       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP523.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM PURGES UNUSED NAME ROWS.                          **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    01/10    FB        ORIGINAL VERSION                       **         
A03864*    08/12    FB        MOVED ALL SQL INTO CURSOR              **         
P00740*    03/14    FB        ADDED CASA FIELDS.                     **         
P00726*    02/15    FB        ADDED PATIENT_NAME_ID                  **         
P00837*    05/15    FB        ADDED ACCOUNT MANAGER AND SALES        **         
P00837*                       SPECIALIST.                            **         
A05460*    08/16    SM93554   REMOVED UN-USED TABLES AND RELATED     **         
      *             ACT245    CODES AS PART OF DROP TABLE.           **         
      *                                                              **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP523'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-DELETE-PARM         PIC X(01) VALUE 'N'.              
           05  WS-PROCESS-COUNT       PIC 9(6).                         
           05  WS-PROCESS-ALL         PIC 9(9).                         
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-DELETE-COUNT        PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(09) COMP VALUE 0.          
           05  WS-CURRENT-DATE        PIC X(10).                        
           05  WS-CURRENT-TS          PIC X(26).                        
           05  WS-TRAN-APPL-NO        PIC S9(04) COMP VALUE 1.          
           05  WS-ITERATION-STORAGE.                                    
               10 WS-DISPLAY-NAME     PIC 9(13) VALUE ZEROES.           
               10 WS-DELETE-NAME-FL   PIC X(01) VALUE 'N'.              
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBATBLNM                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLADRX                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNTACT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCSTSTS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCUST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTNME                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNMACTX                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPHYSN                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTHDPTY                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBWCPLUS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBWCPPAT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBWCPSSN                                                
           END-EXEC.                                                            
                                                                        
P00726     EXEC SQL                                                             
P00726          INCLUDE TBCSTALT                                                
P00726     END-EXEC.                                                            
                                                                        
P00837     EXEC SQL                                                             
P00837          INCLUDE TBINAMGR                                                
P00837     END-EXEC.                                                            
                                                                        
P00837     EXEC SQL                                                             
P00837          INCLUDE TBSALSPL                                                
P00837     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE NAME_CURSOR CURSOR WITH HOLD FOR                   
               SELECT NAME_ID,                                          
                      NAME_TYPE,                                        
                      NAME_FORMAT,                                      
                      REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_DATE
           , 121), ' ', '-'), ':', '.') CREATED_DATE                           
                 FROM CSS_NAME DQ                                       
                WHERE NOT EXISTS                                        
                    (SELECT 'Y'                                         
                       FROM CSS_CUSTOMER                                
                      WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_ACCT_BILL_NMES                          
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_BILL_ADDR_XREF                          
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_CONTACT                                 
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_CUST_STATS                              
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
P00740            AND NOT EXISTS                                        
P00740              (SELECT 'Y'                                         
P00740                 FROM CSS_CUST_STATS                              
P00740                WHERE INDIV_NAME_ID = DQ.NAME_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM HST_ACCT_BILL_NMES                          
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_NAME_ACCT_XREF                          
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_PHYSICIAN                               
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_THD_PRTY                                
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_WH_CROSS_PLUS                           
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_WH_CROSS_PATNT                          
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_WH_CROSS_SSN                            
A03864                WHERE NAME_ID = DQ.NAME_ID)                       
P00726            AND NOT EXISTS                                        
P00726              (SELECT 'Y'                                         
P00726                 FROM CSS_CUST_ALERT                              
P00726                WHERE PATIENT_NAME_ID = DQ.NAME_ID)               
P00837            AND NOT EXISTS                                        
P00837              (SELECT 'Y'                                         
P00837                 FROM CSS_ITRNL_ACCT_MGR                          
P00837                WHERE NAME_ID = DQ.NAME_ID)                       
P00837            AND NOT EXISTS                                        
P00837              (SELECT 'Y'                                         
P00837                 FROM CSS_SALES_SPCLST                            
P00837                WHERE NAME_ID = DQ.NAME_ID)                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE NAME_CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT NAME_ID,                                                  
MFA-TR*               NAME_TYPE,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               CREATED_DATE                                              
MFA-TR*          FROM CSS_NAME DQ                                               
MFA-TR*         WHERE NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CUSTOMER                                        
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_ACCT_BILL_NMES                                  
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_BILL_ADDR_XREF                                  
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CONTACT                                         
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CUST_STATS                                      
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CUST_STATS                                      
MFA-TR*               WHERE INDIV_NAME_ID = DQ.NAME_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM HST_ACCT_BILL_NMES                                  
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_NAME_ACCT_XREF                                  
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_PHYSICIAN                                       
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_THD_PRTY                                        
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_WH_CROSS_PLUS                                   
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_WH_CROSS_PATNT                                  
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_WH_CROSS_SSN                                    
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CUST_ALERT                                      
MFA-TR*               WHERE PATIENT_NAME_ID = DQ.NAME_ID)                       
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_ITRNL_ACCT_MGR                                  
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_SALES_SPCLST                                    
MFA-TR*               WHERE NAME_ID = DQ.NAME_ID)                               
MFA-TR*         QUERYNO 1000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7300-SELECT-JOB-PARM THRU 7300-EXIT.                 
                                                                        
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           MOVE WS-DELETE-COUNT TO WS-DISPLAY-COUNT.                    
           DISPLAY 'TOTAL NAMES DELETED = ' WS-DISPLAY-COUNT.           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           EXEC SQL                                                     
               OPEN NAME_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING NAME CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE NAME_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING NAME CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH NAME_CURSOR                                         
               INTO :DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    :DQ-CREATED-DATE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING NAME CURSOR       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000-PROCESS-NAMES THRU 2000-EXIT.                   
                                                                        
           IF WS-PROCESS-ALL <= WS-DELETE-COUNT                         
               GO TO 1100-EXIT
           END-IF.                                         
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-NAMES.                                              
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
           MOVE DQ-NAME-ID TO WS-DISPLAY-NAME.                          
           PERFORM 2300-DELETE-NAME THRU 2300-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-DELETE-NAME.                                                
                                                                        
           IF WS-DELETE-PARM = 'N'                                      
               DISPLAY 'NAME ID TO DELETE ' WS-DISPLAY-NAME ' '         
                   DQ-NAME-TYPE ' ' DQ-NAME-FORMAT ' '                  
                   DQ-CREATED-DATE                                      
               ADD 1 TO WS-DELETE-COUNT                                 
           ELSE                                                         
               PERFORM 8500-DELETE-NAME THRU 8500-EXIT                  
               ADD 1 TO WS-COMMIT-COUNT WS-DELETE-COUNT                 
               IF WS-COMMIT-COUNT > 50                                  
                     EXEC SQL                                           
                         COMMIT                                         
                     END-EXEC                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                     MOVE 0 TO WS-COMMIT-COUNT
               END-IF
           END-IF.                         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSXP523'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'PCSXP523'                                  
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 10                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF G6-PARM-DATA(8:1) = 'Y' OR 'N'                    
                       MOVE G6-PARM-DATA(8:1) TO WS-DELETE-PARM         
                   ELSE                                                 
                       MOVE 'N' TO WS-DELETE-PARM                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-DELETE-PARM                           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM (1) **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSXP523'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 20                                  
                 AND STATUS       = 'A'                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'PCSXP523'                                  
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 20                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*         QUERYNO 73002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF G6-PARM-DATA(15:6) NUMERIC                        
                       MOVE G6-PARM-DATA(15:6) TO WS-PROCESS-COUNT      
                   ELSE                                                 
                       MOVE 001000 TO WS-PROCESS-COUNT                  
                   END-IF                                               
                   IF WS-PROCESS-COUNT = 999999                         
                       MOVE 999999999 TO WS-PROCESS-ALL                 
                   ELSE                                                 
                       MOVE WS-PROCESS-COUNT TO WS-PROCESS-ALL          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 001000 TO WS-PROCESS-COUNT                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM (2)  **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-DELETE-NAME.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_NAME                                     
                WHERE NAME_ID = :DQ-NAME-ID                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_NAME                                             
MFA-TR*         WHERE NAME_ID = :DQ-NAME-ID                                     
MFA-TR*        QUERYNO 8500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_NAME          **'    
                   DISPLAY '**  NAME    = ' WS-DISPLAY-NAME             
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSXP523 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
