       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP521.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM INSERTS ROWS INTO HST_ACCOUNT AND DELETES ACCOUNT **         
      **   DATA.                                                     **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    03/09    FB        ORIGINAL VERSION                       **         
P00594*    09/12    FB        UPDATE CODE_ACCT_STAT ON               **         
P00594*                       CSS_NAME_ACCT_XREF TO R FOR ARCHIVE    **         
      *                                                              **         
A04880* 08-12-2014  RF10596   PROCESS INACTIVE ACCOUNTS              **         
ACT111* 04-14-2016  TP7R341   WORK QUEUE CHANGE TO REMOVE THE        **         
ACT111*             A04860    TABLE CSS_WQ_ITEMS_MF                  **         
ACT233* 08-08-2016  TP7R341   REPLACE CSR00028 WITH CSR04675         **         
ACT233*             A05460    AND REMOVED THE DROPPED TABLE          **         
      *                                                              **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP521'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
A04880     05  WS-INACTIVE            PIC X VALUE 'J'.                  
           05  WS-PROCESS-COUNT       PIC 9(6).                         
           05  WS-INCREMENTAL-COUNT   PIC 9(6).                         
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-DISPLAY-DOLLARS     PIC Z(10)9.99.                    
           05  WS-ROW-COUNT           PIC S9(09) COMP VALUE 0.          
           05  WS-ARCHIVE-COUNT       PIC S9(09) COMP VALUE 0.          
           05  WS-REFORECAST-COUNT    PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-INC-CHAR     PIC X(03) VALUE ZEROES.           
           05  WS-COMMIT-INC REDEFINES WS-COMMIT-INC-CHAR PIC 9(3).     
           05  WS-CURRENT-DATE        PIC X(10).                        
           05  WS-CURRENT-TS          PIC X(26).                        
           05  WS-DISPLAY-TS          PIC X(26).                        
           05  WS-DATE-PLUS-3-MONTHS  PIC X(10).                        
           05  WS-DATE-PLUS-6-MONTHS  PIC X(10).                        
           05  WS-DATE-PLUS-1-MONTH   PIC X(10).                        
           05  WS-DATE-MINUS-6-MONTHS PIC X(10).                        
           05  WS-DATE-MINUS-3-YEARS  PIC X(10).                        
           05  WS-DATE-MINUS-42-MONTHS PIC X(10).                       
           05  WS-AR-DATE-PLUS-7-MONTHS PIC X(10).                      
           05  WS-DATABASE            PIC 9(01) VALUE 0.                
               88 CSR-DATABASE                  VALUE 1.                
               88 SEB-DATABASE                  VALUE 2.                
           05  WS-WQ-COMMENTS-1         PIC X(115) VALUE                
           'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX        
      -    'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX.'.                    
           05  WS-ITERATION-STORAGE.                                    
               10 WS-DISPLAY-ACCOUNT  PIC 9(13) VALUE ZEROES.           
               10 WS-DELETE-FL        PIC X(01) VALUE 'Y'.              
               10 WS-GENERATE-WQ-FL   PIC X(01) VALUE 'N'.              
               10 WS-NULL-IND         PIC S9(4) COMP VALUE ZEROES.      
               10 WS-NULL-IND-1       PIC S9(4) COMP VALUE ZEROES.      
               10 WS-NULL-IND-2       PIC S9(4) COMP VALUE ZEROES.      
               10 WS-NULL-IND-3       PIC S9(4) COMP VALUE ZEROES.      
               10 WS-NULL-IND-4       PIC S9(4) COMP VALUE ZEROES.      
               10 WS-NULL-IND-5       PIC S9(4) COMP VALUE ZEROES.      
               10 WS-NULL-IND-6       PIC S9(4) COMP VALUE ZEROES.      
               10 WS-MAX-REASON-CD    PIC X(01) VALUE SPACES.           
               10 WS-MAX-TYPE-CD      PIC X(01) VALUE SPACES.           
               10 WS-MAX-DATE         PIC X(10) VALUE SPACES.           
               10 WS-MAX-TABLE-NAME   PIC X(40) VALUE SPACES.           
               10 WS-TEMP-DATE        PIC X(10) VALUE SPACES.           
               10 WS-MSTSUB-FL        PIC X(01) VALUE SPACES.           
               10 WS-UTLREL-FL        PIC X(01) VALUE SPACES.           
               10 WS-PEND-XFER-FL     PIC X(01) VALUE SPACES.           
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
COB305     05 SERV-ORDER-NO-4675        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) USAGE COMP.          
COB305     05 ACCOUNT-NO-4675        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 PREMISE-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 CUSTOMER-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) USAGE COMP VALUE 0.  
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) USAGE COMP VALUE 0. 
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
       01  WS-TABLES.                                                   
           05  T1-CSS-PENDING-XFER       OCCURS 750                     
                                         INDEXED BY T1-INDEX.           
               10  T1-ACCT-XFER-TO       PIC S9(13) COMP-3 VALUE ZEROES.
               10  T1-ACCT-XFER-FROM     PIC S9(13) COMP-3 VALUE ZEROES.
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBARCFCS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBXREF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHACCT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBARCNTL                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPDBKDF                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMSTSUB                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRECNCT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLREL                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLHDR                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCHGOFF                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBREGPRF                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMRKXR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBDEPHND                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHDEPHN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBREFUND                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHREFUN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBDEPHST                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHDEPHS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNTRCT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCOMDAT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMNHIST                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTNME                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBATBLNM                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHCOAPP                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHROOMT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCOAPP                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBROOMT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHINTHS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBINTHST                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPENXFR                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLACXF                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBEBLINS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTERPT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMRKXMT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNSMP                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBINTVRD                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACXMPT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBWQITS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
P00594     EXEC SQL                                                             
P00594         INCLUDE TBNMACTX                                                 
P00594     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE ACCT_CURSOR CURSOR WITH HOLD FOR                   
               SELECT AZ.ACCOUNT_NO,                                    
                      FORECAST_REASON_CD,                               
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
                 FROM CSS_ARCHIVE_FCST AZ WITH(READUNCOMMITTED)                 
                WHERE FORECAST_DT =                                     
                      (SELECT MAX(FORECAST_DT)                          
                         FROM CSS_ARCHIVE_FCST WITH(READUNCOMMITTED)            
                        WHERE ACCOUNT_NO = AZ.ACCOUNT_NO)               
                  AND FORECAST_DT <= IIF(TRY_CONVERT(DATE, 
                                                        :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) )                    
                  AND FORECAST_TYPE_CD = 'A'                            
                  AND NOT EXISTS                                        
                      (SELECT '1'                                       
                         FROM CSS_ARCHIVE_EXEMPT WITH(READUNCOMMITTED)          
                        WHERE ACCOUNT_NO = AZ.ACCOUNT_NO)               
      *        ORDER BY FORECAST_TYPE_CD,                                       
      *                 FORECAST_DT,                                            
      *                 ACCT_FINALED_DT                                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ACCT_CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT AZ.ACCOUNT_NO,                                            
MFA-TR*               FORECAST_REASON_CD,                                       
MFA-TR*               ACCT_FINALED_DT                                           
MFA-TR*          FROM CSS_ARCHIVE_FCST AZ                                       
MFA-TR*         WHERE FORECAST_DT =                                             
MFA-TR*               (SELECT MAX(FORECAST_DT)                                  
MFA-TR*                  FROM CSS_ARCHIVE_FCST                                  
MFA-TR*                 WHERE ACCOUNT_NO = AZ.ACCOUNT_NO)                       
MFA-TR*           AND FORECAST_DT <= :AZ-FORECAST-DT                            
MFA-TR*           AND FORECAST_TYPE_CD = 'A'                                    
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT '1'                                               
MFA-TR*                  FROM CSS_ARCHIVE_EXEMPT                                
MFA-TR*                 WHERE ACCOUNT_NO = AZ.ACCOUNT_NO)                       
MFA-TR*        ORDER BY FORECAST_TYPE_CD,                                       
MFA-TR*                 FORECAST_DT,                                            
MFA-TR*                 ACCT_FINALED_DT                                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 1000                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE CNS_CURSOR CURSOR WITH HOLD FOR                    
               SELECT CODE_UTIL_TYPE,                                   
                      METER_NO,                                         
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :CX-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CNS_CURSOR CURSOR WITH HOLD FOR                            
MFA-TR*        SELECT CODE_UTIL_TYPE,                                           
MFA-TR*               METER_NO,                                                 
MFA-TR*               BILL_ITEM_TIMESTMP                                        
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO = :CX-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 8540                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE XFER_CURSOR CURSOR WITH HOLD FOR                   
               SELECT ACCT_XFER_TO,                                     
                      ACCT_XFER_FROM                                    
                 FROM CSS_PENDING_XFER WITH(READUNCOMMITTED)                    
                                                                 
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE XFER_CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT ACCT_XFER_TO,                                             
MFA-TR*               ACCT_XFER_FROM                                            
MFA-TR*          FROM CSS_PENDING_XFER                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 1200                                                     
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-3-MONTHS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 3 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-3-MONTHS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 6, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-6-MONTHS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 6 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-6-MONTHS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-1-MONTH                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 1 MONTH )                      
MFA-TR*          INTO :WS-DATE-PLUS-1-MONTH                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -6, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-6-MONTHS                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 6 MONTHS)                      
MFA-TR*          INTO :WS-DATE-MINUS-6-MONTHS                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, -3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-3-YEARS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 3 YEARS)                       
MFA-TR*          INTO :WS-DATE-MINUS-3-YEARS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -42, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-42-MONTHS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 42 MONTHS)                     
MFA-TR*          INTO :WS-DATE-MINUS-42-MONTHS                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 7100-SELECT-DELINQUENCY THRU 7100-EXIT.              
           PERFORM 7110-SELECT-JOB-PARM THRU 7110-EXIT.                 
           DISPLAY 'TOTAL    - ' WS-PROCESS-COUNT.                      
           DISPLAY 'COMMIT   - ' WS-COMMIT-INC.                         
           PERFORM 1200-LOAD-PENDING-XFER THRU 1200-EXIT.               
           MOVE 0 TO WS-INCREMENTAL-COUNT.                              
                                                                        
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                       
           DISPLAY 'TOTAL ACCOUNTS PROCESSED = ' WS-DISPLAY-COUNT.      
           MOVE WS-REFORECAST-COUNT TO WS-DISPLAY-COUNT.                
           DISPLAY 'TOTAL ACCOUNTS REFORECAST = ' WS-DISPLAY-COUNT.     
           MOVE WS-ARCHIVE-COUNT TO WS-DISPLAY-COUNT.                   
           DISPLAY 'TOTAL ACCOUNTS ARCHIVED = ' WS-DISPLAY-COUNT.       
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           MOVE WS-CURRENT-DATE TO AZ-FORECAST-DT.                      
           EXEC SQL                                                     
               OPEN ACCT_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING ACCT CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE ACCT_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING ACCT CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH ACCT_CURSOR                                         
               INTO :AZ-ACCOUNT-NO,                                     
                    :AZ-FORECAST-REASON-CD,                             
                    :AZ-ACCT-FINALED-DT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING ACCT CURSOR       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000-DELETE-PROCESS THRU 2000-EXIT.                  
                                                                        
           IF WS-PROCESS-COUNT <= WS-ROW-COUNT                          
               GO TO 1100-EXIT
           END-IF.                                         
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-LOAD-PENDING-XFER.                                          
                                                                        
           EXEC SQL                                                     
               OPEN XFER_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1200-LOAD-PENDING-XFER           **'    
                   DISPLAY '**  ERROR OPENING XFER CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           SET T1-INDEX TO +1.                                          
           PERFORM 1210-FETCH-ROWS THRU 1210-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE XFER_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1200-LOAD-PENDING-XFER           **'    
                   DISPLAY '**  ERROR CLOSING XFER CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1210-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH XFER_CURSOR                                         
               INTO :XP-ACCT-XFER-TO,                                   
                    :XP-ACCT-XFER-FROM                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1210-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1210-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING XFER CURSOR       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE XP-ACCT-XFER-TO TO T1-ACCT-XFER-TO (T1-INDEX).          
           MOVE XP-ACCT-XFER-FROM TO T1-ACCT-XFER-FROM (T1-INDEX).      
           SET T1-INDEX UP BY 1.                                        
                                                                        
           GO TO 1210-FETCH-ROWS.                                       
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-DELETE-PROCESS.                                             
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
           INITIALIZE DCLHST-ACCOUNT.                                   
           MOVE AZ-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT.                    
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
                                                                        
      *  FB DATE MUST BE > 3 YEARS AGO                                          
      *                                                                         
A04880     IF AT-CODE-ACCT-STAT = WS-INACTIVE                           
A04880        NEXT SENTENCE                                             
A04880     ELSE                                                         
              IF AT-ACCT-FINALED-DT > WS-DATE-MINUS-42-MONTHS           
                 MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE             
                 IF WS-TEMP-DATE > WS-MAX-DATE                          
                    MOVE WS-TEMP-DATE TO WS-MAX-DATE                    
                    MOVE 'O' TO WS-MAX-REASON-CD                        
                    MOVE 'E' TO WS-MAX-TYPE-CD                          
                    MOVE 'FINAL BILL DATE < 3 YEARS' TO                 
                         WS-MAX-TABLE-NAME                              
                    MOVE 'N' TO WS-DELETE-FL                            
A04880           END-IF                                                 
A04880        END-IF                                                    
A04880     END-IF.                                                      
                                                                        
      *  ACCOUNT CAN'T HAVE XFER TO                                             
                                                                        
      *    IF AT-ACCT-XFER-TO > 0                                               
      *        MOVE WS-DATE-PLUS-6-MONTHS TO WS-TEMP-DATE                       
      *        IF WS-TEMP-DATE > WS-MAX-DATE                                    
      *            MOVE WS-TEMP-DATE TO WS-MAX-DATE                             
      *            MOVE 'O' TO WS-MAX-REASON-CD                                 
      *            MOVE 'E' TO WS-MAX-TYPE-CD                                   
      *            MOVE 'TRANSFER TO ACCOUNT NO' TO                             
      *                 WS-MAX-TABLE-NAME                                       
      *            MOVE 'N' TO WS-DELETE-FL.                                    
                                                                        
      *  ACCOUNT CAN'T HAVE XFER FROM                                           
                                                                        
      *    IF AT-ACCT-XFER-FROM-LST > 0                                         
      *        MOVE WS-DATE-PLUS-6-MONTHS TO WS-TEMP-DATE                       
      *        IF WS-TEMP-DATE > WS-MAX-DATE                                    
      *            MOVE WS-TEMP-DATE TO WS-MAX-DATE                             
      *            MOVE 'O' TO WS-MAX-REASON-CD                                 
      *            MOVE 'E' TO WS-MAX-TYPE-CD                                   
      *            MOVE 'TRANSFER FROM ACCOUNT NO' TO                           
      *                 WS-MAX-TABLE-NAME                                       
      *            MOVE 'N' TO WS-DELETE-FL.                                    
                                                                        
      *  ACCOUNT MUST HAVE FB DATE                                              
                                                                        
A04880     IF AT-CODE-ACCT-STAT = WS-INACTIVE                           
A04880        NEXT SENTENCE                                             
A04880     ELSE                                                         
              IF AT-ACCT-FINALED-DT = SPACES AND                        
                       AT-DATE-BILL-DAY-00 < WS-DATE-MINUS-6-MONTHS     
                 MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE             
                 IF WS-TEMP-DATE > WS-MAX-DATE                          
                    MOVE WS-TEMP-DATE TO WS-MAX-DATE                    
                    MOVE 'O' TO WS-MAX-REASON-CD                        
                    MOVE 'E' TO WS-MAX-TYPE-CD                          
                    MOVE 'FINAL BILL DATE IS MISSING' TO                
                          WS-MAX-TABLE-NAME                             
                    MOVE 'N' TO WS-DELETE-FL                            
A04880           END-IF                                                 
A04880        END-IF                                                    
A04880     END-IF.                                                      
                                                                        
      *  NON-ZERO TOTAL AR BALANCE                                              
                                                                        
           IF AT-TOTAL-AR-BALANCE NOT = 0                               
              MOVE WS-CURRENT-DATE TO WS-TEMP-DATE                      
              IF WS-TEMP-DATE > WS-MAX-DATE                             
                  MOVE WS-TEMP-DATE TO WS-MAX-DATE                      
                  MOVE 'D' TO WS-MAX-REASON-CD                          
                  MOVE 'E' TO WS-MAX-TYPE-CD                            
                  MOVE AT-TOTAL-AR-BALANCE TO WS-DISPLAY-DOLLARS        
                  STRING 'ACCOUNT BALANCE = '                           
                         WS-DISPLAY-DOLLARS                             
                         DELIMITED BY SIZE                              
                         INTO WS-MAX-TABLE-NAME                         
                  MOVE 'N' TO WS-DELETE-FL
              END-IF
           END-IF.                             
                                                                        
           PERFORM 7400-SELECT-AR-TRANSHIST THRU 7400-EXIT.             
                                                                        
      *  NON-REFUNDED DEPOSIT                                                   
                                                                        
           PERFORM 7120-SELECT-DEP-ON-HAND THRU 7120-EXIT.              
                                                                        
      *  CANNOT ARCHIVE IF DATA EXISTS ON CERTAIN TABLES                        
                                                                        
           PERFORM 7200-SELECT-AR-CNTL THRU 7200-EXIT.                  
           PERFORM 7205-SELECT-WQS THRU 7205-EXIT.                      
           PERFORM 7210-SELECT-BNK-DRFT THRU 7210-EXIT.                 
           PERFORM 7215-SELECT-ORDERS THRU 7215-EXIT.                   
           PERFORM 7230-SELECT-MSTSUB THRU 7230-EXIT.                   
           PERFORM 7240-SELECT-RECONNECT THRU 7240-EXIT.                
           PERFORM 7250-SELECT-UTIL-BILL THRU 7250-EXIT.                
           PERFORM 7260-SELECT-CHRG-OFF THRU 7260-EXIT.                 
           PERFORM 7280-SELECT-CONTRACT THRU 7280-EXIT.                 
           PERFORM 7290-SELECT-PENDXFER THRU 7290-EXIT.                 
                                                                        
      *    IF WS-GENERATE-WQ-FL = 'Y'                                           
      *        PERFORM 5000-CALL-CSR04675 THRU 5000-EXIT.                       
                                                                        
           IF WS-DELETE-FL = 'N'                                        
               ADD 1 TO WS-REFORECAST-COUNT                             
               PERFORM 8100-REFORECAST THRU 8100-EXIT                   
           ELSE                                                         
               ADD 1 TO WS-ARCHIVE-COUNT                                
               PERFORM 7300-SELECT-REG-PROFILE THRU 7300-EXIT           
               PERFORM 7310-SELECT-MKT-XREF THRU 7310-EXIT              
               PERFORM 7320-SELECT-XREF THRU 7320-EXIT                  
               PERFORM 7330-SELECT-DEP-ON-HAND THRU 7330-EXIT           
               MOVE AT-ACCT-CREATE-DT(1:10) TO HA-ACCT-CREATE-DT        
      *                                                                         
A04880         IF AT-CODE-ACCT-STAT = WS-INACTIVE                       
A04880            MOVE 0 TO WS-NULL-IND-2                               
A04880            IF AT-ACCT-FINALED-DT (1:10) > SPACES                 
A04880               MOVE AT-ACCT-FINALED-DT (1:10)                     
A04880                    TO HA-ACCT-FINALED-DT                         
A04880            ELSE                                                  
A04880               IF AT-DATE-BILL-DAY-00 > SPACES                    
A04880                  MOVE AT-DATE-BILL-DAY-00 TO HA-ACCT-FINALED-DT  
A04880               ELSE                                               
A04880                  MOVE WS-CURRENT-DATE TO HA-ACCT-FINALED-DT      
A04880               END-IF                                             
A04880            END-IF                                                
A04880         ELSE                                                     
A04880            MOVE AT-ACCT-FINALED-DT (1:10) TO HA-ACCT-FINALED-DT  
A04880         END-IF                                                   
      *                                                                         
               IF AT-CODES-DATA-PRESENT(20:1) = 'A'                     
                   MOVE 'Y' TO HA-REFUND-FL                             
               ELSE                                                     
                   MOVE 'N' TO HA-REFUND-FL                             
               END-IF                                                   
               PERFORM 8000-INSERT-ACCOUNT THRU 8000-EXIT               
               PERFORM 8200-INSERT-DEP-ON-HAND THRU 8200-EXIT           
               PERFORM 8300-INSERT-DEP-PAY-HIST THRU 8300-EXIT          
               PERFORM 8400-INSERT-REFUND THRU 8400-EXIT                
               PERFORM 8600-INSERT-BILL-NAMES THRU 8600-EXIT            
               PERFORM 8700-INSERT-COAPPLICANT THRU 8700-EXIT           
               PERFORM 8800-INSERT-ROOMMATE THRU 8800-EXIT              
               PERFORM 8900-INSERT-INT-HIST THRU 8900-EXIT              
               PERFORM 2100-DELETE-RESTRICT THRU 2100-EXIT              
               PERFORM 8500-DELETE-ACCOUNT THRU 8500-EXIT               
               PERFORM 8010-UPDATE-HT THRU 8010-EXIT
           END-IF.                   
                                                                        
           ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT WS-INCREMENTAL-COUNT.  
           IF WS-INCREMENTAL-COUNT = 5000                               
               EXEC SQL                                                 
                  SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-DISPLAY-TS                                 
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*        EXEC SQL                                                         
MFA-TR*           VALUES CURRENT TIMESTAMP                                      
MFA-TR*             INTO :WS-DISPLAY-TS                                         
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               DISPLAY '5K PROCESSED - ' WS-DISPLAY-TS                  
               MOVE 0 TO WS-INCREMENTAL-COUNT
           END-IF.                          
                                                                        
           IF WS-COMMIT-COUNT > WS-COMMIT-INC                           
                 EXEC SQL                                               
                     COMMIT                                             
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-DELETE-RESTRICT.                                            
                                                                        
           PERFORM 8510-DELETE-MTR-ENV THRU 8510-EXIT.                  
           PERFORM 8515-DELETE-BILL-XFER THRU 8515-EXIT.                
           PERFORM 8520-DELETE-UTL-ENV THRU 8520-EXIT.                  
           PERFORM 8525-DELETE-EBILL THRU 8525-EXIT.                    
           PERFORM 8530-DELETE-DEP-ON-HAND THRU 8530-EXIT.              
           PERFORM 8535-DELETE-ROUTE-RPT THRU 8535-EXIT.                
           PERFORM 8540-DELETE-INT-READ THRU 8540-EXIT.                 
           PERFORM 8545-DELETE-DIST-MTR THRU 8545-EXIT.                 
           PERFORM 8550-DELETE-REFUND THRU 8550-EXIT.                   
           PERFORM 8555-DELETE-CHRG-OFF THRU 8555-EXIT.                 
           PERFORM 8560-DELETE-AR-CNTL THRU 8560-EXIT.                  
      *    PERFORM 8570-DELETE-COMM-DATA THRU 8570-EXIT.                        
           PERFORM 8580-DELETE-BILL-HDR THRU 8580-EXIT.                 
           PERFORM 8590-DELETE-MNT-HIST THRU 8590-EXIT.                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT233 5000-CALL-CSR04675.                                              
ACT233                                                                  
ACT233     MOVE '1' TO ROUTING-CATEGORY-4675.                           
ACT233     MOVE 000 TO CATEGORY-ID-4675.                                
ACT233     MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT.                 
ACT233     MOVE 115 TO COMMENTS-4675-LEN.                               
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT233     MOVE AT-LOCAL-OFFICE TO LOCAL-OFFICE-4675.                   
ACT233     MOVE 'SYSTEM' TO USER-ID-ORIG-4675.                          
ACT233     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT233                    RESP-AREA-ID-4675                             
ACT233                    DATE-REQUIRED-4675                            
ACT233                    DATE-CREATED-4675                             
ACT233                    FREE-FORM-DATA-4675-TEXT.                     
ACT233     MOVE 'N' TO WQ-PRIORITY-4675                                 
ACT233     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
ACT233     MOVE AZ-ACCOUNT-NO TO ACCOUNT-NO-4675.                       
ACT233     MOVE AT-PREMISE-NO TO PREMISE-NO-4675.                       
ACT233     MOVE AT-CUSTOMER-NO TO CUSTOMER-NO-4675.                     
ACT233     MOVE ZEROES TO SERV-ORDER-NO-4675.                           
ACT233     MOVE 'PCSXP521' TO CREATED-BY-4675.                          
                                                                        
ACT233*    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
ACT233        DISPLAY '**  5000-CALL-CSR04675               **'         
ACT233        DISPLAY '**  ERROR CALLING CSR04675 (1)       **'         
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233            IF RETURN-CODE-4675 NOT = 0                           
ACT233               MOVE RETURN-CODE-4675 TO WS-DISPLAY-SQLCODE        
                     DISPLAY '****************************************' 
ACT233               DISPLAY '**  5000-CALL-CSR04675               **'  
ACT233               DISPLAY '**  ERROR CALLING CSR04675 (2)       **'  
                     DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE        
                     DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT        
                     DISPLAY '**  PROCESSING TERMINATED             **' 
                     DISPLAY '****************************************' 
                     PERFORM 9900-ABEND THRU 9900-ABEND-EXIT            
                  END-IF                                                
               WHEN OTHER                                               
ACT233             MOVE RETURN-CODE-4675 TO WS-DISPLAY-SQLCODE          
                   DISPLAY '****************************************'   
ACT233             DISPLAY '**  5000-CALL-CSR04675                **'   
ACT233             DISPLAY '**  ERROR CALLING CSR04675 (3)        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO,                                       
                      CUSTOMER_NO,                                      
                      LOCAL_OFFICE,                                     
                      CODE_ACCT_STAT,                                   
                      TOTAL_AR_BALANCE,                                 
                      COMPANY_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                      ACCOUNT_TYPE_CODE,                                
                      CODE_STATUS_REASON,                               
                      CREDIT_GROUP,                                     
                      ADDRESS_ID,                                       
                      ADDRESS_FORMAT,                                   
                      LAST_PYMT_DATE,                                   
                      LAST_PYMT_AMOUNT,                                 
                      ACCT_XFER_FROM_LST,                               
                      ACCT_XFER_TO,                                     
                      CODES_DATA_PRESENT,                               
                      DATE_BILL_DAY_00                                  
                 INTO :AT-PREMISE-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-LOCAL-OFFICE,                                 
                      :AT-CODE-ACCT-STAT,                               
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-COMPANY-NO,                                   
                      :AT-ACCT-CREATE-DT :WS-NULL-IND-1,                 
                      :AT-ACCT-FINALED-DT :WS-NULL-IND-2,                
                      :AT-ACCOUNT-TYPE-CODE,                            
                      :AT-CODE-STATUS-REASON,                           
                      :AT-CREDIT-GROUP,                                 
                      :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT,                               
                      :AT-LAST-PYMT-DATE :WS-NULL-IND-3,                 
                      :AT-LAST-PYMT-AMOUNT,                             
                      :AT-ACCT-XFER-FROM-LST,                           
                      :AT-ACCT-XFER-TO,                                 
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-DATE-BILL-DAY-00 :WS-NULL-IND-6                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               TOTAL_AR_BALANCE,                                         
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               ACCT_CREATE_DT,                                           
MFA-TR*               ACCT_FINALED_DT,                                          
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               CODE_STATUS_REASON,                                       
MFA-TR*               CREDIT_GROUP,                                             
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               ADDRESS_FORMAT,                                           
MFA-TR*               LAST_PYMT_DATE,                                           
MFA-TR*               LAST_PYMT_AMOUNT,                                         
MFA-TR*               ACCT_XFER_FROM_LST,                                       
MFA-TR*               ACCT_XFER_TO,                                             
MFA-TR*               CODES_DATA_PRESENT,                                       
MFA-TR*               DATE_BILL_DAY_00                                          
MFA-TR*          INTO :AT-PREMISE-NO,                                           
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-TOTAL-AR-BALANCE,                                     
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-ACCT-CREATE-DT:WS-NULL-IND-1,                         
MFA-TR*               :AT-ACCT-FINALED-DT:WS-NULL-IND-2,                        
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-CODE-STATUS-REASON,                                   
MFA-TR*               :AT-CREDIT-GROUP,                                         
MFA-TR*               :AT-ADDRESS-ID,                                           
MFA-TR*               :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :AT-LAST-PYMT-DATE:WS-NULL-IND-3,                         
MFA-TR*               :AT-LAST-PYMT-AMOUNT,                                     
MFA-TR*               :AT-ACCT-XFER-FROM-LST,                                   
MFA-TR*               :AT-ACCT-XFER-TO,                                         
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-DATE-BILL-DAY-00:WS-NULL-IND-6                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-1 < 0                                 
                       MOVE SPACES TO AT-ACCT-CREATE-DT                 
                   END-IF                                               
                   IF WS-NULL-IND-2 < 0                                 
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
                   IF WS-NULL-IND-3 < 0                                 
                       MOVE SPACES TO AT-LAST-PYMT-DATE                 
                   END-IF                                               
                   IF WS-NULL-IND-6 < 0                                 
                       MOVE SPACES TO AT-DATE-BILL-DAY-00               
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_ACCOUNT      **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD  = 'DATABASE'                           
                 AND  COMPANY_NO = '01'                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = 'DATABASE'                                   
MFA-TR*          AND  COMPANY_NO = '01'                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-DATABASE                  
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_DELINQUENCY  **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = 'PCSXP521'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'PCSXP521'                                  
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 10                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 71101                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF G6-PARM-DATA(15:6) NUMERIC                        
                       MOVE G6-PARM-DATA(15:6) TO WS-PROCESS-COUNT      
                   ELSE                                                 
                       MOVE 001000 TO WS-PROCESS-COUNT                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 001000 TO WS-PROCESS-COUNT                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = 'PCSXP521'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 20                                  
                 AND STATUS       = 'A'                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'PCSXP521'                                  
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 20                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 71102                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF G6-PARM-DATA(14:3) NUMERIC                        
                       MOVE G6-PARM-DATA(14:3) TO WS-COMMIT-INC-CHAR    
                   ELSE                                                 
                       MOVE '050' TO WS-COMMIT-INC-CHAR                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE '050' TO WS-COMMIT-INC-CHAR                     
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM (2) **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-SELECT-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :DO-ACCOUNT-NO                                     
                FROM  CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  (AMT_DEPOSIT  <> 0                                
                  OR   DEPOSIT_STATUS_CD IN ('A', 'P'))                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :DO-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_DEP_ON_HAND                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  (AMT_DEPOSIT  = 0                                        
MFA-TR*           OR   DEPOSIT_STATUS_CD IN ('A', 'P'))                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'NON REFUNDED DEPOSIT' TO WS-MAX-TABLE-NAME 
                       MOVE 'N' TO WS-DELETE-FL                         
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_DEP_ON_HAND  **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :AC-ACCOUNT-NO                                     
                FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  (AMT_TRAN_BALANCE <> 0                            
                  OR   AMT_AR_DAY_00 <> 0                               
                  OR   AMT_AR_DAY_30 <> 0                               
                  OR   AMT_AR_DAY_60 <> 0                               
                  OR   AMT_AR_DAY_90 <> 0                               
                  OR   AMT_UNUSED_CR <> 0                               
                  OR   TOT_SUMM_UNBILLED <> 0)                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :AC-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_AR_CNTL                                               
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  (AMT_TRAN_BALANCE = 0                                    
MFA-TR*           OR   AMT_AR_DAY_00 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_30 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_60 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_90 = 0                                       
MFA-TR*           OR   AMT_UNUSED_CR = 0                                       
MFA-TR*           OR   TOT_SUMM_UNBILLED = 0)                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'Q' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'CSS_AR_CNTL' TO WS-MAX-TABLE-NAME          
                       MOVE 'N' TO WS-DELETE-FL                         
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_AR_CNTL      **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7205-SELECT-WQS.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :WQ-ACCOUNT-NO                                     
                FROM  CSS_WQ_ITEMS WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND STATUS IN ('A', 'I')                               
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :WQ-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_WQ_ITEMS                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND STATUS IN ('A', 'I')                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72051                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-1-MONTH TO WS-TEMP-DATE            
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'U' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'ACTIVE/IN PROCESS WQS EXIST' TO            
                             WS-MAX-TABLE-NAME                          
                       MOVE 'N' TO WS-DELETE-FL                         
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_WQ_ITEMS      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7205-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-SELECT-BNK-DRFT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :PB-ACCOUNT-NO                                     
                FROM  CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                  
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :PB-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_PNDNG_BNK_DRFT                                        
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'CSS_PNDNG_BNK_DRFT' TO WS-MAX-TABLE-NAME   
                       MOVE 'N' TO WS-DELETE-FL                         
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_PNDNG_BNK_DRFT**'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7215-SELECT-ORDERS.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO                                        
                INTO :VO-PREMISE-NO                                     
                FROM  CSS_SO_DATA WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                        
                 AND ORDER_STATE_CD NOT IN ('C', 'Z')                   
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  PREMISE_NO                                                
MFA-TR*         INTO :VO-PREMISE-NO                                             
MFA-TR*         FROM  CSS_SO_DATA                                               
MFA-TR*        WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                                
MFA-TR*          AND ORDER_STATE_CD NOT IN ('C', 'Z')                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72151                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'ORDER NOT CANCELLED OR COMPLETED' TO       
                             WS-MAX-TABLE-NAME                          
                       MOVE 'N' TO WS-DELETE-FL                         
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_SO_DATA       **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO                                        
                INTO :VO-PREMISE-NO                                     
                FROM  CSS_SO_DATA WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO_PRIOR = :AZ-ACCOUNT-NO                  
                 AND ORDER_STATE_CD NOT IN ('C', 'Z')                   
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  PREMISE_NO                                                
MFA-TR*         INTO :VO-PREMISE-NO                                             
MFA-TR*         FROM  CSS_SO_DATA                                               
MFA-TR*        WHERE ACCOUNT_NO_PRIOR = :AZ-ACCOUNT-NO                          
MFA-TR*          AND ORDER_STATE_CD NOT IN ('C', 'Z')                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72152                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'ORDER NOT CANCELLED OR COMPLETED' TO       
                             WS-MAX-TABLE-NAME                          
                       MOVE 'N' TO WS-DELETE-FL                         
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_SO_DATA       **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7215-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7230-SELECT-MSTSUB.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-MSTSUB-FL                                      
                FROM  CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                     
               WHERE  SUB_ACCT_NO = :AZ-ACCOUNT-NO                      
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-MSTSUB-FL                                              
MFA-TR*         FROM  CSS_MSTSUB_ACCT                                           
MFA-TR*        WHERE  SUB_ACCT_NO = :AZ-ACCOUNT-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72301                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-MSTSUB-FL                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-MSTSUB-FL                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_MSTSUB_ACCT (S)*'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF WS-MSTSUB-FL = 'N'                                        
               EXEC SQL                                                 
                  SELECT TOP(1) 'Y'                                            
                    INTO :WS-MSTSUB-FL                                  
                    FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                  
                   WHERE MST_ACCT_NO = :AZ-ACCOUNT-NO                   
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT 'Y'                                                    
MFA-TR*             INTO :WS-MSTSUB-FL                                          
MFA-TR*             FROM CSS_MSTSUB_ACCT                                        
MFA-TR*            WHERE MST_ACCT_NO = :AZ-ACCOUNT-NO                           
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 72302                                                
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                  WHEN SUCCESSFUL-CALL                                  
                      MOVE 'Y' TO WS-MSTSUB-FL                          
                  WHEN NOT-FOUND                                        
                      MOVE 'N' TO WS-MSTSUB-FL                          
                  WHEN OTHER                                            
                     MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE   
                     DISPLAY '****************************************' 
                     DISPLAY '**  ERROR SELECTING CSS_MSTSUB_ACCT (M)'  
                     DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE        
                     DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT        
                     DISPLAY '**  PROCESSING TERMINATED             **' 
                     DISPLAY '****************************************' 
                     PERFORM 9900-ABEND THRU 9900-ABEND-EXIT            
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF WS-MSTSUB-FL = 'Y'                                        
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE > WS-MAX-DATE                            
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'O' TO WS-MAX-REASON-CD                         
                   MOVE 'E' TO WS-MAX-TYPE-CD                           
                   MOVE 'CSS_MSTSUB_ACCT' TO WS-MAX-TABLE-NAME          
                   MOVE 'N' TO WS-DELETE-FL                             
                   MOVE 'Y' TO WS-GENERATE-WQ-FL
               END-IF
           END-IF.                       
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-SELECT-RECONNECT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :DL-ACCOUNT-NO                                     
                FROM  CSS_RECONNECT WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :DL-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_RECONNECT                                             
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7240                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'CSS_RECONNECT' TO WS-MAX-TABLE-NAME        
                       MOVE 'N' TO WS-DELETE-FL                         
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_RECONNECT    **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-SELECT-UTIL-BILL.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-UTLREL-FL                                      
                FROM  CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO_DEP = :AZ-ACCOUNT-NO                   
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-UTLREL-FL                                              
MFA-TR*         FROM  CSS_UTL_BILL_REL                                          
MFA-TR*        WHERE  ACCOUNT_NO_DEP = :AZ-ACCOUNT-NO                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72501                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-UTLREL-FL                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-UTLREL-FL                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_UTL_BILL_REL(D)*'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF WS-UTLREL-FL = 'N'                                        
               EXEC SQL                                                 
                  SELECT TOP(1) 'Y'                                            
                    INTO :WS-UTLREL-FL                                  
                    FROM  CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                
                   WHERE  ACCOUNT_NO_MST = :AZ-ACCOUNT-NO               
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT 'Y'                                                    
MFA-TR*             INTO :WS-UTLREL-FL                                          
MFA-TR*             FROM  CSS_UTL_BILL_REL                                      
MFA-TR*            WHERE  ACCOUNT_NO_MST = :AZ-ACCOUNT-NO                       
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 72502                                                
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                  WHEN SUCCESSFUL-CALL                                  
                      MOVE 'Y' TO WS-UTLREL-FL                          
                  WHEN NOT-FOUND                                        
                      MOVE 'N' TO WS-UTLREL-FL                          
                  WHEN OTHER                                            
                     MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE   
                     DISPLAY '****************************************' 
                     DISPLAY '**  ERROR SELECTING CSS_UTL_BILL_REL(M)*' 
                     DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE        
                     DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT        
                     DISPLAY '**  PROCESSING TERMINATED             **' 
                     DISPLAY '****************************************' 
                     PERFORM 9900-ABEND THRU 9900-ABEND-EXIT            
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF WS-UTLREL-FL = 'Y'                                        
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE > WS-MAX-DATE                            
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'O' TO WS-MAX-REASON-CD                         
                   MOVE 'E' TO WS-MAX-TYPE-CD                           
                   MOVE 'CSS_UTL_BILL_REL' TO WS-MAX-TABLE-NAME         
                   MOVE 'N' TO WS-DELETE-FL                             
                   MOVE 'Y' TO WS-GENERATE-WQ-FL
               END-IF
           END-IF.                       
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7260-SELECT-CHRG-OFF.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :CO-ACCOUNT-NO                                     
                FROM  CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  AMT_TRANS <> 0                                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :CO-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_CHRG_OFF                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  AMT_TRANS = 0                                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7260                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'B' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'CSS_CHRG_OFF' TO WS-MAX-TABLE-NAME         
                       MOVE 'N' TO WS-DELETE-FL                         
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CHRG_OFF     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7280-SELECT-CONTRACT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :CT-ACCOUNT-NO                                     
                FROM  CSS_CONTRACT WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  CODE_CONTRACT_TYPE IN ( 'I', 'J', 'K',            
                                              'L', 'M', 'N',            
                                              'A', 'B', 'O')            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :CT-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_CONTRACT                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  CODE_CONTRACT_TYPE IN ( 'I', 'J', 'K',                    
MFA-TR*                                       'L', 'M', 'N',                    
MFA-TR*                                       'A', 'B', 'O')                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'E' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'CSS_CONTRACT' TO WS-MAX-TABLE-NAME         
                       MOVE 'N' TO WS-DELETE-FL                         
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CONTRACT     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7290-SELECT-PENDXFER.                                            
                                                                        
           SET T1-INDEX TO +1.                                          
           SEARCH T1-CSS-PENDING-XFER                                   
               AT END                                                   
                   MOVE 'N' TO WS-PEND-XFER-FL                          
               WHEN T1-ACCT-XFER-TO (T1-INDEX) = AZ-ACCOUNT-NO          
                   MOVE 'Y' TO WS-PEND-XFER-FL                          
           END-SEARCH.                                                  
                                                                        
           IF WS-PEND-XFER-FL = 'N'                                     
               SET T1-INDEX TO +1                                       
               SEARCH T1-CSS-PENDING-XFER                               
                   AT END                                               
                       MOVE 'N' TO WS-PEND-XFER-FL                      
                   WHEN T1-ACCT-XFER-FROM (T1-INDEX) = AZ-ACCOUNT-NO    
                       MOVE 'Y' TO WS-PEND-XFER-FL                      
               END-SEARCH
           END-IF.                                              
                                                                        
           IF WS-PEND-XFER-FL = 'Y'                                     
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE > WS-MAX-DATE                            
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'O' TO WS-MAX-REASON-CD                         
                   MOVE 'E' TO WS-MAX-TYPE-CD                           
                   MOVE 'CSS_PENDING_XFER' TO WS-MAX-TABLE-NAME         
                   MOVE 'N' TO WS-DELETE-FL                             
                   MOVE 'Y' TO WS-GENERATE-WQ-FL
               END-IF
           END-IF.                       
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-REG-PROFILE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REG_GROUP_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), GROUP_EFF_TS, 121), 
           ' ', '-'), ':', '.') GROUP_EFF_TS,
              SENIOR_FL                                         
                INTO :LR-REG-GROUP-CD,                                  
                     :LR-GROUP-EFF-TS :WS-NULL-IND-4,                    
                     :LR-SENIOR-FL                                      
                FROM  CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  REG_GROUP_CD,                                             
MFA-TR*               GROUP_EFF_TS,                                             
MFA-TR*               SENIOR_FL                                                 
MFA-TR*         INTO :LR-REG-GROUP-CD,                                          
MFA-TR*              :LR-GROUP-EFF-TS:WS-NULL-IND-4,                            
MFA-TR*              :LR-SENIOR-FL                                              
MFA-TR*         FROM  CSS_REG_PROFILE                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-4 < 0                                 
                       MOVE SPACES TO LR-GROUP-EFF-TS                   
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO LR-GROUP-EFF-TS                       
                                  LR-REG-GROUP-CD                       
                                  LR-SENIOR-FL                          
                   MOVE -1 TO WS-NULL-IND-4                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_REG_PROFILE  **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-SELECT-MKT-XREF.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DIST_ACCT_NO,
              ORIGINATION_CD                                    
                INTO :XM-DIST-ACCT-NO,                                  
                     :XM-ORIGINATION-CD                                 
                FROM  CSS_MKT_XREF_ACCT WITH(READUNCOMMITTED)                   
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DIST_ACCT_NO,                                             
MFA-TR*               ORIGINATION_CD                                            
MFA-TR*         INTO :XM-DIST-ACCT-NO,                                          
MFA-TR*              :XM-ORIGINATION-CD                                         
MFA-TR*         FROM  CSS_MKT_XREF_ACCT                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO XM-DIST-ACCT-NO                       
                                  XM-ORIGINATION-CD                     
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_MTK_XREF_ACCT**'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-SELECT-XREF.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) OLD_ACCOUNT_NO                                    
                INTO :XR-OLD-ACCOUNT-NO                                 
                FROM  CSS_XREF_ACCT WITH(READUNCOMMITTED)                       
               WHERE  NEW_ACCOUNT_NO = :AZ-ACCOUNT-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  OLD_ACCOUNT_NO                                            
MFA-TR*         INTO :XR-OLD-ACCOUNT-NO                                         
MFA-TR*         FROM  CSS_XREF_ACCT                                             
MFA-TR*        WHERE  NEW_ACCOUNT_NO = :AZ-ACCOUNT-NO                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO XR-OLD-ACCOUNT-NO                     
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_XREF_ACCT     **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7330-SELECT-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :DO-ACCOUNT-NO                                     
                FROM  CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :DO-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_DEP_ON_HAND                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7330                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO HA-DEPOSIT-FL                            
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO HA-DEPOSIT-FL                            
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_DEP_ON_HAND   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-AR-TRANSHIST.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           TRANS_HIST_SEQ_NO), 121), ' ', '-'), ':', '.')                      
                INTO :AR-TRANS-HIST-SEQ-NO :WS-NULL-IND                  
                FROM  CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(TRANS_HIST_SEQ_NO)                                    
MFA-TR*         INTO :AR-TRANS-HIST-SEQ-NO:WS-NULL-IND                          
MFA-TR*         FROM  CSS_AR_TRANS_HIST                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND < 0                                   
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE AR-TRANS-HIST-SEQ-NO(1:10) TO AR-DATE-TRANS 
                       IF AR-DATE-TRANS > WS-DATE-MINUS-6-MONTHS        
                           EXEC SQL                                     
                               SELECT
              DATEADD( MONTH, 7, IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) ) )
            INTO
              :WS-AR-DATE-PLUS-7-MONTHS          
                           END-EXEC                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*                    EXEC SQL                                             
MFA-TR*                        VALUES (DATE(:AR-DATE-TRANS) + 7 MONTHS)         
MFA-TR*                         INTO :WS-AR-DATE-PLUS-7-MONTHS                  
MFA-TR*                    END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                           MOVE WS-AR-DATE-PLUS-7-MONTHS TO WS-TEMP-DATE
                           IF WS-TEMP-DATE > WS-MAX-DATE                
                               MOVE 'N' TO WS-DELETE-FL                 
                               MOVE 'T' TO WS-MAX-REASON-CD             
                               MOVE 'E' TO WS-MAX-TYPE-CD               
                               MOVE 'TRANS HIST IN LAST 6 MONTHS' TO    
                                    WS-MAX-TABLE-NAME                   
                               MOVE WS-TEMP-DATE TO WS-MAX-DATE         
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_AR_TRANS_HIST **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_ACCOUNT                                  
                          ( CUSTOMER_NO,                                
                            ACCOUNT_NO,                                 
                            PREMISE_NO,                                 
                            COMPANY_NO,                                 
                            LOCAL_OFFICE,                               
                            ARCHIVED_DT,                                
                            ACCT_CREATE_DT,                             
                            ACCT_FINALED_DT,                            
                            ACCOUNT_TYPE_CODE,                          
                            CODE_ACCT_STAT,                             
                            CODE_STATUS_REASON,                         
                            CREDIT_GROUP,                               
                            ADDRESS_ID,                                 
                            ADDRESS_FORMAT,                             
                            LAST_PYMT_DATE,                             
                            LAST_PYMT_AMOUNT,                           
                            ACCT_XFER_FROM_LST,                         
                            ACCT_XFER_TO,                               
                            ACCOUNT_BALANCE_AM,                         
                            REG_GROUP_CD,                               
                            SENIOR_FL,                                  
                            DIST_ACCT_NO,                               
                            ORIGINATION_CD,                             
                            GROUP_EFF_TS,                               
                            OLD_ACCOUNT_NO,                             
                            REFUND_FL,                                  
                            DEPOSIT_FL,                                 
                            FORECAST_REASON_CD)                         
               VALUES                                                   
                   (:AT-CUSTOMER-NO,                                    
                    :AZ-ACCOUNT-NO,                                     
                    :AT-PREMISE-NO,                                     
                    :AT-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                     CAST(SYSDATETIMEOFFSET() AS DATE),                         
                    IIF(TRY_CONVERT(DATE, :HA-ACCT-CREATE-DT 
                                          :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :HA-ACCT-CREATE-DT 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:HA-ACCT-CREATE-DT :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:HA-ACCT-CREATE-DT :WS-NULL-IND-1
              ), CONVERT(DATE, :HA-ACCT-CREATE-DT :WS-NULL-IND-1) ),           
                    IIF(TRY_CONVERT(DATE, :HA-ACCT-FINALED-DT 
                                          :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :HA-ACCT-FINALED-DT 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:HA-ACCT-FINALED-DT :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:HA-ACCT-FINALED-DT 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :HA-ACCT-FINALED-DT :WS-NULL-IND-2) ),          
                    :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-CODE-STATUS-REASON,                             
                    :AT-CREDIT-GROUP,                                   
                    :AT-ADDRESS-ID,                                     
                    :AT-ADDRESS-FORMAT,                                 
                    IIF(TRY_CONVERT(DATE, :AT-LAST-PYMT-DATE 
                                          :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :AT-LAST-PYMT-DATE 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:AT-LAST-PYMT-DATE :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:AT-LAST-PYMT-DATE :WS-NULL-IND-3
              ), CONVERT(DATE, :AT-LAST-PYMT-DATE :WS-NULL-IND-3) ),           
                    :AT-LAST-PYMT-AMOUNT,                               
                    :AT-ACCT-XFER-FROM-LST,                             
                    :AT-ACCT-XFER-TO,                                   
                    :AT-TOTAL-AR-BALANCE,                               
                    :LR-REG-GROUP-CD,                                   
                    :LR-SENIOR-FL,                                      
                    :XM-DIST-ACCT-NO,                                   
                    :XM-ORIGINATION-CD,                                 
                    CIS.CHAR2TIMESTAMP(:LR-GROUP-EFF-TS :WS-NULL-IND-4),        
                    :XR-OLD-ACCOUNT-NO,                                 
                    :HA-REFUND-FL,                                      
                    :HA-DEPOSIT-FL,                                     
                    :AZ-FORECAST-REASON-CD)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO HST_ACCOUNT                                          
MFA-TR*                   ( CUSTOMER_NO,                                        
MFA-TR*                     ACCOUNT_NO,                                         
MFA-TR*                     PREMISE_NO,                                         
MFA-TR*                     COMPANY_NO,                                         
MFA-TR*                     LOCAL_OFFICE,                                       
MFA-TR*                     ARCHIVED_DT,                                        
MFA-TR*                     ACCT_CREATE_DT,                                     
MFA-TR*                     ACCT_FINALED_DT,                                    
MFA-TR*                     ACCOUNT_TYPE_CODE,                                  
MFA-TR*                     CODE_ACCT_STAT,                                     
MFA-TR*                     CODE_STATUS_REASON,                                 
MFA-TR*                     CREDIT_GROUP,                                       
MFA-TR*                     ADDRESS_ID,                                         
MFA-TR*                     ADDRESS_FORMAT,                                     
MFA-TR*                     LAST_PYMT_DATE,                                     
MFA-TR*                     LAST_PYMT_AMOUNT,                                   
MFA-TR*                     ACCT_XFER_FROM_LST,                                 
MFA-TR*                     ACCT_XFER_TO,                                       
MFA-TR*                     ACCOUNT_BALANCE_AM,                                 
MFA-TR*                     REG_GROUP_CD,                                       
MFA-TR*                     SENIOR_FL,                                          
MFA-TR*                     DIST_ACCT_NO,                                       
MFA-TR*                     ORIGINATION_CD,                                     
MFA-TR*                     GROUP_EFF_TS,                                       
MFA-TR*                     OLD_ACCOUNT_NO,                                     
MFA-TR*                     REFUND_FL,                                          
MFA-TR*                     DEPOSIT_FL,                                         
MFA-TR*                     FORECAST_REASON_CD)                                 
MFA-TR*        VALUES                                                           
MFA-TR*            (:AT-CUSTOMER-NO,                                            
MFA-TR*             :AZ-ACCOUNT-NO,                                             
MFA-TR*             :AT-PREMISE-NO,                                             
MFA-TR*             :AT-COMPANY-NO,                                             
MFA-TR*             :AT-LOCAL-OFFICE,                                           
MFA-TR*              CURRENT DATE,                                              
MFA-TR*             :HA-ACCT-CREATE-DT:WS-NULL-IND-1,                           
MFA-TR*             :HA-ACCT-FINALED-DT:WS-NULL-IND-2,                          
MFA-TR*             :AT-ACCOUNT-TYPE-CODE,                                      
MFA-TR*             :AT-CODE-ACCT-STAT,                                         
MFA-TR*             :AT-CODE-STATUS-REASON,                                     
MFA-TR*             :AT-CREDIT-GROUP,                                           
MFA-TR*             :AT-ADDRESS-ID,                                             
MFA-TR*             :AT-ADDRESS-FORMAT,                                         
MFA-TR*             :AT-LAST-PYMT-DATE:WS-NULL-IND-3,                           
MFA-TR*             :AT-LAST-PYMT-AMOUNT,                                       
MFA-TR*             :AT-ACCT-XFER-FROM-LST,                                     
MFA-TR*             :AT-ACCT-XFER-TO,                                           
MFA-TR*             :AT-TOTAL-AR-BALANCE,                                       
MFA-TR*             :LR-REG-GROUP-CD,                                           
MFA-TR*             :LR-SENIOR-FL,                                              
MFA-TR*             :XM-DIST-ACCT-NO,                                           
MFA-TR*             :XM-ORIGINATION-CD,                                         
MFA-TR*             :LR-GROUP-EFF-TS:WS-NULL-IND-4,                             
MFA-TR*             :XR-OLD-ACCOUNT-NO,                                         
MFA-TR*             :HA-REFUND-FL,                                              
MFA-TR*             :HA-DEPOSIT-FL,                                             
MFA-TR*             :AZ-FORECAST-REASON-CD)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING HST_ACCOUNT      **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-UPDATE-HT.                                                  
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_NAME_ACCT_XREF                                
                  SET CODE_ACCT_STAT = 'R',                             
                      ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE         
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_NAME_ACCT_XREF **'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-REFORECAST.                                                 
                                                                        
           MOVE WS-MAX-DATE TO AZ-FORECAST-DT.                          
           MOVE WS-MAX-REASON-CD TO AZ-FORECAST-REASON-CD.              
           MOVE WS-MAX-TABLE-NAME TO AZ-REMARKS.                        
           MOVE WS-MAX-TYPE-CD TO AZ-FORECAST-TYPE-CD.                  
                                                                        
           IF AZ-FORECAST-DT > WS-CURRENT-DATE                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-DATE-PLUS-1-MONTH TO AZ-FORECAST-DT
           END-IF.             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ARCHIVE_FCST                             
                  ( ACCOUNT_NO,                                         
                    FORECAST_TYPE_CD,                                   
                    FORECAST_REASON_CD,                                 
                    FORECAST_DT,                                        
                    ACCT_FINALED_DT,                                    
                    LAST_UPDATE_TS,                                     
                    LAST_UPDATE_USERID,                                 
                    REMARKS)                                            
               VALUES                                                   
                 ( :AZ-ACCOUNT-NO,                                      
                   :AZ-FORECAST-TYPE-CD,                                
                   :AZ-FORECAST-REASON-CD,                              
                   IIF(TRY_CONVERT(DATE, :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) ),                             
                   CIS.CHAR2TIMESTAMP(:AZ-ACCT-FINALED-DT),                     
                   CIS.CURRENT$TIMESTAMP(),                                   
                   'XP521',                                             
                   :AZ-REMARKS)                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ARCHIVE_FCST                                     
MFA-TR*           ( ACCOUNT_NO,                                                 
MFA-TR*             FORECAST_TYPE_CD,                                           
MFA-TR*             FORECAST_REASON_CD,                                         
MFA-TR*             FORECAST_DT,                                                
MFA-TR*             ACCT_FINALED_DT,                                            
MFA-TR*             LAST_UPDATE_TS,                                             
MFA-TR*             LAST_UPDATE_USERID,                                         
MFA-TR*             REMARKS)                                                    
MFA-TR*        VALUES                                                           
MFA-TR*          ( :AZ-ACCOUNT-NO,                                              
MFA-TR*            :AZ-FORECAST-TYPE-CD,                                        
MFA-TR*            :AZ-FORECAST-REASON-CD,                                      
MFA-TR*            :AZ-FORECAST-DT,                                             
MFA-TR*            :AZ-ACCT-FINALED-DT,                                         
MFA-TR*            CURRENT TIMESTAMP,                                           
MFA-TR*            'XP521',                                                     
MFA-TR*            :AZ-REMARKS)                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_ARCHIVE_FCST  **'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-INSERT-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_DEP_ON_HAND                              
                          ( ACCOUNT_NO,                                 
                            DEPOSIT_CERT_NO,                            
                            AMT_DEPOSIT,                                
                            DEPOSIT_STATUS_CD,                          
                            DATE_CERT_ISSUE,                            
                            DATE_TRAN,                                  
                            DATE_REFUNDED,                              
                            AMT_REFUNDED,                               
                            TOTAL_INTRST,                               
                            CODE_DEP_TYPE,                              
                            SERVICE_TYPE_CD,                            
                            CODE_REFUND_ELIG,                           
                            TRANSFER_AMT,                               
                            TRANSFERRED_TO,                             
                            DEP_CERT_NO_TO,                             
                            TRANSFERRED_FROM,                           
                            DEP_CERT_NO_FROM,                           
                            COMMENTS)                                   
               SELECT ACCOUNT_NO,                                       
                      DEPOSIT_CERT_NO,                                  
                      AMT_DEPOSIT,                                      
                      DEPOSIT_STATUS_CD,                                
                      DATE_CERT_ISSUE,                                  
                      DATE_TRAN,                                        
                      DATE_REFUNDED,                                    
                      AMT_REFUNDED,                                     
                      TOTAL_INTRST,                                     
                      CODE_DEP_TYPE,                                    
                      SERVICE_TYPE_CD,                                  
                      CODE_REFUND_ELIG,                                 
                      TRANSFER_AMT,                                     
                      TRANSFERRED_TO,                                   
                      DEP_CERT_NO_TO,                                   
                      TRANSFERRED_FROM,                                 
                      DEP_CERT_NO_FROM,                                 
                      COMMENTS                                          
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO HST_DEP_ON_HAND                                      
MFA-TR*                   ( ACCOUNT_NO,                                         
MFA-TR*                     DEPOSIT_CERT_NO,                                    
MFA-TR*                     AMT_DEPOSIT,                                        
MFA-TR*                     DEPOSIT_STATUS_CD,                                  
MFA-TR*                     DATE_CERT_ISSUE,                                    
MFA-TR*                     DATE_TRAN,                                          
MFA-TR*                     DATE_REFUNDED,                                      
MFA-TR*                     AMT_REFUNDED,                                       
MFA-TR*                     TOTAL_INTRST,                                       
MFA-TR*                     CODE_DEP_TYPE,                                      
MFA-TR*                     SERVICE_TYPE_CD,                                    
MFA-TR*                     CODE_REFUND_ELIG,                                   
MFA-TR*                     TRANSFER_AMT,                                       
MFA-TR*                     TRANSFERRED_TO,                                     
MFA-TR*                     DEP_CERT_NO_TO,                                     
MFA-TR*                     TRANSFERRED_FROM,                                   
MFA-TR*                     DEP_CERT_NO_FROM,                                   
MFA-TR*                     COMMENTS)                                           
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               DEPOSIT_CERT_NO,                                          
MFA-TR*               AMT_DEPOSIT,                                              
MFA-TR*               DEPOSIT_STATUS_CD,                                        
MFA-TR*               DATE_CERT_ISSUE,                                          
MFA-TR*               DATE_TRAN,                                                
MFA-TR*               DATE_REFUNDED,                                            
MFA-TR*               AMT_REFUNDED,                                             
MFA-TR*               TOTAL_INTRST,                                             
MFA-TR*               CODE_DEP_TYPE,                                            
MFA-TR*               SERVICE_TYPE_CD,                                          
MFA-TR*               CODE_REFUND_ELIG,                                         
MFA-TR*               TRANSFER_AMT,                                             
MFA-TR*               TRANSFERRED_TO,                                           
MFA-TR*               DEP_CERT_NO_TO,                                           
MFA-TR*               TRANSFERRED_FROM,                                         
MFA-TR*               DEP_CERT_NO_FROM,                                         
MFA-TR*               COMMENTS                                                  
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING HST_DEP_ON_HAND  **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-INSERT-DEP-PAY-HIST.                                        
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_DEP_PAY_HST                              
                          ( ACCOUNT_NO,                                 
                            DEPOSIT_CERT_NO,                            
                            DEP_PAY_DT,                                 
                            DEP_PAY_AMT)                                
               SELECT ACCOUNT_NO,                                       
                      DEPOSIT_CERT_NO,                                  
                      DEP_PAY_DT,                                       
                      DEP_PAY_AMT                                       
                 FROM CSS_DEP_PAY_HST                                   
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO HST_DEP_PAY_HST                                      
MFA-TR*                   ( ACCOUNT_NO,                                         
MFA-TR*                     DEPOSIT_CERT_NO,                                    
MFA-TR*                     DEP_PAY_DT,                                         
MFA-TR*                     DEP_PAY_AMT)                                        
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               DEPOSIT_CERT_NO,                                          
MFA-TR*               DEP_PAY_DT,                                               
MFA-TR*               DEP_PAY_AMT                                               
MFA-TR*          FROM CSS_DEP_PAY_HST                                           
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING HST_DEP_PAY_HST  **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-INSERT-REFUND.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_REFUND                                   
                          (ACCOUNT_NO,                                  
                           REFUND_ITEM_ID,                              
                           DATE_REFUNDED,                               
                           AMT_REFUNDED,                                
                           REFUND_CHECK_NO,                             
                           CHECK_STATUS_CD,                             
                           CHECK_ISS_REAS_CD,                           
                           ADDRESS_ID,                                  
                           ADDRESS_FORMAT,                              
                           MANUAL_INDICATOR,                            
                           DEPOSIT_CERT_NO,                             
                           ACCT_NO_CREDITED,                            
                           RETURNED_REASON,                             
                           ORIGINAL_CHECK_NO,                           
                           REQUEST_DT,                                  
                           REFUND_STATUS_DT,                            
                           CLEARED_DT,                                  
                           RETURNED_DATE,                               
                           REISSUED_DATE,                               
                           STOP_REQUEST_DT,                             
                           DATE_CHECK_VOIDED,                           
                           CHECK_REMAIL_DT,                             
                           DATE_ESCHEATED,                              
                           ESCHEATMENT_CD,                              
                           ESCHEAT_RETURN_DT,                           
                           ESCHEAT_VERIFY_DT,                           
                           USER_ID_APPRVD_BY,                           
                           USER_ID_RQSTED_BY,                           
                           COMMENTS)                                    
               SELECT ACCOUNT_NO,                                       
                      REFUND_ITEM_ID,                                   
                      DATE_REFUNDED,                                    
                      AMT_REFUNDED,                                     
                      REFUND_CHECK_NO,                                  
                      CHECK_STATUS_CD,                                  
                      CHECK_ISS_REAS_CD,                                
                      ADDRESS_ID,                                       
                      ' ',                                              
                      MANUAL_INDICATOR,                                 
                      DEPOSIT_CERT_NO,                                  
                      ACCT_NO_CREDITED,                                 
                      RETURNED_REASON,                                  
                      ORIGINAL_CHECK_NO,                                
                      REQUEST_DT,                                       
                      REFUND_STATUS_DT,                                 
                      CLEARED_DT,                                       
                      RETURNED_DATE,                                    
                      REISSUED_DATE,                                    
                      STOP_REQUEST_DT,                                  
                      DATE_CHECK_VOIDED,                                
                      CHECK_REMAIL_DT,                                  
                      DATE_ESCHEATED,                                   
                      ESCHEATMENT_CD,                                   
                      ESCHEAT_RETURN_DT,                                
                      ESCHEAT_VERIFY_DT,                                
                      USER_ID_APPRVD_BY,                                
                      USER_ID_RQSTED_BY,                                
                      COMMENTS                                          
                 FROM CSS_REFUND                                        
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO HST_REFUND                                           
MFA-TR*                   (ACCOUNT_NO,                                          
MFA-TR*                    REFUND_ITEM_ID,                                      
MFA-TR*                    DATE_REFUNDED,                                       
MFA-TR*                    AMT_REFUNDED,                                        
MFA-TR*                    REFUND_CHECK_NO,                                     
MFA-TR*                    CHECK_STATUS_CD,                                     
MFA-TR*                    CHECK_ISS_REAS_CD,                                   
MFA-TR*                    ADDRESS_ID,                                          
MFA-TR*                    ADDRESS_FORMAT,                                      
MFA-TR*                    MANUAL_INDICATOR,                                    
MFA-TR*                    DEPOSIT_CERT_NO,                                     
MFA-TR*                    ACCT_NO_CREDITED,                                    
MFA-TR*                    RETURNED_REASON,                                     
MFA-TR*                    ORIGINAL_CHECK_NO,                                   
MFA-TR*                    REQUEST_DT,                                          
MFA-TR*                    REFUND_STATUS_DT,                                    
MFA-TR*                    CLEARED_DT,                                          
MFA-TR*                    RETURNED_DATE,                                       
MFA-TR*                    REISSUED_DATE,                                       
MFA-TR*                    STOP_REQUEST_DT,                                     
MFA-TR*                    DATE_CHECK_VOIDED,                                   
MFA-TR*                    CHECK_REMAIL_DT,                                     
MFA-TR*                    DATE_ESCHEATED,                                      
MFA-TR*                    ESCHEATMENT_CD,                                      
MFA-TR*                    ESCHEAT_RETURN_DT,                                   
MFA-TR*                    ESCHEAT_VERIFY_DT,                                   
MFA-TR*                    USER_ID_APPRVD_BY,                                   
MFA-TR*                    USER_ID_RQSTED_BY,                                   
MFA-TR*                    COMMENTS)                                            
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               REFUND_ITEM_ID,                                           
MFA-TR*               DATE_REFUNDED,                                            
MFA-TR*               AMT_REFUNDED,                                             
MFA-TR*               REFUND_CHECK_NO,                                          
MFA-TR*               CHECK_STATUS_CD,                                          
MFA-TR*               CHECK_ISS_REAS_CD,                                        
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               ' ',                                                      
MFA-TR*               MANUAL_INDICATOR,                                         
MFA-TR*               DEPOSIT_CERT_NO,                                          
MFA-TR*               ACCT_NO_CREDITED,                                         
MFA-TR*               RETURNED_REASON,                                          
MFA-TR*               ORIGINAL_CHECK_NO,                                        
MFA-TR*               REQUEST_DT,                                               
MFA-TR*               REFUND_STATUS_DT,                                         
MFA-TR*               CLEARED_DT,                                               
MFA-TR*               RETURNED_DATE,                                            
MFA-TR*               REISSUED_DATE,                                            
MFA-TR*               STOP_REQUEST_DT,                                          
MFA-TR*               DATE_CHECK_VOIDED,                                        
MFA-TR*               CHECK_REMAIL_DT,                                          
MFA-TR*               DATE_ESCHEATED,                                           
MFA-TR*               ESCHEATMENT_CD,                                           
MFA-TR*               ESCHEAT_RETURN_DT,                                        
MFA-TR*               ESCHEAT_VERIFY_DT,                                        
MFA-TR*               USER_ID_APPRVD_BY,                                        
MFA-TR*               USER_ID_RQSTED_BY,                                        
MFA-TR*               COMMENTS                                                  
MFA-TR*          FROM CSS_REFUND                                                
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING HST_REFUND       **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-DELETE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ACCOUNT                                  
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCOUNT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_ACCOUNT       **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8510-DELETE-MTR-ENV.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_MTRD_ENVRNMT                             
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_MTRD_ENVRNMT                                     
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_MTRD_ENVRNMT  **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8515-DELETE-BILL-XFER.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILL_ACCT_XFER                           
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_BILL_ACCT_XFER                                   
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8515                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_BILL_ACCT_XFER **'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8515-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8520-DELETE-UTL-ENV.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_UTIL_ENVRNMT                             
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_UTIL_ENVRNMT                                     
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8520                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_UTIL_ENVRNMT  **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8525-DELETE-EBILL.                                               
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_EBILL_INSERTS                            
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_EBILL_INSERTS                                    
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8525                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_EBILL_INSERTS **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8525-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8530-DELETE-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_DEP_ON_HAND                              
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_DEP_ON_HAND                                      
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8530                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_DEP_ON_HAND   **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8535-DELETE-ROUTE-RPT.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ROUTE_REPORT                             
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ROUTE_REPORT                                     
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8535                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_ROUTE_REPORT  **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8535-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8540-DELETE-INT-READ.                                            
                                                                        
           MOVE AZ-ACCOUNT-NO TO CX-ACCOUNT-NO.                         
                                                                        
           EXEC SQL                                                     
               OPEN CNS_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  8540-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING CNS CURSOR         **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 8541-FETCH-ROWS THRU 8541-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE CNS_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  8540-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING CNS CURSOR         **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8541-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH CNS_CURSOR                                          
               INTO :CX-CODE-UTIL-TYPE,                                 
                    :CX-METER-NO,                                       
                    :CX-BILL-ITEM-TIMESTMP                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 8541-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  8541-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING CNS CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_INTERVAL_READ                            
                WHERE CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE               
                  AND METER_NO = :CX-METER-NO                           
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_INTERVAL_READ                                    
MFA-TR*         WHERE CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE                       
MFA-TR*           AND METER_NO = :CX-METER-NO                                   
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*        QUERYNO 8541                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_INTERVAL_READ  **'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           GO TO 8541-FETCH-ROWS.                                       
                                                                        
       8541-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8545-DELETE-DIST-MTR.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_DIST_XREF_MTR                            
                WHERE DIST_ACCOUNT_NO = :XM-DIST-ACCT-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_DIST_XREF_MTR                                    
MFA-TR*         WHERE DIST_ACCOUNT_NO = :XM-DIST-ACCT-NO                        
MFA-TR*        QUERYNO 8545                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_DIST_XREF_MTR **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8545-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8550-DELETE-REFUND.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_REFUND                                   
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_REFUND                                           
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8550                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_REFUND        **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8555-DELETE-CHRG-OFF.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_CHRG_OFF                                 
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_CHRG_OFF                                         
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8555                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_CHRG_OFF      **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8555-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8560-DELETE-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_AR_CNTL                                  
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_AR_CNTL                                          
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8560                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_AR_CNTL       **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8560-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8570-DELETE-COMM-DATA.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_COMM_DATA                                
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_COMM_DATA                                        
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8570                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_COMM_DATA     **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8570-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8580-DELETE-BILL-HDR.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILLING_HDR                              
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_BILLING_HDR                                      
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8580                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_BILLING_HDR   **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8580-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8590-DELETE-MNT-HIST.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_MNT_TRANS_HIST                           
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_MNT_TRANS_HIST                                   
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 85903                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_MNT_TRANS_HIST**'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8590-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-INSERT-BILL-NAMES.                                          
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_ACCT_BILL_NMES                           
                          (ACCOUNT_NO,                                  
                           NAME_ID,                                     
                           NAME_TYPE)                                   
               SELECT ACCOUNT_NO,                                       
                      NAME_ID,                                          
                      NAME_TYPE                                         
                 FROM CSS_ACCT_BILL_NMES                                
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO HST_ACCT_BILL_NMES                                   
MFA-TR*                   (ACCOUNT_NO,                                          
MFA-TR*                    NAME_ID,                                             
MFA-TR*                    NAME_TYPE)                                           
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               NAME_ID,                                                  
MFA-TR*               NAME_TYPE                                                 
MFA-TR*          FROM CSS_ACCT_BILL_NMES                                        
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING HST_ACCT_BILL_NMES *'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8700-INSERT-COAPPLICANT.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_COAPPLICANT                              
                          (ACCOUNT_NO,                                  
                           CUSTOMER_NO)                                 
               SELECT ACCOUNT_NO,                                       
                      CUSTOMER_NO                                       
                 FROM CSS_COAPPLICANT                                   
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO HST_COAPPLICANT                                      
MFA-TR*                   (ACCOUNT_NO,                                          
MFA-TR*                    CUSTOMER_NO)                                         
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO                                               
MFA-TR*          FROM CSS_COAPPLICANT                                           
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING HST_COAPPLICANT    *'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-INSERT-ROOMMATE.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_ROOMMATE                                 
                          (ACCOUNT_NO,                                  
                           CUSTOMER_NO)                                 
               SELECT ACCOUNT_NO,                                       
                      CUSTOMER_NO                                       
                 FROM CSS_ROOMMATE                                      
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO HST_ROOMMATE                                         
MFA-TR*                   (ACCOUNT_NO,                                          
MFA-TR*                    CUSTOMER_NO)                                         
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO                                               
MFA-TR*          FROM CSS_ROOMMATE                                              
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING HST_ROOMMATE       *'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-INSERT-INT-HIST.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO HST_INTEREST_HIST                            
                          (ACCOUNT_NO,                                  
                           DEPOSIT_CERT_NO,                             
                           INT_CREDIT_DT,                               
                           EFFECTIVE_DT,                                
                           INTEREST_AMT,                                
                           INTEREST_RT)                                 
               SELECT ACCOUNT_NO,                                       
                      DEPOSIT_CERT_NO,                                  
                      INT_CREDIT_DT,                                    
                      EFFECTIVE_DT,                                     
                      INTEREST_AMT,                                     
                      INTEREST_RT                                       
                 FROM CSS_INTEREST_HIST                                 
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO HST_INTEREST_HIST                                    
MFA-TR*                   (ACCOUNT_NO,                                          
MFA-TR*                    DEPOSIT_CERT_NO,                                     
MFA-TR*                    INT_CREDIT_DT,                                       
MFA-TR*                    EFFECTIVE_DT,                                        
MFA-TR*                    INTEREST_AMT,                                        
MFA-TR*                    INTEREST_RT)                                         
MFA-TR*        SELECT ACCOUNT_NO,                                               
MFA-TR*               DEPOSIT_CERT_NO,                                          
MFA-TR*               INT_CREDIT_DT,                                            
MFA-TR*               EFFECTIVE_DT,                                             
MFA-TR*               INTEREST_AMT,                                             
MFA-TR*               INTEREST_RT                                               
MFA-TR*          FROM CSS_INTEREST_HIST                                         
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8900                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING HST_INTEREST_HIST  *'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSXP521 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
