       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP520.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM REVIEWS ACCOUNTS SET TO BE ARCHIVED.              **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    03/09    FB        ORIGINAL VERSION                       **         
A37666*    09/14    FB        ADD CURRENT ACCOUNT AT PREMISE CHECK   **         
A37666*                       FOR SEB.                               **         
ACT111*    04/16    TP7R341   WORK QUEUE CHANGE TO REMOVE THE        **         
ACT111*             A04860    CSS_WQ_ITEMS_MF TABLE                  **         
ACT228*    08/16    MC95456   REPLACE CSR00028 WITH CSR04675.        **         
ACT228*             APPL5460  REMOVED ARCHIVED TABLE.                **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP520'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-PROCESS-COUNT       PIC 9(6).                         
           05  WS-PROCESS-ALL         PIC 9(9).                         
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-DISPLAY-DOLLARS     PIC Z(10)9.99.                    
           05  WS-TRAN-APPL-NO        PIC S9(04) COMP VALUE 1.          
           05  WS-ROW-COUNT           PIC S9(09) COMP VALUE 0.          
           05  WS-REFORECAST-COUNT    PIC S9(09) COMP VALUE 0.          
           05  WS-RELEASE-COUNT       PIC S9(09) COMP VALUE 0.          
           05  WS-EXEMPTION-COUNT     PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(09) COMP VALUE 0.          
           05  WS-CURRENT-DATE        PIC X(10).                        
           05  WS-CURRENT-TS          PIC X(26).                        
           05  WS-ACCT-FINALED-DT     PIC X(10).                        
           05  WS-DATE-PLUS-3-YEARS   PIC X(10).                        
           05  WS-DATE-PLUS-1-YEAR    PIC X(10).                        
           05  WS-DATE-PLUS-3-MONTHS  PIC X(10).                        
           05  WS-DATE-PLUS-6-MONTHS  PIC X(10).                        
           05  WS-DATE-PLUS-7-MONTHS  PIC X(10).                        
           05  WS-AR-DATE-PLUS-7-MONTHS  PIC X(10).                     
           05  WS-DATE-PLUS-1-MONTH   PIC X(10).                        
           05  WS-BK-DATE-PLUS-10-YEARS  PIC X(10).                     
           05  WS-DATE-MINUS-6-MONTHS PIC X(10).                        
           05  WS-DATE-MINUS-3-YEARS  PIC X(10).                        
           05  WS-DATE-MINUS-42-MONTHS PIC X(10).                       
           05  WS-DATABASE            PIC 9(01) VALUE 0.                
               88 CSR-DATABASE                  VALUE 1.                
               88 SEB-DATABASE                  VALUE 2.                
           05  WS-WQ-COMMENTS-1         PIC X(115) VALUE                
           'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX        
      -    'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX.'.                    
           05  WS-TRANSHIST-1           PIC X(41) VALUE                 
           'ARCHIVE FORECAST DATA HAS BEEN DELETED'.                    
           05  WS-ITERATION-STORAGE.                                    
               10 WS-DISPLAY-ACCOUNT  PIC 9(13) VALUE ZEROES.           
               10 WS-DISPLAY-PREMISE  PIC 9(10) VALUE ZEROES.           
               10 WS-NULL-IND         PIC S9(4) COMP VALUE +0.          
               10 WS-NULL-IND-1       PIC S9(4) COMP VALUE +0.          
               10 WS-NULL-IND-2       PIC S9(4) COMP VALUE +0.          
               10 WS-ARCHIVE-FL       PIC X(01) VALUE 'Y'.              
               10 WS-GENERATE-WQ-FL   PIC X(01) VALUE 'N'.              
               10 WS-EXEMPTION-FL     PIC X(01) VALUE 'N'.              
               10 WS-TRANSHIST-FL     PIC X(01) VALUE 'N'.              
               10 WS-EXEMPTION-CD     PIC X(01) VALUE SPACES.           
               10 WS-CPD99-ERROR      PIC X(01) VALUE 'N'.              
               10 WS-CURRENT-ACCOUNT  PIC 9(13) VALUE ZEROES.           
               10 WS-MAX-REASON-CD    PIC X(01) VALUE SPACES.           
               10 WS-MAX-TYPE-CD      PIC X(01) VALUE SPACES.           
               10 WS-MAX-DATE         PIC X(10) VALUE SPACES.           
               10 WS-MAX-TABLE-NAME   PIC X(40) VALUE SPACES.           
               10 WS-TEMP-DATE        PIC X(10) VALUE SPACES.           
               10 WS-MSTSUB-FL        PIC X(01) VALUE SPACES.           
               10 WS-UTLREL-FL        PIC X(01) VALUE SPACES.           
               10 WS-PEND-XFER-FL     PIC X(01) VALUE SPACES.           
                                                                        
ACT228 01  CSR04675-CALL-DATA.                                          
ACT228     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT228     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
COB305     05 SERV-ORDER-NO-4675        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
ACT228     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT228     05  CATEGORY-ID-4675          PIC S9(4) USAGE COMP.          
COB305     05 ACCOUNT-NO-4675        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 PREMISE-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 CUSTOMER-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
ACT228     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT228     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT228     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT228     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT228     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT228     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT228     05  COMMENTS-4675.                                           
ACT228        49 COMMENTS-4675-LEN       PIC S9(4) USAGE COMP VALUE 0.  
ACT228        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT228     05  FREE-FORM-DATA-4675.                                     
ACT228        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) USAGE COMP VALUE 0. 
ACT228        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT228     05 CREATED-BY-4675             PIC X(16) VALUE SPACES.       
                                                                        
ACT228 01  CSR04675-RETURN-DATA.                                        
ACT228     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT228     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
ACT228*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
       01  WS-TABLES.                                                   
           05  T1-CSS-PENDING-XFER       OCCURS 750                     
                                         INDEXED BY T1-INDEX.           
               10  T1-ACCT-XFER-TO       PIC S9(13) COMP-3 VALUE ZEROES.
               10  T1-ACCT-XFER-FROM     PIC S9(13) COMP-3 VALUE ZEROES.
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBARCFCS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBARCNTL                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPDBKDF                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMSTSUB                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRECNCT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUTLREL                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCSTPRM                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNTRCT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPENXFR                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBFWACTN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBNKRPT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBARHIST                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCHGOFF                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACXMPT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE ARCH_CURSOR CURSOR WITH HOLD FOR                   
               SELECT AZ.ACCOUNT_NO,                                    
                      FORECAST_REASON_CD,                               
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
                 FROM CSS_ARCHIVE_FCST AZ WITH(READUNCOMMITTED)                 
                WHERE FORECAST_DT =                                     
                      (SELECT MAX(FORECAST_DT)                          
                         FROM CSS_ARCHIVE_FCST WITH(READUNCOMMITTED)            
                        WHERE ACCOUNT_NO = AZ.ACCOUNT_NO)               
                  AND FORECAST_DT <= IIF(TRY_CONVERT(DATE, 
                                                        :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) )                    
                  AND FORECAST_TYPE_CD = 'R'                            
                  AND NOT EXISTS                                        
                      (SELECT '1'                                       
                         FROM CSS_ARCHIVE_EXEMPT WITH(READUNCOMMITTED)          
                        WHERE ACCOUNT_NO = AZ.ACCOUNT_NO)               
                OPTION(FAST 1)                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ARCH_CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT AZ.ACCOUNT_NO,                                            
MFA-TR*               FORECAST_REASON_CD,                                       
MFA-TR*               ACCT_FINALED_DT                                           
MFA-TR*          FROM CSS_ARCHIVE_FCST AZ                                       
MFA-TR*         WHERE FORECAST_DT =                                             
MFA-TR*               (SELECT MAX(FORECAST_DT)                                  
MFA-TR*                  FROM CSS_ARCHIVE_FCST                                  
MFA-TR*                 WHERE ACCOUNT_NO = AZ.ACCOUNT_NO)                       
MFA-TR*           AND FORECAST_DT <= :AZ-FORECAST-DT                            
MFA-TR*           AND FORECAST_TYPE_CD = 'R'                                    
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*               (SELECT '1'                                               
MFA-TR*                  FROM CSS_ARCHIVE_EXEMPT                                
MFA-TR*                 WHERE ACCOUNT_NO = AZ.ACCOUNT_NO)                       
MFA-TR*         OPTIMIZE FOR 1 ROW                                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 1000                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE XFER_CURSOR CURSOR WITH HOLD FOR                   
               SELECT ACCT_XFER_TO,                                     
                      ACCT_XFER_FROM                                    
                 FROM CSS_PENDING_XFER WITH(READUNCOMMITTED)                    
                                                                 
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE XFER_CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT ACCT_XFER_TO,                                             
MFA-TR*               ACCT_XFER_FROM                                            
MFA-TR*          FROM CSS_PENDING_XFER                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 1200                                                     
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT228            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, 3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-3-YEARS                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 3 YEARS)                       
MFA-TR*          INTO :WS-DATE-PLUS-3-YEARS                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, 1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-1-YEAR                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 1 YEARS)                       
MFA-TR*          INTO :WS-DATE-PLUS-1-YEAR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 6, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-6-MONTHS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 6 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-6-MONTHS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 7, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-7-MONTHS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 7 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-7-MONTHS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -6, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-6-MONTHS                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 6 MONTHS)                      
MFA-TR*          INTO :WS-DATE-MINUS-6-MONTHS                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-3-MONTHS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 3 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-3-MONTHS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-1-MONTH                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 1 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-1-MONTH                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, -3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-3-YEARS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 3 YEARS)                       
MFA-TR*          INTO :WS-DATE-MINUS-3-YEARS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -42, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-42-MONTHS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 42 MONTHS)                     
MFA-TR*          INTO :WS-DATE-MINUS-42-MONTHS                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 7100-SELECT-DELINQUENCY THRU 7100-EXIT.              
           PERFORM 7110-SELECT-JOB-PARM THRU 7110-EXIT.                 
           PERFORM 1200-LOAD-PENDING-XFER THRU 1200-EXIT.               
                                                                        
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                       
           DISPLAY 'TOTAL ACCOUNTS PROCESSED = ' WS-DISPLAY-COUNT.      
           MOVE WS-REFORECAST-COUNT TO WS-DISPLAY-COUNT.                
           DISPLAY 'TOTAL ACCOUNTS REFORECAST = ' WS-DISPLAY-COUNT.     
           MOVE WS-RELEASE-COUNT TO WS-DISPLAY-COUNT.                   
           DISPLAY 'TOTAL ACCOUNTS RELEASED = ' WS-DISPLAY-COUNT.       
           MOVE WS-EXEMPTION-COUNT TO WS-DISPLAY-COUNT.                 
           DISPLAY 'TOTAL EXEMPTIONS = ' WS-DISPLAY-COUNT.              
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           MOVE WS-CURRENT-DATE TO AZ-FORECAST-DT.                      
           EXEC SQL                                                     
               OPEN ARCH_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING ARCH CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE ARCH_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING ARCH CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH ARCH_CURSOR                                         
               INTO :AZ-ACCOUNT-NO,                                     
                    :AZ-FORECAST-REASON-CD,                             
                    :AZ-ACCT-FINALED-DT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING ARCH CURSOR       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000-ARCHIVE-PROCESS THRU 2000-EXIT.                 
                                                                        
            IF WS-PROCESS-ALL <= WS-ROW-COUNT                           
                GO TO 1100-EXIT
            END-IF.                                        
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-LOAD-PENDING-XFER.                                          
                                                                        
           EXEC SQL                                                     
               OPEN XFER_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1200-LOAD-PENDING-XFER           **'    
                   DISPLAY '**  ERROR OPENING XFER CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           SET T1-INDEX TO +1.                                          
           PERFORM 1210-FETCH-ROWS THRU 1210-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE XFER_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1200-LOAD-PENDING-XFER           **'    
                   DISPLAY '**  ERROR CLOSING XFER CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1210-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH XFER_CURSOR                                         
               INTO :XP-ACCT-XFER-TO,                                   
                    :XP-ACCT-XFER-FROM                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1210-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1210-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING XFER CURSOR       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE XP-ACCT-XFER-TO TO T1-ACCT-XFER-TO (T1-INDEX).          
           MOVE XP-ACCT-XFER-FROM TO T1-ACCT-XFER-FROM (T1-INDEX).      
           SET T1-INDEX UP BY 1.                                        
                                                                        
           GO TO 1210-FETCH-ROWS.                                       
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-ARCHIVE-PROCESS.                                            
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
           MOVE AZ-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT.                    
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
                                                                        
      *  THESE ARE THE EXEMPTION EDITS.  IF ANY FAIL, SET THE                   
      *  EXEMPTION FLAG, WRITE TRANSHIST, AND DELETE FORECAST ROWS.             
                                                                        
      *  ACCOUNT CANNOT BE IN BANKRUPTCY.                                       
                                                                        
           MOVE 'N' TO WS-EXEMPTION-FL.                                 
           IF AT-BANKRUPTCY-IND = 'B' AND AT-BNKRPT-CASE-NO > ' '       
               MOVE 'Y' TO WS-EXEMPTION-FL                              
               MOVE 'B' TO WS-EXEMPTION-CD                              
               MOVE 'N' TO WS-ARCHIVE-FL
           END-IF.                               
                                                                        
      *  ACCOUNT CANNOT HAVE A JUDGEMENT AGAINST IT                             
                                                                        
           IF WS-EXEMPTION-FL = 'N'                                     
               IF AT-JUDGEMENT-IND = 'J'                                
                   MOVE 'Y' TO WS-EXEMPTION-FL                          
                   MOVE 'J' TO WS-EXEMPTION-CD                          
                   MOVE 'N' TO WS-ARCHIVE-FL
               END-IF
           END-IF.                           
                                                                        
      *  ACCOUNT CANNOT BE WITH AN ATTORNEY                                     
                                                                        
           IF WS-EXEMPTION-FL = 'N'                                     
               PERFORM 7510-SELECT-ATTORNEY THRU 7510-EXIT              
               IF WS-EXEMPTION-FL = 'Y'                                 
                   MOVE 'A' TO WS-EXEMPTION-CD                          
                   MOVE 'N' TO WS-ARCHIVE-FL
               END-IF
           END-IF.                           
                                                                        
      *  UTILITY ACCOUNT CANNOT BE CURRENT AT PREMISE FOR CSR                   
                                                                        
           IF AT-ACCOUNT-TYPE-CODE = 'N'                                
               CONTINUE                                                 
           ELSE                                                         
A37666*        IF CSR-DATABASE                                                  
                   MOVE 'N' TO WS-CPD99-ERROR                           
                   MOVE AT-PREMISE-NO TO WS-CPD99-PREMISE-NO            
                   PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT        
                   IF WS-CPD99-ERROR = 'Y'                              
                       MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE       
                       IF WS-TEMP-DATE > WS-MAX-DATE                    
                           MOVE WS-TEMP-DATE TO WS-MAX-DATE             
                           MOVE 'P' TO WS-MAX-REASON-CD                 
                           MOVE 'E' TO WS-MAX-TYPE-CD                   
                           MOVE 'ERROR IN CPD00099 ROUTINE' TO          
                                WS-MAX-TABLE-NAME                       
                           MOVE 'N' TO WS-ARCHIVE-FL                    
                       END-IF                                           
                   ELSE                                                 
                       MOVE WS-CPD99-ACCOUNT-NO TO WS-CURRENT-ACCOUNT   
                       IF WS-CURRENT-ACCOUNT = AZ-ACCOUNT-NO            
                           MOVE 'P' TO WS-EXEMPTION-CD                  
                           MOVE 'Y' TO WS-EXEMPTION-FL                  
                           MOVE 'N' TO WS-ARCHIVE-FL
                       END-IF
                   END-IF
           END-IF.                   
                                                                        
           IF WS-EXEMPTION-FL = 'N'                                     
               PERFORM 2100-NON-MAX-EDITS THRU 2100-EXIT
           END-IF.               
                                                                        
      *   IF WS-GENERATE-WQ-FL = 'Y'                                            
ACT228*       PERFORM 5000-CALL-CSR04675 THRU 5000-EXIT.                        
                                                                        
           IF WS-EXEMPTION-FL = 'Y'                                     
               ADD 1 TO WS-EXEMPTION-COUNT                              
               PERFORM 2200-EXEMPTION-PROCESSING THRU 2200-EXIT         
           ELSE                                                         
               IF WS-ARCHIVE-FL = 'N'                                   
                   ADD 1 TO WS-REFORECAST-COUNT                         
                   PERFORM 8100-REFORECAST THRU 8100-EXIT               
               ELSE                                                     
                   ADD 1 TO WS-RELEASE-COUNT                            
                   PERFORM 8000-RELEASE-FOR-ARCHIVE THRU 8000-EXIT
               END-IF
           END-IF.     
                                                                        
           ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT.                       
           IF WS-COMMIT-COUNT > 250                                     
                 EXEC SQL                                               
                     COMMIT                                             
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-NON-MAX-EDITS.                                              
                                                                        
      *  THESE ARE THE NON-EXEMPTION EDITS.  ALL EDITS ARE PERFORMED            
      *  AND THE MAXIMUM FORECAST DATE/REASON IS LOADED INTO THE                
      *  ARCHIVE FORECAST TABLE.                                                
                                                                        
      *  ACCOUNT MUST HAVE FB DATE                                              
                                                                        
           IF AT-ACCT-FINALED-DT = SPACES AND                           
              AT-DATE-BILL-DAY-00 < WS-DATE-MINUS-6-MONTHS              
                  MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE            
                  IF WS-TEMP-DATE > WS-MAX-DATE                         
                      MOVE WS-TEMP-DATE TO WS-MAX-DATE                  
                      MOVE 'O' TO WS-MAX-REASON-CD                      
                      MOVE 'E' TO WS-MAX-TYPE-CD                        
                      MOVE 'FINAL BILL DATE IS MISSING' TO              
                           WS-MAX-TABLE-NAME                            
                      MOVE 'N' TO WS-ARCHIVE-FL
                  END-IF
           END-IF.                        
                                                                        
      *  FB DATE MUST BE > 3 YEARS AGO                                          
                                                                        
           MOVE AT-ACCT-FINALED-DT(1:10) TO WS-ACCT-FINALED-DT.         
           IF WS-ACCT-FINALED-DT > WS-DATE-MINUS-42-MONTHS              
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE > WS-MAX-DATE                            
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'O' TO WS-MAX-REASON-CD                         
                   MOVE 'E' TO WS-MAX-TYPE-CD                           
                   MOVE 'FINAL BILL DATE < 3 YEARS' TO                  
                        WS-MAX-TABLE-NAME                               
                   MOVE 'N' TO WS-ARCHIVE-FL
               END-IF
           END-IF.                           
                                                                        
      *  NON-ZERO TOTAL AR BALANCE                                              
                                                                        
           IF AT-TOTAL-AR-BALANCE NOT = 0                               
              MOVE WS-CURRENT-DATE TO WS-TEMP-DATE                      
              IF WS-TEMP-DATE > WS-MAX-DATE                             
                  MOVE WS-TEMP-DATE TO WS-MAX-DATE                      
                  MOVE 'D' TO WS-MAX-REASON-CD                          
                  MOVE 'E' TO WS-MAX-TYPE-CD                            
                  MOVE AT-TOTAL-AR-BALANCE TO WS-DISPLAY-DOLLARS        
                  STRING 'ACCOUNT BALANCE = '                           
                         WS-DISPLAY-DOLLARS                             
                         DELIMITED BY SIZE                              
                         INTO WS-MAX-TABLE-NAME                         
                  MOVE 'N' TO WS-ARCHIVE-FL
              END-IF
           END-IF.                            
                                                                        
      *  NON-ZERO ROWS ON AR CONTROL                                            
                                                                        
           PERFORM 7320-SELECT-AR-CNTL THRU 7320-EXIT.                  
                                                                        
      *  NON-REFUNDED DEPOSIT                                                   
                                                                        
           PERFORM 7330-SELECT-DEP-ON-HAND THRU 7330-EXIT.              
                                                                        
      *  CHARGE OFF EDIT                                                        
                                                                        
           PERFORM 7200-SELECT-CHRG-OFF THRU 7200-EXIT.                 
                                                                        
      *  CONTRACT EDITS                                                         
                                                                        
           PERFORM 7260-SELECT-CONTRACT THRU 7260-EXIT.                 
                                                                        
      *  REFUND EDIT                                                            
                                                                        
           PERFORM 7300-SELECT-REFUND THRU 7300-EXIT.                   
                                                                        
      *  AT TRANSHIST EDIT                                                      
                                                                        
           PERFORM 7290-SELECT-AR-TRANSHIST THRU 7290-EXIT.             
                                                                        
      *  MISCELLANEOUS EDITS                                                    
                                                                        
           PERFORM 7210-SELECT-BNK-DRFT THRU 7210-EXIT.                 
           PERFORM 7230-SELECT-MSTSUB THRU 7230-EXIT.                   
           PERFORM 7240-SELECT-RECONNECT THRU 7240-EXIT.                
           PERFORM 7250-SELECT-UTIL-BILL THRU 7250-EXIT.                
           PERFORM 7270-PENDING-XFER THRU 7270-EXIT.                    
           PERFORM 7280-SELECT-WQS THRU 7280-EXIT.                      
           PERFORM 7310-SELECT-ORDERS THRU 7310-EXIT.                   
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-EXEMPTION-PROCESSING.                                       
                                                                        
           PERFORM 8200-UPDATE-ACCOUNT THRU 8200-EXIT.                  
           PERFORM 8300-DELETE-FORECAST THRU 8300-EXIT.                 
           PERFORM 2210-WRITE-TRANSHIST THRU 2210-EXIT.                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-WRITE-TRANSHIST.                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 1                     TO WS-TRAN-APPL-NO                
                                         MI-TRAN-APPL-NO.               
           MOVE SPACES                TO MH-RESP-AREA-ID.               
           MOVE 'F'                   TO MH-CODE-TRAN-TYPE.             
           MOVE ZEROES                TO MH-CUSTOMER-NO.                
           MOVE ZEROES                TO MH-PREMISE-NO.                 
           MOVE AZ-ACCOUNT-NO         TO MH-ACCOUNT-NO.                 
           MOVE 'SYSTEM'              TO MH-USER-ID.                    
           MOVE 'PCSXP520'            TO MH-APPL-PROGRAM-ID.            
           IF WS-TRANSHIST-FL = 'Y'                                     
               MOVE WS-TRANSHIST-1    TO MH-TRAN-COMMENT-TEXT           
               MOVE 41                TO MH-TRAN-COMMENT-LEN            
           ELSE                                                         
               MOVE SPACES            TO MH-TRAN-COMMENT-TEXT           
               MOVE ZERO              TO MH-TRAN-COMMENT-LEN
           END-IF.           
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-CURRENT-DATE       TO MH-DATE-TRANS.                 
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE WS-EXEMPTION-CD       TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'ARCH EXEMPT'         TO MI-COLUMN-DESC.                
           MOVE '  '                  TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT228 5000-CALL-CSR04675.                                              
                                                                        
ACT228     MOVE '1' TO ROUTING-CATEGORY-4675.                           
           EVALUATE WS-MAX-REASON-CD                                    
               WHEN 'B'                                                 
ACT228             MOVE 000 TO CATEGORY-ID-4675                         
ACT228             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT228             MOVE 115 TO COMMENTS-4675-LEN                        
               WHEN 'H'                                                 
ACT228             MOVE 000 TO CATEGORY-ID-4675                         
ACT228             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT228             MOVE 115 TO COMMENTS-4675-LEN                        
               WHEN 'K'                                                 
ACT228             MOVE 000 TO CATEGORY-ID-4675                         
ACT228             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT228             MOVE 115 TO COMMENTS-4675-LEN                        
               WHEN 'S'                                                 
ACT228             MOVE 000 TO CATEGORY-ID-4675                         
ACT228             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT228             MOVE 115 TO COMMENTS-4675-LEN                        
               WHEN 'Q'                                                 
ACT228             MOVE 000 TO CATEGORY-ID-4675                         
ACT228             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT228             MOVE 115 TO COMMENTS-4675-LEN                        
               WHEN 'I'                                                 
ACT228             MOVE 000 TO CATEGORY-ID-4675                         
ACT228             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT228             MOVE 115 TO COMMENTS-4675-LEN                        
               WHEN 'O'                                                 
ACT228             MOVE 000 TO CATEGORY-ID-4675                         
ACT228             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT228             MOVE 115 TO COMMENTS-4675-LEN                        
               WHEN 'C'                                                 
ACT228             MOVE 000 TO CATEGORY-ID-4675                         
ACT228             MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT          
ACT228             MOVE 115 TO COMMENTS-4675-LEN                        
           END-EVALUATE.                                                
ACT228     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT228     MOVE AT-LOCAL-OFFICE TO LOCAL-OFFICE-4675.                   
ACT228     MOVE 'SYSTEM' TO USER-ID-ORIG-4675.                          
ACT228     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT228                    RESP-AREA-ID-4675                             
ACT228                    DATE-REQUIRED-4675                            
ACT228                    DATE-CREATED-4675                             
ACT228                    FREE-FORM-DATA-4675-TEXT.                     
ACT228     MOVE 'N' TO WQ-PRIORITY-4675                                 
ACT228     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
ACT228     MOVE AZ-ACCOUNT-NO TO ACCOUNT-NO-4675.                       
ACT228     MOVE AT-PREMISE-NO TO PREMISE-NO-4675.                       
ACT228     MOVE AT-CUSTOMER-NO TO CUSTOMER-NO-4675.                     
ACT228     MOVE ZEROES TO SERV-ORDER-NO-4675.                           
ACT228     MOVE 'PCSXP520' TO CREATED-BY-4675.                          
                                                                        
      *    EXEC SQL                                                     
ACT228*       CALL CSR04675                                             
ACT228*           (:IN-ITEM-ID-4675,                                    
ACT228*            :ROUTING-CATEGORY-4675,                              
ACT228*            :LOCAL-OFFICE-4675,                                  
ACT228*            :USER-ID-ORIG-4675,                                  
ACT228*            :USER-ID-ASGN-4675,                                  
ACT228*            :RESP-AREA-ID-4675,                                  
ACT228*            :CATEGORY-ID-4675,                                   
ACT228*            :ACCOUNT-NO-4675,                                    
ACT228*            :PREMISE-NO-4675,                                    
ACT228*            :CUSTOMER-NO-4675,                                   
ACT228*            :SERV-ORDER-NO-4675,                                 
ACT228*            :COMMENTS-4675,                                      
ACT228*            :DATE-REQUIRED-4675,                                 
ACT228*            :DATE-CREATED-4675,                                  
ACT228*            :WQ-PRIORITY-4675,                                   
ACT228*            :FREE-FORM-DATA-4675,                                
ACT228*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
ACT228        DISPLAY '**  5000-CALL-CSR04675               **'         
ACT228        DISPLAY '**  ERROR CALLING CSR04675 (1)       **'         
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT228*       (:LOC4675)                                                
ACT228*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT228*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT228*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT228        FETCH RESULT_SET_CSR_4675 INTO                            
ACT228           :RETURN-CODE-4675,                                     
ACT228           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT228            IF RETURN-CODE-4675 NOT = 0                           
ACT228               MOVE RETURN-CODE-4675 TO WS-DISPLAY-SQLCODE        
                     DISPLAY '****************************************' 
ACT228               DISPLAY '**  5000-CALL-CSR04675               **'  
ACT228               DISPLAY '**  ERROR CALLING CSR04675 (2)       **'  
                     DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE        
                     DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT        
                     DISPLAY '**  PROCESSING TERMINATED             **' 
                     DISPLAY '****************************************' 
                     PERFORM 9900-ABEND THRU 9900-ABEND-EXIT            
                  END-IF                                                
               WHEN OTHER                                               
ACT228             MOVE RETURN-CODE-4675 TO WS-DISPLAY-SQLCODE          
                   DISPLAY '****************************************'   
ACT228             DISPLAY '**  5000-CALL-CSR04675                **'   
ACT228             DISPLAY '**  ERROR CALLING CSR04675 (3)        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6530-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           IF MI-TRAN-APPL-NO = 1                                       
              PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT         
           ELSE                                                         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT
           END-IF.        
                                                                        
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6540-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO,                                   
                   DATE_TRANS,                                          
                   CODE_TRAN_TYPE,                                      
                   RESP_AREA_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   PREMISE_NO,                                          
                   USER_ID,                                             
                   APPL_PROGRAM_ID,                                     
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                   
                   IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                   :MH-CODE-TRAN-TYPE,                                  
                   :MH-RESP-AREA-ID,                                    
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,                                     
                   :MH-PREMISE-NO,                                      
                   :MH-USER-ID,                                         
                   :MH-APPL-PROGRAM-ID,                                 
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO,                                           
MFA-TR*            DATE_TRANS,                                                  
MFA-TR*            CODE_TRAN_TYPE,                                              
MFA-TR*            RESP_AREA_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            USER_ID,                                                     
MFA-TR*            APPL_PROGRAM_ID,                                             
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO,                                       
MFA-TR*            :MH-DATE-TRANS,                                              
MFA-TR*            :MH-CODE-TRAN-TYPE,                                          
MFA-TR*            :MH-RESP-AREA-ID,                                            
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,                                             
MFA-TR*            :MH-PREMISE-NO,                                              
MFA-TR*            :MH-USER-ID,                                                 
MFA-TR*            :MH-APPL-PROGRAM-ID,                                         
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '** ERROR INSERTING CSS_MNT_TRN_HIST   **'       
               DISPLAY '** ACCOUNT - ' WS-DISPLAY-ACCOUNT               
               DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE               
               DISPLAY '** PROCESSING TERMINATED              **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       6540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6550-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO,                                     
                 TRAN_APPL_NO,                                          
                 COLUMN_DESC,                                           
                 PRV_COLUMN_VALUE,                                      
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),                     
                 :MI-TRAN-APPL-NO,                                      
                 :MI-COLUMN-DESC,                                       
                 :MI-PRV-COLUMN-VALUE,                                  
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*        ( TRANS_HIST_SEQ_NO,                                             
MFA-TR*          TRAN_APPL_NO,                                                  
MFA-TR*          COLUMN_DESC,                                                   
MFA-TR*          PRV_COLUMN_VALUE,                                              
MFA-TR*          CHG_COLUMN_VALUE,                                              
MFA-TR*          TABLE_ID)                                                      
MFA-TR*        VALUES                                                           
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO,                                         
MFA-TR*          :MI-TRAN-APPL-NO,                                              
MFA-TR*          :MI-COLUMN-DESC,                                               
MFA-TR*          :MI-PRV-COLUMN-VALUE,                                          
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                          
MFA-TR*          :MI-TABLE-ID)                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '** ERROR INSERTING CSS_MT_TRN_HST_DET **'       
               DISPLAY '** ACCOUNT - ' WS-DISPLAY-ACCOUNT               
               DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE               
               DISPLAY '** PROCESSING TERMINATED              **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       6550-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE WS-CPD99-RETURN-CODE TO WS-DISPLAY-SQLCODE.             
           MOVE WS-CPD99-PREMISE-NO TO WS-DISPLAY-PREMISE.              
           DISPLAY '****************************************'           
           DISPLAY '**  6990-FETCH-CUR-ACCOUNT           **'            
           DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE                  
           DISPLAY '**  PREMISE = ' WS-DISPLAY-PREMISE                  
           DISPLAY '** ' ABEND-FUNCTION ' ' TABLE-1 ' ' TABLE-2         
           DISPLAY '****************************************'           
           MOVE 'Y' TO WS-CPD99-ERROR.                                  
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO,                                       
                      CUSTOMER_NO,                                      
                      LOCAL_OFFICE,                                     
                      CODE_ACCT_STAT,                                   
                      TOTAL_AR_BALANCE,                                 
                      ACCOUNT_TYPE_CODE,                                
                      BANKRUPTCY_IND,                                   
                      BNKRPT_CASE_NO,                                   
                      JUDGEMENT_IND,                                    
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                      DATE_BILL_DAY_00                                  
                 INTO :AT-PREMISE-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-LOCAL-OFFICE,                                 
                      :AT-CODE-ACCT-STAT,                               
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-ACCOUNT-TYPE-CODE,                            
                      :AT-BANKRUPTCY-IND,                               
                      :AT-BNKRPT-CASE-NO,                               
                      :AT-JUDGEMENT-IND,                                
                      :AT-ACCT-FINALED-DT :WS-NULL-IND-1,                
                      :AT-DATE-BILL-DAY-00 :WS-NULL-IND-2                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               TOTAL_AR_BALANCE,                                         
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               BANKRUPTCY_IND,                                           
MFA-TR*               BNKRPT_CASE_NO,                                           
MFA-TR*               JUDGEMENT_IND,                                            
MFA-TR*               ACCT_FINALED_DT,                                          
MFA-TR*               DATE_BILL_DAY_00                                          
MFA-TR*          INTO :AT-PREMISE-NO,                                           
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-TOTAL-AR-BALANCE,                                     
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-BANKRUPTCY-IND,                                       
MFA-TR*               :AT-BNKRPT-CASE-NO,                                       
MFA-TR*               :AT-JUDGEMENT-IND,                                        
MFA-TR*               :AT-ACCT-FINALED-DT:WS-NULL-IND-1,                        
MFA-TR*               :AT-DATE-BILL-DAY-00:WS-NULL-IND-2                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-1 < 0                                 
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
                   IF WS-NULL-IND-2 < 0                                 
                       MOVE SPACES TO AT-DATE-BILL-DAY-00               
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_ACCOUNT      **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD  = 'DATABASE'                           
                 AND  COMPANY_NO = '01'                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = 'DATABASE'                                   
MFA-TR*          AND  COMPANY_NO = '01'                                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-DATABASE                  
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_DELINQUENCY  **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSXP520'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'PCSXP520'                                  
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 10                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF G6-PARM-DATA(15:6) NUMERIC                        
                       MOVE G6-PARM-DATA(15:6) TO WS-PROCESS-COUNT      
                   ELSE                                                 
                       MOVE 001000 TO WS-PROCESS-COUNT                  
                   END-IF                                               
                   IF WS-PROCESS-COUNT = 999999                         
                       MOVE 999999999 TO WS-PROCESS-ALL                 
                   ELSE                                                 
                       MOVE WS-PROCESS-COUNT TO WS-PROCESS-ALL          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 001000 TO WS-PROCESS-COUNT                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-CHRG-OFF.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :CO-ACCOUNT-NO                                     
                FROM  CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  AMT_TRANS <> 0                                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :CO-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_CHRG_OFF                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  AMT_TRANS = 0                                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-CURRENT-DATE TO WS-TEMP-DATE                 
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'B' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                       MOVE 'BALANCE IN CSS_CHRG_OFF' TO                
                            WS-MAX-TABLE-NAME                           
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CHRG_OFF      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-SELECT-BNK-DRFT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :PB-ACCOUNT-NO                                     
                FROM  CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                  
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :PB-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_PNDNG_BNK_DRFT                                        
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'DATA EXISTS IN CSS_PNDNG_BNK_DRFT' TO      
                             WS-MAX-TABLE-NAME                          
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_PNDNG_BNK_DRFT**'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7230-SELECT-MSTSUB.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-MSTSUB-FL                                      
                FROM  CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                     
               WHERE  SUB_ACCT_NO = :AZ-ACCOUNT-NO                      
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-MSTSUB-FL                                              
MFA-TR*         FROM  CSS_MSTSUB_ACCT                                           
MFA-TR*        WHERE  SUB_ACCT_NO = :AZ-ACCOUNT-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72301                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-MSTSUB-FL                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-MSTSUB-FL                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_MSTSUB_ACCT (S)*'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF WS-MSTSUB-FL = 'N'                                        
               EXEC SQL                                                 
                  SELECT TOP(1) 'Y'                                            
                    INTO :WS-MSTSUB-FL                                  
                    FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                  
                   WHERE MST_ACCT_NO = :AZ-ACCOUNT-NO                   
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT 'Y'                                                    
MFA-TR*             INTO :WS-MSTSUB-FL                                          
MFA-TR*             FROM CSS_MSTSUB_ACCT                                        
MFA-TR*            WHERE MST_ACCT_NO = :AZ-ACCOUNT-NO                           
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 72302                                                
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                  WHEN SUCCESSFUL-CALL                                  
                      MOVE 'Y' TO WS-MSTSUB-FL                          
                  WHEN NOT-FOUND                                        
                      MOVE 'N' TO WS-MSTSUB-FL                          
                  WHEN OTHER                                            
                     MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE   
                     DISPLAY '****************************************' 
                     DISPLAY '**  ERROR SELECTING CSS_MSTSUB_ACCT (M)*' 
                     DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE        
                     DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT        
                     DISPLAY '**  PROCESSING TERMINATED             **' 
                     DISPLAY '****************************************' 
                     PERFORM 9900-ABEND THRU 9900-ABEND-EXIT            
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF WS-MSTSUB-FL = 'Y'                                        
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE > WS-MAX-DATE                            
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'O' TO WS-MAX-REASON-CD                         
                   MOVE 'E' TO WS-MAX-TYPE-CD                           
                   MOVE 'DATA EXISTS IN CSS_MSTSUB_ACCT' TO             
                         WS-MAX-TABLE-NAME                              
                   MOVE 'N' TO WS-ARCHIVE-FL                            
                   MOVE 'Y' TO WS-GENERATE-WQ-FL
               END-IF
           END-IF.                       
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-SELECT-RECONNECT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :DL-ACCOUNT-NO                                     
                FROM  CSS_RECONNECT WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :DL-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_RECONNECT                                             
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7240                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'DATA EXISTS IN CSS_RECONNECT' TO           
                             WS-MAX-TABLE-NAME                          
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_RECONNECT    **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-SELECT-UTIL-BILL.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-UTLREL-FL                                      
                FROM  CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO_DEP = :AZ-ACCOUNT-NO                   
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-UTLREL-FL                                              
MFA-TR*         FROM  CSS_UTL_BILL_REL                                          
MFA-TR*        WHERE  ACCOUNT_NO_DEP = :AZ-ACCOUNT-NO                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72501                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-UTLREL-FL                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-UTLREL-FL                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_UTL_BILL_REL(D)*'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF WS-UTLREL-FL = 'N'                                        
               EXEC SQL                                                 
                  SELECT TOP(1) 'Y'                                            
                    INTO :WS-UTLREL-FL                                  
                    FROM  CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                
                   WHERE  ACCOUNT_NO_MST = :AZ-ACCOUNT-NO               
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT 'Y'                                                    
MFA-TR*             INTO :WS-UTLREL-FL                                          
MFA-TR*             FROM  CSS_UTL_BILL_REL                                      
MFA-TR*            WHERE  ACCOUNT_NO_MST = :AZ-ACCOUNT-NO                       
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 72502                                                
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                  WHEN SUCCESSFUL-CALL                                  
                      MOVE 'Y' TO WS-UTLREL-FL                          
                  WHEN NOT-FOUND                                        
                      MOVE 'N' TO WS-UTLREL-FL                          
                  WHEN OTHER                                            
                     MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE   
                     DISPLAY '****************************************' 
                     DISPLAY '**  ERROR SELECTING CSS_UTL_BILL_REL(M)*' 
                     DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE        
                     DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT        
                     DISPLAY '**  PROCESSING TERMINATED             **' 
                     DISPLAY '****************************************' 
                     PERFORM 9900-ABEND THRU 9900-ABEND-EXIT            
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF WS-UTLREL-FL = 'Y'                                        
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE > WS-MAX-DATE                            
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'O' TO WS-MAX-REASON-CD                         
                   MOVE 'E' TO WS-MAX-TYPE-CD                           
                   MOVE 'DATA EXISTS IN CSS_UTL_BILL_REL' TO            
                         WS-MAX-TABLE-NAME                              
                   MOVE 'N' TO WS-ARCHIVE-FL                            
                   MOVE 'Y' TO WS-GENERATE-WQ-FL
               END-IF
           END-IF.                       
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7260-SELECT-CONTRACT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :CT-ACCOUNT-NO                                     
                FROM  CSS_CONTRACT WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  CODE_CONTRACT_TYPE IN ( 'I', 'J', 'K',            
                                              'L', 'M', 'N',            
                                              'A', 'B', 'O')            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :CT-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_CONTRACT                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  CODE_CONTRACT_TYPE IN ( 'I', 'J', 'K',                    
MFA-TR*                                       'L', 'M', 'N',                    
MFA-TR*                                       'A', 'B', 'O')                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7260                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'E' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'CSS_CONTRACT' TO WS-MAX-TABLE-NAME         
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CONTRACT     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7270-PENDING-XFER.                                               
                                                                        
           SET T1-INDEX TO +1.                                          
           SEARCH T1-CSS-PENDING-XFER                                   
               AT END                                                   
                   MOVE 'N' TO WS-PEND-XFER-FL                          
               WHEN T1-ACCT-XFER-TO (T1-INDEX) = AZ-ACCOUNT-NO          
                   MOVE 'Y' TO WS-PEND-XFER-FL                          
           END-SEARCH.                                                  
                                                                        
           IF WS-PEND-XFER-FL = 'N'                                     
               SET T1-INDEX TO +1                                       
               SEARCH T1-CSS-PENDING-XFER                               
                   AT END                                               
                       MOVE 'N' TO WS-PEND-XFER-FL                      
                   WHEN T1-ACCT-XFER-FROM (T1-INDEX) = AZ-ACCOUNT-NO    
                       MOVE 'Y' TO WS-PEND-XFER-FL                      
               END-SEARCH
           END-IF.                                              
                                                                        
           IF WS-PEND-XFER-FL = 'Y'                                     
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE > WS-MAX-DATE                            
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'O' TO WS-MAX-REASON-CD                         
                   MOVE 'E' TO WS-MAX-TYPE-CD                           
                   MOVE 'DATA EXISTS IN CSS_PENDING_XFER' TO            
                         WS-MAX-TABLE-NAME                              
                   MOVE 'N' TO WS-ARCHIVE-FL                            
                   MOVE 'Y' TO WS-GENERATE-WQ-FL
               END-IF
           END-IF.                       
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7280-SELECT-WQS.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :WQ-ACCOUNT-NO                                     
                FROM  CSS_WQ_ITEMS WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND STATUS IN ('A', 'I')                               
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :WQ-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_WQ_ITEMS                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND STATUS IN ('A', 'I')                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 72801                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-1-MONTH TO WS-TEMP-DATE            
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'U' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'ACTIVE/IN PROCESS WQS EXIST' TO            
                             WS-MAX-TABLE-NAME                          
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_WQ_ITEMS      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7290-SELECT-AR-TRANSHIST.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           TRANS_HIST_SEQ_NO), 121), ' ', '-'), ':', '.')                      
                INTO :AR-TRANS-HIST-SEQ-NO :WS-NULL-IND                  
                FROM  CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(TRANS_HIST_SEQ_NO)                                    
MFA-TR*         INTO :AR-TRANS-HIST-SEQ-NO:WS-NULL-IND                          
MFA-TR*         FROM  CSS_AR_TRANS_HIST                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7290                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND < 0                                   
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE AR-TRANS-HIST-SEQ-NO(1:10) TO AR-DATE-TRANS 
                       IF AR-DATE-TRANS > WS-DATE-MINUS-6-MONTHS        
                           EXEC SQL                                     
                               SELECT
              DATEADD( MONTH, 7, IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) ) )
            INTO
              :WS-AR-DATE-PLUS-7-MONTHS          
                           END-EXEC                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*                    EXEC SQL                                             
MFA-TR*                        VALUES (DATE(:AR-DATE-TRANS) + 7 MONTHS)         
MFA-TR*                         INTO :WS-AR-DATE-PLUS-7-MONTHS                  
MFA-TR*                    END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                           MOVE WS-AR-DATE-PLUS-7-MONTHS TO WS-TEMP-DATE
                           IF WS-TEMP-DATE > WS-MAX-DATE                
                               MOVE 'N' TO WS-ARCHIVE-FL                
                               MOVE 'T' TO WS-MAX-REASON-CD             
                               MOVE 'E' TO WS-MAX-TYPE-CD               
                               MOVE 'TRANS HIST IN LAST 6 MONTHS' TO    
                                    WS-MAX-TABLE-NAME                   
                               MOVE WS-TEMP-DATE TO WS-MAX-DATE         
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_AR_TRANS_HIST **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-REFUND.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :RN-ACCOUNT-NO                                     
                FROM  CSS_REFUND WITH(READUNCOMMITTED)                          
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  ((CHECK_STATUS_CD IN ('R', 'M', 'U'))             
                  OR   (CHECK_STATUS_CD IN ('I', 'A')                   
                 AND MANUAL_INDICATOR <> 'C'))                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :RN-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_REFUND                                                
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  ((CHECK_STATUS_CD IN ('R', 'M', 'U'))                     
MFA-TR*           OR   (CHECK_STATUS_CD IN ('I', 'A')                           
MFA-TR*          AND MANUAL_INDICATOR = 'C'))                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'N' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'REFUND WITH STATUS A, R, I, M, OR U' TO    
                             WS-MAX-TABLE-NAME                          
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_REFUND        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-SELECT-ORDERS.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO                                        
                INTO :VO-PREMISE-NO                                     
                FROM  CSS_SO_DATA WITH(READUNCOMMITTED)                         
               WHERE (ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                  OR  ACCOUNT_NO_PRIOR = :AZ-ACCOUNT-NO)                
                 AND ORDER_STATE_CD NOT IN ('C', 'Z')                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  PREMISE_NO                                                
MFA-TR*         INTO :VO-PREMISE-NO                                             
MFA-TR*         FROM  CSS_SO_DATA                                               
MFA-TR*        WHERE (ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*           OR  ACCOUNT_NO_PRIOR = :AZ-ACCOUNT-NO)                        
MFA-TR*          AND ORDER_STATE_CD NOT IN ('C', 'Z')                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'ORDER NOT CANCELLED OR COMPLETED' TO       
                             WS-MAX-TABLE-NAME                          
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_SO_DATA       **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-SELECT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :AC-ACCOUNT-NO                                     
                FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  (AMT_TRAN_BALANCE <> 0                            
                  OR   AMT_AR_DAY_00 <> 0                               
                  OR   AMT_AR_DAY_30 <> 0                               
                  OR   AMT_AR_DAY_60 <> 0                               
                  OR   AMT_AR_DAY_90 <> 0                               
                  OR   AMT_UNUSED_CR <> 0                               
                  OR   TOT_SUMM_UNBILLED <> 0)                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :AC-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_AR_CNTL                                               
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  (AMT_TRAN_BALANCE = 0                                    
MFA-TR*           OR   AMT_AR_DAY_00 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_30 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_60 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_90 = 0                                       
MFA-TR*           OR   AMT_UNUSED_CR = 0                                       
MFA-TR*           OR   TOT_SUMM_UNBILLED = 0)                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'Q' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'AR CNTL NOT ALL 0' TO WS-MAX-TABLE-NAME    
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_AR_CNTL      **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7330-SELECT-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :DO-ACCOUNT-NO                                     
                FROM  CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  (AMT_DEPOSIT  <> 0                                
                  OR   DEPOSIT_STATUS_CD IN ('A', 'P'))                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :DO-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_DEP_ON_HAND                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  (AMT_DEPOSIT  = 0                                        
MFA-TR*           OR   DEPOSIT_STATUS_CD IN ('A', 'P'))                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7330                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-MAX-TYPE-CD                       
                       MOVE 'NON REFUNDED DEPOSIT' TO WS-MAX-TABLE-NAME 
                       MOVE 'N' TO WS-ARCHIVE-FL                        
                       MOVE 'Y' TO WS-GENERATE-WQ-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_DEP_ON_HAND  **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-SELECT-ATTORNEY.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :KD-ACCOUNT-NO                                     
                FROM  CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                   
               WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                 AND  FW_ACTION_TYPE_CD = 'ATY'                         
                 AND  FW_ACTION_AM > 0                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :KD-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_FIN_WO_ACTION                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*          AND  FW_ACTION_TYPE_CD = 'ATY'                                 
MFA-TR*          AND  FW_ACTION_AM > 0                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-EXEMPTION-FL                          
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_FIN_WO_ACTION  *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-RELEASE-FOR-ARCHIVE.                                        
                                                                        
           MOVE WS-DATE-PLUS-1-MONTH TO AZ-FORECAST-DT.                 
      *    MOVE WS-CURRENT-DATE TO AZ-FORECAST-DT.                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ARCHIVE_FCST                             
                  ( ACCOUNT_NO,                                         
                    FORECAST_TYPE_CD,                                   
                    FORECAST_REASON_CD,                                 
                    FORECAST_DT,                                        
                    ACCT_FINALED_DT,                                    
                    LAST_UPDATE_TS,                                     
                    LAST_UPDATE_USERID)                                 
               VALUES                                                   
                 ( :AZ-ACCOUNT-NO,                                      
                   'A',                                                 
                   :AZ-FORECAST-REASON-CD,                              
                   IIF(TRY_CONVERT(DATE, :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) ),                             
                   CIS.CHAR2TIMESTAMP(:AZ-ACCT-FINALED-DT),                     
                   CIS.CURRENT$TIMESTAMP(),                                   
                   'XP520')                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ARCHIVE_FCST                                     
MFA-TR*           ( ACCOUNT_NO,                                                 
MFA-TR*             FORECAST_TYPE_CD,                                           
MFA-TR*             FORECAST_REASON_CD,                                         
MFA-TR*             FORECAST_DT,                                                
MFA-TR*             ACCT_FINALED_DT,                                            
MFA-TR*             LAST_UPDATE_TS,                                             
MFA-TR*             LAST_UPDATE_USERID)                                         
MFA-TR*        VALUES                                                           
MFA-TR*          ( :AZ-ACCOUNT-NO,                                              
MFA-TR*            'A',                                                         
MFA-TR*            :AZ-FORECAST-REASON-CD,                                      
MFA-TR*            :AZ-FORECAST-DT,                                             
MFA-TR*            :AZ-ACCT-FINALED-DT,                                         
MFA-TR*            CURRENT TIMESTAMP,                                           
MFA-TR*            'XP520')                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_ARCHIVE_FCST  **'   
                   DISPLAY '**  RELEASING ACCOUNT                 **'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-REFORECAST.                                                 
                                                                        
           MOVE WS-MAX-DATE TO AZ-FORECAST-DT.                          
           MOVE WS-MAX-REASON-CD TO AZ-FORECAST-REASON-CD.              
           MOVE WS-MAX-TABLE-NAME TO AZ-REMARKS.                        
           MOVE WS-MAX-TYPE-CD TO AZ-FORECAST-TYPE-CD.                  
                                                                        
           IF AZ-FORECAST-DT > WS-CURRENT-DATE                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-DATE-PLUS-1-MONTH TO AZ-FORECAST-DT
           END-IF.             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ARCHIVE_FCST                             
                  ( ACCOUNT_NO,                                         
                    FORECAST_TYPE_CD,                                   
                    FORECAST_REASON_CD,                                 
                    FORECAST_DT,                                        
                    ACCT_FINALED_DT,                                    
                    LAST_UPDATE_TS,                                     
                    LAST_UPDATE_USERID,                                 
                    REMARKS)                                            
               VALUES                                                   
                 ( :AZ-ACCOUNT-NO,                                      
                   :AZ-FORECAST-TYPE-CD,                                
                   :AZ-FORECAST-REASON-CD,                              
                   IIF(TRY_CONVERT(DATE, :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) ),                             
                   CIS.CHAR2TIMESTAMP(:AZ-ACCT-FINALED-DT),                     
                   CIS.CURRENT$TIMESTAMP(),                                   
                   'XP520',                                             
                   :AZ-REMARKS)                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ARCHIVE_FCST                                     
MFA-TR*           ( ACCOUNT_NO,                                                 
MFA-TR*             FORECAST_TYPE_CD,                                           
MFA-TR*             FORECAST_REASON_CD,                                         
MFA-TR*             FORECAST_DT,                                                
MFA-TR*             ACCT_FINALED_DT,                                            
MFA-TR*             LAST_UPDATE_TS,                                             
MFA-TR*             LAST_UPDATE_USERID,                                         
MFA-TR*             REMARKS)                                                    
MFA-TR*        VALUES                                                           
MFA-TR*          ( :AZ-ACCOUNT-NO,                                              
MFA-TR*            :AZ-FORECAST-TYPE-CD,                                        
MFA-TR*            :AZ-FORECAST-REASON-CD,                                      
MFA-TR*            :AZ-FORECAST-DT,                                             
MFA-TR*            :AZ-ACCT-FINALED-DT,                                         
MFA-TR*            CURRENT TIMESTAMP,                                           
MFA-TR*            'XP520',                                                     
MFA-TR*            :AZ-REMARKS)                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_ARCHIVE_FCST  **'   
                   DISPLAY '**  REFORECASTING DATE                **'   
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-UPDATE-ACCOUNT.                                             
                                                                        
           MOVE WS-EXEMPTION-CD TO AA-ARCHIVE-EXEMPT-CD.                
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ARCHIVE_EXEMPT                           
                  ( ACCOUNT_NO,                                         
                    ARCHIVE_EXEMPT_CD,                                  
                    LAST_UPDATE_USERID,                                 
                    LAST_UPDATE_TS)                                     
               VALUES                                                   
                 ( :AZ-ACCOUNT-NO,                                      
                   :AA-ARCHIVE-EXEMPT-CD,                               
                   'XP520',                                             
                   CIS.CURRENT$TIMESTAMP())                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ARCHIVE_EXEMPT                                   
MFA-TR*           ( ACCOUNT_NO,                                                 
MFA-TR*             ARCHIVE_EXEMPT_CD,                                          
MFA-TR*             LAST_UPDATE_USERID,                                         
MFA-TR*             LAST_UPDATE_TS)                                             
MFA-TR*        VALUES                                                           
MFA-TR*          ( :AZ-ACCOUNT-NO,                                              
MFA-TR*            :AA-ARCHIVE-EXEMPT-CD,                                       
MFA-TR*            'XP520',                                                     
MFA-TR*            CURRENT TIMESTAMP)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_ACCOUNT       **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-DELETE-FORECAST.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ARCHIVE_FCST                             
                WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ARCHIVE_FCST                                     
MFA-TR*         WHERE ACCOUNT_NO = :AZ-ACCOUNT-NO                               
MFA-TR*        QUERYNO 8300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-TRANSHIST-FL                          
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-TRANSHIST-FL                          
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_ARCHIVE_FCST  **'    
                   DISPLAY '**  ACCOUNT - ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSXP520 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
