       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSXP515.                                         
COB303 DATE-WRITTEN.  APRIL 24, 2014.                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DELETES THE CONSOLIDATED PREMISES                *        
      *                                                                *        
      *  THIS PROGRAM DELETES FROM CSS_PREMISE                         *        
      *                       CSS_ADDR_FORMATTED                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *     DATE    INITIALS   COMMENTS                                *        
      *  ----------  ------   ---------------------------------------  *        
      *  04/24/2014  SC41135  PROGRAM CREATED.                         *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP515'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR PCSXP515 STARTS HERE'.                  
                                                                        
                                                                        
       01  PROGRAM-NAME                 PIC X(08) VALUE 'PCSXP515'.     
       01  WS-PGRMNAME                  PIC X(08).                      
       01  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.         
      *                                                                         
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
     ****** CSS_ADDR_FORMATTED - DY ******                                      
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_NAME_ACCT_XREF - HT ******                                      
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_PREMISE - PR ******                                             
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
    ********************* CURSORS *********************************             
           EXEC SQL                                                     
             DECLARE MAIN-CURSOR CURSOR WITH HOLD FOR                   
               SELECT TOP(10000) PR.PREMISE_NO,
              PR.ADDRESS_ID                                     
               FROM CSS_PREMISE PR                                      
              WHERE NOT EXISTS                                          
               ( SELECT 1                                               
                   FROM CSS_NAME_ACCT_XREF HT                           
                   WHERE HT.PREMISE_NO = PR.PREMISE_NO)                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MAIN-CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT PR.PREMISE_NO,                                            
MFA-TR*               PR.ADDRESS_ID                                             
MFA-TR*        FROM CSS_PREMISE PR                                              
MFA-TR*       WHERE NOT EXISTS                                                  
MFA-TR*        ( SELECT 1                                                       
MFA-TR*            FROM CSS_NAME_ACCT_XREF HT                                   
MFA-TR*            WHERE HT.PREMISE_NO = PR.PREMISE_NO)                         
MFA-TR*        FETCH FIRST 10000 ROWS ONLY                                      
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
           COPY CWS00010.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-DISPLAY-COUNT        PIC S9(9) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-DISPLAY-SQLCODE      PIC -(8)9.                       
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'X515    '.      
           05  WS-NEW-PREM             PIC X(10) VALUE SPACES.          
           05  WS-USERID               PIC X(7).                        
           05  WS-COUNT                PIC S9(04) COMP VALUE 1.         
           05  MULTIPLE-ROWS-SELECTED  PIC S9(09) VALUE -811 COMP.      
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05   S-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE +1.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
          10  S-SP-NAME                 PIC X(18) VALUE SPACES.         
          10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.         
          10  S-SQLSTATE                PIC X(5)  VALUE ' '.            
          10  S-TABLE-NAME              PIC X(18) VALUE SPACES.         
          10  S-HOST-VARIABLES.                                         
              49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.           
              49  S-HOST-VARIABLES-V    PIC X(255).                     
          10  S-SQL-STATEMENT.                                          
              49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.           
              49  S-SQL-STATEMENT-V     PIC X(255).                     
          10  S-SQL-DESCRIPTION.                                        
              49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.           
              49  S-SQL-DESCRIPTION-V   PIC X(255).                     
          10  WS-ABEND-SQLERRMC.                                        
              49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.           
              49  WS-ABEND-SQLERRMC-V   PIC X(255).                     
          10  RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
          10  WS-SQLSTATE               PIC X(05) VALUE SPACES.         
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
            PERFORM 2000-MAIN-PROCESS          THRU 2000-EXIT.          
            MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                      
            DISPLAY 'TOTAL RECORDS = ' WS-DISPLAY-COUNT.                
            STOP RUN.                                                   
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-MAIN-PROCESS                                              *        
      *                                                                *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
              PERFORM 2100-GET-PREMISE-NOS      THRU 2100-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2100-GET-PREMISE-NOS                                           *        
      *                                                                *        
      ******************************************************************        
       2100-GET-PREMISE-NOS.                                            
                                                                        
           MOVE  '2100'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7000-OPEN-PREM-CURSOR     THRU 7000-EXIT.            
           PERFORM 7005-FETCH-PREM-CURSOR    THRU 7005-EXIT             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
             PERFORM 8160-DELETE-PREMISE            THRU 8160-EXIT      
             PERFORM 8170-DELETE-ADDR               THRU 8170-EXIT      
             ADD 1 TO WS-ROW-COUNT                                      
                      WS-COMMIT-COUNT                                   
              IF WS-COMMIT-COUNT > 100 THEN                             
                 EXEC SQL                                               
                   COMMIT                                               
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT                                
              END-IF                                                    
                                                                        
               PERFORM 7005-FETCH-PREM-CURSOR         THRU 7005-EXIT    
             END-PERFORM.                                               
                                                                        
                PERFORM 7010-CLOSE-PREM-CURSOR      THRU 7010-EXIT.     
                                                                        
              EXEC SQL                                                  
                COMMIT                                                  
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-PREM-CURSOR                                          *        
      *                                                                *        
      ******************************************************************        
       7000-OPEN-PREM-CURSOR.                                           
                                                                        
             MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
             EXEC SQL                                                   
                OPEN MAIN-CURSOR                                        
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                   CONTINUE                                             
             ELSE                                                       
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7000-OPEN-PREM-CURSOR             **'   
                   DISPLAY '**  ERROR OPENING  MNT-TRANS   CURSOR **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
              END-IF.                                                   
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7005-FETCH-PREM-CURSOR                                         *        
      *                                                                *        
      ******************************************************************        
       7005-FETCH-PREM-CURSOR.                                          
                                                                        
             MOVE '7005'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              FETCH MAIN-CURSOR                                         
               INTO :PR-PREMISE-NO                                      
                   ,:PR-ADDRESS-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7005-FETCH-PREM-CURSOR            **'   
                   DISPLAY '**  ERROR FETCHING PREM CURSOR        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PREMISE = ' PR-PREMISE-NO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-CLOSE-PREM-CURSOR                                         *        
      *                                                                *        
      ******************************************************************        
       7010-CLOSE-PREM-CURSOR.                                          
                                                                        
             MOVE '7010'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                CLOSE MAIN-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7010-CLOSE-PREM-CURSOR            **'   
                   DISPLAY '**  ERROR CLOSING PREM CURSOR         **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
                                                                        
      ******************************************************************        
      * 8160-DELETE-PREMISE                                            *        
      *                                                                *        
      ******************************************************************        
       8160-DELETE-PREMISE.                                             
                                                                        
             MOVE '8160'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_PREMISE                                  
                  WHERE PREMISE_NO = :PR-PREMISE-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_PREMISE                                          
MFA-TR*           WHERE PREMISE_NO = :PR-PREMISE-NO                             
MFA-TR*        QUERYNO 8160                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
                   CONTINUE                                             
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8160-DELETE-PREMISE               **'       
               DISPLAY '**  ERROR DELETING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PREMISE-NO = ' PR-PREMISE-NO                
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
            END-IF.                                                     
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8170-DELETE-ADDR                                                        
      *                                                                         
      *****************************************************************         
       8170-DELETE-ADDR.                                                
                                                                        
              MOVE '8170'                     TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            EXEC SQL                                                    
                DELETE FROM CSS_ADDR_FORMATTED                          
                   WHERE ADDRESS_ID = :PR-ADDRESS-ID                    
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM CSS_ADDR_FORMATTED                                  
MFA-TR*            WHERE ADDRESS_ID = :PR-ADDRESS-ID                            
MFA-TR*         QUERYNO 8170                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '****************************************'      
                DISPLAY '**  8170-DELETE-ADDR                  **'      
                DISPLAY '**  ERROR DELETING ADDRESS-ID         **'      
                DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE             
                DISPLAY '**  ADDR-ID = ' PR-ADDRESS-ID                  
                DISPLAY '**  PROCESSING TERMINATED             **'      
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                 
           END-IF.                                                      
                                                                        
       8170-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSXP515 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
