       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP512.                                        
       AUTHOR.         PRIYA.                                           
       DATE-WRITTEN.   OCT 2008.                                        
      ******************************************************************00050000
      ******************************************************************00080000
      *                                                               **00090000
      *              PROGRAM  MODIFICATION  LOG                       **00100000
      *    DATE    INITIALS     REASON                                **00110000
      *    ----    --------     ------                                **00120000
      *  23-OCT-08  SP94986     CML A37648-ACT23 (CLONE OF PCSCA277)  **        
ACT074*  26-MAR-15  BD09555     ADD CODE 'D' TO 3-MONTH PURGE CRITERIA**        
ACT074*  A05136-ACT074                                                **        
ACT165*  07-SEP-15  BD09555     ADD 6 MONTHS PURGE CRITERIA FOR       **        
ACT165*  A05136-ACT165          CSS_ACCESS_HISTORY                    **        
      ******************************************************************00130000
      *                                                                *00140000
      *      PURPOSE.                                                  *00150000
      *      THIS PROGRAM DOES DELETION OF RECORDS FROM CSS_BATCH_EMAIL*00160000
      *      TABLE.                                                    *00170000
      *                                                                *00180000
      ***************************************************************** 00190000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                 00220000
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00380000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP512'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                        PIC X(45)                    
           VALUE 'WORKING STORAGE FOR PCSXP512 STARTS HERE'.            
      *                                                                 00430000
       01  WS-PROG-MISC.                                                
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSXP512'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP512'.  
           05  WS-DEL-REC-CNT              PIC S9(09) COMP.             
           05  WS-DEL-REC-CNT-2            PIC S9(09) COMP.             
           05  WS-COMMIT-CNT               PIC S9(09) COMP.             
           05  WS-BATCH-EMAIL-CNT1         PIC S9(09) COMP.             
           05  WS-BATCH-EMAIL-CNT2         PIC S9(09) COMP.             
ACT165     05  WS-ACCESS-HISTORY-CNT       PIC S9(09) COMP.             
           05  WS-PROCESS-DT               PIC X(10).                   
           05  WS-PROCESS-DT1              PIC X(10).                   
ACT165     05  WS-ACCESS-HISTORY-DATE      PIC X(10).                   
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 1000.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 1000.        
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
ACT165     05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE 1000.        
           05  WS-JOB-PARM-MTHS1           PIC 9(03) COMP VALUE 0.      
           05  WS-JOB-PARM-MTHS2           PIC 9(03) COMP VALUE 0.      
           05  WS-BATCH-MTHS1              PIC S9(4) COMP VALUE 0.      
           05  WS-BATCH-MTHS2              PIC S9(4) COMP VALUE 0.      
ACT165     05  WS-ACCESS-HISTORY-MTHS      PIC S9(4) COMP VALUE 0.      
           05  RS-RETURN-CODE              PIC S9(9) VALUE +000 COMP.   
           05  RS-RETURN-CODE-DISP         PIC S9(9) VALUE +000 COMP.   
           05  WS-BATCH-EMAIL-FLAG         PIC X(01) VALUE 'N'.         
               88 BATCH-EMAIL-FG                     VALUE 'Y'.         
ACT165     05  WS-ACCESS-HISTORY-FLAG      PIC X(01) VALUE 'N'.         
ACT165         88 ACCESS-HISTORY                     VALUE 'Y'.         
           05  WS-JOB-PARM-ERR-CODE        PIC 9(02)  VALUE 0.          
      ***** WS FOR JOB PARM DATA OF PURGE VARIABLES. *************              
       COPY CWSPURGE.                                                           
      ******* WS FOR DB2 & CICS ERROR PROCESSING ****************       01210000
       COPY CWS00303.                                                   01220000
      ******* WS-ABEND WORK AREA  ****************                      01240000
       COPY CWS00010.                                                   01250000
      ******* WS-ABEND-SWITCH     ****************                      01300000
       COPY CWS09900.                                                   01310000
      ******* CWS00038 IS JC01 WORK DATA                                        
       COPY CWS00038.                                                           
      ******* FIOJC01 WORKING STORAGE ************                      01330000
       COPY FIOJC01.                                                    01340000
                                                                        
      ******* TABLE DECLARATION FOR SQLCA ****************************  01430000
           EXEC SQL                                                     01390000
                INCLUDE SQLCA                                           01400000
           END-EXEC.                                                    01410000
                                                                        
      ******* TABLE DECLARATION FOR CSS_BATCH_EMAIL ******************  01430000
                                                                        
           EXEC SQL                                                     01450000
                INCLUDE TBBEMAIL                                        01460000
           END-EXEC.                                                    01470000
      *                                                                 01480000
ACT165******* TABLE DECLARATION FOR CSS_ACCESS_HISTORY ***************  01430000
ACT165                                                                  
ACT165     EXEC SQL                                                     01450000
ACT165          INCLUDE TBACCHS                                         01460000
ACT165     END-EXEC.                                                    01470000
      *                                                                 01480000
      ******* TABLE DECLARATION FOR CSS_JOB_PARM      ******************01550000
      *                                                                 01560000
           EXEC SQL                                                     01570000
               INCLUDE TBJBPARM                                         01580000
           END-EXEC.                                                    01590000
                                                                        
ACT165******* CURSOR DECLARATION FOR CSS_ACCESS_HISTORY                 01811000
ACT165     EXEC SQL                                                     
ACT165        DECLARE ACCESS_HISTORY_CSR  CURSOR WITH HOLD FOR          
ACT165        SELECT  CUSTOMER_NO,                                      
ACT165                REPLACE(REPLACE(CONVERT(CHAR(26), ACCESS_TIMESTAMP
           , 121), ' ', '-'), ':', '.') ACCESS_TIMESTAMP                       
ACT165        FROM   CSS_ACCESS_HISTORY WITH(READUNCOMMITTED)                   
ACT165        WHERE  CAST(ACCESS_TIMESTAMP AS DATE) < 
              IIF(TRY_CONVERT(DATE, :WS-ACCESS-HISTORY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ACCESS-HISTORY-DATE
              ) <> 0) OR (LEN(:WS-ACCESS-HISTORY-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-ACCESS-HISTORY-DATE
              ), CONVERT(DATE, :WS-ACCESS-HISTORY-DATE) )   
ACT165        FOR READ ONLY                                     
ACT165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01812000
MFA-TR*       DECLARE ACCESS_HISTORY_CSR  CURSOR WITH HOLD FOR          01813000
MFA-TR*       SELECT  CUSTOMER_NO,                                      01814000
MFA-TR*               ACCESS_TIMESTAMP                                  01815000
MFA-TR*       FROM   CSS_ACCESS_HISTORY                                 01815000
MFA-TR*       WHERE  DATE(ACCESS_TIMESTAMP) < :WS-ACCESS-HISTORY-DATE   01816000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    01817000
      *                                                                         
      ******* CURSOR DECLARATION FOR CSS_BATCH_EMAIL                    01811000
           EXEC SQL                                                     
              DECLARE BATCH_EMAIL_CSR1 CURSOR WITH HOLD FOR             
              SELECT  AE.BATCH_EMAIL_ID                                 
               FROM  CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                   
              WHERE  AE.PROCESSED_DT < IIF(TRY_CONVERT(DATE, 
                                                         :WS-PROCESS-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DT
              ) <> 0) OR (LEN(:WS-PROCESS-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-PROCESS-DT
              ), CONVERT(DATE, :WS-PROCESS-DT) )                   
ACT074          AND  AE.PROCESSED_CD IN ('D', 'R','S')                  
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01812000
MFA-TR*       DECLARE BATCH_EMAIL_CSR1 CURSOR WITH HOLD FOR             01813000
MFA-TR*       SELECT  AE.BATCH_EMAIL_ID                                 01814000
MFA-TR*        FROM  CSS_BATCH_EMAIL AE                                 01815000
MFA-TR*       WHERE  AE.PROCESSED_DT < :WS-PROCESS-DT                   01816000
MFA-TR*         AND  AE.PROCESSED_CD IN ('D', 'R','S')                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    01817000
      **                                                                01940000
      ******* CURSOR DECLARATION FOR CSS_BATCH_EMAIL AFTER 1 YR         01811000
           EXEC SQL                                                     
              DECLARE BTH_EMAIL_CSR2 CURSOR WITH HOLD FOR               
              SELECT  AE.BATCH_EMAIL_ID                                 
               FROM  CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                   
              WHERE  AE.PROCESSED_DT < IIF(TRY_CONVERT(DATE, 
                                                        :WS-PROCESS-DT1
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DT1
              ) <> 0) OR (LEN(:WS-PROCESS-DT1) <> 10), CIS.CHAR2DATE(
                                                        :WS-PROCESS-DT1
              ), CONVERT(DATE, :WS-PROCESS-DT1) )                  
                AND  AE.PROCESSED_CD IN                                 
                             ('B','E','F','H','M','N','Q')              
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01812000
MFA-TR*       DECLARE BTH_EMAIL_CSR2 CURSOR WITH HOLD FOR               01813000
MFA-TR*       SELECT  AE.BATCH_EMAIL_ID                                 01814000
MFA-TR*        FROM  CSS_BATCH_EMAIL AE                                 01815000
MFA-TR*       WHERE  AE.PROCESSED_DT < :WS-PROCESS-DT1                  01816000
MFA-TR*         AND  AE.PROCESSED_CD IN                                         
MFA-TR*                      ('B','E','F','H','M','N','Q')                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    01817000
      *                                                                 01811000
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSXP512 ENDS HERE  '.            
HPCCDM*    EJECT                                                        01970000
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************02000000
      *                                                                *02010000
      *   0000-MAINLINE.                                               *02020000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *02030000
      *                                                                *02040000
      ******************************************************************02050000
       0000-MAINLINE.                                                   
      *                                                                 02070000
           PERFORM 0100-INITIALIZATION    THRU 0100-EXIT.               
           PERFORM 1000-MAIN-PROCESS-PARA THRU 1000-EXIT                
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
           DISPLAY 'PCSXP512 COMPLETED SUCCESSFULLY.'.                  
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02390000
      *                                                                *02400000
      *   0100-INITIALIZATION                                          *02410000
      *        COMMON INITIALIZATION ROUTINE                           *02420000
      *                                                                *02430000
      ***************************************************************** 02440000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
                                                                        
           MOVE SPACES       TO WS-SYSIPT.                              
           MOVE PROGRAM-NAME TO WS-PROGRAM.                             
           MOVE WS-PARM      TO WS-COMMAND.                             
           MOVE ZEROES       TO WS-SEQUENCE.                            
           MOVE WS-KEY-AREA  TO E-FJC01-KEY.                            
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
           PERFORM 0125-READ-FCSJC01   THRU 0125-EXIT                   
               UNTIL END-OF-SYSIPT.                                     
      *                                                                 02473100
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      * READ MONTHS FROM CSS_JOB_PARM                       *                   
      ****************************************************************          
       0125-READ-FCSJC01.                                               
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT.                    
           IF END-OF-SYSIPT                                             
              GO  TO 0125-EXIT                                          
           END-IF.                                                      
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_BATCH_EMAIL   '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA                 TO WS-JOB-PARM-DATA  
                 MOVE WS-JP-PURGE-MO-1             TO WS-JOB-PARM-MTHS1 
                 MOVE WS-JOB-PARM-MTHS1            TO WS-BATCH-MTHS1    
                 MOVE WS-JP-PURGE-MO-2             TO WS-JOB-PARM-MTHS2 
                 MOVE WS-JOB-PARM-MTHS2            TO WS-BATCH-MTHS2    
HONK             IF WS-BATCH-MTHS1 >= 03 AND WS-BATCH-MTHS2 >= 12       
                    MOVE 'Y'              TO WS-BATCH-EMAIL-FLAG        
                    PERFORM 7200-SELECT-PROCESS-DT    THRU 7200-EXIT    
                 ELSE                                                   
                   MOVE   03        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE-1 FROM JOB PARM TBL BTH_EMAIL : '
                           WS-BATCH-MTHS1                               
                   DISPLAY 'MTHS VALUE-2 FROM JOB PARM TBL BTH_EMAIL : '
                           WS-BATCH-MTHS2                               
                   DISPLAY 'NO RECS ARE PROCESSED FOR CSS_BATCH_EMAIL'  
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BATCH_EMAIL - '   
                         'NO RECORDS'                                   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
ACT165     IF WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_ACCESS_HISTORY'     
ACT165        IF INPUT-ACTIVE                                           
ACT165           MOVE G6-PARM-DATA                 TO WS-JOB-PARM-DATA  
ACT165           MOVE WS-JP-PURGE-MO-1             TO WS-JOB-PARM-MTHS1 
ACT165           MOVE WS-JOB-PARM-MTHS1            TO                   
ACT165                WS-ACCESS-HISTORY-MTHS                            
ACT165           IF  WS-ACCESS-HISTORY-MTHS >= 06 AND                   
ACT165               WS-BATCH-MTHS1 <= 36                               
ACT165                  MOVE 'Y'              TO WS-ACCESS-HISTORY-FLAG 
ACT165                  PERFORM 7250-ACCESS-HISTORY-DATE  THRU 7250-EXIT
ACT165           ELSE                                                   
ACT165             MOVE   03        TO  WS-JOB-PARM-ERR-CODE            
ACT165             DISPLAY '       '                                    
ACT165             DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
ACT165             DISPLAY 'MTHS VALUE FROM JOB PARM TBL '              
ACT165                     ' ACCESS HISTORY ' WS-ACCESS-HISTORY-MTHS    
ACT165             DISPLAY 'NO RECS PROCESSED FOR CSS_ACCESS_HISTORY'   
ACT165             DISPLAY '            '                               
ACT165           END-IF                                                 
ACT165        ELSE                                                      
ACT165           DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_ACCESS_HISTORY - '
ACT165                   'NO RECORDS'                                   
ACT165        END-IF                                                    
ACT165     END-IF.                                                      
      *                                                                         
                                                                        
       0125-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************03260000
      * 1000-MAIN-PROCESS-PARA.                                        *03270000
      ******************************************************************03290000
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                 03530000
           IF BATCH-EMAIL-FG                                            
             PERFORM 1100-BTCH-EMAIL-3MNTHS    THRU 1100-EXIT           
             PERFORM 1200-BTCH-EMAIL-12MNTHS   THRU 1200-EXIT           
           END-IF.                                                      
      *                                                                 03530000
ACT165     IF ACCESS-HISTORY                                            
ACT165       PERFORM 1300-ACCESS-HISTORY       THRU 1300-EXIT           
ACT165     END-IF.                                                      
ACT165*                                                                 03530000
           MOVE WS-JOB-PARM-ERR-CODE              TO RETURN-CODE.       
      *                                                                 03530000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03530000
      *                                                                 03530000
      ****************************************************************          
      * PROCESS BATCH EMAIL RECORDS.                                 *          
      * 1100-BTCH-EMAIL-3MNTHS.                                                 
      ****************************************************************          
       1100-BTCH-EMAIL-3MNTHS.                                          
      *                                                                 03530000
             PERFORM 7000-OPEN-BATCH-EMAIL-CSR THRU 7000-EXIT.          
             PERFORM 7010-FETCH-BTH-EMAIL-CSR  THRU 7010-EXIT.          
             PERFORM 2000-PROCESS-RECORDS      THRU 2000-EXIT           
                     UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.           
             PERFORM 7020-CLOSE-BTH-EMAIL-CSR  THRU 7020-EXIT.          
      *                                                                 03530000
             IF WS-DEL-REC-CNT  < WS-CHKP-UPD-LIMIT                     
                PERFORM 8888-COMMIT      THRU 8888-EXIT                 
             END-IF.                                                    
      *                                                                 03530000
           DISPLAY '**NO OF COMMITS TAKEN FOR BTH_EMAIL CSR1  :  '      
                                                  WS-COMMIT-CNT.        
           INITIALIZE WS-COMMIT-CNT.                                    
      *                                                                 03530000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03530000
      ****************************************************************          
      * PROCESS BATCH EMAIL RECORDS.                                 *          
      * 1200-BTCH-EMAIL-12MNTHS.                                                
      ****************************************************************          
       1200-BTCH-EMAIL-12MNTHS.                                         
      *                                                                 03530000
             PERFORM 7100-OPEN-BTH-EMAIL-CSR     THRU 7100-EXIT.        
             PERFORM 7110-FETCH-BTH-EMAIL-CSR    THRU 7110-EXIT.        
             PERFORM 2100-PROCESS-RECORDS        THRU 2100-EXIT         
                     UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.           
             PERFORM 7120-CLOSE-BTH-EMAIL-CSR  THRU 7120-EXIT.          
      *                                                                 03530000
             IF WS-DEL-REC-CNT-2   < WS-CHKP-UPD-LIMIT                  
                PERFORM 8888-COMMIT      THRU 8888-EXIT                 
             END-IF.                                                    
      *                                                                 03530000
           DISPLAY '**NO OF COMMITS TAKEN FOR BTH_EMAIL CSR2  :  '      
                                                 WS-COMMIT-CNT.         
           INITIALIZE WS-COMMIT-CNT.                                    
       1200-EXIT.                                                       
           EXIT.                                                        
ACT165******************************************************************03260000
ACT165* 1300-ACCESS-HISTORY                                            *03270000
ACT165******************************************************************03290000
ACT165 1300-ACCESS-HISTORY.                                             
ACT165       MOVE ZERO TO WS-DEL-REC-CNT.                               
ACT165       PERFORM 7300-OPEN-ACCESS-HISTORY-CSR   THRU 7300-EXIT.     
ACT165       PERFORM 7310-FETCH-ACCESS-HISTORY-CSR  THRU 7310-EXIT.     
ACT165       PERFORM 2200-PROCESS-ACCESS-HISTORY    THRU 2200-EXIT      
ACT165               UNTIL WS-ACTIVE-RETURN-CODE =  NOT-FOUND.          
ACT165       PERFORM 7320-CLOSE-ACCESS-HISTORY-CSR  THRU 7320-EXIT.     
ACT165*                                                                 03530000
ACT165       IF WS-DEL-REC-CNT  < WS-CHKP-UPD-LIMIT                     
ACT165          PERFORM 8888-COMMIT      THRU 8888-EXIT                 
ACT165       END-IF.                                                    
ACT165*                                                                 03530000
ACT165     DISPLAY '**NO OF COMMITS TAKEN FOR ACCESS HIST     :  '      
ACT165                                            WS-COMMIT-CNT.        
ACT165     INITIALIZE WS-COMMIT-CNT.                                    
ACT165 1300-EXIT.                                                       
ACT165     EXIT.                                                        
      *                                                                 03530000
      ******************************************************************03740000
      *       2000-PROCESS-RECORDS.                                    *03760000
      ******************************************************************03800000
       2000-PROCESS-RECORDS.                                            
                                                                        
           PERFORM 8400-DELETE-BATCH-EMAIL THRU 8400-EXIT.              
                                                                        
           IF WS-DEL-REC-CNT = WS-CHKP-UPD-LIMIT                        
              PERFORM 8888-COMMIT      THRU 8888-EXIT                   
              DISPLAY 'COMMIT POINT # ' WS-COMMIT-CNT  ' TAKEN.'        
              MOVE ZEROES              TO WS-DEL-REC-CNT                
           END-IF.                                                      
                                                                        
           PERFORM 7010-FETCH-BTH-EMAIL-CSR THRU 7010-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ***************************************************************** *       
      *       2100-PROCESS-RECORDS.                                     *       
      ***************************************************************** *       
       2100-PROCESS-RECORDS.                                            
                                                                        
           PERFORM 8500-DELETE-BATCH-EMAIL THRU 8500-EXIT.              
                                                                        
           IF WS-DEL-REC-CNT-2 = WS-CHKP-UPD-LIMIT                      
              PERFORM 8888-COMMIT      THRU 8888-EXIT                   
              DISPLAY 'COMMIT POINT # ' WS-COMMIT-CNT  ' TAKEN.'        
              MOVE ZEROES              TO WS-DEL-REC-CNT-2              
           END-IF.                                                      
                                                                        
           PERFORM 7110-FETCH-BTH-EMAIL-CSR THRU 7110-EXIT.             
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03530000
ACT165******************************************************************03740000
ACT165*       2200-PROCESS-ACCESS-HISTORY.                             *03760000
ACT165******************************************************************03800000
ACT165 2200-PROCESS-ACCESS-HISTORY.                                     
ACT165                                                                  
ACT165     PERFORM 8600-DELETE-ACCESS-HISTORY THRU 8600-EXIT.           
ACT165                                                                  
ACT165     IF WS-DEL-REC-CNT   = WS-CHKP-UPD-LIMIT                      
ACT165        PERFORM 8888-COMMIT      THRU 8888-EXIT                   
ACT165        DISPLAY 'COMMIT POINT # ' WS-COMMIT-CNT  ' TAKEN.'        
ACT165        MOVE ZEROES              TO WS-DEL-REC-CNT                
ACT165     END-IF.                                                      
ACT165                                                                  
ACT165     PERFORM 7310-FETCH-ACCESS-HISTORY-CSR THRU 7310-EXIT.        
ACT165                                                                  
ACT165 2200-EXIT.                                                       
ACT165     EXIT.                                                        
                                                                        
      ****************************************************************  05160000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  05170000
      **  *RETRIEVE COMMIT COUNT DETAILS FROM JOB PARM TABLE.        *  05170000
      ****************************************************************  05180000
            EXEC SQL                                                    05190000
                INCLUDE CPD00034                                        05200000
            END-EXEC.                                                   05210000
      *                                                                 05220000
      ******************************************************************05330000
      * 7000-OPEN-BATCH-EMAIL-CSR                                      *05340000
      *  OPENS THE CURSOR FOR PROCESSING CSS_BATCH_EMAIL TABLE.        *05350000
      ******************************************************************05370000
       7000-OPEN-BATCH-EMAIL-CSR.                                       
      *                                                                 05390000
           EXEC SQL                                                     
               OPEN BATCH_EMAIL_CSR1                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7000-OPEN-BATCH-EMAIL-CSR '                     
               DISPLAY '*  BATCH-EMAIL-ID   : ' AE-BATCH-EMAIL-ID       
               DISPLAY '*  PROCESSED DATE   : ' WS-PROCESS-DT           
               DISPLAY '*  SQLCODE        : ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05530000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05560000
      ******************************************************************05570000
      *                                                                *05580000
      *   7010-FETCH-BTH-EMAIL-CSR.                                    *05590000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR OF            *05600000
      *        CSS_BATCH_EMAIL TABLE.                                  *05610000
      ******************************************************************05620000
       7010-FETCH-BTH-EMAIL-CSR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH BATCH_EMAIL_CSR1                                   
               INTO :AE-BATCH-EMAIL-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
                  DISPLAY '****************************************'    
                  DISPLAY '*       7010-FETCH-BTH-EMAIL-CSR       *'    
                  DISPLAY '*  BATCH-EMAIL-ID   : ' AE-BATCH-EMAIL-ID    
                  DISPLAY '*  PROCESSED DATE   : ' WS-PROCESS-DT        
                  DISPLAY '*  SQLCODE          : ' WS-ACTIVE-RETURN-CODE
                  DISPLAY '*       PROGRAM ABORTING...            *'    
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                 05860000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05890000
      ******************************************************************05900000
      *   7050-CLOSE-CURSOR.                                           *05910000
      *        CLOSES THE OPENED CURSOR OF CSS_BATCH_EMAIL TABLE.      *05920000
      ******************************************************************05930000
       7020-CLOSE-BTH-EMAIL-CSR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE BATCH_EMAIL_CSR1                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7020-CLOSE-BTH-EMAIL-CSR'                       
               DISPLAY '*  BATCH-EMAIL-ID   : ' AE-BATCH-EMAIL-ID       
               DISPLAY '*  PROCESSED DATE   : ' WS-PROCESS-DT           
               DISPLAY '*  SQLCODE          : ' WS-ACTIVE-RETURN-CODE   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 06430000
      ******************************************************************05330000
      * 7100-OPEN-BTH-EMAIL-CSR                                        *05340000
      *  OPENS THE CURSOR FOR PROCESSING CSS_BATCH_EMAIL TABLE.        *05350000
      ******************************************************************05370000
       7100-OPEN-BTH-EMAIL-CSR.                                         
      *                                                                 05390000
           EXEC SQL                                                     
               OPEN BTH_EMAIL_CSR2                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7100-OPEN-BTH-EMAIL-CSR '                       
               DISPLAY '*  BATCH-EMAIL-ID   : ' AE-BATCH-EMAIL-ID       
               DISPLAY '*  PROCESSED DATE   : ' WS-PROCESS-DT           
               DISPLAY '*  SQLCODE        : ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05530000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05560000
      ******************************************************************05570000
      *                                                                *05580000
      *   7110-FETCH-BTH-EMAIL-CSR.                              *      05590000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR OF            *05600000
      *        CSS_BATCH_EMAIL TABLE.                                  *05610000
      ******************************************************************05620000
       7110-FETCH-BTH-EMAIL-CSR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH BTH_EMAIL_CSR2                                     
               INTO :AE-BATCH-EMAIL-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
                  DISPLAY '****************************************'    
                  DISPLAY '*       7010-FETCH-BTH-EMAIL-CSR       *'    
                  DISPLAY '*  BATCH-EMAIL-ID   : ' AE-BATCH-EMAIL-ID    
                  DISPLAY '*  PROCESSED DATE   : ' WS-PROCESS-DT        
                  DISPLAY '*  SQLCODE          : ' WS-ACTIVE-RETURN-CODE
                  DISPLAY '*       PROGRAM ABORTING...            *'    
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                 05860000
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05890000
      ******************************************************************05900000
      *   7120-CLOSE-BTH-EMAIL-CSR.                                *    05910000
      *        CLOSES THE OPENED CURSOR OF CSS_BATCH_EMAIL TABLE.      *05920000
      ******************************************************************05930000
       7120-CLOSE-BTH-EMAIL-CSR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE BTH_EMAIL_CSR2                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7120-CLOSE-BTH-EMAIL-CSR'                       
               DISPLAY '*  BATCH-EMAIL-ID   : ' AE-BATCH-EMAIL-ID       
               DISPLAY '*  PROCESSED DATE   : ' WS-PROCESS-DT           
               DISPLAY '*  SQLCODE          : ' WS-ACTIVE-RETURN-CODE   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 06431000
      * 7200-SELECT-PROCESS-DT.                                       * 06433000
      * CALCULATES THE PROCESSED DT.                                  * 06433000
      ***************************************************************** 06434000
       7200-SELECT-PROCESS-DT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, -:WS-BATCH-MTHS1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ),
              DATEADD( MONTH, -:WS-BATCH-MTHS2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-PROCESS-DT,
              :WS-PROCESS-DT1               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     02669100
MFA-TR*       SET :WS-PROCESS-DT   =  CURRENT DATE -                    02669200
MFA-TR*                            :WS-BATCH-MTHS1 MONTHS               02669300
MFA-TR*          ,:WS-PROCESS-DT1  =  CURRENT DATE -                    02669200
MFA-TR*                            :WS-BATCH-MTHS2 MONTHS               02669300
MFA-TR*    END-EXEC.                                                    02669400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           DISPLAY 'PROCESSING RECORDS FOR PROCESSED_CD IN (D,R,S) < '  
                                                     WS-PROCESS-DT      
           DISPLAY 'PROCESSING RECORDS FOR REST OF PROCESSED_CD    < '  
                                                     WS-PROCESS-DT1     
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
                DISPLAY '*******************************************'   
                DISPLAY '** ERROR IN 7200-SELECT-PROCESS-DT.      **'   
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '** BATCH EMAIL ID' AE-BATCH-EMAIL-ID           
                DISPLAY '** PROCESS DT    ' WS-PROCESS-DT               
                DISPLAY '** NO OF MONTHS - 1ST' WS-BATCH-MTHS1          
                DISPLAY '** NO OF MONTHS - 2ND' WS-BATCH-MTHS2          
                DISPLAY '**        PROCESSING IS TERMINATED       **'   
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT165 7250-ACCESS-HISTORY-DATE.                                        
ACT165                                                                  
ACT165     EXEC SQL                                                     
ACT165        SELECT
              DATEADD( MONTH, -:WS-ACCESS-HISTORY-MTHS, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-ACCESS-HISTORY-DATE 
ACT165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     02669100
MFA-TR*       SET :WS-ACCESS-HISTORY-DATE = CURRENT DATE -              02669200
MFA-TR*                                  :WS-ACCESS-HISTORY-MTHS MONTHS 02669300
MFA-TR*    END-EXEC.                                                    02669400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165                                                                  
ACT165     DISPLAY 'PROCESSING RECORDS FOR ACCESS HISTORY          < '  
ACT165                                         WS-ACCESS-HISTORY-DATE   
ACT165     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT165                                                                  
ACT165     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT165        NEXT SENTENCE                                             
ACT165     ELSE                                                         
ACT165          DISPLAY '*******************************************'   
ACT165          DISPLAY '** ERROR IN 7250-ACCESS-HISTORY-DATE     **'   
ACT165          DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
ACT165          DISPLAY '** PROCESS DT    ' WS-PROCESS-DT               
ACT165          DISPLAY '** NO OF MONTHS - 1ST' WS-BATCH-MTHS1          
ACT165          DISPLAY '** NO OF MONTHS - 2ND' WS-BATCH-MTHS2          
ACT165          DISPLAY '**        PROCESSING IS TERMINATED       **'   
ACT165          DISPLAY '*******************************************'   
ACT165          PERFORM 9900-ABEND                THRU 9900-EXIT        
ACT165     END-IF.                                                      
ACT165                                                                  
ACT165 7250-EXIT.                                                       
ACT165     EXIT.                                                        
                                                                        
ACT165 7300-OPEN-ACCESS-HISTORY-CSR.                                    
ACT165*                                                                 05390000
ACT165     EXEC SQL                                                     
ACT165         OPEN ACCESS_HISTORY_CSR                                  
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165                                                                  
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165                                                                  
ACT165     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT165         NEXT SENTENCE                                            
ACT165     ELSE                                                         
ACT165         DISPLAY '7300-OPEN-ACCESS-HISTORY-CSR '                  
ACT165         DISPLAY '*  PROCESSED DATE   : ' WS-PROCESS-DT           
ACT165         DISPLAY '*  SQLCODE        : ' WS-ACTIVE-RETURN-CODE     
ACT165         PERFORM 9900-ABEND THRU 9900-EXIT                        
ACT165     END-IF.                                                      
ACT165*                                                                 05530000
ACT165 7300-EXIT.                                                       
ACT165     EXIT.                                                        
ACT165*                                                                 05560000
ACT165******************************************************************05570000
ACT165*                                                                *05580000
ACT165*   7310-FETCH-BTH-EMAIL-CSR.                                    *05590000
ACT165*        FETCHES THE RECORD FROM THE OPENED CURSOR OF            *05600000
ACT165*        CSS_ACCESS_HISTORY TABLE                                *05610000
ACT165******************************************************************05620000
ACT165 7310-FETCH-ACCESS-HISTORY-CSR.                                   
ACT165                                                                  
ACT165     EXEC SQL                                                     
ACT165         FETCH ACCESS_HISTORY_CSR                                 
ACT165         INTO :HS-CUSTOMER-NO,                                    
ACT165              :HS-ACCESS-TIMESTAMP                                
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165                                                                  
ACT165     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT165         NEXT SENTENCE                                            
ACT165     ELSE                                                         
ACT165        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
ACT165           NEXT SENTENCE                                          
ACT165        ELSE                                                      
ACT165            DISPLAY '****************************************'    
ACT165            DISPLAY '*       7310-FETCH-ACCESS-HISTORY-CSR  *'    
ACT165            DISPLAY '* LAST ITEM FETCHED: ' HS-ACCESS-TIMESTAMP   
ACT165                    ' ' HS-CUSTOMER-NO                            
ACT165            DISPLAY '*  SQLCODE          : ' WS-ACTIVE-RETURN-CODE
ACT165            DISPLAY '*       PROGRAM ABORTING...            *'    
ACT165            DISPLAY '****************************************'    
ACT165            PERFORM 9900-ABEND               THRU 9900-EXIT       
ACT165         END-IF                                                   
ACT165     END-IF.                                                      
ACT165*                                                                 05860000
ACT165 7310-EXIT.                                                       
ACT165     EXIT.                                                        
ACT165*                                                                 05890000
ACT165******************************************************************05900000
ACT165*   7320-CLOSE-ACCESS-HISTORY-CSR                                *05910000
ACT165*        CLOSES THE OPENED CURSOR OF CSS_ACCESS-HISTORY TABLE.   *05920000
ACT165******************************************************************05930000
ACT165 7320-CLOSE-ACCESS-HISTORY-CSR.                                   
ACT165                                                                  
ACT165     EXEC SQL                                                     
ACT165         CLOSE ACCESS_HISTORY_CSR                                 
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165                                                                  
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165                                                                  
ACT165     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT165         NEXT SENTENCE                                            
ACT165     ELSE                                                         
ACT165         DISPLAY '7320-CLOSE-ACCESS-HISTORY-CSR'                  
ACT165         DISPLAY '*  SQLCODE          : ' WS-ACTIVE-RETURN-CODE   
ACT165         PERFORM 9900-ABEND THRU 9900-EXIT                        
ACT165     END-IF.                                                      
ACT165                                                                  
ACT165 7320-EXIT.                                                       
ACT165     EXIT.                                                        
                                                                        
      ****************************************************************  05230000
      **  7600-START-FCSJC01                                            05170000
      **  *RETRIEVE PARM DETAILS FROM JOB PARM TABLE.                   05170000
      ****************************************************************  05180000
           EXEC SQL                                                     05240000
                INCLUDE CPD00038                                        05250000
           END-EXEC.                                                    05260000
                                                                        
      ******************************************************************07960000
      *   8400-DELETE-BATCH-EMAIL.                                     *07980000
      *   DELETES THE RECORD FROM CSS_BATCH_EMAIL TABLE.               *07980000
      ******************************************************************07990000
       8400-DELETE-BATCH-EMAIL.                                         
                                                                        
            EXEC SQL                                                    
               DELETE FROM AE                            
               FROM CSS_BATCH_EMAIL AE
               WHERE AE.BATCH_EMAIL_ID = :AE-BATCH-EMAIL-ID             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*     EXEC SQL                                                    08021000
MFA-TR*        DELETE FROM CSS_BATCH_EMAIL AE                           08022000
MFA-TR*        WHERE AE.BATCH_EMAIL_ID = :AE-BATCH-EMAIL-ID             08023000
MFA-TR*     END-EXEC.                                                   08025000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                TO WS-DEL-REC-CNT                   
              ADD +1                TO WS-BATCH-EMAIL-CNT1              
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*       8400-DELETE-BATCH-EMAIL        *'        
              DISPLAY '* BATCH EMAIL ID : ' AE-BATCH-EMAIL-ID           
              DISPLAY '* PROCESSED DATE : ' WS-PROCESS-DT               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     ERROR DELETING RECORDS           *'        
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
            EXIT.                                                       
      *                                                                 09200000
      ******************************************************************07960000
      *   8500-DELETE-BATCH-EMAIL.                                     *07980000
      *   DELETES THE RECORD FROM CSS_BATCH_EMAIL TABLE.               *07980000
      ******************************************************************07990000
       8500-DELETE-BATCH-EMAIL.                                         
                                                                        
            EXEC SQL                                                    
               DELETE FROM AE                            
               FROM CSS_BATCH_EMAIL AE
               WHERE AE.BATCH_EMAIL_ID = :AE-BATCH-EMAIL-ID             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*     EXEC SQL                                                    08021000
MFA-TR*        DELETE FROM CSS_BATCH_EMAIL AE                           08022000
MFA-TR*        WHERE AE.BATCH_EMAIL_ID = :AE-BATCH-EMAIL-ID             08023000
MFA-TR*     END-EXEC.                                                   08025000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                TO WS-DEL-REC-CNT-2                 
              ADD +1                TO WS-BATCH-EMAIL-CNT2              
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*       8500-DELETE-BATCH-EMAIL        *'        
              DISPLAY '* BATCH EMAIL ID : ' AE-BATCH-EMAIL-ID           
              DISPLAY '* PROCESSED DATE : ' WS-PROCESS-DT               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     ERROR DELETING RECORDS           *'        
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
            EXIT.                                                       
ACT165*                                                                         
ACT165 8600-DELETE-ACCESS-HISTORY.                                      
ACT165                                                                  
ACT165      EXEC SQL                                                    
ACT165         DELETE FROM CSS_ACCESS_HISTORY                           
ACT165         WHERE CUSTOMER_NO      = :HS-CUSTOMER-NO AND             
ACT165               ACCESS_TIMESTAMP = CIS.CHAR2TIMESTAMP(
                                                   :HS-ACCESS-TIMESTAMP
              )            
ACT165      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                    08021000
MFA-TR*        DELETE FROM CSS_ACCESS_HISTORY                           08022000
MFA-TR*        WHERE CUSTOMER_NO      = :HS-CUSTOMER-NO AND             08023000
MFA-TR*              ACCESS_TIMESTAMP = :HS-ACCESS-TIMESTAMP            08023000
MFA-TR*     END-EXEC.                                                   08025000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165                                                                  
ACT165     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
ACT165                                                                  
ACT165     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT165        ADD +1                TO WS-DEL-REC-CNT                   
ACT165        ADD +1                TO WS-ACCESS-HISTORY-CNT            
ACT165     ELSE                                                         
ACT165        DISPLAY '****************************************'        
ACT165        DISPLAY '*       8600-DELETE-ACCESS-HISTORY     *'        
ACT165        DISPLAY '* CUSTOMER NO    : ' HS-CUSTOMER-NO              
ACT165        DISPLAY '* TIMESTAMP      : ' HS-ACCESS-TIMESTAMP         
ACT165        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
ACT165        DISPLAY '*     ERROR DELETING RECORDS           *'        
ACT165        DISPLAY '*       PROGRAM ABORTING...            *'        
ACT165        DISPLAY '****************************************'        
ACT165        PERFORM 9900-ABEND               THRU 9900-EXIT           
ACT165     END-IF.                                                      
ACT165                                                                  
ACT165 8600-EXIT.                                                       
ACT165      EXIT.                                                       
      ***************************************************************** 10080000
      * 8888-COMMIT.                                                    10090000
      ***************************************************************** 10110000
       8888-COMMIT.                                                     
                                                                        
            EXEC SQL                                                            
                INCLUDE CPD00047                                                
            END-EXEC.                                                           
                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD +1 TO WS-COMMIT-CNT                                  
            ELSE                                                        
               DISPLAY '****************************************'       
               DISPLAY '*       8888-COMMIT                    *'       
               DISPLAY '*     ERROR COMMITING RECORDS          *'       
               DISPLAY '* BATCH-EMAIL-ID : ' AE-BATCH-EMAIL-ID          
               DISPLAY '*       PROGRAM ABORTING...            *'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10220000
      ******************************************************************10770000
      *  9000-TERMINATE.                                               *10790000
      ******************************************************************10810000
       9000-TERMINATE.                                                  
                                                                        
           IF BATCH-EMAIL-FG                                            
              DISPLAY 'TOT# RECS DELETED FOR BATCH_EMAIL CSR1    :  '   
                                                 WS-BATCH-EMAIL-CNT1    
              DISPLAY 'TOT# RECS DELETED FOR BATCH_EMAIL CSR2    :  '   
                                                 WS-BATCH-EMAIL-CNT2    
           END-IF.                                                      
ACT165     IF ACCESS-HISTORY                                            
ACT165        DISPLAY 'TOT# RECS DELETED FOR ACCESS-HISTORY      :  '   
ACT165                                           WS-ACCESS-HISTORY-CNT  
ACT165     END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11000000
      ** 9700-ABEND.                                                 ** 11010000
      ***************************************************************** 11020000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
                                                                        
      ***************************************************************** 11000000
      ** 9900-ABEND.                                                 ** 11010000
      ***************************************************************** 11020000
                                                                        
           EXEC SQL                                                     11040000
               INCLUDE CPD09900                                         11050000
           END-EXEC.                                                    11060000
