       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP511.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM PURGES HISTORY SERVICE ORDERS.                    **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    05/08    FB        ORIGINAL VERSION                       **         
C37666*    11/08    FB        ADD DELETES FROM CAD_TECH_STATUS AND   **         
C37666*                       CAD_TECH_COMP                          **         
A05317*    10/16    FB        REMOVE REFERENCES TO CAD TABLES        **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP511'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-ROW-COUNT           PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-COUNT-CHAR   PIC X(03) VALUE ZEROES.           
           05  WS-COMMIT-COUNT REDEFINES WS-COMMIT-COUNT-CHAR PIC 9(3). 
           05  WS-COUNT-TO-COMMIT     PIC S9(09) COMP VALUE 0.          
           05  WS-DATE-TRANS          PIC X(10).                        
           05  WS-TS-TRANS            PIC X(26).                        
           05  WS-YEARS-COUNT         PIC 99.                           
           05  WS-YEARS-SQL           PIC S9(04) COMP VALUE +0.         
           05  WS-DISPLAY-SO          PIC 9(13).                        
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTDAT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHSTORD                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE SO_CURSOR CURSOR WITH HOLD FOR                     
               SELECT SERV_ORDER_NO                                     
                 FROM HST_SO_DATA SO                                    
                WHERE COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                 :YV-COMPLETED-DATETIME
              )      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_CURSOR CURSOR WITH HOLD FOR                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          FROM HST_SO_DATA SO                                            
MFA-TR*         WHERE COMPLETED_DATETIME <= :YV-COMPLETED-DATETIME              
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-DATE-TRANS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TS-TRANS                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-TS-TRANS                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7000-SELECT-JOB-PARM THRU 7000-EXIT.                 
           IF WS-YEARS-COUNT NOT NUMERIC                                
               MOVE '04' TO WS-YEARS-COUNT
           END-IF.                             
           MOVE WS-YEARS-COUNT TO WS-YEARS-SQL.                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( YEAR, -
                                                          :WS-YEARS-SQL
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :YV-COMPLETED-DATETIME                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES TIMESTAMP                                                  
MFA-TR*            (CURRENT TIMESTAMP - :WS-YEARS-SQL YEARS)                    
MFA-TR*         INTO :YV-COMPLETED-DATETIME                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  0000-MAINLINE                    **'    
                   DISPLAY '**  ERROR CALCULATING DATE           **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
           IF WS-COMMIT-COUNT-CHAR NOT NUMERIC                          
               MOVE '010' TO WS-COMMIT-COUNT-CHAR
           END-IF.                      
                                                                        
           DISPLAY 'DATE = ' YV-COMPLETED-DATETIME.                     
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                       
           DISPLAY 'TOTAL ORDERS PURGED = ' WS-DISPLAY-COUNT.           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           EXEC SQL                                                     
               OPEN SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH SO_CURSOR                                           
               INTO :YV-SERV-ORDER-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING SO CURSOR         **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000-PURGE-PROCESS THRU 2000-EXIT.                   
                                                                        
           ADD 1 TO WS-COUNT-TO-COMMIT WS-ROW-COUNT.                    
                                                                        
           IF WS-COUNT-TO-COMMIT > WS-COMMIT-COUNT                      
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COUNT-TO-COMMIT
           END-IF.                            
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PURGE-PROCESS.                                              
                                                                        
           MOVE YV-SERV-ORDER-NO TO WS-DISPLAY-SO.                      
                                                                        
           EXEC SQL                                                     
               DELETE FROM HST_RELATED_ORDER                            
                WHERE SERV_ORDER_NO      = :YV-SERV-ORDER-NO            
                   OR RELATED_SRVC_ORDER = :YV-SERV-ORDER-NO            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING HST_RELATED_ORDER  **'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM HST_SO_DATA                                  
                WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING HST_SO_DATA        **'   
                   DISPLAY '**  ORDER - ' WS-DISPLAY-SO                 
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSXP511'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(7:2) TO WS-YEARS-COUNT                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSXP511'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(14:3) TO WS-COMMIT-COUNT-CHAR           
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSXP511 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
