       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP510.                                        
       AUTHOR.         PRIYA.                                           
       DATE-WRITTEN.   DEC 2008.                                        
      ******************************************************************00050000
      ******************************************************************00080000
      *                                                               **00090000
      *              PROGRAM  MODIFICATION  LOG                       **00100000
      *    DATE    INITIALS     REASON                                **00110000
      *    ----    --------     ------                                **00120000
      *  11-FEB-09  SP94986     APPL 37648                            **        
      ******************************************************************00130000
      *               PCSXP510 NARRATIVE                               *00140000
      * THIS PROGRAM DELETES THE RECORDS FROM TABLES                 *          
      * 1.  CSS_ACCT_WHT_CROSS                                       *          
      * 2.  CSS_SEB_MIA_XREF                                         *          
      * 3.  CSS_MKT_TRAN_OUTMF                                       *          
      *         PER THE RULES IN THE INDIVIDUAL CURSORS              *          
      *                                                              *          
      * PURGE CRITERIA CAN BE FOUND IN THE CSS_JOB_PARM TABLE        *          
      * FOR EACH TABLE. TO SAFEGUARD AGAINST JOB PARM ERRORS AND     *          
      * ACCIDENTALY DELETING MORE DATA THAN INTENDED, THE FOLLOWING  *          
      * HARD CODED VALUES HAVE BEEN ESTABLISHED AS MINIMUM VALUES    *          
      * OF DATA THAT CAN BE DELETED FROM EACH TABLE WITHOUT REQUIRING*          
      * A PROGRAMMING CHANGE. JOB PARM MONTHS CAN BE CHANGED TO      *          
      * GREATER THAN THE MINIMUM BUT NOT LESS THAN MINIMUM           *          
      * 1.  CSS_ACCT_WHT_CROSS - 06 MONTHS                           *          
      * 2.  CSS_SEB_MIA_XREF   - 24 MONTHS                           *          
      * 3.  CSS_MKT_TRAN_OUTMF - 24 MONTHS                           *          
      *                                                              *          
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM   *          
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)            *          
      *                                                              *          
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START- NO        *          
      * RESTART IS NEEDED.                                           *          
      *                                                              *          
      * COMMITS ARE TAKEN                                            *          
      ******************************************************************00190000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                 00220000
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00380000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP510'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                        PIC X(45)                    
           VALUE 'WORKING STORAGE FOR PCSXP510 STARTS HERE'.            
      *                                                                 00430000
       01  WS-PROG-MISC.                                                
           05  WS-COMMIT-COUNT            PIC 9(09) VALUE ZEROS.        
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSXP510'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP510'.  
           05  WS-NBR-COMMIT               PIC S9(09) COMP.             
           05  WS-WHT-CRS-DT               PIC X(26).                   
           05  WS-TRANS-OCCURS-TS          PIC X(26).                   
           05  WS-SEB-MIA-XREF-DT          PIC X(26).                   
           05  WS-MKT-TRAN-DT              PIC X(26).                   
           05  WS-WHT-REC-COUNT            PIC S9(09) COMP.             
           05  WS-SEB-XREF-COUNT           PIC S9(09) COMP.             
           05  WS-MKT-TRAN-COUNT           PIC S9(09) COMP.             
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
           05  WS-MONTHS                   PIC X(03) VALUE SPACES.      
           05  WS-MONTHS-VALUE                                          
               REDEFINES WS-MONTHS         PIC 9(03).                   
           05  WS-ACCT-WH-CROSS-MO         PIC S9(3) COMP VALUE 0.      
           05  WS-SEB-MIA-XREF-MO          PIC S9(3) COMP VALUE 0.      
           05  WS-MKT-TRAN-MO              PIC S9(3) COMP VALUE 0.      
           05  WS-WHT-CROSS-FLAG           PIC X(01) VALUE 'N'.         
               88 WHT-CROSS                          VALUE 'Y'.         
           05  WS-SEB-XREF-FLAG            PIC X(01) VALUE 'N'.         
               88 SEB-XREF                           VALUE 'Y'.         
           05  WS-MKT-TRAN-FLAG            PIC X(01) VALUE 'N'.         
               88 MKT-TRAN                           VALUE 'Y'.         
           05  WS-JOB-PARM-ERR-CODE        PIC 9(02) VALUE 0.           
      *                                                                         
      ***** WS FOR JOB PARM DATA OF PURGE VARIABLES. *************              
       COPY CWSPURGE.                                                           
      *                                                                         
      ******* WS FOR DB2 & CICS ERROR PROCESSING ****************       01210000
       COPY CWS00303.                                                   01220000
      ******* WS-ABEND WORK AREA  ****************                      01240000
       COPY CWS00010.                                                   01250000
      ******* WS-ABEND-SWITCH     ****************                      01300000
       COPY CWS09900.                                                   01310000
      ******* CWS00038 IS JC01 WORK DATA                                        
       COPY CWS00038.                                                           
      ******* FIOJC01 WORKING STORAGE ************                      01330000
       COPY FIOJC01.                                                    01340000
      *                                                                 01380000
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     01390000
                INCLUDE SQLCA                                           01400000
           END-EXEC.                                                    01410000
      *                                                                 01380000
      ****************************************************************          
      **   CSS_ACCT_WHT_CROSS - WH                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     01450000
                INCLUDE TBWCACCT                                        01460000
           END-EXEC.                                                    01470000
      *                                                                 01480000
      ****************************************************************          
      **   CSS_SEB_MIA_XREF   - JM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     01450000
                INCLUDE TBMIAXRF                                        01460000
           END-EXEC.                                                    01470000
      *                                                                 01480000
      ****************************************************************          
      **   CSS_MKT_TRAN_OUTMF - TJ                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     01450000
                INCLUDE TBMRKOMF                                        01460000
           END-EXEC.                                                    01470000
      *                                                                 01480000
      ****************************************************************          
      **   CSS_ACCOUNT - AT                                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     01450000
                INCLUDE TBACCT                                          01460000
           END-EXEC.                                                    01470000
      *                                                                 01480000
      ****************************************************************          
      **   CSS_JOB_PARM - G6                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     01570000
               INCLUDE TBJBPARM                                         01580000
           END-EXEC.                                                    01590000
      *                                                                         
      * DECLARE CURSOR FOR CSS_ACCT_WHT_CROSS TABLE                     01811000
                                                                        
           EXEC SQL                                                     
             DECLARE WHT_CROSS_CSR  CURSOR WITH HOLD FOR                
              SELECT WH.ACCOUNT_NO                                      
                    ,WH.PREMISE_NO                                      
              FROM  CSS_ACCT_WHT_CROSS     WH WITH(READUNCOMMITTED)             
                   ,CSS_ACCOUNT            AT WITH(READUNCOMMITTED)             
              WHERE AT.ACCOUNT_NO          = WH.ACCOUNT_NO              
                AND AT.ACCT_FINALED_DT     < CIS.CHAR2TIMESTAMP(
                                                    :AT-ACCT-FINALED-DT
              )        
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE WHT_CROSS_CSR  CURSOR WITH HOLD FOR                        
MFA-TR*       SELECT WH.ACCOUNT_NO                                              
MFA-TR*             ,WH.PREMISE_NO                                              
MFA-TR*       FROM  CSS_ACCT_WHT_CROSS     WH                                   
MFA-TR*            ,CSS_ACCOUNT            AT                                   
MFA-TR*       WHERE AT.ACCOUNT_NO          = WH.ACCOUNT_NO                      
MFA-TR*         AND AT.ACCT_FINALED_DT     < :AT-ACCT-FINALED-DT                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
      * DECLARE CURSOR FOR CSS_SEB_MIA_XREF TABLE                       01811000
                                                                        
           EXEC SQL                                                     
             DECLARE SEB_MIA_XREF  CURSOR WITH HOLD FOR                 
              SELECT JM.AGL_TRACKING_ID                                 
                    ,JM.ACCOUNT_NO                                      
                    ,JM.CUSTOMER_NO                                     
                    ,JM.ACCOUNT_NO                                      
              FROM  CSS_SEB_MIA_XREF JM WITH(READUNCOMMITTED)                   
                   ,CSS_ACCOUNT            AT WITH(READUNCOMMITTED)             
              WHERE AT.ACCOUNT_NO          = JM.ACCOUNT_NO              
                AND AT.ACCT_CREATE_DT      < CIS.CHAR2TIMESTAMP(
                                                     :AT-ACCT-CREATE-DT
              )         
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SEB_MIA_XREF  CURSOR WITH HOLD FOR                         
MFA-TR*       SELECT JM.AGL_TRACKING_ID                                         
MFA-TR*             ,JM.ACCOUNT_NO                                              
MFA-TR*             ,JM.CUSTOMER_NO                                             
MFA-TR*             ,JM.ACCOUNT_NO                                              
MFA-TR*       FROM  CSS_SEB_MIA_XREF JM                                         
MFA-TR*            ,CSS_ACCOUNT            AT                                   
MFA-TR*       WHERE AT.ACCOUNT_NO          = JM.ACCOUNT_NO                      
MFA-TR*         AND AT.ACCT_CREATE_DT      < :AT-ACCT-CREATE-DT                 
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
      * DECLARE CURSOR FOR CSS_MKT_TRAN_OUTMF TABLE                     01811000
                                                                        
           EXEC SQL                                                     
             DECLARE MKT_TRAN_OUTMF CURSOR WITH HOLD FOR                
              SELECT TJ.SEB_ACCT_NO                                     
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           TJ.TRANS_OCCURS_TS, 121), ' ', '-'), ':', '.') 
           TRANS_OCCURS_TS                                 
              FROM  CSS_MKT_TRAN_OUTMF TJ WITH(READUNCOMMITTED)                 
              WHERE TJ.TRANS_OCCURS_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-TRANS-OCCURS-TS
              )           
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MKT_TRAN_OUTMF CURSOR WITH HOLD FOR                        
MFA-TR*       SELECT TJ.SEB_ACCT_NO                                             
MFA-TR*             ,TJ.TRANS_OCCURS_TS                                         
MFA-TR*       FROM  CSS_MKT_TRAN_OUTMF TJ                                       
MFA-TR*       WHERE TJ.TRANS_OCCURS_TS <= :WS-TRANS-OCCURS-TS                   
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSXP510 ENDS HERE  '.            
HPCCDM*    EJECT                                                        01970000
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************02000000
      *   0000-MAINLINE.                                               *02020000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *02030000
      ******************************************************************02050000
       0000-MAINLINE.                                                   
      *                                                                 02070000
           PERFORM 0100-INITIALIZATION    THRU 0100-EXIT.               
           PERFORM 1000-MAIN-PROCESS-PARA THRU 1000-EXIT.               
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
           DISPLAY 'PCSXP510 COMPLETED SUCCESSFULLY.'                   
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02390000
      *                                                                *02400000
      *   0100-INITIALIZATION                                          *02410000
      *        COMMON INITIALIZATION ROUTINE                           *02420000
      *                                                                *02430000
      ***************************************************************** 02440000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE PROGRAM-NAME                 TO WS-PROGRAM.             
           PERFORM 7600P-START-FCSJC01        THRU 7600P-EXIT.          
           PERFORM 0125-READ-FCSJC01          THRU 0125-EXIT.           
           PERFORM 7611P-CLOSE                THRU 7611P-EXIT.          
           PERFORM 7300-SET-PURGE-DATES       THRU 7300-EXIT.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ MONTHS FROM CSS_JOB_PARM                       *                   
      ****************************************************************          
      *                                                                         
       0125-READ-FCSJC01.                                               
      *                                                                         
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD=')               
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD='               
              AND INPUT-ACTIVE                                          
                 MOVE WS-INPUT-DATA-BREAKDOWN(10:4) TO WS-CHKP-UPD-LIMIT
           ELSE                                                         
              MOVE WS-DEFAULT-CHKP-UPD-LIMIT  TO WS-CHKP-UPD-LIMIT      
              DISPLAY '**JOB PARM NOT ACTIVE FOR CHKP-UPD**'            
              DISPLAY '**DEFAULT OF ' WS-CHKP-UPD-LIMIT                 
                      ' WILL BE USED**'                                 
              DISPLAY '**PROCESS CONTINUING**'                          
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_ACCT_WHT_CROSS')     
            OR END-OF-SYSIPT                                            
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_ACCT_WHT_CROSS'     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA              TO WS-JOB-PARM-DATA     
                 MOVE WS-JP-PURGE-MO-1          TO WS-MONTHS-VALUE      
                 MOVE WS-MONTHS-VALUE           TO WS-ACCT-WH-CROSS-MO  
                 IF WS-ACCT-WH-CROSS-MO >= 06                           
                    MOVE 'Y'                    TO WS-WHT-CROSS-FLAG    
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM TBL ACT_WHT_CRS: ' 
                           WS-ACCT-WH-CROSS-MO                          
                   DISPLAY 'NO RECS ARE PROCESSED CSS_ACCT_WHT_CROSS'   
                   DISPLAY '       '                                    
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_ACCT_WHT_CROSS'   
                 DISPLAY 'NO RECS ARE PROCESSED FOR CSS_ACCT_WHT_CROSS' 
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_ACCT_WHT_CROSS'     
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_ACCT_WHT_CROSS'    
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01          THRU 7610P-EXIT UNTIL    
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_SEB_MIA_XREF  ')     
            OR END-OF-SYSIPT                                            
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_SEB_MIA_XREF  '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA              TO WS-JOB-PARM-DATA     
                 MOVE WS-JP-PURGE-MO-1          TO WS-MONTHS-VALUE      
                 MOVE WS-MONTHS-VALUE           TO WS-SEB-MIA-XREF-MO   
                 IF WS-SEB-MIA-XREF-MO >= 24                            
                    MOVE 'Y'                    TO WS-SEB-XREF-FLAG     
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM TBL SEB_MIA_XREF: '
                           WS-SEB-MIA-XREF-MO                           
                   DISPLAY 'NO RECS ARE PROCESSED CSS_SEB_MIA_XREF'     
                   DISPLAY '       '                                    
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_SEB_MIA_XREF'     
                 DISPLAY 'NO RECS ARE PROCESSED FOR CSS_SEB_MIA_XREF'   
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_SEB_MIA_XREF'       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_SEB_MIA_XREF'      
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01          THRU 7610P-EXIT UNTIL    
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_MKT_TRAN_OUTMF')     
            OR END-OF-SYSIPT                                            
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_MKT_TRAN_OUTMF'     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA              TO WS-JOB-PARM-DATA     
                 MOVE WS-JP-PURGE-MO-1          TO WS-MONTHS-VALUE      
                 MOVE WS-MONTHS-VALUE           TO WS-MKT-TRAN-MO       
                 IF WS-MKT-TRAN-MO >= 24                                
                    MOVE 'Y'                    TO WS-MKT-TRAN-FLAG     
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM MKT_TRAN_OUTMF: '  
                           WS-MKT-TRAN-MO                               
                   DISPLAY 'NO RECS ARE PROCESSED CSS_MKT_TRAN_OUTMF'   
                   DISPLAY '       '                                    
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_MKT_TRAN_OUTMF'   
                 DISPLAY 'NO RECS ARE PROCESSED FOR CSS_MKT_TRAN_OUTMF' 
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_MKT_TRAN_OUTMF'     
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_MKT_TRAN_OUTMF'    
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03530000
      ******************************************************************03260000
      * 1000-MAIN-PROCESS-PARA.                                        *03270000
      ******************************************************************03290000
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                 03530000
           IF WHT-CROSS                                                 
              PERFORM 1100-WHT-CROSS-PROCESS      THRU 1100-EXIT        
           END-IF.                                                      
      *                                                                 03530000
           IF SEB-XREF                                                  
              PERFORM 1200-SEB-MIA-XREF-PROCESS   THRU 1200-EXIT        
           END-IF.                                                      
      *                                                                 03530000
           IF MKT-TRAN                                                  
              PERFORM 1300-MKT-TRAN-OUTMF-PROCESS THRU 1300-EXIT        
           END-IF.                                                      
      *                                                                 03530000
           MOVE WS-JOB-PARM-ERR-CODE              TO RETURN-CODE.       
      *                                                                 03530000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03530000
      ****************************************************************          
      * PROCESS WHITE CROSS RECORDS.                                 *          
      * 1100-WHT-CROSS-PROCESS.                                      *          
      ****************************************************************          
       1100-WHT-CROSS-PROCESS.                                          
      *                                                                 03530000
             DISPLAY 'WS-WHT-CRS-DT  ='                                 
                                        WS-WHT-CRS-DT                   
             DISPLAY 'CURRENT TS   - ' WS-ACCT-WH-CROSS-MO ' MONTHS AGO'
             DISPLAY '**********************************************'   
      *                                                                 03530000
             MOVE WS-WHT-CRS-DT               TO AT-ACCT-FINALED-DT     
             INITIALIZE WS-COMMIT-COUNT.                                
             PERFORM 7000-OPEN-WHT-CROSS-CSR   THRU 7000-EXIT.          
             PERFORM 7010-FETCH-WHT-CROSS-CSR  THRU 7010-EXIT.          
             PERFORM 2000-PROCESS-WHT-CROSS    THRU 2000-EXIT           
                     UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.           
             PERFORM 7020-CLOSE-WHT-CROSS-CSR  THRU 7020-EXIT.          
                                                                        
             IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                     
                PERFORM 8888-COMMIT      THRU 8888-EXIT                 
             END-IF.                                                    
             DISPLAY '** NO.OF.COMMITS FOR CSS_ACCT_WHT_CROSS:'         
                                              WS-NBR-COMMIT.            
             DISPLAY '     '.                                           
             INITIALIZE WS-NBR-COMMIT.                                  
      *                                                                 03530000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS CSS_SEB_MIA_XREF.                                    *          
      * 1200-SEB-MIA-XREF-PROCESS.                                   *          
      ****************************************************************          
       1200-SEB-MIA-XREF-PROCESS.                                       
      *                                                                 03530000
             DISPLAY 'WS-SEB-MIA-XREF-DT  ='                            
                                        WS-SEB-MIA-XREF-DT              
             DISPLAY 'CURRENT TS   - ' WS-SEB-MIA-XREF-MO 'MONTHS AGO'  
             DISPLAY '**********************************************'   
      *                                                                 03530000
             MOVE WS-SEB-MIA-XREF-DT          TO AT-ACCT-CREATE-DT      
             INITIALIZE WS-COMMIT-COUNT.                                
             PERFORM 7400-OPEN-SEB-MIA-XREF       THRU 7400-EXIT.       
             PERFORM 7410-FETCH-SEB-MIA-XREF      THRU 7410-EXIT.       
             PERFORM 2100-PROCESS-SEB-MIA-XREF    THRU 2100-EXIT        
                     UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.           
             PERFORM 7420-CLOSE-SEB-MIA-XREF      THRU 7420-EXIT.       
                                                                        
             IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                     
                PERFORM 8888-COMMIT      THRU 8888-EXIT                 
             END-IF.                                                    
      *                                                                 03530000
             DISPLAY '** NO.OF.COMMITS FOR CSS_SEB_MIA_XREF**'          
                                              WS-NBR-COMMIT.            
             DISPLAY '     '.                                           
             INITIALIZE WS-NBR-COMMIT.                                  
      *                                                                 03530000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS CSS_MKT_TRAN_OUTMF                                   *          
      * 1300-MKT-TRAN-OUTMF-PROCESS.                                 *          
      ****************************************************************          
       1300-MKT-TRAN-OUTMF-PROCESS.                                     
      *                                                                 03530000
             DISPLAY 'WS-MKT-TRAN-DT  ='                                
                                        WS-MKT-TRAN-DT                  
             DISPLAY 'CURRENT TS   - ' WS-MKT-TRAN-MO 'MONTHS AGO'      
             DISPLAY '**********************************************'   
      *                                                                 03530000
             MOVE WS-MKT-TRAN-DT              TO WS-TRANS-OCCURS-TS     
             INITIALIZE WS-COMMIT-COUNT.                                
             PERFORM 7500-OPEN-MKT-TRAN-OUTMF     THRU 7500-EXIT.       
             PERFORM 7510-FETCH-MKT-TRAN-OUTMF    THRU 7510-EXIT.       
             PERFORM 2200-PROCESS-MKT-TRAN-OUTMF   THRU 2200-EXIT       
                     UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.           
             PERFORM 7520-CLOSE-MKT-TRAN-OUTMF    THRU 7520-EXIT.       
                                                                        
             PERFORM 8888-COMMIT      THRU 8888-EXIT                    
      *                                                                 03530000
             DISPLAY '** NO.OF.COMMITS FOR CSS_MKT_TRAN_OUTMF **'       
                                              WS-NBR-COMMIT.            
             DISPLAY '     '.                                           
             INITIALIZE WS-NBR-COMMIT.                                  
      *                                                                 03530000
       1300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************03740000
      *       2000-PROCESS-WHT-CROSS.                                  *03760000
      ******************************************************************03800000
       2000-PROCESS-WHT-CROSS.                                          
                                                                        
           PERFORM 8000-DELETE-WHITE-CROSS  THRU 8000-EXIT.             
                                                                        
           IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                       
              PERFORM 8888-COMMIT  THRU 8888-EXIT                       
              INITIALIZE WS-COMMIT-COUNT                                
           END-IF                                                       
                                                                        
           PERFORM 7010-FETCH-WHT-CROSS-CSR  THRU 7010-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 03530000
      ******************************************************************03740000
      *       2100-PROCESS-SEB-MIA-XREF.                               *03760000
      ******************************************************************03800000
       2100-PROCESS-SEB-MIA-XREF.                                       
                                                                        
           PERFORM 8100-DELETE-SEB-MIA-XREF  THRU 8100-EXIT.            
                                                                        
           IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                       
              PERFORM 8888-COMMIT  THRU 8888-EXIT                       
              INITIALIZE WS-COMMIT-COUNT                                
           END-IF                                                       
                                                                        
           PERFORM 7410-FETCH-SEB-MIA-XREF   THRU 7410-EXIT.            
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 03530000
      ******************************************************************03740000
      *       2200-PROCESS-MKT-TRAN-OUTMF.                             *03760000
      ******************************************************************03800000
       2200-PROCESS-MKT-TRAN-OUTMF.                                     
                                                                        
           PERFORM 8200-DELETE-MKT-TRAN-OUTMF  THRU 8200-EXIT.          
                                                                        
           IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                       
              PERFORM 8888-COMMIT  THRU 8888-EXIT                       
              INITIALIZE WS-COMMIT-COUNT                                
           END-IF                                                       
                                                                        
           PERFORM 7510-FETCH-MKT-TRAN-OUTMF   THRU 7510-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05330000
      * 7000-OPEN-WHT-CROSS-CSR1                                       *05340000
      *  OPENS THE CURSOR FOR PROCESSING CSS_ACCT_WHT_CROSSTABLE.     * 05350000
      ******************************************************************05370000
       7000-OPEN-WHT-CROSS-CSR.                                         
      *                                                                 05390000
           EXEC SQL                                                     
               OPEN WHT_CROSS_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7000-OPEN-WHT-CROSS-CSR   '                     
               DISPLAY '*  ACCOUNT NO       : ' WH-ACCOUNT-NO           
               DISPLAY '*  PROCESSED DATE   : ' WS-WHT-CRS-DT           
               DISPLAY '*  SQLCODE        : ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05530000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05560000
      ******************************************************************05570000
      *                                                                *05580000
      *   7010-FETCH-WHT-CROSS-CSR.                                    *05590000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR OF            *05600000
      *        CSS_ACCT_WHT_CROSS TABLE.                               *05610000
      ******************************************************************05620000
       7010-FETCH-WHT-CROSS-CSR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH WHT_CROSS_CSR                                      
               INTO :WH-ACCOUNT-NO                                      
                   ,:WH-PREMISE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*       7010-FETCH-WHT-CROSS-CSR       *'        
              DISPLAY '*  ACCOUNT NO       : ' WH-ACCOUNT-NO            
              DISPLAY '*  PROCESSED DATE   : ' WS-WHT-CRS-DT            
              DISPLAY '*  SQLCODE       : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '****************************************'        
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 05860000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05890000
      ******************************************************************05900000
      *   7020-CLOSE-WHT-CROSS-CSR.                                    *05910000
      *        CLOSES THE OPENED CURSOR OF CSS_ACCT_WHT_CROSS TABLE.   *05920000
      ******************************************************************05930000
       7020-CLOSE-WHT-CROSS-CSR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE WHT_CROSS_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7020-CLOSE-WHT-CROSS-CSR'                       
               DISPLAY '*  ACCOUNT NO       : ' WH-ACCOUNT-NO           
               DISPLAY '*  WHITE CRS DATE   : ' WS-WHT-CRS-DT           
               DISPLAY '*  SQLCODE          : ' WS-ACTIVE-RETURN-CODE   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 06430000
      ******************************************************************05330000
      * 7400-OPEN-SEB-MIA-XREF                                         *05340000
      *  OPENS THE CURSOR FOR PROCESSING CSS_SEB_MIA_XREF              *05350000
      ******************************************************************05370000
       7400-OPEN-SEB-MIA-XREF.                                          
      *                                                                 05390000
           EXEC SQL                                                     
               OPEN SEB_MIA_XREF                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7400-OPEN-SEB-MIA-XREF    '                     
               DISPLAY '*  SQLCODE        : ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05530000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05560000
      ******************************************************************05570000
      *                                                                *05580000
      *   7410-FETCH-SEB-MIA-XREF.                                     *05590000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR OF            *05600000
      *        CSS_SEB_MIA_XREF.                                       *05610000
      ******************************************************************05620000
       7410-FETCH-SEB-MIA-XREF.                                         
                                                                        
           EXEC SQL                                                     
               FETCH SEB_MIA_XREF                                       
               INTO :JM-AGL-TRACKING-ID                                 
                   ,:JM-ACCOUNT-NO                                      
                   ,:JM-CUSTOMER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*       7410-FETCH-SEB-MIA-XREF       *'         
              DISPLAY '*  AGL TRACKING ID  : ' JM-AGL-TRACKING-ID       
              DISPLAY '*  ACCOUNT NO       : ' JM-ACCOUNT-NO            
              DISPLAY '*  CUSTOMER NO      : ' JM-CUSTOMER-NO           
              DISPLAY '*  SQLCODE       : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '****************************************'        
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 05860000
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05890000
      ******************************************************************05900000
      *   7420-CLOSE-SEB_MIA_XREF.                                    * 05910000
      *        CLOSES THE OPENED CURSOR OF CSS_SEB_MIA_XREF            *05920000
      ******************************************************************05930000
       7420-CLOSE-SEB-MIA-XREF.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE SEB_MIA_XREF                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7040-CLOSE-SEB-MIA-XREF'                        
               DISPLAY '*  AGL TRACKING ID  : ' JM-AGL-TRACKING-ID      
               DISPLAY '*  ACCOUNT NO       : ' JM-ACCOUNT-NO           
               DISPLAY '*  CUSTOMER NO      : ' JM-CUSTOMER-NO          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05330000
      * 7500-OPEN-MKT-TRAN-OUTMF                                       *05340000
      *  OPENS THE CURSOR FOR PROCESSING CSS_MKT_TRAN_OUTMF            *05350000
      ******************************************************************05370000
       7500-OPEN-MKT-TRAN-OUTMF.                                        
      *                                                                 05390000
           EXEC SQL                                                     
               OPEN MKT_TRAN_OUTMF                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7500-OPEN-MKT-TRAN-OUTMF  '                     
               DISPLAY '*  SQLCODE        : ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05530000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05560000
      ******************************************************************05570000
      *                                                                *05580000
      *   7510-FETCH-MKT-TRAN-OUTMF.                                   *05590000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR OF            *05600000
      *        CSS_MKT_TRAN_OUTMF.                                     *05610000
      ******************************************************************05620000
       7510-FETCH-MKT-TRAN-OUTMF.                                       
                                                                        
           EXEC SQL                                                     
               FETCH MKT_TRAN_OUTMF                                     
               INTO :TJ-SEB-ACCT-NO                                     
                   ,:TJ-TRANS-OCCURS-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*       7510-FETCH-MKT-TRAN-OUTMF     *'         
              DISPLAY '*  TJ SEB ACCT NO   : ' TJ-SEB-ACCT-NO           
              DISPLAY '*  TRANS OCCURS TS  : ' TJ-TRANS-OCCURS-TS       
              DISPLAY '*  SQLCODE       : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '****************************************'        
                  PERFORM 9900-ABEND               THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 05860000
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05890000
      ******************************************************************05900000
      *   7520-MKT-TRAN-OUTMF.                                   *      05910000
      *        CLOSES THE OPENED CURSOR OF CSS_MKT_TRAN_OUTMF          *05920000
      ******************************************************************05930000
       7520-CLOSE-MKT-TRAN-OUTMF.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE MKT_TRAN_OUTMF                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7520-CLOSE-MKT-TRAN-OUTMF'                      
               DISPLAY '*  TJ SEB ACCT NO   : ' TJ-SEB-ACCT-NO          
               DISPLAY '*  TRANS OCCURS TS  : ' TJ-TRANS-OCCURS-TS      
               DISPLAY '*  SQLCODE       : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '*       PROGRAM ABORTING...            *'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 06431000
      * 7300-SET-PURGE-DATES.                                         * 06433000
      * CALCULATES THE PROCESSED DT.                                  * 06433000
      ***************************************************************** 06434000
       7300-SET-PURGE-DATES.                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -
                                                   :WS-ACCT-WH-CROSS-MO
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -
                                                    :WS-SEB-MIA-XREF-MO
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -
                                                        :WS-MKT-TRAN-MO
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-WHT-CRS-DT,
              :WS-SEB-MIA-XREF-DT,
              :WS-MKT-TRAN-DT      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02669100
MFA-TR*       SET :WS-WHT-CRS-DT       =  CURRENT TIMESTAMP -           02669200
MFA-TR*                                    :WS-ACCT-WH-CROSS-MO MONTHS  02669300
MFA-TR*          ,:WS-SEB-MIA-XREF-DT  =  CURRENT TIMESTAMP -                   
MFA-TR*                                    :WS-SEB-MIA-XREF-MO  MONTHS          
MFA-TR*          ,:WS-MKT-TRAN-DT      =  CURRENT TIMESTAMP  -                  
MFA-TR*                                    :WS-MKT-TRAN-MO  MONTHS              
MFA-TR*    END-EXEC.                                                    02669400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
                DISPLAY '*******************************************'   
                DISPLAY '** ERROR IN 7300-SELECT-PROCESS-DT.      **'   
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '** WHITE CR DT =  ' WS-WHT-CRS-DT              
                DISPLAY '** MIA XREF DT =  ' WS-SEB-MIA-XREF-DT         
                DISPLAY '** MKT TRAN DT =  ' WS-MKT-TRAN-DT             
                DISPLAY '**        PROCESSING IS TERMINATED       **'   
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04920000
      ****************************************************************  05230000
      **  7600P-START-FCSJC01                                           05170000
      **  *RETRIEVE PARM DETAILS FROM JOB PARM TABLE.                   05170000
      ****************************************************************  05180000
           EXEC SQL                                                     05240000
                INCLUDE CPDPURGE                                        05250000
           END-EXEC.                                                    05260000
                                                                        
      ******************************************************************07960000
      *   8000-DELETE-WHITE-CROSS.                                     *07980000
      *   DELETES THE RECORD FROM THE CSS_ACCT_WHT_CROSS  TABLE.       *07980000
      ******************************************************************07990000
       8000-DELETE-WHITE-CROSS.                                         
                                                                        
            EXEC SQL                                                    
              DELETE FROM WH                          
              FROM CSS_ACCT_WHT_CROSS WH
              WHERE WH.ACCOUNT_NO          = :WH-ACCOUNT-NO             
                AND WH.PREMISE_NO          = :WH-PREMISE-NO             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*     EXEC SQL                                                    08021000
MFA-TR*       DELETE FROM CSS_ACCT_WHT_CROSS  WH                                
MFA-TR*       WHERE WH.ACCOUNT_NO          = :WH-ACCOUNT-NO                     
MFA-TR*         AND WH.PREMISE_NO          = :WH-PREMISE-NO                     
MFA-TR*     END-EXEC.                                                   08025000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-COMMIT-COUNT                               
                 ADD 1 TO WS-WHT-REC-COUNT                              
              END-IF                                                    
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*       8000-DELETE-WHITE-CROSS.       *'        
              DISPLAY '* ACCOUNT NO     : ' WH-ACCOUNT-NO               
              DISPLAY '* PROCESSED DATE : ' WS-WHT-CRS-DT               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     ERROR DELETING RECORDS           *'        
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 09200000
      ******************************************************************07960000
      *   8100-DELETE-SEB-MIA-XREF.                                    *07980000
      *   DELETES THE RECORD FROM CSS_SEB_MIA_XREF  TABLE.             *07980000
      ******************************************************************07990000
       8100-DELETE-SEB-MIA-XREF.                                        
                                                                        
            EXEC SQL                                                    
              DELETE FROM JM                            
              FROM CSS_SEB_MIA_XREF JM
              WHERE JM.AGL_TRACKING_ID     = :JM-AGL-TRACKING-ID        
                AND JM.ACCOUNT_NO          = :JM-ACCOUNT-NO             
                AND JM.CUSTOMER_NO         = :JM-CUSTOMER-NO            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*     EXEC SQL                                                    08021000
MFA-TR*       DELETE FROM CSS_SEB_MIA_XREF    JM                                
MFA-TR*       WHERE JM.AGL_TRACKING_ID     = :JM-AGL-TRACKING-ID                
MFA-TR*         AND JM.ACCOUNT_NO          = :JM-ACCOUNT-NO                     
MFA-TR*         AND JM.CUSTOMER_NO         = :JM-CUSTOMER-NO                    
MFA-TR*     END-EXEC.                                                   08025000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-COMMIT-COUNT                               
                 ADD 1 TO WS-SEB-XREF-COUNT                             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*       8100-DELETE-SEB-MIA-XREF.      *'        
              DISPLAY '*  AGL TRACKING ID  : ' JM-AGL-TRACKING-ID       
              DISPLAY '*  ACCOUNT NO       : ' JM-ACCOUNT-NO            
              DISPLAY '*  CUSTOMER NO      : ' JM-CUSTOMER-NO           
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     ERROR DELETING RECORDS           *'        
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************07960000
      *   8200-DELETE-MKT-TRAN-OUTMF.                                  *07980000
      *   DELETES THE RECORD FROM CSS_MKT-TRAN-OUTMF   TABLE.          *07980000
      ******************************************************************07990000
       8200-DELETE-MKT-TRAN-OUTMF.                                      
                                                                        
            EXEC SQL                                                    
              DELETE FROM TJ                          
              FROM CSS_MKT_TRAN_OUTMF TJ
              WHERE TJ.SEB_ACCT_NO         = :TJ-SEB-ACCT-NO            
                AND TJ.TRANS_OCCURS_TS     = CIS.CHAR2TIMESTAMP(
                                                    :TJ-TRANS-OCCURS-TS
              )        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                    08021000
MFA-TR*       DELETE FROM CSS_MKT_TRAN_OUTMF  TJ                                
MFA-TR*       WHERE TJ.SEB_ACCT_NO         = :TJ-SEB-ACCT-NO                    
MFA-TR*         AND TJ.TRANS_OCCURS_TS     = :TJ-TRANS-OCCURS-TS                
MFA-TR*     END-EXEC.                                                   08025000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-COMMIT-COUNT                               
                 ADD 1 TO WS-MKT-TRAN-COUNT                             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '*       8100-DELETE-SEB-MIA-XREF.      *'        
              DISPLAY '*  AGL TRACKING ID  : ' JM-AGL-TRACKING-ID       
              DISPLAY '*  ACCOUNT NO       : ' JM-ACCOUNT-NO            
              DISPLAY '*  CUSTOMER NO      : ' JM-CUSTOMER-NO           
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     ERROR DELETING RECORDS           *'        
              DISPLAY '*       PROGRAM ABORTING...            *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************** 10080000
      * 8888-COMMIT.                                                    10090000
      ***************************************************************** 10110000
       8888-COMMIT.                                                     
                                                                        
            EXEC SQL                                                            
                INCLUDE CPD00047                                                
            END-EXEC.                                                           
                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD +1 TO WS-NBR-COMMIT                                  
            ELSE                                                        
               DISPLAY '****************************************'       
               DISPLAY '*       8888-COMMIT                    *'       
               DISPLAY '*     ERROR COMMITING RECORDS          *'       
               DISPLAY '*    ACCOUNT_NO  : ' WH-ACCOUNT-NO              
               DISPLAY '*       PROGRAM ABORTING...            *'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10220000
      ******************************************************************10770000
      *  9000-TERMINATE.                                               *10790000
      ******************************************************************10810000
       9000-TERMINATE.                                                  
                                                                        
           IF WHT-CROSS                                                 
              DISPLAY 'ACCOUNT DELT FROM CSS_ACCT_WHT_CROSS:'           
                                         WS-WHT-REC-COUNT               
           END-IF.                                                      
      *                                                                 11000000
           IF SEB-XREF                                                  
              DISPLAY 'ACCOUNT DELT FROM CSS_SEB_MIA_XREF  :'           
                                         WS-SEB-XREF-COUNT              
           END-IF.                                                      
      *                                                                 11000000
           IF MKT-TRAN                                                  
              DISPLAY 'ACCOUNT DELT FROM CSS_MKT_TRAN_OUTMF:'           
                                         WS-MKT-TRAN-COUNT              
           END-IF.                                                      
      *                                                                 11000000
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11000000
      ** 9900-ABEND.                                                 ** 11010000
      ***************************************************************** 11020000
                                                                        
           EXEC SQL                                                     11040000
               INCLUDE CPD09900                                         11050000
           END-EXEC.                                                    11060000
