       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP500.                                           
       DATE-WRITTEN.  27 NOV 2008.                                      
       DATE-COMPILED.                                                   
       AUTHOR.   PRIYA.                                                 
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      **                                                             *          
      ** DATE       INITIALS       REASON                            *          
      ** 11/27/08   SP94986        APPL37648-ACT 29,60,62            *          
      **                                                             *          
A04880** 08/01/14   AS7C117        ADDED THE JOB PARM LOGIC FOR      *          
A04880**            #ACT234        MNT_TRANS_CUSTOMER AND            *          
A04880**                           MNT_TRANS_PREMISE                 *          
      ****************************************************************          
      *                   PCSXP500   NARRATIVE                       *          
      *                                                              *          
      * THIS PROGRAM DELETES THE RECORDS FROM THE FOLLOWING TABLE    *          
      * USING THE CSS_CIS_PURGE TABLE. ADDITIONAL LOGIC EXISTS TO    *          
      * PURGE CUSTOMER ONLY AND PREMISE ONLY DATA USING PURGE        *          
      * CRITERIA FOUND IN THE CSS_JOB_PARM TABLE                     *          
      * 1.  CSS_MNT_TRANS_HIST                                       *          
      *                                                              *          
      * PURGE CRITERIA CAN BE FOUND IN THE CSS_JOB_PARM TABLE        *          
      * FOR EACH TABLE. TO SAFEGUARD AGAINST JOB PARM ERRORS AND     *          
      * ACCIDENTALY DELETING MORE DATA THAN INTENDED, THE FOLLOWING  *          
      * HARD CODED VALUES HAVE BEEN ESTABLISHED AS MINIMUM VALUES    *          
      * OF DATA THAT CAN BE DELETED FROM EACH TABLE WITHOUT REQUIRING*          
      * A PROGRAMMING CHANGE. JOB PARM MONTHS CAN BE CHANGED TO      *          
      * GREATER THAN THE MINIMUM BUT NOT LESS THAN MINIMUM           *          
      * 1.  CSS_MNT_TRANS_HIST - 00 MONTHS                           *          
      * 2.  CSS_MNT_TRANS_CUST - 37 MONTHS                           *          
      * 3.  CSS_MNT_TRANS_PREM - 36 MONTHS                           *          
      * 4.  CSS_MNT_TR_NO_ACCT - 12 MONTHS                           *          
      * 5.  CSS_MNT_TR_NO_CUST - 12 MONTHS                           *          
      * 6.  CSS_MNT_TR_NO_PREM - 12 MONTHS                           *          
      *                                                              *          
      * THE CSS_JOB_PARM TABLE HAS AN ENTRY FOR EACH TABLE AND IN    *          
      * ORDER TO BE PROCESSED, THE STATUS ON THE JOB PARM TABLE      *          
      * MUST BE = 'A' (ACTIVE). TO STOP PURGING FROM A PARTICULAR    *          
      * TABLE, THE JOB PARM STATUS SHOULD BE SET TO 'I'              *          
      *                                                              *          
      * FOR LAST RUN DATE THE ACCOUNT NO AND PURGE DATE ALONG        *          
      * WITH RULES IN THE INDIVIDUAL CURSORS ARE USED TO DETERMINE   *          
      * THE DATA TO BE PURGED.                                       *          
      *                                                              *          
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START -          *          
      * RESTART IS NOT NEEDED.                                      *           
      *                                                              *          
      * COMMITS ARE TAKEN                                            *          
      ****************************************************************          
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP500'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZEROS.       
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(4)  VALUE ZEROS.       
           05  WS-COMMIT-COUNT             PIC 9(4)  VALUE ZEROS.       
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-MNT-CNT                  PIC 9(9)  VALUE ZEROS.       
           05  WS-MNT-CNT1                 PIC 9(9)  VALUE ZEROS.       
           05  WS-MNT-CUST-CNT             PIC 9(9)  VALUE ZEROS.       
           05  WS-MNT-PREM-CNT             PIC 9(9)  VALUE ZEROS.       
           05  WS-MNT-NO-ACC-CNT           PIC 9(9)  VALUE ZEROS.       
           05  WS-MNT-NO-CUS-CNT           PIC 9(9)  VALUE ZEROS.       
           05  WS-MNT-NO-PRE-CNT           PIC 9(9)  VALUE ZEROS.       
           05  WS-NBR-COMMIT               PIC 9(9)  VALUE ZEROS.       
           05  WS-CURRENT-RUN-TS           PIC X(26) VALUE SPACES.      
           05  WS-TRNS-CUST-SQ-DEL-DATE    PIC X(26) VALUE SPACES.      
           05  WS-TRNS-PREM-SQ-DEL-DATE    PIC X(26) VALUE SPACES.      
           05  WS-TRNS-NO-ACC-DEL-DATE     PIC X(26) VALUE SPACES.      
           05  WS-TRNS-NO-CUS-DEL-DATE     PIC X(26) VALUE SPACES.      
           05  WS-TRNS-NO-PRE-DEL-DATE     PIC X(26) VALUE SPACES.      
           05  WS-MNT-TRANS-FLAG           PIC X(01) VALUE 'N'.         
               88 MNT-TRANS-FLAG                     VALUE 'Y'.         
           05  WS-MNT-TRANS-CUST           PIC X(01) VALUE 'N'.         
               88 MNT-TRANS-CUST                     VALUE 'Y'.         
           05  WS-MNT-TRANS-PREM           PIC X(01) VALUE 'N'.         
               88 MNT-TRANS-PREM                     VALUE 'Y'.         
           05  WS-MNT-TRANS-ORGH-ACC       PIC X(01) VALUE 'N'.         
               88 MNT-TRANS-ORPH-ACT                 VALUE 'Y'.         
           05  WS-MNT-TRANS-ORGH-CUS       PIC X(01) VALUE 'N'.         
               88 MNT-TRANS-ORPH-CUS                 VALUE 'Y'.         
           05  WS-MNT-TRANS-ORGH-PRE       PIC X(01) VALUE 'N'.         
               88 MNT-TRANS-ORPH-PRE                 VALUE 'Y'.         
           05  WS-MONTHS                   PIC X(03) VALUE SPACES.      
           05  WS-MONTHS-VALUE             REDEFINES WS-MONTHS          
                                           PIC 9(03).                   
           05  WS-DEL-MONTHS-CUST          PIC S9(3) COMP VALUE 0.      
           05  WS-DEL-MONTHS-PREM          PIC S9(3) COMP VALUE 0.      
           05  WS-DEL-NO-ACC-MONTHS        PIC S9(3) COMP VALUE 0.      
           05  WS-DEL-NO-CUS-MONTHS        PIC S9(3) COMP VALUE 0.      
           05  WS-DEL-NO-PRE-MONTHS        PIC S9(3) COMP VALUE 0.      
           05  WS-DIS-RETURN-CODE          PIC -9(9).                   
           05  WS-JOB-PARM-ERR-CODE        PIC 9(02) VALUE 0.           
                                                                        
       01 WS-PARM-DATA.                                                 
          05 FILLER                  PIC X(20) VALUE                    
                                               'LAST RUN TIME STAMP='.  
          05 WS-PGM-LAST-RUN-TS      PIC X(26) VALUE SPACES.            
          05 FILLER                  PIC X(36) VALUE SPACES.            
      *                                                                         
       01  WS-PGRMNAME                     PIC X(8)  VALUE 'PCSXP500'.  
      *                                                                         
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_JOB_PARM - G6                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_MNT_TRANS_HIST - MH                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_CIS_PURGE                                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPURGE                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                       *          
      ****************************************************************          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
       COPY CWSPURGE.                                                           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *****************************************************************         
      * DECLARE CURSOR FOR MNT_TRANS_TYPE_B                           *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
             DECLARE MNT_TRANS_TYPE_B CURSOR WITH HOLD FOR              
              SELECT PU.ACCOUNT_NO                                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), PU.PURGE_TS
           , 121), ' ', '-'), ':', '.') PURGE_TS                               
                FROM CSS_CIS_PURGE     PU WITH(READUNCOMMITTED)                 
               WHERE PU.LAST_UPDATE_TS  >= CIS.CHAR2TIMESTAMP(
                                                     :PU-LAST-UPDATE-TS
              )           
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MNT_TRANS_TYPE_B CURSOR WITH HOLD FOR                      
MFA-TR*       SELECT PU.ACCOUNT_NO                                              
MFA-TR*             ,PU.PURGE_TS                                                
MFA-TR*         FROM CSS_CIS_PURGE     PU                                       
MFA-TR*        WHERE PU.LAST_UPDATE_TS  >= :PU-LAST-UPDATE-TS                   
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE MNT_TRANS_CUSTOMER CURSOR WITH HOLD FOR            
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
               FROM CSS_MNT_TRANS_HIST MH                               
               WHERE MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                              :WS-TRNS-CUST-SQ-DEL-DATE
              )  
                 AND MH.PREMISE_NO      = 0                             
                 AND MH.CUSTOMER_NO     > 0                             
                 AND MH.ACCOUNT_NO      = 0                             
                 AND NOT EXISTS(SELECT CK.CUSTOMER_NO                   
                                   FROM CSS_CREDIT_HIST CK              
                                WHERE CK.CUSTOMER_NO = MH.CUSTOMER_NO)  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MNT_TRANS_CUSTOMER CURSOR WITH HOLD FOR                    
MFA-TR*        SELECT MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*        FROM CSS_MNT_TRANS_HIST MH                                       
MFA-TR*        WHERE MH.TRANS_HIST_SEQ_NO <= :WS-TRNS-CUST-SQ-DEL-DATE          
MFA-TR*          AND MH.PREMISE_NO      = 0                                     
MFA-TR*          AND MH.CUSTOMER_NO     > 0                                     
MFA-TR*          AND MH.ACCOUNT_NO      = 0                                     
MFA-TR*          AND NOT EXISTS(SELECT CK.CUSTOMER_NO                           
MFA-TR*                            FROM CSS_CREDIT_HIST CK                      
MFA-TR*                         WHERE CK.CUSTOMER_NO = MH.CUSTOMER_NO)          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE MNT_TRANS_PREMISE CURSOR WITH HOLD FOR             
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
               FROM CSS_MNT_TRANS_HIST MH                               
               WHERE MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                              :WS-TRNS-PREM-SQ-DEL-DATE
              )  
                 AND   MH.PREMISE_NO      > 0                           
                 AND   MH.CUSTOMER_NO     = 0                           
                 AND   MH.ACCOUNT_NO      = 0                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MNT_TRANS_PREMISE CURSOR WITH HOLD FOR                     
MFA-TR*        SELECT MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*        FROM CSS_MNT_TRANS_HIST MH                                       
MFA-TR*        WHERE MH.TRANS_HIST_SEQ_NO <= :WS-TRNS-PREM-SQ-DEL-DATE          
MFA-TR*          AND   MH.PREMISE_NO      > 0                                   
MFA-TR*          AND   MH.CUSTOMER_NO     = 0                                   
MFA-TR*          AND   MH.ACCOUNT_NO      = 0                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE MNT_TRANS_ORPH_ACC CURSOR WITH HOLD FOR            
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                 FROM CSS_MNT_TRANS_HIST MH                             
                WHERE MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                               :WS-TRNS-NO-ACC-DEL-DATE
              )  
                  AND MH.ACCOUNT_NO    > 0                              
                  AND NOT EXISTS(SELECT AT.ACCOUNT_NO                   
                                   FROM CSS_ACCOUNT AT                  
                                  WHERE AT.ACCOUNT_NO = MH.ACCOUNT_NO)  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MNT_TRANS_ORPH_ACC CURSOR WITH HOLD FOR                    
MFA-TR*        SELECT MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*          FROM CSS_MNT_TRANS_HIST MH                                     
MFA-TR*         WHERE MH.TRANS_HIST_SEQ_NO <= :WS-TRNS-NO-ACC-DEL-DATE          
MFA-TR*           AND MH.ACCOUNT_NO    > 0                                      
MFA-TR*           AND NOT EXISTS(SELECT AT.ACCOUNT_NO                           
MFA-TR*                            FROM CSS_ACCOUNT AT                          
MFA-TR*                           WHERE AT.ACCOUNT_NO = MH.ACCOUNT_NO)          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE MNT_TRANS_ORPH_CUS CURSOR WITH HOLD FOR            
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                 FROM CSS_MNT_TRANS_HIST MH                             
                WHERE MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                               :WS-TRNS-NO-CUS-DEL-DATE
              )  
                  AND MH.CUSTOMER_NO   > 0                              
                  AND NOT EXISTS(SELECT CU.CUSTOMER_NO                  
                                   FROM CSS_CUSTOMER CU                 
                                WHERE CU.CUSTOMER_NO = MH.CUSTOMER_NO)  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MNT_TRANS_ORPH_CUS CURSOR WITH HOLD FOR                    
MFA-TR*        SELECT MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*          FROM CSS_MNT_TRANS_HIST MH                                     
MFA-TR*         WHERE MH.TRANS_HIST_SEQ_NO <= :WS-TRNS-NO-CUS-DEL-DATE          
MFA-TR*           AND MH.CUSTOMER_NO   > 0                                      
MFA-TR*           AND NOT EXISTS(SELECT CU.CUSTOMER_NO                          
MFA-TR*                            FROM CSS_CUSTOMER CU                         
MFA-TR*                         WHERE CU.CUSTOMER_NO = MH.CUSTOMER_NO)          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE MNT_TRANS_ORPH_PRE CURSOR WITH HOLD FOR            
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                 FROM CSS_MNT_TRANS_HIST MH                             
                WHERE MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                               :WS-TRNS-NO-PRE-DEL-DATE
              )  
                  AND MH.PREMISE_NO    > 0                              
                  AND NOT EXISTS(SELECT PR.PREMISE_NO                   
                                   FROM CSS_PREMISE PR                  
                                  WHERE PR.PREMISE_NO = MH.PREMISE_NO)  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MNT_TRANS_ORPH_PRE CURSOR WITH HOLD FOR                    
MFA-TR*        SELECT MH.TRANS_HIST_SEQ_NO                                      
MFA-TR*          FROM CSS_MNT_TRANS_HIST MH                                     
MFA-TR*         WHERE MH.TRANS_HIST_SEQ_NO <= :WS-TRNS-NO-PRE-DEL-DATE          
MFA-TR*           AND MH.PREMISE_NO    > 0                                      
MFA-TR*           AND NOT EXISTS(SELECT PR.PREMISE_NO                           
MFA-TR*                            FROM CSS_PREMISE PR                          
MFA-TR*                           WHERE PR.PREMISE_NO = MH.PREMISE_NO)          
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      * 0000-MAIN-PARA.                                              *          
      ****************************************************************          
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 0100-INITIALIZATION             THRU 0100-EXIT.      
           IF MNT-TRANS-FLAG                                            
              PERFORM 1000-MNT-TRANS-PROCESS-CSR1  THRU 1000-EXIT       
           END-IF.                                                      
                                                                        
           IF MNT-TRANS-CUST                                            
              MOVE  ZERO  TO  WS-MNT-CNT                                
              PERFORM 7210-GET-CUST-TIMESTAMP      THRU 7210-EXIT       
              PERFORM 1200-MNT-TRANS-CUST-CSR3     THRU 1200-EXIT       
              MOVE   WS-MNT-CNT TO WS-MNT-CUST-CNT                      
           END-IF.                                                      
           IF MNT-TRANS-PREM                                            
              MOVE  ZERO  TO  WS-MNT-CNT                                
              PERFORM 7220-GET-PREM-TIMESTAMP      THRU 7220-EXIT       
              PERFORM 1300-MNT-TRANS-PREMISE-CSR4  THRU 1300-EXIT       
              MOVE   WS-MNT-CNT TO WS-MNT-PREM-CNT                      
           END-IF.                                                      
           IF MNT-TRANS-ORPH-ACT                                        
              MOVE  ZERO  TO  WS-MNT-CNT                                
              PERFORM 7230-GET-ORPH-ACC-TIMESTAMP  THRU 7230-EXIT       
              PERFORM 1500-MNT-TRANS-ORPH-ACC-CSR5 THRU 1500-EXIT       
              MOVE   WS-MNT-CNT TO WS-MNT-NO-ACC-CNT                    
           END-IF.                                                      
           IF MNT-TRANS-ORPH-CUS                                        
              MOVE  ZERO  TO  WS-MNT-CNT                                
              PERFORM 7240-GET-ORPH-CUS-TIMESTAMP  THRU 7240-EXIT       
              PERFORM 1600-MNT-TRANS-ORPH-CUS-CSR6 THRU 1600-EXIT       
              MOVE   WS-MNT-CNT TO WS-MNT-NO-CUS-CNT                    
           END-IF.                                                      
           IF MNT-TRANS-ORPH-PRE                                        
              MOVE  ZERO  TO  WS-MNT-CNT                                
              PERFORM 7250-GET-ORPH-PRE-TIMESTAMP  THRU 7250-EXIT       
              PERFORM 1700-MNT-TRANS-ORPH-PRE-CSR7 THRU 1700-EXIT       
              MOVE   WS-MNT-CNT TO WS-MNT-NO-PRE-CNT                    
           END-IF.                                                      
      *                                                                         
           PERFORM 9100-PRINT-TOTALS            THRU 9100-EXIT          
           MOVE WS-CURRENT-RUN-TS               TO WS-PGM-LAST-RUN-TS   
           MOVE WS-PARM-DATA                    TO G6-PARM-DATA         
           PERFORM 8110-UPDATE-LAST-RUN-DATE    THRU 8110-EXIT          
           MOVE WS-JOB-PARM-ERR-CODE            TO RETURN-CODE          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02390000
      *   0100-INITIALIZATION                                          *02410000
      *        COMMON INITIALIZATION ROUTINE                           *02420000
      ******************************************************************02440000
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT THRU 6253-EXIT.            
                                                                        
           MOVE WS-PGRMNAME                  TO WS-PROGRAM.             
           MOVE ZEROS                        TO WS-SEQUENCE.            
           MOVE SPACES                       TO WS-SYSIPT.              
           MOVE WS-KEY-AREA                  TO E-FJC01-KEY.            
                                                                        
           PERFORM 7600P-START-FCSJC01       THRU 7600P-EXIT.           
           PERFORM 0150-READ-LAST-TS         THRU 0150-EXIT.            
           PERFORM 7611P-CLOSE               THRU 7611P-EXIT.           
           PERFORM 7200-GET-CURRENT-TS       THRU 7200-EXIT.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **  0150-READ-LAST-TS                                           *         
      *****************************************************************         
       0150-READ-LAST-TS.                                               
      *                                                                         
           MOVE +1                               TO   WS-I.             
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP=')    
            OR END-OF-SYSIPT                                            
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP='    
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA(21:26)   TO WS-PGM-LAST-RUN-TS       
                 DISPLAY 'LAST RUN TIME STAMP = ' WS-PGM-LAST-RUN-TS    
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR LAST RUN TIME STAMP'  
                 DISPLAY 'NO RECORDS ARE PROCESSED'                     
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR LAST RUN TIME STAMP'    
              DISPLAY 'NO RECS ARE PROCESSED FOR LAST RUN TIME STAMP'   
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_MNT_TRANS_HIST')    
            OR END-OF-SYSIPT                                            
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) =  'CSS_MNT_TRANS_HIST'     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA          TO WS-JOB-PARM-DATA         
                 MOVE 'Y'                   TO WS-MNT-TRANS-FLAG        
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_MNT_TRANS_HIST '  
                 DISPLAY 'NO RECORDS PROCESSED FOR CSS_MNT_TRANS_HIST'  
                 DISPLAY 'PROCESSING COMPLETED FOR PCSXP500 PROGRAM'    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_MNT_TRANS_HIST'     
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_MNT_TRANS_HIST'    
              DISPLAY '       '                                         
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_MNT_TRANS_CUST')    
            OR END-OF-SYSIPT                                            
           IF WS-INPUT-DATA-BREAKDOWN(1:18) =  'CSS_MNT_TRANS_CUST'     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA          TO WS-JOB-PARM-DATA         
                 MOVE WS-JP-PURGE-MO-1      TO WS-MONTHS-VALUE          
                 MOVE WS-MONTHS-VALUE       TO WS-DEL-MONTHS-CUST       
                 IF WS-DEL-MONTHS-CUST >= 037                           
                    MOVE 'Y'                TO WS-MNT-TRANS-CUST        
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MONTHS VALUE FROM JOB PARM FOR'             
                   DISPLAY 'CSS_MNT_TRANS_CUST: ', WS-JP-PURGE-MO-1     
                   DISPLAY 'NO RECS ARE PROCESSED FOR'                  
                   DISPLAY 'CSS_MNT_TRANS_HIST CUSTOMER'                
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR MNT CUSTOMER WISE '   
                 DISPLAY 'NO RECORDS-CSS_MNT_TRANS_HIST FOR CUSTOMER'   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_MNT_TRANS_PREM')    
            OR END-OF-SYSIPT                                            
           IF WS-INPUT-DATA-BREAKDOWN(1:18) =  'CSS_MNT_TRANS_PREM'     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA          TO WS-JOB-PARM-DATA         
                 MOVE WS-JP-PURGE-MO-1      TO WS-MONTHS-VALUE          
                 MOVE WS-MONTHS-VALUE       TO WS-DEL-MONTHS-PREM       
                 IF WS-DEL-MONTHS-PREM >= 036                           
                    MOVE 'Y'                TO WS-MNT-TRANS-PREM        
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MONTHS VALUE FROM JOB PARM FOR'             
                   DISPLAY 'CSS_MNT_TRANS_PREM: ', WS-JP-PURGE-MO-1     
                   DISPLAY 'NO RECS ARE PROCESSED FOR'                  
                   DISPLAY 'CSS_MNT_TRANS_HIST PREMISE'                 
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR MNT PREMISE WISE '    
                 DISPLAY 'NO RECORDS-CSS_MNT_TRANS_HIST FOR PREMISE '   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_MNT_TR_NO_ACCT')    
            OR END-OF-SYSIPT                                            
           IF WS-INPUT-DATA-BREAKDOWN(1:18) =  'CSS_MNT_TR_NO_ACCT'     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA          TO WS-JOB-PARM-DATA         
                 MOVE WS-JP-PURGE-MO-1      TO WS-MONTHS-VALUE          
                 MOVE WS-MONTHS-VALUE       TO WS-DEL-NO-ACC-MONTHS     
                 IF WS-DEL-NO-ACC-MONTHS >= 012                         
                    MOVE 'Y'                TO WS-MNT-TRANS-ORGH-ACC    
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MONTHS VALUE FROM JOB PARM FOR'             
                   DISPLAY 'CSS_MNT_TR_NO_ACCT: ', WS-JP-PURGE-MO-1     
                   DISPLAY 'NO RECS ARE PROCESSED FOR'                  
                   DISPLAY 'CSS_MNT_TRANS_HIST ORPHACC'                 
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR MNT ORPHAN ACCT'      
                 DISPLAY 'NO RECORDS-CSS_MNT_TRANS_HIST FOR ORPHACC '   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_MNT_TR_NO_CUST')    
            OR END-OF-SYSIPT                                            
           IF WS-INPUT-DATA-BREAKDOWN(1:18) =  'CSS_MNT_TR_NO_CUST'     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA          TO WS-JOB-PARM-DATA         
                 MOVE WS-JP-PURGE-MO-1      TO WS-MONTHS-VALUE          
                 MOVE WS-MONTHS-VALUE       TO WS-DEL-NO-CUS-MONTHS     
                 IF WS-DEL-NO-CUS-MONTHS >= 012                         
                    MOVE 'Y'                TO WS-MNT-TRANS-ORGH-CUS    
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MONTHS VALUE FROM JOB PARM FOR'             
                   DISPLAY 'CSS_MNT_TR_NO_CUST: ', WS-JP-PURGE-MO-1     
                   DISPLAY 'NO RECS ARE PROCESSED FOR'                  
                   DISPLAY 'CSS_MNT_TRANS_HIST ORPHCUST'                
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR MNT ORPHAN CUST'      
                 DISPLAY 'NO RECORDS-CSS_MNT_TRANS_HIST FOR ORPHCUST'   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_MNT_TR_NO_PREM')    
            OR END-OF-SYSIPT                                            
           IF WS-INPUT-DATA-BREAKDOWN(1:18) =  'CSS_MNT_TR_NO_PREM'     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA          TO WS-JOB-PARM-DATA         
                 MOVE WS-JP-PURGE-MO-1      TO WS-MONTHS-VALUE          
                 MOVE WS-MONTHS-VALUE       TO WS-DEL-NO-PRE-MONTHS     
                 IF WS-DEL-NO-PRE-MONTHS >= 012                         
                    MOVE 'Y'                TO WS-MNT-TRANS-ORGH-PRE    
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MONTHS VALUE FROM JOB PARM FOR'             
                   DISPLAY 'CSS_MNT_TR_NO_PREM: ', WS-JP-PURGE-MO-1     
                   DISPLAY 'NO RECS ARE PROCESSED FOR '                 
                   DISPLAY 'CSS_MNT_TRANS_HIST ORPHPRE'                 
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR MNT ORPHAN PREMIS'    
                 DISPLAY 'NO RECORDS-CSS_MNT_TRANS_HIST FOR ORPHPRE '   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_MNT_TRANS_HIST      *          
      ****************************************************************          
      *                                                                         
       1000-MNT-TRANS-PROCESS-CSR1.                                     
      *                                                                         
           INITIALIZE WS-COMMIT-COUNT.                                  
           MOVE    WS-PGM-LAST-RUN-TS        TO   PU-LAST-UPDATE-TS.    
      *                                                                         
           PERFORM 7000-OPEN-MNT-TRANS-CSR1  THRU 7000-EXIT.            
           PERFORM 7010-FETCH-MNT-TRANS-CSR1 THRU 7010-EXIT.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1000-MNT-TRANS-PROCESS-CSR1 PARAGRAPH' 
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '***************************************'         
              DISPLAY '* NO RECORDS TO DELETE IN             *'         
              DISPLAY '* CSS_MNT_TRANS_HIST TABLE            *'         
              DISPLAY '***************************************'         
              DISPLAY '      '                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8000-DELETE-MNT-TRANS-CSR1    THRU 8000-EXIT      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-COMMIT-COUNT                            
                 ADD WS-1 TO WS-MNT-CNT1                                
                IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                  
                   PERFORM 8900-COMMIT THRU 8900-EXIT                   
                   DISPLAY 'COMMIT NO    : ' WS-NBR-COMMIT              
                   DISPLAY 'ACOCUNT NO   : ' PU-ACCOUNT-NO              
                   INITIALIZE WS-COMMIT-COUNT                           
                END-IF                                                  
              END-IF                                                    
              PERFORM 7010-FETCH-MNT-TRANS-CSR1     THRU 7010-EXIT      
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-MNT-TRANS-CSR1 THRU 7020-EXIT.            
           PERFORM 8900-COMMIT               THRU 8900-EXIT.            
      *                                                                         
           DISPLAY '      '.                                            
           DISPLAY '** NUMBER OF COMMITS FOR'.                          
           DISPLAY '** CSS_MNT_TRANS_HIST TABLE = '                     
                                                     WS-NBR-COMMIT.     
           DISPLAY '      '.                                            
           INITIALIZE WS-NBR-COMMIT.                                    
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_MNT_TRANS_HIST      *          
      * FOR CUSTOMER > 0 IN TRANS HISTORY TABLE.                     *          
      ****************************************************************          
      *                                                                         
       1200-MNT-TRANS-CUST-CSR3.                                        
                                                                        
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7300-OPEN-MNT-CUST-CSR3  THRU 7300-EXIT.             
           PERFORM 7310-FETCH-MNT-CUST-CSR3 THRU 7310-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1200-MNT-TRANS-CUST-CSR3 PARAGRAPH'    
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '***************************************'         
              DISPLAY '* NO RECORDS TO DELETE IN             *'         
              DISPLAY '* CSS_MNT_TRANS_HIST FOR CUSTOMER     *'         
              DISPLAY '***************************************'         
              DISPLAY '      '                                          
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8200-MNT-TRANS-DEL-PARA       THRU 8200-EXIT      
              PERFORM 7310-FETCH-MNT-CUST-CSR3      THRU 7310-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7320-CLOSE-MNT-CUST-CSR3 THRU 7320-EXIT.             
                                                                        
           PERFORM 8900-COMMIT THRU 8900-EXIT                           
           DISPLAY '**NO.OF COMMITS FOR MNT TRANS OF CUSTOMER:'         
                                                 WS-NBR-COMMIT.         
           INITIALIZE WS-NBR-COMMIT.                                    
                                                                        
       1200-EXIT.                                                       
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_MNT_TRANS_HIST      *          
      * FOR PREMISE NUMBER > 0 TRANS HISTORY TABLE.                  *          
      ****************************************************************          
                                                                        
       1300-MNT-TRANS-PREMISE-CSR4.                                     
                                                                        
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7400-OPEN-MNT-PREM-CSR4  THRU 7400-EXIT.             
           PERFORM 7410-FETCH-MNT-PREM-CSR4 THRU 7410-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1300-MNT-TRANS-PREMISE-CSR4 PARAGRAPH' 
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '***************************************'         
              DISPLAY '* NO RECORDS TO DELETE IN             *'         
              DISPLAY '* CSS_MNT_TRANS_HIST FOR PREMISE > 0  *'         
              DISPLAY '***************************************'         
              DISPLAY '      '                                          
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8200-MNT-TRANS-DEL-PARA       THRU 8200-EXIT      
              PERFORM 7410-FETCH-MNT-PREM-CSR4      THRU 7410-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7420-CLOSE-MNT-CUST-CSR4 THRU 7420-EXIT.             
                                                                        
           PERFORM 8900-COMMIT THRU 8900-EXIT                           
           DISPLAY '**NO.OF COMMITS FOR MNT TRANS OF PREMISE:'          
                                                 WS-NBR-COMMIT.         
           INITIALIZE WS-NBR-COMMIT.                                    
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_MNT_TRANS_HIST      *          
      * FOR PREMISE NUMBER > 0 TRANS HISTORY TABLE.                  *          
      ****************************************************************          
                                                                        
       1500-MNT-TRANS-ORPH-ACC-CSR5.                                    
                                                                        
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7500-OPEN-MNT-ORPH-ACCT-CSR5  THRU 7500-EXIT.        
           PERFORM 7510-FETCH-MNT-ORPH-ACCT-CSR5 THRU 7510-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1500-MNT-TRANS-ORPH-ACT-CSR6 PARA'     
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '***************************************'         
              DISPLAY '* NO RECORDS TO DELETE IN             *'         
              DISPLAY '* CSS_MNT_TRANS_HIST FOR ACCOUNT > 0  *'         
              DISPLAY '***************************************'         
              DISPLAY '      '                                          
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8200-MNT-TRANS-DEL-PARA       THRU 8200-EXIT      
              PERFORM 7510-FETCH-MNT-ORPH-ACCT-CSR5  THRU 7510-EXIT     
           END-PERFORM.                                                 
                                                                        
           PERFORM 7520-CLOSE-MNT-ORPH-ACCT-CSR5 THRU 7520-EXIT.        
                                                                        
           PERFORM 8900-COMMIT THRU 8900-EXIT                           
           DISPLAY '**NO.OF COMMITS FOR MNT TRANS OF ORPHAN ACCT:'      
                                                 WS-NBR-COMMIT.         
           INITIALIZE WS-NBR-COMMIT.                                    
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       1600-MNT-TRANS-ORPH-CUS-CSR6.                                    
                                                                        
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7800-OPEN-MNT-ORPH-CUST-CSR6  THRU 7800-EXIT.        
           PERFORM 7810-FETCH-MNT-ORPH-CUST-CSR6 THRU 7810-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1500-MNT-TRANS-ORPH-CUS-CSR6 PARA'     
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '***************************************'         
              DISPLAY '* NO RECORDS TO DELETE IN             *'         
              DISPLAY '* CSS_MNT_TRANS_HIST FOR CUSTOMER > 0 *'         
              DISPLAY '***************************************'         
              DISPLAY '      '                                          
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8200-MNT-TRANS-DEL-PARA       THRU 8200-EXIT      
              PERFORM 7810-FETCH-MNT-ORPH-CUST-CSR6  THRU 7810-EXIT     
           END-PERFORM.                                                 
                                                                        
           PERFORM 7820-CLOSE-MNT-ORPH-CUST-CSR6 THRU 7820-EXIT.        
                                                                        
           PERFORM 8900-COMMIT THRU 8900-EXIT                           
           DISPLAY '**NO.OF COMMITS FOR MNT TRANS OF ORPHAN CUST:'      
                                                 WS-NBR-COMMIT.         
           INITIALIZE WS-NBR-COMMIT.                                    
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1700-MNT-TRANS-ORPH-PRE-CSR7.                                    
                                                                        
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7700-OPEN-MNT-ORPH-PREM-CSR7  THRU 7700-EXIT.        
           PERFORM 7710-FETCH-MNT-ORPH-PREM-CSR7 THRU 7710-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1600-MNT-TRANS-ORPH-PRE-CSR7 PARA'     
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '***************************************'         
              DISPLAY '* NO RECORDS TO DELETE IN             *'         
              DISPLAY '* CSS_MNT_TRANS_HIST FOR PREMISE > 0  *'         
              DISPLAY '***************************************'         
              DISPLAY '      '                                          
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8200-MNT-TRANS-DEL-PARA       THRU 8200-EXIT      
              PERFORM 7710-FETCH-MNT-ORPH-PREM-CSR7 THRU 7710-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7720-CLOSE-MNT-ORPH-PREM-CSR7 THRU 7720-EXIT.        
                                                                        
           PERFORM 8900-COMMIT THRU 8900-EXIT                           
           DISPLAY '**NO.OF COMMITS FOR MNT TRANS OF ORPHAN PREM:'      
                                                 WS-NBR-COMMIT.         
           INITIALIZE WS-NBR-COMMIT.                                    
                                                                        
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  05160000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  05170000
      **  *RETRIEVE COMMIT COUNT DETAILS FROM JOB PARM TABLE.        *  05170000
      ****************************************************************  05180000
      *                                                                         
            EXEC SQL                                                    05190000
                INCLUDE CPD00034                                        05200000
            END-EXEC.                                                   05210000
      *                                                                 05220000
      ****************************************************************          
      * OPENS MNT_TRANS_TYPE_B CURSOR.                               *          
      ****************************************************************          
      *                                                                         
       7000-OPEN-MNT-TRANS-CSR1.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN MNT_TRANS_TYPE_B                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7000-OPEN-MNT-TRANS-CSR1               *'      
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES MNT_TRANS_TYPE_B CURSOR                              *          
      ****************************************************************          
      *                                                                         
       7010-FETCH-MNT-TRANS-CSR1.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH  MNT_TRANS_TYPE_B                                  
                INTO :PU-ACCOUNT-NO                                     
                    ,:PU-PURGE-TS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7010-FETCH-MNT-TRANS-CSR1           *'         
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES MNT_TRANS_TYPE_B CURSOR.                              *          
      ****************************************************************          
      *                                                                         
       7020-CLOSE-MNT-TRANS-CSR1.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE MNT_TRANS_TYPE_B                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7020-CLOSE-MNT-TRANS-CSR1           *'         
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **    DETERMINE CURRENT TIMESTAMP FOR LAST RUN TS.         *              
      ************************************************************              
      *                                                                         
       7200-GET-CURRENT-TS.                                             
      *                                                                         
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-RUN-TS              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-RUN-TS   = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-DIS-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP500******************'    
               DISPLAY '* 7200-GET-CURRENT-TS.              *'          
               DISPLAY '* SQLCODE = ' WS-DIS-RETURN-CODE                
               DISPLAY '* CURRENT TIMESTAMP:' WS-CURRENT-RUN-TS         
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSXP500******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **    DETERMINE TRANS SQ TIMESTAMP .                                      
      ************************************************************              
      *                                                                         
       7210-GET-CUST-TIMESTAMP.                                         
                                                                        
           MOVE '7210' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
            SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -(
                                                   :WS-DEL-MONTHS-CUST)
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRNS-CUST-SQ-DEL-DATE        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET                                                                 
MFA-TR*       :WS-TRNS-CUST-SQ-DEL-DATE                                         
MFA-TR*       = CURRENT TIMESTAMP - (:WS-DEL-MONTHS-CUST) MONTHS                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-DIS-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP500******************'    
               DISPLAY '* 7210-GET-CUST-TIMESTAMP.          *'          
               DISPLAY '* SQLCODE = ' WS-DIS-RETURN-CODE                
               DISPLAY '*WS-TRNS-CUST-SQ-DEL-DATE*'                     
                                      WS-TRNS-CUST-SQ-DEL-DATE          
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSXP500******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **    DETERMINE TIMESTAMP FROM TRANS SEQ OF PREMISE LEVEL.                
      ************************************************************              
                                                                        
       7220-GET-PREM-TIMESTAMP.                                         
                                                                        
           MOVE '7220' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
            SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -(
                                                   :WS-DEL-MONTHS-PREM)
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRNS-PREM-SQ-DEL-DATE        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET                                                                 
MFA-TR*       :WS-TRNS-PREM-SQ-DEL-DATE                                         
MFA-TR*       = CURRENT TIMESTAMP - (:WS-DEL-MONTHS-PREM) MONTHS                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-DIS-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP500******************'    
               DISPLAY '* 7220-GET-PREM-TIMESTAMP.          *'          
               DISPLAY '* SQLCODE = ' WS-DIS-RETURN-CODE                
               DISPLAY '*WS-TRNS-PREM-SQ-DEL-DATE*'                     
                                      WS-TRNS-PREM-SQ-DEL-DATE          
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSXP500******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **    DETERMINE TIMESTAMP FROM TRANS SEQ OF PREMISE LEVEL.                
      ************************************************************              
                                                                        
       7230-GET-ORPH-ACC-TIMESTAMP.                                     
                                                                        
           MOVE '7230' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
            SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -(
                                                 :WS-DEL-NO-ACC-MONTHS)
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRNS-NO-ACC-DEL-DATE      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET                                                                 
MFA-TR*       :WS-TRNS-NO-ACC-DEL-DATE                                          
MFA-TR*       = CURRENT TIMESTAMP - (:WS-DEL-NO-ACC-MONTHS) MONTHS              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-DIS-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP500******************'    
               DISPLAY '* 7230-GET-ORPH-ACC-TIMESTAMP.      *'          
               DISPLAY '* SQLCODE = ' WS-DIS-RETURN-CODE                
               DISPLAY '*WS-TRNS-PREM-SQ-DEL-DATE*'                     
                                      WS-TRNS-NO-ACC-DEL-DATE           
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSXP500******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **    DETERMINE TIMESTAMP FROM TRANS SEQ OF PREMISE LEVEL.                
      ************************************************************              
                                                                        
       7240-GET-ORPH-CUS-TIMESTAMP.                                     
                                                                        
           MOVE '7240' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
            SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -(
                                                 :WS-DEL-NO-CUS-MONTHS)
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRNS-NO-CUS-DEL-DATE      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET                                                                 
MFA-TR*       :WS-TRNS-NO-CUS-DEL-DATE                                          
MFA-TR*       = CURRENT TIMESTAMP - (:WS-DEL-NO-CUS-MONTHS) MONTHS              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-DIS-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP500******************'    
               DISPLAY '* 7240-GET-ORPH-CUS-TIMESTAMP.      *'          
               DISPLAY '* SQLCODE = ' WS-DIS-RETURN-CODE                
               DISPLAY '*WS-TRNS-PREM-SQ-DEL-DATE*'                     
                                      WS-TRNS-NO-CUS-DEL-DATE           
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSXP500******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-GET-ORPH-PRE-TIMESTAMP.                                     
                                                                        
           MOVE '7240' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
            SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -(
                                                 :WS-DEL-NO-PRE-MONTHS)
              , CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRNS-NO-PRE-DEL-DATE      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET                                                                 
MFA-TR*       :WS-TRNS-NO-PRE-DEL-DATE                                          
MFA-TR*       = CURRENT TIMESTAMP - (:WS-DEL-NO-PRE-MONTHS) MONTHS              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-DIS-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP500******************'    
               DISPLAY '* 7250-GET-ORPH-PRE-TIMESTAMP.      *'          
               DISPLAY '* SQLCODE = ' WS-DIS-RETURN-CODE                
               DISPLAY '*WS-TRNS-PREM-SQ-DEL-DATE*'                     
                                      WS-TRNS-NO-CUS-DEL-DATE           
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSXP500******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * OPENS MNT_TRANS_CUSTOMER FOR CUSTOMER > 0.                   *          
      ****************************************************************          
                                                                        
       7300-OPEN-MNT-CUST-CSR3.                                         
                                                                        
           EXEC SQL                                                     
               OPEN MNT_TRANS_CUSTOMER                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7300-OPEN-MNT-CUST-CSR3                *'      
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES MNT_TRANS_CUSTOMER CURSOR FOR CUSTOMER > 0.          *          
      ****************************************************************          
      *                                                                         
       7310-FETCH-MNT-CUST-CSR3.                                        
                                                                        
           EXEC SQL                                                     
               FETCH  MNT_TRANS_CUSTOMER                                
                INTO :MH-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7310-FETCH-MNT-CUST-CSR3            *'         
              DISPLAY '* CUSTOMER NO   :' MH-CUSTOMER-NO                
              DISPLAY '* PREMISE  NO   :' MH-PREMISE-NO                 
              DISPLAY '* ACCOUNT  NO   :' MH-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * CLOSES MNT_TRANS_CUSTOMER CURSOR FOR CUSTOMER NUMBER > 0.    *          
      ****************************************************************          
      *                                                                         
       7320-CLOSE-MNT-CUST-CSR3.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE MNT_TRANS_CUSTOMER                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7020-CLOSE-MNT-TRANS-CSR1           *'         
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* CUSTOMER NO   :' MH-CUSTOMER-NO                
              DISPLAY '* PREMISE  NO   :' MH-PREMISE-NO                 
              DISPLAY '* ACCOUNT  NO   :' MH-ACCOUNT-NO                 
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS MNT_TRANS_PREMISE FOR PREMISE NUMBER > 0.              *          
      ****************************************************************          
                                                                        
       7400-OPEN-MNT-PREM-CSR4.                                         
                                                                        
           EXEC SQL                                                     
               OPEN MNT_TRANS_PREMISE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7400-OPEN-MNT-PREM-CSR4                *'      
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES MNT_TRANS_PREMISE CURSOR FOR PREMISE NUMBER > 0.     *          
      ****************************************************************          
                                                                        
       7410-FETCH-MNT-PREM-CSR4.                                        
                                                                        
           EXEC SQL                                                     
               FETCH  MNT_TRANS_PREMISE                                 
                INTO :MH-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7410-FETCH-MNT-PREM-CSR4            *'         
              DISPLAY '* CUSTOMER NO   :' MH-CUSTOMER-NO                
              DISPLAY '* PREMISE  NO   :' MH-PREMISE-NO                 
              DISPLAY '* ACCOUNT  NO   :' MH-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES MNT_TRANS_CUSTOMER CURSOR FOR PREMISE NUMBER > 0.     *          
      ****************************************************************          
      *                                                                         
       7420-CLOSE-MNT-CUST-CSR4.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE MNT_TRANS_PREMISE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7420-CLOSE-MNT-CUST-CSR4            *'         
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* CUSTOMER NO   :' MH-CUSTOMER-NO                
              DISPLAY '* PREMISE  NO   :' MH-PREMISE-NO                 
              DISPLAY '* ACCOUNT  NO   :' MH-ACCOUNT-NO                 
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS MNT_TRANS_PREMISE FOR PREMISE NUMBER > 0.              *          
      ****************************************************************          
                                                                        
       7500-OPEN-MNT-ORPH-ACCT-CSR5.                                    
                                                                        
           EXEC SQL                                                     
               OPEN MNT_TRANS_ORPH_ACC                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7500-OPEN-MNT-ORPH-ACCT-CSR5           *'      
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES MNT_TRANS_PREMISE CURSOR FOR PREMISE NUMBER > 0.     *          
      ****************************************************************          
                                                                        
       7510-FETCH-MNT-ORPH-ACCT-CSR5.                                   
                                                                        
           EXEC SQL                                                     
               FETCH  MNT_TRANS_ORPH_ACC                                
                INTO :MH-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7510-FETCH-MNT-ORPH-ACCT-CSR5       *'         
              DISPLAY '* TRAN TIMESTAMP:' MH-TRANS-HIST-SEQ-NO          
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES MNT_TRANS_CUSTOMER CURSOR FOR PREMISE NUMBER > 0.     *          
      ****************************************************************          
      *                                                                         
       7520-CLOSE-MNT-ORPH-ACCT-CSR5.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE MNT_TRANS_ORPH_ACC                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7520-CLOSE-MNT-ORPH-ACCT-CSR5       *'         
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-OPEN-MNT-ORPH-CUST-CSR6.                                    
                                                                        
           EXEC SQL                                                     
               OPEN MNT_TRANS_ORPH_CUS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7800-OPEN-MNT-ORPH-CUST-CSR6           *'      
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES MNT_TRANS_PREMISE CURSOR FOR PREMISE NUMBER > 0.     *          
      ****************************************************************          
                                                                        
       7810-FETCH-MNT-ORPH-CUST-CSR6.                                   
                                                                        
           EXEC SQL                                                     
               FETCH  MNT_TRANS_ORPH_CUS                                
                INTO :MH-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7810-FETCH-MNT-ORPH-CUST-CSR6       *'         
              DISPLAY '* TRAN TIMESTAMP:' MH-TRANS-HIST-SEQ-NO          
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES MNT_TRANS_CUSTOMER CURSOR FOR PREMISE NUMBER > 0.     *          
      ****************************************************************          
      *                                                                         
       7820-CLOSE-MNT-ORPH-CUST-CSR6.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE MNT_TRANS_ORPH_CUS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7820-CLOSE-MNT-ORPH-CUST-CSR6       *'         
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-OPEN-MNT-ORPH-PREM-CSR7.                                    
                                                                        
           EXEC SQL                                                     
               OPEN MNT_TRANS_ORPH_PRE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7700-OPEN-MNT-ORPH-PREM-CSR7           *'      
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES MNT_TRANS_PREMISE CURSOR FOR PREMISE NUMBER > 0.     *          
      ****************************************************************          
                                                                        
       7710-FETCH-MNT-ORPH-PREM-CSR7.                                   
                                                                        
           EXEC SQL                                                     
               FETCH  MNT_TRANS_ORPH_PRE                                
                INTO :MH-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7710-FETCH-MNT-ORPH-PREM-CSR7       *'         
              DISPLAY '* TRAN TIMESTAMP:' MH-TRANS-HIST-SEQ-NO          
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES MNT_TRANS_CUSTOMER CURSOR FOR PREMISE NUMBER > 0.     *          
      ****************************************************************          
      *                                                                         
       7720-CLOSE-MNT-ORPH-PREM-CSR7.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE MNT_TRANS_ORPH_PRE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT  ************'         
              DISPLAY '* 7720-CLOSE-MNT-ORPH-PREM-CSR7       *'         
              DISPLAY '* SQLCODE IS ', WS-DIS-RETURN-CODE               
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP500  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING          *          
      **    7600-START-FCSJC01                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  7600P-START-FCSJC01                                                   
      **  *RETRIEVE PARM DETAILS FROM JOB PARM TABLE.                           
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPDPURGE                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_MNT_TRANS_HIST TABLE                *          
      ****************************************************************          
      *                                                                         
       8000-DELETE-MNT-TRANS-CSR1.                                      
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM MH                        
                FROM CSS_MNT_TRANS_HIST MH
                 WHERE MH.ACCOUNT_NO         = :PU-ACCOUNT-NO           
                 AND   MH.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_MNT_TRANS_HIST MH                               
MFA-TR*          WHERE MH.ACCOUNT_NO         = :PU-ACCOUNT-NO                   
MFA-TR*          AND   MH.TRANS_HIST_SEQ_NO <= :PU-PURGE-TS                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DIS-RETURN-CODE.                          
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 DISPLAY '********** PCSXP500 ABORT  ************'      
                 DISPLAY '* 8000-DELETE-MNT-TRANS-CSR1          *'      
                 DISPLAY '* ACCOUNT : '           PU-ACCOUNT-NO         
                 DISPLAY '* TRANS_HIST_SEQ_NO : ' PU-PURGE-TS           
                 DISPLAY '* SQLCODE IS ',         WS-DIS-RETURN-CODE    
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP500  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8110-UPDATE-LAST-RUN-DATE                                     *         
      *****************************************************************         
       8110-UPDATE-LAST-RUN-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
                                                                        
               UPDATE CSS_JOB_PARM                                      
                  SET PARM_DATA    = :G6-PARM-DATA                      
                WHERE CMND_CODE    = 'DATE'                             
                  AND COMPANY_NO   = '01'                               
                  AND PROGRAM_NAME = :WS-PGRMNAME                       
                  AND STATUS       = 'A'                                
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DIS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP500 ABORT **************'        
              DISPLAY '*     8110-UPDATE-LAST-RUN-DATE        *'        
              DISPLAY '* SQLCODE        : ' WS-DIS-RETURN-CODE          
              DISPLAY'* WS-PGM-LAST-RUN-TS = ' WS-PGM-LAST-RUN-TS       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                         
       8110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * 8200-MNT-TRANS-DEL-PARA*                                     *          
      ****************************************************************          
      *                                                                         
       8200-MNT-TRANS-DEL-PARA.                                         
                                                                        
           EXEC SQL                                                     
              DELETE FROM MH                          
              FROM CSS_MNT_TRANS_HIST MH
              WHERE MH.TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_MNT_TRANS_HIST MH                                 
MFA-TR*       WHERE MH.TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-DIS-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 ADD WS-1 TO WS-COMMIT-COUNT                            
                 ADD WS-1 TO WS-MNT-CNT                                 
                IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                  
                   PERFORM 8900-COMMIT THRU 8900-EXIT                   
                   DISPLAY 'COMMIT COUNT : ' WS-COMMIT-COUNT            
                   INITIALIZE WS-COMMIT-COUNT                           
                END-IF                                                  
              WHEN NOT-FOUND                                            
                  CONTINUE                                              
              WHEN OTHER                                                
                 DISPLAY '********** PCSXP500 ABORT  ************'      
                 DISPLAY '* 8200-MNT-TRANS-CUST-DEL-PARA        *'      
                 DISPLAY '* TRANS TIMESTAMP  :' MH-TRANS-HIST-SEQ-NO    
                 DISPLAY '* SQLCODE IS ',       WS-DIS-RETURN-CODE      
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP500  ABORT ************'      
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                       *          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           COMPUTE WS-NBR-COMMIT = WS-NBR-COMMIT + 1.                   
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9100-PRINT-TOTALS.                                           *          
      ****************************************************************          
       9100-PRINT-TOTALS.                                               
      *                                                                         
           IF MNT-TRANS-FLAG                                            
              DISPLAY 'TOT#.OF ACCT DLTED IN MNT_TRANS_HIST TABLE :'    
                                                      WS-MNT-CNT1       
           END-IF.                                                      
                                                                        
           IF MNT-TRANS-CUST                                            
              DISPLAY 'TOT#.OF ACCTS DLTED IN MNT_TRANS_HIST CUSTOMER:' 
                                                      WS-MNT-CUST-CNT   
           END-IF.                                                      
                                                                        
           IF MNT-TRANS-PREM                                            
              DISPLAY 'TOT#.OF ACCTS DLTED IN MNT_TRANS_HIST PREMISE:'  
                                                      WS-MNT-PREM-CNT   
           END-IF.                                                      
                                                                        
           IF MNT-TRANS-ORPH-ACT                                        
              DISPLAY 'TOT#.OF ORPHAN ROWS DELETED FOR ACCOUNTS:'       
                                                     WS-MNT-NO-ACC-CNT  
           END-IF.                                                      
                                                                        
           IF MNT-TRANS-ORPH-CUS                                        
              DISPLAY 'TOT#.OF ORPHAN ROWS DELETED FOR CUSTOMER:'       
                                                     WS-MNT-NO-CUS-CNT  
           END-IF.                                                      
                                                                        
           IF MNT-TRANS-ORPH-PRE                                        
              DISPLAY 'TOT#.OF ORPHAN ROWS DELETED FOR PREMISE:'        
                                                     WS-MNT-NO-PRE-CNT  
           END-IF.                                                      
      *                                                                         
       9100-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
