       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP443.                                        
       AUTHOR.         PRIYA.                                           
       DATE-WRITTEN.   OCT, 2008.                                       
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      **                     PCSXP443 NARRATIVE                                 
      **                                                                        
      **  THIS PROGRAM PURGES DATA FROM THE EDI BILLING TABLES                  
      **  (DELETE  CSS_EDI_PYMT_HDR AND CSS_EDI_PYMT_DET) BASED                 
      **  ON ACCOUNT NUMBER AND BILL NUMBER FROM THE INPUT FILE.                
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
C37648**  10/22/08  PRIYA        CLONE OF PCSCA843                   **         
      **                                                             ** 00410000
      ***************************************************************** 00420000
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSBL82-FILE                                          
               ASSIGN TO UT-S-FCSBL82                                   
               FILE STATUS IS WS-FBL82-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * FD STATEMENT FOR A FIXED LENGTH EDI PURGE FILE                 *        
      *                                                                *        
      ******************************************************************        
       FD  FCSBL82-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD                                   
           RECORDING MODE IS F                                          
           DATA RECORD IS FIOBL82.                                      
                                                                        
      *FIOBL82                                                                  
      ******************************************************************        
      *  FIOBL82                                                       *        
      *      IO AREA FOR EDI PURGE FILE                                *        
      ******************************************************************        
       01  FIOBL82.                                                     
         05  E-FBL82-PYMT-TS                  PIC X(26).                
         05  FILLER                           PIC X(01).                
         05  E-FBL82-ROUTING-NO               PIC 9(12).                
         05  FILLER                           PIC X(01).                
         05  E-FBL82-EFFECTIVE-DT             PIC X(10).                
         05  FILLER                           PIC X(01).                
         05  E-FBL82-PAYER-NAME               PIC X(35).                
         05  FILLER                           PIC X(14).                
      *                                                                 00750000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP443'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-FIOBL82.                                                  
           05  WS-PYMT-TS                     PIC X(26).                
           05  FILLER                         PIC X(01).                
           05  WS-ROUTING-NO                  PIC 9(12).                
           05  FILLER                         PIC X(01).                
           05  WS-EFFECTIVE-DT                PIC X(10).                
           05  FILLER                         PIC X(01).                
           05  WS-PAYER-NAME                  PIC X(35).                
           05  FILLER                         PIC X(14).                
                                                                        
       01  WS-MISC.                                                     
           05  WS-FBL82-STATUS            PIC XX     VALUE '  '.        
               88  FBL82-SUCCESSFUL                  VALUE '00'.        
               88  FBL82-READ-OK                     VALUE '00' '04'.   
           05  WS-END-OF-BL82             PIC X      VALUE ' '.         
               88  END-OF-BL82                       VALUE 'Y'.         
               88  PROCESS-BL82                      VALUE ' '.         
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-Y                        PIC X(01) VALUE 'Y'.          
                                                                        
       01  WS-COUNTERS.                                                 
           05 WS-ACCT-TOTAL               PIC S9(9) COMP VALUE 0.       
           05 WS-EDI-HDR-CNT              PIC S9(9) COMP VALUE 0.       
           05 WS-EDI-DET-CNT              PIC S9(9) COMP VALUE 0.       
           05 WS-READ-COMMIT-CNT          PIC S9(9) COMP VALUE 0.       
           05 WS-COMMIT-NO                PIC S9(9) COMP VALUE 0.       
           05 WS-READ-COMMIT              PIC S9(9) COMP VALUE 1000.    
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-ERR-MSG                  PIC X(100)     VALUE SPACES.  
           05 WS-ERR-MSG2                 PIC X(100)     VALUE SPACES.  
       01  WS-COMMIT-DATA.                                              
           05 FILLER                      PIC X(67).                    
                                                                        
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_PYMT_HDR - JH                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPYMTHD                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_PYMT-DET    - JD                                      *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPYMTDT                                                 
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE                            
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *   OPEN FCSBL82                                                 *        
      *----------------------------------------------------------------*        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           OPEN INPUT FCSBL82-FILE                                      
           IF WS-FBL82-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBL82'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL82-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READ EDI PURGE FILE AND DELETE BY TIMESTAMP.                   *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
      *                                                                         
           PERFORM 7000-READ-PURGE-FILE                                 
              THRU 7000-EXIT                                            
                                                                        
           PERFORM UNTIL END-OF-BL82                                    
                                                                        
              MOVE WS-PYMT-TS       TO                                  
                                    JH-TRANSACTION-TS                   
                                    JD-TRANSACTION-TS                   
                                                                        
              PERFORM 2000-PROCESS-DELETION                             
                 THRU 2000-EXIT                                         
              IF WS-READ-COMMIT-CNT = WS-READ-COMMIT                    
                 PERFORM 8999-ISSUE-COMMIT                              
                    THRU 8999-EXIT                                      
                 MOVE 0 TO WS-READ-COMMIT-CNT                           
                 ADD +1 TO WS-COMMIT-NO                                 
                 DISPLAY 'THIS IS A READ COMMIT, TS = ',                
                       WS-PYMT-TS                                       
              END-IF                                                    
              PERFORM 7000-READ-PURGE-FILE                              
                 THRU 7000-EXIT                                         
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7100-CLOSE-PURGE-FILE                                
              THRU 7100-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE ROWS WHICH ARE MORE THAN 6 MONTHS OLD FOR AN ACCOUNT    *        
      *----------------------------------------------------------------*        
       2000-PROCESS-DELETION.                                           
      *----------------------*                                                  
           MOVE '2000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 8100-DELETE-PYMT-DETAIL                              
              THRU 8100-EXIT                                            
           PERFORM 8200-DELETE-PYMT-HDR                                 
              THRU 8200-EXIT                                            
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READ EDI PURGE FILE                                            *        
      *----------------------------------------------------------------*        
       7000-READ-PURGE-FILE.                                            
      *----------------------*                                                  
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSBL82-FILE INTO WS-FIOBL82                            
               AT END                                                   
                  MOVE WS-Y TO WS-END-OF-BL82.                          
           IF FBL82-READ-OK OR END-OF-BL82                              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSXP443 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBL82        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL82-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           IF FBL82-READ-OK                                             
              ADD +1 TO WS-READ-COMMIT-CNT                              
              ADD +1 TO WS-ACCT-TOTAL
           END-IF                                   
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE EDI PURGE FILE                                           *        
      *----------------------------------------------------------------*        
       7100-CLOSE-PURGE-FILE.                                           
      *----------------------*                                                  
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           CLOSE FCSBL82-FILE                                           
           IF FBL82-READ-OK                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSXP443 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR CLOSING FCSBL82        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL82-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE CSS_EDI_PYMT_DET TABLE ROWS                             *        
      *----------------------------------------------------------------*        
       8100-DELETE-PYMT-DETAIL.                                         
      *---------------------*                                                   
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_EDI_PYMT_DET                               
              WHERE TRANSACTION_TS = CIS.CHAR2TIMESTAMP(
                                                     :JD-TRANSACTION-TS
              )                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_EDI_PYMT_DET                                       
MFA-TR*       WHERE TRANSACTION_TS = :JD-TRANSACTION-TS                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-EDI-DET-CNT                                
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR DELETING CSS_EDI_PYMT_DET ** '             
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' JD.TRANSACTION_TS = ' WS-PYMT-TS                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE CSS_EDI_PYMT_HDR TABLE ROWS                             *        
      *----------------------------------------------------------------*        
       8200-DELETE-PYMT-HDR.                                            
      *--------------------*                                                    
           MOVE '8200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_EDI_PYMT_HDR                               
              WHERE TRANSACTION_TS = CIS.CHAR2TIMESTAMP(
                                                     :JH-TRANSACTION-TS
              )                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_EDI_PYMT_HDR                                       
MFA-TR*       WHERE TRANSACTION_TS = :JH-TRANSACTION-TS                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-EDI-HDR-CNT                                
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR DELETING CSS_EDI_PYMT_HDR  ** '            
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' JH.TRANSACTION_TS    = ' WS-PYMT-TS              
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY ERRORS                                                 *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'     
           DISPLAY '**     PCSXP443  PROCESSING ERROR           **'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'     
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE            
           DISPLAY '**       PROCESSING TERMINATED              **'     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * COMMIT DB2                                                    *         
      *---------------------------------------------------------------*         
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
           .                                                                    
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY MESSAGES                                               *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           DISPLAY 'TOTAL NO OF COMMITS = ' WS-COMMIT-NO                
                                                                        
           DISPLAY 'TOTAL NO OF ACCOUNTS SELECTED           = '         
                   WS-ACCT-TOTAL                                        
           DISPLAY 'ACCOUNTS AFFECTED IN CSS_EDI_PYMT_HDR   = '         
                   WS-EDI-HDR-CNT                                       
           DISPLAY 'ACCOUNTS AFFECTED IN CSS_EDI_PYMT_DET = '           
                    WS-EDI-DET-CNT                                      
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PERFORM ABEND USING 9900-ABEND PARAGRAPH                                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
