       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSXP442.                                            
       AUTHOR. PRIYA.                                                   
       DATE-WRITTEN. OCT 2008.                                          
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      * THIS PROGRAM BUILDS A FILE THAT IS USED BY PCSXP441 TO        *         
      * DELETE EDI RECORDS FROM CSS_EDI_PYMT_HDR, CSS_EDI_PYMT_DET    *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *   DATE       INITIALS    REASON                               *         
      * ----------  ------------ -------------------------------------*         
C37648* 10/22/2008  PRIYA        CLONE OF PCSCA842                    *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
             ---- BASIC SEQUENCE STRUCTURE ----                         
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSBL82-FILE                                          
               ASSIGN TO UT-S-FCSBL82                                   
               FILE STATUS IS WS-FBL82-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************        
      * FD STATEMENT FOR A FIXED LENGTH EDI PURGE FILE                 *        
      *                                                                *        
      ******************************************************************        
       FD  FCSBL82-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
      *FIOBL82                                                                  
      ******************************************************************        
      *  FIOBL82                                                       *        
      *      IO AREA FOR EDI PURGE FILE                                *        
      ******************************************************************        
       01  FIOBL82.                                                     
         05  E-FBL82-PYMT-TS                  PIC X(26).                
         05  FILLER                           PIC X(01).                
         05  E-FBL82-ROUTING-NO               PIC 9(12).                
         05  FILLER                           PIC X(01).                
         05  E-FBL82-EFFECTIVE-DT             PIC X(10).                
         05  FILLER                           PIC X(01).                
         05  E-FBL82-PAYER-NAME               PIC X(35).                
         05  FILLER                           PIC X(14).                
      *                                                                 00750000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP442'.
MSQ017     COPY MFASQLM.
       01  WS-MISC.                                                     
           05  WS-FBL82-STATUS            PIC XX     VALUE '  '.        
               88  FBL82-SUCCESSFUL                  VALUE '00'.        
               88  FBL82-WRITE-OK                    VALUE '00'.        
                                                                        
       01  WS-COUNTERS.                                                 
           05 WS-ACCT-TOTAL               PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-ERR-MSG                  PIC X(100)     VALUE SPACES.  
           05 WS-DISP-TS                  PIC 9(13).                    
                                                                        
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_PYMT_HDR - JH                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPYMTHD                                                 
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
      * DECLARE ACCOUNT TABLE CURSOR                                            
           EXEC SQL                                                     
            DECLARE EDI_CSR CURSOR WITH HOLD FOR                        
             SELECT JH.EFFECTIVE_DT                                     
                   ,JH.PAYER_NM                                         
                   ,JH.SENDER_ROUTING_NO                                
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), JH.TRANSACTION_TS
           , 121), ' ', '-'), ':', '.') TRANSACTION_TS                         
               FROM CSS_EDI_PYMT_HDR JH WITH(READUNCOMMITTED)                   
              WHERE JH.EFFECTIVE_DT < DATEADD( MONTH, -6, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )           
                FOR READ ONLY                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE EDI_CSR CURSOR WITH HOLD FOR                                
MFA-TR*      SELECT JH.EFFECTIVE_DT                                             
MFA-TR*            ,JH.PAYER_NM                                                 
MFA-TR*            ,JH.SENDER_ROUTING_NO                                        
MFA-TR*            ,JH.TRANSACTION_TS                                           
MFA-TR*        FROM CSS_EDI_PYMT_HDR JH                                         
MFA-TR*       WHERE JH.EFFECTIVE_DT < CURRENT DATE - 6 MONTHS                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC                                                             
                                                                        
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE                            
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           OPEN OUTPUT FCSBL82-FILE                                     
           IF WS-FBL82-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBL82'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL82-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT ACTIVE ACCOUNTS AND GET BILLING DETAILS                 *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 7100-OPEN-PYMT-CSR                                   
              THRU 7100-EXIT                                            
           PERFORM 7200-FETCH-PYMT-CSR                                  
              THRU 7200-EXIT                                            
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE JH-TRANSACTION-TS TO WS-DISP-TS                      
                                                                        
              PERFORM 2100-PROCESS-PYMT-DET                             
                 THRU 2100-EXIT                                         
              PERFORM 7200-FETCH-PYMT-CSR                               
                 THRU 7200-EXIT                                         
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7300-CLOSE-PYMT-CSR                                  
              THRU 7300-EXIT                                            
                                                                        
           CLOSE FCSBL82-FILE                                           
           IF WS-FBL82-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   1000-PROCESS-ACCOUNTS            '         
               DISPLAY '**   ERROR CLOSING FCSBL82'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL82-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
                                                                        
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * GET EDI HEADER DETAILS AND WRITE ACCOUNTS TO A FILE THAT ARE   *        
      * MORE THAN 6 MONTHS OLD.                                        *        
      *----------------------------------------------------------------*        
       2100-PROCESS-PYMT-DET.                                           
      *----------------------*                                                  
           MOVE '2100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE SPACES                   TO FIOBL82                     
           MOVE JH-EFFECTIVE-DT          TO E-FBL82-EFFECTIVE-DT        
           MOVE JH-SENDER-ROUTING-NO     TO E-FBL82-ROUTING-NO          
           MOVE JH-TRANSACTION-TS        TO E-FBL82-PYMT-TS             
           MOVE JH-PAYER-NM              TO E-FBL82-PAYER-NAME          
                                                                        
           WRITE FIOBL82                                                
                                                                        
           IF FBL82-WRITE-OK                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSXP442 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR WRITING FCSBL82        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL82-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
                                                                        
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * OPEN EDI HEADER CURSOR                                         *        
      *----------------------------------------------------------------*        
       7100-OPEN-PYMT-CSR.                                              
      *----------------------*                                                  
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN EDI_CSR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING EDI_CSR CURSOR **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH ACTIVE ACCOUNTS WHICH ARE SIX MONTHS OLD.                *        
      *----------------------------------------------------------------*        
       7200-FETCH-PYMT-CSR.                                             
      *----------------------*                                                  
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH EDI_CSR                                             
               INTO :JH-EFFECTIVE-DT                                    
                   ,:JH-PAYER-NM                                        
                   ,:JH-SENDER-ROUTING-NO                               
                   ,:JH-TRANSACTION-TS                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-ACCT-TOTAL                                 
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR FETCHING EDI_CSR CURSOR **'                
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE ACCOUNT TABLE CURSOR                                     *        
      *----------------------------------------------------------------*        
       7300-CLOSE-PYMT-CSR.                                             
      *----------------------*                                                  
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE EDI_CSR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ERROR CLOSING EDI_CSR CURSOR **'                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY ERRORS                                                 *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'     
           DISPLAY '**     PCSXP442  PROCESSING ERROR           **'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'     
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE            
           DISPLAY '**       PROCESSING TERMINATED              **'     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY MESSAGES                                               *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           DISPLAY 'TOTAL NO OF ACCOUNTS SELECTED           = '         
                   WS-ACCT-TOTAL                                        
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PERFORM ABEND USING 9900-ABEND PARAGRAPH                                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
