       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP441.                                        
       AUTHOR.         PRIYA.                                           
       DATE-WRITTEN.   OCT, 2008.                                       
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      **                     PCSXP441 NARRATIVE                                 
      **                                                                        
      **  THIS PROGRAM PURGES DATA FROM THE EDI BILLING TABLES BASED            
      **  ON ACCOUNT NUMBER AND BILL NUMBER FROM THE INPUT FILE.                
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
C37648**  10/22/08  PRIYA        CLONE OF PCSCA841                   **         
      **                                                             ** 00410000
      ***************************************************************** 00420000
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSBL84-FILE                                          
               ASSIGN TO UT-S-FCSBL84                                   
               FILE STATUS IS WS-FBL84-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * FD STATEMENT FOR A FIXED LENGTH EDI PURGE FILE                 *        
      *                                                                *        
      ******************************************************************        
       FD  FCSBL84-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD                                   
           RECORDING MODE IS F                                          
           DATA RECORD IS FIOBL84.                                      
                                                                        
      *FIOBL84                                                                  
      ******************************************************************        
      *  FIOBL84                                                       *        
      *      IO AREA FOR EDI PURGE FILE                                *        
      ******************************************************************        
       01  FIOBL84.                                                     
         05  E-FBL84-ACCOUNT-NO               PIC 9(13).                
         05  FILLER                           PIC X(01).                
         05  E-FBL84-BILL-NO                  PIC 9(04).                
         05  FILLER                           PIC X(01).                
         05  E-FBL84-SCHED-SEND-DT            PIC X(10).                
         05  FILLER                           PIC X(01).                
         05  E-FBL84-CUSTOMER-NAME            PIC X(35).                
      *                                                                 00750000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP441'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-FIOBL84.                                                  
           05  WS-ACCOUNT-NO                    PIC 9(13).              
           05  FILLER                           PIC X(01).              
           05  WS-BILL-NO                       PIC 9(04).              
           05  FILLER                           PIC X(01).              
           05  WS-SCHED-SEND-DT                 PIC X(10).              
           05  FILLER                           PIC X(01).              
           05  WS-CUSTOMER-NAME                 PIC X(35).              
                                                                        
       01  WS-MISC.                                                     
           05  WS-FBL84-STATUS            PIC XX     VALUE '  '.        
               88  FBL84-SUCCESSFUL                  VALUE '00'.        
               88  FBL84-READ-OK                     VALUE '00' '04'.   
           05  WS-END-OF-BL84             PIC X      VALUE ' '.         
               88  END-OF-BL84                       VALUE 'Y'.         
               88  PROCESS-BL84                      VALUE ' '.         
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-Y                        PIC X(01) VALUE 'Y'.          
                                                                        
       01  WS-COUNTERS.                                                 
           05 WS-EDI-HDR-CNT              PIC S9(9) COMP VALUE 0.       
           05 WS-EDI-CHRGS-CNT            PIC S9(9) COMP VALUE 0.       
           05 WS-EDI-USAGE-CNT            PIC S9(4) COMP VALUE 0.       
           05 WS-READ-COMMIT-CNT          PIC S9(9) COMP VALUE 0.       
           05 WS-COMMIT-NO                PIC S9(9) COMP VALUE 0.       
           05 WS-READ-COMMIT              PIC S9(9) COMP VALUE 1000.    
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-ERR-MSG                  PIC X(100)     VALUE SPACES.  
           05 WS-ERR-MSG2                 PIC X(100)     VALUE SPACES.  
       01  WS-COMMIT-DATA.                                              
           05 FILLER                      PIC X(67).                    
                                                                        
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_BILL_HDR - HZ                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBILHDR                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_BILL_USAGE - HW                                       *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLUSGE                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_BILL_CHRGS - HF                                       *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLCHGS                                                 
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE                            
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  INITIALIZE                                                    *        
      *----------------------------------------------------------------*        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           OPEN INPUT FCSBL84-FILE                                      
           IF WS-FBL84-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBL84'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL84-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READ EDI PURGE FILE AND DELETE BY ACCOUNT NO AND BILL NO.      *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
      *                                                                         
           PERFORM 7000-READ-PURGE-FILE                                 
              THRU 7000-EXIT                                            
                                                                        
           PERFORM UNTIL END-OF-BL84                                    
                                                                        
              MOVE WS-ACCOUNT-NO    TO                                  
                                    HZ-ACCOUNT-NO                       
                                    HW-ACCOUNT-NO                       
                                    HF-ACCOUNT-NO                       
                                                                        
              MOVE WS-BILL-NO       TO                                  
                                    HZ-BILL-NO                          
                                    HW-BILL-NO                          
                                    HF-BILL-NO                          
                                                                        
              PERFORM 2000-PROCESS-DELETION                             
                 THRU 2000-EXIT                                         
              IF WS-READ-COMMIT-CNT = WS-READ-COMMIT                    
                 PERFORM 8999-ISSUE-COMMIT                              
                    THRU 8999-EXIT                                      
                 MOVE 0 TO WS-READ-COMMIT-CNT                           
                 ADD +1 TO WS-COMMIT-NO                                 
                 DISPLAY 'THIS IS A READ COMMIT, ACCOUNT = ',           
                       WS-ACCOUNT-NO                                    
              END-IF                                                    
              PERFORM 7000-READ-PURGE-FILE                              
                 THRU 7000-EXIT                                         
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7100-CLOSE-PURGE-FILE                                
              THRU 7100-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE ROWS WHICH ARE MORE THAN 6 MONTHS OLD FOR AN ACCOUNT    *        
      *----------------------------------------------------------------*        
       2000-PROCESS-DELETION.                                           
      *----------------------*                                                  
           MOVE '2000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 8100-DELETE-BILL-USAGE                               
              THRU 8100-EXIT                                            
           PERFORM 8200-DELETE-BILL-CHRGS                               
              THRU 8200-EXIT                                            
           PERFORM 8300-DELETE-BILL-HDR                                 
              THRU 8300-EXIT                                            
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READ EDI PURGE FILE                                            *        
      *----------------------------------------------------------------*        
       7000-READ-PURGE-FILE.                                            
      *----------------------*                                                  
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSBL84-FILE INTO WS-FIOBL84                            
               AT END                                                   
                  MOVE WS-Y TO WS-END-OF-BL84.                          
           IF FBL84-READ-OK OR END-OF-BL84                              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSXP441 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBL84        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL84-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           IF FBL84-READ-OK                                             
              ADD +1 TO WS-READ-COMMIT-CNT
           END-IF                              
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE EDI PURGE FILE                                           *        
      *----------------------------------------------------------------*        
       7100-CLOSE-PURGE-FILE.                                           
      *----------------------*                                                  
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           CLOSE FCSBL84-FILE                                           
           IF FBL84-READ-OK                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSXP441 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR CLOSING FCSBL84        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL84-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE CSS_EDI_BILL_USAGE TABLE ROWS                           *        
      *----------------------------------------------------------------*        
       8100-DELETE-BILL-USAGE.                                          
      *---------------------*                                                   
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_EDI_BILL_USAGE                             
              WHERE ACCOUNT_NO = :HW-ACCOUNT-NO                         
                AND BILL_NO    = :HW-BILL-NO                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-EDI-USAGE-CNT                              
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR DELETING CSS_EDI_BILL_USAGE ** '           
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' HW.ACCOUNT_NO = ' WS-ACCOUNT-NO                  
                     ',HW.BILL_NO    = ' WS-BILL-NO                     
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE CSS_EDI_BILL_CHRGS TABLE ROWS                           *        
      *----------------------------------------------------------------*        
       8200-DELETE-BILL-CHRGS.                                          
      *--------------------*                                                    
           MOVE '8200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_EDI_BILL_CHRGS                             
              WHERE ACCOUNT_NO        = :HF-ACCOUNT-NO                  
                AND BILL_NO           = :HF-BILL-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-EDI-CHRGS-CNT                              
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR DELETING CSS_EDI_BILL_CHRGS ** '           
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' HF.ACCOUNT_NO        = ' WS-ACCOUNT-NO           
                     ',HF.BILL_NO           = ' WS-BILL-NO              
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE CSS_EDI_BILL_HDR TABLE ROWS                           *          
      *----------------------------------------------------------------*        
       8300-DELETE-BILL-HDR.                                            
      *---------------------*                                                   
           MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_EDI_BILL_HDR                               
              WHERE ACCOUNT_NO        = :HZ-ACCOUNT-NO                  
                AND BILL_NO           = :HZ-BILL-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-EDI-HDR-CNT                                
              ELSE                                                      
                 DISPLAY '** BILL NUMBER NOT FOUND FOR ACCOUNT - ',     
                 WS-ACCOUNT-NO, 'BILL NO - ', WS-BILL-NO                
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR DELETING CSS_EDI_BILL_HDR  ** '            
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' HZ.ACCOUNT_NO = ' WS-ACCOUNT-NO                  
                     ',HZ.BILL_NO    = ' WS-BILL-NO                     
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY ERRORS                                                 *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'     
           DISPLAY '**     PCSXP441  PROCESSING ERROR           **'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'     
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE            
           DISPLAY '**       PROCESSING TERMINATED              **'     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * COMMIT DB2                                                    *         
      *---------------------------------------------------------------*         
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
           .                                                                    
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY MESSAGES                                               *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           DISPLAY 'TOTAL NO OF COMMITS = ' WS-COMMIT-NO                
                                                                        
           DISPLAY 'TOTAL NO OF ACCOUNTS SELECTED           = '         
                   WS-READ-COMMIT-CNT                                   
           DISPLAY 'ACCOUNTS AFFECTED IN CSS_EDI_BILL_HDR   = '         
                   WS-EDI-HDR-CNT                                       
           DISPLAY 'ACCOUNTS AFFECTED IN CSS_EDI_BILL_CHRGS = '         
                    WS-EDI-CHRGS-CNT                                    
           DISPLAY 'ACCOUNTS AFFECTED IN CSS_EDI_BILL_USAGE = '         
                    WS-EDI-USAGE-CNT                                    
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PERFORM ABEND USING 9900-ABEND PARAGRAPH                                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
