       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSXP440.                                            
       AUTHOR. PRIYA.                                                   
       DATE-WRITTEN. OCT 2008.                                          
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      * THIS PROGRAM BUILDS A FILE THAT IS USED BY PCSXP441 TO        *         
      * DELETE EDI RECORDS FROM TEH FOLLOWING TABLES                  *         
      * CSS_EDI_BILL_HDR                                              *         
      * CSS_EDI_BILL_CHRGS                                            *         
      * CSS_EDI_BILL_USAGE                                            *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *   DATE       INITIALS    REASON                               *         
      * ----------  ------------ -------------------------------------*         
C37648* 10/22/2008  SIVAPRIYA    CLONE OF PCSCA840                    *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
             ---- BASIC SEQUENCE STRUCTURE ----                         
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSBL84-FILE                                          
               ASSIGN TO UT-S-FCSBL84                                   
               FILE STATUS IS WS-FBL84-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************        
      * FD STATEMENT FOR A FIXED LENGTH EDI PURGE FILE                 *        
      *                                                                *        
      ******************************************************************        
       FD  FCSBL84-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
      *FIOBL84                                                                  
      ******************************************************************        
      *  FIOBL84                                                       *        
      *      IO AREA FOR EDI PURGE FILE                                *        
      ******************************************************************        
       01  FIOBL84.                                                     
         05  E-FBL84-ACCOUNT-NO               PIC 9(13).                
         05  FILLER                           PIC X(01).                
         05  E-FBL84-BILL-NO                  PIC 9(04).                
         05  FILLER                           PIC X(01).                
         05  E-FBL84-SCHED-SEND-DT            PIC X(10).                
         05  FILLER                           PIC X(01).                
         05  E-FBL84-CUSTOMER-NAME            PIC X(35).                
      *                                                                 00750000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP440'.
MSQ017     COPY MFASQLM.
       01  WS-MISC.                                                     
           05  WS-FBL84-STATUS            PIC XX     VALUE '  '.        
               88  FBL84-SUCCESSFUL                  VALUE '00'.        
               88  FBL84-WRITE-OK                    VALUE '00'.        
                                                                        
       01  WS-COUNTERS.                                                 
           05 WS-ACCT-TOTAL               PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WS-VARIABLES.                                                
COB305     05 WS-START-ACCT        PIC S9(13)V USAGE COMP-3 VALUE 0.     
COB305     05 WS-END-ACCT        PIC S9(13)V USAGE COMP-3 VALUE 0.     
           05 WS-ERR-MSG                  PIC X(100)     VALUE SPACES.  
           05 WS-DISP-ACCOUNT-NO          PIC 9(13).                    
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_BILL_HDR - HZ                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBILHDR                                                 
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
      * DECLARE ACCOUNT TABLE CURSOR                                            
           EXEC SQL                                                     
            DECLARE EDI_CSR CURSOR WITH HOLD FOR                        
             SELECT HZ.ACCOUNT_NO                                       
                   ,HZ.BILL_NO                                          
                   ,HZ.SCHED_SEND_DT                                    
                   ,HZ.CUSTOMER_NA                                      
               FROM CSS_EDI_BILL_HDR HZ WITH(READUNCOMMITTED)                   
              WHERE HZ.ACCOUNT_NO > :WS-START-ACCT                      
                AND HZ.ACCOUNT_NO < :WS-END-ACCT                        
                AND HZ.SCHED_SEND_DT < DATEADD( MONTH, -6, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )          
                FOR READ ONLY                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE EDI_CSR CURSOR WITH HOLD FOR                                
MFA-TR*      SELECT HZ.ACCOUNT_NO                                               
MFA-TR*            ,HZ.BILL_NO                                                  
MFA-TR*            ,HZ.SCHED_SEND_DT                                            
MFA-TR*            ,HZ.CUSTOMER_NA                                              
MFA-TR*        FROM CSS_EDI_BILL_HDR HZ                                         
MFA-TR*       WHERE HZ.ACCOUNT_NO > :WS-START-ACCT                              
MFA-TR*         AND HZ.ACCOUNT_NO < :WS-END-ACCT                                
MFA-TR*         AND HZ.SCHED_SEND_DT < CURRENT DATE - 6 MONTHS                  
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC                                                             
                                                                        
       LINKAGE SECTION.                                                 
       01 LS-PARM-ACCOUNT.                                              
          05 LS-LENGTH                              PIC S9(02) COMP.    
          05 LS-START-ACCT                          PIC 9(13).          
          05 LS-END-ACCT                            PIC 9(13).          
       PROCEDURE DIVISION USING LS-PARM-ACCOUNT.                        
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE                            
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE LS-START-ACCT            TO WS-START-ACCT               
           MOVE LS-END-ACCT              TO WS-END-ACCT                 
                                                                        
           DISPLAY 'START ACCOUNT = ', WS-START-ACCT                    
           DISPLAY '** END ACCOUNT = ', WS-END-ACCT                     
                                                                        
           OPEN OUTPUT FCSBL84-FILE                                     
           IF WS-FBL84-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBL84'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL84-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
                                                                        
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT ACTIVE ACCOUNTS AND GET BILLING DETAILS                 *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 7100-OPEN-ACCOUNT-CSR                                
              THRU 7100-EXIT                                            
           PERFORM 7200-FETCH-ACCOUNT-CSR                               
              THRU 7200-EXIT                                            
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE HZ-ACCOUNT-NO TO WS-DISP-ACCOUNT-NO                  
                                                                        
              PERFORM 2100-PROCESS-BILL-DET                             
                 THRU 2100-EXIT                                         
              PERFORM 7200-FETCH-ACCOUNT-CSR                            
                 THRU 7200-EXIT                                         
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7300-CLOSE-ACCOUNT-CSR                               
              THRU 7300-EXIT                                            
                                                                        
           CLOSE FCSBL84-FILE                                           
           IF WS-FBL84-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   1000-PROCESS-ACCOUNTS            '         
               DISPLAY '**   ERROR CLOSING FCSBL84'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL84-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
                                                                        
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * GET EDI HEADER DETAILS AND WRITE ACCOUNTS TO A FILE THAT ARE   *        
      * MORE THAN 6 MONTHS OLD.                                        *        
      *----------------------------------------------------------------*        
       2100-PROCESS-BILL-DET.                                           
      *----------------------*                                                  
           MOVE '2100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE SPACES                   TO FIOBL84                     
           MOVE HZ-ACCOUNT-NO            TO E-FBL84-ACCOUNT-NO          
           MOVE HZ-BILL-NO               TO E-FBL84-BILL-NO             
           MOVE HZ-SCHED-SEND-DT         TO E-FBL84-SCHED-SEND-DT       
           MOVE HZ-CUSTOMER-NA-TEXT      TO E-FBL84-CUSTOMER-NAME       
                                                                        
           WRITE FIOBL84                                                
                                                                        
           IF FBL84-WRITE-OK                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**       2100-PROCESS-BILL-DET        **'       
               DISPLAY '**     PCSXP440 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR WRITING FCSBL84        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL84-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF                        
                                                                        
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * OPEN EDI HEADER CURSOR                                         *        
      *----------------------------------------------------------------*        
       7100-OPEN-ACCOUNT-CSR.                                           
      *----------------------*                                                  
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN EDI_CSR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING EDI_CSR CURSOR **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH ACTIVE ACCOUNTS WHICH ARE SIX MONTHS OLD.                *        
      *----------------------------------------------------------------*        
       7200-FETCH-ACCOUNT-CSR.                                          
      *----------------------*                                                  
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH EDI_CSR                                             
               INTO :HZ-ACCOUNT-NO                                      
                   ,:HZ-BILL-NO                                         
                   ,:HZ-SCHED-SEND-DT                                   
                   ,:HZ-CUSTOMER-NA                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-ACCT-TOTAL                                 
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR FETCHING EDI_CSR CURSOR **'                
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE ACCOUNT TABLE CURSOR                                     *        
      *----------------------------------------------------------------*        
       7300-CLOSE-ACCOUNT-CSR.                                          
      *----------------------*                                                  
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE EDI_CSR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ERROR CLOSING EDI_CSR CURSOR **'                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY ERRORS                                                 *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'     
           DISPLAY '**     PCSXP440  PROCESSING ERROR           **'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'     
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE            
           DISPLAY '**       PROCESSING TERMINATED              **'     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY MESSAGES                                               *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           DISPLAY 'TOTAL NO OF ACCOUNTS SELECTED           = '         
                   WS-ACCT-TOTAL                                        
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PERFORM ABEND USING 9900-ABEND PARAGRAPH                                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
