       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSXP434.                                            
       AUTHOR. RICK SPIRES.                                             
       DATE-WRITTEN. DEC 2008.                                          
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      * THIS PROGRAM BUILDS A FILE THAT IS USED BY PCSXP435 TO        *         
      * DELETE EDI RECORDS FROM CSS_EDI_COMP_ACCT.                    *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *   DATE       INITIALS    REASON                               *         
      * ----------  ------------ -------------------------------------*         
C36006* 12/18/2008  RICK SPIRES  NEW PROGRAM                          *         
C36006* 04/17/2009  RICK SPIRES  CORRECT WITH CODE REVIEW CHANGES     *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
             ---- BASIC SEQUENCE STRUCTURE ----                         
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSBL34-FILE                                          
               ASSIGN TO UT-S-FCSBL34                                   
               FILE STATUS IS WS-FBL34-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************        
      * FD STATEMENT FOR A FIXED LENGTH EDI PURGE FILE                 *        
      *                                                                *        
      ******************************************************************        
       FD  FCSBL34-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
      *FIOBL34                                                                  
      ******************************************************************        
      *  FIOBL34                                                       *        
      *      IO AREA FOR EDI PURGE FILE                                *        
      ******************************************************************        
       01  FIOBL34.                                                     
         05  E-FBL34-ACCOUNT-NO               PIC 9(13).                
         05  FILLER                           PIC X(01).                
         05  E-FBL34-COMPANY-ID               PIC X(10).                
         05  FILLER                           PIC X(01).                
         05  E-FBL34-ACCT-STAT                PIC X(01).                
         05  FILLER                           PIC X(04).                
      *                                                                 00750000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP434'.
MSQ017     COPY MFASQLM.
       01  WS-MISC.                                                     
           05  WS-FBL34-STATUS            PIC XX     VALUE '  '.        
               88  FBL34-SUCCESSFUL                  VALUE '00'.        
               88  FBL34-WRITE-OK                    VALUE '00'.        
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP434'.   
                                                                        
       01  WS-COUNTERS.                                                 
           05 WS-ACCT-TOTAL               PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-ERR-MSG                  PIC X(100)     VALUE SPACES.  
           05 WS-ERR-MSG2                 PIC X(100)     VALUE SPACES.  
           05 WS-DISP-ACCOUNT-NO          PIC 9(13).                    
                                                                        
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_COMP_ACCT  IK                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBIDACCT                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT AT                                                *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
      * DECLARE ACCOUNT TABLE CURSOR                                            
           EXEC SQL                                                     
            DECLARE EDI_CSR CURSOR FOR                                  
             SELECT IK.ACCOUNT_NO                                       
                   ,EDI_COMPANY_ID                                      
                   ,AT.CODE_ACCT_STAT                                   
               FROM CSS_EDI_COMP_ACCT IK WITH(READUNCOMMITTED)                  
                   ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE IK.ACCOUNT_NO = AT.ACCOUNT_NO                       
                AND  AT.CODE_ACCT_STAT IN('B','J','S')                  
                FOR READ ONLY                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE EDI_CSR CURSOR FOR                                          
MFA-TR*      SELECT IK.ACCOUNT_NO                                               
MFA-TR*            ,EDI_COMPANY_ID                                              
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*        FROM CSS_EDI_COMP_ACCT IK                                        
MFA-TR*            ,CSS_ACCOUNT AT                                              
MFA-TR*       WHERE IK.ACCOUNT_NO = AT.ACCOUNT_NO                               
MFA-TR*         AND  AT.CODE_ACCT_STAT IN('B','J','S')                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC                                                             
                                                                        
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE                            
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           OPEN OUTPUT FCSBL34-FILE                                     
           IF WS-FBL34-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBL34'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL34-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT ACTIVE ACCOUNTS AND GET BILLING DETAILS                 *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 7100-OPEN-EDI-CSR                                    
              THRU 7100-EXIT                                            
           PERFORM 7200-FETCH-EDI-CSR                                   
              THRU 7200-EXIT                                            
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE IK-ACCOUNT-NO TO WS-DISP-ACCOUNT-NO                  
                                                                        
              PERFORM 2100-PROCESS-EDI-COMP                             
                 THRU 2100-EXIT                                         
              PERFORM 7200-FETCH-EDI-CSR                                
                 THRU 7200-EXIT                                         
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7300-CLOSE-EDI-CSR                                   
              THRU 7300-EXIT                                            
                                                                        
           CLOSE FCSBL34-FILE                                           
           IF WS-FBL34-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   1000-PROCESS-ACCOUNTS            '         
               DISPLAY '**   ERROR CLOSING FCSBL34'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL34-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * GET EDI COMPANY ACCOUNT AND WRITE ACCOUNTS TO A FILE THAT ARE  *        
      * INACTIVE ON CSS_ACCOUNT.                                       *        
      *----------------------------------------------------------------*        
       2100-PROCESS-EDI-COMP.                                           
      *----------------------*                                                  
           MOVE '2100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE SPACES                   TO FIOBL34                     
           MOVE IK-ACCOUNT-NO            TO E-FBL34-ACCOUNT-NO          
           MOVE IK-EDI-COMPANY-ID        TO E-FBL34-COMPANY-ID          
           MOVE AT-CODE-ACCT-STAT        TO E-FBL34-ACCT-STAT           
                                                                        
           WRITE FIOBL34                                                
                                                                        
           IF FBL34-WRITE-OK                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**       2100-PROCESS-BILL-DET        **'       
               DISPLAY '**     PCSXP434 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR WRITING FCSBL34        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL34-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * OPEN EDI COMP ACCT CURSOR                                      *        
      *----------------------------------------------------------------*        
       7100-OPEN-EDI-CSR.                                               
      *----------------------*                                                  
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN EDI_CSR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING EDI_CSR CURSOR **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH INACTIVE ACCOUNTS.                                       *        
      *----------------------------------------------------------------*        
       7200-FETCH-EDI-CSR.                                              
      *----------------------*                                                  
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH EDI_CSR                                             
               INTO :IK-ACCOUNT-NO                                      
                   ,:IK-EDI-COMPANY-ID                                  
                   ,:AT-CODE-ACCT-STAT                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-ACCT-TOTAL                                 
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR FETCHING EDI_CSR CURSOR **'                
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE ACCOUNT TABLE CURSOR                                     *        
      *----------------------------------------------------------------*        
       7300-CLOSE-EDI-CSR.                                              
      *----------------------*                                                  
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE EDI_CSR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ERROR CLOSING EDI_CSR CURSOR **'                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY ERRORS                                                 *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'     
           DISPLAY '**     PCSXP434  PROCESSING ERROR           **'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'     
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE            
           DISPLAY '**       PROCESSING TERMINATED              **'     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY MESSAGES                                               *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           DISPLAY 'TOTAL NO OF ACCOUNTS SELECTED           = '         
                   WS-ACCT-TOTAL                                        
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PERFORM ABEND USING 9900-ABEND PARAGRAPH                                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
