       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP433.                                        
       AUTHOR.         RICK SPIRES.                                     
       DATE-WRITTEN.   DEC, 2008.                                       
           DATE-COMPILED.                                               
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      **                     PCSXP433 NARRATIVE                                 
      **                                                                        
      **  THIS PROGRAM PURGES DATA FROM THE EDI ACCOUNT DESTINATION             
      **  TABLE BASED ON ACCOUNT NUMBER FROM THE INPUT FILE.                    
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **12/18/2008  R.SPIRES     INITIAL PROGRAM                     **         
C36006* 04/17/2009  RICK SPIRES  CORRECT WITH CODE REVIEW CHANGES     *         
      **                                                             ** 00410000
      ***************************************************************** 00420000
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSBL32-FILE                                          
               ASSIGN TO UT-S-FCSBL32                                   
               FILE STATUS IS WS-FBL32-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * FD STATEMENT FOR A FIXED LENGTH EDI PURGE FILE                 *        
      *                                                                *        
      ******************************************************************        
       FD  FCSBL32-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD                                   
           RECORDING MODE IS F                                          
           DATA RECORD IS FIOBL32.                                      
                                                                        
      *FIOBL32                                                                  
      ******************************************************************        
      *  FIOBL32                                                       *        
      *      IO AREA FOR EDI PURGE FILE                                *        
      ******************************************************************        
       01  FIOBL32.                                                     
         05  E-FBL32-ACCOUNT-NO               PIC 9(13).                
         05  FILLER                           PIC X(01).                
         05  E-FBL32-DEST-ID                  PIC X(10).                
         05  FILLER                           PIC X(01).                
         05  E-FBL32-STATUS-CD                PIC X(01).                
         05  FILLER                           PIC X(01).                
         05  E-FBL32-ACCT-STAT                PIC X(01).                
         05  FILLER                           PIC X(02).                
      *                                                                 00750000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP433'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-FIOBL32.                                                  
           05  WS-ACCOUNT-NO                    PIC 9(13).              
           05  FILLER                           PIC X(01).              
           05  WS-DEST-ID                       PIC X(10).              
           05  FILLER                           PIC X(01).              
           05  WS-STATUS-CD                     PIC X(01).              
           05  FILLER                           PIC X(01).              
           05  WS-ACCT-STAT                     PIC X(01).              
           05  FILLER                           PIC X(02).              
                                                                        
       01  WS-MISC.                                                     
           05  WS-FBL32-STATUS            PIC XX     VALUE '  '.        
               88  FBL32-SUCCESSFUL                  VALUE '00'.        
               88  FBL32-READ-OK                     VALUE '00' '04'.   
           05  WS-END-OF-BL32             PIC X      VALUE ' '.         
               88  END-OF-BL32                       VALUE 'Y'.         
               88  PROCESS-BL32                      VALUE ' '.         
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP433'.   
           05 WS-Y                        PIC X(01) VALUE 'Y'.          
                                                                        
       01  WS-COUNTERS.                                                 
           05 WS-READ-COMMIT-CNT          PIC S9(9) COMP VALUE 0.       
           05 WS-EDI-HDR-CNT              PIC S9(4) COMP VALUE 0.       
           05 WS-COMMIT-NO                PIC S9(9) COMP VALUE 0.       
           05 WS-READ-COMMIT              PIC S9(9) COMP VALUE 1000.    
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-ERR-MSG                  PIC X(100)     VALUE SPACES.  
           05 WS-ERR-MSG2                 PIC X(100)     VALUE SPACES.  
                                                                        
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_ACCT_DEST  NF                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACDEST                                                 
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE                            
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  INITIALIZE                                                    *        
      *----------------------------------------------------------------*        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           OPEN INPUT FCSBL32-FILE                                      
           IF WS-FBL32-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBL32'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL32-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READ EDI PURGE FILE AND DELETE BY ACCOUNT NO AND BILL NO.      *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
      *                                                                         
           PERFORM 7000-READ-PURGE-FILE                                 
              THRU 7000-EXIT                                            
                                                                        
           PERFORM UNTIL END-OF-BL32                                    
                                                                        
              MOVE WS-ACCOUNT-NO TO NF-ACCOUNT-NO                       
              MOVE WS-DEST-ID    TO NF-DEST-ID                          
                                                                        
              PERFORM 2000-PROCESS-DELETION                             
                 THRU 2000-EXIT                                         
              IF WS-READ-COMMIT-CNT = WS-READ-COMMIT                    
                 PERFORM 8999-ISSUE-COMMIT                              
                    THRU 8999-EXIT                                      
                 MOVE 0 TO WS-READ-COMMIT-CNT                           
                 ADD +1 TO WS-COMMIT-NO                                 
                 DISPLAY 'THIS IS A READ COMMIT, ACCOUNT = ',           
                       WS-ACCOUNT-NO                                    
              END-IF                                                    
              PERFORM 7000-READ-PURGE-FILE                              
                 THRU 7000-EXIT                                         
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7100-CLOSE-PURGE-FILE                                
              THRU 7100-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE ROWS WHICH ARE MORE THAN 6 MONTHS OLD FOR AN ACCOUNT    *        
      *----------------------------------------------------------------*        
       2000-PROCESS-DELETION.                                           
      *----------------------*                                                  
           MOVE '2000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 8100-DELETE-ACCT-DEST                                
              THRU 8100-EXIT                                            
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * READ EDI PURGE FILE                                            *        
      *----------------------------------------------------------------*        
       7000-READ-PURGE-FILE.                                            
      *----------------------*                                                  
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSBL32-FILE INTO WS-FIOBL32                            
               AT END                                                   
                  MOVE WS-Y TO WS-END-OF-BL32.                          
           IF FBL32-READ-OK OR END-OF-BL32                              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSXP433 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBL32        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL32-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           IF FBL32-READ-OK                                             
              ADD +1 TO WS-READ-COMMIT-CNT                              
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE EDI PURGE FILE                                           *        
      *----------------------------------------------------------------*        
       7100-CLOSE-PURGE-FILE.                                           
      *----------------------*                                                  
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           CLOSE FCSBL32-FILE                                           
           IF FBL32-READ-OK                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSXP433 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR CLOSING FCSBL32        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL32-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETE CSS_EDI_ACCT_DEST TABLE ROWS                            *        
      *----------------------------------------------------------------*        
       8100-DELETE-ACCT-DEST.                                           
      *---------------------*                                                   
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_EDI_ACCT_DEST                              
              WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                         
                AND DEST_ID    = :NF-DEST-ID                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-EDI-HDR-CNT                                
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR DELETING CSS_EDI_ACCT_DEST ** '            
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' HW.ACCOUNT_NO = ' WS-ACCOUNT-NO                  
                     ',HW.STATUS_CD  = ' WS-STATUS-CD                   
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY ERRORS                                                 *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'     
           DISPLAY '**     PCSXP433  PROCESSING ERROR           **'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'     
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE            
           DISPLAY '**       PROCESSING TERMINATED              **'     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * COMMIT DB2                                                    *         
      *---------------------------------------------------------------*         
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
           .                                                                    
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY MESSAGES                                               *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           DISPLAY 'TOTAL NO OF COMMITS = ' WS-COMMIT-NO                
                                                                        
           DISPLAY 'TOTAL NO OF ACCOUNTS SELECTED           = '         
                   WS-READ-COMMIT-CNT                                   
           DISPLAY 'ACCOUNTS AFFECTED IN CSS_EDI_ACCT_DEST  = '         
                   WS-EDI-HDR-CNT                                       
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PERFORM ABEND USING 9900-ABEND PARAGRAPH                                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
