       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSXP432.                                            
       AUTHOR. RICK SPIRES.                                             
       DATE-WRITTEN. DEC 2008.                                          
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
C36006* THIS PROGRAM BUILDS A FILE THAT IS USED BY PCSXP433 TO        *         
      * DELETE EDI RECORDS FROM CSS_EDI_ACCT_DEST.                    *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *   DATE       INITIALS    REASON                               *         
      * ----------  ------------ -------------------------------------*         
C36006* 12/10/2008  RICK SPIRES  NEW PROGRAM                          *         
C36006* 04/17/2009  RICK SPIRES  CORRECT WITH CODE REVIEW CHANGES     *         
C36006* 07/08/2009  RICK SPIRES  HOLD FINALED ACCOUNTS FOR 2 MONTHS   *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
             ---- BASIC SEQUENCE STRUCTURE ----                         
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSBL32-FILE                                          
               ASSIGN TO UT-S-FCSBL32                                   
               FILE STATUS IS WS-FBL32-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ******************************************************************        
      * FD STATEMENT FOR A FIXED LENGTH EDI PURGE FILE                 *        
      *                                                                *        
      ******************************************************************        
       FD  FCSBL32-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
      *FIOBL32                                                                  
      ******************************************************************        
      *  FIOBL32                                                       *        
      *      IO AREA FOR EDI PURGE FILE                                *        
      ******************************************************************        
       01  FIOBL32.                                                     
         05  E-FBL32-ACCOUNT-NO               PIC 9(13).                
         05  FILLER                           PIC X(01).                
         05  E-FBL32-DEST-ID                  PIC X(10).                
         05  FILLER                           PIC X(01).                
         05  E-FBL32-STATUS-CD                PIC X(01).                
         05  FILLER                           PIC X(01).                
         05  E-FBL32-ACCT-STAT                PIC X(01).                
         05  FILLER                           PIC X(02).                
      *                                                                 00750000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP432'.
MSQ017     COPY MFASQLM.
       01  WS-MISC.                                                     
           05  WS-FBL32-STATUS            PIC XX     VALUE '  '.        
               88  FBL32-SUCCESSFUL                  VALUE '00'.        
               88  FBL32-WRITE-OK                    VALUE '00'.        
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP432'.   
                                                                        
       01  WS-COUNTERS.                                                 
           05 WS-ACCT-TOTAL               PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-ERR-MSG                  PIC X(100)     VALUE SPACES.  
           05 WS-ERR-MSG2                 PIC X(100)     VALUE SPACES.  
           05 WS-DISP-ACCOUNT-NO          PIC 9(13).                    
A36006     05 WS-TS-MINUS-2-MNTHS         PIC  X(26)     VALUE SPACES.  
A36006     05 WS-FINAL-DT-NI              PIC S9(04) COMP VALUE 0.      
                                                                        
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_EDI_ACCT_DEST  NF                                         *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACDEST                                                 
           END-EXEC.                                                            
                                                                        
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
      * CSS_ACCOUNT AT                                                *         
      *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*         
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
      * DECLARE ACCOUNT TABLE CURSOR                                            
           EXEC SQL                                                     
            DECLARE EDI_CSR CURSOR FOR                                  
             SELECT NF.ACCOUNT_NO                                       
                   ,NF.DEST_ID                                          
                   ,NF.STATUS_CD                                        
                   ,AT.CODE_ACCT_STAT                                   
A36006             ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
               FROM CSS_EDI_ACCT_DEST NF WITH(READUNCOMMITTED)                  
                   ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE NF.ACCOUNT_NO = AT.ACCOUNT_NO                       
                AND (NF.STATUS_CD = 'I'                                 
                 OR (NF.STATUS_CD = 'A'                                 
                  AND AT.CODE_ACCT_STAT IN ('B','J','S')))              
                FOR READ ONLY                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE EDI_CSR CURSOR FOR                                          
MFA-TR*      SELECT NF.ACCOUNT_NO                                               
MFA-TR*            ,NF.DEST_ID                                                  
MFA-TR*            ,NF.STATUS_CD                                                
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*            ,AT.ACCT_FINALED_DT                                          
MFA-TR*        FROM CSS_EDI_ACCT_DEST NF                                        
MFA-TR*            ,CSS_ACCOUNT AT                                              
MFA-TR*       WHERE NF.ACCOUNT_NO = AT.ACCOUNT_NO                               
MFA-TR*         AND (NF.STATUS_CD = 'I'                                         
MFA-TR*          OR (NF.STATUS_CD = 'A'                                         
MFA-TR*           AND AT.CODE_ACCT_STAT IN ('B','J','S')))                      
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC                                                             
                                                                        
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE                            
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           OPEN OUTPUT FCSBL32-FILE                                     
           IF WS-FBL32-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBL32'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL32-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
A36006     PERFORM 7400-GET-TIMESTAMP THRU 7400-EXIT                    
A36006     DISPLAY 'CURRENT DAY - TWO MONTHS = ', WS-TS-MINUS-2-MNTHS   
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT ACTIVE ACCOUNTS AND GET BILLING DETAILS                 *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 7100-OPEN-EDI-CSR                                    
              THRU 7100-EXIT                                            
           PERFORM 7200-FETCH-EDI-CSR                                   
              THRU 7200-EXIT                                            
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE NF-ACCOUNT-NO TO WS-DISP-ACCOUNT-NO                  
                                                                        
              PERFORM 2100-PROCESS-EDI-DEST                             
                 THRU 2100-EXIT                                         
              PERFORM 7200-FETCH-EDI-CSR                                
                 THRU 7200-EXIT                                         
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7300-CLOSE-EDI-CSR                                   
              THRU 7300-EXIT                                            
                                                                        
           CLOSE FCSBL32-FILE                                           
           IF WS-FBL32-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   1000-PROCESS-ACCOUNTS            '         
               DISPLAY '**   ERROR CLOSING FCSBL32'                     
               DISPLAY '**   FILE STATUS = ' WS-FBL32-STATUS            
               DISPLAY '**************************************'         
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * BUILD A FILE WITH EDI ACCOUNT DESTINATION RECORDS THAT ARE     *        
      * INACTIVE ON CSS_EDI_ACCT_DEST OR CSS_ACCOUNT.                  *        
      *----------------------------------------------------------------*        
       2100-PROCESS-EDI-DEST.                                           
      *----------------------*                                                  
           MOVE '2100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE SPACES                   TO FIOBL32                     
           MOVE NF-ACCOUNT-NO            TO E-FBL32-ACCOUNT-NO          
           MOVE NF-DEST-ID               TO E-FBL32-DEST-ID             
           MOVE NF-STATUS-CD             TO E-FBL32-STATUS-CD           
           MOVE AT-CODE-ACCT-STAT        TO E-FBL32-ACCT-STAT           
                                                                        
A36006     IF WS-FINAL-DT-NI = -1                                       
A36006        GO TO 2100-EXIT                                           
A36006     END-IF                                                       
A36006                                                                  
A36006     IF NF-STATUS-CD = 'A'                                        
A36006       IF AT-CODE-ACCT-STAT = 'B'                                 
A36006         IF AT-ACCT-FINALED-DT > WS-TS-MINUS-2-MNTHS              
A36006            GO TO 2100-EXIT                                       
A36006         END-IF                                                   
A36006       END-IF                                                     
A36006     END-IF                                                       
                                                                        
           WRITE FIOBL32                                                
                                                                        
           IF FBL32-WRITE-OK                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**       2100-PROCESS-BILL-DET        **'       
               DISPLAY '**     PCSXP432 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR WRITING FCSBL32        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBL32-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * OPEN EDI DEST CURSOR                                           *        
      *----------------------------------------------------------------*        
       7100-OPEN-EDI-CSR.                                               
      *----------------------*                                                  
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN EDI_CSR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING EDI_CSR CURSOR **'                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH INACTIVE ACCOUNTS.                                       *        
      *----------------------------------------------------------------*        
       7200-FETCH-EDI-CSR.                                              
      *----------------------*                                                  
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH EDI_CSR                                             
               INTO :NF-ACCOUNT-NO                                      
                   ,:NF-DEST-ID                                         
                   ,:NF-STATUS-CD                                       
                   ,:AT-CODE-ACCT-STAT                                  
A36006             ,:AT-ACCT-FINALED-DT :WS-FINAL-DT-NI                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-ACCT-TOTAL                                 
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR FETCHING EDI_CSR CURSOR **'                
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE ACCOUNT TABLE CURSOR                                     *        
      *----------------------------------------------------------------*        
       7300-CLOSE-EDI-CSR.                                              
      *----------------------*                                                  
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE EDI_CSR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ERROR CLOSING EDI_CSR CURSOR **'                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A36006************************************************************              
A36006**  7400-GET-TIMESTAMP.                                                   
A36006**      GETS THE CURRENT TIMESTAMP FROM CSS_MODEL_SQL.    **              
A36006************************************************************              
       7400-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -2, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TS-MINUS-2-MNTHS                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT TIMESTAMP - 2 MONTHS                              
MFA-TR*        INTO   :WS-TS-MINUS-2-MNTHS                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              DISPLAY '7400-GET-TIMESTAMP'                              
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
A36006 7400-EXIT.                                                       
A36006     EXIT.                                                        
      *                                                                         
      *----------------------------------------------------------------*        
      * DISPLAY ERRORS                                                 *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'     
           DISPLAY '**     PCSXP432  PROCESSING ERROR           **'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'     
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE            
           DISPLAY '**       PROCESSING TERMINATED              **'     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY MESSAGES                                               *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           DISPLAY 'TOTAL NO OF ACCOUNTS SELECTED           = '         
                   WS-ACCT-TOTAL                                        
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PERFORM ABEND USING 9900-ABEND PARAGRAPH                                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
