       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSXP431.                                            
       AUTHOR. PRIYA.                                                   
       DATE-WRITTEN. OCT 2008.                                          
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *      DATE       INITIALS   REASON                             *         
      *    ==========   ========= ================================    *         
      *    T37648       SP94986   CLONE OF PCSAC188                   *         
      *                                                               *         
      *                           ADD MORE COMMITS TO JOURNAL AND     *         
      *                           PAYMENT TRANS TABLE.                *         
      *                                                               *         
      *                           KEEP OVER/SHOT TABLE ROWS FOR ONE   *         
      *                           YEAR INSTEAD OF 6 MONTHS.           *         
      *                                                               *         
A04527*  22 MAR 2013    RF10596   CHANGE DELETE FOR THE TABLES -      *         
A04527*                           CSS_CSH_DRWR_CNTL/CSS_PAYMENT_TRANS *         
A04527*                           TO USE CURSORS                      *         
      *                                                               *         
A04527*  22 APR 2013    RF10596   ADD CSS_GL_ENTRY_CRNT TO BE DELETED *         
A04527*                           ADD JOB_PARM MEMBER TO ALLOW FOR    *         
A04527*                           > 5 YEAR DELETION                   *         
      *                                                               *         
ACT257*  08 AUG 2015    BD09555   REMOVE CSS_EMPLOYEE_CHECK FROM      *         
ACT257*A05460-ACT257              PROGRAM                             *         
      *                                                               *         
A05460*  30 NOV 2016    RF10596   REMOVE CSS_BILL_AGNT_PYMT           *         
      *                                                               *         
      *---------------------------------------------------------------*         
           REMARKS.                                                     
      *---------------------------------------------------------------*         
      * THIS PROGRAM DELETES ROWS FROM THE FOLLOWING TABLES           *         
      * CSS_CSH_DRWR_CNTL                                             *         
      * CSS_BANK_TRANSFER                                             *         
      * CSS_OVERSHORT_HDR                                             *         
      * CSS_OVERSHORT_DET                                             *         
      * THIS PROGRAM DELETES 7 DAYS DATA FROM DEFAULT JRNL PARM VALUE.*         
      * THESE TWO PARAMETERS CAN BE CHANGED VIA TABLES IF NEEDED.     *         
      *---------------------------------------------------------------*         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP431'.
MSQ017     COPY MFASQLM.
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                PIC X(08) VALUE 'PCSXP431'.   
           05  WS-PGMNAME                 PIC X(08) VALUE 'PCSXP431'.   
           05  WS-Y                       PIC X(01) VALUE 'Y'.          
           05  WS-N                       PIC X(01) VALUE 'N'.          
           05  WS-DEFAULT-KEEP-JRNL       PIC 9(04) VALUE 180.          
           05  WS-DEFAULT-PURGE-DAYS      PIC 9(03) VALUE 7.            
           05  WS-KEEP-JRNL               PIC S9(04) COMP VALUE 0.      
           05  WS-PURGE-DAYS              PIC S9(04) COMP VALUE 0.      
A04527     05  WS-PT-BREAK                PIC S9(4) COMP-3 VALUE 0.     
A04527     05  WS-CDC-BREAK               PIC S9(4) COMP-3 VALUE 0.     
A04527     05  WS-PURGE-YEARS             PIC 9     VALUE 0.            
      *                                                                         
A04527 01  WS-REVENUE-DATE.                                             
A04527     05  WS-REVENUE-YEAR            PIC 9(4)  VALUE 0.            
A04527     05  WS-REVENUE-MONTH           PIC 99    VALUE 0.            
      *                                                                         
       01  WS-VARIABLES.                                                
A04527     05  WS-REVENUE-96              PIC 9(6)  VALUE 0.            
A04527     05  WS-SAVE-SQLCODE            PIC S9(9) COMP VALUE 0.       
A04527     05  WS-PT-COMMIT               PIC S9(9) COMP-3 VALUE 0.     
A04527     05  WS-CDC-COMMIT              PIC S9(9) COMP-3 VALUE 0.     
A04527     05  WS-JRL-COMMIT              PIC S9(9) COMP-3 VALUE 0.     
           05  WS-ERR-MSG                 PIC X(100) VALUE SPACES.      
           05  WS-ERR-MSG2                PIC X(115) VALUE SPACES.      
           05  WS-PURGE-DATE              PIC X(10)  VALUE SPACES.      
           05  WS-DELETE-DATE             PIC X(10)  VALUE SPACES.      
           05  WS-INPUT-DATE2             PIC X(10)  VALUE SPACES.      
           05  WS-OVERSHORT-DATE          PIC X(10)  VALUE SPACES.      
           05  WS-ERRD3                   PIC 9(9) VALUE 0.             
                                                                        
      *                                                                         
      *===============================================================*         
      * SQL COMMUNICATION AREA                                        *         
      *===============================================================*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *===============================================================*         
      *    CSS_CSH_DRWR_CNTL - CS                                     *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                             
            INCLUDE TBCDCNTL                                                    
           END-EXEC.                                                            
      *                                                                         
A04527*===============================================================*         
A04527*    CSS_CSH_DRWR_JRNL - CJ                                     *         
A04527*===============================================================*         
      *                                                                         
A04527     EXEC SQL                                                             
A04527      INCLUDE TBCDJRNL                                                    
A04527     END-EXEC.                                                            
      *                                                                         
A04527*===============================================================*         
A04527*    CSS_CSH_GL_ENTRY_CRNT  -  GE                               *         
A04527*===============================================================*         
      *                                                                         
A04527     EXEC SQL                                                             
A04527      INCLUDE TBGLENT                                                     
A04527     END-EXEC.                                                            
      *                                                                         
      *===============================================================*         
      *    CSS_BANK_TRANSFER                                          *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBNKXFR                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_CSH_REPORT_HDR                                         *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSRPHD                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_PAYMENT_TRANS                                          *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBPMTRAN                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_OVERSHORT_HDR                                          *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBOVSHHD                                                    
           END-EXEC.                                                            
                                                                        
      *===============================================================*         
      *    CSS_JOB_PARM                                               *         
      *===============================================================*         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00037.                                                           
       COPY CWS00038.                                                           
       01  WS-INPUT-DATA-R8  REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           05  WS-SYSIPT-R8        PIC X(09).                           
               88  KEEP-JRNL       VALUE 'KEEP JRNL'.                   
           05  FILLER              PIC X(01).                           
           05  WS-KEEP-JRNL-PARM   PIC 9(03).                           
           05  FILLER              PIC X(41).                           
      *                                                                         
       01  WS-INPUT-DATA-R1  REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           05  WS-SYSIPT-R1        PIC X(10).                           
               88  PURGE-DAYS      VALUE 'PURGE-DAYS'.                  
           05  FILLER              PIC X(01).                           
           05  WS-PURGE-JRNL-DAYS  PIC 9(03).                           
           05  FILLER              PIC X(40).                           
      *                                                                         
A04527 01  WS-INPUT-DATA-CM  REDEFINES WS-INPUT-DATA-BREAKDOWN.         
A04527     05  WS-PARM-PT-COMMITX   PIC X(10).                          
A04527         88  PT-COMMIT       VALUE 'PT-COMMIT='.                  
A04527     05  WS-PARM-PT-COMMIT    PIC 9(4).                           
A04527     05  FILLER               PIC X.                              
A04527     05  WS-PARM-CDC-COMMITX  PIC X(11).                          
A04527         88  CDC-COMMIT       VALUE 'CDC-COMMIT='.                
A04527     05  WS-PARM-CDC-COMMIT   PIC 9(4).                           
A04527     05  FILLER               PIC X(50).                          
      *                                                                         
A04527 01  WS-INPUT-PARM     REDEFINES WS-INPUT-DATA-BREAKDOWN.         
A04527     05  WS-PARM-REVENUE-X    PIC X(12).                          
A04527         88  PARM-DATEX      VALUE 'REPORT DATE='.                
A04527     05  WS-PARM-REVENUE      PIC 9(6).                           
A04527     05  FILLER               PIC X(62).                          
      *                                                                         
A04527 01  WS-INPUT-PARM-Y   REDEFINES WS-INPUT-DATA-BREAKDOWN.         
A04527     05  WS-PARM-YEAR-Y       PIC X(12).                          
A04527         88  PARM-YEARY      VALUE 'PURGE-YEARS='.                
A04527     05  WS-PARM-YEAR         PIC 9.                              
A04527     05  FILLER               PIC X(67).                          
      *                                                                         
      ****************************************************************          
A04527* CURSOR DEFINITION TO SELECT CSS_PAYMENT_TRANS TO DELETE      *          
      ****************************************************************          
      *                                                                         
A04527     EXEC SQL                                                     
A04527         DECLARE PAY_CSR CURSOR WITH HOLD FOR                     
A04527            SELECT DATE_CASH_REPORT                               
A04527                  ,CASH_LOCAL_OFFICE                              
A04527                  ,REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_RCVD_TS
           , 121), ' ', '-'), ':', '.') PYMT_RCVD_TS                           
A04527                  ,ACCOUNT_NO                                     
A04527             FROM  CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                
A04527             WHERE DATE_CASH_REPORT  <= IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )      
A04527               FOR READ ONLY                              
A04527                                                      
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PAY_CSR CURSOR WITH HOLD FOR                             
MFA-TR*           SELECT DATE_CASH_REPORT                                       
MFA-TR*                 ,CASH_LOCAL_OFFICE                                      
MFA-TR*                 ,PYMT_RCVD_TS                                           
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*            FROM  CSS_PAYMENT_TRANS                                      
MFA-TR*            WHERE DATE_CASH_REPORT  <= :JT-DATE-CASH-REPORT              
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7010                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A04527* CURSOR DEFINITION TO SELECT CSS_CSH_DRWR_CNTL TO DELETE      *          
      ****************************************************************          
      *                                                                         
A04527     EXEC SQL                                                     
A04527         DECLARE CDC_CSR CURSOR WITH HOLD FOR                     
A04527            SELECT CASH_COMPANY_NO                                
A04527                  ,CASH_LOCAL_OFFICE                              
A04527                  ,DATE_CASH_REPORT                               
A04527                  ,CASH_DRAWER_ID                                 
A04527             FROM  CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                
A04527             WHERE DATE_CASH_REPORT  <= IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )      
A04527               FOR READ ONLY                              
A04527                                                      
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CDC_CSR CURSOR WITH HOLD FOR                             
MFA-TR*           SELECT CASH_COMPANY_NO                                        
MFA-TR*                 ,CASH_LOCAL_OFFICE                                      
MFA-TR*                 ,DATE_CASH_REPORT                                       
MFA-TR*                 ,CASH_DRAWER_ID                                         
MFA-TR*            FROM  CSS_CSH_DRWR_CNTL                                      
MFA-TR*            WHERE DATE_CASH_REPORT  <= :CS-DATE-CASH-REPORT              
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7040                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A04527* CURSOR DEFINITION TO SELECT CSS_CSH_DRWR_JRNL TO DELETE      *          
      ****************************************************************          
      *                                                                         
A04527     EXEC SQL                                                     
A04527         DECLARE JRNL_CSR CURSOR WITH HOLD FOR                    
A04527            SELECT CASH_COMPANY_NO                                
A04527                  ,CASH_LOCAL_OFFICE                              
A04527                  ,DATE_CASH_REPORT                               
A04527                  ,CASH_DRAWER_ID                                 
A04527                  ,DATE_TRAN                                      
A04527                  ,ENTRY_NO                                       
A04527                  ,TRAN_APPL_NO                                   
A04527                  ,REPLACE(REPLACE(CONVERT(CHAR(26), TRAN_TS
           , 121), ' ', '-'), ':', '.') TRAN_TS                                
A04527             FROM  CSS_CSH_DRWR_JRNL WITH(READUNCOMMITTED)                
A04527             WHERE DATE_CASH_REPORT  <= IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )      
A04527               FOR READ ONLY                              
A04527                                                      
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE JRNL_CSR CURSOR WITH HOLD FOR                            
MFA-TR*           SELECT CASH_COMPANY_NO                                        
MFA-TR*                 ,CASH_LOCAL_OFFICE                                      
MFA-TR*                 ,DATE_CASH_REPORT                                       
MFA-TR*                 ,CASH_DRAWER_ID                                         
MFA-TR*                 ,DATE_TRAN                                              
MFA-TR*                 ,ENTRY_NO                                               
MFA-TR*                 ,TRAN_APPL_NO                                           
MFA-TR*                 ,TRAN_TS                                                
MFA-TR*            FROM  CSS_CSH_DRWR_JRNL                                      
MFA-TR*            WHERE DATE_CASH_REPORT  <= :CJ-DATE-CASH-REPORT              
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7041                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
                                                                        
           PERFORM 2000-PROCESS-TABLE-DELETE THRU 2000-EXIT.            
                                                                        
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  COMMON INITIALIZATION ROUTINE                               **        
      **                                                              **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                   
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE WS-PGMNAME TO WS-PGRMNAME                            
           END-IF                                                       
                                                                        
           MOVE SPACES                  TO WS-SYSIPT                    
           MOVE WS-PGRMNAME             TO WS-PROGRAM                   
           MOVE 'PARM'                  TO WS-COMMAND                   
           PERFORM 7600-START-FCSJC01   THRU 7600-EXIT                  
           PERFORM 7610-READ-FCSJC01    THRU 7610-EXIT                  
               UNTIL (KEEP-JRNL AND INPUT-ACTIVE)                       
               OR END-OF-SYSIPT                                         
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY SPACES                                            
              DISPLAY '*   ' WS-PGRMNAME ' INFORMATIONAL MESSAGE'       
              DISPLAY '*   KEEP JRNL PARM NOT ACTIVE             '      
              DISPLAY '*   DEFAULT OF ' WS-DEFAULT-KEEP-JRNL ' WILL'    
                      ' BE USED'                                        
              DISPLAY '*   PROCESSING CONTINUING                  *'    
              MOVE WS-DEFAULT-KEEP-JRNL TO WS-KEEP-JRNL                 
           ELSE                                                         
              IF WS-KEEP-JRNL-PARM NUMERIC                              
                 MOVE WS-KEEP-JRNL-PARM TO WS-KEEP-JRNL                 
              ELSE                                                      
                 DISPLAY SPACES                                         
                 DISPLAY '*   ' WS-PGRMNAME ' PROCESSING WARNING'       
                 DISPLAY '*   KEEP JRNL PARM NOT NUMERIC            '   
                 DISPLAY '*   DEFAULT OF ' WS-DEFAULT-KEEP-JRNL '  WILL'
                         ' BE USED'                                     
                 DISPLAY '*   PROCESSING CONTINUING                  *' 
                 MOVE WS-DEFAULT-KEEP-JRNL   TO WS-KEEP-JRNL            
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-SYSIPT = SPACES                                        
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF                                                       
                                                                        
           MOVE SPACES                  TO WS-SYSIPT                    
           MOVE WS-PGRMNAME             TO WS-PROGRAM                   
           MOVE 'PARM'                  TO WS-COMMAND                   
           PERFORM 7600-START-FCSJC01   THRU 7600-EXIT                  
           PERFORM 7610-READ-FCSJC01    THRU 7610-EXIT                  
               UNTIL (PURGE-DAYS AND INPUT-ACTIVE)                      
               OR END-OF-SYSIPT                                         
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY SPACES                                            
              DISPLAY '*   ' WS-PGRMNAME ' INFORMATIONAL MESSAGE'       
              DISPLAY '*   PURGE JRNL DAYS NOT ACTIVE             '     
              DISPLAY '*   DEFAULT OF ' WS-DEFAULT-PURGE-DAYS ' WILL'   
                      ' BE USED'                                        
              DISPLAY '*   PROCESSING CONTINUING                  *'    
              MOVE WS-DEFAULT-PURGE-DAYS TO WS-PURGE-DAYS               
           ELSE                                                         
              IF WS-PURGE-JRNL-DAYS NUMERIC                             
                 MOVE WS-PURGE-JRNL-DAYS TO WS-PURGE-DAYS               
              ELSE                                                      
                 DISPLAY SPACES                                         
                 DISPLAY '*  ' WS-PGRMNAME ' PROCESSING WARNING'        
                 DISPLAY '*   PURGE JRNL DAYS NOT NUMERIC            '  
                 DISPLAY '* DEFAULT OF ' WS-DEFAULT-PURGE-DAYS ' WILL'  
                         ' BE USED'                                     
                 DISPLAY '*   PROCESSING CONTINUING                 *'  
                 MOVE WS-DEFAULT-PURGE-DAYS  TO WS-PURGE-DAYS           
              END-IF                                                    
           END-IF                                                       
      *                                                                         
A04527     IF WS-SYSIPT = SPACES                                        
A04527        PERFORM 7611-CLOSE THRU 7611-EXIT                         
A04527     END-IF                                                       
      *                                                                         
A04527     MOVE SPACES                 TO WS-SYSIPT                     
A04527     MOVE WS-PGRMNAME            TO WS-PROGRAM                    
A04527     MOVE 'PARM'                 TO WS-COMMAND                    
A04527     PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                   
A04527     PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
A04527         UNTIL (PT-COMMIT AND INPUT-ACTIVE)                       
A04527         OR END-OF-SYSIPT                                         
      *                                                                         
A04527     IF END-OF-SYSIPT                                             
A04527        DISPLAY '*  JOB PARM ERROR - PROGRAM ABENDING'            
A04527        DISPLAY '*  COMMIT NUMBERS ARE NOT AVAILABLE '            
A04527        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04527     ELSE                                                         
A04527        IF WS-PARM-PT-COMMIT NUMERIC                              
A04527           MOVE WS-PARM-PT-COMMIT TO WS-PT-BREAK                  
A04527        ELSE                                                      
A04527           DISPLAY '*  JOB PARM ERROR - PROGRAM ABENDING'         
A04527           DISPLAY '*  PT-COMMIT IS NOT NUMERIC '                 
A04527           PERFORM 9900-ABEND THRU 9900-EXIT                      
A04527        END-IF                                                    
A04527        IF WS-PARM-CDC-COMMIT NUMERIC                             
A04527           MOVE WS-PARM-CDC-COMMIT TO WS-CDC-BREAK                
A04527        ELSE                                                      
A04527           DISPLAY '*  JOB PARM ERROR - PROGRAM ABENDING'         
A04527           DISPLAY '*  CDC-COMMIT IS NOT NUMERIC '                
A04527           PERFORM 9900-ABEND THRU 9900-EXIT                      
A04527        END-IF                                                    
A04527     END-IF.                                                      
      *                                                                         
A04527     DISPLAY '****************************************'.          
A04527     DISPLAY 'PT COMMIT BREAK VALUE = ' WS-PT-BREAK.              
A04527     DISPLAY 'CDC COMMIT BREAK VALUE = ' WS-CDC-BREAK.            
A04527     DISPLAY '****************************************'.          
      *                                                                         
A04527     IF WS-SYSIPT = SPACES                                        
A04527        PERFORM 7611-CLOSE THRU 7611-EXIT                         
A04527     END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-INPUT-DATE2.                        
      *                                                                         
      ****************************************************************          
      **  GET DELETE YEARS FROM JOB PARM                            **          
      ****************************************************************          
      *                                                                         
A04527     MOVE SPACES                 TO WS-SYSIPT.                    
A04527     MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
A04527     MOVE 'PARM'                 TO WS-COMMAND.                   
A04527     PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
A04527     PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
A04527         UNTIL (PARM-YEARY AND INPUT-ACTIVE)                      
A04527         OR END-OF-SYSIPT                                         
      *                                                                         
A04527     IF END-OF-SYSIPT                                             
A04527        DISPLAY '*  JOB PARM ERROR - PROGRAM ABENDING'            
A04527        DISPLAY '*  NUMBER FOR DELETE YEARS NOT AVAILABLE '       
A04527        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04527     ELSE                                                         
A04527        IF WS-PARM-YEAR NUMERIC                                   
A04527           MOVE WS-PARM-YEAR TO WS-PURGE-YEARS                    
A04527        ELSE                                                      
A04527           DISPLAY '*  JOB PARM ERROR - PROGRAM ABENDING'         
A04527           DISPLAY '*  WS-PARM-YEAR IS NOT NUMERIC '              
A04527           PERFORM 9900-ABEND THRU 9900-EXIT                      
A04527        END-IF                                                    
A04527     END-IF.                                                      
      *                                                                         
A04527     DISPLAY '****************************************'.          
A04527     DISPLAY 'WS-PURGE-YEARS = ' WS-PURGE-YEARS.                  
A04527     DISPLAY '****************************************'.          
      *                                                                         
A04527     IF WS-SYSIPT = SPACES                                        
A04527        PERFORM 7611-CLOSE THRU 7611-EXIT                         
A04527     END-IF.                                                      
      *                                                                         
      ****************************************************************          
      **  GET 'REPORTDATE' FROM JOB PARM                            **          
      ****************************************************************          
      *                                                                         
A04527     MOVE SPACES                 TO WS-SYSIPT.                    
A04527     MOVE 'REPORTDATE'           TO WS-PROGRAM.                   
A04527     MOVE 'DATE'                 TO WS-COMMAND.                   
A04527     PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
A04527     PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
A04527         UNTIL (PARM-DATEX AND INPUT-ACTIVE)                      
A04527         OR END-OF-SYSIPT                                         
      *                                                                         
A04527     IF END-OF-SYSIPT                                             
A04527        DISPLAY '*  JOB PARM ERROR - PROGRAM ABENDING'            
A04527        DISPLAY '*  REPORTDATE NOT AVAILABLE '                    
A04527        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04527     ELSE                                                         
A04527        IF WS-PARM-REVENUE NUMERIC                                
A04527           MOVE WS-PARM-REVENUE TO WS-REVENUE-DATE                
A04527        ELSE                                                      
A04527           DISPLAY '*  JOB PARM ERROR - PROGRAM ABENDING'         
A04527           DISPLAY '*  WS-PARM-REVENUE IS NOT NUMERIC '           
A04527           PERFORM 9900-ABEND THRU 9900-EXIT                      
A04527        END-IF                                                    
A04527     END-IF.                                                      
      *                                                                         
A04527     DISPLAY '****************************************'.          
A04527     DISPLAY 'WS-PARM-REVENUE = ' WS-PARM-REVENUE.                
A04527     DISPLAY '****************************************'.          
      *                                                                         
A04527     IF WS-SYSIPT = SPACES                                        
A04527        PERFORM 7611-CLOSE THRU 7611-EXIT                         
A04527     END-IF.                                                      
      *                                                                         
A04527     SUBTRACT WS-PURGE-YEARS FROM WS-REVENUE-YEAR.                
A04527     MOVE WS-REVENUE-DATE TO WS-REVENUE-96.                       
A04527     MOVE WS-REVENUE-96   TO GE-ACCT-PERIOD-AFFCTD.               
      *                                                                         
A04527     DISPLAY '****************************************'.          
A04527     DISPLAY 'WS-REVENUE-DATE = ' WS-REVENUE-DATE.                
A04527     DISPLAY 'GE-ACCT-PERIOD-AFFCTD = ' WS-REVENUE-DATE.          
A04527     DISPLAY '****************************************'.          
      *                                                                         
           PERFORM 7100-SELECT-PURGE-DATE THRU 7100-EXIT.               
      *                                                                         
           PERFORM 7200-SELECT-DELETE-DATE THRU 7200-EXIT.              
      *                                                                         
           MOVE WS-OVERSHORT-DATE        TO OH-DATE-CASH-REPORT.        
                                                                        
           MOVE WS-PURGE-DATE            TO CS-DATE-CASH-REPORT         
                                            JT-DATE-CASH-REPORT         
                                            YB-DATE-CASH-REPORT         
                                            YR-DATE-CASH-REPORT.        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  HANDLES ALL DELETE PARAGRAPHS                               **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-TABLE-DELETE.                                       
      *--------------------------*                                              
                                                                        
           PERFORM 8015-DELETE-OVERSHORT-DET                            
              THRU 8015-EXIT                                            
                                                                        
           PERFORM 8999-ISSUE-COMMIT                                    
              THRU 8999-EXIT                                            
                                                                        
           DISPLAY '*** COMMIT TAKEN FOR CSS_OVERSHORT_DET TABLE ***'   
                                                                        
           PERFORM 8020-DELETE-OVERSHORT-HDR                            
              THRU 8020-EXIT                                            
                                                                        
           PERFORM 8999-ISSUE-COMMIT                                    
              THRU 8999-EXIT                                            
                                                                        
           DISPLAY '*** COMMIT TAKEN FOR CSS_OVERSHORT_HDR TABLE ***'   
                                                                        
           PERFORM 8030-DELETE-BANK-TRANSFER                            
              THRU 8030-EXIT                                            
                                                                        
           PERFORM 8999-ISSUE-COMMIT                                    
              THRU 8999-EXIT                                            
                                                                        
           DISPLAY '*** COMMIT TAKEN FOR CSS_BANK_TRANSFER TABLE ***'   
                                                                        
      *                                                                         
A04527     MOVE WS-DELETE-DATE TO JT-DATE-CASH-REPORT                   
A04527                            CS-DATE-CASH-REPORT                   
A04527                            CJ-DATE-CASH-REPORT.                  
      *                                                                         
           DISPLAY 'WS-DELETE-DATE   = ' WS-DELETE-DATE.                
      *                                                                         
A04527     PERFORM 7000-OPEN-PAY-CSR THRU 7000-EXIT.                    
      *                                                                         
A04527     PERFORM 7010-FETCH-PAY-CSR THRU 7010-EXIT.                   
      *                                                                         
A04527     MOVE SQLCODE TO WS-SAVE-SQLCODE.                             
      *                                                                         
A04527     PERFORM UNTIL WS-SAVE-SQLCODE = NOT-FOUND                    
A04527        PERFORM 8010-DELETE-PAYMENT-TRANS THRU 8010-EXIT          
A04527        PERFORM 7010-FETCH-PAY-CSR THRU 7010-EXIT                 
A04527        MOVE SQLCODE TO WS-SAVE-SQLCODE                           
A04527     END-PERFORM.                                                 
      *                                                                         
A04527     DISPLAY 'DELETED CSS_PAYMENT_TRANS = ' WS-PT-COMMIT          
A04527      ' LOCAL OFFICE = ' JT-CASH-LOCAL-OFFICE ' OUTSIDE '.        
      *                                                                         
A04527     PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT.                    
A04527     MOVE 0 TO WS-PT-COMMIT.                                      
      *                                                                         
A04527     PERFORM 7020-CLOSE-PAY-CSR THRU 7020-EXIT.                   
      *                                                                         
A04527     PERFORM 7031-OPEN-JRNL-CSR THRU 7031-EXIT.                   
      *                                                                         
A04527     PERFORM 7041-FETCH-JRNL-CSR THRU 7041-EXIT.                  
      *                                                                         
A04527     MOVE SQLCODE TO WS-SAVE-SQLCODE.                             
      *                                                                         
A04527     PERFORM UNTIL WS-SAVE-SQLCODE = NOT-FOUND                    
A04527        PERFORM 8065-DELETE-CSH-DRWR-JRNL THRU 8065-EXIT          
A04527        PERFORM 7041-FETCH-JRNL-CSR THRU 7041-EXIT                
A04527        MOVE SQLCODE TO WS-SAVE-SQLCODE                           
A04527     END-PERFORM.                                                 
      *                                                                         
A04527     DISPLAY 'DELETED CSS_CSH_DRWR_JRNL = ' WS-CDC-COMMIT         
A04527      ' LOCAL OFFICE = ' CS-CASH-LOCAL-OFFICE ' OUTSIDE '.        
      *                                                                         
A04527     PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT.                    
A04527     MOVE 0 TO WS-CDC-COMMIT.                                     
      *                                                                         
A04527     PERFORM 7051-CLOSE-JRNL-CSR THRU 7051-EXIT.                  
      *                                                                         
A04527     PERFORM 7030-OPEN-CDC-CSR THRU 7030-EXIT.                    
      *                                                                         
A04527     PERFORM 7040-FETCH-CDC-CSR THRU 7040-EXIT.                   
      *                                                                         
A04527     MOVE SQLCODE TO WS-SAVE-SQLCODE.                             
      *                                                                         
A04527     PERFORM UNTIL WS-SAVE-SQLCODE = NOT-FOUND                    
A04527        PERFORM 8060-DELETE-CSH-DRWR-CNTL THRU 8060-EXIT          
A04527        PERFORM 7040-FETCH-CDC-CSR THRU 7040-EXIT                 
A04527        MOVE SQLCODE TO WS-SAVE-SQLCODE                           
A04527     END-PERFORM.                                                 
      *                                                                         
A04527     DISPLAY 'DELETED CSS_CSH_DRWR_CNTL = ' WS-CDC-COMMIT         
A04527      ' LOCAL OFFICE = ' CS-CASH-LOCAL-OFFICE ' OUTSIDE '.        
      *                                                                         
A04527     PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT.                    
A04527     MOVE 0 TO WS-CDC-COMMIT.                                     
      *                                                                         
A04527     PERFORM 7050-CLOSE-CDC-CSR THRU 7050-EXIT.                   
      *                                                                         
           PERFORM 8070-DELETE-CSH-RPT-HDR THRU 8070-EXIT.              
      *                                                                         
           PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT.                    
      *                                                                         
           DISPLAY '** COMMIT TAKEN FOR CSS_CSH_REPORT_HDR TABLE ***'.  
      *                                                                         
A04527     PERFORM 8071-DELETE-GL-ENTRY-CRNT THRU 8071-EXIT.            
      *                                                                         
A04527     PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT.                    
      *                                                                         
A04527     DISPLAY '** COMMIT TAKEN FOR CSS_GL_ENTRY_CRNT TABLE ***'.   
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  OPENS PAY_CSR TO GET ROWS TO DELETE                         *          
      ****************************************************************          
      *                                                                         
A04527 7000-OPEN-PAY-CSR.                                               
      *                                                                         
A04527     EXEC SQL                                                     
A04527        OPEN PAY_CSR                                              
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7010-OPEN-PAY-CSR                      *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* DATE-CASH-REPORT = ' JT-DATE-CASH-REPORT      
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7000-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  FETCH PAY_CSR                                               *          
      ****************************************************************          
      *                                                                         
A04527 7010-FETCH-PAY-CSR.                                              
      *                                                                         
A04527     EXEC SQL                                                     
A04527        FETCH PAY_CSR                                             
A04527        INTO :JT-DATE-CASH-REPORT                                 
A04527            ,:JT-CASH-LOCAL-OFFICE                                
A04527            ,:JT-PYMT-RCVD-TS                                     
A04527            ,:JT-ACCOUNT-NO                                       
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7010-FETCH-PAY-CSR                     *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* DATE_CASH_REPORT  = ' JT-DATE-CASH-REPORT     
A04527         DISPLAY '* CASH_LOCAL_OFFICE = ' JT-CASH-LOCAL-OFFICE    
A04527         DISPLAY '* PYMT-RCVD-TS      = ' JT-PYMT-RCVD-TS         
A04527         DISPLAY '* ACCOUNT-NO        = ' JT-ACCOUNT-NO           
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7010-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  CLOSE PAY_CSR                                               *          
      ****************************************************************          
      *                                                                         
A04527 7020-CLOSE-PAY-CSR.                                              
      *                                                                         
A04527     EXEC SQL                                                     
A04527        CLOSE PAY_CSR                                             
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7020-CLOSE-PAY-CSR                     *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* DATE-CASH-REPORT = ' JT-DATE-CASH-REPORT      
A04527         DISPLAY '* CASH-LOCAL-OFFICE = ' JT-CASH-LOCAL-OFFICE    
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7020-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  OPENS CDC_CSR TO GET ROWS TO DELETE                         *          
      ****************************************************************          
      *                                                                         
A04527 7030-OPEN-CDC-CSR.                                               
      *                                                                         
A04527     EXEC SQL                                                     
A04527        OPEN CDC_CSR                                              
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7030-OPEN-CDC-CSR                      *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* DATE-CASH-REPORT = ' CS-DATE-CASH-REPORT      
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7030-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  FETCH CDC_CSR                                               *          
      ****************************************************************          
      *                                                                         
A04527 7040-FETCH-CDC-CSR.                                              
      *                                                                         
A04527     EXEC SQL                                                     
A04527        FETCH CDC_CSR                                             
A04527        INTO :CS-CASH-COMPANY-NO                                  
A04527            ,:CS-CASH-LOCAL-OFFICE                                
A04527            ,:CS-DATE-CASH-REPORT                                 
A04527            ,:CS-CASH-DRAWER-ID                                   
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7040-FETCH-CDC-CSR                     *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* CASH_COMPANY_NO   = ' CS-CASH-COMPANY-NO      
A04527         DISPLAY '* CASH_LOCAL_OFFICE = ' CS-CASH-LOCAL-OFFICE    
A04527         DISPLAY '* DATE_CASH_REPORT  = ' CS-DATE-CASH-REPORT     
A04527         DISPLAY '* CASH_DRAWER_ID    = ' CS-CASH-DRAWER-ID       
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7040-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  CLOSE CDC_CSR                                               *          
      ****************************************************************          
      *                                                                         
A04527 7050-CLOSE-CDC-CSR.                                              
      *                                                                         
A04527     EXEC SQL                                                     
A04527        CLOSE CDC_CSR                                             
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7050-CLOSE-CDC-CSR                     *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* DATE-CASH-REPORT = ' CS-DATE-CASH-REPORT      
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7050-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  OPENS JRNL_CSR TO GET ROWS TO DELETE                        *          
      ****************************************************************          
      *                                                                         
A04527 7031-OPEN-JRNL-CSR.                                              
      *                                                                         
A04527     EXEC SQL                                                     
A04527        OPEN JRNL_CSR                                             
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7031-OPEN-JRNL-CSR                     *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* DATE-CASH-REPORT = ' CS-DATE-CASH-REPORT      
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7031-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  FETCH JRNL_CSR                                              *          
      ****************************************************************          
      *                                                                         
A04527 7041-FETCH-JRNL-CSR.                                             
      *                                                                         
A04527     EXEC SQL                                                     
A04527        FETCH JRNL_CSR                                            
A04527        INTO :CJ-CASH-COMPANY-NO                                  
A04527            ,:CJ-CASH-LOCAL-OFFICE                                
A04527            ,:CJ-DATE-CASH-REPORT                                 
A04527            ,:CJ-CASH-DRAWER-ID                                   
A04527            ,:CJ-DATE-TRAN                                        
A04527            ,:CJ-ENTRY-NO                                         
A04527            ,:CJ-TRAN-APPL-NO                                     
A04527            ,:CJ-TRAN-TS                                          
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7041-FETCH-JRNL-CSR                    *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* CASH_COMPANY_NO   = ' CS-CASH-COMPANY-NO      
A04527         DISPLAY '* CASH_LOCAL_OFFICE = ' CS-CASH-LOCAL-OFFICE    
A04527         DISPLAY '* DATE_CASH_REPORT  = ' CS-DATE-CASH-REPORT     
A04527         DISPLAY '* CASH_DRAWER_ID    = ' CS-CASH-DRAWER-ID       
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7041-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04527*  CLOSE JRNL_CSR                                              *          
      ****************************************************************          
      *                                                                         
A04527 7051-CLOSE-JRNL-CSR.                                             
      *                                                                         
A04527     EXEC SQL                                                     
A04527        CLOSE JRNL_CSR                                            
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         DISPLAY '* 7051-CLOSE-JRNL-CSR                    *'     
A04527         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A04527         DISPLAY '* DATE-CASH-REPORT = ' CS-DATE-CASH-REPORT      
A04527         DISPLAY '* PROGRAM ABORTING...                    *'     
A04527         DISPLAY '********** PCSXP431  ABORT ***************'     
A04527         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04527     END-IF.                                                      
      *                                                                         
A04527 7051-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CALCULATES THE PURGE DATE                                   **        
      **                                                              **        
      ******************************************************************        
       7100-SELECT-PURGE-DATE.                                          
      *-----------------------*                                                 
                                                                        
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, -:WS-KEEP-JRNL, IIF(TRY_CONVERT(DATE, 
                                                        :WS-INPUT-DATE2
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE2
              ) <> 0) OR (LEN(:WS-INPUT-DATE2) <> 10), CIS.CHAR2DATE(
                                                        :WS-INPUT-DATE2
              ), CONVERT(DATE, :WS-INPUT-DATE2) ) ),
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE2
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE2
              ) <> 0) OR (LEN(:WS-INPUT-DATE2) <> 10), CIS.CHAR2DATE(
                                                        :WS-INPUT-DATE2
              ), CONVERT(DATE, :WS-INPUT-DATE2) ) )
            INTO
              :WS-PURGE-DATE,
              :WS-OVERSHORT-DATE                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-PURGE-DATE =                                            
MFA-TR*              DATE(:WS-INPUT-DATE2) -  :WS-KEEP-JRNL DAYS                
MFA-TR*             ,:WS-OVERSHORT-DATE =                                       
MFA-TR*              DATE(:WS-INPUT-DATE2) - 1 YEAR                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '    '                                            
              DISPLAY 'WS-PURGE-DATE       = ' WS-PURGE-DATE            
              DISPLAY 'WS-OVERSHORT-DATE   = ' WS-OVERSHORT-DATE        
           ELSE                                                         
              STRING ' ERROR SETTING PURGE DATE AND OVERSHORT DATE ** ' 
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' WS-INPUT-DATE  = ' WS-INPUT-DATE                 
                       DELIMITED BY SIZE                                
                     ' WS-PURGE-DATE  = ' WS-PURGE-DATE                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  CALCULATES THE PURGE DATE                                   **        
      **                                                              **        
      ******************************************************************        
       7200-SELECT-DELETE-DATE.                                         
      *------------------------*                                                
                                                                        
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, -:WS-PURGE-DAYS, IIF(TRY_CONVERT(DATE, 
                                                         :WS-PURGE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PURGE-DATE
              ) <> 0) OR (LEN(:WS-PURGE-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-PURGE-DATE
              ), CONVERT(DATE, :WS-PURGE-DATE) ) )
            INTO
              :WS-DELETE-DATE         
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DELETE-DATE =                                           
MFA-TR*             DATE(:WS-PURGE-DATE) -  :WS-PURGE-DAYS DAYS                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY 'WS-DELETE-DATE  = ' WS-DELETE-DATE               
           ELSE                                                         
              STRING ' ERROR SETTING DELETE DATE          ** '          
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' WS-PURGE-DATE  = ' DELIMITED BY SIZE             
                       WS-PURGE-DATE                                    
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  SELECT NEXT DATE                                            **        
      **                                                              **        
      ******************************************************************        
       7300-SELECT-NEXT-DATE.                                           
      *----------------------*                                                  
                                                                        
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DELETE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DELETE-DATE
              ) <> 0) OR (LEN(:WS-DELETE-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-DELETE-DATE
              ), CONVERT(DATE, :WS-DELETE-DATE) ) )
            INTO
              :WS-DELETE-DATE    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DELETE-DATE = DATE(:WS-DELETE-DATE) + 1 DAYS            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SETTING NEXT DATE          ** '            
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' WS-DELETE-DATE  = ' WS-DELETE-DATE               
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DELETES ROWS FROM PAYMENT TRANS TABLE                       **        
      ******************************************************************        
      *                                                                         
       8010-DELETE-PAYMENT-TRANS.                                       
      *                                                                         
           MOVE '8010' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
             DELETE FROM CSS_PAYMENT_TRANS                              
A04527        WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
A04527          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
A04527          AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
A04527          AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_PAYMENT_TRANS                                      
MFA-TR*       WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                   
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                        
MFA-TR*         AND ACCOUNT_NO        = :JT-ACCOUNT-NO                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527        ADD +1 TO WS-PT-COMMIT                                    
A04527        IF WS-PT-COMMIT >= WS-PT-BREAK                            
A04527           DISPLAY 'DELETED CSS_PAYMENT_TRANS = ' WS-PT-COMMIT    
A04527            ' LOCAL OFFICE = ' JT-CASH-LOCAL-OFFICE ' 8010 '      
A04527           PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT               
A04527           MOVE 0 TO WS-PT-COMMIT                                 
A04527        END-IF                                                    
A04527     ELSE                                                         
A04527        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A04527           NEXT SENTENCE                                          
              ELSE                                                      
                 STRING ' ERROR DELETING CSS_PAYMENT_TRANS   ** '       
                          DELIMITED BY SIZE INTO WS-ERR-MSG             
                 STRING ' DATE_CASH_REPORT   = ' JT-DATE-CASH-REPORT    
                          DELIMITED BY SIZE                             
                        ' CASH_LOCAL_OFFICE  = ' JT-CASH-LOCAL-OFFICE   
                          DELIMITED BY SIZE INTO WS-ERR-MSG2            
                 PERFORM 8800-DIS-TABLE-ERROR THRU 8800-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DELETES ROWS FROM OVER/SHORT DETAIL TABLE                   **        
      **                                                              **        
      ******************************************************************        
       8015-DELETE-OVERSHORT-DET.                                       
      *--------------------------*                                              
                                                                        
           MOVE '8015'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_OVERSHORT_DET                              
              WHERE DATE_CASH_REPORT < IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_OVERSHORT_DET                                      
MFA-TR*       WHERE DATE_CASH_REPORT < :OH-DATE-CASH-REPORT                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3) TO WS-ERRD3                               
              DISPLAY SPACES                                            
              DISPLAY 'ROWS DELETED FROM CSS_OVERSHORT_DET = ' WS-ERRD3 
           ELSE                                                         
              STRING ' ERROR DELETING CSS_OVERSHORT_DET   ** '          
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' DATE_CASH_REPORT     = ' OH-DATE-CASH-REPORT     
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
       8015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  DELETES ROWS FROM OVER/SHORT HEADER TABLE                   **        
      **                                                              **        
      ******************************************************************        
       8020-DELETE-OVERSHORT-HDR.                                       
      *--------------------------*                                              
                                                                        
           MOVE '8020'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_OVERSHORT_HDR                              
              WHERE DATE_CASH_REPORT < IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_OVERSHORT_HDR                                      
MFA-TR*       WHERE DATE_CASH_REPORT < :OH-DATE-CASH-REPORT                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3) TO WS-ERRD3                               
              DISPLAY SPACES                                            
              DISPLAY 'ROWS DELETED FROM CSS_OVERSHORT_HDR = ' WS-ERRD3 
           ELSE                                                         
              STRING ' ERROR DELETING CSS_OVERSHORT_HDR   ** '          
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' DATE_CASH_REPORT     = ' OH-DATE-CASH-REPORT     
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  DELETES ROWS FROM BANK TRANSFER TABLE                       **        
      **                                                              **        
      ******************************************************************        
       8030-DELETE-BANK-TRANSFER.                                       
      *--------------------------*                                              
                                                                        
           MOVE '8030'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_BANK_TRANSFER                              
              WHERE DATE_CASH_REPORT < IIF(TRY_CONVERT(DATE, 
                                                   :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) )             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_BANK_TRANSFER                                      
MFA-TR*       WHERE DATE_CASH_REPORT < :YB-DATE-CASH-REPORT                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3) TO WS-ERRD3                               
              DISPLAY SPACES                                            
              DISPLAY 'ROWS DELETED FROM CSS_BANK_TRANSFER = ' WS-ERRD3 
           ELSE                                                         
              STRING ' ERROR DELETING CSS_BANK_TRANSFER   ** '          
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' DATE_CASH_REPORT     = ' YB-DATE-CASH-REPORT     
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DELETES ROWS FROM CASH DRAWER CONTROL TABLE                 **        
      ******************************************************************        
      *                                                                         
       8060-DELETE-CSH-DRWR-CNTL.                                       
      *                                                                         
           MOVE '8060' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
             DELETE FROM CSS_CSH_DRWR_CNTL                              
A04527        WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO             
A04527          AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE           
A04527          AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )            
A04527          AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_CSH_DRWR_CNTL                                      
MFA-TR*       WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527        ADD +1 TO WS-CDC-COMMIT                                   
A04527        IF WS-CDC-COMMIT >= WS-CDC-BREAK                          
A04527           DISPLAY 'DELETED CSS_CSH_DRWR_CNTL = ' WS-CDC-COMMIT   
A04527            ' LOCAL OFFICE = ' CS-CASH-LOCAL-OFFICE ' 8060 '      
A04527           PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT               
A04527           MOVE 0 TO WS-CDC-COMMIT                                
A04527        END-IF                                                    
A04527     ELSE                                                         
A04527        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A04527           NEXT SENTENCE                                          
              ELSE                                                      
                STRING ' ERROR DELETING CSS_CSH_DRWR_CNTL   ** '        
                         DELIMITED BY SIZE INTO WS-ERR-MSG              
                STRING ' DATE_CASH_REPORT     = ' CS-DATE-CASH-REPORT   
                         DELIMITED BY SIZE                              
                       ' CASH_LOCAL_OFFICE    = ' CS-CASH-LOCAL-OFFICE  
                         DELIMITED BY SIZE INTO WS-ERR-MSG2             
                PERFORM 8800-DIS-TABLE-ERROR THRU 8800-EXIT             
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       8060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A04527**  DELETES ROWS FROM CSS_CSH_DRWR_JRNL TABLE - CHILD           **        
      ******************************************************************        
      *                                                                         
A04527 8065-DELETE-CSH-DRWR-JRNL.                                       
      *                                                                         
A04527     MOVE '8065' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
A04527     EXEC SQL                                                     
A04527       DELETE FROM CSS_CSH_DRWR_JRNL                              
A04527        WHERE CASH_COMPANY_NO   = :CJ-CASH-COMPANY-NO             
A04527          AND CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE           
A04527          AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )            
A04527          AND CASH_DRAWER_ID    = :CJ-CASH-DRAWER-ID              
A04527          AND DATE_TRAN         = IIF(TRY_CONVERT(DATE, 
                                                          :CJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-TRAN
              ) <> 0) OR (LEN(:CJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :CJ-DATE-TRAN
              ), CONVERT(DATE, :CJ-DATE-TRAN) )                   
A04527          AND ENTRY_NO          = :CJ-ENTRY-NO                    
A04527          AND TRAN_APPL_NO      = :CJ-TRAN-APPL-NO                
A04527          AND TRAN_TS           = CIS.CHAR2TIMESTAMP(:CJ-TRAN-TS)         
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_CSH_DRWR_JRNL                                      
MFA-TR*       WHERE CASH_COMPANY_NO   = :CJ-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :CJ-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :CJ-CASH-DRAWER-ID                      
MFA-TR*         AND DATE_TRAN         = :CJ-DATE-TRAN                           
MFA-TR*         AND ENTRY_NO          = :CJ-ENTRY-NO                            
MFA-TR*         AND TRAN_APPL_NO      = :CJ-TRAN-APPL-NO                        
MFA-TR*         AND TRAN_TS           = :CJ-TRAN-TS                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04527        ADD +1 TO WS-CDC-COMMIT                                   
A04527        IF WS-CDC-COMMIT >= WS-CDC-BREAK                          
A04527           DISPLAY 'DELETED CSS_CSH_DRWR_JRNL = ' WS-CDC-COMMIT   
A04527            ' LOCAL OFFICE = ' CJ-CASH-LOCAL-OFFICE ' 8065 '      
A04527           PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT               
A04527           MOVE 0 TO WS-CDC-COMMIT                                
A04527        END-IF                                                    
A04527     ELSE                                                         
A04527        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A04527           NEXT SENTENCE                                          
A04527        ELSE                                                      
A04527          STRING ' ERROR DELETING CSS_CSH_DRWR_CNTL   ** '        
A04527                   DELIMITED BY SIZE INTO WS-ERR-MSG              
A04527          STRING ' DATE_CASH_REPORT     = ' CJ-DATE-CASH-REPORT   
A04527                   DELIMITED BY SIZE                              
A04527                 ' CASH_LOCAL_OFFICE    = ' CJ-CASH-LOCAL-OFFICE  
A04527                   DELIMITED BY SIZE INTO WS-ERR-MSG2             
A04527          DISPLAY '******** PROGRAM ABENDING ***********'         
A04527          DISPLAY ' PARAGRAPH 8065-DELETE-CSH-DRWR-JRNL '         
A04527          DISPLAY ' CJ-CASH-COMPANY-NO   = ' CJ-CASH-COMPANY-NO   
A04527          DISPLAY ' CJ-CASH-LOCAL-OFFICE = ' CJ-CASH-LOCAL-OFFICE 
A04527          DISPLAY ' CJ-DATE-CASH-REPORT  = ' CJ-DATE-CASH-REPORT  
A04527          DISPLAY ' CJ-CASH-DRAWER-ID    = ' CJ-CASH-DRAWER-ID    
A04527          DISPLAY ' CJ-DATE-TRAN         = ' CJ-DATE-TRAN         
A04527          DISPLAY ' CJ-ENTRY-NO          = ' CJ-ENTRY-NO          
A04527          DISPLAY ' CJ-TRAN-APPL-NO      = ' CJ-TRAN-APPL-NO      
A04527          DISPLAY ' CJ-TRAN-TS           = ' CJ-TRAN-TS           
A04527          DISPLAY '*************************************'         
A04527          PERFORM 8800-DIS-TABLE-ERROR THRU 8800-EXIT             
A04527       END-IF                                                     
A04527     END-IF.                                                      
      *                                                                         
A04527 8065-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DELETES ROWS FROM CASH REPORT HEADER  TABLE                 **        
      ******************************************************************        
      *                                                                         
       8070-DELETE-CSH-RPT-HDR.                                         
      *------------------------*                                                
                                                                        
           MOVE '8070'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_CSH_REPORT_HDR                             
              WHERE DATE_CASH_REPORT < IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CSS_CSH_REPORT_HDR                                     
MFA-TR*       WHERE DATE_CASH_REPORT < :YR-DATE-CASH-REPORT                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3) TO WS-ERRD3                               
              DISPLAY SPACES                                            
              DISPLAY 'ROWS DELETED FROM CSS_CSH_REPORT_HDR= ' WS-ERRD3 
           ELSE                                                         
              STRING ' ERROR DELETING CSS_CSH_REPORT_HDR  ** '          
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' DATE_CASH_REPORT     = ' YR-DATE-CASH-REPORT     
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
A04527**  DELETES ROWS FROM CSS_GL_ENTRY_CRNT TABLE                 **          
A04527**  WITH DATE REVENUE DATE OLDER THAN JOB_PARM ENTRY          **          
A04527****************************************************************          
      *                                                                         
A04527 8071-DELETE-GL-ENTRY-CRNT.                                       
      *                                                                         
A04527     MOVE '8071' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
A04527     EXEC SQL                                                     
A04527       DELETE FROM CSS_GL_ENTRY_CRNT                              
A04527        WHERE ACCT_PERIOD_AFFCTD < :GE-ACCT-PERIOD-AFFCTD         
A04527     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04527        MOVE SQLERRD(3) TO WS-ERRD3                               
A04527        DISPLAY SPACES                                            
A04527        DISPLAY 'ROWS DELETED - CSS_GL_ENTRY_CRNT = ' WS-ERRD3    
A04527     ELSE                                                         
A04527        STRING ' ERROR DELETING CSS_GL_ENTRY_CRNT   ** '          
A04527                 DELIMITED BY SIZE INTO WS-ERR-MSG                
A04527       PERFORM 8800-DIS-TABLE-ERROR THRU 8800-EXIT                
A04527     END-IF.                                                      
      *                                                                         
A04527 8071-EXIT.                                                       
A04527     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DISPLAY TABLE ERROR                                         **        
      **                                                              **        
      ******************************************************************        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**     PCSXP431 PROCESSING ERROR            **'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'.    
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE.           
           DISPLAY '**       PROCESSING TERMINATED              **'.    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND  THRU 9900-EXIT.                          
       8800-EXIT.                                                       
            EXIT.                                                       
      *---------------------------------------------------------------*         
      * COMMIT DB2                                                    *         
      *---------------------------------------------------------------*         
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC.                                                            
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  DUMMY PARAGRAPH                                             **        
      **                                                              **        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           CONTINUE                                                     
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
