       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP400.                                           
       DATE-WRITTEN.  25 NOV 2008                                       
       DATE-COMPILED.                                                   
       AUTHOR.   PRIYA.                                                 
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      **                                                             *          
      ** DATE       INITIALS       REASON                              *        
      ** 25/18/08  SP94986         APPL37648-ACT 19, 25                *        
      ** 26/08/09  SP94986        ADD LOGIC TO PURGE FROM CSS_BANK_EFT *        
      **                          USING PURGE DATE FROM CIS_PURGE TABLE*        
      ******************************************************************00130000
      *                  PCSXP400   NARRATIVE                        *  00140000
      *    PURPOSE.                                                  *  00150000
      *    THIS PROGRAM DOES DELETION OF RECORDS FROM FOLLOWING      *  00160000
      *    TABLES USING CSS_CIS_PURGE TABLE                          *  00160000
      *    1. CSS_LIEAP                                              *  00170000
      *    2. CSS_NSF_HIST                                           *  00180000
      *    3. CSS_BANK_EFT                                           *  00180000
      * PURGE CRITERIA CAN BE FOUND IN THE CSS_JOB_PARM TABLE        *          
      * THIS PROGRAM PURGES DATA FROM THE TABLE USING                *          
      * CSS_CIS_PURGE TABLE                                          *          
      *                                                              *          
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM   *          
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)            *          
      *                                                              *          
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START -          *          
      * RESTART IS NOT NEEDED.                                       *          
      *                                                              *          
      * COMMITS ARE TAKEN                                            *          
      *                                                              *          
      *   FOR LAST RUN DATE THE ACCOUNT NO AND PURGE DATE ALONG      *          
      *   WITH RULES IN THE INDIVIDUAL CURSORS ARE USED TO DETERMINE *          
      *   THE DATA TO BE PURGED.                                     *          
      *                                                              *          
      ****************************************************************          
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP400'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-COMMIT-COUNT             PIC 9(09) VALUE ZEROS.       
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-NBR-COMMIT               PIC 9(9)  VALUE ZEROS.       
           05  WS-LIEAP-CNT-B              PIC 9(9)  VALUE ZEROS.       
           05  WS-NSF-COUNTB               PIC 9(9)  VALUE ZEROS.       
           05  WS-BANK-EFT-CNT             PIC 9(9)  VALUE ZEROS.       
           05  WS-1000                     PIC 9(4)  VALUE 1000.        
           05  WS-PURGE-DT                 PIC X(10) VALUE SPACES.      
           05  WS-SYSTEM                   PIC X(07) VALUE 'SYSTEM '.   
           05  WS-532                      PIC S9(9) VALUE -532 COMP.   
           05  WS-LAST-RUN-TIMESTAMP.                                   
               10 WS-LAST-TS-TXT           PIC X(20) VALUE              
                                           'LAST RUN TIME STAMP='.      
               10 WS-LAST-RUN-TS           PIC X(26) VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
           05  WS-PGRMNAME                 PIC X(8)  VALUE 'PCSXP400'.  
           05  WS-EXISTS                   PIC X(01)  VALUE SPACE.      
      *                                                                         
           05  WS-NSF-HIST                 PIC X(01) VALUE 'N'.         
               88 NSFHIST                            VALUE 'Y'.         
      *                                                                         
           05  WS-LIEAP                    PIC X(01) VALUE 'N'.         
               88 LIEAP                              VALUE 'Y'.         
      *                                                                         
           05  WS-BANK-EFT                 PIC X(01) VALUE 'N'.         
               88 BANKEFT                            VALUE 'Y'.         
      *                                                                         
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      ****************************************************************  02080000
      * CSS_ACCOUNT TABLE - AT                                       *          
      ****************************************************************  02080000
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      ****************************************************************          
      *  CSS_LIEAP       LI                                          *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBLIEAP                                                  
           END-EXEC.                                                            
      ****************************************************************          
      *  CSS_BANK_EFT    BE                                          *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBBNKEFT                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *  CSS_PNDNG_BNK_DRFT   PB                                     *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBPDBKDF                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *  CSS_NSF_HIST         NH                                     *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBNSFHST                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *   CSS_CIS_PURGE       PU                                     *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBPURGE                                                  
           END-EXEC.                                                            
      ****************************************************************          
      **  CSS_JOB_PARM          G6                                   *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      ****************************************************************          
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'               *          
      ****************************************************************          
       COPY FIOJC01.                                                            
      ****************************************************************          
      *   COPYBOOK FOR WS-CODES-DATA-PRESENT                         *          
      ****************************************************************          
       COPY CWS00056.                                                           
      ****************************************************************          
      *COPYBOOK TO SUPPORT RESTART-REQ PARAMETERS                    *          
      ****************************************************************          
       COPY CWS00038.                                                           
      ****************************************************************          
      *COPYBOOK TO SUPPORT DB2 AND SQL ERROR CHECKING.               *          
      ****************************************************************          
       COPY CWS00303.                                                           
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      * CURSOR TO SELECT RECORDS FROM CSS_CIS_PURGE TABLE            *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
                DECLARE PURGE_CSR_B CURSOR WITH HOLD FOR                
                   SELECT PU.ACCOUNT_NO                                 
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), PU.PURGE_TS
           , 121), ' ', '-'), ':', '.') PURGE_TS                               
                         ,PU.PURGE_DT                                   
                     FROM CSS_CIS_PURGE  PU WITH(READUNCOMMITTED)               
                   WHERE PU.LAST_UPDATE_TS >= CIS.CHAR2TIMESTAMP(
                                                     :PU-LAST-UPDATE-TS
              )        
                     FOR READ ONLY                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE PURGE_CSR_B CURSOR WITH HOLD FOR                        
MFA-TR*            SELECT PU.ACCOUNT_NO                                         
MFA-TR*                  ,PU.PURGE_TS                                           
MFA-TR*                  ,PU.PURGE_DT                                           
MFA-TR*              FROM CSS_CIS_PURGE  PU                                     
MFA-TR*            WHERE PU.LAST_UPDATE_TS >= :PU-LAST-UPDATE-TS                
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 0150-PURGE-PROCESS          THRU 0150-EXIT.          
      *                                                                         
           PERFORM 2500-PRINT-TOTALS           THRU 2500-EXIT.          
      *                                                                         
           PERFORM 7700-GET-CURRENT-TIMESTAMP  THRU 7700-EXIT.          
           MOVE    WS-CURRENT-TIMESTAMP        TO WS-LAST-RUN-TS.       
           MOVE    WS-LAST-RUN-TIMESTAMP       TO G6-PARM-DATA.         
           PERFORM 8800-UPDATE-LAST-RUN-TS     THRU 8800-EXIT.          
           DISPLAY '*********PROCESS COMPLETED SUCCESSFULLY*********'   
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET NUMBER OF MONTHS & COMMIT PARM FROM CSS_JOB_PARM         *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           PERFORM 7600P-START-FCSJC01 THRU 7600P-EXIT.                 
           PERFORM 0125-READ-FCSJC01   THRU 0125-EXIT.                  
           PERFORM 7611P-CLOSE         THRU 7611P-EXIT.                 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ MONTHS & COMMIT PARM FROM CSS_JOB_PARM                  *          
      ****************************************************************          
       0125-READ-FCSJC01.                                               
      *                                                                         
           MOVE 1                      TO   WS-I.                       
      *                                                                         
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD=')               
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD='               
              AND INPUT-ACTIVE                                          
                 MOVE WS-INPUT-DATA-BREAKDOWN(10:4) TO WS-CHKP-UPD-LIMIT
           ELSE                                                         
              MOVE WS-DEFAULT-CHKP-UPD-LIMIT  TO WS-CHKP-UPD-LIMIT      
              DISPLAY '**JOB PARM NOT ACTIVE FOR CHKP-UPD**'            
              DISPLAY '**DEFAULT OF ' WS-CHKP-UPD-LIMIT                 
                      ' WILL BE USED**'                                 
              DISPLAY '**PROCESS CONTINUING**'                          
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE 1                      TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP=')   
             OR END-OF-SYSIPT.                                          
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP='    
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA(21:26)    TO WS-LAST-RUN-TS          
                 DISPLAY 'LAST RUN TS   : '    WS-LAST-RUN-TS           
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR LAST RUN TIME STAMP'  
                 PERFORM 9900-ABEND          THRU 9900-EXIT             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR LAST RUN TIME STAMP'    
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_NSF_HIST')           
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_NSF_HIST      '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-NSF-HIST                   
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_NSF_HIST    '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_NSF_HIST'    
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_NSF_HIST    '       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_NSF_HIST'          
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_LIEAP')              
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_LIEAP         '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-LIEAP                      
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_LIEAP       '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_LIEAP   '    
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_LIEAP       '       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_LIEAP   '          
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_BANK_EFT')           
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BANK_EFT      '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-BANK-EFT                   
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BANK_EFT    '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_BANK_EFT'    
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_BANK_EFT    '       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_BANK_EFT'          
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * MAIN PURGE PROCESS FOR THE TABLES.                           *          
      ****************************************************************          
      *                                                                         
       0150-PURGE-PROCESS.                                              
      *                                                                         
           MOVE    WS-LAST-RUN-TS                TO PU-LAST-UPDATE-TS.  
      *                                                                         
           PERFORM 7000-OPEN-PURGE-CURSOR-B      THRU 7000-EXIT.        
           PERFORM 7100-FETCH-PURGE-CURSOR-B     THRU 7100-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 0150-PURGE-PROCESS PARAGRAPH'          
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS SELECTED      *'                    
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2000-PROCESS-DELETE-PARA-B THRU 2000-EXIT         
              PERFORM 7100-FETCH-PURGE-CURSOR-B  THRU 7100-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7200-CLOSE-PURGE-CURSOR-B     THRU 7200-EXIT.        
      *                                                                         
           PERFORM 8900-COMMIT                   THRU 8900-EXIT.        
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 02390000
      *   2000-PROCESS-DELETE-PARA-B.                                 * 02410000
      ***************************************************************** 02440000
      *                                                                         
       2000-PROCESS-DELETE-PARA-B.                                      
      *                                                                         
           IF LIEAP                                                     
              PERFORM 8400-LIEAPB-DEL-PROCESS         THRU 8400-EXIT    
           END-IF.                                                      
      *                                                                         
           IF  NSFHIST                                                  
               PERFORM 8600-NSFB-DEL-PROCESS        THRU 8600-EXIT      
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  ADD WS-1 TO WS-NSF-COUNTB                             
                  IF WS-NSF-COUNTB  >= WS-1000                          
                     PERFORM 8900-COMMIT     THRU 8900-EXIT             
                     DISPLAY 'ACCOUNT NO'    PU-ACCOUNT-NO              
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF  BANKEFT                                                  
               PERFORM 7250-CHECK-BANKEFT           THRU 7250-EXIT      
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF WS-EXISTS = 'Y'                                    
                    PERFORM 8500-PROCESS-DELETE-PARA  THRU 8500-EXIT    
                     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL         
                        ADD WS-1               TO WS-BANK-EFT-CNT       
                        ADD WS-1               TO WS-COMMIT-COUNT       
                        PERFORM 8200-UPD-CODES-DATA-PRESENT             
                                               THRU 8200-EXIT           
                        IF WS-COMMIT-COUNT      >= WS-1000              
                            PERFORM 8900-COMMIT     THRU 8900-EXIT      
                            DISPLAY 'ACCOUNT NO'    PU-ACCOUNT-NO       
                        END-IF                                          
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * PRINTS THE TOTAL NO.OF ACCOUNTS DELETED                      *          
      ****************************************************************          
      *                                                                         
       2500-PRINT-TOTALS.                                               
      *                                                                         
           IF NSFHIST                                                   
              DISPLAY '         '                                       
              DISPLAY '*TOT# RECS DELT CSS_NSF_HIST  : ' WS-NSF-COUNTB  
              DISPLAY '         '                                       
           END-IF.                                                      
      *                                                                         
           IF LIEAP                                                     
              DISPLAY '         '                                       
              DISPLAY 'TOT# RECS DELT CSS_LIEAP           : '           
                                           WS-LIEAP-CNT-B               
              DISPLAY '         '                                       
           END-IF.                                                      
                                                                        
           IF BANKEFT                                                   
              DISPLAY '         '                                       
              DISPLAY 'TOT# RECS DELT CSS_BANK_EFT  TABLE: '            
                                            WS-BANK-EFT-CNT             
              DISPLAY '         '                                       
           END-IF.                                                      
                                                                        
           DISPLAY 'COMMIT HAS TAKEN FOR CSS_NSF&CSS_LIEAP&BANK_EFT'.   
      *                                                                         
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **    COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING          *          
      **    7600P-START-FCSJC01                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPDPURGE                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * OPENS PURGE CURSOR                                           *          
      ****************************************************************          
      *                                                                         
       7000-OPEN-PURGE-CURSOR-B.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN PURGE_CSR_B                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP400 ABORT  ************'         
              DISPLAY '*      7000-OPEN-PURGE-CURSOR-B       *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP400  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7100-FETCH-PURGE-CURSOR-B                                    *          
      ****************************************************************          
      *                                                                         
       7100-FETCH-PURGE-CURSOR-B.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH PURGE_CSR_B                                        
                INTO :PU-ACCOUNT-NO                                     
                    ,:PU-PURGE-TS                                       
                    ,:PU-PURGE-DT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE PU-PURGE-TS(1:10)  TO  WS-PURGE-DT                   
           ELSE                                                         
              DISPLAY '********** PCSXP400 ABORT  ************'         
              DISPLAY '*     7100-FETCH-PURGE-CURSOR-B       *'         
              DISPLAY '* PU-ACCOUNT-NO = ' PU-ACCOUNT-NO                
              DISPLAY '* PU-PURGE-TS   = ' PU-PURGE-TS                  
              DISPLAY '* PU-PURGE-DT   = ' PU-PURGE-DT                  
              DISPLAY '* SQLCODE IS    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP400  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7200-CLOSE-PURGE-CURSOR-B                                    *          
      ****************************************************************          
      *                                                                         
       7200-CLOSE-PURGE-CURSOR-B.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE PURGE_CSR_B                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP400 ABORT  ************'         
              DISPLAY '*     7200-CLOSE-PURGE-CURSOR-B       *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP400  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CHECKS IF A RECORD WITH ACCOUNT-NO PASSED FROM THE CSS_CIS_  *        
      **  PURGE TABLE EXISTS IN THE CSS_BANK_EFT TABLE FOR THE GIVEN   *        
      **  CONDITIONS.                                                           
      ******************************************************************        
       7250-CHECK-BANKEFT.                                              
      *                                                                         
           MOVE '7250'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           INITIALIZE  WS-EXISTS                                        
                                                                        
              EXEC SQL                                                  
                 SELECT  'Y'                                            
                   INTO  :WS-EXISTS                                     
                   FROM CSS_BANK_EFT  BE WITH(READUNCOMMITTED)                  
                    WHERE  BE.ACCOUNT_NO      = :PU-ACCOUNT-NO          
                    AND ((BE.LAST_DRAFT_DATE <= IIF(TRY_CONVERT(DATE, 
                                                           :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) )            
                    AND BE.STATUS_CHANGE_DT IS NULL)                    
                    OR (BE.LAST_DRAFT_DATE   < IIF(TRY_CONVERT(DATE, 
                                                           :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) )             
                    AND  BE.STATUS_CHANGE_DT < IIF(TRY_CONVERT(DATE, 
                                                           :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) ))            
                    OR (BE.LAST_DRAFT_DATE  IS NULL  AND                
                       BE.STATUS_CHANGE_DT   <= IIF(TRY_CONVERT(DATE, 
                                                           :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) )))          
                                                                 
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT  'Y'                                                    
MFA-TR*            INTO  :WS-EXISTS                                             
MFA-TR*            FROM CSS_BANK_EFT  BE                                        
MFA-TR*             WHERE  BE.ACCOUNT_NO      = :PU-ACCOUNT-NO                  
MFA-TR*             AND ((BE.LAST_DRAFT_DATE <= :PU-PURGE-DT                    
MFA-TR*             AND BE.STATUS_CHANGE_DT IS NULL)                            
MFA-TR*             OR (BE.LAST_DRAFT_DATE   < :PU-PURGE-DT                     
MFA-TR*             AND  BE.STATUS_CHANGE_DT < :PU-PURGE-DT)                    
MFA-TR*             OR (BE.LAST_DRAFT_DATE  IS NULL  AND                        
MFA-TR*                BE.STATUS_CHANGE_DT   <= :PU-PURGE-DT))                  
MFA-TR*          WITH UR                                                        
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO                         
                                            WS-ACTIVE-RETURN-CODE.      
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSXP400 ABORT ****************'     
               DISPLAY '* 7250-CHECK-BANKEFT*'                          
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT_NO ', PU-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSXP400 ABORT ****************'     
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7700-GET-CURRENT-TIMESTAMP                                              
      ****************************************************************          
      *                                                                         
       7700-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                 DISPLAY '********** PCSXP400 ABORT  ************'      
                 DISPLAY '* 7700-GET-CURRENT-TIMESTAMP          *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP400  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  8200-UPD-CODES-DATA-PRESENT                                   *        
      *      UPDATE CODES_DATA_PRESENT ON CSS_ACCOUNT TABLE            *        
      ******************************************************************        
      *                                                                         
       8200-UPD-CODES-DATA-PRESENT.                                     
      *                                                                         
           MOVE  PU-ACCOUNT-NO           TO  AT-ACCOUNT-NO              
           PERFORM 8625-SELECT-ACCT-CODES THRU 8625-EXIT                
           MOVE  AT-CODES-DATA-PRESENT   TO  WS-CODES-DATA-PRESENT      
      *    MOVE  WS-CODE-BANK-EFT        TO  WS-PREV-CODE-BANK-EFT              
           MOVE  SPACES                  TO  WS-CODE-BANK-EFT           
           MOVE  WS-CODES-DATA-PRESENT   TO  AT-CODES-DATA-PRESENT      
      *                                                                         
           PERFORM 8650-UPD-ACCT-TAB     THRU 8650-EXIT.                
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_LIEAP TABLE                         *          
      * FOR WHICH REIMBURE_DT IS LESS THAN PURGE TS                  *          
      ****************************************************************          
      *                                                                         
       8400-LIEAPB-DEL-PROCESS.                                         
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM LI                                 
                FROM CSS_LIEAP LI
                 WHERE LI.ACCOUNT_NO         = :PU-ACCOUNT-NO           
                 AND   LI.REIMBURSE_DT       <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PURGE-DT
              ) <> 0) OR (LEN(:WS-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-PURGE-DT
              ), CONVERT(DATE, :WS-PURGE-DT) )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_LIEAP LI                                        
MFA-TR*          WHERE LI.ACCOUNT_NO         = :PU-ACCOUNT-NO                   
MFA-TR*          AND   LI.REIMBURSE_DT       <= :WS-PURGE-DT                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD SQLERRD(3)         TO WS-LIEAP-CNT-B               
                 PERFORM 8900-COMMIT     THRU 8900-EXIT                 
              END-IF                                                    
           ELSE                                                         
                DISPLAY '********** PCSXP400 ABORT  ************'       
                DISPLAY '* 8400-LIEAPB-DEL-PROCESS          *'          
                DISPLAY '* PU-ACCOUNT-NO = ' PU-ACCOUNT-NO              
                DISPLAY '* PU-PURGE-DT   = '  WS-PURGE-DT               
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* PROGRAM ABORTING...                 *'       
                DISPLAY '********** PCSXP400  ABORT ************'       
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * DELETES RECORDS FROM CSS_BANK_EFT                            *          
      ****************************************************************          
      *                                                                         
       8500-PROCESS-DELETE-PARA.                                        
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM BE                              
                FROM CSS_BANK_EFT BE
                 WHERE BE.ACCOUNT_NO = :PU-ACCOUNT-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_BANK_EFT BE                                     
MFA-TR*          WHERE BE.ACCOUNT_NO = :PU-ACCOUNT-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                      OR WS-532                         
              CONTINUE                                                  
           ELSE                                                         
                DISPLAY '********** PCSXP400 ABORT  ************'       
                DISPLAY '* 8500-PROCESS-DELETE-PARA         *'          
                DISPLAY '* BE-ACCOUNT-NO = ' PU-ACCOUNT-NO              
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* PROGRAM ABORTING...                 *'       
                DISPLAY '********** PCSXP400  ABORT ************'       
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CIS_NSF_HIST  TABLE                     *          
      * WHERE NSF_TIMESTMP IS LESS THAN PURGE-TS                     *          
      ****************************************************************          
      *                                                                         
       8600-NSFB-DEL-PROCESS.                                           
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM NH                              
                FROM CSS_NSF_HIST NH
                 WHERE ACCOUNT_NO        = :PU-ACCOUNT-NO               
                  AND  NH.NSF_TIMESTMP   <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_NSF_HIST  NH                                    
MFA-TR*          WHERE ACCOUNT_NO        = :PU-ACCOUNT-NO                       
MFA-TR*           AND  NH.NSF_TIMESTMP   <= :PU-PURGE-TS                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP400 ABORT  ************'         
              DISPLAY '* 8600-NSFB-DEL-PROCESS*'                        
              DISPLAY '* PU-ACCOUNT-NO = ' PU-ACCOUNT-NO                
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP400  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   8625-SELECT-ACCT-CODES                                       *        
      *    SELECT THE ACCOUNT CODES-DATA-PRESENT                       *        
      ******************************************************************        
      *                                                                         
       8625-SELECT-ACCT-CODES.                                          
      *                                                                         
           MOVE '8625'                       TO ACTIVE-PARAGRAPH.       
      *                                                                         
           EXEC SQL                                                     
               SELECT CODES_DATA_PRESENT                                
                  INTO :AT-CODES-DATA-PRESENT                           
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                  WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODES_DATA_PRESENT                                        
MFA-TR*           INTO :AT-CODES-DATA-PRESENT                                   
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*           WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************PCSXP400 ABORT****************'      
              DISPLAY '** CSS_ACCOUNT TABLE                      '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 8625 :  RETURN CODE ERROR - SELECT'           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*********PCSXP400 ABORT*******************'      
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       8625-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  8650-UPD-ACCT-TAB.                                            *        
      *    UPDATES THE ACCOUNT TABLE.                                  *        
      ******************************************************************        
      *                                                                         
       8650-UPD-ACCT-TAB.                                               
      *                                                                         
           MOVE '8650'                       TO ACTIVE-PARAGRAPH.       
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET  CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT      
                      ,LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP()          
               WHERE   ACCOUNT_NO         = :AT-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET  CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT              
MFA-TR*               ,LAST_UPDATE_TS     =  CURRENT TIMESTAMP                  
MFA-TR*        WHERE   ACCOUNT_NO         = :AT-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************PCSXP400 ABORT****************'      
              DISPLAY '** CSS_ACCOUNT TABLE                      '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 8650 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*********PCSXP400 ABORT*******************'      
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * UPDATES LAST RUN TIME STAMP TO JOB PARM                      *          
      ****************************************************************          
      *                                                                         
       8800-UPDATE-LAST-RUN-TS.                                         
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
              SET    PARM_DATA = :G6-PARM-DATA                          
              WHERE  CMND_CODE = 'DATE'                                 
              AND    COMPANY_NO = '01'                                  
              AND    PROGRAM_NAME = :WS-PGRMNAME                        
              AND    STATUS = 'A'                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                  DISPLAY '********** PCSXP400 ABORT  ************'     
                  DISPLAY '* 8800-UPDATE-LAST-RUN-TS                  *'
                  DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE          
                  DISPLAY '* WS-LAST-RUN-TSWS   = ' WS-LAST-RUN-TS      
                  DISPLAY '* PARM DATA          = ' G6-PARM-DATA        
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSXP400  ABORT ************'     
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                       *          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           COMPUTE WS-NBR-COMMIT = WS-NBR-COMMIT + 1.                   
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
