       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP321.                                        
       DATE-WRITTEN.   MAY 2010.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              SOUTH CAROLINA ELECTRIC AND GAS                ** 00060000
      **                                                             ** 00080000
      **                CUSTOMER INFORMATION SYSTEM                  ** 00090000
      ***************************************************************** 00100000
      **                                                             ** 00110000
      **                P R O G R A M S U M M A R Y                  ** 00120000
      **                                                             ** 00130000
      **                                                             ** 00140000
      **         F U N C T I O N A L  D E S C R I P T I O N          ** 00150000
      **                         O F  M O D U L E                    ** 00160000
      **                                                             ** 00170000
      **  PURPOSE :                                                  ** 00180000
      **                                                             ** 00190000
      **  GET THE ACCOUNTS WITH TRANSFER FORWARD FLAG SET AND CHECK  ** 00200000
      **  TO SEE IF THE TO ACCOUNT IS ARCHIVED IF SO UNSET TRANSFER  ** 00210000
      **  FORWARD FLAG                                               ** 00230000
      **                                                             ** 00230000
      **  LOGIC :                                                    ** 00240000
      **                                                             ** 00250000
      **  THE PROGRAM WILL PROCESS ALL OF THE RECORDS ON THE CSS_    ** 00260000
      **  ACCOUNT TABLE THAT HAVE A AR_XFER_IND = 'Y' AND SEE IF **     00270000
      **  TO_ACCOUNT IS IN HST_ACCOUNT TABLE                         ** 00280000
      **                                                             ** 00300000
      ***************************************************************** 00340000
      **                                                             ** 00350000
      **              PROGRAM  MODIFICATION  LOG                     ** 00360000
      **    DATE    INITIALS     REASON                              ** 00370000
      **  ________  _______      ______                              ** 00380000
      ** 05/07/2010  DM94438     INITIAL VERSION                     **         
      ***************************************************************** 00491700
                    ---- BASIC BATCH SEQUENCE STRUCTURE -------------   
                    0000 - 0000     MAIN CONTROL PATH                   
                    --------------------------------------------------- 
                    0100 - 0100     INITIALIZE SWITCHES AND COUNTERS    
                                    OPEN FILES                          
                    --------------------------------------------------- 
                    1000 - 1000     MAIN PROCESSING LOOP                
                    --------------------------------------------------- 
                    7000 - 7500     INQUIRY CALLS TO DATABASES          
                    --------------------------------------------------- 
                    8000 - 8000     CREATE EXTRACT                      
                    --------------------------------------------------- 
                    9000 - 9000     TERMINATE                           
                    --------------------------------------------------- 
                    9900 - 9900     ABEND                               
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT FCSC321-FILE  ASSIGN UT-S-FCSC321                     
                              STATUS IS WS-C321-STATUS.                 
      *                                                                 00650000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSC321-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
        01 FIOC321-REC.                                                 
           05 E-C321-ACCOUNT-NO                PIC 9(13).               
           05 E-C321-ESC-CD                    PIC X(01).               
      *                                                                 00720000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP321'.
MSQ017     COPY MFASQLM.
      *                                                                 00740000
       01  WS-MISC.                                                     
           05 WS-START                     PIC X(40) VALUE              
              'WORKING STORAGE FOR PCSXP321 STARTS HERE'.               
           05  WS-ACCOUNT-NO      PIC S9(13)V COMP-3 VALUE 0.           
           05  WS-DISPLAY-COUNT            PIC Z(09).                   
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
           05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
           05  RS-RETURN-CODE              PIC S9(4) COMP.              
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-DEFAULT-CHKP-UPD-LIMIT  PIC 9(07) VALUE 20.           
           05  WS-CHKP-UPD-LIMIT          PIC 9(07) VALUE 0.            
           05  WS-DEFAULT-CHKP-LUW-LIMIT  PIC 9(07) VALUE 4.            
           05  WS-CHKP-LUW-LIMIT          PIC 9(07) VALUE 0.            
           05  WS-UPD-ACCT-TOTAL          PIC S9(9) COMP VALUE 0.       
      *                                                                 01350000
       01  WS-SWITCHES.                                                 
           05  WS-C321-STATUS           PIC X(02).                      
               88  C321-SUCCESSFUL      VALUE '00'.                     
           05  WS-REFUND-EOF-SW            PIC X(01) VALUE 'N'.         
               88  END-OF-REFUND                     VALUE 'Y'.         
           05  WS-DATA-ACCT                PIC X(03) VALUE 'YES'.       
               88  NO-MORE-DATA-ACCT                 VALUE 'NO'.        
      *                                                                 01530000
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP321'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSXP321'.  
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
      *                                                                 01590000
       01  WS-COMPANY-NO                   PIC X(02).                   
                                                                        
      /****** JOBS FILE/TABLE DEFINITIONS                               03008000
           COPY FIOCA00.                                                03009000
           COPY FIOJC01.                                                03010000
      /****** CWS00038 IS JC01 WORK DATA                                03020000
       COPY CWS00038.                                                   03030000
      /****** CWS00039 IS CA00 WORK DATA                                03040000
       COPY CWS00039.                                                   03040100
      /****** CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                03040200
       COPY CWS00303.                                                   03040300
      /****** CWS09900 CONTAINS ABEND WS VARIABLES                      03040400
       COPY CWS09900.                                                   03040500
      /****** CWS00010 CONTAINS DB2 ABEND VARIABLES                     03040600
       COPY CWS00010.                                                   03040700
      /****** CWS00011 CONTAINS VARIABLES FOR CPD00004                  03043000
       COPY CWS00011.                                                   03044000
      *                                                                 03045000
           EXEC SQL                                                     03046000
             INCLUDE SQLCA                                              03047000
           END-EXEC.                                                    03048000
      *                                                                 03049000
      ***********************************************************               
      * DCLGEN TABLE(CSS_AR_LOCKOUT)                            *               
      ***********************************************************               
           EXEC SQL                                                     03589900
               INCLUDE TBARLOCK                                         03590000
           END-EXEC.                                                    03590100
      *                                                                 03790000
      ***********************************************************               
      * DCLGEN TABLE(CSS_JOB_PARM)                             *                
      ***********************************************************               
           EXEC SQL                                                     03250000
             INCLUDE TBJBPARM                                           03260000
           END-EXEC.                                                    03270000
      *                                                                 03280000
      ***********************************************************               
      * DCLGEN TABLE(CSS_ACCOUNT)  AT                           *               
      ***********************************************************               
           EXEC SQL                                                     03050000
             INCLUDE TBACCT                                             03060000
           END-EXEC.                                                    03070000
      *                                                                 03049000
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(HST_ACCOUNT)  HA                           *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************       03490000
      *  CURSOR TO FETCH ACCOUNTS TO BE PROCESSED               *       03500000
      ***********************************************************       03510000
      *                                                                 03790000
                                                                        
           EXEC SQL                                                     
           DECLARE HST_ACT CURSOR FOR                                   
           SELECT AT.ACCOUNT_NO                                         
           FROM HST_ACCOUNT HA WITH(READUNCOMMITTED),                           
                CSS_ACCOUNT AT WITH(READUNCOMMITTED)                            
           WHERE AT.ACCT_XFER_TO = HA.ACCOUNT_NO                        
           AND   AT.AR_XFER_IND = 'Y'                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03591000
MFA-TR*    DECLARE HST_ACT CURSOR FOR                                   01100001
MFA-TR*    SELECT AT.ACCOUNT_NO                                                 
MFA-TR*    FROM HST_ACCOUNT HA,                                                 
MFA-TR*         CSS_ACCOUNT AT                                                  
MFA-TR*    WHERE AT.ACCT_XFER_TO = HA.ACCOUNT_NO                                
MFA-TR*    AND   AT.AR_XFER_IND = 'Y'                                           
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 1000                                                         
MFA-TR*    END-EXEC.                                                    03730000
      *                                                                 03740000
       01  ABEND-FUNCTIONS.                                             
           05  WS-ABEND-SPACE              PIC X(02) VALUE SPACE.       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC        PIC 9(02).                   
      *                                                                 03890000
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSXP321 ENDS HERE  '.            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************03940000
      **    0000-MAINLINE                                             **03950000
      ******************************************************************03960000
                                                                        
       0000-MAINLINE.                                                   
      *                                                                 03990000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                 04011000
      *  PROCESS ONLY IF THERE IS DATA                         **       04280031
      *                                                                         
           PERFORM 1100-PROCESS-ACCT-RECS THRU 1100-EXIT                
                     UNTIL NO-MORE-DATA-ACCT                            
      *                                                                 04291131
           PERFORM 9100-TERMINATE THRU 9100-EXIT.                       
           STOP RUN.                                                    
      *                                                                 04310000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04340000
      ************************************************************      04350000
      **  0100-INITIALIZATION.                                  **      04360000
      **      ACCEPTS CURRENT DATE.                             **      04370000
      ************************************************************      04380000
       0100-INITIALIZATION.                                             
      *                                                                 04400000
           OPEN OUTPUT FCSC321-FILE.                                    
           IF C321-SUCCESSFUL                                           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSXP321 PROCESSING ERROR   **'           
               DISPLAY '**   FCSC321-FILE WILL NOT OPEN   **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               DISPLAY 'FILE-STATUS = ' WS-C321-STATUS                  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           INITIALIZE  FIOC321-REC.                                     
                                                                        
      *  CHECK AR LOCKOUT                                               04652000
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              DISPLAY ' '                                               
              DISPLAY '**  PCSXP321 PROCESSING ERROR  **'               
              DISPLAY '**  AR LOCKOUT IN EFFECT       **'               
              DISPLAY '**  PROCESSING TERMINATED      **'               
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           ELSE                                                         
              PERFORM 7005-OPEN-ACCOUNT-CURSOR THRU 7005-EXIT           
              PERFORM 7006-FETCH-CURSOR-ACCOUNT THRU 7006-EXIT          
           END-IF.                                                      
      *                                                                         
                                                                        
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
                                                                        
      *                                                                 04659100
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04680000
      ************************************************************      05220000
      **  1100-PROCESS-ACCT-RECS.                               **      05230000
      **      PROCESS ACCOUNT BASED ON XFR AND ARCHIVAL STATUS  **      05240000
      ************************************************************      05270000
      *                                                                 05280000
       1100-PROCESS-ACCT-RECS.                                          
           PERFORM 7006-FETCH-CURSOR-ACCOUNT THRU 7006-EXIT.            
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
      ************************************************************      05833600
      **  7005-OPEN-ACCOUNT-CURSOR.                             **      05833200
      **      OPENS CURSOR HST_ACT TO SELECT RECORDS FOR        **      05833300
      **      PROCESSING ARCHIVED ACCTS SITTING IN XFER TO      **      05833400
      ************************************************************      05833600
        7005-OPEN-ACCOUNT-CURSOR.                                       
           EXEC SQL                                                     
               OPEN HST_ACT                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PCSXP321 PROCESSING ERROR       **'          
               DISPLAY '** OPEN ERROR ON CURSOR ACCOUNT    **'          
               DISPLAY '** PARA 7005-OPEN-ACCOUNT-CURSOR   **'          
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05950000
      ************************************************************      06180000
      **  7006-FETCH-CURSOR-ACCOUNT.                            **      06190000
      **      FETCHES THE CURSOR VALUES INTO WS VARIABLES       **      06200000
      **      AND TEST SQLCODE FOR SUCCESS AND END OF TABLE     **      06210000
      ************************************************************      06220000
       7006-FETCH-CURSOR-ACCOUNT.                                       
           EXEC SQL                                                     
                FETCH HST_ACT                                           
                INTO :AT-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 7011-UPDATE-ARFLAG THRU 7011-EXIT            
               WHEN NOT-FOUND                                           
                   MOVE 'NO' TO WS-DATA-ACCT                            
               WHEN OTHER                                               
                   DISPLAY '** PCSXP321 PROCESSING ERROR        **'     
                   DISPLAY '** ERROR ON FETCH CURSOR            **'     
                   DISPLAY '** PARA 7006-FETCH-CURSOR-ACCOUNT   **'     
                   DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
                   DISPLAY '** PROCESSING TERMINATED            **'     
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-EVALUATE.                                            
       7006-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08080000
      ************************************************************      05960000
      **  7010-CLOSE-ACCOUNT-CURSOR.                            **      05970000
      **      CLOSE ACCOUNT CURSOR.                             **      05980000
      ************************************************************      05990000
        7010-CLOSE-ACCOUNT-CURSOR.                                      
           EXEC SQL                                                     
               CLOSE HST_ACT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PCSXP321 PROCESSING ERROR        **'         
               DISPLAY '** CLOSE ERROR ON CURSOR ACCOUNT    **'         
               DISPLAY '** PARA 7010-CLOSE-ACCOUNT-CURSOR   **'         
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED            **'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           CLOSE FCSC321-FILE.                                          
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06170000
      *                                                                 06170000
      ************************************************************      06180000
      **  7011-UPDATE-ARFLAG                                    **      06190000
      **      UPDATES TRANSFER FORWARD FLAG FROM Y TO N         **      06200000
      ************************************************************      06220000
       7011-UPDATE-ARFLAG.                                              
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
             SET AR_XFER_IND  = 'N'                                     
             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_ACCOUNT                                                 
MFA-TR*      SET AR_XFER_IND  = 'N'                                             
MFA-TR*      WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                  
MFA-TR*      QUERYNO 7011                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '**UPDATED XFER INDICATOR*' AT-ACCOUNT-NO         
              PERFORM 8000-WRITE-C321 THRU 8000-EXIT                    
              COMPUTE WS-UPD-ACCT-TOTAL = WS-UPD-ACCT-TOTAL + 1         
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '** PCSXP321 PROCESSING ERROR'                    
              DISPLAY '** PARAGRAPH = 7011-UPDATE-ARFLAG'               
              DISPLAY '** RC        = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '** PROCESSING TERMINATED'                        
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7011-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************** 09060000
      ** 6251-GET-FJC01-DATE                                         ** 09070000
      ***************************************************************** 09080000
      *                                                                 09090000
       COPY CPD00037.                                                   09100000
      *                                                                 09110000
       COPY CPD00040.                                                   09120000
      *                                                                 09130000
      ***************************************************************** 09220000
      ** 7600-START-FCJ01                                            ** 09230000
      ***************************************************************** 09240000
      *                                                                 09250000
           EXEC SQL                                                     09260000
               INCLUDE CPD00039                                         09270000
           END-EXEC.                                                    09280000
      *                                                                 09210000
      ***************************************************************** 09220000
      ** 7999-SELECT-AL                                              ** 09230000
      ***************************************************************** 09240000
      *                                                                 09210000
           EXEC SQL                                                     09290300
               INCLUDE CPD00075                                         09290400
           END-EXEC.                                                    09290500
      *                                                                 09250000
      ******************************************************************        
      * 8000-WRITE-C321.                                               *        
      ******************************************************************        
       8000-WRITE-C321.                                                 
      *                                                                         
           WRITE FIOC321-REC.                                           
      *                                                                         
           IF C321-SUCCESSFUL                                           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSXP321 PROCESSING ERROR   **'           
               DISPLAY '**   WRITE FCSC321-FILE IS FAILED **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               DISPLAY ' FILE-STATUS = ' WS-C321-STATUS                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 09290600
      ****************************************************************  05160000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  05170000
      **  *RETRIEVE COMMIT COUNT DETAILS FROM JOB PARM TABLE.        *  05170000
      ****************************************************************  05180000
      *                                                                         
            EXEC SQL                                                    05190000
                INCLUDE CPD00034                                        05200000
            END-EXEC.                                                   05210000
      *                                                                 05220000
      *----------------------------------------------------------------*        
      * SELECT CSS_JOB_PARM TABLE                                      *        
      * 7600-, 7610-,7611- PARAGRAPHS                                  *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC                                                             
                                                                        
      *----------------------------------------------------------------*        
      *******************************************************           08740101
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                 08741001
      ****************************************************************  08750000
      **                                                            **  08760000
      **   9000-TERMINATE.                                          **  08770000
      **       IF PROCESS ABENDS ROLLS BACK ON CHANGES TO DB  &     **  08780000
      **       CLOSES ALL FILES.                                    **  08790000
      ****************************************************************  08800000
      *                                                                 08810000
       9000-TERMINATE.                                                  
      *                                                                 08830000
           CLOSE FCSC321-FILE.                                          
      *                                                                 08890000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08920000
      ****************************************************************  08533700
      **                                                            **  08533800
      **   9100-TERMINATE.                                          **  08533900
      **       IF PROCESS RUNS THRU OKAY COMMIT'S CHANGES TO DB &   **  08534000
      **       CLOSES ALL FILES.                                    **  08535000
      ****************************************************************  08536000
      *                                                                 08537000
       9100-TERMINATE.                                                  
      *                                                                 08539000
           PERFORM 7010-CLOSE-ACCOUNT-CURSOR THRU 7010-EXIT             
           MOVE WS-UPD-ACCT-TOTAL TO WS-DISPLAY-COUNT                   
           DISPLAY 'ACCOUNTS UPDATED ' WS-DISPLAY-COUNT.                
      *                                                                 08580000
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08740000
      ***************************************************************** 09300000
      ** 9700-PROCESS-ABEND.                                         ** 09310000
      ***************************************************************** 09320000
      *                                                                 09330000
       COPY CPD0023B.                                                   09340000
      *                                                                 09350000
      *                                                                 09350100
       9900-SQL-ERROR-ROUTINE.                                          
           GO TO 9900-EXIT.                                             
      *                                                                 09351000
      **************************************************************    09360000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    09370000
      **************************************************************    09380000
      *                                                                 09351000
      *                                                                 09290600
      ***************************************************************** 09300000
      ** 9900-ABEND.                                                 ** 09310000
      ***************************************************************** 09320000
      *                                                                 09330000
                                                                        
           EXEC SQL                                                     09400000
                INCLUDE CPD09900                                        09410000
           END-EXEC.                                                    09420000
      **************************************************************    09430000
