       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP320.                                        
       DATE-WRITTEN.   SEP 2009.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              SOUTH CAROLINA ELECTRIC AND GAS                ** 00060000
      **                                                             ** 00080000
      **                CUSTOMER INFORMATION SYSTEM                  ** 00090000
      ***************************************************************** 00100000
      **                                                             ** 00110000
      **                P R O G R A M S U M M A R Y                  ** 00120000
      **                                                             ** 00130000
      **                                                             ** 00140000
      **         F U N C T I O N A L  D E S C R I P T I O N          ** 00150000
      **                         O F  M O D U L E                    ** 00160000
      **                                                             ** 00170000
      **  PURPOSE :                                                  ** 00180000
      **                                                             ** 00190000
      **  GET THE ACCOUNTS IN FINAL BILLED AND WRITE OFF STATUS      ** 00200000
      **  THAT MEETS CRITERIA AND INSERT INTO CSS_ARCHIVE_FCST       ** 00210000
      **                                                             ** 00230000
      **  LOGIC :                                                    ** 00240000
      **                                                             ** 00250000
      **  THE PROGRAM WILL PROCESS ALL OF THE RECORDS ON THE CSS_    ** 00260000
      **  ACCOUNT TABLE THAT HAVE A CODE_ACCT_STAT = 'B' OR 'S'         00270000
      **  AND MEET OTHER CRITERIA BEFORE WRITING INTO CSS_ARCHIVE_FCST* 00280000
      **                                                             ** 00300000
      ***************************************************************** 00340000
      **                                                             ** 00350000
      **              PROGRAM  MODIFICATION  LOG                     ** 00360000
      **    DATE    INITIALS     REASON                              ** 00370000
      **  ________  _______      ______                              ** 00380000
      ** 09/28/2009  DM94438     INITIAL VERSION                     **         
A37666** 04/08/2010  DM94438     ADDED 7614-SELECT-FINWO-ACTIONPARA **          
A37666**                         WHEN WRITE OFF ACCT NOT IN CHARGE OFF          
A37666**                         TBL, FORECAST DATES WERE INCORRECT             
A37666**                         ACTIVITY ACT37666062                           
A37666** 04/15/2010  DM94438     CASH REFUNDS - CANCELLED STATUS                
A37666**                         RN.CHEK_STATUS_CD  INCLUDED 'C'                
A37666**                         IN 7305-CASH-RFND                              
A37666**                         ACTIVITY ACT37666063                           
A37666** 05/26/2010  DM94438     IF MONEY SITTING IN DEP ON HAND                
A37666**                         DO NOT SEND TO XP520 FOR REVIEW                
A37666**                         NEEDS TO BE AN EXCEPTION                       
A37666**                         ACTIVITY ACT37666072                           
A37666** 10/07/2010  DM94438     REFINE/REARRANGE LOGIC TO GIVE                 
A37666**                         CORRECT PRECEDENCE WHEN FORECASTING            
A37666**                         ALSO MOVED THE EXEMPT LOGIC.                   
A37666**                         ACTIVITY ACT37666090                           
ACT111** 04/14/2016  TP7R341     WORK QUEUE CHANGE TO REMOVE THE     **         
ACT111**             A04860      CSS_WQ_ITEMS_MF TABLE               **         
A05460** 08/04/2016  SM93554     REMOVED UN-USED TABLES AND RELATED  **         
      **             ACT245      CODES AS PRT OF DROP TABLE.         **         
ACT278** 09/22/2016  TP7R341     REMOVE UNWANTED COLUMNS FROM        **         
ACT278**             A05460      CONTRACT TABLE                      **         
      ***************************************************************** 00491700
      ***************************************************************** 00491700
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00016400
      **                                                             ** 00016500
      **  0000         MODULE CONTROL                                ** 00016600
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00016700
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00016800
      **  2000 - 4999  DETAIL LOGIC                                  ** 00016900
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00017000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00017100
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00017200
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00017300
      **                                                             ** 00017400
      ***************************************************************** 00017500
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      * OUTPUT FILE THAT STORES THE ACCOUNTS INSERTED                           
      * IN ARCHIEVE TABLE FOR CURRENT RUN                                       
           SELECT FCSC320-FILE  ASSIGN UT-S-FCSC320                     
           STATUS IS WS-C320-STATUS.                                    
      *                                                                 00650000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSC320-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
        01 FIOC320-REC.                                                 
           05 E-FCA320-ACCOUNT-NO              PIC 9(13).               
           05 E-FCA320-TABLE-ID                PIC X(2).                
           05 E-FCA320-ACTION                  PIC X(1).                
           05 E-FCA320-FLAG                    PIC X(1).                
           05 E-FCA320-ERRFL                   PIC X(1).                
      *                                                                 00720000
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP320'.
MSQ017     COPY MFASQLM.
      *                                                                 00740000
      * WORKING STORAGE FOR CODES-DATA-PRESENT                                  
       COPY CWS00056.                                                           
                                                                        
       01  WS-TABLES.                                                   
         05  T1-CSS-PENDING-XFER       OCCURS 2000                      
                                       INDEXED BY T1-INDEX.             
             10  T1-ACCT-XFER-TO       PIC S9(13) COMP-3 VALUE ZEROES.  
             10  T1-ACCT-XFER-FROM     PIC S9(13) COMP-3 VALUE ZEROES.  
                                                                        
       01  WS-MISC.                                                     
           05 WS-START                     PIC X(40) VALUE              
              'WORKING STORAGE FOR PCSXP320 STARTS HERE'.               
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0.  
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
           05  WS-DATE-TRANS               PIC X(10) VALUE SPACES.      
           05  WS-DATE-PLUS-3-MONTHS       PIC X(10).                   
           05  WS-DATE-PLUS-18-MONTHS      PIC X(10).                   
           05  WS-DATE-MINUS-3-MONTHS      PIC X(10).                   
           05  WS-DATE-MAX-CONTRCT         PIC X(10).                   
           05  WS-DATE-PLUS-6YRS-3MTHS     PIC X(10).                   
           05  WS-AR-DATE-PLUS-7-MONTHS    PIC X(10).                   
           05  WS-DATE-PLUS-7-MONTHS       PIC X(10).                   
           05  WS-DATE-PLUS-6-MONTHS       PIC X(10).                   
           05  WS-DATE-PLUS-12-MONTHS      PIC X(10).                   
           05  WS-DATE-MINUS-6-MONTHS      PIC X(10).                   
           05  WS-FBDT-PLUS-42-MONTHS      PIC X(10).                   
           05  WS-FBDT-PLUS-8-YEARS        PIC X(10).                   
           05  WS-WODT-PLUS-8-YEARS        PIC X(10).                   
           05  WS-WODT-PLUS-42-MONTHS      PIC X(10).                   
           05  WS-RFNDDT-PLUS-12-MONTHS    PIC X(10).                   
           05  WS-LSTPYT-PLUS-36-MONTHS    PIC X(10).                   
           05  WS-RFNDDT-PLUS-24-MONTHS    PIC X(10).                   
           05  WS-RFNDDT-PLUS-60-MONTHS    PIC X(10).                   
           05  WS-DATE-PLUS-1-YEAR         PIC X(10).                   
           05  WS-DATE-PLUS-1-MONTH        PIC X(10).                   
           05  WS-CODES-DATA-PRESENT-AT    PIC X(32).                   
           05  WS-REC-PRESENT-FL           PIC X(1) VALUE SPACES.       
           05  WS-FLAG-RFNDN               PIC X(1) VALUE SPACES.       
           05  WS-NTF-CHRG-OFF             PIC X(1) VALUE SPACES.       
           05  WS-CIA-PRESENT-FL           PIC X(1) VALUE SPACES.       
           05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
           05  WS-FCST-REV-COUNT           PIC S9(09) COMP VALUE 0.     
           05  WS-FCST-ERR-COUNT           PIC S9(09) COMP VALUE 0.     
           05  WS-EXEMPTION-COUNT          PIC S9(09) COMP VALUE 0.     
           05  WS-PROCESSED-COUNT          PIC S9(09) COMP VALUE 0.     
           05  WS-DISPLAY-COUNT            PIC Z(09).                   
           05  WS-WRT-OFF-DATE             PIC X(10) VALUE SPACES.      
           05  WS-MAX-REFUND-ITEM-ID       PIC S9(9) USAGE COMP.        
           05  WS-REFUND-ITEM-ID-NI        PIC S9(4) COMP VALUE 0.      
           05  WS-NULL-INDICATORS          PIC S9(04) USAGE COMP.       
           05  WS-NULL-INDICATOR-1         PIC S9(04) USAGE COMP.       
           05  WS-NULL-INDICATOR-2         PIC S9(04) USAGE COMP.       
           05  S-RETURN-CODE               PIC S9(4) COMP.              
           05  RS-RETURN-CODE              PIC S9(4) COMP.              
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
COB305     05 WS-WRT-OFF-AMT        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-CHR-OFF-MESSAGE.                                      
               10  FILLER                  PIC X(46) VALUE              
                    'Final bill account with data in CSS_CHRG_OFF  '.   
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  DATE-FILLER             PIC X(10).                   
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  AMOUNT-FILLER           PIC -----.99.                
           05  WS-WRT-OFF-MESSAGE.                                      
               10  FILLER                  PIC X(30) VALUE              
                    'Write off Date and Amount is  '.                   
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-WRT-OFF-DATE-R       PIC X(10).                   
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-WRT-OFF-AMT-R        PIC -----.99.                
           05  WS-ESC-OFF-MESSAGE.                                      
               10  FILLER                  PIC X(40) VALUE              
                    'Credit balance will be escheated '.                
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-LST-PYMT-DT-ESC      PIC X(10).                   
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-ESC-AMT-R            PIC -----.99.                
           05  WS-ARBAL-MESSAGE.                                        
               10  FILLER                  PIC X(30) VALUE              
                    'Account balance > 0          '.                    
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-FB-DATE-R           PIC X(10).                    
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-ARB-R            PIC -----.99.                    
           05  WS-SEB-ARBAL-MESSAGE.                                    
               10  FILLER                  PIC X(46) VALUE              
                    'Credit Balance > 0 to be returned to customer '.   
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-LST-PYMT-DT-SEB      PIC X(10).                   
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-SEB-ARB-R            PIC -----.99.                
           05  WS-FNL-OFF-MESSAGE.                                      
               10  FILLER                  PIC X(30) VALUE              
                    'Final Bill with zero balance  '.                   
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-FNL-OFF-DATE-R       PIC X(10).                   
               10  FILLER                  PIC X(10) VALUE  SPACES.     
                                                                        
           05  WS-CRD-BALLT1-MESSAGE.                                   
               10  FILLER                  PIC X(50) VALUE              
                   'Credit Balance to be returned to customer '.        
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-LST-PYMT-DT-CSRLT1   PIC X(10) VALUE SPACES.      
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-CRD-AMT-R            PIC -----.99.                
           05  WS-AR-TRN-MESSAGE.                                       
               10  FILLER                  PIC X(44) VALUE              
                     'Financial Transaction Hist in last 6 months '.    
               10  FILLER                  PIC X(2)  VALUE  SPACES.     
               10  WS-AR-TRN-DATE-R        PIC X(10) VALUE SPACES.      
               10  FILLER                  PIC X(10) VALUE  SPACES.     
           05  WS-RFND-MESSAGE.                                         
               10  FILLER                  PIC X(47) VALUE              
                     'Refund in Issued,Remailed or Undelivered status'. 
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-RFND-DATE-R          PIC X(10)  VALUE  SPACES.    
               10  FILLER                  PIC X(10) VALUE  SPACES.     
           05  WS-CONTRACT-MESSAGE.                                     
               10  FILLER                  PIC X(41) VALUE              
                    'Contract on account-max contract date is '.        
               10  FILLER                  PIC X(2) VALUE  SPACES.      
               10  WS-CTR-DATE             PIC X(10) VALUE SPACES.      
               10  FILLER                  PIC X(10) VALUE  SPACES.     
      * MESSAGES IN WS VARIABLES                                                
           05  WS-FB-MESSAGE          PIC X(100) VALUE                  
               'Archive rule for write off used - Account has been repor        
      -        'ted to Credit Bureau'.                                          
           05  WS-BK-MESSAGE          PIC X(100) VALUE                  
               'Account flagged as bankrupt but bankruptcy info does not        
      -        'exist'.                                                         
           05  WS-CIA-MESSAGE          PIC X(100) VALUE                 
               'Account has credit balance but no CIA'.                 
           05  WS-BK-DT-MESSAGE        PIC X(100) VALUE                 
               'Bankrupt account with no bankrupcy date'.               
           05  WS-BK-CS-MESSAGE        PIC X(100) VALUE                 
               'Bankrupt account without case number'.                  
           05  WS-CS-RN-MESSAGE        PIC X(100) VALUE                 
               'Cash refund in status other than Issued'.               
           05  WS-AR-MESSAGE        PIC X(100) VALUE                    
               'Charges Summary not all zero'.                          
           05  WS-CNT-ST-MESSAGE    PIC X(100) VALUE                    
               'Contract status is Active or Pending'.                  
           05  WS-FB-DT-MESSAGE    PIC X(100) VALUE                     
               'Final Billed status and no final bill date'.            
           05  WS-RFND-3MTH-MESSAGE  PIC X(100) VALUE                   
               'Refund in Approved or Requested status older than 3 mont        
      -         'hs'.                                                           
           05  WS-LST-ACC-PRM-MESSAGE  PIC X(100) VALUE                 
               'Error in last account at premise routine(CPD0099)'.     
                                                                        
      *                                                                         
           05  WS-DEFAULT-CHKP-UPD-LIMIT  PIC 9(07) VALUE 20.           
           05  WS-CHKP-UPD-LIMIT          PIC 9(12) VALUE 0.            
           05  WS-DEFAULT-CHKP-LUW-LIMIT  PIC 9(07) VALUE 4.            
           05  WS-CHKP-LUW-LIMIT          PIC 9(07) VALUE 0.            
           05  WS-INS-ACCT-TOTAL          PIC S9(09) COMP VALUE 0.      
           05  WS-UPD-ACCT-TOTAL          PIC S9(09) COMP VALUE 0.      
           05  WS-COMMIT-COUNT            PIC S9(09) COMP VALUE 0.      
           05  WS-BK-DATE-PLUS-10-YEARS   PIC X(10).                    
           05  WS-PEND-XFER-FL     PIC X(01) VALUE SPACES.              
           05  WS-MSTSUB-FL        PIC X(01) VALUE SPACES.              
           05  WS-DATABASE            PIC 9(01) VALUE 0.                
               88 CSR-DATABASE                  VALUE 1.                
               88 SEB-DATABASE                  VALUE 2.                
           05  WS-ITERATION-STORAGE.                                    
               10 WS-PREV-ARC-EXMPT-CD   PIC X(1) VALUE SPACES.         
               10 WS-ARCHIVE-EXEMPT-CD   PIC X(1) VALUE SPACES.         
               10 WS-DISPLAY-ACCOUNT  PIC 9(13) VALUE ZEROES.           
               10 WS-DISPLAY-PREMISE  PIC 9(10) VALUE ZEROES.           
               10 WS-NULL-IND         PIC S9(4) COMP VALUE +0.          
               10 WS-NULL-IND-1       PIC S9(4) COMP VALUE +0.          
               10 WS-UTIL-BIL-FL      PIC X(01) VALUE SPACES.           
               10 WS-RECONN-FL        PIC X(01) VALUE SPACES.           
               10 WS-CON-EXP-FL       PIC X(01) VALUE SPACES.           
               10 WS-MSE-CON-FL       PIC X(01) VALUE SPACES.           
               10 WS-MNT-HST-FL       PIC X(01) VALUE SPACES.           
               10 WS-CHR-OFF-FL       PIC X(01) VALUE SPACES.           
               10 WS-ARCHIVE-FL       PIC X(01) VALUE 'Y'.              
               10 WS-GENERATE-WQ-FL   PIC X(01) VALUE 'N'.              
               10 WS-ACC-ARCH-FL      PIC X(01) VALUE 'N'.              
               10 WS-CPD99-ERROR      PIC X(01) VALUE 'N'.              
               10 WS-CURRENT-ACCOUNT  PIC 9(13) VALUE ZEROES.           
               10 WS-MAX-REASON-CD    PIC X(01) VALUE SPACES.           
               10 WS-TEMP-REASON-CD   PIC X(01) VALUE SPACES.           
               10 WS-FCAST-TYPE-CD    PIC X(01) VALUE SPACES.           
               10 WS-TEMP-FCAST-TYPE-CD    PIC X(01) VALUE SPACES.      
               10 WS-MAX-DATE         PIC X(10) VALUE SPACES.           
               10 WS-MAX-TABLE-NAME   PIC X(100) VALUE SPACES.          
               10 WS-TEMP-MESSAGE     PIC X(100) VALUE SPACES.          
               10 WS-TEMP-DATE        PIC X(10) VALUE SPACES.           
                                                                        
      *                                                                 01350000
       01  WS-SWITCHES.                                                 
           05  WS-C320-STATUS           PIC X(02).                      
               88  C320-SUCCESSFUL      VALUE '00'.                     
           05  WS-REFUND-EOF-SW            PIC X(01) VALUE 'N'.         
               88  END-OF-REFUND                     VALUE 'Y'.         
           05  WS-DATA-ACCT                PIC X(03) VALUE 'YES'.       
               88  NO-MORE-DATA-ACCT                 VALUE 'NO'.        
           05  WS-CB-CA-SW                 PIC X(01) VALUE 'N'.         
      *                                                                 01530000
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP320'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSXP320'.  
           05  WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
      *                                                                 01590000
       01  WS-COMPANY-NO                   PIC X(02).                   
                                                                        
      /****** JOBS FILE/TABLE DEFINITIONS                               03008000
           COPY FIOCA00.                                                03009000
           COPY FIOJC01.                                                03010000
      /****** CWS00038 IS JC01 WORK DATA                                03020000
       COPY CWS00038.                                                   03030000
      /****** CWS00039 IS CA00 WORK DATA                                03040000
       COPY CWS00039.                                                   03040100
      /****** CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                03040200
       COPY CWS00303.                                                   03040300
      /****** CWS09900 CONTAINS ABEND WS VARIABLES                      03040400
       COPY CWS09900.                                                   03040500
      /****** CWS00010 CONTAINS DB2 ABEND VARIABLES                     03040600
       COPY CWS00010.                                                   03040700
      /****** CWS00011 CONTAINS VARIABLES FOR CPD00004                  03043000
       COPY CWS00011.                                                   03044000
      *                                                                         
      /****** CWS00099 CONTAINS VARIABLES FOR CPD00099                  03043000
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     03046000
             INCLUDE SQLCA                                              03047000
           END-EXEC.                                                    03048000
      *                                                                         
      *****************************************************************         
      * DCLGEN TABLE (CSS_DELINQUENCY)                                          
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * DCLGEN TABLE (CSS_MNT_TRANS_HIST)                                       
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      * DCLGEN TABLE (CSS_FINAL_WO)                                             
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * DCLGEN TABLE (CSS_MT_TRN_HST_DET TABLE)                                 
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_CONTACT)                               *               
      ***********************************************************               
           EXEC SQL                                                             
                INCLUDE TBCNTACT                                                
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_UTL_BILL_REL)                          *               
      ***********************************************************               
           EXEC SQL                                                             
                INCLUDE TBUTLREL                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_REFUND)                                *               
      ***********************************************************               
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_PENDING_XFER)                          *               
      ***********************************************************               
           EXEC SQL                                                             
                INCLUDE TBPENXFR                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_CONTRACT)                              *               
      ***********************************************************               
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCNTRCT                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_RECONNECT)                             *               
      ***********************************************************               
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBRECNCT                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_AR_CNTL)                               *               
      ***********************************************************               
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBARCNTL                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_WQ_ITEM)                               *               
      ***********************************************************               
           EXEC SQL                                                             
                INCLUDE TBWQITS                                                 
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_MSTSUB_ACCT)                           *               
      ***********************************************************               
           EXEC SQL                                                             
                INCLUDE TBMSTSUB                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_PNDNG_BNK_DRFT)                        *               
      ***********************************************************               
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBPDBKDF                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_CHRG_OFF)                              *               
      ***********************************************************               
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCHGOFF                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_ACCOUNT)                               *               
      ***********************************************************               
           EXEC SQL                                                     03050000
             INCLUDE TBACCT                                             03060000
           END-EXEC.                                                    03070000
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(TBACXMPT)                                  *               
      ***********************************************************               
           EXEC SQL                                                     03050000
             INCLUDE TBACXMPT                                           03060000
           END-EXEC.                                                    03070000
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_REFUND_REASON)                         *               
      ***********************************************************               
           EXEC SQL                                                     03090000
             INCLUDE TBRFNRSN                                           03100000
           END-EXEC.                                                    03110000
      *                                                                 03120000
      ***********************************************************               
      * DCLGEN TABLE(CSS_NAME)                                  *               
      ***********************************************************               
           EXEC SQL                                                     03170000
             INCLUDE TBNAME                                             03180000
           END-EXEC.                                                    03190000
      *                                                                 03200000
      ***********************************************************               
      * DCLGEN TABLE(CSS_JOB_PARM)                             *                
      ***********************************************************               
           EXEC SQL                                                     03250000
             INCLUDE TBJBPARM                                           03260000
           END-EXEC.                                                    03270000
      *                                                                 03280000
      ***********************************************************               
      * DCLGEN TABLE(CSS_AR_LOCKOUT)                            *               
      ***********************************************************               
           EXEC SQL                                                     03589900
               INCLUDE TBARLOCK                                         03590000
           END-EXEC.                                                    03590100
      *                                                                 03790000
      ***********************************************************               
      * DCLGEN TABLE(CSS_ARCHIEVE_FCST)                         *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE TBARCFCS                                                  
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_BANKRUPTCY)                            *               
      ***********************************************************               
           EXEC SQL                                                             
               INCLUDE TBBNKRPT                                                 
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_COST_GAS_DEFER)                        *               
      ***********************************************************               
           EXEC SQL                                                             
               INCLUDE TBGASDEF                                                 
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_FIN_WO_ACTION)                         *               
      ***********************************************************               
           EXEC SQL                                                             
               INCLUDE TBFWACTN                                                 
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_AR_TRANS_HIST)                         *               
      ***********************************************************               
           EXEC SQL                                                             
                INCLUDE TBARHIST                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_CUST_PREM_HIST)                        *               
      ***********************************************************               
           EXEC SQL                                                             
                INCLUDE TBCSTPRM                                                
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ***********************************************************               
      * DCLGEN TABLE(CSS_DEP_ON_HAND)                           *               
      ***********************************************************               
           EXEC SQL                                                             
                INCLUDE TBDEPHND                                                
           END-EXEC.                                                            
      *                                                                         
      ***********************************************************       03490000
      *  CURSOR TO FETCH FINAL BILLED/WRITE OFF ACCOUNTS        *       03500000
      ***********************************************************       03510000
      *                                                                         
           EXEC SQL                                                     
             DECLARE ACCOUNT_FB_CURSOR CURSOR WITH HOLD FOR             
             SELECT  AT.ACCOUNT_NO                                      
                    ,AT.PREMISE_NO                                      
             ,COALESCE(LAST_PYMT_DATE,IIF(TRY_CONVERT(DATE, 
              '2999-12-31-00.00.00.000000'
              ) IS NULL OR (PATINDEX('%.%', 
              '2999-12-31-00.00.00.000000') <> 0) OR (LEN(
              '2999-12-31-00.00.00.000000') <> 10), CIS.CHAR2DATE(
              '2999-12-31-00.00.00.000000'), CONVERT(DATE, 
              '2999-12-31-00.00.00.000000') ))       
             ,COALESCE(BNKRPT_CASE_NO,' ')                                
             ,COALESCE(AT.CODE_ACCT_STAT,' ')                             
             ,COALESCE(AT.BANKRUPTCY_IND,' ')                             
             ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           AT.ACCT_FINALED_DT,CIS.CHAR2TIMESTAMP(
              '2999-12-31-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')   
             ,COALESCE(AT.CODES_DATA_PRESENT,' ')                         
             ,COALESCE(AT.TOTAL_AR_BALANCE,0)                             
             ,COALESCE(AT.JUDGEMENT_IND,' ')                              
             ,COALESCE(AT.ACCOUNT_TYPE_CODE,' ')                          
             FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
             WHERE AT.CODE_ACCT_STAT IN ('B','S')                       
             AND   CAST(AT.ACCT_FINALED_DT AS DATE) < (DATEADD( YEAR, -2
              , CAST(SYSDATETIMEOFFSET() AS DATE) )) 
             AND NOT EXISTS (SELECT 1                                   
                             FROM CSS_ARCHIVE_FCST AF
                           WITH(READUNCOMMITTED)                   
                             WHERE AF.ACCOUNT_NO =  AT.ACCOUNT_NO)      
             AND NOT EXISTS (SELECT 1                                   
                             FROM CSS_ARCHIVE_EXEMPT AA
                           WITH(READUNCOMMITTED)                 
                             WHERE AA.ACCOUNT_NO =  AT.ACCOUNT_NO)      
                                                                        
             UNION ALL                                                  
                                                                        
             SELECT  AT.ACCOUNT_NO                                      
                    ,AT.PREMISE_NO                                      
             ,COALESCE(LAST_PYMT_DATE,IIF(TRY_CONVERT(DATE, 
              '2999-12-31-00.00.00.000000'
              ) IS NULL OR (PATINDEX('%.%', 
              '2999-12-31-00.00.00.000000') <> 0) OR (LEN(
              '2999-12-31-00.00.00.000000') <> 10), CIS.CHAR2DATE(
              '2999-12-31-00.00.00.000000'), CONVERT(DATE, 
              '2999-12-31-00.00.00.000000') ))       
             ,COALESCE(BNKRPT_CASE_NO,' ')                                
             ,COALESCE(AT.CODE_ACCT_STAT,' ')                             
             ,COALESCE(AT.BANKRUPTCY_IND,' ')                             
             ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           AT.ACCT_FINALED_DT,CIS.CHAR2TIMESTAMP(
              '2999-12-31-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')   
             ,COALESCE(AT.CODES_DATA_PRESENT,' ')                         
             ,COALESCE(AT.TOTAL_AR_BALANCE,0)                             
             ,COALESCE(AT.JUDGEMENT_IND,' ')                              
             ,COALESCE(AT.ACCOUNT_TYPE_CODE,' ')                          
             FROM  CSS_ACCOUNT AT
                           WITH(READUNCOMMITTED) , CSS_ARCHIVE_FCST AZ
                           WITH(READUNCOMMITTED)                 
             WHERE  AT.ACCOUNT_NO = AZ.ACCOUNT_NO                       
             AND   AT.CODE_ACCT_STAT IN ('B','S')                       
             AND   AZ.FORECAST_TYPE_CD = 'E'                            
             AND   AZ.FORECAST_DT <  CAST(SYSDATETIMEOFFSET() AS DATE)          
             AND CAST(AT.ACCT_FINALED_DT AS DATE) < (DATEADD( YEAR, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))   
             AND NOT EXISTS (SELECT 1                                   
                             FROM CSS_ARCHIVE_EXEMPT AA
                           WITH(READUNCOMMITTED)                 
                             WHERE AA.ACCOUNT_NO =  AT.ACCOUNT_NO)      
             AND  AZ.LAST_UPDATE_TS =                                   
                    ( SELECT MAX(LAST_UPDATE_TS)                        
                      FROM CSS_ARCHIVE_FCST AF WITH(READUNCOMMITTED)            
                      WHERE AF.ACCOUNT_NO =  AT.ACCOUNT_NO              
                      AND CAST(AF.LAST_UPDATE_TS AS DATE) < 
           CAST(SYSDATETIMEOFFSET() AS DATE))       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03591000
MFA-TR*      DECLARE ACCOUNT_FB_CURSOR CURSOR WITH HOLD FOR             600000  
MFA-TR*      SELECT  AT.ACCOUNT_NO                                      610000  
MFA-TR*             ,AT.PREMISE_NO                                      610000  
MFA-TR*      ,IFNULL(LAST_PYMT_DATE,'2999-12-31-00.00.00.000000')               
MFA-TR*      ,IFNULL(BNKRPT_CASE_NO,' ')                                        
MFA-TR*      ,IFNULL(AT.CODE_ACCT_STAT,' ')                                     
MFA-TR*      ,IFNULL(AT.BANKRUPTCY_IND,' ')                                     
MFA-TR*      ,IFNULL(AT.ACCT_FINALED_DT,'2999-12-31-00.00.00.000000')           
MFA-TR*      ,IFNULL(AT.CODES_DATA_PRESENT,' ')                                 
MFA-TR*      ,IFNULL(AT.TOTAL_AR_BALANCE,0)                                     
MFA-TR*      ,IFNULL(AT.JUDGEMENT_IND,' ')                                      
MFA-TR*      ,IFNULL(AT.ACCOUNT_TYPE_CODE,' ')                                  
MFA-TR*      FROM  CSS_ACCOUNT AT                                       900000  
MFA-TR*      WHERE AT.CODE_ACCT_STAT IN ('B','S')                       700000  
MFA-TR*      AND   DATE (AT.ACCT_FINALED_DT) < (CURRENT DATE - 2 YEARS) 700000  
MFA-TR*      AND NOT EXISTS (SELECT 1                                           
MFA-TR*                      FROM CSS_ARCHIVE_FCST AF                           
MFA-TR*                      WHERE AF.ACCOUNT_NO =  AT.ACCOUNT_NO)              
MFA-TR*      AND NOT EXISTS (SELECT 1                                           
MFA-TR*                      FROM CSS_ARCHIVE_EXEMPT AA                         
MFA-TR*                      WHERE AA.ACCOUNT_NO =  AT.ACCOUNT_NO)              
MFA-TR*                                                                         
MFA-TR*      UNION ALL                                                          
MFA-TR*                                                                         
MFA-TR*      SELECT  AT.ACCOUNT_NO                                      610000  
MFA-TR*             ,AT.PREMISE_NO                                      610000  
MFA-TR*      ,IFNULL(LAST_PYMT_DATE,'2999-12-31-00.00.00.000000')               
MFA-TR*      ,IFNULL(BNKRPT_CASE_NO,' ')                                        
MFA-TR*      ,IFNULL(AT.CODE_ACCT_STAT,' ')                                     
MFA-TR*      ,IFNULL(AT.BANKRUPTCY_IND,' ')                                     
MFA-TR*      ,IFNULL(AT.ACCT_FINALED_DT,'2999-12-31-00.00.00.000000')           
MFA-TR*      ,IFNULL(AT.CODES_DATA_PRESENT,' ')                                 
MFA-TR*      ,IFNULL(AT.TOTAL_AR_BALANCE,0)                                     
MFA-TR*      ,IFNULL(AT.JUDGEMENT_IND,' ')                                      
MFA-TR*      ,IFNULL(AT.ACCOUNT_TYPE_CODE,' ')                                  
MFA-TR*      FROM  CSS_ACCOUNT AT , CSS_ARCHIVE_FCST AZ                 900000  
MFA-TR*      WHERE  AT.ACCOUNT_NO = AZ.ACCOUNT_NO                       700000  
MFA-TR*      AND   AT.CODE_ACCT_STAT IN ('B','S')                       700000  
MFA-TR*      AND   AZ.FORECAST_TYPE_CD = 'E'                            700000  
MFA-TR*      AND   AZ.FORECAST_DT <  CURRENT DATE                               
MFA-TR*      AND DATE (AT.ACCT_FINALED_DT) < (CURRENT DATE - 2 YEARS)   700000  
MFA-TR*      AND NOT EXISTS (SELECT 1                                           
MFA-TR*                      FROM CSS_ARCHIVE_EXEMPT AA                         
MFA-TR*                      WHERE AA.ACCOUNT_NO =  AT.ACCOUNT_NO)              
MFA-TR*      AND  AZ.LAST_UPDATE_TS =                                           
MFA-TR*             ( SELECT MAX(LAST_UPDATE_TS)                                
MFA-TR*               FROM CSS_ARCHIVE_FCST AF                                  
MFA-TR*               WHERE AF.ACCOUNT_NO =  AT.ACCOUNT_NO                      
MFA-TR*               AND DATE(AF.LAST_UPDATE_TS) < CURRENT DATE)               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7005                                                       
MFA-TR*    END-EXEC.                                                    03730000
      *                                                                 03740000
           EXEC SQL                                                     
             DECLARE XFER_CURSOR CURSOR WITH HOLD FOR                   
               SELECT ACCT_XFER_TO,                                     
                      ACCT_XFER_FROM                                    
                 FROM CSS_PENDING_XFER WITH(READUNCOMMITTED)                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE XFER_CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT ACCT_XFER_TO,                                             
MFA-TR*               ACCT_XFER_FROM                                            
MFA-TR*          FROM CSS_PENDING_XFER                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 1200                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  ABEND-FUNCTIONS.                                             
           05  WS-ABEND-SPACE              PIC X(02) VALUE SPACE.       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC        PIC 9(02).                   
      *                                                                 03890000
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSXP320 ENDS HERE  '.            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************03940000
      **    0000-MAINLINE                                             **03950000
      ******************************************************************03960000
                                                                        
       0000-MAINLINE.                                                   
      *                                                                 03990000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                 04011000
      *  PROCESS ONLY IF THERE IS DATA                         **       04280031
      *                                                                         
           PERFORM 1100-PROCESS-ACCT-RECS THRU 1100-EXIT                
                     UNTIL NO-MORE-DATA-ACCT                            
      *                                                                 04291131
           PERFORM 9100-TERMINATE THRU 9100-EXIT.                       
           STOP RUN.                                                    
      *                                                                 04310000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04340000
      ***************************************************************** 04380000
      *0100-INITIALIZATION.                                           * 04390000
      *                                                               * 04400000
      *    OPEN FILES AND INITIALIZE STORAGE                          * 00072300
      ***************************************************************** 00072500
       0100-INITIALIZATION.                                             
           OPEN OUTPUT FCSC320-FILE.                                    
           IF C320-SUCCESSFUL                                           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSXP320 PROCESSING ERROR   **'           
               DISPLAY '**   FCSC320-FILE WILL NOT OPEN   **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               DISPLAY 'FILE-STATUS = ' WS-C320-STATUS                  
               DISPLAY '** PARA 0100-INTIALIZATION   **'                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           INITIALIZE  FIOC320-REC.                                     
                                                                        
      *  CHECK AR LOCKOUT                                               04652000
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
                                                                        
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              DISPLAY ' '                                               
              DISPLAY '**  PCSXP320 PROCESSING ERROR  **'               
              DISPLAY '**  AR LOCKOUT IN EFFECT       **'               
              DISPLAY '**  PROCESSING TERMINATED      **'               
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           ELSE                                                         
              PERFORM 7005-OPEN-ACCOUNT-CURSOR THRU 7005-EXIT           
              PERFORM 7010-FETCH-CURSOR-ACCOUNT THRU 7010-EXIT          
                                                                        
           END-IF.                                                      
                                                                        
                                                                        
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
      *    INITIALIZE WS-SYSIPT.                                        02530000
      *    CAN'T USE  6253-GET-FJC01-CHKP-LIMIT B'CSE NEED TO HAVE      02540000
      *    BIGGER WS-VARIABLE THAT LETS ALL RECORDS TO PROCESS          02540000
           PERFORM 7110-SELECT-JOB-PARM THRU 7110-EXIT.                 
           PERFORM 7050-SELECT-TIMESTAMP THRU 7050-EXIT                 
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, 1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-1-YEAR                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 1 YEARS)                       
MFA-TR*          INTO :WS-DATE-PLUS-1-YEAR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 6, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-6-MONTHS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 6 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-6-MONTHS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 7, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-7-MONTHS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 7 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-7-MONTHS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -6, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-6-MONTHS                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 6 MONTHS)                      
MFA-TR*          INTO :WS-DATE-MINUS-6-MONTHS                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-3-MONTHS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 3 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-3-MONTHS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 18, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-18-MONTHS                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 18 MONTHS)                     
MFA-TR*          INTO :WS-DATE-PLUS-18-MONTHS                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 12, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-12-MONTHS                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 12 MONTHS)                     
MFA-TR*          INTO :WS-DATE-PLUS-12-MONTHS                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-3-MONTHS                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 3 MONTHS)                      
MFA-TR*          INTO :WS-DATE-MINUS-3-MONTHS                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-1-MONTH                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 1 MONTHS)                      
MFA-TR*          INTO :WS-DATE-PLUS-1-MONTH                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           PERFORM 7100-SELECT-DELINQUENCY THRU 7100-EXIT.              
      *                                                                         
           PERFORM 1200-LOAD-PENDING-XFER THRU 1200-EXIT.               
                                                                        
      *                                                                 04659100
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04680000
      ************************************************************      05220000
      **  1100-PROCESS-ACCT-RECS.                               **      05230000
      **      PROCESS ACCOUNT BASED ON STATUS AND ASSIGN VALUES **      05240000
      **      BEFORE THEY WILL BE INSERTED IN CSS_ARCHIVE_FCST  **      05240000
      ************************************************************      05270000
      *                                                                 05280000
       1100-PROCESS-ACCT-RECS.                                          
               PERFORM 2000-CHECK-FOR-RULES THRU 2000-EXIT              
                                                                        
               IF WS-ARCHIVE-EXEMPT-CD = ' '                            
                PERFORM 2200-MOVE-ARCHIVE-DETAILS THRU 2200-EXIT        
                PERFORM 8200-INSERT-ARCHIEVE THRU 8200-EXIT             
               END-IF                                                   
      *                                                                         
               INITIALIZE WS-ITERATION-STORAGE                          
               ADD 1 TO WS-COMMIT-COUNT                                 
               IF WS-COMMIT-COUNT > 250                                 
                     EXEC SQL                                           
                         COMMIT                                         
                     END-EXEC                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                     MOVE 0 TO WS-COMMIT-COUNT                          
               END-IF                                                   
      *                                                                         
               IF WS-INS-ACCT-TOTAL < WS-CHKP-UPD-LIMIT                 
                PERFORM 7010-FETCH-CURSOR-ACCOUNT THRU 7010-EXIT        
               ELSE                                                     
                DISPLAY 'WS-CHKP-UPD-LIMIT '  WS-CHKP-UPD-LIMIT         
                MOVE 'NO' TO WS-DATA-ACCT                               
               END-IF.                                                  
                                                                        
      *                                                                         
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       1200-LOAD-PENDING-XFER.                                          
                                                                        
           EXEC SQL                                                     
               OPEN XFER_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1200-LOAD-PENDING-XFER           **'    
                   DISPLAY '**  ERROR OPENING XFER CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           SET T1-INDEX TO +1.                                          
           PERFORM 1210-FETCH-ROWS THRU 1210-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE XFER_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1200-PARA CLOSE CURSOR           **'    
                   DISPLAY '**  ERROR CLOSING XFER CURSOR        **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1210-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH XFER_CURSOR                                         
               INTO :XP-ACCT-XFER-TO,                                   
                    :XP-ACCT-XFER-FROM                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1210-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1210-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING XFER CURSOR       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           MOVE XP-ACCT-XFER-TO TO T1-ACCT-XFER-TO (T1-INDEX).          
           MOVE XP-ACCT-XFER-FROM TO T1-ACCT-XFER-FROM (T1-INDEX).      
           SET T1-INDEX UP BY 1.                                        
                                                                        
           GO TO 1210-FETCH-ROWS.                                       
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2000-CHECK-FOR-RULES.                                            
      ****************************************************************  08090000
      **   2000-CHECK-FOR-RULES                                     **          
      **       CHECK THE ACCOUNT FOR ALL BUSINESS RULES TO          **          
      **       DETERMINE THE ARCHIEVAL DATE                         **          
      ****************************************************************          
      *                                                                         
               MOVE 'N' TO WS-ACC-ARCH-FL.                              
               MOVE ' ' TO WS-ARCHIVE-EXEMPT-CD.                        
      *                                                                         
               PERFORM 2100-ARCHIVE-EDITS THRU 2100-EXIT.               
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  08090000
      **  2100-ARCHIVE-EDITS                                        **          
      *  THESE ARE THE NON-ARCH EDITS.  ALL EDITS ARE PERFORMED       *         
      *  AND THE MAXIMUM FORECAST DATE/REASON IS LOADED INTO THE     *          
      *  ARCHIVE FORECAST TABLE.                                     *          
      ****************************************************************          
       2100-ARCHIVE-EDITS.                                              
                                                                        
      *  DEP ON HAND EDIT                                                       
                                                                        
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7298-SELECT-DEP-ON-HAND THRU 7298-EXIT          
              END-IF.                                                   
                                                                        
      * CONTRACT EDIT                                                           
             IF WS-FCAST-TYPE-CD = ' '                                  
               PERFORM 7225-CONTRACT-EXPTN THRU 7225-EXIT               
             END-IF                                                     
      *                                                                         
             IF WS-FCAST-TYPE-CD = ' '                                  
               PERFORM 7226-CONTRACT-DATE-EXPTN THRU 7226-EXIT          
             END-IF                                                     
      *                                                                         
      *  REFUND EDITS                                                           
              IF WS-FCAST-TYPE-CD = ' '                                 
               IF WS-CODES-DATA-PRESENT-AT(20:1) = 'A'                  
                 PERFORM 7300-REFUND-ESC  THRU 7300-EXIT                
                 PERFORM 7305-CASH-RFND   THRU 7305-EXIT                
               END-IF                                                   
              END-IF.                                                   
                                                                        
                                                                        
      *  FINAL BILLED ACCOUNT MUST HAVE FB DATE                                 
              IF WS-FCAST-TYPE-CD = ' '                                 
               IF AT-CODE-ACCT-STAT = 'B'                               
                 IF  (AT-ACCT-FINALED-DT = SPACES  OR                   
                 AT-ACCT-FINALED-DT = '2999-12-31-00.00.00.000000')     
                   IF AT-DATE-BILL-DAY-00 < WS-DATE-MINUS-3-MONTHS      
                      MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE        
                      IF WS-TEMP-DATE >= WS-MAX-DATE                    
                          MOVE WS-TEMP-DATE TO WS-MAX-DATE              
                          MOVE 'O' TO WS-MAX-REASON-CD                  
                          MOVE 'E' TO WS-FCAST-TYPE-CD                  
                          MOVE  WS-FB-DT-MESSAGE                        
                                     TO WS-MAX-TABLE-NAME               
                      END-IF                                            
                   END-IF                                               
                 END-IF                                                 
               END-IF                                                   
              END-IF.                                                   
      *  ACCOUNT BALANCE EDITS                                                  
              IF WS-FCAST-TYPE-CD = ' '                                 
               PERFORM 7310-ACCOUNT-BALANCE THRU 7310-EXIT              
              END-IF.                                                   
                                                                        
      * PENDING BANK DRAFT                                                      
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7210-SELECT-BNK-DRFT THRU 7210-EXIT             
              END-IF.                                                   
      * MASTER SUB                                                              
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7230-SELECT-MSTSUB THRU 7230-EXIT               
              END-IF.                                                   
                                                                        
      * RECONNECT                                                               
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7240-SELECT-RECONNECT THRU 7240-EXIT            
              END-IF.                                                   
                                                                        
      * UTIL_BILL_REL                                                           
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7250-SELECT-UTIL-BILL THRU 7250-EXIT            
              END-IF.                                                   
                                                                        
      *  PENDING_XFER                                                           
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7270-SELECT-PENDXFER THRU 7270-EXIT             
              END-IF.                                                   
      * WORK QUEUE                                                              
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7275-SELECT-WQS THRU 7275-EXIT                  
              END-IF.                                                   
      *   DO THE EXEMPTION CHECKS HERE                                          
              IF WS-ACC-ARCH-FL = 'N'                                   
                PERFORM 2150-CHK-FOR-EXEMPTS THRU 2150-EXIT             
              END-IF.                                                   
      *  AR TRANHIST EDIT                                                       
      *DO THESE EDITS IF ITS STILL NOT EXEMPT                                   
             IF WS-ACC-ARCH-FL = 'N'                                    
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7290-SELECT-AR-TRANSHIST THRU 7290-EXIT         
              END-IF                                                    
      * REFUND EDITS                                                            
              IF WS-FCAST-TYPE-CD = ' '                                 
                PERFORM 7285-REFUND-REVIEWS THRU 7285-EXIT              
              END-IF                                                    
                                                                        
      *  CHARGEOFF EDIT                                                         
      *  WRITE OFF & FINAL BILL                                                 
              IF WS-FCAST-TYPE-CD = ' '                                 
               IF AT-CODE-ACCT-STAT = 'S'                               
                   PERFORM 7205-SELECT-CHRG-OFF THRU 7205-EXIT          
               END-IF                                                   
      *                                                                         
                                                                        
                IF AT-CODE-ACCT-STAT = 'B'                              
                   PERFORM 7200-SELECT-CHRG-OFF THRU 7200-EXIT          
                END-IF                                                  
              END-IF                                                    
             END-IF.                                                    
      ********************* NO EXCEPTION EDITS ***********************          
      * IF STILL NOT EXEMPT                                                     
            IF WS-ARCHIVE-EXEMPT-CD = ' '                               
      * FINAL BILL                                                              
            IF WS-FCAST-TYPE-CD = ' '                                   
             IF AT-CODE-ACCT-STAT = 'B'                                 
               PERFORM  7613-FINAL-BILL-REVIEWS  THRU 7613-EXIT         
             END-IF                                                     
      * WRITE OFF                                                               
             IF AT-CODE-ACCT-STAT = 'S'                                 
              PERFORM 7295-WRITEOFF-REVIEWS THRU 7295-EXIT              
             END-IF                                                     
      * CONTRACT EDITS                                                          
              PERFORM 7405-CONTRACT-RULES THRU 7405-EXIT                
              PERFORM 7415-MSE-CONTRACT-RULES THRU 7415-EXIT            
                                                                        
            END-IF                                                      
      *NO EXEMPT END-IF                                                         
            END-IF.                                                     
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  08090000
      **   2150-CHK-FOR-EXEMPTS.                                    **          
      **       CHECK IF ACCOUNT SHOULD BE EXEMPTED                  **          
      **       FROM  FORECAST                                       **          
      ****************************************************************          
                                                                        
       2150-CHK-FOR-EXEMPTS.                                            
      *  ACCOUNT CANNOT HAVE A JUDGEMENT AGAINST IT                             
      *  EXEMPTION LOGIC                                                        
                 IF  WS-FCAST-TYPE-CD  NOT = ' '                        
                 AND (WS-MAX-REASON-CD NOT = 'B'                        
                 AND WS-MAX-REASON-CD  NOT = 'F')                       
                    MOVE 'Y' TO WS-ACC-ARCH-FL                          
                 END-IF                                                 
                                                                        
                 IF WS-ACC-ARCH-FL = 'N'                                
                   IF AT-JUDGEMENT-IND = 'J'                            
                       MOVE 'Y' TO WS-ACC-ARCH-FL                       
                       MOVE 'J' TO WS-ARCHIVE-EXEMPT-CD                 
                       PERFORM 8300-INSERT-EXEMPT THRU 8300-EXIT        
                   END-IF                                               
                 END-IF.                                                
                                                                        
      *  BANKRUPTCY EDIT                                                        
                                                                        
                IF WS-ACC-ARCH-FL = 'N'                                 
                 IF AT-BANKRUPTCY-IND = 'B'                             
                     AND AT-BNKRPT-CASE-NO > ' '                        
                   PERFORM 7280-SELECT-BANKRUPTCY THRU 7280-EXIT        
                   IF WS-ACC-ARCH-FL = 'Y'                              
                     MOVE 'B' TO WS-ARCHIVE-EXEMPT-CD                   
                     PERFORM 8300-INSERT-EXEMPT THRU 8300-EXIT          
                   END-IF                                               
                 ELSE                                                   
                   IF AT-BANKRUPTCY-IND > ' '                           
                     AND AT-BNKRPT-CASE-NO = ' '                        
                      MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE        
                      IF WS-TEMP-DATE >= WS-MAX-DATE                    
                          MOVE WS-TEMP-DATE TO WS-MAX-DATE              
                          MOVE 'Y' TO WS-MAX-REASON-CD                  
                          MOVE 'E' TO WS-FCAST-TYPE-CD                  
                          MOVE WS-BK-CS-MESSAGE TO WS-MAX-TABLE-NAME    
                      END-IF                                            
                   END-IF                                               
                                                                        
                 END-IF                                                 
                END-IF.                                                 
      *                                                                         
      *  ACCOUNT CANNOT BE WITH AN ATTORNEY                                     
                                                                        
                 IF WS-ACC-ARCH-FL = 'N'                                
                   PERFORM 7510-SELECT-ATTORNEY THRU 7510-EXIT          
                   IF WS-ACC-ARCH-FL = 'Y'                              
                       MOVE 'A' TO WS-ARCHIVE-EXEMPT-CD                 
                       PERFORM 8300-INSERT-EXEMPT THRU 8300-EXIT        
                   END-IF                                               
                 END-IF.                                                
      *                                                                         
      *  CURRENT ACCOUNT AT PREMISE EDIT                                        
                IF WS-ACC-ARCH-FL = 'N'                                 
                 IF AT-ACCOUNT-TYPE-CODE NOT = 'N'                      
                   IF CSR-DATABASE                                      
                      PERFORM 7612-PREM-LAST-ACC THRU 7612-EXIT         
                      IF WS-ACC-ARCH-FL = 'Y'                           
                        MOVE 'P' TO WS-ARCHIVE-EXEMPT-CD                
                        PERFORM 8300-INSERT-EXEMPT THRU 8300-EXIT       
                      END-IF                                            
                   END-IF                                               
                 END-IF                                                 
                END-IF.                                                 
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  08090000
      **   2200-MOVE-ARCHIVE-DETAILS.                               **          
      **       MOVES THE DETAILS INTO THE HOST-VARIABLES OF         **          
      **       CSS_ARCHIVE_FORECAST                                 **          
      ****************************************************************          
                                                                        
       2200-MOVE-ARCHIVE-DETAILS.                                       
                                                                        
           MOVE AT-ACCOUNT-NO TO AZ-ACCOUNT-NO                          
      *                                                                         
           IF WS-MAX-DATE  = SPACES                                     
            MOVE WS-DATE-PLUS-3-MONTHS TO AZ-FORECAST-DT                
            MOVE 'O' TO AZ-FORECAST-REASON-CD                           
            MOVE 'E' TO AZ-FORECAST-TYPE-CD                             
            STRING 'Invalid Forecst Date' ';'  WS-DISPLAY-ACCOUNT       
                DELIMITED BY SIZE                                       
                    INTO AZ-REMARKS                                     
           ELSE                                                         
            IF WS-MAX-DATE  <= WS-DATE-PLUS-1-MONTH                     
              MOVE WS-DATE-PLUS-1-MONTH TO AZ-FORECAST-DT               
            ELSE                                                        
              MOVE WS-MAX-DATE TO AZ-FORECAST-DT                        
            END-IF                                                      
           END-IF                                                       
      *                                                                         
                                                                        
           IF WS-MAX-REASON-CD NOT = SPACES                             
            MOVE WS-MAX-REASON-CD TO AZ-FORECAST-REASON-CD              
            MOVE SPACES TO WS-MAX-REASON-CD                             
           ELSE                                                         
            MOVE WS-DATE-PLUS-3-MONTHS TO AZ-FORECAST-DT                
            MOVE 'O' TO AZ-FORECAST-REASON-CD                           
            MOVE 'E' TO AZ-FORECAST-TYPE-CD                             
            STRING 'Invalid reason code ' ';'  WS-DISPLAY-ACCOUNT       
                DELIMITED BY SIZE                                       
                    INTO AZ-REMARKS                                     
           END-IF                                                       
      *                                                                         
           IF WS-MAX-TABLE-NAME NOT = SPACES                            
            MOVE WS-MAX-TABLE-NAME TO AZ-REMARKS                        
           ELSE                                                         
            MOVE WS-DATE-PLUS-3-MONTHS TO AZ-FORECAST-DT                
            MOVE 'O' TO AZ-FORECAST-REASON-CD                           
            MOVE 'E' TO AZ-FORECAST-TYPE-CD                             
            STRING 'Invalid remarks ' ';'  WS-DISPLAY-ACCOUNT           
                DELIMITED BY SIZE                                       
                    INTO AZ-REMARKS                                     
           END-IF                                                       
      *                                                                         
           IF WS-FCAST-TYPE-CD NOT = 'R'                                
           OR WS-FCAST-TYPE-CD NOT = 'E'                                
            MOVE WS-FCAST-TYPE-CD TO AZ-FORECAST-TYPE-CD                
           ELSE                                                         
            MOVE WS-DATE-PLUS-3-MONTHS TO AZ-FORECAST-DT                
            MOVE 'O' TO AZ-FORECAST-REASON-CD                           
            MOVE 'E' TO AZ-FORECAST-TYPE-CD                             
            STRING 'Invalid forecast type' ';'  WS-DISPLAY-ACCOUNT      
                DELIMITED BY SIZE                                       
                    INTO AZ-REMARKS                                     
           END-IF                                                       
      *                                                                         
           MOVE AT-ACCT-FINALED-DT   TO AZ-ACCT-FINALED-DT              
           MOVE WS-CURRENT-TIMESTAMP TO AZ-LAST-UPDATE-TS               
           MOVE 'XP320' TO AZ-LAST-UPDATE-USERID.                       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE WS-CPD99-RETURN-CODE TO WS-DISPLAY-SQLCODE.             
           MOVE WS-CPD99-PREMISE-NO TO WS-DISPLAY-PREMISE.              
           DISPLAY '****************************************'           
           DISPLAY '**  6990-FETCH-CUR-ACCOUNT           **'            
           DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE                  
           DISPLAY '**  PREMISE = ' WS-DISPLAY-PREMISE                  
           DISPLAY '** ' ABEND-FUNCTION ' ' TABLE-1 ' ' TABLE-2         
           DISPLAY '****************************************'           
           MOVE 'Y' TO WS-CPD99-ERROR.                                  
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ************************************************************      05833600
      **  7005-OPEN-ACCOUNT-CURSOR.                             **      05833200
      **      OPENS CURSOR ACCT TO SELECT RECORDS FROM          **      05833300
      **      TABLE CSS_ACCOUNT WITH FB STATUS                  **      05833400
      ************************************************************      05833600
        7005-OPEN-ACCOUNT-CURSOR.                                       
           EXEC SQL                                                     
               OPEN ACCOUNT_FB_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '** PCSXP320 PROCESSING ERROR       **'          
               DISPLAY '** OPEN ERROR ON CURSOR ACCOUNT    **'          
               DISPLAY '** PARA 7005-OPEN-ACCOUNT-CURSOR   **'          
               DISPLAY '** SQLCODE IS  ** ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  ACCOUNT ** ' WS-DISPLAY-ACCOUNT             
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05950000
      ************************************************************      05960000
      **  7006-CLOSE-ACCOUNT-CURSOR.                            **      05970000
      **      CLOSE ACCOUNT CURSOR.                             **      05980000
      ************************************************************      05990000
        7006-CLOSE-ACCOUNT-CURSOR.                                      
           EXEC SQL                                                     
               CLOSE ACCOUNT_FB_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '** PCSXP320 PROCESSING ERROR        **'         
               DISPLAY '** CLOSE ERROR ON CURSOR ACCOUNT    **'         
               DISPLAY '** PARA 7006-CLOSE-ACCOUNT-CURSOR   **'         
               DISPLAY '** SQLCODE IS  ** ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  ACCOUNT ** '    WS-DISPLAY-ACCOUNT          
               DISPLAY '** PROCESSING TERMINATED            **'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           CLOSE FCSC320-FILE.                                          
       7006-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06170000
      ************************************************************      06180000
      **  7010-FETCH-CURSOR-ACCOUNT.                            **      06190000
      **      FETCHES THE CURSOR VALUES INTO WS VARIABLES       **      06200000
      **      AND TEST SQLCODE FOR SUCCESS AND END OF TABLE     **      06210000
      ************************************************************      06220000
       7010-FETCH-CURSOR-ACCOUNT.                                       
            EXEC SQL                                                    
                FETCH ACCOUNT_FB_CURSOR                                 
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-PREMISE-NO                                     
                    ,:AT-LAST-PYMT-DATE                                 
                    ,:AT-BNKRPT-CASE-NO                                 
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-ACCT-FINALED-DT                                
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-JUDGEMENT-IND                                  
                    ,:AT-ACCOUNT-TYPE-CODE                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   ADD 1 TO WS-PROCESSED-COUNT                          
                   MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO                  
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   MOVE AT-CODES-DATA-PRESENT TO                        
                              WS-CODES-DATA-PRESENT-AT                  
                   MOVE WS-CODES-DATA-PRESENT-AT TO                     
                              WS-CODES-DATA-PRESENT                     
      * CALCULATE FINAL BILL DATE + 3 AND 8 YEARS FOR FUTURE USE                
      *                                                                         
                    EXEC SQL                                            
                    SELECT
              DATEADD( YEAR, 8, IIF(TRY_CONVERT(DATE, 
                                                    :AT-ACCT-FINALED-DT
              ) IS NULL OR (PATINDEX('%.%', :AT-ACCT-FINALED-DT
              ) <> 0) OR (LEN(:AT-ACCT-FINALED-DT
              ) <> 10), CIS.CHAR2DATE(:AT-ACCT-FINALED-DT
              ), CONVERT(DATE, :AT-ACCT-FINALED-DT) ) )
            INTO
              :WS-FBDT-PLUS-8-YEARS                        
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                                    
MFA-TR*             VALUES  (DATE(:AT-ACCT-FINALED-DT) + 8 YEARS)               
MFA-TR*               INTO :WS-FBDT-PLUS-8-YEARS                                
MFA-TR*             END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
                    EXEC SQL                                            
                    SELECT
              DATEADD( MONTH, 42, IIF(TRY_CONVERT(DATE, 
                                                    :AT-ACCT-FINALED-DT
              ) IS NULL OR (PATINDEX('%.%', :AT-ACCT-FINALED-DT
              ) <> 0) OR (LEN(:AT-ACCT-FINALED-DT
              ) <> 10), CIS.CHAR2DATE(:AT-ACCT-FINALED-DT
              ), CONVERT(DATE, :AT-ACCT-FINALED-DT) ) )
            INTO
              :WS-FBDT-PLUS-42-MONTHS                      
                    END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                                    
MFA-TR*             VALUES  (DATE(:AT-ACCT-FINALED-DT) + 42 MONTHS)             
MFA-TR*               INTO :WS-FBDT-PLUS-42-MONTHS                              
MFA-TR*             END-EXEC                                                    
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                            
                                                                        
               WHEN NOT-FOUND                                           
                   MOVE 'NO' TO WS-DATA-ACCT                            
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '** PCSXP320 PROCESSING ERROR        **'     
                   DISPLAY '** ERROR ON FETCH CURSOR            **'     
                   DISPLAY '** PARA 7010-FETCH-CURSOR-ACCOUNT   **'     
                   DISPLAY '** SQLCODE IS  ** ' WS-DISPLAY-SQLCODE      
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '** PROCESSING TERMINATED            **'     
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-EVALUATE.                                            
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06600000
      ***************************************************************** 07107300
      * SELECT CURRENT DATE AND CURRENT TIMESTAMP                     * 07107400
      ***************************************************************** 07107500
       7050-SELECT-TIMESTAMP.                                           
      *                                                                 07107700
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07108000
MFA-TR*       SET :WS-CURRENT-TIMESTAMP  =                              07110000
MFA-TR*            CURRENT TIMESTAMP                                            
MFA-TR*    END-EXEC.                                                    07114000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     07108000
MFA-TR*       SET :WS-CURRENT-DATE      =                               07110000
MFA-TR*            CURRENT DATE                                                 
MFA-TR*    END-EXEC.                                                    07114000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07115000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
            MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE            
            DISPLAY '** PCSXP320 PROCESSING ERROR        **'            
            DISPLAY '** PARA 7050-SELECT-TIMESTAMP       **'            
            DISPLAY '** SQLCODE IS  ** ' WS-DISPLAY-SQLCODE             
            DISPLAY '**  ACCOUNT ** ' WS-DISPLAY-ACCOUNT                
            DISPLAY '** PROCESSING TERMINATED            **'            
            PERFORM 9900-ABEND THRU 9900-EXIT                           
           END-IF.                                                      
      *                                                                 07129000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7100-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD  = 'DATABASE'                           
                 AND  COMPANY_NO = '01'                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = 'DATABASE'                                   
MFA-TR*          AND  COMPANY_NO = '01'                                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-DATABASE                  
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7100-SELECT    CSS_DELINQUENCY  **'     
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       7110-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = 'PCSXP320'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 1                                   
                 AND STATUS       = 'A'                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'PCSXP320'                                  
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 1                                           
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   DISPLAY 'G6-PARM-DATA(10:6)   '   G6-PARM-DATA(10:6) 
                   IF G6-PARM-DATA(10:6) NUMERIC                        
                       MOVE G6-PARM-DATA(10:6) TO WS-CHKP-UPD-LIMIT     
                   ELSE                                                 
                       MOVE 001000 TO WS-CHKP-UPD-LIMIT                 
                   END-IF                                               
                   IF G6-PARM-DATA(10:6) = '999999'                     
                       MOVE 999999999999 TO WS-CHKP-UPD-LIMIT           
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'    
                   DISPLAY '**  7110-SELECT-JOB-PARM            **'     
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       7200-SELECT-CHRG-OFF.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-CHR-OFF-FL                                     
                FROM  CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-CHR-OFF-FL                                             
MFA-TR*         FROM  CSS_CHRG_OFF                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-1-MONTH TO WS-TEMP-DATE            
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'I' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-FCAST-TYPE-CD                     
                       MOVE  WS-CHR-OFF-MESSAGE TO WS-MAX-TABLE-NAME    
      *                MOVE 'Y' TO WS-GENERATE-WQ-FL                            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CHRG_OFF      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED PARA 7200   **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7205-SELECT-CHRG-OFF.                                            
           EXEC SQL                                                     
              SELECT  ACCOUNT_NO, COALESCE(MAX (DATE_OF_CHG_OFF)          
                                 ,IIF(TRY_CONVERT(DATE, 
              '2999-12-31-00.00.00.000000'
              ) IS NULL OR (PATINDEX('%.%', 
              '2999-12-31-00.00.00.000000') <> 0) OR (LEN(
              '2999-12-31-00.00.00.000000') <> 10), CIS.CHAR2DATE(
              '2999-12-31-00.00.00.000000'), CONVERT(DATE, 
              '2999-12-31-00.00.00.000000') ))         
                     , COALESCE(SUM(AMT_TRANS),0)                         
                INTO :CO-ACCOUNT-NO,:WS-WRT-OFF-DATE, :WS-WRT-OFF-AMT   
                FROM  CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               GROUP BY ACCOUNT_NO                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO, IFNULL(MAX (DATE_OF_CHG_OFF)                  
MFA-TR*                          ,'2999-12-31-00.00.00.000000')                 
MFA-TR*              , IFNULL(SUM(AMT_TRANS),0)                                 
MFA-TR*         INTO :CO-ACCOUNT-NO,:WS-WRT-OFF-DATE, :WS-WRT-OFF-AMT           
MFA-TR*         FROM  CSS_CHRG_OFF                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        GROUP BY ACCOUNT_NO                                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7205                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                IF  WS-WRT-OFF-DATE = '2999-12-31-00.00.00.000000'      
                  DISPLAY 'WRT OFF DATE NULL FOR '  AT-ACCOUNT-NO       
                  MOVE AT-ACCT-FINALED-DT TO WS-WRT-OFF-DATE            
                END-IF                                                  
                                                                        
                MOVE WS-WRT-OFF-AMT TO WS-WRT-OFF-AMT-R                 
                MOVE WS-WRT-OFF-DATE TO WS-WRT-OFF-DATE-R               
                                                                        
                EXEC SQL                                                
                 SELECT
              DATEADD( MONTH, 96, IIF(TRY_CONVERT(DATE, :WS-WRT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WRT-OFF-DATE
              ) <> 0) OR (LEN(:WS-WRT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-WRT-OFF-DATE
              ), CONVERT(DATE, :WS-WRT-OFF-DATE) ) )
            INTO
              :WS-WODT-PLUS-8-YEARS                           
                END-EXEC                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*         EXEC SQL                                                        
MFA-TR*          VALUES  (DATE(:WS-WRT-OFF-DATE) + 96 MONTHS)                   
MFA-TR*            INTO :WS-WODT-PLUS-8-YEARS                                   
MFA-TR*         END-EXEC                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
                EXEC SQL                                                
                 SELECT
              DATEADD( MONTH, 42, IIF(TRY_CONVERT(DATE, :WS-WRT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WRT-OFF-DATE
              ) <> 0) OR (LEN(:WS-WRT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-WRT-OFF-DATE
              ), CONVERT(DATE, :WS-WRT-OFF-DATE) ) )
            INTO
              :WS-WODT-PLUS-42-MONTHS                         
                END-EXEC                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*         EXEC SQL                                                        
MFA-TR*          VALUES  (DATE(:WS-WRT-OFF-DATE) + 42 MONTHS)                   
MFA-TR*            INTO :WS-WODT-PLUS-42-MONTHS                                 
MFA-TR*         END-EXEC                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
                IF WS-WRT-OFF-AMT > 0                                   
                                                                        
                   MOVE WS-WODT-PLUS-8-YEARS TO WS-TEMP-DATE            
                                                                        
                   IF WS-TEMP-DATE <= WS-DATE-PLUS-1-YEAR               
                     MOVE WS-DATE-PLUS-1-YEAR TO WS-TEMP-DATE           
                   END-IF                                               
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                     MOVE WS-TEMP-DATE TO WS-MAX-DATE                   
                     MOVE 'B' TO WS-MAX-REASON-CD                       
                     MOVE 'E' TO WS-FCAST-TYPE-CD                       
                     MOVE  WS-WRT-OFF-MESSAGE TO WS-MAX-TABLE-NAME      
                   END-IF                                               
                END-IF                                                  
                                                                        
                IF  WS-WRT-OFF-AMT < 0                                  
                     MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE         
                     IF WS-TEMP-DATE >= WS-MAX-DATE                     
                        MOVE WS-TEMP-DATE TO WS-MAX-DATE                
                        MOVE 'B' TO WS-MAX-REASON-CD                    
                        MOVE 'E' TO WS-FCAST-TYPE-CD                    
                        MOVE  WS-WRT-OFF-MESSAGE TO WS-MAX-TABLE-NAME   
                     END-IF                                             
                END-IF                                                  
                                                                        
               WHEN NOT-FOUND                                           
                  CONTINUE                                              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CHRG_OFF      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED PARA 7205   **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7205-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-SELECT-BNK-DRFT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :PB-ACCOUNT-NO                                     
                FROM  CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                  
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :PB-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_PNDNG_BNK_DRFT                                        
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-FCAST-TYPE-CD                     
                       MOVE 'Data exists in CSS_PNDNG_BNK_DRAFT table'  
                                          TO WS-MAX-TABLE-NAME          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7210-SELECT-BNK-DRFT            **'     
                   DISPLAY '**  ERROR SELECTING CSS_PNDNG_BNK_DRFT**'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7225-CONTRACT-EXPTN.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-CON-EXP-FL                                     
                FROM  CSS_CONTRACT CT WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               AND    CT.CNT_STATUS_CD IN                               
                   ('A','B')                                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-CON-EXP-FL                                             
MFA-TR*         FROM  CSS_CONTRACT CT                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        AND    CT.CNT_STATUS_CD IN                                       
MFA-TR*            ('A','B')                                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7225                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE             
                 IF WS-TEMP-DATE >= WS-MAX-DATE                         
                    MOVE WS-TEMP-DATE TO WS-MAX-DATE                    
                    MOVE 'E' TO WS-MAX-REASON-CD                        
                    MOVE 'E' TO WS-FCAST-TYPE-CD                        
                    MOVE WS-CNT-ST-MESSAGE TO WS-MAX-TABLE-NAME         
                 END-IF                                                 
                                                                        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING IN 7225-PARA**'         
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       7226-CONTRACT-DATE-EXPTN.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) COALESCE(CT.STATUS_CHANGE_DT,
              IIF(TRY_CONVERT(DATE, '2999-12-31'
              ) IS NULL OR (PATINDEX('%.%', '2999-12-31'
              ) <> 0) OR (LEN('2999-12-31') <> 10), CIS.CHAR2DATE(
              '2999-12-31'), CONVERT(DATE, '2999-12-31') ))          
               INTO :WS-DATE-MAX-CONTRCT                                
               FROM   CSS_CONTRACT CT WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               AND STATUS_CHANGE_DT IS NULL                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(CT.STATUS_CHANGE_DT,'2999-12-31')                  
MFA-TR*        INTO :WS-DATE-MAX-CONTRCT                                        
MFA-TR*        FROM   CSS_CONTRACT CT                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        AND STATUS_CHANGE_DT IS NULL                                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7226                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 IF WS-DATE-MAX-CONTRCT = '2999-12-31'                  
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-DATE-MAX-CONTRCT    
                   MOVE WS-DATE-MAX-CONTRCT TO WS-TEMP-DATE             
                   MOVE SPACES TO WS-DATE-MAX-CONTRCT                   
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                         MOVE WS-TEMP-DATE TO WS-MAX-DATE               
                         MOVE 'E' TO WS-MAX-REASON-CD                   
                         MOVE 'E' TO WS-FCAST-TYPE-CD                   
                         MOVE WS-DATE-MAX-CONTRCT TO WS-CTR-DATE        
                         MOVE 'Contract with Null Status Change Date'           
      -                                           TO WS-MAX-TABLE-NAME          
                                                                        
                   END-IF                                               
                 END-IF                                                 
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING IN 7226-PARA**'         
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7226-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7230-SELECT-MSTSUB.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y' INTO :WS-MSTSUB-FL                            
                FROM  CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                     
               WHERE  MST_ACCT_NO = :AT-ACCOUNT-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y' INTO :WS-MSTSUB-FL                                    
MFA-TR*         FROM  CSS_MSTSUB_ACCT                                           
MFA-TR*        WHERE  MST_ACCT_NO = :AT-ACCOUNT-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7230                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-MSTSUB-FL                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-MSTSUB-FL                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING 7230-SELECT      **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
      *                                                                         
             IF WS-MSTSUB-FL = 'N'                                      
              EXEC SQL                                                  
                 SELECT TOP(1) 'Y' INTO :WS-MSTSUB-FL                         
                   FROM  CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                  
                  WHERE  SUB_ACCT_NO = :AT-ACCOUNT-NO                   
                                                 
                                                                 
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT  'Y' INTO :WS-MSTSUB-FL                                 
MFA-TR*            FROM  CSS_MSTSUB_ACCT                                        
MFA-TR*           WHERE  SUB_ACCT_NO = :AT-ACCOUNT-NO                           
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           WITH UR                                                       
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                   MOVE 'Y' TO WS-MSTSUB-FL                             
                  WHEN NOT-FOUND                                        
                   MOVE 'N' TO WS-MSTSUB-FL                             
                  WHEN OTHER                                            
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_MSTSUB_ACCT  **'    
                   DISPLAY '**  ERROR SELECTING 7230-SELECT      **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
              END-EVALUATE                                              
             END-IF.                                                    
      *                                                                         
             IF WS-MSTSUB-FL = 'Y'                                      
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE >= WS-MAX-DATE                           
                  MOVE WS-TEMP-DATE TO WS-MAX-DATE                      
                  MOVE 'O' TO WS-MAX-REASON-CD                          
                  MOVE 'E' TO WS-FCAST-TYPE-CD                          
                  MOVE 'Data in Master_Sub' TO WS-MAX-TABLE-NAME        
               END-IF                                                   
             END-IF.                                                    
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-SELECT-RECONNECT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-RECONN-FL                                      
                FROM  CSS_RECONNECT WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-RECONN-FL                                              
MFA-TR*         FROM  CSS_RECONNECT                                             
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7240                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-FCAST-TYPE-CD                     
                       MOVE 'Data exists in CSS_RECONNECT table '       
                              TO WS-MAX-TABLE-NAME                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING 7240-SELECT**'          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '**  PARA 7240                        **'    
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-SELECT-UTIL-BILL.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-UTIL-BIL-FL                                    
                FROM  CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO_DEP = :AT-ACCOUNT-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-UTIL-BIL-FL                                            
MFA-TR*         FROM  CSS_UTL_BILL_REL                                          
MFA-TR*        WHERE  ACCOUNT_NO_DEP = :AT-ACCOUNT-NO                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-UTIL-BIL-FL                           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_UTL_BILL_REL **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '**  PARA 7250                         **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE                                                 
                                                                        
           IF WS-UTIL-BIL-FL = 'N'                                      
               EXEC SQL                                                 
                  SELECT TOP(1) 'Y'                                            
                    INTO :WS-UTIL-BIL-FL                                
                    FROM  CSS_UTL_BILL_REL WITH(READUNCOMMITTED)                
                   WHERE  ACCOUNT_NO_MST = :AT-ACCOUNT-NO               
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT 'Y'                                                    
MFA-TR*             INTO :WS-UTIL-BIL-FL                                        
MFA-TR*             FROM  CSS_UTL_BILL_REL                                      
MFA-TR*            WHERE  ACCOUNT_NO_MST = :AT-ACCOUNT-NO                       
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 72502                                                
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                  WHEN SUCCESSFUL-CALL                                  
                      CONTINUE                                          
                  WHEN NOT-FOUND                                        
                      MOVE 'N' TO WS-UTIL-BIL-FL                        
                  WHEN OTHER                                            
                     MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE   
                     DISPLAY '****************************************' 
                     DISPLAY '**  ERROR SELECTING CSS_UTL_BILL_REL(M)*' 
                     DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE        
                     DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT        
                     DISPLAY '**  PROCESSING TERMINATED             **' 
                     DISPLAY '****************************************' 
                     PERFORM 9900-ABEND THRU 9900-EXIT                  
               END-EVALUATE                                             
                                                                        
               IF WS-UTIL-BIL-FL = 'Y'                                  
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-FCAST-TYPE-CD                     
                       MOVE 'Data exists in CSS_UTL_BILL_REL table '    
                                               TO WS-MAX-TABLE-NAME     
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7265-SELECT-REFUND.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :RN-ACCOUNT-NO                                     
                FROM  CSS_REFUND WITH(READUNCOMMITTED)                          
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :RN-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_REFUND                                                
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7265                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  PERFORM 7300-REFUND-ESC  THRU 7300-EXIT               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING IN 7265-PARA**'         
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7265-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7270-SELECT-PENDXFER.                                            
                                                                        
           SET T1-INDEX TO +1                                           
           SEARCH T1-CSS-PENDING-XFER                                   
               AT END                                                   
                   MOVE 'N' TO WS-PEND-XFER-FL                          
               WHEN T1-ACCT-XFER-TO (T1-INDEX) = AT-ACCOUNT-NO          
                   MOVE 'Y' TO WS-PEND-XFER-FL                          
           END-SEARCH.                                                  
                                                                        
           IF WS-PEND-XFER-FL = 'N'                                     
               SET T1-INDEX TO +1                                       
               SEARCH T1-CSS-PENDING-XFER                               
                   AT END                                               
                       MOVE 'N' TO WS-PEND-XFER-FL                      
                   WHEN T1-ACCT-XFER-FROM (T1-INDEX) = AT-ACCOUNT-NO    
                       MOVE 'Y' TO WS-PEND-XFER-FL                      
               END-SEARCH                                               
           END-IF.                                                      
                                                                        
           IF WS-PEND-XFER-FL = 'Y'                                     
               MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE               
               IF WS-TEMP-DATE >= WS-MAX-DATE                           
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'O' TO WS-MAX-REASON-CD                         
                   MOVE 'E' TO WS-FCAST-TYPE-CD                         
                   MOVE 'Data exists in CSS_PENDING_XFER table ' TO     
                         WS-MAX-TABLE-NAME                              
           END-IF
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7275-SELECT-WQS.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :WQ-ACCOUNT-NO                                     
                FROM  CSS_WQ_ITEMS WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                 AND STATUS IN ('A', 'I')                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :WQ-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_WQ_ITEMS                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          AND STATUS IN ('A', 'I')                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7275                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-1-MONTH  TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'U' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-FCAST-TYPE-CD                     
                       MOVE 'ACTIVE/IN PROCESS WQS EXIST' TO            
                             WS-MAX-TABLE-NAME                          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_WQ_ITEMS      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7280-SELECT-BANKRUPTCY.                                          
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COALESCE( DATE_BNKRPT_FILED,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))           
                INTO :BQ-DATE-BNKRPT-FILED                              
                FROM  CSS_BANKRUPTCY WITH(READUNCOMMITTED)                      
               WHERE  BNKRPT_CASE_NO = :AT-BNKRPT-CASE-NO               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  IFNULL( DATE_BNKRPT_FILED,'1900-01-01')                   
MFA-TR*         INTO :BQ-DATE-BNKRPT-FILED                                      
MFA-TR*         FROM  CSS_BANKRUPTCY                                            
MFA-TR*        WHERE  BNKRPT_CASE_NO = :AT-BNKRPT-CASE-NO                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7280                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF  BQ-DATE-BNKRPT-FILED = '1900-01-01'              
                       MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE       
                       IF  WS-TEMP-DATE >=  WS-MAX-DATE                 
                        MOVE WS-TEMP-DATE TO WS-MAX-DATE                
                        MOVE 'Y' TO WS-MAX-REASON-CD                    
                        MOVE 'E' TO WS-FCAST-TYPE-CD                    
                        MOVE  WS-BK-DT-MESSAGE TO WS-MAX-TABLE-NAME     
                        GO TO 7280-EXIT                                 
                       END-IF                                           
                   END-IF                                               
                   MOVE 'Y' TO  WS-ACC-ARCH-FL                          
               WHEN NOT-FOUND                                           
                       MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE       
                       IF  WS-TEMP-DATE >=  WS-MAX-DATE                 
                        MOVE WS-TEMP-DATE TO WS-MAX-DATE                
                        MOVE 'Y' TO WS-MAX-REASON-CD                    
                        MOVE 'E' TO WS-FCAST-TYPE-CD                    
                        MOVE  WS-BK-MESSAGE TO WS-MAX-TABLE-NAME        
                        GO TO 7280-EXIT                                 
                       END-IF                                           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING 7280- PARA       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7285-REFUND-REVIEWS.                                             
                                                                        
           EXEC SQL                                                     
                 SELECT TOP(1) RN.ACCOUNT_NO,
              RN.REFUND_STATUS_DT                             
                        INTO                                            
                        :RN-ACCOUNT-NO                                  
                        ,:RN-REFUND-STATUS-DT                           
                        FROM CSS_REFUND RN WITH(READUNCOMMITTED)                
                        WHERE RN.ACCOUNT_NO = :AT-ACCOUNT-NO            
                        AND RN.CHECK_STATUS_CD IN                       
                        ('I','M','U')                                   
                        AND RN.MANUAL_INDICATOR  <> 'C'                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT                                                         
MFA-TR*                 RN.ACCOUNT_NO                                           
MFA-TR*                ,RN.REFUND_STATUS_DT                                     
MFA-TR*                 INTO                                                    
MFA-TR*                 :RN-ACCOUNT-NO                                          
MFA-TR*                 ,:RN-REFUND-STATUS-DT                                   
MFA-TR*                 FROM CSS_REFUND RN                                      
MFA-TR*                 WHERE RN.ACCOUNT_NO = :AT-ACCOUNT-NO                    
MFA-TR*                 AND RN.CHECK_STATUS_CD IN                               
MFA-TR*                 ('I','M','U')                                           
MFA-TR*                 AND RN.MANUAL_INDICATOR  <> 'C'                         
MFA-TR*                 FETCH FIRST 1 ROWS ONLY                                 
MFA-TR*                 WITH UR                                                 
MFA-TR*                 QUERYNO 7285                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                                                                        
               EXEC SQL                                                 
                  SELECT
              DATEADD( MONTH, 12, IIF(TRY_CONVERT(DATE, 
                                                   :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ) )
            INTO
              :WS-RFNDDT-PLUS-12-MONTHS                      
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL                                                         
MFA-TR*           VALUES  (DATE(:RN-REFUND-STATUS-DT) + 12 MONTHS)              
MFA-TR*             INTO :WS-RFNDDT-PLUS-12-MONTHS                              
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
               EXEC SQL                                                 
                  SELECT
              DATEADD( MONTH, 24, IIF(TRY_CONVERT(DATE, 
                                                   :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ) )
            INTO
              :WS-RFNDDT-PLUS-24-MONTHS                      
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL                                                         
MFA-TR*           VALUES  (DATE(:RN-REFUND-STATUS-DT) + 24 MONTHS)              
MFA-TR*             INTO :WS-RFNDDT-PLUS-24-MONTHS                              
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
               EXEC SQL                                                 
                  SELECT
              DATEADD( MONTH, 60, IIF(TRY_CONVERT(DATE, 
                                                   :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ) )
            INTO
              :WS-RFNDDT-PLUS-60-MONTHS                      
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL                                                         
MFA-TR*           VALUES  (DATE(:RN-REFUND-STATUS-DT) + 60 MONTHS)              
MFA-TR*             INTO :WS-RFNDDT-PLUS-60-MONTHS                              
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               IF CSR-DATABASE                                          
                    MOVE WS-RFNDDT-PLUS-12-MONTHS TO WS-TEMP-DATE       
               ELSE                                                     
                    IF RN-ESCHEATMENT-CD = 'U'                          
                     MOVE WS-RFNDDT-PLUS-24-MONTHS TO WS-TEMP-DATE      
                    ELSE                                                
                     MOVE WS-RFNDDT-PLUS-60-MONTHS TO WS-TEMP-DATE      
                    END-IF                                              
               END-IF                                                   
      *                                                                         
               IF WS-TEMP-DATE <= WS-DATE-PLUS-12-MONTHS                
                  MOVE WS-DATE-PLUS-12-MONTHS TO WS-TEMP-DATE           
               END-IF                                                   
      *                                                                         
               IF  WS-TEMP-DATE >=  WS-MAX-DATE                         
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   MOVE 'E' TO WS-FCAST-TYPE-CD                         
                   MOVE 'R' TO WS-MAX-REASON-CD                         
                   MOVE RN-REFUND-STATUS-DT TO WS-RFND-DATE-R           
                   MOVE WS-RFND-MESSAGE TO WS-MAX-TABLE-NAME            
               END-IF                                                   
      *                                                                         
              WHEN NOT-FOUND                                            
                  CONTINUE                                              
              WHEN OTHER                                                
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_REFUND        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '**  7285-REFUND-REVIEWS               **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
                                                                        
       7285-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7290-SELECT-AR-TRANSHIST.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           TRANS_HIST_SEQ_NO), 121), ' ', '-'), ':', '.')                      
                INTO :AR-TRANS-HIST-SEQ-NO :WS-NULL-IND                  
                FROM  CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(TRANS_HIST_SEQ_NO)                                    
MFA-TR*         INTO :AR-TRANS-HIST-SEQ-NO:WS-NULL-IND                          
MFA-TR*         FROM  CSS_AR_TRANS_HIST                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7290                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND < 0                                   
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE AR-TRANS-HIST-SEQ-NO(1:10) TO WS-DATE-TRANS 
                       IF WS-DATE-TRANS > WS-DATE-MINUS-6-MONTHS        
                           EXEC SQL                                     
                               SELECT
              DATEADD( MONTH, 7, IIF(TRY_CONVERT(DATE, :WS-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TRANS
              ) <> 0) OR (LEN(:WS-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-TRANS
              ), CONVERT(DATE, :WS-DATE-TRANS) ) )
            INTO
              :WS-AR-DATE-PLUS-7-MONTHS          
                           END-EXEC                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*                    EXEC SQL                                             
MFA-TR*                        VALUES (DATE(:WS-DATE-TRANS) + 7 MONTHS)         
MFA-TR*                         INTO :WS-AR-DATE-PLUS-7-MONTHS                  
MFA-TR*                    END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                           MOVE WS-AR-DATE-PLUS-7-MONTHS TO WS-TEMP-DATE
                           IF WS-TEMP-DATE >= WS-MAX-DATE               
                              MOVE 'T' TO WS-MAX-REASON-CD              
                              MOVE 'E' TO WS-FCAST-TYPE-CD              
                              MOVE WS-DATE-TRANS TO WS-AR-TRN-DATE-R    
                              MOVE  WS-AR-TRN-MESSAGE                   
                                                 TO WS-MAX-TABLE-NAME   
                              MOVE WS-TEMP-DATE TO WS-MAX-DATE          
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_AR_TRANS_HIST **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED 7290- PARA  **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7295-WRITEOFF-REVIEWS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO,  COALESCE(MAX (DATE_OF_CHG_OFF)          
                                 ,IIF(TRY_CONVERT(DATE, 
              '2999-12-31-00.00.00.000000'
              ) IS NULL OR (PATINDEX('%.%', 
              '2999-12-31-00.00.00.000000') <> 0) OR (LEN(
              '2999-12-31-00.00.00.000000') <> 10), CIS.CHAR2DATE(
              '2999-12-31-00.00.00.000000'), CONVERT(DATE, 
              '2999-12-31-00.00.00.000000') ))         
                     , COALESCE(SUM(AMT_TRANS),0)                         
                INTO :CO-ACCOUNT-NO,:WS-WRT-OFF-DATE, :WS-WRT-OFF-AMT   
                FROM  CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               GROUP BY ACCOUNT_NO                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO,  IFNULL(MAX (DATE_OF_CHG_OFF)                  
MFA-TR*                          ,'2999-12-31-00.00.00.000000')                 
MFA-TR*              , IFNULL(SUM(AMT_TRANS),0)                                 
MFA-TR*         INTO :CO-ACCOUNT-NO,:WS-WRT-OFF-DATE, :WS-WRT-OFF-AMT           
MFA-TR*         FROM  CSS_CHRG_OFF                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        GROUP BY ACCOUNT_NO                                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7295                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               IF  WS-WRT-OFF-DATE = '2999-12-31-00.00.00.000000'       
                  DISPLAY 'WRT OFF DATE NULL FOR '  AT-ACCOUNT-NO       
                  MOVE AT-ACCT-FINALED-DT TO WS-WRT-OFF-DATE            
               END-IF                                                   
                                                                        
               MOVE WS-WRT-OFF-AMT TO WS-WRT-OFF-AMT-R                  
               MOVE WS-WRT-OFF-DATE TO WS-WRT-OFF-DATE-R                
                                                                        
                                                                        
               EXEC SQL                                                 
                  SELECT
              DATEADD( MONTH, 96, IIF(TRY_CONVERT(DATE, :WS-WRT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WRT-OFF-DATE
              ) <> 0) OR (LEN(:WS-WRT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-WRT-OFF-DATE
              ), CONVERT(DATE, :WS-WRT-OFF-DATE) ) )
            INTO
              :WS-WODT-PLUS-8-YEARS                          
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL                                                         
MFA-TR*           VALUES  (DATE(:WS-WRT-OFF-DATE) + 96 MONTHS)                  
MFA-TR*             INTO :WS-WODT-PLUS-8-YEARS                                  
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
               EXEC SQL                                                 
                  SELECT
              DATEADD( MONTH, 42, IIF(TRY_CONVERT(DATE, :WS-WRT-OFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WRT-OFF-DATE
              ) <> 0) OR (LEN(:WS-WRT-OFF-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-WRT-OFF-DATE
              ), CONVERT(DATE, :WS-WRT-OFF-DATE) ) )
            INTO
              :WS-WODT-PLUS-42-MONTHS                        
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL                                                         
MFA-TR*           VALUES  (DATE(:WS-WRT-OFF-DATE) + 42 MONTHS)                  
MFA-TR*             INTO :WS-WODT-PLUS-42-MONTHS                                
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
                                                                        
               IF WS-WRT-OFF-AMT  NOT = 0                               
                 DISPLAY WS-DISPLAY-ACCOUNT ' ' 'WO NOT 0'              
               END-IF                                                   
                                                                        
               MOVE WS-WRT-OFF-AMT TO WS-WRT-OFF-AMT-R                  
               MOVE WS-WRT-OFF-DATE TO WS-WRT-OFF-DATE-R                
                                                                        
               WHEN NOT-FOUND                                           
                  MOVE AT-ACCT-FINALED-DT   TO WS-WRT-OFF-DATE          
                  MOVE WS-FBDT-PLUS-42-MONTHS TO WS-WODT-PLUS-42-MONTHS 
                  MOVE WS-FBDT-PLUS-8-YEARS TO WS-WODT-PLUS-8-YEARS     
                  MOVE 'Y' TO WS-NTF-CHRG-OFF                           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CHRG_OFF      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED PARA 7295   **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           PERFORM 7624-CHECK-FOR-CREDIT-BUREAU THRU 7624-EXIT.         
                                                                        
                                                                        
           IF WS-CB-CA-SW = 'Y'                                         
              MOVE WS-WODT-PLUS-8-YEARS TO WS-TEMP-DATE                 
              MOVE 'W' TO WS-TEMP-REASON-CD                             
              MOVE 'R' TO WS-TEMP-FCAST-TYPE-CD                         
              IF WS-NTF-CHRG-OFF = 'Y'                                  
               MOVE 'N' TO WS-NTF-CHRG-OFF                              
               MOVE  'Write off date not found,using final bill date'   05260000
      -                 TO WS-TEMP-MESSAGE                                      
              ELSE                                                      
               MOVE  WS-WRT-OFF-MESSAGE TO WS-TEMP-MESSAGE              
              END-IF                                                    
           ELSE                                                         
              IF WS-WODT-PLUS-8-YEARS <= WS-DATE-PLUS-1-MONTH           
                 MOVE WS-WODT-PLUS-8-YEARS TO WS-TEMP-DATE              
                 MOVE 'W' TO WS-TEMP-REASON-CD                          
                 MOVE 'R' TO WS-TEMP-FCAST-TYPE-CD                      
               IF WS-NTF-CHRG-OFF = 'Y'                                 
                MOVE 'N' TO WS-NTF-CHRG-OFF                             
                MOVE  'Write off date not found,using final bill date'  05260000
      -                 TO WS-TEMP-MESSAGE                                      
               ELSE                                                     
                MOVE  WS-WRT-OFF-MESSAGE TO WS-TEMP-MESSAGE             
               END-IF                                                   
              ELSE                                                      
                 MOVE WS-WODT-PLUS-42-MONTHS TO WS-TEMP-DATE            
                 MOVE 'X' TO WS-TEMP-REASON-CD                          
                 MOVE 'R' TO WS-TEMP-FCAST-TYPE-CD                      
                 MOVE  'Write off using final bill rule'                
                              TO WS-TEMP-MESSAGE                        
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-TEMP-DATE >= WS-MAX-DATE                               
                MOVE WS-TEMP-DATE TO WS-MAX-DATE                        
                MOVE WS-TEMP-REASON-CD TO WS-MAX-REASON-CD              
                MOVE WS-TEMP-FCAST-TYPE-CD TO WS-FCAST-TYPE-CD          
                MOVE  WS-TEMP-MESSAGE TO WS-MAX-TABLE-NAME              
           END-IF.                                                      
                                                                        
       7295-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7298-SELECT-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :DO-ACCOUNT-NO                                     
                FROM  CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                 AND  (AMT_DEPOSIT  <> 0                                
                  OR   DEPOSIT_STATUS_CD IN ('A', 'P'))                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :DO-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_DEP_ON_HAND                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          AND  (AMT_DEPOSIT  = 0                                        
MFA-TR*           OR   DEPOSIT_STATUS_CD IN ('A', 'P'))                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7298                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE > WS-MAX-DATE                        
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'O' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-FCAST-TYPE-CD                     
                       MOVE 'Non Refunded Deposit' TO WS-MAX-TABLE-NAME 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_DEP_ON_HAND  **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '**  PROCESSING TERMINATED 7298- PARA  **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7298-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7300-REFUND-ESC.                                                 
                                                                        
           EXEC SQL                                                     
                 SELECT TOP(1) RN.ACCOUNT_NO,
              RN.CHECK_ISS_REAS_CD,
              RN.CHECK_STATUS_CD,
              RN.MANUAL_INDICATOR,
              RN.REFUND_STATUS_DT                             
                        INTO                                            
                       :RN-ACCOUNT-NO                                   
                       ,:RN-CHECK-ISS-REAS-CD                           
                       ,:RN-CHECK-STATUS-CD                             
                       ,:RN-MANUAL-INDICATOR                            
                       ,:RN-REFUND-STATUS-DT                            
                        FROM CSS_REFUND RN WITH(READUNCOMMITTED)                
                        WHERE RN.ACCOUNT_NO = :AT-ACCOUNT-NO            
                        AND REFUND_CHECK_NO NOT IN                      
                        ('00','000'                                     
                        ,'0000','00000','000000','0000000',             
                        '00000000')                                     
                        AND RN.CHECK_STATUS_CD NOT IN                   
                        ('C','D','F','L','S','X','T')                   
                        ORDER BY CHECK_STATUS_CD DESC                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT                                                         
MFA-TR*                 RN.ACCOUNT_NO                                           
MFA-TR*                ,RN.CHECK_ISS_REAS_CD                                    
MFA-TR*                ,RN.CHECK_STATUS_CD                                      
MFA-TR*                ,RN.MANUAL_INDICATOR                                     
MFA-TR*                ,RN.REFUND_STATUS_DT                                     
MFA-TR*                 INTO                                                    
MFA-TR*                :RN-ACCOUNT-NO                                           
MFA-TR*                ,:RN-CHECK-ISS-REAS-CD                                   
MFA-TR*                ,:RN-CHECK-STATUS-CD                                     
MFA-TR*                ,:RN-MANUAL-INDICATOR                                    
MFA-TR*                ,:RN-REFUND-STATUS-DT                                    
MFA-TR*                 FROM CSS_REFUND RN                                      
MFA-TR*                 WHERE RN.ACCOUNT_NO = :AT-ACCOUNT-NO                    
MFA-TR*                 AND REFUND_CHECK_NO NOT IN                              
MFA-TR*                 ('00','000'                                             
MFA-TR*                 ,'0000','00000','000000','0000000',                     
MFA-TR*                 '00000000')                                             
MFA-TR*                 AND RN.CHECK_STATUS_CD NOT IN                           
MFA-TR*                 ('C','D','F','L','S','X','T')                           
MFA-TR*                 ORDER BY CHECK_STATUS_CD DESC                           
MFA-TR*                 FETCH FIRST 1 ROWS ONLY                                 
MFA-TR*                 WITH UR                                                 
MFA-TR*                 QUERYNO 7300                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                                                                        
                  MOVE 'N' TO WS-FLAG-RFNDN                             
      *                                                                         
                  IF  RN-CHECK-STATUS-CD = 'A'                          
                    IF  RN-MANUAL-INDICATOR  NOT = 'A'                  
                    AND RN-MANUAL-INDICATOR  NOT = 'B'                  
                    AND RN-MANUAL-INDICATOR  NOT = 'C'                  
                        MOVE 'Y' TO WS-FLAG-RFNDN                       
                    END-IF                                              
                  END-IF                                                
      *                                                                         
                  IF RN-CHECK-STATUS-CD = 'R'                           
                  AND  RN-REFUND-STATUS-DT < WS-DATE-MINUS-3-MONTHS     
                        MOVE 'Y' TO WS-FLAG-RFNDN                       
                  END-IF                                                
      *                                                                         
                  IF (RN-CHECK-STATUS-CD NOT  = 'I' AND                 
                      RN-CHECK-STATUS-CD NOT  = 'A' )                   
                      IF  RN-MANUAL-INDICATOR = 'C'                     
                        MOVE 'Y' TO WS-FLAG-RFNDN                       
                      END-IF                                            
                  END-IF                                                
      *                                                                         
                  IF  WS-FLAG-RFNDN = 'Y'                               
                    MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE          
      *                                                                         
                    IF WS-TEMP-DATE >= WS-MAX-DATE                      
                        MOVE WS-TEMP-DATE TO WS-MAX-DATE                
                        MOVE 'N' TO WS-MAX-REASON-CD                    
                        MOVE 'E' TO WS-FCAST-TYPE-CD                    
                        MOVE WS-RFND-3MTH-MESSAGE TO WS-MAX-TABLE-NAME  
                                                                        
                    END-IF                                              
                  ELSE                                                  
                    MOVE 'N' TO WS-FLAG-RFNDN                           
                  END-IF                                                
                                                                        
              WHEN NOT-FOUND                                            
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_REFUND        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED 7300- PARA  **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7305-CASH-RFND.                                                  
                                                                        
           EXEC SQL                                                     
                 SELECT TOP(1) RN.ACCOUNT_NO                                   
                        INTO                                            
                       :RN-ACCOUNT-NO                                   
                        FROM CSS_REFUND RN WITH(READUNCOMMITTED)                
                        WHERE RN.ACCOUNT_NO = :AT-ACCOUNT-NO            
                        AND RN.CHECK_STATUS_CD IN  ('R')                
                        AND RN.MANUAL_INDICATOR  = 'C'                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT                                                         
MFA-TR*                 RN.ACCOUNT_NO                                           
MFA-TR*                 INTO                                                    
MFA-TR*                :RN-ACCOUNT-NO                                           
MFA-TR*                 FROM CSS_REFUND RN                                      
MFA-TR*                 WHERE RN.ACCOUNT_NO = :AT-ACCOUNT-NO                    
MFA-TR*                 AND RN.CHECK_STATUS_CD IN  ('R')                        
MFA-TR*                 AND RN.MANUAL_INDICATOR  = 'C'                          
MFA-TR*                 FETCH FIRST 1 ROWS ONLY                                 
MFA-TR*                 WITH UR                                                 
MFA-TR*                 QUERYNO 7305                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                                                                        
      *                                                                         
                  MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE            
      *                                                                         
                  IF WS-TEMP-DATE >= WS-MAX-DATE                        
                      MOVE WS-TEMP-DATE TO WS-MAX-DATE                  
                      MOVE 'N' TO WS-MAX-REASON-CD                      
                      MOVE 'E' TO WS-FCAST-TYPE-CD                      
                      MOVE WS-CS-RN-MESSAGE TO WS-MAX-TABLE-NAME        
                                                                        
                  END-IF                                                
                                                                        
              WHEN NOT-FOUND                                            
                  CONTINUE                                              
              WHEN OTHER                                                
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR  7305- PARA  **'                  
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
                                                                        
       7305-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-ACCOUNT-BALANCE.                                            
                                                                        
      *  ACCOUNT WITH BALANCE EDITS                                             
                                                                        
      *                                                                         
             IF AT-TOTAL-AR-BALANCE > 0                                 
                  MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE            
                  IF WS-TEMP-DATE >= WS-MAX-DATE                        
                      MOVE WS-TEMP-DATE TO WS-MAX-DATE                  
                      MOVE 'H' TO WS-MAX-REASON-CD                      
                      MOVE 'E' TO WS-FCAST-TYPE-CD                      
                      MOVE AT-TOTAL-AR-BALANCE TO WS-ARB-R              
                      MOVE AT-ACCT-FINALED-DT  TO WS-FB-DATE-R          
                      MOVE WS-ARBAL-MESSAGE TO WS-MAX-TABLE-NAME        
                  END-IF                                                
             END-IF                                                     
      *                                                                         
             IF AT-TOTAL-AR-BALANCE < 0                                 
                 PERFORM 7325-CHECK-CIA-ROW THRU 7325-EXIT              
                 IF WS-CIA-PRESENT-FL = 'Y'                             
                  IF SEB-DATABASE                                       
                      MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE        
                      MOVE WS-TEMP-DATE TO WS-MAX-DATE                  
                    IF WS-TEMP-DATE >= WS-MAX-DATE                      
                      MOVE 'K' TO WS-MAX-REASON-CD                      
                      MOVE 'E' TO WS-FCAST-TYPE-CD                      
                      MOVE AT-TOTAL-AR-BALANCE TO WS-SEB-ARB-R          
                      MOVE AT-LAST-PYMT-DATE TO WS-LST-PYMT-DT-SEB      
                      MOVE WS-SEB-ARBAL-MESSAGE TO WS-MAX-TABLE-NAME    
                    END-IF                                              
                  END-IF                                                
                                                                        
                  IF  CSR-DATABASE                                      
                   IF (( AT-CODE-ACCT-STAT =  'B'                       
                        AND AT-TOTAL-AR-BALANCE >= -1.00 )  OR          
                        ( AT-CODE-ACCT-STAT =  'S'                      
                        AND AT-TOTAL-AR-BALANCE >= -5.00 ))             
                       PERFORM 7326-ESCHEAT-CSR-AMT THRU 7326-EXIT      
                   ELSE                                                 
                       PERFORM 7327-RETURN-CUST-AMT THRU 7327-EXIT      
                   END-IF                                               
                  END-IF                                                
                 END-IF                                                 
             END-IF                                                     
      *  ACCOUNTS WITH  NON-ZERO ROWS ON AR CONTROL                             
             IF WS-FCAST-TYPE-CD = ' '                                  
                  PERFORM 7320-SELECT-AR-CNTL THRU 7320-EXIT            
             END-IF.                                                    
                                                                        
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-SELECT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :AC-ACCOUNT-NO                                     
                FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                 AND  (AMT_TRAN_BALANCE <> 0                            
                  OR   AMT_AR_DAY_00 <> 0                               
                  OR   AMT_AR_DAY_30 <> 0                               
                  OR   AMT_AR_DAY_60 <> 0                               
                  OR   AMT_AR_DAY_90 <> 0                               
                  OR   AMT_UNUSED_CR <> 0                               
                  OR   TOT_SUMM_UNBILLED <> 0)                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :AC-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_AR_CNTL                                               
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          AND  (AMT_TRAN_BALANCE = 0                                    
MFA-TR*           OR   AMT_AR_DAY_00 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_30 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_60 = 0                                       
MFA-TR*           OR   AMT_AR_DAY_90 = 0                                       
MFA-TR*           OR   AMT_UNUSED_CR = 0                                       
MFA-TR*           OR   TOT_SUMM_UNBILLED = 0)                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'Q' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-FCAST-TYPE-CD                     
                       MOVE WS-AR-MESSAGE  TO WS-MAX-TABLE-NAME         
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING 7320- PARA       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
        7325-CHECK-CIA-ROW.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                        
                INTO :AC-ACCOUNT-NO                                     
                FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                 AND  PYMT_PRIORITY_LVL  = 70                           
                 AND  ITEM_ID IN (1,2)                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :AC-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_AR_CNTL                                               
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          AND  PYMT_PRIORITY_LVL  = 70                                   
MFA-TR*          AND  ITEM_ID IN (1,2)                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7325                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-CIA-PRESENT-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-CIA-PRESENT-FL                        
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                       MOVE WS-TEMP-DATE TO WS-MAX-DATE                 
                       MOVE 'J' TO WS-MAX-REASON-CD                     
                       MOVE 'E' TO WS-FCAST-TYPE-CD                     
                      MOVE WS-CIA-MESSAGE  TO WS-MAX-TABLE-NAME         
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING 7325- PARA       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7326-ESCHEAT-CSR-AMT.                                            
                  IF AT-LAST-PYMT-DATE ='2999-12-31-00.00.00.000000'    
                    MOVE WS-DATE-PLUS-12-MONTHS TO WS-TEMP-DATE         
                                                                        
                  ELSE                                                  
                   EXEC SQL                                             
                    SELECT
              DATEADD( MONTH, 36, IIF(TRY_CONVERT(DATE, 
                                                     :AT-LAST-PYMT-DATE
              ) IS NULL OR (PATINDEX('%.%', :AT-LAST-PYMT-DATE
              ) <> 0) OR (LEN(:AT-LAST-PYMT-DATE
              ) <> 10), CIS.CHAR2DATE(:AT-LAST-PYMT-DATE
              ), CONVERT(DATE, :AT-LAST-PYMT-DATE) ) )
            INTO
              :WS-LSTPYT-PLUS-36-MONTHS                      
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*            EXEC SQL                                                     
MFA-TR*             VALUES  (DATE(:AT-LAST-PYMT-DATE) + 36 MONTHS)              
MFA-TR*             INTO :WS-LSTPYT-PLUS-36-MONTHS                              
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
                   IF WS-LSTPYT-PLUS-36-MONTHS <= WS-CURRENT-DATE       
                    MOVE WS-DATE-PLUS-12-MONTHS                         
                                 TO WS-LSTPYT-PLUS-36-MONTHS            
                   END-IF                                               
                   MOVE WS-LSTPYT-PLUS-36-MONTHS TO WS-TEMP-DATE        
                  END-IF                                                
      *                                                                         
                  IF WS-TEMP-DATE >= WS-MAX-DATE                        
                    MOVE WS-TEMP-DATE TO WS-MAX-DATE                    
                    MOVE 'A' TO WS-MAX-REASON-CD                        
                    MOVE 'E' TO WS-FCAST-TYPE-CD                        
                    MOVE AT-TOTAL-AR-BALANCE TO WS-ESC-AMT-R            
                    MOVE AT-LAST-PYMT-DATE TO WS-LST-PYMT-DT-ESC        
                    MOVE WS-ESC-OFF-MESSAGE TO WS-MAX-TABLE-NAME        
                  END-IF.                                               
      *                                                                         
       7326-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7327-RETURN-CUST-AMT.                                            
                IF AT-TOTAL-AR-BALANCE < -1.00                          
                   MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE           
                   MOVE WS-TEMP-DATE TO WS-MAX-DATE                     
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                     MOVE 'K' TO WS-MAX-REASON-CD                       
                                                                        
                     MOVE 'E' TO WS-FCAST-TYPE-CD                       
                     MOVE AT-TOTAL-AR-BALANCE TO WS-CRD-AMT-R           
                     MOVE AT-LAST-PYMT-DATE TO WS-LST-PYMT-DT-CSRLT1    
                     MOVE WS-CRD-BALLT1-MESSAGE                         
                                             TO WS-MAX-TABLE-NAME       
                   END-IF                                               
                END-IF.                                                 
       7327-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7405-CONTRACT-RULES.                                             
           EXEC SQL                                                     
               SELECT CT.ACCOUNT_NO,                                    
               COALESCE(MAX(CT.STATUS_CHANGE_DT),IIF(TRY_CONVERT(DATE, 
              '2999-12-31') IS NULL OR (PATINDEX('%.%', '2999-12-31'
              ) <> 0) OR (LEN('2999-12-31') <> 10), CIS.CHAR2DATE(
              '2999-12-31'), CONVERT(DATE, '2999-12-31') ))            
               INTO                                                     
               :CT-ACCOUNT-NO                                           
               ,:WS-DATE-MAX-CONTRCT                                    
               FROM   CSS_CONTRACT CT WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               AND CT.CODE_CONTRACT_TYPE IN                             
                                ('I','J','K','L','M','N','A','B','O')   
               AND CT.CNT_STATUS_CD IN                                  
                                ('C','D','E','F','R','G','P')           
               GROUP BY CT.ACCOUNT_NO                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CT.ACCOUNT_NO,                                            
MFA-TR*        IFNULL(MAX(CT.STATUS_CHANGE_DT),'2999-12-31')                    
MFA-TR*        INTO                                                             
MFA-TR*        :CT-ACCOUNT-NO                                                   
MFA-TR*        ,:WS-DATE-MAX-CONTRCT                                            
MFA-TR*        FROM   CSS_CONTRACT CT                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        AND CT.CODE_CONTRACT_TYPE IN                                     
MFA-TR*                         ('I','J','K','L','M','N','A','B','O')           
MFA-TR*        AND CT.CNT_STATUS_CD IN                                          
MFA-TR*                         ('C','D','E','F','R','G','P')                   
MFA-TR*        GROUP BY CT.ACCOUNT_NO                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7405                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
      *                                                                         
                     EXEC SQL                                           
                     SELECT
              DATEADD( MONTH, 75, IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-MAX-CONTRCT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-MAX-CONTRCT
              ) <> 0) OR (LEN(:WS-DATE-MAX-CONTRCT
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-MAX-CONTRCT
              ), CONVERT(DATE, :WS-DATE-MAX-CONTRCT) ) )
            INTO
              :WS-DATE-PLUS-6YRS-3MTHS                    
                     END-EXEC                                           

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*              EXEC SQL                                                   
MFA-TR*              VALUES  (DATE(:WS-DATE-MAX-CONTRCT) + 75 MONTHS)           
MFA-TR*                INTO :WS-DATE-PLUS-6YRS-3MTHS                            
MFA-TR*              END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                     MOVE WS-DATE-PLUS-6YRS-3MTHS TO WS-TEMP-DATE       
      *                                                                         
                     IF WS-TEMP-DATE < WS-DATE-PLUS-6-MONTHS            
                      MOVE WS-DATE-PLUS-6-MONTHS TO WS-TEMP-DATE        
                     END-IF                                             
      *                                                                         
                     IF WS-TEMP-DATE >= WS-MAX-DATE                     
                        MOVE WS-TEMP-DATE TO WS-MAX-DATE                
                        MOVE 'C' TO WS-MAX-REASON-CD                    
                        MOVE 'R' TO WS-FCAST-TYPE-CD                    
                        MOVE WS-DATE-MAX-CONTRCT TO WS-CTR-DATE         
                        MOVE WS-CONTRACT-MESSAGE TO WS-MAX-TABLE-NAME   
                                                                        
                     END-IF                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CONTRACT     **'    
                   DISPLAY '**  PARA  7405                       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7405-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 09290600
       7415-MSE-CONTRACT-RULES.                                         
                                                                        
           EXEC SQL                                                     
               SELECT CT.ACCOUNT_NO,                                    
               COALESCE(MAX(CT.STATUS_CHANGE_DT),IIF(TRY_CONVERT(DATE, 
              '2999-12-31') IS NULL OR (PATINDEX('%.%', '2999-12-31'
              ) <> 0) OR (LEN('2999-12-31') <> 10), CIS.CHAR2DATE(
              '2999-12-31'), CONVERT(DATE, '2999-12-31') ))            
               INTO                                                     
               :CT-ACCOUNT-NO                                           
               ,:WS-DATE-MAX-CONTRCT                                    
               FROM   CSS_CONTRACT CT WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               GROUP BY CT.ACCOUNT_NO                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CT.ACCOUNT_NO,                                            
MFA-TR*        IFNULL(MAX(CT.STATUS_CHANGE_DT),'2999-12-31')                    
MFA-TR*        INTO                                                             
MFA-TR*        :CT-ACCOUNT-NO                                                   
MFA-TR*        ,:WS-DATE-MAX-CONTRCT                                            
MFA-TR*        FROM   CSS_CONTRACT CT                                           
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        GROUP BY CT.ACCOUNT_NO                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7415                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  IF WS-DATE-MAX-CONTRCT = '2999-12-31'                 
                      MOVE AT-ACCT-FINALED-DT TO WS-DATE-MAX-CONTRCT    
                  END-IF                                                
                                                                        
                   EXEC SQL                                             
                   SELECT
              DATEADD( MONTH, 75, IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-MAX-CONTRCT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-MAX-CONTRCT
              ) <> 0) OR (LEN(:WS-DATE-MAX-CONTRCT
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-MAX-CONTRCT
              ), CONVERT(DATE, :WS-DATE-MAX-CONTRCT) ) )
            INTO
              :WS-DATE-PLUS-6YRS-3MTHS                      
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*            EXEC SQL                                                     
MFA-TR*            VALUES  (DATE(:WS-DATE-MAX-CONTRCT) + 75 MONTHS)             
MFA-TR*              INTO :WS-DATE-PLUS-6YRS-3MTHS                              
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                   MOVE WS-DATE-PLUS-6YRS-3MTHS TO WS-TEMP-DATE         
      *                                                                         
                   IF WS-TEMP-DATE < WS-DATE-PLUS-6-MONTHS              
                    MOVE WS-DATE-PLUS-6-MONTHS TO WS-TEMP-DATE          
                   END-IF                                               
      *                                                                         
                   IF WS-TEMP-DATE >= WS-MAX-DATE                       
                      MOVE WS-TEMP-DATE TO WS-MAX-DATE                  
                      MOVE 'M' TO WS-MAX-REASON-CD                      
                      MOVE 'R' TO WS-FCAST-TYPE-CD                      
                      MOVE WS-DATE-MAX-CONTRCT TO WS-CTR-DATE           
                      MOVE WS-CONTRACT-MESSAGE TO WS-MAX-TABLE-NAME     
                                                                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CONTRACT     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '**  PARA  7415                       **'    
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7415-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 09290600
                                                                        
       7510-SELECT-ATTORNEY.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FW.ACCOUNT_NO                                     
                INTO :FW-ACCOUNT-NO                                     
                FROM  CSS_FIN_WO_ACTION KD
                           WITH(READUNCOMMITTED), CSS_FINAL_WO FW
                           WITH(READUNCOMMITTED)             
               WHERE  FW.ACCOUNT_NO = :AT-ACCOUNT-NO                    
               AND FW.ACCOUNT_NO =  KD.ACCOUNT_NO                       
               AND FW.COLLECT_STATUS_CD NOT IN ('E')                    
               AND  FW_ACTION_TYPE_CD = 'ATY'                           
               AND  FW_ACTION_AM > 0                                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FW.ACCOUNT_NO                                             
MFA-TR*         INTO :FW-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_FIN_WO_ACTION KD, CSS_FINAL_WO FW                     
MFA-TR*        WHERE  FW.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*        AND FW.ACCOUNT_NO =  KD.ACCOUNT_NO                               
MFA-TR*        AND FW.COLLECT_STATUS_CD NOT IN ('E')                            
MFA-TR*        AND  FW_ACTION_TYPE_CD = 'ATY'                                   
MFA-TR*        AND  FW_ACTION_AM > 0                                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ACC-ARCH-FL                           
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_FIN_WO_ACTION  *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED 7510 PARA   **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7612-PREM-LAST-ACC.                                              
                 IF AT-PREMISE-NO NOT = 0                               
                   MOVE 'N' TO WS-CPD99-ERROR                           
                   MOVE AT-PREMISE-NO TO WS-CPD99-PREMISE-NO            
                   PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT        
                   IF WS-CPD99-ERROR = 'Y'                              
                     DISPLAY 'CPD99 FAILED IN LST_ACCT_PREM CHECK'      
                     DISPLAY WS-CPD99-ACCOUNT-NO "," WS-CURRENT-ACCOUNT 
                     MOVE WS-DATE-PLUS-3-MONTHS TO WS-TEMP-DATE         
      *                                                                         
                     IF WS-TEMP-DATE >= WS-MAX-DATE                     
                        MOVE WS-TEMP-DATE TO WS-MAX-DATE                
                        MOVE 'P' TO WS-MAX-REASON-CD                    
                        MOVE 'E' TO WS-FCAST-TYPE-CD                    
                        MOVE WS-LST-ACC-PRM-MESSAGE                     
                                            TO WS-MAX-TABLE-NAME        
                     END-IF                                             
      *                                                                         
                   ELSE                                                 
                     MOVE WS-CPD99-ACCOUNT-NO TO WS-CURRENT-ACCOUNT     
                     IF WS-CURRENT-ACCOUNT = AT-ACCOUNT-NO              
                       MOVE 'Y' TO WS-ACC-ARCH-FL                       
                     END-IF                                             
                   END-IF                                               
                 END-IF.                                                
       7612-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7613-FINAL-BILL-REVIEWS.                                         
           PERFORM 7624-CHECK-FOR-CREDIT-BUREAU THRU 7624-EXIT.         
           IF WS-CB-CA-SW = 'Y'                                         
              MOVE WS-FBDT-PLUS-8-YEARS TO WS-TEMP-DATE                 
              IF WS-TEMP-DATE >= WS-MAX-DATE                            
                 MOVE WS-TEMP-DATE TO WS-MAX-DATE                       
                 MOVE 'W' TO WS-MAX-REASON-CD                           
                 MOVE 'R' TO WS-FCAST-TYPE-CD                           
                 MOVE WS-FB-MESSAGE TO WS-MAX-TABLE-NAME                
              END-IF                                                    
           ELSE                                                         
               MOVE WS-FBDT-PLUS-42-MONTHS TO WS-TEMP-DATE              
               MOVE WS-TEMP-DATE TO WS-MAX-DATE                         
               MOVE 'F' TO WS-MAX-REASON-CD                             
               MOVE 'R' TO WS-FCAST-TYPE-CD                             
               MOVE AT-ACCT-FINALED-DT TO WS-FNL-OFF-DATE-R             
               MOVE  WS-FNL-OFF-MESSAGE TO WS-MAX-TABLE-NAME            
           END-IF.                                                      
                                                                        
                                                                        
       7613-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7624-CHECK-FOR-CREDIT-BUREAU.                                    
           MOVE ' ' TO WS-CB-CA-SW                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-CB-CA-SW                                       
                FROM  CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                  
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               AND CR_BUR_RPT_DT IS NOT NULL                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-CB-CA-SW                                               
MFA-TR*         FROM  CSS_CREDIT_PROFILE                                        
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        AND CR_BUR_RPT_DT IS NOT NULL                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7624                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  MOVE 'Y' TO WS-CB-CA-SW                               
                                                                        
            WHEN NOT-FOUND                                              
                  PERFORM 7623-CHECK-FINWO-MNT THRU 7623-EXIT           
            WHEN OTHER                                                  
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_CREDIT_PROFILE *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED 7624 PARA   **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
       7624-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7623-CHECK-FINWO-MNT.                                            
                                                                        
                                                                        
           MOVE ' ' TO WS-CB-CA-SW                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO :WS-CB-CA-SW                                       
                FROM  CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                   
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
               AND FW_ACTION_TYPE_CD                                    
                      IN ('CREDB', '1PLMT','2PLMT','3PLMT','ATY')       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-CB-CA-SW                                               
MFA-TR*         FROM  CSS_FIN_WO_ACTION                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        AND FW_ACTION_TYPE_CD                                            
MFA-TR*               IN ('CREDB', '1PLMT','2PLMT','3PLMT','ATY')               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7623                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  MOVE 'Y' TO WS-CB-CA-SW                               
                                                                        
            WHEN NOT-FOUND                                              
                  PERFORM 7616-SELECT-MNTTRN-CACB THRU 7616-EXIT        
            WHEN OTHER                                                  
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_FIN_WO_ACTION  *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED 7623 PARA   **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7623-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7616-SELECT-MNTTRN-CACB.                                         
                                                                        
           MOVE ' ' TO WS-CB-CA-SW                                      
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO :WS-CB-CA-SW                                         
              FROM CSS_MNT_TRANS_HIST MN WITH(READUNCOMMITTED)                  
               WHERE MN.ACCOUNT_NO = :AT-ACCOUNT-NO                     
               AND APPL_PROGRAM_ID IN ('PCSCA206','PCSCA275',           
                 'CBDTCORR','UPDT CACB','UPDT CB','UPDT WDRW')          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :WS-CB-CA-SW                                                 
MFA-TR*       FROM CSS_MNT_TRANS_HIST MN                                        
MFA-TR*        WHERE MN.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        AND APPL_PROGRAM_ID IN ('PCSCA206','PCSCA275',                   
MFA-TR*          'CBDTCORR','UPDT CACB','UPDT CB','UPDT WDRW')                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7616                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                  CONTINUE                                              
            WHEN NOT-FOUND                                              
                  MOVE 'N' TO WS-CB-CA-SW                               
            WHEN OTHER                                                  
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_FIN_WO_ACTION  *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ACCOUNT = ' WS-DISPLAY-ACCOUNT          
                   DISPLAY '**  PROCESSING TERMINATED 7616 PARA   **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7616-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * COMMENTING LAST ACCT PREM COPYBOOK AND HARDCODING                       
      * FOR DBAS TO CHANGE SQLS HERE AND CHK PERORMANCE                         
      *    EXEC SQL                                                             
      *        INCLUDE CPD00099                                                 
      *    END-EXEC.                                                            
      ******************************************************************31298000
      *                        COPYBOOK CPD00099                       *31300000
      ******************************************************************31320000
      * PURPOSE : TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.    *31300000
      *                                                                *31300000
      * INCLUDE CWS00010 & CWS00099 IN THE PROGRAM TO USE THIS LOGIC.  *31300000
      *                                                                *31300000
      * SHOULD ALSO INCLUDE THE LOGIC TO DISPLAY ABEND INFO FOR BATCH  *31300000
      * PROGRAMS OR TO SEND ABEND INFO TO MC05 IN ONLINE PROGRAMS.     *31300000
      * (FOR PARA 6995-CPD99-ERROR-ROUTINE)                            *31300000
      *                                                                *31320000
      * PASS THE PREMISE-NO TO WS-CPD99-PREMISE-NO AND IT WILL RETURN  *31300000
      * WS-CPD99-ACCOUNT-NO, THE MOST CURRENT ACCT AT THE PREMISE.     *31320000
      *                                                                *31320000
      ******************************************************************31360000
      *                                                                 31370000
      ******************************************************************43111000
      * 6990-FETCH-CUR-ACCOUNT                                         *42840000
      *                                                                *42840000
      *     1.  LOOK FOR A NULL IN DATE_UTIL_SVC_END (THERE SHOULD BE  *42850000
      *         ONLY ONE).  IF EXISTS, USE THIS ACCOUNT.               *42850000
      *     2.  IF NONE EXISTS, LOOK FOR MAX (DATE_UTIL_SVC_END).  IF  *42850000
      *         ONLY ONE EXISTS, USE THIS ACCOUNT.                     *42850000
      *     3.  IF MULTIPLE ROWS WITH SAME MAX END DATE, LOOK AT       *42850000
      *         ACCOUNT TABLE FOR MAX (ACCT_FINALED_DT) FOR THE        *42850000
      *         PREMISE.  USE THIS ACCOUNT.                            *42850000
      *     4.  IF MULTIPLE ROWS WITH SAME MAX ACCT_FINALED_DT, LOOK   *42850000
      *         FOR MAX ACCT_CREATE_DT.  USE THIS ACCOUNT.             *42850000
      ******************************************************************00110000
      *     DATE    INITIALS   MODIFICATION LOG                        *00140000
      *     ____    ________   ________________                        *00150000
      *                                                                *00151000
T22243*    06/00     SREENI    CHANGES MADE TO IMPLEMENT MULTI-COMPANY *        
T22243*                        IN METER INVENTORY.                     *        
C30397*    02/04     SREENI    CHANGES MADE TO FIX -305 IN 6992- PARA  *        
      *                                                                *42840000
      ******************************************************************42860000
      *                                                                 42870000
       6990-FETCH-CUR-ACCOUNT.                                          
      *                                                                 43520000
           EXEC SQL                                                     
              SELECT CH.ACCOUNT_NO                                      
                INTO :WS-CPD99-ACCOUNT-NO                               
                FROM CSS_CUST_PREM_HIST CH                              
                    ,CSS_ACCOUNT        AT                              
               WHERE CH.PREMISE_NO = :WS-CPD99-PREMISE-NO               
                 AND CH.ACCOUNT_NO = AT.ACCOUNT_NO                      
                 AND CH.DATE_UTIL_SVC_END IS NULL                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     43521000
MFA-TR*       SELECT CH.ACCOUNT_NO                                              
MFA-TR*         INTO :WS-CPD99-ACCOUNT-NO                               43522100
MFA-TR*         FROM CSS_CUST_PREM_HIST CH                              43523000
MFA-TR*             ,CSS_ACCOUNT        AT                              43523100
MFA-TR*        WHERE CH.PREMISE_NO = :WS-CPD99-PREMISE-NO               43524000
MFA-TR*          AND CH.ACCOUNT_NO = AT.ACCOUNT_NO                      43527000
MFA-TR*          AND CH.DATE_UTIL_SVC_END IS NULL                               
MFA-TR*          QUERYNO 6990                                                   
MFA-TR*    END-EXEC.                                                    43528000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43529000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 43529300
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   PERFORM 6991-MAX-END-DATE THRU 6991-EXIT             
               WHEN OTHER                                               
                   MOVE SQLCODE               TO WS-CPD99-RETURN-CODE   
                   MOVE SPACES                TO ABEND-FILE             
                   MOVE '6990'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ACCOUNT'         TO TABLE-1                
                   MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-2                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
T22243             MOVE 'DATE_UTIL_SVC_END'   TO TABLE-ELEMENT-2        
                   MOVE WS-CPD99-PREMISE-NO   TO HOSTVAR-ELEMENT-1      
T22243             MOVE 'NULL'                TO HOSTVAR-ELEMENT-2      
                   PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT      
           END-EVALUATE.                                                
      *                                                                 43110000
       6990-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43110000
      ******************************************************************42780000
      * 6991-MAX-END-DATE                                              *42790000
      *                                                                *42820000
      *     CALLED FROM 6990-FETCH-CUR-ACCOUNT                         *42830000
      *                                                                *42840000
      *     MAX DATE_UTIL_SVC_END AT PREMISE                           *42850000
      ******************************************************************42860000
      *                                                                 42870000
       6991-MAX-END-DATE.                                               
      *                                                                 43110000
           EXEC SQL                                                     
              SELECT  MAX(DATE_UTIL_SVC_END)                            
                INTO :WS-CPD99-DATE-SVC-END :WS-CPD99-NULL-IND           
                FROM  CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)               
                     ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)               
               WHERE CH.PREMISE_NO = :WS-CPD99-PREMISE-NO               
                 AND CH.ACCOUNT_NO = AT.ACCOUNT_NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     43521000
MFA-TR*       SELECT  MAX(DATE_UTIL_SVC_END)                            43522000
MFA-TR*         INTO :WS-CPD99-DATE-SVC-END:WS-CPD99-NULL-IND           43522100
MFA-TR*         FROM  CSS_CUST_PREM_HIST CH                             43523000
MFA-TR*              ,CSS_ACCOUNT        AT                             43523100
MFA-TR*        WHERE CH.PREMISE_NO = :WS-CPD99-PREMISE-NO               43524000
MFA-TR*          AND CH.ACCOUNT_NO = AT.ACCOUNT_NO                      43527000
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 6991                                                   
MFA-TR*    END-EXEC.                                                    43528000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43529000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 43529300
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE LOW-VALUES            TO WS-CPD99-DATE-SVC-END  
               WHEN OTHER                                               
                   MOVE SQLCODE               TO WS-CPD99-RETURN-CODE   
                   MOVE SPACES                TO ABEND-FILE             
                   MOVE '6991'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ACCOUNT'         TO TABLE-1                
                   MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-2                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE WS-CPD99-PREMISE-NO   TO HOSTVAR-ELEMENT-1      
                   PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT      
           END-EVALUATE.                                                
      *                                                                 43110000
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                      AND WS-CPD99-NULL-IND NOT EQUAL -1)               
              EXEC SQL                                                  
                  SELECT CH.ACCOUNT_NO                                  
                    INTO :WS-CPD99-ACCOUNT-NO                           
                    FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)            
                        ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)            
                   WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO   
                     AND AT.PREMISE_NO         = CH.PREMISE_NO          
                     AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO          
                     AND CH.DATE_UTIL_SVC_END  = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) ) 
                                                                 
                                                             
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                  43532000
MFA-TR*           SELECT CH.ACCOUNT_NO                                  43540000
MFA-TR*             INTO :WS-CPD99-ACCOUNT-NO                           43550000
MFA-TR*             FROM CSS_CUST_PREM_HIST CH                          43560000
MFA-TR*                 ,CSS_ACCOUNT        AT                          43561000
MFA-TR*            WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO   43570000
MFA-TR*              AND AT.PREMISE_NO         = CH.PREMISE_NO          43580000
MFA-TR*              AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO          43600000
MFA-TR*              AND CH.DATE_UTIL_SVC_END  = :WS-CPD99-DATE-SVC-END 43610000
MFA-TR*              WITH UR                                                    
MFA-TR*              QUERYNO 699                                                
MFA-TR*       END-EXEC                                                  43680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43690000
              MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE  
      *                                                                 43690000
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                  WHEN NOT-FOUND                                        
                      CONTINUE                                          
                  WHEN WS-CPD99-DUP-ROWS                                
                      PERFORM 6992-GET-MAX-FINAL-DATE THRU 6992-EXIT    
                  WHEN OTHER                                            
                      MOVE SQLCODE               TO WS-CPD99-RETURN-CODE
                      MOVE SPACES                TO ABEND-FILE          
                      MOVE '6991'                TO ACTIVE-PARAGRAPH    
                      MOVE 'SELECT'              TO ABEND-FUNCTION      
                      MOVE 'CSS_ACCOUNT'         TO TABLE-1             
                      MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-2             
                      MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1     
T22243                MOVE 'DATE_UTIL_SVC_END'   TO TABLE-ELEMENT-2     
                      MOVE WS-CPD99-PREMISE-NO   TO HOSTVAR-ELEMENT-1   
T22243                MOVE WS-CPD99-DATE-SVC-END TO HOSTVAR-ELEMENT-2   
                      PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT   
               END-EVALUATE                                             
           END-IF.                                                      
      *                                                                 43870000
       6991-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43110000
      ******************************************************************42780000
      * 6992-GET-MAX-FINAL-DATE                                        *42790000
      *                                                                *42820000
      *     CALLED FROM 6991-MAX-END-DATE                              *42830000
      *                                                                *42840000
      *     MAX ACCT_FINALED_DT AT PREMISE                             *42850000
      ******************************************************************42860000
      *                                                                 42870000
       6992-GET-MAX-FINAL-DATE.                                         
      *                                                                 43110000
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           AT.ACCT_FINALED_DT), 121), ' ', '-'), ':', '.')                     
C30397          INTO :WS-CPD99-MAX-AT-FINAL-DT :WS-CPD99-NULL-IND        
                FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
                    ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
               WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO       
                 AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO              
                 AND CH.DATE_UTIL_SVC_END  = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) )     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     43919100
MFA-TR*       SELECT MAX(AT.ACCT_FINALED_DT)                            43919200
MFA-TR*         INTO :WS-CPD99-MAX-AT-FINAL-DT:WS-CPD99-NULL-IND        43919300
MFA-TR*         FROM CSS_CUST_PREM_HIST CH                              43919400
MFA-TR*             ,CSS_ACCOUNT        AT                              43919500
MFA-TR*        WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO       43919601
MFA-TR*          AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO              43919800
MFA-TR*          AND CH.DATE_UTIL_SVC_END  = :WS-CPD99-DATE-SVC-END     43919902
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 6992                                                   
MFA-TR*    END-EXEC.                                                    43920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43920100
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 43920300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                   TO WS-CPD99-RETURN-CODE   
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '6992'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'CSS_CUST_PREM_HIST'      TO TABLE-2                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
T22243         MOVE 'DATE_UTIL_SVC_END'       TO TABLE-ELEMENT-2        
               MOVE WS-CPD99-PREMISE-NO       TO HOSTVAR-ELEMENT-1      
T22243         MOVE WS-CPD99-DATE-SVC-END     TO HOSTVAR-ELEMENT-2      
               PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT          
           END-IF.                                                      
      *                                                                 43922000
C30397     IF WS-CPD99-NULL-IND EQUAL -1                                
C30397         PERFORM 6993-GET-MAX-CREATE-DATE THRU 6993-EXIT          
C30397     ELSE                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              EXEC SQL                                                  
                 SELECT CH.ACCOUNT_NO                                   
                   INTO :WS-CPD99-ACCOUNT-NO                            
                   FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)             
                       ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)             
                  WHERE CH.PREMISE_NO        = :WS-CPD99-PREMISE-NO     
                    AND AT.PREMISE_NO        = CH.PREMISE_NO            
                    AND CH.ACCOUNT_NO        = AT.ACCOUNT_NO            
                    AND CH.DATE_UTIL_SVC_END = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) )   
                    AND AT.ACCT_FINALED_DT   = CIS.CHAR2TIMESTAMP(
                                              :WS-CPD99-MAX-AT-FINAL-DT
              )
                                                                 
                                                              
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                  43913700
MFA-TR*          SELECT CH.ACCOUNT_NO                                   43913800
MFA-TR*            INTO :WS-CPD99-ACCOUNT-NO                            43914000
MFA-TR*            FROM CSS_CUST_PREM_HIST CH                           43914200
MFA-TR*                ,CSS_ACCOUNT        AT                           43914300
MFA-TR*           WHERE CH.PREMISE_NO        = :WS-CPD99-PREMISE-NO     43914400
MFA-TR*             AND AT.PREMISE_NO        = CH.PREMISE_NO            43914500
MFA-TR*             AND CH.ACCOUNT_NO        = AT.ACCOUNT_NO            43914700
MFA-TR*             AND CH.DATE_UTIL_SVC_END = :WS-CPD99-DATE-SVC-END   43914800
MFA-TR*             AND AT.ACCT_FINALED_DT   = :WS-CPD99-MAX-AT-FINAL-DT        
MFA-TR*             WITH UR                                                     
MFA-TR*             QUERYNO 69                                                  
MFA-TR*       END-EXEC                                                  43915000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43915100
              MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE 
      *                                                                 43915400
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                      CONTINUE                                          
                  WHEN WS-CPD99-DUP-ROWS                                
                      PERFORM 6993-GET-MAX-CREATE-DATE THRU 6993-EXIT   
                  WHEN OTHER                                            
                      MOVE SQLCODE             TO WS-CPD99-RETURN-CODE  
                      MOVE SPACES              TO ABEND-FILE            
                      MOVE '6992'              TO ACTIVE-PARAGRAPH      
                      MOVE 'SELECT'            TO ABEND-FUNCTION        
                      MOVE 'CSS_ACCOUNT'       TO TABLE-1               
                      MOVE 'CSS_CUST_PREM_HIST' TO TABLE-2              
                      MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1      
T22243                MOVE 'DATE_UTIL_SVC_END'  TO TABLE-ELEMENT-2      
T22243                MOVE 'ACCT_FINALED_DT'    TO TABLE-ELEMENT-3      
                      MOVE WS-CPD99-PREMISE-NO  TO HOSTVAR-ELEMENT-1    
T22243                MOVE WS-CPD99-DATE-SVC-END TO HOSTVAR-ELEMENT-2   
T22243                MOVE WS-CPD99-MAX-AT-FINAL-DT TO HOSTVAR-ELEMENT-3
                      PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT   
              END-EVALUATE                                              
C30397     END-IF                                                       
           END-IF.                                                      
      *                                                                 43917500
       6992-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43110000
      ******************************************************************42780000
      * 6993-GET-MAX-CREATE-DATE                                       *42790000
      *                                                                *42820000
      *     CALLED FROM 6992-GET-MAX-END-DATE                          *42830000
      *                                                                *42840000
      *     MAX ACCT_CREATE_DT AT PREMISE                              *42850000
      ******************************************************************42860000
      *                                                                 42870000
       6993-GET-MAX-CREATE-DATE.                                        
      *                                                                 43110000
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           AT.ACCT_CREATE_DT), 121), ' ', '-'), ':', '.')                      
                INTO :WS-CPD99-MAX-AT-CREATE-DT                         
                FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
                    ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
               WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO       
                 AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO              
                 AND CH.DATE_UTIL_SVC_END  = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) )     
                 AND AT.ACCT_FINALED_DT    = CIS.CHAR2TIMESTAMP(
                                             :WS-CPD99-MAX-AT-FINAL-DT 
                                                     :WS-CPD99-NULL-IND
              )      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     43919100
MFA-TR*       SELECT MAX(AT.ACCT_CREATE_DT)                             43919200
MFA-TR*         INTO :WS-CPD99-MAX-AT-CREATE-DT                         43919300
MFA-TR*         FROM CSS_CUST_PREM_HIST CH                              43919400
MFA-TR*             ,CSS_ACCOUNT        AT                              43919500
MFA-TR*        WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO       43919601
MFA-TR*          AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO              43919800
MFA-TR*          AND CH.DATE_UTIL_SVC_END  = :WS-CPD99-DATE-SVC-END     43919902
MFA-TR*          AND AT.ACCT_FINALED_DT    = :WS-CPD99-MAX-AT-FINAL-DT  43914900
MFA-TR*                                         :WS-CPD99-NULL-IND              
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 6993                                                   
MFA-TR*    END-EXEC.                                                    43920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43920100
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 43920300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                   TO WS-CPD99-RETURN-CODE   
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '6993'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'CSS_CUST_PREM_HIST'      TO TABLE-2                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
T22243         MOVE 'DATE_UTIL_SVC_END'       TO TABLE-ELEMENT-2        
T22243         MOVE 'ACCT_FINALED_DT'         TO TABLE-ELEMENT-3        
               MOVE WS-CPD99-PREMISE-NO       TO HOSTVAR-ELEMENT-1      
T22243         MOVE WS-CPD99-DATE-SVC-END     TO HOSTVAR-ELEMENT-2      
T22243         MOVE WS-CPD99-MAX-AT-FINAL-DT  TO HOSTVAR-ELEMENT-3      
               PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT          
           END-IF.                                                      
      *                                                                 43922000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EXEC SQL                                                  
                 SELECT CH.ACCOUNT_NO                                   
                   INTO :WS-CPD99-ACCOUNT-NO                            
                   FROM CSS_CUST_PREM_HIST CH                           
                       ,CSS_ACCOUNT        AT                           
                  WHERE CH.PREMISE_NO        = :WS-CPD99-PREMISE-NO     
                    AND AT.PREMISE_NO        = CH.PREMISE_NO            
                    AND CH.ACCOUNT_NO        = AT.ACCOUNT_NO            
                    AND CH.DATE_UTIL_SVC_END = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) )   
                    AND AT.ACCT_CREATE_DT = CIS.CHAR2TIMESTAMP(
                                             :WS-CPD99-MAX-AT-CREATE-DT
              )  
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                  43913700
MFA-TR*          SELECT CH.ACCOUNT_NO                                   43913800
MFA-TR*            INTO :WS-CPD99-ACCOUNT-NO                            43914000
MFA-TR*            FROM CSS_CUST_PREM_HIST CH                           43914200
MFA-TR*                ,CSS_ACCOUNT        AT                           43914300
MFA-TR*           WHERE CH.PREMISE_NO        = :WS-CPD99-PREMISE-NO     43914400
MFA-TR*             AND AT.PREMISE_NO        = CH.PREMISE_NO            43914500
MFA-TR*             AND CH.ACCOUNT_NO        = AT.ACCOUNT_NO            43914700
MFA-TR*             AND CH.DATE_UTIL_SVC_END = :WS-CPD99-DATE-SVC-END   43914800
MFA-TR*             AND AT.ACCT_CREATE_DT = :WS-CPD99-MAX-AT-CREATE-DT  43914900
MFA-TR*       END-EXEC                                                  43915000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43915100
              MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE  
      *                                                                 43915400
              IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
              ELSE                                                      
                  MOVE SQLCODE                TO WS-CPD99-RETURN-CODE   
                  MOVE SPACES                 TO ABEND-FILE             
                  MOVE '6993'                 TO ACTIVE-PARAGRAPH       
                  MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_ACCOUNT'          TO TABLE-1                
                  MOVE 'CSS_CUST_PREM_HIST'   TO TABLE-2                
                  MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1        
T22243            MOVE 'DATE_UTIL_SVC_END'    TO TABLE-ELEMENT-2        
T22243            MOVE 'ACCT_CREATE_DT'       TO TABLE-ELEMENT-3        
                  MOVE WS-CPD99-PREMISE-NO    TO HOSTVAR-ELEMENT-1      
T22243            MOVE WS-CPD99-DATE-SVC-END  TO HOSTVAR-ELEMENT-2      
T22243            MOVE WS-CPD99-MAX-AT-CREATE-DT TO HOSTVAR-ELEMENT-3   
                  PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 43917500
       6993-EXIT.                                                       
           EXIT.                                                        
      * END HARD CODE OF COPY BOOK CPD99                                43110000
      *                                                                         
      ***************************************************************** 09060000
      ** 6251-GET-FJC01-DATE                                         ** 09070000
      ***************************************************************** 09080000
      *                                                                 09090000
       COPY CPD00037.                                                   09100000
      *                                                                 09110000
       COPY CPD00040.                                                   09120000
      *                                                                 09130000
      ***************************************************************** 09220000
      ** 7600-START-FCJ01                                            ** 09230000
      ***************************************************************** 09240000
      *                                                                 09250000
           EXEC SQL                                                     09260000
               INCLUDE CPD00039                                         09270000
           END-EXEC.                                                    09280000
      *                                                                 09210000
      ***************************************************************** 09220000
      ** 7999-SELECT-AL                                              ** 09230000
      ***************************************************************** 09240000
      *                                                                 09210000
           EXEC SQL                                                     09290300
               INCLUDE CPD00075                                         09290400
           END-EXEC.                                                    09290500
      *                                                                 09250000
      ******************************************************************        
      * 8000-WRITE-FCA320.                                             *        
      ******************************************************************        
       8000-WRITE-FCA320.                                               
      *                                                                         
           WRITE FIOC320-REC.                                           
      *                                                                         
           IF C320-SUCCESSFUL                                           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSXP320 PROCESSING ERROR   **'           
               DISPLAY '**   WRITE FCSC320-FILE IS FAILED **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               DISPLAY ' FILE-STATUS = ' WS-C320-STATUS                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  05160000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  05170000
      **  *RETRIEVE COMMIT COUNT DETAILS FROM JOB PARM TABLE.        *  05170000
      ****************************************************************  05180000
      *                                                                         
            EXEC SQL                                                    05190000
                INCLUDE CPD00034                                        05200000
            END-EXEC.                                                   05210000
      *                                                                 05220000
      *----------------------------------------------------------------*        
      * SELECT CSS_JOB_PARM TABLE                                      *        
      * 7600-, 7610-,7611- PARAGRAPHS                                  *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC                                                             
      *                                                                         
      ************************************************************      05470000
      **  8200-INSERT-ARCHIEVE                                  **      05480000
      **      INSERTS ARCHEIVE DATA                             **      05490000
      **                                                        **      05500000
      ************************************************************      05510000
      *                                                                 05520000
       8200-INSERT-ARCHIEVE.                                            
           EXEC SQL                                                     
                INSERT INTO CSS_ARCHIVE_FCST                            
                  (ACCOUNT_NO,                                          
                   FORECAST_TYPE_CD,                                    
                   FORECAST_REASON_CD,                                  
                   FORECAST_DT,                                         
                   LAST_UPDATE_TS,                                      
                   LAST_UPDATE_USERID,                                  
                   REMARKS,                                             
                   ACCT_FINALED_DT)                                     
                VALUES                                                  
                   (:AZ-ACCOUNT-NO,                                     
                    :AZ-FORECAST-TYPE-CD,                               
                    :AZ-FORECAST-REASON-CD,                             
                    IIF(TRY_CONVERT(DATE, :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) ),                             
                    CIS.CHAR2TIMESTAMP(:AZ-LAST-UPDATE-TS),                     
                    :AZ-LAST-UPDATE-USERID,                             
                    :AZ-REMARKS,                                        
                    CIS.CHAR2TIMESTAMP(:AZ-ACCT-FINALED-DT))                    
                END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15630000
MFA-TR*         INSERT INTO CSS_ARCHIVE_FCST                            15640000
MFA-TR*           (ACCOUNT_NO,                                          15650000
MFA-TR*            FORECAST_TYPE_CD,                                    15660000
MFA-TR*            FORECAST_REASON_CD,                                  15670000
MFA-TR*            FORECAST_DT,                                         15680000
MFA-TR*            LAST_UPDATE_TS,                                      15710000
MFA-TR*            LAST_UPDATE_USERID,                                  15740000
MFA-TR*            REMARKS,                                             15791000
MFA-TR*            ACCT_FINALED_DT)                                             
MFA-TR*         VALUES                                                  15930000
MFA-TR*            (:AZ-ACCOUNT-NO,                                     15940000
MFA-TR*             :AZ-FORECAST-TYPE-CD,                               15950000
MFA-TR*             :AZ-FORECAST-REASON-CD,                             15960000
MFA-TR*             :AZ-FORECAST-DT,                                    16081000
MFA-TR*             :AZ-LAST-UPDATE-TS,                                 15970000
MFA-TR*             :AZ-LAST-UPDATE-USERID,                             16000000
MFA-TR*             :AZ-REMARKS,                                        16030000
MFA-TR*             :AZ-ACCT-FINALED-DT)                                16030000
MFA-TR*         END-EXEC.                                               16220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACCOUNT-NO TO  E-FCA320-ACCOUNT-NO                
              MOVE 'AZ' TO E-FCA320-TABLE-ID                            
              MOVE 'I' TO  E-FCA320-ACTION                              
              MOVE  AZ-FORECAST-REASON-CD TO E-FCA320-FLAG              
              MOVE  AZ-FORECAST-TYPE-CD   TO E-FCA320-ERRFL             
              PERFORM 8000-WRITE-FCA320 THRU 8000-EXIT                  
              COMPUTE WS-INS-ACCT-TOTAL = WS-INS-ACCT-TOTAL + 1         
              IF AZ-FORECAST-TYPE-CD = 'E'                              
               ADD 1 TO WS-FCST-ERR-COUNT                               
              END-IF                                                    
                                                                        
              IF AZ-FORECAST-TYPE-CD = 'R'                              
                ADD 1 TO WS-FCST-REV-COUNT                              
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '** PCSXP320 PROCESSING ERROR        **'          
              DISPLAY '** ERROR IN INSERT                  **'          
              DISPLAY '** ACCOUNT NO **'   WS-ACCOUNT-NO                
              DISPLAY '** PARA 8200-INSERT-ARCHIEVE        **'          
              DISPLAY '** SQLCODE IS  ** ' WS-DISPLAY-SQLCODE           
              DISPLAY '** PROCESSING TERMINATED            **'          
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
       8200-EXIT.                                                       
            EXIT.                                                       
      *----------------------------------------------------------------*        
      *                                                                         
      ************************************************************      05470000
      **  8300-INSERT-EXEMPT                                    **      05480000
      **      UPDATES ARCHEIVE FORECAST FLAG                    **      05490000
      **                                                        **      05500000
      ************************************************************      05510000
      *                                                                 05520000
       8300-INSERT-EXEMPT.                                              
           MOVE WS-ARCHIVE-EXEMPT-CD TO AA-ARCHIVE-EXEMPT-CD            
           MOVE AT-ACCOUNT-NO  TO AA-ACCOUNT-NO                         
           MOVE 'XP320' TO AA-LAST-UPDATE-USERID                        
           MOVE WS-CURRENT-TIMESTAMP TO AA-LAST-UPDATE-TS               
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_ARCHIVE_EXEMPT                          
                 (ACCOUNT_NO                                            
                 ,ARCHIVE_EXEMPT_CD                                     
                 ,LAST_UPDATE_USERID                                    
                 ,LAST_UPDATE_TS                                        
                  )                                                     
                  VALUES                                                
                  (                                                     
                   :AA-ACCOUNT-NO                                       
                  ,:AA-ARCHIVE-EXEMPT-CD                                
                  ,:AA-LAST-UPDATE-USERID                               
                  ,CIS.CHAR2TIMESTAMP(:AA-LAST-UPDATE-TS)                       
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15630000
MFA-TR*         INSERT INTO CSS_ARCHIVE_EXEMPT                                  
MFA-TR*          (ACCOUNT_NO                                                    
MFA-TR*          ,ARCHIVE_EXEMPT_CD                                             
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*           )                                                             
MFA-TR*           VALUES                                                15640000
MFA-TR*           (                                                             
MFA-TR*            :AA-ACCOUNT-NO                                               
MFA-TR*           ,:AA-ARCHIVE-EXEMPT-CD                                        
MFA-TR*           ,:AA-LAST-UPDATE-USERID                                       
MFA-TR*           ,:AA-LAST-UPDATE-TS                                           
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                    16220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO WS-EXEMPTION-COUNT                               
              MOVE AT-ACCOUNT-NO TO  E-FCA320-ACCOUNT-NO                
              MOVE 'AA' TO E-FCA320-TABLE-ID                            
              MOVE 'I' TO  E-FCA320-ACTION                              
              MOVE  WS-ARCHIVE-EXEMPT-CD TO E-FCA320-FLAG               
              MOVE  SPACES               TO E-FCA320-ERRFL              
              PERFORM 8000-WRITE-FCA320 THRU 8000-EXIT                  
              COMPUTE WS-UPD-ACCT-TOTAL = WS-UPD-ACCT-TOTAL + 1         
              PERFORM 8310-UPD-TRANS-HIST THRU 8310-EXIT                
              PERFORM 8320-DEL-ARCH-FORCST THRU 8320-EXIT               
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '** PCSXP320 PROCESSING ERROR        **'          
              DISPLAY '** ERROR IN INSERT                 **'           
              DISPLAY '** ACCOUNT NO **'   WS-DISPLAY-ACCOUNT           
              DISPLAY '** PARA 8300-INSERT-EXEMPT         **'           
              DISPLAY '** SQLCODE IS  ** ' WS-DISPLAY-SQLCODE           
              DISPLAY '** PROCESSING TERMINATED            **'          
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
       8300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *                                                                 05510000
       8310-UPD-TRANS-HIST.                                             
      ************************************************************      05470000
      **  8310-UPD-TRANS-HIST                                   **      05480000
      **      ADD ROWS TO MAINT TRANS HIST AND DETAIL TABLE     **      05490000
      **                                                        **      05500000
      ************************************************************      05510000
      *                                                                         
           MOVE '8310'                       TO ACTIVE-PARAGRAPH.       
      *                                                                         
           PERFORM 7050-SELECT-TIMESTAMP THRU 7050-EXIT                 
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO     
                                               MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE SPACES                      TO MH-RESP-AREA-ID.         
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-SYSTEM                   TO MH-USER-ID.              
           MOVE PROGRAM-NAME                TO MH-APPL-PROGRAM-ID.      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE +1                          TO MI-TRAN-APPL-NO.         
      *                                                                         
           MOVE 'ARCHIVE EXEMPT'        TO MI-COLUMN-DESC               
           MOVE 1                       TO MI-PRV-COLUMN-VALUE-LEN      
           MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT     
           MOVE  5                      TO MI-CHG-COLUMN-VALUE-LEN      
           MOVE WS-ARCHIVE-EXEMPT-CD    TO MI-CHG-COLUMN-VALUE-TEXT     
      *                                                                         
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                 05520000
       8310-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8320-DEL-ARCH-FORCST.                                            
      ************************************************************      05470000
      **  8320-DEL-ARCH-FORCST                                  **      05480000
      **      DEL ROWS IN ARCHIEVE FCT TABLE AFTER INSERTING    **      05490000
      **      IN CSS_ARCHIVE_EXEMPT                             **      05490000
      **                                                        **      05500000
      ************************************************************      05510000
      *                                                                         
           MOVE AT-ACCOUNT-NO TO AZ-ACCOUNT-NO                          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_ARCHIVE_FCST                            
                 WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                     
                 AND LAST_UPDATE_TS > CIS.CHAR2TIMESTAMP(
              '2010-01-01-01.00.00.000000')      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_ARCHIVE_FCST                                    
MFA-TR*          WHERE  ACCOUNT_NO = :AZ-ACCOUNT-NO                             
MFA-TR*          AND LAST_UPDATE_TS > '2010-01-01-01.00.00.000000'              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
             DISPLAY '********** PCSXP320 ABORT  ************'          
             DISPLAY '* 8320-DEL-ARCH-FORCST                *'          
             DISPLAY '* SQLCODE IS: '  WS-ACTIVE-RETURN-CODE            
             DISPLAY '* AZ-ACCOUNT-NO        =' AZ-ACCOUNT-NO           
             DISPLAY '* PROGRAM ABORTING...                 *'          
             DISPLAY '********** PCSXP320  ABORT ************'          
             PERFORM 9900-ABEND THRU 9900-EXIT                          
           END-IF.                                                      
      *                                                                         
       8320-EXIT.                                                       
            EXIT.                                                       
      *                                                                 08740000
      *******************************************************           08740101
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                 08741001
      ****************************************************************  08750000
      **                                                            **  08760000
      **   9000-TERMINATE.                                          **  08770000
      **       IF PROCESS ABENDS ROLLS BACK ON CHANGES TO DB  &     **  08780000
      **       CLOSES ALL FILES.                                    **  08790000
      ****************************************************************  08800000
      *                                                                 08810000
       9000-TERMINATE.                                                  
      *                                                                 08830000
           CLOSE FCSC320-FILE.                                          
      *                                                                 08890000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08920000
      ***************************************************************** 09300000
      ** 9700-PROCESS-ABEND.                                         ** 09310000
      ***************************************************************** 09320000
      *                                                                 09330000
       COPY CPD0023B.                                                   09340000
      *                                                                 09350000
      ****************************************************************  08533700
      **                                                            **  08533800
      **   9100-TERMINATE.                                          **  08533900
      **       IF PROCESS RUNS THRU OKAY COMMIT'S CHANGES TO DB &   **  08534000
      **       CLOSES ALL FILES.                                    **  08535000
      ****************************************************************  08536000
      *                                                                 08537000
       9100-TERMINATE.                                                  
      *                                                                 08539000
           PERFORM 7006-CLOSE-ACCOUNT-CURSOR THRU 7006-EXIT             
           MOVE WS-PROCESSED-COUNT TO WS-DISPLAY-COUNT                  
           DISPLAY 'ACCOUNTS PROCESSED ' WS-DISPLAY-COUNT               
           MOVE WS-FCST-ERR-COUNT TO WS-DISPLAY-COUNT                   
           DISPLAY 'ACCOUNTS FORECASTED FOR ERROR ' WS-DISPLAY-COUNT    
           MOVE WS-FCST-REV-COUNT TO WS-DISPLAY-COUNT                   
           DISPLAY 'ACCOUNTS FORECASTED FOR REVIEW ' WS-DISPLAY-COUNT   
           MOVE WS-EXEMPTION-COUNT TO WS-DISPLAY-COUNT                  
           DISPLAY 'ACCOUNTS EXEMPTED FROM ARCHIVE ' WS-DISPLAY-COUNT.  
      *                                                                 08580000
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09350100
       9900-SQL-ERROR-ROUTINE.                                          
           GO TO 9900-EXIT.                                             
      *                                                                 09351000
      **************************************************************    09360000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    09370000
      ***************************************************************** 09300000
      ** 9900-ABEND.                                                 ** 09310000
      ***************************************************************** 09320000
      *                                                                 09330000
           EXEC SQL                                                     09400000
                INCLUDE CPD09900                                        09410000
           END-EXEC.                                                    09420000
      *                                                                         
      ******************************************************************        
      *  COPYBOOK TO INSERT DATA INTO 6530-LOAD-MNT-TRANS-HIST         *        
      ******************************************************************        
           EXEC SQL                                                     09400000
                INCLUDE CPD00067                                        09410000
           END-EXEC.                                                    09420000
      ******************************************************************09430000
