       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP301.                                           
       DATE-WRITTEN.  25 NOV 2008                                       
       DATE-COMPILED.                                                   
       AUTHOR.   MADHAVI CH.                                            
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      **                                                             *          
      ** DATE       INITIALS       REASON                            *          
      ** 11/25/08  MC95456          APPL37648-ACT 11, 12, 13,14 & 15 *          
      ** 12/12/09  SP94986          APPL37648-ACT 72 - CONTRACT TYPE *          
      **                            'F' (SERVICE CARE TYPE) RECORDS  *          
      **                            WITH NO BALANCE IN AR CAN BE DELT*          
ACT074** 07/25/12  MC95456          APPL3967-ACT 74 - CONTRACT SHOULD*          
ACT074**                            BE DELETED WHEN SUMM_CNT_ID = 0  *          
ACT074**                            (NON-MSE CONTRACTS)              *          
ACT040** 02/12/14  BD09555          REMOVE CSS_BUDGET_PAYMENT A04880 *          
ACT040**                                                             *          
ACT278** 09/21/16  TP7R341          REMOVE UNWANTED COLUMN FROM      *          
ACT278**  A05460                    CONTRACT TABLE                   *          
      ****************************************************************          
      *                   PCSXP301   NARRATIVE                       *          
      * THIS PROGRAM PURGES DATA FROM THE FOLLOWING TABLES USING THE *          
      * CSS_CIS_PURGE_TABLE.                                         *          
      **  1. CSS_BUDGET_HIST                                         *          
      **  2. CSS_CONTRACT                                            *          
      **  3. CSS_DFA_ACCT                                            *          
      **  4. CSS_PROJ_SHARE                                          *          
      *         PER THE RULES IN THE INDIVIDUAL CURSORS              *          
      * COMMITS ARE TAKEN                                            *          
      * FOR LAST RUN DATE THE ACCOUNT NO AND PURGE DATE ALONG        *          
      * WITH RULES IN THE INDIVIDUAL CURSORS ARE USED TO DETERMINE   *          
      * THE DATA TO BE PURGED.                                       *          
      * THE CSS_JOB_PARM TABLE HAS AN ENTRY FOR EACH TABLE AND IN    *          
      * ORDER TO BE PROCESSED, THE STATUS ON THE JOB PARM TABLE      *          
      * MUST BE = 'A' (ACTIVE). TO STOP PURGING FROM A PARTICULAR    *          
      * TABLE, THE JOB PARM STATUS SHOULD BE SET TO 'I'              *          
      *                                                              *          
      *  CSS_CONTRACT -                                              *          
      *         ( CONTRACT TYPES 'C','D','E','G','H','P','F')        *          
      *           AND NO BALANCE IN CSS_AR_CNTL )                    *          
      *                                                              *          
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM   *          
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)            *          
      *                                                              *          
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START -          *          
      * RESTART IS NOT NEEDED                                        *          
      *                                                              *          
      * COMMITS ARE TAKEN                                            *          
      ****************************************************************          
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP301'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-COMMIT-COUNT             PIC 9(9)  VALUE ZEROS.       
           05  WS-1000                     PIC 9(4)  VALUE 1000.        
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
           05  WS-LAST-RUN-TIMESTAMP.                                   
               10 WS-LAST-TS-TXT           PIC X(20) VALUE              
                                           'LAST RUN TIME STAMP='.      
               10 WS-LAST-RUN-TS           PIC X(26) VALUE SPACES.      
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-PURGE-DT                 PIC X(10) VALUE SPACES.      
           05  WS-BGTHIST-B-CNT            PIC 9(9)  VALUE ZEROS.       
           05  WS-BGTHIST-B-CMT            PIC 9(9)  VALUE ZEROS.       
           05  WS-CONTRACT-B-CNT           PIC 9(9)  VALUE ZEROS.       
           05  WS-CONTRACT-B-CMT           PIC 9(9)  VALUE ZEROS.       
           05  WS-DFAACT-B-CNT             PIC 9(9)  VALUE ZEROS.       
           05  WS-DFAACT-B-CMT             PIC 9(9)  VALUE ZEROS.       
           05  WS-PRJSHR-B-CNT             PIC 9(9)  VALUE ZEROS.       
           05  WS-PRJSHR-B-CMT             PIC 9(9)  VALUE ZEROS.       
           05  WS-BGTPYMT-B-CNT            PIC 9(9)  VALUE ZEROS.       
           05  WS-BGTPYMT-B-CMT            PIC 9(9)  VALUE ZEROS.       
      *                                                                         
           05  WS-PGRMNAME                 PIC X(8)  VALUE 'PCSXP301'.  
      *                                                                         
           05  WS-BGTHIST-DEL              PIC X(01) VALUE 'N'.         
               88 BGTHIST-DEL                        VALUE 'Y'.         
           05  WS-CONTRACT-DEL             PIC X(01) VALUE 'N'.         
               88 CONTRACT-DEL                       VALUE 'Y'.         
           05  WS-DFAACT-DEL               PIC X(01) VALUE 'N'.         
               88 DFAACT-DEL                         VALUE 'Y'.         
           05  WS-PRJSHR-DEL               PIC X(01) VALUE 'N'.         
               88 PRJSHR-DEL                         VALUE 'Y'.         
           05  WS-BGTPYMT-DEL              PIC X(01) VALUE 'N'.         
               88 BGTPYMT-DEL                        VALUE 'Y'.         
           05  WS-NO-MORE-RECORDS          PIC X(01) VALUE 'N'.         
               88 NO-MORE-RECORDS                    VALUE 'Y'.         
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      ****************************************************************          
      *  CSS_CIS_PURGE     PU                                        *          
      ****************************************************************          
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPURGE                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_BUDGET_HIST   BH                                        *          
      ****************************************************************          
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBGTHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_CONTRACT      CT                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_DFA_ACCT  DA                                                       
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_PROJ_SHARE      PJ                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPRJSHR                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ****************************************************************          
      **  CSS_JOB_PARM                                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      ****************************************************************          
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'               *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                       *          
      ****************************************************************          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
       COPY CWSPURGE.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
      ****************************************************************          
      * CURSOR DECLARATION TO SELECT THE RECORDS FROM CSS_CIS_PURGE             
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE  CIS_PURGE_B     CURSOR WITH HOLD FOR            
                SELECT  PU.ACCOUNT_NO                                   
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), PU.PURGE_TS
           , 121), ' ', '-'), ':', '.') PURGE_TS                               
                  FROM  CSS_CIS_PURGE    PU WITH(READUNCOMMITTED)               
                  WHERE PU.LAST_UPDATE_TS  >= CIS.CHAR2TIMESTAMP(
                                                     :PU-LAST-UPDATE-TS
              )        
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE  CIS_PURGE_B     CURSOR WITH HOLD FOR                    
MFA-TR*         SELECT  PU.ACCOUNT_NO                                           
MFA-TR*                ,PU.PURGE_TS                                             
MFA-TR*           FROM  CSS_CIS_PURGE    PU                                     
MFA-TR*           WHERE PU.LAST_UPDATE_TS  >= :PU-LAST-UPDATE-TS                
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * PROCEDURE DIVISION                                                      
      ****************************************************************          
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-GET-PARM-DATA          THRU 0100-EXIT.          
      *                                                                         
           PERFORM 1000-PROCESS-PTYPE-B-RECORDS THRU 1000-EXIT.         
      *                                                                         
           PERFORM 2000-PRINT-TOTALS            THRU 2000-EXIT.         
           PERFORM 3000-UPDATE-LAST-RUN-TS      THRU 3000-EXIT.         
      *                                                                         
           DISPLAY '*********PROCESS COMPLETED SUCCESSFULLY*********'   
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * GET NUMBER OF MONTHS FROM CSS_JOB_PARM                       *          
      ****************************************************************          
      *                                                                         
       0100-GET-PARM-DATA.                                              
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           INITIALIZE WS-SYSIPT.                                        
                                                                        
           PERFORM 7600P-START-FCSJC01        THRU 7600P-EXIT.          
           PERFORM 0125-READ-FCSJC01          THRU 0125-EXIT.           
           PERFORM 7611P-CLOSE                THRU 7611P-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ MONTHS FROM CSS_JOB_PARM                       *                   
      ****************************************************************          
       0125-READ-FCSJC01.                                               
      *                                                                         
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD=')               
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD='               
              AND INPUT-ACTIVE                                          
                 MOVE WS-INPUT-DATA-BREAKDOWN(10:4) TO WS-CHKP-UPD-LIMIT
           ELSE                                                         
              MOVE WS-DEFAULT-CHKP-UPD-LIMIT  TO WS-CHKP-UPD-LIMIT      
              DISPLAY '**JOB PARM NOT ACTIVE FOR CHKP-UPD**'            
              DISPLAY '**DEFAULT OF ' WS-CHKP-UPD-LIMIT                 
                      ' WILL BE USED**'                                 
              DISPLAY '**PROCESS CONTINUING**'                          
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
                                                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP=')   
             OR END-OF-SYSIPT.                                          
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP='    
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA(21:26)    TO WS-LAST-RUN-TS          
                 DISPLAY 'LAST RUN TS   : '    WS-LAST-RUN-TS           
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR LAST RUN TIME STAMP'  
                 DISPLAY 'NO RECORDS ARE PROCESSED'                     
                 PERFORM 9900-ABEND          THRU 9900-EXIT             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR LAST RUN TIME STAMP'    
              DISPLAY 'NO RECS ARE PROCESSED FOR LAST RUN TIME STAMP'   
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_BUDGET_HIST   ')     
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BUDGET_HIST   '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-BGTHIST-DEL                
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BUDGET_HIST '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_BUDGET_HIST' 
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_BUDGET_HIST '       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_BUDGET_HIST '      
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT  UNTIL            
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_CONTRACT      ')     
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CONTRACT      '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-CONTRACT-DEL               
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CONTRACT    '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_CONTRACT   ' 
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_CONTRACT    '       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CONTRACT    '      
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT  UNTIL            
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_DFA_ACCT      ')     
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_DFA_ACCT      '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-DFAACT-DEL                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_DFA_ACCT    '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_DFA_ACCT   ' 
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_DFA_ACCT    '       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_DFA_ACCT    '      
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT  UNTIL            
            (WS-INPUT-DATA-BREAKDOWN (1:18) = 'CSS_PROJ_SHARE    ')     
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_PROJ_SHARE    '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-PRJSHR-DEL                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_PROJ_SHARE  '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_PROJ_SHARE ' 
                 DISPLAY '       '                                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_PROJ_SHARE  '       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_PROJ_SHARE  '      
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * PROCESS RECORDS                                              *          
      ****************************************************************          
       1000-PROCESS-PTYPE-B-RECORDS.                                    
      *                                                                         
           MOVE    'N'    TO WS-NO-MORE-RECORDS.                        
      *                                                                         
           MOVE    WS-LAST-RUN-TS                  TO PU-LAST-UPDATE-TS.
      *                                                                         
           PERFORM 7210-OPEN-PURGE-B-CURSOR        THRU 7210-EXIT.      
           PERFORM 7220-FETCH-PURGE-B-CURSOR       THRU 7220-EXIT.      
      *                                                                         
           PERFORM UNTIL NO-MORE-RECORDS                                
                                                                        
              IF BGTHIST-DEL                                            
                 PERFORM 8200-DELETE-BUDGET-HIST   THRU 8200-EXIT       
              END-IF                                                    
      *                                                                         
              IF CONTRACT-DEL                                           
                 PERFORM 8300-DELETE-CSS-CONTRACT       THRU 8300-EXIT  
              END-IF                                                    
      *                                                                         
              IF DFAACT-DEL                                             
                 PERFORM 8400-DELETE-DFA-ACCOUNT        THRU 8400-EXIT  
              END-IF                                                    
      *                                                                         
              IF PRJSHR-DEL                                             
                 PERFORM 8500-DELETE-PROJ-SHARE         THRU 8500-EXIT  
              END-IF                                                    
      *                                                                         
              PERFORM 7220-FETCH-PURGE-B-CURSOR         THRU 7220-EXIT  
      *                                                                         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7230-CLOSE-PURGE-B-CURSOR            THRU 7230-EXIT. 
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      * PRINTS THE TOTAL NO.OF RECORDS DELETED                       *          
      ****************************************************************          
      *                                                                         
       2000-PRINT-TOTALS.                                               
      *                                                                         
           IF BGTHIST-DEL                                               
              DISPLAY '* NO. OF RECORDS DELETED IN *'                   
              DISPLAY '* CSS_BUDGET_HIST    TABLE:  *' WS-BGTHIST-B-CNT 
              DISPLAY '* NO. OF COMMITS FOR *'                          
              DISPLAY '* CSS_BUDGET_HIST    TABLE:  *' WS-BGTHIST-B-CMT 
              DISPLAY '         '                                       
           END-IF.                                                      
      *                                                                         
           IF CONTRACT-DEL                                              
              DISPLAY '* NO. OF RECORDS DELETED IN *'                   
              DISPLAY '* CSS_CONTRACT   TABLE     *' WS-CONTRACT-B-CNT  
              DISPLAY '* NO. OF COMMITS FOR *'                          
              DISPLAY '* CSS_CONTRACT   TABLE     *' WS-CONTRACT-B-CMT  
              DISPLAY '         '                                       
           END-IF.                                                      
      *                                                                         
           IF DFAACT-DEL                                                
              DISPLAY '* NO. OF RECORDS DELETED IN *'                   
              DISPLAY '* CSS_DFA_ACCT       TABLE *' WS-DFAACT-B-CNT    
              DISPLAY '* NO. OF COMMITS FOR *'                          
              DISPLAY '* CSS_DFA_ACCT       TABLE *' WS-DFAACT-B-CMT    
              DISPLAY '         '                                       
           END-IF.                                                      
      *                                                                         
           IF PRJSHR-DEL                                                
              DISPLAY '* NO. OF RECORDS DELETED IN *'                   
              DISPLAY '* CSS_PROJ_SHARE     TABLE *' WS-PRJSHR-B-CNT    
              DISPLAY '* NO. OF COMMITS FOR *'                          
              DISPLAY '* CSS_PROJ_SHARE     TABLE *' WS-PRJSHR-B-CMT    
              DISPLAY '         '                                       
           END-IF.                                                      
      *                                                                         
      *                                                                         
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      * UPDATES LAST RUN TIMESTAMP TO JOBPARM                        *          
      ****************************************************************          
      *                                                                         
       3000-UPDATE-LAST-RUN-TS.                                         
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP  THRU 7500-EXIT.          
           MOVE    WS-CURRENT-TIMESTAMP        TO WS-LAST-RUN-TS.       
           MOVE    WS-LAST-RUN-TIMESTAMP       TO G6-PARM-DATA.         
           PERFORM 8800-UPDATE-LAST-RUN-TS     THRU 8800-EXIT.          
      *                                                                         
       3000-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      **    COPYBOOK  NECESSARY FOR CSS_JOB_PARM PROCESSING          *          
      **    7600P-START-FCSJC01                                       *         
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPDPURGE                                                   
           END-EXEC.                                                            
      ****************************************************************          
      * OPENS BUDGET_HIST    CURSOR                                  *          
      ****************************************************************          
      *                                                                         
       7210-OPEN-PURGE-B-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN  CIS_PURGE_B                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP301 ABORT  ************'         
              DISPLAY '* 7210-OPEN-PURGE-B-CURSOR              *'       
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP301  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES PURGE_B CURSOR                                                  
      ****************************************************************          
      *                                                                         
       7220-FETCH-PURGE-B-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH  CIS_PURGE_B                                       
                INTO  :PU-ACCOUNT-NO                                    
                     ,:PU-PURGE-TS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE PU-PURGE-TS(1:10)     TO WS-PURGE-DT                 
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'               TO WS-NO-MORE-RECORDS           
              ELSE                                                      
                  DISPLAY '********** PCSXP301 ABORT  ************'     
                  DISPLAY '* 7220-FETCH-PURGE-B-CURSOR             *'   
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY 'PU-ACCOUNT-NO'         PU-ACCOUNT-NO         
                  DISPLAY 'PU-PURGE-TS'           PU-PURGE-TS           
                  DISPLAY '********** PCSXP301  ABORT ************'     
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES PURGE-B CURSOR                                        *          
      ****************************************************************          
      *                                                                         
       7230-CLOSE-PURGE-B-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE CIS_PURGE_B                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP301 ABORT  ************'         
              DISPLAY '* 7230-CLOSE-PURGE-B-CURSOR             *'       
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP301  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7500-GET-CURRENT-TIMESTAMP                                              
      ****************************************************************          
      *                                                                         
       7500-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                 DISPLAY '********** PCSXP301 ABORT  ************'      
                 DISPLAY '* 7500-GET-CURRENT-TIMESTAMP          *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP301  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * DELETES RECORDS FROM CSS_BUDGET_HIST                         *          
      ****************************************************************          
      *                                                                         
       8200-DELETE-BUDGET-HIST.                                         
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM BH                           
                FROM CSS_BUDGET_HIST BH
                 WHERE BH.ACCOUNT_NO        =  :PU-ACCOUNT-NO           
                 AND   BH.BUD_HIST_SEQ_NO   <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_BUDGET_HIST  BH                                 
MFA-TR*          WHERE BH.ACCOUNT_NO        =  :PU-ACCOUNT-NO                   
MFA-TR*          AND   BH.BUD_HIST_SEQ_NO   <= :PU-PURGE-TS                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD WS-1 TO WS-BGTHIST-B-CNT                              
              ADD WS-1 TO WS-COMMIT-COUNT                               
              IF WS-COMMIT-COUNT = WS-1000                              
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 DISPLAY 'ACCOUNT NUMBER :   ' PU-ACCOUNT-NO            
                 ADD WS-1 TO WS-BGTHIST-B-CMT                           
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '********** PCSXP301 ABORT  ************'      
                 DISPLAY '* 8200-DELETE-BUDGET-HIST              *'     
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY 'PU-ACCOUNT-NO'         PU-ACCOUNT-NO          
                 DISPLAY 'PU-PURGE-TS'           PU-PURGE-TS            
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP301  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_CONTRACT                            *          
      ****************************************************************          
      *                                                                         
       8300-DELETE-CSS-CONTRACT.                                        
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CT                              
                FROM CSS_CONTRACT CT
                 WHERE CT.ACCOUNT_NO     = :PU-ACCOUNT-NO               
                   AND CT.CODE_CONTRACT_TYPE IN                         
                                     ('C','D','E','G','H','P','F')      
                   AND CT.CNT_STATUS_CD IN                              
                                         ('C','D','E','R')              
                   AND CT.LAST_UPDATE_TS <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )                
                   AND NOT EXISTS                                       
                       (SELECT 1 FROM CSS_AR_CNTL AC                    
                        WHERE AC.ACCOUNT_NO      = CT.ACCOUNT_NO        
                        AND AC.PYMT_PRIORITY_LVL = 100                  
                        AND AC.ITEM_ID           = CT.CNT_ITEM_ID       
                        AND AC.AMT_TRAN_BALANCE  > 0)                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CONTRACT CT                                     
MFA-TR*          WHERE CT.ACCOUNT_NO     = :PU-ACCOUNT-NO                       
MFA-TR*            AND CT.CODE_CONTRACT_TYPE IN                                 
MFA-TR*                              ('C','D','E','G','H','P','F')              
MFA-TR*            AND CT.CNT_STATUS_CD IN                                      
MFA-TR*                                  ('C','D','E','R')                      
MFA-TR*            AND CT.LAST_UPDATE_TS <= :PU-PURGE-TS                        
MFA-TR*            AND NOT EXISTS                                               
MFA-TR*                (SELECT 1 FROM CSS_AR_CNTL AC                            
MFA-TR*                 WHERE AC.ACCOUNT_NO      = CT.ACCOUNT_NO                
MFA-TR*                 AND AC.PYMT_PRIORITY_LVL = 100                          
MFA-TR*                 AND AC.ITEM_ID           = CT.CNT_ITEM_ID               
MFA-TR*                 AND AC.AMT_TRAN_BALANCE  > 0)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD WS-1 TO WS-COMMIT-COUNT                               
              ADD WS-1 TO WS-CONTRACT-B-CNT                             
              IF WS-COMMIT-COUNT = WS-1000                              
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 ADD WS-1 TO WS-CONTRACT-B-CMT                          
                 DISPLAY 'ACCOUNT NUMBER :   ' PU-ACCOUNT-NO            
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '********** PCSXP301 ABORT  ************'      
                 DISPLAY '* 8300-DELETE-CSS-CONTRACT             *'     
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY 'PU-ACCOUNT-NO'        PU-ACCOUNT-NO           
                 DISPLAY 'PU-PURGE-TS'          PU-PURGE-TS             
                 DISPLAY '********** PCSXP301  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_DFA_ACCT                            *          
      ****************************************************************          
      *                                                                         
       8400-DELETE-DFA-ACCOUNT.                                         
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM DA                              
                FROM CSS_DFA_ACCT DA
                 WHERE DA.ACCOUNT_NO     =  :PU-ACCOUNT-NO              
                 AND   DA.CODE_DFA_STATUS IN ('C','R')                  
                 AND   DA.LAST_UPDATE_TS <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )                
                 AND   NOT EXISTS                                       
                       (SELECT 1 FROM CSS_AR_CNTL AC                    
                        WHERE AC.ACCOUNT_NO      = DA.ACCOUNT_NO        
                        AND AC.PYMT_PRIORITY_LVL = 129                  
                        AND AC.ITEM_ID           = DA.DFA_ITEM_ID       
                        AND AC.AMT_TRAN_BALANCE  > 0)                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_DFA_ACCT     DA                                 
MFA-TR*          WHERE DA.ACCOUNT_NO     =  :PU-ACCOUNT-NO                      
MFA-TR*          AND   DA.CODE_DFA_STATUS IN ('C','R')                          
MFA-TR*          AND   DA.LAST_UPDATE_TS <= :PU-PURGE-TS                        
MFA-TR*          AND   NOT EXISTS                                               
MFA-TR*                (SELECT 1 FROM CSS_AR_CNTL AC                            
MFA-TR*                 WHERE AC.ACCOUNT_NO      = DA.ACCOUNT_NO                
MFA-TR*                 AND AC.PYMT_PRIORITY_LVL = 129                          
MFA-TR*                 AND AC.ITEM_ID           = DA.DFA_ITEM_ID               
MFA-TR*                 AND AC.AMT_TRAN_BALANCE  > 0)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD WS-1 TO WS-COMMIT-COUNT                               
              ADD WS-1 TO WS-DFAACT-B-CNT                               
              IF WS-COMMIT-COUNT = WS-1000                              
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 ADD WS-1 TO WS-DFAACT-B-CMT                            
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '********** PCSXP301 ABORT  ************'      
                 DISPLAY '* 8400-DELETE-DFA-ACCOUNT             *'      
                 DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
                 DISPLAY '* PU-ACCOUNT-NO       =' PU-ACCOUNT-NO        
                 DISPLAY '* PU-PURGE-TS         =' PU-PURGE-TS          
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP301  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_PROJ_SHARE                          *          
      ****************************************************************          
      *                                                                         
       8500-DELETE-PROJ-SHARE.                                          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM PJ                            
                FROM CSS_PROJ_SHARE PJ
                 WHERE PJ.ACCOUNT_NO     = :PU-ACCOUNT-NO               
                 AND   PJ.ACCT_TERM_DT  <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PURGE-DT
              ) <> 0) OR (LEN(:WS-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-PURGE-DT
              ), CONVERT(DATE, :WS-PURGE-DT) )                 
                 AND   NOT EXISTS                                       
                       (SELECT 1 FROM CSS_AR_CNTL AC                    
                        WHERE AC.ACCOUNT_NO      = PJ.ACCOUNT_NO        
                        AND AC.PYMT_PRIORITY_LVL = 129                  
                        AND AC.ITEM_ID           = PJ.ITEM_ID           
                        AND AC.AMT_TRAN_BALANCE  > 0)                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_PROJ_SHARE   PJ                                 
MFA-TR*          WHERE PJ.ACCOUNT_NO     = :PU-ACCOUNT-NO                       
MFA-TR*          AND   PJ.ACCT_TERM_DT  <= :WS-PURGE-DT                         
MFA-TR*          AND   NOT EXISTS                                               
MFA-TR*                (SELECT 1 FROM CSS_AR_CNTL AC                            
MFA-TR*                 WHERE AC.ACCOUNT_NO      = PJ.ACCOUNT_NO                
MFA-TR*                 AND AC.PYMT_PRIORITY_LVL = 129                          
MFA-TR*                 AND AC.ITEM_ID           = PJ.ITEM_ID                   
MFA-TR*                 AND AC.AMT_TRAN_BALANCE  > 0)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD WS-1 TO WS-COMMIT-COUNT                               
              ADD WS-1 TO WS-PRJSHR-B-CNT                               
              IF WS-COMMIT-COUNT = WS-1000                              
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 ADD WS-1 TO WS-PRJSHR-B-CMT                            
                 DISPLAY 'ACCOUNT NUMBER :    ' PU-ACCOUNT-NO           
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '********** PCSXP301 ABORT  ************'      
                 DISPLAY '* 8500-DELETE-PROJ-SHARE              *'      
                 DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
                 DISPLAY '* PU-ACCOUNT-NO       =' PU-ACCOUNT-NO        
                 DISPLAY '* PU-PURGE-DT         =' WS-PURGE-DT          
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP301  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * UPDATES LAST RUN TIME STAMP TO JOB PARM                     *           
      ****************************************************************          
      *                                                                         
       8800-UPDATE-LAST-RUN-TS.                                         
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
              SET    PARM_DATA = :G6-PARM-DATA                          
              WHERE  CMND_CODE = 'DATE'                                 
              AND    COMPANY_NO = '01'                                  
              AND    PROGRAM_NAME = :WS-PGRMNAME                        
              AND    STATUS = 'A'                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                  DISPLAY '********** PCSXP301 ABORT  ************'     
                  DISPLAY '* 8800-UPDATE-LAST-RUN-TS                  *'
                  DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE          
                  DISPLAY '* WS-LAST-RUN-TSWS   = ' WS-LAST-RUN-TS      
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSXP301  ABORT ************'     
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                       *          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
