       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP300.                                           
       DATE-WRITTEN.  27 NOV 2008                                       
       DATE-COMPILED.                                                   
       AUTHOR.   PRIYA.                                                 
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      ** DATE           USERID           PURPOSE                     *          
      ** ----           ------           -------                     *          
      ** 02/19/2009     SP94986          APPL37648-ACT 07, 63        *          
      ****************************************************************          
      *                   PCSXP300   NARRATIVE                       *          
      *                                                              *          
      * THIS PROGRAM PURGES DATA FROM THE FOLLOWING TABLES USING THE *          
      * CSS_CIS_PURGE_TABLE.                                         *          
      * 1.  CSS_AR_TRANS_HIST                                        *          
      *                                                              *          
      * PURGE CRITERIA CAN BE FOUND IN THE CSS_JOB_PARM TABLE        *          
      * THIS PROGRAM PURGES DATA FROM THE TABLE USING                *          
      * CSS_CIS_PURGE TABLE                                          *          
      *                                                              *          
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM   *          
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)            *          
      *                                                              *          
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START -          *          
      * RESTART IS NOT NEEDED.                                       *          
      *                                                              *          
      * COMMITS ARE TAKEN                                            *          
      *                                                              *          
      * FOR LAST RUN DATE THE ACCOUNT NO AND PURGE DATE ARE USED     *          
      * TO DETERMINE THE DATE TO BE PURGED.                          *          
      *****************************************************************         
      *                                                               *         
      *             ---- BASIC SEQUENCE STRUCTURE ----                *         
      *         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  *         
      *         1000 - 1999     INPUT PROCESSING CONTROL PATH         *         
      *         2000 - 2999     OUTPUT PROCESSING CONTROL PATH        *         
      *         7000 - 7999     DATABASE ACCESS / INPUT MODULES       *         
      *         8000 - 8999     OUTPUT MODULES                        *         
      *         9000 - 9900     TERMINATION MODULES                   *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP300'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-COMMIT-COUNT             PIC 9(09) VALUE ZEROS.       
           05  WS-1000                     PIC 9(4)  VALUE 1000.        
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
           05  WS-DEL-TRN-HST-B-CNT        PIC 9(9)  VALUE ZEROS.       
           05  WS-NBR-COMMIT               PIC 9(9)  VALUE ZEROS.       
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-CURRENT-RUN-TS           PIC X(26) VALUE SPACES.      
           05  WS-TRANS-FLAG               PIC X(01) VALUE 'N'.         
               88 TRANS-FLAG                         VALUE 'Y'.         
       01 WS-PARM-DATA.                                                 
          05 FILLER                  PIC X(20) VALUE                    
                                               'LAST RUN TIME STAMP='.  
          05 WS-PGM-LAST-RUN-TS      PIC X(26) VALUE SPACES.            
          05 FILLER                  PIC X(36) VALUE SPACES.            
      *                                                                         
       01 WS-PGRMNAME                     PIC X(8)  VALUE 'PCSXP300'.   
      *                                                                         
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_AR_TRANS_HIST- AR                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_CIS_PURGE                                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPURGE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_JOB_PARM - G6                                              *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'               *          
      ***************************************************************           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                       *          
      ****************************************************************          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      ****************************************************************          
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND             *          
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      * WS-JOB-PARM-DATA                                                        
       COPY CWSPURGE.                                                           
      *                                                                         
      ******************************************************************        
      * -- USED BY CPD0303B                                            *        
      * WS ABEND WORK AREA                                             *        
      ******************************************************************        
      *                                                                         
       COPY CWS00010.                                                           
      ******************************************************************        
      * DECLARE CSS_CIS_PURGE CURSOR PURGE_CD 'B".                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                                                                        
             DECLARE AR_TRANS_HIST_CUR1 CURSOR WITH HOLD FOR            
              SELECT PU.ACCOUNT_NO                                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), PU.PURGE_TS
           , 121), ' ', '-'), ':', '.') PURGE_TS                               
                FROM CSS_CIS_PURGE PU WITH(READUNCOMMITTED)                     
               WHERE PU.LAST_UPDATE_TS >= CIS.CHAR2TIMESTAMP(
                                                     :PU-LAST-UPDATE-TS
              )            
               FOR READ ONLY                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      DECLARE AR_TRANS_HIST_CUR1 CURSOR WITH HOLD FOR                    
MFA-TR*       SELECT PU.ACCOUNT_NO                                              
MFA-TR*             ,PU.PURGE_TS                                                
MFA-TR*         FROM CSS_CIS_PURGE PU                                           
MFA-TR*        WHERE PU.LAST_UPDATE_TS >= :PU-LAST-UPDATE-TS                    
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      * 0000-MAIN-PARA.                                              *          
      ****************************************************************          
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 0100-INITIALIZATION            THRU 0100-EXIT.       
      *                                                                         
           IF TRANS-FLAG                                                
              PERFORM 1000-AR-TRANS-HIST-PRO-CSR1 THRU 1000-EXIT        
              PERFORM 2000-PRINT-TOTALS           THRU 2000-EXIT        
              PERFORM 7015-GET-TIME-STAMP         THRU 7015-EXIT        
              MOVE WS-CURRENT-RUN-TS              TO WS-PGM-LAST-RUN-TS 
              MOVE WS-PARM-DATA                   TO G6-PARM-DATA       
              PERFORM 8004-UPDATE-LAST-RUN-DATE   THRU 8004-EXIT        
           END-IF.                                                      
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   0100-INITIALIZATION                                          *        
      *        COMMON INITIALIZATION ROUTINE                           *        
      *                                                                *        
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT THRU 6253-EXIT.            
                                                                        
           MOVE WS-PGRMNAME                  TO WS-PROGRAM.             
           MOVE ZEROS                        TO WS-SEQUENCE.            
           MOVE SPACES                       TO WS-SYSIPT.              
           MOVE WS-KEY-AREA                  TO E-FJC01-KEY.            
                                                                        
           PERFORM 7600P-START-FCSJC01        THRU 7600P-EXIT.          
           PERFORM 0125-READ-JOB-PARM-VALUES  THRU 0125-EXIT.           
           PERFORM 7611P-CLOSE                THRU 7611P-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      **  0125-READ-JOB-PARM-VALUES                                   *         
      *****************************************************************         
       0125-READ-JOB-PARM-VALUES.                                       
      *                                                                         
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP=')   
             OR END-OF-SYSIPT                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP='    
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA(21:26)    TO WS-PGM-LAST-RUN-TS      
                 DISPLAY 'LAST RUN TS   : '    WS-PGM-LAST-RUN-TS       
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR LAST RUN TIME STAMP'  
                 DISPLAY 'NO RECORDS ARE PROCESSED'                     
                 PERFORM 9900-ABEND          THRU 9900-EXIT             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR LAST RUN TIME STAMP'    
              DISPLAY 'NO RECS ARE PROCESSED FOR LAST RUN TIME STAMP'   
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_AR_TRANS_HIST ')    
            OR END-OF-SYSIPT                                            
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_AR_TRANS_HIST '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-TRANS-FLAG                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_AR_TRANS_HIST '   
                 DISPLAY 'NO RECORDS ARE PROCESSED CSS_AR_TRANS_HIST'   
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_AR_TRAN_HIST '      
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_AR_TRANS_HIST '    
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *                                                                         
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_AR_TRANS_HIST       *          
      ****************************************************************          
      *                                                                         
       1000-AR-TRANS-HIST-PRO-CSR1.                                     
      *                                                                         
           INITIALIZE WS-COMMIT-COUNT.                                  
                                                                        
           MOVE    WS-PGM-LAST-RUN-TS            TO PU-LAST-UPDATE-TS.  
                                                                        
           PERFORM 7006-OPEN-AR-TRANS-HIST-CUR1  THRU 7006-EXIT.        
           PERFORM 7007-FETCH-AR-TRANS-HIST-CUR1 THRU 7007-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1000-AR-TRANS-HIST-PRO-CSR1 PARAGRAPH' 
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS TO DELETE IN  *'                    
              DISPLAY '* CSS_AR_TRANS_HIST   TABLE*'                    
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8002-DEL-AR-TRNS-HST-DATA     THRU 8002-EXIT      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1                TO WS-COMMIT-COUNT             
                 ADD WS-1                TO WS-DEL-TRN-HST-B-CNT        
                 IF WS-COMMIT-COUNT >= WS-CHKP-UPD-LIMIT                
                    PERFORM 8900-COMMIT  THRU 8900-EXIT                 
                    DISPLAY 'COMMIT NO          : ' WS-NBR-COMMIT       
                    DISPLAY 'ACCOUNT NO         : ' PU-ACCOUNT-NO       
                    INITIALIZE WS-COMMIT-COUNT                          
                 END-IF                                                 
               END-IF                                                   
              PERFORM 7007-FETCH-AR-TRANS-HIST-CUR1 THRU 7007-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7008-CLOSE-AR-TRANS-HIST-CUR1    THRU 7008-EXIT.     
                                                                        
           PERFORM 8900-COMMIT                   THRU 8900-EXIT         
                                                                        
           DISPLAY '      '.                                            
           DISPLAY '** NUMBER OF COMMITS FOR'.                          
           DISPLAY '** CSS_AR_TRANS_HIST  = ', WS-NBR-COMMIT.           
           DISPLAY '      '.                                            
           INITIALIZE WS-NBR-COMMIT.                                    
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *  2000-PRINT-TOTALS.                                          *          
      ****************************************************************          
       2000-PRINT-TOTALS.                                               
      *                                                                         
           DISPLAY 'ACCOUNTS DELETED IN CSS_AR_TRANS_HIST '             
                                                   WS-DEL-TRN-HST-B-CNT.
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      **  6253-GET-FJC01-CHKP-LIMIT.                                  *         
      **  *RETRIEVE COMMIT COUNT DETAILS FROM JOB PARM TABLE.         *         
      *****************************************************************         
      *                                                                         
            EXEC SQL                                                            
                INCLUDE CPD00034                                                
            END-EXEC.                                                           
      *                                                                         
      *----------------------------------------------------------------*        
      * SELECT CSS_JOB_PARM TABLE                                      *        
      * 7600P-,7610P-, 7611P- PARAGRAPHS                              *         
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE CPDPURGE                                                 
           END-EXEC                                                             
      *                                                                         
      ****************************************************************          
      * OPENS 7006-OPEN-AR-TRANS-HIST-CUR1 CURSOR                    *          
      ****************************************************************          
      *                                                                         
       7006-OPEN-AR-TRANS-HIST-CUR1.                                    
      *                                                                         
           EXEC SQL                                                     
               OPEN  AR_TRANS_HIST_CUR1                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP300 ABORT  ************'         
              DISPLAY '* 7006-OPEN-AR-TRANS-HIST-CUR1 CURSOR *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP300  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7006-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCH AR-TRANS-HIST-CUR1 CURSOR                              *          
      ****************************************************************          
      *                                                                         
       7007-FETCH-AR-TRANS-HIST-CUR1.                                   
      *                                                                         
           EXEC SQL                                                     
               FETCH AR_TRANS_HIST_CUR1                                 
                INTO :PU-ACCOUNT-NO                                     
                    ,:PU-PURGE-TS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP300 ABORT  ************'         
              DISPLAY '* 7007-FETCH-AR-TRANS-HIST-CUR1 CURSOR*'         
              DISPLAY '* SQLCODE IS         ', WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ACCOUNT #          ', PU-ACCOUNT-NO            
              DISPLAY '* PU-PURGE-TS        ', PU-PURGE-TS              
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP300  ABORT ************'         
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       7007-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *CLOSE AR-TRANS-HIST-CUR1 CURSOR                               *          
      ****************************************************************          
      *                                                                         
       7008-CLOSE-AR-TRANS-HIST-CUR1.                                   
      *                                                                         
           EXEC SQL                                                     
               CLOSE AR_TRANS_HIST_CUR1                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP300 ABORT  ************'         
              DISPLAY '* 7008-CLOSE-AR-TRANS-HIST-CUR1 CURSOR*'         
              DISPLAY '* SQLCODE IS  ', WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP300  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7008-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7015-GET-TIME-STAMP                                            *        
      ******************************************************************        
      *                                                                         
       7015-GET-TIME-STAMP.                                             
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-RUN-TS              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-RUN-TS = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP300 ABORT  ************'         
              DISPLAY '* 7015-GET-TIME-STAMP                 *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP300  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7015-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *   7600-START-FCSJC01                                           *        
      *   *RETRIEVE PARM DETAILS FROM JOB PARM TABLE.                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8002-DEL-AR-TRNS-HST-DATA   DELETES THE RECORD FROM            *        
      * CSS_AR_TRANS_HST TABLE                                         *        
      ******************************************************************        
       8002-DEL-AR-TRNS-HST-DATA.                                       
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DELETE FROM AR                          
               FROM CSS_AR_TRANS_HIST AR
               WHERE AR.ACCOUNT_NO         = :PU-ACCOUNT-NO             
                 AND AR.TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )               
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DELETE FROM CSS_AR_TRANS_HIST AR                                 
MFA-TR*        WHERE AR.ACCOUNT_NO         = :PU-ACCOUNT-NO                     
MFA-TR*          AND AR.TRANS_HIST_SEQ_NO <= :PU-PURGE-TS                       
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '********** PCSXP300 ABORT  ************'   
                    DISPLAY '* 8002-DEL-AR-TRNS-HST-DATA           *'   
                    DISPLAY '* SQLCODE IS       ', WS-ACTIVE-RETURN-CODE
                    DISPLAY '* ACCOUNT #           ', PU-ACCOUNT-NO     
                    DISPLAY '* AR-TRANS-HIST-SEQ-NO', PU-PURGE-TS       
                    DISPLAY '* PROGRAM ABORTING...                 *'   
                    DISPLAY '********** PCSXP300  ABORT ************'   
                    PERFORM 9900-ABEND            THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      *                                                               *         
      * 8004-UPDATE-LAST-RUN-DATE                                     *         
      *****************************************************************         
       8004-UPDATE-LAST-RUN-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
                                                                        
               UPDATE CSS_JOB_PARM                                      
                  SET PARM_DATA    = :G6-PARM-DATA                      
                WHERE CMND_CODE    = 'DATE'                             
                  AND COMPANY_NO   = '01'                               
                  AND PROGRAM_NAME = :WS-PGRMNAME                       
                  AND STATUS       = 'A'                                
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP300 ABORT **************'        
              DISPLAY '*     8004-UPDATE-LAST-RUN-DATE        *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY'* PROGRAM NAME:      = ' WS-PGRMNAME              
              DISPLAY'* PARM DATA   :      = ' G6-PARM-DATA             
              DISPLAY'* WS-PGM-LAST-RUN-TS = ' WS-PGM-LAST-RUN-TS       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                         
       8004-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                       *          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           COMPUTE WS-NBR-COMMIT = WS-NBR-COMMIT + 1.                   
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
      *                                                                         
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                      

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

      *                                                                         
           MOVE 12                          TO RETURN-CODE.             
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
