       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSXP216.                                            
       AUTHOR. SJ94244.                                                 
       DATE-WRITTEN. JUN 2010.                                          
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** PROGRAM TO PURGE THE DATA IN REVENUE TABLES FOR THE GIVEN    **        
      ** INPUT DATE (COMMON DATE  - NUMBER OF WEEKS GIVEN IN JOB_PARM)**        
      ** OR THE DELETE DATE GIVEN IN THE JOB PARM TABLE               **        
      **                                                              **        
      ** REVENUE TABLES                                               **        
      ** --------------                                               **        
      ** REV_BILLING_DET                                              **        
      ** REV_BILL_COMP_ADJ                                            **        
A04527** REV_BILL_BLOCK - REMOVED THE DELETION OF THIS TABLE          **        
      ** REV_BILL_TAX                                                 **        
      **                                                              **        
A04880** 22 MAY 2014   RF10596  CHANGED CURSOR TO SELECT 100 ROWS     **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------- -------  ------                                     **        
P00257** 06/15/10 SJ94244  INITIAL IMPLEMENTATION.                    **        
P00257** 08/06/10 GOKUL    CHANGE DELETE PROCESS TO BE DRIVEN BY      **        
P00257**                   BILL_UNIQUE_TS.                            **        
      **                                                              **        
A04527** 9 SEP 13 RF10596  REMOVE REV_BILL_BLOCK DELETION             **        
      **                                                              **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-REV-TSTMP-CSR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP216'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                      PIC X(40)  VALUE                
                           'WORKING STORAGE FOR PCSXP216 STARTS HERE'.  
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08)  VALUE 'PCSXP216'.    
          05 WS-PGRMNAME                PIC X(10)  VALUE 'PCSXP216'.    
          05 WS-Y                       PIC X(01)  VALUE 'Y'.           
          05 WS-N                       PIC X(01)  VALUE 'N'.           
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-NUMBER-OF-WEEKS-NUM     PIC 9(02)  VALUE 0.             
          05 WS-DEFAULT-NUMBER-OF-WEEKS PIC X(02)  VALUE '08'.          
          05 WS-NUMBER-OF-DAYS          PIC S9(09) USAGE COMP VALUE +0. 
          05 WS-CHKP-SEQ-NO             PIC S9(09) USAGE COMP VALUE +0. 
          05 WS-SUB1                    PIC S9(04) USAGE COMP VALUE +0. 
          05 WS-ORDER-ROW-COUNT         PIC S9(04) COMP VALUE +0.       
          05 WS-NUM-COND                PIC S9(04) COMP VALUE +0.       
          05 WS-START-TSTMP             PIC X(26)  VALUE SPACES.        
          05 WS-END-TSTMP               PIC X(26)  VALUE SPACES.        
          05 WS-HOLD-UNIQUE-TS          PIC X(26)  VALUE SPACES.        
          05 WS-DELETE-DATE-START       PIC X(10)  VALUE SPACES.        
          05 WS-DELETE-DATE-END         PIC X(10)  VALUE SPACES.        
          05 WS-HOLD-DEL-DATE-START     PIC X(10)  VALUE '2000-01-01'.  
          05 WS-INPUT-DATE-COMMON       PIC X(10)  VALUE SPACES.        
          05 WS-TEMP-ST-TIMESTAMP.                                      
             10 WS-TEMP-DATE-ST         PIC X(10).                      
             10 FILLER                  PIC X(16)  VALUE                
                                        '-00.00.00.000000'.             
          05 WS-TEMP-END-TIMESTAMP.                                     
             10 WS-TEMP-DATE-END        PIC X(10).                      
             10 FILLER                  PIC X(16)  VALUE                
                                        '-23.59.59.999999'.             
                                                                        
       01 WS-MISC-HOST-VARIABLES.                                       
A04880    05 WS-REV-UNIQUE-TS           PIC X(26) OCCURS 100 TIMES      
                                                   VALUE SPACES.        
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-IS-DEL-DATE-ACTIVE      PIC X(01)  VALUE 'N'.           
             88 DEL-DATE-ACTIVE         VALUE 'Y'.                      
             88 DEL-DATE-NOT-ACTIVE     VALUE 'N'.                      
          05 WS-IS-DEL-DATE-RANGE       PIC X(01)  VALUE 'N'.           
             88 DATE-RANGE-ACTIVE       VALUE 'Y'.                      
             88 NO-DATE-RANGE           VALUE 'N'.                      
      *                                                                         
      ******************************************************************        
      *  ABEND SWITCH                                                  *        
      ******************************************************************        
      *  CWS00303 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS   *        
      ******************************************************************        
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD09900 CONTAINS ABEND WS VARIABLES       *        
      ******************************************************************        
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
      ******************************************************************        
      *  CWS00038 IS JC01 WORK DATA FOR RESTART PROCESSING             *        
      ******************************************************************        
       COPY CWS00038.                                                           
      *                                                                         
      *** BEWARE OF BELOW REDIFINITIONS, WHICH ARE LINK TO CWS00038             
                                                                        
       01 WS-NO-OF-WEEKS REDEFINES WS-INPUT-DATA-BREAKDOWN.             
          10 WS-PARM-NUMBER-OF-WEEKS-TXT PIC X(16).                     
             88 NUMBER-OF-WEEKS          VALUE 'NUMBER-OF-WEEKS='.      
          10 WS-NUMBER-OF-WEEKS          PIC X(02).                     
          10 FILLER                      PIC X(62).                     
                                                                        
       01 WS-DEL-DATE REDEFINES WS-INPUT-DATA-BREAKDOWN.                
          10 WS-PARM-DEL-DATE-TXT        PIC X(12).                     
             88 DELETE-DATE              VALUE 'DELETE-DATE='.          
          10 WS-JPARM-DELETE-DATE        PIC X(10).                     
          10 FILLER                      PIC X(58).                     
      *                                                                         
       01 WS-DEL-DATE REDEFINES WS-INPUT-DATA-BREAKDOWN.                
          10 WS-PARM-DEL-DATE-TXT        PIC X(13).                     
             88 DEL-DT-RANGE             VALUE 'DEL-DT-RANGE='.         
          10 WS-JPARM-DEL-ST-DATE        PIC X(10).                     
          10 WS-JPARM-DEL-END-DATE       PIC X(10).                     
          10 FILLER                      PIC X(47).                     
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       01 WS-END                         PIC X(40) VALUE                
                       'WORKING STORAGE FOR PCSXP216 ENDS HERE  '.      
      ******************************************************************        
      * DB2 INCLUDES.                                                  *        
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_JOB_PARM  - G6                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO SELECT THE DATA FROM REV_BILLING_DET               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE REV_TSTMP_CSR CURSOR                             
                  WITH HOLD WITH ROWSET POSITIONING FOR                 
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), BILL_UNIQUE_TS
           , 121), ' ', '-'), ':', '.') BILL_UNIQUE_TS                         
                  FROM REV_BILLING_DET WITH(READUNCOMMITTED)                    
                WHERE BILL_UNIQUE_TS >= CIS.CHAR2TIMESTAMP(
                                                        :WS-START-TSTMP
              )                 
                  AND BILL_UNIQUE_TS <= CIS.CHAR2TIMESTAMP(:WS-END-TSTMP
              )                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE REV_TSTMP_CSR CURSOR                                     
MFA-TR*           WITH HOLD WITH ROWSET POSITIONING FOR                         
MFA-TR*         SELECT BILL_UNIQUE_TS                                           
MFA-TR*           FROM REV_BILLING_DET                                          
MFA-TR*         WHERE BILL_UNIQUE_TS >= :WS-START-TSTMP                         
MFA-TR*           AND BILL_UNIQUE_TS <= :WS-END-TSTMP                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM  0100-INITIALIZATION          THRU  0100-EXIT.       
           PERFORM  1000-PROCESS-INPUT           THRU  1000-EXIT.       
           PERFORM  2000-PROCESS-OUTPUT          THRU  2000-EXIT.       
           PERFORM  9000-TERMINATE               THRU  9000-EXIT.       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
                                                                        
           PERFORM 0110-GET-JOB-PARM-DETAILS     THRU 0110-EXIT.        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-GET-JOB-PARM-DETAILS.                                     *        
      *    1. SELECT RUN-DATE                                          *        
      *    2. GET NUMBER-OF-WEEKS                                      *        
      ******************************************************************        
      *                                                                         
       0110-GET-JOB-PARM-DETAILS.                                       
      *                                                                         
           PERFORM 0120-GET-JPARM-DATE-RANGE     THRU 0120-EXIT.        
           IF NO-DATE-RANGE                                             
              PERFORM 0130-GET-JPARM-DELETE-DATE THRU 0130-EXIT         
           END-IF.                                                      
                                                                        
           IF DEL-DATE-NOT-ACTIVE AND NO-DATE-RANGE                     
              PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT         
              IF COMMON-DATE-NEEDED                                     
                 PERFORM 0140-GET-COMMON-JP      THRU 0140-EXIT         
              END-IF                                                    
              MOVE WS-INPUT-DATE            TO WS-INPUT-DATE-COMMON     
              PERFORM 0150-GET-NUMBER-OF-WEEKS   THRU 0150-EXIT         
           END-IF.                                                      
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0120-GET-JPARM-DATE-RANGE.                                     *        
      * GET THE DELETE DATE RANGE FROM JOB PARM TABLE                  *        
      ******************************************************************        
      *                                                                         
       0120-GET-JPARM-DATE-RANGE.                                       
      *                                                                         
           MOVE  WS-PGRMNAME                TO WS-PROGRAM.              
           MOVE  WS-PARM                    TO WS-COMMAND.              
           MOVE  ZEROS                      TO WS-SEQUENCE.             
           MOVE  SPACES                     TO WS-SYSIPT.               
           MOVE  WS-KEY-AREA                TO E-FJC01-KEY.             
                                                                        
           PERFORM 7600-START-FCSJC01            THRU  7600-EXIT.       
           PERFORM 7610-READ-FCSJC01             THRU  7610-EXIT        
              UNTIL (DEL-DT-RANGE AND INPUT-ACTIVE)                     
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '** DELETE-DATE RANGE NOT ACTIVE        **'       
              DISPLAY '** PROCESSING CONTINUING               **'       
           ELSE                                                         
              DISPLAY '** DELETE DATE RANGE GIVEN IN JOB PARM TABLE ='  
                       WS-JPARM-DEL-ST-DATE ' '                         
                       WS-JPARM-DEL-END-DATE                            
              MOVE WS-Y                     TO WS-IS-DEL-DATE-RANGE     
              MOVE WS-JPARM-DEL-ST-DATE     TO WS-DELETE-DATE-START     
              MOVE WS-JPARM-DEL-END-DATE    TO WS-DELETE-DATE-END       
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0130-GET-JPARM-DELETE-DATE.                                    *        
      * GET THE DELETE DATE DIRECTLY FROM JOB PARM TABLE               *        
      ******************************************************************        
      *                                                                         
       0130-GET-JPARM-DELETE-DATE.                                      
      *                                                                         
           MOVE  WS-PGRMNAME                TO WS-PROGRAM.              
           MOVE  WS-PARM                    TO WS-COMMAND.              
           MOVE  ZEROS                      TO WS-SEQUENCE.             
           MOVE  SPACES                     TO WS-SYSIPT.               
           MOVE  WS-KEY-AREA                TO E-FJC01-KEY.             
                                                                        
           PERFORM 7600-START-FCSJC01            THRU  7600-EXIT.       
           PERFORM 7610-READ-FCSJC01             THRU  7610-EXIT        
              UNTIL (DELETE-DATE AND INPUT-ACTIVE)                      
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '** DELETE-DATE PARM NOT ACTIVE         **'       
              DISPLAY '** PROCESSING CONTINUING               **'       
           ELSE                                                         
              DISPLAY '** DELETE DATE GIVEN IN JOB PARM TABLE ='        
                       WS-JPARM-DELETE-DATE                             
              DISPLAY '** THIS DATE IS USED FOR DELETION **'            
              MOVE WS-Y                     TO WS-IS-DEL-DATE-ACTIVE    
              MOVE WS-JPARM-DELETE-DATE     TO WS-DELETE-DATE-END       
              MOVE WS-HOLD-DEL-DATE-START   TO WS-DELETE-DATE-START     
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
           END-IF.                                                      
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0140-GET-COMMON-JP.                                            *        
      * GET COMMON FROM CSS_JOB_PARM, NOT COMMONDATE                   *        
      ******************************************************************        
      *                                                                         
       0140-GET-COMMON-JP.                                              
                                                                        
           MOVE SPACES                      TO WS-SYSIPT.               
           MOVE 'COMMON'                    TO WS-PROGRAM.              
           MOVE WS-DATE                     TO WS-COMMAND.              
           MOVE ZEROS                       TO WS-SEQUENCE.             
           MOVE WS-KEY-AREA                 TO E-FJC01-KEY.             
                                                                        
           PERFORM 7600-START-FCSJC01            THRU  7600-EXIT.       
                                                                        
           PERFORM 7610-READ-FCSJC01             THRU  7610-EXIT        
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSXP216 PROCESSING ERROR  **'            
                 DISPLAY '**    NO ACTIVE COMMON DATE FOUND'            
                 DISPLAY '**  PROCESSING TERMINATED      **'            
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE              THRU 7611-EXIT         
           END-EVALUATE.                                                
                                                                        
           MOVE WS-INPUT-RUN-DATE           TO WS-INPUT-DATE.           
           DISPLAY ' '                                                  
           DISPLAY '**  PCSXP216 PROCESSING MESSAGE **'                 
           DISPLAY '**    COMMON DATE USED = ' WS-INPUT-RUN-DATE.       
           DISPLAY '**  PROCESSING CONTINUING               **'.        
           DISPLAY ' '.                                                 
                                                                        
       0140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0150-GET-NUMBER-OF-WEEKS.                                      *        
      * GET THE NUMBER OF WEEKS FROM JOB PARM TABLE                    *        
      ******************************************************************        
      *                                                                         
       0150-GET-NUMBER-OF-WEEKS.                                        
                                                                        
           MOVE  WS-PGRMNAME                TO WS-PROGRAM.              
           MOVE  WS-PARM                    TO WS-COMMAND.              
           MOVE  ZEROS                      TO WS-SEQUENCE.             
           MOVE  SPACES                     TO WS-SYSIPT.               
           MOVE  WS-KEY-AREA                TO E-FJC01-KEY.             
                                                                        
           PERFORM 7600-START-FCSJC01            THRU  7600-EXIT.       
           PERFORM 7610-READ-FCSJC01             THRU  7610-EXIT        
              UNTIL (NUMBER-OF-WEEKS AND INPUT-ACTIVE)                  
              OR  END-OF-SYSIPT.                                        
                                                                        
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '** ' WS-PGRMNAME ' PROCESSING WARNING  **'       
              DISPLAY '** NUMBER-OF-WEEKS PARM NOT ACTIVE     **'       
              DISPLAY '** DEFAULT VALUE ' WS-DEFAULT-NUMBER-OF-WEEKS    
              DISPLAY '** WILL BE USED                        **'       
              DISPLAY '** PROCESSING CONTINUING               **'       
              MOVE WS-DEFAULT-NUMBER-OF-WEEKS                           
                                            TO WS-NUMBER-OF-WEEKS       
           ELSE                                                         
              PERFORM 7611-CLOSE            THRU 7611-EXIT              
              IF WS-NUMBER-OF-WEEKS NUMERIC                             
                 DISPLAY '** ' WS-PGRMNAME ' PROCESSING MESSAGE  **'    
                 DISPLAY '** NUMBER-OF-WEEKS GIVEN IN JOB PARM TABLE = '
                       WS-NUMBER-OF-WEEKS                               
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  ' WS-PGRMNAME ' PROCESSING WARNING  **'   
                 DISPLAY '** NUMBER-OF-WEEKS PARM NOT NUMERIC     **'   
                 DISPLAY '** DEFAULT VALUE ' WS-DEFAULT-NUMBER-OF-WEEKS 
                 DISPLAY '** WILL BE USED                         **'   
                 DISPLAY '** PROCESSING CONTINUING                **'   
                 MOVE WS-DEFAULT-NUMBER-OF-WEEKS                        
                                            TO WS-NUMBER-OF-WEEKS       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      * PROCESS INPUT                                                  *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF DEL-DATE-NOT-ACTIVE AND NO-DATE-RANGE                     
              MOVE WS-NUMBER-OF-WEEKS       TO WS-NUMBER-OF-WEEKS-NUM   
              PERFORM  1100-GET-DELETE-DATE      THRU 1100-EXIT         
           END-IF.                                                      
           MOVE WS-DELETE-DATE-START         TO WS-TEMP-DATE-ST.        
           MOVE WS-TEMP-ST-TIMESTAMP         TO WS-START-TSTMP.         
           MOVE WS-DELETE-DATE-END           TO WS-TEMP-DATE-END.       
           MOVE WS-TEMP-END-TIMESTAMP        TO WS-END-TSTMP.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-GET-DELETE-DATE.                                          *        
      * GET DELETE DATE BY SUBTRACTING NUMBER OF WEEKS WITH COMMON DATE*        
      ******************************************************************        
      *                                                                         
       1100-GET-DELETE-DATE.                                            
                                                                        
           COMPUTE WS-NUMBER-OF-DAYS = WS-NUMBER-OF-WEEKS-NUM * 7       
                                                                        
           PERFORM 7000-GET-DELETE-DATE      THRU  7000-EXIT.           
           MOVE WS-HOLD-DEL-DATE-START       TO WS-DELETE-DATE-START.   
           DISPLAY '** DATES USED FOR DELETION = ' WS-DELETE-DATE-START 
                   ' ' WS-DELETE-DATE-END.                              
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      * PROCESS OUTPUT - DELETES THE ROWS IN REVENUE TABLES            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7100-OPEN-REV-TSTMP-CSR       THRU 7100-EXIT.        
           INITIALIZE                            WS-MISC-HOST-VARIABLES.
           PERFORM 7200-FETCH-REV-TSTMP-CSR      THRU 7200-EXIT.        
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                 
                      WS-SUB1 > WS-ORDER-ROW-COUNT OR                   
                      WS-REV-UNIQUE-TS(WS-SUB1) = SPACES                
                 MOVE WS-REV-UNIQUE-TS(WS-SUB1) TO WS-HOLD-UNIQUE-TS    
                 PERFORM 8100-DELETE-REV-BILL-DET   THRU 8100-EXIT      
              END-PERFORM                                               
              PERFORM 8888-COMMIT                THRU 8888-EXIT         
              INITIALIZE                         WS-MISC-HOST-VARIABLES 
              PERFORM 7200-FETCH-REV-TSTMP-CSR   THRU 7200-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           IF WS-ORDER-ROW-COUNT > 0                                    
              PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                 
                      WS-SUB1 > WS-ORDER-ROW-COUNT OR                   
                      WS-REV-UNIQUE-TS(WS-SUB1) = SPACES                
                 MOVE WS-REV-UNIQUE-TS(WS-SUB1) TO WS-HOLD-UNIQUE-TS    
                 PERFORM 8100-DELETE-REV-BILL-DET   THRU 8100-EXIT      
              END-PERFORM                                               
           END-IF.                                                      
           PERFORM 8888-COMMIT THRU 8888-EXIT.                          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00037                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-GET-DELETE-DATE.                                          *        
      * GET DELETE DATE BY SUBTRACTING NUMBER OF DAYS WITH COMMON DATE *        
      ******************************************************************        
      *                                                                         
       7000-GET-DELETE-DATE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -:WS-NUMBER-OF-DAYS, IIF(TRY_CONVERT(DATE, 
                                                  :WS-INPUT-DATE-COMMON
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE-COMMON
              ) <> 0) OR (LEN(:WS-INPUT-DATE-COMMON
              ) <> 10), CIS.CHAR2DATE(:WS-INPUT-DATE-COMMON
              ), CONVERT(DATE, :WS-INPUT-DATE-COMMON) ) )
            INTO
              :WS-DELETE-DATE-END       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DELETE-DATE-END = (DATE(:WS-INPUT-DATE-COMMON) -          
MFA-TR*                                   :WS-NUMBER-OF-DAYS DAY)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP216 ABORT  ************'         
              DISPLAY '* 7000-GET-DELETE-DATE                *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP216 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-REV-TSTMP-CSR.                                       *        
      * OPENS REVENUE TIMESTAMP CURSOR                                 *        
      ******************************************************************        
      *                                                                         
       7100-OPEN-REV-TSTMP-CSR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN REV_TSTMP_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP216 ABORT  ************'         
              DISPLAY '* 7100-OPEN-REV-TSTMP-CSR             *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP216 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-FETCH-REV-TSTMP-CSR                                       *        
      * FETCH REVENUE TIMESTAMP                                        *        
      ******************************************************************        
       7200-FETCH-REV-TSTMP-CSR.                                        

MSQ008     MOVE 100 TO MSQ008-REV-TSTMP-CSR
                                                                        
           EXEC SQL                                                     
              FOR :MSQ008-REV-TSTMP-CSR
              FETCH 
              FROM REV_TSTMP_CSR                      
A04880                                                      
               INTO  :WS-REV-UNIQUE-TS                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM REV_TSTMP_CSR                              
MFA-TR*         FOR 100 ROWS                                                    
MFA-TR*        INTO  :WS-REV-UNIQUE-TS                                          
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-REV-TSTMP-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF SQLERRD (3) > 0                                        
                 MOVE SQLERRD (3)         TO WS-ORDER-ROW-COUNT         
              ELSE                                                      
                 MOVE 0                   TO WS-ORDER-ROW-COUNT         
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                                                                        
                 EXEC SQL                                               
MSQ012              GET DIAGNOSTICS :MFA-GD-ROW-COUNT = ROW_COUNT     
MSQ012                              ,:MFA-GD-NUMBER       = NUMBER        
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*          EXEC SQL                                                       
MFA-TR*             GET DIAGNOSTICS :WS-ORDER-ROW-COUNT = ROW_COUNT             
MFA-TR*                             ,:WS-NUM-COND       = NUMBER                
MFA-TR*          END-EXEC                                                       
MSQ012           MOVE MFA-GD-ROW-COUNT TO WS-ORDER-ROW-COUNT
MSQ012           MOVE MFA-GD-NUMBER TO WS-NUM-COND
                                                                        
                 DISPLAY '********** PCSXP216 ABORT  ************'      
                 DISPLAY '* 7200-FETCH-REV-TSTMP-CSR            *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ROWCOUNT ' SQLERRD(3)                       
                 DISPLAY '* NUM_COND '  WS-NUM-COND                     
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP216 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              ELSE                                                      
                 DISPLAY '********** PCSXP216 ABORT  ************'      
                 DISPLAY '* 7200-FETCH-REV-TSTMP-CSR            *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP216 ABORT  ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CLOSE-REV-TSTMP-CSR                                       *        
      * CLOSE REVENUE TIMESTAMP CSR                                    *        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-REV-TSTMP-CSR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE REV_TSTMP_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP216 ABORT  ************'         
              DISPLAY '* 7300-CLOSE-REV-TSTMP-CSR            *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP216 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CPD00038                                                       *        
      * 7600-START-FCSJC01                                             *        
      * 7610-READ-FCSJC01                                              *        
      * 7611-CLOSE                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8100-DELETE-REV-BILL-DET                                       *        
      * DELETES DATA IN REV_BILLING_DET                                *        
      ******************************************************************        
      *                                                                         
       8100-DELETE-REV-BILL-DET.                                        
      *                                                                         
           EXEC SQL                                                     
              DELETE                                                    
                FROM REV_BILLING_DET                                    
               WHERE BILL_UNIQUE_TS = CIS.CHAR2TIMESTAMP(
                                                     :WS-HOLD-UNIQUE-TS
              )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE                                                            
MFA-TR*         FROM REV_BILLING_DET                                            
MFA-TR*        WHERE BILL_UNIQUE_TS = :WS-HOLD-UNIQUE-TS                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******PCSXP216 ABORT*****************'           
              DISPLAY '       8100-DELETE-REV-BILL-DET      '           
              DISPLAY ' ** ERROR ON DELETE '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** GIVEN DATES FOR DELETE :'                    
                           WS-DELETE-DATE-START                         
                           WS-DELETE-DATE-END                           
              DISPLAY ' ** TABLE REV_BILLING_DET '                      
              DISPLAY '******PCSXP216 ABORT*****************'           
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8888-COMMIT.                                                     
                                                                        
           ADD 1                    TO WS-CHKP-SEQ-NO.                  
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'.          
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           DISPLAY 'DELETE PROCESS SUCCESSFULLY COMPLETED'.             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * PERFORMED IF VSAM OR DB2 PROBLEM OCCURS                        *        
      ******************************************************************        
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC                                                       

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
