       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP211.                                           
       DATE-WRITTEN.  23 JUL 2009                                       
       DATE-COMPILED.                                                   
      ****************************************************************  00050000
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *  00060000
      **                                                             *  00070000
      ********            CUSTOMER SERVICE SYSTEM             ********  00080000
      ********                   DB2                          ********  00090000
      ****************************************************************  00100000
      **                                                             *  00110000
      **              PROGRAM  MODIFICATION  LOG                     *  00120000
      **                                                             *  00130000
      ** DATE       INITIALS       REASON                            *  00140000
      ** 23/07/09   SP94986     APPL37648 - ACT-2                    *  00150000
A37741** 11/16/09   VP94820     DECLARED S-RETURN-CODE RESPECTIVE TO *  00152000
      **                        CPD00067 CHANGES.                    *  00153000
      ****************************************************************  00160000
      *                   PCSXP211   NARRATIVE                       *  00170000
      *                                                              *  00180000
      * THIS PROGRAM DELETES THE RECORDS FROM THE FOLLOWING TABLES   *  00190000
      * 1.  CSS_THD_PRTY                                             *  00200000
      *           PER THE RULES IN THE INDIVIDUAL CURSORS            *  00210000
      *                                                              *  00220000
      * A ROW EXISTS IN THE CSS_JOB_PARM                             *  00230000
      * TABLE FOR EACH TABLE AND THE TABLE WILL ONLY BE PROCESSED    *  00240000
      * IF THE JOB_PARM STATUS = 'A'                                 *  00250000
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM   *  00260000
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)            *  00270000
      *                                                              *  00280000
      * PURGE CRITERIA CAN BE FOUND IN THE CSS_JOB_PARM TABLE        *  00290000
      * FOR EACH TABLE. TO SAFEGUARD AGAINST JOB PARM ERRORS AND     *  00300000
      * ACCIDENTALY DELETING MORE DATA THAN INTENDED, THE FOLLOWING  *  00310000
      * HARD CODED VALUES HAVE BEEN ESTABLISHED AS MINIMUM VALUES    *  00320000
      * OF DATA THAT CAN BE DELETED FROM EACH TABLE WITHOUT REQUIRING*  00330000
      * A PROGRAMMING CHANGE.                                        *  00340000
      *                                                              *  00350000
      * 1.  CSS_THD_PRTY    - 24 MONTHS-INACTIVE                     *  00360000
      *                     - 06 MONTHS-PENDING                      *  00370000
      *                                                              *  00380000
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START-           *  00390000
      * RESTART IS NOT NEEDED.                                       *  00400000
      *                                                              *  00410000
      * COMMITS ARE TAKEN                                            *  00420000
      ****************************************************************  00430000
      *                                                                 00440000
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                 00520000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                 00580000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00610000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00640000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP211'.
MSQ017     COPY MFASQLM.
      *                                                                 00660000
       01  WS-VARIABLES.                                                
           05  WS-COMMIT-COUNT             PIC 9(4)  VALUE ZEROS.       
           05  WS-1000                     PIC 9(4)  VALUE 1000.        
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-NBR-COMMIT               PIC 9(9)  VALUE ZEROS.       
           05  WS-NULL-INACTIVE            PIC S9(04) COMP VALUE +0.    
           05  WS-NULL-PENDING             PIC S9(04) COMP VALUE +0.    
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
      *                                                                 00800000
           05 WS-PGRMNAME                  PIC X(8)  VALUE 'PCSXP211'.  
           05 WS-SYSTEM                    PIC X(07) VALUE 'SYSTEM '.   
      *                                                                 00830000
           05 WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.      
           05 WS-CURRENT-DATE              PIC X(10) VALUE SPACES.      
           05 WS-ACCT-CREATE-DT            PIC X(10) VALUE SPACES.      
           05 WS-INACTIVE-DEL-DT           PIC X(10) VALUE SPACES.      
           05 WS-PENDING-DEL-DT            PIC X(10) VALUE SPACES.      
                                                                        
           05 WS-TRANS-COMM-INACTIVE       PIC X(40) VALUE              
              'REMOVED THIRD PARTY - INACTIVE 24 MONTHS'.               
           05 WS-TRANS-COMM-PENDING        PIC X(40) VALUE              
              'REMOVED THIRD PARTY - PENDING 6 MONTHS  '.               
           05  WS-PREV-CODE-THIRD-PTY      PIC X(01) VALUE SPACES.      
           05  WS-MONTHS                   PIC X(03) VALUE SPACES.      
           05  WS-MONTHS-VALUEI                                         
               REDEFINES WS-MONTHS         PIC 9(03).                   
           05  WS-MONTHS-VALUEP                                         
               REDEFINES WS-MONTHS         PIC 9(03).                   
           05  WS-THD-INACTIVE-MO          PIC S9(3) COMP VALUE 0.      
           05  WS-THD-PENDING-MO           PIC S9(3) COMP VALUE 0.      
           05  WS-THD-INACTIVE-DEL         PIC X(01) VALUE 'N'.         
               88 THD-INACTIVE-DEL         VALUE 'Y'.                   
           05  WS-THD-PENDING-DEL          PIC X(01) VALUE 'N'.         
               88 THD-PENDING-DEL          VALUE 'Y'.                   
           05  WS-JOB-PARM-ERR-CODE        PIC 9(02) VALUE 0.           
           05  WS-NO-MORE-RECORDS          PIC X(01) VALUE 'N'.         
               88 NO-MORE-RECORDS          VALUE 'Y'.                   
           05  WS-INACTIVE-COUNT           PIC 9(9)  VALUE ZEROS.       
           05  WS-PENDING-COUNT            PIC 9(9)  VALUE ZEROS.       
A37741     05  S-RETURN-CODE               PIC S9(9) VALUE +000 COMP.   
      *                                                                 01110000
      ****************************************************************  01120000
      **      APPLICATION  TABLE DCLGENS                             *  01130000
      ****************************************************************  01140000
      *                                                                 01150000
           EXEC SQL                                                     01160000
               INCLUDE SQLCA                                            01170000
           END-EXEC.                                                    01180000
      *                                                                 01190000
      ****************************************************************  01200000
      **  CSS_JOB_PARM                                               *  01210000
      ****************************************************************  01220000
      *                                                                 01230000
           EXEC SQL                                                     01240000
               INCLUDE TBJBPARM                                         01250000
           END-EXEC.                                                    01260000
      *                                                                 01270000
      ***************************************************************** 01280000
      * CSS_THD_PRTY TABLE - ZW                                         01290000
      ***************************************************************** 01300000
           EXEC SQL                                                     01310000
             INCLUDE TBTHDPTY                                           01320000
           END-EXEC.                                                    01330000
                                                                        
      ***************************************************************** 01350000
      * CSS_ACCOUNT TABLE - AT                                          01360000
      ***************************************************************** 01370000
           EXEC SQL                                                     01380000
             INCLUDE TBACCT                                             01390000
           END-EXEC.                                                    01400000
      *                                                                 01410000
      ***************************************************************** 01420000
      * CSS_MNT_TRANS_HIST TABLE - MH                                   01430000
      ***************************************************************** 01440000
           EXEC SQL                                                     01450000
               INCLUDE TBMNHIST                                         01460000
           END-EXEC.                                                    01470000
      *                                                                 01480000
      ***************************************************************** 01490000
      * CSS_MT_TRN_HST_DET TABLE - MI                                   01500000
      ***************************************************************** 01510000
           EXEC SQL                                                     01520000
               INCLUDE TBMNHDT                                          01530000
           END-EXEC.                                                    01540000
      *                                                                 01550000
      ****************************************************************  01560000
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'               *  01570000
      ****************************************************************  01580000
      *                                                                 01590000
       COPY FIOJC01.                                                    01600000
      *                                                                 01610000
      ****************************************************************  01620000
      *  ABEND SWITCH COPYBOOK                                       *  01630000
      ****************************************************************  01640000
      *                                                                 01650000
       COPY CWS00038.                                                   01660000
      *                                                                 01670000
       COPY CWS00303.                                                   01680000
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                01690000
                                                                        
      *  ABEND SWITCH COPYBOOK                                          01710000
       COPY CWS09900.                                                   01720000
                                                                        
      *-- COPYBOOK FOR WS-CODES-DATA-PRESENT                            01740000
       COPY CWS00056.                                                   01750000
      *                                                                 01760000
      * -- USED BY CPD0303B                                             01770000
      * WS ABEND WORK AREA                                              01780000
       COPY CWS00010.                                                   01790000
      *                                                                 01800000
      * WS-PURGE-MONTHS                                                 01810000
       COPY CWSPURGE.                                                   01820000
      *                                                                 01830000
      ***************************************************************** 01840000
      * CURSOR GETTING DETAILS FROM CSS_THD_PRTY WITH ACTIVE ACCOUNT  * 01850000
      * AND IN PENDING STATUS IN ACCOUNT TABLE OR WITH STATUS INACTIVE* 01860000
      * ACCOUNTS IN CSS_THD_PRTY TABLE.                               * 01870000
      ***************************** *********************************** 01880000
      *                                                                 01890000
           EXEC SQL                                                     
                DECLARE THIRD_PRTY CURSOR FOR                           
                SELECT  ZW.THD_PRTY_ID                                  
                       ,ZW.ACCOUNT_NO                                   
                       ,ZW.THD_PRTY_STATUS                              
                       ,ZW.DATE_INACTIVE                                
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.CODES_DATA_PRESENT                           
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') ACCT_CREATE_DT        
                  FROM  CSS_THD_PRTY ZW                                 
                       ,CSS_ACCOUNT AT                                  
                 WHERE  ZW.ACCOUNT_NO         = AT.ACCOUNT_NO           
                 AND   ((AT.CODE_ACCT_STAT    = 'P' AND                 
                        ZW.THD_PRTY_STATUS    = 'A')                    
                 OR ZW.THD_PRTY_STATUS = 'I')                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01900000
MFA-TR*         DECLARE THIRD_PRTY CURSOR FOR                           01910000
MFA-TR*         SELECT  ZW.THD_PRTY_ID                                  01920000
MFA-TR*                ,ZW.ACCOUNT_NO                                   01930000
MFA-TR*                ,ZW.THD_PRTY_STATUS                              01940000
MFA-TR*                ,ZW.DATE_INACTIVE                                01950000
MFA-TR*                ,AT.CODE_ACCT_STAT                               01960000
MFA-TR*                ,AT.CODES_DATA_PRESENT                           01970000
MFA-TR*                ,AT.ACCT_CREATE_DT                               01980000
MFA-TR*           FROM  CSS_THD_PRTY ZW                                 01990000
MFA-TR*                ,CSS_ACCOUNT AT                                  02000000
MFA-TR*          WHERE  ZW.ACCOUNT_NO         = AT.ACCOUNT_NO           02010000
MFA-TR*          AND   ((AT.CODE_ACCT_STAT    = 'P' AND                 02020000
MFA-TR*                 ZW.THD_PRTY_STATUS    = 'A')                    02030000
MFA-TR*          OR ZW.THD_PRTY_STATUS = 'I')                           02040000
MFA-TR*    END-EXEC.                                                    02050000
      *                                                                 02060000
      ****************************************************************  02070000
       PROCEDURE DIVISION.                                              
      ****************************************************************  02090000
      *                                                                 02100000
       0000-MAINLINE.                                                   
      *                                                                 02120000
           PERFORM 0100-INILIZATION-PARA       THRU 0100-EXIT.          
                                                                        
           PERFORM 7200-SET-THD-PRTY-PURGE-DT  THRU 7200-EXIT.          
           PERFORM 1300-PROCESS-THD-PRTY       THRU 1300-EXIT.          
      *                                                                 02170000
           MOVE WS-JOB-PARM-ERR-CODE              TO RETURN-CODE.       
      *                                                                 02190000
           PERFORM 2000-PRINT-TOTALS           THRU 2000-EXIT.          
           DISPLAY '******PROCESS COMPLETED SUCCESSFULLY******'.        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02260000
      ****************************************************************  02270000
      * GET NUMBER OF MONTHS FROM CSS_JOB_PARM                       *  02280000
      ****************************************************************  02290000
      *                                                                 02300000
       0100-INILIZATION-PARA.                                           
      *                                                                 02320000
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
                                                                        
           PERFORM 7600P-START-FCSJC01        THRU 7600P-EXIT.          
           PERFORM 0125-READ-JOB-PARM-VALUES  THRU 0125-EXIT.           
           PERFORM 7611P-CLOSE                THRU 7611P-EXIT.          
      *                                                                 02390000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02420000
      ****************************************************************  02430000
      * READ MONTHS FROM CSS_JOB_PARM                       *           02440000
      ****************************************************************  02450000
                                                                        
       0125-READ-JOB-PARM-VALUES.                                       
                                                                        
           MOVE  +1                    TO   WS-I.                       
                                                                        
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD=')               
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD='               
              AND INPUT-ACTIVE                                          
                 MOVE WS-INPUT-DATA-BREAKDOWN(10:4) TO WS-CHKP-UPD-LIMIT
           ELSE                                                         
              MOVE WS-DEFAULT-CHKP-UPD-LIMIT  TO WS-CHKP-UPD-LIMIT      
              DISPLAY '**JOB PARM NOT ACTIVE FOR CHKP-UPD**'            
              DISPLAY '**DEFAULT OF ' WS-CHKP-UPD-LIMIT                 
                      ' WILL BE USED**'                                 
              DISPLAY '**PROCESS CONTINUING**'                          
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
                                                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_THD_PRTY      ')     
             OR END-OF-SYSIPT.                                          
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_THD_PRTY      '      
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA          TO  WS-JOB-PARM-DATA        
                 MOVE WS-JP-PURGE-MO-1      TO  WS-MONTHS-VALUEI        
                 MOVE WS-MONTHS-VALUEI      TO  WS-THD-INACTIVE-MO      
                 MOVE WS-JP-PURGE-MO-2      TO  WS-MONTHS-VALUEP        
                 MOVE WS-MONTHS-VALUEP      TO  WS-THD-PENDING-MO       
                 IF WS-THD-INACTIVE-MO >= 024                           
                    MOVE 'Y'                TO WS-THD-INACTIVE-DEL      
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM TBL THD_PRTY: '    
                           WS-THD-INACTIVE-MO                           
                   DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_THD_PRTY'  
                   DISPLAY '       '                                    
                 END-IF                                                 
                 IF WS-THD-PENDING-MO >= 006                            
                    MOVE 'Y'                TO WS-THD-PENDING-DEL       
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM TBL THD_PRTY: '    
                           WS-THD-PENDING-MO                            
                   DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_THD_PRTY'  
                   DISPLAY '       '                                    
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_THD_PRTY'         
                 DISPLAY 'NO ROWS ARE PROCESSED FOR CSS_THD_PRTY'       
                 DISPLAY '       '                                      
              END-IF                                                    
            ELSE                                                        
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_THD_PRTY '          
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_THD_PRTY'          
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                 03140000
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03170000
      ****************************************************************  03180000
      * FETCHING & DELETING THE RECORDS FROM CSS_THD_PRTY  ACCOUNTS  *  03190000
      ****************************************************************  03200000
      *                                                                 03210000
       1300-PROCESS-THD-PRTY.                                           
      *                                                                 03230000
           INITIALIZE WS-COMMIT-COUNT                                   
           PERFORM 7210-OPEN-THIRD-PRTY-CURSOR  THRU 7210-EXIT          
           PERFORM 7220-FETCH-THIRD-PRTY-CURSOR THRU 7220-EXIT          
      *                                                                 03270000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1300-PROCESS-THD-PRTY     PRAGRAPH'    
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS TO DELETE IN  *'                    
              DISPLAY '* CSS_THD_PRTY    TABLE   *'                     
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF                                                       
      *                                                                 03400000
           PERFORM UNTIL NO-MORE-RECORDS                                
             IF  WS-NULL-INACTIVE = -1                                  
                 MOVE SPACES                 TO    ZW-DATE-INACTIVE     
             END-IF                                                     
             IF  WS-NULL-PENDING  = -1                                  
                 MOVE SPACES                 TO    WS-ACCT-CREATE-DT    
             ELSE                                                       
                 MOVE AT-ACCT-CREATE-DT(1:10) TO   WS-ACCT-CREATE-DT    
             END-IF                                                     
      *                                                                 03500000
                                                                        
              IF  (ZW-THD-PRTY-STATUS = 'A' AND THD-PENDING-DEL)        
                  IF (WS-ACCT-CREATE-DT = '   ') OR                     
                     (WS-ACCT-CREATE-DT <= WS-PENDING-DEL-DT)           
                      MOVE WS-TRANS-COMM-PENDING                        
                                             TO MH-TRAN-COMMENT-TEXT    
                      MOVE +40               TO MH-TRAN-COMMENT-LEN     
                      PERFORM 8130-PROCESS-THD-PRTY THRU 8130-EXIT      
                  END-IF                                                
              ELSE                                                      
                  IF (ZW-THD-PRTY-STATUS = 'I' AND THD-INACTIVE-DEL)    
                    IF (ZW-DATE-INACTIVE  = '    ' )  OR                
                       (ZW-DATE-INACTIVE <= WS-INACTIVE-DEL-DT)         
                        MOVE WS-TRANS-COMM-INACTIVE                     
                                             TO MH-TRAN-COMMENT-TEXT    
                        MOVE +40             TO MH-TRAN-COMMENT-LEN     
                        PERFORM 8130-PROCESS-THD-PRTY                   
                           THRU 8130-EXIT                               
                    END-IF                                              
                  END-IF                                                
              END-IF                                                    
      *                                                                 03720000
                PERFORM 7220-FETCH-THIRD-PRTY-CURSOR THRU 7220-EXIT     
              END-PERFORM                                               
      *                                                                 03750000
            PERFORM 7230-CLOSE-THIRD-PRTY-CURSOR    THRU 7230-EXIT      
            PERFORM 8900-COMMIT THRU 8900-EXIT                          
    *                                                                   
            DISPLAY '      '                                            
            DISPLAY '** NUMBER OF COMMITS FOR'                          
            DISPLAY '** CSS_THD_PRTY  TABLE = ' WS-NBR-COMMIT           
            DISPLAY '      '                                            
            INITIALIZE WS-NBR-COMMIT.                                   
      *                                                                 03840000
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03870000
      ****************************************************************  03880000
      * PRINTS THE TOTAL NO.OF RECORDS DELETED                       *  03890000
      ****************************************************************  03900000
      *                                                                 03910000
       2000-PRINT-TOTALS.                                               
      *                                                                 03930000
           IF THD-INACTIVE-DEL                                          
              DISPLAY '* NO OF RECORDS DELETED IN *'                    
              DISPLAY '*CSS_THD_PRTY TABLE INACTIVE ' WS-INACTIVE-COUNT 
              DISPLAY '         '                                       
           END-IF.                                                      
     *                                                                  
           IF THD-PENDING-DEL                                           
              DISPLAY '* NO OF RECORDS DELETED IN *'                    
              DISPLAY '* CSS_THD_PRTY TABLE:PENDING ' WS-PENDING-COUNT  
              DISPLAY '         '                                       
           END-IF.                                                      
      *                                                                 04050000
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 04080000
      ****************************************************************  04090000
      *DETERMINE DATES USING CURRENT DATE  FOR  PURGING ACCOUNTS     *  04100000
      *IN CSS_THD_PRTY TABLE AND ALSO SETTING CURRENT DATE.          *  04110000
      ****************************************************************  04120000
      *                                                                 04130000
       7200-SET-THD-PRTY-PURGE-DT.                                      
      *                                                                 04150000
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 04170000
           EXEC SQL                                                     
            SELECT
              (DATEADD( MONTH, -(:WS-THD-INACTIVE-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-THD-PENDING-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-INACTIVE-DEL-DT,
              :WS-PENDING-DEL-DT,
              :WS-CURRENT-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     04180000
MFA-TR*     SET                                                         04190000
MFA-TR*       :WS-INACTIVE-DEL-DT     =                                 04200000
MFA-TR*           (DATE (CURRENT DATE) - (:WS-THD-INACTIVE-MO) MONTHS)  04210000
MFA-TR*       ,:WS-PENDING-DEL-DT     =                                 04220000
MFA-TR*           (DATE (CURRENT DATE) - (:WS-THD-PENDING-MO) MONTHS)   04230000
MFA-TR*       ,:WS-CURRENT-DATE       = CURRENT DATE                    04240000
MFA-TR*    END-EXEC.                                                    04250000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           DISPLAY 'WS-INACTIVE-DEL-DT    = ' WS-INACTIVE-DEL-DT        
           DISPLAY 'CURRENT DATE - ' WS-THD-INACTIVE-MO'  MONTHS AGO'   
           DISPLAY 'WS-PENDING-DEL-DT     = ' WS-PENDING-DEL-DT         
           DISPLAY 'CURRENT DATE - ' WS-THD-PENDING-MO'  MONTHS AGO'    
      *                                                                 04310000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP211******************'    
               DISPLAY '* 7200-SET-THD-PRTY-PURGE-DT         *'         
               DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE             
               DISPLAY '* WS-INACTIVE-DEL-DT    *' WS-INACTIVE-DEL-DT   
               DISPLAY '* WS-PENDING-DEL-DT     *' WS-PENDING-DEL-DT    
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSXP211******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 04450000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04480000
      ****************************************************************  04490000
      *  TO GET THE CURRENT TIMESTAMP                                *  04500000
      ****************************************************************  04510000
      *                                                                 04520000
       7400-GET-TIMESTAMP.                                              
      *                                                                 04540000
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                 04560000
           EXEC SQL                                                     
            SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04570000
MFA-TR*     SET :WS-CURRENT-TIMESTAMP  = CURRENT TIMESTAMP              04580000
MFA-TR*    END-EXEC.                                                    04590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04600000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
             DISPLAY '*****************PCSXP211******************'      
             DISPLAY '* 7200-SET-THD-PRTY-PURGE-DT         *'           
             DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE               
             DISPLAY '* PROGRAM ABENDING...                     *'      
             DISPLAY '*****************PCSXP211******************'      
             PERFORM 9900-ABEND  THRU  9900-EXIT                        
           END-IF.                                                      
      *                                                                 04720000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04750000
      ****************************************************************  04760000
      **    COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING          *  04770000
      **    7600P-START-FCSJC01                                      *  04780000
      ****************************************************************  04790000
      *                                                                 04800000
           EXEC SQL                                                     04810000
             INCLUDE CPDPURGE                                           04820000
           END-EXEC.                                                    04830000
      *                                                                 04840000
      ****************************************************************  04850000
      * OPENS THD_PRTY  CURSOR                                       *  04860000
      ****************************************************************  04870000
      *                                                                 04880000
       7210-OPEN-THIRD-PRTY-CURSOR.                                     
      *                                                                 04900000
           EXEC SQL                                                     
               OPEN  THIRD_PRTY                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04940000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
             DISPLAY '********** PCSXP211 ABORT  ************'          
             DISPLAY '* 7210-OPEN-THIRD-PRTY-CURSOR         *'          
             DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE             
             DISPLAY '* PROGRAM ABORTING...                 *'          
             DISPLAY '********** PCSXP211  ABORT ************'          
             PERFORM 9900-ABEND THRU 9900-EXIT                          
           END-IF.                                                      
      *                                                                 05060000
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05090000
      ****************************************************************  05100000
      * FETCHES THD_PRTY CURSOR ACCOUNTS                             *  05110000
      ****************************************************************  05120000
      *                                                                 05130000
       7220-FETCH-THIRD-PRTY-CURSOR.                                    
      *                                                                 05150000
           EXEC SQL                                                     
               FETCH THIRD_PRTY                                         
                INTO  :ZW-THD-PRTY-ID                                   
                     ,:ZW-ACCOUNT-NO                                    
                     ,:ZW-THD-PRTY-STATUS                               
                     ,:ZW-DATE-INACTIVE :WS-NULL-INACTIVE                
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-CODES-DATA-PRESENT                            
                     ,:AT-ACCT-CREATE-DT :WS-NULL-PENDING                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05260000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE  'Y'   TO WS-NO-MORE-RECORDS                       
             ELSE                                                       
                DISPLAY '********** PCSXP211 ABORT  ************'       
                DISPLAY '* 7220-FETCH-THIRD-PRTY-CURSOR        *'       
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* PROGRAM ABORTING...                 *'       
                DISPLAY 'ZW-THD-PRTY-ID '     ZW-THD-PRTY-ID            
                DISPLAY '********** PCSXP211  ABORT ************'       
                PERFORM 9900-ABEND THRU 9900-EXIT                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                 05430000
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05460000
      ****************************************************************  05470000
      * CLOSES THIRD_PRTY CURSOR                                     *  05480000
      ****************************************************************  05490000
      *                                                                 05500000
       7230-CLOSE-THIRD-PRTY-CURSOR.                                    
      *                                                                 05520000
           EXEC SQL                                                     
               CLOSE THIRD_PRTY                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05560000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
             DISPLAY '********** PCSXP211 ABORT  ************'          
             DISPLAY '* 7230-CLOSE-THIRD-PRTY-CURSOR        *'          
             DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE             
             DISPLAY '* PROGRAM ABORTING...                 *'          
             DISPLAY '********** PCSXP211  ABORT ************'          
             PERFORM 9900-ABEND THRU 9900-EXIT                          
           END-IF.                                                      
      *                                                                 05680000
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05710000
      ****************************************************************  05720000
      * PROCESS FOR DELETEING RECORDS FROM CSS_THD_PRTY TABLE        *  05730000
      * AND ALSO UPDATING THE ACCOUNT & MH & MI TABLES.              *  05740000
      ****************************************************************  05750000
      *                                                                 05760000
       8130-PROCESS-THD-PRTY.                                           
      *                                                                 05780000
           PERFORM 8160-DELETE-THD-PRTY THRU 8160-EXIT                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 8200-UPD-CODES-DATA-PRESENT  THRU 8200-EXIT       
              PERFORM 8300-UPD-TRANS-HIST          THRU 8300-EXIT       
              PERFORM 8140-COMMIT-THD-PRTY         THRU 8140-EXIT       
           END-IF .                                                     
      *                                                                 05850000
       8130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05880000
      ****************************************************************  05890000
      *COMMIT PROCESS FOR CSS_THD_PRTY TABLE AND ALSO COUNTING OF    *  05900000
      *PENDING AND INACTIVE ACOOUNTS.                                *  05910000
      ****************************************************************  05920000
      *                                                                 05930000
       8140-COMMIT-THD-PRTY.                                            
      *                                                                 05950000
           ADD WS-1 TO WS-COMMIT-COUNT                                  
           IF ZW-THD-PRTY-STATUS = 'A'                                  
              ADD WS-1 TO WS-PENDING-COUNT                              
           ELSE                                                         
              ADD WS-1 TO WS-INACTIVE-COUNT                             
           END-IF                                                       
           IF WS-COMMIT-COUNT >= WS-1000                                
              PERFORM 8900-COMMIT THRU 8900-EXIT                        
              INITIALIZE WS-COMMIT-COUNT                                
           END-IF.                                                      
      *                                                                 06060000
       8140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06090000
      ****************************************************************  06100000
      * DELETES RECORDS FROM CSS_THD_PRTY                            *  06110000
      ****************************************************************  06120000
      *                                                                 06130000
       8160-DELETE-THD-PRTY.                                            
      *                                                                 06150000
           EXEC SQL                                                     
                DELETE FROM ZW                              
                FROM CSS_THD_PRTY ZW
                 WHERE  ZW.THD_PRTY_ID = :ZW-THD-PRTY-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                     06160000
MFA-TR*         DELETE FROM CSS_THD_PRTY  ZW                            06170000
MFA-TR*          WHERE  ZW.THD_PRTY_ID = :ZW-THD-PRTY-ID                06180000
MFA-TR*    END-EXEC.                                                    06190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06200000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 06220000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
             DISPLAY '********** PCSXP211 ABORT  ************'          
             DISPLAY '* 8160-DELETE-THD-PRTY                *'          
             DISPLAY '* SQLCODE IS: '  WS-ACTIVE-RETURN-CODE            
             DISPLAY '*ZW-THD-PRTY-ID       =' ZW-THD-PRTY-ID           
             DISPLAY '* PROGRAM ABORTING...                 *'          
             DISPLAY '********** PCSXP211  ABORT ************'          
             PERFORM 9900-ABEND THRU 9900-EXIT                          
           END-IF.                                                      
      *                                                                 06340000
       8160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06370000
      ******************************************************************06380000
      *  8200-UPD-CODES-DATA-PRESENT                                   *06390000
      *      UPDATE CODES_DATA_PRESENT ON CSS_ACCOUNT TABLE            *06400000
      ******************************************************************06410000
      *                                                                 06420000
       8200-UPD-CODES-DATA-PRESENT.                                     
      *                                                                 06440000
           MOVE  ZW-ACCOUNT-NO           TO  AT-ACCOUNT-NO              
           MOVE  AT-CODES-DATA-PRESENT   TO  WS-CODES-DATA-PRESENT      
           MOVE  WS-CODE-THIRD-PTY       TO  WS-PREV-CODE-THIRD-PTY     
           MOVE  SPACES                  TO  WS-CODE-THIRD-PTY          
           MOVE  WS-CODES-DATA-PRESENT   TO  AT-CODES-DATA-PRESENT      
      *                                                                 06500000
           PERFORM 8600-UPD-ACCT-TAB     THRU 8600-EXIT.                
      *                                                                 06520000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06550000
      ******************************************************************06560000
      *  8300-UPD-TRANS-HIST                                           *06570000
      *    ADD ROWS TO MAINT TRANS HIST AND DETAIL TABLES              *06580000
      ******************************************************************06590000
      *                                                                 06600000
       8300-UPD-TRANS-HIST.                                             
      *                                                                 06620000
           MOVE '8300'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 06640000
           PERFORM 7400-GET-TIMESTAMP       THRU 7400-EXIT.             
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO     
                                               MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE SPACES                      TO MH-RESP-AREA-ID.         
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE ZW-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-SYSTEM                   TO MH-USER-ID.              
           MOVE WS-PGRMNAME                 TO MH-APPL-PROGRAM-ID.      
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE 'THD PRTY ID'               TO MI-COLUMN-DESC.          
           MOVE +1                          TO MI-TRAN-APPL-NO.         
           MOVE ZW-THD-PRTY-ID              TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE 10                          TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 9                           TO MI-CHG-COLUMN-VALUE-LEN. 
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                 06840000
           IF WS-PREV-CODE-THIRD-PTY NOT EQUAL WS-CODE-THIRD-PTY        
              ADD  +1                       TO MI-TRAN-APPL-NO          
              MOVE 'CODE THIRD PTY'         TO MI-COLUMN-DESC           
              MOVE 1                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-PREV-CODE-THIRD-PTY   TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                 06940000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06970000
      ******************************************************************06980000
      *  8600-UPD-ACCT-TAB.                                            *06990000
      *    UPDATES THE ACCOUNT TABLE.                                  *07000000
      ******************************************************************07010000
      *                                                                 07020000
       8600-UPD-ACCT-TAB.                                               
      *                                                                 07040000
           MOVE '8600'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 07060000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET  CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT      
                      ,LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP()          
               WHERE   ACCOUNT_NO         = :AT-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     07070000
MFA-TR*        UPDATE CSS_ACCOUNT                                       07080000
MFA-TR*           SET  CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT      07090000
MFA-TR*               ,LAST_UPDATE_TS     =  CURRENT TIMESTAMP          07100000
MFA-TR*        WHERE   ACCOUNT_NO         = :AT-ACCOUNT-NO              07110000
MFA-TR*    END-EXEC.                                                    07120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07130000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 07150000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************PCSXP211 ABORT****************'      
              DISPLAY '** CSS_ACCOUNT TABLE                      '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 8200 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*********PCSXP211 ABORT*******************'      
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                 07270000
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07300000
      ******************************************************************07310000
      *  COPYBOOK TO INSERT DATA INTO 6530-LOAD-MNT-TRANS-HIST         *07320000
      ******************************************************************07330000
           EXEC SQL                                                     07340000
              INCLUDE CPD00067                                          07350000
           END-EXEC.                                                    07360000
      *                                                                 07370000
      ****************************************************************  07380000
      *  ISSUES A COMMIT POINT                                       *  07390000
      ****************************************************************  07400000
      *                                                                 07410000
       8900-COMMIT.                                                     
      *                                                                 07430000
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07470000
           COMPUTE WS-NBR-COMMIT = WS-NBR-COMMIT + 1.                   
      *                                                                 07490000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07520000
      ****************************************************************  07530000
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  07540000
      ****************************************************************  07550000
      *                                                                 07560000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07610000
      ****************************************************************  07620000
      **  9900-SQL-ERROR-ROUTINE                                    **  07630000
      ****************************************************************  07640000
      *                                                                 07650000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 07670000
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
      *                                                                 07690000
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
      *                                                                 07800000
      ****************************************************************  07810000
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *  07820000
      ****************************************************************  07830000
      *                                                                 07840000
       9900-ABEND.                                                      
      *                                                                 07860000
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                 07940000
       9900-EXIT.                                                       
           EXIT.                                                        
