       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP210.                                           
       DATE-WRITTEN.  18 NOV 2008                                       
       DATE-COMPILED.                                                   
       AUTHOR.   PRIYA.                                                 
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      **                                                             *          
      ** DATE       INITIALS       REASON                            *          
      ** 02/14/09   SP94986        APPL37648-6,9,31,32,49,50         *          
A37648** 08/15/11   DM94438        COLLECTION TABLE DATA PURGE       *          
A37648**                           NEW BUSINESS RULES                *          
A37648**                           ACT37648 - ACTIVITY 74            *          
P00599** 11/21/12   AA97148        CREDIT SIMPLIFICATION CHANGES.    *          
      **                                                             *          
A04568** 1 APR 13   RF10596        CHANGE CREDIT_HIST CURSOR TO      *          
A04568**                           CHECK ITPA_EXISTS_CD.             *          
A04568**                           IF = SPACE, 3 YEARS.              *          
A04568**                           IF NOT = SPACE, 7 YEARS.          *          
      **                                                             *          
A05136**11 MAR 15   RF10596        ADD JOB_PARM AND CURSOR TO        *          
A05136**                           DELETE CSS_CUST_ALERT RECORDS     *          
      **                                                             *          
      ****************************************************************  00130000
      *                  PCSXP210   NARRATIVE                          *00140000
      *    PURPOSE.                                                    *00150000
      *    THIS PROGRAM DOES DELETION OF RECORDS FROM FOLLOWING TABLES *00160000
      *    CSS_CHG_OFF_AMT                                             *00170000
      *    CSS_WH_CROSS_PLUS                                           *00180000
      *    CSS_CREDIT_HIST                                             *00180000
      *    CSS_COLL_ACCT_INFO                                          *00180000
      *    CSS_IVR_NOTICE                                              *00180000
      *    CSS_COLL_ACTIVITY                                           *00180000
      *    CSS_BHV_ACCT_SCORE                                          *00180000
A05136*    CSS_CUST_ALERT                                              *00180000
      *           PER THE RULES IN THE INDIVIDUAL CURSORS              *        
      *                                                                *        
      * PURGE CRITERIA CAN BE FOUND IN THE CSS_JOB_PARM TABLE          *        
      * FOR EACH TABLE. TO SAFEGUARD AGAINST JOB PARM ERRORS AND       *        
      * ACCIDENTALY DELETING MORE DATA THAN INTENDED, THE FOLLOWING    *        
      * HARD CODED VALUES HAVE BEEN ESTABLISHED AS MINIMUM VALUES      *        
      * OF DATA THAT CAN BE DELETED FROM EACH TABLE WITHOUT REQUIRING  *        
      * A PROGRAMMING CHANGE. JOB PARM MONTHS CAN BE CHANGED TO        *        
      * GREATER THAN THE MINIMUM BUT NOT LESS THAN MINIMUM             *        
      *                                                                *        
      * 1. CSS_CHG_OFF_AMT   - 96 MONTHS                               *00170000
      * 2. CSS_WH_CROSS_PLUS - 06 MONTHS OF FINAL BILLED DATE          *00180000
      * 3. CSS_CREDIT_HIST   - 36 MONTHS                               *00180000
      * 4. CSS_COLL_ACCT_INFO-  NEW BUSINESS RULE                      *00180000
      * 5. CSS_IVR_NOTICE    - 03 MONTHS                               *00180000
      * 6. CSS_COLL_ACTIVITY - 13 MONTHS                               *00180000
      * 7. CSS_BHV_ACCT_SCORE - 12 MONTHS                              *00180000
A05136* 8. CSS_CUST_ALERT     - 25 MONTHS                              *00180000
      *                                                                *        
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM     *        
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)              *        
      *                                                                *        
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START- NO          *        
      * RESTART IS NEEDED.                                             *        
      *                                                                *        
      * COMMITS ARE TAKEN                                              *        
      ******************************************************************00190000
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
A37648     SELECT FCSC210-FILE  ASSIGN UT-S-FCSC210                     
A37648                        STATUS IS WS-C210-STATUS.                 
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
A37648 FD  FCSC210-FILE                                                 
A37648     BLOCK CONTAINS 0 RECORDS                                     
A37648     RECORDING MODE IS F                                          
A37648     LABEL RECORDS ARE STANDARD.                                  
A37648  01 FIOC210-REC.                                                 
A37648     05 E-C210-ACCOUNT-NO                PIC 9(13).               
A37648     05 FILLER                           PIC X(01).               
A37648     05 E-C210-LAST-UPDATE-DT            PIC X(10).               
A37648     05 FILLER                           PIC X(01).               
A37648     05 E-C210-PURGE-DATE                PIC X(10).               
A37648     05 FILLER                           PIC X(01).               
A37648     05 E-C210-ACCT-STAT                 PIC X(01).               
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP210'.
MSQ017     COPY MFASQLM.
      *                                                                         
A37648 01  WS-SWITCHES.                                                 
A37648     05  WS-C210-STATUS           PIC X(02).                      
A37648         88  C210-SUCCESSFUL      VALUE '00'.                     
       01  WS-VARIABLES.                                                
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-COMMIT-COUNT             PIC 9(09) VALUE ZEROS.       
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-NBR-COMMIT               PIC 9(9)  VALUE ZEROS.       
A05136     05  WS-CUST-ALERT-COUNT         PIC 9(9)  VALUE ZEROS.       
           05  WS-WHCROSS-COUNT            PIC 9(9)  VALUE ZEROS.       
           05  WS-CHG-OFF-COUNT            PIC 9(9)  VALUE ZEROS.       
           05  WS-CREDITHST-COUNT          PIC 9(9)  VALUE ZEROS.       
      *    05  WS-COLLACCT-COUNT           PIC 9(9)  VALUE ZEROS.               
           05  WS-IVRNOTICE-COUNT          PIC 9(9)  VALUE ZEROS.       
           05  WS-COLLACTIV-COUNT          PIC 9(9)  VALUE ZEROS.       
           05  WS-BHV-ACCT-COUNT           PIC 9(9)  VALUE ZEROS.       
P00599     05  WS-CORRESP-HDR-COUNT        PIC 9(9)  VALUE ZEROS.       
           05  WS-WH-CROSS-DATE            PIC X(26) VALUE SPACES.      
      *                                                                         
A05136     05  WS-CUST-ALERT-DATE          PIC X(10) VALUE SPACES.      
A04568     05  WS-CREDIT-DATE-3            PIC X(10) VALUE SPACES.      
A04568     05  WS-CREDIT-DATE-7            PIC X(10) VALUE SPACES.      
A04568     05  WS-ITPA-SPACE               PIC X     VALUE SPACES.      
A04568     05  WS-CRED-HIST-MO36           PIC S9(4) COMP VALUE 0.      
A04568     05  WS-CRED-HIST-MO84           PIC S9(4) COMP VALUE 0.      
A05136     05  WS-CUST-ALERT-MO            PIC S9(4) COMP VALUE 0.      
      *                                                                         
A37648     05  WS-DATE-MINUS-3-YEARS       PIC X(10) VALUE SPACES.      
A37648     05  WS-DATE-PLUS-13-MONTHS      PIC X(10) VALUE SPACES.      
A37648     05  WS-DATE-PLUS-36-MONTHS      PIC X(10) VALUE SPACES.      
A37648     05  WS-DATE-MINUS-13-MONTHS     PIC X(10) VALUE SPACES.      
A37648     05  WS-DATE-COLL-ACT            PIC X(10) VALUE SPACES.      
A37648     05  WS-COLL-PURGE-DATE          PIC X(10) VALUE SPACES.      
A37648     05  WS-UPDDATE-PLUS-36-MONTHS   PIC X(10) VALUE SPACES.      
A37648     05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
A37648     05  WS-NULL-IND                 PIC S9(4) COMP VALUE +0.     
           05  WS-CHARGE-OFF-DATE          PIC X(10) VALUE SPACES.      
      *    05  WS-COLL1-DATE               PIC X(10) VALUE SPACES.              
           05  WS-IVR-TIMESTAMP            PIC X(26) VALUE SPACES.      
           05  WS-COLL-DATE                PIC X(10) VALUE SPACES.      
           05  WS-BHV-DATE                 PIC X(10) VALUE SPACES.      
P00599     05  WS-CORRESP-DATE             PIC X(10) VALUE SPACES.      
           05  WS-PGRMNAME                 PIC X(8)  VALUE 'PCSXP210'.  
           05  WS-PURGE-MNTHS              PIC 9(03) VALUE 0.           
           05  WS-CHARGE-OFF-MO            PIC S9(4) COMP VALUE 0.      
           05  WS-WH-CROSS-MO              PIC S9(4) COMP VALUE 0.      
           05  WS-COLL-ACCT-MO             PIC S9(4) COMP VALUE 0.      
           05  WS-IVR-NOTICE-MO            PIC S9(4) COMP VALUE 0.      
           05  WS-COLL-ACTIV-MO            PIC S9(4) COMP VALUE 0.      
           05  WS-BHV-ACCT-MO              PIC S9(4) COMP VALUE 0.      
P00599     05  WS-CORRESP-HDR-MO           PIC S9(4) COMP VALUE 0.      
      *                                                                         
A37648     05  WS-COLL-PURGE               PIC X(01) VALUE 'N'.         
A37648         88 COLL-PURGE                         VALUE 'Y'.         
           05  WS-CHARGE-OFF               PIC X(01) VALUE 'N'.         
               88 CHARGE-OFF                         VALUE 'Y'.         
           05  WS-WH-CROSS                 PIC X(01) VALUE 'N'.         
               88 WH-CROSS                           VALUE 'Y'.         
           05  WS-CREDIT-HIST              PIC X(01) VALUE 'N'.         
               88 CREDIT-HIST                        VALUE 'Y'.         
           05  WS-CUST-ALERT               PIC X(01) VALUE 'N'.         
               88 CUST-ALERT                         VALUE 'Y'.         
           05  WS-COLL-ACCT                PIC X(01) VALUE 'N'.         
               88 COLL-ACCT                          VALUE 'Y'.         
           05  WS-IVR-NOTICE               PIC X(01) VALUE 'N'.         
               88 IVR-NOTICE                         VALUE 'Y'.         
           05  WS-COLL-ACTIVITY            PIC X(01) VALUE 'N'.         
               88 COLL-ACTIVITY                      VALUE 'Y'.         
           05  WS-BHV-ACCT-SCORE           PIC X(01) VALUE 'N'.         
               88 BHV-ACCT-SCORE                     VALUE 'Y'.         
P00599     05  WS-CORRESP-HDR              PIC X(01) VALUE 'N'.         
P00599         88 CORRESP-HDR                        VALUE 'Y'.         
           05  WS-CHRG-REV-MONTH.                                       
               10  WS-CHRG-REV-YY          PIC X(4).                    
               10  WS-CHRG-REV-MM          PIC X(2).                    
           05  WS-CHRG-REV-MTH                                          
               REDEFINES WS-CHRG-REV-MONTH PIC 9(6).                    
           05  WS-JOB-PARM-ERR-CODE        PIC 9(02) VALUE 0.           
      *                                                                         
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_CHG_OFF_AMT   SN                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCHGAMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_WH_CROSS_PLUS    WO                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBWCPLUS                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_CREDIT_HIST      CK                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_COLL_ACCT_INFO  IF                                      *          
      ****************************************************************          
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCINF                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_IVR_NOTICE      IY                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBIVRNOT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_COLL_ACTIVITY     YO                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOLACT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_BHV_ACCT_SCORE    KF                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACSCRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CSS_ACCOUNT           AT                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CSS_AR_TRANS_HIST     AR                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBARHIST                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * DCLGEN TABLE(CSS_FIN_WO_ACTION)                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFWACTN                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  06330000
A05136* CSS_CUST_ALERT -  CA                                         *  06340000
      ****************************************************************  06350000
      *                                                                         
A05136     EXEC SQL                                                             
A05136         INCLUDE TBCSTALT                                                 
A05136     END-EXEC.                                                            
      *                                                                         
      ****************************************************************  06330000
P00599* CSS_CORRESP_HDR     - 1J                                     *  06340000
      ****************************************************************  06350000
      *                                                                         
P00599                                                                  
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORHDR                                                 
P00599     END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CSS_JOB_PARM          G6                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'               *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                       *          
      ****************************************************************          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
       COPY CWSPURGE.                                                           
      *                                                                         
      ****************************************************************          
      * CURSOR DECLARATION TO SELECT ALL THE RECORDS THAT ARE OLDER  *          
      * THAN 6 MONTHS AFTER THE ACCOUNT HAS BEEN FINAL-BILLED        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE WH_CROSS CURSOR WITH HOLD FOR                    
                SELECT  WO.APPLICATION_ID                               
                  FROM  CSS_WH_CROSS_PLUS WO WITH(READUNCOMMITTED),             
                        CSS_ACCOUNT       AT WITH(READUNCOMMITTED)              
                 WHERE  AT.ACCOUNT_NO      =  WO.ACCOUNT_NO             
                 AND    AT.CODE_ACCT_STAT  = 'B'                        
                 AND    AT.ACCT_FINALED_DT <  CIS.CHAR2TIMESTAMP(
                                                    :AT-ACCT-FINALED-DT
              )       
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE WH_CROSS CURSOR WITH HOLD FOR                            
MFA-TR*         SELECT  WO.APPLICATION_ID                                       
MFA-TR*           FROM  CSS_WH_CROSS_PLUS WO,                                   
MFA-TR*                 CSS_ACCOUNT       AT                                    
MFA-TR*          WHERE  AT.ACCOUNT_NO      =  WO.ACCOUNT_NO                     
MFA-TR*          AND    AT.CODE_ACCT_STAT  = 'B'                                
MFA-TR*          AND    AT.ACCT_FINALED_DT <  :AT-ACCT-FINALED-DT               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DECLARATION TO SELECT CSS_CREDIT_HIST RECORDS         *          
A04568* WHERE ITPA_EXISTS_CD = SPACE                                 *          
A04568*           AND CR_HIST_TRAN_DT < 3 YEAR OLD                   *          
A04568*                     OR                                       *          
A04568* WHERE ITPA_EXISTS_CD NOT = SPACE                             *          
A04568*           AND CR_HIST_TRAN_DT < 7 YEAR OLD                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
            DECLARE CREDITHST_CURSOR CURSOR WITH HOLD FOR               
             SELECT CK.CUSTOMER_NO                                      
                   ,CK.CR_HIST_TRAN_DT                                  
                   ,REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), 
           ':', '.') CR_HIST_TRAN_TM                                  
               FROM CSS_CREDIT_HIST   CK WITH(READUNCOMMITTED)                  
A04568        WHERE ((CK.ITPA_EXISTS_CD = :WS-ITPA-SPACE                
A04568          AND CK.CR_HIST_TRAN_DT < IIF(TRY_CONVERT(DATE, 
                                                      :WS-CREDIT-DATE-3
              ) IS NULL OR (PATINDEX('%.%', :WS-CREDIT-DATE-3
              ) <> 0) OR (LEN(:WS-CREDIT-DATE-3) <> 10), CIS.CHAR2DATE(
                                                      :WS-CREDIT-DATE-3
              ), CONVERT(DATE, :WS-CREDIT-DATE-3) ))             
A04568            OR (CK.ITPA_EXISTS_CD <> :WS-ITPA-SPACE               
A04568             AND CK.CR_HIST_TRAN_DT < IIF(TRY_CONVERT(DATE, 
                                                      :WS-CREDIT-DATE-7
              ) IS NULL OR (PATINDEX('%.%', :WS-CREDIT-DATE-7
              ) <> 0) OR (LEN(:WS-CREDIT-DATE-7) <> 10), CIS.CHAR2DATE(
                                                      :WS-CREDIT-DATE-7
              ), CONVERT(DATE, :WS-CREDIT-DATE-7) )))         
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE CREDITHST_CURSOR CURSOR WITH HOLD FOR                       
MFA-TR*      SELECT CK.CUSTOMER_NO                                              
MFA-TR*            ,CK.CR_HIST_TRAN_DT                                          
MFA-TR*            ,CK.CR_HIST_TRAN_TM                                          
MFA-TR*        FROM CSS_CREDIT_HIST   CK                                        
MFA-TR*       WHERE ((CK.ITPA_EXISTS_CD = :WS-ITPA-SPACE                        
MFA-TR*         AND CK.CR_HIST_TRAN_DT < :WS-CREDIT-DATE-3)                     
MFA-TR*           OR (CK.ITPA_EXISTS_CD <> :WS-ITPA-SPACE                       
MFA-TR*            AND CK.CR_HIST_TRAN_DT < :WS-CREDIT-DATE-7))                 
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *  COLLECTIONS ACCOUNT CURSOR                                             
      *                                                                         
A37648     EXEC SQL                                                     
A37648      DECLARE COLLACCT_CURSOR CURSOR WITH HOLD FOR                
A37648       SELECT AT.ACCOUNT_NO                                       
A37648             ,AT.CODE_ACCT_STAT                                   
A37648             ,AT.TOTAL_AR_BALANCE                                 
A37648             ,AT.BANKRUPTCY_IND                                   
A37648             ,AT.BNKRPT_CASE_NO                                   
A37648             ,AT.JUDGEMENT_IND                                    
A37648             ,AT.JUDGEMENT_CASE_NO                                
A37648             ,[IF].LAST_UPDATE_DT                                   
A37648             ,[IF].CUSTOMER_NO                                      
A37648         FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                       
A37648              CSS_COLL_ACCT_INFO [IF] WITH(READUNCOMMITTED)               
A37648        WHERE [IF].ACCOUNT_NO = AT.ACCOUNT_NO                       
A37648        AND   [IF].LAST_UPDATE_DT <   DATEADD( MONTH, -36, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )      
A37648        FOR READ ONLY                                     
A37648     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE COLLACCT_CURSOR CURSOR WITH HOLD FOR                        
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*            ,AT.TOTAL_AR_BALANCE                                         
MFA-TR*            ,AT.BANKRUPTCY_IND                                           
MFA-TR*            ,AT.BNKRPT_CASE_NO                                           
MFA-TR*            ,AT.JUDGEMENT_IND                                            
MFA-TR*            ,AT.JUDGEMENT_CASE_NO                                        
MFA-TR*            ,IF.LAST_UPDATE_DT                                           
MFA-TR*            ,IF.CUSTOMER_NO                                              
MFA-TR*        FROM CSS_ACCOUNT AT,                                             
MFA-TR*             CSS_COLL_ACCT_INFO IF                                       
MFA-TR*       WHERE IF.ACCOUNT_NO = AT.ACCOUNT_NO                               
MFA-TR*       AND   IF.LAST_UPDATE_DT <   CURRENT DATE - 36 MONTHS              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DECLARATION TO SELECT CSS_COLL_ACCT_INFO ACCOUNTS     *          
      * 12 MONTHS AFTER EXPIRED  ACTUAL DATES TBD.                   *          
      ****************************************************************          
      *                                                                         
      *    EXEC SQL                                                             
      *     DECLARE COLLACCT_CURSOR CURSOR WITH HOLD FOR                        
      *      SELECT IF.ACCOUNT_NO                                               
      *        FROM CSS_COLL_ACCT_INFO  AS IF                                   
      *       WHERE IF.LAST_UPDATE_DT < :WS-COLL1-DATE                          
      *       FOR FETCH ONLY WITH UR                                            
      *    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DECLARATION TO SELECT CSS_IVR_NOTICE ACCOUNTS FOR     *          
      * ORIGINAL_CALL_DT MORE THAN 3 MONTHS FROM THE CURRENT DATE    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
            DECLARE IVRNOTICE_CURSOR CURSOR WITH HOLD FOR               
             SELECT IY.ACCOUNT_NO                                       
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), IY.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), IY.CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
               FROM CSS_IVR_NOTICE IY WITH(READUNCOMMITTED)                     
              WHERE IY.CREATED_TS  <  CIS.CHAR2TIMESTAMP(:IY-CREATED-TS)        
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE IVRNOTICE_CURSOR CURSOR WITH HOLD FOR                       
MFA-TR*      SELECT IY.ACCOUNT_NO                                               
MFA-TR*            ,IY.LAST_UPDATE_TS                                           
MFA-TR*            ,IY.CREATED_TS                                               
MFA-TR*        FROM CSS_IVR_NOTICE IY                                           
MFA-TR*       WHERE IY.CREATED_TS  <  :IY-CREATED-TS                            
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DECLARATION TO SELECT ACTIVITY DATE WHICH IS AFTER    *          
      * THAN 13 MONTHS FROM THE CURRENT DATE FROM CSS_COLL_ACTIVITY  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
            DECLARE COLL_CURSOR CURSOR WITH HOLD FOR                    
             SELECT YO.USER_ID                                          
                   ,YO.ACTIVITY_DT                                      
                   ,REPLACE(CONVERT(CHAR(8), YO.ACTIVITY_TIME, 108), 
           ':', '.') ACTIVITY_TIME                                    
               FROM CSS_COLL_ACTIVITY YO                                
              WHERE YO.ACTIVITY_DT < IIF(TRY_CONVERT(DATE, 
                                                        :YO-ACTIVITY-DT
              ) IS NULL OR (PATINDEX('%.%', :YO-ACTIVITY-DT
              ) <> 0) OR (LEN(:YO-ACTIVITY-DT) <> 10), CIS.CHAR2DATE(
                                                        :YO-ACTIVITY-DT
              ), CONVERT(DATE, :YO-ACTIVITY-DT) )                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE COLL_CURSOR CURSOR WITH HOLD FOR                            
MFA-TR*      SELECT YO.USER_ID                                                  
MFA-TR*            ,YO.ACTIVITY_DT                                              
MFA-TR*            ,YO.ACTIVITY_TIME                                            
MFA-TR*        FROM CSS_COLL_ACTIVITY YO                                        
MFA-TR*       WHERE YO.ACTIVITY_DT < :YO-ACTIVITY-DT                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CURSOR TO SELECT RECORDS FROM CSS_BHV_ACCT_SCORE MORE       *          
      *  THAN 1 YEAR.                                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
            DECLARE BHVACCT_CURSOR CURSOR WITH HOLD FOR                 
             SELECT KF.ACCOUNT_NO                                       
               FROM CSS_BHV_ACCT_SCORE KF                               
             WHERE CAST(KF.LAST_UPDATE_TS AS DATE) <  
              IIF(TRY_CONVERT(DATE, :KF-LAST-UPDATE-TS
              ) IS NULL OR (PATINDEX('%.%', :KF-LAST-UPDATE-TS
              ) <> 0) OR (LEN(:KF-LAST-UPDATE-TS
              ) <> 10), CIS.CHAR2DATE(:KF-LAST-UPDATE-TS
              ), CONVERT(DATE, :KF-LAST-UPDATE-TS) )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BHVACCT_CURSOR CURSOR WITH HOLD FOR                         
MFA-TR*      SELECT KF.ACCOUNT_NO                                               
MFA-TR*        FROM CSS_BHV_ACCT_SCORE KF                                       
MFA-TR*      WHERE DATE(KF.LAST_UPDATE_TS) <  :KF-LAST-UPDATE-TS                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
P00599* CURSOR DECLARATION TO SELECT CSS_CORRESP_HDR  RECORDS WHERE  *          
P00599* CORRESP_STMT_DT IS MORE THAN 3 YEAR OLD                      *          
      ****************************************************************          
      *                                                                         
P00599     EXEC SQL                                                     
P00599      DECLARE CORRESPHDR_CURSOR CURSOR WITH HOLD FOR              
P00599       SELECT [1J].CORRESP_ID                                       
P00599             ,[1J].CUSTOMER_NO                                      
P00599             ,[1J].CORRESP_STMT_DT                                  
P00599         FROM CSS_CORRESP_HDR  [1J] WITH(READUNCOMMITTED)                 
P00599        WHERE [1J].CORRESP_STMT_DT < IIF(TRY_CONVERT(DATE, 
                                                       :WS-CORRESP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CORRESP-DATE
              ) <> 0) OR (LEN(:WS-CORRESP-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CORRESP-DATE
              ), CONVERT(DATE, :WS-CORRESP-DATE) )               
P00599        FOR READ ONLY                                     
P00599                                                      
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE CORRESPHDR_CURSOR CURSOR WITH HOLD FOR                      
MFA-TR*      SELECT 1J.CORRESP_ID                                               
MFA-TR*            ,1J.CUSTOMER_NO                                              
MFA-TR*            ,1J.CORRESP_STMT_DT                                          
MFA-TR*        FROM CSS_CORRESP_HDR  1J                                         
MFA-TR*       WHERE 1J.CORRESP_STMT_DT < :WS-CORRESP-DATE                       
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*     QUERYNO 7660                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A05136* CURSOR DECLARATION TO SELECT CSS_CUST_ALERT RECORDS          *          
A05136* WHERE DATE_EXPIRE IS LESS THAN:                              *          
A05136* (WS-CUST-ALERT-DATE = CURRENT DATE - WS-CUST-ALERT-MO)       *          
A05136*           AND CODE_ACCT_STAT = 'B' OR 'S'                    *          
      ****************************************************************          
      *                                                                         
A05136     EXEC SQL                                                     
A05136         DECLARE CUST_ALERT_CSR CURSOR WITH HOLD FOR              
A05136          SELECT  CA.ACCOUNT_NO                                   
A05136                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CA.CUST_ALERT_SEQ_NO, 121), ' ', '-'), ':', '.') 
           CUST_ALERT_SEQ_NO                            
A05136            FROM  CSS_CUST_ALERT CA WITH(READUNCOMMITTED)                 
A05136                 ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
A05136           WHERE  AT.ACCOUNT_NO =  CA.ACCOUNT_NO                  
A05136           AND    CA.CODE_ALERT_TYPE = 'M'                        
A05136           AND    AT.CODE_ACCT_STAT IN ('B', 'S')                 
A05136           AND    CA.DATE_EXPIRE < IIF(TRY_CONVERT(DATE, 
                                                    :WS-CUST-ALERT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CUST-ALERT-DATE
              ) <> 0) OR (LEN(:WS-CUST-ALERT-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CUST-ALERT-DATE
              ), CONVERT(DATE, :WS-CUST-ALERT-DATE) )            
A05136          FOR READ ONLY                                   
P00599                                                      
A05136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CUST_ALERT_CSR CURSOR WITH HOLD FOR                      
MFA-TR*         SELECT  CA.ACCOUNT_NO                                           
MFA-TR*                ,CA.CUST_ALERT_SEQ_NO                                    
MFA-TR*           FROM  CSS_CUST_ALERT CA                                       
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*          WHERE  AT.ACCOUNT_NO =  CA.ACCOUNT_NO                          
MFA-TR*          AND    CA.CODE_ALERT_TYPE = 'M'                                
MFA-TR*          AND    AT.CODE_ACCT_STAT IN ('B', 'S')                         
MFA-TR*          AND    CA.DATE_EXPIRE < :WS-CUST-ALERT-DATE                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 7450                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION-PARA    THRU 0100-EXIT.          
           PERFORM 1000-PURGE-PROCESS          THRU 1000-EXIT.          
           PERFORM 2000-PRINT-TOTALS           THRU 2000-EXIT.          
           DISPLAY '*********PROCESS COMPLETED SUCCESSFULLY*********'   
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET NUMBER OF MONTHS & COMMIT PARM FROM CSS_JOB_PARM*                   
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION-PARA.                                        
      *                                                                         
A37648     OPEN OUTPUT FCSC210-FILE.                                    
A37648     IF C210-SUCCESSFUL                                           
A37648         NEXT SENTENCE                                            
A37648     ELSE                                                         
A37648         DISPLAY '**    PCSXP210 PROCESSING ERROR   **'           
A37648         DISPLAY '**   FCSC210-FILE WILL NOT OPEN   **'           
A37648         DISPLAY '**      PROCESSING TERMINATED     **'           
A37648         DISPLAY 'FILE-STATUS = ' WS-C210-STATUS                  
A37648         PERFORM 9900-ABEND THRU 9900-EXIT                        
A37648     END-IF.                                                      
      *                                                                         
A37648     INITIALIZE  FIOC210-REC.                                     
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
                                                                        
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 0125-READ-FCSJC01  THRU 0125-EXIT                    
               UNTIL END-OF-SYSIPT.                                     
      *                                                                         
A37648*                                                                         
A37648          EXEC SQL                                                
A37648             SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                              
A37648          END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*         EXEC SQL                                                        
MFA-TR*            VALUES CURRENT DATE                                          
MFA-TR*              INTO :WS-CURRENT-DATE                                      
MFA-TR*         END-EXEC.                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A37648          EXEC SQL                                                
A37648              SELECT
              DATEADD( YEAR, -3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-3-YEARS                       
A37648          END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*         EXEC SQL                                                        
MFA-TR*             VALUES  (DATE(:WS-CURRENT-DATE) - 3 YEARS)                  
MFA-TR*               INTO :WS-DATE-MINUS-3-YEARS                               
MFA-TR*         END-EXEC.                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A37648          EXEC SQL                                                
A37648              SELECT
              DATEADD( YEAR, 3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-36-MONTHS                      
A37648          END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*         EXEC SQL                                                        
MFA-TR*             VALUES  (DATE(:WS-CURRENT-DATE) + 3 YEARS)                  
MFA-TR*               INTO :WS-DATE-PLUS-36-MONTHS                              
MFA-TR*         END-EXEC.                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A37648          EXEC SQL                                                
A37648              SELECT
              DATEADD( MONTH, -13, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-13-MONTHS                     
A37648          END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*         EXEC SQL                                                        
MFA-TR*             VALUES  (DATE(:WS-CURRENT-DATE) - 13 MONTHS)                
MFA-TR*               INTO :WS-DATE-MINUS-13-MONTHS                             
MFA-TR*         END-EXEC.                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37648*                                                                         
A37648          EXEC SQL                                                
A37648              SELECT
              DATEADD( MONTH, 13, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-PLUS-13-MONTHS                      
A37648          END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*         EXEC SQL                                                        
MFA-TR*             VALUES  (DATE(:WS-CURRENT-DATE) + 13 MONTHS)                
MFA-TR*               INTO :WS-DATE-PLUS-13-MONTHS                              
MFA-TR*         END-EXEC.                                                       
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                               
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ MONTHS & COMMIT PARM FROM CSS_JOB_PARM                             
      ****************************************************************          
       0125-READ-FCSJC01.                                               
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT.                    
           IF END-OF-SYSIPT                                             
              GO  TO 0125-EXIT                                          
           END-IF.                                                      
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CHG_OFF_AMT    '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
                 MOVE WS-JP-PURGE-MO-1 TO WS-PURGE-MNTHS                
                 MOVE WS-PURGE-MNTHS   TO WS-CHARGE-OFF-MO              
                 IF WS-CHARGE-OFF-MO >= 96                              
                    MOVE 'Y'              TO WS-CHARGE-OFF              
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM TBL FOR CHG-OFF : '
                            WS-CHARGE-OFF-MO                            
                   DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CHG_OFF_AMT'  
                   DISPLAY '       '                                    
                 END-IF                                                 
              ELSE                                                      
                DISPLAY '       '                                       
                DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CHG_OFF_AMT  '     
                DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_CHG_OFF_AMT  '
                DISPLAY '       '                                       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_WH_CROSS_PLUS  '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
                 MOVE WS-JP-PURGE-MO-1 TO WS-PURGE-MNTHS                
                 MOVE WS-PURGE-MNTHS   TO WS-WH-CROSS-MO                
                 IF WS-WH-CROSS-MO >= 6                                 
                    MOVE 'Y'              TO WS-WH-CROSS                
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM TBL OF WHT-CRSS :' 
                            WS-WH-CROSS-MO                              
                   DISPLAY 'NO RECS ARE PROCESSED FOR CSS_WH_CROSS_PLUS'
                   DISPLAY '       '                                    
                 END-IF                                                 
              ELSE                                                      
                   DISPLAY '       '                                    
                  DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_WH_CROSS_PLUS'   
                  DISPLAY 'NO RECS ARE PROCESSED FOR CSS_WH_CROSS_PLUS' 
                  DISPLAY '            '                                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
A05136     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CUST_ALERT     '     
A05136        IF INPUT-ACTIVE                                           
A05136           MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
A05136           MOVE WS-JP-PURGE-MO-1 TO WS-PURGE-MNTHS                
A05136           MOVE WS-PURGE-MNTHS   TO WS-CUST-ALERT-MO              
A05136           IF WS-CUST-ALERT-MO > 0                                
A05136              MOVE 'Y' TO WS-CUST-ALERT                           
A05136           ELSE                                                   
A05136              MOVE 3 TO  WS-JOB-PARM-ERR-CODE                     
A05136              DISPLAY '****************************************'  
A05136              DISPLAY 'MONTHS ON CSS_JOB_PARM ARE NOT VALID '     
A05136              DISPLAY 'MTHS VALUE FOR CSS_CUST_ALERT = '          
A05136                       WS-CUST-ALERT-MO                           
A05136              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CUST_ALERT'  
A05136              DISPLAY '****************************************'  
A05136           END-IF                                                 
A05136        ELSE                                                      
A05136            DISPLAY '****************************************'    
A05136            DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CUST_ALERT'      
A05136            DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CUST_ALERT'    
A05136            DISPLAY '****************************************'    
A05136        END-IF                                                    
A05136     END-IF.                                                      
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CREDIT_HIST    '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
                 MOVE WS-JP-PURGE-MO-1 TO WS-PURGE-MNTHS                
A04568           MOVE WS-PURGE-MNTHS   TO WS-CRED-HIST-MO36             
      *                                                                         
                 MOVE WS-JP-PURGE-MO-2 TO WS-PURGE-MNTHS                
A04568           MOVE WS-PURGE-MNTHS   TO WS-CRED-HIST-MO84             
      *                                                                         
A04568           IF WS-CRED-HIST-MO36 >= 36                             
A04568                     AND WS-CRED-HIST-MO84 >= 84                  
                    MOVE 'Y'              TO WS-CREDIT-HIST             
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
A04568             DISPLAY 'ONE OR BOTH OF THE MONTHS SUPPLIED THRU'    
A04568                     ' JOB PARM ARE NOT VALID'                    
A04568             DISPLAY 'MONTHS VALUE FROM JOB PARM FOR USE'         
A04568                     ' WITH CREDIT_HIST TABLE : '                 
A04568             DISPLAY ' 36 MONTH =  '  WS-CRED-HIST-MO36           
A04568             DISPLAY ' 84 MONTH =  '  WS-CRED-HIST-MO84           
                   DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CREDIT_HIST'  
                   DISPLAY '       '                                    
                 END-IF                                                 
              ELSE                                                      
                   DISPLAY '       '                                    
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CREDIT_HIST'      
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_CREDIT_HIST' 
                 DISPLAY '       '                                      
              END-IF                                                    
           END-IF.                                                      
A37648*                                                                         
A37648* COLLECTIONS TABLE PARMS WILL BE USED TO ACTIVATE/INACTIVATE ONLY        
A37648* NO DATES WILL BE GOT FOR THE PURGE CRITERIA                             
A37648     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_COLL_ACCT_INFO '     
A37648        IF INPUT-ACTIVE                                           
A37648          MOVE 'Y'              TO WS-COLL-PURGE                  
A37648        ELSE                                                      
A37648          DISPLAY '       '                                       
A37648          DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_COLL_ACCT_INFO'    
A37648         DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_COLL_ACCT_INFO'
A37648          DISPLAY '       '                                       
A37648        END-IF                                                    
A37648     END-IF.                                                      
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_IVR_NOTICE     '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
                 MOVE WS-JP-PURGE-MO-1 TO WS-PURGE-MNTHS                
                 MOVE WS-PURGE-MNTHS   TO WS-IVR-NOTICE-MO              
                 IF WS-IVR-NOTICE-MO >= 03                              
                    MOVE 'Y'              TO WS-IVR-NOTICE              
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE OF JOB PARM TBL IVR_NOTICE :'    
                           WS-IVR-NOTICE-MO                             
                   DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_IVR_NOTICE'
                   DISPLAY '       '                                    
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_IVR_NOTICE'       
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_IVR_NOTICE'  
                 DISPLAY '       '                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_COLL_ACTIVITY  '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
                 MOVE WS-JP-PURGE-MO-1 TO WS-PURGE-MNTHS                
                 MOVE WS-PURGE-MNTHS   TO WS-COLL-ACTIV-MO              
                 IF WS-COLL-ACTIV-MO >= 13                              
                    MOVE 'Y'              TO WS-COLL-ACTIVITY           
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE OF JOB PARM TBL COLL_ACTIVTIY: ' 
                           WS-COLL-ACTIV-MO                             
                   DISPLAY 'NO RECS ARE PROCESSED FOR CSS_COLL_ACTIVITY'
                   DISPLAY '      '                                     
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR  CSS_COLL_ACTIVITY'   
                 DISPLAY 'NO RECORDS ARE PROCE FOR CSS_COLL_ACTIVITY'   
                 DISPLAY '       '                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BHV_ACCT_SCORE '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
                 MOVE WS-JP-PURGE-MO-1 TO WS-PURGE-MNTHS                
                 MOVE WS-PURGE-MNTHS   TO WS-BHV-ACCT-MO                
                 IF WS-BHV-ACCT-MO >= 12                                
                    MOVE 'Y'              TO WS-BHV-ACCT-SCORE          
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE OF JOB PARM TBL BHV_ACCT: '      
                            WS-BHV-ACCT-MO                              
                  DISPLAY 'NO RECS ARE PROCESSED FOR CSS_BHV_ACCT_SCORE'
                   DISPLAY '      '                                     
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY '       '                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BHV_ACCT_SCORE'   
               DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_BHV_ACCT_SCORE'
                 DISPLAY '       '                                      
              END-IF                                                    
           END-IF.                                                      
P00599                                                                  
P00599     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CORRESP_HDR    '     
P00599        IF INPUT-ACTIVE                                           
P00599           MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
P00599           MOVE WS-JP-PURGE-MO-1 TO WS-PURGE-MNTHS                
P00599           MOVE WS-PURGE-MNTHS   TO WS-CORRESP-HDR-MO             
P00599           IF WS-CORRESP-HDR-MO >= 36                             
P00599              MOVE 'Y'              TO WS-CORRESP-HDR             
P00599           ELSE                                                   
P00599             MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
P00599             DISPLAY '       '                                    
P00599             DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
P00599             DISPLAY 'MTHS VALUE FROM JOB PARM TBL CORRESP HDR :' 
P00599                      WS-CORRESP-HDR-MO                           
P00599             DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CORRESP_HDR'  
P00599             DISPLAY '       '                                    
P00599           END-IF                                                 
P00599        ELSE                                                      
P00599             DISPLAY '       '                                    
P00599           DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CORRESP_HDR'      
P00599           DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_CORRESP_HDR' 
P00599           DISPLAY '       '                                      
P00599        END-IF                                                    
P00599     END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      * MAIN PURGE PROCESS FOR THE TABLES.                           *          
      ****************************************************************          
      *                                                                         
       1000-PURGE-PROCESS.                                              
      *                                                                         
           PERFORM 7200-SET-PURGE-DATES       THRU 7200-EXIT.           
           MOVE    WS-CHARGE-OFF-DATE(1:4)    TO WS-CHRG-REV-YY.        
           MOVE    WS-CHARGE-OFF-DATE(6:2)    TO WS-CHRG-REV-MM.        
           MOVE    WS-CHRG-REV-MTH            TO SN-WRITE-OFF-MONTH-YR. 
      *                                                                         
           DISPLAY 'WS-CHARGE-OFF-DATE = ' WS-CHARGE-OFF-DATE.          
           DISPLAY 'CURRENT DATE - ' WS-CHARGE-OFF-MO ' MONTHS AGO'.    
           DISPLAY '**********************************************'.    
           DISPLAY 'WS-WH-CROSS-DATE   = ' WS-WH-CROSS-DATE.            
           DISPLAY 'CURRENT DATE - ' WS-WH-CROSS-MO ' MONTHS AGO'.      
           DISPLAY '**********************************************'.    
A04568     DISPLAY ' WS-CREDIT-DATE-3  = ' WS-CREDIT-DATE-3.            
A04568     DISPLAY 'CURRENT DATE - ' WS-CRED-HIST-MO36 ' MONTHS AGO'.   
           DISPLAY '**********************************************'.    
A04568     DISPLAY ' WS-CREDIT-DATE-7  = ' WS-CREDIT-DATE-7.            
A04568     DISPLAY 'CURRENT DATE - ' WS-CRED-HIST-MO84 ' MONTHS AGO'.   
           DISPLAY '**********************************************'.    
           DISPLAY ' WS-IVR-TIMESTAMP = ' WS-IVR-TIMESTAMP.             
           DISPLAY 'CURRENT DATE - ' WS-IVR-NOTICE-MO ' MONTHS AGO'.    
           DISPLAY '**********************************************'.    
           DISPLAY ' WS-COLL-DATE  = ' WS-COLL-DATE.                    
           DISPLAY 'CURRENT DATE - ' WS-COLL-ACTIV-MO ' MONTHS AGO'.    
           DISPLAY '**********************************************'.    
           DISPLAY ' WS-BHV-DATE = '  WS-BHV-DATE.                      
           DISPLAY 'CURRENT DATE - ' WS-BHV-ACCT-MO ' MONTHS AGO'.      
P00599     DISPLAY '**********************************************'.    
P00599     DISPLAY ' WS-CORRESP-DATE = ' WS-CORRESP-DATE.               
P00599     DISPLAY 'CURRENT DATE - ' WS-CORRESP-HDR-MO ' MONTHS AGO'.   
P00599     DISPLAY '**********************************************'.    
A05136     DISPLAY ' WS-CUST-ALERT-DATE  = ' WS-CUST-ALERT-DATE.        
A05136     DISPLAY 'CURRENT DATE - ' WS-CUST-ALERT-MO  ' MONTHS AGO'.   
           DISPLAY '**********************************************'.    
      *                                                                         
           IF CHARGE-OFF                                                
              PERFORM 8120-DELETE-CHARGE-OFF THRU 8120-EXIT             
           END-IF.                                                      
      *                                                                         
           IF WH-CROSS                                                  
              PERFORM 1400-WH-CROSS               THRU 1400-EXIT        
           END-IF.                                                      
      *                                                                         
           IF CREDIT-HIST                                               
              PERFORM 1500-CREDITHST-RD           THRU 1500-EXIT        
           END-IF.                                                      
      *                                                                         
A37648     IF COLL-PURGE                                                
A37648        PERFORM 1600-COLLACCT-INFO          THRU 1600-EXIT        
A37648     END-IF.                                                      
      *                                                                         
           IF IVR-NOTICE                                                
              PERFORM 1700-IVR-NOTICE-INFO        THRU 1700-EXIT        
           END-IF.                                                      
      *                                                                         
           IF COLL-ACTIVITY                                             
               PERFORM 1800-COLL-ACT               THRU 1800-EXIT       
           END-IF.                                                      
      *                                                                         
           IF BHV-ACCT-SCORE                                            
              PERFORM 1900-BHV-ACCT-SCORE         THRU 1900-EXIT        
           END-IF.                                                      
      *                                                                         
P00599     IF CORRESP-HDR                                               
P00599        PERFORM 1910-CORRESP-HDR            THRU 1910-EXIT        
P00599     END-IF.                                                      
      *                                                                         
P05136     IF CUST-ALERT                                                
P05136        PERFORM 1920-CUST-ALERT             THRU 1920-EXIT        
P05136     END-IF.                                                      
      *                                                                         
           MOVE WS-JOB-PARM-ERR-CODE              TO RETURN-CODE.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_WH_CROSS_PLUS OLDER THAN 6 MONTHS   *          
      * AFTER IT IS FINAL BILLED.                                    *          
      ****************************************************************          
      *                                                                         
       1400-WH-CROSS.                                                   
      *                                                                         
           MOVE WS-WH-CROSS-DATE             TO  AT-ACCT-FINALED-DT     
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7310-OPEN-WH-CROSS-CURSOR  THRU 7310-EXIT.           
           PERFORM 7320-FETCH-WH-CROSS-CURSOR THRU 7320-EXIT.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1400-WH-CROSS PARAGRAPH'               
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS TO DELETE IN  *'                    
              DISPLAY '* CSS_WH_CROSS_PLUS TABLE     *'                 
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             PERFORM 8130-DELETE-WH-CROSS-DETAIL THRU 8130-EXIT         
             PERFORM 7320-FETCH-WH-CROSS-CURSOR THRU 7320-EXIT          
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7330-CLOSE-WH-CROSS-CURSOR THRU 7330-EXIT.           
      *                                                                         
           IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                       
              PERFORM 8900-COMMIT THRU 8900-EXIT                        
           END-IF.                                                      
      *                                                                         
           DISPLAY '      '.                                            
           DISPLAY '** NUMBER OF COMMITS FOR'.                          
           DISPLAY '** CSS_WH_CROSS_PLUS TABLE = ', WS-NBR-COMMIT.      
           DISPLAY '      '.                                            
           INITIALIZE WS-NBR-COMMIT.                                    
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * MAIN PARAGRAPH FOR CSS_CREDIT_HIST                           *          
      ****************************************************************          
      *                                                                         
       1500-CREDITHST-RD.                                               
      *                                                                         
A04568*    MOVE WS-CREDIT-DATE TO CK-CR-HIST-TRAN-DT.                           
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7410-OPEN-CREDITHST-CURSOR   THRU 7410-EXIT.         
           PERFORM 7420-FETCH-CREDITHST-CURSOR  THRU 7420-EXIT.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* 1500-CREDITHST-RD      *'                      
              DISPLAY '* NO RECORDS TO DELETE IN  *'                    
              DISPLAY '* CSS_CREDIT_HIST TABLE  *'                      
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8140-DELETE-CREDITHST-ACTIVITY THRU 8140-EXIT     
              PERFORM 7420-FETCH-CREDITHST-CURSOR THRU 7420-EXIT        
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7430-CLOSE-CREDITHST-CURSOR THRU 7430-EXIT.          
      *                                                                         
           IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                       
              PERFORM 8900-COMMIT THRU 8900-EXIT                        
           END-IF.                                                      
      *                                                                         
           DISPLAY '      '.                                            
           DISPLAY '** NUMBER OF COMMITS ON '.                          
           DISPLAY '** CSS_CREDIT_HIST TABLE = ', WS-NBR-COMMIT.        
           DISPLAY '      '.                                            
           INITIALIZE WS-NBR-COMMIT.                                    
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_COLL_ACCT_INFO      *          
      ****************************************************************          
      *                                                                         
A37648 1600-COLLACCT-INFO.                                              
A37648                                                                  
A37648     INITIALIZE WS-COMMIT-COUNT.                                  
A37648     PERFORM 7510-OPEN-COLLACCT-CURSOR  THRU 7510-EXIT.           
A37648     PERFORM 7520-FETCH-COLLACCT-CURSOR THRU 7520-EXIT.           
A37648                                                                  
A37648     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37648        DISPLAY '      '                                          
A37648        DISPLAY 'BEGINNING 1600-COLLACCT-INFO  PARAGRAPH'         
A37648        DISPLAY '      '                                          
A37648     ELSE                                                         
A37648       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
A37648        DISPLAY '      '                                          
A37648        DISPLAY '****************************'                    
A37648        DISPLAY '* NO RECORDS TO DELETE IN   *'                   
A37648        DISPLAY '* CSS_COLL_ACCT_INFO  TABLE *'                   
A37648        DISPLAY '****************************'                    
A37648        DISPLAY '      '                                          
A37648       END-IF                                                     
A37648     END-IF.                                                      
      *                                                                         
A37648     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A37648        PERFORM 8145-VALIDATE-COLLACCT  THRU 8145-EXIT            
A37648        IF COLL-PURGE                                             
A37648         PERFORM 8150-DELETE-COLLACCT-INFO THRU 8150-EXIT         
A37648        END-IF                                                    
A37648        PERFORM 7520-FETCH-COLLACCT-CURSOR THRU 7520-EXIT         
A37648     END-PERFORM.                                                 
A37648                                                                  
A37648     PERFORM 7530-CLOSE-COLLACCT-CURSOR THRU 7530-EXIT.           
A37648                                                                  
A37648     IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                       
A37648        PERFORM 8900-COMMIT THRU 8900-EXIT                        
A37648     END-IF.                                                      
                                                                        
A37648     DISPLAY '      '.                                            
A37648     DISPLAY '** NUMBER OF COMMITS FOR'.                          
A37648     DISPLAY '** CSS_COLL_ACCT_INFO TABLE = ', WS-NBR-COMMIT.     
A37648     DISPLAY '      '.                                            
A37648     INITIALIZE WS-NBR-COMMIT.                                    
                                                                        
A37648 1600-EXIT.                                                       
A37648     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_IVR_NOTICE          *          
      ****************************************************************          
      *                                                                         
       1700-IVR-NOTICE-INFO.                                            
      *                                                                         
           MOVE WS-IVR-TIMESTAMP               TO IY-CREATED-TS         
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7710-OPEN-IVRNOTICE-CURSOR  THRU 7710-EXIT.          
           PERFORM 7620-FETCH-IVRNOTICE-CURSOR THRU 7620-EXIT.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1700-IVR-NOTICE-INFO  PARAGRAPH'       
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS TO DELETE IN   *'                   
              DISPLAY '* CSS_IVR_NOTICE      TABLE *'                   
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8160-DELETE-IVRNOTICE-INFO  THRU 8160-EXIT        
              PERFORM 7620-FETCH-IVRNOTICE-CURSOR THRU 7620-EXIT        
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7630-CLOSE-IVRNOTICE-CURSOR THRU 7630-EXIT.          
      *                                                                         
           IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                       
              PERFORM 8900-COMMIT THRU 8900-EXIT                        
           END-IF.                                                      
      *                                                                         
           DISPLAY '      '.                                            
           DISPLAY '** NUMBER OF COMMITS FOR'.                          
           DISPLAY '** CSS_IVR_NOTICE TABLE = ', WS-NBR-COMMIT.         
           DISPLAY '      '.                                            
           INITIALIZE WS-NBR-COMMIT.                                    
      *                                                                         
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 1800-COLL-ACT                                                *          
      ****************************************************************          
      *                                                                         
       1800-COLL-ACT.                                                   
                                                                        
           MOVE WS-COLL-DATE              TO YO-ACTIVITY-DT             
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7950-OPEN-COLL-CURSOR     THRU 7950-EXIT.            
           PERFORM 7960-FETCH-COLL-CURSOR    THRU 7960-EXIT.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1800-COLL-ACT PARAGRAPH'               
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS TO DELETE IN  *'                    
              DISPLAY '* CSS_COLL_ACTIVITY  TABLE *'                    
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8170-DELETE-COLL-ACTIVITY  THRU 8170-EXIT         
              PERFORM 7960-FETCH-COLL-CURSOR     THRU 7960-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7970-CLOSE-COLL-CURSOR        THRU 7970-EXIT.        
      *                                                                         
           IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                       
              PERFORM 8900-COMMIT THRU 8900-EXIT                        
           END-IF.                                                      
      *                                                                         
           DISPLAY '      '.                                            
           DISPLAY '** NUMBER OF COMMITS ON '.                          
           DISPLAY '** CSS_COLL_ACTIVITY TABLE = ', WS-NBR-COMMIT.      
           DISPLAY '      '.                                            
           INITIALIZE WS-NBR-COMMIT.                                    
      *                                                                         
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_BHV_ACCT_SCORE                      *          
      ****************************************************************          
      *                                                                         
       1900-BHV-ACCT-SCORE.                                             
      *                                                                         
           MOVE WS-BHV-DATE             TO KF-LAST-UPDATE-TS            
           INITIALIZE WS-COMMIT-COUNT.                                  
           PERFORM 7900-OPEN-BHVACCT-CURSOR  THRU 7900-EXIT.            
           PERFORM 7910-FETCH-BHVACCT-CURSOR THRU 7910-EXIT.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1900-BHV-ACCT-SCORE PARAGRAPH'         
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS TO DELETE IN  *'                    
              DISPLAY '* CSS_BHV_ACCT_SCORE TABLE *'                    
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 8180-DELETE-BHV-ACCT-SCORE  THRU 8180-EXIT        
              PERFORM 7910-FETCH-BHVACCT-CURSOR   THRU 7910-EXIT        
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7920-CLOSE-BHVACCT-CURSOR THRU 7920-EXIT.            
      *                                                                         
           IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                       
              PERFORM 8900-COMMIT THRU 8900-EXIT                        
           END-IF.                                                      
      *                                                                         
           DISPLAY '      '.                                            
           DISPLAY '** NUMBER OF COMMITS ON '.                          
           DISPLAY '** CSS_BHV_ACCT_SCORE TABLE = ', WS-NBR-COMMIT.     
           DISPLAY '      '.                                            
           INITIALIZE WS-NBR-COMMIT.                                    
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599******************************************************************        
P00599* 1910-CORRESP-HDR.                                              *        
P00599******************************************************************        
P00599*                                                                         
P00599 1910-CORRESP-HDR.                                                
P00599*                                                                         
P00599     INITIALIZE WS-COMMIT-COUNT.                                  
P00599     PERFORM 7650-OPEN-CORRESPHDR-CURSOR     THRU 7650-EXIT.      
P00599     PERFORM 7660-FETCH-CORRESPHDR-CURSOR    THRU 7660-EXIT.      
P00599*                                                                         
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '      '                                          
P00599        DISPLAY '****************************'                    
P00599        DISPLAY '* 1910-CORRESP-HDR         *'                    
P00599        DISPLAY '* NO RECORDS TO DELETE IN  *'                    
P00599        DISPLAY '* CSS_CORRESP_HDR TABLE    *'                    
P00599        DISPLAY '****************************'                    
P00599        DISPLAY '      '                                          
P00599     END-IF.                                                      
P00599*                                                                         
P00599     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00599        PERFORM 8190-DELETE-CORRESPHDR       THRU 8190-EXIT       
P00599        PERFORM 7660-FETCH-CORRESPHDR-CURSOR THRU 7660-EXIT       
P00599     END-PERFORM.                                                 
P00599*                                                                         
P00599     PERFORM 7670-CLOSE-CORRESPHDR-CURSOR    THRU 7670-EXIT.      
P00599*                                                                         
P00599     IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                       
P00599        PERFORM 8900-COMMIT                  THRU 8900-EXIT       
P00599     END-IF.                                                      
P00599*                                                                         
P00599     DISPLAY '      '.                                            
P00599     DISPLAY '** NUMBER OF COMMITS ON '.                          
P00599     DISPLAY '** CSS_CORRESP_HDR TABLE = ', WS-NBR-COMMIT.        
P00599     DISPLAY '      '.                                            
P00599     INITIALIZE WS-NBR-COMMIT.                                    
P00599*                                                                         
P00599 1910-EXIT.                                                       
P00599     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETE RECORDS FROM CSS_CUST_ALERT                           *          
      ****************************************************************          
      *                                                                         
A05136 1920-CUST-ALERT.                                                 
      *                                                                         
A05136     INITIALIZE WS-COMMIT-COUNT.                                  
A05136     PERFORM 7440-OPEN-CUST_ALERT_CSR  THRU 7440-EXIT.            
A05136     PERFORM 7450-FETCH-CUST_ALERT_CSR THRU 7450-EXIT.            
      *                                                                         
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05136        CONTINUE                                                  
A05136     ELSE                                                         
A05136        DISPLAY '      '                                          
A05136        DISPLAY '****************************'                    
A05136        DISPLAY '* 1920-CUST-ALERT          *'                    
A05136        DISPLAY '* NO RECORDS TO DELETE IN  *'                    
A05136        DISPLAY '* CSS_CUST_ALERT TABLE     *'                    
A05136        DISPLAY '****************************'                    
A05136        DISPLAY '      '                                          
A05136     END-IF.                                                      
      *                                                                         
A05136     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A05136        PERFORM 8195-DELETE-CUST-ALERT    THRU 8195-EXIT          
A05136        PERFORM 7450-FETCH-CUST_ALERT_CSR THRU 7450-EXIT          
A05136     END-PERFORM.                                                 
      *                                                                         
A05136     PERFORM 7460-CLOSE-CUST_ALERT_CSR THRU 7460-EXIT.            
      *                                                                         
A05136     IF WS-COMMIT-COUNT < WS-CHKP-UPD-LIMIT                       
A05136        PERFORM 8900-COMMIT THRU 8900-EXIT                        
A05136     END-IF.                                                      
      *                                                                         
A05136     DISPLAY '      '.                                            
A05136     DISPLAY '** NUMBER OF COMMITS ON '.                          
A05136     DISPLAY '** CSS_CUST_ALERT TABLE = ', WS-NBR-COMMIT.         
A05136     DISPLAY '      '.                                            
A05136     INITIALIZE WS-NBR-COMMIT.                                    
      *                                                                         
A05136 1920-EXIT.                                                       
A05136     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINTS THE TOTAL NO.OF RECORDS DELETED                       *          
      ****************************************************************          
      *                                                                         
       2000-PRINT-TOTALS.                                               
      *                                                                         
           IF CHARGE-OFF                                                
              DISPLAY '*TOT# RECS DELT IN CSS_CHG_OFF_AMT: '            
                                                  WS-CHG-OFF-COUNT      
           END-IF.                                                      
      *                                                                         
           IF WH-CROSS                                                  
              DISPLAY '*TOT# RECS DELT IN CSS_WH_CROSS_PLUS:'           
                                                  WS-WHCROSS-COUNT      
           END-IF.                                                      
      *                                                                         
A05136     IF CUST-ALERT                                                
A05136        DISPLAY '*TOT# RECS DELT IN CSS_CUST-ALERT: '             
A05136                                           WS-CUST-ALERT-COUNT    
A05136     END-IF.                                                      
      *                                                                         
           IF CREDIT-HIST                                               
              DISPLAY '*TOT# RECS DELT IN CSS_CREDIT_HIST:'             
                                                 WS-CREDITHST-COUNT     
           END-IF.                                                      
      **   IF COLL-ACCT                                                         
      *       DISPLAY '*TOT# RECS DELT IN CSS_COLL_ACCT_INTO:'                  
      *                                           WS-COLLACCT-COUNT             
      *    END-IF.                                                              
           IF IVR-NOTICE                                                
              DISPLAY '*TOT# RECS DELT IN CSS_IVR_NOTICE:'              
                                                 WS-IVRNOTICE-COUNT     
           END-IF.                                                      
           IF COLL-ACTIVITY                                             
              DISPLAY '*TOT# RECS DELT IN CSS_COLL_ACTIVITY:'           
                                              WS-COLLACTIV-COUNT        
           END-IF.                                                      
           IF BHV-ACCT-SCORE                                            
              DISPLAY '*TOT# RECS DELT IN CSS_BHV_ACCT_SCORE:'          
                                              WS-BHV-ACCT-COUNT         
           END-IF.                                                      
P00599     IF CORRESP-HDR                                               
P00599        DISPLAY '*TOT# RECS DELT IN CSS_CORRESP_HDR:'             
P00599                                           WS-CORRESP-HDR-COUNT   
P00599     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **    DETERMINE DATES USING CURRENT DATE FOR ALL CURSORS      **          
      ****************************************************************          
      *                                                                         
       7200-SET-PURGE-DATES.                                            
      *                                                                         
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
            SELECT
              (DATEADD( MONTH, -(:WS-CHARGE-OFF-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              REPLACE(REPLACE(CONVERT(CHAR(26), (DATEADD( MONTH, -(
                                                       :WS-WH-CROSS-MO)
              , CIS.CURRENT$TIMESTAMP() )), 121), ' ', '-'), ':', '.'),
              (DATEADD( MONTH, -(:WS-CUST-ALERT-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-CRED-HIST-MO36), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-CRED-HIST-MO84), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              REPLACE(REPLACE(CONVERT(CHAR(26), (DATEADD( MONTH, -(
                                                     :WS-IVR-NOTICE-MO)
              , CIS.CURRENT$TIMESTAMP() )), 121), ' ', '-'), ':', '.'),
              (DATEADD( MONTH, -(:WS-COLL-ACTIV-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-BHV-ACCT-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-CORRESP-HDR-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))
            INTO
              :WS-CHARGE-OFF-DATE,
              :WS-WH-CROSS-DATE,
              :WS-CUST-ALERT-DATE,
              :WS-CREDIT-DATE-3,
              :WS-CREDIT-DATE-7,
              :WS-IVR-TIMESTAMP,
              :WS-COLL-DATE,
              :WS-BHV-DATE,
              :WS-CORRESP-DATE   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET                                                                 
MFA-TR*       :WS-CHARGE-OFF-DATE                                               
MFA-TR*         = (DATE (CURRENT DATE)  -                                       
MFA-TR*                                  (:WS-CHARGE-OFF-MO) MONTHS)            
MFA-TR*      ,:WS-WH-CROSS-DATE                                                 
MFA-TR*         = (TIMESTAMP(CURRENT TIMESTAMP) -                               
MFA-TR*                                  (:WS-WH-CROSS-MO) MONTHS)              
MFA-TR*      ,:WS-CUST-ALERT-DATE                                               
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-CUST-ALERT-MO) MONTHS)            
MFA-TR*      ,:WS-CREDIT-DATE-3                                                 
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-CRED-HIST-MO36) MONTHS)           
MFA-TR*      ,:WS-CREDIT-DATE-7                                                 
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-CRED-HIST-MO84) MONTHS)           
MFA-TR*      ,:WS-COLL1-DATE                                                    
MFA-TR*         = (DATE(CURRENT DATE) -                                         
MFA-TR*                                  36 MONTHS)                             
MFA-TR*      ,:WS-IVR-TIMESTAMP                                                 
MFA-TR*         = (TIMESTAMP(CURRENT TIMESTAMP) -                               
MFA-TR*                               (:WS-IVR-NOTICE-MO) MONTHS)               
MFA-TR*      ,:WS-COLL-DATE                                                     
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-COLL-ACTIV-MO) MONTHS)            
MFA-TR*      ,:WS-BHV-DATE                                                      
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-BHV-ACCT-MO) MONTHS)              
MFA-TR*      ,:WS-CORRESP-DATE                                                  
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-CORRESP-HDR-MO) MONTHS)           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP210******************'    
               DISPLAY '* 7200-SET-PURGE-DATES              *'          
               DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE             
               DISPLAY '* WS-WH-CROSS-DATE  *'                          
                                          WS-WH-CROSS-DATE              
A04568         DISPLAY '* WS-CREDIT-DATE-3 * ' WS-CREDIT-DATE-3         
A04568         DISPLAY '* WS-CREDIT-DATE-7 * ' WS-CREDIT-DATE-7         
      *        DISPLAY '* WS-COLL1-DATE *'                                      
      *                                   WS-COLL1-DATE                         
               DISPLAY '* WS-IVR-TIMESTAMP *'                           
                                          WS-IVR-TIMESTAMP              
               DISPLAY '* WS-COLL-DATE *'                               
                                         WS-COLL-DATE                   
               DISPLAY '* WS-BHV-DATE  *'                               
                                         WS-BHV-DATE                    
P00599         DISPLAY '* WS-CORRESP-DATE *'                            
P00599                                   WS-CORRESP-DATE                
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSXP210******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  05160000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  05170000
      **  *RETRIEVE COMMIT COUNT DETAILS FROM JOB PARM TABLE.        *  05170000
      ****************************************************************  05180000
      *                                                                         
            EXEC SQL                                                    05190000
                INCLUDE CPD00034                                        05200000
            END-EXEC.                                                   05210000
      *                                                                 05220000
      ****************************************************************          
      **    COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING          *          
      **    7600-START-FCSJC01                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * OPENS WH_CROSS   CURSOR                                      *          
      ****************************************************************          
      *                                                                         
       7310-OPEN-WH-CROSS-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN WH_CROSS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7310-OPEN-WH-CROSS-CURSOR           *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES WH_CROSS ROWS MORE THAN 6 MONTHS FROM FINAL BILLED DATE*        
      ****************************************************************          
      *                                                                         
       7320-FETCH-WH-CROSS-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
               FETCH  WH_CROSS                                          
                INTO :WO-APPLICATION-ID                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7320-FETCH-WH-CROSS-CURSOR               *'    
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY 'WO-APPLICATION-ID'     WO-APPLICATION-ID         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES WH_CROSS CURSOR                                       *          
      ****************************************************************          
      *                                                                         
       7330-CLOSE-WH-CROSS-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE WH_CROSS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7330-CLOSE-WH-CROSS-CURSOR               *'    
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS CREDITHST_CURSOR                                       *          
      ****************************************************************          
      *                                                                         
       7410-OPEN-CREDITHST-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN CREDITHST_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7410-OPEN-CREDITHST-CURSOR             *'      
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES CREDITHST_CURSOR                                     *          
      ****************************************************************          
      *                                                                         
       7420-FETCH-CREDITHST-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
               FETCH  CREDITHST_CURSOR                                  
                INTO :CK-CUSTOMER-NO                                    
                    ,:CK-CR-HIST-TRAN-DT                                
                    ,:CK-CR-HIST-TRAN-TM                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7420-FETCH-CREDITHST-CURSOR         *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '* CK-CUSTOMER-NO       = ' CK-CUSTOMER-NO        
              DISPLAY '* CK-CR-HIST-TRAN-DT  = ' CK-CR-HIST-TRAN-DT     
              DISPLAY '* CK-CR-HIST-TRAN-TM  = ' CK-CR-HIST-TRAN-TM     
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES CREDITHST_CURSOR                                      *          
      ****************************************************************          
      *                                                                         
       7430-CLOSE-CREDITHST-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
               CLOSE CREDITHST_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7430-CLOSE-CREDITHST-CURSOR            *'      
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05136* OPENS CSS_CUST_ALERT                                         *          
      ****************************************************************          
      *                                                                         
A05136 7440-OPEN-CUST_ALERT_CSR.                                        
      *                                                                         
A05136     EXEC SQL                                                     
A05136         OPEN CUST_ALERT_CSR                                      
A05136     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05136        CONTINUE                                                  
A05136     ELSE                                                         
A05136        DISPLAY '********** PCSXP210 ABORT  ************'         
A05136        DISPLAY '* OPEN CURSOR ERROR FOR PARAGRAPH     *'         
A05136        DISPLAY '* 7440-OPEN-CUST_ALERT_CSR            *'         
A05136        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
A05136        DISPLAY '***************************************'         
A05136        PERFORM 9900-ABEND THRU 9900-EXIT                         
A05136     END-IF.                                                      
      *                                                                         
A05136 7440-EXIT.                                                       
A05136     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05136* FETCHES CSS_CUST_ALERT                                       *          
      ****************************************************************          
      *                                                                         
A05136 7450-FETCH-CUST_ALERT_CSR.                                       
      *                                                                         
A05136     EXEC SQL                                                     
A05136         FETCH  CUST_ALERT_CSR                                    
A05136          INTO :CA-ACCOUNT-NO                                     
A05136              ,:CA-CUST-ALERT-SEQ-NO                              
A05136     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A05136        CONTINUE                                                  
A05136     ELSE                                                         
A05136        DISPLAY '********** PCSXP210 ABORT  ************'         
A05136        DISPLAY '* FETCH CURSOR ERROR FOR PARAGRAPH    *'         
A05136        DISPLAY '* 7450-FETCH-CUST_ALERT_CSR           *'         
A05136        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
A05136        DISPLAY '* CA-ACCOUNT-NO        = ' CA-ACCOUNT-NO         
A05136        DISPLAY '* CA-CUST-ALERT-SEQ-NO = ' CA-CUST-ALERT-SEQ-NO  
A05136        DISPLAY '***************************************'         
A05136        PERFORM 9900-ABEND THRU 9900-EXIT                         
A05136     END-IF.                                                      
      *                                                                         
A05136 7450-EXIT.                                                       
A05136     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05136* CLOSES CSS_CUST_ALERT                                        *          
      ****************************************************************          
      *                                                                         
A05136 7460-CLOSE-CUST_ALERT_CSR.                                       
      *                                                                         
A05136     EXEC SQL                                                     
A05136         CLOSE CUST_ALERT_CSR                                     
A05136     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05136        CONTINUE                                                  
A05136     ELSE                                                         
A05136        DISPLAY '********** PCSXP210 ABORT  ************'         
A05136        DISPLAY '* CLOSE CURSOR ERROR FOR PARAGRAPH    *'         
A05136        DISPLAY '* 7460-CLOSE-CUST_ALERT_CSR           *'         
A05136        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
A05136        DISPLAY '***************************************'         
A05136        PERFORM 9900-ABEND THRU 9900-EXIT                         
A05136     END-IF.                                                      
      *                                                                         
A05136 7460-EXIT.                                                       
A05136     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS COLLACCT_CURSOR    CURSOR                              *          
      ****************************************************************          
                                                                        
A37648 7510-OPEN-COLLACCT-CURSOR.                                       
                                                                        
A37648     EXEC SQL                                                     
A37648         OPEN COLLACCT_CURSOR                                     
A37648     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A37648     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37648     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37648        CONTINUE                                                  
A37648     ELSE                                                         
A37648        DISPLAY '********** PCSXP210 ABORT  ************'         
A37648        DISPLAY '* 7510-OPEN-COLLACCT-CURSOR          *'          
A37648        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A37648        DISPLAY '* PROGRAM ABORTING...                 *'         
A37648        DISPLAY '********** PCSXP210  ABORT ************'         
A37648        PERFORM 9900-ABEND THRU 9900-EXIT                         
A37648     END-IF.                                                      
                                                                        
A37648 7510-EXIT.                                                       
A37648     EXIT.                                                        
                                                                        
A37648****************************************************************          
A37648* FETCHES COLLACCT_CURSOR    ROWS                              *          
A37648****************************************************************          
                                                                        
A37648 7520-FETCH-COLLACCT-CURSOR.                                      
                                                                        
A37648     EXEC SQL                                                     
A37648         FETCH  COLLACCT_CURSOR                                   
A37648          INTO                                                    
A37648          :AT-ACCOUNT-NO                                          
A37648          ,:AT-CODE-ACCT-STAT                                     
A37648          ,:AT-TOTAL-AR-BALANCE                                   
A37648          ,:AT-BANKRUPTCY-IND                                     
A37648          ,:AT-BNKRPT-CASE-NO                                     
A37648          ,:AT-JUDGEMENT-IND                                      
A37648          ,:AT-JUDGEMENT-CASE-NO                                  
A37648          ,:IF-LAST-UPDATE-DT                                     
A37648          ,:IF-CUSTOMER-NO                                        
A37648     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A37648     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37648     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A37648        CONTINUE                                                  
A37648     ELSE                                                         
A37648        DISPLAY '********** PCSXP210 ABORT  ************'         
A37648        DISPLAY '* 7520-FETCH-COLLACCT-CURSOR            *'       
A37648        DISPLAY '* AT-ACCOUNT-NO IS ' AT-ACCOUNT-NO               
A37648        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A37648        DISPLAY '* PROGRAM ABORTING...                 *'         
A37648        DISPLAY '* AT-ACCOUNT-NO     = ' AT-ACCOUNT-NO            
A37648        DISPLAY '********** PCSXP210  ABORT ************'         
A37648        PERFORM 9900-ABEND THRU 9900-EXIT                         
A37648     END-IF.                                                      
                                                                        
A37648 7520-EXIT.                                                       
A37648     EXIT.                                                        
      *                                                                         
A37648****************************************************************          
A37648* CLOSES COLLACCT_CURSOR                                       *          
A37648****************************************************************          
      *                                                                         
A37648 7530-CLOSE-COLLACCT-CURSOR.                                      
                                                                        
A37648     EXEC SQL                                                     
A37648         CLOSE COLLACCT_CURSOR                                    
A37648     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A37648     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37648     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37648        CONTINUE                                                  
A37648     ELSE                                                         
A37648        DISPLAY '********** PCSXP210 ABORT  ************'         
A37648        DISPLAY '* 7530-CLOSE-COLLACCT-CURSOR          *'         
A37648        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A37648        DISPLAY '* PROGRAM ABORTING...                 *'         
A37648        DISPLAY '********** PCSXP210  ABORT ************'         
A37648        PERFORM 9900-ABEND THRU 9900-EXIT                         
A37648     END-IF.                                                      
                                                                        
A37648 7530-EXIT.                                                       
A37648     EXIT.                                                        
      *                                                                         
A37648 7540-SELECT-ATTORNEY.                                            
A37648     EXEC SQL                                                     
A37648        SELECT TOP(1) ACCOUNT_NO                                        
A37648          INTO :KD-ACCOUNT-NO                                     
A37648          FROM  CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                   
A37648         WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
A37648           AND  FW_ACTION_TYPE_CD = 'ATY'                         
A37648           AND  FW_ACTION_AM > 0                                  
A37648                                           
A37648                                                           
A37648     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :KD-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_FIN_WO_ACTION                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          AND  FW_ACTION_TYPE_CD = 'ATY'                                 
MFA-TR*          AND  FW_ACTION_AM > 0                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A37648     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37648     EVALUATE WS-ACTIVE-RETURN-CODE                               
A37648         WHEN SUCCESSFUL-CALL                                     
A37648             MOVE 'N' TO WS-COLL-PURGE                            
A37648         WHEN NOT-FOUND                                           
A37648             MOVE 'Y' TO WS-COLL-PURGE                            
A37648         WHEN OTHER                                               
A37648             DISPLAY '****************************************'   
A37648             DISPLAY '**  ERROR SELECTING CSS_FIN_WO_ACTION  *'   
A37648             DISPLAY '**  SQLCODE = ' WS-ACTIVE-RETURN-CODE       
A37648             DISPLAY '**  ACCOUNT NO ' AT-ACCOUNT-NO              
A37648             DISPLAY '**  PROCESSING TERMINATED 7540 PARA   **'   
A37648             DISPLAY '****************************************'   
A37648             PERFORM 9900-ABEND THRU 9900-EXIT                    
A37648     END-EVALUATE.                                                
                                                                        
A37648 7540-EXIT.                                                       
A37648     EXIT.                                                        
      *                                                                         
A37648 7545-SELECT-FINWO-ACTION.                                        
                                                                        
A37648     EXEC SQL                                                     
A37648        SELECT TOP(1) ACCOUNT_NO                                        
A37648          INTO :KD-ACCOUNT-NO                                     
A37648          FROM  CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                   
A37648         WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
A37648         AND FW_ACTION_DT  > IIF(TRY_CONVERT(DATE, 
                                                      :WS-DATE-COLL-ACT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-COLL-ACT
              ) <> 0) OR (LEN(:WS-DATE-COLL-ACT) <> 10), CIS.CHAR2DATE(
                                                      :WS-DATE-COLL-ACT
              ), CONVERT(DATE, :WS-DATE-COLL-ACT) )                    
A37648         AND FW_ACTION_TYPE_CD                                    
A37648                IN ('CREDB', '1PLMT','2PLMT','3PLMT','ATY')       
A37648                                           
A37648                                                           
A37648     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ACCOUNT_NO                                                
MFA-TR*         INTO :KD-ACCOUNT-NO                                             
MFA-TR*         FROM  CSS_FIN_WO_ACTION                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        AND FW_ACTION_DT  > :WS-DATE-COLL-ACT                            
MFA-TR*        AND FW_ACTION_TYPE_CD                                            
MFA-TR*               IN ('CREDB', '1PLMT','2PLMT','3PLMT','ATY')               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A37648     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37648     EVALUATE WS-ACTIVE-RETURN-CODE                               
A37648      WHEN SUCCESSFUL-CALL                                        
A37648          MOVE 'N' TO WS-COLL-PURGE                               
A37648      WHEN NOT-FOUND                                              
A37648          MOVE 'Y' TO WS-COLL-PURGE                               
A37648      WHEN OTHER                                                  
A37648             DISPLAY '****************************************'   
A37648             DISPLAY '**  ERROR SELECTING CSS_FIN_WO_ACTION  *'   
A37648             DISPLAY '**  SQLCODE = ' WS-ACTIVE-RETURN-CODE       
A37648             DISPLAY '**  ACCOUNT = ' AT-ACCOUNT-NO               
A37648             DISPLAY '**  PROCESSING TERMINATED 7545 PARA   **'   
A37648             DISPLAY '****************************************'   
A37648             PERFORM 9900-ABEND THRU 9900-EXIT                    
A37648     END-EVALUATE.                                                
                                                                        
A37648 7545-EXIT.                                                       
A37648     EXIT.                                                        
      *                                                                         
A37648 7290-SELECT-AR-TRANSHIST.                                        
                                                                        
A37648     EXEC SQL                                                     
A37648        SELECT TOP(1) 'N'                                               
A37648          INTO :WS-COLL-PURGE                                     
A37648          FROM  CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
A37648         WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
A37648         AND CAST(TRANS_HIST_SEQ_NO AS DATE) > 
              IIF(TRY_CONVERT(DATE, :WS-DATE-MINUS-13-MONTHS
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-MINUS-13-MONTHS
              ) <> 0) OR (LEN(:WS-DATE-MINUS-13-MONTHS
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-MINUS-13-MONTHS
              ), CONVERT(DATE, :WS-DATE-MINUS-13-MONTHS) )   
A37648                                           
A37648                                                           
A37648     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'N'                                                       
MFA-TR*         INTO :WS-COLL-PURGE                                             
MFA-TR*         FROM  CSS_AR_TRANS_HIST                                         
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        AND DATE(TRANS_HIST_SEQ_NO) > :WS-DATE-MINUS-13-MONTHS           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A37648     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37648     EVALUATE WS-ACTIVE-RETURN-CODE                               
A37648         WHEN SUCCESSFUL-CALL                                     
A37648             CONTINUE                                             
A37648         WHEN NOT-FOUND                                           
A37648             MOVE 'Y' TO WS-COLL-PURGE                            
A37648         WHEN OTHER                                               
A37648             DISPLAY '****************************************'   
A37648             DISPLAY '**  ERROR SELECTING CSS_AR_TRANS_HIST **'   
A37648             DISPLAY '**  SQLCODE = ' WS-ACTIVE-RETURN-CODE       
A37648             DISPLAY '**  ACCOUNT = ' AT-ACCOUNT-NO               
A37648             DISPLAY '**  PROCESSING TERMINATED 7290- PARA  **'   
A37648             DISPLAY '****************************************'   
A37648             PERFORM 9900-ABEND THRU 9900-EXIT                    
A37648     END-EVALUATE.                                                
                                                                        
A37648 7290-EXIT.                                                       
A37648     EXIT.                                                        
                                                                        
      ****************************************************************          
      * OPENS IVRNOTICE_CURSOR   CURSOR                              *          
      ****************************************************************          
      *                                                                         
       7710-OPEN-IVRNOTICE-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN IVRNOTICE_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7710-OPEN-IVRNOTICE-CURSOR          *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES IVRNOTICE_CURSOR   ROWS                              *          
      ****************************************************************          
      *                                                                         
       7620-FETCH-IVRNOTICE-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
               FETCH  IVRNOTICE_CURSOR                                  
                INTO :IY-ACCOUNT-NO                                     
                    ,:IY-LAST-UPDATE-TS                                 
                    ,:IY-CREATED-TS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7620-FETCH-IVRNOTICE-CURSOR         *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '* IY-ACCOUNT-NO     = ' IY-ACCOUNT-NO            
              DISPLAY '* IY-ORIGINAL-CALL-DT ' IY-ORIGINAL-CALL-DT      
              DISPLAY '* IY-CREATED-TS     = ' IY-CREATED-TS            
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES IVRNOTICE_CURSOR                                      *          
      ****************************************************************          
      *                                                                         
       7630-CLOSE-IVRNOTICE-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
               CLOSE IVRNOTICE_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7630-CLOSE-IVRNOTICE-6URSOR          *'        
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599******************************************************************        
P00599* 7650-OPEN-CORRESPHDR-CURSOR                                    *        
P00599******************************************************************        
P00599*                                                                         
P00599 7650-OPEN-CORRESPHDR-CURSOR.                                     
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599         OPEN CORRESPHDR_CURSOR                                   
P00599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSXP210 ABORT  ************'         
P00599        DISPLAY '* 7650-OPEN-CORRESPHDR-CURSOR         *'         
P00599        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00599        DISPLAY '* PROGRAM ABORTING...                 *'         
P00599        DISPLAY '********** PCSXP210  ABORT ************'         
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 7650-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                         
P00599******************************************************************        
P00599* 7660-FETCH-CORRESPHDR-CURSOR                                   *        
P00599******************************************************************        
P00599*                                                                         
P00599 7660-FETCH-CORRESPHDR-CURSOR.                                    
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599         FETCH  CORRESPHDR_CURSOR                                 
P00599          INTO :1J-CORRESP-ID                                     
P00599              ,:1J-CUSTOMER-NO                                    
P00599              ,:1J-CORRESP-STMT-DT                                
P00599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSXP210 ABORT  ************'         
P00599        DISPLAY '* 7660-FETCH-CORRESPHDR-CURSOR        *'         
P00599        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00599        DISPLAY '* PROGRAM ABORTING...                 *'         
P00599        DISPLAY '* CORRESP DATE = ' WS-CORRESP-DATE               
P00599        DISPLAY '********** PCSXP210  ABORT ************'         
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 7660-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                         
P00599******************************************************************        
P00599* 7670-CLOSE-CORRESPHDR-CURSOR                                   *        
P00599******************************************************************        
P00599*                                                                         
P00599 7670-CLOSE-CORRESPHDR-CURSOR.                                    
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599         CLOSE CORRESPHDR_CURSOR                                  
P00599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSXP210 ABORT  ************'         
P00599        DISPLAY '* 7670-CLOSE-CORRESPHDR-CURSOR        *'         
P00599        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00599        DISPLAY '* PROGRAM ABORTING...                 *'         
P00599        DISPLAY '********** PCSXP210  ABORT ************'         
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 7670-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                         
      ****************************************************************          
      * OPENS COLL CURSOR                                            *          
      ****************************************************************          
       7950-OPEN-COLL-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN COLL_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7950-OPEN-COLL-CURSOR               *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES COLL-CURSOR ROWS WHICH ARE LESS THAN THE ACTIVITY DAT           
      ****************************************************************          
      *                                                                         
       7960-FETCH-COLL-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
               FETCH  COLL_CURSOR                                       
                INTO :YO-USER-ID                                        
                    ,:YO-ACTIVITY-DT                                    
                    ,:YO-ACTIVITY-TIME                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7960-FETCH-COLL-CURSOR *'                      
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* YO-USER-ID        = ' YO-USER-ID               
              DISPLAY '* YO-ACTIVITY-DT      ' YO-ACTIVITY-DT           
              DISPLAY '* YO-ACTIVITY-TIME  = ' YO-ACTIVITY-TIME         
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES COLL_CURSOR                                           *          
      ****************************************************************          
      *                                                                         
       7970-CLOSE-COLL-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE COLL_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7970-CLOSE-COLL-CURSOR              *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7970-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  OPENS BHVACCT_CURSOR CURSOR                                 *          
      ****************************************************************          
      *                                                                         
       7900-OPEN-BHVACCT-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN BHVACCT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7900-OPEN-BHVACCT-CURSOR            *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES BHV_ACCT_SCORE ROWS WHICH ARE 1 YEAR OLD FROM CURRENT*          
      ****************************************************************          
      *                                                                         
       7910-FETCH-BHVACCT-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH  BHVACCT_CURSOR                                    
                INTO :KF-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7910-FETCH-BHVACCT-CURSOR *'                   
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES BHVACCT_CURSOR                                        *          
      ****************************************************************          
      *                                                                         
       7920-CLOSE-BHVACCT-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE BHVACCT_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 7920-CLOSE-BHVACCT-CURSOR      *'              
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_CHG_OFF_AMT                         *          
      ****************************************************************          
      *                                                                         
       8120-DELETE-CHARGE-OFF.                                          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_CHG_OFF_AMT                             
                WHERE  WRITE_OFF_MONTH_YR < :SN-WRITE-OFF-MONTH-YR      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
              IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  ADD SQLERRD(3)         TO WS-CHG-OFF-COUNT            
                  PERFORM 8900-COMMIT THRU 8900-EXIT                    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 8120-DELETE-CHARGE-OFF              *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_WH_CROSS_PLUS                       *          
      ****************************************************************          
      *                                                                         
       8130-DELETE-WH-CROSS-DETAIL.                                     
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM WO                         
                FROM CSS_WH_CROSS_PLUS WO
                 WHERE APPLICATION_ID     = :WO-APPLICATION-ID          
      *                                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_WH_CROSS_PLUS WO                                
MFA-TR*          WHERE APPLICATION_ID     = :WO-APPLICATION-ID                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
              IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  ADD WS-1 TO WS-COMMIT-COUNT                           
                  ADD WS-1 TO WS-WHCROSS-COUNT                          
              END-IF                                                    
              IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                    
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 8130-DELETE-WH-CROSS-DETAIL              *'    
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_CREDIT_HIST                         *          
      ****************************************************************          
      *                                                                         
       8140-DELETE-CREDITHST-ACTIVITY.                                  
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CK                           
                FROM CSS_CREDIT_HIST CK
                 WHERE CUSTOMER_NO     = :CK-CUSTOMER-NO                
                 AND   CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )            
                 AND   CR_HIST_TRAN_TM = CIS.CHAR2TIME(
                                                    :CK-CR-HIST-TRAN-TM
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CREDIT_HIST CK                                  
MFA-TR*          WHERE CUSTOMER_NO     = :CK-CUSTOMER-NO                        
MFA-TR*          AND   CR_HIST_TRAN_DT = :CK-CR-HIST-TRAN-DT                    
MFA-TR*          AND   CR_HIST_TRAN_TM = :CK-CR-HIST-TRAN-TM                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-COMMIT-COUNT                            
                 ADD WS-1 TO WS-CREDITHST-COUNT                         
              END-IF                                                    
              IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                    
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 8140-DELETE-CREDITHST-ACTIVITY      *'         
              DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '* CK-CUSTOMER-NO       ' CK-CUSTOMER-NO          
              DISPLAY '* CK-CR-HIST-TRAN-DT   ' CK-CR-HIST-TRAN-DT      
              DISPLAY '* CK-CR-HIST-TRAN-TM   ' CK-CR-HIST-TRAN-TM      
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A37648 8145-VALIDATE-COLLACCT.                                          
A37648       IF AT-CODE-ACCT-STAT = 'A'                                 
A37648         IF IF-LAST-UPDATE-DT  < WS-DATE-MINUS-3-YEARS            
A37648            MOVE 'Y' TO WS-COLL-PURGE                             
      *                                                                         
A37648          EXEC SQL                                                
A37648              SELECT
              DATEADD( YEAR, 3, IIF(TRY_CONVERT(DATE, :IF-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :IF-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:IF-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:IF-LAST-UPDATE-DT
              ), CONVERT(DATE, :IF-LAST-UPDATE-DT) ) )
            INTO
              :WS-UPDDATE-PLUS-36-MONTHS                   
A37648          END-EXEC                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*         EXEC SQL                                                        
MFA-TR*             VALUES  (DATE(:IF-LAST-UPDATE-DT) + 3 YEARS)                
MFA-TR*               INTO :WS-UPDDATE-PLUS-36-MONTHS                           
MFA-TR*         END-EXEC                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A37648            MOVE WS-UPDDATE-PLUS-36-MONTHS TO WS-COLL-PURGE-DATE  
A37648         END-IF                                                   
A37648       END-IF                                                     
      *                                                                         
A37648       IF AT-CODE-ACCT-STAT = 'B' OR AT-CODE-ACCT-STAT = 'S'      
A37648          IF AT-TOTAL-AR-BALANCE > 0                              
A37648          OR AT-JUDGEMENT-IND = 'J' OR AT-BANKRUPTCY-IND = 'B'    
A37648             MOVE 'N' TO WS-COLL-PURGE                            
A37648          END-IF                                                  
A37648*                                                                         
A37648          IF COLL-PURGE                                           
A37648            PERFORM 7540-SELECT-ATTORNEY THRU 7540-EXIT           
A37648          END-IF                                                  
A37648*                                                                         
A37648          IF COLL-PURGE                                           
A37648             MOVE WS-DATE-MINUS-13-MONTHS TO WS-DATE-COLL-ACT     
A37648             PERFORM 7545-SELECT-FINWO-ACTION THRU 7545-EXIT      
A37648          END-IF                                                  
A37648*                                                                         
A37648          IF COLL-PURGE                                           
A37648             PERFORM 7290-SELECT-AR-TRANSHIST THRU 7290-EXIT      
A37648          END-IF                                                  
A37648*                                                                         
A37648          IF COLL-PURGE                                           
A37648             MOVE WS-CURRENT-DATE TO WS-DATE-COLL-ACT             
A37648             PERFORM 7545-SELECT-FINWO-ACTION THRU 7545-EXIT      
A37648             IF COLL-PURGE                                        
A37648                MOVE WS-DATE-PLUS-13-MONTHS TO WS-COLL-PURGE-DATE 
A37648             ELSE                                                 
A37648                MOVE WS-DATE-PLUS-36-MONTHS TO WS-COLL-PURGE-DATE 
A37648             END-IF                                               
A37648          END-IF                                                  
A37648*                                                                         
A37648*         IF COLL-PURGE                                                   
A37648*           PERFORM 8150-DELETE-COLLACCT-INFO THRU 8150-EXIT              
A37648*         END-IF                                                          
A37648       END-IF.                                                    
A37648*                                                                         
      *                                                                         
       8145-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * DELETES RECORDS FROM CSS_COLL_ACCT_INFO                      *          
      ****************************************************************          
      *                                                                         
       8150-DELETE-COLLACCT-INFO.                                       
      * THIS CODE BELOW (DECLARE/OPEN/FETCH/CLOSE IS TEMPORARY                  
      * WILL BE REPLACED BY DELETE STATEMENT                                    
           IF WS-COLL-PURGE-DATE < WS-CURRENT-DATE                      
              MOVE WS-CURRENT-DATE TO WS-COLL-PURGE-DATE                
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
               DECLARE FILE_COLL  CURSOR WITH HOLD FOR                  
                SELECT  ACCOUNT_NO, LAST_UPDATE_DT                      
                  FROM  CSS_COLL_ACCT_INFO [IF] WITH(READUNCOMMITTED)           
                 WHERE  ACCOUNT_NO      =  :AT-ACCOUNT-NO               
                 AND    [IF].LAST_UPDATE_DT  < IIF(TRY_CONVERT(DATE, 
                                                    :WS-COLL-PURGE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COLL-PURGE-DATE
              ) <> 0) OR (LEN(:WS-COLL-PURGE-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-COLL-PURGE-DATE
              ), CONVERT(DATE, :WS-COLL-PURGE-DATE) )        
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FILE_COLL  CURSOR WITH HOLD FOR                          
MFA-TR*         SELECT  ACCOUNT_NO, LAST_UPDATE_DT                              
MFA-TR*           FROM  CSS_COLL_ACCT_INFO IF                                   
MFA-TR*          WHERE  ACCOUNT_NO      =  :AT-ACCOUNT-NO                       
MFA-TR*          AND    IF.LAST_UPDATE_DT  < :WS-COLL-PURGE-DATE                
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *    OPEN CURSOR                                                          
           EXEC SQL                                                     
               OPEN FILE_COLL                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* OPEN FILE_COLL CURSOR           *'             
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
                                                                        
      *   FETCH FILE_COLL                                                       
           EXEC SQL                                                     
               FETCH  FILE_COLL                                         
                INTO :IF-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37648        MOVE IF-ACCOUNT-NO TO E-C210-ACCOUNT-NO                   
A37648        MOVE IF-LAST-UPDATE-DT TO E-C210-LAST-UPDATE-DT           
A37648        MOVE WS-COLL-PURGE-DATE TO  E-C210-PURGE-DATE             
A37648        MOVE AT-CODE-ACCT-STAT TO   E-C210-ACCT-STAT              
A37648        PERFORM 8000-WRITE-C210 THRU 8000-EXIT                    
           ELSE                                                         
            IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
              CONTINUE                                                  
            ELSE                                                        
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* FETCH FILE_COLL CURSOR *'                      
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
            CLOSE FILE_COLL                                             
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
      *                                                                         
      *    EXEC SQL                                                             
      *         DELETE FROM CSS_COLL_ACCT_INFO                                  
      *          WHERE ACCOUNT_NO     =  :IF-ACCOUNT-NO                         
      *          AND LAST_UPDATE_DT   <  WS-COLL-PURGE-DATE                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND            
      *       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                        
      *          ADD WS-1 TO WS-COMMIT-COUNT                                    
      *          ADD WS-1 TO WS-COLLACCT-COUNT                                  
      *       END-IF                                                            
      *       IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                            
      *          PERFORM 8900-COMMIT THRU 8900-EXIT                             
      *          INITIALIZE WS-COMMIT-COUNT                                     
      *       END-IF                                                            
      *    ELSE                                                                 
      *       DISPLAY '********** PCSXP210 ABORT  ************'                 
      *       DISPLAY '* 8150-DELETE-COLLACCT-INFO            *'                
      *       DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE                      
      *       DISPLAY '* IF-ACCOUNTN-NO     = ' IF-ACCOUNT-NO                   
      *       DISPLAY '* PROGRAM ABORTING...                 *'                 
      *       DISPLAY '********** PCSXP210  ABORT ************'                 
      *       PERFORM 9900-ABEND THRU 9900-EXIT                                 
      *    END-IF.                                                              
      *                                                                         
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_IVR_NOTICE                          *          
      ****************************************************************          
      *                                                                         
       8160-DELETE-IVRNOTICE-INFO.                                      
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_IVR_NOTICE                              
                 WHERE ACCOUNT_NO     = :IY-ACCOUNT-NO                  
                 AND LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :IY-LAST-UPDATE-TS
              )              
                 AND CREATED_TS       = CIS.CHAR2TIMESTAMP(
                                                         :IY-CREATED-TS
              )                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_IVR_NOTICE                                      
MFA-TR*          WHERE ACCOUNT_NO     = :IY-ACCOUNT-NO                          
MFA-TR*          AND LAST_UPDATE_TS   = :IY-LAST-UPDATE-TS                      
MFA-TR*          AND CREATED_TS       = :IY-CREATED-TS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  ADD WS-1 TO WS-COMMIT-COUNT                           
                  ADD WS-1 TO WS-IVRNOTICE-COUNT                        
              END-IF                                                    
              IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                    
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 8160-DELETE-IVRNOTICE-INFO            *'       
              DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '* IY-ACCOUNT-NO     = ' IY-ACCOUNT-NO            
              DISPLAY '* IY-ORIGINAL-CALL-DT   = ' IY-ORIGINAL-CALL-DT  
              DISPLAY '* IY-CREATED-TS         = ' IY-CREATED-TS        
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_COLL_ACTIVITY                       *          
      ****************************************************************          
      *                                                                         
       8170-DELETE-COLL-ACTIVITY.                                       
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_COLL_ACTIVITY                           
                 WHERE CURRENT OF COLL_CURSOR                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-COMMIT-COUNT                            
                 ADD SQLERRD(3) TO  WS-COLLACTIV-COUNT                  
              END-IF                                                    
              IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                    
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 8170-DELETE-COLL-ACTIVITY           *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA766  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_BHV_ACCT_SCORE                      *          
      ****************************************************************          
      *                                                                         
       8180-DELETE-BHV-ACCT-SCORE.                                      
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_BHV_ACCT_SCORE                          
                 WHERE CURRENT OF BHVACCT_CURSOR                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-COMMIT-COUNT                            
                 ADD SQLERRD(3) TO WS-BHV-ACCT-COUNT                    
              END-IF                                                    
              IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                    
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP210 ABORT  ************'         
              DISPLAY '* 8180-DELETE-BHV-ACCT-SCORE          *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP210  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599******************************************************************        
P00599* DELETES RECORDS FROM CSS_CORRESP_HDR TABLE                     *        
P00599* 8190-DELETE-CORRESPHDR                                         *        
P00599******************************************************************        
P00599*                                                                         
P00599 8190-DELETE-CORRESPHDR.                                          
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599          DELETE FROM CSS_CORRESP_HDR                             
P00599           WHERE CORRESP_ID      = :1J-CORRESP-ID                 
P00599           AND   CUSTOMER_NO     = :1J-CUSTOMER-NO                
P00599           AND   CORRESP_STMT_DT = IIF(TRY_CONVERT(DATE, 
                                                    :1J-CORRESP-STMT-DT
              ) IS NULL OR (PATINDEX('%.%', :1J-CORRESP-STMT-DT
              ) <> 0) OR (LEN(:1J-CORRESP-STMT-DT
              ) <> 10), CIS.CHAR2DATE(:1J-CORRESP-STMT-DT
              ), CONVERT(DATE, :1J-CORRESP-STMT-DT) )            
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CORRESP_HDR                                     
MFA-TR*          WHERE CORRESP_ID      = :1J-CORRESP-ID                         
MFA-TR*          AND   CUSTOMER_NO     = :1J-CUSTOMER-NO                        
MFA-TR*          AND   CORRESP_STMT_DT = :1J-CORRESP-STMT-DT                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599*                                                                         
P00599     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
P00599        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00599           ADD WS-1 TO WS-COMMIT-COUNT                            
P00599           ADD WS-1 TO WS-CORRESP-HDR-COUNT                       
P00599        END-IF                                                    
P00599        IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                    
P00599           PERFORM 8900-COMMIT THRU 8900-EXIT                     
P00599           INITIALIZE WS-COMMIT-COUNT                             
P00599        END-IF                                                    
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSXP210 ABORT  ***************'      
P00599        DISPLAY '* 8190-DELETE-CORRESPHDR                 *'      
P00599        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
P00599        DISPLAY '* CORRESP ID           ' 1J-CORRESP-ID           
P00599        DISPLAY '* CUSTOMER NO          ' 1J-CUSTOMER-NO          
P00599        DISPLAY '* CORRESP STMT DT      ' 1J-CORRESP-STMT-DT      
P00599        DISPLAY '* PROGRAM ABORTING...                    *'      
P00599        DISPLAY '********** PCSXP210  ABORT ***************'      
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 8190-EXIT.                                                       
P00599     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05136* DELETE RECORDS FROM CSS_CUST_ALERT TABLE                     *          
      ****************************************************************          
      *                                                                         
A05136 8195-DELETE-CUST-ALERT.                                          
      *                                                                         
A05136     EXEC SQL                                                     
A05136          DELETE FROM CSS_CUST_ALERT                              
A05136           WHERE ACCOUNT_NO        = :CA-ACCOUNT-NO               
A05136           AND   CUST_ALERT_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :CA-CUST-ALERT-SEQ-NO
              )        
A05136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CUST_ALERT                                      
MFA-TR*          WHERE ACCOUNT_NO        = :CA-ACCOUNT-NO                       
MFA-TR*          AND   CUST_ALERT_SEQ_NO = :CA-CUST-ALERT-SEQ-NO                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A05136     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
A05136        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A05136           ADD WS-1 TO WS-COMMIT-COUNT                            
A05136           ADD WS-1 TO WS-CUST-ALERT-COUNT                        
A05136        END-IF                                                    
A05136        IF WS-COMMIT-COUNT = WS-CHKP-UPD-LIMIT                    
A05136           PERFORM 8900-COMMIT THRU 8900-EXIT                     
A05136           INITIALIZE WS-COMMIT-COUNT                             
A05136        END-IF                                                    
A05136     ELSE                                                         
A05136        DISPLAY '********** PCSXP210 ABORT  ***************'      
A05136        DISPLAY '* CSS_CUST_ALERT DELETE ERROR PARAGRAPH  *'      
A05136        DISPLAY '* 8195-DELETE-CUST-ALERT                 *'      
A05136        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
A05136        DISPLAY '*CA-ACCOUNT-NO        = ' CA-ACCOUNT-NO          
A05136        DISPLAY '*CA-CUST-ALERT-SEQ-NO = ' CA-CUST-ALERT-SEQ-NO   
A05136        DISPLAY '******************************************'      
A05136        PERFORM 9900-ABEND THRU 9900-EXIT                         
A05136     END-IF.                                                      
      *                                                                         
A05136 8195-EXIT.                                                       
A05136     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                       *          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           COMPUTE WS-NBR-COMMIT = WS-NBR-COMMIT + 1.                   
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A37648******************************************************************        
A37648* 8000-WRITE-C210.                                               *        
A37648******************************************************************        
A37648 8000-WRITE-C210.                                                 
      *                                                                         
A37648     WRITE FIOC210-REC.                                           
      *                                                                         
A37648     IF C210-SUCCESSFUL                                           
A37648         NEXT SENTENCE                                            
A37648     ELSE                                                         
A37648         DISPLAY '**    PCSXP320 PROCESSING ERROR   **'           
A37648         DISPLAY '**   WRITE FCSC210-FILE IS FAILED **'           
A37648         DISPLAY '**      PROCESSING TERMINATED     **'           
A37648         DISPLAY ' FILE-STATUS = ' WS-C210-STATUS                 
A37648         PERFORM 9900-ABEND THRU 9900-EXIT                        
A37648     END-IF.                                                      
      *                                                                         
A37648 8000-EXIT.                                                       
A37648     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
