       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP200.                                           
       DATE-WRITTEN.  28 NOV 2008                                       
       DATE-COMPILED.                                                   
       AUTHOR.   MADHAVI CH.                                            
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      **                                                             *          
      ** DATE       INITIALS       REASON                            *          
      ** 11/28/08   MC95456     APPL37648 - ACT 16,17,18,47,53 AND 57*          
P00599** 19/09/2012 AS7C117     DELETES THE RECORDS FROM             *          
P00599**                        CSS_CORRESP_HDR                      *          
P00726** 07/30/2014 WR19680     ADD CHANGES TO DELETE RECORDS FROM   *          
P00726**                        CSS_CRED_ARNGMENT                    *          
ACT278** 10/08/2016 TP7R341     REMOVE STA SUMMARY TABLE             *          
ACT278**  A05460                                                     *          
      ****************************************************************          
      *                   PCSXP200   NARRATIVE                       *          
      *                                                              *          
      * THIS PROGRAM DELETES THE RECORDS FROM THE FOLLOWING TABLES   *          
      * USING THE CSS_CIS_PURGE TABLE                                *          
      * 1.  CSS_CUST_ALERT                                           *          
      * 2.  CSS_GUARANTOR                                            *          
      * 3.  CSS_EXCH_DATA_SENT                                       *          
P00599* 4.  CSS_CORRESP_HDR                                          *          
P00726* 5.  CSS_CRED_ARNGMENT                                                   
      * COMMITS ARE TAKEN                                            *          
      * FOR LAST RUN DATE THE ACCOUNT NUMBER, PURGE DATE AND         *          
      * RULES IN THE INDIVIDUAL CURSORS ARE USED TO DETERMINE THE    *          
      * DATA TO BE PURGED.                                           *          
      * A ROW EXISTS IN THE CSS_JOB_PARM                             *          
      * TABLE FOR EACH TABLE AND THE TABLE WILL ONLY BE PROCESSED    *          
      * IF THE JOB_PARM STATUS = 'A'                                 *          
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM   *          
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)            *          
      *                                                              *          
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START-           *          
      * RESTART IS NOT NEEDED.                                       *          
      *                                                              *          
      * COMMITS ARE TAKEN                                            *          
      ****************************************************************          
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP200'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
           05  WS-NBR-COMMIT               PIC 9(9)  VALUE ZEROS.       
           05  WS-CUST-ALERT-COUNT-B       PIC 9(9)  VALUE ZEROS.       
           05  WS-CUST-ALERT-CMT-CNT       PIC 9(9)  VALUE ZEROS.       
           05  WS-CUST-ALERT-CMT-NO        PIC 9(9)  VALUE ZEROS.       
           05  WS-GUARANTOR-COUNT-B        PIC 9(9)  VALUE ZEROS.       
           05  WS-GUARANTOR-CMT-CNT        PIC 9(9)  VALUE ZEROS.       
           05  WS-GUARANTOR-CMT-NO         PIC 9(9)  VALUE ZEROS.       
           05  WS-EXCH-DATA-COUNT-B        PIC 9(9)  VALUE ZEROS.       
           05  WS-EXCH-DATA-CMT-CNT        PIC 9(9)  VALUE ZEROS.       
           05  WS-EXCH-DATA-CMT-NO         PIC 9(9)  VALUE ZEROS.       
P00599     05  WS-CORR-HDR-COUNT-B         PIC 9(9)  VALUE ZEROS.       
P00599     05  WS-CORR-HDR-CMT-CNT         PIC 9(9)  VALUE ZEROS.       
P00599     05  WS-CORR-HDR-CMT-NO          PIC 9(9)  VALUE ZEROS.       
P00726     05  WS-CRED-ARNG-COUNT-B        PIC 9(9)  VALUE ZEROS.       
P00726     05  WS-CRED-ARNG-CMT-CNT        PIC 9(9)  VALUE ZEROS.       
P00726     05  WS-CRED-ARNG-CMT-NO         PIC 9(9)  VALUE ZEROS.       
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
           05  WS-PURGE-DT                 PIC X(10) VALUE SPACES.      
           05  WS-NULL-IND                 PIC S9(04) COMP VALUE +0.    
      *                                                                         
           05  WS-LAST-RUN-TIMESTAMP.                                   
               10 WS-LAST-TS-TXT           PIC X(20) VALUE              
                                           'LAST RUN TIME STAMP='.      
               10 WS-LAST-RUN-TS           PIC X(26) VALUE SPACES.      
      *                                                                         
           05 WS-PGRMNAME                  PIC X(8)  VALUE 'PCSXP200'.  
           05 WS-SYSTEM                    PIC X(07) VALUE 'SYSTEM '.   
      *                                                                         
           05  WS-CUST-DELETE              PIC X(01) VALUE 'N'.         
               88 CUST-DELETE                        VALUE 'Y'.         
           05  WS-GUAR-DELETE              PIC X(01) VALUE 'N'.         
               88 GUAR-DELETE                        VALUE 'Y'.         
           05  WS-EXCH-DELETE              PIC X(01) VALUE 'N'.         
               88 EXCH-DELETE                        VALUE 'Y'.         
           05  WS-NO-MORE-B-RECORDS        PIC X(01) VALUE 'N'.         
               88 NO-MORE-B-RECORDS                  VALUE 'Y'.         
P00599     05  WS-CORRESP-DELETE           PIC X(01) VALUE 'N'.         
P00599         88 CORRESP-DELETE                     VALUE 'Y'.         
P00726     05  WS-ARNG-DELETE              PIC X(01) VALUE 'N'.         
P00726         88 ARNG-DELETE                        VALUE 'Y'.         
      *                                                                         
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_CUST_ALERT    CA                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTALT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_GUARANTOR     GU                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_EXCH_DATA_SENT EX                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEXCSNT                                                 
           END-EXEC.                                                            
P00599*                                                                         
P00599****************************************************************          
P00599*  CSS_CORRESP_HDR    1J                                       *          
P00599****************************************************************          
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORHDR                                                 
P00599     END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_CIS_PURGE         PG                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPURGE                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CSS_JOB_PARM                                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
P00726*****************************************************************         
P00726*    CSS_CRED_ARNGMENT X1                                       *         
P00726*****************************************************************         
P00726*                                                                         
P00726     EXEC SQL                                                             
P00726         INCLUDE TBCRARNG                                                 
P00726     END-EXEC.                                                            
P00726*                                                                         
P00726*****************************************************************         
P00726*    CSS_CRED_ARNG_SCHD WX                                      *         
P00726*****************************************************************         
P00726*                                                                         
P00726     EXEC SQL                                                             
P00726         INCLUDE TBCRARSC                                                 
P00726     END-EXEC.                                                            
P00726*                                                                         
P00726******************************************************************        
      ****************************************************************          
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'               *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                       *          
      ****************************************************************          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *-- COPYBOOK FOR WS-CODES-DATA-PRESENT                                    
       COPY CWS00056.                                                           
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      * WS-PURGE-MONTHS                                                         
       COPY CWSPURGE.                                                           
      *                                                                         
      ****************************************************************          
      * DECLARE CURSOR FOR                                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE  PURGE_CSR1 CURSOR WITH HOLD FOR                 
                SELECT  PU.ACCOUNT_NO                                   
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), PU.PURGE_TS
           , 121), ' ', '-'), ':', '.') PURGE_TS                               
                  FROM  CSS_CIS_PURGE  PU WITH(READUNCOMMITTED)                 
                  WHERE PU.LAST_UPDATE_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :PU-LAST-UPDATE-TS
              )       
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE  PURGE_CSR1 CURSOR WITH HOLD FOR                         
MFA-TR*         SELECT  PU.ACCOUNT_NO                                           
MFA-TR*                ,PU.PURGE_TS                                             
MFA-TR*           FROM  CSS_CIS_PURGE  PU                                       
MFA-TR*           WHERE PU.LAST_UPDATE_TS   >= :PU-LAST-UPDATE-TS               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P00726     EXEC SQL                                                     
P00726         DECLARE ARNG_CSR CURSOR WITH HOLD FOR                    
P00726          SELECT  ARNG_ID                                         
P00726                 ,COALESCE(MAX(CRED_ARNG_SEQ),0)                    
P00726          FROM    CSS_CRED_ARNG_SCHD WX WITH(READUNCOMMITTED)             
P00726          WHERE   WX.ACCOUNT_NO           = :WX-ACCOUNT-NO        
P00726            AND   WX.ARNG_SCHD_DUE_DT   <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PURGE-DT
              ) <> 0) OR (LEN(:WS-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-PURGE-DT
              ), CONVERT(DATE, :WS-PURGE-DT) )           
P00726          GROUP BY ARNG_ID                                        
P00726          FOR READ ONLY                                   
P00726     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ARNG_CSR CURSOR WITH HOLD FOR                            
MFA-TR*         SELECT  ARNG_ID                                                 
MFA-TR*                ,IFNULL(MAX(CRED_ARNG_SEQ),0)                            
MFA-TR*         FROM    CSS_CRED_ARNG_SCHD WX                                   
MFA-TR*         WHERE   WX.ACCOUNT_NO           = :WX-ACCOUNT-NO                
MFA-TR*           AND   WX.ARNG_SCHD_DUE_DT   <= :WS-PURGE-DT                   
MFA-TR*         GROUP BY ARNG_ID                                                
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
P00726*                                                                         
      ****************************************************************          
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INILIZATION-PARA       THRU 0100-EXIT.          
           PERFORM 2000-PURGE-PROCESS          THRU 2000-EXIT.          
           PERFORM 3500-PRINT-TOTALS-PARA      THRU 3500-EXIT.          
           PERFORM 3700-UPDATE-LAST-RUN-TS     THRU 3700-EXIT.          
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET NUMBER OF MONTHS FROM CSS_JOB_PARM                       *          
      ****************************************************************          
      *                                                                         
       0100-INILIZATION-PARA.                                           
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           PERFORM 7600P-START-FCSJC01        THRU 7600P-EXIT.          
           PERFORM 0125-READ-JOB-PARM-VALUES  THRU 0125-EXIT.           
           PERFORM 7611P-CLOSE                THRU 7611P-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ MONTHS FROM CSS_JOB_PARM                       *                   
      ****************************************************************          
                                                                        
       0125-READ-JOB-PARM-VALUES.                                       
                                                                        
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD=')               
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD='               
              AND INPUT-ACTIVE                                          
                 MOVE WS-INPUT-DATA-BREAKDOWN(10:4) TO WS-CHKP-UPD-LIMIT
           ELSE                                                         
              MOVE WS-DEFAULT-CHKP-UPD-LIMIT  TO WS-CHKP-UPD-LIMIT      
              DISPLAY '**JOB PARM NOT ACTIVE FOR CHKP-UPD**'            
              DISPLAY '**DEFAULT OF ' WS-CHKP-UPD-LIMIT                 
                      ' WILL BE USED**'                                 
              DISPLAY '**PROCESS CONTINUING**'                          
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP=')   
             OR END-OF-SYSIPT.                                          
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP='    
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA(21:26)    TO WS-LAST-RUN-TS          
                 DISPLAY 'LAST RUN TS   : '    WS-LAST-RUN-TS           
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR LAST RUN TIME STAMP'  
                 DISPLAY 'NO RECORDS ARE PROCESSED'                     
                 PERFORM 9900-ABEND          THRU 9900-EXIT             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR LAST RUN TIME STAMP'    
              DISPLAY 'NO RECS ARE PROCESSED FOR LAST RUN TIME STAMP'   
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CUST_ALERT    ')    
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CUST_ALERT    '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO  WS-CUST-DELETE               
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CUST_ALERT '      
                 DISPLAY 'NO RECORDS ARE PROCESSED CSS_CUST_ALERT'      
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_CUST_ALERT '        
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CUST_ALERT '       
              DISPLAY '       '                                         
           END-IF.                                                      
                                                                        
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_GUARANTOR     ')    
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_GUARANTOR     '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO  WS-GUAR-DELETE               
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_GUARANTOR '       
                 DISPLAY 'NO RECORDS ARE PROCESSED CSS_GUARANTOR'       
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_GUARANTOR '         
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_GUARANTOR '        
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
           MOVE  +1                    TO   WS-I.                       
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_EXCH_DATA_SENT  ' ) 
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) =  'CSS_EXCH_DATA_SENT  '   
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO  WS-EXCH-DELETE               
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_EXCH_DATA_SENT'   
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR EXCH_DATA_SENT'  
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_EXCH_DATA_SENT'     
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_EXCH_DATA_SENT'    
              DISPLAY '       '                                         
           END-IF.                                                      
                                                                        
P00599     MOVE  +1                    TO   WS-I.                       
P00599     INITIALIZE WS-SYSIPT.                                        
P00599     PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
P00599        (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CORRESP_HDR   ')    
P00599      OR END-OF-SYSIPT.                                           
P00599                                                                  
P00599     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CORRESP_HDR   '      
P00599        IF INPUT-ACTIVE                                           
P00599           MOVE 'Y'              TO  WS-CORRESP-DELETE            
P00599        ELSE                                                      
P00599           DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CORRESP_HDR '     
P00599           DISPLAY 'NO RECORDS ARE PROCESSED CSS_CORRESP_HDR'     
P00599           DISPLAY '            '                                 
P00599        END-IF                                                    
P00599     ELSE                                                         
P00599        DISPLAY '       '                                         
P00599        DISPLAY 'JOB PARM NOT PRESENT FOR CSS_CORRESP_HDR '       
P00599        DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CORRESP_HDR '      
P00599        DISPLAY '       '                                         
P00599     END-IF.                                                      
      *                                                                         
P00726     MOVE  +1                    TO   WS-I.                       
P00726     INITIALIZE WS-SYSIPT.                                        
P00726     PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
P00726        (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CRED_ARNGMENT ' )   
P00726      OR END-OF-SYSIPT.                                           
P00726                                                                  
P00726     IF WS-INPUT-DATA-BREAKDOWN(1:18) =  'CSS_CRED_ARNGMENT '     
P00726        IF INPUT-ACTIVE                                           
P00726           MOVE 'Y'              TO  WS-ARNG-DELETE               
P00726        ELSE                                                      
P00726           DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CRED_ARNGMENT'    
P00726         DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_CRED_ARNGMENT' 
P00726           DISPLAY '            '                                 
P00726        END-IF                                                    
P00726     ELSE                                                         
P00726        DISPLAY '       '                                         
P00726        DISPLAY 'JOB PARM NOT PRESENT FOR CSS_CRED_ARNGMENT'      
P00726        DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CRED_ARNGMENT'     
P00726        DISPLAY '       '                                         
P00726     END-IF.                                                      
P00726                                                                  
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * MAIN PARA FOR THE PROCESS OF DELETING FROM TABLES.           *          
      ****************************************************************          
       2000-PURGE-PROCESS.                                              
      *                                                                         
           MOVE    WS-LAST-RUN-TS               TO PU-LAST-UPDATE-TS.   
      *                                                                         
           PERFORM 7100-OPEN-PURGE-CSR1         THRU 7100-EXIT.         
           PERFORM 7110-FETCH-PURGE-CSR1        THRU 7110-EXIT.         
           PERFORM 2200-PURGE-TYPE-B-PROCESS    THRU 2200-EXIT          
                   UNTIL NO-MORE-B-RECORDS.                             
           PERFORM 7120-CLOSE-PURGE-CSR1        THRU 7120-EXIT.         
      *                                                                         
           PERFORM 8900-COMMIT                  THRU 8900-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * PROCEESS RECORDS                                             *          
      ****************************************************************          
       2200-PURGE-TYPE-B-PROCESS.                                       
      *                                                                         
           IF CUST-DELETE                                               
              PERFORM 8000-DELETE-CUST-ALERT-B    THRU 8000-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-CUST-ALERT-COUNT-B                      
                 ADD WS-1 TO WS-CUST-ALERT-CMT-CNT                      
                 IF WS-CUST-ALERT-CMT-CNT = WS-CHKP-UPD-LIMIT           
                    PERFORM 8900-COMMIT THRU 8900-EXIT                  
                    ADD     WS-1        TO   WS-CUST-ALERT-CMT-NO       
                    INITIALIZE WS-CUST-ALERT-CMT-CNT                    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF GUAR-DELETE                                               
              PERFORM 8100-DELETE-GUARANTOR-B     THRU 8100-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-GUARANTOR-COUNT-B                       
                 ADD WS-1 TO WS-GUARANTOR-CMT-CNT                       
                 IF WS-GUARANTOR-CMT-CNT  = WS-CHKP-UPD-LIMIT           
                    PERFORM 8900-COMMIT THRU 8900-EXIT                  
                    ADD     WS-1        TO   WS-GUARANTOR-CMT-NO        
                    INITIALIZE WS-GUARANTOR-CMT-CNT                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF EXCH-DELETE                                               
              PERFORM 8300-DELETE-EXCH-DATA-B    THRU 8300-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-EXCH-DATA-COUNT-B                       
                 ADD WS-1 TO WS-EXCH-DATA-CMT-CNT                       
                 IF WS-EXCH-DATA-CMT-CNT = WS-CHKP-UPD-LIMIT            
                    PERFORM 8900-COMMIT THRU 8900-EXIT                  
                    ADD WS-1 TO WS-EXCH-DATA-CMT-NO                     
                    INITIALIZE  WS-EXCH-DATA-CMT-CNT                    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
P00599*                                                                         
P00599     IF CORRESP-DELETE                                            
P00599        PERFORM 8400-DELETE-CORRESP-HDR-B   THRU 8400-EXIT        
P00599        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00599           ADD WS-1 TO WS-CORR-HDR-COUNT-B                        
P00599           ADD WS-1 TO WS-CORR-HDR-CMT-CNT                        
P00599           IF WS-CORR-HDR-CMT-CNT = WS-CHKP-UPD-LIMIT             
P00599              PERFORM 8900-COMMIT THRU 8900-EXIT                  
P00599              ADD     WS-1        TO   WS-CORR-HDR-CMT-NO         
P00599              INITIALIZE WS-CORR-HDR-CMT-CNT                      
P00599           END-IF                                                 
P00599        END-IF                                                    
P00599     END-IF.                                                      
      *                                                                         
P00726*                                                                         
P00726     IF ARNG-DELETE                                               
P00726        MOVE PU-ACCOUNT-NO TO WX-ACCOUNT-NO                       
P00726        PERFORM 7130-OPEN-ARNG-CSR          THRU 7130-EXIT        
P00726        PERFORM 7135-FETCH-ARNG-CSR         THRU 7135-EXIT        
P00726        PERFORM UNTIL WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL 
P00726          IF WX-CRED-ARNG-SEQ > 0                                 
P00726            PERFORM 8500-DELETE-CRED-ARNG-B THRU 8500-EXIT        
P00726            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
P00726              ADD WS-1 TO WS-CRED-ARNG-COUNT-B                    
P00726              ADD WS-1 TO WS-CRED-ARNG-CMT-CNT                    
P00726              IF WS-CRED-ARNG-CMT-CNT = WS-CHKP-UPD-LIMIT         
P00726                PERFORM 8900-COMMIT THRU 8900-EXIT                
P00726                ADD     WS-1        TO   WS-CRED-ARNG-CMT-NO      
P00726                INITIALIZE WS-CRED-ARNG-CMT-CNT                   
P00726              END-IF                                              
P00726            END-IF                                                
P00726          END-IF                                                  
P00726          PERFORM 7135-FETCH-ARNG-CSR         THRU 7135-EXIT      
P00726        END-PERFORM                                               
P00726        PERFORM 7140-CLOSE-ARNG-CSR          THRU 7140-EXIT       
P00726     END-IF.                                                      
      *                                                                         
           PERFORM  7110-FETCH-PURGE-CSR1      THRU 7110-EXIT.          
      *                                                                         
        2200-EXIT.                                                      
             EXIT.                                                      
      ****************************************************************          
      * PRINTS THE TOTAL NO.OF RECORDS PROCESSED                     *          
      ****************************************************************          
      *                                                                         
       3500-PRINT-TOTALS-PARA.                                          
      *                                                                         
           IF CUST-DELETE                                               
              DISPLAY '         '                                       
              DISPLAY '* NO.OF RECORDS DELETED     '                    
              DISPLAY '* FROM CSS_CUST_ALERT   ' WS-CUST-ALERT-COUNT-B  
              DISPLAY '         '                                       
              DISPLAY '* NO.OF COMMITS TAKEN'                           
              DISPLAY '* FOR  CSS_CUST_ALERT   ' WS-CUST-ALERT-CMT-NO   
              DISPLAY '         '                                       
           END-IF.                                                      
      *                                                                         
           IF GUAR-DELETE                                               
              DISPLAY '         '                                       
              DISPLAY '* NO OF RECORDS DELETED     '                    
              DISPLAY '* FROM  CSS_GUARANTOR   ' WS-GUARANTOR-COUNT-B   
              DISPLAY '         '                                       
              DISPLAY '* NO.OF COMMITS TAKEN'                           
              DISPLAY '* FOR  CSS_GUARANTOR   '  WS-GUARANTOR-CMT-NO    
           END-IF.                                                      
      *                                                                         
           IF EXCH-DELETE                                               
              DISPLAY '         '                                       
              DISPLAY '* NO OF RECORDS DELETED     '                    
              DISPLAY '* FROM  CSS_EXCH_DATA_SENT ' WS-EXCH-DATA-COUNT-B
              DISPLAY '         '                                       
              DISPLAY '* NO.OF COMMITS TAKEN'                           
              DISPLAY '* FOR   CSS_EXCH_DATA_SENT ' WS-EXCH-DATA-CMT-NO 
           END-IF.                                                      
P00599*                                                                         
P00599     IF CORRESP-DELETE                                            
P00599        DISPLAY '         '                                       
P00599        DISPLAY '* NO OF RECORDS DELETED     '                    
P00599        DISPLAY '* FROM  CSS_CORRESP_HDR    ' WS-CORR-HDR-COUNT-B 
P00599        DISPLAY '         '                                       
P00599        DISPLAY '* NO.OF COMMITS TAKEN'                           
P00599        DISPLAY '* FOR   CSS_CORRESP_HDR    ' WS-CORR-HDR-CMT-NO  
P00599     END-IF.                                                      
      *                                                                         
       3500-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      * UPDATES LAST RUN TIMESTAMP TO JOB PARM                       *          
      ****************************************************************          
      *                                                                         
       3700-UPDATE-LAST-RUN-TS.                                         
      *                                                                         
           PERFORM 7400-GET-CURRENT-TIMESTAMP  THRU 7400-EXIT.          
           MOVE    WS-CURRENT-TIMESTAMP        TO WS-LAST-RUN-TS.       
           MOVE    WS-LAST-RUN-TIMESTAMP       TO G6-PARM-DATA.         
           PERFORM 8800-UPDATE-LAST-RUN-TS     THRU 8800-EXIT.          
      *                                                                         
       3700-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05220000
      ****************************************************************          
      * OPENS CUST_CSR1    CURSOR                                    *          
      ****************************************************************          
       7100-OPEN-PURGE-CSR1.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN PURGE_CSR1                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP200 ABORT  ************'         
              DISPLAY '* 7100-OPEN-PURGE-CSR1                *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP200  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES DATA TO PURGE THE CSS_PURGE                          *          
      ****************************************************************          
      *                                                                         
       7110-FETCH-PURGE-CSR1.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH PURGE_CSR1                                         
                INTO  :PU-ACCOUNT-NO                                    
                     ,:PU-PURGE-TS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE PU-PURGE-TS(1:10)  TO WS-PURGE-DT                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'        TO WS-NO-MORE-B-RECORDS                
              ELSE                                                      
                 DISPLAY '********** PCSXP200 ABORT  ************'      
                 DISPLAY '* 7110-FETCH-PURGE-CSR1               *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY 'PU-ACCOUNT-NO',       PU-ACCOUNT-NO           
                 DISPLAY 'PU-PURGE-TS'  ,       PU-PURGE-TS             
                 DISPLAY '********** PCSXP200  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES PURGE_CSR1    CURSOR                                   *         
      ****************************************************************          
      *                                                                         
       7120-CLOSE-PURGE-CSR1.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE PURGE_CSR1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP200 ABORT  ************'         
              DISPLAY '* 7120-CLOSE-PURGE_CSR1               *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP200  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00726****************************************************************          
P00726* OPENS ARNG_CSR     CURSOR                                    *          
P00726****************************************************************          
P00726 7130-OPEN-ARNG-CSR.                                              
P00726*                                                                         
P00726     EXEC SQL                                                     
P00726         OPEN ARNG_CSR                                            
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726*                                                                         
P00726     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        DISPLAY '********** PCSXP200 ABORT  ************'         
P00726        DISPLAY '* 7130-OPEN-ARNG-CSR                  *'         
P00726        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00726        DISPLAY '* PROGRAM ABORTING...                 *'         
P00726        DISPLAY '********** PCSXP200  ABORT ************'         
P00726        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00726     END-IF.                                                      
P00726*                                                                         
P00726 7130-EXIT.                                                       
P00726     EXIT.                                                        
P00726*                                                                         
P00726****************************************************************          
P00726* FETCHES DATA TO CSS_CRED_ARNG_SCHED CURSOR                   *          
P00726****************************************************************          
P00726*                                                                         
P00726 7135-FETCH-ARNG-CSR.                                             
P00726*                                                                         
P00726     EXEC SQL                                                     
P00726         FETCH ARNG_CSR                                           
P00726          INTO  :WX-ARNG-ID                                       
P00726               ,:WX-CRED-ARNG-SEQ                                 
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726*                                                                         
P00726     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        DISPLAY '********** PCSXP200 ABORT  ************'         
P00726        DISPLAY '* 7135-FETCH-ARNG-CSR                 *'         
P00726        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00726        DISPLAY '* PROGRAM ABORTING...                 *'         
P00726        DISPLAY 'WX-ACCOUNT-NO',       WX-ACCOUNT-NO              
P00726        DISPLAY '********** PCSXP200  ABORT ************'         
P00726        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00726     END-IF.                                                      
P00726*                                                                         
P00726 7135-EXIT.                                                       
P00726     EXIT.                                                        
P00726*                                                                         
P00726****************************************************************          
P00726* CLOSES ARNG_CSR      CURSOR                                   *         
P00726****************************************************************          
P00726*                                                                         
P00726 7140-CLOSE-ARNG-CSR.                                             
P00726*                                                                         
P00726     EXEC SQL                                                     
P00726         CLOSE ARNG_CSR                                           
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726*                                                                         
P00726     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        DISPLAY '********** PCSXP200 ABORT  ************'         
P00726        DISPLAY '* 7140-CLOSE-ARNG-CSR                 *'         
P00726        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00726        DISPLAY '* PROGRAM ABORTING...                 *'         
P00726        DISPLAY '********** PCSXP200  ABORT ************'         
P00726        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00726     END-IF.                                                      
P00726*                                                                         
P00726 7140-EXIT.                                                       
P00726     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7400-GET-CURRENT-TIMESTAMP                                   *          
      ****************************************************************          
      *                                                                         
       7400-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET   :WS-CURRENT-TIMESTAMP  =  CURRENT TIMESTAMP                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************************************'           
              DISPLAY '* 7400-GET-CURRENT-TIMESTAMP'                    
              DISPLAY '* SQL RETURN CODE = ' SQLCODE                    
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND   THRU 9900-EXIT                       
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING          *          
      **    7600P-START-FCSJC01                                       *         
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPDPURGE                                                   
           END-EXEC.                                                            
      ****************************************************************          
      * DELETES RECORDS FROM CSS_CUST_ALERT                          *          
      ****************************************************************          
       8000-DELETE-CUST-ALERT-B.                                        
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CA                            
                FROM CSS_CUST_ALERT CA
                 WHERE CA.ACCOUNT_NO  =  :PU-ACCOUNT-NO                 
                 AND   CA.DATE_EXPIRE <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PURGE-DT
              ) <> 0) OR (LEN(:WS-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-PURGE-DT
              ), CONVERT(DATE, :WS-PURGE-DT) )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CUST_ALERT CA                                   
MFA-TR*          WHERE CA.ACCOUNT_NO  =  :PU-ACCOUNT-NO                         
MFA-TR*          AND   CA.DATE_EXPIRE <= :WS-PURGE-DT                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP200 ABORT  ************'         
              DISPLAY '* 8000-DELETE-CUST-ALERT-B            *'         
              DISPLAY '* ACCOUNT # : ', PU-ACCOUNT-NO                   
              DISPLAY '* PURGE DT  : ', WS-PURGE-DT                     
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP200  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_GUARANTOR                           *          
      ****************************************************************          
      *                                                                         
       8100-DELETE-GUARANTOR-B.                                         
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM GU                             
                FROM CSS_GUARANTOR GU
                 WHERE GU.ACCOUNT_NO      = :PU-ACCOUNT-NO              
                 AND   GU.GUAR_STATUS_CD IN ('C','G','R')               
                 AND   GU.LAST_UPDATE_TS  <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_GUARANTOR GU                                    
MFA-TR*          WHERE GU.ACCOUNT_NO      = :PU-ACCOUNT-NO                      
MFA-TR*          AND   GU.GUAR_STATUS_CD IN ('C','G','R')                       
MFA-TR*          AND   GU.LAST_UPDATE_TS  <= :PU-PURGE-TS                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP200 ABORT  ************'         
              DISPLAY '* 8100-DELETE-GUARANTOR-B             *'         
              DISPLAY '* ACCOUNT # :' , PU-ACCOUNT-NO                   
              DISPLAY '* TS        :',  PU-PURGE-TS                     
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP200  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_EXCH_DATA_SENT                      *          
      ****************************************************************          
      *                                                                         
       8300-DELETE-EXCH-DATA-B.                                         
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM EX                        
                FROM CSS_EXCH_DATA_SENT EX
                 WHERE EX.ACCOUNT_NO    = :PU-ACCOUNT-NO                
                 AND   EX.EXCH_SENT_TS <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_EXCH_DATA_SENT EX                               
MFA-TR*          WHERE EX.ACCOUNT_NO    = :PU-ACCOUNT-NO                        
MFA-TR*          AND   EX.EXCH_SENT_TS <= :PU-PURGE-TS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP200 ABORT  ************'         
              DISPLAY '* 8300-DELETE-EXCH-DATA-B             *'         
              DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '* PU-ACCOUNT-NO      = ' PU-ACCOUNT-NO           
              DISPLAY '* PU-PURGE-TS        = ' PU-PURGE-TS             
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP200  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
P00599*                                                                         
P00599****************************************************************          
P00599* DELETES RECORDS FROM CSS_CORRESP_HDR                         *          
P00599****************************************************************          
P00599 8400-DELETE-CORRESP-HDR-B.                                       
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599          DELETE FROM [1J]                           
                FROM CSS_CORRESP_HDR [1J]
P00599           WHERE [1J].ACCOUNT_NO      = :PU-ACCOUNT-NO              
P00599           AND   [1J].LAST_UPDATE_TS <= CIS.CHAR2TIMESTAMP(
                                                           :PU-PURGE-TS
              )                
P00599           AND   [1J].CORRESP_TYPE_CD NOT IN ('IT','CL')            
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CORRESP_HDR 1J                                  
MFA-TR*          WHERE 1J.ACCOUNT_NO      = :PU-ACCOUNT-NO                      
MFA-TR*          AND   1J.LAST_UPDATE_TS <= :PU-PURGE-TS                        
MFA-TR*          AND   1J.CORRESP_TYPE_CD NOT IN ('IT','CL')                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599*                                                                         
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSXP200 ABORT  ************'         
P00599        DISPLAY '* 8400-DELETE-CORRESP-HDR-B           *'         
P00599        DISPLAY '* ACCOUNT # : ', PU-ACCOUNT-NO                   
P00599        DISPLAY '* PURGE TS  : ', PU-PURGE-TS                     
P00599        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00599        DISPLAY '* PROGRAM ABORTING...                 *'         
P00599        DISPLAY '********** PCSXP200  ABORT ************'         
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 8400-EXIT.                                                       
P00599     EXIT.                                                        
      *                                                                         
P00726****************************************************************          
P00726* DELETES RECORDS FROM CSS_CRED_ARNG                           *          
P00726****************************************************************          
P00726*                                                                         
P00726 8500-DELETE-CRED-ARNG-B.                                         
P00726                                                                  
P00726     EXEC SQL                                                     
P00726          DELETE FROM X1                         
                FROM CSS_CRED_ARNGMENT X1
P00726          WHERE X1.ACCOUNT_NO       = :WX-ACCOUNT-NO              
P00726            AND X1.ARNG_ID          = :WX-ARNG-ID                 
P00726            AND X1.CRED_ARNG_SEQ    = :WX-CRED-ARNG-SEQ           
P00726            AND X1.ARNG_STATUS_CD   IN('C','R')                   
P00726     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CRED_ARNGMENT X1                                
MFA-TR*         WHERE X1.ACCOUNT_NO       = :WX-ACCOUNT-NO                      
MFA-TR*           AND X1.ARNG_ID          = :WX-ARNG-ID                         
MFA-TR*           AND X1.CRED_ARNG_SEQ    = :WX-CRED-ARNG-SEQ                   
MFA-TR*           AND X1.ARNG_STATUS_CD   IN('C','R')                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00726                                                                  
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00726        NEXT SENTENCE                                             
P00726     ELSE                                                         
P00726        DISPLAY '********** PCSXP200 ABORT  ************'         
P00726        DISPLAY '* 8500-DELETE-CRED-ARNG-B         *'             
P00726        DISPLAY '* ACCOUNT   #: ', WX-ACCOUNT-NO                  
P00726        DISPLAY '* ARNG ID   #: ', WX-ARNG-ID                     
P00726        DISPLAY '* SEQ NO    #: ', WX-CRED-ARNG-SEQ               
P00726        DISPLAY '* SQLCODE IS   ', WS-ACTIVE-RETURN-CODE          
P00726        DISPLAY '* PROGRAM ABORTING...                 *'         
P00726        DISPLAY '********** PCSXP200  ABORT ************'         
P00726        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00726     END-IF.                                                      
P00726                                                                  
P00726 8500-EXIT.                                                       
P00726     EXIT.                                                        
                                                                        
      ****************************************************************          
      * UPDATES LAST RUN TIME STAMP TO JOB PARM                     *           
      ****************************************************************          
      *                                                                         
       8800-UPDATE-LAST-RUN-TS.                                         
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
              SET    PARM_DATA = :G6-PARM-DATA                          
              WHERE  CMND_CODE = 'DATE'                                 
              AND    COMPANY_NO = '01'                                  
              AND    PROGRAM_NAME = :WS-PGRMNAME                        
              AND    STATUS = 'A'                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                  DISPLAY '********** PCSXP200 ABORT  ************'     
                  DISPLAY '* 8800-UPDATE-LAST-RUN-TS                  *'
                  DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE          
                  DISPLAY '* WS-LAST-RUN-TSWS   = ' WS-LAST-RUN-TS      
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSXP200  ABORT ************'     
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                       *          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           ADD     WS-1                TO            WS-NBR-COMMIT.     
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
