       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP110.                                           
       DATE-WRITTEN.  14 SEP 2008                                       
       DATE-COMPILED.                                                   
       AUTHOR.   MADHAVI CH.                                            
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      **                                                             *          
      ** DATE       INITIALS       REASON                            *          
      ** 09/14/08  MC95456      APPL37648- ACT 3 & 5                 *          
      **                        LOGIC FOR SOME TABLES TAKEN FROM     *          
      **                        PCSCA766                             *          
ACT040** 02/12/13  BD09555      CHANGE CSS_SPCL_FCTOR DELETION       *          
ACT040**                        CRITERIA A04880                      *          
A04684** 12/11/14  VK7L032      PURGE PROCESS FOR TABLE              *          
A04684**                        CSS_OFFCYCLE_READS                   *          
      **                                                             *          
A05136**21 MAR 15   RF10596     ADD JOB_PARM AND CURSOR TO           *          
A05136**                        DELETE CSS_MDM_SS_INTF RECORDS       *          
      **                                                             *          
A04684** 07/31/15  SS95855      ACT002 CSS_OFFCYCLE_READS JOB PARM   *          
A04684**                        ADDED AND CHANGED TO RETAIN 1 MONTH  *          
ACT165** 09/04/15  BD09555      ADD PURGE FOR CSS_CORR_MAIL_STAT AND *          
ACT165** A05248-ACT165          CSS_BTU_FACTOR                       *          
ACT165** 10/07/15  BD09555      CORRECT NUMBER OF MONTHS VALUE FOR   *          
ACT165** A05248-ACT165          OFF-CYCLE-READS OVERLAID IN PREVIOUS *          
ACT165**                        UPDATE                               *          
ACT165** 10/09/15  BD09555      ADD PURGE FOR CSS_BTU_INDUST_FCT     *          
ACT165** A05248-ACT165          CHANGED PURGE LOGIC FOR SOME TABLES. *          
ACT165** A05248-ACT165          FOR TABLES WITH LOW VOLUMES OF       *          
ACT165** A05248-ACT165          PURGED ROWS (<1000), THE PURGE IS    *          
ACT165** A05248-ACT165          DONE WITH ONE DELETE STATEMENT.    . *          
ACT165** A05248-ACT165          FOR MORE THAN 1000 ROWS, A CURSOR    *          
ACT165** A05248-ACT165          IS USED AND COMMITTED AFTER EVERY    *          
ACT165** A05248-ACT165          1000 DELETIONS.                      *          
ACT257**     BD09555            DELETE ROWS FROM CSS_EXCP_BILL_DET   *          
ACT257** A05248-ACT257          THAT ARE OVER THREE MONTHS OLD       *          
ACT154** 05/09/16  MS7M727      ADD PURGE FOR CSS_TEMPERATURE TABLE  *          
ACT154**           A05460                                            *          
      ****************************************************************          
      *                   PCSXP110   NARRATIVE                       *          
      *                                                              *          
      * THIS PROGRAM DELETES THE RECORDS FROM TABLES                 *          
      * 1.  CSS_ROUTE_REPORT                                         *          
      * 2.  CSS_RTP_DETAIL                                           *          
      * 3.  CSS_SPCL_FCTR_APPL                                       *          
A04684* 4.  CSS_OFFCYCLE_READS                                       *          
A05136* 5.  CSS_MDM_SS_INTF                                          *  00180000
ACT165* 6.  CSS_CORR_MAIL_STAT                                       *  00180000
ACT165* 7.  CSS_BTU_FACTOR                                           *  00180000
ACT165* 8.  CSS_BTU_INDUST_FCT                                       *  00180000
ACT257* 9.  CSS_EXCP_BILL_DET                                        *  00180000
ACT154*10.  CSS_TEMPERATURE                                          *  00180000
      *                                                              *          
      *         PER THE RULES IN THE INDIVIDUAL CURSORS              *          
      *                                                              *          
      * PURGE CRITERIA CAN BE FOUND IN THE CSS_JOB_PARM TABLE        *          
      * FOR EACH TABLE. TO SAFEGUARD AGAINST JOB PARM ERRORS AND     *          
      * ACCIDENTALY DELETING MORE DATA THAN INTENDED, THE FOLLOWING  *          
      * HARD CODED VALUES HAVE BEEN ESTABLISHED AS MINIMUM VALUES    *          
      * OF DATA THAT CAN BE DELETED FROM EACH TABLE WITHOUT REQUIRING*          
      * A PROGRAMMING CHANGE. JOB PARM MONTHS CAN BE CHANGED TO      *          
      * GREATER THAN THE MINIMUM BUT NOT LESS THAN MINIMUM           *          
      * 1.  CSS_ROUTE_REPORT- 15 MO PSNC SECURED RATE, 6 MO ALL OTHER*          
      * 2.  CSS_RTP_DETAIL- 24 MONTHS                                *          
      * 3.  CSS_SPCL_FCTR_APPL - 24 MONTHS                           *          
A04684* 4.  CSS_OFFCYCLE_READS - 01 MONTH                            *          
A05136* 5.  CSS_MDM_SS_INTF    -  1 MONTH                            *  00180000
ACT165* 6.  CSS_CORR_MAIL_STAT -  2 MONTHS                           *  00180000
ACT165* 7.  CSS_BTU_FACTOR     - 30 MONTHS                           *  00180000
ACT165* 8.  CSS_BTU_INDUST_FCT - 30 MONTHS                           *  00180000
ACT257* 9.  CSS_EXCP_BILL_DET  -  3 MONTHS                           *  00180000
ACT154*10.  CSS_TEMPERATURE    - 30 MONTHS                           *  00180000
      *                                                              *          
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM   *          
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)            *          
      *                                                              *          
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START- NO        *          
      * RESTART IS NEEDED.                                           *          
      *                                                              *          
      * COMMITS ARE TAKEN                                            *          
      ****************************************************************          
                                                                     *  
      ****************************************************************          
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OU PUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP110'.
MSQ017     COPY MFASQLM.
      *                                                                         
A05136 01  WS-MDM-SS-TMESTMP       PIC X(26) VALUE SPACES.              
A05136 01  WS-MDM-SS-TIMESTAMP.                                         
A05136     05  WS-MDM-SS-DATE      PIC X(10) VALUE SPACES.              
A05136     05  WS-MDM-SS-TMSTP     PIC X(16) VALUE '-00.00.00.000001'.  
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-COMMIT-COUNT             PIC 9(9)  VALUE ZEROS.       
           05  FILLER REDEFINES WS-COMMIT-COUNT.                        
               10 WS-CHECKPOINT-NBR        PIC 9(6).                    
               10 WS-COMMIT-TEST           PIC 9(3).                    
           05  WS-1000                     PIC 9(4)  VALUE 1000.        
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-I                        PIC S9(4) COMP VALUE 0.      
           05  WS-NBR-COMMIT               PIC 9(9)  VALUE ZEROS.       
           05  WS-ROUTRPT-COUNT            PIC 9(9)  VALUE ZEROS.       
           05  WS-RTP-DETAIL-COUNT         PIC 9(9)  VALUE ZEROS.       
           05  WS-SPCL-FCTR-COUNT          PIC 9(9)  VALUE ZEROS.       
A04684     05  WS-OFFCYCLE-COUNT           PIC 9(9)  VALUE ZEROS.       
ACT165     05  WS-CORR-MAIL-STAT-COUNT     PIC 9(9)  VALUE ZEROS.       
ACT165     05  WS-BTU-FACTOR-COUNT         PIC 9(9)  VALUE ZEROS.       
ACT165     05  WS-BTU-INDUST-FCT-COUNT     PIC 9(9)  VALUE ZEROS.       
ACT257     05  WS-EXCP-BILL-DET-COUNT      PIC 9(9)  VALUE ZEROS.       
ACT154     05  WS-TEMPERATURE-COUNT        PIC 9(9)  VALUE ZEROS.       
           05  WS-RTP-DETAIL-DATE          PIC X(10).                   
           05  WS-RTP-DETAIL-DATE1                                      
                  REDEFINES WS-RTP-DETAIL-DATE.                         
               10  WS-RTP-DETAIL-YYYY      PIC X(04).                   
               10  FILLER                  PIC X(01).                   
               10  WS-RTP-DETAIL-MM        PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-RTP-DETAIL-DD        PIC X(02).                   
           05  WS-ROUTE-RPT-OTHER          PIC X(10) VALUE SPACES.      
           05  WS-ROUTE-RPT-PSNC-SECURED   PIC X(10) VALUE SPACES.      
           05  WS-SPCL-FCTR-DATE           PIC X(10) VALUE SPACES.      
ACT002     05  WS-OFF-CYCLE-DATE           PIC X(10) VALUE SPACES.      
ACT165     05  WS-CORR-MAIL-STAT-DATE      PIC X(10) VALUE SPACES.      
ACT165     05  WS-BTU-FACTOR-DATE          PIC X(10) VALUE SPACES.      
ACT165     05  WS-BTU-INDUST-FACTOR-DATE   PIC X(10) VALUE SPACES.      
ACT257     05  WS-EXCP-BILL-DET-DATE       PIC X(10) VALUE SPACES.      
ACT154     05  WS-TEMPERATURE-DATE         PIC X(10) VALUE SPACES.      
COB305     05 WS-PREV-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
                                                                        
      *                                                                         
           05  WS-PGRMNAME                 PIC X(8)  VALUE 'PCSXP110'.  
           05  WS-MONTHS                   PIC X(03) VALUE SPACES.      
           05  WS-MONTHS-VALUE                                          
               REDEFINES WS-MONTHS         PIC 9(03).                   
      *                                                                         
           05  WS-ROUTE-RPT-MO1            PIC S9(4) COMP VALUE 0.      
           05  WS-ROUTE-RPT-MO2            PIC S9(4) COMP VALUE 0.      
           05  WS-RPT-DETAIL-MO            PIC S9(4) COMP VALUE 0.      
           05  WS-SPCL-FCTR-MO             PIC S9(4) COMP VALUE 0.      
ACT002     05  WS-OFF-CYCLE-MO             PIC S9(4) COMP VALUE 0.      
ACT165     05  WS-CORR-MAIL-STAT-MO        PIC S9(4) COMP VALUE 0.      
ACT165     05  WS-BTU-FACTOR-MO            PIC S9(4) COMP VALUE 0.      
ACT165     05  WS-BTU-INDUST-FCT-MO        PIC S9(4) COMP VALUE 0.      
ACT257     05  WS-EXCP-BILL-DET-MO         PIC S9(4) COMP VALUE 0.      
ACT154     05  WS-TEMPERATURE-MO           PIC S9(4) COMP VALUE 0.      
           05  WS-JOB-PARM-ERR-CODE        PIC 9(02) VALUE 0.           
      *                                                                         
A05136     05  WS-MDM-SS-COUNT             PIC 9(9)  VALUE ZEROS.       
A05136     05  WS-MDM-SS-MO                PIC S9(4) COMP VALUE 0.      
      *                                                                         
A05136     05  WS-MDM-SS-ALERT             PIC X(01) VALUE 'N'.         
A05136         88 MDM-SS-ALERT                       VALUE 'Y'.         
      *                                                                         
ACT165     05  WS-CORR_MAIL_STAT           PIC X(01) VALUE 'N'.         
ACT165         88 CORR-MAIL-STAT                     VALUE 'Y'.         
ACT165     05  WS-BTU-FACTOR               PIC X(01) VALUE 'N'.         
ACT165         88 BTU-FACTOR                         VALUE 'Y'.         
           05  WS-ROUTE-REPORT             PIC X(01) VALUE 'N'.         
               88 ROUTE-REPORT                       VALUE 'Y'.         
           05  WS-RTP-DETAIL               PIC X(01) VALUE 'N'.         
               88 RTP-DETAIL                         VALUE 'Y'.         
           05  WS-SECURED-IND              PIC X(01) VALUE ' '.         
               88 SECURED-IND                        VALUE 'Y'.         
               88 NOT-SECURED                        VALUE 'N'.         
           05  WS-SPCL-FCTR                PIC X(01) VALUE ' '.         
               88 SPCL-FCTR                          VALUE 'Y'.         
ACT002     05  WS-OFF-CYCLE                PIC X(01) VALUE ' '.         
ACT002         88 OFF-CYCLE                          VALUE 'Y'.         
ACT165     05  WS-BTU-INDUST-FCT           PIC X(01) VALUE ' '.         
ACT165         88 BTU-INDUST-FACTOR                  VALUE 'Y'.         
ACT257     05  WS-EXCP-BILL-DET            PIC X(01) VALUE ' '.         
ACT257         88 EXCP-BILL-DET                      VALUE 'Y'.         
ACT154     05  WS-TEMPERATURE              PIC X(01) VALUE ' '.         
ACT154         88 TEMPERATURE                        VALUE 'Y'.         
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_ROUTE_REPORT  PW                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTERPT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_UTIL_ENVRNMT  UT                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_RATE_PLAN_DESC   RD                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_RTP_DETAIL      J3                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTPDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_SPCL_FCTR_APPL  SA                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLAPL                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CSS_JOB_PARM                                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      ****************************************************************  06330000
A05136* CSS_MDM_SS_INTF -  1D                                        *  06340000
      ****************************************************************  06350000
      *                                                                         
A05136     EXEC SQL                                                             
A05136         INCLUDE TBMDMINT                                                 
A05136     END-EXEC.                                                            
      *                                                                         
      ****************************************************************  06330000
ACT165* CSS_CORR_MAIL_STAT - MW                                      *  06340000
ACT165****************************************************************  06350000
ACT165*                                                                         
ACT165     EXEC SQL                                                             
ACT165         INCLUDE TBMAILST                                                 
ACT165     END-EXEC.                                                            
      *                                                                         
      ****************************************************************  06330000
ACT165* CSS_BTU_FACTOR     - TF                                      *  06340000
ACT165****************************************************************  06350000
ACT165*                                                                         
ACT165     EXEC SQL                                                             
ACT165         INCLUDE TBBTUFCT                                                 
ACT165     END-EXEC.                                                            
      *                                                                         
      ****************************************************************  06330000
ACT165* CSS_BTU_INDUST_FCT - FE                                      *  06340000
ACT165****************************************************************  06350000
ACT165*                                                                         
ACT165     EXEC SQL                                                             
ACT165         INCLUDE TBINDFCT                                                 
ACT165     END-EXEC.                                                            
      *                                                                         
ACT154****************************************************************  06330000
ACT154* CSS_TEMPERATURE    - E8                                      *  06340000
ACT154****************************************************************  06350000
ACT154*                                                                         
ACT154     EXEC SQL                                                             
ACT154         INCLUDE TBTEMPIN                                                 
ACT154     END-EXEC.                                                            
      *                                                                         
      ****************************************************************  06330000
HONK  * CSS_EXCP_BILL_DET  - ??                                      *  06340000
ACT165****************************************************************  06350000
ACT165*                                                                         
      *                                                                         
A04684****************************************************************          
A04684*   CSS_OFFCYCLE_READS 3B                                      *          
A04684****************************************************************          
A04684     EXEC SQL                                                             
A04684        INCLUDE TBOFFCYR                                                  
A04684     END-EXEC.                                                            
A04684                                                                  
      ****************************************************************          
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'               *          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                       *          
      ****************************************************************          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
       COPY CWSPURGE.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
ACT165****************************************************************          
ACT165* CURSOR DECLARATION TO SELECT ALL THE RECORDS THAT ARE OLDER  *          
ACT165* THAN 24 MONTHS FROM CSS_RTP_DETAIL   TABLE                   *          
ACT165****************************************************************          
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165         DECLARE  RTP_DETAIL_CSR CURSOR WITH HOLD FOR             
ACT165          SELECT  J3.CODE_UTIL_TYPE,                              
ACT165                  J3.RATE_PLAN_NO ,                               
ACT165                  J3.VERSION_NO_CNTRL,                            
ACT165                  J3.CMPNT_ID_CD ,                                
ACT165                  J3.CODE_USE_INST_TYPE,                          
ACT165                  J3.PRICE_APPLIES_DT ,                           
ACT165                  J3.PRICE_APPLIES_HR                             
ACT165            FROM  CSS_RTP_DETAIL   J3 WITH(READUNCOMMITTED)               
ACT165            WHERE J3.PRICE_APPLIES_DT <  IIF(TRY_CONVERT(DATE, 
                                                   :J3-PRICE-APPLIES-DT
              ) IS NULL OR (PATINDEX('%.%', :J3-PRICE-APPLIES-DT
              ) <> 0) OR (LEN(:J3-PRICE-APPLIES-DT
              ) <> 10), CIS.CHAR2DATE(:J3-PRICE-APPLIES-DT
              ), CONVERT(DATE, :J3-PRICE-APPLIES-DT) )     
ACT165          FOR READ ONLY                                   
ACT165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE  RTP_DETAIL_CSR CURSOR WITH HOLD FOR                     
MFA-TR*         SELECT  J3.CODE_UTIL_TYPE,                                      
MFA-TR*                 J3.RATE_PLAN_NO ,                                       
MFA-TR*                 J3.VERSION_NO_CNTRL,                                    
MFA-TR*                 J3.CMPNT_ID_CD ,                                        
MFA-TR*                 J3.CODE_USE_INST_TYPE,                                  
MFA-TR*                 J3.PRICE_APPLIES_DT ,                                   
MFA-TR*                 J3.PRICE_APPLIES_HR                                     
MFA-TR*           FROM  CSS_RTP_DETAIL   J3                                     
MFA-TR*           WHERE J3.PRICE_APPLIES_DT <  :J3-PRICE-APPLIES-DT             
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR DECLARATION TO SELECT ALL THE RECORDS THAT ARE OLDER  *          
      * THAN 06 MONTHS FROM CSS_ROUTE_REPORT TABLE                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE  ROUTE_REPORT CURSOR WITH HOLD FOR               
                SELECT  PW.ACCOUNT_NO,                                  
                        PW.REVENUE_MONTH,                               
                        PW.CODE_UTIL_TYPE,                              
                        PW.IC_NO,                                       
                        PW.METER_NO,                                    
                        PW.REG_MEASURE_CD,                              
                        PW.CODE_TIME_PERIOD,                            
                        PW.CODE_TOU_SEASN,                              
                        PW.LAST_REG_READ_DT,                            
                        REPLACE(CONVERT(CHAR(8), PW.LAST_REG_READ_TM
           , 108), ':', '.') LAST_REG_READ_TM,                            
                        PW.COMPANY_NO                                   
                  FROM  CSS_ROUTE_REPORT PW WITH(READUNCOMMITTED)               
                  WHERE PW.LAST_REG_READ_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ROUTE-RPT-OTHER
              ) IS NULL OR (PATINDEX('%.%', :WS-ROUTE-RPT-OTHER
              ) <> 0) OR (LEN(:WS-ROUTE-RPT-OTHER
              ) <> 10), CIS.CHAR2DATE(:WS-ROUTE-RPT-OTHER
              ), CONVERT(DATE, :WS-ROUTE-RPT-OTHER) )      
                ORDER BY  PW.ACCOUNT_NO                                 
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE  ROUTE_REPORT CURSOR WITH HOLD FOR                       
MFA-TR*         SELECT  PW.ACCOUNT_NO,                                          
MFA-TR*                 PW.REVENUE_MONTH,                                       
MFA-TR*                 PW.CODE_UTIL_TYPE,                                      
MFA-TR*                 PW.IC_NO,                                               
MFA-TR*                 PW.METER_NO,                                            
MFA-TR*                 PW.REG_MEASURE_CD,                                      
MFA-TR*                 PW.CODE_TIME_PERIOD,                                    
MFA-TR*                 PW.CODE_TOU_SEASN,                                      
MFA-TR*                 PW.LAST_REG_READ_DT,                                    
MFA-TR*                 PW.LAST_REG_READ_TM,                                    
MFA-TR*                 PW.COMPANY_NO                                           
MFA-TR*           FROM  CSS_ROUTE_REPORT PW                                     
MFA-TR*           WHERE PW.LAST_REG_READ_DT <= :WS-ROUTE-RPT-OTHER              
MFA-TR*         ORDER BY  PW.ACCOUNT_NO                                         
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
A04684****************************************************************          
A04684* CURSOR DECLARATION TO SELECT ALL THE RECORDS THAT ARE OLDER  *          
A04684* THAN 09 DAYS FROM CSS_OFFCYCLE_READS TABLE                   *          
A04684****************************************************************          
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684          DECLARE OFFCYC_READS CURSOR WITH HOLD FOR               
A04684           SELECT [3B].DEVICE_NO                                    
A04684                 ,[3B].COMPANY_NO                                   
A04684                 ,[3B].REG_READ_DT                                  
A04684                 ,REPLACE(CONVERT(CHAR(8), [3B].REG_READ_TM
           , 108), ':', '.') REG_READ_TM                                  
A04684                 ,[3B].CODE_UTIL_TYPE                               
A04684             FROM CSS_OFFCYCLE_READS [3B] WITH(READUNCOMMITTED)           
ACT002            WHERE [3B].REG_READ_DT <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-OFF-CYCLE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-CYCLE-DATE
              ) <> 0) OR (LEN(:WS-OFF-CYCLE-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-OFF-CYCLE-DATE
              ), CONVERT(DATE, :WS-OFF-CYCLE-DATE) )            
A04684          FOR READ ONLY                                   
A04684     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE OFFCYC_READS CURSOR WITH HOLD FOR                       
MFA-TR*          SELECT 3B.DEVICE_NO                                            
MFA-TR*                ,3B.COMPANY_NO                                           
MFA-TR*                ,3B.REG_READ_DT                                          
MFA-TR*                ,3B.REG_READ_TM                                          
MFA-TR*                ,3B.CODE_UTIL_TYPE                                       
MFA-TR*            FROM CSS_OFFCYCLE_READS 3B                                   
MFA-TR*           WHERE 3B.REG_READ_DT <= :WS-OFF-CYCLE-DATE                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
ACT165****************************************************************          
      *                                                                         
      ****************************************************************          
A05136* CURSOR DECLARATION TO SELECT CSS_MDM_SS_INTF RECORDS         *          
A05136* WHERE LAST_UPDATE_TS LESS THAN:                              *          
A05136* (WS-MDM-SS-TIMESTAMP = CURRENT DATE - WS-MDM-SS-MO)          *          
      ****************************************************************          
      *                                                                         
A05136     EXEC SQL                                                     
A05136         DECLARE MDM_SS_CSR CURSOR WITH HOLD FOR                  
A05136          SELECT  SERVICE_POINT_ID                                
A05136                 ,LAST_SYNC_DATE                                  
A05136            FROM  CSS_MDM_SS_INTF WITH(READUNCOMMITTED)                   
A05136           WHERE  LAST_SYNC_DATE  = IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') )                  
A05136             AND  LAST_UPDATE_TS < CIS.CHAR2TIMESTAMP(
                                                     :WS-MDM-SS-TMESTMP
              )             
A05136          FOR READ ONLY                                   
P00599                                                      
A05136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MDM_SS_CSR CURSOR WITH HOLD FOR                          
MFA-TR*         SELECT  SERVICE_POINT_ID                                        
MFA-TR*                ,LAST_SYNC_DATE                                          
MFA-TR*           FROM  CSS_MDM_SS_INTF                                         
MFA-TR*          WHERE  LAST_SYNC_DATE  = '0001-01-01'                          
MFA-TR*            AND  LAST_UPDATE_TS < :WS-MDM-SS-TMESTMP                     
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 7480                                                        
MFA-TR*    END-EXEC.                                                            
ACT165****************************************************************          
ACT165* CURSOR DEFINITION TO SELECT CSS_CORR_MAIL_STAT TO DELETE     *          
ACT165****************************************************************          
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165         DECLARE CORR_CSR CURSOR WITH HOLD FOR                    
ACT165            SELECT ACCOUNT_NO                                     
ACT165                  ,BARCODE_UNIQUE_ID                              
ACT165             FROM  CSS_CORR_MAIL_STAT WITH(READUNCOMMITTED)               
ACT165             WHERE CREATE_DT < IIF(TRY_CONVERT(DATE, 
                                                :WS-CORR-MAIL-STAT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CORR-MAIL-STAT-DATE
              ) <> 0) OR (LEN(:WS-CORR-MAIL-STAT-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CORR-MAIL-STAT-DATE
              ), CONVERT(DATE, :WS-CORR-MAIL-STAT-DATE) )            
ACT165               FOR READ ONLY                              
ACT165                                                      
ACT165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CORR_CSR CURSOR WITH HOLD FOR                            
MFA-TR*           SELECT ACCOUNT_NO                                             
MFA-TR*                 ,BARCODE_UNIQUE_ID                                      
MFA-TR*            FROM  CSS_CORR_MAIL_STAT                                     
MFA-TR*            WHERE CREATE_DT < :WS-CORR-MAIL-STAT-DATE                    
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7510                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
ACT165****************************************************************          
ACT165* CURSOR DEFINITION TO SELECT CSS_BTU_FACTOR     TO DELETE     *          
ACT165****************************************************************          
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165         DECLARE BTU_FACTOR_CSR CURSOR WITH HOLD FOR              
ACT165            SELECT BTU_DT                                         
ACT165                  ,COMPANY_NO                                     
ACT165             FROM  CSS_BTU_FACTOR WITH(READUNCOMMITTED)                   
ACT165             WHERE BTU_DT    < IIF(TRY_CONVERT(DATE, 
                                                    :WS-BTU-FACTOR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BTU-FACTOR-DATE
              ) <> 0) OR (LEN(:WS-BTU-FACTOR-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-BTU-FACTOR-DATE
              ), CONVERT(DATE, :WS-BTU-FACTOR-DATE) )                
ACT165               FOR READ ONLY                              
ACT165                                                      
ACT165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BTU_FACTOR_CSR CURSOR WITH HOLD FOR                      
MFA-TR*           SELECT BTU_DT                                                 
MFA-TR*                 ,COMPANY_NO                                             
MFA-TR*            FROM  CSS_BTU_FACTOR                                         
MFA-TR*            WHERE BTU_DT    < :WS-BTU-FACTOR-DATE                        
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*              QUERYNO 7530                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-GET-PARM-PURGE-MONTHS  THRU 0100-EXIT.          
           PERFORM 7200-SET-PURGE-DATES        THRU 7200-EXIT.          
      *                                                                         
           PERFORM 1000-PURGE-PROCESS          THRU 1000-EXIT.          
           PERFORM 2000-PRINT-TOTALS              THRU 2000-EXIT        
      *                                                                         
           DISPLAY '*********PROCESS COMPLETED SUCCESSFULLY*********'   
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET NUMBER OF MONTHS FROM CSS_JOB_PARM                       *          
      ****************************************************************          
      *                                                                         
       0100-GET-PARM-PURGE-MONTHS.                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           PERFORM 7600P-START-FCSJC01 THRU 7600P-EXIT.                 
           PERFORM 0125-READ-FCSJC01   THRU 0125-EXIT.                  
           PERFORM 7611P-CLOSE         THRU 7611P-EXIT.                 
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ MONTHS FROM CSS_JOB_PARM                       *                   
      ****************************************************************          
       0125-READ-FCSJC01.                                               
           MOVE           1                      TO   WS-I.             
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
            (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_ROUTE_REPORT   ')     
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_ROUTE_REPORT   '     
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
                 MOVE WS-JP-PURGE-MO-1 TO WS-MONTHS                     
                 MOVE WS-MONTHS-VALUE  TO WS-ROUTE-RPT-MO1              
                 MOVE WS-JP-PURGE-MO-2 TO WS-MONTHS                     
                 MOVE WS-MONTHS-VALUE  TO WS-ROUTE-RPT-MO2              
                 IF WS-ROUTE-RPT-MO1 >= 06 AND WS-ROUTE-RPT-MO2 >= 15   
                    MOVE 'Y'              TO WS-ROUTE-REPORT            
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY '       '                                    
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MNTHS VALUE FRM JOB PARM TBL FOR ROUTE-RPT:'
                   DISPLAY  WS-ROUTE-RPT-MO1 ',' WS-ROUTE-RPT-MO2       
                   DISPLAY 'NO RECS ARE PROCESSED FOR CSS_ROUTE_REPORT' 
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_ROUTE_REPORT - '  
                         'NO RECORDS PROCESSED'                         
              END-IF                                                    
           ELSE                                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_ROUTE_REPORT - '    
                      'NO RECORDS PROCESSED'                            
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
            (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_RTP_DETAIL    ')      
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_RTP_DETAIL    '      
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA TO WS-JOB-PARM-DATA                  
                 MOVE WS-JP-PURGE-MO-1 TO WS-MONTHS                     
                 MOVE WS-MONTHS-VALUE  TO WS-RPT-DETAIL-MO              
                 IF WS-RPT-DETAIL-MO >= 24                              
                    MOVE 'Y'              TO WS-RTP-DETAIL              
                 ELSE                                                   
                   MOVE    3        TO  WS-JOB-PARM-ERR-CODE            
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM TBL FOR RTP-DET:'  
                           WS-RPT-DETAIL-MO                             
                   DISPLAY 'NO RECS ARE PROCESSED FOR CSS_RTP_DETAIL'   
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_RTP_DETAIL - '    
                         'NO RECORDS PROCESSED'                         
              END-IF                                                    
           ELSE                                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_RTP_DETAIL - '      
                      'NO RECORDS PROCESSED'                            
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE           1                      TO   WS-I.             
      *                                                                         
           PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
            (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_SPCL_FCTR_APPL')      
            OR END-OF-SYSIPT.                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_SPCL_FCTR_APPL'      
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA       TO WS-JOB-PARM-DATA            
                 MOVE WS-JP-PURGE-MO-1   TO WS-MONTHS                   
                 MOVE WS-MONTHS-VALUE    TO WS-SPCL-FCTR-MO             
                 IF WS-SPCL-FCTR-MO >= 24                               
                    MOVE 'Y'             TO WS-SPCL-FCTR                
                 ELSE                                                   
                   MOVE    3             TO WS-JOB-PARM-ERR-CODE        
                   DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
                   DISPLAY 'MTHS VALUE FROM JOB PARM TBL FOR SPCL-FCTR:'
                            WS-SPCL-FCTR                                
                   DISPLAY 'NO RECS ARE PROCESSED FOR'                  
                           'CSS_SPCL_FCTR_APPL'                         
                   DISPLAY '            '                               
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_SPCL_FCTR_APPL - '
                         'NO RECORDS PROCESSED'                         
              END-IF                                                    
           ELSE                                                         
              DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_SPCL_FCTR_APPL - '   
                      'NO RECORDS PROCESSED'                            
           END-IF.                                                      
      *                                                                         
ACT002     INITIALIZE WS-SYSIPT.                                        
ACT002     MOVE           1                      TO   WS-I.             
ACT002*                                                                         
ACT002     PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
ACT002      (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_OFFCYCLE_READS')      
ACT002      OR END-OF-SYSIPT.                                           
ACT002*                                                                         
ACT002     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_OFFCYCLE_READS'      
ACT002        IF INPUT-ACTIVE                                           
ACT002           MOVE G6-PARM-DATA       TO WS-JOB-PARM-DATA            
ACT002           MOVE WS-JP-PURGE-MO-1   TO WS-MONTHS                   
ACT002           MOVE WS-MONTHS-VALUE    TO WS-OFF-CYCLE-MO             
ACT002           IF WS-OFF-CYCLE-MO >= 1                                
ACT002              MOVE 'Y'             TO WS-OFF-CYCLE                
ACT002           ELSE                                                   
ACT002             MOVE    3             TO WS-JOB-PARM-ERR-CODE        
ACT002             DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
ACT165             DISPLAY 'MTHS VALUE FROM JOB PARM TBL FOR OFF CYCLE:'
ACT002                      WS-OFF-CYCLE-MO                             
ACT002             DISPLAY 'NO RECS ARE PROCESSED FOR'                  
ACT002                     'CSS_OFFCYCLE_READS'                         
ACT002             DISPLAY '            '                               
ACT002           END-IF                                                 
ACT002        ELSE                                                      
ACT002           DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_OFFCYCLE_READS - '
ACT002                   'NO RECORDS PROCESSED'                         
ACT002        END-IF                                                    
ACT002     ELSE                                                         
ACT002        DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_OFFCYCLE_READS - '   
ACT002                   'NO RECORDS PROCESSED'                         
ACT002     END-IF.                                                      
ACT002*                                                                         
      *                                                                         
ACT165     INITIALIZE WS-SYSIPT.                                        
ACT165     MOVE           1                      TO   WS-I.             
ACT165*                                                                         
ACT165     PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
ACT165      (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CORR_MAIL_STAT')      
ACT165      OR END-OF-SYSIPT.                                           
ACT165*                                                                         
ACT165     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CORR_MAIL_STAT'      
ACT165        IF INPUT-ACTIVE                                           
ACT165           MOVE G6-PARM-DATA       TO WS-JOB-PARM-DATA            
ACT165           MOVE WS-JP-PURGE-MO-1   TO WS-MONTHS                   
ACT165           MOVE WS-MONTHS-VALUE    TO WS-CORR-MAIL-STAT-MO        
ACT165           IF  WS-CORR-MAIL-STAT-MO > 1 AND                       
ACT165               WS-CORR-MAIL-STAT-MO < 4                           
ACT165                  MOVE 'Y'             TO WS-CORR_MAIL_STAT       
ACT165           ELSE                                                   
ACT165             MOVE    3             TO WS-JOB-PARM-ERR-CODE        
ACT165             DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
ACT165             DISPLAY 'MTHS VALUE FROM JOB PARM TBL FOR '          
ACT165                      'CORR MAIL STAT: ' WS-CORR-MAIL-STAT-MO     
ACT165             DISPLAY 'NO RECS ARE PROCESSED FOR'                  
ACT165                     'CSS_CORR_MAIL_STAT'                         
ACT165             DISPLAY '            '                               
ACT165           END-IF                                                 
ACT165        ELSE                                                      
ACT165           DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CORR_MAIL_STAT - '
ACT165                   'NO RECORDS PROCESSED'                         
ACT165        END-IF                                                    
ACT165     ELSE                                                         
ACT165        DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CORR_MAIL_STAT - '   
ACT165                'NO RECORDS PROCESSED'                            
ACT165     END-IF.                                                      
ACT165*                                                                         
ACT165     INITIALIZE WS-SYSIPT.                                        
ACT165     MOVE           1                      TO   WS-I.             
ACT165*                                                                         
ACT165     PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
ACT165      (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BTU_FACTOR    ')      
ACT165      OR END-OF-SYSIPT.                                           
ACT165*                                                                         
ACT165     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BTU_FACTOR    '      
ACT165        IF INPUT-ACTIVE                                           
ACT165           MOVE G6-PARM-DATA       TO WS-JOB-PARM-DATA            
ACT165           MOVE WS-JP-PURGE-MO-1   TO WS-MONTHS                   
ACT165           MOVE WS-MONTHS-VALUE    TO WS-BTU-FACTOR-MO            
ACT165           IF  WS-BTU-FACTOR-MO     > 24 AND                      
ACT165               WS-BTU-FACTOR-MO     < 60                          
ACT165                  MOVE 'Y'             TO WS-BTU-FACTOR           
ACT165           ELSE                                                   
ACT165             MOVE    3             TO WS-JOB-PARM-ERR-CODE        
ACT165             DISPLAY 'MONTHS SUPPLIED THRU JOB PARM ARE NOT VALID'
ACT165             DISPLAY 'MTHS VALUE FROM JOB PARM TBL FOR '          
ACT165                      'BTU FACTOR:     ' WS-BTU-FACTOR-MO         
ACT165             DISPLAY 'NO RECS ARE PROCESSED FOR'                  
ACT165                     'CSS_BTU_FACTOR'                             
ACT165             DISPLAY '            '                               
ACT165           END-IF                                                 
ACT165        ELSE                                                      
ACT165           DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BTU_FACTOR - '    
ACT165                   'NO RECORDS PROCESSED'                         
ACT165        END-IF                                                    
ACT165     ELSE                                                         
ACT165        DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BTU_FACTOR - '       
ACT165                   'NO RECORDS PROCESSED'                         
ACT165     END-IF.                                                      
ACT165*                                                                         
      *                                                                         
A05136     INITIALIZE WS-SYSIPT.                                        
A05136     MOVE 1 TO WS-I.                                              
      *                                                                         
A05136     PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
A05136      (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_MDM_SS_INTF    ')     
A05136      OR END-OF-SYSIPT.                                           
      *                                                                         
A05136     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_MDM_SS_INTF    '     
A05136        IF INPUT-ACTIVE                                           
A05136           MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
A05136           MOVE WS-JP-PURGE-MO-1 TO WS-MONTHS                     
A05136           MOVE WS-MONTHS-VALUE  TO WS-MDM-SS-MO                  
A05136           IF WS-MDM-SS-MO > 0                                    
A05136              MOVE 'Y' TO WS-MDM-SS-ALERT                         
A05136           ELSE                                                   
A05136              MOVE 3 TO  WS-JOB-PARM-ERR-CODE                     
A05136              DISPLAY '****************************************'  
A05136              DISPLAY 'MONTHS ON CSS_JOB_PARM ARE NOT VALID '     
A05136              DISPLAY 'MTHS VALUE FOR CSS_MDM_SS_INTF = '         
A05136                       WS-MDM-SS-MO                               
A05136              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_MDM_SS_INTF' 
A05136              DISPLAY '****************************************'  
A05136           END-IF                                                 
A05136        ELSE                                                      
A05136            DISPLAY '****************************************'    
A05136            DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_MDM_SS_INTF'     
A05136            DISPLAY 'NO RECS ARE PROCESSED FOR CSS_MDM_SS_INTF'   
A05136            DISPLAY '****************************************'    
A05136        END-IF                                                    
A05136     ELSE                                                         
A05136        DISPLAY '****************************************'        
A05136        DISPLAY 'JOB PARM NOT PRESENT FOR CSS_MDM_SS_INTF'        
A05136        DISPLAY 'NO RECS ARE PROCESSED FOR CSS_MDM_SS_INTF'       
A05136        DISPLAY '****************************************'        
A05136     END-IF.                                                      
      *                                                                         
A05136     INITIALIZE WS-SYSIPT.                                        
A05136     MOVE 1 TO WS-I.                                              
      *                                                                         
ACT165     PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
ACT165      (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BTU_INDUST_FCT ')     
ACT165      OR END-OF-SYSIPT.                                           
      *                                                                         
ACT165     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BTU_INDUST_FCT '     
ACT165        IF INPUT-ACTIVE                                           
ACT165           MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
ACT165           MOVE WS-JP-PURGE-MO-1 TO WS-MONTHS                     
ACT165           MOVE WS-MONTHS-VALUE  TO WS-BTU-INDUST-FCT-MO          
ACT165           IF WS-BTU-INDUST-FCT-MO > 30                           
ACT165              MOVE 3 TO  WS-JOB-PARM-ERR-CODE                     
ACT165              DISPLAY '****************************************'  
ACT165              DISPLAY 'MONTHS ON CSS_JOB_PARM ARE NOT VALID '     
ACT165              DISPLAY 'MTHS VALUE FOR CSS_BTU_INDUST_FCT = '      
ACT165                       WS-BTU-INDUST-FCT-MO                       
ACT165              DISPLAY 'NO RECS ARE PROCESSED FOR '                
ACT165                      'CSS_BTU_INDUST_FCT        '                
ACT165              DISPLAY '****************************************'  
ACT165           ELSE                                                   
                    MOVE 'Y' TO WS-BTU-INDUST-FCT                       
ACT165           END-IF                                                 
ACT165        ELSE                                                      
ACT165            DISPLAY '****************************************'    
ACT165            DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BTU_INDUST_FCT'  
ACT165            DISPLAY 'NO RECS ARE PROCESSED FOR '                  
ACT165                    'CSS_BTU_INDUST_FCT'                          
ACT165            DISPLAY '****************************************'    
ACT165        END-IF                                                    
ACT165     ELSE                                                         
ACT165        DISPLAY '****************************************'        
ACT165        DISPLAY 'JOB PARM NOT PRESENT FOR CSS_BTU_INDUST_FCT'     
ACT165        DISPLAY 'NO RECS ARE PROCESSED FOR CSS_BTU_INDUST_FCT'    
ACT165        DISPLAY '****************************************'        
ACT165     END-IF.                                                      
      *                                                                         
ACT257     INITIALIZE WS-SYSIPT.                                        
ACT257     MOVE 1 TO WS-I.                                              
ACT257     PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
ACT257      (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_EXCP_BILL_DET  ')     
ACT257      OR END-OF-SYSIPT.                                           
      *                                                                         
ACT257     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_EXCP_BILL_DET  '     
ACT257        IF INPUT-ACTIVE                                           
ACT257           MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
ACT257           MOVE WS-JP-PURGE-MO-1 TO WS-MONTHS                     
ACT257           MOVE WS-MONTHS-VALUE  TO WS-EXCP-BILL-DET-MO           
ACT257           IF WS-EXCP-BILL-DET-MO  > 03                           
ACT257              MOVE 3 TO  WS-JOB-PARM-ERR-CODE                     
ACT257              DISPLAY '****************************************'  
ACT257              DISPLAY 'MONTHS ON CSS_JOB_PARM ARE NOT VALID '     
ACT257              DISPLAY 'MTHS VALUE FOR CSS_EXCP_BILL_DET  = '      
ACT257                       WS-EXCP-BILL-DET-MO                        
ACT257              DISPLAY 'NO RECS ARE PROCESSED FOR '                
ACT257                      'CSS_EXCP_BILL_DET         '                
ACT257              DISPLAY '****************************************'  
ACT257           ELSE                                                   
                    MOVE 'Y' TO WS-EXCP-BILL-DET                        
ACT257           END-IF                                                 
ACT257        ELSE                                                      
ACT257            DISPLAY '****************************************'    
ACT257            DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_EXCP_BILL_DET '  
ACT257            DISPLAY 'NO RECS ARE PROCESSED FOR '                  
ACT257                    'CSS_EXCP_BILL_DET '                          
ACT257            DISPLAY '****************************************'    
ACT257        END-IF                                                    
ACT257     ELSE                                                         
ACT257        DISPLAY '****************************************'        
ACT257        DISPLAY 'JOB PARM NOT PRESENT FOR CSS_EXCP_BILL_DET '     
ACT257        DISPLAY 'NO RECS ARE PROCESSED FOR CSS_EXCP_BILL_DET '    
ACT257        DISPLAY '****************************************'        
ACT257     END-IF.                                                      
ACT154     INITIALIZE WS-SYSIPT.                                        
ACT154     MOVE 1 TO WS-I.                                              
ACT154     PERFORM 7610P-READ-FCSJC01 THRU 7610P-EXIT UNTIL             
ACT154      (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_TEMPERATURE    ')     
ACT154      OR END-OF-SYSIPT.                                           
      *                                                                         
ACT154     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_TEMPERATURE    '     
ACT154        IF INPUT-ACTIVE                                           
ACT154           MOVE G6-PARM-DATA     TO WS-JOB-PARM-DATA              
ACT154           MOVE WS-JP-PURGE-MO-1 TO WS-MONTHS                     
ACT154           MOVE WS-MONTHS-VALUE  TO WS-TEMPERATURE-MO             
ACT154           IF WS-TEMPERATURE-MO    >  30                          
ACT154              MOVE 3 TO  WS-JOB-PARM-ERR-CODE                     
ACT154              DISPLAY '****************************************'  
ACT154              DISPLAY 'MONTHS ON CSS_JOB_PARM ARE NOT VALID '     
ACT154              DISPLAY 'MTHS VALUE FOR CSS_TEMPERATURE    = '      
ACT154                       WS-TEMPERATURE-MO                          
ACT154              DISPLAY 'NO RECS ARE PROCESSED FOR '                
ACT154                      'CSS_TEMPERATURE           '                
ACT154              DISPLAY '****************************************'  
ACT154           ELSE                                                   
ACT154              MOVE 'Y' TO WS-TEMPERATURE                          
ACT154           END-IF                                                 
ACT154        ELSE                                                      
ACT154            DISPLAY '****************************************'    
ACT154            DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_TEMPERATURE   '  
ACT154            DISPLAY 'NO RECS ARE PROCESSED FOR '                  
ACT154                    'CSS_TEMPERATURE   '                          
ACT154            DISPLAY '****************************************'    
ACT154        END-IF                                                    
ACT154     ELSE                                                         
ACT154        DISPLAY '****************************************'        
ACT154        DISPLAY 'JOB PARM NOT PRESENT FOR CSS_TEMPERATURE   '     
ACT154        DISPLAY 'NO RECS ARE PROCESSED FOR CSS_TEMPERATURE   '    
ACT154        DISPLAY '****************************************'        
ACT154     END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * PURGE PROCESS FOR TABLES WHICH ARE HAVING ACTIVE JOB PARM    *          
      ****************************************************************          
      *                                                                         
       1000-PURGE-PROCESS.                                              
      *                                                                         
           IF ROUTE-REPORT                                              
              PERFORM 1010-ROUTE-REPORT           THRU 1010-EXIT        
           END-IF.                                                      
      *                                                                         
           IF RTP-DETAIL                                                
              PERFORM 1020-RTP-DETAIL             THRU 1020-EXIT        
           END-IF.                                                      
      *                                                                         
      *                                                                         
           IF SPCL-FCTR                                                 
              PERFORM 1040-SPCL-FCTR-APPL         THRU 1040-EXIT        
           END-IF.                                                      
      *                                                                         
ACT002     IF OFF-CYCLE                                                 
ACT002        PERFORM 1050-OFF-CYCLE-READS        THRU 1050-EXIT        
ACT002     END-IF.                                                      
      *                                                                         
ACT165     IF CORR-MAIL-STAT                                            
ACT165        PERFORM 1060-CORR-MAIL-STAT THRU 1060-EXIT                
ACT165     END-IF.                                                      
ACT165*                                                                         
ACT165     IF BTU-FACTOR                                                
ACT165        PERFORM 1070-BTU-FACTOR     THRU 1070-EXIT                
ACT165     END-IF.                                                      
ACT165*                                                                         
P05136     IF MDM-SS-ALERT                                              
P05136        PERFORM 1080-MDM-SS-INTF THRU 1080-EXIT                   
P05136     END-IF.                                                      
      *                                                                         
ACT165     IF BTU-INDUST-FACTOR                                         
ACT165        PERFORM 1090-BTU-INDUST-FACTOR THRU 1090-EXIT             
ACT165     END-IF.                                                      
      *                                                                         
ACT257     IF EXCP-BILL-DET                                             
ACT257        PERFORM 1100-EXCP-BILL-DET     THRU 1100-EXIT             
ACT257     END-IF.                                                      
                                                                        
ACT154     IF TEMPERATURE                                               
ACT154        PERFORM 1110-PROC-TEMPERATURE  THRU 1110-EXIT             
ACT154     END-IF.                                                      
      *                                                                         
           MOVE WS-JOB-PARM-ERR-CODE              TO RETURN-CODE.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_ROUTE_REPORT        *          
      ****************************************************************          
      *                                                                         
       1010-ROUTE-REPORT.                                               
      *                                                                         
      *                                                                         
           INITIALIZE WS-COMMIT-COUNT.                                  
           DISPLAY 'PROCESSING ROUTE REPORT'.                           
      *                                                                         
           PERFORM 7210-OPEN-ROUTE-REPORT-CURSOR THRU 7210-EXIT.        
           PERFORM 7220-FETCH-ROUTE-REPORT-CURSOR THRU 7220-EXIT.       
      *                                                                         
           MOVE    ZEROS               TO  WS-PREV-ACCOUNT-NO.          
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE  'N'                       TO   WS-SECURED-IND       
              IF PW-COMPANY-NO = '26'                                   
                 IF PW-ACCOUNT-NO NOT EQUAL TO WS-PREV-ACCOUNT-NO       
                    PERFORM 7300-CHECK-SECURED-IND THRU 7300-EXIT       
                    MOVE    PW-ACCOUNT-NO          TO WS-PREV-ACCOUNT-NO
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF (SECURED-IND AND                                       
                      PW-LAST-REG-READ-DT <= WS-ROUTE-RPT-PSNC-SECURED) 
                OR NOT-SECURED                                          
                   PERFORM 8010-DELETE-ROUTE-REPORT       THRU 8010-EXIT
              END-IF                                                    
              PERFORM 7220-FETCH-ROUTE-REPORT-CURSOR THRU 7220-EXIT     
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7230-CLOSE-ROUTE-REPORT-CURSOR THRU 7230-EXIT.       
      *                                                                         
      *                                                                         
           IF WS-COMMIT-TEST > 0                                        
               ADD +1  TO WS-CHECKPOINT-NBR                             
               PERFORM 8900-COMMIT           THRU 8900-EXIT             
           END-IF.                                                      
           DISPLAY 'COMPLETED  ROUTE REPORT'.                           
      *                                                                         
       1010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * DELETES RECORDS FROM CSS_RTP_DETAIL WHEN OLDER THAN 2 YEARS  *          
      ****************************************************************          
      *                                                                         
       1020-RTP-DETAIL.                                                 
      *                                                                         
      *                                                                         
           DISPLAY 'PROCESSING RTP DETAIL'.                             
           INITIALIZE WS-COMMIT-COUNT.                                  
           MOVE  WS-RTP-DETAIL-DATE       TO   J3-PRICE-APPLIES-DT      
           PERFORM 7610-OPEN-RTP-DETAIL            THRU 7610-EXIT.      
           PERFORM 7620-FETCH-RTP-DETAIL           THRU 7620-EXIT.      
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 8000-DELETE-RTP-DETAIL      THRU 8000-EXIT       
               PERFORM 7620-FETCH-RTP-DETAIL       THRU 7620-EXIT       
           END-PERFORM.                                                 
           PERFORM 7630-CLOSE-RTP-DETAIL           THRU 7630-EXIT.      
           IF WS-COMMIT-TEST > 0                                        
               ADD +1  TO WS-CHECKPOINT-NBR                             
               PERFORM 8900-COMMIT           THRU 8900-EXIT             
           END-IF.                                                      
      *                                                                         
           DISPLAY 'COMPLETED  RTP DETAIL'.                             
      *                                                                         
       1020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHING & DELETING THE RECORDS FROM CSS_SPCL_FCTR_APPL      *          
      ****************************************************************          
      *                                                                         
       1040-SPCL-FCTR-APPL.                                             
      *                                                                         
           DISPLAY 'PROCESSING SPCL FCTR APPL'.                         
           MOVE    WS-SPCL-FCTR-DATE          TO   SA-DATE-TO           
           PERFORM 8040-DELETE-SPCL-FCTR-APPL THRU 8040-EXIT.           
           MOVE 1 TO WS-CHECKPOINT-NBR                                  
           PERFORM 8900-COMMIT           THRU 8900-EXIT.                
           DISPLAY 'COMPLETED  SPCL FCTR APPL PURGE'.                   
      *                                                                         
       1040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04684****************************************************************          
A04684* FETCHING & DELETING THE RECORDS FROM CSS_OFFCYCLE_READS      *          
A04684****************************************************************          
A04684*                                                                         
ACT002 1050-OFF-CYCLE-READS.                                            
A04684*                                                                         
A04684*                                                                         
           DISPLAY 'PROCESSING OFF CYCLE READS'.                        
A04684     INITIALIZE WS-COMMIT-COUNT.                                  
A04684     PERFORM 7310-OPEN-OFFCYC-READ    THRU 7310-EXIT.             
A04684     PERFORM 7320-FETCH-OFFCYC-READ   THRU 7320-EXIT.             
A04684     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A04684       PERFORM 8050-DELETE-OFFCYC-READ THRU 8050-EXIT             
A04684       PERFORM 7320-FETCH-OFFCYC-READ THRU 7320-EXIT              
A04684     END-PERFORM.                                                 
A04684     PERFORM 7340-CLOSE-OFFCYC-READ   THRU 7340-EXIT.             
           IF WS-COMMIT-TEST > 0                                        
               ADD  1 TO WS-CHECKPOINT-NBR                              
               PERFORM 8900-COMMIT          THRU 8900-EXIT              
           END-IF.                                                      
A04684     DISPLAY 'COMPLETED  OFF CYCLE READS    '.                    
A04684*                                                                         
A04684 1050-EXIT.                                                       
A04684     EXIT.                                                        
ACT165*                                                                         
ACT165***************************************************************           
ACT165* FETCHING & DELETING THE RECORDS FROM CSS_CORR_MAIL_STAT     *           
ACT165***************************************************************           
ACT165 1060-CORR-MAIL-STAT.                                             
ACT165*                                                                         
ACT165     INITIALIZE WS-COMMIT-COUNT.                                  
           DISPLAY 'PROCESSING CORR MAIL STAT'.                         
ACT165*                                                                         
ACT165     PERFORM 7500-OPEN-CORR-MAIL-CSR  THRU 7500-EXIT.             
ACT165     PERFORM 7510-FETCH-CORR-MAIL-CSR THRU 7510-EXIT.             
ACT165*                                                                         
ACT165     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
ACT165        PERFORM 8060-DELETE-CORR-MAIL-STAT THRU 8060-EXIT         
ACT165        PERFORM 7510-FETCH-CORR-MAIL-CSR   THRU 7510-EXIT         
ACT165     END-PERFORM.                                                 
ACT165*                                                                         
ACT165     PERFORM 7520-CLOSE-CORR-MAIL-CSR THRU 7520-EXIT.             
ACT165*                                                                         
           IF WS-COMMIT-TEST > 0                                        
               ADD +1 TO WS-CHECKPOINT-NBR                              
               PERFORM 8900-COMMIT          THRU 8900-EXIT              
           END-IF                                                       
ACT165     DISPLAY 'COMPLETED  CORR MAIL STAT'.                         
ACT165*                                                                         
ACT165 1060-EXIT.                                                       
ACT165     EXIT.                                                        
      *                                                                         
ACT165*                                                                         
ACT165****************************************************************          
ACT165* FETCHING & DELETING THE RECORDS FROM CSS_BTU_FACTOR          *          
ACT165****************************************************************          
ACT165 1070-BTU-FACTOR.                                                 
ACT165*                                                                         
           DISPLAY 'PROCESSING BTU FACTOR'.                             
ACT165*                                                                         
ACT165     PERFORM 8070-DELETE-BTU-FACTOR     THRU 8070-EXIT            
ACT165*                                                                         
           MOVE 1 TO WS-CHECKPOINT-NBR                                  
           PERFORM 8900-COMMIT          THRU 8900-EXIT                  
ACT165*                                                                         
ACT165     DISPLAY 'COMPLETED  BTU FACTOR'.                             
ACT165*                                                                         
ACT165 1070-EXIT.                                                       
ACT165     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A05136* DELETE RECORDS FROM CSS_MDM_SS_INTF                          *          
      ****************************************************************          
      *                                                                         
A05136 1080-MDM-SS-INTF.                                                
      *                                                                         
A05136     DISPLAY 'PROCESSING MDM SS INTF PURGE'.                      
A05136     PERFORM 8030-DELETE-MDM-SS-INTF THRU 8030-EXIT               
      *                                                                         
           MOVE 1 TO WS-CHECKPOINT-NBR                                  
A05136     PERFORM 8900-COMMIT           THRU 8900-EXIT.                
      *                                                                         
A05136     DISPLAY 'COMPLETED  MDM SS INTF'.                            
      *                                                                         
A05136 1080-EXIT.                                                       
A05136     EXIT.                                                        
ACT165 1090-BTU-INDUST-FACTOR.                                          
ACT165****************************************************************          
ACT165* CURSOR DEFINITION TO SELECT CSS_BTU_FACTOR     TO DELETE     *          
ACT165****************************************************************          
ACT165*                                                                         
ACT165     INITIALIZE WS-COMMIT-COUNT.                                  
ACT165     DISPLAY 'PROCESSING BTU INDUST FCT'..                        
ACT165     PERFORM 8080-DELETE-BTU-INDUST-FACTOR THRU 8080-EXIT.        
ACT165*                                                                         
ACT165     MOVE 1 TO WS-CHECKPOINT-NBR                                  
ACT165     PERFORM 8900-COMMIT           THRU 8900-EXIT.                
ACT165*                                                                         
ACT165     DISPLAY 'COMPLETED  BTU INDUST FCT'.                         
ACT165 1090-EXIT.                                                       
ACT165     EXIT.                                                        
      *                                                                         
ACT257****************************************************************          
ACT257* DELETE RECORDS FROM CSS_EXCP_BILL_DET                        *          
ACT257****************************************************************          
ACT257*                                                                         
ACT257 1100-EXCP-BILL-DET.                                              
ACT257*                                                                         
ACT257     DISPLAY 'PROCESSING EXCP BILL DET PURGE'.                    
ACT257     PERFORM 8090-DELETE-EXCP-BILL-DET THRU 8090-EXIT.            
ACT257*                                                                         
ACT257     MOVE 1 TO WS-CHECKPOINT-NBR.                                 
ACT257     PERFORM 8900-COMMIT           THRU 8900-EXIT.                
ACT257*                                                                         
ACT257     DISPLAY 'COMPLETED  EXCP-BILL-DET'.                          
ACT257*                                                                         
ACT257 1100-EXIT.                                                       
ACT257     EXIT.                                                        
      *                                                                         
ACT154****************************************************************          
ACT154* FETCHING & DELETING THE RECORDS FROM CSS_TEMPERATURE         *          
ACT154****************************************************************          
ACT154*                                                                         
ACT154 1110-PROC-TEMPERATURE.                                           
ACT154*                                                                         
ACT154     DISPLAY 'PROCESSING TEMPERATURE   PURGE'.                    
ACT154     PERFORM 8100-DELETE-TEMPERATURE   THRU 8100-EXIT.            
ACT154*                                                                         
ACT154     MOVE 1 TO WS-CHECKPOINT-NBR.                                 
ACT154     PERFORM 8900-COMMIT           THRU 8900-EXIT.                
ACT154*                                                                         
ACT154     DISPLAY 'COMPLETED  TEMPERATURE '.                           
ACT154*                                                                         
ACT154 1110-EXIT.                                                       
ACT154     EXIT.                                                        
ACT154*                                                                         
      ****************************************************************          
      * PRINTS THE TOTAL NO.OF RECORDS DELETED                       *          
      ****************************************************************          
      *                                                                         
       2000-PRINT-TOTALS.                                               
      *                                                                         
ACT165     DISPLAY ' '.                                                 
ACT165     DISPLAY 'NUMBER OF ROWS DELETED FROM:'                       
           DISPLAY '* CSS_ROUTE_REPORT TABLE:  * ' WS-ROUTRPT-COUNT.    
           DISPLAY '* CSS_RTP_DETAIL TABLE     * ' WS-RTP-DETAIL-COUNT. 
           DISPLAY '* CSS_SPCL_FCTR_APPL TABLE * ' WS-SPCL-FCTR-COUNT.  
684        DISPLAY '* CSS_OFFCYCLE_READS TABLE * ' WS-OFFCYCLE-COUNT.   
136        DISPLAY '* CSS_MDM_SS_INTF TABLE    * ' WS-MDM-SS-COUNT.     
ACT165     DISPLAY '* CSS_CORR_MAIL_STAT       * '                      
ACT165                                        WS-CORR-MAIL-STAT-COUNT.  
ACT165     DISPLAY '* CSS_BTU_FACTOR           * ' WS-BTU-FACTOR-COUNT. 
ACT165     DISPLAY '* CSS_BTU_INDUST_FCT       * '                      
ACT165                                         WS-BTU-INDUST-FCT-COUNT. 
ACT165     DISPLAY '* CSS_EXCP_BILL_DET        * '                      
ACT165                                         WS-EXCP-BILL-DET-COUNT.  
ACT154     DISPLAY '* CSS_TEMPERATURE          * '                      
ACT154                                         WS-TEMPERATURE-COUNT.    
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      **    DETERMINE DATES USING CURRENT DATE FOR ALL CURSORS      **          
      ****************************************************************          
      *                                                                         
       7200-SET-PURGE-DATES.                                            
      *                                                                         
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
            SELECT
              (DATEADD( MONTH, -(:WS-ROUTE-RPT-MO1), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-ROUTE-RPT-MO2), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-RPT-DETAIL-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-SPCL-FCTR-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-OFF-CYCLE-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-MDM-SS-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-CORR-MAIL-STAT-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-BTU-FACTOR-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-BTU-INDUST-FCT-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-EXCP-BILL-DET-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )),
              (DATEADD( MONTH, -(:WS-TEMPERATURE-MO), 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))
            INTO
              :WS-ROUTE-RPT-OTHER,
              :WS-ROUTE-RPT-PSNC-SECURED,
              :WS-RTP-DETAIL-DATE,
              :WS-SPCL-FCTR-DATE,
              :WS-OFF-CYCLE-DATE,
              :WS-MDM-SS-DATE,
              :WS-CORR-MAIL-STAT-DATE,
              :WS-BTU-FACTOR-DATE,
              :WS-BTU-INDUST-FACTOR-DATE,
              :WS-EXCP-BILL-DET-DATE,
              :WS-TEMPERATURE-DATE                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET                                                                 
MFA-TR*       :WS-ROUTE-RPT-OTHER                                               
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-ROUTE-RPT-MO1)     MONTHS)        
MFA-TR*      ,:WS-ROUTE-RPT-PSNC-SECURED                                        
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-ROUTE-RPT-MO2)     MONTHS)        
MFA-TR*      ,:WS-RTP-DETAIL-DATE                                               
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-RPT-DETAIL-MO)     MONTHS)        
MFA-TR*      ,:WS-SPCL-FCTR-DATE                                                
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-SPCL-FCTR-MO)      MONTHS)        
MFA-TR*      ,:WS-OFF-CYCLE-DATE                                                
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-OFF-CYCLE-MO)      MONTHS)        
MFA-TR*      ,:WS-MDM-SS-DATE                                                   
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-MDM-SS-MO)         MONTHS)        
MFA-TR*      ,:WS-CORR-MAIL-STAT-DATE                                           
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-CORR-MAIL-STAT-MO) MONTHS)        
MFA-TR*      ,:WS-BTU-FACTOR-DATE                                               
MFA-TR*         = (DATE (CURRENT DATE) - (:WS-BTU-FACTOR-MO)     MONTHS)        
MFA-TR*      ,:WS-BTU-INDUST-FACTOR-DATE                                        
MFA-TR*         = (DATE (CURRENT DATE)                                          
MFA-TR*         - (:WS-BTU-INDUST-FCT-MO) MONTHS)                               
MFA-TR*      ,:WS-EXCP-BILL-DET-DATE                                            
MFA-TR*         = (DATE (CURRENT DATE)                                          
MFA-TR*         - (:WS-EXCP-BILL-DET-MO) MONTHS)                                
MFA-TR*      ,:WS-TEMPERATURE-DATE                                              
MFA-TR*         = (DATE (CURRENT DATE)                                          
MFA-TR*         - (:WS-TEMPERATURE-MO) MONTHS)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05136     MOVE WS-MDM-SS-TIMESTAMP TO WS-MDM-SS-TMESTMP.               
      *                                                                         
A05136     DISPLAY 'WS-MDM-SS-TIMESTAMP        = ' WS-MDM-SS-DATE       
ACT165             ' CURRENT DATE - ' WS-MDM-SS-MO ' MONTHS AGO'.       
           DISPLAY 'WS-ROUTE-RPT-OTHER         = ' WS-ROUTE-RPT-OTHER   
                   ' CURRENT DATE - ' WS-ROUTE-RPT-MO1 ' MONTHS AGO'    
           DISPLAY 'WS-ROUTE-RPT-PSNC-SECURED  = '                      
                                          WS-ROUTE-RPT-PSNC-SECURED     
                   ' CURRENT DATE - ' WS-ROUTE-RPT-MO2 ' MONTHS AGO'    
           MOVE    '01'                   TO  WS-RTP-DETAIL-DD          
           DISPLAY 'WS-RTP-DETAIL-DATE         = ' WS-RTP-DETAIL-DATE   
                   ' CURRENT DATE - ' WS-RPT-DETAIL-MO ' MONTHS AGO'    
           DISPLAY 'WS-SPCL-FCTR-DATE          = ' WS-SPCL-FCTR-DATE    
                   ' CURRENT DATE - ' WS-SPCL-FCTR-MO ' MONTHS AGO'     
ACT002     DISPLAY 'WS-OFF-CYCLE-DATE          = ' WS-OFF-CYCLE-DATE    
ACT002             ' CURRENT DATE - ' WS-OFF-CYCLE-MO ' MONTHS AGO'.    
ACT165     DISPLAY 'WS-BTU-FACTOR-DATE         = ' WS-BTU-FACTOR-DATE   
ACT165             ' CURRENT DATE - ' WS-BTU-FACTOR-MO ' MONTHS AGO'    
ACT165     DISPLAY 'WS-CORR-MAIL-STAT-DATE     = '                      
ACT165              WS-CORR-MAIL-STAT-DATE                              
ACT165             ' CURRENT DATE - ' WS-CORR-MAIL-STAT-MO ' MONTHS AGO'
ACT165     DISPLAY 'WS-BTU-INDUST-FACTOR-DATE =  '                      
ACT165              WS-BTU-INDUST-FACTOR-DATE                           
ACT165             ' CURRENT DATE - ' WS-BTU-INDUST-FCT-MO ' MONTHS AGO'
ACT257     DISPLAY 'WS-EXCP-BILL-DET-DATE     =  ' WS-EXCP-BILL-DET-DATE
ACT257             ' CURRENT DATE - ' WS-EXCP-BILL-DET-MO  ' MONTHS AGO'
ACT154     DISPLAY 'WS-TEMPERATURE-DATE       =  ' WS-TEMPERATURE-DATE  
ACT154             ' CURRENT DATE - ' WS-TEMPERATURE-MO    ' MONTHS AGO'
      *                                                                         
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSXP110******************'    
               DISPLAY '* 7200-SET-PURGE-DATES              *'          
               DISPLAY '* SQLCODE            = ' WS-ACTIVE-RETURN-CODE  
               DISPLAY '* CHECK MONTHS IN ABOVE LIST FOR ERRORS'        
               DISPLAY '*****************PCSXP110******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING          *          
      **    7600P-START-FCSJC01                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPDPURGE                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * OPENS ROUTE_REPORT CURSOR                                    *          
      ****************************************************************          
      *                                                                         
       7210-OPEN-ROUTE-REPORT-CURSOR.                                   
      *                                                                         
           EXEC SQL                                                     
               OPEN  ROUTE_REPORT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP110 ABORT  ************'         
              DISPLAY '* 7210-OPEN-ROUTE-REPORT-CURSOR       *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP110  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES ROUTE_REPORT MORE THAN 6 MONTHS.                     *          
      ****************************************************************          
      *                                                                         
       7220-FETCH-ROUTE-REPORT-CURSOR.                                  
      *                                                                         
           EXEC SQL                                                     
               FETCH  ROUTE_REPORT                                      
                INTO :PW-ACCOUNT-NO,                                    
                     :PW-REVENUE-MONTH,                                 
                     :PW-CODE-UTIL-TYPE,                                
                     :PW-IC-NO,                                         
                     :PW-METER-NO,                                      
                     :PW-REG-MEASURE-CD,                                
                     :PW-CODE-TIME-PERIOD,                              
                     :PW-CODE-TOU-SEASN,                                
                     :PW-LAST-REG-READ-DT,                              
                     :PW-LAST-REG-READ-TM,                              
                     :PW-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP110 ABORT  ************'         
              DISPLAY '* 7220-FETCH-ROUTE-REPORT-CURSOR      *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY 'PW-ACCOUNT-NO'       PW-ACCOUNT-NO               
              DISPLAY 'PW-REVENUE-MONTH'    PW-REVENUE-MONTH            
              DISPLAY 'PW-CODE-UTIL-TYPE'   PW-CODE-UTIL-TYPE           
              DISPLAY 'PW-IC-NO'            PW-IC-NO                    
              DISPLAY 'PW-METER-NO'         PW-METER-NO                 
              DISPLAY 'PW-REG-MEASURE-CD'   PW-REG-MEASURE-CD           
              DISPLAY 'PW-CODE-TIME-PERIOD' PW-CODE-TIME-PERIOD         
              DISPLAY 'PW-CODE-TOU-SEASN'   PW-CODE-TOU-SEASN           
              DISPLAY 'PW-LAST-REG-READ-DT' PW-LAST-REG-READ-DT         
              DISPLAY 'PW-LAST-REG-READ-TM' PW-LAST-REG-READ-TM         
              DISPLAY '********** PCSXP110  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES ROUTE_REPORT CURSOR                                   *          
      ****************************************************************          
      *                                                                         
       7230-CLOSE-ROUTE-REPORT-CURSOR.                                  
      *                                                                         
           EXEC SQL                                                     
               CLOSE ROUTE_REPORT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP110 ABORT  ************'         
              DISPLAY '* 7230-CLOSE-ROUTE-REPORT-CURSOR      *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP110  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CHECKS SECURED RATE INDICATOR                                *          
      ****************************************************************          
      *                                                                         
       7300-CHECK-SECURED-IND.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                 INTO  :WS-SECURED-IND                                  
                 FROM  CSS_UTIL_ENVRNMT     UT WITH(READUNCOMMITTED)            
                      ,CSS_RATE_PLAN_DESC   RD WITH(READUNCOMMITTED)            
                WHERE  UT.ACCOUNT_NO      = :PW-ACCOUNT-NO              
                AND    UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO             
                AND    RD.SECURED_RATE_FL = 'Y'                         
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*          INTO  :WS-SECURED-IND                                          
MFA-TR*          FROM  CSS_UTIL_ENVRNMT     UT                                  
MFA-TR*               ,CSS_RATE_PLAN_DESC   RD                                  
MFA-TR*         WHERE  UT.ACCOUNT_NO      = :PW-ACCOUNT-NO                      
MFA-TR*         AND    UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                     
MFA-TR*         AND    RD.SECURED_RATE_FL = 'Y'                                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND    
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSXP110 ABORT  ************'         
              DISPLAY '* 7300-CHECK-SECURED-IND         *'              
              DISPLAY '* UT.ACCOUNT_NO  *'   PW-ACCOUNT-NO              
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP110  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04684* OPENS OFFCYC_READS CURSOR                                  *            
A04684****************************************************************          
A04684*                                                                         
A04684 7310-OPEN-OFFCYC-READ.                                           
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684         OPEN OFFCYC_READS                                        
A04684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04684     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04684        CONTINUE                                                  
A04684     ELSE                                                         
A04684        DISPLAY '********** PCSXP110 ABORT  ************'         
A04684        DISPLAY '* 7310-OPEN-OFFCYC-READ-CURSOR     *'            
A04684        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A04684        DISPLAY '* TABLE       = CSS_OFFCYCLE_READS'              
A04684        DISPLAY '* REG_READ_DT = ' WS-OFF-CYCLE-DATE              
A04684        DISPLAY '* PROGRAM ABORTING...                 *'         
A04684        DISPLAY '********** PCSXP110  ABORT ************'         
A04684        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7310-EXIT.                                                       
A04684     EXIT.                                                        
A04684*                                                                         
A04684****************************************************************          
A04684* FETCHES OFFCYC_READS                                       *            
A04684****************************************************************          
A04684*                                                                         
A04684 7320-FETCH-OFFCYC-READ.                                          
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684         FETCH OFFCYC_READS                                       
A04684         INTO  :3B-DEVICE-NO                                      
A04684              ,:3B-COMPANY-NO                                     
A04684              ,:3B-REG-READ-DT                                    
A04684              ,:3B-REG-READ-TM                                    
A04684              ,:3B-CODE-UTIL-TYPE                                 
A04684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04684     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04684        CONTINUE                                                  
A04684     ELSE                                                         
A04684        DISPLAY '********** PCSXP110 ABORT  ************'         
A04684        DISPLAY '* 7320-FETCH-OFFCYC-READS-CURSOR    *'           
A04684        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A04684        DISPLAY '* TABLE       = CSS_OFFCYCLE_READS'              
A04684        DISPLAY '* REG_READ_DT = ' WS-OFF-CYCLE-DATE              
A04684        DISPLAY '* PROGRAM ABORTING...                 *'         
A04684        DISPLAY '********** PCSXP110  ABORT ************'         
A04684        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7320-EXIT.                                                       
A04684     EXIT.                                                        
A04684*                                                                         
A04684****************************************************************          
A04684* CLOSES OFFCYC_READS CURSOR                                   *          
A04684****************************************************************          
A04684*                                                                         
A04684 7340-CLOSE-OFFCYC-READ.                                          
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684         CLOSE OFFCYC_READS                                       
A04684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04684     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04684        CONTINUE                                                  
A04684     ELSE                                                         
A04684        DISPLAY '********** PCSXP110 ABORT  ************'         
A04684        DISPLAY '* 7340-CLOSE-OFFCYC-READ-CURSOR    *'            
A04684        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A04684        DISPLAY '* TABLE       = CSS_OFFCYCLE_READS'              
A04684        DISPLAY '* REG_READ_DT = ' WS-OFF-CYCLE-DATE              
A04684        DISPLAY '* PROGRAM ABORTING...                 *'         
A04684        DISPLAY '********** PCSXP110  ABORT ************'         
A04684        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7340-EXIT.                                                       
A04684     EXIT.                                                        
      *                                                                         
ACT165****************************************************************          
ACT165* OPENS CSS_CORR_MAIL_STAT                                     *          
ACT165****************************************************************          
ACT165*                                                                         
ACT165 7500-OPEN-CORR-MAIL-CSR.                                         
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165         OPEN CORR_CSR                                            
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT165        CONTINUE                                                  
ACT165     ELSE                                                         
ACT165        DISPLAY '********** PCSXP110 ABORT  ************'         
ACT165        DISPLAY '* OPEN CURSOR ERROR FOR PARAGRAPH     *'         
ACT165        DISPLAY '* 7500-OPEN-CORR-MAIL-STAT-CSR    *'             
ACT165        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
ACT165        DISPLAY '***************************************'         
ACT165        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT165     END-IF.                                                      
ACT165*                                                                         
ACT165 7500-EXIT.                                                       
ACT165     EXIT.                                                        
ACT165*                                                                         
ACT165****************************************************************          
ACT165* FETCHES CSS_CORR_MAIL_STAT                                   *          
ACT165****************************************************************          
ACT165*                                                                         
ACT165 7510-FETCH-CORR-MAIL-CSR.                                        
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165         FETCH  CORR_CSR                                          
ACT165          INTO :MW-ACCOUNT-NO                                     
ACT165              ,:MW-BARCODE-UNIQUE-ID                              
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT165        CONTINUE                                                  
ACT165     ELSE                                                         
ACT165        DISPLAY '********** PCSXP110 ABORT  ************'         
ACT165        DISPLAY '* FETCH CURSOR ERROR FOR PARAGRAPH    *'         
ACT165        DISPLAY '* 7510-FETCH-CORR-MAIL-STAT-CSR       *'         
ACT165        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
ACT165        DISPLAY '***************************************'         
ACT165        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT165     END-IF.                                                      
ACT165*                                                                         
ACT165 7510-EXIT.                                                       
ACT165     EXIT.                                                        
ACT165*                                                                         
ACT165****************************************************************          
ACT165* CLOSES CSS_CORR_MAIL_STAT                                    *          
ACT165****************************************************************          
ACT165*                                                                         
ACT165 7520-CLOSE-CORR-MAIL-CSR.                                        
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165         CLOSE CORR_CSR                                           
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT165        CONTINUE                                                  
ACT165     ELSE                                                         
ACT165        DISPLAY '********** PCSXP110 ABORT  ************'         
ACT165        DISPLAY '* CLOSE CURSOR ERROR FOR PARAGRAPH    *'         
ACT165        DISPLAY '* 7520-CLOSE-CORR-MAIL-STAT-CSR   *'             
ACT165        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
ACT165        DISPLAY '***************************************'         
ACT165        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT165     END-IF.                                                      
ACT165*                                                                         
ACT165 7520-EXIT.                                                       
ACT165     EXIT.                                                        
ACT165****************************************************************          
ACT165* OPENS CSS_BTU_FACTOR                                         *          
ACT165****************************************************************          
ACT165*                                                                         
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_ROUTE_REPORT                        *          
      ****************************************************************          
      *                                                                         
           EXIT.                                                        
       7610-OPEN-RTP-DETAIL.                                            
ACT165     EXEC SQL                                                     
ACT165         OPEN RTP_DETAIL_CSR                                      
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT165        CONTINUE                                                  
ACT165     ELSE                                                         
ACT165        DISPLAY '********** PCSXP110 ABORT  ************'         
ACT165        DISPLAY '* OPEN CURSOR ERROR FOR PARAGRAPH     *'         
ACT165        DISPLAY '* 7610-OPEN-RTP-DETAIL-CSR    *'                 
ACT165        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
ACT165        DISPLAY '***************************************'         
ACT165        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT165     END-IF.                                                      
ACT165*                                                                         
       7610-EXIT.                                                       
           EXIT.                                                        
       7620-FETCH-RTP-DETAIL.                                           
ACT165     EXEC SQL                                                     
ACT165         FETCH  RTP_DETAIL_CSR                                    
ACT165          INTO :J3-CODE-UTIL-TYPE                                 
ACT165              ,:J3-RATE-PLAN-NO                                   
ACT165              ,:J3-VERSION-NO-CNTRL                               
ACT165              ,:J3-CMPNT-ID-CD                                    
ACT165              ,:J3-CODE-USE-INST-TYPE                             
ACT165              ,:J3-PRICE-APPLIES-DT                               
ACT165              ,:J3-PRICE-APPLIES-HR                               
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT165        CONTINUE                                                  
ACT165     ELSE                                                         
ACT165        DISPLAY '********** PCSXP110 ABORT  ************'         
ACT165        DISPLAY '* FETCH CURSOR ERROR FOR PARAGRAPH    *'         
ACT165        DISPLAY '* 7620-FETCH-RTP-DETAIL-CSR           *'         
ACT165        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
ACT165        DISPLAY '***************************************'         
ACT165        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT165     END-IF.                                                      
ACT165*                                                                         
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_RTP_DETAIL                          *          
      ****************************************************************          
      *                                                                         
       7630-CLOSE-RTP-DETAIL.                                           
ACT165     EXEC SQL                                                     
ACT165         CLOSE RTP_DETAIL_CSR                                     
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT165        CONTINUE                                                  
ACT165     ELSE                                                         
ACT165        DISPLAY '********** PCSXP110 ABORT  ************'         
ACT165        DISPLAY '* CLOSE CURSOR ERROR FOR PARAGRAPH     *'        
ACT165        DISPLAY '* 8131-OPEN-RTP-DETAIL-CSR    *'                 
ACT165        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
ACT165        DISPLAY '***************************************'         
ACT165        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT165     END-IF.                                                      
ACT165*                                                                         
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_ZIP_USAGE_SUMM                      *          
      ****************************************************************          
      *                                                                         
       8000-DELETE-RTP-DETAIL.                                          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_RTP_DETAIL                              
                WHERE CODE_UTIL_TYPE    = :J3-CODE-UTIL-TYPE     AND    
                     RATE_PLAN_NO       = :J3-RATE-PLAN-NO       AND    
                     VERSION_NO_CNTRL   = :J3-VERSION-NO-CNTRL   AND    
                     CMPNT_ID_CD        = :J3-CMPNT-ID-CD        AND    
                     CODE_USE_INST_TYPE = :J3-CODE-USE-INST-TYPE AND    
                     PRICE_APPLIES_DT   = IIF(TRY_CONVERT(DATE, 
                                                   :J3-PRICE-APPLIES-DT
              ) IS NULL OR (PATINDEX('%.%', :J3-PRICE-APPLIES-DT
              ) <> 0) OR (LEN(:J3-PRICE-APPLIES-DT
              ) <> 10), CIS.CHAR2DATE(:J3-PRICE-APPLIES-DT
              ), CONVERT(DATE, :J3-PRICE-APPLIES-DT) )   AND    
                     PRICE_APPLIES_HR   = :J3-PRICE-APPLIES-HR          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_RTP_DETAIL                                      
MFA-TR*         WHERE CODE_UTIL_TYPE    = :J3-CODE-UTIL-TYPE     AND            
MFA-TR*              RATE_PLAN_NO       = :J3-RATE-PLAN-NO       AND            
MFA-TR*              VERSION_NO_CNTRL   = :J3-VERSION-NO-CNTRL   AND            
MFA-TR*              CMPNT_ID_CD        = :J3-CMPNT-ID-CD        AND            
MFA-TR*              CODE_USE_INST_TYPE = :J3-CODE-USE-INST-TYPE AND            
MFA-TR*              PRICE_APPLIES_DT   = :J3-PRICE-APPLIES-DT   AND            
MFA-TR*              PRICE_APPLIES_HR   = :J3-PRICE-APPLIES-HR                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
ACT165*                                                                         
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT165        ADD WS-1 TO WS-COMMIT-COUNT                               
ACT165        ADD WS-1 TO WS-RTP-DETAIL-COUNT                           
ACT165        IF WS-COMMIT-TEST  = 0                                    
ACT165           PERFORM 8900-COMMIT THRU 8900-EXIT                     
ACT165        END-IF                                                    
ACT165     ELSE                                                         
ACT165        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT165           NEXT SENTENCE                                          
ACT165        ELSE                                                      
ACT165           DISPLAY '********** PCSXP110 ABORT  ************'      
ACT165           DISPLAY '* 8000-DELETE-RTP-DETAIL              *'      
ACT165           DISPLAY '* SQLCODE      = ' WS-ACTIVE-RETURN-CODE      
ACT165           DISPLAY '* TABLE        = CSS_RTP_DETAIL    '          
ACT165           DISPLAY '*  CODE_UTIL_TYPE    = ' J3-CODE-UTIL-TYPE    
ACT165           DISPLAY '* RATE_PLAN_NO       = ' J3-RATE-PLAN-NO      
ACT165           DISPLAY '* VERSION_NO_CNTRL   = ' J3-VERSION-NO-CNTRL  
ACT165           DISPLAY '* CMPNT_ID_CD        = ' J3-CMPNT-ID-CD       
ACT165           DISPLAY '* CODE_USE_INST_TYPE = ' J3-CODE-USE-INST-TYPE
ACT165           DISPLAY '* PRICE_APPLIES_DT   = ' J3-PRICE-APPLIES-DT  
ACT165           DISPLAY '* PRICE_APPLIES_HR   = ' J3-PRICE-APPLIES-HR  
ACT165           DISPLAY '********** PCSXP110  ABORT ************'      
ACT165           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT165        END-IF                                                    
ACT165     END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8010-DELETE-ROUTE-REPORT.                                        
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_ROUTE_REPORT                            
                 WHERE ACCOUNT_NO       =  :PW-ACCOUNT-NO               
                 AND   REVENUE_MONTH    =  :PW-REVENUE-MONTH            
                 AND   CODE_UTIL_TYPE   =  :PW-CODE-UTIL-TYPE           
                 AND   IC_NO            =  :PW-IC-NO                    
                 AND   METER_NO         =  :PW-METER-NO                 
                 AND   REG_MEASURE_CD   =  :PW-REG-MEASURE-CD           
                 AND   CODE_TIME_PERIOD =  :PW-CODE-TIME-PERIOD         
                 AND   CODE_TOU_SEASN   =  :PW-CODE-TOU-SEASN           
                 AND   LAST_REG_READ_DT =  IIF(TRY_CONVERT(DATE, 
                                                   :PW-LAST-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :PW-LAST-REG-READ-DT
              ) <> 0) OR (LEN(:PW-LAST-REG-READ-DT
              ) <> 10), CIS.CHAR2DATE(:PW-LAST-REG-READ-DT
              ), CONVERT(DATE, :PW-LAST-REG-READ-DT) )         
                 AND   LAST_REG_READ_TM =  CIS.CHAR2TIME(
                                                   :PW-LAST-REG-READ-TM
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_ROUTE_REPORT                                    
MFA-TR*          WHERE ACCOUNT_NO       =  :PW-ACCOUNT-NO                       
MFA-TR*          AND   REVENUE_MONTH    =  :PW-REVENUE-MONTH                    
MFA-TR*          AND   CODE_UTIL_TYPE   =  :PW-CODE-UTIL-TYPE                   
MFA-TR*          AND   IC_NO            =  :PW-IC-NO                            
MFA-TR*          AND   METER_NO         =  :PW-METER-NO                         
MFA-TR*          AND   REG_MEASURE_CD   =  :PW-REG-MEASURE-CD                   
MFA-TR*          AND   CODE_TIME_PERIOD =  :PW-CODE-TIME-PERIOD                 
MFA-TR*          AND   CODE_TOU_SEASN   =  :PW-CODE-TOU-SEASN                   
MFA-TR*          AND   LAST_REG_READ_DT =  :PW-LAST-REG-READ-DT                 
MFA-TR*          AND   LAST_REG_READ_TM =  :PW-LAST-REG-READ-TM                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              ADD WS-1 TO WS-COMMIT-COUNT                               
              ADD WS-1 TO WS-ROUTRPT-COUNT                              
              IF WS-COMMIT-TEST  = 0                                    
                 PERFORM 8900-COMMIT THRU 8900-EXIT                     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '********** PCSXP110 ABORT  ************'      
                 DISPLAY '* 8010-DELETE-ROUTE-REPORT            *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP110  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
A05136* DELETE RECORDS FROM CSS_MDM_SS_INTF TABLE                    *          
      ****************************************************************          
      *                                                                         
A05136 8030-DELETE-MDM-SS-INTF.                                         
      *                                                                         
A05136     EXEC SQL                                                     
A05136          DELETE FROM CSS_MDM_SS_INTF                             
                  WHERE  LAST_SYNC_DATE  = IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') )                 
                    AND  LAST_UPDATE_TS < CIS.CHAR2TIMESTAMP(
                                                     :WS-MDM-SS-TMESTMP
              )            
A05136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_MDM_SS_INTF                                     
MFA-TR*           WHERE  LAST_SYNC_DATE  = '0001-01-01'                         
MFA-TR*             AND  LAST_UPDATE_TS < :WS-MDM-SS-TMESTMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SQLERRD(3)  TO  WS-MDM-SS-COUNT                      
ACT165     ELSE                                                         
ACT165        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT165           NEXT SENTENCE                                          
ACT165        ELSE                                                      
ACT165           DISPLAY '********** PCSXP110 ABORT  ************'      
ACT165           DISPLAY '* 8030-DELETE-MDM-SS-INTF             *'      
ACT165           DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
ACT165           DISPLAY '* WS-MDM-SS-TMESTMP  = ' WS-MDM-SS-TMESTMP    
ACT165           DISPLAY '* PROGRAM ABORTING...                 *'      
ACT165           DISPLAY '********** PCSXP110  ABORT ************'      
ACT165           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT165        END-IF                                                    
ACT165     END-IF.                                                      
ACT165*                                                                         
      *                                                                         
A05136 8030-EXIT.                                                       
A05136     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_SPCL_FCTR_APPL                      *          
      ****************************************************************          
      *                                                                         
       8040-DELETE-SPCL-FCTR-APPL.                                      
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM SA                        
                FROM CSS_SPCL_FCTR_APPL SA
                 WHERE SA.DATE_TO   <  IIF(TRY_CONVERT(DATE, :SA-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO) <> 0) OR (LEN(
                                                            :SA-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO), CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) )                      
ACT040           AND SA.FACTOR_ID NOT IN ('COGPSNC', 'COGSCEG')         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_SPCL_FCTR_APPL SA                               
MFA-TR*          WHERE SA.DATE_TO   <  :SA-DATE-TO                              
MFA-TR*          AND SA.FACTOR_ID NOT IN ('COGPSNC', 'COGSCEG')                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SQLERRD(3)  TO  WS-SPCL-FCTR-COUNT                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '********** PCSXP110 ABORT  ************'      
                 DISPLAY '* 8040-DELETE-SPCL-FCTR-APPL          *'      
                 DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
                 DISPLAY '* SA-DATE-TO         = ' SA-DATE-TO           
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP110  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04684* DELETES RECORDS FROM CSS_OFFCYCLE_READS                      *          
A04684****************************************************************          
A04684*                                                                         
A04684 8050-DELETE-OFFCYC-READ.                                         
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684          DELETE FROM CSS_OFFCYCLE_READS                          
A04684           WHERE DEVICE_NO      = :3B-DEVICE-NO                   
A04684             AND COMPANY_NO     = :3B-COMPANY-NO                  
A04684             AND REG_READ_DT    = IIF(TRY_CONVERT(DATE, 
                                                        :3B-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :3B-REG-READ-DT
              ) <> 0) OR (LEN(:3B-REG-READ-DT) <> 10), CIS.CHAR2DATE(
                                                        :3B-REG-READ-DT
              ), CONVERT(DATE, :3B-REG-READ-DT) )                 
A04684             AND REG_READ_TM    = CIS.CHAR2TIME(:3B-REG-READ-TM)          
A04684             AND CODE_UTIL_TYPE = :3B-CODE-UTIL-TYPE              
A04684     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_OFFCYCLE_READS                                  
MFA-TR*          WHERE DEVICE_NO      = :3B-DEVICE-NO                           
MFA-TR*            AND COMPANY_NO     = :3B-COMPANY-NO                          
MFA-TR*            AND REG_READ_DT    = :3B-REG-READ-DT                         
MFA-TR*            AND REG_READ_TM    = :3B-REG-READ-TM                         
MFA-TR*            AND CODE_UTIL_TYPE = :3B-CODE-UTIL-TYPE                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04684*                                                                         
A04684     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04684        ADD WS-1 TO WS-COMMIT-COUNT                               
A04684        ADD WS-1 TO WS-OFFCYCLE-COUNT                             
A04684        IF WS-COMMIT-TEST  = 0                                    
A04684           PERFORM 8900-COMMIT THRU 8900-EXIT                     
A04684        END-IF                                                    
A04684     ELSE                                                         
A04684        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A04684           NEXT SENTENCE                                          
A04684        ELSE                                                      
A04684           DISPLAY '********** PCSXP110 ABORT  ************'      
A04684           DISPLAY '* 8050-DELETE-OFFCYC-READ           *'        
A04684           DISPLAY '* SQLCODE     = ' WS-ACTIVE-RETURN-CODE       
A04684           DISPLAY '* TABLE       = CSS_OFFCYCLE_READS'           
A04684           DISPLAY '* REG_READ_DT = ' WS-OFF-CYCLE-DATE           
A04684           DISPLAY '* PROGRAM ABORTING...                 *'      
A04684           DISPLAY '********** PCSXP110  ABORT ************'      
A04684           PERFORM 9900-ABEND THRU 9900-EXIT                      
A04684        END-IF                                                    
A04684     END-IF.                                                      
A04684*                                                                         
A04684 8050-EXIT.                                                       
A04684     EXIT.                                                        
      *                                                                         
ACT165****************************************************************          
ACT165* DELETES RECORDS FROM CSS_CORR_MAIL_STAT                      *          
ACT165****************************************************************          
ACT165 8060-DELETE-CORR-MAIL-STAT.                                      
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165          DELETE FROM CSS_CORR_MAIL_STAT                          
ACT165           WHERE ACCOUNT_NO        = :MW-ACCOUNT-NO               
ACT165             AND BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID        
ACT165     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165*                                                                         
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT165        ADD WS-1 TO WS-COMMIT-COUNT                               
ACT165        ADD WS-1 TO WS-CORR-MAIL-STAT-COUNT                       
ACT165        IF WS-COMMIT-TEST  = 0                                    
ACT165           PERFORM 8900-COMMIT THRU 8900-EXIT                     
ACT165        END-IF                                                    
ACT165     ELSE                                                         
ACT165        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT165           NEXT SENTENCE                                          
ACT165        ELSE                                                      
ACT165           DISPLAY '********** PCSXP110 ABORT  ************'      
ACT165           DISPLAY '* 8060-DELETE-CORR-MAIL-STAT        *'        
ACT165           DISPLAY '* SQLCODE     = ' WS-ACTIVE-RETURN-CODE       
ACT165           DISPLAY '* TABLE       = CSS_CORR_MAIL_STAT'           
ACT165           DISPLAY '* ACCOUNT NO  = ' MW-ACCOUNT-NO               
ACT165           DISPLAY '* UNIQUE ID   = ' MW-BARCODE-UNIQUE-ID        
ACT165           DISPLAY '* PROGRAM ABORTING...                 *'      
ACT165           DISPLAY '********** PCSXP110  ABORT ************'      
ACT165           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT165        END-IF                                                    
ACT165     END-IF.                                                      
ACT165*                                                                         
ACT165 8060-EXIT.                                                       
ACT165     EXIT.                                                        
      *                                                                         
ACT165****************************************************************          
ACT165* DELETES RECORDS FROM CSS_BTU_FACTOR                          *          
ACT165****************************************************************          
ACT165 8070-DELETE-BTU-FACTOR.                                          
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165          DELETE FROM CSS_BTU_FACTOR                              
ACT165           WHERE  BTU_DT    < IIF(TRY_CONVERT(DATE, 
                                                    :WS-BTU-FACTOR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BTU-FACTOR-DATE
              ) <> 0) OR (LEN(:WS-BTU-FACTOR-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-BTU-FACTOR-DATE
              ), CONVERT(DATE, :WS-BTU-FACTOR-DATE) )                 
ACT165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_BTU_FACTOR                                      
MFA-TR*          WHERE  BTU_DT    < :WS-BTU-FACTOR-DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165*                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SQLERRD(3)  TO  WS-BTU-FACTOR-COUNT                  
ACT165     ELSE                                                         
ACT165        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT165           NEXT SENTENCE                                          
ACT165        ELSE                                                      
ACT165           DISPLAY '********** PCSXP110 ABORT  ************'      
ACT165           DISPLAY '* 8070-DELETE-BTU-FACTOR              *'      
ACT165           DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
ACT165           DISPLAY '* BTU-FACTOR-DATE    = ' WS-BTU-FACTOR-DATE   
ACT165           DISPLAY '* PROGRAM ABORTING...                 *'      
ACT165           DISPLAY '********** PCSXP110  ABORT ************'      
ACT165           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT165        END-IF                                                    
ACT165     END-IF.                                                      
ACT165*                                                                         
ACT165 8070-EXIT.                                                       
ACT165     EXIT.                                                        
      *                                                                         
ACT165****************************************************************          
ACT165* DELETES RECORDS FROM CSS_BTU_FACTOR                          *          
ACT165****************************************************************          
ACT165 8080-DELETE-BTU-INDUST-FACTOR.                                   
ACT165*                                                                         
ACT165     EXEC SQL                                                     
ACT165          DELETE FROM CSS_BTU_INDUST_FCT                          
ACT165           WHERE  BTU_DT    < IIF(TRY_CONVERT(DATE, 
                                             :WS-BTU-INDUST-FACTOR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BTU-INDUST-FACTOR-DATE
              ) <> 0) OR (LEN(:WS-BTU-INDUST-FACTOR-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-BTU-INDUST-FACTOR-DATE
              ), CONVERT(DATE, :WS-BTU-INDUST-FACTOR-DATE) )          
ACT165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_BTU_INDUST_FCT                                  
MFA-TR*          WHERE  BTU_DT    < :WS-BTU-INDUST-FACTOR-DATE                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT165*                                                                         
ACT165     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT165*                                                                         
ACT165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT165        MOVE SQLERRD(3)  TO  WS-BTU-INDUST-FCT-COUNT              
ACT165     ELSE                                                         
ACT165        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT165           NEXT SENTENCE                                          
ACT165        ELSE                                                      
ACT165           DISPLAY '********** PCSXP110 ABORT  ************'      
ACT165           DISPLAY '* 8080-DELETE-BTU-INDUST-FACTOR       *'      
ACT165           DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
ACT165           DISPLAY '* BTU-FACTOR-DATE    = '                      
ACT165                                       WS-BTU-INDUST-FACTOR-DATE  
ACT165           DISPLAY '* PROGRAM ABORTING...                 *'      
ACT165           DISPLAY '********** PCSXP110  ABORT ************'      
ACT165           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT165        END-IF                                                    
ACT165     END-IF.                                                      
ACT165*                                                                         
ACT165 8080-EXIT.                                                       
ACT165     EXIT.                                                        
      *                                                                         
ACT257****************************************************************          
ACT257* DELETES RECORDS FROM CSS_EXCP_BILL_DET                       *          
ACT257****************************************************************          
ACT257 8090-DELETE-EXCP-BILL-DET.                                       
ACT257*                                                                         
ACT257     EXEC SQL                                                     
ACT257          DELETE FROM CSS_EXCP_BILL_DET                           
ACT257           WHERE DATE_BILLED < IIF(TRY_CONVERT(DATE, 
                                                 :WS-EXCP-BILL-DET-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-EXCP-BILL-DET-DATE
              ) <> 0) OR (LEN(:WS-EXCP-BILL-DET-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-EXCP-BILL-DET-DATE
              ), CONVERT(DATE, :WS-EXCP-BILL-DET-DATE) )             
ACT257     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_EXCP_BILL_DET                                   
MFA-TR*          WHERE DATE_BILLED < :WS-EXCP-BILL-DET-DATE                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT257*                                                                         
ACT257     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT257*                                                                         
ACT257     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT257        MOVE SQLERRD(3)  TO  WS-EXCP-BILL-DET-COUNT               
ACT257     ELSE                                                         
ACT257        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT257           NEXT SENTENCE                                          
ACT257        ELSE                                                      
ACT257           DISPLAY '********** PCSXP110 ABORT  ************'      
ACT257           DISPLAY '* 8090-DELETE-EXCP-BILL-DET           *'      
ACT257           DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
ACT257           DISPLAY '* EXCP BILL DET DATE = '                      
ACT257                                       WS-EXCP-BILL-DET-DATE      
ACT257           DISPLAY '* PROGRAM ABORTING...                 *'      
ACT257           DISPLAY '********** PCSXP110  ABORT ************'      
ACT257           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT257        END-IF                                                    
ACT257     END-IF.                                                      
ACT257*                                                                         
ACT257 8090-EXIT.                                                       
ACT257     EXIT.                                                        
      *                                                                         
ACT154****************************************************************          
ACT154* DELETES RECORDS FROM CSS_TEMPERATURE                         *          
ACT154****************************************************************          
ACT154 8100-DELETE-TEMPERATURE.                                         
ACT154*                                                                         
ACT154     EXEC SQL                                                     
ACT154          DELETE FROM CSS_TEMPERATURE                             
ACT154           WHERE TEMP_DT     < IIF(TRY_CONVERT(DATE, 
                                                   :WS-TEMPERATURE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMPERATURE-DATE
              ) <> 0) OR (LEN(:WS-TEMPERATURE-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-TEMPERATURE-DATE
              ), CONVERT(DATE, :WS-TEMPERATURE-DATE) )               
ACT154     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_TEMPERATURE                                     
MFA-TR*          WHERE TEMP_DT     < :WS-TEMPERATURE-DATE                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT154*                                                                         
ACT154     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT154*                                                                         
ACT154     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT154        MOVE SQLERRD(3)  TO  WS-TEMPERATURE-COUNT                 
ACT154     ELSE                                                         
ACT154        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT154           NEXT SENTENCE                                          
ACT154        ELSE                                                      
ACT154           DISPLAY '********** PCSXP110 ABORT  ************'      
ACT154           DISPLAY '* 8100-DELETE-TEMPERATURE             *'      
ACT154           DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE           
ACT154           DISPLAY '* TEMPERATURE DATE   = '                      
ACT154                                       WS-TEMPERATURE-DATE        
ACT154           DISPLAY '* PROGRAM ABORTING...                 *'      
ACT154           DISPLAY '********** PCSXP110  ABORT ************'      
ACT154           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT154        END-IF                                                    
ACT154     END-IF.                                                      
ACT154*                                                                         
ACT154 8100-EXIT.                                                       
ACT154     EXIT.                                                        
ACT154*                                                                         
ACT154****************************************************************          
      *  ISSUES A COMMIT POINT                                       *          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = 0                                               
               DISPLAY '                         COMMIT #'              
                       WS-CHECKPOINT-NBR                                
           ELSE                                                         
ACT165           DISPLAY '********** PCSXP110 ABORT  ************'      
ACT165           DISPLAY '* 8900-COMMIT                         *'      
ACT165           DISPLAY '* SQLCODE = ' SQLCODE                         
ACT165           DISPLAY '* PROGRAM ABORTING...                 *'      
ACT165           DISPLAY '********** PCSXP110  ABORT ************'      
ACT165           PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
