       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSXP101.                                           
       DATE-WRITTEN. 19 OCT 2008                                        
       DATE-COMPILED.                                                   
       AUTHOR.   SIVAPRIYA.                                             
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRICITY  & GAS              *          
      **                                                             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                   DB2                          ********          
      ****************************************************************          
      **                                                             *          
      **              PROGRAM  MODIFICATION  LOG                     *          
      *   DATE       INITIALS    REASON                               *         
      * ----------  ------------ -------------------------------------*         
A37648* 10/10/2008  PRIYA        APPL37648                            *         
ACT066* 08/01/2012  BD09555      ADDING CSS_BILL_CONTRACT             *         
ACT066* A03967                                                        *         
A05136* 11/20/2015  DB41297      REMOVE CSS_INCENTIVE                 *         
ACT239*                                                               *         
      ****************************************************************          
      *                   PCSXP101   NARRATIVE                       *          
      *                                                              *          
      * THIS PROGRAM PURGES DATA FROM THE FOLLOWING TABLES USING THE *          
      * CSS_CIS_PURGE_TABLE.                                         *          
      * 1.  CSS_CBL_USAGE                                            *          
      * 2.  CSS_FIXED_FCTR                                           *          
      * 4.  CSS_ACCT_MKT_TIER                                        *          
      * 5.  CSS_BILL_ACCT_XFER                                       *          
      * 6.  CSS_IRRGLR_MTR_RD                                        *          
      * 7.  CSS_EBILL_INSERTS                                        *          
ACT066* 8.  CSS_BILL_CONTRACT                                        *          
      * FOR LAST RUN DATE THE ACCOUNT NO AND PURGE DATE ARE USED *              
      * TO DETERMINE THE DATE TO BE PURGED.                          *          
      * THE CSS_JOB_PARM TABLE HAS AN ENTRY FOR EACH TABLE AND IN    *          
      * ORDER TO BE PROCESSED, THE STATUS ON THE JOB PARM TABLE      *          
      * MUST BE = 'A' (ACTIVE). TO STOP PURGING FROM A PARTICULAR    *          
      * TABLE, THE JOB PARM STATUS SHOULD BE SET TO 'I'              *          
      *                                                                         
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START- NO        *          
      * RESTART IS NEEDED.                                           *          
      ****************************************************************          
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9900     TERMINATION MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP101'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-COMMIT-COUNT             PIC 9(4)  VALUE ZEROS.       
           05  WS-1                        PIC 9     VALUE 1.           
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
           05  WS-CBL-CNT                  PIC 9(9)  VALUE ZEROS.       
           05  WS-FIXFT-CNT                PIC 9(9)  VALUE ZEROS.       
           05  WS-INCT-CNT                 PIC 9(9)  VALUE ZEROS.       
   *****   05  WS-ACCT-MCNT                PIC 9(9)  VALUE ZEROS.               
           05  WS-BIAT-XCNT                PIC 9(9)  VALUE ZEROS.       
           05  WS-IRRGLR-CNT               PIC 9(9)  VALUE ZEROS.       
           05  WS-EBILL-CNT                PIC 9(9)  VALUE ZEROS.       
ACT066     05  WS-CONTRACT-CNT             PIC 9(9)  VALUE ZEROS.       
           05  WS-NBR-COMMIT               PIC 9(9)  VALUE ZEROS.       
           05  WS-CBLUSAGE                 PIC X(01) VALUE 'N'.         
               88 CBLUSAGE                           VALUE 'Y'.         
           05  WS-FIXEDFCTR                PIC X(01) VALUE 'N'.         
               88 FIXEDFCTR                          VALUE 'Y'.         
           05  WS-ACCTTIER                 PIC X(01) VALUE 'N'.         
               88 ACCTTIER                           VALUE 'Y'.         
           05  WS-ACCTXFER                 PIC X(01) VALUE 'N'.         
               88 ACCTXFER                           VALUE 'Y'.         
           05  WS-IRRGLRRD                 PIC X(01) VALUE 'N'.         
               88 IRRGLRRD                           VALUE 'Y'.         
           05  WS-EBILLINSERT              PIC X(01) VALUE 'N'.         
               88 EBILLINSERT                        VALUE 'Y'.         
ACT066     05  WS-BILLCONTRACT             PIC X(01) VALUE 'N'.         
ACT066         88 BILLCONTRACT                       VALUE 'Y'.         
           05  WS-LAST-RUN-TIMESTAMP.                                   
               10 WS-LAST-TS-TXT           PIC X(20) VALUE              
                                           'LAST RUN TIME STAMP='.      
               10 WS-LAST-RUN-TS           PIC X(26) VALUE SPACES.      
           05  WS-PGRMNAME                 PIC X(8)  VALUE 'PCSXP101'.  
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **      APPLICATION  TABLE DCLGENS                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_CBL_USAGE - CD.                                                    
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCBLUSG                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_FIXED_FCTR - FF.                                                   
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_BILL_ACCT_XREF - AF                                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBBLACXF                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_IRRGLR_MTR_RD     IM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBIRMTRD                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *   CSS_EBILL_INSERTS     IE                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEBLINS                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  CSS_CIS_PURGE                                               *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPURGE                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_JOB_PARM - G6                                                       
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'               *          
      ***************************************************************           
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      ****************************************************************          
      *  ABEND SWITCH COPYBOOK                                       *          
      ****************************************************************          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      * DECLARE CURSOR FOR LAST RUN DATE                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE PURGE_CSR_B CURSOR WITH HOLD FOR                   
              SELECT PU.ACCOUNT_NO                                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), PU.PURGE_TS
           , 121), ' ', '-'), ':', '.') PURGE_TS                               
                    ,PU.PURGE_DT                                        
                    ,PU.BILL_NO                                         
                FROM CSS_CIS_PURGE PU WITH(READUNCOMMITTED)                     
               WHERE PU.LAST_UPDATE_TS      >= CIS.CHAR2TIMESTAMP(
                                                        :WS-LAST-RUN-TS
              )          
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE PURGE_CSR_B CURSOR WITH HOLD FOR                           
MFA-TR*       SELECT PU.ACCOUNT_NO                                              
MFA-TR*             ,PU.PURGE_TS                                                
MFA-TR*             ,PU.PURGE_DT                                                
MFA-TR*             ,PU.BILL_NO                                                 
MFA-TR*         FROM CSS_CIS_PURGE PU                                           
MFA-TR*        WHERE PU.LAST_UPDATE_TS      >= :WS-LAST-RUN-TS                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      * 0000-MAIN-PARA.                                              *          
      ****************************************************************          
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 0100-INITIALIZATION  THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-PURGE-CURSOR     THRU 1000-EXIT.        
           PERFORM 2300-PRINT-TOTALS             THRU 2300-EXIT.        
           MOVE WS-PGRMNAME             TO G6-PROGRAM-NAME.             
           MOVE 'DATE'                  TO G6-CMND-CODE.                
           MOVE WS-CURRENT-TIMESTAMP    TO WS-LAST-RUN-TS.              
           MOVE WS-LAST-RUN-TIMESTAMP   TO G6-PARM-DATA.                
           PERFORM 8800-UPDATE-LAST-RUN-DATE     THRU 8800-EXIT.        
           DISPLAY '*********PROCESS COMPLETED SUCCESSFULLY*********'.  
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02390000
      *                                                               * 02400000
      *   0100-INITIALIZATION                                         * 02410000
      *        COMMON INITIALIZATION ROUTINE                          * 02420000
      *                                                               * 02430000
      ***************************************************************** 02440000
      *                                                                 02450000
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           PERFORM 7600P-START-FCSJC01 THRU 7600P-EXIT.                 
           PERFORM 0125-READ-FCSJC01   THRU 0125-EXIT.                  
           PERFORM 7611P-CLOSE              THRU 7611P-EXIT.            
           PERFORM 7950-GET-CURRENT-TIMESTAMP THRU 7950-EXIT.           
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * READ MONTHS & COMMIT PARM FROM CSS_JOB_PARM                  *          
      ****************************************************************          
       0125-READ-FCSJC01.                                               
      *                                                                         
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD=')               
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD='               
              AND INPUT-ACTIVE                                          
                 MOVE WS-INPUT-DATA-BREAKDOWN(10:4) TO WS-CHKP-UPD-LIMIT
           ELSE                                                         
              MOVE WS-DEFAULT-CHKP-UPD-LIMIT  TO WS-CHKP-UPD-LIMIT      
              DISPLAY '**JOB PARM NOT ACTIVE FOR CHKP-UPD**'            
              DISPLAY '**DEFAULT OF              **  ' WS-CHKP-UPD-LIMIT
                      ' WILL BE USED**'                                 
              DISPLAY '**PROCESS CONTINUING**'                          
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP=')   
             OR END-OF-SYSIPT.                                          
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP='    
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA(21:26) TO WS-LAST-RUN-TS             
                 DISPLAY 'LAST RUN TIME STAMP: '  WS-LAST-RUN-TS        
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR LAST RUN TIME STAMP'  
                 DISPLAY 'NO RECORDS ARE PROCESSED'                     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
               END-IF                                                   
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR LAST RUN TIME STAMP'    
              DISPLAY 'NO RECS ARE PROCESSED FOR LAST RUN TIME STAMP'   
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
                                                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CBL_USAGE     ')     
             OR END-OF-SYSIPT.                                          
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_CBL_USAGE     '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-CBLUSAGE                   
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_CBL_USAGE   '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_CBL_USAGE '  
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_CBL_USAGE'          
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_CBL_USAGE'         
              DISPLAY '       '                                         
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
                                                                        
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:14) = 'CSS_FIXED_FCTR')         
             OR END-OF-SYSIPT.                                          
           IF WS-INPUT-DATA-BREAKDOWN(1:14) = 'CSS_FIXED_FCTR'          
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-FIXEDFCTR                  
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_FIXED_FCTR  '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_FIXED_FCTR'  
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_FIXED_FCTR'         
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_FIXED_FCTR'        
              DISPLAY '       '                                         
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BILL_ACCT_XFER')     
             OR END-OF-SYSIPT.                                          
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BILL_ACCT_XFER'      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-ACCTXFER                   
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BILL_ACCT_XFER'   
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR '                
                        ' CSS_BILL_ACCT_XFER  '                         
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_BILL_ACCT_XFER'     
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_BILL_ACCT_XFER'    
              DISPLAY '       '                                         
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_IRRGLR_MTR_RD ')     
             OR END-OF-SYSIPT.                                          
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_IRRGLR_MTR_RD '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-IRRGLRRD                   
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_IRRGLR_MTR_RD '   
                 DISPLAY 'NO RECORDS ARE PROCESSED IN CSS_IRRGLR_MTR_RD'
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_IRRGLR_MTR_RD'      
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_IRRGLR_MTR_RD'     
              DISPLAY '       '                                         
           END-IF.                                                      
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_EBILL_INSERT  ')     
             OR END-OF-SYSIPT.                                          
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_EBILL_INSERT  '      
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-EBILLINSERT                
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_EBILL_INSERT'     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_EBILL_INSERT'
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_EBILL_INSERT'       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_EBILL_INSERT'      
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
ACT066     INITIALIZE WS-SYSIPT.                                        
ACT066     MOVE  +1                    TO   WS-I.                       
ACT066     PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
ACT066       (WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BILL_CONTRACT ')     
ACT066       OR END-OF-SYSIPT.                                          
ACT066                                                                  
ACT066     IF WS-INPUT-DATA-BREAKDOWN(1:18) = 'CSS_BILL_CONTRACT '      
ACT066        IF INPUT-ACTIVE                                           
ACT066          MOVE 'Y'              TO WS-BILLCONTRACT                
ACT066        ELSE                                                      
ACT066          DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BILL_CONTRACT'     
ACT066          DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_BILL_CONTRACT'
ACT066          DISPLAY '            '                                  
ACT066        END-IF                                                    
ACT066     ELSE                                                         
ACT066        DISPLAY '       '                                         
ACT066        DISPLAY 'JOB PARM NOT PRESENT FOR CSS_BILL_CONTRACT'      
ACT066        DISPLAY 'NO RECS ARE PROCESSED FOR CSS_BILL_CONTRACT'     
ACT066        DISPLAY '       '                                         
ACT066     END-IF.                                                      
ACT066*                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************** 02390000
      * 1000-PROCESS-PURGE-CURSOR.                                    * 02410000
      ***************************************************************** 02440000
      *                                                                         
       1000-PROCESS-PURGE-CURSOR.                                       
      *                                                                         
           PERFORM 7000-OPEN-PURGE-CURSOR-B      THRU 7000-EXIT.        
           PERFORM 7100-FETCH-PURGE-CURSOR-B     THRU 7100-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1000-PROCESS-PURGE-CURSOR PARAGRAPH'   
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS SELECTED      *'                    
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2000-PROCESS-DELETE-PARA-B THRU 2000-EXIT         
              ADD WS-1 TO WS-COMMIT-COUNT                               
              IF WS-COMMIT-COUNT  >= WS-CHKP-UPD-LIMIT                  
                 PERFORM 8900-COMMIT             THRU 8900-EXIT         
                 INITIALIZE WS-COMMIT-COUNT                             
              END-IF                                                    
              PERFORM 7100-FETCH-PURGE-CURSOR-B  THRU 7100-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7200-CLOSE-PURGE-CURSOR-B     THRU 7200-EXIT.        
      *                                                                         
           PERFORM 8900-COMMIT                   THRU 8900-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************** 02390000
      *   2000-PROCESS-DELETE-PARA-B.                                 * 02410000
      ***************************************************************** 02440000
      *                                                                         
       2000-PROCESS-DELETE-PARA-B.                                      
      *                                                                         
           IF CBLUSAGE                                                  
               PERFORM 8000-CBL-USG-TYPE-B           THRU 8000-EXIT     
           END-IF.                                                      
           IF FIXEDFCTR                                                 
               PERFORM 8100-FIXED-FCTR-TYPE-B        THRU 8100-EXIT     
           END-IF.                                                      
           IF ACCTXFER                                                  
               PERFORM 8400-BILL-ACXF-TYPE-B         THRU 8400-EXIT     
           END-IF.                                                      
           IF IRRGLRRD                                                  
               PERFORM 8500-IRRGLR-MTR-RD-TYPE-B     THRU 8500-EXIT     
           END-IF.                                                      
           IF EBILLINSERT                                               
               PERFORM 8600-EBILL-INSERT-TYPE-B      THRU 8600-EXIT     
           END-IF.                                                      
ACT066     IF BILLCONTRACT                                              
ACT066         PERFORM 8700-BILL-CONTRACT-TYPE-B     THRU 8700-EXIT     
ACT066     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 2300-PRINT-TOTALS.                                            * 02410000
      ***************************************************************** 02440000
      *                                                                         
       2300-PRINT-TOTALS.                                               
           IF CBLUSAGE                                                  
              DISPLAY 'TOT# CBL ACCOUNTS DLT-PURGE   :' WS-CBL-CNT      
           END-IF.                                                      
           IF FIXEDFCTR                                                 
             DISPLAY 'TOT# FIX FCTR ACCTS DLT-PURGE  :' WS-FIXFT-CNT    
           END-IF.                                                      
           IF ACCTXFER                                                  
             DISPLAY 'TOT# BILL ACT ACCTS DLT-PURGE  :' WS-BIAT-XCNT    
           END-IF.                                                      
           IF IRRGLRRD                                                  
             DISPLAY 'TOT# IRR ACCTS DLT-PURGE       :' WS-IRRGLR-CNT   
           END-IF.                                                      
           IF EBILLINSERT                                               
             DISPLAY 'TOT# EBILL ACCTS DLT-PURGE     :' WS-EBILL-CNT    
           END-IF.                                                      
ACT066     IF BILLCONTRACT                                              
ACT066       DISPLAY 'TOT# CONTRACT ACCTS TLD-PURGE  :' WS-CONTRACT-CNT 
ACT066     END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *                                                                 05220000
      ****************************************************************          
      * OPENS PURGE CURSOR PURGE_CSR_B                               *          
      ****************************************************************          
      *                                                                         
       7000-OPEN-PURGE-CURSOR-B.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN PURGE_CSR_B                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP101 ABORT  ************'         
              DISPLAY '*      7000-OPEN-PURGE-CURSOR-B       *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP101  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7100-FETCH-PURGE-CURSOR-B                                    *          
      ****************************************************************          
      *                                                                         
       7100-FETCH-PURGE-CURSOR-B.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH PURGE_CSR_B                                        
                INTO :PU-ACCOUNT-NO                                     
                    ,:PU-PURGE-TS                                       
                    ,:PU-PURGE-DT                                       
                    ,:PU-BILL-NO                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP101 ABORT  ************'         
              DISPLAY '*     7100-FETCH-PURGE-CURSOR-B       *'         
              DISPLAY '* PU-ACCOUNT-NO = ' PU-ACCOUNT-NO                
              DISPLAY '* PU-PURGE-TS   = ' PU-PURGE-TS                  
              DISPLAY '* PU-PURGE-DT   = ' PU-PURGE-DT                  
              DISPLAY '* PU-BILL-NO    = ' PU-BILL-NO                   
              DISPLAY '* SQLCODE IS    = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP101  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7200-CLOSE-PURGE-CURSOR-B                                    *          
      ****************************************************************          
      *                                                                         
       7200-CLOSE-PURGE-CURSOR-B.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE PURGE_CSR_B                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP101 ABORT  ************'         
              DISPLAY '*     7200-CLOSE-PURGE-CURSOR-B       *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP101  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *----------------------------------------------------------------*        
      * SELECT CSS_JOB_PARM TABLE                                      *        
      * 7600P-,7610P-, 7611P- PARAGRAPHS                               *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDPURGE                                                 
           END-EXEC                                                             
      *                                                                         
      ****************************************************************          
      * 7950-GET-CURRENT-TIMESTAMP                                              
      ****************************************************************          
      *                                                                         
       7950-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
                 DISPLAY '********** PCSXP101 ABORT  ************'      
                 DISPLAY '* 7950-GET-CURRENT-TIMESTAMP          *'      
                 DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* PROGRAM ABORTING...                 *'      
                 DISPLAY '********** PCSXP101  ABORT ************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * DELETES RECORDS FROM CSS_CBL_USAGE                           *          
      ****************************************************************          
      *                                                                         
       8000-CBL-USG-TYPE-B.                                             
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_CBL_USAGE                               
                 WHERE ACCOUNT_NO         = :PU-ACCOUNT-NO              
                   AND BASELINE_EFFCT_DT <= IIF(TRY_CONVERT(DATE, 
                                                           :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CBL_USAGE                                       
MFA-TR*          WHERE ACCOUNT_NO         = :PU-ACCOUNT-NO                      
MFA-TR*            AND BASELINE_EFFCT_DT <= :PU-PURGE-DT                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-CBL-CNT                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP101 ABORT  ************'         
              DISPLAY '*        8000-CBL-USG-TYPE-B          *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT #  ', PU-ACCOUNT-NO                    
              DISPLAY '* EFFECT DT  ', PU-PURGE-DT                      
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP101  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_FIXED_FCTR                          *          
      ****************************************************************          
      *                                                                         
       8100-FIXED-FCTR-TYPE-B.                                          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_FIXED_FCTR                              
                 WHERE ACCOUNT_NO   = :PU-ACCOUNT-NO                    
                   AND EFF_DATE_TO <= IIF(TRY_CONVERT(DATE, :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) )                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_FIXED_FCTR                                      
MFA-TR*          WHERE ACCOUNT_NO   = :PU-ACCOUNT-NO                            
MFA-TR*            AND EFF_DATE_TO <= :PU-PURGE-DT                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-FIXFT-CNT                               
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP101 ABORT  ************'         
              DISPLAY '*      8100-FIXED-FCTR-TYPE-B         *'         
              DISPLAY '* ACCOUNT #      : ' PU-ACCOUNT-NO               
              DISPLAY '* EFFECTIVE DATE : ' PU-PURGE-DT                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP101  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * DELETES RECORDS FROM CSS_BILL_ACCT_XREF.                     *          
      ****************************************************************          
      *                                                                         
       8400-BILL-ACXF-TYPE-B.                                           
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_BILL_ACCT_XFER                          
                 WHERE ACCOUNT_NO = :PU-ACCOUNT-NO                      
                 AND   BILL_NO   <= :PU-BILL-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-BIAT-XCNT                               
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP101 ABORT  ************'         
              DISPLAY '*      8400-BILL-ACXF-TYPE-B          *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* ACCOUNT #: ', PU-ACCOUNT-NO                    
              DISPLAY '* BILL NO ',    PU-BILL-NO                       
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP101  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_IRRGLR_MTR_RD.                      *          
      ****************************************************************          
      *                                                                         
       8500-IRRGLR-MTR-RD-TYPE-B.                                       
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_IRRGLR_MTR_RD                           
                 WHERE METER_READ_DT  <= IIF(TRY_CONVERT(DATE, 
                                                           :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) )                   
                   AND ACCOUNT_NO      = :PU-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_IRRGLR_MTR_RD                                   
MFA-TR*          WHERE METER_READ_DT  <= :PU-PURGE-DT                           
MFA-TR*            AND ACCOUNT_NO      = :PU-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-IRRGLR-CNT                              
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP101 ABORT  ************'         
              DISPLAY '*     8500-IRRGLR-MTR-RD-TYPE-B       *'         
              DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '* IM-METER-READ-DT = ' PU-PURGE-DT               
              DISPLAY '* IM-ACCOUNT-NO    = ' PU-ACCOUNT-NO             
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP101  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * DELETES RECORDS FROM CSS_EBILL_INSERTS                       *          
      ****************************************************************          
      *                                                                         
       8600-EBILL-INSERT-TYPE-B.                                        
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_EBILL_INSERTS                           
                 WHERE DATE_BILLED <= IIF(TRY_CONVERT(DATE, :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) )                      
                   AND ACCOUNT_NO   = :PU-ACCOUNT-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_EBILL_INSERTS                                   
MFA-TR*          WHERE DATE_BILLED <= :PU-PURGE-DT                              
MFA-TR*            AND ACCOUNT_NO   = :PU-ACCOUNT-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD WS-1 TO WS-EBILL-CNT                               
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSXP101 ABORT  ************'         
              DISPLAY '*     8600-EBILL-INSERT-TYPE-B        *'         
              DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '* WS-PURGE-DATE      = ' PU-PURGE-DT             
              DISPLAY '* IE-ACCOUNT-NO      = ' PU-ACCOUNT-NO           
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP101  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT066****************************************************************          
ACT066* DELETES RECORDS FROM CSS_BILL_CONTRACT                       *          
ACT066****************************************************************          
ACT066*                                                                         
ACT066 8700-BILL-CONTRACT-TYPE-B.                                       
ACT066*                                                                         
ACT066     EXEC SQL                                                     
ACT066          DELETE FROM CSS_BILL_CONTRACT                           
ACT066           WHERE CNTRCT_END_DT <=  IIF(TRY_CONVERT(DATE, 
                                                           :PU-PURGE-DT
              ) IS NULL OR (PATINDEX('%.%', :PU-PURGE-DT
              ) <> 0) OR (LEN(:PU-PURGE-DT) <> 10), CIS.CHAR2DATE(
                                                           :PU-PURGE-DT
              ), CONVERT(DATE, :PU-PURGE-DT) )                   
ACT066             AND ACCOUNT_NO     =  :PU-ACCOUNT-NO                 
ACT066     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_BILL_CONTRACT                                   
MFA-TR*          WHERE CNTRCT_END_DT <=  :PU-PURGE-DT                           
MFA-TR*            AND ACCOUNT_NO     =  :PU-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT066*                                                                         
ACT066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT066*                                                                         
ACT066     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT066        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
ACT066           ADD WS-1 TO WS-CONTRACT-CNT                            
ACT066        END-IF                                                    
ACT066     ELSE                                                         
ACT066        DISPLAY '********** PCSXP101 ABORT  ************'         
ACT066        DISPLAY '*     8700-BILL-CONTRACT-TYPE-B       *'         
ACT066        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
ACT066        DISPLAY '* WS-PURGE-DATE      = ' PU-PURGE-DT             
ACT066        DISPLAY '* ACCOUNT-NO         = ' PU-ACCOUNT-NO           
ACT066        DISPLAY '* PROGRAM ABORTING...                 *'         
ACT066        DISPLAY '********** PCSXP101  ABORT ************'         
ACT066        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT066     END-IF.                                                      
ACT066*                                                                         
ACT066 8700-EXIT.                                                       
ACT066     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** UPDATE THE JOB PARM LAST RUN DATE WITH CURRENT RUN DATE    **          
      ****************************************************************          
      *                                                                         
       8800-UPDATE-LAST-RUN-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
               SET    PARM_DATA    = :G6-PARM-DATA                      
               WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                   
               AND    CMND_CODE    = :G6-CMND-CODE                      
               AND    COMPANY_NO   = '01'                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '*        PROCESSING ERROR               *'       
              DISPLAY '* PARAGRAPH 8800-UPDATE-LAST-RUN-DATE   *'       
              DISPLAY '*   SQLCODE = ' WS-ACTIVE-RETURN-CODE            
              DISPLAY '*   G6-PARM-DATA = ' G6-PARM-DATA                
              DISPLAY '*   G6-PROGRAM-NAME = ' G6-PROGRAM-NAME          
              DISPLAY '*   G6-CMND-CODE = ' G6-CMND-CODE                
              DISPLAY '*         PROCESSING TERMINATED         *'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                       *          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           COMPUTE WS-NBR-COMMIT = WS-NBR-COMMIT + 1.                   
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
