       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSXP100.                                            
       DATE-WRITTEN. OCT 2008.                                          
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      *                                                               *         
      * THIS PROGRAM PURGES DATA FROM CSS_BILLING_HDR USING THE       *         
      * CSS_CIS_PURGE TABLE.                                          *         
      * FOR  LAST-RUN-DATE , THE ACCOUNT NO AND BILL NO ARE           *         
      * USED AS THE PURGE CRITERIA.                                   *         
      *                                                               *         
      * PURGE CRITERIA CAN BE FOUND IN THE CSS_JOB_PARM TABLE        *          
      * FOR EACH TABLE. TO SAFEGUARD AGAINST JOB PARM ERRORS AND     *          
      * ACCIDENTALY DELETING MORE DATA THAN INTENDED.                *          
      *                                                              *          
      * 1.  CSS_BILLING_HDR                                          *          
      *                                                              *          
      * TO NOT PURGE DATA FOR A PARTICULAR TABLE, SET THE JOB PARM   *          
      * STATUS FOR THE PARTICULAR TABLE TO 'I' (INACTIVE)            *          
      *                                                              *          
      * IF PROGRAM ABENDS, IT CAN BE RERUN FROM THE START -          *          
      * RESTART IS NOT NEEDED.                                       *          
      *                                                              *          
      * COMMITS ARE TAKEN                                            *          
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *   DATE       INITIALS    REASON                               *         
      * ----------  ------------ -------------------------------------*         
A37648* 10/24/2008  PRIYA        APPL37648- ACT 26, 45,55             *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
             ---- BASIC SEQUENCE STRUCTURE ----                         
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP100'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP100'.   
                                                                        
       01  WS-VARIABLES.                                                
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 4.           
           05  WS-CHKP-LUW-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04) VALUE ZERO.        
           05  WS-COMMIT-COUNT             PIC 9(09) VALUE ZEROS.       
           05  WS-1                        PIC 9(1)  VALUE 1.           
           05  WS-I                        PIC S9(04) COMP VALUE 0.     
                                                                        
       01  WS-COUNTERS.                                                 
           05 WS-BILL-ACCT-CNT            PIC S9(9) COMP VALUE 0.       
           05 WS-COMMIT-CNT               PIC S9(9) COMP VALUE 0.       
           05 WS-COMMIT-NO                PIC S9(9) COMP VALUE 0.       
           05 WS-CURRENT-RUN-TS           PIC X(26) VALUE SPACES.       
           05 WS-DEFAULT-COMMIT-CNT       PIC S9(9) COMP VALUE 500.     
           05 WS-BILLING-HDR              PIC X(01) VALUE 'N'.          
              88 BILLING-HDR                        VALUE 'Y'.          
                                                                        
       01 WS-PARM-DATA.                                                 
          05 FILLER                  PIC X(20) VALUE                    
                                               'LAST RUN TIME STAMP='.  
          05 WS-PGM-LAST-RUN-TS      PIC X(26) VALUE SPACES.            
          05 FILLER                  PIC X(36) VALUE SPACES.            
                                                                        
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      * CSS_JOB_PARM - G6                                                       
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_BILLING_HDR - BI                                                    
           EXEC SQL                                                             
             INCLUDE TBBLLHDR                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_CIS_PURGE - PU                                                      
           EXEC SQL                                                             
             INCLUDE TBPURGE                                                    
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
      * WORKING STORAGE FOR PROCESSING CSS_JOB_PARM                             
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
                                                                        
      * DECLARE PURGE TABLE CURSOR FOR LAST-RUN-DATE                            
           EXEC SQL                                                     
            DECLARE PURGE_CSR CURSOR WITH HOLD FOR                      
             SELECT PU.ACCOUNT_NO                                       
                   ,PU.BILL_NO                                          
               FROM CSS_CIS_PURGE  PU WITH(READUNCOMMITTED)                     
              WHERE PU.LAST_UPDATE_TS  >= CIS.CHAR2TIMESTAMP(
                                                     :PU-LAST-UPDATE-TS
              )            
                FOR READ ONLY                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE PURGE_CSR CURSOR WITH HOLD FOR                              
MFA-TR*      SELECT PU.ACCOUNT_NO                                               
MFA-TR*            ,PU.BILL_NO                                                  
MFA-TR*        FROM CSS_CIS_PURGE  PU                                           
MFA-TR*       WHERE PU.LAST_UPDATE_TS  >= :PU-LAST-UPDATE-TS                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC                                                             
                                                                        
       PROCEDURE DIVISION.                                              
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000'                          TO WS-ACTIVE-PARAGRAPH  
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE    THRU 0100-EXIT          
                                                                        
           IF BILLING-HDR                                               
              PERFORM 1000-PROCESS-ACCOUNTS     THRU 1000-EXIT          
              PERFORM 2000-PRINT-TOTALS         THRU 2000-EXIT          
              MOVE WS-CURRENT-RUN-TS            TO WS-PGM-LAST-RUN-TS   
              MOVE WS-PARM-DATA                 TO G6-PARM-DATA         
      **-- FOR UPDATING LAST-RUN-DATE                                           
              PERFORM 8100-UPDATE-LAST-RUN-DATE THRU 8100-EXIT          
              DISPLAY 'PCSXP100 COMPLETED SUCCESSFULLY.'                
           END-IF.                                                      
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT COMMIT COUNT FROM CSS_JOB_PARM TABLE                    *        
      *----------------------------------------------------------------*        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                        TO WS-ACTIVE-PARAGRAPH    
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME                  TO WS-PROGRAM.             
           PERFORM 7600P-START-FCSJC01       THRU 7600P-EXIT.           
           PERFORM 0125-READ-JOB-PARM-VALUES THRU 0125-EXIT.            
           PERFORM 7611P-CLOSE               THRU 7611P-EXIT.           
      *                                                                         
           PERFORM 7410-GET-TIME-STAMP      THRU 7410-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  0125-READ-JOB-PARM-VALUES                                   *         
      *****************************************************************         
       0125-READ-JOB-PARM-VALUES.                                       
      *                                                                         
           MOVE  +1                              TO   WS-I.             
           PERFORM 7610P-READ-FCSJC01            THRU 7610P-EXIT UNTIL  
            (WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD=')               
            OR END-OF-SYSIPT.                                           
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN (1:9) = 'CHKP-UPD=' AND           
              INPUT-ACTIVE                                              
              MOVE WS-INPUT-DATA-BREAKDOWN(10:4) TO WS-CHKP-UPD-LIMIT   
           ELSE                                                         
              MOVE WS-DEFAULT-CHKP-UPD-LIMIT  TO WS-CHKP-UPD-LIMIT      
              DISPLAY '**JOB PARM NOT ACTIVE FOR CHKP-UPD**'            
              DISPLAY '**DEFAULT OF ' WS-CHKP-UPD-LIMIT                 
                      ' WILL BE USED**'                                 
              DISPLAY '**PROCESS CONTINUING**'                          
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
             (WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP=')   
             OR END-OF-SYSIPT                                           
      *                                                                         
           IF WS-INPUT-DATA-BREAKDOWN(1:20) = 'LAST RUN TIME STAMP='    
              IF INPUT-ACTIVE                                           
                 MOVE G6-PARM-DATA(21:26)    TO WS-PGM-LAST-RUN-TS      
                 DISPLAY 'LAST RUN TS   : '    WS-PGM-LAST-RUN-TS       
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR LAST RUN TIME STAMP'  
                 DISPLAY 'NO RECORDS ARE PROCESSED'                     
                 PERFORM 9900-ABEND          THRU 9900-EXIT             
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR LAST RUN TIME STAMP'    
              DISPLAY 'NO RECS ARE PROCESSED FOR LAST RUN TIME STAMP'   
              PERFORM 9900-ABEND          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-SYSIPT.                                        
           MOVE  +1                    TO   WS-I.                       
           PERFORM 7610P-READ-FCSJC01  THRU 7610P-EXIT UNTIL            
              (WS-INPUT-DATA-BREAKDOWN(1:15) = 'CSS_BILLING_HDR')       
            OR END-OF-SYSIPT                                            
                                                                        
           IF WS-INPUT-DATA-BREAKDOWN(1:15) = 'CSS_BILLING_HDR'         
              IF INPUT-ACTIVE                                           
                 MOVE 'Y'              TO WS-BILLING-HDR                
              ELSE                                                      
                 DISPLAY 'JOB PARM NOT ACTIVE FOR CSS_BILLING_HDR '     
                 DISPLAY 'NO RECORDS ARE PROCESSED FOR CSS_BILLING_HDR '
                 DISPLAY '            '                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '       '                                         
              DISPLAY 'JOB PARM NOT PRESENT FOR CSS_BILLING_HDR '       
              DISPLAY 'NO RECS ARE PROCESSED FOR CSS_BILLING_HDR '      
              DISPLAY '       '                                         
           END-IF.                                                      
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *----------------------------------------------------------------*        
      * SELECT ACTIVE ACCOUNTS AND GET BILLING DETAILS                 *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           INITIALIZE WS-COMMIT-CNT                                     
                                                                        
           MOVE    WS-PGM-LAST-RUN-TS        TO  PU-LAST-UPDATE-TS.     
                                                                        
           PERFORM 7100-OPEN-PURGE-CSR       THRU 7100-EXIT.            
           PERFORM 7200-FETCH-PURGE-CSR      THRU 7200-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '      '                                          
              DISPLAY 'BEGINNING 1000-PROCESS-ACCOUNTS PARAGRAPH'       
              DISPLAY '      '                                          
           ELSE                                                         
              DISPLAY '      '                                          
              DISPLAY '****************************'                    
              DISPLAY '* NO RECORDS TO PROCESS IN *'                    
              DISPLAY '* CSS_CIS_PURGE TABLE       *'                   
              DISPLAY '****************************'                    
              DISPLAY '      '                                          
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE PU-ACCOUNT-NO               TO BI-ACCOUNT-NO         
              MOVE PU-BILL-NO                  TO BI-BILL-NO            
                                                                        
              PERFORM 8000-PROCESS-DELETION  THRU 8000-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-BILL-ACCT-CNT                              
                 ADD WS-1 TO WS-COMMIT-CNT                              
                 IF WS-COMMIT-CNT >= WS-CHKP-UPD-LIMIT                  
                    PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT            
                    DISPLAY 'COMMIT NO        : ' WS-COMMIT-NO          
                    DISPLAY 'ACCOUNT NO       : ' BI-ACCOUNT-NO         
                    INITIALIZE WS-COMMIT-CNT                            
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7200-FETCH-PURGE-CSR   THRU 7200-EXIT             
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7300-CLOSE-PURGE-CSR      THRU 7300-EXIT.            
                                                                        
           PERFORM 8999-ISSUE-COMMIT         THRU 8999-EXIT.            
                                                                        
           DISPLAY '      '.                                            
           DISPLAY '** NUMBER OF COMMITS FOR'.                          
           DISPLAY '** CSS_BILLING_HDR  TABLE = ', WS-COMMIT-NO.        
           DISPLAY '      '.                                            
           INITIALIZE WS-COMMIT-NO.                                     
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT ARCHIVE ACCOUNTS AND GET BILLING DETAILS FOR DELETING   *        
      *----------------------------------------------------------------*        
      * 2000-PRINT-TOTALS                                              *        
      *----------------------------------------------------------------*        
       2000-PRINT-TOTALS.                                               
      *                                                                         
           DISPLAY 'RECORDS DELETED IN  CSS_BILLING_HDR FOR = '         
                   WS-BILL-ACCT-CNT.                                    
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * OPEN PURGE TABLE CURSOR                                        *        
      *----------------------------------------------------------------*        
       7100-OPEN-PURGE-CSR.                                             
      *----------------------*                                                  
           MOVE '7100'                         TO WS-ACTIVE-PARAGRAPH   
                                                                        
           EXEC SQL                                                     
               OPEN PURGE_CSR                                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**     PCSXP100  PROCESSING ERROR           **'  
              DISPLAY '**    ERROR OPENING PURGE_CSR CURSOR        **'  
              DISPLAY '**********************************************'  
              DISPLAY '** CURRENT PARAGRAPH  = ' WS-ACTIVE-PARAGRAPH    
              DISPLAY '** SQL STATUS         = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**       PROCESSING TERMINATED              **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH ACTIVE ACCOUNTS WHICH WERE CREATED 25 MONTHS BEFORE      *        
      *----------------------------------------------------------------*        
       7200-FETCH-PURGE-CSR.                                            
      *----------------------*                                                  
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH PURGE_CSR                                           
               INTO :PU-ACCOUNT-NO                                      
                   ,:PU-BILL-NO                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**     PCSXP100  PROCESSING ERROR           **'  
              DISPLAY '**  ERROR FETCHING PURGE_CSR CURSOR         **'  
              DISPLAY '**********************************************'  
              DISPLAY '** CURRENT PARAGRAPH  = ' WS-ACTIVE-PARAGRAPH    
              DISPLAY '** PU-ACCOUNT-NO      = ' PU-ACCOUNT-NO          
              DISPLAY '** PU-BILL-NO         = ' PU-BILL-NO             
              DISPLAY '** SQL STATUS         = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**       PROCESSING TERMINATED              **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE ACCOUNT TABLE CURSOR                                     *        
      *----------------------------------------------------------------*        
       7300-CLOSE-PURGE-CSR.                                            
      *----------------------*                                                  
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE PURGE_CSR                                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**     PCSXP100  PROCESSING ERROR           **'  
              DISPLAY '**    ERROR CLOSING PURGE_CSR CURSOR        **'  
              DISPLAY '**********************************************'  
              DISPLAY '** CURRENT PARAGRAPH  = ' WS-ACTIVE-PARAGRAPH    
              DISPLAY '** SQL STATUS         = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**       PROCESSING TERMINATED              **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  05160000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  05170000
      **  *RETRIEVE COMMIT COUNT DETAILS FROM JOB PARM TABLE.        *  05170000
      ****************************************************************  05180000
      *                                                                         
            EXEC SQL                                                    05190000
                INCLUDE CPD00034                                        05200000
            END-EXEC.                                                   05210000
      *                                                                 05220000
      *----------------------------------------------------------------*        
      * SELECT CSS_JOB_PARM TABLE                                      *        
      * 7600P-,7610P-, 7611P- PARAGRAPHS                              *         
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE CPDPURGE                                                 
           END-EXEC                                                             
      *                                                                         
      *----------------------------------------------------------------*        
      * SELECT CSS_JOB_PARM TABLE                                      *        
      * 7600-,7610-, 7611- PARAGRAPHS                                  *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC                                                             
      *                                                                         
      ******************************************************************        
      * 7410-GET-TIME-STAMP                                            *        
      ******************************************************************        
      *                                                                         
       7410-GET-TIME-STAMP.                                             
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-RUN-TS              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-RUN-TS = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP100 ABORT  ************'         
              DISPLAY '* 7410-GET-TIME-STAMP                 *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP100  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
            EXIT.                                                       
      *----------------------------------------------------------------*        
      * DELETE CSS_BILLING_HDR TABLE ROWS                              *        
      *----------------------------------------------------------------*        
       8000-PROCESS-DELETION.                                           
      *---------------------*                                                   
           MOVE '8000'                         TO WS-ACTIVE-PARAGRAPH   
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_BILLING_HDR                                
              WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                         
                AND BILL_NO   <= :BI-BILL-NO                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**********************************************'  
              DISPLAY '**     PCSXP100  PROCESSING ERROR           **'  
              DISPLAY '**     ERROR DELETING CSS_BILLING_HDR       **'  
              DISPLAY '**********************************************'  
              DISPLAY '** CURRENT PARAGRAPH  = ' WS-ACTIVE-PARAGRAPH    
              DISPLAY '** BI-ACCOUNT-NO      = ' BI-ACCOUNT-NO          
              DISPLAY '** BI-BILL-NO         = ' BI-BILL-NO             
              DISPLAY '** SQL STATUS         = ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**       PROCESSING TERMINATED              **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND                                        
                 THRU 9900-EXIT                                         
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8100-UPDATE-LAST-RUN-DATE                                     *         
      *****************************************************************         
       8100-UPDATE-LAST-RUN-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
                                                                        
               UPDATE CSS_JOB_PARM                                      
                  SET PARM_DATA    = :G6-PARM-DATA                      
                WHERE CMND_CODE    = 'DATE'                             
                  AND COMPANY_NO   = '01'                               
                  AND PROGRAM_NAME = :WS-PGRMNAME                       
                  AND STATUS       = 'A'                                
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP100 ABORT **************'        
              DISPLAY '*     8100-UPDATE-LAST-RUN-DATE        *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM NAME   : ' WS-PGRMNAME                 
              DISPLAY '* PARM DATA      : ' G6-PARM-DATA                
              DISPLAY'* WS-PGM-LAST-RUN-TS = ' WS-PGM-LAST-RUN-TS       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *---------------------------------------------------------------*         
      * COMMIT DB2                                                    *         
      *---------------------------------------------------------------*         
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
           COMPUTE WS-COMMIT-NO = WS-COMMIT-NO  + 1.                    
           .                                                            
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      *  PERFORMED IF BAD TERMINATION OCCURS.                        *          
      ****************************************************************          
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
