       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSXP000.                                            
       DATE-WRITTEN. OCT 2008.                                          
                                                                        
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      *                                                               *         
      * THIS PROGRAM SELECTS ACCOUNTS FROM THE CSS_BILLING_HDR TABLE  *         
      * AND DETERMINES THE DATA THAT CAN BE PURGED. THE BUSINESS      *         
      * RULES CAME FROM PCSCA363. ONCE ACCOUNTS ARE SELECTED TO BE    *         
      * PURGED, THEY ARE INSERTED IN THE CIS_PURGE TABLE WITH A       *         
      * PURGE_TYPE_CD = 'B' AND UPDATED EACH MONTH AS LONG AS THEY    *         
      * ARE ACTIVE.                                                   *         
      * WHEN AN ACCOUNT IS FINAL BILLED, THE ROW WITH A PURGE TYPE    *         
      * OF 'B' IS DELETED. ACCOUNTS ARE INSERTED BACK INTO THIS TABLE *         
      * WITH A PURGE TYPE OF 'A' BY PCSXP520 ONCE THEY ARE READY TO   *         
      * BE ARCHIVED. WHEN AN ACCOUNT HAS BEEN ARCHIVED, AND IT NO     *         
      * LONGER EXISTS ON THE CSS_ACCOUNT TABLE, IT IS DELETED FROM    *         
      * THE CIS_PURGE TABLE                                           *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *   DATE       INITIALS    REASON                               *         
      * ----------  ------------ -------------------------------------*         
A37648* 10/10/2008  PRIYA        APPL37648-ACT01, 44, 55              *         
A03673* 09/19/2011  MC95456      APPL3673-ACT01                       *         
A03673*                          PROCESS CSS_BILL_HDR IF BILLING DETL *         
A03673*                          DOES NOT EXISTS.                     *         
ACT010* 02/15/2012  VIJAY        FIX BILL NO MISMATCH.                *         
      *    A03967                                                     *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
             ---- BASIC SEQUENCE STRUCTURE ----                         
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP000'.
MSQ017     COPY MFASQLM.
       01  WS-CONSTANTS.                                                
           05 WS-PGRMNAME                 PIC X(08) VALUE 'PCSXP000'.   
      *                                                                         
       01  WS-COUNTERS.                                                 
           05 WS-BILL-ACCT-CNT-INS        PIC S9(9) COMP VALUE 0.       
           05 WS-BILL-ACCT-CNT-UPD        PIC S9(9) COMP VALUE 0.       
           05 WS-ACCT-TOTAL               PIC S9(9) COMP VALUE 0.       
           05 WS-DEL-ACCT-TOTAL           PIC S9(9) COMP VALUE 0.       
           05 WS-COMMIT-CNT               PIC S9(9) COMP VALUE 0.       
           05 WS-COMMIT-CNT-DEL           PIC S9(9) COMP VALUE 0.       
           05 WS-COMMIT-NO                PIC S9(9) COMP VALUE 0.       
           05 WS-COMMIT-NO-DEL            PIC S9(9) COMP VALUE 0.       
           05 WS-DEFAULT-COMMIT-CNT       PIC S9(9) COMP VALUE 500.     
           05 WS-CURRENT-RUN-DATE         PIC X(10) VALUE SPACES.       
      *                                                                         
       01  WS-VARIABLES.                                                
           05 WS-DEFAULT-CHKP-LUW-LIMIT  PIC 9(04) VALUE 4.             
           05 WS-CHKP-LUW-LIMIT          PIC 9(04) VALUE ZERO.          
           05 WS-DEFAULT-CHKP-UPD-LIMIT  PIC 9(04) VALUE 20.            
           05 WS-CHKP-UPD-LIMIT          PIC 9(04) VALUE ZERO.          
           05 WS-COMMIT-COUNT            PIC 9(09) VALUE ZEROS.         
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05 WS-ACCT-COMP-3             PIC S9(13)  COMP.              
           05 WS-ERR-MSG                 PIC X(100)     VALUE SPACES.   
           05 WS-ERR-MSG2                PIC X(100)     VALUE SPACES.   
           05 WS-DISP-ACCOUNT-NO         PIC 9(13).                     
           05 WS-DATE-BILL-DAY-00        PIC X(10)      VALUE SPACES.   
           05 WS-BILL-NO                 PIC 9(9)       VALUE 0.        
           05 WS-IMAGE-DATE              PIC X(10)      VALUE SPACES.   
           05 WS-DATE-BILLED-25MONTHS    PIC X(10)      VALUE SPACES.   
           05 WS-TIMESTAMP               PIC X(26)      VALUE SPACES.   
           05 WS-NO-MORE-RECORDS          PIC X(01)      VALUE 'N'.     
              88 NO-MORE-RECORDS                         VALUE 'Y'.     
A03673     05 WS-TRANS-HIST-SEQ-NO.                                     
A03673        10 WS-TRANS-HIST-SEQ-NO-DT PIC X(10).                     
A03673        10 WS-TRANS-HIST-SEQ-NO-TS PIC X(16)                      
A03673                                   VALUE '-00.00.00.000000'.      
                                                                        
       01 WS-PARM-DATA.                                                 
          05 FILLER                  PIC X(14) VALUE                    
                                               'LAST RUN DATE='.        
          05 WS-PGM-LAST-RUN-DATE    PIC X(10) VALUE SPACES.            
          05 FILLER                  PIC X(56) VALUE SPACES.            
                                                                        
      *                                                                 01280001
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT - AT                                                        
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_JOB_PARM - G6                                                       
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_BILLING_HDR - BI                                                    
           EXEC SQL                                                             
             INCLUDE TBBLLHDR                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_BILLING_DET - BG                                                    
           EXEC SQL                                                             
             INCLUDE TBBLLDET                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_CIS_PURGE- PU                                                       
           EXEC SQL                                                             
             INCLUDE TBPURGE                                                    
           END-EXEC.                                                            
                                                                        
      * CSS_AR_TRANS_HIST - AR                                                  
           EXEC SQL                                                             
             INCLUDE TBARHIST                                                   
           END-EXEC.                                                            
                                                                        
      * DECLARE DB2 AND SQL ERROR CHECK VARIABLES                               
       COPY CWS00303.                                                           
                                                                        
      * ABEND SWITCH COPYBOOK                                                   
       COPY CWS09900.                                                           
                                                                        
      * WORKING STORAGE FOR PROCESSING CSS_JOB_PARM                             
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
                                                                        
      * DECLARE ACCOUNT TABLE CURSOR                                            
           EXEC SQL                                                     
            DECLARE ACCOUNT_CSR CURSOR WITH HOLD FOR                    
             SELECT ACCOUNT_NO                                          
                   ,DATE_BILL_DAY_00                                    
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO     >= :AT-ACCOUNT-NO                    
                AND ACCOUNT_NO     <= :WS-ACCOUNT-NO                    
                AND CODE_ACCT_STAT  = 'A'                               
                AND ACCT_CREATE_DT < CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP)          
                AND DATE_BILL_DAY_00 > IIF(TRY_CONVERT(DATE, 
                                                  :WS-PGM-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PGM-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-PGM-LAST-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PGM-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-PGM-LAST-RUN-DATE) )            
                FOR READ ONLY                                   
A03673                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE ACCOUNT_CSR CURSOR WITH HOLD FOR                            
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*            ,DATE_BILL_DAY_00                                            
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO     >= :AT-ACCOUNT-NO                            
MFA-TR*         AND ACCOUNT_NO     <= :WS-ACCOUNT-NO                            
MFA-TR*         AND CODE_ACCT_STAT  = 'A'                                       
MFA-TR*         AND ACCT_CREATE_DT < :WS-TIMESTAMP                              
MFA-TR*         AND DATE_BILL_DAY_00 > :WS-PGM-LAST-RUN-DATE                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC                                                             
                                                                        
      *--------------------------------------------------------------           
      * SELECTING BILLED ROWS OF 26. THIS INCLUDES CANCEL/REBILL ROWS.          
      *--------------------------------------------------------------           
      * DECLARE BILLING DETAIL TABLE CURSOR -                                   
           EXEC SQL                                                     
            DECLARE BILLING_CSR INSENSITIVE SCROLL CURSOR WITH HOLD FOR 
             SELECT TOP(26) BILL_NO                                             
               FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO           = :BG-ACCOUNT-NO               
                AND BILL_NO              > 0                            
                AND IC_NO                > 0                            
                AND CODE_UTIL_TYPE       > ' '                          
                AND CODE_BILL_CALC       = 'A'                          
                AND CODE_BILL_ITM_TYPE   = 'C'                          
                AND CODE_BILL_ITM_IND    = 'A'                          
                AND ((REV_MTH_ORIG_BILL  = 0                            
                AND REVENUE_MONTH        > 0 )                          
                 OR REV_MTH_ORIG_BILL    > 0 )                          
              GROUP BY BILL_NO                                          
              ORDER BY BILL_NO DESC                                     
                                                
              FOR READ ONLY                                     
A03673                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BILLING_CSR INSENSITIVE SCROLL CURSOR WITH HOLD FOR         
MFA-TR*      SELECT BILL_NO                                                     
MFA-TR*        FROM CSS_BILLING_DET                                             
MFA-TR*       WHERE ACCOUNT_NO           = :BG-ACCOUNT-NO                       
MFA-TR*         AND BILL_NO              > 0                                    
MFA-TR*         AND IC_NO                > 0                                    
MFA-TR*         AND CODE_UTIL_TYPE       > ' '                                  
MFA-TR*         AND CODE_BILL_CALC       = 'A'                                  
MFA-TR*         AND CODE_BILL_ITM_TYPE   = 'C'                                  
MFA-TR*         AND CODE_BILL_ITM_IND    = 'A'                                  
MFA-TR*         AND ((REV_MTH_ORIG_BILL  = 0                                    
MFA-TR*         AND REVENUE_MONTH        > 0 )                                  
MFA-TR*          OR REV_MTH_ORIG_BILL    > 0 )                                  
MFA-TR*       GROUP BY BILL_NO                                                  
MFA-TR*       ORDER BY BILL_NO DESC                                             
MFA-TR*       FETCH FIRST 26 ROWS ONLY                                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC                                                             
                                                                        
A03673*--------------------------------------------------------------           
A03673* SELECTING BILLED ROWS OF 26 FROM CSS_BILLING_HDR            *           
A03673*--------------------------------------------------------------           
A03673* DECLARE BILLING HEADER TABLE CURSOR -                                   
A03673     EXEC SQL                                                     
A03673      DECLARE BILLING_HDR INSENSITIVE SCROLL CURSOR WITH HOLD FOR 
A03673       SELECT TOP(26) BILL_NO                                             
A03673         FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                       
A03673        WHERE ACCOUNT_NO           = :BG-ACCOUNT-NO               
A03673          AND BILL_NO              > 0                            
A03673          AND DATE_BILLED          IS NOT NULL                    
A03673                                          
A03673        FOR READ ONLY                                     
A03673                                                      
A03673     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BILLING_HDR INSENSITIVE SCROLL CURSOR WITH HOLD FOR         
MFA-TR*      SELECT BILL_NO                                                     
MFA-TR*        FROM CSS_BILLING_HDR                                             
MFA-TR*       WHERE ACCOUNT_NO           = :BG-ACCOUNT-NO                       
MFA-TR*         AND BILL_NO              > 0                                    
MFA-TR*         AND DATE_BILLED          IS NOT NULL                            
MFA-TR*       FETCH FIRST 26 ROWS ONLY                                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7430                                                      
MFA-TR*    END-EXEC                                                             
A03673*--------------------------------------------------------------           
      * DECLARE PURGE TABLE CURSOR                                              
           EXEC SQL                                                     
            DECLARE   PURGE_CSR CURSOR WITH HOLD FOR                    
             SELECT   PU.ACCOUNT_NO                                     
               FROM   CSS_CIS_PURGE PU WITH(READUNCOMMITTED)                    
                     ,CSS_ACCOUNT    AT WITH(READUNCOMMITTED)                   
               WHERE PU.PURGE_TYPE_CD = 'B'                             
               AND   PU.ACCOUNT_NO    = AT.ACCOUNT_NO                   
               AND   AT.CODE_ACCT_STAT  IN ('B','S')                    
               AND   AT.ACCT_FINALED_DT IS NOT NULL                     
              FOR READ ONLY                                     
A03673                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE   PURGE_CSR CURSOR WITH HOLD FOR                            
MFA-TR*      SELECT   PU.ACCOUNT_NO                                             
MFA-TR*        FROM   CSS_CIS_PURGE PU                                          
MFA-TR*              ,CSS_ACCOUNT    AT                                         
MFA-TR*        WHERE PU.PURGE_TYPE_CD = 'B'                                     
MFA-TR*        AND   PU.ACCOUNT_NO    = AT.ACCOUNT_NO                           
MFA-TR*        AND   AT.CODE_ACCT_STAT  IN ('B','S')                            
MFA-TR*        AND   AT.ACCT_FINALED_DT IS NOT NULL                             
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 WS-PARM-ACCOUNT.                                              
          05 WS-LENGTH                              PIC S9(4) COMP.     
          05 WS-START-ACCT                          PIC 9(13).          
          05 FILLER                                 PIC X(01).          
          05 WS-END-ACCT                            PIC 9(13).          
       PROCEDURE DIVISION USING WS-PARM-ACCOUNT.                        
      *----------------------------------------------------------------*        
      *                          M A I N L I N E                       *        
      *----------------------------------------------------------------*        
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE                            
              THRU 0100-EXIT                                            
                                                                        
           PERFORM 1000-PROCESS-ACCOUNTS                                
              THRU 1000-EXIT                                            
                                                                        
           PERFORM 3000-DELETE-PURGE-ROWS                               
              THRU 3000-EXIT                                            
                                                                        
           MOVE WS-CURRENT-RUN-DATE          TO WS-PGM-LAST-RUN-DATE    
           MOVE WS-PARM-DATA                 TO G6-PARM-DATA            
           PERFORM 8200-UPDATE-LAST-RUN-DATE THRU 8200-EXIT             
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT COMMIT COUNT FROM CSS_JOB_PARM TABLE                    *        
      *----------------------------------------------------------------*        
       0100-INITIALIZE-PROCEDURE.                                       
      *--------------------------*                                              
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
      **-- GET COMMIT COUNTS.                                                   
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
                                                                        
      **-- GET LAST RUN DATE.                                                   
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME                   TO WS-PROGRAM.            
           MOVE WS-DATE                       TO WS-COMMAND.            
           MOVE ZEROS                         TO WS-SEQUENCE.           
           MOVE SPACES                        TO WS-SYSIPT.             
           MOVE WS-KEY-AREA                   TO E-FJC01-KEY.           
                                                                        
           PERFORM 7600-START-FCSJC01        THRU 7600-EXIT.            
           PERFORM 0125-READ-LAST-TS         THRU 0125-EXIT.            
                                                                        
      **-- FOR SELECTING ACCOUNTS                                               
           PERFORM 7800-SELECT-TIMESTAMP     THRU 7800-EXIT             
                                                                        
      **-- FOR UPDATING LAST-RUN-DATE                                           
           PERFORM 7850-LAST-RUN-TIME-STAMP  THRU 7850-EXIT.            
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *----------------------------------------------------------------*        
      **  0125-READ-LAST-TS                                           *         
      *----------------------------------------------------------------*        
       0125-READ-LAST-TS.                                               
      *                                                                         
           PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT              
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:14) = 'LAST RUN DATE=')   
                OR END-OF-SYSIPT                                        
               IF WS-INPUT-DATA-BREAKDOWN(1:14) = 'LAST RUN DATE='      
                 IF INPUT-ACTIVE                                        
                    MOVE G6-PARM-DATA(15:10)    TO WS-PGM-LAST-RUN-DATE 
                    DISPLAY 'LAST RUN DATE : ' WS-PGM-LAST-RUN-DATE     
                 ELSE                                                   
                    DISPLAY 'JOB PARM NOT ACTIVE FOR LAST RUN DATE'     
                    DISPLAY 'NO RECORDS ARE PROCESSED'                  
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
                 END-IF                                                 
               ELSE                                                     
                  DISPLAY 'JOB PARM NOT PRESENT FOR LAST RUN DATE'      
                  DISPLAY 'NO RECORDS ARE PROCESSED'                    
                  PERFORM 9900-ABEND          THRU 9900-EXIT            
               END-IF.                                                  
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *----------------------------------------------------------------*        
      * SELECT ACTIVE ACCOUNTS AND GET BILLING DETAILS                 *        
      *----------------------------------------------------------------*        
       1000-PROCESS-ACCOUNTS.                                           
      *----------------------*                                                  
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-START-ACCT            TO WS-ACCT-COMP-3              
           MOVE WS-ACCT-COMP-3           TO AT-ACCOUNT-NO               
           MOVE WS-END-ACCT              TO WS-ACCT-COMP-3              
           MOVE WS-ACCT-COMP-3           TO WS-ACCOUNT-NO               
                                                                        
           DISPLAY 'START ACCT: ' AT-ACCOUNT-NO                         
           DISPLAY 'END   ACCT: ' WS-ACCOUNT-NO                         
                                                                        
           PERFORM 7100-OPEN-ACCOUNT-CSR                                
              THRU 7100-EXIT                                            
           PERFORM 7200-FETCH-ACCOUNT-CSR                               
              THRU 7200-EXIT                                            
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE AT-ACCOUNT-NO         TO WS-DISP-ACCOUNT-NO          
                                            BI-ACCOUNT-NO               
                                            BG-ACCOUNT-NO               
                                                                        
              MOVE AT-DATE-BILL-DAY-00   TO WS-DATE-BILL-DAY-00         
                                                                        
              PERFORM 2100-PROCESS-BILL-DET                             
                 THRU 2100-EXIT                                         
                                                                        
              IF WS-COMMIT-CNT >= WS-CHKP-UPD-LIMIT                     
                  PERFORM 8999-ISSUE-COMMIT                             
                     THRU 8999-EXIT                                     
                  MOVE 0  TO WS-COMMIT-CNT                              
                  ADD  1  TO WS-COMMIT-NO                               
                  DISPLAY 'COMMIT NO = ' WS-COMMIT-NO                   
                  DISPLAY 'ACCOUNT NO = ' WS-DISP-ACCOUNT-NO            
              ELSE                                                      
                 ADD  1  TO WS-COMMIT-CNT                               
              END-IF                                                    
                                                                        
              PERFORM 7200-FETCH-ACCOUNT-CSR                            
                 THRU 7200-EXIT                                         
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7300-CLOSE-ACCOUNT-CSR                               
              THRU 7300-EXIT                                            
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
      *----------------------------------------------------------------*        
      * GET BILLING DETAILS FOR AN ACCOUNT AND INSERT ROWS WHICH ARE   *        
      * MORE THAN 25 MONTHS OLD INTO CSS_CIS_PURGE TABLE.              *        
      *----------------------------------------------------------------*        
       2100-PROCESS-BILL-DET.                                           
      *----------------------*                                                  
           MOVE '2100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 7400-OPEN-BILLDET-CSR                                
              THRU 7400-EXIT                                            
           PERFORM 7410-FETCH-LAST-BILL                                 
              THRU 7410-EXIT                                            
                                                                        
           IF SQLERRD(2) = 26 OR SQLERRD(1) = 26                        
                                                                        
              PERFORM 7420-CLOSE-BILLDET-CSR                            
                 THRU 7420-EXIT                                         
                                                                        
              MOVE BG-BILL-NO     TO BI-BILL-NO                         
                                     WS-BILL-NO                         
                                                                        
ACT010        INITIALIZE WS-DATE-BILLED-25MONTHS                        
              PERFORM 7650-SELECT-DAY-BILL-25MTHS                       
                 THRU 7650-EXIT                                         
                                                                        
              PERFORM 7700-SELECT-DATE-BILLED                           
                 THRU 7700-EXIT                                         
                                                                        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 GO TO 2100-EXIT                                        
              END-IF                                                    
                                                                        
              PERFORM 7750-GET-IMAGE-PURGEDT                            
                 THRU 7750-EXIT                                         
                                                                        
              PERFORM 7775-GET-TRANS-SEQNO                              
                 THRU 7775-EXIT                                         
                                                                        
              PERFORM 2200-PROCESS-UPDATION                             
                 THRU 2200-EXIT                                         
           ELSE                                                         
              PERFORM 7420-CLOSE-BILLDET-CSR                            
                 THRU 7420-EXIT                                         
                                                                        
A03673        PERFORM 2150-PROCESS-BILL-HDR                             
A03673           THRU 2150-EXIT                                         
           END-IF                                                       
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03673*----------------------------------------------------------------*        
A03673* GET BILLING HDR DETAILS OF ACCOUNT AND INSERT ROWS WHICH ARE   *        
A03673* MORE THAN 25 MONTHS OLD INTO CSS_CIS_PURGE TABLE.              *        
A03673*----------------------------------------------------------------*        
A03673 2150-PROCESS-BILL-HDR.                                           
A03673*----------------------*                                                  
A03673     MOVE '2150'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
A03673     PERFORM 7430-OPEN-BILLHDR-CSR                                
A03673        THRU 7430-EXIT                                            
A03673     PERFORM 7440-FETCH-BILLHDR                                   
A03673        THRU 7440-EXIT                                            
                                                                        
A03673     IF SQLERRD(2) = 26 OR SQLERRD(1) = 26                        
                                                                        
A03673        PERFORM 7450-CLOSE-BILLHDR-CSR                            
A03673           THRU 7450-EXIT                                         
                                                                        
A03673        MOVE BI-BILL-NO     TO WS-BILL-NO                         
                                                                        
ACT010        INITIALIZE WS-DATE-BILLED-25MONTHS                        
                                                                        
A03673        PERFORM 7650-SELECT-DAY-BILL-25MTHS                       
A03673           THRU 7650-EXIT                                         
                                                                        
                                                                        
A03673        PERFORM 7700-SELECT-DATE-BILLED                           
A03673           THRU 7700-EXIT                                         
                                                                        
                                                                        
A03673        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A03673           GO TO 2150-EXIT                                        
A03673        END-IF                                                    
                                                                        
A03673        PERFORM 7750-GET-IMAGE-PURGEDT                            
A03673           THRU 7750-EXIT                                         
                                                                        
A03673        PERFORM 7775-GET-TRANS-SEQNO                              
A03673           THRU 7775-EXIT                                         
                                                                        
A03673        PERFORM 2200-PROCESS-UPDATION                             
A03673           THRU 2200-EXIT                                         
A03673     ELSE                                                         
A03673        PERFORM 7450-CLOSE-BILLHDR-CSR                            
A03673           THRU 7450-EXIT                                         
                                                                        
A03673     END-IF                                                       
           .                                                            
A03673 2150-EXIT.                                                       
A03673     EXIT.                                                        
      *----------------------------------------------------------------*        
      * UPDATE AND INSERT THE ROWS WHICH ARE MORE THAN 25 MONTHS OLD   *        
      * FOR AN ACCOUNT INTO CSS_CIS_PURGE TABLE.                       *        
      *----------------------------------------------------------------*        
       2200-PROCESS-UPDATION.                                           
      *----------------------*                                                  
           MOVE '2200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 7950-UPDATE-PURGE-TBL                                
              THRU 7950-EXIT                                            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7900-INSERT-PURGE-TBL                             
                 THRU 7900-EXIT                                         
           END-IF                                                       
                                                                        
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT ACTIVE ACCOUNTS AND DELETE FROM CIS_PURGE TABLE.        *        
      *----------------------------------------------------------------*        
       3000-DELETE-PURGE-ROWS.                                          
      *----------------------*                                                  
           MOVE '3000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
                                                                        
           PERFORM 7500-OPEN-PURGE-CSR                                  
              THRU 7500-EXIT                                            
           PERFORM 7510-FETCH-PURGE-CSR                                 
              THRU 7510-EXIT                                            
                                                                        
            MOVE PU-ACCOUNT-NO         TO WS-DISP-ACCOUNT-NO            
                                                                        
           PERFORM UNTIL NO-MORE-RECORDS                                
              PERFORM 8100-PURGE-DELETE                                 
                 THRU 8100-EXIT                                         
              IF WS-COMMIT-CNT-DEL >= WS-CHKP-UPD-LIMIT                 
                 PERFORM 8999-ISSUE-COMMIT                              
                    THRU 8999-EXIT                                      
                 MOVE 0  TO WS-COMMIT-CNT-DEL                           
                 ADD  1  TO WS-COMMIT-NO-DEL                            
              ELSE                                                      
                 ADD  1  TO WS-COMMIT-CNT-DEL                           
              END-IF                                                    
              PERFORM 7510-FETCH-PURGE-CSR                              
                 THRU 7510-EXIT                                         
              MOVE PU-ACCOUNT-NO         TO WS-DISP-ACCOUNT-NO          
           END-PERFORM                                                  
                                                                        
           PERFORM 7520-CLOSE-PURGE-CSR                                 
              THRU 7520-EXIT                                            
           .                                                            
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * OPEN ACCOUNT TABLE CURSOR                                      *        
      *----------------------------------------------------------------*        
       7100-OPEN-ACCOUNT-CSR.                                           
      *----------------------*                                                  
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN ACCOUNT_CSR                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING ACCOUNT_CSR CURSOR **'             
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH ACTIVE ACCOUNTS WHICH WERE CREATED 25 MONTHS BEFORE      *        
      *----------------------------------------------------------------*        
       7200-FETCH-ACCOUNT-CSR.                                          
      *----------------------*                                                  
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH ACCOUNT_CSR                                         
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-DATE-BILL-DAY-00                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-ACCT-TOTAL                                 
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR FETCHING ACCOUNT_CSR CURSOR **'            
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' AT.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE ACCOUNT TABLE CURSOR                                     *        
      *----------------------------------------------------------------*        
       7300-CLOSE-ACCOUNT-CSR.                                          
      *----------------------*                                                  
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE ACCOUNT_CSR                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR FETCHING ACCOUNT_CSR CURSOR **'            
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' AT.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              DISPLAY ' ERROR CLOSING ACCOUNT_CSR CURSOR **'            
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * OPEN BILLING DETAIL TABLE CURSOR                               *        
      *----------------------------------------------------------------*        
       7400-OPEN-BILLDET-CSR.                                           
      *----------------------*                                                  
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN BILLING_CSR                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING BILLING_CSR CURSOR FROM '          
                     'CSS_BILLING_DET **'                               
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' BG.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH LAST ROW FROM THE CURSOR                                 *        
      *----------------------------------------------------------------*        
       7410-FETCH-LAST-BILL.                                            
      *---------------------*                                                   
           MOVE '7410'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH  LAST FROM BILLING_CSR                   
               INTO :BG-BILL-NO                                         
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH INSENSITIVE LAST FROM BILLING_CSR                           
MFA-TR*        INTO :BG-BILL-NO                                                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR FETCHING BILLING_CSR CURSOR'               
                     ' FROM CSS_BILLING_DET **'                         
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' BG.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
                     ',BG.BILL_NO    = ' WS-BILL-NO                     
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  CLOSE BILLING DETAIL TABLE CURSOR                             *        
      *----------------------------------------------------------------*        
       7420-CLOSE-BILLDET-CSR.                                          
      *-----------------------*                                                 
           MOVE '7420'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE BILLING_CSR                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR CLOSING BILLING_CSR CURSOR'                
                     ' FROM CSS_BILLING_DET **'                         
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' BG.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7420-EXIT.                                                       
           EXIT.                                                        
A03673*----------------------------------------------------------------*        
A03673* OPEN BILLING HEADER CURSOR                                     *        
A03673*----------------------------------------------------------------*        
A03673 7430-OPEN-BILLHDR-CSR.                                           
A03673*----------------------*                                                  
A03673     MOVE '7430'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
A03673     EXEC SQL                                                     
A03673         OPEN BILLING_HDR                                         
A03673     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A03673     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
A03673     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03673        CONTINUE                                                  
A03673     ELSE                                                         
A03673        STRING ' ERROR OPENING BILLING_HDR CURSOR FROM '          
A03673               'CSS_BILLING_HDR **'                               
A03673                 DELIMITED BY SIZE INTO WS-ERR-MSG                
A03673        STRING ' BI.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
A03673                 DELIMITED BY SIZE INTO WS-ERR-MSG2               
A03673        PERFORM 8800-DIS-TABLE-ERROR                              
A03673           THRU 8800-EXIT                                         
A03673     END-IF                                                       
           .                                                            
A03673 7430-EXIT.                                                       
A03673     EXIT.                                                        
                                                                        
A03673*----------------------------------------------------------------*        
A03673* FETCH ROWS FROM BILLING HDR CURSOR                             *        
A03673*----------------------------------------------------------------*        
A03673 7440-FETCH-BILLHDR.                                              
A03673*---------------------*                                                   
A03673     MOVE '7440'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
A03673     EXEC SQL                                                     
A03673        FETCH  LAST FROM BILLING_HDR                   
A03673         INTO :BI-BILL-NO                                         
A03673     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH INSENSITIVE LAST FROM BILLING_HDR                           
MFA-TR*        INTO :BI-BILL-NO                                                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A03673     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
A03673     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A03673        CONTINUE                                                  
A03673     ELSE                                                         
A03673        STRING ' ERROR FETCHING BILLING_HDR CURSOR'               
A03673               ' FROM CSS_BILLING_HDR **'                         
A03673                 DELIMITED BY SIZE INTO WS-ERR-MSG                
A03673        STRING ' BI.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
A03673               ',BI.BILL_NO    = ' WS-BILL-NO                     
A03673                 DELIMITED BY SIZE INTO WS-ERR-MSG2               
A03673        PERFORM 8800-DIS-TABLE-ERROR                              
A03673           THRU 8800-EXIT                                         
A03673     END-IF                                                       
A03673     .                                                            
A03673 7440-EXIT.                                                       
A03673     EXIT.                                                        
                                                                        
A03673*----------------------------------------------------------------*        
A03673*  CLOSE BILLING HEADER CURSOR                                   *        
A03673*----------------------------------------------------------------*        
A03673 7450-CLOSE-BILLHDR-CSR.                                          
A03673*-----------------------*                                                 
A03673     MOVE '7450'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
A03673     EXEC SQL                                                     
A03673        CLOSE BILLING_HDR                                         
A03673     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A03673     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
A03673     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03673        CONTINUE                                                  
A03673     ELSE                                                         
A03673        STRING ' ERROR CLOSING BILLING_HDR CURSOR'                
A03673               ' FROM CSS_BILLING_HDR **'                         
A03673                 DELIMITED BY SIZE INTO WS-ERR-MSG                
A03673        STRING ' BI.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
A03673                 DELIMITED BY SIZE INTO WS-ERR-MSG2               
A03673        PERFORM 8800-DIS-TABLE-ERROR                              
A03673           THRU 8800-EXIT                                         
A03673     END-IF                                                       
A03673     .                                                            
A03673 7450-EXIT.                                                       
A03673     EXIT.                                                        
      *----------------------------------------------------------------*        
      * OPEN PURGE   TABLE CURSOR                                      *        
      *----------------------------------------------------------------*        
       7500-OPEN-PURGE-CSR.                                             
      *----------------------*                                                  
           MOVE '7500'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               OPEN PURGE_CSR                                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING PURGE_CSR CURSOR **'               
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * FETCH PURGE ACCOUNTS                                                    
      *----------------------------------------------------------------*        
       7510-FETCH-PURGE-CSR.                                            
      *----------------------*                                                  
           MOVE '7510'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              FETCH PURGE_CSR                                           
               INTO :PU-ACCOUNT-NO                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE 'Y'    TO WS-NO-MORE-RECORDS                     
               ELSE                                                     
                  STRING ' ERROR FETCHING PURGE_CSR CURSOR'             
                       ' FROM CSS_CIS_PURGE **'                         
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
                  STRING ' PU.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO         
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
                  PERFORM 8800-DIS-TABLE-ERROR                          
                  THRU 8800-EXIT                                        
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CLOSE PURGE  TABLE CURSOR                                     *         
      *----------------------------------------------------------------*        
       7520-CLOSE-PURGE-CSR.                                            
      *----------------------*                                                  
           MOVE '7520'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              CLOSE PURGE_CSR                                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ERROR CLOSING PURGE_CSR CURSOR **'              
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  05160000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  05170000
      **  *RETRIEVE COMMIT COUNT DETAILS FROM JOB PARM TABLE.        *  05170000
      ****************************************************************  05180000
      *                                                                         
            EXEC SQL                                                    05190000
                INCLUDE CPD00034                                        05200000
            END-EXEC.                                                   05210000
      *                                                                 05220000
      *----------------------------------------------------------------*        
      * SELECT CSS_JOB_PARM TABLE                                      *        
      * 7600-, 7610-,7611- PARAGRAPHS                                  *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC                                                             
                                                                        
      *----------------------------------------------------------------*        
      * CALCULATE THE DATE BILLED : AT-DATE-BILL-DAY OF 00 - 25 MONTHS *        
      *----------------------------------------------------------------*        
       7650-SELECT-DAY-BILL-25MTHS.                                     
      *----------------------*                                                  
           MOVE '7650'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( MONTH, -25, IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:WS-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILL-DAY-00
              ), CONVERT(DATE, :WS-DATE-BILL-DAY-00) ) )
            INTO
              :WS-DATE-BILLED-25MONTHS    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DATE-BILLED-25MONTHS =                                  
MFA-TR*                      DATE (:WS-DATE-BILL-DAY-00) - 25 MONTHS            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING TIMESTAMP      ** '              
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES                TO WS-ERR-MSG2                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT DATE ON WHICH AN ACCOUNT WAS BILLED                     *        
      *----------------------------------------------------------------*        
       7700-SELECT-DATE-BILLED.                                         
      *------------------------*                                                
           MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) DATE_BILLED,
              BILL_NO                                             
               INTO :BI-DATE-BILLED                                     
ACT010             ,:BI-BILL-NO                                         
              FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                        
              WHERE ACCOUNT_NO   =  :BI-ACCOUNT-NO                      
                AND BILL_NO     <=  :BI-BILL-NO                         
                AND DATE_BILLED <=  IIF(TRY_CONVERT(DATE, 
                                               :WS-DATE-BILLED-25MONTHS
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED-25MONTHS
              ) <> 0) OR (LEN(:WS-DATE-BILLED-25MONTHS
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILLED-25MONTHS
              ), CONVERT(DATE, :WS-DATE-BILLED-25MONTHS) )            
               ORDER BY BILL_NO DESC                                    
                                                    
                                                                 
A03673                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_BILLED                                                 
MFA-TR*            ,BILL_NO                                                     
MFA-TR*        INTO :BI-DATE-BILLED                                             
MFA-TR*            ,:BI-BILL-NO                                                 
MFA-TR*       FROM CSS_BILLING_HDR                                              
MFA-TR*       WHERE ACCOUNT_NO   =  :BI-ACCOUNT-NO                              
MFA-TR*         AND BILL_NO     <=  :BI-BILL-NO                                 
MFA-TR*         AND DATE_BILLED <=  :WS-DATE-BILLED-25MONTHS                    
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING DATE BILLED FROM'                
                     ' CSS_BILLING_HDR **'                              
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' BI.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO             
                     ',BI.BILL_NO    = ' WS-BILL-NO                     
                     ',WS-DATE-BILLED-25MONTHS =  '                     
                                         WS-DATE-BILLED-25MONTHS        
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * CALCULATE THE IMAGE PURGE DATE : PURGE_DT PLUS 18 MONTHS.      *        
      *----------------------------------------------------------------*        
       7750-GET-IMAGE-PURGEDT.                                          
      *----------------------*                                                  
           MOVE '7750'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( MONTH, -18, IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) ) )
            INTO
              :WS-IMAGE-DATE 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-IMAGE-DATE = DATE (:BI-DATE-BILLED) - 18 MONTHS         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING TIMESTAMP      ** '              
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES                TO WS-ERR-MSG2                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT TRANS SEQUENCE NUMBER FOR BI-ACCOUNT NO AND BI-BILLED-DT*        
      *----------------------------------------------------------------*        
       7775-GET-TRANS-SEQNO.                                            
      *------------------------*                                                
           MOVE '7775'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                                   
               INTO :AR-TRANS-HIST-SEQ-NO                               
              FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO     =  :BI-ACCOUNT-NO                    
                AND DATE_TRANS     =  IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )                   
                AND CODE_TRAN_TYPE = 'B'                                
A03673                                              
                                                                 
A03673                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT TRANS_HIST_SEQ_NO                                           
MFA-TR*        INTO :AR-TRANS-HIST-SEQ-NO                                       
MFA-TR*       FROM CSS_AR_TRANS_HIST                                            
MFA-TR*       WHERE ACCOUNT_NO     =  :BI-ACCOUNT-NO                            
MFA-TR*         AND DATE_TRANS     =  :BI-DATE-BILLED                           
MFA-TR*         AND CODE_TRAN_TYPE = 'B'                                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7775                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
A03673     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
A03673        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A03673           MOVE BI-DATE-BILLED  TO WS-TRANS-HIST-SEQ-NO-DT        
A03673           MOVE WS-TRANS-HIST-SEQ-NO TO AR-TRANS-HIST-SEQ-NO      
A03673        ELSE                                                      
A03673           STRING ' ERROR SELECTING TRANS_HIST_SEQ_NO FROM'       
A03673                  ' CSS_AR_TRANS_HIST **'                         
A03673                   DELIMITED BY SIZE INTO WS-ERR-MSG              
A03673           STRING ' AR.ACCOUNT_NO = ' WS-DISP-ACCOUNT-NO          
A03673                  ',AR.DATE_TRANS = ' BI-DATE-BILLED              
A03673                   DELIMITED BY SIZE INTO WS-ERR-MSG2             
A03673           PERFORM 8800-DIS-TABLE-ERROR                           
A03673                   THRU 8800-EXIT                                 
           END-IF
           END-IF                                                       
           .                                                            
       7775-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECT CURRENT TIMESTAMP - 25 MONTHS                           *        
      *----------------------------------------------------------------*        
       7800-SELECT-TIMESTAMP.                                           
      *----------------------*                                                  
           MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, -25, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-TIMESTAMP  = CURRENT TIMESTAMP - 25 MONTHS              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING TIMESTAMP      ** '              
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              MOVE SPACES                TO WS-ERR-MSG2                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 7850-LAST-RUN-TIME-STAMP                                                
      *----------------------------------------------------------------*        
      *                                                                         
       7850-LAST-RUN-TIME-STAMP.                                        
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-RUN-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-RUN-DATE = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSXP000 ABORT  ************'         
              DISPLAY '* 7850-LAST-RUN-TIME-STAMP            *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSXP000  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
            EXIT.                                                       
      *----------------------------------------------------------------*        
      * INSERT CSS_BILLING_HDR TABLE ROWS INTO CSS_CIS_PURGE TABLE     *        
      *----------------------------------------------------------------*        
       7900-INSERT-PURGE-TBL.                                           
      *---------------------*                                                   
           MOVE '7900'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CIS_PURGE                                  
                    (ACCOUNT_NO                                         
                    ,PURGE_TYPE_CD                                      
                    ,PURGE_DT                                           
                    ,PURGE_TS                                           
                    ,LAST_UPDATE_TS                                     
                    ,BILL_NO                                            
                    ,IMAGE_PURGE_DT)                                    
             VALUES (:BI-ACCOUNT-NO                                     
                    ,'B'                                                
                    ,IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )                              
                    ,CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO)                  
                    ,CIS.CURRENT$TIMESTAMP()                                  
                    ,:BI-BILL-NO                                        
                    ,IIF(TRY_CONVERT(DATE, :WS-IMAGE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-IMAGE-DATE
              ) <> 0) OR (LEN(:WS-IMAGE-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-IMAGE-DATE
              ), CONVERT(DATE, :WS-IMAGE-DATE) ))                              
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CIS_PURGE                                          
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,PURGE_TYPE_CD                                              
MFA-TR*             ,PURGE_DT                                                   
MFA-TR*             ,PURGE_TS                                                   
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,IMAGE_PURGE_DT)                                            
MFA-TR*      VALUES (:BI-ACCOUNT-NO                                             
MFA-TR*             ,'B'                                                        
MFA-TR*             ,:BI-DATE-BILLED                                            
MFA-TR*             ,:AR-TRANS-HIST-SEQ-NO                                      
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,:BI-BILL-NO                                                
MFA-TR*             ,:WS-IMAGE-DATE)                                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD 1 TO WS-BILL-ACCT-CNT-INS                          
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR INSERTING CSS_CIS_PURGE  ** '              
                       DELIMITED BY SIZE INTO WS-ERR-MSG                
              STRING ' BI.ACCOUNT_NO = '  WS-DISP-ACCOUNT-NO            
                     ',BI.BILL_NO    = '  WS-BILL-NO                    
                     ',PURGE_DATE    = '  BI-DATE-BILLED                
                     ',PURGE_TS      = '  AR-TRANS-HIST-SEQ-NO          
                     ',IMAGE_PURGE_DT = ' WS-IMAGE-DATE                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 7950-UPDATE-PURGE-TBL                                          *        
      *----------------------------------------------------------------*        
       7950-UPDATE-PURGE-TBL.                                           
      *----------------------*                                                  
           MOVE '7950'                         TO WS-ACTIVE-PARAGRAPH   
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_CIS_PURGE                                    
                   SET PURGE_TYPE_CD   =  'B'                           
                      ,PURGE_DT        =  IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )               
                      ,PURGE_TS        =  CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                      ,LAST_UPDATE_TS  =  CIS.CURRENT$TIMESTAMP()             
                      ,BILL_NO         =  :BI-BILL-NO                   
                      ,IMAGE_PURGE_DT  =  IIF(TRY_CONVERT(DATE, 
                                                         :WS-IMAGE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-IMAGE-DATE
              ) <> 0) OR (LEN(:WS-IMAGE-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-IMAGE-DATE
              ), CONVERT(DATE, :WS-IMAGE-DATE) )                
                 WHERE ACCOUNT_NO      =  :BI-ACCOUNT-NO                
                   AND PURGE_TYPE_CD   =  'B'                           
                   AND PURGE_DT        <> IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )               
                   AND BILL_NO         <> :BI-BILL-NO                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_CIS_PURGE                                            
MFA-TR*            SET PURGE_TYPE_CD   =  'B'                                   
MFA-TR*               ,PURGE_DT        =  :BI-DATE-BILLED                       
MFA-TR*               ,PURGE_TS        =  :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*               ,LAST_UPDATE_TS  =  CURRENT TIMESTAMP                     
MFA-TR*               ,BILL_NO         =  :BI-BILL-NO                           
MFA-TR*               ,IMAGE_PURGE_DT  =  :WS-IMAGE-DATE                        
MFA-TR*          WHERE ACCOUNT_NO      =  :BI-ACCOUNT-NO                        
MFA-TR*            AND PURGE_TYPE_CD   =  'B'                                   
MFA-TR*            AND PURGE_DT        <> :BI-DATE-BILLED                       
MFA-TR*            AND BILL_NO         <> :BI-BILL-NO                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  ADD 1 TO WS-BILL-ACCT-CNT-UPD                         
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR IN UPDATING CSS_CIS_PURGE ** '             
                       DELIMITED BY SIZE     INTO WS-ERR-MSG            
              STRING ' BI.ACCOUNT_NO = '  WS-DISP-ACCOUNT-NO            
                     ',BI.BILL_NO    = '  WS-BILL-NO                    
                     ',PURGE_DATE    = '  BI-DATE-BILLED                
                     ',PURGE_TS      = '  AR-TRANS-HIST-SEQ-NO          
                     ',IMAGE_PURGE_DT = ' WS-IMAGE-DATE                 
                       DELIMITED BY SIZE INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7950-EXIT.                                                       
           EXIT.                                                        
      *----------------------------------------------------------------*        
      * 8100-PURGE-DELETE.                                             *        
      *----------------------------------------------------------------*        
       8100-PURGE-DELETE.                                               
      *----------------------*                                                  
                                                                        
           MOVE '8100'                         TO WS-ACTIVE-PARAGRAPH   
                                                                        
           EXEC SQL                                                     
                DELETE FROM  CSS_CIS_PURGE                              
                   WHERE ACCOUNT_NO = :PU-ACCOUNT-NO                    
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                TO WS-DEL-ACCT-TOTAL                
           ELSE                                                         
              STRING ' ERROR IN DELETE CSS_CIS_PURGE ** '               
                       DELIMITED BY SIZE     INTO WS-ERR-MSG            
              MOVE SPACES                      TO WS-ERR-MSG2           
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8200-UPDATE-LAST-RUN-DATE                                     *         
      *****************************************************************         
       8200-UPDATE-LAST-RUN-DATE.                                       
      *                                                                         
           EXEC SQL                                                     
                                                                        
               UPDATE CSS_JOB_PARM                                      
                  SET PARM_DATA    = :G6-PARM-DATA                      
                WHERE CMND_CODE    = 'DATE'                             
                  AND COMPANY_NO   = '01'                               
                  AND PROGRAM_NAME = :WS-PGRMNAME                       
                  AND STATUS       = 'A'                                
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSXP000 ABORT **************'        
              DISPLAY '*     8200-UPDATE-LAST-RUN-DATE        *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM NAME   : ' WS-PGRMNAME                 
              DISPLAY '* PARM DATA      : ' G6-PARM-DATA                
              DISPLAY'* WS-PGM-LAST-RUN-DATE = ' WS-PGM-LAST-RUN-DATE   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '****************************************'        
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *----------------------------------------------------------------*        
      * DISPLAY ERRORS                                                 *        
      *----------------------------------------------------------------*        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'     
           DISPLAY '**     PCSXP000  PROCESSING ERROR           **'     
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE        **'     
           DISPLAY '**********************************************'     
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH        
           DISPLAY '**' WS-ERR-MSG                                      
           DISPLAY '**' WS-ERR-MSG2                                     
           DISPLAY '** SQL STATUS  = ' WS-ACTIVE-RETURN-CODE            
           DISPLAY '**       PROCESSING TERMINATED              **'     
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT                                            
           .                                                            
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *---------------------------------------------------------------*         
      * COMMIT DB2                                                    *         
      *---------------------------------------------------------------*         
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC                                                             
           .                                                                    
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DISPLAY MESSAGES                                               *        
      *----------------------------------------------------------------*        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           DISPLAY 'TOT.# COMMITS FOR INSERT/UPDATE ACCTS: '            
                                                 WS-COMMIT-NO           
                                                                        
           DISPLAY 'TOT.# COMMITS FOR DELETED ACCTS      : '            
                                                 WS-COMMIT-NO-DEL       
                                                                        
           DISPLAY 'TOTAL NO OF ACCOUNTS SELECTED           = '         
                   WS-ACCT-TOTAL                                        
           DISPLAY 'ACCOUNTS INSERTED INTO CSS_CIS_PURGE    = '         
                   WS-BILL-ACCT-CNT-INS                                 
           DISPLAY 'ACCOUNTS UPDATED  INTO CSS_CIS_PURGE    = '         
                   WS-BILL-ACCT-CNT-UPD                                 
           DISPLAY 'ACCOUNTS DELETED  FROM CSS_CIS_PURGE    = '         
                   WS-DEL-ACCT-TOTAL                                    
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PERFORM ABEND USING 9900-ABEND PARAGRAPH                                
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
