       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSWQ201.                                            
       AUTHOR. COVANSYS.                                                
       DATE-WRITTEN. JUL-2003.                                          
                                                                        
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS              REASON                 **         
      **     09/16/03   VC91250  INITIAL PROGRAM VERSION             **         
T35434**     06/02/07   MK92804  REPLACED MODEL_SQL WITH SET COMMAND **         
A01360**     03/09/11   MH94819  CHANGED SUBJECT FOR SEB REGION,ZERO **         
A01360**                         SUPPRESSION AND MESG CONTENTS       **         
A03352**     05/22/12   MH94819  CHANGES FOR WQ OVERDUE MAIL TO LOOK **         
A03352**                         AT DATE ASSIGEND AND DATE CREATED   **         
A05460**     05/24/16   MS7M727  CHANGED SUBJECT FOR SEB REGION,     **         
A05460**                ACT180   CSR REGION.ADD REQUIRED DATE IN MSG **         
A05460**                         AND REMOVE SUBMODULES CSR01004 AND  **         
A05460**                         CSR00424                            **         
A05460**     10/03/16   MC95456  ACT290 - CORRECTED THE MESSAGE.     **         
      *****************************************************************         
             REMARKS.                                                   
      *****************************************************************         
      **                       PROGRAM SUMMARY                       **         
      **                                                             **         
      ** THIS PROGRAM WILL CHECK THE NUMBER OF WORK QUEUE ITEMS      **         
      ** PENDING FOR EACH USER AND SENDS AN EMAIL TO EACH USER       **         
      **                                                             **         
      *****************************************************************         
                                                                        
      *****************************************************************         
      **          ---- BASIC SEQUENCE STRUCTURE ----                 **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **         
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*         
      **                                                             **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT JCLFILE  ASSIGN TO UT-S-JCLFILE                       
           FILE STATUS      IS WS-JCLFILE-STATUS.                       
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  JCLFILE                                                      
           RECORD CONTAINS 80 CHARACTERS                                
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD                                   
           DATA RECORD IS JCL-REC.                                      
                                                                        
       01  JCL-REC                       PIC X(80).                     
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSWQ201'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                      PIC X(40)    VALUE             
           'WORKING STORAGE FOR PCSWQ201 STARTS HERE'.                  
                                                                        
       01  WS-LITERALS-SWITCHES.                                        
           05  WS-PGRMNAME               PIC X(08)    VALUE 'PCSWQ201'. 
                                                                        
       01  WS-SWITCHES.                                                 
           05  EMSG-OUT-STATUS           PIC X(02)    VALUE ZEROS.      
               88 EMSG-OUT-STATUS-OK                  VALUE '00'.       
               88 EMSG-OUT-STATUS-EOF                 VALUE '10'.       
                                                                        
           05  WS-END-RECORD             PIC X(01)    VALUE 'N'.        
               88 END-DATA                            VALUE 'Y'.        
               88 NOT-END-DATA                        VALUE 'N'.        
                                                                        
       01 WS-FILE-ERROR-MESS.                                           
           05 WS-ERR-FILE-STATUS         PIC X(02)    VALUE SPACES.     
           05 WS-ERR-PARA-NAME           PIC X(40)    VALUE SPACES.     
           05 WS-ERR-FILE-NAME           PIC X(25)    VALUE SPACES.     
           05 WS-ERR-FILE-OPERATION      PIC X(10)    VALUE SPACES.     
                                                                        
       01  WS-NUM-BUSI-DAY-SPLIT.                                       
           05  WS-NUM-BUSI-DAY-DATA.                                    
               10  WS-NUM-BUSI-DAY-TEXT  PIC X(23).                     
               10  WS-NUM-BUSI-DAY-NUM   PIC 9(04).                     
A03352         10  WS-ADDL-BUS-DAY-TXT   PIC x(05).                     
A03352         10  WS-ADDL-BUS-DAY-NUM   PIC 9(04).                     
A03352     05  FILLER                    PIC X(44).                     
                                                                        
       01  WS-MISC.                                                     
           05  WS-ERR-MSG                PIC X(40)    VALUE SPACES.     
ACT180     05  PROGRAM-NAME              PIC X(10) VALUE 'PCSWQ201'.    
ACT180     05  RS-RETURN-CODE            PIC S9(04) COMP VALUE 0.       
ACT180     05  RS-RETURN-CODE-DISP       PIC S9(04) COMP VALUE 0.       
           05  WS-DISP-RC                PIC -ZZZZZZZZ9.                
           05  TABLE-SUB                 PIC S9(04)   COMP VALUE +0.    
A01360     05  WQ-COUNT-OF               PIC S9(05)   COMP VALUE +0.    
           05  WS-CURR-DATE              PIC X(26)    VALUE SPACES.     
           05  WS-BISNES-DAYS            PIC S9(04)   COMP.             
A03352     05  WS-BISNES-DAYS-2          PIC S9(04)   COMP.             
           05  WS-RETURN-CODE            PIC S9(09)   COMP VALUE +0.    
           05  WS-CALL-RETURN-CODE       PIC S9(09)   COMP VALUE +0.    
           05  WS-OUTPUT-DATE            PIC X(26)    VALUE SPACES.     
A03352     05  WS-OUTPUT-DATE-2          PIC X(26)    VALUE SPACES.     
ACT180     05  WS-DATE-REQUIRED          PIC X(26)    VALUE SPACES.     
           05  WS-CNTR                   PIC 9(09)    VALUE ZERO.       
           05  WS-CSR-USER               PIC X(07)    VALUE 'CSR    '.  
           05  WS-SEB-USER               PIC X(07)    VALUE 'SEB    '.  
           05  WS-CSR-PRGNAME            PIC X(08)    VALUE 'CSRQ201D'. 
           05  WS-SEB-PRGNAME            PIC X(08)    VALUE 'SEBQ201D'. 
           05  WS-CSR-PRGNM              PIC X(07)    VALUE 'CSRQ201'.  
           05  WS-SEB-PRGNM              PIC X(07)    VALUE 'SEBQ201'.  
                                                                        
           05 WS-JCLFILE-STATUS          PIC X(02).                     
               88 JCLFILE-SUCCESS                     VALUE '00'.       
                                                                        
ACT180 01  WS-JCL-DATE-REQUIRED.                                        
ACT180     05  WS-MM                     PIC X(02)    VALUE SPACES.     
ACT180     05  FILLER                    PIC X(01)    VALUE '/'.        
ACT180     05  WS-DD                     PIC X(02)    VALUE SPACES.     
ACT180     05  FILLER                    PIC X(01)    VALUE '/'.        
ACT180     05  WS-YEAR                   PIC X(04)    VALUE SPACES.     
                                                                        
      *01 LOC-RESLTSET  USAGE SQL TYPE IS                               
      *                 RESULT-SET-LOCATOR VARYING.                     
                                                                        
      ****************************************************************          
      ** THE FOLLOWING WORKING STORAGE ENTRIES ARE USED TO BUILD    **          
      ** THE JCL IN THE OUTPUT DATASET.                             **          
      ****************************************************************          
                                                                        
       01  WS-JOB-CARD1.                                                
           03  FILLER                    PIC X(2)     VALUE '//'.       
           03  WS-JOBNAME                PIC X(8)     VALUE SPACES.     
           03  FILLER                    PIC X(32)    VALUE             
               ' JOB (3230,555),''DOWNLOADS WQS'','.                    
           03  FILLER                    PIC X(38)    VALUE SPACES.     
       01  WS-JOB-CARD2.                                                
           03  FILLER                    PIC X(15)    VALUE '//'.       
           03  FILLER                    PIC X(65)    VALUE             
               'MSGCLASS=U,CLASS=A,'.                                   
       01  WS-JOB-CARD3.                                                
           03  FILLER                    PIC X(15)    VALUE '//'.       
           03  FILLER                    PIC X(5)     VALUE 'USER='.    
           03  WS-USER                   PIC X(07)    VALUE SPACES.     
           03  FILLER                    PIC X(52)    VALUE SPACES.     
       01  WS-COMMENT-CARD1.                                            
           03  FILLER                    PIC X(02)    VALUE '/*'.       
           03  FILLER                    PIC X(78)    VALUE SPACES.     
       01  WS-COMMENT-1.                                                
           03  FILLER                    PIC X(03)    VALUE '//*'.      
           03  WS-PRG-NAME               PIC X(08)    VALUE SPACES.     
           03  FILLER                    PIC X(37)    VALUE             
              ' -A D1 D- BODY OF THE EMAILS SENT BY '.                  
           03  WS-PRG-NM                 PIC X(07)    VALUE SPACES.     
           03  FILLER                    PIC X(25)    VALUE SPACES.     
       01  WS-STEP-CARD1.                                               
           03  FILLER                    PIC X(28)    VALUE             
               '//STEP1    EXEC PGM=IEBGENER'.                          
           03  FILLER                    PIC X(52)    VALUE SPACES.     
       01  WS-SYSPRINT-CARD1.                                           
           03  FILLER                    PIC X(22)    VALUE             
               '//SYSPRINT DD SYSOUT=$'.                                
           03  FILLER                    PIC X(46)    VALUE SPACES.     
       01  WS-SYSUT-CARD1.                                              
           03  FILLER                    PIC X(15)    VALUE             
               '//SYSUT1   DD *'.                                       
           03  FILLER                    PIC X(65)    VALUE SPACES.     
       01  WS-SYSUT-CARD2.                                              
           03  FILLER                    PIC X(29)    VALUE             
               '//SYSUT2   DD SYSOUT=(B,SMTP)'.                         
           03  FILLER                    PIC X(51)    VALUE SPACES.     
       01  WS-SYSIN-CARD1.                                              
           03  FILLER                    PIC X(19)    VALUE             
               '//SYSIN    DD DUMMY'.                                   
           03  FILLER                    PIC X(61)    VALUE SPACES.     
       01  WS-MESSAGE-CARD1.                                            
           03  FILLER                    PIC X(17)    VALUE             
               'HELO DOMAIN:SCANA'.                                     
       01  WS-MESSAGE-CARD2.                                            
           03  FILLER                    PIC X(33)    VALUE             
               'MAIL FROM: <CSRWQADMIN@SCANA.COM>'.                     
A01360 01  WS-MESSAGE-CARD21.                                           
A01360     03  FILLER                    PIC X(33)    VALUE             
A01360         'MAIL FROM: <SEBWQADMIN@SCANA.COM>'.                     
       01  WS-MESSAGE-CARD3.                                            
           03  FILLER                    PIC X(10)    VALUE             
               'RCPT TO: <'.                                            
           03  WS-USERID-1               PIC X(07).                     
           03  FILLER                    PIC X(11)    VALUE             
               '@SCANA.COM>'.                                           
           03  FILLER                    PIC X(52)    VALUE SPACES.     
       01  WS-MESSAGE-CARD4.                                            
           03  FILLER                    PIC X(04)    VALUE             
               'DATA'.                                                  
       01  WS-MESSAGE-CARD5.                                            
           03  FILLER                    PIC X(40)    VALUE             
               'FROM: CSR WQADMIN <CSRWQADMIN@SCANA.COM>'.              
AO1360 01  WS-MESSAGE-CARD51.                                           
A01360     03  FILLER                    PIC X(40)    VALUE             
A01360         'FROM: SEB WQADMIN <SEBWQADMIN@SCANA.COM>'.              
       01  WS-MESSAGE-CARD6.                                            
           03  FILLER                    PIC X(07)    VALUE             
               'TO:   <'.                                               
           03  WS-USERID-2               PIC X(07).                     
           03  FILLER                    PIC X(11)    VALUE             
               '@SCANA.COM>'.                                           
           03  FILLER                    PIC X(55)    VALUE SPACES.     
       01  WS-MESSAGE-CARD7.                                            
           03  FILLER                    PIC X(51)    VALUE             
               'SUBJECT: TASK(S) OVERDUE NOTIFICATION - CSRP Region'.   
A01360 01  WS-MESSAGE-CARD71.                                           
A01360     03  FILLER                    PIC X(51)    VALUE             
A01360         'SUBJECT: TASK(S) OVERDUE NOTIFICATION - SEBP Region'.   
       01  WS-MESSAGE-CARD8.                                            
           03  FILLER                    PIC X(36)    VALUE             
               'This is to notify you that you have '.                  
A01360     03  WS-WQ-COUNT               PIC 99999.                     
A01360     03  FILLER                    PIC X(31)    VALUE             
A01360         ' CIS Task(s) that are now more '.                       
       01  WS-MESSAGE-CARD9.                                            
A01360     03  FILLER                    PIC X(05)    VALUE             
A01360         'than '.                                                 
A01360     03  WS-BUSS-DAYS              PIC 9999.                      
A01360     03  FILLER                    PIC X(06)    VALUE             
A01360         ' days '.                                                
A01360     03  FILLER                    PIC X(04)    VALUE             
A01360         'old '.                                                  
ACT180     03  FILLER                    PIC X(25)    VALUE             
ACT180         'with oldest task date as '.                             
ACT180     03  WS-JCL-DATE-REQUIRED1     PIC X(10)    VALUE SPACES.     
ACT180     03  FILLER                    PIC X(01)    VALUE SPACES.     
ACT180     03  FILLER                    PIC X(22)    value             
ACT180         'Please try to address '.                                
       01  WS-MESSAGE-CARD10.                                           
A01360     03  FILLER                    PIC X(53)    VALUE                     
ACT290-        'these Task(s) at your earliest convenience via Tasks.'.         
                                                                        
       01  WS-MESSAGE-CARD11.                                           
           03  FILLER                    PIC X(55)    VALUE             
              'This message was generated automatically, please do not'.
       01  WS-MESSAGE-CARD12.                                           
           03  FILLER                    PIC X(08)    VALUE             
              'respond.'.                                               
       01  WS-BLANK-LINE.                                               
           03  FILLER                    PIC X(80)    VALUE SPACES.     
       01  WS-TERM-CARD1.                                               
           03  FILLER                    PIC X(80)    VALUE '//'.       
                                                                        
      *****************************************************************         
      **   COMMON COPYBOOK FOR WS-VARIABLES                          **         
      *****************************************************************         
                                                                        
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00010.                                                           
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      **   SQL COMMUNICATION AREA                                    **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
ACT180*****************************************************************         
      **   WS FOR PROCESSING JOB_PARM                                **         
      *****************************************************************         
                                                                        
       COPY CWS00038.                                                           
                                                                        
ACT180******************************************************************        
ACT180* CSS_BUSINESS_DAYS  - 1G                                        *        
ACT180******************************************************************        
ACT180*                                                                         
ACT180     EXEC SQL                                                             
ACT180         INCLUDE TBBUSDAY                                                 
ACT180     END-EXEC.                                                            
ACT180*                                                                         
      *****************************************************************         
      **   CSS_WQ_ITEMS                                              **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      **   CSS_JOB_PARM                                              **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
ACT180     EXEC SQL                                                             
ACT180        INCLUDE CWS00322                                                  
ACT180     END-EXEC.                                                            
                                                                        
       01  WS-END                        PIC X(40)    VALUE             
             'WORKING STORAGE FOR PCSWQ201 ENDS HERE  '.                
                                                                        
ACT180     EXEC SQL                                                     
ACT180       DECLARE WQ_ITEMS_USER_CUR CURSOR FOR                       
ACT180        SELECT USER_ID_ASGN                                       
ACT180              ,COUNT(*) AS COUNT_OF                               
ACT180          FROM CSS_WQ_ITEMS WITH(READUNCOMMITTED)                         
ACT180         WHERE (DATE_REQUIRED < CIS.CHAR2TIMESTAMP(:WS-OUTPUT-DATE
              )                   
ACT180            OR DATE_CREATED   < CIS.CHAR2TIMESTAMP(
                                                      :WS-OUTPUT-DATE-2
              ) )               
ACT180           AND (STATUS = 'A' OR STATUS = 'I' OR  STATUS = '*' )   
ACT180         GROUP BY USER_ID_ASGN                                    
ACT180           FOR READ ONLY                                         
ACT180                                                           
ACT180                                                      
ACT180     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE WQ_ITEMS_USER_CUR CURSOR FOR                               
MFA-TR*       SELECT USER_ID_ASGN                                               
MFA-TR*             ,COUNT(*) AS COUNT_OF                                       
MFA-TR*         FROM CSS_WQ_ITEMS                                               
MFA-TR*        WHERE (DATE_REQUIRED < :WS-OUTPUT-DATE                           
MFA-TR*           OR DATE_CREATED   < :WS-OUTPUT-DATE-2 )                       
MFA-TR*          AND (STATUS = 'A' OR STATUS = 'I' OR  STATUS = '*' )           
MFA-TR*        GROUP BY USER_ID_ASGN                                            
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LS-PARM.                                                     
          05  LS-PARMLEN                 PIC S9(03)   COMP.             
          05  LS-PARMTXT                 PIC X(03).                     
                                                                        
      *****************************************************************         
      **   0000-MAINLINE.                                            **         
      **   CONTROLS MAIN PATH OF PROGRAM                             **         
      *****************************************************************         
                                                                        
       PROCEDURE DIVISION USING LS-PARM.                                
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PARA  THRU 0100-EXIT.                
                                                                        
           PERFORM 1000-PROCESS-PARA     THRU 1000-EXIT.                
                                                                        
           PERFORM 9000-TERMINATE        THRU 9000-EXIT.                
                                                                        
           DISPLAY 'PROGRAM ENDED SUCCESSFULLY'.                        
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   0100-INITIALIZATION.                                      **         
      **        INITIALIZATION ROUTINE                               **         
      *****************************************************************         
                                                                        
       0100-INITIALIZE-PARA.                                            
                                                                        
           DISPLAY 'PROGRAM EXECUTION STARTED'.                         
                                                                        
           INITIALIZE WS-NUM-BUSI-DAY-SPLIT.                            
                                                                        
           OPEN OUTPUT JCLFILE.                                         
                                                                        
           IF WS-JCLFILE-STATUS NOT = '00'                              
               DISPLAY 'ERROR OCCURED WHILE OPENING JCLFILE'            
                                         WS-JCLFILE-STATUS              
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING JCLFILE FILE'                
               DISPLAY '**   FILE STATUS = ' WS-JCLFILE-STATUS          
               DISPLAY '**************************************'         
               MOVE 12                   TO   RETURN-CODE               
               PERFORM 9900-ABEND        THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
           PERFORM 0120-PROCESS-REGION   THRU 0120-EXIT.                
                                                                        
           PERFORM 7000-SELECT-CURR-TIMESTAMP THRU 7000-EXIT.           
                                                                        
           PERFORM 0110-NUM-BUSINESS-DAY      THRU 0110-EXIT.           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   0110-NUM-BUSINESS-DAY                                     **         
      **   GET THE NO. OF BUSINESS DAYS FROM CSS_JOB_PARM TABLE      **         
      *****************************************************************         
                                                                        
       0110-NUM-BUSINESS-DAY.                                           
                                                                        
           MOVE SPACES                   TO   WS-SYSIPT.                
           MOVE WS-PGRMNAME              TO   WS-PROGRAM.               
           MOVE WS-PARM                  TO   WS-COMMAND.               
           MOVE +1                       TO   WS-SEQUENCE.              
                                                                        
           PERFORM 7600-START-FCSJC01    THRU  7600-EXIT.               
                                                                        
           PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT                
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:23) =                   
                      'NO OF BUSINESS DAYS IS ' AND INPUT-ACTIVE)       
                  OR  END-OF-SYSIPT.                                    
                                                                        
           MOVE G6-PARM-DATA             TO   WS-NUM-BUSI-DAY-DATA      
           MOVE WS-NUM-BUSI-DAY-NUM      TO   WS-BISNES-DAYS            
A03352     MOVE WS-ADDL-BUS-DAY-NUM      TO   WS-BISNES-DAYS-2          
                                                                        
           IF END-OF-SYSIPT OR WS-NUM-BUSI-DAY-NUM  NOT NUMERIC         
              DISPLAY '** 0110-NUM-BUSINESS-DAY            **'          
              DISPLAY '** PCSWQ201 PROCESSING ERROR        **'          
              DISPLAY '** NO OF BUSINESS DAY NOT AVAILABLE **'          
              DISPLAY '** PROCESSING TERMINATED            **'          
              PERFORM 7611-CLOSE         THRU  7611-EXIT                
              PERFORM 9900-ABEND         THRU  9900-EXIT                
           END-IF.                                                      
                                                                        
           DISPLAY 'NO. OF BUSINESS DAYS FOR REQUIRED DATE FROM JOB PARM        
      -    ' TABLE = ' WS-BISNES-DAYS.                                          
                                                                        
           DISPLAY 'NO. OF BUSINESS DAYS FOR CREATED  DATE FROM JOB PARM        
      -    ' TABLE = ' WS-BISNES-DAYS-2.                                        
                                                                        
           DISPLAY '**************************************************'.
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   0120-PROCESS-REGION                                       **         
      **   MOVES THE JCL PARM DETAILS BASED ON THE REGION            **         
      *****************************************************************         
                                                                        
       0120-PROCESS-REGION.                                             
                                                                        
           MOVE '0120'                   TO   WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF LS-PARMTXT = 'CSR'                                        
               MOVE  WS-CSR-USER         TO   WS-USER                   
               MOVE  WS-CSR-PRGNAME      TO   WS-JOBNAME                
                                              WS-PRG-NAME               
               MOVE  WS-CSR-PRGNM        TO   WS-PRG-NM                 
           ELSE                                                         
               IF LS-PARMTXT = 'SEB'                                    
                   MOVE  WS-SEB-USER        TO   WS-USER                
                   MOVE  WS-SEB-PRGNAME     TO   WS-JOBNAME             
                                                 WS-PRG-NAME            
                   MOVE  WS-SEB-PRGNM       TO   WS-PRG-NM              
A01360             MOVE  WS-MESSAGE-CARD21  TO   WS-MESSAGE-CARD2       
A01360             MOVE  WS-MESSAGE-CARD51  TO   WS-MESSAGE-CARD5       
A01360             MOVE  WS-MESSAGE-CARD71  TO   WS-MESSAGE-CARD7       
               ELSE                                                     
                   DISPLAY '**   PROCESSING ERROR IN PCSWQ201  **'      
                   DISPLAY '**   JCL PARM IS NOT AVAILABLE     **'      
                   DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH        
                   DISPLAY '**   ABENDING PROGRAM              **'      
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
                                                                        
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   1000-MAIN-PROCESS-PARA                                    **         
      **        MAIN PROCESS BEGINS HERE                             **         
      *****************************************************************         
                                                                        
       1000-PROCESS-PARA.                                               
                                                                        
A03352     MOVE WS-BISNES-DAYS-2 TO WS-BISNES-DAYS                      
           PERFORM 2000-GET-BUSINESS-DAY-PARA                           
                                         THRU  2000-EXIT.               
A03352     MOVE WS-OUTPUT-DATE  TO WS-OUTPUT-DATE-2                     
A03352                                                                  
A03352     MOVE WS-NUM-BUSI-DAY-NUM TO WS-BISNES-DAYS                   
A03352     PERFORM 2000-GET-BUSINESS-DAY-PARA                           
                                         THRU  2000-EXIT.               
           PERFORM 2100-GET-WQITEMS-PARA                                
                                         THRU  2100-EXIT.               
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   2000-GET-BUSINESS-DAY-PARA                                **         
      **   CALLS DB2 STORED PROCEDURE TO GET THE OUTPUT DATE         **         
      *****************************************************************         
                                                                        
       2000-GET-BUSINESS-DAY-PARA.                                      
                                                                        
           MOVE '2000'                   TO   WS-ACTIVE-PARAGRAPH.      
                                                                        
ACT180     MOVE WS-CURR-DATE(1:10)       TO WS-NEW-BUSINESS-DAY.        
ACT180     MOVE WS-BISNES-DAYS           TO WS-NO-OF-DAY.               
ACT180     PERFORM 6525-PREV-BUSINESS-DAY THRU                          
ACT180                              6525-PREV-BUSINESS-DAY-EXIT.        
ACT180     MOVE WS-NEW-BUSINESS-DAY      TO WS-OUTPUT-DATE.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   2100-GET-WQITEMS-PARA                                     **         
      **   GETS THE NUMBER OF WORK QUEUE ITEMS FROM CSS_WS_ITEMS     **         
      **   TABLE USING CURSOR                                        **         
      *****************************************************************         
                                                                        
       2100-GET-WQITEMS-PARA.                                           
                                                                        
ACT180     PERFORM 7100-OPEN-WQ-IEMS-CURR      THRU 7100-EXIT.          
ACT180                                                                  
ACT180     PERFORM 5100-PROCESS-WQ-ITEMS-CUR   THRU 5100-EXIT.          
ACT180                                                                  
           PERFORM 7300-CLOSE-WQ-ITEM-USER-CUR THRU 7300-EXIT.          
                                                                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT180*****************************************************************         
ACT180**   5100-PROCESS-WQ-ITEMS-CUR                                 **         
ACT180*****************************************************************         
ACT180*                                                                         
ACT180 5100-PROCESS-WQ-ITEMS-CUR.                                       
ACT180*                                                                         
ACT180     MOVE '5100'                   TO   WS-ACTIVE-PARAGRAPH.      
ACT180*                                                                         
ACT180     PERFORM 7200-FETCH-WQ-ITEM-USER-CUR                          
ACT180                                         THRU  7200-EXIT.         
ACT180     PERFORM 7400-GET-OLDEST-DATE                                 
ACT180                                         THRU  7400-EXIT.         
           IF END-DATA                                                  
              CONTINUE                                                  
           ELSE                                                         
               WRITE JCL-REC             FROM WS-JOB-CARD1              
               WRITE JCL-REC             FROM WS-JOB-CARD2              
               WRITE JCL-REC             FROM WS-JOB-CARD3              
               WRITE JCL-REC             FROM WS-COMMENT-1              
               PERFORM UNTIL END-DATA                                   
ACT180             MOVE WS-DATE-REQUIRED(1:4)  TO WS-YEAR               
ACT180             MOVE WS-DATE-REQUIRED(6:2)  TO WS-MM                 
ACT180             MOVE WS-DATE-REQUIRED(9:2)  TO WS-DD                 
ACT180             MOVE WS-JCL-DATE-REQUIRED   TO WS-JCL-DATE-REQUIRED1 
                   PERFORM 8000-PREPARE-SEND-MAIL-PARA                  
                                              THRU  8000-EXIT           
                   ADD  1                TO   WS-CNTR                   
ACT180             PERFORM 7200-FETCH-WQ-ITEM-USER-CUR                  
ACT180                                        THRU  7200-EXIT           
ACT180             PERFORM 7400-GET-OLDEST-DATE                         
ACT180                                        THRU  7400-EXIT           
               END-PERFORM                                              
               WRITE JCL-REC             FROM WS-TERM-CARD1             
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT180*****************************************************************         
ACT180**   6525-PREV-BUSINESS-DAY                                    **         
ACT180*****************************************************************         
ACT180*                                                                         
ACT180     EXEC SQL                                                             
ACT180        INCLUDE CPD00322                                                  
ACT180     END-EXEC                                                             
      *                                                                         
      *****************************************************************         
      **   7000-SELECT-CURR-TIMESTAMP                                **         
T35434**   RETRIEVE CURRENT TIMESTAMP                                **         
      *****************************************************************         
                                                                        
       7000-SELECT-CURR-TIMESTAMP.                                      
                                                                        
           MOVE '7000'                   TO   WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURR-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-DATE = CURRENT TIMESTAMP                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO   WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE ' ERROR IN GETTING CURRENT TIMESTAMP'                
                                         TO   WS-ERR-MSG                
              MOVE WS-ACTIVE-RETURN-CODE                                
                                         TO    WS-DISP-RC               
              DISPLAY '**   PROCESSING TERMINATED         **'           
              PERFORM 9100-DISPLAY-ERROR      THRU 9100-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT180*****************************************************************         
ACT180**   7100-OPEN-WQ-IEMS-CURR                                    **         
ACT180*****************************************************************         
ACT180*                                                                         
ACT180 7100-OPEN-WQ-IEMS-CURR.                                          
ACT180*                                                                         
ACT180     MOVE '7100'                   TO   WS-ACTIVE-PARAGRAPH.      
ACT180*                                                                         
ACT180     EXEC SQL                                                     
ACT180         OPEN WQ_ITEMS_USER_CUR                                   
ACT180     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT180*                                                                         
ACT180     MOVE SQLCODE                  TO   WS-ACTIVE-RETURN-CODE.    
ACT180                                                                  
ACT180     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT180        CONTINUE                                                  
ACT180     ELSE                                                         
ACT180        MOVE WS-ACTIVE-RETURN-CODE TO   WS-DISP-RC                
ACT180        PERFORM 9100-DISPLAY-ERROR     THRU 9100-EXIT             
ACT180     END-IF.                                                      
ACT180                                                                  
ACT180 7100-EXIT.                                                       
ACT180     EXIT.                                                        
ACT180                                                                  
ACT180                                                                  
ACT180*****************************************************************         
ACT180** 7200-FETCH-WQ-ITEM-USER-CUR                                 **         
ACT180**   THIS PARAGRAPH FETCHES VALUES FROM THE CURSOR FOR THE     **         
ACT180**   WORK QUEUE ITEMS TABLE                                    **         
ACT180*****************************************************************         
ACT180                                                                  
ACT180 7200-FETCH-WQ-ITEM-USER-CUR.                                     
ACT180                                                                  
ACT180     MOVE '7200'                   TO   WS-ACTIVE-PARAGRAPH.      
                                                                        
           INITIALIZE  WQ-USER-ID-ASGN                                  
                       WQ-COUNT-OF.                                     
                                                                        
           EXEC SQL                                                     
              FETCH WQ_ITEMS_USER_CUR                                   
              INTO  :WQ-USER-ID-ASGN                                    
                   ,:WQ-COUNT-OF                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO   WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
ACT180             CONTINUE                                             
              WHEN NOT-FOUND                                            
                   SET END-DATA          TO    TRUE                     
              WHEN OTHER                                                
                   MOVE ' ERROR IN FETCHING WQITEMS CURSOR'             
                                         TO   WS-ERR-MSG                
                   MOVE WS-ACTIVE-RETURN-CODE                           
                                         TO   WS-DISP-RC                
                   DISPLAY 'INPUT DATE    '                             
                                               WS-OUTPUT-DATE           
                   PERFORM 9100-DISPLAY-ERROR                           
                                              THRU  9100-EXIT           
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT180*****************************************************************         
ACT180**   7300-CLOSE-WQ-ITEM-USER-CUR                               **         
ACT180**   THIS PARAGRAPH CLOSES THE CURSOR FOR THE WORK QUEUE       **         
ACT180**   ITEM TABLE                                                **         
ACT180*****************************************************************         
ACT180                                                                  
ACT180 7300-CLOSE-WQ-ITEM-USER-CUR.                                     
ACT180                                                                  
ACT180     MOVE '7300'                   TO   WS-ACTIVE-PARAGRAPH.      
ACT180                                                                  
ACT180     EXEC SQL                                                     
ACT180        CLOSE WQ_ITEMS_USER_CUR                                   
ACT180     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO   WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE ' ERROR OCCURED WHILE CLOSING THE CURSOR'            
                                         TO   WS-ERR-MSG                
              MOVE WS-ACTIVE-RETURN-CODE                                
                                         TO   WS-DISP-RC                
ACT180        DISPLAY 'OUTPUT DATE '          WS-OUTPUT-DATE            
                                                                        
              PERFORM 9100-DISPLAY-ERROR                                
                                              THRU 9100-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT180*****************************************************************         
ACT180* 7400- GET  OLDEST DATE USING USER ID.                        **         
ACT180*****************************************************************         
ACT180*                                                                         
ACT180 7400-GET-OLDEST-DATE.                                            
ACT180*                                                                         
ACT180     MOVE 7300                     TO WS-ACTIVE-PARAGRAPH.        
ACT180                                                                  
ACT180     EXEC SQL                                                     
ACT180        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           DATE_REQUIRED, 121), ' ', '-'), ':', '.') DATE_REQUIRED             
ACT180          INTO :WS-DATE-REQUIRED                                  
ACT180          FROM CSS_WQ_ITEMS                                       
ACT180         WHERE (DATE_REQUIRED < CIS.CHAR2TIMESTAMP(:WS-OUTPUT-DATE
              )                   
ACT180            OR DATE_CREATED  <  CIS.CHAR2TIMESTAMP(
                                                      :WS-OUTPUT-DATE-2
              ) )               
ACT180           AND (STATUS = 'A' or STATUS = 'I' or  STATUS = '*' )   
ACT180           AND USER_ID_ASGN = :WQ-USER-ID-ASGN                    
ACT180         ORDER BY DATE_REQUIRED ASC                               
ACT180                                              
ACT180     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_REQUIRED                                              
MFA-TR*         INTO :WS-DATE-REQUIRED                                          
MFA-TR*         FROM CSS_WQ_ITEMS                                               
MFA-TR*        WHERE (DATE_REQUIRED < :WS-OUTPUT-DATE                           
MFA-TR*           OR DATE_CREATED  <  :WS-OUTPUT-DATE-2 )                       
MFA-TR*          AND (STATUS = 'A' or STATUS = 'I' or  STATUS = '*' )           
MFA-TR*          AND USER_ID_ASGN = :WQ-USER-ID-ASGN                            
MFA-TR*        ORDER BY DATE_REQUIRED ASC                                       
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT180*                                                                         
ACT180     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT180                                                                  
ACT180     IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
ACT180        CONTINUE                                                  
ACT180     ELSE                                                         
ACT180         DISPLAY '******** PCSWQ210 ABORT ******'                 
ACT180         DISPLAY '**  7400-GET-OLDEST-DATE'                       
ACT180         DISPLAY '**  PARAGRAPH -         ' WS-ACTIVE-PARAGRAPH   
ACT180         DISPLAY '**  USER ID             ' WQ-USER-ID-ASGN       
ACT180         DISPLAY '** SQLCODE            **' WS-ACTIVE-RETURN-CODE 
ACT180         DISPLAY '**  PROCESSING TERMINATED  **'                  
ACT180         PERFORM 9900-ABEND              THRU 9900-EXIT           
ACT180     END-IF.                                                      
ACT180*                                                                         
ACT180 7400-EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 7600- READ THE CSS_JOB_PARM DATABASE TABLE.                  **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      **   8000-PREPARE-SEND-MAIL-PARA                               **         
      **   WRITE INTO AN OUTPUT DATASER TO SEND AN EMAIL TO THE      **         
      **   USER WITH NUMBER OF WORK QUEUE ITEMS PENDING              **         
      *****************************************************************         
                                                                        
       8000-PREPARE-SEND-MAIL-PARA.                                     
                                                                        
           MOVE WQ-USER-ID-ASGN          TO   WS-USERID-1               
                                              WS-USERID-2.              
           MOVE WQ-COUNT-OF              TO   WS-WQ-COUNT.              
           MOVE WS-BISNES-DAYS           TO   WS-BUSS-DAYS.             
                                                                        
           WRITE JCL-REC                 FROM WS-STEP-CARD1.            
           WRITE JCL-REC                 FROM WS-SYSPRINT-CARD1.        
           WRITE JCL-REC                 FROM WS-SYSUT-CARD1.           
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD1.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD2.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD3.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD4.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD5.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD6.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD7.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD8.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD9.         
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD10.        
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD11.        
           WRITE JCL-REC                 FROM WS-MESSAGE-CARD12.        
           WRITE JCL-REC                 FROM WS-SYSUT-CARD2.           
           WRITE JCL-REC                 FROM WS-SYSIN-CARD1.           
           WRITE JCL-REC                 FROM WS-COMMENT-CARD1.         
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   9000-TERMINATE                                            **         
      **   MODULE CLOSES ALL OPEN FILES UTILIZED BY THE PROGRAM.     **         
      *****************************************************************         
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           DISPLAY 'MAILS HAVE BEEN SENT TO ' WS-CNTR ' USERS'.         
                                                                        
           CLOSE JCLFILE.                                               
                                                                        
           IF WS-JCLFILE-STATUS NOT = '00'                              
               DISPLAY 'ERROR OCCURED WHILE CLOSING JCLFILE'            
                                         WS-JCLFILE-STATUS              
               DISPLAY '**************************************'         
               DISPLAY '**   9000-TERMINATE                   '         
               DISPLAY '**   ERROR CLOSING JCLFILE FILE'                
               DISPLAY '**   FILE STATUS = ' WS-JCLFILE-STATUS          
               DISPLAY '**************************************'         
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   9100-DISPLAY-ERROR.                                       **         
      **        DISPLAY ERROR PARA                                   **         
      *****************************************************************         
                                                                        
       9100-DISPLAY-ERROR.                                              
                                                                        
           DISPLAY '**   PROCESSING ERROR IN PCSWQ201  **'.             
           DISPLAY '**  ', WS-ERR-MSG.                                  
           DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
           DISPLAY '**   SQLCODE = ', WS-DISP-RC.                       
           DISPLAY '**   ABENDING PROGRAM              **'.             
           PERFORM 9900-ABEND            THRU 9900-EXIT.                
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT180*****************************************************************         
ACT180* 9700-PROCESS-ABEND.                                                     
ACT180*****************************************************************         
ACT180*                                                                         
ACT180 COPY CPD0023B.                                                           
AC180 *                                                                         
      *****************************************************************         
      **   9900-  THIS INCLUDES THE DB2 SQL ABEND MODULE             **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
