       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSWK112.                                        
       DATE-WRITTEN.   08/09/99.                                        
       DATE-COMPILED.                                                   
       AUTHOR.         CBSI                                             
      ***************************************************************** PCS00050
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **               COMPLETE BUSINESS SOLUTIONS INC.              **         
      **                                                             ** PCS00110
      *********            CUSTOMER SERVICE SYSTEM            *********         
      *********                      DB2                      *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS        REASON                           **         
      ** ========   ========     ====================================**         
T15866**                                                             **         
      ** 08/09/99     CBSI       DEVELOPMENT OF NEW PROGRAM          **         
      **                                                             **         
T23877** 08/28/01     COVANSYS   ADD MULTI-COMPANY LOGIC TO THE      **         
T23877**                         WEATHER TREND CALCULCATIONS         **         
      **                                                             **         
T25407** 10/19/01     SK88120   COPY CLASS 020 TO MISSING CLASSES    **         
      **                        EACH DAY FOR COMPANY 26.             **         
      **                                                             **         
T28883** 05/22/03     COVANSYS  ADDED CODE TO CALCULATE WEATHER      **         
T28883**              INDIA     TREND FOR MAX CYCLE 20 IN CSR & FOR  **         
T28883**                        MAX CYCLE 21 IN SEB                  **         
C35227** 03/22/07     DB41297   PERFORMANCE IMPROVEMENTS/ABEND       **         
C35227**                        REDUCTION.                           **         
T35227**                                                             **         
T35227** 07/22/08     NC94746   PERFORMANCE IMPROVEMENTS & ADDING    **         
T35227**                        ROWSET FUNCTIONALITY                 **         
T35227** 08/11/08     NC94746   NEED TO INCLUDE PRORATE_CD 'P' FOR   **         
T35227**                        SEB ACCOUNTS                         **         
      *****************************************************************         
      **                    PCSWK112   NARRATIVE                     **         
      **    CALCULATE DAILY WEATHER TREND FACTORS FOR ESTIMATION OF  **         
      **    MISSING METER READING:                                   **         
      **                                                             **         
T15866**   THIS PROGRAM IS USED TO UPDATE AND MAINTAIN THE           **         
      **   CSS_WEATHER_TREND TABLE. THE PROGRAM CALCULATES A MEDIAN  **         
      **   RATIO OF THE CURRENT MONTH'S DAILY CONSUMPTION TO THE PREV**         
      **   MONTH'S FOR EACH ACCOUNT WITH ACTUAL USAGE FOR THE TWO    **         
      **   MONTHS IN THE PREVIOUS THREE BILLING CYCLES. THE MEDIAN   **         
      **   RATIO IS CALCULATED FOR ACCTS GROUPED BY THE MIDDLE DIGIT **         
      **   OF THE CODE-REVENUE-CLASS(EXCEPT FOR  ACCOUNTS WITH CODE- **         
      **   REVENUE-CLASS ='910'). THE WEATHER TREND FACTOR FOR EACH  **         
      **   CLASS IS CLACULATED TO BE THE AVERAGE OF THE MEDIAN RATIOS**         
      **   FROM THE PREVIOUS THREE BILLING CYCLE.                    **         
T15866**                                                             **         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
HPCCDM*EJECT                                                            00020000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
       COPY CSSWK112.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDWK112.                                                           
       COPY FIOWK112.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-ACCT-DET  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSWK112'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-INTERVAL-MAX-RANGE-TAB.                                   
           05 WS-INTERVAL-MAX-RANGE-VAL.                                
              10 FILLER                    PIC S9V99 COMP-3 VALUE 0.40. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 0.60. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 0.80. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 1.00. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 1.20. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 1.40. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 1.60. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 1.80. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 2.00. 
              10 FILLER                    PIC S9V99 COMP-3 VALUE 2.20. 
           05 WS-INTERVAL-MAX-RANGE-RED REDEFINES                       
                                       WS-INTERVAL-MAX-RANGE-VAL.       
              10 WS-INTERVAL-MAX-RANGE OCCURS 10 TIMES                  
                                           PIC S9V99 COMP-3.            
      *                                                                         
       01  WS-ELEC-WEATHER-TREND-TAB.                                   
           05 WS-ELEC-BILL-CYCLE-TAB OCCURS 3 TIMES.                    
              10 WS-ELEC-CLASS-TAB  OCCURS 10 TIMES.                    
COB305           15 WS-ELEC-INTERVAL-COUNT        PIC S9(07) 
COB305              OCCURS 11 TIMES COMP-3 VALUE 0.           
      *                                                                         
       01  WS-GAS-WEATHER-TREND-TAB.                                    
           05 WS-GAS-BILL-CYCLE-TAB OCCURS 3 TIMES.                     
              10 WS-GAS-CLASS-TAB  OCCURS 10 TIMES.                     
COB305           15 WS-GAS-INTERVAL-COUNT        PIC S9(07) 
COB305              OCCURS 11 TIMES COMP-3 VALUE 0.           
      *                                                                         
       01  WS-TEST-TREND-TAB.                                           
COB305     05 WS-TEST-INTERVAL-COUNT        PIC S9(07) OCCURS 11 TIMES 
COB305       COMP-3 VALUE 0.           
      *                                                                         
       01  WS-WORK-AREA.                                                
           05 WS-PGRMNAME                  PIC X(08) VALUE              
              'PCSWK112'.                                               
T28883*    05 WS-MAX-CYCLE                 PIC X(02) VALUE '20'.                
T28883     05 WS-MAX-CYCLE                 PIC X(02) VALUE SPACES.      
           05 WS-CL-SUB                    PIC S9(04) COMP VALUE +0.    
           05 WS-IN-SUB                    PIC S9(04) COMP VALUE +0.    
           05 WS-CYC-SUB                   PIC S9(04) COMP VALUE +0.    
           05 WS-CURRENT-BILL-CYC          PIC 9(02).                   
           05 WS-CURRENT-DATE              PIC X(10).                   
           05 WS-ACCOUNT-NO                PIC 9(13).                   
           05 WS-TEMP-USAGE                PIC 9(12).                   
           05 WS-TEMP-UNITS                PIC 9(12).                   
           05 WS-NO-DAYS                   PIC 9(04).                   
T25407     05 WS-TEMP-REV-CLASS            PIC 9(3).                    
           05 WS-CODE-REV-CLASS.                                        
              10 WS-CLASS-DIGIT-1          PIC X(01) VALUE '0'.         
              10 WS-CLASS-MID-DIGIT        PIC 9(01).                   
              10 WS-CLASS-DIGIT-3          PIC X(01) VALUE '0'.         
           05 WS-CURR-REV-MONTH            PIC 9(06).                   
           05 WS-PREV-REVENUE-MONTH.                                    
              10 WS-PREV-REV-YYYY          PIC 9(04).                   
              10 WS-PREV-REV-MM            PIC 9(02).                   
           05 WS-PREV-REV-MONTH REDEFINES                               
              WS-PREV-REVENUE-MONTH        PIC 9(06).                   
COB305     05 WS-PREV-DAILY-USE        PIC S9(9)V99 COMP-3 VALUE 0.       
COB305     05 WS-CURR-DAILY-USE        PIC S9(9)V99 COMP-3 VALUE 0.       
COB305     05 WS-AVG-DAILY-USE-RATIO        PIC S9(7)V9(4) COMP-3 
COB305       VALUE 0.       
COB305     05 WS-DIFF-TIMES-INV-SIZE        PIC S9(7)V9(4) COMP-3 
COB305       VALUE 0.       
COB305     05 WS-PRODUCT-DVD-BY-N        PIC S9(7)V9(4) COMP-3 VALUE 0.       
COB305     05 WS-CYC-FACTOR-ACCUM        PIC S9(4)V9(4) COMP-3 VALUE 0.       
COB305     05 WS-CYCLE-FACTOR        PIC S9(4)V9(4) COMP-3 VALUE 0.       
COB305     05 WS-N-FACTOR        PIC S9(4)V9(4) COMP-3 VALUE 0.       
COB305     05 WS-WT-FACTOR        PIC S9(4)V9(4) COMP-3 VALUE 0.       
COB305     05 WS-TOTAL-COUNT        PIC S9(8) COMP-3 VALUE 0.       
COB305     05 WS-MID-POINT-COUNT        PIC S9(8) COMP-3 VALUE 0.       
COB305     05 WS-CUMULATIVE-SUM-N        PIC S9(8) COMP-3 VALUE 0.       
COB305     05 WS-CMLTV-SUM-N-MINUS-1        PIC S9(8) COMP-3 VALUE 0.       
COB305     05 WS-MID-POINT-LESS-CMLTV-N-1        PIC S9(8) COMP-3 
COB305       VALUE 0.       
T35227     05 WS-ACC-ROW-COUNT             PIC 9(04)  VALUE 0.          
T35227     05 WS-ACC-SUB                   PIC 9(04)  VALUE 0.          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-USAGE-FLAG                PIC X(01)  VALUE 'Y'.        
              88 USAGE-NOT-FOUND                      VALUE 'N'.        
           05 WS-END-OF-ACCT               PIC X(01)  VALUE 'N'.        
           05 WS-FWK112-STATUS             PIC XX     VALUE '00'.       
              88 FWK112-SUCCESSFUL                    VALUE '00'.       
T28883     05 WS-DATABASE                  PIC 9(01)  VALUE  0.         
T28883        88 CSR-DATABASE                         VALUE  1.         
T28883        88 SEB-DATABASE                         VALUE  2.         
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-A                         PIC X(01)  VALUE 'A'.        
           05 WS-B                         PIC X(01)  VALUE 'B'.        
           05 WS-C                         PIC X(01)  VALUE 'C'.        
           05 WS-E                         PIC X(01)  VALUE 'E'.        
           05 WS-F                         PIC X(01)  VALUE 'F'.        
           05 WS-G                         PIC X(01)  VALUE 'G'.        
           05 WS-I                         PIC X(01)  VALUE 'I'.        
           05 WS-J                         PIC X(01)  VALUE 'J'.        
           05 WS-K                         PIC X(01)  VALUE 'K'.        
           05 WS-M                         PIC X(01)  VALUE 'M'.        
           05 WS-N                         PIC X(01)  VALUE 'N'.        
           05 WS-NO                        PIC X(01)  VALUE 'N'.        
           05 WS-S                         PIC X(01)  VALUE 'S'.        
           05 WS-Y                         PIC X(01)  VALUE 'Y'.        
           05 WS-YES                       PIC X(01)  VALUE 'Y'.        
           05 WS-U                         PIC X(01)  VALUE 'U'.        
           05 WS-COMMA                     PIC X(01)  VALUE ','.        
      *                                                                 00443500
T35227 01  WS-ROWSET-ARRAY.                                             
COB305     05 WS-ACCOUNT-NO-ARR        PIC S9(13)V OCCURS 250 TIMES 
COB305       USAGE COMP-3 VALUE 0.    
T35227     05 WS-CODE-UTIL-TYPE-ARR     OCCURS 250 TIMES  PIC X(01).    
T35227     05 WS-IC-NO-ARR              OCCURS 250 TIMES                
T35227                                     PIC S9(4) USAGE COMP.        
T35227     05 WS-MTR-REF-NO-ARR         OCCURS 250 TIMES                
T35227                                     PIC S9(4) USAGE COMP.        
      *                                                                 00443500
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
      *                                                                 00516500
       COPY CWS00039.                                                   PCS01000
       COPY CWS00038.                                                   PCS01000
      *                                                                 00519000
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_BILL_WINDOW                                                      
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_ACCOUNT                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_MTRD_ENVRNMT                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_BILLING_DET                                                      
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBBLLDET                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CNSMPTN_HIST                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCNSMP                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_JOB_PARM                                                         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_WEATHER_TREND                                                    
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBWTHTRD                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_HOLIDAY                                                          
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBHLDAY                                                    
           END-EXEC.                                                            
      *                                                                         
T28883*****************************************************************         
T28883*    CSS_DELINQUENCY                                                      
T28883*****************************************************************         
T28883     EXEC SQL                                                             
T28883       INCLUDE TBDELQ                                                     
T28883     END-EXEC.                                                            
T28883*                                                                         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00166                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
                                                                        
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO SELECT WT DATA                        **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE WT_CURSOR CURSOR FOR                             
                SELECT CODE_UTIL_TYPE                                   
                      ,CODE_REVENUE_CLASS                               
                      ,FACTOR                                           
                      ,UNITS_ACCUM                                      
                  FROM CSS_WEATHER_TREND WITH(READUNCOMMITTED)                  
                 WHERE DATE_BILL = IIF(TRY_CONVERT(DATE, :WT-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :WT-DATE-BILL
              ) <> 0) OR (LEN(:WT-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :WT-DATE-BILL
              ), CONVERT(DATE, :WT-DATE-BILL) )                        
T23877             AND COMPANY_NO = :WT-COMPANY-NO                      
C35227           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE WT_CURSOR CURSOR FOR                                     
MFA-TR*         SELECT CODE_UTIL_TYPE                                           
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,UNITS_ACCUM                                              
MFA-TR*           FROM CSS_WEATHER_TREND                                        
MFA-TR*          WHERE DATE_BILL = :WT-DATE-BILL                                
MFA-TR*            AND COMPANY_NO = :WT-COMPANY-NO                              
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ** CURSOR TO GET THE PREVIOUS 3 BILL-CYCLES & REV-MONTHS       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE PREV_CYC CURSOR FOR                              
                SELECT DISTINCT TOP(3) BN.BILL_CYCLE,
              BN.REVENUE_MONTH                                 
                  FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
                 WHERE BN.DATE_EXTRACT <= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )              
T28883             AND BN.BILL_CYCLE   <= :WS-MAX-CYCLE                 
              ORDER BY BN.REVENUE_MONTH DESC, BN.BILL_CYCLE DESC        
T35227                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PREV_CYC CURSOR FOR                                      
MFA-TR*         SELECT DISTINCT BN.BILL_CYCLE                                   
MFA-TR*               ,BN.REVENUE_MONTH                                         
MFA-TR*           FROM CSS_BILL_WINDOW BN                                       
MFA-TR*          WHERE BN.DATE_EXTRACT <= :BN-DATE-EXTRACT                      
MFA-TR*            AND BN.BILL_CYCLE   <= :WS-MAX-CYCLE                         
MFA-TR*       ORDER BY BN.REVENUE_MONTH DESC, BN.BILL_CYCLE DESC                
MFA-TR*       FETCH FIRST 3 ROWS ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ** CURSOR TO GET ACCOUNT DETAILS                               **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
T35227       DECLARE ACCT_DET CURSOR WITH ROWSET                        
T35227                           POSITIONING FOR                        
               SELECT UT.ACCOUNT_NO                                     
                     ,UT.CODE_UTIL_TYPE                                 
                     ,UT.IC_NO                                          
                     ,MN.MTR_REF_NO                                     
                 FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                 
                     ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO             
                  AND MN.ACCOUNT_NO         = AT.ACCOUNT_NO             
                  AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO             
                  AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE         
                  AND MN.IC_NO              = UT.IC_NO                  
T23877            AND AT.COMPANY_NO         = :WT-COMPANY-NO            
                  AND AT.CODE_ACCT_STAT     = 'A'                       
                  AND AT.BILL_CYCLE         = :AT-BILL-CYCLE            
                  AND MN.CODE_METER_STATUS IN ('A', 'B', 'I', 'J')      
                  AND AT.REV_MTH_LST_NRML  >= :AT-REV-MTH-LST-NRML      
C35227        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ACCT_DET CURSOR WITH ROWSET                                
MFA-TR*                          POSITIONING FOR                                
MFA-TR*        SELECT UT.ACCOUNT_NO                                             
MFA-TR*              ,UT.CODE_UTIL_TYPE                                         
MFA-TR*              ,UT.IC_NO                                                  
MFA-TR*              ,MN.MTR_REF_NO                                             
MFA-TR*          FROM CSS_ACCOUNT      AT                                       
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_MTRD_ENVRNMT MN                                       
MFA-TR*         WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO                     
MFA-TR*           AND MN.ACCOUNT_NO         = AT.ACCOUNT_NO                     
MFA-TR*           AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO                     
MFA-TR*           AND MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                 
MFA-TR*           AND MN.IC_NO              = UT.IC_NO                          
MFA-TR*           AND AT.COMPANY_NO         = :WT-COMPANY-NO                    
MFA-TR*           AND AT.CODE_ACCT_STAT     = 'A'                               
MFA-TR*           AND AT.BILL_CYCLE         = :AT-BILL-CYCLE                    
MFA-TR*           AND MN.CODE_METER_STATUS IN ('A', 'B', 'I', 'J')              
MFA-TR*           AND AT.REV_MTH_LST_NRML  >= :AT-REV-MTH-LST-NRML              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
                                                                        
T23877 LINKAGE SECTION.                                                 
                                                                        
T23877 01 WS-PARM-CARD.                                                 
T23877    05 WS-CHK-BYTE                   PIC S9(04) COMP.             
T23877    05 WS-PARM-COMPANY               PIC X(02).                   
                                                                        
      *                                                                         
T23877 PROCEDURE DIVISION USING WS-PARM-CARD.                           
      *                                                                         
      ******************************************************************        
      * MAIN PROCESS                                                   *01092001
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 1000-PROCESS-INPUT THRU 1000-EXIT.                   
      *                                                                         
T25407     IF WS-PARM-COMPANY = '26'                                    
T25407        MOVE WS-NEW-BUSINESS-DAY TO WT-DATE-BILL                  
T25407        MOVE WS-PARM-COMPANY     TO WT-COMPANY-NO                 
T25407        MOVE WS-G                TO WT-CODE-UTIL-TYPE             
T25407        MOVE '020'               TO WT-CODE-REVENUE-CLASS         
T25407        PERFORM 7500-SELECT-WT-PSNC   THRU   7500-EXIT            
T25407        IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T25407            MOVE ZEROS                  TO WT-UNITS-ACCUM         
T25407            MOVE '000'                  TO WT-CODE-REVENUE-CLASS  
T25407            PERFORM 7600-INSERT-WT-PSNC  THRU   7600-INSERT-EXIT  
T25407                    UNTIL WT-CODE-REVENUE-CLASS > '090'           
T25407        END-IF                                                    
T25407     END-IF                                                       
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  GET THE CURRENT BILLING COMMONDATE FROM CSS_JOB_PARM AND FIND *        
      *  THE NEXT-BUSINESS-DAY USING CPD00315 COPYBOOK. SELECT THE MOST*        
      *  CURRENT BILL-CYCLE FOR THAT DAY FROM CSS_BILL_WINDOW.         *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
T23877     MOVE WS-PARM-COMPANY            TO WT-COMPANY-NO.            
      *                                                                 00568500
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                 00568500
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
               MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
           END-IF.                                                      
      *                                                                 05620000
           MOVE WS-INPUT-DATE              TO WS-NEW-BUSINESS-DAY.      
           PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                      
              6500-NEXT-BUSINESS-DAY-EXIT UNTIL NEXT-BUSINESS-DAY-FOUND.
                                                                        
           MOVE WS-NEW-BUSINESS-DAY        TO BN-DATE-EXTRACT           
                                              WS-CURRENT-DATE.          
T28883     MOVE WS-PARM-COMPANY            TO C8-COMPANY-NO.            
T28883     MOVE 'DATABASE'                 TO C8-DELINQ-CD.             
T28883     PERFORM 7700-GET-DATABASE       THRU 7700-EXIT.              
T28883     MOVE C8-DELINQ-VALUE            TO WS-DATABASE.              
T28883     IF CSR-DATABASE                                              
T28883        MOVE '20'                    TO WS-MAX-CYCLE              
T28883     ELSE                                                         
T28883        MOVE '21'                    TO WS-MAX-CYCLE              
T28883     END-IF.                                                      
      *                                                                 05620000
           PERFORM 7000-GET-CURRENT-CYCLE THRU 7000-EXIT.               
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* BILL-CYCLE NOT FOUND ON THE TABLE  *'         
               DISPLAY '* DATE_EXTRACT = ', BN-DATE-EXTRACT             
               DISPLAY '* PROGRAM ABENDING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 05620000
           PERFORM VARYING WS-CYC-SUB FROM 1 BY 1 UNTIL WS-CYC-SUB > 3  
             PERFORM VARYING WS-CL-SUB FROM 1 BY 1 UNTIL WS-CL-SUB > 10 
              PERFORM VARYING WS-IN-SUB FROM 1 BY 1 UNTIL WS-IN-SUB > 11
                MOVE ZEROS                 TO                           
                WS-ELEC-INTERVAL-COUNT(WS-CYC-SUB, WS-CL-SUB, WS-IN-SUB)
                WS-GAS-INTERVAL-COUNT(WS-CYC-SUB, WS-CL-SUB, WS-IN-SUB) 
                WS-TEST-INTERVAL-COUNT(WS-IN-SUB)                       
              END-PERFORM                                               
             END-PERFORM                                                
           END-PERFORM.                                                 
      *                                                                 00568500
           OPEN OUTPUT FCSWK112-FILE.                                   
      *                                                                         
           IF  FWK112-SUCCESSFUL                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FILE OPEN ERROR'                                
               DISPLAY 'FCSWK112 FILE STATUS ==>' WS-FWK112-STATUS      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           MOVE SPACES TO FIOWK112.                                     
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
T28883*  IF THE BILL-CYCLE > '21', COPY FACTORS FROM PREV DAY.   ELSE, *        
      *  CALCULATE THE FACTORS BASED ON THE USAGE FOR THE THREE PREV   *        
      *  CYCLES IN THE LAST TWO REVENUE MONTHS.                        *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF  BN-BILL-CYCLE > WS-MAX-CYCLE                             
               MOVE WS-INPUT-DATE          TO WT-DATE-BILL              
T23877*        MOVE '01'                   TO WT-COMPANY-NO                     
               PERFORM 7050-OPEN-WT-CURSOR THRU 7050-EXIT               
               PERFORM 7060-FETCH-WT-CURSOR THRU 7060-EXIT              
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND      
                   MOVE WS-NEW-BUSINESS-DAY TO WT-DATE-BILL             
                   PERFORM 8000-INSERT-INTO-WT THRU 8000-EXIT           
                   PERFORM 7060-FETCH-WT-CURSOR THRU 7060-EXIT          
               END-PERFORM                                              
               PERFORM 7070-CLOSE-WT-CURSOR THRU 7070-EXIT              
      *                                                                         
           ELSE                                                         
               PERFORM 1050-CALCULATE-WT-FACTORS THRU 1050-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  PROCESS ACCTS WHICH WERE BILLED IN THE PREV 3 CYCLES          *        
      ******************************************************************        
       1050-CALCULATE-WT-FACTORS.                                       
      *                                                                         
           MOVE ZEROS                      TO WS-CYC-SUB.               
           MOVE WS-INPUT-DATE              TO BN-DATE-EXTRACT.          
           PERFORM 7200-OPEN-PREV-CYC THRU 7200-EXIT.                   
           PERFORM UNTIL WS-CYC-SUB >= 3                                
              PERFORM 7210-FETCH-PREV-CYC THRU 7210-EXIT                
              IF  BN-BILL-CYCLE <= WS-MAX-CYCLE                         
                  COMPUTE WS-CYC-SUB = WS-CYC-SUB + 1                   
                  PERFORM 1075-GET-ACCT-DETAILS THRU 1075-EXIT          
              END-IF                                                    
           END-PERFORM.                                                 
           PERFORM 7220-CLOSE-PREV-CYC THRU 7220-EXIT.                  
           PERFORM 1200-CALC-EST-FACTOR THRU 1200-EXIT.                 
      *                                                                         
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  FETCH ACCOUNTS BILLED IN EACH OF THE THREE PREVIOUS CYCLES    *        
      ******************************************************************        
       1075-GET-ACCT-DETAILS.                                           
      *                                                                         
           MOVE BN-BILL-CYCLE              TO AT-BILL-CYCLE.            
           MOVE BN-REVENUE-MONTH           TO AT-REV-MTH-LST-NRML       
                                              WS-CURR-REV-MONTH         
                                              BG-REVENUE-MONTH.         
           MOVE WS-N                       TO WS-END-OF-ACCT.           
           PERFORM 7250-OPEN-ACCT-DET THRU 7250-EXIT.                   
T35227     PERFORM 7260-FETCH-ACCT-DET THRU 7260-EXIT.                  
T35227     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
T35227               AND WS-ACC-ROW-COUNT = ZERO                        
T35227        PERFORM 1100-PROCESS-EACH-ACCT THRU 1100-EXIT             
T35227                VARYING WS-ACC-SUB FROM 1 BY 1                    
T35227                UNTIL WS-ACC-SUB > WS-ACC-ROW-COUNT               
T35227        PERFORM 7260-FETCH-ACCT-DET THRU 7260-EXIT                
T35227     END-PERFORM.                                                 
           PERFORM 7270-CLOSE-ACCT-DET THRU 7270-EXIT.                  
      *                                                                         
       1075-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  GET THE USAGE FOR THE CURRENT & PREV MONTHS                   *        
      ******************************************************************        
       1100-PROCESS-EACH-ACCT.                                          
      *                                                                         
T35227     MOVE WS-ACCOUNT-NO-ARR         (WS-ACC-SUB)                  
T35227                                    TO UT-ACCOUNT-NO              
T35227     MOVE WS-CODE-UTIL-TYPE-ARR     (WS-ACC-SUB)                  
T35227                                    TO UT-CODE-UTIL-TYPE          
T35227     MOVE WS-IC-NO-ARR              (WS-ACC-SUB)                  
T35227                                    TO UT-IC-NO                   
T35227     MOVE WS-MTR-REF-NO-ARR         (WS-ACC-SUB)                  
T35227                                    TO MN-MTR-REF-NO              
      *                                                                         
           MOVE UT-CODE-UTIL-TYPE          TO BG-CODE-UTIL-TYPE         
                                          E-FWK112-CODE-UTIL-TYPE.      
           MOVE UT-ACCOUNT-NO              TO BG-ACCOUNT-NO             
                                              WS-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NO              TO E-FWK112-ACCOUNT-NO.      
           MOVE UT-IC-NO                   TO BG-IC-NO.                 
           MOVE WS-CURR-REV-MONTH          TO BG-REVENUE-MONTH.         
      *                                                                         
T35227     PERFORM 7300-GET-LATEST-BILL-VER THRU 7300-EXIT.             
T35227     IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               GO TO 1100-EXIT                                          
           END-IF.                                                      
      *                                                                         
T35227**   ADDING BELOW CHECK TO AVOID ANY ABENDS DOWN THE LINE                 
T35227     IF BG-CODE-REVENUE-CLASS <= SPACE                            
T35227        GO TO 1100-EXIT                                           
T35227     END-IF                                                       
T35227*                                                                         
T35227     MOVE BG-CODE-REVENUE-CLASS      TO UT-CODE-REVENUE-CLASS     
T35227                                        E-FWK112-CODE-REV-CLASS.  
           IF  UT-CODE-REVENUE-CLASS = '910'                            
               COMPUTE WS-CL-SUB = 10                                   
           ELSE                                                         
               MOVE UT-CODE-REVENUE-CLASS  TO WS-CODE-REV-CLASS         
               COMPUTE WS-CL-SUB = WS-CLASS-MID-DIGIT + 1               
           END-IF.                                                      
      *                                                                         
           MOVE CX-METER-NO                TO E-FWK112-METER-NO.        
      *                                                                         
           IF  CX-NO-UNITS > 0 AND CX-NO-DAYS > 0                       
               COMPUTE WS-CURR-DAILY-USE                                
                              = ( CX-NO-UNITS / CX-NO-DAYS )            
           ELSE                                                         
               GO TO 1100-EXIT                                          
           END-IF.                                                      
           MOVE WS-CURR-DAILY-USE          TO WS-TEMP-USAGE.            
           MOVE WS-TEMP-USAGE              TO E-FWK112-CURR-USAGE.      
           MOVE CX-NO-UNITS                TO WS-TEMP-UNITS.            
           MOVE WS-TEMP-UNITS              TO E-FWK112-CURR-UNITS.      
           MOVE CX-NO-DAYS                 TO WS-NO-DAYS.               
           MOVE WS-NO-DAYS                 TO E-FWK112-CURR-DAYS.       
      *                                                                         
           MOVE WS-CURR-REV-MONTH          TO WS-PREV-REV-MONTH.        
      *                                                                         
           COMPUTE WS-PREV-REV-MM = WS-PREV-REV-MM - 1.                 
           IF  WS-PREV-REV-MM = ZEROS                                   
               MOVE 12                     TO WS-PREV-REV-MM            
               COMPUTE WS-PREV-REV-YYYY = WS-PREV-REV-YYYY - 1          
           END-IF.                                                      
      *                                                                         
           MOVE WS-PREV-REV-MONTH          TO BG-REVENUE-MONTH.         
      *                                                                         
T35227     PERFORM 7300-GET-LATEST-BILL-VER THRU 7300-EXIT.             
T35227     IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               GO TO 1100-EXIT                                          
TP8037     END-IF.                                                      
      *                                                                         
           IF  CX-NO-UNITS > 0 AND CX-NO-DAYS > 0                       
               COMPUTE WS-PREV-DAILY-USE                                
                              = ( CX-NO-UNITS / CX-NO-DAYS )            
           ELSE                                                         
               GO TO 1100-EXIT                                          
           END-IF.                                                      
           MOVE WS-PREV-DAILY-USE          TO WS-TEMP-USAGE.            
           MOVE WS-TEMP-USAGE              TO E-FWK112-PREV-USAGE.      
           MOVE CX-NO-UNITS                TO WS-TEMP-UNITS.            
           MOVE WS-TEMP-UNITS              TO E-FWK112-PREV-UNITS.      
           MOVE CX-NO-DAYS                 TO WS-NO-DAYS.               
           MOVE WS-NO-DAYS                 TO E-FWK112-PREV-DAYS.       
      *                                                                         
           IF  WS-PREV-DAILY-USE > 0                                    
               COMPUTE WS-AVG-DAILY-USE-RATIO = ( WS-CURR-DAILY-USE /   
                                            WS-PREV-DAILY-USE )         
           ELSE                                                         
               GO TO 1100-EXIT                                          
           END-IF.                                                      
      *                                                                         
           IF  WS-AVG-DAILY-USE-RATIO >= WS-INTERVAL-MAX-RANGE (10)     
               COMPUTE WS-IN-SUB = 11                                   
           ELSE                                                         
               COMPUTE WS-IN-SUB = 1                                    
               PERFORM UNTIL WS-AVG-DAILY-USE-RATIO                     
                                < WS-INTERVAL-MAX-RANGE (WS-IN-SUB)     
                   COMPUTE WS-IN-SUB = WS-IN-SUB + 1                    
               END-PERFORM                                              
           END-IF.                                                      
      *                                                                         
           IF  UT-CODE-UTIL-TYPE = WS-E                                 
               ADD +1                      TO                           
                WS-ELEC-INTERVAL-COUNT(WS-CYC-SUB, WS-CL-SUB, WS-IN-SUB)
           ELSE                                                         
               ADD +1                      TO                           
                WS-GAS-INTERVAL-COUNT(WS-CYC-SUB, WS-CL-SUB, WS-IN-SUB) 
           END-IF.                                                      
      *                                                                         
           PERFORM 8200-WRITE-FCSWK112 THRU 8200-EXIT.                  
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CALCULATE THE ESTIMATION FACTOR FOR EACH UTILITY & CLASS       *        
      ******************************************************************        
       1200-CALC-EST-FACTOR.                                            
      *                                                                         
           PERFORM 1210-CALC-ELEC-EST-FACTOR THRU 1210-EXIT             
               VARYING WS-CL-SUB FROM 1 BY 1 UNTIL WS-CL-SUB > 10.      
      *                                                                         
           PERFORM 1220-CALC-GAS-EST-FACTOR THRU 1220-EXIT              
               VARYING WS-CL-SUB FROM 1 BY 1 UNTIL WS-CL-SUB > 10.      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DETERMINING ELECTRIC ESTIMATION FACTORS                        *        
      ******************************************************************        
       1210-CALC-ELEC-EST-FACTOR.                                       
      *                                                                         
           MOVE ZEROS                      TO WS-CYC-FACTOR-ACCUM.      
           PERFORM VARYING WS-CYC-SUB FROM 1 BY 1 UNTIL WS-CYC-SUB > 3  
              PERFORM VARYING WS-IN-SUB FROM 1 BY 1 UNTIL WS-IN-SUB > 11
                  COMPUTE WS-TEST-INTERVAL-COUNT (WS-IN-SUB) =          
                WS-ELEC-INTERVAL-COUNT(WS-CYC-SUB, WS-CL-SUB, WS-IN-SUB)
              END-PERFORM                                               
              PERFORM 1250-CALC-CYC-FACTOR THRU 1250-EXIT               
              COMPUTE WS-CYC-FACTOR-ACCUM = WS-CYC-FACTOR-ACCUM +       
                                                  WS-CYCLE-FACTOR       
           END-PERFORM.                                                 
      *                                                                         
           COMPUTE WS-WT-FACTOR = WS-CYC-FACTOR-ACCUM / 3.              
           MOVE WS-WT-FACTOR               TO WT-FACTOR.                
           IF  WT-FACTOR NOT EQUAL ZEROS                                
               IF  WS-CL-SUB = 10                                       
                   MOVE '910'              TO WT-CODE-REVENUE-CLASS     
               ELSE                                                     
                   MOVE ZEROS              TO WS-CODE-REV-CLASS         
                   COMPUTE WS-CLASS-MID-DIGIT = WS-CL-SUB - 1           
                   MOVE WS-CODE-REV-CLASS  TO WT-CODE-REVENUE-CLASS     
               END-IF                                                   
               MOVE WS-CURRENT-DATE        TO WT-DATE-BILL              
T23877*        MOVE '01'                   TO WT-COMPANY-NO                     
               MOVE WS-E                   TO WT-CODE-UTIL-TYPE         
               MOVE ZEROS                  TO WT-UNITS-ACCUM            
               PERFORM 8000-INSERT-INTO-WT THRU 8000-EXIT               
           END-IF.                                                      
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DETERMINING GAS ESTIMATION FACTORS                             *        
      ******************************************************************        
       1220-CALC-GAS-EST-FACTOR.                                        
      *                                                                         
           MOVE ZEROS                      TO WS-CYC-FACTOR-ACCUM.      
           PERFORM VARYING WS-CYC-SUB FROM 1 BY 1 UNTIL WS-CYC-SUB > 3  
              PERFORM VARYING WS-IN-SUB FROM 1 BY 1 UNTIL WS-IN-SUB > 11
                  COMPUTE WS-TEST-INTERVAL-COUNT (WS-IN-SUB) =          
                WS-GAS-INTERVAL-COUNT(WS-CYC-SUB, WS-CL-SUB, WS-IN-SUB) 
              END-PERFORM                                               
              PERFORM 1250-CALC-CYC-FACTOR THRU 1250-EXIT               
              COMPUTE WS-CYC-FACTOR-ACCUM = WS-CYC-FACTOR-ACCUM +       
                                                  WS-CYCLE-FACTOR       
           END-PERFORM.                                                 
      *                                                                         
           COMPUTE WS-WT-FACTOR = WS-CYC-FACTOR-ACCUM / 3.              
           MOVE WS-WT-FACTOR               TO WT-FACTOR.                
           IF  WT-FACTOR NOT EQUAL ZEROS                                
               IF  WS-CL-SUB = 10                                       
                   MOVE '910'              TO WT-CODE-REVENUE-CLASS     
               ELSE                                                     
                   MOVE ZEROS              TO WS-CODE-REV-CLASS         
                   COMPUTE WS-CLASS-MID-DIGIT = WS-CL-SUB - 1           
                   MOVE WS-CODE-REV-CLASS  TO WT-CODE-REVENUE-CLASS     
               END-IF                                                   
               MOVE WS-CURRENT-DATE        TO WT-DATE-BILL              
T23877*        MOVE '01'                   TO WT-COMPANY-NO                     
               MOVE WS-G                   TO WT-CODE-UTIL-TYPE         
               MOVE ZEROS                  TO WT-UNITS-ACCUM            
               PERFORM 8000-INSERT-INTO-WT THRU 8000-EXIT               
           END-IF.                                                      
      *                                                                         
       1220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CALCULATE ESTIMATION FACTORS                                   *        
      ******************************************************************        
       1250-CALC-CYC-FACTOR.                                            
      *                                                                         
           MOVE ZEROS                      TO WS-TOTAL-COUNT.           
           PERFORM VARYING WS-IN-SUB FROM 1 BY 1 UNTIL WS-IN-SUB > 11   
               COMPUTE WS-TOTAL-COUNT = WS-TOTAL-COUNT                  
                                  + WS-TEST-INTERVAL-COUNT (WS-IN-SUB)  
           END-PERFORM.                                                 
      *                                                                         
           IF  WS-TOTAL-COUNT EQUAL ZEROS                               
               MOVE ZEROS                  TO WS-CYCLE-FACTOR           
               GO TO 1250-EXIT                                          
           END-IF.                                                      
      *                                                                         
           COMPUTE WS-MID-POINT-COUNT = WS-TOTAL-COUNT / 2              
           MOVE ZEROS                      TO WS-CUMULATIVE-SUM-N       
                                              WS-CMLTV-SUM-N-MINUS-1.   
      *                                                                         
           PERFORM VARYING WS-IN-SUB FROM 1 BY 1 UNTIL WS-IN-SUB > 11   
                   OR WS-CUMULATIVE-SUM-N > WS-MID-POINT-COUNT          
               COMPUTE WS-CUMULATIVE-SUM-N = WS-CUMULATIVE-SUM-N        
                                   + WS-TEST-INTERVAL-COUNT (WS-IN-SUB) 
               IF  WS-IN-SUB > 1                                        
                   COMPUTE WS-CMLTV-SUM-N-MINUS-1                       
                              = WS-CMLTV-SUM-N-MINUS-1                  
                                + WS-TEST-INTERVAL-COUNT (WS-IN-SUB - 1)
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
           COMPUTE WS-IN-SUB = WS-IN-SUB - 1.                           
           COMPUTE WS-MID-POINT-LESS-CMLTV-N-1                          
                          = WS-MID-POINT-COUNT - WS-CMLTV-SUM-N-MINUS-1.
           COMPUTE WS-DIFF-TIMES-INV-SIZE =                             
                   WS-MID-POINT-LESS-CMLTV-N-1 * 0.20.                  
      *                                                                         
           IF  WS-TEST-INTERVAL-COUNT (WS-IN-SUB) > 0                   
               COMPUTE WS-PRODUCT-DVD-BY-N = WS-DIFF-TIMES-INV-SIZE     
                          / WS-TEST-INTERVAL-COUNT (WS-IN-SUB)          
           ELSE                                                         
               MOVE ZEROS                  TO WS-PRODUCT-DVD-BY-N       
           END-IF.                                                      
      *                                                                         
           EVALUATE WS-IN-SUB                                           
              WHEN 1                                                    
                 MOVE 0.40                 TO WS-N-FACTOR               
              WHEN 11                                                   
                 MOVE 2.19                 TO WS-N-FACTOR               
              WHEN OTHER                                                
                 MOVE WS-INTERVAL-MAX-RANGE (WS-IN-SUB - 1)             
                                           TO WS-N-FACTOR               
           END-EVALUATE.                                                
      *                                                                         
           COMPUTE WS-CYCLE-FACTOR = WS-PRODUCT-DVD-BY-N + WS-N-FACTOR. 
      *                                                                         
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ********************************************************                  
      * JOB_PARM INCLUDES FOR DATE ACCESS                                       
      ********************************************************                  
       COPY CPD00037.                                                   13580000
       COPY CPD00040.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * COPYBOOK TO GET THE NEXT BUSINESS DAY                                   
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00315                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  DB2 CALLS                                                   **        
      ******************************************************************        
       7000-GET-CURRENT-CYCLE.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT MAX(BN.BILL_CYCLE)                                 
                INTO :BN-BILL-CYCLE                                     
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE BN.DATE_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                
T28883           AND BN.BILL_CYCLE   <= :WS-MAX-CYCLE                   
                 AND BN.REVENUE_MONTH =                                 
                          ( SELECT MAX(REVENUE_MONTH)                   
                              FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)        
                             WHERE DATE_EXTRACT  = 
              IIF(TRY_CONVERT(DATE, :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) ) )   
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BN.BILL_CYCLE)                                         
MFA-TR*         INTO :BN-BILL-CYCLE                                             
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE BN.DATE_EXTRACT  = :BN-DATE-EXTRACT                        
MFA-TR*          AND BN.BILL_CYCLE   <= :WS-MAX-CYCLE                           
MFA-TR*          AND BN.REVENUE_MONTH =                                         
MFA-TR*                   ( SELECT MAX(REVENUE_MONTH)                           
MFA-TR*                       FROM CSS_BILL_WINDOW                              
MFA-TR*                      WHERE DATE_EXTRACT  = :BN-DATE-EXTRACT )           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* 7000-GET-CURRENT-CYCLE             *'         
               DISPLAY '* DATE_EXTRACT = ', BN-DATE-EXTRACT             
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04414100
      *   OPEN CURSOR ON WT                                            *03340000
      ******************************************************************04414300
       7050-OPEN-WT-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
               OPEN WT_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* 7050-OPEN-WT-CURSOR                *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* DATE BILL = ', WT-DATE-BILL                   
T23877         DISPLAY '* COMPANY NO =', WT-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04416502
      ******************************************************************        
      * FETCHES DATA FROM CSS_WEATHER_TREND                            *        
      ******************************************************************        
       7060-FETCH-WT-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH  WT_CURSOR                                          
               INTO :WT-CODE-UTIL-TYPE                                  
                   ,:WT-CODE-REVENUE-CLASS                              
                   ,:WT-FACTOR                                          
                   ,:WT-UNITS-ACCUM                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* 7060-FETCH-WT-CURSOR               *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* DATE BILL = ', WT-DATE-BILL                   
T23877         DISPLAY '* COMPANY NO =', WT-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES WT_CURSOR                                                        
      ******************************************************************        
       7070-CLOSE-WT-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE WT_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* 7070-CLOSE-WT-CURSOR               *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* DATE BILL = ', WT-DATE-BILL                   
T23877         DISPLAY '* COMPANY NO =', WT-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * COPY BOOK TO GET THE LATEST VERSION OF BILL FOR A REVENUE-MONTH*        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00166                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************04414100
      *   OPEN CURSOR PREV_CYC                                         *03340000
      ******************************************************************04414300
       7200-OPEN-PREV-CYC.                                              
      *                                                                         
           EXEC SQL                                                     
               OPEN PREV_CYC                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* 7200-OPEN-PREV-CYC                 *'         
               DISPLAY '* DATE-EXTRACT = ', BN-DATE-EXTRACT             
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES DATA FROM PREV_CYC                                     *        
      ******************************************************************        
       7210-FETCH-PREV-CYC.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH  PREV_CYC                                           
               INTO :BN-BILL-CYCLE                                      
                   ,:BN-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* 7210-FETCH-PREV-CYC                *'         
               DISPLAY '* DATE-EXTRACT = ', BN-DATE-EXTRACT             
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES PREV_CYC CURSOR                                                  
      ******************************************************************        
       7220-CLOSE-PREV-CYC.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE PREV_CYC                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* 7220-CLOSE-PREV-CYC                *'         
               DISPLAY '* DATE-EXTRACT = ', BN-DATE-EXTRACT             
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THESE PARAGRAPHS ARE TO FETCH DETAILS FROM ACCT_DET         **        
      ******************************************************************        
       7250-OPEN-ACCT-DET.                                              
      *                                                                         
           EXEC SQL                                                     
               OPEN ACCT_DET                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* OPEN ERROR -  7250-OPEN-ACCT-DET   *'         
               DISPLAY '* BILL-CYCLE = ', AT-BILL-CYCLE                 
               DISPLAY '* REV-MTH-LST-NRML = ', AT-REV-MTH-LST-NRML     
T23877         DISPLAY '* COMPANY NO =', WT-COMPANY-NO                  
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7260-FETCH-ACCT-DET.                                             

MSQ008     MOVE 250 TO MSQ008-ACCT-DET
      *                                                                         
           EXEC SQL                                                     
T35227         FOR :MSQ008-ACCT-DET
              FETCH 
              FROM ACCT_DET              
T35227          INTO :WS-ACCOUNT-NO-ARR                                 
T35227              ,:WS-CODE-UTIL-TYPE-ARR                             
T35227              ,:WS-IC-NO-ARR                                      
T35227              ,:WS-MTR-REF-NO-ARR                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM ACCT_DET FOR 250 ROWS                     
MFA-TR*         INTO :WS-ACCOUNT-NO-ARR                                         
MFA-TR*             ,:WS-CODE-UTIL-TYPE-ARR                                     
MFA-TR*             ,:WS-IC-NO-ARR                                              
MFA-TR*             ,:WS-MTR-REF-NO-ARR                                         
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ACCT-DET
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T35227        MOVE SQLERRD(3)              TO WS-ACC-ROW-COUNT          
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* FETCH ERROR - 7260-FETCH-ACCT-DET  *'         
               DISPLAY '* BILL-CYCLE = ', AT-BILL-CYCLE                 
               DISPLAY '* REV-MTH-LST-NRML = ', AT-REV-MTH-LST-NRML     
T23877         DISPLAY '* COMPANY NO =', WT-COMPANY-NO                  
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7270-CLOSE-ACCT-DET.                                             
      *                                                                         
           EXEC SQL                                                     
               CLOSE ACCT_DET                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE  SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* CLOSE ERROR - 7270-CLOSE-ACCT-DET  *'         
               DISPLAY '* BILL-CYCLE = ', AT-BILL-CYCLE                 
               DISPLAY '* REV-MTH-LST-NRML = ', AT-REV-MTH-LST-NRML     
T23877         DISPLAY '* COMPANY NO =', WT-COMPANY-NO                  
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *GET THE LATEST VERSION OF THE BILL                                       
      ******************************************************************        
T35227 7300-GET-LATEST-BILL-VER.                                        
T35227*                                                                         
T35227     EXEC SQL                                                     
T35227         SELECT TOP(1) CX.NO_DAYS,
              CX.NO_UNITS,
              CX.METER_NO,
              BG.CODE_REVENUE_CLASS                             
T35227         INTO  :CX-NO-DAYS                                        
T35227              ,:CX-NO-UNITS                                       
T35227              ,:CX-METER-NO                                       
T35227              ,:BG-CODE-REVENUE-CLASS                             
T35227        FROM   CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                  
T35227              ,CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
T35227        WHERE BG.ACCOUNT_NO             = CX.ACCOUNT_NO           
T35227          AND BG.CODE_UTIL_TYPE         = CX.CODE_UTIL_TYPE       
T35227          AND BG.IC_NO                  = CX.IC_NO                
T35227          AND BG.BILL_ITEM_TIMESTMP     = CX.BILL_ITEM_TIMESTMP   
T35227          AND BG.BILL_NO                = CX.BILL_NO              
T35227          AND BG.ACCOUNT_NO             = :BG-ACCOUNT-NO          
T35227          AND BG.CODE_UTIL_TYPE         = :BG-CODE-UTIL-TYPE      
T35227          AND BG.IC_NO                  = :BG-IC-NO               
T35227          AND (( BG.REV_MTH_ORIG_BILL   = 0                       
T35227              AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH )     
T35227              OR ( BG.REV_MTH_ORIG_BILL = :BG-REVENUE-MONTH       
T35227              AND  BG.REVENUE_MONTH     > 0 ))                    
T35227          AND BG.CODE_BILL_ITM_IND      = 'A'                     
T35227          AND BG.CODE_BILL_CALC         = 'A'                     
T35227          AND BG.CODE_BILL_ITM_TYPE     = 'C'                     
T35227          AND CX.MTR_REF_NO             = :MN-MTR-REF-NO          
T35227          AND CX.CODE_TIME_PERIOD       = 0                       
T35227          AND CX.CODE_USAGE_TYPE       IN ('B','C')               
T35227          AND CX.CODE_USAGE_ID          = 'A'                     
T35227          AND CX.NO_DAYS                > 27                      
T35227          AND CX.NO_DAYS                < 35                      
T35227          AND BG.PRORATE_CD            IN (' ', 'P')              
T35227                                       
T35227     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CX.NO_DAYS                                                
MFA-TR*              ,CX.NO_UNITS                                               
MFA-TR*              ,CX.METER_NO                                               
MFA-TR*              ,BG.CODE_REVENUE_CLASS                                     
MFA-TR*        INTO  :CX-NO-DAYS                                                
MFA-TR*             ,:CX-NO-UNITS                                               
MFA-TR*             ,:CX-METER-NO                                               
MFA-TR*             ,:BG-CODE-REVENUE-CLASS                                     
MFA-TR*       FROM   CSS_BILLING_DET  BG                                01120001
MFA-TR*             ,CSS_CNSMPTN_HIST CX                                        
MFA-TR*       WHERE BG.ACCOUNT_NO             = CX.ACCOUNT_NO           01130001
MFA-TR*         AND BG.CODE_UTIL_TYPE         = CX.CODE_UTIL_TYPE       01130001
MFA-TR*         AND BG.IC_NO                  = CX.IC_NO                01130001
MFA-TR*         AND BG.BILL_ITEM_TIMESTMP     = CX.BILL_ITEM_TIMESTMP           
MFA-TR*         AND BG.BILL_NO                = CX.BILL_NO                      
MFA-TR*         AND BG.ACCOUNT_NO             = :BG-ACCOUNT-NO          01130001
MFA-TR*         AND BG.CODE_UTIL_TYPE         = :BG-CODE-UTIL-TYPE      01130001
MFA-TR*         AND BG.IC_NO                  = :BG-IC-NO               01130001
MFA-TR*         AND (( BG.REV_MTH_ORIG_BILL   = 0                               
MFA-TR*             AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH )     01130001
MFA-TR*             OR ( BG.REV_MTH_ORIG_BILL = :BG-REVENUE-MONTH               
MFA-TR*             AND  BG.REVENUE_MONTH     > 0 ))                    01130001
MFA-TR*         AND BG.CODE_BILL_ITM_IND      = 'A'                             
MFA-TR*         AND BG.CODE_BILL_CALC         = 'A'                             
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE     = 'C'                             
MFA-TR*         AND CX.MTR_REF_NO             = :MN-MTR-REF-NO                  
MFA-TR*         AND CX.CODE_TIME_PERIOD       = 0                               
MFA-TR*         AND CX.CODE_USAGE_TYPE       IN ('B','C')                       
MFA-TR*         AND CX.CODE_USAGE_ID          = 'A'                             
MFA-TR*         AND CX.NO_DAYS                > 27                              
MFA-TR*         AND CX.NO_DAYS                < 35                              
MFA-TR*         AND BG.PRORATE_CD            IN (' ', 'P')                      
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35227                                                                  
T35227     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T35227                                                                  
T35227     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T35227         CONTINUE                                                 
T35227     ELSE                                                         
T35227         DISPLAY '********** PCSWK112 ABORT ************'         
T35227         DISPLAY '* 7300-GET-LATEST-BILL-VER           *'         
T35227         DISPLAY '* ACCOUNT_NO       = ' BG-ACCOUNT-NO            
T35227         DISPLAY '* CODE_UTIL_TYPE   = ' BG-CODE-UTIL-TYPE        
T35227         DISPLAY '* IC_NO            = ' BG-IC-NO                 
T35227         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
T35227         DISPLAY '* PROGRAM ABORTING...                *'         
T35227         DISPLAY '********** PCSWK112 ABORT ************'         
T35227         PERFORM 9900-ABEND              THRU 9900-EXIT           
T35227     END-IF.                                                      
T35227*                                                                         
T35227 7300-EXIT.                                                       
T35227     EXIT.                                                        
T35227*                                                                         
T25407******************************************************************        
T25407*  7500-SELECT-WT-PSNC                                           *        
T25407*  THIS PARAGRAPH WILL SELECT WEATHER TREND DATA FROM            *        
T25407*  CSS_WEATHER_TREND TABLE FOR REVENUE CLASS 20 & COMPANY '26'   *        
T25407******************************************************************        
T25407*                                                                         
T25407 7500-SELECT-WT-PSNC.                                             
T25407     EXEC SQL                                                     
T25407        SELECT FACTOR                                             
T25407         INTO  :WT-FACTOR                                         
T25407        FROM   CSS_WEATHER_TREND WITH(READUNCOMMITTED)                    
T25407         WHERE DATE_BILL  =  IIF(TRY_CONVERT(DATE, :WT-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :WT-DATE-BILL
              ) <> 0) OR (LEN(:WT-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :WT-DATE-BILL
              ), CONVERT(DATE, :WT-DATE-BILL) )  AND                   
T25407              COMPANY_NO  =  :WT-COMPANY-NO AND                   
T25407           CODE_UTIL_TYPE =  :WT-CODE-UTIL-TYPE  AND              
T25407        CODE_REVENUE_CLASS = :WT-CODE-REVENUE-CLASS               
C35227                                                           
T25407     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FACTOR                                                     
MFA-TR*        INTO  :WT-FACTOR                                                 
MFA-TR*       FROM   CSS_WEATHER_TREND                                          
MFA-TR*        WHERE DATE_BILL  =  :WT-DATE-BILL  AND                           
MFA-TR*             COMPANY_NO  =  :WT-COMPANY-NO AND                           
MFA-TR*          CODE_UTIL_TYPE =  :WT-CODE-UTIL-TYPE  AND                      
MFA-TR*       CODE_REVENUE_CLASS = :WT-CODE-REVENUE-CLASS                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25407*                                                                         
T25407     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T25407*                                                                         
T25407     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T25407         CONTINUE                                                 
T25407     ELSE                                                         
T25407         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T25407            DISPLAY '********** PCSWK112 ******************'      
T25407            DISPLAY 'REVENUE CLASS 020 NOT FOUND FOR PSNC '       
T25407            DISPLAY '********** PCSWK112 ******************'      
T25407         ELSE                                                     
T25407            DISPLAY '********** PCSWK112 ABORT ************'      
T25407            DISPLAY '* 7500-SELECT-WT-PSNC                *'      
T25407            DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
T25407            DISPLAY '* DATE BILL = ', WT-DATE-BILL                
T25407            DISPLAY '* COMPANY NO =', WT-COMPANY-NO               
T25407            DISPLAY '* PROGRAM ABORTING...                *'      
T25407            DISPLAY '********** PCSWK112 ABORT ************'      
T25407            PERFORM 9900-ABEND              THRU 9900-EXIT        
T25407        END-IF                                                    
T25407     END-IF.                                                      
T25407*                                                                         
T25407 7500-EXIT.                                                       
T25407     EXIT.                                                        
T25407*                                                                         
T25407******************************************************************        
T25407*  7600-INSERT-WT-PSNC                                           *        
T25407*  THIS PARAGRAPH WILL INSERT WEATHER TREND DATA INTO            *        
T25407*  CSS_WEATHER_TREND TABLE FOR MISSING REVENUE CLASSES WITH      *        
T25407*  DATA FROM REVENUE CLASS -020 FOR PSNC                         *        
T25407******************************************************************        
T25407*                                                                         
T25407 7600-INSERT-WT-PSNC.                                             
T25407     EXEC SQL                                                     
T25407        SELECT FACTOR                                             
T25407         INTO :WS-WT-FACTOR                                       
T25407        FROM   CSS_WEATHER_TREND WITH(READUNCOMMITTED)                    
T25407         WHERE DATE_BILL  =  IIF(TRY_CONVERT(DATE, :WT-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :WT-DATE-BILL
              ) <> 0) OR (LEN(:WT-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :WT-DATE-BILL
              ), CONVERT(DATE, :WT-DATE-BILL) )  AND                   
T25407              COMPANY_NO  =  :WT-COMPANY-NO AND                   
T25407           CODE_UTIL_TYPE =  :WT-CODE-UTIL-TYPE  AND              
T25407        CODE_REVENUE_CLASS = :WT-CODE-REVENUE-CLASS               
C35227                                                           
T25407     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FACTOR                                                     
MFA-TR*        INTO :WS-WT-FACTOR                                               
MFA-TR*       FROM   CSS_WEATHER_TREND                                          
MFA-TR*        WHERE DATE_BILL  =  :WT-DATE-BILL  AND                           
MFA-TR*             COMPANY_NO  =  :WT-COMPANY-NO AND                           
MFA-TR*          CODE_UTIL_TYPE =  :WT-CODE-UTIL-TYPE  AND                      
MFA-TR*       CODE_REVENUE_CLASS = :WT-CODE-REVENUE-CLASS                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25407*                                                                         
T25407     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T25407*                                                                         
T25407     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T25407         MOVE WT-CODE-REVENUE-CLASS  TO WS-TEMP-REV-CLASS         
T25407         ADD +10                     TO WS-TEMP-REV-CLASS         
T25407         MOVE WS-TEMP-REV-CLASS TO WT-CODE-REVENUE-CLASS          
T25407     ELSE                                                         
T25407         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T25407            PERFORM 8000-INSERT-INTO-WT THRU 8000-EXIT            
T25407            MOVE WT-CODE-REVENUE-CLASS  TO WS-TEMP-REV-CLASS      
T25407            ADD +10                     TO WS-TEMP-REV-CLASS      
T25407            MOVE WS-TEMP-REV-CLASS TO WT-CODE-REVENUE-CLASS       
T25407         ELSE                                                     
T25407            DISPLAY '********** PCSWK112 ABORT ************'      
T25407            DISPLAY '* 7600-INSERT-WT-PSNC                *'      
T25407            DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
T25407            DISPLAY '* DATE BILL = ', WT-DATE-BILL                
T25407            DISPLAY '* COMPANY NO =', WT-COMPANY-NO               
T25407            DISPLAY '* PROGRAM ABORTING...                *'      
T25407            DISPLAY '********** PCSWK112 ABORT ************'      
T25407            PERFORM 9900-ABEND              THRU 9900-EXIT        
T25407        END-IF                                                    
T25407     END-IF.                                                      
T25407*                                                                         
T25407 7600-INSERT-EXIT.                                                
T25407     EXIT.                                                        
T25407*                                                                         
T28883******************************************************************        
T28883*  7700-GET-DATABASE.                                            *        
T28883*  DETERMINE WHETHER WE'RE IN SEB OR CSR.                        *        
T28883******************************************************************        
T28883 7700-GET-DATABASE.                                               
T28883                                                                  
T28883     EXEC SQL                                                     
T28883        SELECT  DELINQ_VALUE                                      
T28883          INTO  :C8-DELINQ-VALUE                                  
T28883          FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T28883         WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
T28883           AND  COMPANY_NO = :C8-COMPANY-NO                       
C35227                                                           
T28883     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO  :C8-DELINQ-VALUE                                          
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*          AND  COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T28883                                                                  
T28883     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
T28883                                                                  
T28883     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T28883           NEXT SENTENCE                                          
T28883     ELSE                                                         
T28883         DISPLAY '********** PCSWK112 ABORT ************'         
T28883         DISPLAY '* 7700-GET-DATABASE'                            
T28883         DISPLAY '* DELINQ_CD       = ' C8-DELINQ-CD              
T28883         DISPLAY '* COMPANY_NO      = ' C8-COMPANY-NO             
T28883         DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
T28883         DISPLAY '********** PCSWK112 ABORT ************'         
T28883         PERFORM 9900-ABEND   THRU 9900-EXIT                      
T28883     END-IF.                                                      
T28883                                                                  
T28883 7700-EXIT.                                                       
T28883     EXIT.                                                        
T28883                                                                  
      ******************************************************************        
      **  8000-INSERT-INTO-WT                                         **        
      **  THIS LOGIC INSERTS WEATHER TREND DATA                       **        
      ******************************************************************        
       8000-INSERT-INTO-WT.                                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_WEATHER_TREND                            
                  ( DATE_BILL                                           
                   ,COMPANY_NO                                          
                   ,CODE_UTIL_TYPE                                      
                   ,CODE_REVENUE_CLASS                                  
                   ,UNITS_ACCUM                                         
                   ,FACTOR )                                            
                  VALUES                                                
                  ( IIF(TRY_CONVERT(DATE, :WT-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :WT-DATE-BILL
              ) <> 0) OR (LEN(:WT-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :WT-DATE-BILL
              ), CONVERT(DATE, :WT-DATE-BILL) )                                
                   ,:WT-COMPANY-NO                                      
                   ,:WT-CODE-UTIL-TYPE                                  
                   ,:WT-CODE-REVENUE-CLASS                              
                   ,:WT-UNITS-ACCUM                                     
                   ,:WT-FACTOR )                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_WEATHER_TREND                                    
MFA-TR*           ( DATE_BILL                                                   
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,CODE_REVENUE_CLASS                                          
MFA-TR*            ,UNITS_ACCUM                                                 
MFA-TR*            ,FACTOR )                                                    
MFA-TR*           VALUES                                                        
MFA-TR*           ( :WT-DATE-BILL                                               
MFA-TR*            ,:WT-COMPANY-NO                                              
MFA-TR*            ,:WT-CODE-UTIL-TYPE                                          
MFA-TR*            ,:WT-CODE-REVENUE-CLASS                                      
MFA-TR*            ,:WT-UNITS-ACCUM                                             
MFA-TR*            ,:WT-FACTOR )                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS           
                   PERFORM 8100-UPDATE-WT THRU 8100-EXIT                
               ELSE                                                     
                   DISPLAY '********** PCSWK112 ABORT ************'     
                   DISPLAY '* 8000-INSERT-INTO-WT                *'     
                   DISPLAY '* DATE_BILL  = ', WT-DATE-BILL              
                   DISPLAY '* UTIL_TYPE  = ', WT-CODE-UTIL-TYPE         
                   DISPLAY '* REVENUE_CLASS = ', WT-CODE-REVENUE-CLASS  
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* PROGRAM ABORTING...                *'     
                   DISPLAY '********** PCSWK112 ABORT ************'     
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8100-UPDATE-WT                                              **        
      **  THIS LOGIC UPDATES THE CSS_WEATHER_TREND.                   **        
      ******************************************************************        
      *                                                                         
       8100-UPDATE-WT.                                                  
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_WEATHER_TREND                                   
                SET UNITS_ACCUM        = :WT-UNITS-ACCUM                
                   ,FACTOR             = :WT-FACTOR                     
              WHERE DATE_BILL          = IIF(TRY_CONVERT(DATE, 
                                                          :WT-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :WT-DATE-BILL
              ) <> 0) OR (LEN(:WT-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :WT-DATE-BILL
              ), CONVERT(DATE, :WT-DATE-BILL) )                  
                AND COMPANY_NO         = :WT-COMPANY-NO                 
                AND CODE_REVENUE_CLASS = :WT-CODE-REVENUE-CLASS         
                AND CODE_UTIL_TYPE     = :WT-CODE-UTIL-TYPE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_WEATHER_TREND                                           
MFA-TR*         SET UNITS_ACCUM        = :WT-UNITS-ACCUM                03467500
MFA-TR*            ,FACTOR             = :WT-FACTOR                             
MFA-TR*       WHERE DATE_BILL          = :WT-DATE-BILL                          
MFA-TR*         AND COMPANY_NO         = :WT-COMPANY-NO                         
MFA-TR*         AND CODE_REVENUE_CLASS = :WT-CODE-REVENUE-CLASS                 
MFA-TR*         AND CODE_UTIL_TYPE     = :WT-CODE-UTIL-TYPE                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSWK112 ABORT ************'         
               DISPLAY '* 8100-UPDATE-WT                     *'         
               DISPLAY '* DATE_BILL  = ', WT-DATE-BILL                  
               DISPLAY '* UTIL_TYPE  = ', WT-CODE-UTIL-TYPE             
               DISPLAY '* REVENUE_CLASS = ', WT-CODE-REVENUE-CLASS      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSWK112 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03629000
      ******************************************************************03629000
      * WRITES FIOWK112 RECORD TO THE FILE AND INITIALIZES THE RECORD  *        
      ******************************************************************03632000
       8200-WRITE-FCSWK112.                                             
      *                                                                         
           MOVE WS-COMMA                   TO E-FWK112-SEP1,            
                                              E-FWK112-SEP2,            
                                              E-FWK112-SEP3,            
                                              E-FWK112-SEP4,            
                                              E-FWK112-SEP5,            
                                              E-FWK112-SEP6,            
                                              E-FWK112-SEP7,            
                                              E-FWK112-SEP8,            
                                              E-FWK112-SEP9.            
           WRITE FIOWK112.                                              
           IF FWK112-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8200-ERROR ON FCSWK112 WRITE '                  
               DISPLAY 'FCSWK112 FILE STATUE IS ==>' WS-FWK112-STATUS   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           MOVE SPACES TO FIOWK112.                                     
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * CLOSE ALL FILES                                            *            
      **************************************************************            
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSWK112-FILE.                                         
      *                                                                         
           IF  FWK112-SUCCESSFUL                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'FILE CLOSE ERROR'                               
               DISPLAY 'FCSWK112 FILE STATUS ==>' WS-FWK112-STATUS      
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
