       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSUM303.                                        
       DATE-WRITTEN.   05/2003.                                         
       DATE-COMPILED.                                                   
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRICITY AND GAS              **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                GAS METERS INACTIVE REPORT                   **         
      **                                                             **         
      ** PCSUM303 REPORTS  METERS INACTIVE AND ACCOUNTS INACTIVE FOR **         
      ** LONGER THAN 20 MONTHS AND LESS THAN 24 MONTHS.              **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  05/02/04   R. KELLEY    NEW PROGRAM FOR REPORT GENERATION  **         
T35434**  05/31/07   MK92804      REPLACED MODEL_SQL WITH SET COMMAND**         
T35434**                          AND ADDED FETCH ONLY WITH UR TO    **         
T35434**                          AVOID -911 ABENDS.                 **         
      **  04/01/08  L.PRUETT     ADD COMMA     DELIMITED FILE        **         
      **                                                             **         
A01209**  23 FEB 10 RF10596      ADD READ ROUTE TO OUTPUT FILE       **         
      **                                                             **         
A01209**  12 MAR 10 RF10596      ADD NULL DATE CHECK IN CURSOR       **         
      **                                                             **         
      **  --------  --------     ----------------------------------  **         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSUM303 REPORTS ----      
                   ----- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
       COPY CSSPT331.                                                           
      *                                                                         
            SELECT FCSPTXX-FILE                                         
                ASSIGN UT-S-FCSPTXX.                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
       COPY CFDPT331.                                                           
      *                                                                         
       FD  FCSPTXX-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
      *    RECORDING MODE IS F                                                  
           LABEL RECORDS ARE STANDARD.                                  
A01209 01  EXCEL-XX-RECORD    PIC X(227).                               
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSUM303'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSUM303 STARTS HERE'.                  
      *                                                                         
       01  WS-PRT331-REC.                                               
           05  WS-PRT331-CC            PIC X(01).                       
           05  WS-PRT331-DATA          PIC X(132).                      
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
      *                                                                         
      ******************************************************************        
      *   FCA00 MISC                                                   *        
      ******************************************************************        
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FIRST-TIME           PIC X(01)    VALUE 'Y'.          
               88  FIRST-TIME                       VALUE 'Y'.          
           05  WS-ACCT-REPORT          PIC X(01)    VALUE 'N'.          
               88  ACCT-REPORT                      VALUE 'Y'.          
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-REC-COUNT            PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-RPT-COUNT            PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-LOC-COUNT            PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-JOB-PARM-DT          PIC X(10)    VALUE SPACES.       
           05  WS-CURR-DATE            PIC X(10)    VALUE SPACES.       
           05  WS-TWENTY-MTH-PRIOR-DT  PIC X(10).                       
           05  WS-TWENTY4-MTH-PRIOR-DT PIC X(10).                       
           05  WS-MTH-PRIOR-DT         PIC X(10).                       
           05  WS-PREV-LOCOFF1         PIC X(03)    VALUE SPACES.       
           05  WS-PREV-ACCOUNT-NO      PIC 9(13)    VALUE ZEROS.        
           05  WS-STATUS-DESC          PIC X(15)    VALUE SPACES.       
           05  WS-FCA331-STATUS        PIC X(02).                       
           05  WS-CNTR                 PIC 9(02)    VALUE 0.            
           05  WS-NO-YEARS             PIC S9(04)   VALUE 0 COMP.       
           05  WS-NO-MONTHS            PIC S9(04)   VALUE 0 COMP.       
           05  WS-INACTIVE-MONTHS      PIC 9(04)    VALUE 0.            
           05  WS-NULL-1               PIC S9(04)   VALUE 0 COMP.       
           05  WS-NULL-2               PIC S9(04)   VALUE 0 COMP.       
           05  WS-MTR-CNST             PIC 9(6)V999.                    
           05  WS-MTR-SIZE-ID          PIC X(08).                       
           05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSUM303'.   
           05  RS-RETURN-CODE          PIC S9(9)    VALUE +000 COMP.    
           05  RS-RETURN-CODE-DISP     PIC S9(9)    VALUE +000 COMP.    
           05  WS-RPT1-LINE-NO         PIC 9(02)    VALUE 62   COMP-3.  
           05  WS-RPT1-PAGE-NO         PIC 9(05)    VALUE ZERO COMP-3.  
           05  WS-LINE-SPACE           PIC 9(01)    VALUE ZERO.         
           05  WS-LINE                 PIC X(132)   VALUE ALL '-'.      
           05  WS-PREV-COMP-NO         PIC X(02)    VALUE ' '.          
           05  WS-PARM-MNTH            PIC X(02)    VALUE SPACES.       
           05  WS-PARM-MNTH1           PIC S9(04)   COMP.               
           05  WS-INPUT-PARM-DATA      PIC X(80)    VALUE SPACES.       
           05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE SPACES.       
           05  WS-COMP-NO              PIC X(02)    VALUE '01'.         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(09)    VALUE 'PCSUM303-'.  
           05  WS-ACTIVE               PIC X(13)    VALUE 'ACTIVE'.     
           05  WS-INACTIVE             PIC X(13)    VALUE 'INACTIVE'.   
           05  WS-FINAL-BILL           PIC X(13)    VALUE 'FINAL-BILL'. 
           05  WS-WRITE-OFF            PIC X(13)    VALUE 'WRITE-OFF'.  
           05  WS-PENDING              PIC X(13)    VALUE 'PENDING'.    
           05  WS-REMOVED              PIC X(13)    VALUE 'REMOVED'.    
           05  WS-PARM1                PIC X(04)    VALUE 'PARM'.       
           05  WS-G                    PIC X(01)    VALUE 'G'.          
           05  WS-0                    PIC 9(01)    VALUE 0.            
           05  WS-ZERO                 PIC X(02)    VALUE '00'.         
           05  WS-1                    PIC 9(01)    VALUE 1.            
           05  WS-2                    PIC 9(01)    VALUE 2.            
           05  WS-3                    PIC 9(01)    VALUE 3.            
           05  WS-TWENTY               PIC X(02)    VALUE '20'.         
           05  WS-TWENTY4              PIC X(02)    VALUE '24'.         
           05  WS-07                   PIC 9(01)    VALUE 7.            
           05  WS-09                   PIC 9(01)    VALUE 9.            
           05  WS-57                   PIC 9(02)    VALUE 57.           
           05  WS-60                   PIC 9(02)    VALUE 60.           
           05  WS-SEMIC                PIC X        VALUE ','.          
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MIN                  PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CCYY                 PIC X(04).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-MM                   PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-DD                   PIC X(02).                       
      *                                                                         
       01  WS-REP-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-CCYY              PIC X(04).                       
      *                                                                         
       01  WS-TABLE.                                                    
           05  WS-DET-LINE OCCURS 4 TIMES.                              
               10  WS-ACCOUNT-NO       PIC X(13).                       
               10  WS-NAME-ADDR        PIC X(50).                       
               10  WS-METER-NO         PIC X(09).                       
               10  WS-METER-SIZE-ID    PIC X(08).                       
               10  WS-STATUS           PIC X(15).                       
               10  WS-INACTIVE-MTHS    PIC X(04).                       
               10  WS-METER-CONSTANT   PIC 9(06)V9(3).                  
A01209         10  WS-READ-ROUTE       PIC 9(4).                        
      *                                                                         
       01  WS-REPORT-HEADERS.                                           
      *                                                                         
           05  WS-DEFAULT-RPT1-HEADER1.                                 
               10  WS-RPT-HEADER1-1    PIC X(54)   VALUE                
               '           GAS METERS INACTIVE BETWEEN 20 TO 24 MONTHS'.
               10  FILLER              PIC X(36)   VALUE SPACES.        
           05  WS-DEFAULT-RPT1-HEADER2.                                 
               10  FILLER              PIC X(40)   VALUE SPACES.        
               10  FILLER              PIC X(22)   VALUE                
               'CURRENT DATE RANGE IS '.                                
               10  WS-RPT-HEADER1-DT1  PIC X(10).                       
               10  FILLER              PIC X(09)   VALUE                
               ' THROUGH '.                                             
               10  WS-RPT-HEADER1-DT2  PIC X(10).                       
               10  FILLER              PIC X(42)   VALUE SPACES.        
           05  WS-DEFAULT-RPT2-HEADER2.                                 
               10  WS-RPT-HEADER2-1    PIC X(43)   VALUE                
               '   GAS ACCOUNTS INACTIVE WITH ACTIVE METERS'.           
               10  FILLER              PIC X(27)   VALUE SPACES.        
           05  WS-DEFAULT-RPT-HEADER2.                                  
               10  FILLER              PIC X(14)    VALUE               
               'CURRENT AS OF '.                                        
               10  WS-DEFAULT-RPT-HEADER2-DT                            
                                       PIC X(10).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT-TITLE.                                            
               10  P-RPT-TITLE-PGNM    PIC X(09)    VALUE SPACES.       
               10  P-RPT-TITLE-NBR     PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(42)    VALUE SPACES.       
               10  P-RPT-COMP-NAME     PIC X(26).                       
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT-RUN-DATE      PIC X(10).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER.                                           
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT-DATE          PIC X(10).                       
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  P-RPT-HEAD1         PIC X(70).                       
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT-RUN-TIME      PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER              PIC X(53)    VALUE SPACES.       
               10  P-RPT-HEAD2         PIC X(24)    VALUE SPACES.       
               10  FILLER              PIC X(39)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  FILLER              PIC X(04)    VALUE SPACES.       
               10  P-RPT-PAGE-NO       PIC ZZ,ZZ9.                      
      *                                                                         
           05  WS-LOCAL-OFFICE-HEADER.                                  
               10  FILLER              PIC X(15)    VALUE               
                                                   'LOCAL OFFICE - '.   
               10  P-LOCAL-OFFICE      PIC X(03).                       
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-LOCAL-OFFICE-DESC PIC X(22).                       
               10  FILLER              PIC X(90)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
A01209     05  WS-COLUMN-HEADER-1.                                      
A01209         10  FILLER              PIC X(18)    VALUE SPACES.       
A01209         10  FILLER              PIC X(08)    VALUE 'CUSTOMER'.   
A01209         10  FILLER              PIC X(44)    VALUE SPACES.       
A01209         10  FILLER              PIC X(05)    VALUE 'METER'.      
A01209         10  FILLER              PIC X(08)    VALUE SPACE.        
A01209         10  FILLER              PIC X(04)    VALUE 'SIZE'.       
A01209         10  FILLER              PIC X(8)     VALUE SPACES.       
A01209         10  WS-STATUS-HDR       PIC X(07)    VALUE 'ACCOUNT'.    
A01209         10  FILLER              PIC X(4)     VALUE SPACES.       
A01209         10  FILLER              PIC X(4)     VALUE 'MTHS'.       
A01209         10  FILLER              PIC X(5)     VALUE SPACES.       
A01209         10  FILLER              PIC X(6)     VALUE 'METER'.      
A01209         10  FILLER              PIC X(6)     VALUE SPACES.       
A01209         10  FILLER              PIC X(4)     VALUE 'READ'.       
A01209         10  FILLER              PIC X(3)     VALUE SPACES.       
      *                                                                         
A01209     05  WS-COLUMN-HEADER-2.                                      
A01209         10  FILLER              PIC X(14)    VALUE               
A01209                                             'ACCOUNT NUMBER'.    
A01209         10  FILLER              PIC X(04)    VALUE SPACES.       
A01209         10  FILLER              PIC X(15)    VALUE               
A01209                                             'SERVICE ADDRESS'.   
A01209         10  FILLER              PIC X(37)    VALUE SPACES.       
A01209         10  FILLER              PIC X(06)    VALUE               
A01209                                             'NUMBER'.            
A01209         10  FILLER              PIC X(07)    VALUE SPACES.       
A01209         10  FILLER              PIC XX       VALUE 'ID'.         
A01209         10  FILLER              PIC X(10)    VALUE SPACES.       
A01209         10  FILLER              PIC X(06)    VALUE 'STATUS'.     
A01209         10  FILLER              PIC X(5)     VALUE SPACES.       
A01209         10  FILLER              PIC X(5)     VALUE 'INACT'.      
A01209         10  FILLER              PIC X(4)     VALUE SPACES.       
A01209         10  FILLER              PIC X(8)     VALUE 'CONSTANT'.   
A01209         10  FILLER              PIC X(3)     VALUE SPACES.       
A01209         10  FILLER              PIC X(5)     VALUE 'ROUTE'.      
A01209         10  FILLER              PIC X(2)     VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **        WORKING STORAGE FOR REPORT DETAIL LINES             **          
      ****************************************************************          
      *                                                                         
A01209 01  WS-DETAIL-TABLE.                                             
A01209     05  WS-DETAIL-LINE  OCCURS 4 TIMES INDEXED BY WS-INDX.       
A01209         10  FILLER              PIC X(01)    VALUE SPACES.       
A01209         10  P-ACCOUNT-NO        PIC X(13).                       
A01209         10  FILLER              PIC X(05)    VALUE SPACES.       
A01209         10  P-NAME-ADDR         PIC X(50).                       
A01209         10  FILLER              PIC X(02)    VALUE SPACES.       
A01209         10  P-METER-NUMBER      PIC X(09).                       
A01209         10  FILLER              PIC X(04)    VALUE SPACES.       
A01209         10  P-METER-SIZE-ID     PIC X(08).                       
A01209         10  FILLER              PIC X(4)     VALUE SPACES.       
A01209         10  P-STATUS            PIC X(10).                       
A01209         10  FILLER              PIC X        VALUE SPACES.       
A01209         10  P-INACTIVE-MTHS     PIC Z(3)9.                       
A01209         10  P-INACTIVE-MTHS1 REDEFINES P-INACTIVE-MTHS           
A01209                                 PIC X(04).                       
A01209         10  FILLER              PIC XX       VALUE SPACES.       
A01209         10  P-MTR-CNST          PIC Z(05)9.999.                  
A01209         10  P-MTR-CNST1 REDEFINES P-MTR-CNST                     
A01209                                 PIC X(10).                       
A01209         10  FILLER              PIC X(4)     VALUE SPACES.       
A01209         10  P-READ-ROUTE        PIC X(4).                        
A01209         10  FILLER              PIC X(2)     VALUE SPACES.       
      *                                                                         
        01 WS-EXCEL-DATA.                                               
           05  EXCEL-LOCAL-OFF      PIC X(03).                          
           05  EXCEL-SEMIC0         PIC X(01) VALUE ','.                
           05  EXCEL-ACCOUNT-NO     PIC X(13).                          
           05  EXCEL-SEMIC1         PIC X(01) VALUE ','.                
           05  EXCEL-NAME-ADDR      PIC X(50).                          
           05  EXCEL-SEMIC2         PIC X(01) VALUE ','.                
           05  EXCEL-NAME-ADDR1     PIC X(50).                          
           05  EXCEL-SEMIC3         PIC X(01) VALUE ','.                
           05  EXCEL-NAME-ADDR2     PIC X(50).                          
           05  EXCEL-SEMIC4         PIC X(01) VALUE ','.                
           05  EXCEL-METER-NUMBER   PIC X(9).                           
           05  EXCEL-SEMIC5         PIC X(01) VALUE ','.                
           05  EXCEL-METER-SIZE-ID  PIC X(8).                           
           05  EXCEL-SEMIC6         PIC X(01) VALUE ','.                
           05  EXCEL-STATUS         PIC X(15).                          
           05  EXCEL-SEMIC7         PIC X(01) VALUE ','.                
           05  EXCEL-INACTIVE-MTHS  PIC X(04).                          
           05  EXCEL-SEMIC8         PIC X(01) VALUE ','.                
           05  EXCEL-MTR-CNST       PIC 9(10).                          
           05  EXCEL-SEMIC9         PIC X(01) VALUE ','.                
A01209     05  EXCEL-READ-ROUTE     PIC 9(4).                           
A01209     05  EXCEL-SEMIC10        PIC X(01) VALUE ','.                
      *                                                                         
       01  WS-TOTAL-LINE.                                               
           05  FILLER                  PIC X(13)    VALUE SPACES.       
           05  P-TOT-MESSAGE           PIC X(26).                       
           05  P-TOT-RECORDS           PIC ZZZ,ZZZ,ZZ9.                 
           05  FILLER                  PIC X(82)    VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION TO SELECT INACTIVE METERS                            
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
            DECLARE METER_INACTIVE CURSOR FOR                           
             SELECT  AT.COMPANY_NO                                      
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.CUSTOMER_NO                                     
                    ,AT.PREMISE_NO                                      
                    ,AT.ADDRESS_ID                                      
                    ,AT.ADDRESS_FORMAT                                  
                    ,MN.ACCOUNT_NO                                      
                    ,MN.METER_NO                                        
                    ,MN.LAST_REG_READ_DATE                              
                    ,CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ), 
           MN.MTR_STATUS_CHNG_DT ))      
                    ,CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ), 
           MN.MTR_STATUS_CHNG_DT ))     
                    ,MN.REG_ID_NO                                       
                    ,MN.REGISTER_RD_SEQ                                 
                    ,UT.RATE_PLAN_NO                                    
                    ,UT.READ_CYCLE                                      
                    ,UT.READ_ROUTE                                      
                    ,GM.METER_SIZE_ID                                   
               FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
                    ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
              WHERE  AT.ACCOUNT_NO         = MN.ACCOUNT_NO              
                AND  AT.ACCOUNT_NO         = UT.ACCOUNT_NO              
                AND  MN.CODE_UTIL_TYPE     = :WS-G                      
                AND  MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE          
                AND  MN.IC_NO              = UT.IC_NO                   
                AND  MN.CODE_METER_STATUS  = 'J'                        
A01209          AND ((MN.MTR_STATUS_CHNG_DT > IIF(TRY_CONVERT(DATE, 
                                               :WS-TWENTY4-MTH-PRIOR-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-TWENTY4-MTH-PRIOR-DT
              ) <> 0) OR (LEN(:WS-TWENTY4-MTH-PRIOR-DT
              ) <> 10), CIS.CHAR2DATE(:WS-TWENTY4-MTH-PRIOR-DT
              ), CONVERT(DATE, :WS-TWENTY4-MTH-PRIOR-DT) )  
A01209          AND  MN.MTR_STATUS_CHNG_DT < IIF(TRY_CONVERT(DATE, 
                                                :WS-TWENTY-MTH-PRIOR-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-TWENTY-MTH-PRIOR-DT
              ) <> 0) OR (LEN(:WS-TWENTY-MTH-PRIOR-DT
              ) <> 10), CIS.CHAR2DATE(:WS-TWENTY-MTH-PRIOR-DT
              ), CONVERT(DATE, :WS-TWENTY-MTH-PRIOR-DT) ))   
A01209           OR  MN.MTR_STATUS_CHNG_DT IS NULL)                     
                AND  GM.METER_NO           = MN.METER_NO                
                AND  AT.COMPANY_NO         = :WS-COMP-NO                
                AND  GM.COMPANY_NO         = AT.COMPANY_NO              
              ORDER BY AT.COMPANY_NO                                    
                      ,AT.LOCAL_OFFICE                                  
A01209                ,UT.READ_CYCLE                                    
A01209                ,UT.READ_ROUTE                                    
A01209                ,MN.REGISTER_RD_SEQ                               
T35434          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE METER_INACTIVE CURSOR FOR                                   
MFA-TR*      SELECT  AT.COMPANY_NO                                              
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.ADDRESS_ID                                              
MFA-TR*             ,AT.ADDRESS_FORMAT                                          
MFA-TR*             ,MN.ACCOUNT_NO                                              
MFA-TR*             ,MN.METER_NO                                                
MFA-TR*             ,MN.LAST_REG_READ_DATE                                      
MFA-TR*             ,YEAR(:WS-JOB-PARM-DT - MN.MTR_STATUS_CHNG_DT)              
MFA-TR*             ,MONTH(:WS-JOB-PARM-DT - MN.MTR_STATUS_CHNG_DT)             
MFA-TR*             ,MN.REG_ID_NO                                               
MFA-TR*             ,MN.REGISTER_RD_SEQ                                         
MFA-TR*             ,UT.RATE_PLAN_NO                                            
MFA-TR*             ,UT.READ_CYCLE                                              
MFA-TR*             ,UT.READ_ROUTE                                              
MFA-TR*             ,GM.METER_SIZE_ID                                           
MFA-TR*        FROM  CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_GAS_METER GM                                           
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*       WHERE  AT.ACCOUNT_NO         = MN.ACCOUNT_NO                      
MFA-TR*         AND  AT.ACCOUNT_NO         = UT.ACCOUNT_NO                      
MFA-TR*         AND  MN.CODE_UTIL_TYPE     = :WS-G                              
MFA-TR*         AND  MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                  
MFA-TR*         AND  MN.IC_NO              = UT.IC_NO                           
MFA-TR*         AND  MN.CODE_METER_STATUS  = 'J'                                
MFA-TR*         AND ((MN.MTR_STATUS_CHNG_DT > :WS-TWENTY4-MTH-PRIOR-DT          
MFA-TR*         AND  MN.MTR_STATUS_CHNG_DT < :WS-TWENTY-MTH-PRIOR-DT)           
MFA-TR*          OR  MN.MTR_STATUS_CHNG_DT IS NULL)                             
MFA-TR*         AND  GM.METER_NO           = MN.METER_NO                        
MFA-TR*         AND  AT.COMPANY_NO         = :WS-COMP-NO                        
MFA-TR*         AND  GM.COMPANY_NO         = AT.COMPANY_NO                      
MFA-TR*       ORDER BY AT.COMPANY_NO                                            
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,UT.READ_CYCLE                                            
MFA-TR*               ,UT.READ_ROUTE                                            
MFA-TR*               ,MN.REGISTER_RD_SEQ                                       
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION TO SELECT INACTIVE ACCOUNTS                          
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE  ACCT_INACTIVE CURSOR FOR                        
                SELECT  AT.COMPANY_NO                                   
                       ,AT.LOCAL_OFFICE                                 
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.CUSTOMER_NO                                  
                       ,AT.PREMISE_NO                                   
                       ,AT.ADDRESS_ID                                   
                       ,AT.ADDRESS_FORMAT                               
                       ,MN.ACCOUNT_NO                                   
                       ,MN.METER_NO                                     
                       ,MN.LAST_REG_READ_DATE                           
                       ,MN.CODE_METER_STATUS                            
                       ,CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ), 
           MN.LAST_REG_READ_DATE ))   
                       ,CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ), 
           MN.LAST_REG_READ_DATE ))  
                       ,MN.REG_ID_NO                                    
                       ,MN.REGISTER_RD_SEQ                              
                       ,UT.RATE_PLAN_NO                                 
                       ,UT.READ_CYCLE                                   
                       ,UT.READ_ROUTE                                   
                  FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                 WHERE  AT.ACCOUNT_NO         = MN.ACCOUNT_NO           
                   AND  AT.ACCOUNT_NO         = UT.ACCOUNT_NO           
                   AND  AT.CODE_ACCT_STAT    IN ('B', 'J')              
                   AND  MN.CODE_UTIL_TYPE     = :WS-G                   
                   AND  MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE       
                   AND  MN.IC_NO              = UT.IC_NO                
                   AND  MN.CODE_METER_STATUS IN ('A', 'B', 'I')         
                   AND  AT.COMPANY_NO         = :WS-COMP-NO             
                 ORDER BY AT.COMPANY_NO                                 
                         ,AT.LOCAL_OFFICE                               
A01209                   ,UT.READ_CYCLE                                 
A01209                   ,UT.READ_ROUTE                                 
                         ,MN.REGISTER_RD_SEQ                            
T35434             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE  ACCT_INACTIVE CURSOR FOR                                
MFA-TR*         SELECT  AT.COMPANY_NO                                           
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.CUSTOMER_NO                                          
MFA-TR*                ,AT.PREMISE_NO                                           
MFA-TR*                ,AT.ADDRESS_ID                                           
MFA-TR*                ,AT.ADDRESS_FORMAT                                       
MFA-TR*                ,MN.ACCOUNT_NO                                           
MFA-TR*                ,MN.METER_NO                                             
MFA-TR*                ,MN.LAST_REG_READ_DATE                                   
MFA-TR*                ,MN.CODE_METER_STATUS                                    
MFA-TR*                ,YEAR(:WS-JOB-PARM-DT - MN.LAST_REG_READ_DATE)           
MFA-TR*                ,MONTH(:WS-JOB-PARM-DT - MN.LAST_REG_READ_DATE)          
MFA-TR*                ,MN.REG_ID_NO                                            
MFA-TR*                ,MN.REGISTER_RD_SEQ                                      
MFA-TR*                ,UT.RATE_PLAN_NO                                         
MFA-TR*                ,UT.READ_CYCLE                                           
MFA-TR*                ,UT.READ_ROUTE                                           
MFA-TR*           FROM  CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_MTRD_ENVRNMT MN                                     
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*          WHERE  AT.ACCOUNT_NO         = MN.ACCOUNT_NO                   
MFA-TR*            AND  AT.ACCOUNT_NO         = UT.ACCOUNT_NO                   
MFA-TR*            AND  AT.CODE_ACCT_STAT    IN ('B', 'J')                      
MFA-TR*            AND  MN.CODE_UTIL_TYPE     = :WS-G                           
MFA-TR*            AND  MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE               
MFA-TR*            AND  MN.IC_NO              = UT.IC_NO                        
MFA-TR*            AND  MN.CODE_METER_STATUS IN ('A', 'B', 'I')                 
MFA-TR*            AND  AT.COMPANY_NO         = :WS-COMP-NO                     
MFA-TR*          ORDER BY AT.COMPANY_NO                                         
MFA-TR*                  ,AT.LOCAL_OFFICE                                       
MFA-TR*                  ,UT.READ_CYCLE                                         
MFA-TR*                  ,UT.READ_ROUTE                                         
MFA-TR*                  ,MN.REGISTER_RD_SEQ                                    
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSUM303 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 1100-PRODUCE-REPORTS        THRU 1100-EXIT.          
      *                                                                         
           PERFORM 1200-PRODUCE-ACCT-REPORT    THRU 1200-EXIT.          
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   0100-INITIALIZATION.                                     **          
      **                                                            **          
      **   SETS CURRENT DATE AND TIME TO THE REPORT, GETS JOB PARM  **          
      **   DATE AND OPENS THE OUTPUT FILES                          **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                          TO WS-RT-HH.             
           MOVE WS-MIN                         TO WS-RT-MM.             
           MOVE WS-SS                          TO WS-RT-SS.             
           MOVE WS-RUN-TIME                    TO P-RPT-RUN-TIME.       
           MOVE WS-PGRMNAME                    TO P-RPT-TITLE-PGNM.     
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                               THRU 6240-EXIT           
              MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE         
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE                  TO WS-JOB-PARM-DT        
                                                  WS-CURRENT-DATE.      
           MOVE WS-CCYY                        TO WS-RD-CCYY.           
           MOVE WS-MM                          TO WS-RD-MM.             
           MOVE WS-DD                          TO WS-RD-DD.             
           MOVE WS-REP-DATE                    TO P-RPT-DATE            
                                    WS-DEFAULT-RPT-HEADER2-DT.          
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF  WS-SYSIN-COMP-NO LESS THAN OR EQUAL                      
                                               TO SPACES OR LOW-VALUES  
               MOVE WS-COMP-NO                 TO WS-SYSIN-COMP-NO      
           END-IF.                                                      
           MOVE PROGRAM-NAME                   TO WS-PROGRAM.           
           MOVE WS-SYSIN-COMP-NO               TO WS-COMP-NO.           
           MOVE WS-COMP-NO                     TO G6-COMPANY-NO.        
           MOVE WS-PARM1                       TO WS-COMMAND.           
           PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT.          
           MOVE G6-PARM-DATA                   TO WS-INPUT-PARM-DATA.   
           MOVE WS-INPUT-PARM-DATA(29:2)       TO WS-PARM-MNTH.         
           IF WS-PARM-MNTH EQUAL SPACES OR LOW-VALUES OR WS-ZERO        
              MOVE WS-TWENTY                   TO WS-PARM-MNTH          
           END-IF.                                                      
           MOVE WS-PARM-MNTH                   TO WS-PARM-MNTH1.        
           PERFORM 7000-GET-MTHS-PRIOR-DT      THRU 7000-EXIT.          
           MOVE WS-MTH-PRIOR-DT               TO WS-TWENTY-MTH-PRIOR-DT.
           MOVE WS-TWENTY-MTH-PRIOR-DT         TO WS-RPT-HEADER1-DT1.   
           PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT.          
           IF END-OF-SYSIPT                                             
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7611-CLOSE               THRU 7611-EXIT           
           END-IF.                                                      
           MOVE G6-PARM-DATA                   TO WS-INPUT-PARM-DATA.   
           MOVE WS-INPUT-PARM-DATA(29:2)       TO WS-PARM-MNTH.         
           IF WS-PARM-MNTH EQUAL SPACES OR LOW-VALUES OR WS-ZERO        
              MOVE WS-TWENTY4                  TO WS-PARM-MNTH          
           END-IF.                                                      
           MOVE WS-PARM-MNTH                   TO WS-PARM-MNTH1.        
           PERFORM 7000-GET-MTHS-PRIOR-DT      THRU 7000-EXIT.          
           MOVE WS-MTH-PRIOR-DT              TO WS-TWENTY4-MTH-PRIOR-DT.
           MOVE WS-TWENTY4-MTH-PRIOR-DT        TO WS-RPT-HEADER1-DT2.   
      *    MOVE WS-PARM-MNTH                   TO WS-RPT1-MNTH.                 
      *                                           WS-RPT2-MNTH.                 
           MOVE WS-CURR-DATE                   TO WS-CURRENT-DATE.      
           MOVE WS-CCYY                        TO WS-RD-CCYY.           
           MOVE WS-MM                          TO WS-RD-MM.             
           MOVE WS-DD                          TO WS-RD-DD.             
           MOVE WS-REP-DATE                    TO P-RPT-RUN-DATE.       
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE, FCSPT331-FILE.                     
           OPEN OUTPUT FCSPTXX-FILE.                                    
      *                                                                         
           PERFORM 7110-OPEN-METER-INACTIVE    THRU 7110-EXIT.          
           PERFORM 7120-FETCH-METER-INACTIVE   THRU 7120-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1100-PRODUCE-REPORTS                                      **          
      **                                                            **          
      **  PROCESSES THOSE RECORDS WHERE ACCOUNT NO FROM CSS_ACCOUNT **          
      **  TABLE IS EQUAL TO THE LATEST ACCOUNT AT THAT PREMISE FOR  **          
      **  METERS THAT ARE INACTIVE FOR MORE THAN SIX MONTHS         **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           MOVE '1100'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               IF UT-RATE-PLAN-NO NOT EQUAL '978'                       
                   MOVE AT-PREMISE-NO             TO WS-CPD99-PREMISE-NO
                   PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT       
                   MOVE WS-CPD99-ACCOUNT-NO        TO AT-ACCOUNT-NO     
                   IF  AT-ACCOUNT-NO EQUAL MN-ACCOUNT-NO                
                       IF  FIRST-TIME                                   
                           PERFORM 2010-LOC-OFF-BRK                     
                                                   THRU 2010-EXIT       
                           MOVE AT-COMPANY-NO      TO WS-PREV-COMP-NO   
                           MOVE AT-COMPANY-NO      TO C7-COMPANY-NO     
                           PERFORM 7300-GET-COMPANY-DESC                
                                                   THRU 7300-EXIT       
                           MOVE C7-COMPANY-NAME    TO P-RPT-COMP-NAME   
                           INITIALIZE WS-TABLE                          
                           PERFORM 2040-ACCUM-DETAILS THRU 2040-EXIT    
                           MOVE WS-N               TO WS-FIRST-TIME     
                       ELSE                                             
                           PERFORM 2020-CHK-FOR-BRKS THRU 2020-EXIT     
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
               PERFORM 7120-FETCH-METER-INACTIVE THRU 7120-EXIT         
           END-PERFORM.                                                 
           PERFORM 7130-CLOSE-METER-INACTIVE   THRU 7130-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               MOVE WS-COMP-NO                 TO C7-COMPANY-NO         
               PERFORM 7300-GET-COMPANY-DESC   THRU 7300-EXIT           
               MOVE C7-COMPANY-NAME            TO P-RPT-COMP-NAME       
               PERFORM 8100-PRINT-RPT1-HDNGS   THRU 8100-EXIT           
               MOVE WS-NO-DATA-LINE            TO PRT33-RECORD          
               MOVE WS-2                       TO WS-LINE-SPACE         
               PERFORM 8600-WRITE-PRINT-REC    THRU 8600-EXIT           
           ELSE                                                         
               PERFORM 2030-ACCT-NO-BRK        THRU 2030-EXIT           
               PERFORM 2070-LOC-OFF-TOT        THRU 2070-EXIT           
               PERFORM 2080-RPT-TOT            THRU 2080-EXIT           
               MOVE WS-2                       TO WS-LINE-SPACE         
               MOVE WS-END-DATA-LINE           TO PRT33-RECORD          
               PERFORM 8600-WRITE-PRINT-REC    THRU 8600-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                           TO WS-FIRST-TIME         
                                                  WS-ACCT-REPORT.       
           MOVE ZEROS                          TO WS-RPT1-PAGE-NO.      
           MOVE 'METER'                        TO WS-STATUS-HDR.        
           MOVE SPACES                         TO P-LOCAL-OFFICE        
                                                  P-LOCAL-OFFICE-DESC.  
           PERFORM 7150-OPEN-ACCT-INACTIVE     THRU 7150-EXIT           
           PERFORM 7160-FETCH-ACCT-INACTIVE    THRU 7160-EXIT.          
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PROCESSES THOSE RECORDS WITH ACCOUNTS INACTIVE FOR MORE THAN   *        
      * SIX MONTHS                                                     *        
      ******************************************************************        
      *                                                                         
       1200-PRODUCE-ACCT-REPORT.                                        
      *                                                                         
           MOVE '1200'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
      *                                                                         
               IF UT-RATE-PLAN-NO NOT EQUAL '978'                       
                   MOVE AT-PREMISE-NO             TO WS-CPD99-PREMISE-NO
                   PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT       
                   MOVE WS-CPD99-ACCOUNT-NO        TO AT-ACCOUNT-NO     
                   IF  AT-ACCOUNT-NO EQUAL MN-ACCOUNT-NO                
                       IF  FIRST-TIME                                   
                           PERFORM 2010-LOC-OFF-BRK                     
                                                   THRU 2010-EXIT       
                           MOVE AT-COMPANY-NO      TO WS-PREV-COMP-NO   
                           MOVE AT-COMPANY-NO      TO C7-COMPANY-NO     
                           PERFORM 7300-GET-COMPANY-DESC                
                                                   THRU 7300-EXIT       
                           MOVE C7-COMPANY-NAME    TO P-RPT-COMP-NAME   
                           PERFORM 2040-ACCUM-DETAILS                   
                                                   THRU 2040-EXIT       
                           MOVE WS-N               TO WS-FIRST-TIME     
                       ELSE                                             
                           PERFORM 2020-CHK-FOR-BRKS                    
                                                   THRU 2020-EXIT       
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
               PERFORM 7160-FETCH-ACCT-INACTIVE THRU 7160-EXIT          
           END-PERFORM.                                                 
           PERFORM 7170-CLOSE-ACCT-INACTIVE    THRU 7170-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               PERFORM 8200-PRINT-RPT2-HDNGS   THRU 8200-EXIT           
               MOVE WS-NO-DATA-LINE            TO WS-PRT331-REC         
               MOVE WS-2                       TO WS-LINE-SPACE         
               PERFORM 8625-WRITE-PRINT-REC    THRU 8625-EXIT           
           ELSE                                                         
               PERFORM 2030-ACCT-NO-BRK        THRU 2030-EXIT           
               PERFORM 2070-LOC-OFF-TOT        THRU 2070-EXIT           
               PERFORM 2080-RPT-TOT            THRU 2080-EXIT           
               MOVE WS-2                       TO WS-LINE-SPACE         
               MOVE WS-END-DATA-LINE           TO WS-PRT331-REC         
               PERFORM 8625-WRITE-PRINT-REC    THRU 8625-EXIT           
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINTS THE DETAILS ON A FRESH PAGE ON THE REPORT WHEN THERE IS *        
      * A CHANGE IN LOCAL OFFICE AND GETS THE LOCAL OFFICE DESC        *        
      ******************************************************************        
      *                                                                         
       2010-LOC-OFF-BRK.                                                
      *                                                                         
           MOVE WS-1                           TO WS-CNTR.              
           MOVE WS-0                           TO WS-RPT1-PAGE-NO.      
           MOVE MN-ACCOUNT-NO                  TO WS-PREV-ACCOUNT-NO.   
           MOVE AT-LOCAL-OFFICE                TO WS-PREV-LOCOFF1.      
           MOVE WS-60                          TO WS-RPT1-LINE-NO.      
           MOVE AT-LOCAL-OFFICE                TO B1-LOCAL-OFFICE       
                                                  P-LOCAL-OFFICE.       
           MOVE AT-COMPANY-NO                  TO B1-COMPANY-NO.        
           PERFORM 7200-GET-LOCAL-OFFICE       THRU 7200-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE B1-LOCAL-OFFICE-DESC       TO P-LOCAL-OFFICE-DESC   
           ELSE                                                         
               MOVE SPACES                     TO P-LOCAL-OFFICE-DESC   
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECKS FOR MAJOR CONTROL BREAK ON LOCAL OFFICE AND MINOR ON    *        
      * ACCOUNT NO                                                     *        
      ******************************************************************        
      *                                                                         
       2020-CHK-FOR-BRKS.                                               
      *                                                                         
           IF AT-COMPANY-NO NOT EQUAL WS-PREV-COMP-NO                   
              PERFORM 2030-ACCT-NO-BRK        THRU 2030-EXIT            
              PERFORM 2010-LOC-OFF-BRK        THRU 2010-EXIT            
              PERFORM 2040-ACCUM-DETAILS      THRU 2040-EXIT            
              MOVE AT-COMPANY-NO              TO C7-COMPANY-NO          
              PERFORM 7300-GET-COMPANY-DESC                             
                                              THRU 7300-EXIT            
              MOVE C7-COMPANY-NAME            TO P-RPT-COMP-NAME        
              MOVE AT-COMPANY-NO              TO WS-PREV-COMP-NO        
           ELSE                                                         
            IF AT-LOCAL-OFFICE NOT EQUAL WS-PREV-LOCOFF1                
               PERFORM 2030-ACCT-NO-BRK       THRU 2030-EXIT            
               PERFORM 2070-LOC-OFF-TOT       THRU 2070-EXIT            
               PERFORM 2010-LOC-OFF-BRK       THRU 2010-EXIT            
               PERFORM 2040-ACCUM-DETAILS     THRU 2040-EXIT            
            ELSE                                                        
               IF  MN-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO           
                   PERFORM 2030-ACCT-NO-BRK    THRU 2030-EXIT           
                   MOVE WS-1                   TO WS-CNTR               
                   PERFORM 2040-ACCUM-DETAILS  THRU 2040-EXIT           
               ELSE                                                     
                   ADD WS-1                    TO WS-CNTR               
                   PERFORM 2040-ACCUM-DETAILS  THRU 2040-EXIT           
                   IF ACCT-REPORT                                       
                       SUBTRACT WS-1           FROM WS-LOC-COUNT        
                   END-IF                                               
               END-IF                                                   
            END-IF                                                      
           END-IF.                                                      
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SETS WS-INDX TO 1 AND POPULATES THE REPORT VARIABLES UNTIL     *        
      * WS-CNTR > 3. FOR AN ACCOUNT SET WITH 4 METERS POPULATES THE    *        
      * REPORT VARIABLES FOR THE FOURTH METER                          *        
      ******************************************************************        
      *                                                                         
       2030-ACCT-NO-BRK.                                                
      *                                                                         
           SET WS-INDX                         TO WS-1.                 
           PERFORM 2050-POPULATE-REP-VAR       THRU 2050-EXIT           
               VARYING WS-CNTR FROM WS-1 BY WS-1                        
                 UNTIL WS-CNTR > 3.                                     
           IF  WS-METER-NO(WS-CNTR) GREATER THAN SPACES                 
               PERFORM 2050-POPULATE-REP-VAR   THRU 2050-EXIT           
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-TABLE.                                         
           MOVE MN-ACCOUNT-NO                  TO WS-PREV-ACCOUNT-NO.   
      *                                                                         
       2030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ACCUMULATES THE DETAILS OF A PARTICULAR ACCOUNT AS LONG AS THE *        
      * CURRENT ACCOUNT IS SAME AS PREVIOUS ACCOUNT BOTH FOR INACTIVE  *        
      * METERS AND INACTIVE ACCOUNTS                                   *        
      ******************************************************************        
      *                                                                         
       2040-ACCUM-DETAILS.                                              
      *                                                                         
           ADD WS-1                            TO WS-LOC-COUNT.         
                                                                        
           MOVE AT-COMPANY-NO                  TO GM-COMPANY-NO         
                                                  MC-COMPANY-NO.        
           PERFORM 7400-GET-MTR-CNST           THRU 7400-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE MC-CONSTANT                TO WS-MTR-CNST           
           ELSE                                                         
               MOVE ZEROS                      TO WS-MTR-CNST           
           END-IF.                                                      
      *                                                                         
           PERFORM 7500-GET-METER-SIZE-ID      THRU 7500-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE GM-METER-SIZE-ID           TO WS-MTR-SIZE-ID        
           ELSE                                                         
               MOVE SPACES                     TO WS-MTR-SIZE-ID        
           END-IF.                                                      
      *                                                                         
           IF  ACCT-REPORT                                              
               EVALUATE MN-CODE-METER-STATUS                            
                   WHEN 'A'                                             
                   WHEN 'B'                                             
                   WHEN 'I'                                             
                      MOVE WS-ACTIVE           TO WS-STATUS-DESC        
                   WHEN 'J'                                             
                      MOVE WS-INACTIVE         TO WS-STATUS-DESC        
                   WHEN 'K'                                             
                      MOVE WS-REMOVED          TO WS-STATUS-DESC        
                   WHEN OTHER                                           
                      MOVE SPACES              TO WS-STATUS-DESC        
               END-EVALUATE                                             
           ELSE                                                         
               IF  WS-CNTR = WS-1                                       
                   EVALUATE AT-CODE-ACCT-STAT                           
                      WHEN 'A'                                          
                         MOVE WS-ACTIVE        TO WS-STATUS-DESC        
                      WHEN 'J'                                          
                         MOVE WS-INACTIVE      TO WS-STATUS-DESC        
                      WHEN 'B'                                          
                         MOVE WS-FINAL-BILL    TO WS-STATUS-DESC        
                      WHEN 'S'                                          
                         MOVE WS-WRITE-OFF     TO WS-STATUS-DESC        
                      WHEN 'P'                                          
                         MOVE WS-PENDING       TO WS-STATUS-DESC        
                   END-EVALUATE                                         
               ELSE                                                     
                   MOVE SPACES                 TO WS-STATUS-DESC        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF  WS-CNTR = WS-1                                           
               MOVE MN-ACCOUNT-NO    TO WS-ACCOUNT-NO(WS-CNTR)          
A01209         MOVE ZEROS            TO AT-ADDRESS-ID                   
               MOVE AT-ADDRESS-ID    TO HT-ADDRESS-ID                   
               PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT            
               MOVE WS-CUSTOMER-NAME TO WS-NAME-ADDR(WS-CNTR)           
               MOVE WS-PR-STREET     TO WS-NAME-ADDR(2)                 
               MOVE WS-PR-ADDR-CITY-STATE-ZIP TO WS-NAME-ADDR(3)        
               MOVE MN-ACCOUNT-NO TO  EXCEL-ACCOUNT-NO                  
               MOVE WS-NAME-ADDR(WS-CNTR) TO EXCEL-NAME-ADDR            
               MOVE WS-NAME-ADDR(2) TO EXCEL-NAME-ADDR1                 
               MOVE WS-NAME-ADDR(3) TO EXCEL-NAME-ADDR2                 
           END-IF.                                                      
      *                                                                         
           MOVE MN-METER-NO  TO WS-METER-NO(WS-CNTR).                   
           MOVE MN-METER-NO TO EXCEL-METER-NUMBER.                      
           MOVE WS-STATUS-DESC TO WS-STATUS(WS-CNTR).                   
           MOVE WS-STATUS(WS-CNTR) TO EXCEL-STATUS.                     
           COMPUTE WS-INACTIVE-MONTHS =                                 
                   (( WS-NO-YEARS) * 12 + WS-NO-MONTHS ).               
           MOVE WS-INACTIVE-MONTHS TO WS-INACTIVE-MTHS(WS-CNTR).        
           MOVE WS-INACTIVE-MTHS(WS-CNTR) TO EXCEL-INACTIVE-MTHS.       
           MOVE WS-MTR-CNST TO WS-METER-CONSTANT(WS-CNTR).              
           MOVE WS-METER-CONSTANT(WS-CNTR) TO EXCEL-MTR-CNST.           
           MOVE WS-MTR-SIZE-ID TO WS-METER-SIZE-ID(WS-CNTR).            
           MOVE WS-METER-SIZE-ID(WS-CNTR) TO EXCEL-METER-SIZE-ID.       
           MOVE P-LOCAL-OFFICE TO EXCEL-LOCAL-OFF.                      
A01209     MOVE UT-READ-ROUTE  TO WS-READ-ROUTE(WS-CNTR)                
A01209                            EXCEL-READ-ROUTE.                     
      *                                                                         
           MOVE WS-EXCEL-DATA TO EXCEL-XX-RECORD.                       
           WRITE EXCEL-XX-RECORD.                                       
           INITIALIZE WS-EXCEL-DATA.                                    
           MOVE WS-SEMIC TO EXCEL-SEMIC0                                
                            EXCEL-SEMIC1                                
                            EXCEL-SEMIC2                                
                            EXCEL-SEMIC3                                
                            EXCEL-SEMIC4                                
                            EXCEL-SEMIC5                                
                            EXCEL-SEMIC6                                
                            EXCEL-SEMIC7                                
                            EXCEL-SEMIC8                                
                            EXCEL-SEMIC9                                
A01209                      EXCEL-SEMIC10.                              
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * REPORT VARIABLES ARE LOADED FROM THE WORKING STORAGE TABLE BOTH         
      * FOR INACTIVE ACCOUNTS AND INACTIVE METERS                               
      ******************************************************************        
      *                                                                         
       2050-POPULATE-REP-VAR.                                           
      *                                                                         
           MOVE WS-ACCOUNT-NO(WS-CNTR) TO P-ACCOUNT-NO(WS-INDX).        
           MOVE WS-NAME-ADDR(WS-CNTR)  TO P-NAME-ADDR(WS-INDX).         
           MOVE WS-METER-NO(WS-CNTR)   TO P-METER-NUMBER(WS-INDX).      
           MOVE WS-STATUS(WS-CNTR)     TO P-STATUS(WS-INDX).            
      *                                                                         
A01209     IF WS-READ-ROUTE(WS-CNTR) > 0                                
A01209        MOVE WS-READ-ROUTE(WS-CNTR) TO P-READ-ROUTE(WS-INDX)      
A01209     ELSE                                                         
A01209        MOVE SPACES TO P-READ-ROUTE(WS-INDX)                      
A01209     END-IF.                                                      
      *                                                                         
           IF WS-INACTIVE-MTHS(WS-CNTR) > 0                             
              MOVE WS-INACTIVE-MTHS(WS-CNTR) TO                         
                                          P-INACTIVE-MTHS(WS-INDX)      
           ELSE                                                         
              MOVE SPACES TO P-INACTIVE-MTHS1(WS-INDX)                  
           END-IF.                                                      
           IF WS-METER-CONSTANT(WS-CNTR) > 0                            
              MOVE WS-METER-CONSTANT(WS-CNTR) TO P-MTR-CNST(WS-INDX)    
           ELSE                                                         
              MOVE SPACES TO P-MTR-CNST1(WS-INDX)                       
           END-IF.                                                      
           MOVE WS-METER-SIZE-ID(WS-CNTR) TO P-METER-SIZE-ID(WS-INDX).  
           PERFORM 2060-CHK-PAGE-BRK THRU 2060-EXIT.                    
      *                                                                         
           IF ACCT-REPORT                                               
              MOVE WS-DETAIL-LINE(WS-INDX) TO WS-PRT331-REC             
              PERFORM 8625-WRITE-PRINT-REC THRU 8625-EXIT               
           ELSE                                                         
              MOVE WS-DETAIL-LINE(WS-INDX) TO PRT33-RECORD              
              PERFORM 8600-WRITE-PRINT-REC THRU 8600-EXIT               
           END-IF.                                                      
           INITIALIZE WS-DETAIL-TABLE.                                  
      *                                                                         
           SET WS-INDX UP BY WS-1.                                      
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * IF THE LINE NO IS GREATER THAN 50 PRINTS PAGE HEADERS. IF ALL  *        
      * THE DETAILS PERTAINING TO AN ACCOUNT ARE NOT PRINTING ON THE   *        
      * SAME PAGE FORCE THE LINE NO TO BE GREATER THAN 50              *        
      * ****************************************************************        
      *                                                                         
       2060-CHK-PAGE-BRK.                                               
      *                                                                         
           IF  ACCT-REPORT                                              
               IF  WS-CNTR = WS-1                                       
                   IF  (WS-RPT1-LINE-NO + 4) > WS-57                    
                       PERFORM 8200-PRINT-RPT2-HDNGS                    
                                               THRU 8200-EXIT           
                   END-IF                                               
                   MOVE WS-2                   TO WS-LINE-SPACE         
                   ADD  WS-2                   TO WS-RPT1-LINE-NO       
               ELSE                                                     
                   MOVE WS-1                   TO WS-LINE-SPACE         
                   ADD WS-1                    TO WS-RPT1-LINE-NO       
               END-IF                                                   
           ELSE                                                         
               IF  WS-CNTR = WS-1                                       
                   IF  (WS-RPT1-LINE-NO + 4) > WS-57                    
                        PERFORM 8100-PRINT-RPT1-HDNGS                   
                                               THRU 8100-EXIT           
                   END-IF                                               
                   MOVE WS-2                   TO WS-LINE-SPACE         
                   ADD  WS-2                   TO WS-RPT1-LINE-NO       
               ELSE                                                     
                   MOVE WS-1                   TO WS-LINE-SPACE         
                   ADD  WS-1                   TO WS-RPT1-LINE-NO       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINTS TOTALS FOR EACH LOCAL OFFICE                                     
      ******************************************************************        
      *                                                                         
       2070-LOC-OFF-TOT.                                                
      *                                                                         
           MOVE WS-3                           TO WS-LINE-SPACE.        
           MOVE WS-LOC-COUNT                   TO P-TOT-RECORDS.        
           ADD WS-LOC-COUNT                    TO WS-RPT-COUNT.         
           MOVE 'TOTAL FOR LOCAL OFFICE  = '   TO P-TOT-MESSAGE.        
           IF  ACCT-REPORT                                              
               MOVE WS-TOTAL-LINE              TO WS-PRT331-REC         
               PERFORM 8625-WRITE-PRINT-REC    THRU 8625-EXIT           
           ELSE                                                         
               MOVE WS-TOTAL-LINE              TO PRT33-RECORD          
               PERFORM 8600-WRITE-PRINT-REC    THRU 8600-EXIT           
           END-IF.                                                      
           MOVE ZERO                           TO WS-LOC-COUNT.         
      *                                                                         
       2070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINTS TOTALS FOR THE ENTIRE REPORT                                     
      ******************************************************************        
      *                                                                         
       2080-RPT-TOT.                                                    
      *                                                                         
           MOVE ZERO                           TO WS-REC-COUNT.         
           MOVE WS-RPT-COUNT                   TO P-TOT-RECORDS.        
           MOVE 'TOTAL FOR ENTIRE REPORT = '   TO P-TOT-MESSAGE.        
           IF  ACCT-REPORT                                              
               PERFORM 8200-PRINT-RPT2-HDNGS   THRU 8200-EXIT           
               MOVE WS-3                       TO WS-LINE-SPACE         
               MOVE WS-TOTAL-LINE              TO WS-PRT331-REC         
               PERFORM 8625-WRITE-PRINT-REC    THRU 8625-EXIT           
           ELSE                                                         
               PERFORM 8100-PRINT-RPT1-HDNGS   THRU 8100-EXIT           
               MOVE WS-3                       TO WS-LINE-SPACE         
               MOVE WS-TOTAL-LINE              TO PRT33-RECORD          
               PERFORM 8600-WRITE-PRINT-REC    THRU 8600-EXIT           
           END-IF.                                                      
           MOVE ZERO                           TO WS-RPT-COUNT.         
      *                                                                         
       2080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      * COPY BOOK TO GET COMMON DATE                                   *        
      ******************************************************************        
       COPY CPD00040.                                                           
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      * COPY BOOK TO GET JOB PARM DATE                                 *        
      ******************************************************************        
       COPY CPD00037.                                                           
      ******************************************************************        
      * 7000-START-FJC01 ..                                            *        
      * SQL STATEMENTS TO RETRIEVE DATE FROM JOB PARM TABLE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6990-FETCH-CUR-ACCOUNT                                         *        
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           DISPLAY '*********** PCSUM303 ABEND  *************'          
           DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
           DISPLAY '* PREMISE-NO  = ', HOSTVAR-ELEMENT-1.               
           DISPLAY '* SQL CODE IS   ', WS-CPD99-RETURN-CODE.            
           DISPLAY '* PROGRAM ABENDING...                   *'.         
           DISPLAY '*********** PCSUM303 ABEND  *************'          
           PERFORM 9900-ABEND                  THRU 9900-EXIT.          
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4000-MAIL-NAME-ADDRESS.                                        *        
      * TO FETCH THE PREMISE ADDRESS.                                  *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES (NEEDED BY CPD00074)               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      * CALCULATES DATE THAT IS X MONTHS PRIOR TO THE JOB PARM DATE    *        
      ******************************************************************        
       7000-GET-MTHS-PRIOR-DT.                                          
      *                                                                         
           EXEC SQL                                                     
T35434          SELECT
              DATEADD( MONTH, -:WS-PARM-MNTH1, IIF(TRY_CONVERT(DATE, 
                                                        :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ) ),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-MTH-PRIOR-DT,
              :WS-CURR-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-MTH-PRIOR-DT =                                          
MFA-TR*                DATE(:WS-JOB-PARM-DT) - :WS-PARM-MNTH1 MONTHS            
MFA-TR*            ,:WS-CURR-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '**  ERROR IN 7001-GET-MTH-PRIOR-DT **'          
               DISPLAY '**  JOB PARM DATE = ' WS-JOB-PARM-DT            
               DISPLAY '**  RETURN CODE   = ' SQLCODE                   
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPENS THE CURSOR FOR THE TABLES CSS_ACCOUNT AND                *        
      * CSS_MTRD_ENVRNMT                                               *        
      ******************************************************************        
      *                                                                         
       7110-OPEN-METER-INACTIVE.                                        
      *                                                                         
           MOVE '7110'        TO WS-ACTIVE-PARAGRAPH.                   
      *                                                                         
           EXEC SQL                                                     
               OPEN METER_INACTIVE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE               
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '** ERROR IN 7110-OPEN-METER-INACTIVE   **'      
               DISPLAY '** RETURN CODE = ' SQLCODE                      
               DISPLAY '** PROCESSING TERMINATED               **'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES METERS THAT ARE INACTIVE FOR MORE THAN SIX MONTHS      *        
      ******************************************************************        
      *                                                                         
       7120-FETCH-METER-INACTIVE.                                       
      *                                                                         
           MOVE '7120'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
               FETCH  METER_INACTIVE                                    
                INTO :AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:MN-ACCOUNT-NO                                     
                    ,:MN-METER-NO                                       
                    ,:MN-LAST-REG-READ-DATE                             
                    ,:WS-NO-YEARS :WS-NULL-1                           
                    ,:WS-NO-MONTHS :WS-NULL-2                           
                    ,:MN-REG-ID-NO                                      
                    ,:MN-REGISTER-RD-SEQ                                
                    ,:UT-RATE-PLAN-NO                                   
                    ,:UT-READ-CYCLE                                     
                    ,:UT-READ-ROUTE                                     
                    ,:GM-METER-SIZE-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD WS-1                        TO WS-REC-COUNT          
               IF  WS-NULL-1 < WS-0                                     
                   MOVE WS-0                   TO WS-NO-YEARS           
               END-IF                                                   
               IF  WS-NULL-2 < WS-0                                     
                   MOVE WS-0                   TO WS-NO-MONTHS          
               END-IF                                                   
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   CONTINUE                                             
               ELSE                                                     
                   DISPLAY '*********** PCSUM303 ABEND  *************'  
                   DISPLAY '**  ERROR IN 7120-FETCH-METER-INACTIVE  *'  
                   DISPLAY '**  ACCOUNT NO   = ' MN-ACCOUNT-NO          
                   DISPLAY '**  METER NO     = ' MN-METER-NO            
                   DISPLAY '**  LOCAL OFFICE = ' AT-LOCAL-OFFICE        
                   DISPLAY '**  PREMISE NO   = ' AT-PREMISE-NO          
                   DISPLAY '**  RETURN CODE  = ' SQLCODE                
                   DISPLAY '**  PROCESSING TERMINATED               *'  
                   DISPLAY '*********** PCSUM303 ABEND  *************'  
                   PERFORM 9900-ABEND          THRU 9900-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES THE CURSOR FOR THE TABLES CSS_ACCOUNT AND               *        
      * CSS_MTRD_ENVRNMT                                               *        
      ******************************************************************        
      *                                                                         
       7130-CLOSE-METER-INACTIVE.                                       
      *                                                                         
           MOVE '7130'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
              EXEC SQL                                                  
                  CLOSE METER_INACTIVE                                  
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '**  ERROR IN 7130-CLOSE-METER-INACTIVE  *'      
               DISPLAY '**  ACCOUNT NO   = ' MN-ACCOUNT-NO              
               DISPLAY '**  METER NO     = ' MN-METER-NO                
               DISPLAY '**  LOCAL OFFICE = ' AT-LOCAL-OFFICE            
               DISPLAY '**  PREMISE NO   = ' AT-PREMISE-NO              
               DISPLAY '**  RETURN CODE  = ' SQLCODE                    
               DISPLAY '**  PROCESSING TERMINATED               *'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPENS ACCT_INACTIVE CURSOR                                     *        
      ******************************************************************        
      *                                                                         
       7150-OPEN-ACCT-INACTIVE.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN ACCT_INACTIVE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '**  ERROR IN 7150-OPEN-ACCT-INACTIVE   **'      
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES ACCOUNTS THAT ARE INACTIVE FOR MORE THAN SIX MONTHS    *        
      ******************************************************************        
      *                                                                         
       7160-FETCH-ACCT-INACTIVE.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH  ACCT_INACTIVE                                     
                INTO :AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:MN-ACCOUNT-NO                                     
                    ,:MN-METER-NO                                       
                    ,:MN-LAST-REG-READ-DATE                             
                    ,:MN-CODE-METER-STATUS                              
                    ,:WS-NO-YEARS :WS-NULL-1                           
                    ,:WS-NO-MONTHS :WS-NULL-2                           
                    ,:MN-REG-ID-NO                                      
                    ,:MN-REGISTER-RD-SEQ                                
                    ,:UT-RATE-PLAN-NO                                   
                    ,:UT-READ-CYCLE                                     
                    ,:UT-READ-ROUTE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD WS-1                        TO WS-REC-COUNT          
               IF WS-NULL-1 < WS-0                                      
                  MOVE WS-0                    TO WS-NO-YEARS           
               END-IF                                                   
               IF WS-NULL-2 < WS-0                                      
                  MOVE WS-0                    TO WS-NO-MONTHS          
               END-IF                                                   
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   CONTINUE                                             
               ELSE                                                     
                   DISPLAY '*********** PCSUM303 ABEND  *************'  
                   DISPLAY '**  ERROR IN 7160-FETCH-ACCT-INACTIVE  **'  
                   DISPLAY '**  ACCOUNT NO   = ' MN-ACCOUNT-NO          
                   DISPLAY '**  METER NO     = ' MN-METER-NO            
                   DISPLAY '**  LOCAL OFFICE = ' AT-LOCAL-OFFICE        
                   DISPLAY '**  PREMISE NO   = ' AT-PREMISE-NO          
                   DISPLAY '**  RETURN CODE  = ' SQLCODE                
                   DISPLAY '**  PROCESSING TERMINATED              **'  
                   DISPLAY '*********** PCSUM303 ABEND  *************'  
                   PERFORM 9900-ABEND          THRU 9900-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES ACCT_INACTIVE CURSOR                                    *        
      ******************************************************************        
      *                                                                         
       7170-CLOSE-ACCT-INACTIVE.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE ACCT_INACTIVE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '**  ERROR IN 7170-CLOSE-ACCT-INACTIVE  **'      
               DISPLAY '**  ACCOUNT NO   = ' MN-ACCOUNT-NO              
               DISPLAY '**  METER NO     = ' MN-METER-NO                
               DISPLAY '**  LOCAL OFFICE = ' AT-LOCAL-OFFICE            
               DISPLAY '**  PREMISE NO   = ' AT-PREMISE-NO              
               DISPLAY '**  RETURN CODE  = ' SQLCODE                    
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECTS THE LOCAL OFFICE DESCRIPTION FOR THE GIVEN LOCAL OFFICE*        
      * AND COMPANY NO                                                 *        
      ******************************************************************        
      *                                                                         
       7200-GET-LOCAL-OFFICE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE_DESC                                 
                 INTO :B1-LOCAL-OFFICE-DESC                             
                 FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO   = :B1-COMPANY-NO                     
                  AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCAL_OFFICE_DESC                                         
MFA-TR*          INTO :B1-LOCAL-OFFICE-DESC                                     
MFA-TR*          FROM CSS_LOCAL_OFFICE                                          
MFA-TR*         WHERE COMPANY_NO   = :B1-COMPANY-NO                             
MFA-TR*           AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '**  ERROR IN 7200-GET-LOCAL-OFFICE     **'      
               DISPLAY '**  COMPANY NO   = ' B1-COMPANY-NO              
               DISPLAY '**  LOCAL OFFICE = ' B1-LOCAL-OFFICE            
               DISPLAY '**  RETURN CODE  = ' SQLCODE                    
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECTS COMPANY NAME FOR THE GIVEN COMPANY NO                  *        
      ******************************************************************        
      *                                                                         
       7300-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7300'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NAME                                      
                 INTO :C7-COMPANY-NAME                                  
                 FROM CSS_COMPANY WITH(READUNCOMMITTED)                         
                WHERE COMPANY_NO = :C7-COMPANY-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM CSS_COMPANY                                               
MFA-TR*         WHERE COMPANY_NO = :C7-COMPANY-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '**  ERROR IN 7300-GET-COMPANY-DESC     **'      
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECTS METER CONSTANT FROM CSS_MTR_CAP                        *        
      ******************************************************************        
      *                                                                         
       7400-GET-MTR-CNST.                                               
      *                                                                         
           MOVE '7400'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
               SELECT CONSTANT                                          
                 INTO :MC-CONSTANT                                      
                 FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                         
                WHERE METER_NO       = :MN-METER-NO                     
                  AND REG_ID_NO      = :MN-REG-ID-NO                    
                  AND CODE_UTIL_TYPE = :WS-G                            
                  AND COMPANY_NO     = :MC-COMPANY-NO                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CONSTANT                                                  
MFA-TR*          INTO :MC-CONSTANT                                              
MFA-TR*          FROM CSS_MTR_CAP                                               
MFA-TR*         WHERE METER_NO       = :MN-METER-NO                             
MFA-TR*           AND REG_ID_NO      = :MN-REG-ID-NO                            
MFA-TR*           AND CODE_UTIL_TYPE = :WS-G                                    
MFA-TR*           AND COMPANY_NO     = :MC-COMPANY-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '**  ERROR IN 7400-GET-MTR-CNST         **'      
               DISPLAY '**  COMPANY NO  = ' MC-COMPANY-NO               
               DISPLAY '**  METER NO    = ' MN-METER-NO                 
               DISPLAY '**  REG ID NO   = ' MN-REG-ID-NO                
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECTS METER SIZE ID FROM CSS_GAS_METER                       *        
      ******************************************************************        
      *                                                                         
       7500-GET-METER-SIZE-ID.                                          
      *                                                                         
           MOVE '7500'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
               SELECT  METER_SIZE_ID                                    
                 INTO :GM-METER-SIZE-ID                                 
                 FROM  CSS_GAS_METER WITH(READUNCOMMITTED)                      
                WHERE  METER_NO       = :MN-METER-NO                    
                  AND  CODE_UTIL_TYPE = :WS-G                           
                  AND  COMPANY_NO     = :GM-COMPANY-NO                  
T35434                                                          
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  METER_SIZE_ID                                            
MFA-TR*          INTO :GM-METER-SIZE-ID                                         
MFA-TR*          FROM  CSS_GAS_METER                                            
MFA-TR*         WHERE  METER_NO       = :MN-METER-NO                            
MFA-TR*           AND  CODE_UTIL_TYPE = :WS-G                                   
MFA-TR*           AND  COMPANY_NO     = :GM-COMPANY-NO                          
MFA-TR*          WITH  UR                                                       
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               DISPLAY '**  ERROR IN 7500-GET-METER-SIZE-ID     *'      
               DISPLAY '**  COMPANY NO  = ' GM-COMPANY-NO               
               DISPLAY '**  METER NO    = ' MN-METER-NO                 
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED               *'      
               DISPLAY '*********** PCSUM303 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINTS HEADERS FOR METERS INACTIVE FOR  LONGER THAN SIX MONTHS*         
      * NO OF MONTHS IS TAKEN DYNAMICALLY FROM PARM, DEFAULT BEING 6  *         
      ******************************************************************        
      *                                                                         
       8100-PRINT-RPT1-HDNGS.                                           
      *                                                                         
           MOVE '8100'                         TO WS-ACTIVE-PARAGRAPH.  
           MOVE 0                              TO WS-RPT1-LINE-NO.      
           ADD WS-1                            TO WS-RPT1-PAGE-NO.      
           MOVE WS-RPT1-PAGE-NO                TO P-RPT-PAGE-NO.        
           MOVE '01'                           TO P-RPT-TITLE-NBR.      
           MOVE WS-RPT-TITLE                   TO PRT33-DATA.           
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           MOVE WS-DEFAULT-RPT1-HEADER1        TO P-RPT-HEAD1           
           MOVE WS-RPT-HEADER                  TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
           MOVE WS-DEFAULT-RPT-HEADER2         TO P-RPT-HEAD2.          
           MOVE WS-RPT-HEADER-2                TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
           MOVE WS-DEFAULT-RPT1-HEADER2        TO PRT33-DATA.           
           MOVE WS-2                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-LOCAL-OFFICE-HEADER     TO PRT33-DATA            
               MOVE WS-2                       TO WS-LINE-SPACE         
               PERFORM 8600-WRITE-PRINT-REC    THRU 8600-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-COLUMN-HEADER-1             TO PRT33-DATA.           
           MOVE WS-2                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
           MOVE WS-COLUMN-HEADER-2             TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
           MOVE WS-LINE                        TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               ADD  WS-07                      TO WS-RPT1-LINE-NO       
           ELSE                                                         
               ADD  WS-09                      TO WS-RPT1-LINE-NO       
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINTS HEADERS FOR ACCOUNTS INACTIVE FOR LONGER THAN 6 MONTHS  *        
      * NO OF MONTHS IS TAKEN DYNAMICALLY FROM PARM, DEFAULT BEING 6   *        
      ******************************************************************        
      *                                                                         
       8200-PRINT-RPT2-HDNGS.                                           
      *                                                                         
           MOVE '8200'                         TO WS-ACTIVE-PARAGRAPH.  
           MOVE 0                              TO WS-RPT1-LINE-NO.      
           ADD WS-1                            TO WS-RPT1-PAGE-NO.      
           MOVE WS-RPT1-PAGE-NO                TO P-RPT-PAGE-NO.        
           MOVE '02'                           TO P-RPT-TITLE-NBR.      
           MOVE WS-RPT-TITLE                   TO WS-PRT331-DATA.       
           MOVE WS-PRT331-REC                  TO PRT331-RECORD.        
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
           MOVE WS-DEFAULT-RPT2-HEADER2        TO P-RPT-HEAD1.          
           MOVE WS-RPT-HEADER                  TO WS-PRT331-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
           MOVE WS-DEFAULT-RPT-HEADER2         TO P-RPT-HEAD2.          
           MOVE WS-RPT-HEADER-2                TO WS-PRT331-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-LOCAL-OFFICE-HEADER     TO WS-PRT331-DATA        
               MOVE WS-2                       TO WS-LINE-SPACE         
               PERFORM 8625-WRITE-PRINT-REC    THRU 8625-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-COLUMN-HEADER-1             TO WS-PRT331-DATA.       
           MOVE WS-2                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
           MOVE WS-COLUMN-HEADER-2             TO WS-PRT331-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
           MOVE WS-LINE                        TO WS-PRT331-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               ADD  WS-07                      TO WS-RPT1-LINE-NO       
           ELSE                                                         
               ADD  WS-09                      TO WS-RPT1-LINE-NO       
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * WRITES THE PRT33-RECORD.                                                
      ******************************************************************        
      *                                                                         
       8600-WRITE-PRINT-REC.                                            
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * WRITES THE PRT331-RECORD.                                               
      ******************************************************************        
      *                                                                         
       8625-WRITE-PRINT-REC.                                            
      *                                                                         
           MOVE WS-PRT331-REC  TO PRT331-RECORD.                        
           WRITE PRT331-RECORD AFTER ADVANCING WS-LINE-SPACE.           
      *                                                                         
       8625-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM               *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE, FCSPT331-FILE.                           
           CLOSE FCSPTXX-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00074)                      *        
      ******************************************************************        
       COPY CPD0023B.                                                           
      *                                                                         
