       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSUM300.                                        
       DATE-WRITTEN.   02/22/00.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRICITY AND GAS              **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **              ELECTRIC METERS INACTIVE REPORT                **         
      **                                                             **         
      ** PCSUM300 REPORTS METERS INACTIVE AND ACCOUNTS INACTIVE FOR  **         
      ** LONGER THAN 6 MONTHS. IF PARM = 'Y' THEN THE METERS INACTIVE**         
      ** REPORT IS SPLIT INTO TWO ONE WITH METER CONSTANT = 1  AND   **         
      ** THE OTHER WITH METER CONSTANT > 1                           **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
T21525**  02/22/00  CBSI         NEW PROGRAM FOR REPORT GENERATION   **         
T22981**  10/11/00  RGB          INCREASED THE OCCUR CLAUSE OF DET   **         
T22981**                         ACCT TABLE.                         **         
T22243**  26/10/00  CBSI         MULTI-COMPANY CHANGES,GIVE PAGE-    **         
T22243**                         BREAK FOR COMPANY NUMBER CHANGE     **         
T22243**                         NO OF MONTHS THE METER/ACCOUNTS ARE **         
T22243**                         INACTIVE IS TAKEN DYNAMICALLY       **         
T35434**  02/05/08  MC95456      ADDED WITH UR TO SELECT STATEMENTS  **         
T35434**                         REPLACED CSS_MODEL_SQL WITH SET STMT**         
      **  --------  --------     ----------------------------------  **         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSUM300 REPORTS ----      
                   ----- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT33.                                                            
T19050 COPY CSSPT331.                                                           
T19588 COPY CSSPT332.                                                           
T19588                                                                  
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDPT33.                                                            
T19050 COPY CFDPT331.                                                           
T19588 COPY CFDPT332.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSUM300'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PCSUM300 STARTS HERE'.                  
      *                                                                         
       01  WS-PRT331-REC.                                               
           05  WS-PRT331-CC            PIC X(01).                       
           05  WS-PRT331-DATA          PIC X(132).                      
      *                                                                         
       01  WS-PRT332-REC.                                               
           05  WS-PRT332-CC            PIC X(01).                       
           05  WS-PRT332-DATA          PIC X(132).                      
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
T19003         INCLUDE TBCSTPRM                                                 
T19003     END-EXEC.                                                            
T19003*                                                                         
T20889     EXEC SQL                                                             
T20889         INCLUDE TBMTRCAP                                                 
T20889     END-EXEC.                                                            
T20889*                                                                         
T20971     EXEC SQL                                                             
T20971         INCLUDE TBNMACTX                                                 
T20971     END-EXEC.                                                            
T20971*                                                                         
T20971     EXEC SQL                                                             
T20971         INCLUDE TBCSADRX                                                 
T20971     END-EXEC.                                                            
T20971*                                                                         
T20971     EXEC SQL                                                             
T20971         INCLUDE TBADRFRE                                                 
T20971     END-EXEC.                                                            
T20971*                                                                         
T20971     EXEC SQL                                                             
T20971         INCLUDE TBATMISC                                                 
T20971     END-EXEC.                                                            
T20971*                                                                         
T21239     EXEC SQL                                                             
T21239         INCLUDE TBELMTR                                                  
T21239     END-EXEC.                                                            
T21239*                                                                         
T21239     EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
T21239     END-EXEC.                                                            
T21239*                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
      *                                                                         
      ******************************************************************        
      *   FCA00 MISC                                                   *        
      ******************************************************************        
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FIRST-TIME           PIC X(01)    VALUE 'Y'.          
T19003         88  FIRST-TIME                       VALUE 'Y'.          
T19050     05  WS-ACCT-REPORT          PIC X(01)    VALUE 'N'.          
T19050         88  ACCT-REPORT                      VALUE 'Y'.          
           05  WS-PARM-EXISTS          PIC X(01)    VALUE SPACES.       
               88  PARM-EXISTS                      VALUE 'Y'.          
               88  PARM-DOES-NOT-EXIST              VALUE 'N'.          
           05  WS-MTR-CONST-ONE        PIC X(01)    VALUE 'N'.          
               88  CONSTANT-ONE                     VALUE 'Y'.          
           05  WS-MTR-CONST-GRTR-ONE   PIC X(01)    VALUE 'N'.          
               88  CONSTANT-GRTR-ONE                VALUE 'Y'.          
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-REC-COUNT            PIC 9(09)    VALUE ZERO COMP-3.  
           05  WS-JOB-PARM-DT          PIC X(10)    VALUE SPACES.       
           05  WS-CURR-DATE            PIC X(10)    VALUE SPACES.       
           05  WS-SIX-MTH-PRIOR-DT     PIC X(10).                       
T22243     05  WS-MTH-PRIOR-DT         PIC X(10).                       
           05  WS-PREV-LOCOFF1         PIC X(03)    VALUE SPACES.       
           05  WS-PREV-LOCOFF2         PIC X(03)    VALUE SPACES.       
           05  WS-PREV-ACCOUNT-NO      PIC 9(13)    VALUE ZEROS.        
           05  WS-STATUS-DESC          PIC X(15)    VALUE SPACES.       
T19050     05  WS-FCA331-STATUS        PIC X(02).                       
T19588     05  WS-FCA332-STATUS        PIC X(02).                       
           05  WS-CNTR                 PIC 9(02)    VALUE 0.            
           05  WS-NO-YEARS             PIC S9(04) COMP  VALUE 0.        
           05  WS-NO-MONTHS            PIC S9(04) COMP  VALUE 0.        
           05  WS-INACTIVE-MONTHS      PIC 9(04)    VALUE 0.            
           05  WS-NULL-1               PIC S9(04)   VALUE ZEROS COMP.   
           05  WS-NULL-2               PIC S9(04)   VALUE ZEROS COMP.   
           05  WS-MTR-CNST             PIC 9(6)V999.                    
           05  WS-MTR-CLASS-CD         PIC X(02).                       
           05  WS-MTR-SPEC-CD          PIC X(03).                       
           05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSUM300'.   
           05  RS-RETURN-CODE          PIC S9(9)    VALUE +000 COMP.    
           05  RS-RETURN-CODE-DISP     PIC S9(9)    VALUE +000 COMP.    
           05  WS-RPT1-LINE-NO         PIC 9(02)    VALUE 62   COMP-3.  
           05  WS-RPT2-LINE-NO         PIC 9(02)    VALUE 62   COMP-3.  
           05  WS-RPT1-PAGE-NO         PIC 9(05)    VALUE ZERO COMP-3.  
           05  WS-RPT2-PAGE-NO         PIC 9(05)    VALUE ZERO COMP-3.  
           05  WS-LINE-SPACE           PIC 9(01)    VALUE ZERO.         
           05  WS-LINE                 PIC X(132)   VALUE ALL  '-'.     
T22243     05  WS-PREV-COMP-NO         PIC X(02)    VALUE ' '.          
T22243     05  WS-PARM-MNTH            PIC X(02)    VALUE SPACES.       
T22243     05  WS-PARM-MNTH1           PIC S9(04)   COMP.               
T22243     05  WS-INPUT-PARM-DATA      PIC X(80)    VALUE SPACES.       
T22243     05  WS-SYSIN-COMP-NO        PIC X(02)    VALUE SPACES.       
T22243     05  WS-COMP-NO              PIC X(02)    VALUE '01'.         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSUM300'.   
           05  WS-ACTIVE               PIC X(13)    VALUE 'ACTIVE'.     
           05  WS-INACTIVE             PIC X(13)    VALUE 'INACTIVE'.   
           05  WS-FINAL-BILL           PIC X(13)    VALUE 'FINAL-BILL'. 
           05  WS-WRITE-OFF            PIC X(13)    VALUE 'WRITE-OFF'.  
           05  WS-PENDING              PIC X(13)    VALUE 'PENDING'.    
           05  WS-REMOVED              PIC X(13)    VALUE 'REMOVED'.    
T22243     05  WS-PARM1                PIC X(04)    VALUE 'PARM'.       
           05  WS-E                    PIC X(01)    VALUE 'E'.          
           05  WS-0                    PIC 9(01)    VALUE 0.            
           05  WS-ZERO                 PIC X(02)    VALUE '00'.         
           05  WS-1                    PIC 9(01)    VALUE 1.            
           05  WS-2                    PIC 9(01)    VALUE 2.            
T22243     05  WS-SIX                  PIC X(02)    VALUE '06'.         
           05  WS-07                   PIC 9(01)    VALUE 7.            
           05  WS-09                   PIC 9(01)    VALUE 9.            
           05  WS-57                   PIC 9(02)    VALUE 57.           
           05  WS-60                   PIC 9(02)    VALUE 60.           
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MIN                  PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CCYY                 PIC X(04).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-MM                   PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-DD                   PIC X(02).                       
      *                                                                         
       01  WS-REP-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-CCYY              PIC X(04).                       
      *                                                                         
       01  WS-TABLE.                                                    
T22981     05  WS-DET-LINE OCCURS 50 TIMES.                             
               10  WS-ACCOUNT-NO       PIC X(13).                       
               10  WS-NAME-ADDR        PIC X(50).                       
               10  WS-METER-NO         PIC X(09).                       
               10  WS-CLASS-CODE       PIC X(02).                       
               10  WS-SPEC-CODE        PIC X(03).                       
               10  WS-STATUS           PIC X(15).                       
               10  WS-INACTIVE-MTHS    PIC X(04).                       
               10  WS-METER-CONSTANT   PIC 9(06)V9(3).                  
      *                                                                         
       01  WS-REPORT-HEADERS.                                           
      *                                                                         
           05  WS-DEFAULT-RPT-HEADER1.                                  
               10  WS-RPT-HEADER1-1    PIC X(49)    VALUE               
               '             ELECTRIC METERS INACTIVE FOR LONGER '.     
T22243         10  WS-RPT-HEADER1-2    PIC X(5)     VALUE               
T22243         'THAN '.                                                 
T22243         10  WS-RPT-MNTH         PIC X(02).                       
T22243         10  FILLER              PIC X(20)    VALUE               
T22243         ' MONTHS             '.                                  
           05  WS-DEFAULT-RPT-HEADER1A.                                 
T22243         10  WS-RPT-HEADER1A-1   PIC X(42)    VALUE               
T22243         ' ELECTRIC METERS INACTIVE FOR LONGER THAN '.            
T22243         10  WS-RPT-MNTHA        PIC X(02).                       
T22243         10  FILLER              PIC X(08)    VALUE               
T22243         ' MONTHS '.                                              
               10  WS-RPT-HEADER1A-2   PIC X(18)    VALUE               
               'WITH CONSTANT = 1 '.                                    
           05  WS-DEFAULT-RPT2-HEADER1.                                 
               10  WS-RPT2-HEADER1-1   PIC X(42)    VALUE               
T22243         ' ELECTRIC METERS INACTIVE FOR LONGER THAN '.            
T22243         10  WS-RPT2-MNTH        PIC X(02).                       
T22243         10  FILLER              PIC X(08)    VALUE               
T22243         ' MONTHS '.                                              
               10  WS-RPT2-HEADER1-2   PIC X(18)    VALUE               
               'WITH CONSTANT > 1 '.                                    
           05  WS-DEFAULT-RPT3-HEADER1.                                 
               10  WS-RPT3-HEADER1-1   PIC X(43)    VALUE               
T22243         'ELECTRIC ACCOUNTS INACTIVE FOR LONGER THAN '.           
T22243         10  WS-RPT3-MNTH        PIC X(02).                       
T22243         10  FILLER              PIC X(08)    VALUE               
T22243         ' MONTHS '.                                              
               10  WS-RPT3-HEADER1-2   PIC X(18)    VALUE               
               'WITH ACTIVE METERS'.                                    
      *                                                                         
           05  WS-DEFAULT-RPT-HEADER2.                                  
               10  FILLER              PIC X(14)    VALUE               
                                                   'CURRENT AS OF '.    
               10  WS-DEFAULT-RPT-HEADER2-DT                            
                                       PIC X(10).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT-TITLE.                                            
               10  P-RPT-TITLE-PGNM    PIC X(10)    VALUE SPACES.       
               10  FILLER              PIC X(43)    VALUE SPACES.       
               10  P-RPT-COMP-NAME     PIC X(26).                       
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-DATE: '. 
               10  P-RPT-RUN-DATE      PIC X(10).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER.                                           
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT-DATE          PIC X(10).                       
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  P-RPT-HEAD1         PIC X(70).                       
               10  FILLER              PIC X(13)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT-RUN-TIME      PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER              PIC X(53)    VALUE SPACES.       
               10  P-RPT-HEAD2         PIC X(24)    VALUE SPACES.       
               10  FILLER              PIC X(39)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  FILLER              PIC X(04)    VALUE SPACES.       
               10  P-RPT-PAGE-NO       PIC ZZ,ZZ9.                      
      *                                                                         
           05  WS-LOCAL-OFFICE-HEADER.                                  
               10  FILLER              PIC X(15)    VALUE               
                                                   'LOCAL OFFICE - '.   
               10  P-LOCAL-OFFICE      PIC X(03).                       
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-LOCAL-OFFICE-DESC PIC X(22).                       
               10  FILLER              PIC X(90)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-COLUMN-HEADER-1.                                      
T20889         10  FILLER              PIC X(16)    VALUE SPACES.       
               10  FILLER              PIC X(08)    VALUE 'CUSTOMER'.   
T20889         10  FILLER              PIC X(44)    VALUE SPACES.       
               10  FILLER              PIC X(05)    VALUE 'METER'.      
T20889         10  FILLER              PIC X(06)    VALUE SPACES.       
T21239         10  FILLER              PIC X(05)    VALUE 'CLASS'.      
T20889         10  FILLER              PIC X(02)    VALUE SPACES.       
T21239         10  FILLER              PIC X(04)    VALUE 'SPEC'.       
T21239         10  FILLER              PIC X(06)    VALUE SPACES.       
T19050         10  WS-STATUS-HDR       PIC X(07)    VALUE 'ACCOUNT'.    
T20889         10  FILLER              PIC X(05)    VALUE SPACES.       
T19588         10  FILLER              PIC X(13)    VALUE               
T19588             'NBR OF MONTHS'.                                     
T20889         10  FILLER              PIC X(02)    VALUE SPACES.       
T20889         10  FILLER              PIC X(05)    VALUE 'METER'.      
      *                                                                         
           05  WS-COLUMN-HEADER-2.                                      
               10  FILLER              PIC X(14)    VALUE               
                                                   'ACCOUNT NUMBER'.    
T20889         10  FILLER              PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(15)    VALUE               
                                                   'SERVICE ADDRESS'.   
T20889         10  FILLER              PIC X(37)    VALUE SPACES.       
T20889         10  FILLER              PIC X(06)    VALUE               
T20889                                             'NUMBER'.            
T20889         10  FILLER              PIC X(05)    VALUE SPACES.       
T21239         10  FILLER              PIC X(04)    VALUE 'CODE'.       
               10  FILLER              PIC X(03)    VALUE SPACES.       
T21239         10  FILLER              PIC X(04)    VALUE 'CODE'.       
T21239         10  FILLER              PIC X(06)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'STATUS'.     
T20889         10  FILLER              PIC X(06)    VALUE SPACES.       
T19588         10  FILLER              PIC X(08)    VALUE 'INACTIVE'.   
T19588         10  FILLER              PIC X(07)    VALUE SPACES.       
T21239         10  FILLER              PIC X(08)    VALUE 'CONSTANT'.   
T21239*                                                                         
      ****************************************************************          
      **        WORKING STORAGE FOR REPORT DETAIL LINES             **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-TABLE.                                             
T22981     05  WS-DETAIL-LINE  OCCURS 50 TIMES INDEXED BY WS-INDX.      
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-ACCOUNT-NO        PIC X(13).                       
               10  FILLER              PIC X(03)    VALUE SPACES.       
               10  P-NAME-ADDR         PIC X(50).                       
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-METER-NUMBER      PIC X(09).                       
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-CLASS-CODE        PIC X(02).                       
               10  FILLER              PIC X(05)    VALUE SPACES.       
               10  P-SPEC-CODE         PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  P-STATUS            PIC X(15).                       
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  P-INACTIVE-MTHS     PIC Z(3)9.                       
               10  P-INACTIVE-MTHS1 REDEFINES P-INACTIVE-MTHS           
                                       PIC X(04).                       
               10  FILLER              PIC X(06)    VALUE SPACES.       
               10  P-MTR-CNST          PIC Z(05)9.999.                  
               10  P-MTR-CNST1 REDEFINES P-MTR-CNST                     
                                       PIC X(10).                       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION TO SELECT INACTIVE METERS                            
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE METER_INACTIVE CURSOR FOR                        
                SELECT  AT.COMPANY_NO                                   
                       ,AT.LOCAL_OFFICE                                 
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.CUSTOMER_NO                                  
                       ,AT.PREMISE_NO                                   
                       ,AT.ADDRESS_ID                                   
                       ,AT.ADDRESS_FORMAT                               
                       ,MN.ACCOUNT_NO                                   
                       ,MN.METER_NO                                     
                       ,MN.LAST_REG_READ_DATE                           
                       ,CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ), 
           MN.MTR_STATUS_CHNG_DT ))   
                       ,CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ), 
           MN.MTR_STATUS_CHNG_DT ))  
                       ,MN.REG_ID_NO                                    
                       ,MN.REGISTER_RD_SEQ                              
                       ,UT.READ_CYCLE                                   
                       ,UT.READ_ROUTE                                   
                  FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                 WHERE  AT.ACCOUNT_NO         = MN.ACCOUNT_NO           
                   AND  AT.ACCOUNT_NO         = UT.ACCOUNT_NO           
                   AND  MN.CODE_UTIL_TYPE     = :WS-E                   
                   AND  MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE       
                   AND  MN.IC_NO              = UT.IC_NO                
                   AND  MN.CODE_METER_STATUS  = 'J'                     
                   AND  MN.MTR_STATUS_CHNG_DT < IIF(TRY_CONVERT(DATE, 
                                                   :WS-SIX-MTH-PRIOR-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-SIX-MTH-PRIOR-DT
              ) <> 0) OR (LEN(:WS-SIX-MTH-PRIOR-DT
              ) <> 10), CIS.CHAR2DATE(:WS-SIX-MTH-PRIOR-DT
              ), CONVERT(DATE, :WS-SIX-MTH-PRIOR-DT) )    
T22243             AND  AT.COMPANY_NO         = :WS-COMP-NO             
T29688             AND  MN.MTR_READ_SOURCE_CD <> 'X'                    
T22243           ORDER BY AT.COMPANY_NO                                 
                         ,AT.LOCAL_OFFICE                               
                         ,UT.READ_CYCLE                                 
                         ,UT.READ_ROUTE                                 
                         ,MN.REGISTER_RD_SEQ                            
T22981                   ,AT.ACCOUNT_NO                                 
T35434          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE METER_INACTIVE CURSOR FOR                                
MFA-TR*         SELECT  AT.COMPANY_NO                                           
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.CUSTOMER_NO                                          
MFA-TR*                ,AT.PREMISE_NO                                           
MFA-TR*                ,AT.ADDRESS_ID                                           
MFA-TR*                ,AT.ADDRESS_FORMAT                                       
MFA-TR*                ,MN.ACCOUNT_NO                                           
MFA-TR*                ,MN.METER_NO                                             
MFA-TR*                ,MN.LAST_REG_READ_DATE                                   
MFA-TR*                ,YEAR(:WS-JOB-PARM-DT - MN.MTR_STATUS_CHNG_DT)           
MFA-TR*                ,MONTH(:WS-JOB-PARM-DT - MN.MTR_STATUS_CHNG_DT)          
MFA-TR*                ,MN.REG_ID_NO                                            
MFA-TR*                ,MN.REGISTER_RD_SEQ                                      
MFA-TR*                ,UT.READ_CYCLE                                           
MFA-TR*                ,UT.READ_ROUTE                                           
MFA-TR*           FROM  CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_MTRD_ENVRNMT MN                                     
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*          WHERE  AT.ACCOUNT_NO         = MN.ACCOUNT_NO                   
MFA-TR*            AND  AT.ACCOUNT_NO         = UT.ACCOUNT_NO                   
MFA-TR*            AND  MN.CODE_UTIL_TYPE     = :WS-E                           
MFA-TR*            AND  MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE               
MFA-TR*            AND  MN.IC_NO              = UT.IC_NO                        
MFA-TR*            AND  MN.CODE_METER_STATUS  = 'J'                             
MFA-TR*            AND  MN.MTR_STATUS_CHNG_DT < :WS-SIX-MTH-PRIOR-DT            
MFA-TR*            AND  AT.COMPANY_NO         = :WS-COMP-NO                     
MFA-TR*            AND  MN.MTR_READ_SOURCE_CD <> 'X'                            
MFA-TR*          ORDER BY AT.COMPANY_NO                                         
MFA-TR*                  ,AT.LOCAL_OFFICE                                       
MFA-TR*                  ,UT.READ_CYCLE                                         
MFA-TR*                  ,UT.READ_ROUTE                                         
MFA-TR*                  ,MN.REGISTER_RD_SEQ                                    
MFA-TR*                  ,AT.ACCOUNT_NO                                         
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR DECLARATION TO SELECT INACTIVE ACCOUNTS                          
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE  ACCT_INACTIVE CURSOR FOR                        
                SELECT  AT.COMPANY_NO                                   
                       ,AT.LOCAL_OFFICE                                 
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.CUSTOMER_NO                                  
                       ,AT.PREMISE_NO                                   
                       ,AT.ADDRESS_ID                                   
                       ,AT.ADDRESS_FORMAT                               
                       ,MN.ACCOUNT_NO                                   
                       ,MN.METER_NO                                     
                       ,MN.LAST_REG_READ_DATE                           
                       ,MN.CODE_METER_STATUS                            
                       ,CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ), 
           MN.LAST_REG_READ_DATE ))   
                       ,CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ), 
           MN.LAST_REG_READ_DATE ))  
                       ,MN.REG_ID_NO                                    
                       ,MN.REGISTER_RD_SEQ                              
                       ,UT.READ_CYCLE                                   
                       ,UT.READ_ROUTE                                   
                  FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
                       ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
                 WHERE  AT.ACCOUNT_NO         = MN.ACCOUNT_NO           
                   AND  AT.ACCOUNT_NO         = UT.ACCOUNT_NO           
                   AND  AT.CODE_ACCT_STAT    IN ('B', 'J')              
                   AND  MN.CODE_UTIL_TYPE     = :WS-E                   
                   AND  MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE       
                   AND  MN.IC_NO              = UT.IC_NO                
                   AND  MN.CODE_METER_STATUS IN ('A', 'B', 'I')         
                   AND  MN.LAST_REG_READ_DATE < IIF(TRY_CONVERT(DATE, 
                                                   :WS-SIX-MTH-PRIOR-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-SIX-MTH-PRIOR-DT
              ) <> 0) OR (LEN(:WS-SIX-MTH-PRIOR-DT
              ) <> 10), CIS.CHAR2DATE(:WS-SIX-MTH-PRIOR-DT
              ), CONVERT(DATE, :WS-SIX-MTH-PRIOR-DT) )    
T22243             AND  AT.COMPANY_NO         = :WS-COMP-NO             
T22243           ORDER BY AT.COMPANY_NO                                 
                         ,AT.LOCAL_OFFICE                               
                         ,UT.READ_CYCLE                                 
                         ,UT.READ_ROUTE                                 
                         ,MN.REGISTER_RD_SEQ                            
T22981                   ,AT.ACCOUNT_NO                                 
T35434          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE  ACCT_INACTIVE CURSOR FOR                                
MFA-TR*         SELECT  AT.COMPANY_NO                                           
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.CUSTOMER_NO                                          
MFA-TR*                ,AT.PREMISE_NO                                           
MFA-TR*                ,AT.ADDRESS_ID                                           
MFA-TR*                ,AT.ADDRESS_FORMAT                                       
MFA-TR*                ,MN.ACCOUNT_NO                                           
MFA-TR*                ,MN.METER_NO                                             
MFA-TR*                ,MN.LAST_REG_READ_DATE                                   
MFA-TR*                ,MN.CODE_METER_STATUS                                    
MFA-TR*                ,YEAR(:WS-JOB-PARM-DT - MN.LAST_REG_READ_DATE)           
MFA-TR*                ,MONTH(:WS-JOB-PARM-DT - MN.LAST_REG_READ_DATE)          
MFA-TR*                ,MN.REG_ID_NO                                            
MFA-TR*                ,MN.REGISTER_RD_SEQ                                      
MFA-TR*                ,UT.READ_CYCLE                                           
MFA-TR*                ,UT.READ_ROUTE                                           
MFA-TR*           FROM  CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_MTRD_ENVRNMT MN                                     
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*          WHERE  AT.ACCOUNT_NO         = MN.ACCOUNT_NO                   
MFA-TR*            AND  AT.ACCOUNT_NO         = UT.ACCOUNT_NO                   
MFA-TR*            AND  AT.CODE_ACCT_STAT    IN ('B', 'J')                      
MFA-TR*            AND  MN.CODE_UTIL_TYPE     = :WS-E                           
MFA-TR*            AND  MN.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE               
MFA-TR*            AND  MN.IC_NO              = UT.IC_NO                        
MFA-TR*            AND  MN.CODE_METER_STATUS IN ('A', 'B', 'I')                 
MFA-TR*            AND  MN.LAST_REG_READ_DATE < :WS-SIX-MTH-PRIOR-DT            
MFA-TR*            AND  AT.COMPANY_NO         = :WS-COMP-NO                     
MFA-TR*          ORDER BY AT.COMPANY_NO                                         
MFA-TR*                  ,AT.LOCAL_OFFICE                                       
MFA-TR*                  ,UT.READ_CYCLE                                         
MFA-TR*                  ,UT.READ_ROUTE                                         
MFA-TR*                  ,MN.REGISTER_RD_SEQ                                    
MFA-TR*                  ,AT.ACCOUNT_NO                                         
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
T19050*                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSUM300 ENDS HERE'.                    
      *                                                                         
T21239 LINKAGE SECTION.                                                 
T21239*                                                                         
T21239 01  LINKAGE-PARM.                                                
T21239     05 WS-PARM-LENGTH           PIC S9(04) COMP.                 
T21239     05 WS-PARM-CONSTANT-CHECK   PIC X(01).                       
T21239*                                                                         
T21239 PROCEDURE DIVISION USING LINKAGE-PARM.                           
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 1100-PRODUCE-REPORTS        THRU 1100-EXIT.          
      *                                                                         
           PERFORM 1200-PRODUCE-ACCT-REPORT    THRU 1200-EXIT.          
T20181*                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
T19050*                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   0100-INITIALIZATION.                                     **          
      **                                                            **          
      **   SETS CURRENT DATE AND TIME TO THE REPORT, GETS JOB PARM  **          
      **   DATE AND OPENS THE OUTPUT FILES DEPENDING ON THE LINKAGE **          
      **   PARAMETER.                                               **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                          TO WS-RT-HH.             
           MOVE WS-MIN                         TO WS-RT-MM.             
           MOVE WS-SS                          TO WS-RT-SS.             
           MOVE WS-RUN-TIME                    TO P-RPT-RUN-TIME.       
           MOVE WS-PGRMNAME                    TO P-RPT-TITLE-PGNM.     
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE                        
                                               THRU 6240-EXIT           
              MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE         
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE                  TO WS-JOB-PARM-DT        
                                                  WS-CURRENT-DATE.      
           MOVE WS-CCYY                        TO WS-RD-CCYY.           
           MOVE WS-MM                          TO WS-RD-MM.             
           MOVE WS-DD                          TO WS-RD-DD.             
           MOVE WS-REP-DATE                    TO P-RPT-DATE            
                                    WS-DEFAULT-RPT-HEADER2-DT.          
T22243     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
T22243     IF  WS-SYSIN-COMP-NO LESS THAN OR EQUAL                      
T22243                                         TO SPACES OR LOW-VALUES  
T22243         MOVE WS-COMP-NO                 TO WS-SYSIN-COMP-NO      
T22243     END-IF.                                                      
T22243     MOVE WS-SYSIN-COMP-NO               TO WS-COMP-NO.           
T22243     MOVE WS-COMP-NO                     TO G6-COMPANY-NO.        
T22243     MOVE WS-PARM1                       TO WS-COMMAND.           
T22243     PERFORM 7600-START-FCSJC01          THRU 7600-EXIT.          
T22243     PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT.          
T22243     IF END-OF-SYSIPT                                             
T22243        CONTINUE                                                  
T22243     ELSE                                                         
T22243        PERFORM 7611-CLOSE                  THRU 7611-EXIT        
T22243     END-IF.                                                      
T22243     MOVE G6-PARM-DATA                   TO WS-INPUT-PARM-DATA.   
T22243     MOVE WS-INPUT-PARM-DATA(29:2)       TO WS-PARM-MNTH.         
T22243     IF WS-PARM-MNTH EQUAL SPACES OR LOW-VALUES OR WS-ZERO        
T22243        MOVE WS-SIX                      TO WS-PARM-MNTH          
T22243     END-IF.                                                      
T22243     MOVE WS-PARM-MNTH                   TO WS-PARM-MNTH1.        
T22243     PERFORM 7000-GET-MTHS-PRIOR-DT      THRU 7000-EXIT.          
T22243     MOVE WS-MTH-PRIOR-DT                TO WS-SIX-MTH-PRIOR-DT.  
T22243     MOVE WS-PARM-MNTH                   TO WS-RPT-MNTH           
T22243                                            WS-RPT-MNTHA          
T22243                                            WS-RPT2-MNTH          
T22243                                            WS-RPT3-MNTH.         
           MOVE WS-CURR-DATE                   TO WS-CURRENT-DATE.      
           MOVE WS-CCYY                        TO WS-RD-CCYY.           
           MOVE WS-MM                          TO WS-RD-MM.             
           MOVE WS-DD                          TO WS-RD-DD.             
           MOVE WS-REP-DATE                    TO P-RPT-RUN-DATE.       
      *                                                                         
T21239     IF  WS-PARM-CONSTANT-CHECK = WS-Y                            
               SET PARM-EXISTS                 TO TRUE                  
               OPEN OUTPUT FCSPT33-FILE, FCSPT331-FILE,                 
                    FCSPT332-FILE                                       
T21239     ELSE                                                         
               SET PARM-DOES-NOT-EXIST         TO TRUE                  
               OPEN OUTPUT FCSPT33-FILE, FCSPT332-FILE                  
T21239     END-IF.                                                      
      *                                                                         
           PERFORM 7110-OPEN-METER-INACTIVE    THRU 7110-EXIT.          
           PERFORM 7120-FETCH-METER-INACTIVE   THRU 7120-EXIT.          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1100-PRODUCE-REPORTS                                      **          
      **                                                            **          
      **  PROCESSES THOSE RECORDS WHERE ACCOUNT NO FROM CSS_ACCOUNT **          
      **  TABLE IS EQUAL TO THE LATEST ACCOUNT AT THAT PREMISE FOR  **          
      **  METERS THAT ARE INACTIVE FOR MORE THAN SIX MONTHS         **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
           MOVE '1100'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
      *                                                                         
               MOVE AT-PREMISE-NO              TO WS-CPD99-PREMISE-NO   
               PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT           
               MOVE WS-CPD99-ACCOUNT-NO        TO AT-ACCOUNT-NO         
               IF  AT-ACCOUNT-NO EQUAL MN-ACCOUNT-NO                    
                   IF  FIRST-TIME                                       
                       PERFORM 2010-LOC-OFF-BRK                         
                                               THRU 2010-EXIT           
                       MOVE AT-COMPANY-NO      TO C7-COMPANY-NO         
T22243                                            WS-PREV-COMP-NO       
                       PERFORM 7300-GET-COMPANY-DESC                    
                                               THRU 7300-EXIT           
                       MOVE C7-COMPANY-NAME    TO P-RPT-COMP-NAME       
                       INITIALIZE WS-TABLE                              
                       PERFORM 2040-ACCUM-DETAILS                       
                                               THRU 2040-EXIT           
                       MOVE WS-N               TO WS-FIRST-TIME         
                   ELSE                                                 
                       PERFORM 2020-CHK-FOR-BRKS                        
                                               THRU 2020-EXIT           
                   END-IF                                               
               END-IF                                                   
               PERFORM 7120-FETCH-METER-INACTIVE                        
                                               THRU 7120-EXIT           
           END-PERFORM.                                                 
           PERFORM 7130-CLOSE-METER-INACTIVE   THRU 7130-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
T22243         MOVE WS-COMP-NO                 TO C7-COMPANY-NO         
               PERFORM 7300-GET-COMPANY-DESC   THRU 7300-EXIT           
               MOVE C7-COMPANY-NAME            TO P-RPT-COMP-NAME       
               IF  PARM-EXISTS                                          
                   PERFORM 8100-PRINT-RPT1-HDNGS                        
                                               THRU 8100-EXIT           
                   MOVE WS-NO-DATA-LINE        TO PRT33-RECORD          
                   MOVE WS-2                   TO WS-LINE-SPACE         
                   PERFORM 8600-WRITE-PRINT-REC                         
                                               THRU 8600-EXIT           
                   PERFORM 8200-PRINT-RPT2-HDNGS                        
                                               THRU 8200-EXIT           
                   MOVE WS-NO-DATA-LINE        TO WS-PRT331-REC         
                   MOVE WS-2                   TO WS-LINE-SPACE         
                   PERFORM 8625-WRITE-PRINT-REC                         
                                               THRU 8625-EXIT           
               ELSE                                                     
                   PERFORM 8100-PRINT-RPT1-HDNGS                        
                                               THRU 8100-EXIT           
                   MOVE WS-NO-DATA-LINE        TO PRT33-RECORD          
                   MOVE WS-2                   TO WS-LINE-SPACE         
                   PERFORM 8600-WRITE-PRINT-REC                         
                                               THRU 8600-EXIT           
               END-IF                                                   
           ELSE                                                         
               PERFORM 2030-ACCT-NO-BRK        THRU 2030-EXIT           
               IF  PARM-EXISTS                                          
                   MOVE WS-2                   TO WS-LINE-SPACE         
                   MOVE WS-END-DATA-LINE       TO PRT33-RECORD          
                   PERFORM 8600-WRITE-PRINT-REC                         
                                               THRU 8600-EXIT           
                   MOVE WS-END-DATA-LINE       TO WS-PRT331-REC         
                   PERFORM 8625-WRITE-PRINT-REC                         
                                               THRU 8625-EXIT           
               ELSE                                                     
                   MOVE WS-2                   TO WS-LINE-SPACE         
                   MOVE WS-END-DATA-LINE       TO PRT33-RECORD          
                   PERFORM 8600-WRITE-PRINT-REC                         
                                               THRU 8600-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                           TO WS-FIRST-TIME         
                                                  WS-ACCT-REPORT        
           MOVE ZEROS                          TO WS-REC-COUNT          
                                                  WS-RPT1-PAGE-NO.      
           MOVE SPACES                         TO P-LOCAL-OFFICE        
                                                  P-LOCAL-OFFICE-DESC.  
           MOVE 'METER'                        TO WS-STATUS-HDR.        
           PERFORM 7150-OPEN-ACCT-INACTIVE     THRU 7150-EXIT           
           PERFORM 7160-FETCH-ACCT-INACTIVE    THRU 7160-EXIT.          
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PROCESSES THOSE RECORDS WITH ACCOUNTS INACTIVE FOR MORE THAN   *        
      * SIX MONTHS                                                     *        
      ******************************************************************        
      *                                                                         
ST     1200-PRODUCE-ACCT-REPORT.                                        
      *                                                                         
           MOVE '1200'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
      *                                                                         
               MOVE AT-PREMISE-NO              TO WS-CPD99-PREMISE-NO   
               PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT           
               MOVE WS-CPD99-ACCOUNT-NO        TO AT-ACCOUNT-NO         
               IF  AT-ACCOUNT-NO EQUAL MN-ACCOUNT-NO                    
                   IF  FIRST-TIME                                       
                       PERFORM 2010-LOC-OFF-BRK                         
                                               THRU 2010-EXIT           
T22243                 MOVE AT-COMPANY-NO      TO WS-PREV-COMP-NO       
                       MOVE AT-COMPANY-NO      TO C7-COMPANY-NO         
                       PERFORM 7300-GET-COMPANY-DESC                    
                                               THRU 7300-EXIT           
                       MOVE C7-COMPANY-NAME    TO P-RPT-COMP-NAME       
                       PERFORM 2040-ACCUM-DETAILS                       
                                               THRU 2040-EXIT           
                       MOVE WS-N               TO WS-FIRST-TIME         
                   ELSE                                                 
T22243              IF  AT-COMPANY-NO   NOT EQUAL WS-PREV-COMP-NO       
T22243                  PERFORM 2030-ACCT-NO-BRK                        
T22243                                         THRU 2030-EXIT           
T22243                  PERFORM 2010-LOC-OFF-BRK                        
T22243                                         THRU 2010-EXIT           
T22243                  MOVE AT-LOCAL-OFFICE   TO WS-PREV-LOCOFF1       
T22243                  MOVE WS-1              TO WS-CNTR               
T22243                  MOVE AT-COMPANY-NO     TO C7-COMPANY-NO         
T22243                  PERFORM 7300-GET-COMPANY-DESC                   
T22243                                         THRU 7300-EXIT           
T22243                  MOVE C7-COMPANY-NAME   TO P-RPT-COMP-NAME       
T22243                  MOVE AT-COMPANY-NO     TO WS-PREV-COMP-NO       
T22243                  PERFORM 2040-ACCUM-DETAILS                      
T22243                                         THRU 2040-EXIT           
T22243              ELSE                                                
                        IF  AT-LOCAL-OFFICE NOT EQUAL WS-PREV-LOCOFF1   
                            PERFORM 2030-ACCT-NO-BRK                    
                                               THRU 2030-EXIT           
                            PERFORM 2010-LOC-OFF-BRK                    
                                               THRU 2010-EXIT           
                            MOVE AT-LOCAL-OFFICE TO WS-PREV-LOCOFF1     
                            MOVE WS-1        TO WS-CNTR                 
                            PERFORM 2040-ACCUM-DETAILS                  
                                               THRU 2040-EXIT           
                      ELSE                                              
                          IF  MN-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO
                              PERFORM 2030-ACCT-NO-BRK                  
                                               THRU 2030-EXIT           
                              MOVE WS-1        TO WS-CNTR               
                              PERFORM 2040-ACCUM-DETAILS                
                                               THRU 2040-EXIT           
                          ELSE                                          
                              ADD WS-1         TO WS-CNTR               
                              PERFORM 2040-ACCUM-DETAILS                
                                               THRU 2040-EXIT           
                          END-IF                                        
                      END-IF                                            
T22243              END-IF                                              
                   END-IF                                               
               END-IF                                                   
      *                                                                         
               PERFORM 7160-FETCH-ACCT-INACTIVE                         
                                               THRU 7160-EXIT           
           END-PERFORM.                                                 
           PERFORM 7170-CLOSE-ACCT-INACTIVE    THRU 7170-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               PERFORM 8300-PRINT-RPT3-HDNGS   THRU 8300-EXIT           
               MOVE WS-NO-DATA-LINE            TO WS-PRT332-REC         
               MOVE WS-2                       TO WS-LINE-SPACE         
               PERFORM 8650-WRITE-PRINT-REC    THRU 8650-EXIT           
T19588     ELSE                                                         
               PERFORM 2030-ACCT-NO-BRK        THRU 2030-EXIT           
               MOVE WS-2                       TO WS-LINE-SPACE         
               MOVE WS-END-DATA-LINE           TO WS-PRT332-REC         
               PERFORM 8650-WRITE-PRINT-REC    THRU 8650-EXIT           
           END-IF.                                                      
      *                                                                         
END    1200-EXIT.                                                       
T19050     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINTS THE DETAILS ON A FRESH PAGE ON THE REPORT WHEN THERE IS *        
      * A CHANGE IN LOCAL OFFICE AND GETS THE LOCAL OFFICE DESC        *        
      ******************************************************************        
      *                                                                         
       2010-LOC-OFF-BRK.                                                
      *                                                                         
           MOVE WS-1                           TO WS-CNTR.              
           MOVE MN-ACCOUNT-NO                  TO WS-PREV-ACCOUNT-NO.   
           MOVE AT-LOCAL-OFFICE                TO WS-PREV-LOCOFF1       
                                                  WS-PREV-LOCOFF2.      
           MOVE WS-60                          TO WS-RPT1-LINE-NO       
                                                  WS-RPT2-LINE-NO.      
           MOVE AT-LOCAL-OFFICE                TO B1-LOCAL-OFFICE       
                                                  P-LOCAL-OFFICE.       
           MOVE AT-COMPANY-NO                  TO B1-COMPANY-NO.        
           PERFORM 7200-GET-LOCAL-OFFICE       THRU 7200-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE B1-LOCAL-OFFICE-DESC       TO P-LOCAL-OFFICE-DESC   
           ELSE                                                         
               MOVE SPACES                     TO P-LOCAL-OFFICE-DESC   
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECKS FOR MAJOR CONTROL BREAK ON LOCAL OFFICE AND MINOR ON    *        
      * ACCOUNT NO FOR BOTH METER CONSTANT = 1 AND METER CONSTANT > 1  *        
      * IF PARM EXISTS OR JUST FOR METERS INACTIVE FOR > 6 MONTHS      *        
      ******************************************************************        
      *                                                                         
       2020-CHK-FOR-BRKS.                                               
      *                                                                         
           IF  (PARM-EXISTS AND CONSTANT-ONE) OR                        
                PARM-DOES-NOT-EXIST                                     
T22243         IF AT-COMPANY-NO NOT EQUAL WS-PREV-COMP-NO               
T22243             PERFORM 2030-ACCT-NO-BRK     THRU 2030-EXIT          
T22243             PERFORM 2010-LOC-OFF-BRK     THRU 2010-EXIT          
T22243             PERFORM 2040-ACCUM-DETAILS   THRU 2040-EXIT          
T22243             MOVE AT-COMPANY-NO           TO C7-COMPANY-NO        
T22243             PERFORM 7300-GET-COMPANY-DESC                        
T22243                                          THRU 7300-EXIT          
T22243             MOVE C7-COMPANY-NAME         TO P-RPT-COMP-NAME      
T22243             MOVE AT-COMPANY-NO           TO WS-PREV-COMP-NO      
T22243         ELSE                                                     
                 IF AT-LOCAL-OFFICE NOT EQUAL WS-PREV-LOCOFF1           
                    PERFORM 2030-ACCT-NO-BRK    THRU 2030-EXIT          
                    PERFORM 2010-LOC-OFF-BRK    THRU 2010-EXIT          
                    PERFORM 2040-ACCUM-DETAILS  THRU 2040-EXIT          
                 ELSE                                                   
                    IF  MN-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO      
                        PERFORM 2030-ACCT-NO-BRK                        
                                                THRU 2030-EXIT          
                        MOVE WS-1               TO WS-CNTR              
                        PERFORM 2040-ACCUM-DETAILS                      
                                                THRU 2040-EXIT          
                    ELSE                                                
                        ADD WS-1                TO WS-CNTR              
                        PERFORM 2040-ACCUM-DETAILS                      
                                                THRU 2040-EXIT          
                    END-IF                                              
T22243           END-IF                                                 
               END-IF                                                   
T19050     ELSE                                                         
               IF  CONSTANT-GRTR-ONE                                    
T22243             IF AT-COMPANY-NO NOT EQUAL WS-PREV-COMP-NO           
T22243                 PERFORM 2030-ACCT-NO-BRK    THRU 2030-EXIT       
T22243                 PERFORM 2010-LOC-OFF-BRK    THRU 2010-EXIT       
T22243                 PERFORM 2040-ACCUM-DETAILS  THRU 2040-EXIT       
T22243                 MOVE AT-COMPANY-NO          TO C7-COMPANY-NO     
T22243                 PERFORM 7300-GET-COMPANY-DESC                    
T22243                                             THRU 7300-EXIT       
T22243                 MOVE C7-COMPANY-NAME        TO P-RPT-COMP-NAME   
T22243                 MOVE AT-COMPANY-NO          TO WS-PREV-COMP-NO   
T22243             ELSE                                                 
                    IF  AT-LOCAL-OFFICE NOT EQUAL WS-PREV-LOCOFF2       
                        PERFORM 2030-ACCT-NO-BRK                        
                                                   THRU 2030-EXIT       
                        PERFORM 2010-LOC-OFF-BRK                        
                                                   THRU 2010-EXIT       
                        PERFORM 2040-ACCUM-DETAILS                      
                                                   THRU 2040-EXIT       
                    ELSE                                                
                        IF MN-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO   
                           PERFORM 2030-ACCT-NO-BRK                     
                                               THRU 2030-EXIT           
                           MOVE WS-1           TO WS-CNTR               
                           PERFORM 2040-ACCUM-DETAILS                   
                                               THRU 2040-EXIT           
                       ELSE                                             
                           ADD WS-1            TO WS-CNTR               
                           PERFORM 2040-ACCUM-DETAILS                   
                                               THRU 2040-EXIT           
                       END-IF                                           
                    END-IF                                              
T22243             END-IF                                               
               END-IF                                                   
T19050     END-IF.                                                      
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SETS WS-INDX TO 1 AND POPULATES THE REPORT VARIABLES UNTIL     *        
      * WS-CNTR > 3. FOR AN ACCOUNT IF THERE ARE 4 METERS POPULATES    *        
      * THE REPORT VARIABLES FOR THE FOURTH METER                      *        
      ******************************************************************        
      *                                                                         
       2030-ACCT-NO-BRK.                                                
      *                                                                         
           SET WS-INDX                         TO WS-1.                 
T22981     MOVE WS-1                           TO WS-CNTR.              
           PERFORM 2050-POPULATE-REP-VAR       THRU 2050-EXIT           
                 UNTIL WS-CNTR > 3.                                     
T22981     PERFORM 2050-POPULATE-REP-VAR       THRU 2050-EXIT           
T22981         UNTIL WS-METER-NO(WS-CNTR) = SPACES                      
T22981*    IF  WS-METER-NO(WS-CNTR) GREATER THAN SPACES                         
T22981*        PERFORM 2050-POPULATE-REP-VAR   THRU 2050-EXIT                   
T22981*    END-IF.                                                              
      *                                                                         
           INITIALIZE WS-TABLE.                                         
           MOVE MN-ACCOUNT-NO                  TO WS-PREV-ACCOUNT-NO.   
      *                                                                         
       2030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ACCUMULATES THE DETAILS OF A PARTICULAR ACCOUNT AS LONG AS THE *        
      * CURRENT ACCOUNT IS SAME AS PREVIOUS ACCOUNT BOTH FOR INACTIVE  *        
      * METERS AND INACTIVE ACCOUNTS                                   *        
      ******************************************************************        
      *                                                                         
       2040-ACCUM-DETAILS.                                              
      *                                                                         
           PERFORM 7400-GET-MTR-CNST           THRU 7400-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE MC-CONSTANT                TO WS-MTR-CNST           
           ELSE                                                         
               MOVE ZEROES                     TO WS-MTR-CNST           
           END-IF.                                                      
      *                                                                         
           PERFORM 7500-GET-ELEC-MTR-DETAILS   THRU 7500-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE EM-ELEC-MTR-CLASS-CD       TO WS-MTR-CLASS-CD       
               MOVE EM-ELEC-MTR-SPEC-CD        TO WS-MTR-SPEC-CD        
           ELSE                                                         
               MOVE SPACES                     TO WS-MTR-CLASS-CD       
               MOVE SPACES                     TO WS-MTR-SPEC-CD        
           END-IF.                                                      
      *                                                                         
T19050     IF  ACCT-REPORT                                              
T19050         EVALUATE MN-CODE-METER-STATUS                            
T19050             WHEN 'A'                                             
T19050             WHEN 'B'                                             
T19050             WHEN 'I'                                             
                      MOVE WS-ACTIVE           TO WS-STATUS-DESC        
T19050             WHEN 'J'                                             
                      MOVE WS-INACTIVE         TO WS-STATUS-DESC        
T19050             WHEN 'K'                                             
                      MOVE WS-REMOVED          TO WS-STATUS-DESC        
T19050             WHEN OTHER                                           
                      MOVE SPACES              TO WS-STATUS-DESC        
T19050         END-EVALUATE                                             
T19050     ELSE                                                         
               IF  WS-CNTR = 1                                          
                   EVALUATE AT-CODE-ACCT-STAT                           
                      WHEN 'A'                                          
                         MOVE WS-ACTIVE        TO WS-STATUS-DESC        
                      WHEN 'J'                                          
                         MOVE WS-INACTIVE      TO WS-STATUS-DESC        
                      WHEN 'B'                                          
                         MOVE WS-FINAL-BILL    TO WS-STATUS-DESC        
                      WHEN 'S'                                          
                         MOVE WS-WRITE-OFF     TO WS-STATUS-DESC        
                      WHEN 'P'                                          
                         MOVE WS-PENDING       TO WS-STATUS-DESC        
                   END-EVALUATE                                         
T21239         ELSE                                                     
                   MOVE SPACES                 TO WS-STATUS-DESC        
T21239         END-IF                                                   
               IF  WS-MTR-CNST = WS-1                                   
                   SET  CONSTANT-ONE           TO TRUE                  
                   MOVE 'N'                    TO WS-MTR-CONST-GRTR-ONE 
T21239         ELSE                                                     
                   IF  WS-MTR-CNST > WS-1                               
                       SET CONSTANT-GRTR-ONE   TO TRUE                  
                       MOVE 'N'                TO WS-MTR-CONST-ONE      
                   END-IF                                               
T21239         END-IF                                                   
           END-IF.                                                      
      *                                                                         
           IF  WS-CNTR = WS-1                                           
               MOVE MN-ACCOUNT-NO              TO WS-ACCOUNT-NO(WS-CNTR)
               MOVE AT-ADDRESS-ID              TO HT-ADDRESS-ID         
               PERFORM 4000-MAIL-NAME-ADDRESS  THRU 4000-EXIT           
               MOVE WS-CUSTOMER-NAME           TO WS-NAME-ADDR(WS-CNTR) 
               MOVE WS-PR-STREET               TO WS-NAME-ADDR(2)       
               MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO WS-NAME-ADDR(3)       
           END-IF.                                                      
      *                                                                         
           MOVE MN-METER-NO                    TO WS-METER-NO(WS-CNTR). 
           MOVE WS-STATUS-DESC                 TO WS-STATUS(WS-CNTR).   
           COMPUTE WS-INACTIVE-MONTHS =                                 
                   (( WS-NO-YEARS) * 12 + WS-NO-MONTHS ).               
           MOVE WS-INACTIVE-MONTHS             TO                       
                                             WS-INACTIVE-MTHS(WS-CNTR). 
           MOVE WS-MTR-CNST                    TO                       
                                             WS-METER-CONSTANT(WS-CNTR).
           MOVE WS-MTR-CLASS-CD                TO                       
                                             WS-CLASS-CODE(WS-CNTR).    
           MOVE WS-MTR-SPEC-CD                 TO WS-SPEC-CODE(WS-CNTR).
      *                                                                         
       2040-EXIT.                                                       
END        EXIT.                                                        
T19050*                                                                         
      ******************************************************************        
      * REPORT VARIABLES ARE LOADED FROM THE WORKING STORAGE TABLE BOTH         
      * FOR INACTIVE ACCOUNTS AND INACTIVE METERS                               
      ******************************************************************        
      *                                                                         
       2050-POPULATE-REP-VAR.                                           
      *                                                                         
           MOVE WS-ACCOUNT-NO(WS-CNTR)         TO P-ACCOUNT-NO(WS-INDX) 
           MOVE WS-NAME-ADDR(WS-CNTR)          TO P-NAME-ADDR(WS-INDX)  
           MOVE WS-METER-NO(WS-CNTR)           TO                       
                                               P-METER-NUMBER(WS-INDX)  
           MOVE WS-STATUS(WS-CNTR)             TO P-STATUS(WS-INDX)     
           IF  WS-INACTIVE-MTHS(WS-CNTR) > 0                            
               MOVE WS-INACTIVE-MTHS(WS-CNTR)  TO                       
                                               P-INACTIVE-MTHS(WS-INDX) 
           ELSE                                                         
               MOVE SPACES                     TO                       
                                               P-INACTIVE-MTHS1(WS-INDX)
           END-IF                                                       
           IF  WS-METER-CONSTANT(WS-CNTR) > 0                           
               MOVE WS-METER-CONSTANT(WS-CNTR) TO P-MTR-CNST(WS-INDX)   
           ELSE                                                         
               MOVE SPACES                     TO P-MTR-CNST1(WS-INDX)  
           END-IF                                                       
           MOVE WS-CLASS-CODE(WS-CNTR)         TO P-CLASS-CODE(WS-INDX) 
           MOVE WS-SPEC-CODE(WS-CNTR)          TO P-SPEC-CODE(WS-INDX)  
           PERFORM 2060-CHK-PAGE-BRK           THRU 2060-EXIT           
      *                                                                         
           IF  ACCT-REPORT                                              
               MOVE WS-DETAIL-LINE(WS-INDX)    TO WS-PRT332-REC         
               PERFORM 8650-WRITE-PRINT-REC    THRU 8650-EXIT           
           ELSE                                                         
               IF (PARM-EXISTS AND CONSTANT-ONE) OR                     
                   PARM-DOES-NOT-EXIST                                  
                   MOVE WS-DETAIL-LINE(WS-INDX)                         
                                               TO PRT33-RECORD          
                   PERFORM 8600-WRITE-PRINT-REC                         
                                               THRU 8600-EXIT           
T19588         ELSE                                                     
                   MOVE WS-DETAIL-LINE(WS-INDX)                         
                                               TO WS-PRT331-REC         
                   PERFORM 8625-WRITE-PRINT-REC                         
                                               THRU 8625-EXIT           
T19588         END-IF                                                   
           END-IF.                                                      
           INITIALIZE WS-DETAIL-TABLE.                                  
           SET WS-INDX UP BY WS-1.                                      
T22981     ADD WS-1                            TO WS-CNTR.              
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T19496******************************************************************43111000
      * IF THE LINE NO IS GREATER THAN 50 PRINTS PAGE HEADERS. IF ALL  *        
      * THE DETIALS PERTAINING TO AN ACCOUNT ARE NOT PRINTING ON THE   *        
      * SAME PAGE FORCE THE LINE NO TO BE GREATER THAN 50              *        
      * ****************************************************************        
      *                                                                         
       2060-CHK-PAGE-BRK.                                               
      *                                                                         
           IF  ACCT-REPORT                                              
               IF  WS-CNTR = WS-1                                       
                   IF  (WS-RPT1-LINE-NO + 4) > WS-57                    
                       PERFORM 8300-PRINT-RPT3-HDNGS                    
                                               THRU 8300-EXIT           
                   END-IF                                               
                   MOVE WS-2                   TO WS-LINE-SPACE         
                   ADD  WS-2                   TO WS-RPT1-LINE-NO       
               ELSE                                                     
                   MOVE WS-1                   TO WS-LINE-SPACE         
                   ADD WS-1                    TO WS-RPT1-LINE-NO       
               END-IF                                                   
           ELSE                                                         
               IF  (PARM-EXISTS AND CONSTANT-ONE) OR                    
                    PARM-DOES-NOT-EXIST                                 
                    IF  WS-CNTR = WS-1                                  
                        IF  (WS-RPT1-LINE-NO + 4) > WS-57               
                            PERFORM 8100-PRINT-RPT1-HDNGS               
                                               THRU 8100-EXIT           
                        END-IF                                          
                        MOVE WS-2              TO WS-LINE-SPACE         
                        ADD  WS-2              TO WS-RPT1-LINE-NO       
                    ELSE                                                
                        MOVE WS-1              TO WS-LINE-SPACE         
                        ADD  WS-1              TO WS-RPT1-LINE-NO       
                    END-IF                                              
               ELSE                                                     
                    IF  WS-CNTR = WS-1                                  
                        IF  (WS-RPT2-LINE-NO + 4) > WS-57               
                            PERFORM 8200-PRINT-RPT2-HDNGS               
                                               THRU 8200-EXIT           
                        END-IF                                          
                        MOVE WS-2              TO WS-LINE-SPACE         
                        ADD  WS-2              TO WS-RPT2-LINE-NO       
                    ELSE                                                
                        MOVE WS-1              TO WS-LINE-SPACE         
                        ADD  WS-1              TO WS-RPT2-LINE-NO       
                    END-IF                                              
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      * COPY BOOK TO GET COMMON DATE                                   *        
      ******************************************************************        
       COPY CPD00040.                                                           
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      * COPY BOOK TO GET JOB PARM DATE                                 *        
      ******************************************************************        
       COPY CPD00037.                                                           
      ******************************************************************        
      * 7000-START-FJC01 ..                                            *        
      * SQL STATEMENTS TO RETRIEVE DATE FROM JOB PARM TABLE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************43111000
T19496* 6990-FETCH-CUR-ACCOUNT                                         *42840000
T19496*  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *31300000
T19496******************************************************************43111000
      *                                                                         
T19496     EXEC SQL                                                             
T19496         INCLUDE CPD00099                                                 
T19496     END-EXEC.                                                            
T19496*                                                                         
T19496 6995-CPD99-ERROR-ROUTINE.                                        
T19496*                                                                         
           DISPLAY '*********** PCSUM300 ABEND  *************'          
T19496     DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
           DISPLAY '* PREMISE-NO  = ', HOSTVAR-ELEMENT-1.               
           DISPLAY '* SQL CODE IS   ', WS-CPD99-RETURN-CODE.            
           DISPLAY '* PROGRAM ABENDING...                   *'.         
           DISPLAY '*********** PCSUM300 ABEND  *************'          
           PERFORM 9900-ABEND                  THRU 9900-EXIT.          
T19496*                                                                         
T19496 6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T20971******************************************************************        
T20971* 4000-MAIL-NAME-ADDRESS.                                        *        
T20971* TO FETCH THE PREMISE ADDRESS.                                  *        
T20971******************************************************************        
T20971     EXEC SQL                                                             
T20971         INCLUDE CPD00074                                                 
T20971     END-EXEC.                                                            
T20971*                                                                         
T20971******************************************************************        
T20971* 6010-REDUCE-EMBEDDED-SPACES (NEEDED BY CPD00074)               *        
T20971******************************************************************        
      *                                                                         
T20971     EXEC SQL                                                             
T20971         INCLUDE CPD00004                                                 
T20971     END-EXEC.                                                            
T20971*                                                                         
      *                                                                         
T22243******************************************************************        
T22243* CALCULATES DATE THAT IS X MONTHS PRIOR TO THE JOB PARM DATE    *        
T22243******************************************************************        
T22243*                                                                         
T22243 7000-GET-MTHS-PRIOR-DT.                                          
T22243*                                                                         
T22243     EXEC SQL                                                     
T35434         SELECT
              DATEADD( MONTH, -:WS-PARM-MNTH1, IIF(TRY_CONVERT(DATE, 
                                                        :WS-JOB-PARM-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-JOB-PARM-DT
              ) <> 0) OR (LEN(:WS-JOB-PARM-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-JOB-PARM-DT
              ), CONVERT(DATE, :WS-JOB-PARM-DT) ) ),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-MTH-PRIOR-DT,
              :WS-CURR-DATE                   
T22243     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET   :WS-MTH-PRIOR-DT =                                         
MFA-TR*                DATE(:WS-JOB-PARM-DT) - :WS-PARM-MNTH1 MONTHS            
MFA-TR*             ,:WS-CURR-DATE    =  CURRENT DATE                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22243*                                                                         
T22243     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T22243     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T22243         CONTINUE                                                 
T22243     ELSE                                                         
T22243         DISPLAY '*********** PCSUM300 ABEND  *************'      
T22243         DISPLAY '**  ERROR IN 7001-GET-MTH-PRIOR-DT     **'      
T22243         DISPLAY '**  JOB PARM DATE = ' WS-JOB-PARM-DT            
T22243         DISPLAY '**  RETURN CODE   = ' SQLCODE                   
T22243         DISPLAY '**  PROCESSING TERMINATED              **'      
T22243         DISPLAY '*********** PCSUM300 ABEND  *************'      
T22243         PERFORM 9900-ABEND              THRU 9900-EXIT           
T22243     END-IF.                                                      
T22243*                                                                         
T22243 7000-EXIT.                                                       
T22243     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPENS THE CURSOR FOR THE TABLES CSS_ACCOUNT AND                *        
      * CSS_MTRD_ENVRNMT                                               *        
      ******************************************************************        
      *                                                                         
       7110-OPEN-METER-INACTIVE.                                        
      *                                                                         
           MOVE '7110'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
               OPEN METER_INACTIVE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               DISPLAY '** ERROR IN 7110-OPEN-METER-INACTIVE   **'      
               DISPLAY '** RETURN CODE = ' SQLCODE                      
               DISPLAY '** PROCESSING TERMINATED               **'      
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES METERS THAT ARE INACTIVE FOR MORE THAN SIX MONTHS      *        
      ******************************************************************        
      *                                                                         
       7120-FETCH-METER-INACTIVE.                                       
      *                                                                         
           MOVE '7120'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
               FETCH  METER_INACTIVE                                    
                INTO :AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:MN-ACCOUNT-NO                                     
                    ,:MN-METER-NO                                       
                    ,:MN-LAST-REG-READ-DATE                             
                    ,:WS-NO-YEARS :WS-NULL-1                           
                    ,:WS-NO-MONTHS :WS-NULL-2                           
                    ,:MN-REG-ID-NO                                      
                    ,:MN-REGISTER-RD-SEQ                                
                    ,:UT-READ-CYCLE                                     
                    ,:UT-READ-ROUTE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD WS-1                        TO WS-REC-COUNT          
               IF  WS-NULL-1 < WS-0                                     
                   MOVE WS-0                   TO WS-NO-YEARS           
T19588         END-IF                                                   
               IF  WS-NULL-2 < WS-0                                     
                   MOVE WS-0                   TO WS-NO-MONTHS          
T19588         END-IF                                                   
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   CONTINUE                                             
               ELSE                                                     
                   DISPLAY '*********** PCSUM300 ABEND  *************'  
                   DISPLAY '**  ERROR IN 7120-FETCH-METER-INACTIVE  *'  
                   DISPLAY '**  ACCOUNT NO   = ' MN-ACCOUNT-NO          
                   DISPLAY '**  METER NO     = ' MN-METER-NO            
                   DISPLAY '**  LOCAL OFFICE = ' AT-LOCAL-OFFICE        
                   DISPLAY '**  PREMISE_NO   = ' AT-PREMISE-NO          
                   DISPLAY '**  RETURN CODE  = ' SQLCODE                
                   DISPLAY '**  PROCESSING TERMINATED               *'  
                   DISPLAY '*********** PCSUM300 ABEND  *************'  
                   PERFORM 9900-ABEND          THRU 9900-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES THE CURSOR FOR THE TABLES CSS_ACCOUNT AND               *        
      * CSS_MTRD_ENVRNMT                                               *        
      ******************************************************************        
      *                                                                         
       7130-CLOSE-METER-INACTIVE.                                       
ST    *                                                                         
           MOVE '7130'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
              EXEC SQL                                                  
                  CLOSE METER_INACTIVE                                  
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               DISPLAY '**  ERROR IN 7130-CLOSE-METER-INACTIVE  *'      
               DISPLAY '**  ACCOUNT NO   = ' MN-ACCOUNT-NO              
               DISPLAY '**  METER NO     = ' MN-METER-NO                
               DISPLAY '**  LOCAL OFFICE = ' AT-LOCAL-OFFICE            
               DISPLAY '**  PREMISE_NO   = ' AT-PREMISE-NO              
               DISPLAY '**  RETURN CODE  = ' SQLCODE                    
               DISPLAY '**  PROCESSING TERMINATED               *'      
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPENS ACCT_INACTIVE CURSOR                                     *        
      ******************************************************************        
      *                                                                         
       7150-OPEN-ACCT-INACTIVE.                                         
      *                                                                 32290000
           EXEC SQL                                                     
               OPEN ACCT_INACTIVE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31880000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               DISPLAY '**  ERROR IN 7150-OPEN-ACCT-INACTIVE   **'      
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 31970000
       7150-EXIT.                                                       
END        EXIT.                                                        
T20181*                                                                         
      ******************************************************************31740000
      * FETCHES ACCOUNTS THAT ARE INACTIVE FOR MORE THAN SIX MONTHS    *31740000
      ******************************************************************31740000
      *                                                                         
       7160-FETCH-ACCT-INACTIVE.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH  ACCT_INACTIVE                                     
                INTO :AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-ADDRESS-ID                                     
                    ,:AT-ADDRESS-FORMAT                                 
                    ,:MN-ACCOUNT-NO                                     
                    ,:MN-METER-NO                                       
                    ,:MN-LAST-REG-READ-DATE                             
                    ,:MN-CODE-METER-STATUS                              
                    ,:WS-NO-YEARS :WS-NULL-1                           
                    ,:WS-NO-MONTHS :WS-NULL-2                           
                    ,:MN-REG-ID-NO                                      
                    ,:MN-REGISTER-RD-SEQ                                
                    ,:UT-READ-CYCLE                                     
                    ,:UT-READ-ROUTE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD WS-1                        TO WS-REC-COUNT          
               IF WS-NULL-1 < WS-0                                      
                  MOVE WS-0                    TO WS-NO-YEARS           
               END-IF                                                   
               IF WS-NULL-2 < WS-0                                      
                  MOVE WS-0                    TO WS-NO-MONTHS          
               END-IF                                                   
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   CONTINUE                                             
               ELSE                                                     
                   DISPLAY '*********** PCSUM300 ABEND  *************'  
                   DISPLAY '**  ERROR IN 7160-FETCH-ACCT-INACTIVE  **'  
                   DISPLAY '**  ACCOUNT NO   = ' MN-ACCOUNT-NO          
                   DISPLAY '**  METER NO     = ' MN-METER-NO            
                   DISPLAY '**  LOCAL OFFICE = ' AT-LOCAL-OFFICE        
                   DISPLAY '**  PREMISE_NO   = ' AT-PREMISE-NO          
                   DISPLAY '**  RETURN CODE  = ' SQLCODE                
                   DISPLAY '**  PROCESSING TERMINATED              **'  
                   DISPLAY '*********** PCSUM300 ABEND  *************'  
                   PERFORM 9900-ABEND          THRU 9900-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES ACCT_INACTIVE CURSOR                                    *        
      ******************************************************************        
      *                                                                         
       7170-CLOSE-ACCT-INACTIVE.                                        
      *                                                                 32130000
           EXEC SQL                                                     
               CLOSE ACCT_INACTIVE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32170000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               DISPLAY '**  ERROR IN 7170-CLOSE-ACCT-INACTIVE  **'      
               DISPLAY '**  ACCOUNT NO   = ' MN-ACCOUNT-NO              
               DISPLAY '**  METER NO     = ' MN-METER-NO                
               DISPLAY '**  LOCAL OFFICE = ' AT-LOCAL-OFFICE            
               DISPLAY '**  PREMISE_NO   = ' AT-PREMISE-NO              
               DISPLAY '**  RETURN CODE  = ' SQLCODE                    
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 32260000
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32361900
      ******************************************************************        
      * SELECTS THE LOCAL OFFICE DESCRIPTION FOR THE GIVEN LOCAL OFFICE*        
      * AND COMPANY NO                                                 *        
      ******************************************************************        
      *                                                                         
       7200-GET-LOCAL-OFFICE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE_DESC                                 
                 INTO :B1-LOCAL-OFFICE-DESC                             
                 FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO   = :B1-COMPANY-NO                     
                  AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCAL_OFFICE_DESC                                         
MFA-TR*          INTO :B1-LOCAL-OFFICE-DESC                                     
MFA-TR*          FROM CSS_LOCAL_OFFICE                                          
MFA-TR*         WHERE COMPANY_NO   = :B1-COMPANY-NO                             
MFA-TR*           AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               DISPLAY '**  ERROR IN 7200-GET-LOCAL-OFFICE     **'      
               DISPLAY '**  COMPANY NO   = ' B1-COMPANY-NO              
               DISPLAY '**  LOCAL OFFICE = ' B1-LOCAL-OFFICE            
               DISPLAY '**  RETURN CODE  = ' SQLCODE                    
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECTS COMPANY NAME FOR THE GIVEN COMPANY NO                  *        
      ******************************************************************        
      *                                                                         
       7300-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7300'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           EXEC SQL                                                     
               SELECT COMPANY_NAME                                      
                 INTO :C7-COMPANY-NAME                                  
                 FROM CSS_COMPANY WITH(READUNCOMMITTED)                         
                WHERE COMPANY_NO = :C7-COMPANY-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM CSS_COMPANY                                               
MFA-TR*         WHERE COMPANY_NO = :C7-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               DISPLAY '**  ERROR IN 7300-GET-COMPANY-DESC     **'      
               DISPLAY '**  COMPANY NO  = ' C7-COMPANY-NO               
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 32260000
       7300-EXIT.                                                       
END        EXIT.                                                        
T19050*                                                                 32361900
      ******************************************************************        
      * SELECTS METER CONSTANT FROM CSS_MTR_CAP                        *        
      ******************************************************************        
T20889*                                                                         
       7400-GET-MTR-CNST.                                               
T20889*                                                                         
           MOVE '7400'                         TO WS-ACTIVE-PARAGRAPH.  
T20889*                                                                         
T20889     EXEC SQL                                                     
               SELECT CONSTANT                                          
T20889           INTO :MC-CONSTANT                                      
T20889           FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                         
                WHERE METER_NO       = :MN-METER-NO                     
T22243            AND COMPANY_NO     = :AT-COMPANY-NO                   
                  AND REG_ID_NO      = :MN-REG-ID-NO                    
                  AND CODE_UTIL_TYPE = :WS-E                            
T35434                                                           
T20889     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CONSTANT                                                  
MFA-TR*          INTO :MC-CONSTANT                                              
MFA-TR*          FROM CSS_MTR_CAP                                               
MFA-TR*         WHERE METER_NO       = :MN-METER-NO                             
MFA-TR*           AND COMPANY_NO     = :AT-COMPANY-NO                           
MFA-TR*           AND REG_ID_NO      = :MN-REG-ID-NO                            
MFA-TR*           AND CODE_UTIL_TYPE = :WS-E                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20889*                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
T20889     ELSE                                                         
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               DISPLAY '**  ERROR IN 7400-GET-MTR-CNST         **'      
               DISPLAY '**  METER NO    = ' MN-METER-NO                 
               DISPLAY '**  REG ID NO   = ' MN-REG-ID-NO                
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
T20889     END-IF.                                                      
T20889*                                                                         
       7400-EXIT.                                                       
T20889     EXIT.                                                        
T20889*                                                                         
      ******************************************************************        
      * SELECTS MTR CLASS CODE AND MTR SPEC CODE FROM CSS_ELEC_METER   *        
      ******************************************************************        
T21239*                                                                         
       7500-GET-ELEC-MTR-DETAILS.                                       
T21239*                                                                         
           MOVE '7500'                         TO WS-ACTIVE-PARAGRAPH.  
T21239*                                                                         
T21239     EXEC SQL                                                     
               SELECT  ELEC_MTR_CLASS_CD                                
                      ,ELEC_MTR_SPEC_CD                                 
                 INTO :EM-ELEC-MTR-CLASS-CD,                            
                      :EM-ELEC-MTR-SPEC-CD                              
                 FROM  CSS_ELEC_METER WITH(READUNCOMMITTED)                     
                WHERE  METER_NO       = :MN-METER-NO                    
T22243            AND  COMPANY_NO     = :AT-COMPANY-NO                  
                  AND  CODE_UTIL_TYPE = :WS-E                           
T35434                                                           
T21239     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  ELEC_MTR_CLASS_CD                                        
MFA-TR*               ,ELEC_MTR_SPEC_CD                                         
MFA-TR*          INTO :EM-ELEC-MTR-CLASS-CD,                                    
MFA-TR*               :EM-ELEC-MTR-SPEC-CD                                      
MFA-TR*          FROM  CSS_ELEC_METER                                           
MFA-TR*         WHERE  METER_NO       = :MN-METER-NO                            
MFA-TR*           AND  COMPANY_NO     = :AT-COMPANY-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = :WS-E                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21239*                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
T21239     ELSE                                                         
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               DISPLAY '**  ERROR IN 7500-GET-ELEC-MTR-DETAILS  *'      
               DISPLAY '**  METER NO    = ' MN-METER-NO                 
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED               *'      
               DISPLAY '*********** PCSUM300 ABEND  *************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
T21239     END-IF.                                                      
T21239*                                                                         
       7500-EXIT.                                                       
T21239     EXIT.                                                        
T21239*                                                                         
      ******************************************************************        
      * IF PARM DOES NOT EXIST PRINTS HEADERS FOR METERS INACTIVE FOR  *        
      * LONGER THAN SIX MONTHS AND IF PARM EXISTS PRINTS HEADERS FOR   *        
      * METERS INACTIVE FOR LONGER THAN SIX MONTHS WITH MTR CONSTANT = 1        
T22243* NO OF MONTHS IS TAKEN DYNAMICALLY FROM PARM, DEFAULT BEING 6   *        
      ******************************************************************        
T21239*                                                                         
       8100-PRINT-RPT1-HDNGS.                                           
T21239*                                                                         
           MOVE '8100'                         TO WS-ACTIVE-PARAGRAPH.  
           MOVE 0                              TO WS-RPT1-LINE-NO.      
           ADD WS-1                            TO WS-RPT1-PAGE-NO.      
           MOVE WS-RPT1-PAGE-NO                TO P-RPT-PAGE-NO.        
           MOVE WS-RPT-TITLE                   TO PRT33-DATA.           
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           IF  PARM-EXISTS                                              
               MOVE WS-DEFAULT-RPT-HEADER1A    TO P-RPT-HEAD1           
T21239     ELSE                                                         
               MOVE WS-DEFAULT-RPT-HEADER1     TO P-RPT-HEAD1           
T21239     END-IF.                                                      
           MOVE WS-RPT-HEADER                  TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
           MOVE WS-DEFAULT-RPT-HEADER2         TO P-RPT-HEAD2.          
           MOVE WS-RPT-HEADER-2                TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
T21239*                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-LOCAL-OFFICE-HEADER     TO PRT33-DATA            
               MOVE WS-2                       TO WS-LINE-SPACE         
               PERFORM 8600-WRITE-PRINT-REC    THRU 8600-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-COLUMN-HEADER-1             TO PRT33-DATA.           
           MOVE WS-2                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
           MOVE WS-COLUMN-HEADER-2             TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
           MOVE WS-LINE                        TO PRT33-DATA.           
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8600-WRITE-PRINT-REC        THRU 8600-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               ADD WS-07                       TO WS-RPT1-LINE-NO       
T19588     ELSE                                                         
               ADD WS-09                       TO WS-RPT1-LINE-NO       
T19588     END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * IF PARM EXISTS PRINTS HEADERS FOR METERS INACTIVE FOR LONGER   *        
      * THAN SIX MONTHS WITH METER CONSTANT > 1                        *        
T22243* NO OF MONTHS IS TAKEN DYNAMICALLY FROM PARM, DEFAULT BEING 6   *        
      ******************************************************************        
      *                                                                         
       8200-PRINT-RPT2-HDNGS.                                           
      *                                                                         
           MOVE '8200'                         TO WS-ACTIVE-PARAGRAPH.  
           MOVE 0                              TO WS-RPT2-LINE-NO.      
           ADD WS-1                            TO WS-RPT2-PAGE-NO.      
           MOVE WS-RPT2-PAGE-NO                TO P-RPT-PAGE-NO.        
           MOVE WS-RPT-TITLE                   TO WS-PRT331-DATA.       
           MOVE WS-PRT331-REC                  TO PRT331-RECORD.        
           WRITE PRT331-RECORD AFTER ADVANCING PAGE.                    
                                                                        
           MOVE WS-DEFAULT-RPT2-HEADER1        TO P-RPT-HEAD1.          
           MOVE WS-RPT-HEADER                  TO WS-PRT331-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
           MOVE WS-DEFAULT-RPT-HEADER2         TO P-RPT-HEAD2.          
           MOVE WS-RPT-HEADER-2                TO WS-PRT331-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               CONTINUE                                                 
T19588     ELSE                                                         
               MOVE WS-LOCAL-OFFICE-HEADER     TO WS-PRT331-DATA        
               MOVE WS-2                       TO WS-LINE-SPACE         
               PERFORM 8625-WRITE-PRINT-REC    THRU 8625-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-COLUMN-HEADER-1             TO WS-PRT331-DATA.       
           MOVE WS-2                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
           MOVE WS-COLUMN-HEADER-2             TO WS-PRT331-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
           MOVE WS-LINE                        TO WS-PRT331-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8625-WRITE-PRINT-REC        THRU 8625-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               ADD  WS-07                      TO WS-RPT2-LINE-NO       
           ELSE                                                         
               ADD  WS-09                      TO WS-RPT2-LINE-NO       
T19588     END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINTS HEADERS FOR ACCOUNTS INACTIVE FOR LONGER THAN 6 MONTHS  *        
T22243* NO OF MONTHS IS TAKEN DYNAMICALLY FROM PARM, DEFAULT BEING 6   *        
      ******************************************************************        
      *                                                                         
       8300-PRINT-RPT3-HDNGS.                                           
      *                                                                         
           MOVE '8300'                         TO WS-ACTIVE-PARAGRAPH.  
           MOVE 0                              TO WS-RPT1-LINE-NO.      
           ADD WS-1                            TO WS-RPT1-PAGE-NO.      
           MOVE WS-RPT1-PAGE-NO                TO P-RPT-PAGE-NO.        
           MOVE WS-RPT-TITLE                   TO WS-PRT332-DATA.       
           MOVE WS-PRT332-REC                  TO PRT332-RECORD.        
           WRITE PRT332-RECORD AFTER ADVANCING PAGE.                    
           MOVE WS-DEFAULT-RPT3-HEADER1        TO P-RPT-HEAD1.          
           MOVE WS-RPT-HEADER                  TO WS-PRT332-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8650-WRITE-PRINT-REC        THRU 8650-EXIT.          
           MOVE WS-DEFAULT-RPT-HEADER2         TO P-RPT-HEAD2.          
           MOVE WS-RPT-HEADER-2                TO WS-PRT332-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8650-WRITE-PRINT-REC        THRU 8650-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-LOCAL-OFFICE-HEADER     TO WS-PRT332-DATA        
               MOVE WS-2                       TO WS-LINE-SPACE         
               PERFORM 8650-WRITE-PRINT-REC    THRU 8650-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-COLUMN-HEADER-1             TO WS-PRT332-DATA.       
           MOVE WS-2                           TO WS-LINE-SPACE.        
           PERFORM 8650-WRITE-PRINT-REC        THRU 8650-EXIT.          
           MOVE WS-COLUMN-HEADER-2             TO WS-PRT332-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8650-WRITE-PRINT-REC        THRU 8650-EXIT.          
           MOVE WS-LINE                        TO WS-PRT332-DATA.       
           MOVE WS-1                           TO WS-LINE-SPACE.        
           PERFORM 8650-WRITE-PRINT-REC        THRU 8650-EXIT.          
      *                                                                         
           IF  WS-REC-COUNT = WS-0                                      
               ADD  WS-07                      TO WS-RPT1-LINE-NO       
T19588     ELSE                                                         
               ADD  WS-09                      TO WS-RPT1-LINE-NO       
T19588     END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * WRITES THE PRT33-RECORD.                                                
      ******************************************************************        
      *                                                                         
       8600-WRITE-PRINT-REC.                                            
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * WRITES THE PRT331-RECORD.                                               
      ******************************************************************        
      *                                                                         
       8625-WRITE-PRINT-REC.                                            
      *                                                                         
           MOVE WS-PRT331-REC                  TO PRT331-RECORD.        
           WRITE PRT331-RECORD AFTER ADVANCING WS-LINE-SPACE.           
      *                                                                         
       8625-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * WRITES THE PRT332-RECORD.                                               
      ******************************************************************        
      *                                                                         
       8650-WRITE-PRINT-REC.                                            
      *                                                                         
           MOVE WS-PRT332-REC                  TO PRT332-RECORD.        
           WRITE PRT332-RECORD AFTER ADVANCING WS-LINE-SPACE.           
      *                                                                         
       8650-EXIT.                                                       
END        EXIT.                                                        
T19050*                                                                         
      ******************************************************************        
      * CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM               *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           IF  WS-PARM-CONSTANT-CHECK = WS-Y                            
               CLOSE FCSPT33-FILE, FCSPT331-FILE, FCSPT332-FILE         
           ELSE                                                         
               CLOSE FCSPT33-FILE, FCSPT332-FILE                        
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
T20971******************************************************************        
T20971* 9700-PROCESS-ABEND  (REQUIED BY CPD00074)                      *        
T20971******************************************************************        
T20971 COPY CPD0023B.                                                           
      *                                                                         
