       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSSO312.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   CANCEL ORDERS THAT ARE DISPATCHED TO CLICK AND SEND THEM  **         
      **   TO CAD.                                                   **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
P00718*    07/03    MSR       ORIGINAL VERSION                       **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSR00092.
MSQ002    05 ARG-5 PIC X(26).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO312'.
MSQ017     COPY MFASQLM.
                                                                        
*                                                                       
      *01 LOC-RESLTSET   USAGE SQL TYPE IS                              
      *                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
       01  MISC.                                                        
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-RETURN-CODE         PIC S9(9) COMP VALUE +0.          
           05  WS-PGRMNAME            PIC X(08) VALUE 'PCSSO312'.       
           05  WS-FETCH-ROWS          PIC 9(09) VALUE ZEROS.            
           05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOODR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTSKQUE                                                
           END-EXEC.                                                            
                                                                        
      **                                                                        
           EXEC SQL                                                     
             DECLARE SO_ORDER_CURSOR CURSOR WITH HOLD  FOR   
                 SELECT DISTINCT(VO.SERV_ORDER_NO)                      
                       ,COMPANY_NO                                      
                   FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                   
                        CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)              
                  WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO             
                    AND VI.TASK_STATUS_CD = 'S'                         
                    AND VI.WORK_TYPE_CD > ''                            
                    AND VI.WORK_TYPE_CD <> 'FIN'                        
                                                                 
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_ORDER_CURSOR CURSOR WITH HOLD WITH RETURN FOR           
MFA-TR*          SELECT DISTINCT(VO.SERV_ORDER_NO)                              
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*            FROM CSS_SO_DATA VO,                                         
MFA-TR*                 CSS_SO_ORDER_INST VI                                    
MFA-TR*           WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                     
MFA-TR*             AND VI.TASK_STATUS_CD = 'S'                                 
MFA-TR*             AND VI.WORK_TYPE_CD > ''                                    
MFA-TR*             AND VI.WORK_TYPE_CD <> 'FIN'                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR CURSOR
MSQ001          FOR CALL CSR00092 ( :VO-SERV-ORDER-NO
                  , '10'
                  , '2'
                  , 'SYSTEM'
                  , :MFA-CSR00092.ARG-5
                  , 'S109'
                  , 'YR'
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-ORDERS          THRU 1000-EXIT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       1000-PROCESS-ORDERS.                                             
                                                                        
           EXEC SQL                                                     
               OPEN SO_ORDER_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           PERFORM UNTIL WS-FETCH-ROWS EQUAL NOT-FOUND                  
               PERFORM 1100-FETCH-ROWS        THRU 1100-EXIT            
               PERFORM 2000-INSERT-ROWS       THRU 2000-EXIT            
           END-PERFORM.                                                 
                                                                        
           EXEC SQL                                                     
              CLOSE SO_ORDER_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH SO_ORDER_CURSOR                                     
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-ACTIVE-RETURN-CODE    TO WS-FETCH-ROWS       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING SO CURSOR          *'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-INSERT-ROWS.                                                
           PERFORM 7000-UPDATE-SO-INST            THRU 7000-EXIT.       
           PERFORM 7200-INSERT-TASK-QUEUE         THRU 7200-EXIT.       
           PERFORM 7300-UPDATE-SO-DATA            THRU 7300-EXIT.       
           PERFORM 7400-UPDATE-SO-STATUS          THRU 7400-EXIT.       
       2000-EXIT.                                                       
                                                                        
       7000-UPDATE-SO-INST.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_ORDER_INST                                  
                 SET SO_INST_SEQ_NO = SO_INST_SEQ_NO + 1                
                    ,TASK_STATUS_CD = 'C'                               
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
                AND WORK_TYPE_CD > ''                                   
                AND TASK_STATUS_CD = 'S'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATE TASK STATUS AND SEQ NO*'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-INSERT-TASK-QUEUE.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SO_TASK_QUEUE                             
                       (SERV_ORDER_NO,                                  
                        CREATED_TS,                                     
                        COMPANY_NO,                                     
                        TASK_PRIORITY,                                  
                        CREATED_BY_USER_ID,                             
                        SO_BUSINESS_UNIT,                               
                        CALL_ID,                                        
                        CALL_NUMBER)                                    
                VALUES (:VO-SERV-ORDER-NO,                              
                        CIS.CURRENT$TIMESTAMP(),                              
                        :VO-COMPANY-NO,                                 
                        '1',                                            
                        'SYSTEM',                                       
                        '',                                             
                        :VO-SERV-ORDER-NO,                              
                        '1')                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SO_TASK_QUEUE                                     
MFA-TR*                (SERV_ORDER_NO,                                          
MFA-TR*                 CREATED_TS,                                             
MFA-TR*                 COMPANY_NO,                                             
MFA-TR*                 TASK_PRIORITY,                                          
MFA-TR*                 CREATED_BY_USER_ID,                                     
MFA-TR*                 SO_BUSINESS_UNIT,                                       
MFA-TR*                 CALL_ID,                                                
MFA-TR*                 CALL_NUMBER)                                            
MFA-TR*         VALUES (:VO-SERV-ORDER-NO,                                      
MFA-TR*                 CURRENT TIMESTAMP,                                      
MFA-TR*                 :VO-COMPANY-NO,                                         
MFA-TR*                 '1',                                                    
MFA-TR*                 'SYSTEM',                                               
MFA-TR*                 '',                                                     
MFA-TR*                 :VO-SERV-ORDER-NO,                                      
MFA-TR*                 '1')                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING INTO TASK QUEUE    *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-UPDATE-SO-DATA.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
                 SET PRINTED_IND = 'N'                                  
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATE SO DATA               *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-UPDATE-SO-STATUS.                                           

MSQ002     EXEC SQL
MSQ002         SELECT CIS.CURRENT$TIMESTAMP()
MSQ002           INTO :MFA-CSR00092.ARG-5
MSQ002     END-EXEC
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00092 (:VO-SERV-ORDER-NO,                         
      *                      '10',                                      
      *                      '2',                                       
      *                      'SYSTEM',                                  
      *                      CURRENT TIMESTAMP,                         
      *                      'S109',                                    
      *                      'YR')                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              DISPLAY '************* PCSSO312 *******************'      
              DISPLAY '** 7400 :  RETURN CODE ERROR             '       
              DISPLAY '** 7400 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  NO RESULTSET RETURNED'                
              DISPLAY '************* PCSSO312 *******************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-RESLTSET)                                           
      *       WITH PROCEDURE CSR00092                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR CURSOR FOR RESULT SET             
      *       :LOC-RESLTSET                                             
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR INTO                                 
                 :WS-RETURN-CODE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* PCSSO312 *******************'      
              DISPLAY '** 7400 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  FETCH FROM CSR00092 RESULTSET FAILED' 
              DISPLAY '************* PCSSO311********************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              CLOSE RESULT_SET_CSR                                      
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO312 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
