       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSSO311.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   EXTRACT ORDERS THAT ARE DISPATCHED TO CAD PRIOR TO FIELD  **         
      **   MOBILITY PILOT IMPLMENTATION AND SEND THEM TO CLICK.      **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
P00718*    06/14    MSR       ORIGINAL VERSION                       **         
A05020*    11/05    MSR       FIX ISSUE WITH INITIALIZATION          **         
ACT193*    06/16    TP7R341   RENAME RESULT_SET_CSR TO               **         
ACT193*    A05460             RESULT_SET_CRSR IN 7300- PARA          **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO311'.
MSQ017     COPY MFASQLM.
                                                                        
*                                                                       
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
                                                                        
      *01 LOC-RESLTSET   USAGE SQL TYPE IS                              
      *                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
       01  WS-NUM-CUT-OFF-SPLIT.                                        
           05  WS-NUM-CUT-OFF-DATA.                                     
               10  WS-NUM-CUT-OFF-TEXT   PIC X(23).                     
               10  WS-NUM-CUT-OFF-NUM    PIC 9(04).                     
           05  FILLER                    PIC X(53).                     
                                                                        
       01  MISC.                                                        
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-RETURN-CODE         PIC S9(9) COMP VALUE +0.          
           05  WS-CURRENT-DATE        PIC X(10) VALUE SPACES.           
           05  WS-OLD-WORK-AREA       PIC X(10) VALUE SPACES.           
           05  WS-OLD-WORK-AREA-TX    PIC X(50) VALUE SPACES.           
           05  WS-NEW-WORK-AREA       PIC X(50) VALUE SPACES.           
           05  WS-LOCAL-OFFICE        PIC X(03) VALUE SPACES.           
           05  WS-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.           
           05  WS-WORK-TYPE-CD        PIC X(03) VALUE SPACES.           
           05  WS-CRAWL-IND           PIC X(01) VALUE SPACES.           
           05  WS-METER-IND           PIC X(01) VALUE SPACES.           
           05  WS-ZIP-CODE            PIC X(05) VALUE SPACES.           
           05  WS-READ-ROUTE          PIC S9(04) COMP VALUE ZEROS.      
           05  WS-POINT-ID            PIC X(10) VALUE SPACES.           
           05  WS-BUSINESS-UNIT       PIC X(03) VALUE SPACES.           
           05  WS-FETCH-ROWS          PIC 9(09) VALUE ZEROS.            
           05  WS-CUTOFF-DATE         PIC X(10) VALUE '2015-01-01'.     
           05  WS-PGRMNAME            PIC X(08) VALUE 'PCSSO311'.       
           05  WS-WORK-DISTRICT       PIC X(50) VALUE SPACES.           
           05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPREM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTSKQUE                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      **                                                                        
           EXEC SQL                                                     
             DECLARE SO_ORDER_CURSOR CURSOR WITH HOLD  FOR   
                 SELECT SERV_ORDER_NO                                   
                       ,PREMISE_NO                                      
                       ,SO_BUSINESS_UNIT                                
                       ,COMPANY_NO                                      
                       ,LOCAL_OFFICE                                    
                   FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                    
                  WHERE ORDER_STATE_CD = 'A'                            
                    AND CAST(WANTED_BY_DATETIME AS DATE) <> 
              IIF(TRY_CONVERT(DATE, :WS-CUTOFF-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CUTOFF-DATE
              ) <> 0) OR (LEN(:WS-CUTOFF-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-CUTOFF-DATE
              ), CONVERT(DATE, :WS-CUTOFF-DATE) )     
                    AND CAST(ASSIGNED_DATETIME AS DATE) >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)         
                    AND ORDER_TYPE_CD NOT IN ('FM007', 'FW022' ,'FW024')
                    AND BACK_DATED_IND <> 'Y'                           
                    AND EXISTS                                          
                          (SELECT 1                                     
                             FROM CSS_PREMISE PR WITH(READUNCOMMITTED)          
                            WHERE PR.PREMISE_NO = VO.PREMISE_NO         
                             AND (FM_ELEC_SVC_WKDIST <> '' OR           
                                  FM_GAS_OPS_WKDIST  <> '' OR           
                                  FM_FLD_SVCS_WKDIST <> '' OR           
                                  FM_REV_PRT_WKDIST  <> '' OR           
                                  FM_DSM_ESVC_WKDIST <> '' ))           
                    AND EXISTS                                          
                          (SELECT 1                                     
                             FROM CSS_SO_ORDER_INST VI
                           WITH(READUNCOMMITTED)                  
                            WHERE VI.SERV_ORDER_NO = VO.SERV_ORDER_NO   
                              AND VI.WORK_TYPE_CD <> ''                 
                              AND VI.TASK_STATUS_CD = '')               
                    AND NOT EXISTS                                      
                          (SELECT 1                                     
                             FROM CSS_SO_DATA S1 WITH(READUNCOMMITTED)          
                            WHERE S1.SERV_ORDER_NO = VO.SERV_ORDER_NO   
                              AND S1.ORDER_TYPE_CD = 'DNPFB'            
                              AND S1.CODE_EDITED_YES_NO = 'Y')          
                                                                 
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_ORDER_CURSOR CURSOR WITH HOLD WITH RETURN FOR           
MFA-TR*          SELECT SERV_ORDER_NO                                           
MFA-TR*                ,PREMISE_NO                                              
MFA-TR*                ,SO_BUSINESS_UNIT                                        
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,LOCAL_OFFICE                                            
MFA-TR*            FROM CSS_SO_DATA VO                                          
MFA-TR*           WHERE ORDER_STATE_CD = 'A'                                    
MFA-TR*             AND DATE(WANTED_BY_DATETIME) <> :WS-CUTOFF-DATE             
MFA-TR*             AND DATE(ASSIGNED_DATETIME) >= CURRENT DATE                 
MFA-TR*             AND ORDER_TYPE_CD NOT IN ('FM007', 'FW022' ,'FW024')        
MFA-TR*             AND BACK_DATED_IND <> 'Y'                                   
MFA-TR*             AND EXISTS                                                  
MFA-TR*                   (SELECT 1                                             
MFA-TR*                      FROM CSS_PREMISE PR                                
MFA-TR*                     WHERE PR.PREMISE_NO = VO.PREMISE_NO                 
MFA-TR*                      AND (FM_ELEC_SVC_WKDIST <> '' OR                   
MFA-TR*                           FM_GAS_OPS_WKDIST  <> '' OR                   
MFA-TR*                           FM_FLD_SVCS_WKDIST <> '' OR                   
MFA-TR*                           FM_REV_PRT_WKDIST  <> '' OR                   
MFA-TR*                           FM_DSM_ESVC_WKDIST <> '' ))                   
MFA-TR*             AND EXISTS                                                  
MFA-TR*                   (SELECT 1                                             
MFA-TR*                      FROM CSS_SO_ORDER_INST VI                          
MFA-TR*                     WHERE VI.SERV_ORDER_NO = VO.SERV_ORDER_NO           
MFA-TR*                       AND VI.WORK_TYPE_CD <> ''                         
MFA-TR*                       AND VI.TASK_STATUS_CD = '')                       
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*                   (SELECT 1                                             
MFA-TR*                      FROM CSS_SO_DATA S1                                
MFA-TR*                     WHERE S1.SERV_ORDER_NO = VO.SERV_ORDER_NO           
MFA-TR*                       AND S1.ORDER_TYPE_CD = 'DNPFB'                    
MFA-TR*                       AND S1.CODE_EDITED_YES_NO = 'Y')                  
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR CURSOR
MSQ001          FOR CALL CSR04251 ( :VO-SERV-ORDER-NO
                  , 'S'
                  , 'SYSTEM'
                  , 'CLIC'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CRSR CURSOR
MSQ001          FOR CALL CSR04747 ( :VO-SERV-ORDER-NO
                  , '1'
                  , 'I'
                  , 'SYSTEM'
                  , :WS-WORK-DISTRICT OUTPUT
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE         TO WS-INPUT-DATE        
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE                   TO WS-CURRENT-DATE.     
           MOVE G6-PARM-DATA                    TO WS-NUM-CUT-OFF-DATA. 
                                                                        
           PERFORM 1000-PROCESS-ORDERS          THRU 1000-EXIT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  COPYBOOK MODULES NEEDED FOR DATE RETRIEVAL                             
      ************************************************************              
           COPY CPD00037.                                                       
           COPY CPD00040.                                                       
      *                                                                         
      ************************************************************              
      *  INCLUDE COPYBOOK CALLED FROM CPD00037                                  
      ************************************************************              
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      *  INCLUDE COPYBOOK CALLED FROM CPD00040                                  
      ************************************************************              
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
                                                                        
       1000-PROCESS-ORDERS.                                             
                                                                        
           EXEC SQL                                                     
               OPEN SO_ORDER_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           PERFORM UNTIL WS-FETCH-ROWS EQUAL NOT-FOUND                  
               PERFORM 1100-FETCH-ROWS        THRU 1100-EXIT            
               PERFORM 2000-INSERT-ROWS       THRU 2000-EXIT            
           END-PERFORM.                                                 
                                                                        
           EXEC SQL                                                     
              CLOSE SO_ORDER_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH SO_ORDER_CURSOR                                     
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-PREMISE-NO                                      
                   ,:VO-SO-BUSINESS-UNIT                                
A05020             ,:VO-COMPANY-NO                                      
A05020             ,:VO-LOCAL-OFFICE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-ACTIVE-RETURN-CODE    TO WS-FETCH-ROWS       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING SO CURSOR          *'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-INSERT-ROWS.                                                
           PERFORM 7000-GET-PREM-BUSUNIT          THRU 7000-EXIT.       
           IF VO-SO-BUSINESS-UNIT EQUAL SPACES OR                       
              VO-SO-BUSINESS-UNIT EQUAL LOW-VALUES                      
              PERFORM 4000-CALCULATE-BUSUNIT      THRU 4000-EXIT        
           ELSE                                                         
              MOVE VO-SO-BUSINESS-UNIT            TO WS-BUSINESS-UNIT   
           END-IF.                                                      
           EVALUATE WS-BUSINESS-UNIT                                    
               WHEN 'EOP'                                               
A05020             IF PR-FM-ELEC-SVC-WKDIST-TEXT NOT EQUAL SPACES AND   
A05020                PR-FM-ELEC-SVC-WKDIST-TEXT NOT EQUAL LOW-VALUES   
                      PERFORM 7200-UPDATE-SO-DATA    THRU 7200-EXIT     
                      PERFORM 7300-INSERT-TASK-QUEUE THRU 7300-EXIT     
                      PERFORM 7400-INSERT-CAD-QUEUE  THRU 7400-EXIT     
                   END-IF                                               
               WHEN 'GOP'                                               
A05020             IF PR-FM-GAS-OPS-WKDIST-TEXT NOT EQUAL SPACES AND    
A05020                PR-FM-GAS-OPS-WKDIST-TEXT NOT EQUAL LOW-VALUES    
                      PERFORM 7200-UPDATE-SO-DATA    THRU 7200-EXIT     
                      PERFORM 7300-INSERT-TASK-QUEUE THRU 7300-EXIT     
                      PERFORM 7400-INSERT-CAD-QUEUE  THRU 7400-EXIT     
                   END-IF                                               
               WHEN 'FSV'                                               
A05020             IF PR-FM-FLD-SVCS-WKDIST-TEXT NOT EQUAL SPACES AND   
A05020                PR-FM-FLD-SVCS-WKDIST-TEXT NOT EQUAL LOW-VALUES   
                      PERFORM 7200-UPDATE-SO-DATA    THRU 7200-EXIT     
                      PERFORM 7300-INSERT-TASK-QUEUE THRU 7300-EXIT     
                      PERFORM 7400-INSERT-CAD-QUEUE  THRU 7400-EXIT     
                   END-IF                                               
               WHEN 'DSM'                                               
A05020             IF PR-FM-DSM-ESVC-WKDIST-TEXT NOT EQUAL SPACES AND   
A05020                PR-FM-DSM-ESVC-WKDIST-TEXT NOT EQUAL LOW-VALUES   
                      PERFORM 7200-UPDATE-SO-DATA    THRU 7200-EXIT     
                      PERFORM 7300-INSERT-TASK-QUEUE THRU 7300-EXIT     
                      PERFORM 7400-INSERT-CAD-QUEUE  THRU 7400-EXIT     
                   END-IF                                               
               WHEN 'RVP'                                               
A05020             IF PR-FM-REV-PRT-WKDIST-TEXT NOT EQUAL SPACES AND    
A05020                PR-FM-REV-PRT-WKDIST-TEXT NOT EQUAL LOW-VALUES    
                      PERFORM 7200-UPDATE-SO-DATA    THRU 7200-EXIT     
                      PERFORM 7300-INSERT-TASK-QUEUE THRU 7300-EXIT     
                      PERFORM 7400-INSERT-CAD-QUEUE  THRU 7400-EXIT     
                   END-IF                                               
           END-EVALUATE.                                                
A05020     MOVE SPACES TO PR-FM-ELEC-SVC-WKDIST.                        
A05020     MOVE SPACES TO PR-FM-GAS-OPS-WKDIST.                         
A05020     MOVE SPACES TO PR-FM-FLD-SVCS-WKDIST.                        
A05020     MOVE SPACES TO PR-FM-REV-PRT-WKDIST.                         
A05020     MOVE SPACES TO PR-FM-DSM-ESVC-WKDIST.                        
       2000-EXIT.                                                       
                                                                        
       4000-CALCULATE-BUSUNIT.                                          
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04251 (:VO-SERV-ORDER-NO,                         
      *                      'S',                                       
      *                      'SYSTEM',                                  
      *                      'CLIC')                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              DISPLAY '************* PCSSO311 *******************'      
              DISPLAY '** 4000 :  RETURN CODE ERROR             '       
              DISPLAY '** 4000 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  NO RESULTSET RETURNED'                
              DISPLAY '************* PCSSO311 *******************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-RESLTSET)                                           
      *       WITH PROCEDURE CSR04251                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR CURSOR FOR RESULT SET             
      *       :LOC-RESLTSET                                             
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR INTO                                 
                 :WS-RETURN-CODE,                                       
                 :WS-OLD-WORK-AREA,                                     
                 :WS-OLD-WORK-AREA-TX,                                  
                 :WS-NEW-WORK-AREA,                                     
                 :WS-LOCAL-OFFICE,                                      
                 :WS-CODE-UTIL-TYPE,                                    
                 :WS-WORK-TYPE-CD,                                      
                 :WS-CRAWL-IND,                                         
                 :WS-METER-IND,                                         
                 :WS-ZIP-CODE,                                          
                 :WS-READ-ROUTE,                                        
                 :WS-POINT-ID,                                          
                 :WS-BUSINESS-UNIT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* PCSSO311 *******************'      
              DISPLAY '** 4000 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  FETCH FROM CSR04251 RESULTSET FAILED' 
              DISPLAY '************* PCSSO311********************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              CLOSE RESULT_SET_CSR                                      
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-GET-PREM-BUSUNIT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT FM_ELEC_SVC_WKDIST                                 
                    ,FM_GAS_OPS_WKDIST                                  
                    ,FM_FLD_SVCS_WKDIST                                 
                    ,FM_REV_PRT_WKDIST                                  
                    ,FM_DSM_ESVC_WKDIST                                 
                INTO :PR-FM-ELEC-SVC-WKDIST                             
                    ,:PR-FM-GAS-OPS-WKDIST                              
                    ,:PR-FM-FLD-SVCS-WKDIST                             
                    ,:PR-FM-REV-PRT-WKDIST                              
                    ,:PR-FM-DSM-ESVC-WKDIST                             
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :VO-PREMISE-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FM_ELEC_SVC_WKDIST                                         
MFA-TR*             ,FM_GAS_OPS_WKDIST                                          
MFA-TR*             ,FM_FLD_SVCS_WKDIST                                         
MFA-TR*             ,FM_REV_PRT_WKDIST                                          
MFA-TR*             ,FM_DSM_ESVC_WKDIST                                         
MFA-TR*         INTO :PR-FM-ELEC-SVC-WKDIST                                     
MFA-TR*             ,:PR-FM-GAS-OPS-WKDIST                                      
MFA-TR*             ,:PR-FM-FLD-SVCS-WKDIST                                     
MFA-TR*             ,:PR-FM-REV-PRT-WKDIST                                      
MFA-TR*             ,:PR-FM-DSM-ESVC-WKDIST                                     
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :VO-PREMISE-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING WORK DISTRICTS    *'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-UPDATE-SO-DATA.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
                 SET SO_BUSINESS_UNIT = :WS-BUSINESS-UNIT               
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING BUSINESS UNIT      *'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-INSERT-TASK-QUEUE.                                          
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04747 (:VO-SERV-ORDER-NO,                         
      *                      '1',                                       
      *                      'I',                                       
      *                      'SYSTEM',                                  
      *                      :WS-WORK-DISTRICT)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CRSR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CRSR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CRSR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              DISPLAY '************* PCSSO311 *******************'      
              DISPLAY '** 7300 :  RETURN CODE ERROR             '       
              DISPLAY '** 7300 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  NO RESULTSET RETURNED'                
              DISPLAY '************* PCSSO311 *******************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-RESLTSET)                                           
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT193*       ALLOCATE RESULT_SET_CRSR CURSOR FOR RESULT SET            
      *       :LOC-RESLTSET                                             
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT193        FETCH RESULT_SET_CRSR INTO                                
                 :WS-RETURN-CODE,                                       
                 :WS-WORK-DISTRICT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* PCSSO311 *******************'      
              DISPLAY '** 7300 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  FETCH FROM CSR04251 RESULTSET FAILED' 
              DISPLAY '************* PCSSO311********************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
ACT193        CLOSE RESULT_SET_CRSR                                     
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-INSERT-CAD-QUEUE.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SO_CAD_QUEUE                              
                    (SERV_ORDER_NO                                      
                    ,COMPANY_NO                                         
                    ,LOCAL_OFFICE                                       
                    ,WORK_GROUP_ID                                      
                    ,WORK_AREA_ID                                       
                    ,CREATED_TS                                         
                    ,CAD_TS                                             
                    ,CAD_PRIORITY                                       
                    ,CREATED_BY_USER_ID                                 
                    ,CAD_TRANS_TY_ACTN                                  
                    ,MESSAGE_ID                                         
                    ,MSG_ACK_NAK_FL)                                    
               VALUES                                                   
                    (:VO-SERV-ORDER-NO                                  
                    ,:VO-COMPANY-NO                                     
                    ,:VO-LOCAL-OFFICE                                   
                    ,' '                                                
                    ,' '                                                
                    ,CIS.CURRENT$TIMESTAMP()                                  
                    ,NULL                                               
                    ,'1'                                                
                    ,'SYSTEM'                                           
                    ,'C'                                                
                    ,'0000'                                             
                    ,'N')                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SO_CAD_QUEUE                                      
MFA-TR*             (SERV_ORDER_NO                                              
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,WORK_GROUP_ID                                              
MFA-TR*             ,WORK_AREA_ID                                               
MFA-TR*             ,CREATED_TS                                                 
MFA-TR*             ,CAD_TS                                                     
MFA-TR*             ,CAD_PRIORITY                                               
MFA-TR*             ,CREATED_BY_USER_ID                                         
MFA-TR*             ,CAD_TRANS_TY_ACTN                                          
MFA-TR*             ,MESSAGE_ID                                                 
MFA-TR*             ,MSG_ACK_NAK_FL)                                            
MFA-TR*        VALUES                                                           
MFA-TR*             (:VO-SERV-ORDER-NO                                          
MFA-TR*             ,:VO-COMPANY-NO                                             
MFA-TR*             ,:VO-LOCAL-OFFICE                                           
MFA-TR*             ,' '                                                        
MFA-TR*             ,' '                                                        
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,NULL                                                       
MFA-TR*             ,'1'                                                        
MFA-TR*             ,'SYSTEM'                                                   
MFA-TR*             ,'C'                                                        
MFA-TR*             ,'0000'                                                     
MFA-TR*             ,'N')                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CANCEL TRANSACTION *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO311 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
