       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSSO306.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM CORRECTS BILL ADDRESS SHARING ACROSS CUSTOMERS.   **         
      **   NEW BILLING ADDRESS IDS ARE CREATED AND ALL ACCOUNTS FOR  **         
      **   A CUSTOMER ARE UPDATED.                                   **         
      **   PROGRAM ALSO CONSOLIDATES ADDRESS IDS WITHIN A CUSTOMER   **         
      **   WHEN THE ADDRESS FIELDS ARE IDENTICAL.                    **         
      **   PROGRAM ALSO DELETES THE BILLING ADDRESS ID WHEN THE BILL **         
      **   AND SERVICE ADDRESS FIELDS ARE IDENTICAL. LIMITED TO      **         
      **   3000 ACCOUNTS PER RUN.                                    **         
      **   PROGRAM ALSO SYNCS UP ADDRESS IDS ON CSS_BILL_ADDR_XREF   **         
      **   WITH CSS_ACCOUNT.                                         **         
      **   PROGRAM INSERTS MISSING ROWS INTO CSS_BILL_ADDR_XREF      **         
      **   PROGRAM DELETES ROWS FROM CSS_BILL_ADDR_XREF WHEN ADDRESS **         
      **   ID ON CSS_ACCOUNT IS 0.                                   **         
      **   PROGRAM DELETES ROWS FROM CSS_ADDR_BILL_XREF AND ZEROES   **         
      **   ADDRESS_ID ON CSS_ACCOUNT IF ADDRESS DOES NOT EXIST ON    **         
      **   EITHER ADDRESS TABLE.                                     **         
      **   PROGRAM FORMATS PO BOXES CORRECTLY.                       **         
P00740**   FORMAT CSS_ADDR_FREEFORM.ADDR_CITY_STATE                  **         
A05317**   ADD 3RD PARTY AND CONTACT ADDRESSES TO P00740 CHANGES     **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
A03018*    02/11    FMB       ORIGINAL VERSION                       **         
A03018*                       PARM #2 SHOULD RUN IN REQUEST VERSION  **         
A03864*    11/12    FMB       DECREASE COMMIT COUNTS.                **         
P00740*    04/14    FMB       SYNC DZ CITY STATE WITH A4.            **         
A05317*    02/16    FMB       SYNC CV AND DW CITY STATE WITH A4.     **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO306'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  PROGRAM-NAME           PIC X(08) VALUE 'PCSSO306'.       
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC 9(09).                        
           05  WS-DISPLAY-ACCOUNT     PIC 9(13).                        
           05  WS-DISPLAY-CUSTOMER    PIC 9(10).                        
           05  WS-DISPLAY-PREMISE     PIC 9(10).                        
           05  WS-DISPLAY-ADDRESS     PIC 9(13).                        
           05  WS-DISPLAY-ADDRESS-2   PIC 9(13).                        
           05  RS-RETURN-CODE         PIC S9(4) COMP.                   
           05  RS-RETURN-CODE-DISP    PIC +Z(4).                        
           05  WS-COUNT-ROWS-1        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-2        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-3        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-4        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-5        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-6        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-7        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-8        PIC 9(9) VALUE 0.                 
           05  WS-COUNT-ROWS-9        PIC 9(9) VALUE 0.                 
P00740     05  WS-COUNT-ROWS-10       PIC 9(9) VALUE 0.                 
A05317     05  WS-COUNT-ROWS-11       PIC 9(9) VALUE 0.                 
A05317     05  WS-COUNT-ROWS-12       PIC 9(9) VALUE 0.                 
           05  WS-COMMIT-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-ROW-COUNT           PIC S9(9) COMP VALUE 0.           
           05  WS-CURRENT-TIMESTAMP   PIC X(26) VALUE SPACES.           
           05  WS-CURRENT-DATE        PIC X(10) VALUE SPACES.           
           05  WS-TRAN-APPL-NO        PIC S9(04) COMP VALUE 1.          
           05  WS-OLD-ADDRESS-ID      PIC 9(13) VALUE ZEROES.           
           05  WS-NEW-ADDRESS-ID      PIC 9(13) VALUE ZEROES.           
           05  WS-HOLD-CUSTOMER       PIC S9(10) COMP-3 VALUE 0.        
           05  WS-HOLD-ADDRESS        PIC S9(13) COMP-3 VALUE 0.        
           05  WS-HOLD-ADDRESS-FIELDS.                                  
               10  WS-HOLD-HOUSE      PIC X(15) VALUE SPACES.           
               10  WS-HOLD-PREF1      PIC X(03) VALUE SPACES.           
               10  WS-HOLD-PREF2      PIC X(02) VALUE SPACES.           
               10  WS-HOLD-STREET     PIC X(30) VALUE SPACES.           
               10  WS-HOLD-ST-SUFF    PIC X(04) VALUE SPACES.           
               10  WS-HOLD-AD-SUFF    PIC X(02) VALUE SPACES.           
               10  WS-HOLD-LOC1       PIC X(04) VALUE SPACES.           
               10  WS-HOLD-LOC2       PIC X(11) VALUE SPACES.           
               10  WS-HOLD-ZIP        PIC X(05) VALUE SPACES.           
               10  WS-HOLD-ZIPTOK     PIC X(01) VALUE SPACES.           
               10  WS-HOLD-PLUS4      PIC X(04) VALUE SPACES.           
           05  WS-ADDRESS-MATCH       PIC X(01) VALUE 'N'.              
           05  WS-ADDRESS-COUNT       PIC S9(4) COMP VALUE 0.           
           05  WS-MULTIPLE-ACCOUNTS   PIC X(01) VALUE 'N'.              
           05  WS-FIRST-CUSTOMER      PIC X(01) VALUE 'Y'.              
           05  WS-FIRST-ACCOUNT       PIC X(01) VALUE 'Y'.              
           05  WS-RUN-1               PIC X(01) VALUE 'N'.              
           05  WS-RUN-2               PIC X(01) VALUE 'N'.              
           05  WS-RUN-3               PIC X(01) VALUE 'N'.              
           05  WS-RUN-4               PIC X(01) VALUE 'N'.              
           05  WS-RUN-5               PIC X(01) VALUE 'N'.              
           05  WS-RUN-6               PIC X(01) VALUE 'N'.              
           05  WS-RUN-7               PIC X(01) VALUE 'N'.              
           05  WS-RUN-8               PIC X(01) VALUE 'N'.              
           05  WS-ADDRESS-LIMIT-U     PIC 9(13) VALUE 0.                
           05  WS-CUSTOMER-LIMIT-U    PIC 9(10) VALUE 0.                
           05  WS-ACCOUNT-LIMIT-U     PIC 9(13) VALUE 0.                
           05  WS-ADDRESS-LIMIT-L     PIC 9(13) VALUE 0.                
           05  WS-CUSTOMER-LIMIT-L    PIC 9(10) VALUE 0.                
           05  WS-ACCOUNT-LIMIT-L     PIC 9(13) VALUE 0.                
           05  WS-HI-ADDRESS-ID       PIC S9(13) COMP-3 VALUE 0.        
           05  WS-LO-ADDRESS-ID       PIC S9(13) COMP-3 VALUE 0.        
           05  WS-HI-CUSTOMER-NO      PIC S9(10) COMP-3 VALUE 0.        
           05  WS-LO-CUSTOMER-NO      PIC S9(10) COMP-3 VALUE 0.        
           05  WS-HI-ACCOUNT-NO       PIC S9(13) COMP-3 VALUE 0.        
           05  WS-LO-ACCOUNT-NO       PIC S9(13) COMP-3 VALUE 0.        
           05  WS-PROCESSING-SW       PIC X(01) VALUE ' '.              
           05  WS-UPDATE-SW           PIC X(01) VALUE ' '.              
           05  WS-COMMENTS-1          PIC X(60) VALUE                   
            'ADDRESS SHARED ACROSS CUSTOMERS.  NEW ADDRESS ID CREATED.'.
           05  WS-COMMENTS-2          PIC X(50) VALUE                   
            'CONSOLIDATED DUPLICATE ADDRESSES FOR CUSTOMER.'.           
           05  WS-COMMENTS-3          PIC X(54) VALUE                   
             'PREMISE / BILL ADDRESS MATCH.  BILL ADDRESS DELETED.'.    
           05  WS-COMMENTS-10         PIC X(38) VALUE                   
             'CITY STATE STANDARDIZATION.'.                             
           05  WS-POBOX-FMT           PIC X(07) VALUE 'PO BOX '.        
           05  WS-POBOX-FIELDS.                                         
               10 WS-BOX-NUMBER       PIC X(47) VALUE SPACES.           
               10 WS-OLD-ADDR-STREET  PIC X(55) VALUE SPACES.           
               10 WS-POBOX-UPDATE     PIC X(01) VALUE SPACES.           
           05  WS-CITY-STATE          PIC X(30) VALUE SPACES.           
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00071.                                                           
       COPY CWS00303.                                                           
            EXEC SQL                                                            
                INCLUDE CWS0090A                                                
            END-EXEC.                                                           
                                                                        
            EXEC SQL                                                            
                INCLUDE SQLCA                                                   
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBMODEL                                                 
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBPREM                                                  
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBACCT                                                  
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBADRFMT                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBADRFRE                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBMNHIST                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBMNHDT                                                 
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBADDRID                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBMSTSUB                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBLNDLRD                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBBLADRX                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBCUST                                                  
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE TBJBPARM                                                
            END-EXEC.                                                           
                                                                        
P00740      EXEC SQL                                                            
P00740          INCLUDE TBZIPCD                                                 
P00740      END-EXEC.                                                           
                                                                        
A05317      EXEC SQL                                                            
A05317          INCLUDE TBTHDPTY                                                
A05317      END-EXEC.                                                           
                                                                        
A05317      EXEC SQL                                                            
A05317          INCLUDE TBCNTACT                                                
A05317      END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE ACCT-CURSOR CURSOR WITH HOLD FOR                
                    SELECT DISTINCT AT.ADDRESS_ID                       
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                 
                     WHERE AT.ADDRESS_ID > 0                            
                       AND AT.ADDRESS_FORMAT = 'A'                      
      *                AND AT.ADDRESS_ID <= :WS-HI-ADDRESS-ID                   
      *                AND AT.ADDRESS_ID >= :WS-LO-ADDRESS-ID                   
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE ACCT-CURSOR CURSOR WITH HOLD FOR                        
MFA-TR*             SELECT DISTINCT AT.ADDRESS_ID                               
MFA-TR*               FROM CSS_ACCOUNT AT                                       
MFA-TR*              WHERE AT.ADDRESS_ID > 0                                    
MFA-TR*                AND AT.ADDRESS_FORMAT = 'A'                              
MFA-TR*                AND AT.ADDRESS_ID <= :WS-HI-ADDRESS-ID                   
MFA-TR*                AND AT.ADDRESS_ID >= :WS-LO-ADDRESS-ID                   
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE ADDR-CUST-CURSOR CURSOR FOR                     
                    SELECT AT.ACCOUNT_NO,                               
                           AT.CUSTOMER_NO,                              
                           AT.ADDRESS_ID                                
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                 
                     WHERE ADDRESS_ID = :AT-ADDRESS-ID                  
                  ORDER BY AT.CUSTOMER_NO                               
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE ADDR-CUST-CURSOR CURSOR FOR                             
MFA-TR*             SELECT AT.ACCOUNT_NO,                                       
MFA-TR*                    AT.CUSTOMER_NO,                                      
MFA-TR*                    AT.ADDRESS_ID                                        
MFA-TR*               FROM CSS_ACCOUNT AT                                       
MFA-TR*              WHERE ADDRESS_ID = :AT-ADDRESS-ID                          
MFA-TR*           ORDER BY AT.CUSTOMER_NO                                       
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE CUST-ADDR-CURSOR CURSOR WITH HOLD FOR           
                    SELECT DISTINCT CUSTOMER_NO                         
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                 
                     WHERE ADDRESS_ID > 0                               
                       AND ADDRESS_FORMAT = 'A'                         
                       AND EXISTS                                       
                          (SELECT '1'                                   
                             FROM CSS_ACCOUNT WITH(READUNCOMMITTED)             
                            WHERE CUSTOMER_NO = AT.CUSTOMER_NO          
                              AND ADDRESS_FORMAT = 'A'                  
                              AND ADDRESS_ID > 0                        
                              AND ADDRESS_ID <> AT.ADDRESS_ID)          
                       AND AT.CUSTOMER_NO <= :WS-HI-CUSTOMER-NO         
                       AND AT.CUSTOMER_NO >= :WS-LO-CUSTOMER-NO         
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE CUST-ADDR-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT DISTINCT CUSTOMER_NO                                 
MFA-TR*               FROM CSS_ACCOUNT AT                                       
MFA-TR*              WHERE ADDRESS_ID > 0                                       
MFA-TR*                AND ADDRESS_FORMAT = 'A'                                 
MFA-TR*                AND EXISTS                                               
MFA-TR*                   (SELECT '1'                                           
MFA-TR*                      FROM CSS_ACCOUNT                                   
MFA-TR*                     WHERE CUSTOMER_NO = AT.CUSTOMER_NO                  
MFA-TR*                       AND ADDRESS_FORMAT = 'A'                          
MFA-TR*                       AND ADDRESS_ID > 0                                
MFA-TR*                       AND ADDRESS_ID = AT.ADDRESS_ID)                  
MFA-TR*                AND AT.CUSTOMER_NO <= :WS-HI-CUSTOMER-NO                 
MFA-TR*                AND AT.CUSTOMER_NO >= :WS-LO-CUSTOMER-NO                 
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE SAME-ADDR-CURSOR CURSOR WITH HOLD FOR           
                    SELECT AT.ADDRESS_ID,                               
                           COUNT(*),                                    
                           HOUSE_NO,                                    
                           ADDR_PREFIX_1,                               
                           ADDR_PREFIX_2,                               
                           STREET_NAME,                                 
                           STREET_SUFFIX,                               
                           ADDR_SUFFIX,                                 
                           STREET_LOCATION_1,                           
                           STREET_LOCATION_2,                           
                           ZIP_CODE,                                    
                           ZIP_CODE_PLUS_FOUR,                          
                           ZIP_CODE_TOKEN                               
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                
                           CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)          
                     WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                
                       AND AT.ADDRESS_ID > 0                            
                       AND AT.ADDRESS_FORMAT = 'A'                      
                       AND AT.ADDRESS_ID = DY.ADDRESS_ID                
                       GROUP BY                                         
                           AT.ADDRESS_ID,                               
                           HOUSE_NO,                                    
                           ADDR_PREFIX_1,                               
                           ADDR_PREFIX_2,                               
                           STREET_NAME,                                 
                           STREET_SUFFIX,                               
                           ADDR_SUFFIX,                                 
                           STREET_LOCATION_1,                           
                           STREET_LOCATION_2,                           
                           ZIP_CODE,                                    
                           ZIP_CODE_PLUS_FOUR,                          
                           ZIP_CODE_TOKEN                               
                       ORDER BY                                         
                           HOUSE_NO,                                    
                           ADDR_PREFIX_1,                               
                           ADDR_PREFIX_2,                               
                           STREET_NAME,                                 
                           STREET_SUFFIX,                               
                           ADDR_SUFFIX,                                 
                           STREET_LOCATION_1,                           
                           STREET_LOCATION_2,                           
                           ZIP_CODE,                                    
                           ZIP_CODE_PLUS_FOUR,                          
                           ZIP_CODE_TOKEN,                              
                           2 DESC                                       
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE SAME-ADDR-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT AT.ADDRESS_ID,                                       
MFA-TR*                    COUNT(*),                                            
MFA-TR*                    HOUSE_NO,                                            
MFA-TR*                    ADDR_PREFIX_1,                                       
MFA-TR*                    ADDR_PREFIX_2,                                       
MFA-TR*                    STREET_NAME,                                         
MFA-TR*                    STREET_SUFFIX,                                       
MFA-TR*                    ADDR_SUFFIX,                                         
MFA-TR*                    STREET_LOCATION_1,                                   
MFA-TR*                    STREET_LOCATION_2,                                   
MFA-TR*                    ZIP_CODE,                                            
MFA-TR*                    ZIP_CODE_PLUS_FOUR,                                  
MFA-TR*                    ZIP_CODE_TOKEN                                       
MFA-TR*               FROM CSS_ACCOUNT AT,                                      
MFA-TR*                    CSS_ADDR_FORMATTED DY                                
MFA-TR*              WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                        
MFA-TR*                AND AT.ADDRESS_ID > 0                                    
MFA-TR*                AND AT.ADDRESS_FORMAT = 'A'                              
MFA-TR*                AND AT.ADDRESS_ID = DY.ADDRESS_ID                        
MFA-TR*                GROUP BY                                                 
MFA-TR*                    AT.ADDRESS_ID,                                       
MFA-TR*                    HOUSE_NO,                                            
MFA-TR*                    ADDR_PREFIX_1,                                       
MFA-TR*                    ADDR_PREFIX_2,                                       
MFA-TR*                    STREET_NAME,                                         
MFA-TR*                    STREET_SUFFIX,                                       
MFA-TR*                    ADDR_SUFFIX,                                         
MFA-TR*                    STREET_LOCATION_1,                                   
MFA-TR*                    STREET_LOCATION_2,                                   
MFA-TR*                    ZIP_CODE,                                            
MFA-TR*                    ZIP_CODE_PLUS_FOUR,                                  
MFA-TR*                    ZIP_CODE_TOKEN                                       
MFA-TR*                ORDER BY                                                 
MFA-TR*                    HOUSE_NO,                                            
MFA-TR*                    ADDR_PREFIX_1,                                       
MFA-TR*                    ADDR_PREFIX_2,                                       
MFA-TR*                    STREET_NAME,                                         
MFA-TR*                    STREET_SUFFIX,                                       
MFA-TR*                    ADDR_SUFFIX,                                         
MFA-TR*                    STREET_LOCATION_1,                                   
MFA-TR*                    STREET_LOCATION_2,                                   
MFA-TR*                    ZIP_CODE,                                            
MFA-TR*                    ZIP_CODE_PLUS_FOUR,                                  
MFA-TR*                    ZIP_CODE_TOKEN,                                      
MFA-TR*                    2 DESC                                               
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE ACCTS-4-ADDR CURSOR WITH HOLD FOR               
                    SELECT ACCOUNT_NO,                                  
                           PREMISE_NO                                   
                      FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                    
                     WHERE ADDRESS_ID = :AT-ADDRESS-ID                  
                       AND ADDRESS_FORMAT = 'A'                         
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE ACCTS-4-ADDR CURSOR WITH HOLD FOR                       
MFA-TR*             SELECT ACCOUNT_NO,                                          
MFA-TR*                    PREMISE_NO                                           
MFA-TR*               FROM CSS_ACCOUNT                                          
MFA-TR*              WHERE ADDRESS_ID = :AT-ADDRESS-ID                          
MFA-TR*                AND ADDRESS_FORMAT = 'A'                                 
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE ACCT-ADDR-CURSOR CURSOR WITH HOLD FOR           
                    SELECT AT.ACCOUNT_NO,                               
                           AT.PREMISE_NO,                               
                           AT.ADDRESS_ID,                               
                           PR.ADDRESS_ID ,                              
                           AT.CUSTOMER_NO                               
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                
                           CSS_PREMISE PR WITH(READUNCOMMITTED),                
                           CSS_ADDR_FORMATTED DY1 WITH(READUNCOMMITTED),        
                           CSS_ADDR_FORMATTED DY2 WITH(READUNCOMMITTED)         
                     WHERE AT.ADDRESS_ID > 0                            
                       AND AT.ADDRESS_FORMAT = 'A'                      
      *                AND AT.ACCOUNT_NO <= :WS-HI-ACCOUNT-NO                   
      *                AND AT.ACCOUNT_NO >= :WS-LO-ACCOUNT-NO                   
                       AND AT.PREMISE_NO = PR.PREMISE_NO                
                       AND AT.ADDRESS_ID = DY1.ADDRESS_ID               
                       AND PR.ADDRESS_ID = DY2.ADDRESS_ID               
                       AND DY1.HOUSE_NO = DY2.HOUSE_NO                  
                       AND DY1.ADDR_PREFIX_1 = DY2.ADDR_PREFIX_1        
                       AND DY1.ADDR_PREFIX_2 = DY2.ADDR_PREFIX_2        
                       AND DY1.STREET_NAME = DY2.STREET_NAME            
                       AND DY1.STREET_SUFFIX = DY2.STREET_SUFFIX        
                       AND DY1.ADDR_SUFFIX = DY2.ADDR_SUFFIX            
                       AND DY1.STREET_LOCATION_1 =                      
                           DY2.STREET_LOCATION_1                        
                       AND DY1.STREET_LOCATION_2 =                      
                           DY2.STREET_LOCATION_2                        
                       AND DY1.ZIP_CODE = DY2.ZIP_CODE                  
                       AND DY1.ZIP_CODE_PLUS_FOUR =                     
                           DY2.ZIP_CODE_PLUS_FOUR                       
                       AND DY1.ZIP_CODE_TOKEN = DY2.ZIP_CODE_TOKEN      
                       AND DY1.ADDRESS_OVERFLOW <= ' '                  
                       AND NOT EXISTS                                   
                         (SELECT '1'                                    
                            FROM CSS_LANDLORD WITH(READUNCOMMITTED)             
                           WHERE ADDRESS_ID = AT.ADDRESS_ID             
                             AND CUSTOMER_NO = AT.CUSTOMER_NO           
                             AND ADDRESS_FORMAT = 'A')
            OPTION(FAST 1)
            FOR READ ONLY
                                                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE ACCT-ADDR-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT AT.ACCOUNT_NO,                                       
MFA-TR*                    AT.PREMISE_NO,                                       
MFA-TR*                    AT.ADDRESS_ID,                                       
MFA-TR*                    PR.ADDRESS_ID ,                                      
MFA-TR*                    AT.CUSTOMER_NO                                       
MFA-TR*               FROM CSS_ACCOUNT AT,                                      
MFA-TR*                    CSS_PREMISE PR,                                      
MFA-TR*                    CSS_ADDR_FORMATTED DY1,                              
MFA-TR*                    CSS_ADDR_FORMATTED DY2                               
MFA-TR*              WHERE AT.ADDRESS_ID > 0                                    
MFA-TR*                AND AT.ADDRESS_FORMAT = 'A'                              
MFA-TR*                AND AT.ACCOUNT_NO <= :WS-HI-ACCOUNT-NO                   
MFA-TR*                AND AT.ACCOUNT_NO >= :WS-LO-ACCOUNT-NO                   
MFA-TR*                AND AT.PREMISE_NO = PR.PREMISE_NO                        
MFA-TR*                AND AT.ADDRESS_ID = DY1.ADDRESS_ID                       
MFA-TR*                AND PR.ADDRESS_ID = DY2.ADDRESS_ID                       
MFA-TR*                AND DY1.HOUSE_NO = DY2.HOUSE_NO                          
MFA-TR*                AND DY1.ADDR_PREFIX_1 = DY2.ADDR_PREFIX_1                
MFA-TR*                AND DY1.ADDR_PREFIX_2 = DY2.ADDR_PREFIX_2                
MFA-TR*                AND DY1.STREET_NAME = DY2.STREET_NAME                    
MFA-TR*                AND DY1.STREET_SUFFIX = DY2.STREET_SUFFIX                
MFA-TR*                AND DY1.ADDR_SUFFIX = DY2.ADDR_SUFFIX                    
MFA-TR*                AND DY1.STREET_LOCATION_1 =                              
MFA-TR*                    DY2.STREET_LOCATION_1                                
MFA-TR*                AND DY1.STREET_LOCATION_2 =                              
MFA-TR*                    DY2.STREET_LOCATION_2                                
MFA-TR*                AND DY1.ZIP_CODE = DY2.ZIP_CODE                          
MFA-TR*                AND DY1.ZIP_CODE_PLUS_FOUR =                             
MFA-TR*                    DY2.ZIP_CODE_PLUS_FOUR                               
MFA-TR*                AND DY1.ZIP_CODE_TOKEN = DY2.ZIP_CODE_TOKEN              
MFA-TR*                AND DY1.ADDRESS_OVERFLOW <= ' '                          
MFA-TR*                AND NOT EXISTS                                           
MFA-TR*                  (SELECT '1'                                            
MFA-TR*                     FROM CSS_LANDLORD                                   
MFA-TR*                    WHERE ADDRESS_ID = AT.ADDRESS_ID                     
MFA-TR*                      AND CUSTOMER_NO = AT.CUSTOMER_NO                   
MFA-TR*                      AND ADDRESS_FORMAT = 'A')                          
MFA-TR*             OPTIMIZE FOR 1 ROW                                          
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE BILL-XREF-CURSOR CURSOR WITH HOLD FOR           
                    SELECT AT.ACCOUNT_NO,                               
                           AT.ADDRESS_ID,                               
                           AQ.ADDRESS_ID,                               
                           AQ.NAME_ID,                                  
                           AQ.COMPANY_NO                                
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                
                           CSS_BILL_ADDR_XREF AQ WITH(READUNCOMMITTED)          
                     WHERE AT.ADDRESS_ID > 0                            
                       AND AT.ACCOUNT_NO = AQ.ACCOUNT_NO                
                       AND AT.ADDRESS_ID <> AQ.ADDRESS_ID               
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE BILL-XREF-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT AT.ACCOUNT_NO,                                       
MFA-TR*                    AT.ADDRESS_ID,                                       
MFA-TR*                    AQ.ADDRESS_ID,                                       
MFA-TR*                    AQ.NAME_ID,                                          
MFA-TR*                    AQ.COMPANY_NO                                        
MFA-TR*               FROM CSS_ACCOUNT AT,                                      
MFA-TR*                    CSS_BILL_ADDR_XREF AQ                                
MFA-TR*              WHERE AT.ADDRESS_ID > 0                                    
MFA-TR*                AND AT.ACCOUNT_NO = AQ.ACCOUNT_NO                        
MFA-TR*                AND AT.ADDRESS_ID = AQ.ADDRESS_ID                       
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE MISS-XREF-CURSOR CURSOR WITH HOLD FOR           
                    SELECT AT.ACCOUNT_NO,                               
                           AT.ADDRESS_ID,                               
                           CU.NAME_ID,                                  
                           AT.COMPANY_NO                                
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                
                           CSS_CUSTOMER CU WITH(READUNCOMMITTED)                
                     WHERE AT.ADDRESS_ID > 0                            
                       AND AT.ADDRESS_FORMAT = 'A'                      
                       AND AT.CUSTOMER_NO = CU.CUSTOMER_NO              
                       AND NOT EXISTS                                   
                         (SELECT '1'                                    
                            FROM CSS_BILL_ADDR_XREF
                           WITH(READUNCOMMITTED)                     
                           WHERE ACCOUNT_NO = AT.ACCOUNT_NO)            
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE MISS-XREF-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT AT.ACCOUNT_NO,                                       
MFA-TR*                    AT.ADDRESS_ID,                                       
MFA-TR*                    CU.NAME_ID,                                          
MFA-TR*                    AT.COMPANY_NO                                        
MFA-TR*               FROM CSS_ACCOUNT AT,                                      
MFA-TR*                    CSS_CUSTOMER CU                                      
MFA-TR*              WHERE AT.ADDRESS_ID > 0                                    
MFA-TR*                AND AT.ADDRESS_FORMAT = 'A'                              
MFA-TR*                AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                      
MFA-TR*                AND NOT EXISTS                                           
MFA-TR*                  (SELECT '1'                                            
MFA-TR*                     FROM CSS_BILL_ADDR_XREF                             
MFA-TR*                    WHERE ACCOUNT_NO = AT.ACCOUNT_NO)                    
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE MISS-ACCT-CURSOR CURSOR WITH HOLD FOR           
                    SELECT AT.ACCOUNT_NO                                
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                 
                     WHERE AT.ADDRESS_ID = 0                            
                       AND EXISTS                                       
                         (SELECT '1'                                    
                            FROM CSS_BILL_ADDR_XREF
                           WITH(READUNCOMMITTED)                     
                           WHERE ACCOUNT_NO = AT.ACCOUNT_NO)            
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE MISS-ACCT-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT AT.ACCOUNT_NO                                        
MFA-TR*               FROM CSS_ACCOUNT AT                                       
MFA-TR*              WHERE AT.ADDRESS_ID = 0                                    
MFA-TR*                AND EXISTS                                               
MFA-TR*                  (SELECT '1'                                            
MFA-TR*                     FROM CSS_BILL_ADDR_XREF                             
MFA-TR*                    WHERE ACCOUNT_NO = AT.ACCOUNT_NO)                    
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE MISS-ADDR-CURSOR CURSOR WITH HOLD FOR           
                    SELECT AT.ACCOUNT_NO, AT.ADDRESS_ID                 
                      FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                
                           CSS_BILL_ADDR_XREF AQ WITH(READUNCOMMITTED)          
                     WHERE AT.ACCOUNT_NO = AQ.ACCOUNT_NO                
                       AND AQ.ADDRESS_ID > 0                            
                       AND AQ.ADDRESS_ID = AT.ADDRESS_ID                
                       AND NOT EXISTS                                   
                         (SELECT '1'                                    
                            FROM CSS_ADDR_FORMATTED
                           WITH(READUNCOMMITTED)                     
                           WHERE ADDRESS_ID = AQ.ADDRESS_ID)            
                       AND NOT EXISTS                                   
                         (SELECT '2'                                    
                            FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)        
                           WHERE ADDRESS_ID = AQ.ADDRESS_ID)            
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE MISS-ADDR-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT AT.ACCOUNT_NO, AT.ADDRESS_ID                         
MFA-TR*               FROM CSS_ACCOUNT AT,                                      
MFA-TR*                    CSS_BILL_ADDR_XREF AQ                                
MFA-TR*              WHERE AT.ACCOUNT_NO = AQ.ACCOUNT_NO                        
MFA-TR*                AND AQ.ADDRESS_ID > 0                                    
MFA-TR*                AND AQ.ADDRESS_ID = AT.ADDRESS_ID                        
MFA-TR*                AND NOT EXISTS                                           
MFA-TR*                  (SELECT '1'                                            
MFA-TR*                     FROM CSS_ADDR_FORMATTED                             
MFA-TR*                    WHERE ADDRESS_ID = AQ.ADDRESS_ID)                    
MFA-TR*                AND NOT EXISTS                                           
MFA-TR*                  (SELECT '2'                                            
MFA-TR*                     FROM CSS_ADDR_FREEFORM                              
MFA-TR*                    WHERE ADDRESS_ID = AQ.ADDRESS_ID)                    
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE FF-POBOX-CURSOR CURSOR WITH HOLD FOR            
                    SELECT ADDRESS_ID, ADDR_STREET                      
                      FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)              
                     WHERE ADDR_STREET LIKE '%BOX%'                     
                       AND ADDR_STREET LIKE 'P%'                        
                       AND NOT ADDR_STREET LIKE 'PO BOX %'              
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE FF-POBOX-CURSOR CURSOR WITH HOLD FOR                    
MFA-TR*             SELECT ADDRESS_ID, ADDR_STREET                              
MFA-TR*               FROM CSS_ADDR_FREEFORM                                    
MFA-TR*              WHERE ADDR_STREET LIKE '%BOX%'                             
MFA-TR*                AND ADDR_STREET LIKE 'P%'                                
MFA-TR*                AND NOT ADDR_STREET LIKE 'PO BOX %'                      
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
            EXEC SQL                                                    
                DECLARE FMT-POBOX-CURSOR CURSOR WITH HOLD FOR           
                    SELECT ADDRESS_ID, STREET_NAME                      
                      FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)             
                     WHERE STREET_NAME LIKE '%BOX%'                     
                       AND STREET_NAME LIKE 'P%'                        
                       AND NOT STREET_NAME LIKE 'PO BOX %'              
                       AND HOUSE_NO = ' '                               
                    FOR READ ONLY                                      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE FMT-POBOX-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT ADDRESS_ID, STREET_NAME                              
MFA-TR*               FROM CSS_ADDR_FORMATTED                                   
MFA-TR*              WHERE STREET_NAME LIKE '%BOX%'                             
MFA-TR*                AND STREET_NAME LIKE 'P%'                                
MFA-TR*                AND NOT STREET_NAME LIKE 'PO BOX %'                      
MFA-TR*                AND HOUSE_NO = ' '                                       
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
P00740*     LAST FIELD IN COUNTRY CHECK IS HEX LOW VALUES                       
P00740                                                                  
P00740      EXEC SQL                                                    
P00740          DECLARE FF-CITYST-CURSOR CURSOR WITH HOLD FOR           
P00740              SELECT DZ.ADDRESS_ID,                               
P00740                     ADDR_CITY_STATE,                             
P00740                     RTRIM(TOWN) + ' ' + STATE,                 
P00740                     ACCOUNT_NO                                   
P00740                FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED),          
P00740                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),               
P00740                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                 
P00740               WHERE ADDR_COUNTRY IN (' ', 'UNITED STATES', 'USA')
P00740                 AND ADDR_ZIP_CODE > ' '                          
P00740                 AND CIS.SUBSTR3(ADDR_ZIP_CODE,1,5) = A4.ZIP_CODE      
P00740                 AND A4.ZIP_CODE_TOKEN = '1'                      
P00740                 AND RTRIM(ADDR_CITY_STATE) <>                    
P00740                     RTRIM(TOWN) + ' ' + STATE                  
P00740                 AND DZ.ADDRESS_ID = AT.ADDRESS_ID                
P00740                 AND ADDRESS_FORMAT = 'B'                         
P00740                 AND CODE_ACCT_STAT IN ('A', 'P')                 
P00740              FOR READ ONLY                                      
P00740                                                           
P00740      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE FF-CITYST-CURSOR CURSOR WITH HOLD FOR                   
MFA-TR*             SELECT DZ.ADDRESS_ID,                                       
MFA-TR*                    ADDR_CITY_STATE,                                     
MFA-TR*                    RTRIM(TOWN) || ' ' || STATE,                         
MFA-TR*                    ACCOUNT_NO                                           
MFA-TR*               FROM CSS_ADDR_FREEFORM DZ,                                
MFA-TR*                    CSS_ZIP_CODE A4,                                     
MFA-TR*                    CSS_ACCOUNT AT                                       
MFA-TR*              WHERE ADDR_COUNTRY IN (' ', 'UNITED STATES', 'USA')        
MFA-TR*                AND ADDR_ZIP_CODE > ' '                                  
MFA-TR*                AND SUBSTR(ADDR_ZIP_CODE,1,5) = A4.ZIP_CODE              
MFA-TR*                AND A4.ZIP_CODE_TOKEN = '1'                              
MFA-TR*                AND RTRIM(ADDR_CITY_STATE) <>                            
MFA-TR*                    RTRIM(TOWN) || ' ' || STATE                          
MFA-TR*                AND DZ.ADDRESS_ID = AT.ADDRESS_ID                        
MFA-TR*                AND ADDRESS_FORMAT = 'B'                                 
MFA-TR*                AND CODE_ACCT_STAT IN ('A', 'P')                         
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
A05317      EXEC SQL                                                    
A05317          DECLARE FF-CITYST-CURSOR-C CURSOR WITH HOLD FOR         
A05317              SELECT DZ.ADDRESS_ID,                               
A05317                     ADDR_CITY_STATE,                             
A05317                     RTRIM(TOWN) + ' ' + STATE,                 
A05317                     CONTACT_ID                                   
A05317                FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED),          
A05317                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),               
A05317                     CSS_CONTACT CV WITH(READUNCOMMITTED)                 
P00740               WHERE (ADDR_COUNTRY IN ('UNITED STATES', 'USA')    
P00740                  OR  ADDR_COUNTRY <= ' ')                        
A05317                 AND ADDR_ZIP_CODE > ' '                          
A05317                 AND CIS.SUBSTR3(ADDR_ZIP_CODE,1,5) = A4.ZIP_CODE      
A05317                 AND A4.ZIP_CODE_TOKEN = '1'                      
A05317                 AND RTRIM(ADDR_CITY_STATE) <>                    
A05317                     RTRIM(TOWN) + ' ' + STATE                  
A05317                 AND DZ.ADDRESS_ID = CV.ADDRESS_ID                
A05317                 AND ADDRESS_FORMAT = 'B'                         
A05317              FOR READ ONLY                                      
A05317                                                           
A05317      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE FF-CITYST-CURSOR-C CURSOR WITH HOLD FOR                 
MFA-TR*             SELECT DZ.ADDRESS_ID,                                       
MFA-TR*                    ADDR_CITY_STATE,                                     
MFA-TR*                    RTRIM(TOWN) || ' ' || STATE,                         
MFA-TR*                    CONTACT_ID                                           
MFA-TR*               FROM CSS_ADDR_FREEFORM DZ,                                
MFA-TR*                    CSS_ZIP_CODE A4,                                     
MFA-TR*                    CSS_CONTACT CV                                       
MFA-TR*              WHERE (ADDR_COUNTRY IN ('UNITED STATES', 'USA')            
MFA-TR*                 OR  ADDR_COUNTRY <= ' ')                                
MFA-TR*                AND ADDR_ZIP_CODE > ' '                                  
MFA-TR*                AND SUBSTR(ADDR_ZIP_CODE,1,5) = A4.ZIP_CODE              
MFA-TR*                AND A4.ZIP_CODE_TOKEN = '1'                              
MFA-TR*                AND RTRIM(ADDR_CITY_STATE) <>                            
MFA-TR*                    RTRIM(TOWN) || ' ' || STATE                          
MFA-TR*                AND DZ.ADDRESS_ID = CV.ADDRESS_ID                        
MFA-TR*                AND ADDRESS_FORMAT = 'B'                                 
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
A05317      EXEC SQL                                                    
A05317          DECLARE FF-CITYST-CURSOR-T CURSOR WITH HOLD FOR         
A05317              SELECT DZ.ADDRESS_ID,                               
A05317                     ADDR_CITY_STATE,                             
A05317                     RTRIM(TOWN) + ' ' + STATE,                 
A05317                     THD_PRTY_ID                                  
A05317                FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED),          
A05317                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),               
A05317                     CSS_THD_PRTY ZW WITH(READUNCOMMITTED)                
P00740               WHERE ADDR_COUNTRY IN (' ', 'UNITED STATES', 'USA')
A05317                 AND ADDR_ZIP_CODE > ' '                          
A05317                 AND CIS.SUBSTR3(ADDR_ZIP_CODE,1,5) = A4.ZIP_CODE      
A05317                 AND A4.ZIP_CODE_TOKEN = '1'                      
A05317                 AND RTRIM(ADDR_CITY_STATE) <>                    
A05317                     RTRIM(TOWN) + ' ' + STATE                  
A05317                 AND DZ.ADDRESS_ID = ZW.ADDRESS_ID                
A05317                 AND ADDRESS_FORMAT = 'B'                         
A05317              FOR READ ONLY                                      
A05317                                                           
A05317      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE FF-CITYST-CURSOR-T CURSOR WITH HOLD FOR                 
MFA-TR*             SELECT DZ.ADDRESS_ID,                                       
MFA-TR*                    ADDR_CITY_STATE,                                     
MFA-TR*                    RTRIM(TOWN) || ' ' || STATE,                         
MFA-TR*                    THD_PRTY_ID                                          
MFA-TR*               FROM CSS_ADDR_FREEFORM DZ,                                
MFA-TR*                    CSS_ZIP_CODE A4,                                     
MFA-TR*                    CSS_THD_PRTY ZW                                      
MFA-TR*              WHERE ADDR_COUNTRY IN (' ', 'UNITED STATES', 'USA')        
MFA-TR*                AND ADDR_ZIP_CODE > ' '                                  
MFA-TR*                AND SUBSTR(ADDR_ZIP_CODE,1,5) = A4.ZIP_CODE              
MFA-TR*                AND A4.ZIP_CODE_TOKEN = '1'                              
MFA-TR*                AND RTRIM(ADDR_CITY_STATE) <>                            
MFA-TR*                    RTRIM(TOWN) || ' ' || STATE                          
MFA-TR*                AND DZ.ADDRESS_ID = ZW.ADDRESS_ID                        
MFA-TR*                AND ADDRESS_FORMAT = 'B'                                 
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                         
               INTO  :WS-CURRENT-DATE                                   
               FROM   CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT DATE                                              
MFA-TR*        INTO  :WS-CURRENT-DATE                                           
MFA-TR*        FROM   CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7000-SELECT-JOB-PARM THRU 7000-EXIT.                 
                                                                        
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           DISPLAY 'BILL SHARE ACROSS CUSTOMER: ' WS-COUNT-ROWS-1.      
           DISPLAY 'CONSOLIDATION WITHIN CUSTOMER: ' WS-COUNT-ROWS-2.   
           DISPLAY 'PREMISE / BILLING IDENTICAL: ' WS-COUNT-ROWS-3.     
           DISPLAY 'BILL ADDR XREF MISMATCH: ' WS-COUNT-ROWS-4.         
           DISPLAY 'MISSING FROM XREF: ' WS-COUNT-ROWS-5.               
           DISPLAY 'DELETED FROM XREF: ' WS-COUNT-ROWS-6.               
           DISPLAY 'ZEROED OUT ON ACCT: ' WS-COUNT-ROWS-7.              
           DISPLAY 'FF PO BOXES: ' WS-COUNT-ROWS-8.                     
           DISPLAY 'FMT PO BOXES: ' WS-COUNT-ROWS-9.                    
P00740     DISPLAY 'CITY/STATE: ' WS-COUNT-ROWS-10.                     
A05317     DISPLAY 'CITY/STATE CONTACT: ' WS-COUNT-ROWS-11.             
A05317     DISPLAY 'CITY/STATE 3RD PARTY: ' WS-COUNT-ROWS-12.           
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           MOVE 0 TO WS-COMMIT-COUNT.                                   
           IF WS-RUN-1 = 'Y'                                            
               MOVE '1' TO WS-PROCESSING-SW                             
               PERFORM 1000A-RUN-1 THRU 1000A-EXIT
           END-IF.                     
           IF WS-RUN-2 = 'Y'                                            
               MOVE 0 TO WS-COMMIT-COUNT                                
               MOVE '2' TO WS-PROCESSING-SW                             
               PERFORM 1000B-RUN-2 THRU 1000B-EXIT
           END-IF.                     
           IF WS-RUN-3 = 'Y'                                            
               MOVE 0 TO WS-COMMIT-COUNT                                
               MOVE '3' TO WS-PROCESSING-SW                             
               PERFORM 1000C-RUN-3 THRU 1000C-EXIT
           END-IF.                     
           IF WS-RUN-4 = 'Y'                                            
               MOVE 0 TO WS-COMMIT-COUNT                                
               MOVE '4' TO WS-PROCESSING-SW                             
               PERFORM 1000D-RUN-4 THRU 1000D-EXIT
           END-IF.                     
           IF WS-RUN-5 = 'Y'                                            
               MOVE 0 TO WS-COMMIT-COUNT                                
               MOVE '5' TO WS-PROCESSING-SW                             
               PERFORM 1000E-RUN-5 THRU 1000E-EXIT
           END-IF.                     
           IF WS-RUN-6 = 'Y'                                            
               MOVE 0 TO WS-COMMIT-COUNT                                
               MOVE '6' TO WS-PROCESSING-SW                             
               PERFORM 1000F-RUN-6 THRU 1000F-EXIT
           END-IF.                     
           IF WS-RUN-7 = 'Y'                                            
               MOVE 0 TO WS-COMMIT-COUNT                                
               MOVE '7' TO WS-PROCESSING-SW                             
               PERFORM 1000G-RUN-7 THRU 1000G-EXIT
           END-IF.                     
           MOVE 0 TO WS-COMMIT-COUNT.                                   
           PERFORM 1000H-RUN-8 THRU 1000H-EXIT.                         
           MOVE 0 TO WS-COMMIT-COUNT.                                   
           PERFORM 1000I-RUN-9 THRU 1000I-EXIT.                         
P00740     MOVE 0 TO WS-COMMIT-COUNT.                                   
P00740     PERFORM 1000J-RUN-10 THRU 1000J-EXIT.                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000A-RUN-1.                                                     
                                                                        
           DISPLAY 'OPENING ACCT-CURSOR'.                               
           MOVE WS-ADDRESS-LIMIT-U TO WS-HI-ADDRESS-ID.                 
           MOVE WS-ADDRESS-LIMIT-L TO WS-LO-ADDRESS-ID.                 
           EXEC SQL                                                     
               OPEN ACCT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING ACCT-CURSOR         **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING ACCT-CURSOR         **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000B-RUN-2.                                                     
                                                                        
           MOVE ZEROES TO WS-HOLD-CUSTOMER.                             
                                                                        
           MOVE WS-CUSTOMER-LIMIT-U TO WS-HI-CUSTOMER-NO.               
           MOVE WS-CUSTOMER-LIMIT-L TO WS-LO-CUSTOMER-NO.               
           DISPLAY 'OPENING CUST-ADDR-CURSOR'.                          
           EXEC SQL                                                     
               OPEN CUST-ADDR-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING CUST-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 3100-FETCH-ROWS  THRU 3100-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE CUST-ADDR-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING CUST-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000C-RUN-3.                                                     
                                                                        
           DISPLAY 'OPENING ACCT-ADDR-CURSOR'.                          
           MOVE WS-ACCOUNT-LIMIT-U TO WS-HI-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-LIMIT-L TO WS-LO-ACCOUNT-NO.                 
           EXEC SQL                                                     
               OPEN ACCT-ADDR-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING ACCT-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 4100-FETCH-ROWS  THRU 4100-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT-ADDR-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING ACCT-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000D-RUN-4.                                                     
                                                                        
           DISPLAY 'OPENING BILL-XREF-CURSOR'.                          
           EXEC SQL                                                     
               OPEN BILL-XREF-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING BILL-XREF-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 5100-FETCH-ROWS  THRU 5100-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE BILL-XREF-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING BILL-XREF-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000D-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000E-RUN-5.                                                     
                                                                        
           DISPLAY 'OPENING MISS-XREF-CURSOR'.                          
           EXEC SQL                                                     
               OPEN MISS-XREF-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING MISS-XREF-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 6100-FETCH-ROWS  THRU 6100-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE MISS-XREF-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING MISS-XREF-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000E-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000F-RUN-6.                                                     
                                                                        
           DISPLAY 'OPENING MISS-ACCT-CURSOR'.                          
           EXEC SQL                                                     
               OPEN MISS-ACCT-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING MISS-ACCT-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 6200-FETCH-ROWS  THRU 6200-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE MISS-ACCT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING MISS-ACCT-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000F-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000G-RUN-7.                                                     
                                                                        
           DISPLAY 'OPENING MISS-ADDR-CURSOR'.                          
           EXEC SQL                                                     
               OPEN MISS-ADDR-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING MISS-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 6300-FETCH-ROWS  THRU 6300-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE MISS-ADDR-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING MISS-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000G-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000H-RUN-8.                                                     
                                                                        
           DISPLAY 'OPENING FF-POBOX-CURSOR'.                           
           EXEC SQL                                                     
               OPEN FF-POBOX-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING FF-POBOX-CURSOR     **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 6400-FETCH-ROWS  THRU 6400-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE FF-POBOX-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING FF-POBOX-CURSOR     **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000H-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000I-RUN-9.                                                     
                                                                        
           DISPLAY 'OPENING FMT-POBOX-CURSOR'.                          
           EXEC SQL                                                     
               OPEN FMT-POBOX-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING FMT-POBOX-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 6500-FETCH-ROWS  THRU 6500-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE FMT-POBOX-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING FMT-POBOX-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000I-EXIT.                                                      
           EXIT.                                                        
                                                                        
P00740 1000J-RUN-10.                                                    
P00740                                                                  
P00740     MOVE 'X' TO WS-PROCESSING-SW.                                
P00740     DISPLAY 'OPENING FF-CITYST-CURSOR'.                          
P00740     EXEC SQL                                                     
P00740         OPEN FF-CITYST-CURSOR                                    
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
P00740             DISPLAY '****************************************'   
P00740             DISPLAY '**  ERROR OPENING FF-CITYST-CURSOR    **'   
P00740             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
P00740             DISPLAY '**  PROCESSING TERMINATED             **'   
P00740             DISPLAY '****************************************'   
P00740             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     PERFORM 6600-FETCH-ROWS  THRU 6600-EXIT.                     
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         CLOSE FF-CITYST-CURSOR                                   
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
P00740             DISPLAY '****************************************'   
P00740             DISPLAY '**  ERROR CLOSING FF-CITYST-CURSOR    **'   
P00740             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
P00740             DISPLAY '**  PROCESSING TERMINATED             **'   
P00740             DISPLAY '****************************************'   
P00740             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
P00740     END-EVALUATE.                                                
P00740                                                                  
A05317     DISPLAY 'OPENING FF-CITYST-CURSOR-C'.                        
A05317     EXEC SQL                                                     
A05317         OPEN FF-CITYST-CURSOR-C                                  
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             CONTINUE                                             
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A05317             DISPLAY '****************************************'   
A05317             DISPLAY '**  ERROR OPENING FF-CITYST-CURSOR-C  **'   
A05317             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A05317             DISPLAY '**  PROCESSING TERMINATED             **'   
A05317             DISPLAY '****************************************'   
A05317             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317     PERFORM 6700-FETCH-ROWS  THRU 6700-EXIT.                     
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         CLOSE FF-CITYST-CURSOR-C                                 
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             CONTINUE                                             
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A05317             DISPLAY '****************************************'   
A05317             DISPLAY '**  ERROR CLOSING FF-CITYST-CURSOR-C  **'   
A05317             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A05317             DISPLAY '**  PROCESSING TERMINATED             **'   
A05317             DISPLAY '****************************************'   
A05317             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317     DISPLAY 'OPENING FF-CITYST-CURSOR-T'.                        
A05317     EXEC SQL                                                     
A05317         OPEN FF-CITYST-CURSOR-T                                  
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             CONTINUE                                             
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A05317             DISPLAY '****************************************'   
A05317             DISPLAY '**  ERROR OPENING FF-CITYST-CURSOR-T  **'   
A05317             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A05317             DISPLAY '**  PROCESSING TERMINATED             **'   
A05317             DISPLAY '****************************************'   
A05317             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317     PERFORM 6800-FETCH-ROWS  THRU 6800-EXIT.                     
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         CLOSE FF-CITYST-CURSOR-T                                 
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             CONTINUE                                             
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A05317             DISPLAY '****************************************'   
A05317             DISPLAY '**  ERROR CLOSING FF-CITYST-CURSOR-T  **'   
A05317             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A05317             DISPLAY '**  PROCESSING TERMINATED             **'   
A05317             DISPLAY '****************************************'   
A05317             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A05317     END-EVALUATE.                                                
A05317                                                                  
P00740 1000J-EXIT.                                                      
P00740     EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ACCT-CURSOR                                        
                INTO :AT-ADDRESS-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
      *            DISPLAY ' '                                                  
      *            DISPLAY 'BEGINNING ADDRESS ID ' WS-DISPLAY-ADDRESS           
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING ACCT-CURSOR        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AT.ADDRESS_ID                                     
                 INTO :AT-ADDRESS-ID                                    
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ADDRESS_ID = :AT-ADDRESS-ID                    
                  AND EXISTS                                            
                   (SELECT '1'                                          
                      FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                    
                     WHERE ADDRESS_ID = AT.ADDRESS_ID                   
                       AND CUSTOMER_NO <> AT.CUSTOMER_NO)               
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.ADDRESS_ID                                             
MFA-TR*          INTO :AT-ADDRESS-ID                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ADDRESS_ID = :AT-ADDRESS-ID                            
MFA-TR*           AND EXISTS                                                    
MFA-TR*            (SELECT '1'                                                  
MFA-TR*               FROM CSS_ACCOUNT                                          
MFA-TR*              WHERE ADDRESS_ID = AT.ADDRESS_ID                           
MFA-TR*                AND CUSTOMER_NO = AT.CUSTOMER_NO)                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
      *            DISPLAY ' '                                                  
      *            DISPLAY 'BEGINNING ADDRESS ID ' WS-DISPLAY-ADDRESS           
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-FETCH-ROWS                                
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_ACCOUNT       **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1200-ADDRESS-PROCESSING THRU 1200-EXIT.              
                                                                        
           ADD 1 TO WS-COMMIT-COUNT.                                    
                                                                        
A03864     IF WS-COMMIT-COUNT > 1                                       
               DISPLAY 'COMMIT TAKEN'                                   
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-ADDRESS-PROCESSING.                                         
                                                                        
           MOVE 'Y' TO WS-FIRST-CUSTOMER.                               
           MOVE ZEROES TO WS-HOLD-CUSTOMER.                             
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
                      HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_SUFFIX,                                    
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN,                                   
                      ADDR_USAGE_CD,                                    
                      ADDR_SUFFIX,                                      
                      USPS_DELIV_PT_CD                                  
                 INTO :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-CARRIER-ROUTE,                                
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-USAGE-CD,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-USPS-DELIV-PT-CD                              
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :AT-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_ADDR_FORMATTED**'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ADDRESS = ' WS-DISPLAY-ADDRESS          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               OPEN ADDR-CUST-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING ADDR-CUST-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1250-FETCH-ROWS  THRU 1250-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE ADDR-CUST-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING ADDR-CUST-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1250-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ADDR-CUST-CURSOR                                   
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-ADDRESS-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   MOVE AT-CUSTOMER-NO TO WS-DISPLAY-CUSTOMER           
      *            DISPLAY 'ACCT/CUST ' WS-DISPLAY-ACCOUNT                      
      *                    ' ' WS-DISPLAY-CUSTOMER                              
               WHEN NOT-FOUND                                           
                   GO TO 1250-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING ADDR-CUST-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE AT-ADDRESS-ID TO WS-OLD-ADDRESS-ID.                     
                                                                        
           IF WS-FIRST-CUSTOMER = 'Y'                                   
               IF WS-HOLD-CUSTOMER = 0                                  
                   MOVE AT-CUSTOMER-NO TO WS-HOLD-CUSTOMER              
                   GO TO 1250-FETCH-ROWS                                
               ELSE                                                     
                   IF AT-CUSTOMER-NO = WS-HOLD-CUSTOMER                 
                       GO TO 1250-FETCH-ROWS                            
                   ELSE                                                 
                       MOVE 'N' TO WS-FIRST-CUSTOMER
                   END-IF
               END-IF
           END-IF.                   
                                                                        
           IF WS-FIRST-CUSTOMER = 'N'                                   
               IF AT-CUSTOMER-NO = WS-HOLD-CUSTOMER                     
                   MOVE 'Y' TO WS-MULTIPLE-ACCOUNTS                     
                   MOVE DY-ADDRESS-ID TO AT-ADDRESS-ID                  
                   PERFORM 2000-UPDATE-ACCOUNT THRU 2000-EXIT           
                   ADD +1 TO WS-COUNT-ROWS-1                            
               ELSE                                                     
                   PERFORM 2100-GET-ADDRESS-ID THRU 2100-EXIT           
                   PERFORM 2200-INSERT-ADDRESS THRU 2200-EXIT           
                   MOVE DY-ADDRESS-ID TO AT-ADDRESS-ID                  
                   PERFORM 2000-UPDATE-ACCOUNT THRU 2000-EXIT           
                   ADD +1 TO WS-COUNT-ROWS-1                            
                   PERFORM 2300-UPDATE-LANDLORD THRU 2300-EXIT          
                   MOVE AT-CUSTOMER-NO TO WS-HOLD-CUSTOMER
               END-IF
           END-IF.             
                                                                        
           GO TO 1250-FETCH-ROWS.                                       
                                                                        
       1250-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2000-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ADDRESS_ID     = :AT-ADDRESS-ID                   
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_ACCOUNT (2000) **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILL_ADDR_XREF                                
                  SET ADDRESS_ID     = :AT-ADDRESS-ID                   
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN ALREADY-EXISTS                                      
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_BILL_ADDR_XREF **'   
                   DISPLAY '**  (2000)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE AT-ADDRESS-ID TO WS-NEW-ADDRESS-ID.                     
           PERFORM 2400-JRNL-TRAN-HEAD THRU 2400-EXIT.                  
           PERFORM 2450-JRNL-UPDATE THRU 2450-EXIT.                     
      *    DISPLAY 'OLD = ' WS-OLD-ADDRESS-ID.                                  
      *    DISPLAY 'NEW = ' WS-NEW-ADDRESS-ID.                                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-GET-ADDRESS-ID.                                             
                                                                        
           MOVE SPACES                        TO WS-90-PANEL-NO.        
           MOVE SPACES                        TO WS-90-USERID.          
           MOVE ZEROES                        TO WS-90-ACCOUNT-NO.      
           MOVE ZEROES                        TO WS-90-CUSTOMER-NO.     
           MOVE ZEROES                        TO WS-90-PREMISE-NO.      
                                                                        
           PERFORM 6202-GET-NEW-ADDRESS-ID    THRU 6202-EXIT.           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-INSERT-ADDRESS.                                             
                                                                        
           MOVE WS-90-NEW-ADDRESS-ID          TO DY-ADDRESS-ID.         
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                    (ADDRESS_ID        ,                                
                     HOUSE_NO          ,                                
                     ADDR_PREFIX_1     ,                                
                     ADDR_PREFIX_2     ,                                
                     STREET_NAME       ,                                
                     STREET_LOCATION_1 ,                                
                     STREET_LOCATION_2 ,                                
                     STREET_SUFFIX     ,                                
                     ADDR_SUFFIX       ,                                
                     ADDRESS_OVERFLOW  ,                                
                     CARRIER_ROUTE     ,                                
                     ZIP_CODE          ,                                
                     ZIP_CODE_PLUS_FOUR,                                
                     ZIP_CODE_TOKEN    ,                                
                     USPS_DELIV_PT_CD  ,                                
                     ADDR_USAGE_CD)                                     
               VALUES                                                   
                   (:DY-ADDRESS-ID        ,                             
                    :DY-HOUSE-NO          ,                             
                    :DY-ADDR-PREFIX-1     ,                             
                    :DY-ADDR-PREFIX-2     ,                             
                    :DY-STREET-NAME       ,                             
                    :DY-STREET-LOCATION-1 ,                             
                    :DY-STREET-LOCATION-2 ,                             
                    :DY-STREET-SUFFIX     ,                             
                    :DY-ADDR-SUFFIX       ,                             
                    :DY-ADDRESS-OVERFLOW  ,                             
                    :DY-CARRIER-ROUTE     ,                             
                    :DY-ZIP-CODE          ,                             
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN    ,                             
                    :DY-USPS-DELIV-PT-CD  ,                             
                    :DY-ADDR-USAGE-CD)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE DY-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_ADDR_FORMATTED**'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-UPDATE-LANDLORD.                                            
                                                                        
           MOVE WS-OLD-ADDRESS-ID TO SI-ADDRESS-ID.                     
           MOVE AT-CUSTOMER-NO TO SI-CUSTOMER-NO.                       
           EXEC SQL                                                     
               UPDATE CSS_LANDLORD                                      
                  SET ADDRESS_ID     = :AT-ADDRESS-ID                   
                WHERE ADDRESS_ID     = :SI-ADDRESS-ID                   
                  AND CUSTOMER_NO    = :SI-CUSTOMER-NO                  
                  AND ADDRESS_FORMAT = 'A'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   MOVE SI-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_LANDLORD (2300)**'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-JRNL-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
               INTO  :WS-CURRENT-TIMESTAMP                              
               FROM   CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT TIMESTAMP                                         
MFA-TR*        INTO  :WS-CURRENT-TIMESTAMP                                      
MFA-TR*        FROM   CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO.            
                                                                        
           MOVE SPACES                   TO MH-RESP-AREA-ID.            
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE ZEROES                   TO MH-CUSTOMER-NO.             
           MOVE ZEROES                   TO MH-PREMISE-NO.              
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 'SYSTEM'                 TO MH-USER-ID.                 
           MOVE 'PANEL086'               TO MH-APPL-PROGRAM-ID.         
           EVALUATE WS-PROCESSING-SW                                    
               WHEN '1'                                                 
                   MOVE WS-COMMENTS-1 TO MH-TRAN-COMMENT-TEXT           
                   MOVE 60 TO MH-TRAN-COMMENT-LEN                       
               WHEN '2'                                                 
                   MOVE WS-COMMENTS-2 TO MH-TRAN-COMMENT-TEXT           
                   MOVE 50 TO MH-TRAN-COMMENT-LEN                       
               WHEN '3'                                                 
                   MOVE WS-COMMENTS-3 TO MH-TRAN-COMMENT-TEXT           
                   MOVE 54 TO MH-TRAN-COMMENT-LEN                       
               WHEN 'X'                                                 
                   MOVE WS-COMMENTS-10 TO MH-TRAN-COMMENT-TEXT          
                   MOVE 38 TO MH-TRAN-COMMENT-LEN                       
               WHEN OTHER                                               
                   MOVE ZERO             TO MH-TRAN-COMMENT-LEN         
           END-EVALUATE.                                                
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2450-JRNL-UPDATE.                                                
                                                                        
           MOVE WS-CURRENT-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO.        
           MOVE WS-CURRENT-DATE         TO MH-DATE-TRANS.               
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE WS-OLD-ADDRESS-ID     TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE WS-NEW-ADDRESS-ID     TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'ADDRESS ID'          TO MI-COLUMN-DESC.                
           MOVE '  '                  TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CUST-ADDR-CURSOR                                   
                INTO :AT-CUSTOMER-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CUSTOMER-NO TO WS-DISPLAY-CUSTOMER           
      *            DISPLAY ' '                                                  
      *            DISPLAY 'CUSTOMER NO ' WS-DISPLAY-CUSTOMER                   
                   PERFORM 3200-ADDRESS-PROCESSING THRU 3200-EXIT       
               WHEN NOT-FOUND                                           
                   GO TO 3100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING CUST-ADDR-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           GO TO 3100-FETCH-ROWS.                                       
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-ADDRESS-PROCESSING.                                         
                                                                        
           MOVE 'Y' TO WS-FIRST-ACCOUNT.                                
           MOVE ZEROES TO WS-HOLD-ADDRESS.                              
           INITIALIZE WS-HOLD-ADDRESS-FIELDS.                           
           MOVE 'N' TO WS-UPDATE-SW.                                    
                                                                        
           EXEC SQL                                                     
               OPEN SAME-ADDR-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING SAME-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 3250-FETCH-ROWS  THRU 3250-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE SAME-ADDR-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING SAME-ADDR-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF WS-UPDATE-SW = 'Y'                                        
               ADD 1 TO WS-COMMIT-COUNT                                 
A03864         IF WS-COMMIT-COUNT > 10                                  
                   DISPLAY 'COMMIT TAKEN'                               
                   EXEC SQL                                             
                       COMMIT                                           
                   END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   MOVE 0 TO WS-COMMIT-COUNT
               END-IF
           END-IF.                           
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3250-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH SAME-ADDR-CURSOR                                   
                INTO :AT-ADDRESS-ID,                                    
                     :WS-ADDRESS-COUNT,                                 
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-SUFFIX,                                 
                     :DY-ADDR-SUFFIX,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 3250-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING SAME-ADDR-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF WS-FIRST-ACCOUNT = 'Y'                                    
               MOVE AT-ADDRESS-ID TO WS-HOLD-ADDRESS                    
               MOVE DY-HOUSE-NO TO WS-HOLD-HOUSE                        
               MOVE DY-ADDR-PREFIX-1 TO WS-HOLD-PREF1                   
               MOVE DY-ADDR-PREFIX-2 TO WS-HOLD-PREF2                   
               MOVE DY-STREET-NAME TO WS-HOLD-STREET                    
               MOVE DY-STREET-SUFFIX TO WS-HOLD-ST-SUFF                 
               MOVE DY-ADDR-SUFFIX TO WS-HOLD-AD-SUFF                   
               MOVE DY-STREET-LOCATION-1 TO WS-HOLD-LOC1                
               MOVE DY-STREET-LOCATION-2 TO WS-HOLD-LOC2                
               MOVE DY-ZIP-CODE TO WS-HOLD-ZIP                          
               MOVE DY-ZIP-CODE-TOKEN TO WS-HOLD-ZIPTOK                 
               MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-HOLD-PLUS4              
               MOVE 'N' TO WS-FIRST-ACCOUNT                             
               GO TO 3250-FETCH-ROWS
           END-IF.                                   
                                                                        
           MOVE 'N' TO WS-ADDRESS-MATCH.                                
                                                                        
           IF DY-HOUSE-NO = WS-HOLD-HOUSE AND                           
              DY-ADDR-PREFIX-1 = WS-HOLD-PREF1 AND                      
              DY-ADDR-PREFIX-2 = WS-HOLD-PREF2 AND                      
              DY-STREET-NAME = WS-HOLD-STREET AND                       
              DY-STREET-SUFFIX = WS-HOLD-ST-SUFF AND                    
              DY-ADDR-SUFFIX = WS-HOLD-AD-SUFF AND                      
              DY-STREET-LOCATION-1 = WS-HOLD-LOC1 AND                   
              DY-STREET-LOCATION-2 = WS-HOLD-LOC2 AND                   
              DY-ZIP-CODE = WS-HOLD-ZIP AND                             
              DY-ZIP-CODE-TOKEN = WS-HOLD-ZIPTOK AND                    
              DY-ZIP-CODE-PLUS-FOUR = WS-HOLD-PLUS4                     
                  MOVE 'Y' TO WS-ADDRESS-MATCH
           END-IF.                         
                                                                        
           IF WS-ADDRESS-MATCH = 'Y'                                    
               MOVE 'Y' TO WS-UPDATE-SW                                 
               PERFORM 3350-PROCESS-ACCOUNTS THRU 3350-EXIT
           END-IF.            
                                                                        
           IF WS-ADDRESS-MATCH = 'N'                                    
               MOVE AT-ADDRESS-ID TO WS-HOLD-ADDRESS                    
               MOVE DY-HOUSE-NO TO WS-HOLD-HOUSE                        
               MOVE DY-ADDR-PREFIX-1 TO WS-HOLD-PREF1                   
               MOVE DY-ADDR-PREFIX-2 TO WS-HOLD-PREF2                   
               MOVE DY-STREET-NAME TO WS-HOLD-STREET                    
               MOVE DY-STREET-SUFFIX TO WS-HOLD-ST-SUFF                 
               MOVE DY-ADDR-SUFFIX TO WS-HOLD-AD-SUFF                   
               MOVE DY-STREET-LOCATION-1 TO WS-HOLD-LOC1                
               MOVE DY-STREET-LOCATION-2 TO WS-HOLD-LOC2                
               MOVE DY-ZIP-CODE TO WS-HOLD-ZIP                          
               MOVE DY-ZIP-CODE-TOKEN TO WS-HOLD-ZIPTOK                 
               MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-HOLD-PLUS4
           END-IF.             
                                                                        
           GO TO 3250-FETCH-ROWS.                                       
                                                                        
       3250-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3350-PROCESS-ACCOUNTS.                                           
                                                                        
           EXEC SQL                                                     
               OPEN ACCTS-4-ADDR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR OPENING ACCTS-4-ADDR CURSOR **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 3400-FETCH-ROWS  THRU 3400-EXIT.                     
                                                                        
           EXEC SQL                                                     
               CLOSE ACCTS-4-ADDR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CLOSING ACCTS-4-ADDR CURSOR **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       3350-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3400-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ACCTS-4-ADDR                                       
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-PREMISE-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
      *            DISPLAY 'ACCT/CUST ' WS-DISPLAY-ACCOUNT                      
      *                    ' ' WS-DISPLAY-CUSTOMER                              
               WHEN NOT-FOUND                                           
                   GO TO 3400-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING ACCTS-4-ADDR CURSOR**'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ADDRESS_ID     = :WS-HOLD-ADDRESS                 
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND ADDRESS_FORMAT = 'A'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_ACCOUNT (3400) **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILL_ADDR_XREF                                
                  SET ADDRESS_ID     = :WS-HOLD-ADDRESS                 
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN ALREADY-EXISTS                                      
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_BILL_ADDR_XREF **'   
                   DISPLAY '**  (3400)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_LANDLORD                                      
                  SET ADDRESS_ID     = :WS-HOLD-ADDRESS                 
                WHERE ADDRESS_ID     = :AT-ADDRESS-ID                   
                  AND PREMISE_NO     = :AT-PREMISE-NO                   
                  AND ADDRESS_FORMAT = 'A'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   MOVE AT-PREMISE-NO TO WS-DISPLAY-PREMISE             
                   MOVE WS-HOLD-ADDRESS TO WS-DISPLAY-ADDRESS           
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_LANDLORD (3400)**'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
                   DISPLAY '**  PREMISE  = ' WS-DISPLAY-PREMISE         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE WS-HOLD-ADDRESS TO WS-NEW-ADDRESS-ID.                   
           MOVE AT-ADDRESS-ID TO WS-OLD-ADDRESS-ID.                     
           PERFORM 2400-JRNL-TRAN-HEAD THRU 2400-EXIT.                  
           PERFORM 2450-JRNL-UPDATE THRU 2450-EXIT.                     
      *    DISPLAY 'OLD = ' WS-OLD-ADDRESS-ID.                                  
      *    DISPLAY 'NEW = ' WS-NEW-ADDRESS-ID.                                  
                                                                        
           ADD 1 TO WS-COUNT-ROWS-2                                     
           GO TO 3400-FETCH-ROWS.                                       
                                                                        
       3400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ACCT-ADDR-CURSOR                                   
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-PREMISE-NO,                                    
                     :AT-ADDRESS-ID,                                    
                     :PR-ADDRESS-ID,                                    
                     :AT-CUSTOMER-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
      *            DISPLAY ' '                                                  
      *            DISPLAY 'ACCOUNT NO ' WS-DISPLAY-ACCOUNT                     
               WHEN NOT-FOUND                                           
                   GO TO 4100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING ACCT-ADDR-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ADDRESS_ID     = 0,                               
                      ADDRESS_FORMAT = ' '                              
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND ADDRESS_ID     = :AT-ADDRESS-ID                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_ACCOUNT (4100) **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILL_ADDR_XREF                           
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_BILL_ADDR_XREF **'   
                   DISPLAY '**  (4100)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           ADD +1 TO WS-COUNT-ROWS-3.                                   
           MOVE AT-ADDRESS-ID TO WS-OLD-ADDRESS-ID.                     
           MOVE 0 TO WS-NEW-ADDRESS-ID.                                 
           PERFORM 2400-JRNL-TRAN-HEAD THRU 2400-EXIT.                  
           PERFORM 2450-JRNL-UPDATE THRU 2450-EXIT.                     
                                                                        
           ADD 1 TO WS-COMMIT-COUNT.                                    
                                                                        
A03864     IF WS-COMMIT-COUNT > 10                                      
               DISPLAY 'COMMIT TAKEN'                                   
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           IF WS-COUNT-ROWS-3 > 2999                                    
               GO TO 4100-EXIT
           END-IF.                                         
                                                                        
           GO TO 4100-FETCH-ROWS.                                       
                                                                        
       4100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH BILL-XREF-CURSOR                                   
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-ADDRESS-ID,                                    
                     :AQ-ADDRESS-ID,                                    
                     :AQ-NAME-ID,                                       
                     :AQ-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
      *            DISPLAY ' '                                                  
      *            DISPLAY 'ACCOUNT NO ' WS-DISPLAY-ACCOUNT                     
               WHEN NOT-FOUND                                           
                   GO TO 5100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING BILL-XREF-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILL_ADDR_XREF                           
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_BILL_ADDR_XREF **'   
                   DISPLAY '**  (5100)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BILL_ADDR_XREF                            
                    (NAME_ID           ,                                
                     COMPANY_NO        ,                                
                     ACCOUNT_NO        ,                                
                     ADDRESS_ID)                                        
               VALUES                                                   
                   (:AQ-NAME-ID           ,                             
                    :AQ-COMPANY-NO        ,                             
                    :AT-ACCOUNT-NO        ,                             
                    :AT-ADDRESS-ID)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_BILL_ADDR_XREF**'   
                   DISPLAY '**  (5100)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           ADD +1 TO WS-COUNT-ROWS-4.                                   
                                                                        
           ADD 1 TO WS-COMMIT-COUNT.                                    
                                                                        
A03864     IF WS-COMMIT-COUNT > 10                                      
               DISPLAY 'COMMIT TAKEN'                                   
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 5100-FETCH-ROWS.                                       
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH MISS-XREF-CURSOR                                   
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-ADDRESS-ID,                                    
                     :CU-NAME-ID,                                       
                     :AT-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
      *            DISPLAY ' '                                                  
      *            DISPLAY 'ACCOUNT NO ' WS-DISPLAY-ACCOUNT                     
               WHEN NOT-FOUND                                           
                   GO TO 6100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING MISS-XREF-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILL_ADDR_XREF                           
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_BILL_ADDR_XREF **'   
                   DISPLAY '**  (6100)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BILL_ADDR_XREF                            
                    (NAME_ID           ,                                
                     COMPANY_NO        ,                                
                     ACCOUNT_NO        ,                                
                     ADDRESS_ID)                                        
               VALUES                                                   
                   (:CU-NAME-ID           ,                             
                    :AT-COMPANY-NO        ,                             
                    :AT-ACCOUNT-NO        ,                             
                    :AT-ADDRESS-ID)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERTING CSS_BILL_ADDR_XREF**'   
                   DISPLAY '**  (6100)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           ADD +1 TO WS-COUNT-ROWS-5.                                   
                                                                        
           ADD 1 TO WS-COMMIT-COUNT.                                    
                                                                        
A03864     IF WS-COMMIT-COUNT > 15                                      
               DISPLAY 'COMMIT TAKEN'                                   
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 6100-FETCH-ROWS.                                       
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6200-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH MISS-ACCT-CURSOR                                   
                INTO :AT-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
      *            DISPLAY ' '                                                  
      *            DISPLAY 'ACCOUNT NO ' WS-DISPLAY-ACCOUNT                     
               WHEN NOT-FOUND                                           
                   GO TO 6200-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING MISS-ACCT-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILL_ADDR_XREF                           
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_BILL_ADDR_XREF **'   
                   DISPLAY '**  (6100)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           ADD +1 TO WS-COUNT-ROWS-6.                                   
                                                                        
           ADD 1 TO WS-COMMIT-COUNT.                                    
                                                                        
A03864     IF WS-COMMIT-COUNT > 15                                      
               DISPLAY 'COMMIT TAKEN'                                   
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 6200-FETCH-ROWS.                                       
                                                                        
       6200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6300-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH MISS-ADDR-CURSOR                                   
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-ADDRESS-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
      *            DISPLAY ' '                                                  
      *            DISPLAY 'ACCOUNT NO ' WS-DISPLAY-ACCOUNT                     
               WHEN NOT-FOUND                                           
                   GO TO 6300-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING MISS-ADDR-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET ADDRESS_ID     = 0,                               
                      ADDRESS_FORMAT = ' '                              
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND ADDRESS_ID     = :AT-ADDRESS-ID                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATING CSS_ACCOUNT (6300) **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILL_ADDR_XREF                           
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT             
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_BILL_ADDR_XREF **'   
                   DISPLAY '**  (6100)                            **'   
                   DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
                   DISPLAY '**  ACCOUNT  = ' WS-DISPLAY-ACCOUNT         
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           ADD +1 TO WS-COUNT-ROWS-7.                                   
                                                                        
           ADD 1 TO WS-COMMIT-COUNT.                                    
                                                                        
A03864     IF WS-COMMIT-COUNT > 15                                      
               DISPLAY 'COMMIT TAKEN'                                   
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 6300-FETCH-ROWS.                                       
                                                                        
       6300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6400-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH FF-POBOX-CURSOR                                    
                INTO :DZ-ADDRESS-ID,                                    
                     :DZ-ADDR-STREET                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE DZ-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
               WHEN NOT-FOUND                                           
                   GO TO 6400-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING FF-POBOX-CURSOR    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 6410-PROCESS-POBOXES THRU 6410-EXIT.                 
                                                                        
           IF WS-COUNT-ROWS-8 > 5999                                    
               GO TO 6400-EXIT
           END-IF.                                         
                                                                        
A03864     IF WS-COMMIT-COUNT > 50                                      
               DISPLAY 'COMMIT TAKEN'                                   
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 6400-FETCH-ROWS.                                       
                                                                        
       6400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6410-PROCESS-POBOXES.                                            
                                                                        
           INITIALIZE WS-POBOX-FIELDS.                                  
           MOVE DZ-ADDR-STREET TO WS-OLD-ADDR-STREET.                   
           IF DZ-ADDR-STREET(1:8) = 'P O BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:8) = 'PO  BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:8) = 'P.O.BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:8) = 'P.O BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:8) = 'POX BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:8) = 'POP BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:8) = 'POI BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:8) = 'POM BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:8) = 'PO. BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(9:47) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:7) = 'P OBOX '                           
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(8:46) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:7) = 'P0 BOX '                           
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(8:46) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:7) = 'P O BOX' AND                       
              DZ-ADDR-STREET(8:1) NUMERIC                               
                   MOVE 'Y' TO WS-POBOX-UPDATE                          
                   MOVE DZ-ADDR-STREET(8:46) TO WS-BOX-NUMBER           
                   MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)             
                   MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.          
           IF DZ-ADDR-STREET(1:9) = 'P.O. BOX '                         
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(10:46) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:9) = 'P O  BOX '                         
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(10:46) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:9) = 'P  O BOX '                         
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(10:46) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:9) = 'P. O BOX '                         
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(10:46) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:9) = 'P O. BOX '                         
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(10:46) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:10) = 'P. O. BOX '                       
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(11:45) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:4) = 'POB '                              
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(5:50) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:6) = 'POBOX '                            
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(7:48) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:6) = 'PO BOX' AND                        
              DZ-ADDR-STREET(7:1) NUMERIC                               
                  MOVE 'Y' TO WS-POBOX-UPDATE                           
                  MOVE DZ-ADDR-STREET(7:48) TO WS-BOX-NUMBER            
                  MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)              
                  MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.           
           IF DZ-ADDR-STREET(1:6) = 'P BOX '                            
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(7:48) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
           IF DZ-ADDR-STREET(1:16) = 'POST OFFICE BOX '                 
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DZ-ADDR-STREET(17:35) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DZ-ADDR-STREET(1:7)                 
               MOVE WS-BOX-NUMBER TO DZ-ADDR-STREET(8:47)
           END-IF.              
                                                                        
           IF WS-POBOX-UPDATE = 'Y'                                     
               ADD +1 TO WS-COUNT-ROWS-8                                
               ADD 1 TO WS-COMMIT-COUNT                                 
               EXEC SQL                                                 
                   UPDATE CSS_ADDR_FREEFORM                             
                      SET ADDR_STREET = :DZ-ADDR-STREET                 
                    WHERE ADDRESS_ID = :DZ-ADDRESS-ID                   
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       CONTINUE                                         
                   WHEN OTHER                                           
                       MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE 
                       MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT         
                       DISPLAY '**************************************' 
                       DISPLAY '**  ERROR UPDATING CSS_ADDR_FREEFORM  ' 
                       DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE     
                       DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS     
                       DISPLAY '**  PROCESSING TERMINATED             ' 
                       DISPLAY '**************************************' 
                       PERFORM 9900-ABEND THRU 9900-ABEND-EXIT          
               END-EVALUATE
           END-IF.                                            
                                                                        
       6410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6500-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH FMT-POBOX-CURSOR                                   
                INTO :DY-ADDRESS-ID,                                    
                     :DY-STREET-NAME                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE DY-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
               WHEN NOT-FOUND                                           
                   GO TO 6500-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR FETCHING FMT-POBOX-CURSOR   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 6510-PROCESS-POBOXES THRU 6510-EXIT.                 
                                                                        
           IF WS-COUNT-ROWS-9 > 1999                                    
               GO TO 6500-EXIT
           END-IF.                                         
                                                                        
A03864     IF WS-COMMIT-COUNT > 50                                      
               DISPLAY 'COMMIT TAKEN'                                   
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
           GO TO 6500-FETCH-ROWS.                                       
                                                                        
       6500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6510-PROCESS-POBOXES.                                            
                                                                        
           INITIALIZE WS-POBOX-FIELDS.                                  
           MOVE DY-STREET-NAME TO WS-OLD-ADDR-STREET.                   
           IF DY-STREET-NAME(1:8) = 'P O BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(9:22) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:8) = 'PO  BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(9:22) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:8) = 'P.O.BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(9:22) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:8) = 'POX BOX '                          
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(9:22) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:9) = 'P.O. BOX '                         
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(10:21) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:9) = 'P O  BOX '                         
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(10:21) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:9) = 'P  O BOX '                         
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(10:21) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:10) = 'P. O. BOX '                       
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(11:20) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:4) = 'POB '                              
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(5:26) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:7) = 'P OBOX '                           
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(8:23) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:7) = 'P0 BOX '                           
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(8:23) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:7) = 'P O BOX' AND                       
              DY-STREET-NAME(8:1) NUMERIC                               
                   MOVE 'Y' TO WS-POBOX-UPDATE                          
                   MOVE DY-STREET-NAME(8:23) TO WS-BOX-NUMBER           
                   MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)             
                   MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.          
           IF DY-STREET-NAME(1:6) = 'POBOX '                            
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(7:24) TO WS-BOX-NUMBER               
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
           IF DY-STREET-NAME(1:6) = 'PO BOX' AND                        
              DY-STREET-NAME(7:1) NUMERIC                               
                  MOVE 'Y' TO WS-POBOX-UPDATE                           
                  MOVE DY-STREET-NAME(7:24) TO WS-BOX-NUMBER            
                  MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)              
                  MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.           
           IF DY-STREET-NAME(1:16) = 'POST OFFICE BOX '                 
               MOVE 'Y' TO WS-POBOX-UPDATE                              
               MOVE DY-STREET-NAME(17:14) TO WS-BOX-NUMBER              
               MOVE WS-POBOX-FMT TO DY-STREET-NAME(1:7)                 
               MOVE WS-BOX-NUMBER TO DY-STREET-NAME(8:22)
           END-IF.              
                                                                        
           IF WS-POBOX-UPDATE = 'Y'                                     
               ADD +1 TO WS-COUNT-ROWS-9                                
               ADD 1 TO WS-COMMIT-COUNT                                 
               EXEC SQL                                                 
                   UPDATE CSS_ADDR_FORMATTED                            
                      SET STREET_NAME = :DY-STREET-NAME                 
                    WHERE ADDRESS_ID = :DY-ADDRESS-ID                   
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       CONTINUE                                         
                   WHEN OTHER                                           
                       MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE 
                       MOVE AT-ACCOUNT-NO TO WS-DISPLAY-ACCOUNT         
                       DISPLAY '**************************************' 
                       DISPLAY '**  ERROR UPDATING CSS_ADDR_FORMATTED ' 
                       DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE     
                       DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS     
                       DISPLAY '**  PROCESSING TERMINATED             ' 
                       DISPLAY '**************************************' 
                       PERFORM 9900-ABEND THRU 9900-ABEND-EXIT          
               END-EVALUATE
           END-IF.                                            
                                                                        
       6510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6530-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           IF MI-TRAN-APPL-NO = 1                                       
              PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT         
           ELSE                                                         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT
           END-IF.        
                                                                        
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6540-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO,                                   
                   DATE_TRANS,                                          
                   CODE_TRAN_TYPE,                                      
                   RESP_AREA_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   PREMISE_NO,                                          
                   USER_ID,                                             
                   APPL_PROGRAM_ID,                                     
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                   
                   IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                   :MH-CODE-TRAN-TYPE,                                  
                   :MH-RESP-AREA-ID,                                    
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,                                     
                   :MH-PREMISE-NO,                                      
                   :MH-USER-ID,                                         
                   :MH-APPL-PROGRAM-ID,                                 
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO,                                           
MFA-TR*            DATE_TRANS,                                                  
MFA-TR*            CODE_TRAN_TYPE,                                              
MFA-TR*            RESP_AREA_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            USER_ID,                                                     
MFA-TR*            APPL_PROGRAM_ID,                                             
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO,                                       
MFA-TR*            :MH-DATE-TRANS,                                              
MFA-TR*            :MH-CODE-TRAN-TYPE,                                          
MFA-TR*            :MH-RESP-AREA-ID,                                            
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,                                             
MFA-TR*            :MH-PREMISE-NO,                                              
MFA-TR*            :MH-USER-ID,                                                 
MFA-TR*            :MH-APPL-PROGRAM-ID,                                         
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '** ERROR INSERTING CSS_MNT_TRN_HIST   **'       
               DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE               
               DISPLAY '** PROCESSING TERMINATED              **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       6540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6550-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO,                                     
                 TRAN_APPL_NO,                                          
                 COLUMN_DESC,                                           
                 PRV_COLUMN_VALUE,                                      
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),                     
                 :MI-TRAN-APPL-NO,                                      
                 :MI-COLUMN-DESC,                                       
                 :MI-PRV-COLUMN-VALUE,                                  
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*        ( TRANS_HIST_SEQ_NO,                                             
MFA-TR*          TRAN_APPL_NO,                                                  
MFA-TR*          COLUMN_DESC,                                                   
MFA-TR*          PRV_COLUMN_VALUE,                                              
MFA-TR*          CHG_COLUMN_VALUE,                                              
MFA-TR*          TABLE_ID)                                                      
MFA-TR*        VALUES                                                           
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO,                                         
MFA-TR*          :MI-TRAN-APPL-NO,                                              
MFA-TR*          :MI-COLUMN-DESC,                                               
MFA-TR*          :MI-PRV-COLUMN-VALUE,                                          
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                          
MFA-TR*          :MI-TABLE-ID)                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '** ERROR INSERTING CSS_MT_TRN_HST_DET **'       
               DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE               
               DISPLAY '** PROCESSING TERMINATED              **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       6550-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 6600-FETCH-ROWS.                                                 
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         FETCH FF-CITYST-CURSOR                                   
P00740          INTO :DZ-ADDRESS-ID,                                    
P00740               :DZ-ADDR-CITY-STATE,                               
P00740               :WS-CITY-STATE,                                    
P00740               :AT-ACCOUNT-NO                                     
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             MOVE DZ-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
P00740         WHEN NOT-FOUND                                           
P00740             GO TO 6600-EXIT                                      
P00740         WHEN OTHER                                               
P00740             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
P00740             DISPLAY '****************************************'   
P00740             DISPLAY '**  ERROR FETCHING FF-CITYST-CURSOR   **'   
P00740             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
P00740             DISPLAY '**  PROCESSING TERMINATED             **'   
P00740             DISPLAY '****************************************'   
P00740             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     PERFORM 6610-PROCESS-CITYST THRU 6610-EXIT.                  
P00740                                                                  
P00740     IF WS-COUNT-ROWS-10 > 1000                                   
P00740         GO TO 6600-EXIT
           END-IF.                                         
P00740                                                                  
P00740     IF WS-COMMIT-COUNT > 50                                      
P00740         DISPLAY 'COMMIT TAKEN'                                   
P00740         EXEC SQL                                                 
P00740             COMMIT                                               
P00740         END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740         MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
P00740                                                                  
P00740     GO TO 6600-FETCH-ROWS.                                       
P00740                                                                  
P00740 6600-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 6610-PROCESS-CITYST.                                             
P00740                                                                  
P00740     ADD +1 TO WS-COUNT-ROWS-10.                                  
P00740     ADD +1 TO WS-COMMIT-COUNT.                                   
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         UPDATE CSS_ADDR_FREEFORM                                 
P00740            SET ADDR_CITY_STATE = :WS-CITY-STATE                  
P00740          WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
P00740             DISPLAY '**************************************'     
P00740             DISPLAY '**  ERROR UPDATING CSS_ADDR_FREEFORM  '     
P00740             DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
P00740             DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
P00740             DISPLAY '**  PROCESSING TERMINATED             '     
P00740             DISPLAY '**************************************'     
P00740             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     PERFORM 2400-JRNL-TRAN-HEAD THRU 2400-EXIT.                  
P00740     MOVE WS-CURRENT-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO.        
P00740     MOVE WS-CURRENT-DATE         TO MH-DATE-TRANS.               
P00740     MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
P00740                                                                  
P00740     MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
P00740     MOVE +30                   TO MI-PRV-COLUMN-VALUE-LEN.       
P00740     MOVE DZ-ADDR-CITY-STATE    TO MI-PRV-COLUMN-VALUE-TEXT.      
P00740     MOVE +30                   TO MI-CHG-COLUMN-VALUE-LEN.       
P00740     MOVE WS-CITY-STATE         TO MI-CHG-COLUMN-VALUE-TEXT.      
P00740     MOVE 'ADDR CITY ST'        TO MI-COLUMN-DESC.                
P00740     MOVE '  '                  TO MI-TABLE-ID.                   
P00740     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00740                                                                  
P00740 6610-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
A05317 6700-FETCH-ROWS.                                                 
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         FETCH FF-CITYST-CURSOR-C                                 
A05317          INTO :DZ-ADDRESS-ID,                                    
A05317               :DZ-ADDR-CITY-STATE,                               
A05317               :WS-CITY-STATE,                                    
A05317               :CV-CONTACT-ID                                     
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             MOVE DZ-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
A05317         WHEN NOT-FOUND                                           
A05317             GO TO 6700-EXIT                                      
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A05317             DISPLAY '****************************************'   
A05317             DISPLAY '**  ERROR FETCHING FF-CITYST-CURSOR-C **'   
A05317             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A05317             DISPLAY '**  PROCESSING TERMINATED             **'   
A05317             DISPLAY '****************************************'   
A05317             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317     ADD +1 TO WS-COUNT-ROWS-11.                                  
A05317     ADD +1 TO WS-COMMIT-COUNT.                                   
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         UPDATE CSS_ADDR_FREEFORM                                 
A05317            SET ADDR_CITY_STATE = :WS-CITY-STATE                  
A05317          WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             CONTINUE                                             
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A05317             DISPLAY '**************************************'     
A05317             DISPLAY '**  ERROR UPDATING CSS_ADDR_FREEFORM  '     
A05317             DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
A05317             DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
A05317             DISPLAY '**  PROCESSING TERMINATED             '     
A05317             DISPLAY '**************************************'     
A05317             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317     IF WS-COUNT-ROWS-11 > 9999                                   
A05317         GO TO 6700-EXIT
           END-IF.                                         
A05317                                                                  
A05317     IF WS-COMMIT-COUNT > 100                                     
A05317         DISPLAY 'COMMIT TAKEN'                                   
A05317         EXEC SQL                                                 
A05317             COMMIT                                               
A05317         END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317         MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
A05317                                                                  
A05317     GO TO 6700-FETCH-ROWS.                                       
A05317                                                                  
A05317 6700-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
A05317 6800-FETCH-ROWS.                                                 
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         FETCH FF-CITYST-CURSOR-T                                 
A05317          INTO :DZ-ADDRESS-ID,                                    
A05317               :DZ-ADDR-CITY-STATE,                               
A05317               :WS-CITY-STATE,                                    
A05317               :ZW-THD-PRTY-ID                                    
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             MOVE DZ-ADDRESS-ID TO WS-DISPLAY-ADDRESS             
A05317         WHEN NOT-FOUND                                           
A05317             GO TO 6800-EXIT                                      
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A05317             DISPLAY '****************************************'   
A05317             DISPLAY '**  ERROR FETCHING FF-CITYST-CURSOR-T **'   
A05317             DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
A05317             DISPLAY '**  PROCESSING TERMINATED             **'   
A05317             DISPLAY '****************************************'   
A05317             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317     ADD +1 TO WS-COUNT-ROWS-12.                                  
A05317     ADD +1 TO WS-COMMIT-COUNT.                                   
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         UPDATE CSS_ADDR_FREEFORM                                 
A05317            SET ADDR_CITY_STATE = :WS-CITY-STATE                  
A05317          WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             CONTINUE                                             
A05317         WHEN OTHER                                               
A05317             MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
A05317             DISPLAY '**************************************'     
A05317             DISPLAY '**  ERROR UPDATING CSS_ADDR_FREEFORM  '     
A05317             DISPLAY '**  SQLCODE  = ' WS-DISPLAY-SQLCODE         
A05317             DISPLAY '**  ADDRESS  = ' WS-DISPLAY-ADDRESS         
A05317             DISPLAY '**  PROCESSING TERMINATED             '     
A05317             DISPLAY '**************************************'     
A05317             PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317     IF WS-COUNT-ROWS-12 > 7500                                   
A05317         GO TO 6800-EXIT
           END-IF.                                         
A05317                                                                  
A05317     IF WS-COMMIT-COUNT > 100                                     
A05317         DISPLAY 'COMMIT TAKEN'                                   
A05317         EXEC SQL                                                 
A05317             COMMIT                                               
A05317         END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317         MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
A05317                                                                  
A05317     GO TO 6800-FETCH-ROWS.                                       
A05317                                                                  
A05317 6800-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
       7000-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSSO306'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(1:1) TO WS-RUN-1                        
              MOVE G6-PARM-DATA(2:1) TO WS-RUN-2                        
              MOVE G6-PARM-DATA(3:1) TO WS-RUN-3                        
              MOVE G6-PARM-DATA(4:1) TO WS-RUN-4                        
              MOVE G6-PARM-DATA(5:1) TO WS-RUN-5                        
              MOVE G6-PARM-DATA(6:1) TO WS-RUN-6                        
              MOVE G6-PARM-DATA(7:1) TO WS-RUN-7                        
              IF G6-PARM-DATA(8:13) NUMERIC                             
                  MOVE G6-PARM-DATA(8:13) TO WS-ADDRESS-LIMIT-U         
              ELSE                                                      
                  MOVE ZEROES TO WS-ADDRESS-LIMIT-U                     
              END-IF                                                    
              IF G6-PARM-DATA(22:10) NUMERIC                            
                  MOVE G6-PARM-DATA(22:10) TO WS-CUSTOMER-LIMIT-U       
              ELSE                                                      
                  MOVE ZEROES TO WS-CUSTOMER-LIMIT-U                    
              END-IF                                                    
              IF G6-PARM-DATA(33:13) NUMERIC                            
                  MOVE G6-PARM-DATA(33:13) TO WS-ACCOUNT-LIMIT-U        
              ELSE                                                      
                  MOVE ZEROES TO WS-ACCOUNT-LIMIT-U                     
              END-IF                                                    
              COMPUTE WS-ADDRESS-LIMIT-L =                              
                      WS-ADDRESS-LIMIT-U - 1000000000000                
              IF WS-ADDRESS-LIMIT-L < 0                                 
                  MOVE 0 TO WS-ADDRESS-LIMIT-L                          
              END-IF                                                    
              COMPUTE WS-CUSTOMER-LIMIT-L =                             
                      WS-CUSTOMER-LIMIT-U - 1000000000                  
              IF WS-CUSTOMER-LIMIT-L < 0                                
                  MOVE 0 TO WS-CUSTOMER-LIMIT-L                         
              END-IF                                                    
              COMPUTE WS-ACCOUNT-LIMIT-L =                              
                      WS-ACCOUNT-LIMIT-U - 1000000000000                
              IF WS-ACCOUNT-LIMIT-L < 0                                 
                  MOVE 0 TO WS-ACCOUNT-LIMIT-L                          
              END-IF                                                    
              DISPLAY G6-PARM-DATA(1:7)                                 
              DISPLAY WS-ADDRESS-LIMIT-U                                
              DISPLAY WS-ADDRESS-LIMIT-L                                
              DISPLAY WS-CUSTOMER-LIMIT-U                               
              DISPLAY WS-CUSTOMER-LIMIT-L                               
              DISPLAY WS-ACCOUNT-LIMIT-U                                
              DISPLAY WS-ACCOUNT-LIMIT-L                                
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       COPY CPD0023B.                                                           
            EXEC SQL                                                            
                INCLUDE CPD00090                                                
            END-EXEC.                                                           
            EXEC SQL                                                            
                INCLUDE CPD00071                                                
            END-EXEC.                                                           
                                                                        
      ********************************************************                  
      **  SET THE RETURN CODE AND END.                      **                  
      ********************************************************                  
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE             
           DISPLAY '****************************************'           
           DISPLAY '** ERROR GETTING NEXT ADDRESS ID      **'           
           DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE                   
           DISPLAY '** ' ABEND-FUNCTION ' ** ' TABLE-1                  
           DISPLAY '** PROCESSING TERMINATED              **'           
           DISPLAY '****************************************'.          
                                                                        
                                                                        
       9000-EXIT.                                                       
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           PERFORM 9900-ABEND THRU 9900-ABEND-EXIT.                     
                                                                        
       9900-EXIT.                                                       
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO306 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
