       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSSO304                                             
       DATE-WRITTEN. AUG 2008.                                          
       DATE-COMPILED.                                                   
      *                                                                 00050002
      ******************************************************************00060002
      *                                                                *00070002
      *      PROGRAM MODIFICATION LOG                                  *00080002
      *                                                                *00090002
      *     DATE     USER ID  REASON                                   *00100002
      *   --------   -------  ---------------------------------------- *00110002
      *   08/25/08   PK98692  INITIAL CODING                           *00120002
      ******************************************************************00130002
      * THIS PROGRAM GENERATES THE WEEKLY REPORT FOR PSNC FROM THE     *00140002
      * POWERPLANT STATISTICAL INTERFACE GENERATED BY PROGAM PCSCV011  *00140002
      * THE WEEKLY REPORT#3 IS GENERATED EVERY FRIDAY.                 *00140002
      ******************************************************************00140002
      *                                                                 00140002
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                 00200002
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT CSR2EBS-FILE    ASSIGN TO CSR2EBS                     
               FILE STATUS IS WS-2EBS-STATUS.                           
           SELECT PRNTFILE ASSIGN TO PRNTFILE.                          
      *                                                                 00240002
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  CSR2EBS-FILE.                                                
       01  WS-CSR2EBS-REC.                                              
           05 POWER-PLT-WO           PIC X(6).                          
           05 DLM-01                 PIC X(1).                          
           05 PF-NO                  PIC X(15).                         
           05 DLM-02                 PIC X(1).                          
           05 GL-ACCOUNT-NO          PIC X(7).                          
           05 DLM-03                 PIC X(1).                          
           05 GL-UTIL-ACCT-NO        PIC X(6).                          
           05 DLM-04                 PIC X(1).                          
           05 CUSTOMER               PIC X(3).                          
           05 DLM-05                 PIC X(1).                          
           05 WORK-ORDER-NO          PIC X(8).                          
           05 DLM-06                 PIC X(1).                          
           05 COMPLETION-DT          PIC X(8).                          
           05 DLM-07                 PIC X(1).                          
           05 PIPE-TYPE-CD           PIC X(5).                          
           05 DLM-08                 PIC X(1).                          
           05 PIPE-LENGTH            PIC X(5).                          
           05 DLM-09                 PIC X(1).                          
           05 INSTALLED-COUNT        PIC X(3).                          
           05 DLM-10                 PIC X(1).                          
           05 NO-T-LINE              PIC X(10).                         
           05 DLM-11                 PIC X(1).                          
           05 VINTAGE-YEAR           PIC X(4).                          
           05 DLM-12                 PIC X(1).                          
           05 PREFIX-3               PIC X(1).                          
           05 COST-CENTER            PIC X(3).                          
           05 DLM-13                 PIC X(1).                          
           05 REVERSE-N              PIC X(1).                          
      *                                                                 00270035
       FD PRNTFILE                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 81 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01 PRNTFILE-RECORD.                                              
          05 PRNTFILE-CC              PIC X(01).                        
          05 PRNTFILE-DATA            PIC X(80).                        
                                                                        
HPCCDM*EJECT                                                            00370002
                                                                        
      *                                                                 00390002
       WORKING-STORAGE SECTION.                                         
      *                                                                 00410002
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PPRPT03 STARTS HERE'.                   
      *                                                                 00440002
       01 WORK-AREAS.                                                   
          05 WS-EOF-SW                     PIC X(01) VALUE SPACES.      
             88  END-OF-FILE                         VALUE 'Y'.         
          05 WS-2EBS-STATUS                PIC X(02) VALUE '  '.        
             88 2EBS-SUCCESSFUL                      VALUE '00'.        
             88 2EBS-READ-OK                         VALUE '00' '04'.   
             88 END-OF-CSR2EBS                       VALUE '10'.        
          05 WS-YES                      PIC X(01) VALUE 'Y'.           
          05 WS-NO                       PIC X(01) VALUE 'N'.           
          05 WS-RPT1-PAGE-NO             PIC 9(04) VALUE ZERO.          
          05 WS-INSTALLED-COUNT-N        PIC 9(03) VALUE ZERO.          
          05 WS-PIPE-LENGTH-N            PIC 9(05) VALUE ZERO.          
          05 WS-TOTAL-TALLY              PIC S9(3) VALUE ZERO.          
          05 WS-TOTAL-PIPE               PIC S9(5) VALUE ZERO.          
          05 WS-NO-OF-SERV-TALLY         PIC S9(1) VALUE ZERO.          
          05 WS-FEET-OF-PIPE             PIC S9(5) VALUE ZERO.          
          05 WS-PROGRAM                  PIC X(08) VALUE 'PCSSO304'.    
       01 WS-CURRENT-DATE.                                              
          05  WS-CURRENT-YY              PIC 9(02).                     
          05  WS-CURRENT-MM              PIC 9(02).                     
          05  WS-CURRENT-DD              PIC 9(02).                     
          05 WS-HOLD-DT.                                                
             10 WS-HOLD-YR               PIC X(04) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-MO               PIC X(02) VALUE SPACES.        
             10 FILLER                   PIC X(01) VALUE SPACES.        
             10 WS-HOLD-DY               PIC X(02) VALUE SPACES.        
      *                                                                 00970002
       01 WS-PRINTER-CONTROL.                                           
          05 WS-RPT1-LINE-NO             PIC 9(02) VALUE ZERO.          
          05 WS-LINES-PER-PAGE           PIC 9(02) VALUE 60.            
      *                                                                 01010002
       01 WS-HEADER-1.                                                  
          05 WS-RPRT-DATE-MM             PIC X(2).                      
          05 FILLER                      PIC X(1) VALUE '/'.            
          05 WS-RPRT-DATE-DD             PIC X(2).                      
          05 FILLER                      PIC X(1) VALUE '/'.            
          05 WS-RPRT-DATE-YY             PIC X(2).                      
      *   05 WS-RPRT-DATE                PIC X(8) VALUE SPACES.                 
          05 FILLER                      PIC X(23) VALUE SPACES.        
          05 WS-RPRT-COMPANY             PIC X(11) VALUE 'PSNC ENERGY'. 
          05 FILLER                      PIC X(20) VALUE SPACES.        
          05 FILLER                      PIC X(04) VALUE 'PAGE'.        
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-RPRT-PAGE-NO             PIC ZZ9   VALUE SPACES.        
          05 FILLER                      PIC X(02) VALUE SPACES.        
      *                                                                 01100002
       01 WS-HEADER-2.                                                  
          05 FILLER                      PIC X(23) VALUE SPACES.        
          05 FILLER                      PIC X(35) VALUE                
             'CSR INTERFACE TO EBS POWERPLANT'.                         
          05 FILLER                      PIC X(22) VALUE SPACES.        
      *                                                                 01190002
       01 WS-HEADER-3.                                                  
          05 FILLER                      PIC X(21) VALUE SPACES.        
          05 FILLER                      PIC X(39) VALUE                
             'TRANSACTION REPORT (CSRS304  PCSS3041)'.                  
      *                                                                 01411050
       01 WS-HEADER-4.                                                  
          05 FILLER                  PIC X(66) VALUE SPACES.            
          05 FILLER                  PIC X(03) VALUE 'NBR'.             
          05 FILLER                  PIC X(06) VALUE SPACES.            
          05 FILLER                  PIC X(04) VALUE 'FEET'.            
      *                                                                 01411050
       01 WS-HEADER-5.                                                  
          05 FILLER                  PIC X(05) VALUE ' WORK'.           
          05 FILLER                  PIC X(06) VALUE SPACES.            
          05 FILLER                  PIC X(06) VALUE 'POSTED'.          
          05 FILLER                  PIC X(15) VALUE SPACES.            
          05 FILLER                  PIC X(02) VALUE 'GL'.              
          05 FILLER                  PIC X(05) VALUE SPACES.            
          05 FILLER                  PIC X(07) VALUE 'UTILITY'.         
          05 FILLER                  PIC X(01) VALUE SPACES.            
          05 FILLER                  PIC X(07) VALUE 'EXT RET'.         
          05 FILLER                  PIC X(01) VALUE SPACES.            
          05 FILLER                  PIC X(07) VALUE 'VINTAGE'.         
          05 FILLER                  PIC X(02) VALUE SPACES.            
          05 FILLER                  PIC X(07) VALUE 'OF SERV'.         
          05 FILLER                  PIC X(05) VALUE SPACES.            
          05 FILLER                  PIC X(02) VALUE 'OF'.              
      *                                                                         
       01 WS-HEADER-6.                                                  
          05 FILLER                  PIC X(06) VALUE ' ORDER'.          
          05 FILLER                  PIC X(06) VALUE SPACES.            
          05 FILLER                  PIC X(04) VALUE 'DATE'.            
          05 FILLER                  PIC X(04) VALUE SPACES.            
          05 FILLER                  PIC X(07) VALUE 'WO NBR.'.         
          05 FILLER                  PIC X(03) VALUE SPACES.            
          05 FILLER                  PIC X(07) VALUE 'ACCOUNT'.         
          05 FILLER                  PIC X(02) VALUE SPACES.            
          05 FILLER                  PIC X(07) VALUE 'ACCOUNT'.         
          05 FILLER                  PIC X(01) VALUE SPACES.            
          05 FILLER                  PIC X(07) VALUE 'UNIT ID'.         
          05 FILLER                  PIC X(02) VALUE SPACES.            
          05 FILLER                  PIC X(04) VALUE 'YEAR'.            
          05 FILLER                  PIC X(05) VALUE SPACES.            
          05 FILLER                  PIC X(05) VALUE 'TALLY'.           
          05 FILLER                  PIC X(05) VALUE SPACES.            
          05 FILLER                  PIC X(04) VALUE 'PIPE'.            
      *                                                                 01421002
       01 WS-HEADER-SPACES.                                             
          05 FILLER                      PIC X(80) VALUE SPACES.        
      *                                                                 01421002
       01 WS-HEADER-EQUALS.                                             
          05 FILLER                      PIC X(40) VALUE                
             '========================================'.                
          05 FILLER                      PIC X(40) VALUE                
             '========================================'.                
      *                                                                 01421002
       01 WS-DETAIL-1.                                                  
          05 WS-WORK-ORDER-NO            PIC X(08).                     
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-TRANS-MM                 PIC 99.                        
          05 FILLER                      PIC X(1)  VALUE '/'.           
          05 WS-TRANS-DD                 PIC 99.                        
          05 FILLER                      PIC X(1)  VALUE '/'.           
          05 WS-TRANS-YY                 PIC 99.                        
          05 FILLER                      PIC X(02) VALUE SPACES.        
          05 WS-PWRPLT-WO-NBR            PIC X(06).                     
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-GL-ACCOUNT               PIC X(07).                     
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-UTIL-ACCOUNT             PIC X(04).                     
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-EXT-RET-UNIT-ID          PIC X(05).                     
          05 FILLER                      PIC X(03) VALUE SPACES.        
          05 WS-VINTAGE-YEAR             PIC ZZZZ.                      
          05 FILLER                      PIC X(04) VALUE SPACES.        
          05 WS-DET-SERV-TALLY           PIC --9.                       
          05 FILLER                      PIC X(06) VALUE SPACES.        
          05 WS-DET-FEET-PIPE            PIC -----9.                    
      *                                                                 01850002
       01 WS-FOOTER-1.                                                  
          05 FILLER                  PIC X(55)  VALUE SPACES.           
          05 FILLER                  PIC X(05)  VALUE 'TOTAL'.          
          05 FILLER                  PIC X(03)  VALUE SPACES.           
          05 WS-FOOTER-TALLY         PIC ---9   VALUE ZEROS.            
          05 FILLER                  PIC X(06)  VALUE SPACES.           
          05 WS-FOOTER-PIPE          PIC -----9 VALUE ZEROS.            
      *                                                                         
       01 WS-NO-DATA-LINE.                                              
          05  FILLER                     PIC X(29) VALUE SPACES.        
          05  FILLER                     PIC X(22) VALUE                
                    '** NO DATA THIS RUN **'.                           
          05  FILLER                     PIC X(29) VALUE SPACES.        
      *                                                                 01910002
       01  WS-END                        PIC X(38) VALUE                
           'WORKING STORAGE FOR PPRPT03 ENDS HERE'.                     
      *                                                                 02175007
       COPY CWS00010.                                                   02391002
       COPY CWS09900.                                                   02392002
      *                                                                 02394002
       PROCEDURE DIVISION.                                              
      ******************************************************************02410002
      *       CONTROLS THE MAIN PROCESSING OF THE PROGRAM.             *02420002
      ******************************************************************02430002
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE.                                     
      *                                                                 02460002
           MOVE ZEROS                      TO WS-RPT1-LINE-NO.          
      *                                                                 02520002
           PERFORM 0020-READ-CSR2EBS THRU 0020-EXIT.                    
           IF END-OF-CSR2EBS                                            
              PERFORM 8000-PRINT-HEADER    THRU 8000-EXIT               
              MOVE SPACES                  TO PRNTFILE-DATA             
              WRITE PRNTFILE-RECORD                                     
                    AFTER ADVANCING 1 LINE                              
              MOVE WS-NO-DATA-LINE         TO PRNTFILE-DATA             
              WRITE PRNTFILE-RECORD                                     
                    AFTER ADVANCING 1 LINE                              
           END-IF.                                                      
      *                                                                 02640002
           PERFORM UNTIL END-OF-CSR2EBS                                 
              PERFORM 2000-PROCESS-ACCT    THRU 2000-EXIT               
           END-PERFORM.                                                 
      *                                                                 02690002
           PERFORM 9000-TERMINATE      THRU 9000-EXIT.                  
           STOP RUN.                                                    
      *                                                                 02720002
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02740137
      *  READ THE INPUT FILE                                            02740137
      ******************************************************************02740137
      *                                                                 02740137
       0020-READ-CSR2EBS.                                               
           READ CSR2EBS-FILE AT END                                     
               GO TO 0020-EXIT.                                         
      *                                                                 02740637
           IF 2EBS-SUCCESSFUL                                           
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSSO304 *********************'    
               DISPLAY '** 0020-READ-CSR2EBS             '              
               DISPLAY '** ERROR READING CSR2EBS'                       
               DISPLAY '** FILE STATUS = ' WS-2EBS-STATUS               
               DISPLAY '************* PCSSO304 **********************'  
               MOVE 12                 TO RETURN-CODE                   
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 02742764
                                                                        
       0020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02750002
      *                                                                *02760002
      *      OPEN OUTPUT FILE PRNTFILE.                                *02770002
      *                                                                *02780002
      ******************************************************************02790002
       0100-INITIALIZE.                                                 
           OPEN INPUT  CSR2EBS-FILE.                                    
           OPEN OUTPUT PRNTFILE.                                        
      *                                                                 02870002
           PERFORM 0110-GET-CURR-DATE      THRU 0110-EXIT.              
      *                                                                 02940002
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02970002
      ******************************************************************02982002
      *                                                                *02990002
      *       0110-GET-CURR-DATE.                                      *03000002
      *                                                                *03010002
      ******************************************************************03020002
       0110-GET-CURR-DATE.                                              
                                                                        
      * GET CURRENT DATE                                                        
           ACCEPT WS-CURRENT-DATE          FROM DATE.                   
           MOVE   WS-CURRENT-YY            TO   WS-RPRT-DATE-YY.        
           MOVE   WS-CURRENT-MM            TO   WS-RPRT-DATE-MM.        
           MOVE   WS-CURRENT-DD            TO   WS-RPRT-DATE-DD.        
                                                                        
      *                                                                 03290002
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03320002
      ******************************************************************03899464
      *                                                                *03900002
      *       2000-PROCESS-ACCT                                        *03910002
      *                                                                *03920002
      ******************************************************************03930002
       2000-PROCESS-ACCT.                                               
      *                                                                 04030002
           MOVE WORK-ORDER-NO                 TO WS-WORK-ORDER-NO.      
           MOVE COMPLETION-DT(3:2)            TO WS-TRANS-YY.           
           MOVE COMPLETION-DT(5:2)            TO WS-TRANS-MM.           
           MOVE COMPLETION-DT(7:2)            TO WS-TRANS-DD.           
           MOVE POWER-PLT-WO                  TO WS-PWRPLT-WO-NBR.      
           MOVE GL-ACCOUNT-NO                 TO WS-GL-ACCOUNT.         
           MOVE GL-UTIL-ACCT-NO               TO WS-UTIL-ACCOUNT.       
           MOVE PIPE-TYPE-CD                  TO WS-EXT-RET-UNIT-ID.    
           MOVE VINTAGE-YEAR                  TO WS-VINTAGE-YEAR.       
                                                                        
           MOVE INSTALLED-COUNT               TO WS-INSTALLED-COUNT-N.  
           MOVE WS-INSTALLED-COUNT-N          TO WS-NO-OF-SERV-TALLY.   
                                                                        
           MOVE PIPE-LENGTH                   TO WS-PIPE-LENGTH-N.      
           MOVE WS-PIPE-LENGTH-N              TO WS-FEET-OF-PIPE.       
                                                                        
           IF REVERSE-N IS EQUAL TO 'N'                                 
             MULTIPLY  -1  BY   WS-NO-OF-SERV-TALLY                     
             MULTIPLY  -1  BY   WS-FEET-OF-PIPE                         
           END-IF.                                                      
                                                                        
           ADD WS-FEET-OF-PIPE             TO WS-TOTAL-PIPE.            
           ADD WS-NO-OF-SERV-TALLY         TO WS-TOTAL-TALLY.           
                                                                        
           MOVE WS-NO-OF-SERV-TALLY        TO WS-DET-SERV-TALLY.        
           MOVE WS-FEET-OF-PIPE            TO WS-DET-FEET-PIPE.         
                                                                        
           PERFORM 0020-READ-CSR2EBS THRU 0020-EXIT                     
      *                                                                 04049672
           PERFORM 8500-PRINT-DETAIL       THRU 8500-EXIT.              
           IF END-OF-CSR2EBS                                            
              MOVE WS-TOTAL-TALLY          TO   WS-FOOTER-TALLY         
              MOVE WS-TOTAL-PIPE           TO   WS-FOOTER-PIPE          
              PERFORM 8700-PRINT-FOOTER    THRU 8700-EXIT               
           END-IF.                                                      
      *                                                                 04050066
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04320002
      ***************************************************************** 05810002
      *                                                               * 05820002
      *            8000-PRINT-HEADER                                  * 05830002
      *             PRINTS THE REPORT HEADER                          * 05840002
      *                                                               * 05850002
      ***************************************************************** 05860002
       8000-PRINT-HEADER.                                               
           MOVE ZEROES                     TO WS-RPT1-LINE-NO.          
           ADD 1                           TO WS-RPT1-PAGE-NO.          
           MOVE WS-HEADER-SPACES           TO PRNTFILE-DATA             
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                 05920002
           MOVE WS-RPT1-PAGE-NO            TO WS-RPRT-PAGE-NO.          
           MOVE WS-HEADER-1                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 05920002
           MOVE WS-HEADER-2                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 05960002
           MOVE WS-HEADER-3                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06020002
           MOVE WS-HEADER-EQUALS           TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           MOVE WS-HEADER-4                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           MOVE WS-HEADER-5                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           MOVE WS-HEADER-6                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           MOVE WS-HEADER-EQUALS           TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06060002
           ADD 9                           TO WS-RPT1-LINE-NO.          
      *                                                                 06160002
       8000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 06190002
      *                                                               * 06200002
      *            8500-PRINT-DETAIL                                  * 06210002
      *   PRINTS DETAIL LINE                                          * 06220002
      *                                                               * 06230002
      ***************************************************************** 06240002
       8500-PRINT-DETAIL.                                               
      *                                                                         
           IF WS-RPT1-LINE-NO IS EQUAL TO ZEROS                         
              PERFORM 8000-PRINT-HEADER          THRU 8000-EXIT         
           END-IF.                                                      
      *                                                                 06543030
           MOVE WS-DETAIL-1            TO PRNTFILE-DATA.                
            WRITE PRNTFILE-RECORD                                       
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 06580002
           MOVE ZEROES                     TO PRNTFILE-DATA.            
           ADD 1                           TO WS-RPT1-LINE-NO.          
      *                                                                         
           IF WS-RPT1-LINE-NO NOT < WS-LINES-PER-PAGE                   
               MOVE ZEROS                      TO   WS-RPT1-LINE-NO     
           END-IF.                                                      
      *                                                                 06600002
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07020002
      ***************************************************************** 05810002
      *                                                               * 05820002
      *            8000-PRINT-FOOTER                                  * 05830002
      *             PRINTS THE REPORT FOOTER                          * 05840002
      *                                                               * 05850002
      ***************************************************************** 05860002
       8700-PRINT-FOOTER.                                               
           MOVE WS-HEADER-EQUALS           TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE WS-FOOTER-1                TO PRNTFILE-DATA.            
           WRITE PRNTFILE-RECORD                                        
                 AFTER ADVANCING 1 LINE.                                
      *                                                                 05920002
           ADD 2                           TO WS-RPT1-LINE-NO.          
      *                                                                 06160002
       8700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07030002
      *                                                                *07040002
      *       9000-TERMINATE                                           *07050002
      *                                                                *07060002
      ******************************************************************07070002
       9000-TERMINATE.                                                  
           CLOSE CSR2EBS-FILE.                                          
           CLOSE PRNTFILE.                                              
      *                                                                 07140002
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07300002
      ****************************************************************  07310002
      **    9900-ABEND                                              **  07320002
      ****************************************************************  07330002
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           MOVE 12                     TO RETURN-CODE.                  
           MOVE 'YES'                  TO WS-ABEND-SWITCH.              
       9900-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
      *                                                                 07420002
