       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSSO174.                                           
       DATE-WRITTEN.                                                    
       AUTHOR.  PADMA KONETI.                                           
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      ** CANCELS ARE SENT TO CLICK FOR ORDERS THAT IN IN PAYMENT     **         
      ** REQUIRED STATE AND SCHEDULED FOR THE NEXT DAY AND PAYMENT   **         
      ** HAS NOT COME IN YET.                                        **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
D10004*    06/20/16 PK44514   ORIGINAL VERSION                       **         
PRDFIX*    09/06/16 PK44514   FIX RUN DATE TO GET FROM CURRENT DATE  **         
PRDFIX*                       AND NOT COMMON DATE AS IT DOES NOT GET **         
PRDFIX*                       INCREMENTED ON HOLIDAYS.               **         
PRDFX1*    11/11/16 PK44514   CHECK FOR TASK_STATUS_CD = ' ' ALSO IN **         
PRDFX1*                       THE QUERY. WHEN CLICK CALL TIME OUTS   **         
PRDFX1*                       ORDER IS SCHLD BUT NOT UPDTD IN TABLE. **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSR00092.
MSQ002    05 ARG-5 PIC X(26).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO174'.
MSQ017     COPY MFASQLM.
                                                                        
*                                                                       
      *01 LOC-CSR00092   USAGE SQL TYPE IS                              
      *                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
      *01 LOC-CSR04747M   USAGE SQL TYPE IS                             
      *                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
       01  WS-MISC.                                                     
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-RETURN-CODE         PIC S9(9) COMP VALUE +0.          
           05  WS-PGRMNAME            PIC X(08) VALUE 'PCSSO174'.       
           05  WS-FETCH-ROWS          PIC 9(09) VALUE ZEROS.            
           05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
           05  WS-GET-COMMON-DATE     PIC X(01) VALUE SPACES.           
           05  WS-NEXT-DAY            PIC X(10) VALUE SPACES.           
           05  WS-RUN-DATE            PIC X(10) VALUE SPACES.           
           05  WS-COMMON-DATE         PIC X(10) VALUE SPACES.           
                                                                        
       01  WS-CSR04747-CALL-DATA.                                       
           05  SERV-ORDER-NO-4747       PIC X(13) VALUE SPACES.         
           05  PRIORITY-4747            PIC X(01) VALUE SPACES.         
           05  ACTION-CD-4747           PIC X(01) VALUE SPACES.         
           05  USER-ID-4747             PIC X(07) VALUE SPACES.         
           05  WORK-DISTRICT-4747       PIC X(40) VALUE SPACES.         
                                                                        
       01  WS-CSR04747-RETURN-DATA.                                     
           03  RETURN-CODE-4747         PIC S9(9) COMP VALUE 0.         
           03  WORK-DISTRICT-OUT-4747   PIC X(40) VALUE SPACES.         
                                                                        
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOODR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUPD                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTSKQUE                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOLOC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      **                                                                        
           EXEC SQL                                                     
             DECLARE PYMT_REQD_ORDERS CURSOR WITH HOLD  FOR  
                 SELECT DISTINCT(VO.SERV_ORDER_NO)                      
                       ,WORK_AREA_ID                                    
                   FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                   
                        CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)              
                  WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO             
                    AND VO.ORDER_STATE_CD = 'R'                         
                    AND (VI.TASK_STATUS_CD = 'S'                        
                     OR VI.TASK_STATUS_CD = ' ')                        
                    AND VI.WORK_TYPE_CD > ''                            
                    AND CAST(ASSIGNED_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )          
                                                                 
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE PYMT_REQD_ORDERS CURSOR WITH HOLD WITH RETURN FOR          
MFA-TR*          SELECT DISTINCT(VO.SERV_ORDER_NO)                              
MFA-TR*                ,WORK_AREA_ID                                            
MFA-TR*            FROM CSS_SO_DATA VO,                                         
MFA-TR*                 CSS_SO_ORDER_INST VI                                    
MFA-TR*           WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                     
MFA-TR*             AND VO.ORDER_STATE_CD = 'R'                                 
MFA-TR*             AND (VI.TASK_STATUS_CD = 'S'                                
MFA-TR*              OR VI.TASK_STATUS_CD = ' ')                                
MFA-TR*             AND VI.WORK_TYPE_CD > ''                                    
MFA-TR*             AND DATE(ASSIGNED_DATETIME) = :WS-RUN-DATE                  
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747M CURSOR
MSQ001          FOR CALL CSR04747 ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :WORK-DISTRICT-4747 OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR CURSOR
MSQ001          FOR CALL CSR00092 ( :VO-SERV-ORDER-NO
                  , '10'
                  , '2'
                  , 'SYSTEM'
                  , :MFA-CSR00092.ARG-5
                  , 'S109'
                  , 'YR'
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 7000-SELECT-JOB-PARM         THRU 7000-EXIT.         
           IF WS-GET-COMMON-DATE = 'Y'                                  
PRDFIX        PERFORM 7600-GET-RUN-DATE        THRU 7600-EXIT           
PRDFIX*       PERFORM 7050-GET-COMMON-DATE     THRU 7050-EXIT                   
PRDFIX*       PERFORM 7650-GET-RUN-DATE-COMMON THRU 7650-EXIT                   
           END-IF.                                                      
           PERFORM 1000-PROCESS-ORDERS          THRU 1000-EXIT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       1000-PROCESS-ORDERS.                                             
                                                                        
           EXEC SQL                                                     
               OPEN PYMT_REQD_ORDERS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '*****************************************'  
                   DISPLAY '** ERROR OPENING PYMT REQD ORDER CURSOR *'  
                   DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE           
                   DISPLAY '** PROCESSING TERMINATED                *'  
                   DISPLAY '*****************************************'  
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS        THRU 1100-EXIT                
           PERFORM UNTIL WS-FETCH-ROWS EQUAL NOT-FOUND                  
               PERFORM 2000-PROCESS-ROWS       THRU 2000-EXIT           
               PERFORM 1100-FETCH-ROWS        THRU 1100-EXIT            
           END-PERFORM.                                                 
                                                                        
           EXEC SQL                                                     
              CLOSE PYMT_REQD_ORDERS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '*****************************************'  
                   DISPLAY '** ERROR CLOSING PYMT REQD ORDERS CURSOR*'  
                   DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE           
                   DISPLAY '** PROCESSING TERMINATED                *'  
                   DISPLAY '*****************************************'  
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH PYMT_REQD_ORDERS                                    
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-WORK-AREA-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-ACTIVE-RETURN-CODE    TO WS-FETCH-ROWS       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '******************************************' 
                   DISPLAY '** ERROR FETCHING PYMT REQD ORDERS CURSOR*' 
                   DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE           
                   DISPLAY '** PROCESSING TERMINATED                 *' 
                   DISPLAY '******************************************' 
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-ROWS.                                               
           PERFORM 7400-CHECK-CAD-WKAREA        THRU 7400-EXIT.         
           IF C4-CAD-WORKAREA-FL = 'Y'                                  
              PERFORM 7100-SEND-CLICK-CANCEL    THRU 7100-EXIT          
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSSO174'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 1                                   
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SPACES TO WS-GET-COMMON-DATE                         
              MOVE G6-PARM-DATA(1:10) TO WS-RUN-DATE                    
              DISPLAY 'JOBPARM DATE: ' WS-RUN-DATE                      
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              MOVE 'Y' TO WS-GET-COMMON-DATE                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-GET-COMMON-DATE.                                          *        
      *                                                                *        
      ******************************************************************        
       7050-GET-COMMON-DATE.                                            
                                                                        
           MOVE '7050'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE 'COMMON'                 TO G6-PROGRAM-NAME             
           MOVE 'DATE'                       TO G6-CMND-CODE            
           MOVE '01'                         TO G6-COMPANY-NO           
           MOVE 'A'                          TO G6-STATUS               
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) G6.PARM_DATA                                     
                  INTO :G6-PARM-DATA                                    
                  FROM CSS_JOB_PARM G6                                  
                 WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME               
                   AND G6.CMND_CODE    = :G6-CMND-CODE                  
                   AND G6.COMPANY_NO   = :G6-COMPANY-NO                 
                   AND G6.STATUS       = :G6-STATUS                     
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT G6.PARM_DATA                                             
MFA-TR*           INTO :G6-PARM-DATA                                            
MFA-TR*           FROM CSS_JOB_PARM G6                                          
MFA-TR*          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                       
MFA-TR*            AND G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*            AND G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*            AND G6.STATUS       = :G6-STATUS                             
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE G6-PARM-DATA(10:10)           TO WS-COMMON-DATE     
               DISPLAY 'COMMON DATE: ' WS-COMMON-DATE                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7050-GET-COMMON-DATE             **'        
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM      **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
       7100-SEND-CLICK-CANCEL.                                          
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE VO-SERV-ORDER-NO              TO SERV-ORDER-NO-4747.    
           MOVE '1'                           TO PRIORITY-4747.         
           MOVE 'M'                           TO ACTION-CD-4747.        
           MOVE 'SYSTEM'                      TO USER-ID-4747.          
           MOVE SPACES                        TO WORK-DISTRICT-4747.    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04747 (:SERV-ORDER-NO-4747,                       
      *                      :PRIORITY-4747,                            
      *                      :ACTION-CD-4747,                           
      *                      :USER-ID-4747,                             
      *                      :WORK-DISTRICT-4747)                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747M
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747M
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747M INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              DISPLAY '************* PCSSO174 *******************'      
              DISPLAY '** 7100 :  RETURN CODE ERROR             '       
              DISPLAY '** 7100 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  NO RESULTSET RETURNED'                
              DISPLAY '************* PCSSO174 *******************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-CSR04747M)                                          
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747M CURSOR FOR RESULT SET           
      *       :LOC-CSR04747M                                            
      *    END-EXEC.                                                    
                                                                        
           INITIALIZE RETURN-CODE-4747                                  
                      WORK-DISTRICT-OUT-4747.                           
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747M INTO                               
                 :RETURN-CODE-4747,                                     
                 :WORK-DISTRICT-OUT-4747                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY 'SERV ORDER NO: ' SERV-ORDER-NO-4747              
           ELSE                                                         
              DISPLAY '************* PCSSO174 *******************'      
              DISPLAY '** 7100 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  FETCH FROM CSR04747 RESULTSET FAILED' 
              DISPLAY '************* PCSSO174 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              CLOSE RESULT_CSR_4747M                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-UPD-SO-DATA-PRINT.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
                 SET PRINTED_IND = 'N'                                  
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   DISPLAY 'SO NUMBER : ' VO-SERV-ORDER-NO              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATE SO DATA               *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-CHECK-CAD-WKAREA.                                           
                                                                        
           MOVE SPACES           TO C4-CAD-WORKAREA-FL.                 
           MOVE VO-WORK-AREA-ID  TO C4-WORK-AREA-ID.                    
                                                                        
           EXEC SQL                                                     
              SELECT CAD_WORKAREA_FL                                    
                INTO :C4-CAD-WORKAREA-FL                                
                FROM CSS_SO_PRINT_LOC                                   
              WHERE WORK_AREA_ID =  :C4-WORK-AREA-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT SO PRINT LOC          *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  WORK AREA = ' C4-WORK-AREA-ID           
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************18100000
      * 7600-GET-RUN-DATE.                                             *18110000
      *      SELECT THE NEXT DAY'S DATE FROM CURRENT DATE              *18120000
      ******************************************************************18140000
       7600-GET-RUN-DATE.                                               
      *                                                                 18160000
           EXEC SQL                                                     
                  SELECT
              DATEADD( DAY, 1, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-RUN-DATE           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     18170000
MFA-TR*           SET :WS-RUN-DATE     = CURRENT DATE + 1 DAY           18180000
MFA-TR*    END-EXEC.                                                    18220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   DISPLAY 'RUN DATE: ' WS-RUN-DATE                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR GET NEXT DAYS  DATE          *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
      *                                                                 18390000
       7600-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************18100000
      * 7650-GET-RUN-DATE.                                             *18110000
      *      SELECT THE RUN DATE FROM COMMON DATE WHICH IS NEXT DAY    *18120000
      ******************************************************************18140000
       7650-GET-RUN-DATE-COMMON.                                        
      *                                                                 18160000
           EXEC SQL                                                     
                  SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-RUN-DATE   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     18170000
MFA-TR*           SET :WS-RUN-DATE    = DATE(:WS-COMMON-DATE) + 1 DAY   18180000
MFA-TR*    END-EXEC.                                                    18220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   DISPLAY 'RUN DATE: ' WS-RUN-DATE                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR 7650-GET-RUN-DATE            *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
      *                                                                 18390000
       7650-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7620-UPDATE-SO-STATUS.                                           

MSQ002     EXEC SQL
MSQ002         SELECT CIS.CURRENT$TIMESTAMP()
MSQ002           INTO :MFA-CSR00092.ARG-5
MSQ002     END-EXEC
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00092 (:VO-SERV-ORDER-NO,                         
      *                      '10',                                      
      *                      '2',                                       
      *                      'SYSTEM',                                  
      *                      CURRENT TIMESTAMP,                         
      *                      'S109',                                    
      *                      'YR')                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              DISPLAY '************* PCSSO312 *******************'      
              DISPLAY '** 7620 :  RETURN CODE ERROR             '       
              DISPLAY '** 7620 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  NO RESULTSET RETURNED'                
              DISPLAY '************* PCSSO312 *******************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-CSR00092)                                           
      *       WITH PROCEDURE CSR00092                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR CURSOR FOR RESULT SET             
      *       :LOC-CSR00092                                             
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR INTO                                 
                 :WS-RETURN-CODE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* PCSSO174 *******************'      
              DISPLAY '** 7620 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  FETCH FROM CSR00092 RESULTSET FAILED' 
              DISPLAY '************* PCSSO311********************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              CLOSE RESULT_SET_CSR                                      
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO174 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
