       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSSO172.                                           
       DATE-WRITTEN.                                                    
       AUTHOR.  PADMA KONETI.                                           
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      ** CANCELS IN CLICK, LIGHT-MNT ORDERS THAT WERE SENT IN ERROR  **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
P00795*    10/27/15 PK44514   ORIGINAL VERSION                       **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO172'.
MSQ017     COPY MFASQLM.
                                                                        
*                                                                       
      *01 LOC-CSR00092   USAGE SQL TYPE IS                              
      *                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
      *01 LOC-CSR04747S   USAGE SQL TYPE IS                             
      *                  RESULT-SET-LOCATOR VARYING.                    
      *01 LOC-CSR04747M   USAGE SQL TYPE IS                             
      *                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
       01  WS-MISC.                                                     
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-RETURN-CODE         PIC S9(9) COMP VALUE +0.          
           05  WS-PGRMNAME            PIC X(08) VALUE 'PCSSO172'.       
           05  WS-FETCH-ROWS          PIC 9(09) VALUE ZEROS.            
           05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-Y                   PIC X(01) VALUE 'Y'.              
           05  WS-IS-CLICK-ORDER      PIC X(01) VALUE SPACES.           
                                                                        
       01  WS-CSR04747-CALL-DATA.                                       
           05  SERV-ORDER-NO-4747       PIC X(13) VALUE SPACES.         
           05  PRIORITY-4747            PIC X(01) VALUE SPACES.         
           05  ACTION-CD-4747           PIC X(01) VALUE SPACES.         
           05  USER-ID-4747             PIC X(07) VALUE SPACES.         
           05  WORK-DISTRICT-4747       PIC X(40) VALUE SPACES.         
                                                                        
       01  WS-CSR04747-RETURN-DATA.                                     
           03  RETURN-CODE-4747         PIC S9(9) COMP VALUE 0.         
           03  WORK-DISTRICT-OUT-4747   PIC X(40) VALUE SPACES.         
                                                                        
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOODR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOUPD                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTSKQUE                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSOLOC                                                 
           END-EXEC.                                                            
                                                                        
      **                                                                        
           EXEC SQL                                                     
             DECLARE LIGHT_MNT_ORDERS CURSOR WITH HOLD  FOR  
                 SELECT DISTINCT(VO.SERV_ORDER_NO)                      
                       ,COMPANY_NO                                      
                   FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                   
                        CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)              
                  WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO             
                    AND VO.ORDER_TYPE_CD = 'FW003'                      
                    AND VO.ORDER_STATE_CD = 'A'                         
                    AND VI.TASK_STATUS_CD = 'S'                         
                    AND VI.WORK_TYPE_CD > ''                            
                    AND EXISTS (SELECT 'Y' FROM CSS_SO_UPDATE VW
                           WITH(READUNCOMMITTED)        
                    WHERE VW.SERV_ORDER_NO = VO.SERV_ORDER_NO           
                    AND PANEL_NO = 'SST')                               
                                                                 
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE LIGHT_MNT_ORDERS CURSOR WITH HOLD WITH RETURN FOR          
MFA-TR*          SELECT DISTINCT(VO.SERV_ORDER_NO)                              
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*            FROM CSS_SO_DATA VO,                                         
MFA-TR*                 CSS_SO_ORDER_INST VI                                    
MFA-TR*           WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                     
MFA-TR*             AND VO.ORDER_TYPE_CD = 'FW003'                              
MFA-TR*             AND VO.ORDER_STATE_CD = 'A'                                 
MFA-TR*             AND VI.TASK_STATUS_CD = 'S'                                 
MFA-TR*             AND VI.WORK_TYPE_CD > ''                                    
MFA-TR*             AND EXISTS (SELECT 'Y' FROM CSS_SO_UPDATE VW                
MFA-TR*             WHERE VW.SERV_ORDER_NO = VO.SERV_ORDER_NO                   
MFA-TR*             AND PANEL_NO = 'SST')                                       
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747S CURSOR
MSQ001          FOR CALL CSR04747 ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :WORK-DISTRICT-4747 OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747M CURSOR
MSQ001          FOR CALL CSR04747 ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :WORK-DISTRICT-4747 OUTPUT
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-ORDERS          THRU 1000-EXIT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       1000-PROCESS-ORDERS.                                             
                                                                        
           EXEC SQL                                                     
               OPEN LIGHT_MNT_ORDERS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '*****************************************'  
                   DISPLAY '** ERROR OPENING LIGHT MNT ORDER CURSOR *'  
                   DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE           
                   DISPLAY '** PROCESSING TERMINATED                *'  
                   DISPLAY '*****************************************'  
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS        THRU 1100-EXIT                
           PERFORM UNTIL WS-FETCH-ROWS EQUAL NOT-FOUND                  
               PERFORM 2000-PROCESS-ROWS       THRU 2000-EXIT           
               PERFORM 1100-FETCH-ROWS        THRU 1100-EXIT            
           END-PERFORM.                                                 
                                                                        
           EXEC SQL                                                     
              CLOSE LIGHT_MNT_ORDERS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '*****************************************'  
                   DISPLAY '** ERROR CLOSING LIGHT MNT ORDERS CURSOR*'  
                   DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE           
                   DISPLAY '** PROCESSING TERMINATED                *'  
                   DISPLAY '*****************************************'  
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH LIGHT_MNT_ORDERS                                    
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-ACTIVE-RETURN-CODE    TO WS-FETCH-ROWS       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '******************************************' 
                   DISPLAY '** ERROR FETCHING LIGHT MNT ORDERS CURSOR*' 
                   DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE           
                   DISPLAY '** PROCESSING TERMINATED                 *' 
                   DISPLAY '******************************************' 
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-ROWS.                                               
           PERFORM 7000-CHECK-IF-CLICK            THRU 7000-EXIT.       
           IF WORK-DISTRICT-OUT-4747 <= SPACES                          
              PERFORM 7300-SELECT-SO-DATA          THRU 7300-EXIT       
              PERFORM 7400-CHECK-CAD-WKAREA        THRU 7400-EXIT       
              IF C4-CAD-WORKAREA-FL = 'Y'                               
                 PERFORM 7100-SEND-CLICK-CANCEL       THRU 7100-EXIT    
                 PERFORM 7200-UPD-SO-DATA-PRINT       THRU 7200-EXIT    
              ELSE                                                      
                 PERFORM 7500-UPD-SO-INST-TASK        THRU 7500-EXIT    
                 PERFORM 7550-INSERT-SO-TASK-QUEUE    THRU 7550-EXIT    
                 PERFORM 7200-UPD-SO-DATA-PRINT       THRU 7200-EXIT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7000-CHECK-IF-CLICK.                                             
                                                                        
           MOVE '7000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE VO-SERV-ORDER-NO              TO SERV-ORDER-NO-4747.    
           MOVE '1'                           TO PRIORITY-4747.         
           MOVE 'S'                           TO ACTION-CD-4747.        
           MOVE 'SYSTEM'                      TO USER-ID-4747.          
           MOVE SPACES                        TO WORK-DISTRICT-4747.    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04747 (:SERV-ORDER-NO-4747,                       
      *                      :PRIORITY-4747,                            
      *                      :ACTION-CD-4747,                           
      *                      :USER-ID-4747,                             
      *                      :WORK-DISTRICT-4747)                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747S
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747S
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747S INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              DISPLAY '************* PCSSO172 *******************'      
              DISPLAY '** 7000 :  RETURN CODE ERROR             '       
              DISPLAY '** 7000 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  NO RESULTSET RETURNED'                
              DISPLAY '************* PCSSO172 *******************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-CSR04747S)                                          
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747S CURSOR FOR RESULT SET           
      *       :LOC-CSR04747S                                            
      *    END-EXEC.                                                    
                                                                        
           INITIALIZE RETURN-CODE-4747                                  
                      WORK-DISTRICT-OUT-4747.                           
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747S INTO                               
                 :RETURN-CODE-4747,                                     
                 :WORK-DISTRICT-OUT-4747                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSSO172 *******************'      
              DISPLAY '** 7000 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  FETCH FROM CSR04747 RESULTSET FAILED' 
              DISPLAY '************* PCSSO172 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              CLOSE RESULT_CSR_4747S                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SEND-CLICK-CANCEL.                                          
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE VO-SERV-ORDER-NO              TO SERV-ORDER-NO-4747.    
           MOVE '1'                           TO PRIORITY-4747.         
           MOVE 'M'                           TO ACTION-CD-4747.        
           MOVE 'SYSTEM'                      TO USER-ID-4747.          
           MOVE SPACES                        TO WORK-DISTRICT-4747.    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04747 (:SERV-ORDER-NO-4747,                       
      *                      :PRIORITY-4747,                            
      *                      :ACTION-CD-4747,                           
      *                      :USER-ID-4747,                             
      *                      :WORK-DISTRICT-4747)                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747M
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747M
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747M INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              DISPLAY '************* PCSSO172 *******************'      
              DISPLAY '** 7100 :  RETURN CODE ERROR             '       
              DISPLAY '** 7100 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  NO RESULTSET RETURNED'                
              DISPLAY '************* PCSSO172 *******************'      
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-CSR04747M)                                          
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747M CURSOR FOR RESULT SET           
      *       :LOC-CSR04747M                                            
      *    END-EXEC.                                                    
                                                                        
           INITIALIZE RETURN-CODE-4747                                  
                      WORK-DISTRICT-OUT-4747.                           
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747M INTO                               
                 :RETURN-CODE-4747,                                     
                 :WORK-DISTRICT-OUT-4747                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************* PCSSO172 *******************'      
              DISPLAY '** 7100 :  RETURN CODE ERROR             '       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**      :  FETCH FROM CSR04747 RESULTSET FAILED' 
              DISPLAY '************* PCSSO172 *******************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              CLOSE RESULT_CSR_4747M                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-UPD-SO-DATA-PRINT.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
                 SET PRINTED_IND = 'N'                                  
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   DISPLAY 'SO NUMBER : ' VO-SERV-ORDER-NO              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATE SO DATA               *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-SO-DATA.                                             
                                                                        
           EXEC SQL                                                     
              SELECT WORK_AREA_ID,                                      
                     COMPANY_NO                                         
                INTO :VO-WORK-AREA-ID                                   
                    ,:VO-COMPANY-NO                                     
                FROM CSS_SO_DATA                                        
              WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT SO DATA               *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-CHECK-CAD-WKAREA.                                           
                                                                        
           MOVE SPACES           TO C4-CAD-WORKAREA-FL.                 
           MOVE VO-WORK-AREA-ID  TO C4-WORK-AREA-ID.                    
                                                                        
           EXEC SQL                                                     
              SELECT CAD_WORKAREA_FL                                    
                INTO :C4-CAD-WORKAREA-FL                                
                FROM CSS_SO_PRINT_LOC                                   
              WHERE WORK_AREA_ID =  :C4-WORK-AREA-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECT SO PRINT LOC          *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  WORK AREA = ' C4-WORK-AREA-ID           
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-UPD-SO-INST-TASK.                                           
                                                                        
           MOVE VO-SERV-ORDER-NO TO VI-SERV-ORDER-NO.                   
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_ORDER_INST                                  
                 SET TASK_STATUS_CD = 'C'                               
               WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                  
                 AND TASK_STATUS_CD = 'S'                               
                 AND WORK_TYPE_CD   > ' '                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR UPDATE SO ORDER INST         *'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7550-INSERT-SO-TASK-QUEUE.                                       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_TASK_QUEUE                            
                 (SERV_ORDER_NO,                                        
                  CREATED_TS,                                           
                  COMPANY_NO,                                           
                  TASK_PRIORITY,                                        
                  CREATED_BY_USER_ID,                                   
                  SO_BUSINESS_UNIT,                                     
                  CALL_ID,                                              
                  CALL_NUMBER)                                          
               VALUES                                                   
                  (:VO-SERV-ORDER-NO,                                   
                   CIS.CURRENT$TIMESTAMP(),                                   
                   :VO-COMPANY-NO,                                      
                   '1',                                                 
                   '',                                                  
                   '',                                                  
                   1,                                                   
                   1)                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_TASK_QUEUE                                    
MFA-TR*          (SERV_ORDER_NO,                                                
MFA-TR*           CREATED_TS,                                                   
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           TASK_PRIORITY,                                                
MFA-TR*           CREATED_BY_USER_ID,                                           
MFA-TR*           SO_BUSINESS_UNIT,                                             
MFA-TR*           CALL_ID,                                                      
MFA-TR*           CALL_NUMBER)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*           (:VO-SERV-ORDER-NO,                                           
MFA-TR*            CURRENT TIMESTAMP,                                           
MFA-TR*            :VO-COMPANY-NO,                                              
MFA-TR*            '1',                                                         
MFA-TR*            '',                                                          
MFA-TR*            '',                                                          
MFA-TR*            1,                                                           
MFA-TR*            1)                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR INSERT SO TASK QUEUE         *'   
                   DISPLAY '**  SO# = ' VO-SERV-ORDER-NO                
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
       7550-EXIT.                                                       
            EXIT.                                                       
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO172 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
