       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSSO170.                                          
       AUTHOR.       DAVID BOWDEN.                                      
       DATE-WRITTEN. JAN 2013.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM CREATES ROWS INTO CSS_BATCH_EMAIL WHEN        **        
      **   AN ONLINE ENROLLMENT FOLLOW-UP EMAIL NEEDS TO BE SENT TO   **        
      **   A CUSTOMER.                                                **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESSING CONTROL PATH        **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **                PROGRAM  MODIFICATION  LOG                    **        
      ******************************************************************        
      ** DATE     USER ID  REASON                                     **        
      ** -------  -------  ------                                     **        
      ** 01/30/13 DB18339  INITIAL IMPLEMENTATION FOR PROJ730.                  
A04753** 01/03/14 DB18339  CHANGED EMAIL_EVENT_DT TO USE COMMON-DATE.           
ACT070** 02/25/16 MC95456  USE NEXT VALUE FOR BATCH_EMAIL_ID          **        
ACT070** APPL5460          IN CSS_BATCH_EMAIL TABLE.                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO170'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *                                                                *        
      *             'WORKING STORAGE FOR PCSSO170 STARTS HERE'.        *        
      ******************************************************************        
                                                                        
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSSO170 STARTS HERE'.            
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
       01  WS-VARIABLES.                                                
           05  WS-NO                 PIC X(01) VALUE 'N'.               
           05  WS-YES                PIC X(01) VALUE 'Y'.               
           05  WS-WORK-DATE          PIC X(10) VALUE SPACES.            
           05  WS-EVENT-CD           PIC X(05) VALUE 'CIS01'.           
           05  WS-EVENT-DT           PIC X(10) VALUE SPACES.            
           05  WS-PROCESSED-CD       PIC X(01).                         
           05  WS-PROCESSED-DATE     PIC X(10) VALUE SPACES.            
           05  WS-PGRMNAME           PIC X(08) VALUE 'PCSSO170'.        
           05  WS-DISPLAY-SQLCODE    PIC -(8)9.                         
           05  WS-COMMIT-COUNT       PIC S9(09) COMP VALUE 0.           
           05  WS-NULL-IND-01        PIC S9(4)  COMP VALUE 0.           
           05  WS-FOLLOW-UP-DT       PIC X(10) VALUE SPACES.            
           05  WS-FOLLOW-UP-DAYS     PIC S9(4)V COMP-3 VALUE 0.         
           05  WS-PROMO-OFFER-DT     PIC X(10) VALUE SPACES.            
           05  WS-CHECK-EMAIL-EXISTS PIC X(01) VALUE 'N'.               
           05  WS-ONLINE-ENROLLED    PIC X(01) VALUE 'N'.               
           05  WS-NEXT-RUN-DATA.                                        
             10 WS-NEXT-RUN            PIC X(09) VALUE 'RUN DATE='.     
             10 WS-NEXT-RUN-DT         PIC X(10).                       
             10 FILLER                 PIC X(61) VALUE SPACES.          
      *    05  WS-GUID-LINK.                                                    
      *      10 FILLER             PIC X(40) VALUE                              
      *        'https://secure.sceg.com/ecs/ecsRegister/'.                      
      *      10 FILLER             PIC X(25) VALUE                              
      *        'RegisterNewUser.aspx?ID=%'.                                     
      *      10 REMINDER-GUID      PIC X(32).                                   
      *      10 FILLER             PIC X(23) VALUE                              
      *        '&PromoCode=OnlineEnroll'.                                       
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-END-SVC-CUR-SW           PIC X(1) VALUE 'N'.          
               88  WS-END-SVC-CUR          VALUE 'Y'.                   
               88  WS-NOT-END-SVC-CUR      VALUE 'N'.                   
           05  WS-FETCH-SUCCESS-SW         PIC X(1) VALUE 'N'.          
               88  WS-FETCH-SUCCESS        VALUE 'Y'.                   
               88  WS-FETCH-NOT-SUCCESS    VALUE 'N'.                   
       01  WS-FOLLOW-UP-DATETIME     PIC X(26).                         
       01  WS-FOLLOW-UP-TS       REDEFINES WS-FOLLOW-UP-DATETIME.       
                05  WS-FOLLOW-UP-DATE1        PIC X(10).                
                05  WS-FOLLOW-UP-DATE2        PIC X(16).                
                                                                        
      /*****   SQL WORK VARIABLES.                                              
       COPY CWS00303.                                                           
                                                                        
      /*****   WS AREA FOR ABEND SWITCH.                                        
       COPY CWS09900.                                                           
                                                                        
      /*****   WS AREA FOR ABEND WORK.                                          
       COPY CWS00010.                                                           
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSSO170 START HERE '.               
      ******************************************************************        
      **                                                              **        
      **  TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS     **        
      **  (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM     **        
      **  WILL ALWAYS BE SQLCA.                                       **        
      **                                                              **        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM - G6                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUSTOMER - CU                                        *           
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUST_STATS - CE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCSTSTS                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BATCH_EMAIL - AE                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBEMAIL                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BTCH_EMAIL_DET - JK                                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBTEDET                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SERVICE_PROMO - 3A                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBSERPRM                                                 
           END-EXEC.                                                            
                                                                        
      *CURSOR TO EXTRACT THE SERVICE PROMO INVITATIONS                          
           EXEC SQL                                                     
              DECLARE SVC_PROMO_CUR CURSOR WITH HOLD FOR                
                SELECT [3A].ACCOUNT_NO                                    
                      ,[3A].CUSTOMER_NO                                   
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [3A].PROMO_OFFERED_TS, 121), ' ', '-'), ':', '.') 
           PROMO_OFFERED_TS                              
                      ,[3A].PROMO_ACTIVATE_ID                             
                      ,LTRIM(RTRIM([3A].PROMO_EMAIL_ADDR))                      
                      ,CU.COMPANY_NO_ORIG                               
                FROM CSS_SERVICE_PROMO [3A] WITH(READUNCOMMITTED)               
                INNER JOIN CSS_CUSTOMER CU WITH(READUNCOMMITTED)                
                ON [3A].CUSTOMER_NO = CU.CUSTOMER_NO                      
                WHERE                                                   
                        PROMO_OFFERED_SERV = 'PROMO_ONLINE_ENROLL'      
                    AND PROMO_CHOICE_CD = 'Y'                           
                    AND PROMO_STATUS_CD in ('A','E')                    
                    AND PROMO_REGISTER_FL = ' '                         
                    AND REMINDER_SENT_FL = ' '                          
                    AND PROMO_OFFERED_TS <= CIS.CHAR2TIMESTAMP(
                                                 :WS-FOLLOW-UP-DATETIME
              )      
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SVC_PROMO_CUR CURSOR WITH HOLD FOR                        
MFA-TR*         SELECT 3A.ACCOUNT_NO                                            
MFA-TR*               ,3A.CUSTOMER_NO                                           
MFA-TR*               ,3A.PROMO_OFFERED_TS                                      
MFA-TR*               ,3A.PROMO_ACTIVATE_ID                                     
MFA-TR*               ,STRIP(3A.PROMO_EMAIL_ADDR)                               
MFA-TR*               ,CU.COMPANY_NO_ORIG                                       
MFA-TR*         FROM CSS_SERVICE_PROMO 3A                                       
MFA-TR*         INNER JOIN CSS_CUSTOMER CU                                      
MFA-TR*         ON 3A.CUSTOMER_NO = CU.CUSTOMER_NO                              
MFA-TR*         WHERE                                                           
MFA-TR*                 PROMO_OFFERED_SERV = 'PROMO_ONLINE_ENROLL'              
MFA-TR*             AND PROMO_CHOICE_CD = 'Y'                                   
MFA-TR*             AND PROMO_STATUS_CD in ('A','E')                            
MFA-TR*             AND PROMO_REGISTER_FL = ' '                                 
MFA-TR*             AND REMINDER_SENT_FL = ' '                                  
MFA-TR*             AND PROMO_OFFERED_TS <= :WS-FOLLOW-UP-DATETIME              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **          
      ****************************************************************          
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION  THRU 0100-EXIT.                 
           PERFORM 2000-PROCESS-PROMOS  THRU 2000-EXIT                  
             UNTIL WS-END-SVC-CUR.                                      
           PERFORM 7020-CLOSE-SVC-PROMO THRU 7020-EXIT.                 
           PERFORM 8900-UPDATE-RUN-DATE THRU 8900-EXIT.                 
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      ****************************************************************          
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSSO170 PROCESSING              **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '******************************************'.        
                                                                        
           PERFORM 1000-INITIALIZE-DATES.                               
           PERFORM 7000-OPEN-SVC-PROMO THRU 7000-EXIT.                  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  1000-INITIALIZE-DATES                                     **          
      ****************************************************************          
       1000-INITIALIZE-DATES.                                           
                                                                        
           PERFORM 7500-GET-WORK-DATE  THRU 7500-EXIT.                  
           PERFORM 7300-GET-FOLLOW-UP-DAYS THRU 7300-EXIT.              
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -:WS-FOLLOW-UP-DAYS, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) )
            INTO
              :WS-FOLLOW-UP-DT         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-FOLLOW-UP-DT =                                            
MFA-TR*           DATE(:WS-WORK-DATE) - :WS-FOLLOW-UP-DAYS DAYS                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-FOLLOW-UP-DT TO WS-FOLLOW-UP-DATE1.                  
           MOVE '-23.59.59.000000' TO WS-FOLLOW-UP-DATE2.               
                                                                        
A04753     PERFORM 7550-GET-COMMON-DATE THRU 7550-EXIT.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  2000-PROCESS-PROMOS                                       **          
      **      GETS THE ACTIVE PROMOTION ROWS AND WRITES TO BATCH    **          
      **      EMAIL TABLE                                           **          
      ****************************************************************          
       2000-PROCESS-PROMOS.                                             
                                                                        
           PERFORM 7010-FETCH-SVC-PROMO         THRU 7010-EXIT.         
           IF WS-FETCH-SUCCESS                                          
              PERFORM 7400-CHECK-ONLINE-ENROLLED THRU 7400-EXIT         
              IF WS-ONLINE-ENROLLED = 'N'                               
                 MOVE 3A-PROMO-OFFERED-TS(1:10) TO WS-PROMO-OFFER-DT    
                 PERFORM 7600-CHECK-EMAIL-EXISTS THRU 7600-EXIT         
                 IF WS-CHECK-EMAIL-EXISTS = 'N'                         
ACT070              PERFORM 7700-SET-NEXT-VALUE       THRU 7700-EXIT    
                    PERFORM 8000-INSERT-BATCH-EMAIL   THRU 8000-EXIT    
                    PERFORM 2250-EMAIL-BATCH-DETAILS  THRU 2250-EXIT    
                    PERFORM 8600-UPDATE-REMIND-FL     THRU 8600-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  2250-EMAIL-BATCH-DETAILS                                  **          
      **      PROCESSES BATCH EMAIL VARIABLES FOR REMINDER EMAIL    **          
      ****************************************************************          
       2250-EMAIL-BATCH-DETAILS.                                        
                                                                        
           MOVE 'ALT-EMAIL' TO JK-FIELD-NAME-TX.                        
           MOVE SPACES TO JK-FIELD-VALUE-TX-TEXT.                       
           MOVE 3A-PROMO-EMAIL-ADDR-TEXT TO JK-FIELD-VALUE-TX-TEXT.     
           MOVE 3A-PROMO-EMAIL-ADDR-LEN TO JK-FIELD-VALUE-TX-LEN.       
      *    INSPECT 3A-PROMO-EMAIL-ADDR REPLACING ALL LOW-VALUES,                
      *    BY SPACES.                                                           
      *    INSPECT 3A-PROMO-EMAIL-ADDR REPLACING ALL HIGH-VALUES,               
      *    BY SPACES.                                                           
      *    MOVE LENGTH OF JK-FIELD-VALUE-TX-TEXT TO                             
      *                JK-FIELD-VALUE-TX-LEN.                                   
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
           MOVE 'GUID-LINK' TO JK-FIELD-NAME-TX.                        
           MOVE 3A-PROMO-ACTIVATE-ID TO JK-FIELD-VALUE-TX-TEXT.         
           MOVE 120 TO JK-FIELD-VALUE-TX-LEN.                           
           PERFORM 8100-INSERT-BATCH-EMAIL-DET THRU 8100-EXIT.          
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7000-OPEN-SVC-PROMO                                       **          
      **      OPEN THE MAIN CURSOR SVC_PROMO_CUR                    **          
      ****************************************************************          
                                                                        
       7000-OPEN-SVC-PROMO.                                             
                                                                        
           MOVE '7000' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
               OPEN SVC_PROMO_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       OPEN SVC_PROMO_CUR '                     
               DISPLAY '       7000-OPEN-SVC-PROMO '                    
               DISPLAY ' RETURN CODE    = ' WS-DISPLAY-SQLCODE          
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7010-FETCH-SVC-PROMO                                      **          
      **      FETCH THE PROMOTIONS FOR PROCESSING                   **          
      ****************************************************************          
                                                                        
       7010-FETCH-SVC-PROMO.                                            
                                                                        
           MOVE '7010' TO WS-ACTIVE-PARAGRAPH.                          
           MOVE SPACES TO 3A-PROMO-EMAIL-ADDR.                          
                                                                        
           EXEC SQL                                                     
               FETCH SVC_PROMO_CUR                                      
                INTO  :3A-ACCOUNT-NO                                    
                     ,:3A-CUSTOMER-NO                                   
                     ,:3A-PROMO-OFFERED-TS                              
                     ,:3A-PROMO-ACTIVATE-ID                             
                     ,:3A-PROMO-EMAIL-ADDR                              
                     ,:CU-COMPANY-NO-ORIG                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET WS-FETCH-SUCCESS TO TRUE                              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET WS-END-SVC-CUR TO TRUE                             
                 SET WS-FETCH-NOT-SUCCESS TO TRUE                       
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE       
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       FETCH SVC_PROMO_CUR '                  
                 DISPLAY '       7010-FETCH-ACCOUNT '                   
                 DISPLAY ' RETURN CODE    = ' WS-DISPLAY-SQLCODE        
                 DISPLAY ' ACCOUNT NO     = ' 3A-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7020-CLOSE-SVC-PROMO                                      **          
      **      CLOSE THE MAIN CURSOR SVC_PROMO_CUR                   **          
      ****************************************************************          
                                                                        
       7020-CLOSE-SVC-PROMO.                                            
                                                                        
           MOVE '7020' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
               CLOSE SVC_PROMO_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
                 MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE       
                 DISPLAY '*******************************************'  
                 DISPLAY '       ABENDING PROGRAM '                     
                 DISPLAY '       CLOSE SVC_PROMO_CUR '                  
                 DISPLAY '       7020-CLOSE-SVC-PROMO '                 
                 DISPLAY ' RETURN CODE    = ' WS-DISPLAY-SQLCODE        
                 DISPLAY ' ACCOUNT NO     = ' 3A-ACCOUNT-NO             
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7300-GET-FOLLOW-UP-DAYS                                       *08090000
      *       LOOKS UP CSS_DELINQUENCY TO SEE HOW MANY DAYS TO WAIT    *08100000
      *       BEFORE FOLLOW-UP EMAIL                                   *08100000
      ******************************************************************        
                                                                        
       7300-GET-FOLLOW-UP-DAYS.                                         
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DELINQ_VALUE                                     
                  INTO :WS-FOLLOW-UP-DAYS                               
                  FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                  WHERE DELINQ_CD = 'PROMO-FOLLOW-UP-DAYS'              
                                           
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*        SELECT  DELINQ_VALUE                                             
MFA-TR*           INTO :WS-FOLLOW-UP-DAYS                                       
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*           WHERE DELINQ_CD = 'PROMO-FOLLOW-UP-DAYS'                      
MFA-TR*        WITH UR FETCH FIRST 1 ROW ONLY                                   
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND)                
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 7300-GET-FOLLOW-UP-DAYS'    
              DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7400-CHECK-ONLINE-ENROLLED                                   *08090000
      *        CHECKS IF CUSTOMER HAS ENROLLED FOR AN ONLINE ACCOUNT   *08100000
      ******************************************************************        
                                                                        
       7400-CHECK-ONLINE-ENROLLED.                                      
                                                                        
           MOVE '7400'                     TO WS-ACTIVE-PARAGRAPH       
           MOVE 'N' TO WS-ONLINE-ENROLLED.                              
                                                                        
           EXEC SQL                                                     
              SELECT EBILL_REGISTER_IND                                 
                INTO :CE-EBILL-REGISTER-IND                             
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO       = :3A-CUSTOMER-NO                
                 AND CUSTOMER_TYPE     = 'C'                            
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*       SELECT EBILL_REGISTER_IND                                         
MFA-TR*         INTO :CE-EBILL-REGISTER-IND                                     
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO       = :3A-CUSTOMER-NO                        
MFA-TR*          AND CUSTOMER_TYPE     = 'C'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF CE-EBILL-REGISTER-IND EQUAL SPACES                     
                 MOVE 'N' TO WS-ONLINE-ENROLLED                         
              ELSE                                                      
                 MOVE CE-EBILL-REGISTER-IND TO WS-ONLINE-ENROLLED       
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'N' TO WS-ONLINE-ENROLLED                         
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE       
                 DISPLAY '***********************************'          
                 DISPLAY '**  PROCESSING ERROR             **'          
                 DISPLAY '**  PARAGRAPH = 7400-CHECK-ONLINE-ENROLLED'   
                 DISPLAY '**  RETURN CODE = ' WS-DISPLAY-SQLCODE        
                 DISPLAY '    CUSTOMER NO = ' 3A-CUSTOMER-NO            
                 DISPLAY '**  PROCESSING TERMINATED        **'          
                 DISPLAY '***********************************'          
                 PERFORM 9900-ABEND      THRU 9900-EXIT                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** SELECTS THE RUN DATE                                         **        
      ******************************************************************        
       7500-GET-WORK-DATE.                                              
                                                                        
           MOVE '7500'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM                                        
              WHERE PROGRAM_NAME = 'PCSSO170'                           
                AND COMPANY_NO   = '01'                                 
                AND CMND_CODE    = 'DATE'                               
                AND SEQ_NO       = 10                                   
                AND STATUS       = 'A'                                  
                AND CIS.SUBSTR3(PARM_DATA,1,9) = 'RUN DATE='                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PARM_DATA                                                   
MFA-TR*        INTO :G6-PARM-DATA                                               
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME = 'PCSSO170'                                   
MFA-TR*         AND COMPANY_NO   = '01'                                         
MFA-TR*         AND CMND_CODE    = 'DATE'                                       
MFA-TR*         AND SEQ_NO       = 10                                           
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*         AND SUBSTR(PARM_DATA,1,9) = 'RUN DATE='                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(10:10) TO WS-WORK-DATE                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  ERROR WHILE FETCHING RUN DATE     **'        
              DISPLAY '**  PLEASE ADD RUN DATE PARM          **'        
              DISPLAY '**  PARAGRAPH     = 7500-GET-WORK-DATE'          
              DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04753******************************************************************        
A04753** SELECTS THE COMMON DATE                                      **        
A04753******************************************************************        
A04753 7550-GET-COMMON-DATE.                                            
A04753                                                                  
A04753     MOVE '7550'                   TO WS-ACTIVE-PARAGRAPH         
A04753                                                                  
A04753     EXEC SQL                                                     
A04753       SELECT PARM_DATA                                           
A04753         INTO :G6-PARM-DATA                                       
A04753         FROM CSS_JOB_PARM                                        
A04753        WHERE PROGRAM_NAME = 'COMMON'                             
A04753          AND COMPANY_NO   = '01'                                 
A04753          AND CMND_CODE    = 'DATE'                               
A04753          AND SEQ_NO       = 10                                   
A04753          AND STATUS       = 'A'                                  
A04753                                                      
A04753     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PARM_DATA                                                   
MFA-TR*        INTO :G6-PARM-DATA                                               
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME = 'COMMON'                                     
MFA-TR*         AND COMPANY_NO   = '01'                                         
MFA-TR*         AND CMND_CODE    = 'DATE'                                       
MFA-TR*         AND SEQ_NO       = 10                                           
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04753                                                                  
A04753     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A04753                                                                  
A04753     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04753        MOVE G6-PARM-DATA(10:10) TO WS-EVENT-DT                   
A04753     ELSE                                                         
A04753        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
A04753        DISPLAY '***********************************'             
A04753        DISPLAY '**  ERROR WHILE FETCHING RUN DATE     **'        
A04753        DISPLAY '**  PLEASE ADD RUN DATE PARM          **'        
A04753        DISPLAY '**  PARAGRAPH     = 7550-GET-COMMON-DATE'        
A04753        DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
A04753        DISPLAY '***********************************'             
A04753        PERFORM 9900-ABEND      THRU 9900-EXIT                    
A04753     END-IF.                                                      
A04753                                                                  
A04753 7550-EXIT.                                                       
A04753     EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7600-CHECK-EMAIL-EXISTS                                      *08090000
      *        CHECKS IF EMAIL REMINDER EXISTS IN CSS_BATCH_EMAIL      *08100000
      ******************************************************************        
                                                                        
       7600-CHECK-EMAIL-EXISTS.                                         
                                                                        
           MOVE '7600'                     TO WS-ACTIVE-PARAGRAPH       
           MOVE 'N' TO WS-CHECK-EMAIL-EXISTS.                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
                  INTO :WS-CHECK-EMAIL-EXISTS                           
                  FROM CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                 
                  WHERE AE.ACCOUNT_NO = :3A-ACCOUNT-NO                  
                    AND AE.EMAIL_EVENT_CD = :WS-EVENT-CD                
                    AND AE.COMPANY_NO = :CU-COMPANY-NO-ORIG             
                    AND AE.EMAIL_EVENT_DT >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-PROMO-OFFER-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PROMO-OFFER-DT
              ) <> 0) OR (LEN(:WS-PROMO-OFFER-DT
              ) <> 10), CIS.CHAR2DATE(:WS-PROMO-OFFER-DT
              ), CONVERT(DATE, :WS-PROMO-OFFER-DT) )         
                                           
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*           INTO :WS-CHECK-EMAIL-EXISTS                                   
MFA-TR*           FROM CSS_BATCH_EMAIL AE                                       
MFA-TR*           WHERE AE.ACCOUNT_NO = :3A-ACCOUNT-NO                          
MFA-TR*             AND AE.EMAIL_EVENT_CD = :WS-EVENT-CD                        
MFA-TR*             AND AE.COMPANY_NO = :CU-COMPANY-NO-ORIG                     
MFA-TR*             AND AE.EMAIL_EVENT_DT >= :WS-PROMO-OFFER-DT                 
MFA-TR*        WITH UR FETCH FIRST 1 ROW ONLY                                   
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF (WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND)                
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH      = 7600-CHECK-EMAIL-EXISTS'    
              DISPLAY '**  RETURN CODE    = ' WS-DISPLAY-SQLCODE        
              DISPLAY '**  ACCOUNT NO     = ' 3A-ACCOUNT-NO             
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT070*****************************************************************         
ACT070* 7700-SET-NEXT-VALUE.                                          *         
ACT070*****************************************************************         
ACT070 7700-SET-NEXT-VALUE.                                             
      *                                                                         
ACT070     EXEC SQL                                                     
ACT070        SELECT
              NEXT VALUE FOR SEQ_AE_BATCH_EMAIL_ID
            INTO
              :AE-BATCH-EMAIL-ID
ACT070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :AE-BATCH-EMAIL-ID = NEXTVAL FOR SEQ_AE_BATCH_EMAIL_ID        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT070     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
ACT070     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT070        CONTINUE                                                  
ACT070     ELSE                                                         
ACT070        DISPLAY '***********************************'             
ACT070        DISPLAY '**  PROCESSING ERROR             **'             
ACT070        DISPLAY '**  PARAGRAPH    = 7700-SET-NEXT-VALUE    '      
ACT070        DISPLAY '**  SET CSS_BATCH_EMAIL'                         
ACT070        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
ACT070        DISPLAY '**  PROCESSING TERMINATED        **'             
ACT070        DISPLAY '***********************************'             
ACT070        PERFORM 9900-ABEND                THRU 9900-EXIT          
ACT070     END-IF.                                                      
                                                                        
      *                                                                         
ACT070 7700-EXIT.                                                       
ACT070     EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8000-INSERT-BATCH-EMAIL.                                     *08090000
      *        INSERTS ROWS INTO CSS_BATCH_EMAIL TABLE                 *08100000
      ******************************************************************        
       8000-INSERT-BATCH-EMAIL.                                         
                                                                        
           MOVE '8000'                     TO WS-ACTIVE-PARAGRAPH       
           ADD 1 TO WS-COMMIT-COUNT                                     
A04753*    MOVE WS-WORK-DATE TO WS-EVENT-DT                                     
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_BATCH_EMAIL                             
                       (ACCOUNT_NO                                      
                       ,CUSTOMER_NO                                     
                       ,EMAIL_EVENT_CD                                  
                       ,EMAIL_EVENT_DT                                  
ACT070                 ,BATCH_EMAIL_ID                                  
                       ,COMPANY_NO)                                     
                VALUES (:3A-ACCOUNT-NO                                  
                      ,:3A-CUSTOMER-NO                                  
                      ,:WS-EVENT-CD                                     
                      ,IIF(TRY_CONVERT(DATE, :WS-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-EVENT-DT
              ) <> 0) OR (LEN(:WS-EVENT-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-EVENT-DT
              ), CONVERT(DATE, :WS-EVENT-DT) )                                 
ACT070                ,:AE-BATCH-EMAIL-ID                               
                      ,:CU-COMPANY-NO-ORIG)                             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         INSERT INTO CSS_BATCH_EMAIL                             08190000
MFA-TR*                (ACCOUNT_NO                                      08200000
MFA-TR*                ,CUSTOMER_NO                                     08210000
MFA-TR*                ,EMAIL_EVENT_CD                                  08220000
MFA-TR*                ,EMAIL_EVENT_DT                                  08230000
MFA-TR*                ,BATCH_EMAIL_ID                                          
MFA-TR*                ,COMPANY_NO)                                     08240000
MFA-TR*         VALUES (:3A-ACCOUNT-NO                                          
MFA-TR*               ,:3A-CUSTOMER-NO                                          
MFA-TR*               ,:WS-EVENT-CD                                             
MFA-TR*               ,:WS-EVENT-DT                                             
MFA-TR*               ,:AE-BATCH-EMAIL-ID                                       
MFA-TR*               ,:CU-COMPANY-NO-ORIG)                                     
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      ALREADY-EXISTS                    
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR INSERTING CSS_BATCH_EMAIL   **'       
               DISPLAY '**  SQLCODE     = ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  ACCOUNT NO  = ' 3A-ACCOUNT-NO               
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND      THRU 9900-EXIT
           END-IF.                  
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) BATCH_EMAIL_ID                                   
                  INTO :AE-BATCH-EMAIL-ID                               
                  FROM CSS_BATCH_EMAIL WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO = :3A-ACCOUNT-NO                      
                   AND CUSTOMER_NO = :3A-CUSTOMER-NO                    
                   AND EMAIL_EVENT_CD = :WS-EVENT-CD                    
                   AND EMAIL_EVENT_DT = IIF(TRY_CONVERT(DATE, 
                                                           :WS-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-EVENT-DT
              ) <> 0) OR (LEN(:WS-EVENT-DT) <> 10), CIS.CHAR2DATE(
                                                           :WS-EVENT-DT
              ), CONVERT(DATE, :WS-EVENT-DT) )                    
                   AND COMPANY_NO = :CU-COMPANY-NO-ORIG                 
                                           
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*         SELECT BATCH_EMAIL_ID                                   08190000
MFA-TR*           INTO :AE-BATCH-EMAIL-ID                                       
MFA-TR*           FROM CSS_BATCH_EMAIL                                  08200000
MFA-TR*          WHERE ACCOUNT_NO = :3A-ACCOUNT-NO                      08250000
MFA-TR*            AND CUSTOMER_NO = :3A-CUSTOMER-NO                            
MFA-TR*            AND EMAIL_EVENT_CD = :WS-EVENT-CD                            
MFA-TR*            AND EMAIL_EVENT_DT = :WS-EVENT-DT                            
MFA-TR*            AND COMPANY_NO = :CU-COMPANY-NO-ORIG                 08300000
MFA-TR*          WITH UR FETCH FIRST 1 ROW ONLY                                 
MFA-TR*          QUERYNO 8000                                                   
MFA-TR*    END-EXEC                                                     08310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_BATCH_EMAIL   **'       
               DISPLAY '**  SQLCODE     = ' WS-DISPLAY-SQLCODE          
               DISPLAY '**  ACCOUNT NO  = ' 3A-ACCOUNT-NO               
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           IF WS-COMMIT-COUNT > 100                                     
               EXEC SQL                                                 
                   COMMIT                                               
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                               
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *   8100-INSERT-BATCH-EMAIL-DET.                                 *08090000
      *        INSERTS VARIABLES INTO CSS_BTCH_EMAIL_DET               *08100000
      ******************************************************************        
       8100-INSERT-BATCH-EMAIL-DET.                                     
                                                                        
           MOVE AE-BATCH-EMAIL-ID TO JK-BATCH-EMAIL-ID.                 
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_BTCH_EMAIL_DET                             
                    (BATCH_EMAIL_ID,                                    
                     FIELD_NAME_TX,                                     
                     FIELD_VALUE_TX)                                    
             VALUES                                                     
                    (:JK-BATCH-EMAIL-ID,                                
                     :JK-FIELD-NAME-TX,                                 
                     :JK-FIELD-VALUE-TX)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      ALREADY-EXISTS                    
               MOVE SPACES TO JK-FIELD-VALUE-TX-TEXT                    
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR INSERTING CSS_BTCH_EMAIL_DET *'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' 3A-ACCOUNT-NO                   
               DISPLAY '**  FIELD = ' JK-FIELD-NAME-TX                  
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *   8600-UPDATE-REMIND-FL.                                       *08090000
      *        UPDATES REMINDER FLAG IN CSS_SERVICE_PROMO              *08100000
      ****CURRENTLY POINTING TO WRONG FLAG - WAITING ON DCR*************08100000
      ******************************************************************        
       8600-UPDATE-REMIND-FL.                                           
                                                                        
           MOVE '8600'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_SERVICE_PROMO                                   
                SET REMINDER_SENT_FL = 'Y'                              
              WHERE CUSTOMER_NO  = :3A-CUSTOMER-NO                      
                AND ACCOUNT_NO   = :3A-ACCOUNT-NO                       
                AND PROMO_STATUS_CD = 'A'                               
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  ERROR WHILE UPDATING RUN DATE     **'        
              DISPLAY '**  PARAGRAPH     = 8600-UPDATE-REMIND-FL'       
              DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**  ACCOUNT NO    = ' 3A-ACCOUNT-NO              
              DISPLAY '**  CUSTOMER NO   = ' 3A-CUSTOMER-NO             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-UPDATE-RUN-DATE.                                            
                                                                        
           MOVE '8900'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) )
            INTO
              :WS-NEXT-RUN-DT                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NEXT-RUN-DT =                                             
MFA-TR*           DATE(:WS-WORK-DATE) + 1 DAYS                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-NEXT-RUN-DATA         TO G6-PARM-DATA.               
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_JOB_PARM                                        
                SET PARM_DATA = :G6-PARM-DATA                           
              WHERE PROGRAM_NAME = 'PCSSO170'                           
                AND COMPANY_NO   = '01'                                 
                AND CMND_CODE    = 'DATE'                               
                AND SEQ_NO       = 10                                   
                AND STATUS       = 'A'                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '***********************************'             
              DISPLAY '**  ERROR WHILE UPDATING RUN DATE     **'        
              DISPLAY '**  PARAGRAPH     = 8900-UPDATE-RUN-DATE'        
              DISPLAY '**  RETURN CODE   = ' WS-DISPLAY-SQLCODE         
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  9000-TERMINATE                                            **          
      **       PROGRAM WRAP UP                                      **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             DISPLAY '*******************************************'      
             DISPLAY '           PCSSO170 ENDING '                      
             DISPLAY '*******************************************'      
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  9700-PROCESS-ABEND.                                       **          
      ****************************************************************          
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
