       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSSO167.                                         
COB303 DATE-WRITTEN.  AUGUST, 2010.                                     
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  PROGRAM:  PCSSO167                                           *         
      *                                                               *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      * THIS PROGRAM WILL RUN TO CHECK THE VIRTUAL WQ'S LEFT IN DB2   *         
      * IF THERE ARE ANY WQ'S LEFT SEND A MAIL TO THE TEAM CONCERNED  *         
      *                                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
      *  08/14/10    KHM      PROGRAM ORIGINALLY CODED.               *         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT FCSSO167-FILE ASSIGN TO UT-S-FCSSO167                
                   FILE STATUS IS WS-FCSSO167-STATUS.                   
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSSO167-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
       01  FSO167.                                                      
         05  E-FSO167-REC.                                              
             10  E-FSO167-DAT              PIC X(80).                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO167'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                               *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_WQ_ITEMS_MF    - WF >                                           
           EXEC SQL                                                             
               INCLUDE TBWQITS                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * COBOL WORKING STORAGE COPY BOOKS                              *         
      *****************************************************************         
      * CONTAINS THE COBOL EQUATES NEEDED FOR USING THE                         
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
      *                                                                         
      ***********  DECLARATIONS OF ALL ABEND WS INFO ***************            
       COPY CWS00010.                                                           
       COPY CWS09900.                                                           
      **************************************************************            
                                                                        
       01  WS-REC-COUNT.                                                
           05 WS-WQ-COUNT             PIC S9(4) COMP.                   
           05 WS-WQ-COUNT-NUM         PIC 9999 VALUE 0000.              
           05 WS-WQ-COUNT-X REDEFINES WS-WQ-COUNT-NUM PIC X(4).         
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                   PIC X(01)     VALUE 'Y'.          
           05  WS-N                   PIC X(01)     VALUE 'N'.          
                                                                        
       01  MISC.                                                        
           05 WS-WQ-ABEND-LVL         PIC X(01) VALUE SPACES.           
           05 WS-1                    PIC 9(01) VALUE 1.                
           05 WS-H                    PIC X(01) VALUE 'H'.              
           05 WS-USER-ID-ASSGN        PIC X(07) VALUE 'WQ09999'.        
           05 WS-RETURN-CODE          PIC 9(01) VALUE 0.                
           05 RS-RETURN-CODE-DISP     PIC +Z(04) VALUE SPACES.          
           05 RS-RETURN-CODE          PIC S9(04) COMP VALUE ZEROS.      
                                                                        
           05  WS-FCSSO167-STATUS     PIC X(02) VALUE SPACES.           
                88 FCSSO167-SUCCESSFUL      VALUE '00'.                 
           05  WS-END-OF-SO167        PIC X VALUE 'N'.                  
                88 END-OF-SO167             VALUE 'Y'.                  
                                                                        
           05  WS-IN-REC.                                               
               08 WS-WQ-CNT              PIC 9(04) VALUE 0.             
               08 FILLER                 PIC X(76) VALUE SPACES.        
      *                                                                         
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      *                                                               *         
      *     0000-MAINLINE                                             *         
      *                                                               *         
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                     *         
      *                                                               *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-WQ-ITEMS      THRU 1000-EXIT.           
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  0100-INITIALIZATION ..                                     **         
      **       COMMON INITIALIZATION ROUTINE                         **         
      **                                                             **         
      *****************************************************************         
       0100-INITIALIZATION.                                             
           MOVE WS-USER-ID-ASSGN                TO WQ-USER-ID-ASGN.     
                                                                        
           OPEN I-O FCSSO167-FILE                                       
            IF NOT FCSSO167-SUCCESSFUL                                  
               DISPLAY '********** PCSSO167 ABORT  ************'        
               DISPLAY '**  0100-INITIALIZATION               *'        
               DISPLAY '**  ERROR OPENING FCSSO101            *'        
               DISPLAY '**  FILE STATUS = ' WS-FCSSO167-STATUS          
               DISPLAY '********** PCSSO167 ABORT  ************'        
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
            END-IF.                                                     
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1000-PROCESS-WQ-ITEMS.                                        *         
      *                                                               *         
      * PROCESS THE WQ COUNT AND SEND THE RETURN CODE TO SEND MAIL    *         
      * TO THE USERS IF THERE ARE ASSIGNED, IN PROGRESS WQ'S PRESENT. *         
      *                                                               *         
      *****************************************************************         
       1000-PROCESS-WQ-ITEMS.                                           
                                                                        
           PERFORM 7000-GET-WQ-COUNT               THRU 7000-EXIT.      
           EVALUATE TRUE                                                
               WHEN WS-WQ-COUNT = ZERO                                  
                   CONTINUE                                             
               WHEN WS-WQ-COUNT >= WS-1                                 
                   DISPLAY '**********PCSSO167***********************'  
                   DISPLAY '* THERE WERE VIRTUAL WQS                *'  
                   DISPLAY '* LEFT IN CSS_WQ_ITEMS WITH ASSIGNED    *'  
                   DISPLAY '* STATUS.PLEASE VERFIY THE WQS.         *'  
                   DISPLAY '* TOTAL NUMBER WQS = ' WS-WQ-COUNT          
                   DISPLAY '**********PCSSO167***********************'  
                   MOVE WS-H                       TO WS-WQ-ABEND-LVL   
                   PERFORM 7100-READ-INPUT               THRU 7100-EXIT 
                   PERFORM 1100-PROCESS-INPUT            THRU 1100-EXIT 
                           UNTIL END-OF-SO167                           
                                                                        
           END-EVALUATE.                                                
                                                                        
           IF WS-WQ-ABEND-LVL = WS-H                                    
              MOVE WS-1                          TO WS-RETURN-CODE      
              PERFORM 9800-HARD-ABEND            THRU 9800-EXIT         
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1100-PROCESS-INPUT.                                        *            
      *                                                               *         
      * PROCESS THE CONTENTS OF THE FILE TO DETERMINE WHERE TO INSERT *         
      * COUNT FOR SENDING MAIL.                                       *         
      *                                                               *         
      *****************************************************************         
       1100-PROCESS-INPUT.                                              
           MOVE WS-WQ-COUNT                      TO WS-WQ-COUNT-NUM.    
           MOVE E-FSO167-DAT                     TO WS-IN-REC.          
                                                                        
           IF WS-WQ-CNT NUMERIC                                         
              MOVE WS-WQ-COUNT-X         TO  WS-WQ-CNT                  
              MOVE WS-IN-REC TO E-FSO167-DAT                            
              PERFORM 8100-REWRITE-FCSSO167      THRU 8100-EXIT         
           ELSE                                                         
              CONTINUE                                                  
           END-IF.                                                      
                                                                        
           PERFORM 7100-READ-INPUT               THRU 7100-EXIT.        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7000-GET-WQ-COUNT.                                            *         
      *                                                               *         
      * RETRIEVES THE TOTAL NUMBER OF WQ'S PRESENT IN CSS_WQ_ITEMS.   *         
      *                                                               *         
      *****************************************************************         
       7000-GET-WQ-COUNT.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-WQ-COUNT                                      
                 FROM CSS_WQ_ITEMS WITH(READUNCOMMITTED)                        
                WHERE STATUS       IN ('A','I')                         
                  AND USER_ID_ASGN = :WQ-USER-ID-ASGN                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-WQ-COUNT                                              
MFA-TR*          FROM CSS_WQ_ITEMS                                              
MFA-TR*         WHERE STATUS       IN ('A','I')                                 
MFA-TR*           AND USER_ID_ASGN = :WQ-USER-ID-ASGN                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            RS-RETURN-CODE.             
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'PCSSO167'            TO ABEND-PROGRAM          
                   MOVE '7000'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_WQ_ITEMS'        TO TABLE-1                
                   MOVE 'WQ_USER_ID_ASSGN'    TO TABLE-ELEMENT-1        
                   MOVE  WQ-USER-ID-ASGN      TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-READ-INPUT.                                              *         
      * READS THE PAGE FILE TO DYNAMICALLY FEED THE WQ'S AND DATE     *         
      *****************************************************************         
       7100-READ-INPUT.                                                 
      *                                                                         
           INITIALIZE                               FSO167.             
            READ FCSSO167-FILE                                          
                AT END MOVE WS-Y TO WS-END-OF-SO167.                    
            IF FCSSO167-SUCCESSFUL OR END-OF-SO167                      
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '****************************************'      
                DISPLAY '**    PCSSO167 PROCESSING ERROR       **'      
                DISPLAY '**       ERROR READING FCSSO101       **'      
                DISPLAY '**    FILE STATUS = ' WS-FCSSO167-STATUS       
                DISPLAY '****************************************'      
                PERFORM 9000-TERMINATE THRU 9000-EXIT
            END-IF.                  
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-REWRITE-FCSSO167                                          *        
      * REWRITES BY ADDING COUNT AND DATE DETAILS                      *        
      ******************************************************************        
       8100-REWRITE-FCSSO167.                                           
                                                                        
           REWRITE FSO167.                                              
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   9000-TERMINATE                                           **          
      **   PROGRAM TERMINATION                                      **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSSO167-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************15309303
      *  9700-PROCESS-ABEND.                                           *15309304
      ******************************************************************15309305
           EXEC SQL                                                     15309306
               INCLUDE CPD0023B                                         15309307
           END-EXEC.                                                    15309308
                                                                        
HPCCDM*    EJECT                                                        PCS07970
      *****************************************************************         
      * 9800-HARD-ABEND                                               *         
      *                   SET THE RETURN CODE AND END.                *         
      *                                                               *         
      *****************************************************************         
       9800-HARD-ABEND.                                                 
                                                                        
           MOVE WS-RETURN-CODE  TO RETURN-CODE.                         
           DISPLAY 'PCSSO167 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************08140000
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE       *08150000
      * 9900-ABEND                                                     *        
      ******************************************************************08160000
           EXEC SQL                                                     08170000
               INCLUDE CPD09900                                         08180001
           END-EXEC.                                                    08190000
      ******************************************************************15309340
