       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSSO166.                                            
       DATE-WRITTEN. 05/21/08.                                          
       AUTHOR. PADMA KONETI.                                            
      ******************************************************************00050000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00060000
      *                                                                *00080000
      ******************************************************************00090000
      ******************************************************************00060002
      *                                                                *00070002
      *      PROGRAM MODIFICATION LOG                                  *00080002
      *                                                                *00090002
      *     DATE     USER ID  REASON                                   *00100002
      *   --------   -------  ---------------------------------------- *00110002
      *   05/21/08   PK98692  INITIAL CODING                           *00120002
      *   10/20/08   PK98692  CHANGES MADE TO INCLUDE POSTED ORDERS    *00120002
      *                       & NOT COMPLETED ORDERS IN THE FILES      *00120002
      *   12/18/08   PK98692  SCRAPPED MATERIALS TO BE INCLUDED IN     *00120002
      *                       MATERIALS INTERFACE DATA FILE            *00120002
      *   11/09/09   PK98692  TO UPDATE PROCESSED_DT FOR ABANDONED     *00120002
      *                       MATERIALS SO THE ARCHIVAL PROGRAM CAN    *00120002
      *                       MOVE THOSE ROWS IN CSS_SO_MATL_TRAN TO   *00120002
      *                       HST_SO_MATL_TRAN (ACT18341)              *00120002
A31802*    03/10/11  PK98692  CHANGES TO ERROR HANDLING AND ADDING     *00120002
      *                       COMMIT LOGIC                             *00120002
      ******************************************************************00130002
      * THIS PROGRAM GENERATES THE POWERPLANT INTERFACES - STATISTICAL *00140002
      * AND MATERIAL. IT PULLS THE GAS SERVICE DATA FROM THE           *00140002
      * SO_MATL_TRAN FOR MATERIAL POSTED SERVICES. IT ALSO PULLS OUT   *00140002
      * THE SCEG MATERIAL DATA FOR GAS SERVS ANS STORES IN A SEQ FILE  *00140002
      * PROGRAM WAS PREVIOUSLY NAMED PCSCV011, CHANGED ON 12/07        *00140002
      ******************************************************************00140002
      *                                                                 00140002
      *                                                                 00140002
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT PPSTATS-FILE ASSIGN TO PPSTATS                        
A31802            FILE STATUS IS WS-PPSTATS-STATUS.                     
           SELECT PPMATRL-FILE ASSIGN TO PPMATRL                        
A31802            FILE STATUS IS WS-PPMATRL-STATUS.                     
           SELECT SCEGMTL-FILE ASSIGN TO SCEGMTL                        
A31802            FILE STATUS IS WS-SCEGMTL-STATUS.                     
A31802*    SELECT XCEPTRPT-FILE ASSIGN TO XCEPTRPT.                             
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD PPSTATS-FILE.                                                 
       01 PPSTATS-REC                PIC X(98).                         
      *                                                                         
       FD PPMATRL-FILE.                                                 
       01 PPMATRL-REC                PIC X(148).                        
      *                                                                         
       FD SCEGMTL-FILE.                                                 
       01 SCEGMTL-REC                PIC X(90).                         
      *                                                                         
A31802*FD XCEPTRPT-FILE.                                                        
A31802*01 XCEPTRPT-REC               PIC X(98).                                 
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO166'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-PPSTATS-REC.                                              
           05 PS-POWER-PLT-WO           PIC X(6).                       
HEX01      05 PS-DLM-01                 PIC X(1) VALUE X'09'.           
           05 PS-PF-NO                  PIC X(15).                      
HEX01      05 PS-DLM-02                 PIC X(1) VALUE X'09'.           
           05 PS-GL-ACCOUNT-NO          PIC X(7).                       
HEX01      05 PS-DLM-03                 PIC X(1) VALUE X'09'.           
           05 PS-GL-UTIL-ACCT-NO        PIC X(6).                       
HEX01      05 PS-DLM-04                 PIC X(1) VALUE X'09'.           
           05 PS-CUSTOMER               PIC X(3).                       
HEX01      05 PS-DLM-05                 PIC X(1) VALUE X'09'.           
           05 PS-WORK-ORDER-NO          PIC X(8).                       
HEX01      05 PS-DLM-06                 PIC X(1) VALUE X'09'.           
           05 PS-COMPLETION-DT          PIC X(8).                       
HEX01      05 PS-DLM-07                 PIC X(1) VALUE X'09'.           
           05 PS-PIPE-TYPE-CD           PIC X(5).                       
HEX01      05 PS-DLM-08                 PIC X(1) VALUE X'09'.           
           05 PS-PIPE-LENGTH            PIC X(5).                       
HEX01      05 PS-DLM-09                 PIC X(1) VALUE X'09'.           
           05 PS-INSTALLED-COUNT        PIC X(3).                       
HEX01      05 PS-DLM-10                 PIC X(1) VALUE X'09'.           
           05 PS-NO-T-LINE              PIC X(10).                      
HEX01      05 PS-DLM-11                 PIC X(1) VALUE X'09'.           
           05 PS-VINTAGE-YEAR           PIC X(4).                       
HEX01      05 PS-DLM-12                 PIC X(1) VALUE X'09'.           
           05 PS-PREFIX-3               PIC X(1) VALUE '3'.             
           05 PS-COST-CENTER            PIC X(3).                       
HEX01      05 PS-DLM-13                 PIC X(1) VALUE X'09'.           
           05 PS-REVERSE-N              PIC X(1).                       
      *                                                                         
       01  WS-PPMATRL-REC.                                              
           05 PM-TRANSACTION-CD         PIC X(03).                      
           05 PM-IDENTIFIER-C           PIC X(01) VALUE ' '.            
           05 PM-FILLER-1               PIC X(05) VALUE SPACES.         
           05 PM-MATL-ITEM-CD           PIC X(10).                      
           05 PM-FILLER-2               PIC X(02) VALUE SPACES.         
           05 PM-TRANSACTION-DATE       PIC X(06).                      
           05 PM-FILLER-3               PIC X(03) VALUE SPACES.         
           05 PM-UOM                    PIC X(02).                      
           05 PM-MATL-QTY-SIGN          PIC X(01) VALUE '+'.            
           05 PM-MATL-ITEM-QTY          PIC X(06).                      
           05 PM-TOTAL-AMT-SIGN         PIC X(01) VALUE '+'.            
           05 PM-COST-PER-ITEM          PIC X(10) VALUE SPACES.         
           05 PM-WORK-ORDER-NO          PIC X(06).                      
           05 PM-COMPANY-NO             PIC X(02).                      
           05 PM-GL-ACCT-NO             PIC X(07).                      
           05 PM-FILLER-6               PIC X(01) VALUE '0'.            
           05 PM-RESOURCE-CD            PIC X(03).                      
           05 PM-FILLER-7               PIC X(01) VALUE '0'.            
           05 PM-FUNC-ACT-CD            PIC X(04).                      
           05 PM-FILLER-8               PIC X(01) VALUE SPACES.         
           05 PM-TEXT-DCI               PIC X(03) VALUE 'DCI'.          
           05 PM-SERVICE-ORDER-NO       PIC X(13).                      
           05 PM-FILLER-9               PIC X(04) VALUE SPACES.         
           05 PM-FILLER-10              PIC X(07) VALUE '0000000'.      
           05 PM-COST-CENTRE            PIC X(03).                      
           05 PM-FILLER-11              PIC X(25) VALUE SPACES.         
           05 PM-COUNTY-CODE            PIC X(03).                      
           05 PM-STATE-CODE             PIC X(02).                      
           05 PM-PREMISE-NO             PIC X(10).                      
           05 PM-STORE-ROOM-ID          PIC X(03).                      
      *                                                                         
A31802*01  WS-XCEPTRPT-REC              PIC X(98).                              
      *                                                                         
       01  WS-SCEGMTL-REC.                                              
           05 SM-SERVICE-ORDER-NO       PIC X(13).                      
           05 SM-FILLER                 PIC X(1).                       
           05 SM-COMP-UNIT-CD           PIC X(12).                      
           05 SM-FILLER                 PIC X(1).                       
           05 SM-CU-SEQ-NM              PIC 9(4).                       
           05 SM-FILLER                 PIC X(1).                       
           05 SM-MATL-USAGE-CD          PIC X(1).                       
           05 SM-FILLER                 PIC X(1).                       
           05 SM-MATL-ITEM-CD           PIC X(12).                      
           05 SM-FILLER                 PIC X(1).                       
           05 SM-WORK-ORDER-NM          PIC X(6).                       
           05 SM-FILLER                 PIC X(1).                       
           05 SM-GL-ACCT-NO             PIC 9(8).                       
           05 SM-FILLER                 PIC X(1).                       
           05 SM-FUNC-ACT-CD            PIC X(6).                       
           05 SM-FILLER                 PIC X(1).                       
           05 SM-POINT                  PIC 9(6).                       
           05 SM-FILLER                 PIC X(1).                       
           05 SM-SPAN-TO-POINT          PIC 9(6).                       
           05 SM-FILLER                 PIC X(6).                       
      *                                                                         
       01  WS-VARIABLES.                                                
           05 FIRST-TIME                 PIC X(1) VALUE 'N'.            
           05 END-OF-FETCH               PIC X(1) VALUE 'N'.            
           05 END-OF-MOP-FETCH           PIC X(1) VALUE 'N'.            
           05 OK-TO-PROCESS-ALL          PIC X(1) VALUE 'Y'.            
      *    05 WS-ORDER-PROCESSED-FL      PIC X(1) VALUE 'N'.                    
           05 WS-ORDER-PROCESSED-FL      PIC X(1) VALUE SPACES.         
           05 WS-SO-POSTED               PIC X(1) VALUE SPACES.         
           05 NO-MORE-SERV-NOS           PIC X(1) VALUE 'N'.            
           05 NO-MORE-MATL               PIC X(1) VALUE 'N'.            
           05 PROCESSED-DT-IND           PIC S9(4) COMP.                
           05 SO-POSTED-DT-IND           PIC S9(4) COMP.                
           05 WS-START-DATE              PIC X(10).                     
           05 WS-END-DATE                PIC X(10).                     
           05 WS-DATE-TEXT               PIC X(4)  VALUE 'DATE'.        
           05 WS-PIPE-TYPE-CD            PIC X(5)  VALUE SPACES.        
           05 WS-GL-ACCOUNT-NO           PIC X(7)  VALUE SPACES.        
           05 WS-GL-UTIL-ACCT-NO         PIC X(4)  VALUE SPACES.        
           05 WS-PARM-DATA               PIC X(80) VALUE SPACES.        
           05 WS-TEMP-SO-NO              PIC X(12) VALUE SPACES.        
           05 WS-SERV-ORDER-NO           PIC X(13) VALUE SPACES.        
           05 WS-PP-PIPE-LENGTH          PIC X(9)  VALUE SPACES.        
COB305     05 WS-XX-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-WU-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
           05 WS-WU-FUNC-ACT-CD          PIC X(4)  VALUE SPACES.        
           05 WS-WU-MATL-ITEM-QT         PIC X(9)  VALUE SPACES.        
           05 WS-WU-MATL-ITEM-TOT-AM     PIC 9(7).9(2).                 
           05 WS-PR-PREMISE-NO           PIC X(10) VALUE SPACES.        
           05 WS-SM-POINT                PIC 9(6)  VALUE 0.             
           05 WS-SM-SPAN-TO-POINT        PIC 9(6)  VALUE 0.             
           05 WS-SM-GL-ACCT-NO           PIC 9(8)  VALUE 0.             
           05 WS-SM-CU-SEQ-NM            PIC 9(4)  VALUE 0.             
           05 WS-A9-STATE                PIC X(2)  VALUE SPACES.        
           05 WS-A9-COUNTY               PIC X(3)  VALUE SPACES.        
COB305     05 WS-XO-SERVICE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
           05 WS-RESOURCE-CD             PIC X(3)  VALUE SPACES.        
           05 WS-TRANSACTION-CODE        PIC X(03).                     
           05 WS-SERV-LINE-TYPE          PIC X(01).                     
           05 WS-SERV-LINE-SIZE          PIC X(03).                     
           05 WS-IDENTIFIER-C            PIC X(01) VALUE ' '.           
           05 COMP-DATE-IND              PIC S9(04) COMP VALUE +0.      
           05 WS-STUB-INSTALL-SW         PIC X(1)  VALUE 'N'.           
              88 WS-STUB-INSTALL                   VALUE 'Y'.           
           05 WS-REVERSED-SW             PIC X(1)  VALUE 'N'.           
              88 WS-REVERSED                       VALUE 'Y'.           
           05 WS-COMPLETED-DATE.                                        
              10 WS-COMPLETED-YEAR       PIC X(4).                      
              10 FILLER                  PIC X(1).                      
              10 WS-COMPLETED-MONTH      PIC X(2).                      
              10 FILLER                  PIC X(1).                      
              10 WS-COMPLETED-DAY        PIC X(2).                      
           05 WS-PP-COMP-DATE.                                          
              10 WS-PP-COMP-YEAR         PIC X(4).                      
              10 WS-PP-COMP-MONTH        PIC X(2).                      
              10 WS-PP-COMP-DAY          PIC X(2).                      
           05 WS-TODAYS-DATE             PIC X(10).                     
           05 WS-CURRENT-DATE.                                          
              10 WS-CURRENT-CC           PIC X(2).                      
              10 WS-CURRENT-YY           PIC X(2).                      
              10 FILLER                  PIC X(1).                      
              10 WS-CURRENT-MONTH        PIC X(2).                      
              10 FILLER                  PIC X(1).                      
              10 WS-CURRENT-DAY          PIC X(2).                      
           05 WS-MATL-IFACE-DATE.                                       
              10 WS-MI-CURR-MONTH        PIC X(2).                      
              10 WS-MI-CURR-DAY          PIC X(2).                      
              10 WS-MI-CURR-YY           PIC X(2).                      
           05 WS-DOT-GL-ACCT-NO          PIC X(8).                      
           05 WS-WU-GL-ACCT-NO           PIC X(7).                      
           05 WS-NUM-GL-ACCT-NO          PIC 9(7).                      
           05 WS-NODOT-GL-ACCT-NO.                                      
              10 WS-INT-GL-ACCT-NO       PIC X(3).                      
              10 WS-DEC-GL-ACCT-NO       PIC X(4).                      
           05 WS-COMPANY-NO              PIC X(2).                      
              88 WS-SCEG                          VALUE '01'.           
              88 WS-PSNC                          VALUE '26'.           
A31802     05  WS-COMMIT-COUNT              PIC 9(04)  VALUE 0.         
A31802     05  WS-COMMIT-CTR                PIC 9(04)  VALUE 0.         
A31802     05  WS-PARM-CTR                  PIC X(04)                   
A31802                                      JUSTIFIED RIGHT.            
A31802     05  WS-PPSTATS-STATUS             PIC X(02)  VALUE '00'.     
A31802         88  WS-PPSTATS-SUCCESSFUL                VALUE '00'.     
A31802     05  WS-PPMATRL-STATUS             PIC X(02)  VALUE '00'.     
A31802         88  WS-PPMATRL-SUCCESSFUL                VALUE '00'.     
A31802     05  WS-SCEGMTL-STATUS             PIC X(02)  VALUE '00'.     
A31802         88  WS-SCEGMTL-SUCCESSFUL                VALUE '00'.     
A31802     05  WS-ROW-COUNT                 PIC 9(04) VALUE 0.          
                                                                        
       01  WS-LITERALS.                                                 
           05 WS-PGRMNAME                      PIC X(08) VALUE          
              'PCSSO166'.                                               
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_PREMISE  PR                                                        
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_LINE_WORK_TYPE                                                     
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBLINEWK                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_ORDER_TYPE                                                         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBORTYP                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_SO_MATL_TRAN                                                       
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBWMSTRN                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_SO_DATA                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_SO_REQUIREMENT                                                     
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSOREQ                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_REQUIREMENT                                                        
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRQMNT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_SO_ORDER_INST                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_PREM_GAS_LINE                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREMLN                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_GAS_SERV_LINE                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBGASSRV                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_GASLINE_SO_XRF                                                     
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBGASSO                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_REV_DISTRICT                                                       
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRVDST                                                  
           END-EXEC.                                                            
      *                                                                         
      *COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                           
       COPY CWS00303.                                                           
      *                                                                         
      *ABEND SWITCH COPYBOOK                                                    
       COPY CWS09900.                                                           
      *                                                                         
      *WS ABEND WORK AREA                                                       
       COPY CWS00010.                                                           
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO GET THE UNEXTRACTED GAS SERV NOS FROM **         
      **                 CSS_GAS_SERV_LINE                           **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
            DECLARE GAS-SERV-NOS CURSOR WITH HOLD FOR                   
            SELECT DISTINCT(PG.SERVICE_NO),                             
                   XO.SERV_LINE_TYPE,                                   
                   XO.SERV_LINE_SIZE,                                   
                   XO.SERV_LINE_LENGTH,                                 
                   XO.INSTALL_TYPE_CD,                                  
                   XO.SVC_LINE_INSTALL_DT,                              
                   XO.SERV_LINE_STAT_FL,                                
                   XO.INSTALL_TYPE_ORIG,                                
                   XO.SERV_LINE_LEN_RTD,                                
                   XO.SERV_LINE_SIZE_RTD,                               
                   XO.SERV_LINE_TYPE_RTD,                               
                   PR.COMPANY_NO                                        
              FROM CSS_PREM_GAS_LINE   PG,                              
                   CSS_GAS_SERV_LINE   XO,                              
                   CSS_PREMISE         PR                               
             WHERE PG.SERVICE_NO         =  XO.SERVICE_NO               
               AND PG.PREMISE_NO         =  PR.PREMISE_NO               
               AND PG.CMSN_REQUEST_FL    =  'N'                         
           END-EXEC.                                                    
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO GET THE SERV_ORDER_NOS FROM THE XREF  **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
            DECLARE SERV-ORDER-NOS CURSOR WITH HOLD FOR                 
            SELECT GX.SERV_ORDER_NO                                     
              FROM CSS_GASLINE_SO_XRF  GX                               
             WHERE GX.SERVICE_NO   =  :XX-SERVICE-NO                    
           END-EXEC.                                                    
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARED TO GET THE INFO FOR PPLT MATERIAL INTERFACE            
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE MATL-INTERFACE-CURSOR CURSOR WITH HOLD FOR         
             SELECT WU.SERV_ORDER_NO,                                   
                    WU.COMP_UNIT_CD,                                    
                    WU.CU_SEQ_NM,                                       
                    WU.MATL_USAGE_CD,                                   
                    WU.MATL_ITEM_CD,                                    
                    WU.WORK_ORDER_NM,                                   
                    WU.GL_ACCT_NO,                                      
                    WU.FUNC_ACT_CD,                                     
                    WU.POINT,                                           
                    WU.SPAN_TO_POINT,                                   
                    WU.MATL_ITEM_QT,                                    
                    WU.MATL_ITEM_TOT_AM,                                
                    WU.MATL_ITEM_TYPE_CD,                               
                    WU.UOM_CD,                                          
                    WU.COST_CENTER,                                     
                    WU.COMPANY_NO,                                      
                    WU.LOCAL_STORERM_ID,                                
                    WU.OK_TO_PROCESS_FL,                                
                    REPLACE(REPLACE(CONVERT(CHAR(26), WU.PROCESSED_DT
           , 121), ' ', '-'), ':', '.') PROCESSED_DT                           
               FROM CSS_SO_MATL_TRAN WU                                 
              WHERE WU.MATL_USAGE_CD IN ('I', 'S', 'R', 'V', 'X', 'Y',  
A18341                                   'A', 'W')                      
                AND (WU.MATL_ITEM_TYPE_CD LIKE 'T%'                     
                 OR WU.MATL_ITEM_TYPE_CD LIKE 'C%')                     
                AND WU.MATL_ITEM_QT <> 0                                
                AND WU.PROCESSED_DT IS NULL                             
                AND WU.OK_TO_PROCESS_FL IN ('Y','Z')                    
                AND WU.SERV_ORDER_NO= :WS-WU-SERV-ORDER-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MATL-INTERFACE-CURSOR CURSOR WITH HOLD FOR                 
MFA-TR*      SELECT WU.SERV_ORDER_NO,                                           
MFA-TR*             WU.COMP_UNIT_CD,                                            
MFA-TR*             WU.CU_SEQ_NM,                                               
MFA-TR*             WU.MATL_USAGE_CD,                                           
MFA-TR*             WU.MATL_ITEM_CD,                                            
MFA-TR*             WU.WORK_ORDER_NM,                                           
MFA-TR*             WU.GL_ACCT_NO,                                              
MFA-TR*             WU.FUNC_ACT_CD,                                             
MFA-TR*             WU.POINT,                                                   
MFA-TR*             WU.SPAN_TO_POINT,                                           
MFA-TR*             WU.MATL_ITEM_QT,                                            
MFA-TR*             WU.MATL_ITEM_TOT_AM,                                        
MFA-TR*             WU.MATL_ITEM_TYPE_CD,                                       
MFA-TR*             WU.UOM_CD,                                                  
MFA-TR*             WU.COST_CENTER,                                             
MFA-TR*             WU.COMPANY_NO,                                              
MFA-TR*             WU.LOCAL_STORERM_ID,                                        
MFA-TR*             WU.OK_TO_PROCESS_FL,                                        
MFA-TR*             WU.PROCESSED_DT                                             
MFA-TR*        FROM CSS_SO_MATL_TRAN WU                                         
MFA-TR*       WHERE WU.MATL_USAGE_CD IN ('I', 'S', 'R', 'V', 'X', 'Y',          
MFA-TR*                                  'A', 'W')                              
MFA-TR*         AND (WU.MATL_ITEM_TYPE_CD LIKE 'T%'                             
MFA-TR*          OR WU.MATL_ITEM_TYPE_CD LIKE 'C%')                             
MFA-TR*         AND WU.MATL_ITEM_QT <> 0                                        
MFA-TR*         AND WU.PROCESSED_DT IS NULL                                     
MFA-TR*         AND WU.OK_TO_PROCESS_FL IN ('Y','Z')                            
MFA-TR*         AND WU.SERV_ORDER_NO= :WS-WU-SERV-ORDER-NO                      
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      ** CURSOR TO GET THE INFO FOR SCEG MATERIAL FOR GAS SVC                   
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE SCEG-GASMATL-CURSOR CURSOR WITH HOLD FOR           
             SELECT WU.SERV_ORDER_NO,                                   
                    WU.COMP_UNIT_CD,                                    
                    WU.CU_SEQ_NM,                                       
                    WU.MATL_USAGE_CD,                                   
                    WU.MATL_ITEM_CD,                                    
                    WU.WORK_ORDER_NM,                                   
                    WU.GL_ACCT_NO,                                      
                    WU.FUNC_ACT_CD,                                     
                    WU.POINT,                                           
                    WU.SPAN_TO_POINT                                    
               FROM CSS_SO_MATL_TRAN WU                                 
              WHERE WU.PROCESSED_DT IS NULL                             
                AND WU.OK_TO_PROCESS_FL = 'Y'                           
                AND WU.SERV_ORDER_NO= :WS-WU-SERV-ORDER-NO              
           END-EXEC.                                                    
      ******************************************************************        
      *PROCEDURE DIVISION.                                                      
      ******************************************************************        
      *                                                                         
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
      *                                                                         
A31802     PERFORM 1000-INITIALIZATION            THRU 1000-EXIT.       
           PERFORM 1100-PROCESS-INPUT             THRU 1100-EXIT.       
           PERFORM 9000-TERMINATE                 THRU 9000-EXIT.       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *   OPEN  FILES                                                           
      **************************************************************            
       1000-INITIALIZATION.                                             
                                                                        
A31802     DISPLAY '**************************************************'.
A31802     DISPLAY '** PROGRAM NAME: ' WS-PGRMNAME.                     
A31802*                                                                         
           OPEN OUTPUT PPSTATS-FILE.                                    
A31802     IF WS-PPSTATS-SUCCESSFUL                                     
A31802        CONTINUE                                                  
A31802     ELSE                                                         
A31802        DISPLAY ' '                                               
A31802        DISPLAY '**       PCSSO166 PROCESSING ERROR         **'   
A31802        DISPLAY '     OPEN ERROR OF PPSTATS OUTPUT FILE '         
A31802        DISPLAY '     FILE STATUS = ' WS-PPSTATS-STATUS           
A31802        DISPLAY '**         PROCESSING TERMINATED           **'   
A31802        PERFORM 9900-ABEND           THRU 9900-EXIT               
A31802     END-IF.                                                      
A31802*                                                                 03190000
           OPEN OUTPUT PPMATRL-FILE.                                    
A31802     IF WS-PPMATRL-SUCCESSFUL                                     
A31802        CONTINUE                                                  
A31802     ELSE                                                         
A31802        DISPLAY ' '                                               
A31802        DISPLAY '**       PCSSO166 PROCESSING ERROR         **'   
A31802        DISPLAY '     OPEN ERROR OF PPMATRL OUTPUT FILE '         
A31802        DISPLAY '     FILE STATUS = ' WS-PPMATRL-STATUS           
A31802        DISPLAY '**         PROCESSING TERMINATED           **'   
A31802        PERFORM 9900-ABEND           THRU 9900-EXIT               
A31802     END-IF.                                                      
A31802*                                                                 03190000
           OPEN OUTPUT SCEGMTL-FILE.                                    
A31802     IF WS-SCEGMTL-SUCCESSFUL                                     
A31802        CONTINUE                                                  
A31802     ELSE                                                         
A31802        DISPLAY ' '                                               
A31802        DISPLAY '**       PCSSO166 PROCESSING ERROR         **'   
A31802        DISPLAY '     OPEN ERROR OF SCEGMTL OUTPUT FILE '         
A31802        DISPLAY '     FILE STATUS = ' WS-SCEGMTL-STATUS           
A31802        DISPLAY '**         PROCESSING TERMINATED           **'   
A31802        PERFORM 9900-ABEND           THRU 9900-EXIT               
A31802     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-PROCESS INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1100-PROCESS-INPUT.                                              
      *                                                                         
A31802      PERFORM 7200-OPEN-GAS-SERV-NOS-CURSOR  THRU 7200-EXIT.      
            MOVE 'N' TO END-OF-FETCH.                                   
            PERFORM UNTIL END-OF-FETCH = 'Y'                            
               PERFORM 1200-GET-GAS-SERV-NOS-CMPLTD THRU 1200-EXIT      
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE PR-COMPANY-NO  TO  WS-COMPANY-NO                 
                  MOVE Y0-SERVICE-NO  TO  WS-XO-SERVICE-NO              
                  IF XO-INSTALL-TYPE-CD = 'S' OR                        
                     XO-INSTALL-TYPE-ORIG = 'S'                         
                      MOVE 'Y' TO WS-STUB-INSTALL-SW                    
                  ELSE                                                  
                      MOVE 'N' TO WS-STUB-INSTALL-SW                    
                  END-IF                                                
                  PERFORM 1300-GET-SERVICE-NOS-XRF     THRU  1300-EXIT  
               ELSE                                                     
                  IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
                      MOVE 'Y' TO END-OF-FETCH                          
                  END-IF                                                
               END-IF                                                   
            END-PERFORM.                                                
A31802      DISPLAY 'SERVICE ROWS PROCESSED = ', WS-ROW-COUNT           
A31802      PERFORM 7810-CLOSE-GAS-SERV-NOS-CURSOR THRU 7810-EXIT.      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE SERVICE ORDERS  WHICH HAVE NOT YET BEEN EXTRACTED      *        
      ******************************************************************        
       1200-GET-GAS-SERV-NOS-CMPLTD.                                    
      *                                                                         
           EXEC SQL                                                     
              FETCH   GAS-SERV-NOS                                      
               INTO   :Y0-SERVICE-NO                                    
                    , :XO-SERV-LINE-TYPE                                
                    , :XO-SERV-LINE-SIZE                                
                    , :XO-SERV-LINE-LENGTH                              
                    , :XO-INSTALL-TYPE-CD                               
                    , :XO-SVC-LINE-INSTALL-DT                           
                    , :XO-SERV-LINE-STAT-FL                             
                    , :XO-INSTALL-TYPE-ORIG                             
                    , :XO-SERV-LINE-LEN-RTD                             
                    , :XO-SERV-LINE-SIZE-RTD                            
                    , :XO-SERV-LINE-TYPE-RTD                            
                    , :PR-COMPANY-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO       WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166    ABORT ************'      
               DISPLAY '* PARAGRAPH = 1200-GET-GAS-SERV-NOS-CMPLTD *'   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                      *'   
               DISPLAY '********** PCSSO166    ABORT ************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  GET THE SERVICE NOS FROM THE XREF.                            *        
      ******************************************************************        
      *                                                                         
       1300-GET-SERVICE-NOS-XRF.                                        
            MOVE Y0-SERVICE-NO TO XX-SERVICE-NO.                        
            PERFORM 7220-OPEN-SERV-ORDER-CURSOR  THRU  7220-EXIT        
      *     MOVE 'N' TO WS-ORDER-PROCESSED-FL                                   
            MOVE SPACES TO WS-ORDER-PROCESSED-FL                        
            MOVE 'N' TO NO-MORE-SERV-NOS                                
            PERFORM UNTIL NO-MORE-SERV-NOS = 'Y'                        
              PERFORM 7280-FETCH-SERV-ORDER-CURSOR THRU 7280-EXIT       
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y' TO NO-MORE-SERV-NOS                           
              ELSE                                                      
                 MOVE SPACES TO WS-ORDER-PROCESSED-FL                   
                 MOVE XX-SERV-ORDER-NO TO WS-XX-SERV-ORDER-NO           
                 IF WS-PSNC                                             
                    PERFORM 2000-CHK-SERV-ORDER-POSTED THRU 2000-EXIT   
                    PERFORM 2100-GET-PPLT-STATS-INFO THRU 2100-EXIT     
                    PERFORM 2200-GET-PPLT-MATL-INFO  THRU 2200-EXIT     
                 ELSE                                                   
                    PERFORM 2300-GET-SCEG-GAS-MATL   THRU 2300-EXIT     
                 END-IF                                                 
              END-IF                                                    
            END-PERFORM.                                                
            IF WS-ORDER-PROCESSED-FL = 'Y'                              
               PERFORM 7410-UPDATE-EXTRACT-STATUS   THRU  7410-EXIT     
A31802         EXEC SQL                                                 
A31802              COMMIT                                              
A31802         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
            END-IF.                                                     
            PERFORM  7800-CLOSE-SERV-ORDER-CURSOR THRU 7800-EXIT.       
                                                                        
       1300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CHK TO SEE IF THE SERVICE ORDER  HAS BEEN POSTED OR NOT        *        
      ******************************************************************        
       2000-CHK-SERV-ORDER-POSTED.                                      
            MOVE SPACES TO VO-COMPLETED-DATETIME, VO-ORDER-STATE-CD.    
            MOVE ZEROS  TO COMP-DATE-IND.                               
            MOVE 'N' TO WS-SO-POSTED.                                   
                                                                        
            EXEC SQL                                                    
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME,                            
                      SO.ORDER_STATE_CD                                 
                 INTO :VO-COMPLETED-DATETIME :COMP-DATE-IND,            
                      :VO-ORDER-STATE-CD                                
                 FROM CSS_SO_DATA      SO                               
                WHERE SO.SERV_ORDER_NO =  :WS-XX-SERV-ORDER-NO          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT SO.COMPLETED_DATETIME,                                    
MFA-TR*               SO.ORDER_STATE_CD                                         
MFA-TR*          INTO :VO-COMPLETED-DATETIME :COMP-DATE-IND,                    
MFA-TR*               :VO-ORDER-STATE-CD                                        
MFA-TR*          FROM CSS_SO_DATA      SO                                       
MFA-TR*         WHERE SO.SERV_ORDER_NO =  :WS-XX-SERV-ORDER-NO                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                    
            IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
               IF VO-ORDER-STATE-CD = 'Z'                               
                  MOVE 'Y' TO WS-SO-POSTED                              
               ELSE                                                     
                  MOVE 'N' TO WS-SO-POSTED                              
               END-IF                                                   
               IF COMP-DATE-IND = -1                                    
                  EXEC SQL                                              
                    SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :VO-COMPLETED-DATETIME     
                  END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*           EXEC SQL                                                      
MFA-TR*             SET :VO-COMPLETED-DATETIME =  CURRENT TIMESTAMP             
MFA-TR*           END-EXEC                                                      
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                              
               END-IF                                                   
            ELSE                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 CONTINUE                                               
              ELSE                                                      
                DISPLAY '********** PCSSO166     ABORT ************'    
                DISPLAY '* 2000-CHK-SERV-ORDER-POSTED             *'    
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* SERV ORDER : ', WS-XX-SERV-ORDER-NO          
                DISPLAY '* PROGRAM ABORTING...                    *'    
                DISPLAY '********** PCSSO166    ABORT *************'    
                PERFORM 9900-ABEND              THRU 9900-EXIT          
              END-IF                                                    
            END-IF.                                                     
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  GET THE MATERIAL DETAIL FROM MATL_TRAN FOR PPLT STATS REPORT  *        
      ******************************************************************        
       2100-GET-PPLT-STATS-INFO.                                        
           MOVE 'N' TO WS-REVERSED-SW                                   
           MOVE ZEROS  TO WU-SERV-ORDER-NO                              
           MOVE SPACES TO WU-WORK-ORDER-NM, WU-FUNC-ACT-CD,             
                          WU-COST-CENTER                                
           EXEC SQL                                                     
            SELECT TOP(1) WU.SERV_ORDER_NO,
              WU.MATL_USAGE_CD,
              WU.WORK_ORDER_NM,
              WU.FUNC_ACT_CD,
              WU.COST_CENTER                                       
              INTO :WU-SERV-ORDER-NO,                                   
                   :WU-MATL-USAGE-CD,                                   
                   :WU-WORK-ORDER-NM,                                   
                   :WU-FUNC-ACT-CD,                                     
                   :WU-COST-CENTER                                      
              FROM CSS_SO_MATL_TRAN    WU WITH(READUNCOMMITTED)                 
             WHERE WU.SERV_ORDER_NO      =  :WS-XX-SERV-ORDER-NO        
               AND WU.PROCESSED_DT       IS NULL                        
               AND WU.OK_TO_PROCESS_FL   IN ('Y', 'Z')                  
                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT WU.SERV_ORDER_NO,                                            
MFA-TR*            WU.MATL_USAGE_CD,                                            
MFA-TR*            WU.WORK_ORDER_NM,                                            
MFA-TR*            WU.FUNC_ACT_CD,                                              
MFA-TR*            WU.COST_CENTER                                               
MFA-TR*       INTO :WU-SERV-ORDER-NO,                                           
MFA-TR*            :WU-MATL-USAGE-CD,                                           
MFA-TR*            :WU-WORK-ORDER-NM,                                           
MFA-TR*            :WU-FUNC-ACT-CD,                                             
MFA-TR*            :WU-COST-CENTER                                              
MFA-TR*       FROM CSS_SO_MATL_TRAN    WU                                       
MFA-TR*      WHERE WU.SERV_ORDER_NO      =  :WS-XX-SERV-ORDER-NO                
MFA-TR*        AND WU.PROCESSED_DT       IS NULL                                
MFA-TR*        AND WU.OK_TO_PROCESS_FL   IN ('Y', 'Z')                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
              IF WU-MATL-USAGE-CD = 'V' OR                              
                 WU-MATL-USAGE-CD = 'W' OR                              
                 WU-MATL-USAGE-CD = 'X' OR                              
                 WU-MATL-USAGE-CD = 'Y'                                 
                 MOVE 'Y' TO WS-REVERSED-SW                             
              ELSE                                                      
                 MOVE 'N' TO WS-REVERSED-SW                             
              END-IF                                                    
              IF WS-SO-POSTED = 'Y'                                     
                 PERFORM 5200-GET-SO-POSTED-DATE      THRU  5200-EXIT   
                 PERFORM 5220-GET-LOCATOR-ID          THRU  5220-EXIT   
                 PERFORM 5240-GET-PIPE-GLUTIL-CODE    THRU  5240-EXIT   
                 PERFORM 5260-GET-GL-ACCOUNT-NO       THRU  5260-EXIT   
                 PERFORM 5280-GET-WORK-ORDER-NUMBER   THRU  5280-EXIT   
                 PERFORM 5300-GET-COMPLETED-DATE      THRU  5300-EXIT   
                 PERFORM 8000-WRITE-PP-STAT-INTERFACE THRU  8000-EXIT   
                 MOVE 'Y' TO WS-ORDER-PROCESSED-FL                      
              ELSE                                                      
                 MOVE 'N' TO WS-ORDER-PROCESSED-FL                      
              END-IF                                                    
           ELSE                                                         
              IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                 CONTINUE                                               
              ELSE                                                      
                DISPLAY '********** PCSSO166     ABORT ************'    
                DISPLAY '* 2100-GET-PPLT-STATS-INFO               *'    
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* SO # : ', WS-XX-SERV-ORDER-NO                
                DISPLAY '* PROGRAM ABORTING...                    *'    
                DISPLAY '********** PCSSO166    ABORT ************'     
                PERFORM 9900-ABEND              THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      *  GET THE MATERIAL DETAIL FROM MATL_TRAN FOR PPLT MATL  REPORT  *        
      ******************************************************************        
       2200-GET-PPLT-MATL-INFO.                                         
           MOVE XX-SERV-ORDER-NO TO WS-WU-SERV-ORDER-NO                 
           PERFORM 7240-OPEN-MATL-INTERFACE-CSR  THRU  7240-EXIT.       
           MOVE 'N' TO NO-MORE-MATL                                     
           PERFORM UNTIL NO-MORE-MATL = 'Y'                             
             PERFORM 7300-FETCH-MATL-INFO    THRU   7300-EXIT           
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
A31802         IF WS-SO-POSTED = 'Y'                                    
A18341           IF WU-MATL-USAGE-CD = 'A' OR 'W'                       
A31802              MOVE 'Y' TO WS-ORDER-PROCESSED-FL                   
A31802*             PERFORM 7420-UPDATE-PROCESSED-DATE   THRU 7420-EXIT         
                    CONTINUE                                            
A18341           ELSE                                                   
                    PERFORM 5000-GET-TRANSACTION-CODE    THRU 5000-EXIT 
                    PERFORM 5025-GET-TRANSACTION-DATE    THRU 5025-EXIT 
                    PERFORM 5050-GET-GLACCT-NO-NODOT     THRU 5050-EXIT 
                    PERFORM 5075-GET-RESOURCE-CODE       THRU 5075-EXIT 
                    PERFORM 5100-GET-FUNC-ACTIVITY-CODE  THRU 5100-EXIT 
                    PERFORM 5125-GET-PREMISE-DETAILS     THRU 5125-EXIT 
                    PERFORM 8100-WRITE-PP-MATL-INTERFACE THRU 8100-EXIT 
                    MOVE 'Y' TO WS-ORDER-PROCESSED-FL                   
A31802*             PERFORM 7420-UPDATE-PROCESSED-DATE   THRU 7420-EXIT         
A18341           END-IF                                                 
A31802          ELSE                                                    
A31802              MOVE 'N' TO WS-ORDER-PROCESSED-FL                   
A31802*             PERFORM 7430-UPDATE-OK-PROCESS-FL    THRU  7430-EXIT        
A31802          END-IF                                                  
             ELSE                                                       
                MOVE 'Y' TO NO-MORE-MATL                                
             END-IF                                                     
           END-PERFORM                                                  
A31802     IF WS-ORDER-PROCESSED-FL = 'Y'                               
A31802        MOVE XX-SERV-ORDER-NO TO WU-SERV-ORDER-NO                 
A31802        PERFORM 7420-UPDATE-PROCESSED-DATE   THRU 7420-EXIT       
A31802     ELSE                                                         
A31802       IF WS-ORDER-PROCESSED-FL = 'N'                             
A31802          MOVE XX-SERV-ORDER-NO TO WU-SERV-ORDER-NO               
A31802          PERFORM 7430-UPDATE-OK-PROCESS-FL    THRU  7430-EXIT    
A31802       END-IF                                                     
A31802     END-IF.                                                      
           PERFORM 7820-CLOSE-MATL-INTERFACE-CSR  THRU  7820-EXIT.      
                                                                        
       2200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * GET THE SCEG MATERIAL IN A FILE*                                        
      ******************************************************************        
       2300-GET-SCEG-GAS-MATL.                                          
           MOVE XX-SERV-ORDER-NO TO WS-WU-SERV-ORDER-NO                 
           PERFORM 7260-OPEN-SCEG-GAS-MATL-CSR  THRU  7260-EXIT.        
           MOVE 'N' TO NO-MORE-MATL.                                    
           MOVE 'N' TO WS-ORDER-PROCESSED-FL                            
           PERFORM UNTIL NO-MORE-MATL = 'Y'                             
             PERFORM 7400-FETCH-SCEG-GAS-MATL-INFO    THRU   7400-EXIT  
             IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                PERFORM 8200-WRITE-SCEG-MATL-RPT   THRU  8200-EXIT      
A31802*         PERFORM 7420-UPDATE-PROCESSED-DATE   THRU  7420-EXIT            
                MOVE 'Y' TO WS-ORDER-PROCESSED-FL                       
             ELSE                                                       
                MOVE 'Y' TO NO-MORE-MATL                                
             END-IF                                                     
           END-PERFORM.                                                 
           IF WS-ORDER-PROCESSED-FL = 'Y'                               
              MOVE XX-SERV-ORDER-NO TO WU-SERV-ORDER-NO                 
              PERFORM 7420-UPDATE-PROCESSED-DATE   THRU  7420-EXIT      
           END-IF.                                                      
           PERFORM 7830-CLOSE-SCEG-GAS-MATL-CSR  THRU  7830-EXIT.       
                                                                        
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE TRANSACTION CODE FOR THE MATERIALS                     *        
      ******************************************************************        
       5000-GET-TRANSACTION-CODE.                                       
            MOVE SPACES TO WS-TRANSACTION-CODE.                         
            EVALUATE WU-MATL-USAGE-CD                                   
            WHEN 'I'  MOVE 'ISS' TO WS-TRANSACTION-CODE                 
                      MOVE 'C'  TO    WS-IDENTIFIER-C                   
            WHEN 'S'  MOVE 'ISS' TO WS-TRANSACTION-CODE                 
                      MOVE 'S'  TO    WS-IDENTIFIER-C                   
            WHEN 'X'  MOVE 'RET' TO WS-TRANSACTION-CODE                 
                      MOVE 'S'  TO    WS-IDENTIFIER-C                   
            WHEN 'Y'  MOVE 'ISS' TO WS-TRANSACTION-CODE                 
                      MOVE 'C'  TO    WS-IDENTIFIER-C                   
            WHEN OTHER MOVE 'RET' TO WS-TRANSACTION-CODE                
                      MOVE 'C'  TO    WS-IDENTIFIER-C                   
            END-EVALUATE.                                               
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE TRANSACTION DATE AS MMDDYY                             *        
      ******************************************************************        
       5025-GET-TRANSACTION-DATE.                                       
                                                                        
            EXEC SQL                                                    
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SET  :WS-TODAYS-DATE = CURRENT DATE                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE WS-TODAYS-DATE   TO  WS-CURRENT-DATE.                  
            MOVE WS-CURRENT-YY    TO  WS-MI-CURR-YY.                    
            MOVE WS-CURRENT-MONTH TO  WS-MI-CURR-MONTH.                 
            MOVE WS-CURRENT-DAY   TO  WS-MI-CURR-DAY.                   
                                                                        
       5025-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * GET THE GL ACCT NUMBER WITH NO DOT                             *        
      ******************************************************************        
       5050-GET-GLACCT-NO-NODOT.                                        
                                                                        
            MULTIPLY WU-GL-ACCT-NO BY 10000 GIVING  WS-NUM-GL-ACCT-NO.  
            MOVE WS-NUM-GL-ACCT-NO TO WS-WU-GL-ACCT-NO.                 
                                                                        
       5050-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * GET THE RESOURCE CODE                                          *        
      ******************************************************************        
       5075-GET-RESOURCE-CODE.                                          
            IF WU-MATL-ITEM-TYPE-CD = 'T'                               
               MOVE '206' TO WS-RESOURCE-CD                             
            ELSE                                                        
               IF WU-MATL-ITEM-TYPE-CD = 'C'                            
                  IF WU-MATL-USAGE-CD = 'I'                             
                     MOVE '202' TO WS-RESOURCE-CD                       
                  ELSE                                                  
                     MOVE '203' TO WS-RESOURCE-CD                       
                  END-IF                                                
                END-IF                                                  
            END-IF.                                                     
                                                                        
       5075-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * GET THE FUNC ACTIVITY CODE *                                            
      ******************************************************************        
       5100-GET-FUNC-ACTIVITY-CODE.                                     
                                                                        
            IF WU-FUNC-ACT-CD IS EQUAL TO SPACES                        
               MOVE 'SCNV' TO WS-WU-FUNC-ACT-CD                         
            ELSE                                                        
               MOVE WU-FUNC-ACT-CD TO WS-WU-FUNC-ACT-CD                 
            END-IF.                                                     
                                                                        
        5100-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      *  GET THE PREMISE DETAILS FOR MATERIAL INTERFACE                *        
      ******************************************************************        
       5125-GET-PREMISE-DETAILS.                                        
           EXEC SQL                                                     
            SELECT PR.PREMISE_NO                                        
                  ,A9.STATE                                             
                  ,A9.COUNTY                                            
              INTO :PR-PREMISE-NO                                       
                  ,:A9-STATE                                            
                  ,:A9-COUNTY                                           
              FROM CSS_SO_DATA      VO                                  
                  ,CSS_REV_DISTRICT A9                                  
                  ,CSS_PREMISE      PR                                  
             WHERE VO.SERV_ORDER_NO   = :XX-SERV-ORDER-NO               
               AND PR.PREMISE_NO      = VO.PREMISE_NO                   
               AND A9.REV_DISTRICT_CD = PR.REV_DISTRICT_CD              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
              MOVE PR-PREMISE-NO TO WS-PR-PREMISE-NO                    
              MOVE A9-STATE      TO WS-A9-STATE                         
              MOVE A9-COUNTY     TO WS-A9-COUNTY                        
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 CONTINUE                                               
              ELSE                                                      
                DISPLAY '********** PCSSO166     ABORT ************'    
                DISPLAY '* 5125-GET-PREMISE-DETAILS               *'    
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* SO # : ', XX-SERV-ORDER-NO                   
                DISPLAY '* PROGRAM ABORTING...                    *'    
                DISPLAY '********** PCSSO166    ABORT *************'    
                PERFORM 9900-ABEND              THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5125-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * CHK TO SEE IF ALL MATLS FOR THE SERV_ORD_NO IS OK TO PROCESS*           
      ******************************************************************        
       5200-GET-SO-POSTED-DATE.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) CAST(REQMNT_COMP_DT AS DATE)                      
                  INTO :EG-REQMNT-COMP-DT :SO-POSTED-DT-IND             
                  FROM CSS_SO_DATA          SO                          
                      ,CSS_SO_REQUIREMENT   SR                          
                 WHERE SO.SERV_ORDER_NO = :WS-XX-SERV-ORDER-NO          
                   AND SR.SERV_ORDER_NO = SO.SERV_ORDER_NO              
                   AND SR.SERV_ORDER_STATUS =                           
                             (SELECT MAX(RQ.SERV_ORDER_STATUS)          
                                FROM CSS_REQUIREMENT      RQ            
                                    ,CSS_ORDER_TYPE       OT            
                               WHERE OT.ORDER_TYPE_CD = SO.ORDER_TYPE_CD
                                 AND OT.COMPANY_NO    = SO.COMPANY_NO   
                                 AND RQ.WORK_CLASS_ID = OT.WORK_CLASS_ID
                             )                                          
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DATE(REQMNT_COMP_DT)                                     
MFA-TR*           INTO :EG-REQMNT-COMP-DT :SO-POSTED-DT-IND                     
MFA-TR*           FROM CSS_SO_DATA          SO                                  
MFA-TR*               ,CSS_SO_REQUIREMENT   SR                                  
MFA-TR*          WHERE SO.SERV_ORDER_NO = :WS-XX-SERV-ORDER-NO                  
MFA-TR*            AND SR.SERV_ORDER_NO = SO.SERV_ORDER_NO                      
MFA-TR*            AND SR.SERV_ORDER_STATUS =                                   
MFA-TR*                      (SELECT MAX(RQ.SERV_ORDER_STATUS)                  
MFA-TR*                         FROM CSS_REQUIREMENT      RQ                    
MFA-TR*                             ,CSS_ORDER_TYPE       OT                    
MFA-TR*                        WHERE OT.ORDER_TYPE_CD = SO.ORDER_TYPE_CD        
MFA-TR*                          AND OT.COMPANY_NO    = SO.COMPANY_NO           
MFA-TR*                          AND RQ.WORK_CLASS_ID = OT.WORK_CLASS_ID        
MFA-TR*                      )                                                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF SO-POSTED-DT-IND  = -1                                
                  EXEC SQL                                              
                    SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :EG-REQMNT-COMP-DT         
                  END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*           EXEC SQL                                                      
MFA-TR*             SET :EG-REQMNT-COMP-DT =  CURRENT TIMESTAMP                 
MFA-TR*           END-EXEC                                                      
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                              
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  CONTINUE                                              
               ELSE                                                     
                  DISPLAY '********** PCSSO166     ABORT ************'  
                  DISPLAY '* 5200-GET-SO-POSTED-DATE                *'  
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* SO # :     ', WS-XX-SERV-ORDER-NO          
                  DISPLAY '* PROGRAM ABORTING...                    *'  
                  DISPLAY '********** PCSSO166    ABORT *************'  
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
                END-IF                                                  
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE LOCATOR ID FROM THE PREMISE TABLE                      *        
      ******************************************************************        
       5220-GET-LOCATOR-ID.                                             
            MOVE SPACES TO PR-LOCATOR-ID.                               
            EXEC SQL                                                    
               SELECT PR.LOCATOR_ID                                     
                 INTO :PR-LOCATOR-ID                                    
                 FROM CSS_PREMISE      PR,                              
                      CSS_SO_DATA      SO                               
                WHERE SO.SERV_ORDER_NO =  :WS-XX-SERV-ORDER-NO          
                  AND PR.PREMISE_NO    =  SO.PREMISE_NO                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                    
            IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
               CONTINUE                                                 
            ELSE                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE '*********' TO PR-LOCATOR-ID                      
                 CONTINUE                                               
              ELSE                                                      
                DISPLAY '********** PCSSO166     ABORT ************'    
                DISPLAY '* 5220-GET-LOCATOR-ID                *'        
                DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
                DISPLAY '* SO # : ', WS-XX-SERV-ORDER-NO                
                DISPLAY '* PROGRAM ABORTING...                *'        
                DISPLAY '********** PCSSO166    ABORT ************'     
                PERFORM 9900-ABEND              THRU 9900-EXIT          
              END-IF                                                    
            END-IF.                                                     
                                                                        
       5220-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE PIPE TYPE CODE AND GLUTIL CODE FROM PIPE TYPE & SIZE   *        
      ******************************************************************        
      *                                                                         
       5240-GET-PIPE-GLUTIL-CODE.                                       
            MOVE SPACES TO WS-GL-UTIL-ACCT-NO.                          
            MOVE SPACES TO WS-PIPE-TYPE-CD.                             
            IF WU-FUNC-ACT-CD = 'PLSR' OR WU-FUNC-ACT-CD = 'STSR'       
               IF XO-SERV-LINE-TYPE-RTD = ' ' OR                        
                  XO-SERV-LINE-SIZE-RTD = ' '                           
                  MOVE XO-SERV-LINE-TYPE     TO WS-SERV-LINE-TYPE       
                  MOVE XO-SERV-LINE-SIZE     TO WS-SERV-LINE-SIZE       
               ELSE                                                     
                  MOVE XO-SERV-LINE-TYPE-RTD TO WS-SERV-LINE-TYPE       
                  MOVE XO-SERV-LINE-SIZE-RTD TO WS-SERV-LINE-SIZE       
               END-IF                                                   
            ELSE                                                        
               MOVE XO-SERV-LINE-TYPE TO WS-SERV-LINE-TYPE              
               MOVE XO-SERV-LINE-SIZE TO WS-SERV-LINE-SIZE              
            END-IF.                                                     
            IF WS-SERV-LINE-TYPE = 'P'                                  
               MOVE '4801' TO WS-GL-UTIL-ACCT-NO                        
               EVALUATE WS-SERV-LINE-SIZE                               
                  WHEN '34'   MOVE '00779' TO WS-PIPE-TYPE-CD           
                  WHEN '114'  MOVE '00780' TO WS-PIPE-TYPE-CD           
                  WHEN '2'    MOVE '00781' TO WS-PIPE-TYPE-CD           
                  WHEN '4'    MOVE '00782' TO WS-PIPE-TYPE-CD           
                  WHEN '6'    MOVE '00783' TO WS-PIPE-TYPE-CD           
                  WHEN '8'    MOVE '00784' TO WS-PIPE-TYPE-CD           
                  WHEN '58'   MOVE '01015' TO WS-PIPE-TYPE-CD           
                  WHEN OTHER  MOVE '*****' TO WS-PIPE-TYPE-CD           
                END-EVALUATE                                            
            ELSE                                                        
              IF WS-SERV-LINE-TYPE = 'M'                                
                 MOVE '4802' TO WS-GL-UTIL-ACCT-NO                      
                 EVALUATE WS-SERV-LINE-SIZE                             
                   WHEN '34'   MOVE '00765' TO WS-PIPE-TYPE-CD          
                   WHEN '1'    MOVE '00766' TO WS-PIPE-TYPE-CD          
                   WHEN '114'  MOVE '00767' TO WS-PIPE-TYPE-CD          
                   WHEN '112'  MOVE '00768' TO WS-PIPE-TYPE-CD          
                   WHEN '2'    MOVE '00771' TO WS-PIPE-TYPE-CD          
                   WHEN '3'    MOVE '00773' TO WS-PIPE-TYPE-CD          
                   WHEN '4'    MOVE '00775' TO WS-PIPE-TYPE-CD          
                   WHEN '6'    MOVE '00776' TO WS-PIPE-TYPE-CD          
                   WHEN '8'    MOVE '00777' TO WS-PIPE-TYPE-CD          
                   WHEN '10'   MOVE '00769' TO WS-PIPE-TYPE-CD          
                   WHEN '212'  MOVE '00772' TO WS-PIPE-TYPE-CD          
                   WHEN '312'  MOVE '00774' TO WS-PIPE-TYPE-CD          
                   WHEN OTHER  MOVE '*****' TO WS-PIPE-TYPE-CD          
                 END-EVALUATE                                           
               END-IF                                                   
            END-IF.                                                     
                                                                        
       5240-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE GL ACCOUNT  NO                                         *        
      ******************************************************************        
      *                                                                         
       5260-GET-GL-ACCOUNT-NO.                                          
            IF WU-FUNC-ACT-CD = 'PLSI' OR WU-FUNC-ACT-CD = 'STSI'       
               MOVE '1180270'     TO  WS-GL-ACCOUNT-NO                  
            ELSE                                                        
               IF WU-FUNC-ACT-CD = 'PLSR' OR WU-FUNC-ACT-CD = 'STSR'    
                  MOVE '1190210'  TO  WS-GL-ACCOUNT-NO                  
               ELSE                                                     
                  MOVE 'ERROR'    TO  WS-GL-ACCOUNT-NO                  
               END-IF                                                   
            END-IF.                                                     
                                                                        
       5260-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * GET THE GL UTILITY ACCOUNT NO                                  *        
      ******************************************************************        
      *                                                                         
       5280-GET-WORK-ORDER-NUMBER.                                      
            MOVE SPACES TO  WS-TEMP-SO-NO,  WS-SERV-ORDER-NO            
            IF WU-SERV-ORDER-NO >= 100000000000                         
               MOVE WU-SERV-ORDER-NO  TO WS-SERV-ORDER-NO               
            ELSE                                                        
               MOVE WU-SERV-ORDER-NO  TO WS-TEMP-SO-NO                  
               MOVE WS-TEMP-SO-NO     TO WS-SERV-ORDER-NO               
            END-IF.                                                     
                                                                        
       5280-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * GET THE COMPLETED DATE FOR STATISTICAL DATA                    *        
      ******************************************************************        
      *                                                                         
       5300-GET-COMPLETED-DATE.                                         
            MOVE EG-REQMNT-COMP-DT(1:10) TO WS-COMPLETED-DATE.          
            MOVE WS-COMPLETED-YEAR           TO WS-PP-COMP-YEAR.        
            MOVE WS-COMPLETED-MONTH          TO WS-PP-COMP-MONTH.       
            MOVE WS-COMPLETED-DAY            TO WS-PP-COMP-DAY.         
                                                                        
       5300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * OPENS SERV_ORDERS CURSOR                                                
      ******************************************************************        
      *                                                                         
       7200-OPEN-GAS-SERV-NOS-CURSOR.                                   
      *                                                                         
           EXEC SQL                                                     
              OPEN GAS-SERV-NOS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7200-OPEN-GAS-SERV-NOS-CURSOR        *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSSO166     ABORT ************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPENS SERV-ORDER-NOS CURSOR                                             
      ******************************************************************        
      *                                                                         
       7220-OPEN-SERV-ORDER-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
              OPEN SERV-ORDER-NOS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7220-OPEN-SERV-ORDER-CURSOR            *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166     ABORT ************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPENS MATL-INTERFACE-CURSOR                                             
      ******************************************************************        
      *                                                                         
       7240-OPEN-MATL-INTERFACE-CSR.                                    
      *                                                                         
           EXEC SQL                                                     
              OPEN MATL-INTERFACE-CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7240-OPEN-MATL-INTERFACE-CSR           *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166     ABORT ************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPENS SCEG-GAS-MATL-CURSOR                                              
      ******************************************************************        
      *                                                                         
       7260-OPEN-SCEG-GAS-MATL-CSR.                                     
      *                                                                         
           EXEC SQL                                                     
              OPEN SCEG-GASMATL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7260-OPEN-SCEG-GAS-MATL-CSR           *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166     ABORT ************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  FETCH THE SERV-ORDER-NOS CURSOR TO GET THE SERV-ORDER-NOS     *        
      ******************************************************************        
      *                                                                         
       7280-FETCH-SERV-ORDER-CURSOR.                                    
           MOVE ZEROS TO XX-SERV-ORDER-NO.                              
           EXEC SQL                                                     
              FETCH SERV-ORDER-NOS                                      
              INTO  :XX-SERV-ORDER-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL  OR          
                                           NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSSO166     ABORT ************'      
              DISPLAY '* PARAGRAPH = 7280-FETCH-SERV-ORDER-CURSOR *'    
              DISPLAY '* SERVICE NO = ', XX-SERVICE-NO                  
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                      *'    
              DISPLAY '********** PCSSO166    ABORT *************'      
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE SO_MATL_TRAN INFO FROM THE TABLE                                
      ******************************************************************        
       7300-FETCH-MATL-INFO.                                            
           MOVE ZEROS  TO  WU-SERV-ORDER-NO, WU-CU-SEQ-NM,              
                           WU-MATL-ITEM-CD,  WU-WORK-ORDER-NM           
                           WU-GL-ACCT-NO,    WU-POINT,                  
                           WU-MATL-ITEM-QT,  WU-MATL-ITEM-TOT-AM,       
                           WU-SPAN-TO-POINT                             
           MOVE SPACES TO  WU-COMP-UNIT-CD, WU-MATL-USAGE-CD            
                           WU-FUNC-ACT-CD,  WU-MATL-ITEM-TYPE-CD,       
                           WU-UOM-CD,       WU-COST-CENTER,             
                           WU-LOCAL-STORERM-ID, WU-COMPANY-NO           
           EXEC SQL                                                     
              FETCH MATL-INTERFACE-CURSOR                               
              INTO :WU-SERV-ORDER-NO,                                   
                   :WU-COMP-UNIT-CD,                                    
                   :WU-CU-SEQ-NM,                                       
                   :WU-MATL-USAGE-CD,                                   
                   :WU-MATL-ITEM-CD,                                    
                   :WU-WORK-ORDER-NM,                                   
                   :WU-GL-ACCT-NO,                                      
                   :WU-FUNC-ACT-CD,                                     
                   :WU-POINT,                                           
                   :WU-SPAN-TO-POINT,                                   
                   :WU-MATL-ITEM-QT,                                    
                   :WU-MATL-ITEM-TOT-AM,                                
                   :WU-MATL-ITEM-TYPE-CD,                               
                   :WU-UOM-CD,                                          
                   :WU-COST-CENTER,                                     
                   :WU-COMPANY-NO,                                      
                   :WU-LOCAL-STORERM-ID,                                
                   :WU-OK-TO-PROCESS-FL,                                
                   :WU-PROCESSED-DT :PROCESSED-DT-IND                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH = 7300-FETCH-MATL-INFO'            
              DISPLAY '**  SO # : ', WS-WU-SERV-ORDER-NO                
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE SO_MATL_TRAN FOR SCEG INFO FROM THE TABLE                       
      ******************************************************************        
       7400-FETCH-SCEG-GAS-MATL-INFO.                                   
           MOVE ZEROS  TO  WU-SERV-ORDER-NO, WU-CU-SEQ-NM,              
                           WU-MATL-ITEM-CD,  WU-WORK-ORDER-NM           
                           WU-GL-ACCT-NO,    WU-POINT,                  
                           WU-SPAN-TO-POINT                             
           MOVE SPACES TO  WU-COMP-UNIT-CD, WU-MATL-USAGE-CD            
                           WU-FUNC-ACT-CD                               
                                                                        
           EXEC SQL                                                     
              FETCH SCEG-GASMATL-CURSOR                                 
              INTO :WU-SERV-ORDER-NO,                                   
                   :WU-COMP-UNIT-CD,                                    
                   :WU-CU-SEQ-NM,                                       
                   :WU-MATL-USAGE-CD,                                   
                   :WU-MATL-ITEM-CD,                                    
                   :WU-WORK-ORDER-NM,                                   
                   :WU-GL-ACCT-NO,                                      
                   :WU-FUNC-ACT-CD,                                     
                   :WU-POINT,                                           
                   :WU-SPAN-TO-POINT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH = 7400-FETCH-SCEG-GAS-MATL-INFO'   
A31802        DISPLAY '**  SO # : ', WS-WU-SERV-ORDER-NO                
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * UPDATE THE EXTRACT FLAG TO 'Y' AFTER EXTRACTION                *        
      ******************************************************************        
      *                                                                         
       7410-UPDATE-EXTRACT-STATUS.                                      
            EXEC SQL                                                    
               UPDATE CSS_PREM_GAS_LINE                                 
               SET    CMSN_REQUEST_FL    = 'Y'                          
               WHERE  SERVICE_NO         = :Y0-SERVICE-NO               
               AND    CMSN_REQUEST_FL    = 'N'                          
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                    
            IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                CONTINUE                                                
            ELSE                                                        
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7410-UPDATE-EXTRACT-STATUS             *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* SVC NO :   ', Y0-SERVICE-NO                   
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166    ABORT *************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
                                                                        
       7410-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * UPDATE THE PROCESSED DATE IN SO_MATL_TRAN                      *        
      ******************************************************************        
      *                                                                         
       7420-UPDATE-PROCESSED-DATE.                                      
            EXEC SQL                                                    
               UPDATE CSS_SO_MATL_TRAN                                  
               SET    PROCESSED_DT       = CIS.CURRENT$TIMESTAMP(),           
                      OK_TO_PROCESS_FL   = 'Y'                          
               WHERE  SERV_ORDER_NO      = :WU-SERV-ORDER-NO            
A31802*        AND    COMP_UNIT_CD       = :WU-COMP-UNIT-CD                     
A31802*        AND    CU_SEQ_NM          = :WU-CU-SEQ-NM                        
A31802*        AND    MATL_USAGE_CD      = :WU-MATL-USAGE-CD                    
A31802*        AND    MATL_ITEM_CD       = :WU-MATL-ITEM-CD                     
A31802*        AND    WORK_ORDER_NM      = :WU-WORK-ORDER-NM                    
A31802*        AND    GL_ACCT_NO         = :WU-GL-ACCT-NO                       
A31802*        AND    FUNC_ACT_CD        = :WU-FUNC-ACT-CD                      
A31802*        AND    POINT              = :WU-POINT                            
A31802*        AND    SPAN_TO_POINT      = :WU-SPAN-TO-POINT                    
               AND    OK_TO_PROCESS_FL   IN ('Y', 'Z')                  
               AND    MATL_POSTED_FL     = 'Y'                          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*        UPDATE CSS_SO_MATL_TRAN                                          
MFA-TR*        SET    PROCESSED_DT       = CURRENT TIMESTAMP,                   
MFA-TR*               OK_TO_PROCESS_FL   = 'Y'                                  
MFA-TR*        WHERE  SERV_ORDER_NO      = :WU-SERV-ORDER-NO                    
MFA-TR*        AND    COMP_UNIT_CD       = :WU-COMP-UNIT-CD                     
MFA-TR*        AND    CU_SEQ_NM          = :WU-CU-SEQ-NM                        
MFA-TR*        AND    MATL_USAGE_CD      = :WU-MATL-USAGE-CD                    
MFA-TR*        AND    MATL_ITEM_CD       = :WU-MATL-ITEM-CD                     
MFA-TR*        AND    WORK_ORDER_NM      = :WU-WORK-ORDER-NM                    
MFA-TR*        AND    GL_ACCT_NO         = :WU-GL-ACCT-NO                       
MFA-TR*        AND    FUNC_ACT_CD        = :WU-FUNC-ACT-CD                      
MFA-TR*        AND    POINT              = :WU-POINT                            
MFA-TR*        AND    SPAN_TO_POINT      = :WU-SPAN-TO-POINT                    
MFA-TR*        AND    OK_TO_PROCESS_FL   IN ('Y', 'Z')                          
MFA-TR*        AND    MATL_POSTED_FL     = 'Y'                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                    
            ADD 1 TO WS-ROW-COUNT.                                      
            DISPLAY 'ROW COUNT ...', WS-ROW-COUNT.                      
            IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                CONTINUE                                                
            ELSE                                                        
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7420-UPDATE-PROCESSED-DATE             *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* SO # : ', WU-SERV-ORDER-NO                    
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166    ABORT *************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
                                                                        
       7420-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * UPDATE THE OK_TO_PROCESS_FL ='Z'IN SO_MATL_TRAN IF THE SO IS   *        
      *  IS NOT POSTED                                                 *        
      ******************************************************************        
      *                                                                         
       7430-UPDATE-OK-PROCESS-FL.                                       
            EXEC SQL                                                    
               UPDATE CSS_SO_MATL_TRAN                                  
               SET    PROCESSED_DT       = NULL,                        
                      OK_TO_PROCESS_FL   = 'Z'                          
               WHERE  SERV_ORDER_NO      = :WU-SERV-ORDER-NO            
A31802*        AND    COMP_UNIT_CD       = :WU-COMP-UNIT-CD                     
A31802*        AND    CU_SEQ_NM          = :WU-CU-SEQ-NM                        
A31802*        AND    MATL_USAGE_CD      = :WU-MATL-USAGE-CD                    
A31802*        AND    MATL_ITEM_CD       = :WU-MATL-ITEM-CD                     
A31802*        AND    WORK_ORDER_NM      = :WU-WORK-ORDER-NM                    
A31802*        AND    GL_ACCT_NO         = :WU-GL-ACCT-NO                       
A31802*        AND    FUNC_ACT_CD        = :WU-FUNC-ACT-CD                      
A31802*        AND    POINT              = :WU-POINT                            
A31802*        AND    SPAN_TO_POINT      = :WU-SPAN-TO-POINT                    
               AND    OK_TO_PROCESS_FL   IN ('Y', 'Z')                  
               AND    MATL_POSTED_FL     = 'Y'                          
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                    
            IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                CONTINUE                                                
            ELSE                                                        
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7430-UPDATE-PROCESSED-DATE             *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* SO # : ', WU-SERV-ORDER-NO                    
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166    ABORT *************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
                                                                        
       7430-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES SERV ORDER NOS CURSOR                                   *        
      ******************************************************************        
       7800-CLOSE-SERV-ORDER-CURSOR.                                    
      *                                                                         
           EXEC SQL                                                     
              CLOSE SERV-ORDER-NOS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO   WS-ACTIVE-RETURN-CODE.                   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7800-CLOSE-SERV-ORDER-CURSOR           *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166    ABORT *************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES SERV ORDERS  CURSOR                                     *        
      ******************************************************************        
       7810-CLOSE-GAS-SERV-NOS-CURSOR.                                  
      *                                                                         
           EXEC SQL                                                     
              CLOSE GAS-SERV-NOS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO   WS-ACTIVE-RETURN-CODE.                   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7810-CLOSE-GAS-SERV-NOS-CURSOR      *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSSO166    ABORT ************'      
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES MATL INTERFACE CURSOR                                  *         
      ******************************************************************        
       7820-CLOSE-MATL-INTERFACE-CSR.                                   
      *                                                                         
           EXEC SQL                                                     
              CLOSE MATL-INTERFACE-CURSOR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO   WS-ACTIVE-RETURN-CODE.                   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7820-CLOSE-MATL-INTERFACE-CSR          *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166    ABORT *************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES SCEG GAS MATL CURSOR                                    *        
      ******************************************************************        
       7830-CLOSE-SCEG-GAS-MATL-CSR.                                    
      *                                                                         
           EXEC SQL                                                     
              CLOSE SCEG-GASMATL-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE   TO   WS-ACTIVE-RETURN-CODE.                   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSSO166     ABORT ************'     
               DISPLAY '* 7830-CLOSE-SCEG-GAS-MATL-CSR           *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSSO166    ABORT *************'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *   CLOSE FILES                                                           
      **************************************************************            
       7900-CLOSE-FILES.                                                
                                                                        
           CLOSE PPSTATS-FILE.                                          
A31802     IF WS-PPSTATS-SUCCESSFUL                                     
A31802        CONTINUE                                                  
A31802     ELSE                                                         
A31802        DISPLAY ' '                                               
A31802        DISPLAY '**  PCSSO166  PROCESSING ERROR **'               
A31802        DISPLAY '**  CLOSE ERROR OF PPSTATS OUTPUT FILE'          
A31802        DISPLAY '**  FILE STATUS = ' WS-PPSTATS-STATUS            
A31802        DISPLAY '**  PROCESSING TERMINATED      **'               
A31802        PERFORM 9900-ABEND THRU 9900-EXIT                         
A31802     END-IF.                                                      
A31802*                                                                 10210000
           CLOSE PPMATRL-FILE.                                          
A31802     IF WS-PPMATRL-SUCCESSFUL                                     
A31802        CONTINUE                                                  
A31802     ELSE                                                         
A31802        DISPLAY ' '                                               
A31802        DISPLAY '**  PCSSO166  PROCESSING ERROR **'               
A31802        DISPLAY '**  CLOSE ERROR OF PPMATRL OUTPUT FILE'          
A31802        DISPLAY '**  FILE STATUS = ' WS-PPMATRL-STATUS            
A31802        DISPLAY '**  PROCESSING TERMINATED      **'               
A31802        PERFORM 9900-ABEND THRU 9900-EXIT                         
A31802     END-IF.                                                      
A31802*                                                                 10210000
           CLOSE SCEGMTL-FILE.                                          
A31802     IF WS-SCEGMTL-SUCCESSFUL                                     
A31802        CONTINUE                                                  
A31802     ELSE                                                         
A31802        DISPLAY ' '                                               
A31802        DISPLAY '**  PCSSO166  PROCESSING ERROR **'               
A31802        DISPLAY '**  CLOSE ERROR OF SCEGMTL OUTPUT FILE'          
A31802        DISPLAY '**  FILE STATUS = ' WS-SCEGMTL-STATUS            
A31802        DISPLAY '**  PROCESSING TERMINATED      **'               
A31802        PERFORM 9900-ABEND THRU 9900-EXIT                         
A31802     END-IF.                                                      
A31802*    CLOSE XCEPTRPT-FILE.                                                 
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *   WRITE THE INTERFACE OR EXCEPTION REPORT                               
      **************************************************************            
      *                                                                         
       8000-WRITE-PP-STAT-INTERFACE.                                    
           MOVE SPACES TO WS-PPSTATS-REC.                               
HEX01      MOVE X'09'  TO PS-DLM-01, PS-DLM-02, PS-DLM-03,              
                          PS-DLM-04, PS-DLM-05, PS-DLM-06,              
                          PS-DLM-07, PS-DLM-08, PS-DLM-09,              
                          PS-DLM-10, PS-DLM-11, PS-DLM-12,              
                          PS-DLM-13.                                    
      * PREFIX THE COMPANY NUMBER WITH A 3 - REQD BY USER                       
           MOVE '3'    TO PS-PREFIX-3.                                  
           MOVE WU-WORK-ORDER-NM             TO  PS-POWER-PLT-WO.       
           MOVE PR-LOCATOR-ID(3:7)           TO  PS-PF-NO.              
           MOVE WS-GL-ACCOUNT-NO             TO  PS-GL-ACCOUNT-NO.      
           MOVE WS-GL-UTIL-ACCT-NO           TO  PS-GL-UTIL-ACCT-NO.    
           MOVE 'PSC'                        TO  PS-CUSTOMER.           
           MOVE WS-SERV-ORDER-NO(6:8)        TO  PS-WORK-ORDER-NO.      
           MOVE WS-PP-COMP-DATE              TO  PS-COMPLETION-DT.      
           MOVE WS-PIPE-TYPE-CD              TO  PS-PIPE-TYPE-CD.       
           IF WS-REVERSED                                               
              MOVE 'N' TO PS-REVERSE-N                                  
           END-IF.                                                      
      * FOR STUB INSTALL, THE INSTALLED COUNT IS 000.                           
           IF WS-STUB-INSTALL                                           
              MOVE '000'                     TO  PS-INSTALLED-COUNT     
           ELSE                                                         
              MOVE '001'                     TO  PS-INSTALLED-COUNT     
           END-IF.                                                      
           IF WU-FUNC-ACT-CD = 'PLSR' OR WU-FUNC-ACT-CD = 'STSR'        
              MOVE XO-SVC-LINE-INSTALL-DT(1:4) TO PS-VINTAGE-YEAR       
              IF XO-SERV-LINE-LEN-RTD = 0                               
                 MOVE XO-SERV-LINE-LENGTH       TO  WS-PP-PIPE-LENGTH   
              ELSE                                                      
                 MOVE XO-SERV-LINE-LEN-RTD      TO  WS-PP-PIPE-LENGTH   
              END-IF                                                    
              MOVE WS-PP-PIPE-LENGTH(5:5)       TO  PS-PIPE-LENGTH      
           ELSE                                                         
              MOVE '0000'                       TO PS-VINTAGE-YEAR      
              MOVE XO-SERV-LINE-LENGTH          TO  WS-PP-PIPE-LENGTH   
              MOVE WS-PP-PIPE-LENGTH(5:5)       TO  PS-PIPE-LENGTH      
           END-IF.                                                      
           MOVE WU-COST-CENTER               TO PS-COST-CENTER.         
           MOVE WS-PPSTATS-REC               TO   PPSTATS-REC.          
           WRITE PPSTATS-REC.                                           
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   WRITE THE MATERIAL INTERFACE                                 *        
      ******************************************************************        
      *                                                                         
       8100-WRITE-PP-MATL-INTERFACE.                                    
      *    MOVE SPACES TO WS-PPMATRL-REC.                                       
           MOVE WS-TRANSACTION-CODE          TO  PM-TRANSACTION-CD.     
           MOVE WS-IDENTIFIER-C              TO  PM-IDENTIFIER-C.       
           MOVE WU-MATL-ITEM-CD              TO  PM-MATL-ITEM-CD.       
           MOVE WS-MATL-IFACE-DATE           TO  PM-TRANSACTION-DATE.   
           MOVE WU-UOM-CD                    TO  PM-UOM.                
           IF WS-TRANSACTION-CODE = 'RET'                               
              MOVE '-' TO PM-MATL-QTY-SIGN                              
              MOVE '-' TO PM-TOTAL-AMT-SIGN                             
           ELSE                                                         
              MOVE '+' TO PM-MATL-QTY-SIGN                              
              MOVE '+' TO PM-TOTAL-AMT-SIGN                             
           END-IF.                                                      
           IF WS-REVERSED                                               
              MULTIPLY -1 BY WU-MATL-ITEM-QT                            
              MULTIPLY -1 BY WU-MATL-ITEM-TOT-AM                        
           END-IF.                                                      
           MOVE WU-MATL-ITEM-QT              TO  WS-WU-MATL-ITEM-QT.    
           MOVE WS-WU-MATL-ITEM-QT(4:6)      TO  PM-MATL-ITEM-QTY.      
           MOVE WU-MATL-ITEM-TOT-AM          TO  WS-WU-MATL-ITEM-TOT-AM.
           MOVE WS-WU-MATL-ITEM-TOT-AM       TO  PM-COST-PER-ITEM.      
           MOVE WU-WORK-ORDER-NM             TO  PM-WORK-ORDER-NO.      
           MOVE WU-COMPANY-NO                TO  PM-COMPANY-NO.         
           MOVE WS-WU-GL-ACCT-NO             TO  PM-GL-ACCT-NO.         
           MOVE WS-RESOURCE-CD               TO  PM-RESOURCE-CD.        
           MOVE WS-WU-FUNC-ACT-CD            TO  PM-FUNC-ACT-CD         
           MOVE WU-SERV-ORDER-NO             TO  PM-SERVICE-ORDER-NO.   
           MOVE WU-COST-CENTER               TO  PM-COST-CENTRE.        
           MOVE WS-A9-COUNTY                 TO  PM-COUNTY-CODE.        
           MOVE WS-A9-STATE                  TO  PM-STATE-CODE.         
           MOVE WS-PR-PREMISE-NO             TO  PM-PREMISE-NO.         
           MOVE WU-LOCAL-STORERM-ID          TO  PM-STORE-ROOM-ID.      
           MOVE WS-PPMATRL-REC               TO  PPMATRL-REC.           
           WRITE PPMATRL-REC.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   WRITE THE SCEG MATERIAL REPORT                               *        
      ******************************************************************        
      *                                                                         
       8200-WRITE-SCEG-MATL-RPT.                                        
           MOVE SPACES TO WS-SCEGMTL-REC.                               
           MOVE WU-SERV-ORDER-NO             TO  SM-SERVICE-ORDER-NO.   
           MOVE WU-COMP-UNIT-CD              TO  SM-COMP-UNIT-CD.       
           MOVE WU-CU-SEQ-NM                 TO  WS-SM-CU-SEQ-NM.       
           MOVE WS-SM-CU-SEQ-NM              TO  SM-CU-SEQ-NM.          
           MOVE WU-MATL-USAGE-CD             TO  SM-MATL-USAGE-CD.      
           MOVE WU-MATL-ITEM-CD              TO  SM-MATL-ITEM-CD.       
           MOVE WU-WORK-ORDER-NM             TO  SM-WORK-ORDER-NM.      
           MOVE WU-GL-ACCT-NO                TO  WS-SM-GL-ACCT-NO.      
           MOVE WS-SM-GL-ACCT-NO             TO  SM-GL-ACCT-NO.         
           MOVE WU-FUNC-ACT-CD               TO  SM-FUNC-ACT-CD.        
           MOVE WU-POINT                     TO  WS-SM-POINT.           
           MOVE WS-SM-POINT                  TO  SM-POINT.              
           MOVE WU-SPAN-TO-POINT             TO  WS-SM-SPAN-TO-POINT.   
           MOVE WS-SM-SPAN-TO-POINT          TO  SM-SPAN-TO-POINT.      
           MOVE WS-SCEGMTL-REC               TO  SCEGMTL-REC.           
           WRITE SCEGMTL-REC.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  TERMINATES THE PROGRAM                                     **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
A31802     PERFORM 7900-CLOSE-FILES               THRU 7900-EXIT.       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
