       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSSO165.                                            
       DATE-WRITTEN.                                                    
       AUTHOR. PADMA KONETI.                                            
      ******************************************************************00050000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00060000
      ******************************************************************00090000
      ******************************************************************00100000
      *               PROGRAM  MODIFICATION  LOG                       *00110000
      *                                                                *00120000
      *      DATE       INITIALS    REASON                             *00130000
      *      ----       --------    ------                             *        
A46404*    05/12/2009   PK98692     DAILY REPORT TO IDENTIFY THE       *00140000
      *                             INSTALL DT, PIPE DETAILS (ACT/RETD)*00140000
      *                             RETD DT CHANGES MADE TO A SVC LINE *00140000
A46404*    07/15/2009   PK98692     SWITCH ACTION TYPE AND SERVICE     *00140000
      *                             STATUS COLUMNS IN REPORT           *00140000
A4645 *    10/13/2009   PK98692     TO FLAG SVCS THAT ARE CHANGED &    *00140000
      *                             LATER DELETED. ADDED TWO NEW COLUMN*00140000
      *                             DELETED BY & DELETE COMMENTS       *00140000
PRDFIX*    12/29/2016   PK44514     ADD COMPANY NUMBER TO QUERY INSTALL*00140000
      *                             TYPE DESC FROM CSS_CODE_VALUE      *00140000
      ******************************************************************00221000
             REMARKS.                                                   
      ******************************************************************00240000
      *   THIS PROGRAM GENERATES A DAILY REPORT OF ALL CHANGES MADE TO *00250000
      *   INSTALL DATE, ACTIVE AND RETIRED PIPE DETAILS AND RETIRED    *00260000
      *   DATE ON SVCADMIN AND INSTALL DETAILS PANEL. THIS REPORT IS   *00260000
      *   FOR PSNC ONLY.                                               *00260000
      ******************************************************************00320000
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT FCSSO165-FILE ASSIGN  UT-S-FCSSO165                  
                   FILE STATUS IS WS-FSO165-STATUS.                     
      *                                                                         
           SELECT FCSSOXP1-FILE ASSIGN TO UT-S-FCSSOXP1                 
               FILE STATUS IS WS-FSOXP1-STATUS.                         
      *                                                                         
           SELECT FCSSOXP2-FILE ASSIGN TO UT-S-FCSSOXP2                 
               FILE STATUS IS WS-FSOXP2-STATUS.                         
                                                                        
                                                                        
            SELECT PRNTFILE      ASSIGN TO UT-S-PRNTFILE.               
                                                                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSSO165-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
       01  FSO165                       PIC X(700).                     
                                                                        
       FD  FCSSOXP1-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
       01  FSOXP1                          PIC X(80).                   
                                                                        
       FD  FCSSOXP2-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE  IS F                                         
           LABEL RECORDS   ARE STANDARD.                                
       01  FSOXP2                          PIC X(80).                   
                                                                        
       FD  PRNTFILE                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 95 CHARACTERS                                
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRNTFILE-RECORD                 PIC X(95).                   
                                                                        
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO165'.
MSQ017     COPY MFASQLM.
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR PCSSO165 STARTS HERE'.                  
                                                                        
       01  WS-MISC1.                                                    
           05 WS-PGRMNAME                 PIC X(10) VALUE 'PCSSO165'.   
           05 WS-PROGRAM-NAME             PIC X(08) VALUE 'PCSSO165'.   
           05 WS-FSO165-STATUS            PIC X(02) VALUE '00'.         
              88  WS-FSO165-SUCCESSFUL              VALUE '00'.         
           05 WS-FSOXP1-STATUS            PIC X(02) VALUE '00'.         
              88  WS-FSOXP1-SUCCESSFUL              VALUE '00'.         
           05 WS-FSOXP2-STATUS            PIC X(02) VALUE '00'.         
              88  WS-FSOXP2-SUCCESSFUL              VALUE '00'.         
           05 WS-EOF                      PIC X(01) VALUE 'N'.          
           05 WS-END-DATA                 PIC X(01) VALUE 'N'.          
           05 WS-Y                        PIC X(01) VALUE 'Y'.          
           05 WS-N                        PIC X(01) VALUE 'N'.          
           05 WS-SCEG                     PIC X(04) VALUE 'SCEG'.       
           05 WS-PSNC                     PIC X(04) VALUE 'PSNC'.       
           05 WS-START-DATE               PIC X(10) VALUE SPACES.       
           05 WS-END-DATE                 PIC X(10) VALUE SPACES.       
           05 WS-RUN-DATE                 PIC X(10) VALUE SPACES.       
           05 WS-PRNT-DATE.                                             
              10 WS-PRNT-CCYY             PIC X(04) VALUE SPACES.       
              10 FILLER                   PIC X(01) VALUE SPACES.       
              10 WS-PRNT-MM               PIC X(02) VALUE SPACES.       
              10 FILLER                   PIC X(01) VALUE SPACES.       
              10 WS-PRNT-DD               PIC X(02) VALUE SPACES.       
           05 WS-SO-NO                    PIC 9(13).                    
           05 WS-SO-NUM REDEFINES WS-SO-NO        PIC X(13).            
           05 WS-PREM-NO                  PIC 9(10).                    
           05 WS-PREM-NUM  REDEFINES WS-PREM-NO   PIC X(10).            
           05 WS-SVC-NUM                  PIC X(10).                    
           05 WS-SVC-NO    REDEFINES WS-SVC-NUM   PIC 9(10).            
                                                                        
      ******************************************************************        
      *     WORKING STORAGE FOR FILE VARIABLES                         *        
      ******************************************************************        
       01 WS-HEADER-LINES.                                              
          05 WS-HEADER-LINE4.                                           
             10 FILLER               PIC X(10) VALUE '  SERVICE '.      
             10 WS-FIL01             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(10) VALUE '  PREMISE '.      
HEX01        10 WS-FIL02             PIC X(01) VALUE X'09'.             
A46404*      10 FILLER               PIC X(16) VALUE '     ACTION     '.        
A46404       10 FILLER               PIC X(15) VALUE '    ACTION     '. 
             10 WS-FIL03             PIC X(01) VALUE X'05'.             
A46404*      10 FILLER               PIC X(16) VALUE '    SERVICE     '.        
A46404       10 FILLER               PIC X(15) VALUE '   SERVICE     '. 
             10 WS-FIL04             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(13) VALUE '   INSTALL   '.   
HEX01        10 WS-FIL05             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(20) VALUE                    
                                     '       INSTALL      '.            
             10 WS-FIL06             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(13) VALUE '   RETIRE    '.   
HEX01        10 WS-FIL07             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(20) VALUE                    
                                     '       RETIRE       '.            
             10 WS-FIL08             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(26) VALUE                    
                                      'TRANSACTION TIMESTAMP     '.     
             10 WS-FIL09             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(10) VALUE 'INSTALL DT'.      
HEX01        10 WS-FIL10             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(10) VALUE 'INSTALL DT'.      
HEX01        10 WS-FIL11             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE TYPE'.       
HEX01        10 WS-FIL12             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE TYPE'.       
HEX01        10 WS-FIL13             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE SIZE'.       
HEX01        10 WS-FIL14             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE SIZE'.       
HEX01        10 WS-FIL15             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE LEN '.       
HEX01        10 WS-FIL16             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE LEN '.       
HEX01        10 WS-FIL17             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(10) VALUE 'RETIRED DT'.      
HEX01        10 WS-FIL18             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(10) VALUE 'RETIRED DT'.      
HEX01        10 WS-FIL19             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE TYPE'.       
HEX01        10 WS-FIL20             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE TYPE'.       
HEX01        10 WS-FIL21             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE SIZE'.       
HEX01        10 WS-FIL22             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE SIZE'.       
HEX01        10 WS-FIL23             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE LEN '.       
HEX01        10 WS-FIL24             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'PIPE LEN '.       
HEX01        10 WS-FIL25             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(03) VALUE 'LO.'.             
HEX01        10 WS-FIL26             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(15) VALUE '  HOUSE NO     '. 
HEX01        10 WS-FIL27             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(05) VALUE 'ADDR '.           
HEX01        10 WS-FIL28             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(05) VALUE 'ADDR '.           
HEX01        10 WS-FIL29             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(30) VALUE 'STREET NAME'.     
HEX01        10 WS-FIL30             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(04) VALUE ' ST '.            
HEX01        10 WS-FIL31             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(11) VALUE '    ST     '.     
HEX01        10 WS-FIL32             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(04) VALUE ' ST '.            
HEX01        10 WS-FIL33             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(35) VALUE 'ADDR OVERFLOW'.   
HEX01        10 WS-FIL34             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(05) VALUE ' ZIP '.           
HEX01        10 WS-FIL35             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(04) VALUE 'ZIP '.            
HEX01        10 WS-FIL35A            PIC X(01) VALUE X'09'.             
A4645        10 FILLER               PIC X(40) VALUE                    
A4645        '           DELETED BY                   '.                
A4645        10 WS-FIL35B            PIC X(01) VALUE X'05'.             
A4645        10 FILLER               PIC X(17) VALUE                    
A4645                                'DELETION COMMENTS'.               
A4645        10 FILLER               PIC X(195) VALUE SPACES.           
                                                                        
          05 WS-HEADER-LINE5.                                           
             10 FILLER               PIC X(10) VALUE '    NO    '.      
             10 WS-FIL36             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(10) VALUE '    NO    '.      
HEX01        10 WS-FIL37             PIC X(01) VALUE X'09'.             
A46404*      10 FILLER               PIC X(16) VALUE '      TYPE      '.        
A46404       10 FILLER               PIC X(15) VALUE '     TYPE      '. 
             10 WS-FIL38             PIC X(01) VALUE X'05'.             
A46404*      10 FILLER               PIC X(16) VALUE '     STATUS     '.        
A46404       10 FILLER               PIC X(15) VALUE '    STATUS     '. 
             10 WS-FIL39             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(13) VALUE '      SO     '.   
HEX01        10 WS-FIL40             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(20) VALUE                    
                                     '      WORK TYPE     '.            
             10 WS-FIL41             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(13) VALUE '      SO     '.   
HEX01        10 WS-FIL42             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(20) VALUE                    
                                     '      WORK TYPE     '.            
             10 WS-FIL43             PIC X(01) VALUE X'05'.             
             10 FILLER               PIC X(26) VALUE SPACES.            
HEX01        10 WS-FIL44             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(10) VALUE ' PREV     '.      
HEX01        10 WS-FIL45             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(10) VALUE ' CHGD     '.      
HEX01        10 WS-FIL46             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE ' PREV    '.       
HEX01        10 WS-FIL47             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE ' CHGD    '.       
HEX01        10 WS-FIL48             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE ' PREV    '.       
HEX01        10 WS-FIL49             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE ' CHGD    '.       
HEX01        10 WS-FIL50             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE ' PREV    '.       
HEX01        10 WS-FIL51             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE ' CHGD    '.       
HEX01        10 WS-FIL52             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(10) VALUE ' PREV     '.      
HEX01        10 WS-FIL53             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(10) VALUE ' CHGD     '.      
HEX01        10 WS-FIL54             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'RETD PREV'.       
HEX01        10 WS-FIL55             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'RETD CHGD'.       
HEX01        10 WS-FIL56             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'RETD PREV'.       
HEX01        10 WS-FIL57             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'RETD CHGD'.       
HEX01        10 WS-FIL58             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'RETD PREV'.       
HEX01        10 WS-FIL59             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(09) VALUE 'RETD CHGD'.       
HEX01        10 WS-FIL60             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(03) VALUE 'OFF'.             
HEX01        10 WS-FIL61             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(15) VALUE SPACES.            
HEX01        10 WS-FIL62             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(05) VALUE 'PFX 1'.           
HEX01        10 WS-FIL63             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(05) VALUE 'PFX 2'.           
HEX01        10 WS-FIL64             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(30) VALUE SPACES.            
HEX01        10 WS-FIL65             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(04) VALUE 'LOC1'.            
HEX01        10 WS-FIL66             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(11) VALUE '    LOC2   '.     
HEX01        10 WS-FIL67             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(04) VALUE 'SUFF'.            
HEX01        10 WS-FIL68             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(35) VALUE SPACES.            
HEX01        10 WS-FIL69             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(05) VALUE 'CODE '.           
HEX01        10 WS-FIL70             PIC X(01) VALUE X'09'.             
             10 FILLER               PIC X(04) VALUE ' +4 '.            
HEX01        10 WS-FIL70A            PIC X(01) VALUE X'09'.             
A4645        10 FILLER               PIC X(40) VALUE SPACES.            
HEX01        10 WS-FIL70B            PIC X(01) VALUE X'09'.             
A4645        10 FILLER               PIC X(212) VALUE SPACES.           
                                                                        
       01 WS-DETAIL-LINE.                                               
          05 WS-DETAIL-LINE1.                                           
             10 D-SERVICE-NO         PIC X(10) VALUE SPACES.            
             10 WS-FIL71             PIC X(01) VALUE SPACES.            
             10 D-PREMISE-NO         PIC X(10) VALUE SPACES.            
             10 WS-FIL72             PIC X(01) VALUE SPACES.            
A46404*      10 D-SERVICE-STATUS     PIC X(16) VALUE SPACES.                    
A46404       10 D-ACTION-TYPE        PIC X(15) VALUE SPACES.            
             10 WS-FIL73             PIC X(01) VALUE SPACES.            
A46404*      10 D-ACTION-TYPE        PIC X(16) VALUE SPACES.                    
A46404       10 D-SERVICE-STATUS     PIC X(15) VALUE SPACES.            
             10 WS-FIL74             PIC X(01) VALUE SPACES.            
             10 D-INSTALL-SO         PIC X(13) VALUE SPACES.            
             10 WS-FIL75             PIC X(01) VALUE SPACES.            
             10 D-INSTALL-WK-TYPE    PIC X(20) VALUE SPACES.            
             10 WS-FIL76             PIC X(01) VALUE SPACES.            
             10 D-RETIRE-SO          PIC X(13) VALUE SPACES.            
             10 WS-FIL77             PIC X(01) VALUE SPACES.            
             10 D-RETIRE-WK-TYPE     PIC X(20) VALUE SPACES.            
             10 WS-FIL78             PIC X(01) VALUE SPACES.            
             10 D-TRANS-TIMESTMP     PIC X(26) VALUE SPACES.            
             10 WS-FIL79             PIC X(01) VALUE SPACES.            
             10 D-INSTALL-DT-PREV    PIC X(10) VALUE SPACES.            
             10 WS-FIL80             PIC X(01) VALUE SPACES.            
             10 D-INSTALL-DT-CHGD    PIC X(10) VALUE SPACES.            
             10 WS-FIL81             PIC X(01) VALUE SPACES.            
             10 D-PIPE-TYPE-PREV     PIC X(09) VALUE SPACES.            
             10 WS-FIL82             PIC X(01) VALUE SPACES.            
             10 D-PIPE-TYPE-CHGD     PIC X(09) VALUE SPACES.            
             10 WS-FIL83             PIC X(01) VALUE SPACES.            
             10 D-PIPE-SIZE-PREV     PIC X(09) VALUE SPACES.            
             10 WS-FIL84             PIC X(01) VALUE SPACES.            
             10 D-PIPE-SIZE-CHGD     PIC X(09) VALUE SPACES.            
             10 WS-FIL85             PIC X(01) VALUE SPACES.            
             10 D-PIPE-LEN-PREV      PIC X(09) VALUE SPACES.            
             10 WS-FIL86             PIC X(01) VALUE SPACES.            
             10 D-PIPE-LEN-CHGD      PIC X(09) VALUE SPACES.            
             10 WS-FIL87             PIC X(01) VALUE SPACES.            
             10 D-RETIRED-DT-PREV    PIC X(10) VALUE SPACES.            
             10 WS-FIL88             PIC X(01) VALUE SPACES.            
             10 D-RETIRED-DT-CHGD    PIC X(10) VALUE SPACES.            
             10 WS-FIL89             PIC X(01) VALUE SPACES.            
             10 D-PIPE-TYPE-RETD-P   PIC X(09) VALUE SPACES.            
             10 WS-FIL90             PIC X(01) VALUE SPACES.            
             10 D-PIPE-TYPE-RETD-C   PIC X(09) VALUE SPACES.            
             10 WS-FIL91             PIC X(01) VALUE SPACES.            
             10 D-PIPE-SIZE-RETD-P   PIC X(09) VALUE SPACES.            
             10 WS-FIL92             PIC X(01) VALUE SPACES.            
             10 D-PIPE-SIZE-RETD-C   PIC X(09) VALUE SPACES.            
             10 WS-FIL93             PIC X(01) VALUE SPACES.            
             10 D-PIPE-LEN-RETD-P    PIC X(09) VALUE SPACES.            
             10 WS-FIL94             PIC X(01) VALUE SPACES.            
             10 D-PIPE-LEN-RETD-C    PIC X(09) VALUE SPACES.            
             10 WS-FIL95             PIC X(01) VALUE SPACES.            
             10 D-LOCAL-OFFICE       PIC X(03) VALUE SPACES.            
             10 WS-FIL96             PIC X(01) VALUE SPACES.            
             10 D-HOUSE-NO           PIC X(15) VALUE SPACES.            
             10 WS-FIL97             PIC X(01) VALUE SPACES.            
             10 D-ADDR-PFX-1         PIC X(05) VALUE SPACES.            
             10 WS-FIL98             PIC X(01) VALUE SPACES.            
             10 D-ADDR-PFX-2         PIC X(05) VALUE SPACES.            
             10 WS-FIL99             PIC X(01) VALUE SPACES.            
             10 D-STREET-NAME        PIC X(30) VALUE SPACES.            
             10 WS-FIL100            PIC X(01) VALUE SPACES.            
             10 D-ST-LOCN-1          PIC X(04) VALUE SPACES.            
             10 WS-FIL101            PIC X(01) VALUE SPACES.            
             10 D-ST-LOCN-2          PIC X(11) VALUE SPACES.            
             10 WS-FIL102            PIC X(01) VALUE SPACES.            
             10 D-ST-SUFFIX          PIC X(04) VALUE SPACES.            
             10 WS-FIL103            PIC X(01) VALUE SPACES.            
             10 D-ADDR-OVERFLOW      PIC X(35) VALUE SPACES.            
             10 WS-FIL104            PIC X(01) VALUE SPACES.            
             10 D-ZIP-CODE           PIC X(05) VALUE SPACES.            
             10 WS-FIL105            PIC X(01) VALUE SPACES.            
             10 D-ZIP-FOUR           PIC X(04) VALUE SPACES.            
A4645        10 WS-FIL106            PIC X(01) VALUE SPACES.            
A4645        10 D-DELETED-BY         PIC X(40) VALUE SPACES.            
A4645        10 WS-FIL107            PIC X(01) VALUE SPACES.            
A4645        10 D-DELETION-CMNTS     PIC X(212) VALUE SPACES.           
      *                                                                         
       01  MAILHEAD-1.                                                  
           05  FILLER                      PIC X(22) VALUE              
                      'HELO DOMAIN:     SCANA'.                         
      *                                                                         
       01  MAILHEAD-2.                                                  
           05 FILLER                       PIC X(14) VALUE              
                      'MAIL FROM:   <'.                                 
           05 MAIL2-JOB-NAME               PIC X(07) VALUE 'CSRS165'.   
           05 FILLER                       PIC X(20) VALUE              
                      '@SCEGJES2.SCANA.COM>'.                           
      *                                                                         
       01  MAILHEAD-3.                                                  
           05 FILLER                       PIC X(41) VALUE              
                      'RCPT TO: <PK44514@SCANA.COM>'.                   
      *                                                                         
       01  MAILHEAD-4.                                                  
           05 FILLER                       PIC X(04) VALUE              
                      'DATA'.                                           
      *                                                                         
       01  MAILHEAD-5.                                                  
           05 FILLER                       PIC X(18) VALUE              
                      'FROM: CSR PAGING <'.                             
           05 MAIL5-JOB-NAME               PIC X(07) VALUE 'CSRS165'.   
           05 FILLER                       PIC X(20) VALUE              
                      '@SCEGJES2.SCANA.COM>'.                           
      *                                                                         
       01  MAILHEAD-6-1.                                                
           05 FILLER                       PIC X(35) VALUE              
                      'TO: <PSNCPLANTACCOUNTING@SCANA.COM>'.            
      *                                                                         
       01  MAILHEAD-6-2.                                                
           05 FILLER                       PIC X(36) VALUE              
                      'TO: <PK44514@SCANA.COM>'.                        
      *                                                                         
       01  MAILHEAD-6-3.                                                
           05 FILLER                       PIC X(24) VALUE              
                      'CC: <LWCRONIN@SCANA.COM>'.                       
      *                                                                         
       01  MAILHEAD-6-4.                                                
           05 FILLER                       PIC X(20) VALUE              
                      'CC: <PDAS@SCANA.COM>'.                           
      *                                                                         
       01  MAILHEAD-7.                                                  
           05 FILLER                       PIC X(10) VALUE              
                      'SUBJECT:  '.                                     
           05 MAIL7-SUBJECT                PIC X(30) VALUE              
                 'Date and Pipe Info Changes => '.                      
           05 WS-SUB-DATE1                PIC X(10) VALUE SPACES.       
           05 FILLER                      PIC X(04) VALUE ' TO '.       
           05 WS-SUB-DATE2                PIC X(10) VALUE SPACES.       
      *                                                                         
       01  MAILHEAD-8.                                                  
           05 FILLER                       PIC X(80) VALUE SPACES.      
      *                                                                         
       01  MAILDTLS-1.                                                  
           05 FILLER                       PIC X(42) VALUE              
             'The file has been successfully saved at : '.              
      *                                                                         
       01  MAILDTLS-2.                                                  
           05 FILLER                       PIC X(42) VALUE              
              '\\Scana\Shares\groupdirs\0573\Reports\CSR\'.             
           05 FILLER                       PIC X(15) VALUE              
              'Date_Pipe_Chgs_'.                                        
           05 WS-FILE-DATE.                                             
              10 WS-FILE-MM                PIC X(02) VALUE SPACES.      
              10 WS-FILE-DD                PIC X(02) VALUE SPACES.      
              10 WS-FILE-CCYY              PIC X(04) VALUE SPACES.      
           05 FILLER                       PIC X(04) VALUE '.txt'.      
                                                                        
      **XCOM FILE CREATION VARIABLES                                            
       01  WS-XCOM-REC.                                                 
           05 X-PATH                       PIC X(47)   VALUE            
              'FILE=\\Scana\Shares\groupdirs\0573\Reports\CSR\'.        
           05 X-FILENAME                   PIC X(15)   VALUE            
              'Date_Pipe_Chgs_'.                                        
           05 X-DATE.                                                   
              10 X-MM                      PIC X(02)   VALUE SPACES.    
              10 X-DD                      PIC X(02)   VALUE SPACES.    
              10 X-CCYY                    PIC X(04)   VALUE SPACES.    
           05 X-EXTN                       PIC X(04)   VALUE '.TXT'.    
           05 FILLER                       PIC X(12)   VALUE SPACES.    
                                                                        
      *                                                                         
                                                                        
       COPY CWS00038.                                                   01270000
       COPY CWS09900.                                                   01280000
       COPY CWS00303.                                                   01290000
       COPY FIOJC01.                                                    01300000
                                                                        
      ***************************************************************** 01320000
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_JOB_PARM            (PREFIX = G6)                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MNT_TRANS_HIST      (PREFIX = MH)                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBMNHIST                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET      (PREFIX = MI)                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBMNHDT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_PREMISE             (PREFIX = PR)                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBPREM                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_GAS_SERV_LINE       (PREFIX = XO)                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBGASSRV                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_ORDER_INST       (PREFIX = VI)                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBSOODR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * HST_SO_ORDER_INST       (PREFIX = ZG)                        *          
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBHSTODR                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_DATA             (PREFIX = VO)                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * HST_SO_DATA             (PREFIX = YV)                        *          
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBHSTDAT                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ADDR_FORMATTED     (PREFIX = DY)                         *          
      ***************************************************************** 01320000
           EXEC SQL                                                     01350000
                INCLUDE TBADRFMT                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_GASLINE_SO_XRF     (PREFIX = XX)                         *          
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBGASSO                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_WORK_TYPE          (PREFIX = L4)                                    
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBWKTYP                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CODE_VALUE         (PREFIX = UV)                                    
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBCDVALU                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_USER_PROFILE       (PREFIX = PF)                                    
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBUSRPRF                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING THE TRANHIST HEADER ROW INFORAMTION THAT  *         
      * HAVE INSTALL DT, RETD DT, PIPE INFO CHANGES IN TRANHIST DETLS *         
      *****************************************************************         
           EXEC SQL                                                     
                DECLARE CHANGED-DTLS CURSOR FOR                         
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                           
                        PR.PREMISE_NO                                   
                   FROM CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)             
                       ,CSS_PREMISE        PR WITH(READUNCOMMITTED)             
                  WHERE DATE_TRANS         >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )            
                    AND DATE_TRANS         <  IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )              
                    AND MH.APPL_PROGRAM_ID = 'PANEL531'                 
                    AND MH.CODE_TRAN_TYPE  = 'F'                        
                    AND MH.ACCOUNT_NO      = 0                          
                    AND MH.CUSTOMER_NO     = 0                          
                    AND PR.PREMISE_NO      = MH.PREMISE_NO              
                    AND PR.COMPANY_NO      = '26'                       
                    AND EXISTS                                          
                         (SELECT 1                                      
                          FROM   CSS_MT_TRN_HST_DET MI
                           WITH(READUNCOMMITTED)                  
                          WHERE  MI.TRANS_HIST_SEQ_NO =                 
                                              MH.TRANS_HIST_SEQ_NO      
                          AND    MI.TRAN_APPL_NO     >  1               
                          AND    TABLE_ID            =  ' '             
                          AND    MI.COLUMN_DESC IN (                    
                                    'INSTALL DATE'  , 'RETIRED DATE',   
                                    'PIPE TYPE'     , 'PIPE SIZE',      
                                    'PIPE LENGTH'   , 'PIPE TYPE RETD', 
                                    'PIPE SIZE RETD', 'PIPE LEN RETD')) 
                    AND EXISTS                                          
                         (SELECT 1                                      
                          FROM   CSS_MT_TRN_HST_DET MI
                           WITH(READUNCOMMITTED)                  
                          WHERE  MI.TRANS_HIST_SEQ_NO =                 
                                              MH.TRANS_HIST_SEQ_NO      
                          AND    MI.TRAN_APPL_NO     =  1               
                          AND    TABLE_ID            =  ' '             
                          AND    MI.COLUMN_DESC      = 'GAS SVC NO'     
                          AND    MI.PRV_COLUMN_VALUE <> '*NEW*'         
                          AND    MI.CHG_COLUMN_VALUE <> '*DELETED*')    
               UNION                                                    
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                           
                        PR.PREMISE_NO                                   
                   FROM CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)             
                       ,CSS_PREMISE        PR WITH(READUNCOMMITTED)             
                  WHERE DATE_TRANS         >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )            
                    AND DATE_TRANS         <  IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )              
                    AND MH.APPL_PROGRAM_ID = 'PANEL523T'                
                    AND MH.CODE_TRAN_TYPE  = 'F'                        
                    AND MH.ACCOUNT_NO      = 0                          
                    AND MH.CUSTOMER_NO     = 0                          
                    AND PR.PREMISE_NO      = MH.PREMISE_NO              
                    AND PR.COMPANY_NO      = '26'                       
                    AND EXISTS                                          
                         (SELECT 1                                      
                          FROM   CSS_MT_TRN_HST_DET MI
                           WITH(READUNCOMMITTED)                  
                          WHERE  MI.TRANS_HIST_SEQ_NO =                 
                                              MH.TRANS_HIST_SEQ_NO      
                          AND    MI.PRV_COLUMN_VALUE <> '*NEW*'         
                          AND    MI.CHG_COLUMN_VALUE <> '*DELETED*'     
                          AND    MI.TRAN_APPL_NO     >  1               
                          AND    TABLE_ID            =  ' '             
                          AND    MI.COLUMN_DESC      = 'INSTALL DATE')  
                  ORDER BY  1                                           
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CHANGED-DTLS CURSOR FOR                                 
MFA-TR*          SELECT MH.TRANS_HIST_SEQ_NO,                                   
MFA-TR*                 PR.PREMISE_NO                                           
MFA-TR*            FROM CSS_MNT_TRANS_HIST MH                                   
MFA-TR*                ,CSS_PREMISE        PR                                   
MFA-TR*           WHERE DATE_TRANS         >= :WS-START-DATE                    
MFA-TR*             AND DATE_TRANS         <  :WS-END-DATE                      
MFA-TR*             AND MH.APPL_PROGRAM_ID = 'PANEL531'                         
MFA-TR*             AND MH.CODE_TRAN_TYPE  = 'F'                                
MFA-TR*             AND MH.ACCOUNT_NO      = 0                                  
MFA-TR*             AND MH.CUSTOMER_NO     = 0                                  
MFA-TR*             AND PR.PREMISE_NO      = MH.PREMISE_NO                      
MFA-TR*             AND PR.COMPANY_NO      = '26'                               
MFA-TR*             AND EXISTS                                                  
MFA-TR*                  (SELECT 1                                              
MFA-TR*                   FROM   CSS_MT_TRN_HST_DET MI                          
MFA-TR*                   WHERE  MI.TRANS_HIST_SEQ_NO =                         
MFA-TR*                                       MH.TRANS_HIST_SEQ_NO              
MFA-TR*                   AND    MI.TRAN_APPL_NO     >  1                       
MFA-TR*                   AND    TABLE_ID            =  ' '                     
MFA-TR*                   AND    MI.COLUMN_DESC IN (                            
MFA-TR*                             'INSTALL DATE'  , 'RETIRED DATE',           
MFA-TR*                             'PIPE TYPE'     , 'PIPE SIZE',              
MFA-TR*                             'PIPE LENGTH'   , 'PIPE TYPE RETD',         
MFA-TR*                             'PIPE SIZE RETD', 'PIPE LEN RETD'))         
MFA-TR*             AND EXISTS                                                  
MFA-TR*                  (SELECT 1                                              
MFA-TR*                   FROM   CSS_MT_TRN_HST_DET MI                          
MFA-TR*                   WHERE  MI.TRANS_HIST_SEQ_NO =                         
MFA-TR*                                       MH.TRANS_HIST_SEQ_NO              
MFA-TR*                   AND    MI.TRAN_APPL_NO     =  1                       
MFA-TR*                   AND    TABLE_ID            =  ' '                     
MFA-TR*                   AND    MI.COLUMN_DESC      = 'GAS SVC NO'             
MFA-TR*                   AND    MI.PRV_COLUMN_VALUE <> '*NEW*'                 
MFA-TR*                   AND    MI.CHG_COLUMN_VALUE <> '*DELETED*')            
MFA-TR*        UNION                                                            
MFA-TR*          SELECT MH.TRANS_HIST_SEQ_NO,                                   
MFA-TR*                 PR.PREMISE_NO                                           
MFA-TR*            FROM CSS_MNT_TRANS_HIST MH                                   
MFA-TR*                ,CSS_PREMISE        PR                                   
MFA-TR*           WHERE DATE_TRANS         >= :WS-START-DATE                    
MFA-TR*             AND DATE_TRANS         <  :WS-END-DATE                      
MFA-TR*             AND MH.APPL_PROGRAM_ID = 'PANEL523T'                        
MFA-TR*             AND MH.CODE_TRAN_TYPE  = 'F'                                
MFA-TR*             AND MH.ACCOUNT_NO      = 0                                  
MFA-TR*             AND MH.CUSTOMER_NO     = 0                                  
MFA-TR*             AND PR.PREMISE_NO      = MH.PREMISE_NO                      
MFA-TR*             AND PR.COMPANY_NO      = '26'                               
MFA-TR*             AND EXISTS                                                  
MFA-TR*                  (SELECT 1                                              
MFA-TR*                   FROM   CSS_MT_TRN_HST_DET MI                          
MFA-TR*                   WHERE  MI.TRANS_HIST_SEQ_NO =                         
MFA-TR*                                       MH.TRANS_HIST_SEQ_NO              
MFA-TR*                   AND    MI.PRV_COLUMN_VALUE <> '*NEW*'                 
MFA-TR*                   AND    MI.CHG_COLUMN_VALUE <> '*DELETED*'             
MFA-TR*                   AND    MI.TRAN_APPL_NO     >  1                       
MFA-TR*                   AND    TABLE_ID            =  ' '                     
MFA-TR*                   AND    MI.COLUMN_DESC      = 'INSTALL DATE')          
MFA-TR*           ORDER BY  1                                                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                           PIC X(40) VALUE             
                      'WORKING STORAGE FOR PCSSO165 ENDS HERE  '.       
                                                                        
      ******************************************************************        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS MAIN PATH OF PROGRAM                           *        
      ******************************************************************        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZATION         THRU 1000-EXIT.          
                                                                        
           PERFORM 2000-MAIN-PROCESS           THRU 2000-EXIT.          
                                                                        
           PERFORM 2200-UPDATE-END-DATE        THRU 2200-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    1000-INITIALIZATION.                                        *        
      *         OPENS FSCSO165-FILE AND WRITES THE REPORT TITLE.       *        
      ******************************************************************        
       1000-INITIALIZATION.                                             
                                                                        
           DISPLAY '**************************************************'.
           DISPLAY '** PROGRAM NAME: ' WS-PROGRAM-NAME.                 
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           OPEN OUTPUT  FCSSO165-FILE.                                  
                                                                        
           IF WS-FSO165-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**       PCSSO165 PROCESSING ERROR         **'   
              DISPLAY '     OPEN ERROR OF FCSSO165 OUTPUT FILE '        
              DISPLAY '     FILE STATUS = ' WS-FSO165-STATUS            
              DISPLAY '**         PROCESSING TERMINATED           **'   
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           OPEN INPUT  FCSSOXP1-FILE.                                   
           IF WS-FSOXP1-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**       PCSSO165 PROCESSING ERROR         **'   
              DISPLAY '     OPEN ERROR OF FCSSOXP1 INPUT FILE '         
              DISPLAY '     FILE STATUS = ' WS-FSOXP1-STATUS            
              DISPLAY '**         PROCESSING TERMINATED           **'   
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSSOXP2-FILE.                                   
                                                                        
           MOVE SPACES TO WS-DETAIL-LINE1.                              
           OPEN OUTPUT PRNTFILE.                                        
                                                                        
           PERFORM 7100-GET-START-DATE     THRU 7100-EXIT.              
           PERFORM 7150-GET-END-DATE       THRU 7150-EXIT.              
           PERFORM 8050-WRITE-RPT-HEADER2  THRU 8050-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2000-MAIN-PROCESS                                           *        
      *         DOES THE MAIN REPORT PROCESSING.                       *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
           PERFORM 7200-OPEN-CHANGED-CURSOR         THRU 7200-EXIT.     
                                                                        
           PERFORM 7225-FETCH-CHANGED-CURSOR        THRU 7225-EXIT.     
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
                                                                        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                                                                        
                  MOVE MH-TRANS-HIST-SEQ-NO     TO   D-TRANS-TIMESTMP   
                  MOVE PR-PREMISE-NO            TO   WS-PREM-NO         
                  MOVE WS-PREM-NUM              TO   D-PREMISE-NO       
                                                                        
                  PERFORM 7300-SELECT-ADDR-DTLS THRU 7300-EXIT          
                                                                        
                  MOVE DY-HOUSE-NO              TO   D-HOUSE-NO         
                  MOVE DY-ADDR-PREFIX-1         TO   D-ADDR-PFX-1       
                  MOVE DY-ADDR-PREFIX-2         TO   D-ADDR-PFX-2       
                  MOVE DY-STREET-NAME           TO   D-STREET-NAME      
                  MOVE DY-STREET-LOCATION-1     TO   D-ST-LOCN-1        
                  MOVE DY-STREET-LOCATION-2     TO   D-ST-LOCN-2        
                  MOVE DY-STREET-SUFFIX         TO   D-ST-SUFFIX        
                  MOVE DY-ADDRESS-OVERFLOW      TO   D-ADDR-OVERFLOW    
                  MOVE DY-ZIP-CODE              TO   D-ZIP-CODE         
                  MOVE DY-ZIP-CODE-PLUS-FOUR    TO   D-ZIP-FOUR         
                  MOVE PR-LOCAL-OFFICE          TO   D-LOCAL-OFFICE     
                                                                        
                  PERFORM 7400-SELECT-SVC-DTLS   THRU 7400-EXIT         
                  PERFORM 7500-SELECT-SO-DTLS    THRU 7500-EXIT         
                  PERFORM 7600-SELECT-DATE-CHGS  THRU 7600-EXIT         
                  PERFORM 7700-SELECT-TYPE-CHGS  THRU 7700-EXIT         
                  PERFORM 7800-SELECT-SIZE-CHGS  THRU 7800-EXIT         
                  PERFORM 7900-SELECT-LEN-CHGS   THRU 7900-EXIT         
                                                                        
                  PERFORM 8500-WRITE-DETAIL          THRU 8500-EXIT     
                                                                        
                  PERFORM 7225-FETCH-CHANGED-CURSOR  THRU 7225-EXIT     
              END-PERFORM                                               
                                                                        
           END-IF.                                                      
           PERFORM 3000-PROCESS-XCOM                 THRU 3000-EXIT     
             UNTIL WS-EOF = 'Y'                                         
           PERFORM 8600-WRITE-PRNTFILE               THRU 8600-EXIT.    
           PERFORM 7250-CLOSE-CHANGED-CURSOR         THRU 7250-EXIT.    
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2200-UPDATE-END-DATE                                        *        
      *    GETS THE DATE TO UPDATE THE JOB PARM AFTER JOB COMPLETION   *        
      ******************************************************************        
       2200-UPDATE-END-DATE.                                            
                                                                        
           MOVE WS-END-DATE                   TO G6-PARM-DATA.          
                                                                        
           PERFORM 7990-UPDATE-ENDDATE        THRU 7990-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    3000-PROCESS-XCOM                                           *        
      *         APPENDS FILENAME WITH PROCESS DATE                     *        
      ******************************************************************        
      *                                                                         
       3000-PROCESS-XCOM.                                               
                                                                        
           READ FCSSOXP1-FILE AT END MOVE 'Y' TO WS-EOF.                
                                                                        
                                                                        
           IF WS-EOF = 'N'                                              
              IF FSOXP1(1:7) = 'FILE=\\'                                
                 MOVE WS-SUB-DATE2         TO  WS-PRNT-DATE             
                 MOVE WS-PRNT-MM           TO  X-MM                     
                 MOVE WS-PRNT-DD           TO  X-DD                     
                 MOVE WS-PRNT-CCYY         TO  X-CCYY                   
                                                                        
                 WRITE FSOXP2        FROM WS-XCOM-REC                   
                 MOVE 'Y'            TO WS-EOF                          
              ELSE                                                      
                 WRITE FSOXP2        FROM FSOXP1                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7100-GET-START-DATE                                          *        
      *        GETS THE PROCESS DATE FOR THE REPORT.                   *        
      ******************************************************************        
       7100-GET-START-DATE.                                             
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT CIS.SUBSTR3(PARM_DATA,1,10)                           
                  INTO :WS-START-DATE                                   
                  FROM CSS_JOB_PARM                                     
                 WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                  
                   AND COMPANY_NO   = '26'                              
                   AND CMND_CODE    = 'DATE'                            
                   AND SEQ_NO       = 1                                 
                   AND STATUS       = 'A'                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUBSTR(PARM_DATA,1,10)                                   
MFA-TR*           INTO :WS-START-DATE                                           
MFA-TR*           FROM CSS_JOB_PARM                                             
MFA-TR*          WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                          
MFA-TR*            AND COMPANY_NO   = '26'                                      
MFA-TR*            AND CMND_CODE    = 'DATE'                                    
MFA-TR*            AND SEQ_NO       = 1                                         
MFA-TR*            AND STATUS       = 'A'                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7100-GET-START-DATE **'       
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  JOB PARM DATE= ' WS-START-DATE               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7150-GET-END-DATE                                           *        
      *    GETS THE END DATE FOR EXTRACTING DATA                       *        
      ******************************************************************        
       7150-GET-END-DATE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 7, IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) )
            INTO
              :WS-END-DATE          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-END-DATE = DATE(:WS-START-DATE) + 7 DAYS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 6, IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) )
            INTO
              :WS-SUB-DATE2         
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-SUB-DATE2 = DATE(:WS-START-DATE) + 6 DAYS                 
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7200-OPEN-CHANGED-CURSOR                                     *        
      *        OPENS THE CHANGED CURSOR TO FETCH ROWS                  *        
      ******************************************************************        
       7200-OPEN-CHANGED-CURSOR.                                        
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN CHANGED-DTLS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7200-OPEN-CHANGED-CURSOR'    
              DISPLAY '**  OPEN CHANGED CURSOR'                         
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7225-FETCH-CHANGED-CURSOR                                    *        
      *        GETS THE CHANGED INFO                                   *        
      ******************************************************************        
                                                                        
       7225-FETCH-CHANGED-CURSOR.                                       
                                                                        
           MOVE '7225'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH CHANGED-DTLS                                        
               INTO :MH-TRANS-HIST-SEQ-NO,                              
                    :PR-PREMISE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7225-FETCH-CHANGED-CURSOR'    
              DISPLAY '**  FETCH REVISED CURSOR'                        
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7250-CLOSE-CHANGED-CURSOR                                    *        
      *        CLOSING CHANGED CURSOR                                  *        
      ******************************************************************        
                                                                        
       7250-CLOSE-CHANGED-CURSOR.                                       
                                                                        
           MOVE '7250'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE CHANGED-DTLS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7250-CLOSE-CHANGED-CURSOR'    
              DISPLAY '**  CLOSE REVISED CURSOR '                       
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7300-SELECT-ADDR-DTLS.*                                               
      *                                                                *        
      ******************************************************************        
                                                                        
       7300-SELECT-ADDR-DTLS.                                           
                                                                        
           MOVE '7300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT  DY.HOUSE_NO                                     
                       ,DY.ADDR_PREFIX_1                                
                       ,DY.ADDR_PREFIX_2                                
                       ,DY.STREET_NAME                                  
                       ,DY.STREET_LOCATION_1                            
                       ,DY.STREET_LOCATION_2                            
                       ,DY.STREET_SUFFIX                                
                       ,DY.ADDRESS_OVERFLOW                             
                       ,DY.ZIP_CODE                                     
                       ,DY.ZIP_CODE_PLUS_FOUR                           
                       ,PR.LOCAL_OFFICE                                 
               INTO     :DY-HOUSE-NO                                    
                       ,:DY-ADDR-PREFIX-1                               
                       ,:DY-ADDR-PREFIX-2                               
                       ,:DY-STREET-NAME                                 
                       ,:DY-STREET-LOCATION-1                           
                       ,:DY-STREET-LOCATION-2                           
                       ,:DY-STREET-SUFFIX                               
                       ,:DY-ADDRESS-OVERFLOW                            
                       ,:DY-ZIP-CODE                                    
                       ,:DY-ZIP-CODE-PLUS-FOUR                          
                       ,:PR-LOCAL-OFFICE                                
              FROM      CSS_PREMISE PR                                  
                       ,CSS_ADDR_FORMATTED DY                           
              WHERE    PR.PREMISE_NO = :PR-PREMISE-NO                   
              AND      DY.ADDRESS_ID = PR.ADDRESS_ID                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7300-SELECT-ADDR-DTLS'        
              DISPLAY '**  SELECT ADDRESS DETAILS'                      
              DISPLAY '**  PREMISE NO   = ' PR-PREMISE-NO               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7400-SELECT-SVC-DTLS.*                                                
      *                                                                *        
      ******************************************************************        
                                                                        
       7400-SELECT-SVC-DTLS.                                            
                                                                        
           MOVE '7400'                       TO    WS-ACTIVE-PARAGRAPH. 
           PERFORM 7410-SELECT-SVC-NO        THRU  7410-EXIT.           
           MOVE MI-PRV-COLUMN-VALUE-TEXT     TO    D-SERVICE-NO         
                                                   WS-SVC-NUM.          
           MOVE WS-SVC-NO                    TO    XO-SERVICE-NO.       
           DISPLAY 'SVC=NO - ', XO-SERVICE-NO, ' ', WS-SVC-NO.          
           PERFORM 7420-SELECT-SVC-INFO      THRU  7420-EXIT.           
A4645      IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
A4645         MOVE 'DELETED'                    TO   D-SERVICE-STATUS   
A4645         MOVE 'DELETED'                    TO   D-ACTION-TYPE      
A4645         PERFORM 7960-GET-SVC-DELETE-DTLS  THRU 7960-EXIT          
A4645         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
A4645            MOVE MH-USER-ID           TO D-DELETED-BY              
A4645            MOVE MH-TRAN-COMMENT-TEXT TO D-DELETION-CMNTS          
A4645            PERFORM 7962-GET-DELETE-USER-NAME  THRU 7962-EXIT      
A4645            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
A4645               STRING PF-LAST-NAME   DELIMITED BY SPACE            
A4645                      ','            DELIMITED BY SIZE             
A4645                      PF-FIRST-NAME  DELIMITED BY SPACE            
A4645                      ' '            DELIMITED BY SIZE             
A4645                      PF-MIDDLE-NAME DELIMITED BY SPACE            
A4645                      INTO D-DELETED-BY                            
A4645               END-STRING                                          
A4645            END-IF                                                 
A4645         ELSE                                                      
A4645            MOVE 'UNKNOWN'             TO D-DELETED-BY             
A4645            MOVE 'NOT FOUND'           TO D-DELETION-CMNTS         
A4645         END-IF                                                    
A4645      ELSE                                                         
              PERFORM 7422-GET-SVC-STATUS-DESC  THRU 7422-EXIT          
              MOVE UV-CODE-SHORT-DESC-TEXT      TO   D-SERVICE-STATUS   
              PERFORM 7424-GET-SVC-INSTALL-DESC THRU 7424-EXIT          
              MOVE UV-CODE-SHORT-DESC-TEXT      TO   D-ACTION-TYPE      
A4645      END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7410-SELECT-SVC-NO                                           *        
      *                                                                *        
      ******************************************************************        
       7410-SELECT-SVC-NO.                                              
                                                                        
           MOVE '7410'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND CHG_COLUMN_VALUE  <> '*DELETED*'                 
                   AND COLUMN_DESC       = 'GAS SVC NO'                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND CHG_COLUMN_VALUE  <> '*DELETED*'                         
MFA-TR*            AND COLUMN_DESC       = 'GAS SVC NO'                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7410-SELECT-SVC-NO*'          
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7420-SELECT-SVC-INFO.                                        *        
      *                                                                *        
      ******************************************************************        
       7420-SELECT-SVC-INFO.                                            
                                                                        
           MOVE '7420'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT  SERV_LINE_STAT_FL                               
                       ,INSTALL_TYPE_CD                                 
                  INTO  :XO-SERV-LINE-STAT-FL                           
                       ,:XO-INSTALL-TYPE-CD                             
                  FROM  CSS_GAS_SERV_LINE                               
                 WHERE  SERVICE_NO = :XO-SERVICE-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
A4645      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7420-SELECT-SVC-INFO.'        
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  GAS SVC NO   = ' XO-SERVICE-NO               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7422-GET-SVC-STATUS-DESC.                                    *        
      *                                                                *        
      ******************************************************************        
       7422-GET-SVC-STATUS-DESC.                                        
                                                                        
           MOVE '7422'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO UV-CODE-SHORT-DESC.       
           EXEC SQL                                                     
                SELECT CODE_SHORT_DESC                                  
                INTO   :UV-CODE-SHORT-DESC                              
                FROM   CSS_CODE_VALUE                                   
                WHERE  CODE_VALUE = :XO-SERV-LINE-STAT-FL               
                AND    COLUMN_NA = 'SERV_LINE_STAT_FL'                  
                AND    TABLE_NA  = 'CSS_GAS_SERV_LINE'                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7422-GET-SVC-STATUS-DESC'     
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  GAS SVC NO   = ' XO-SERVICE-NO               
              DISPLAY '**  CODE VALUE   = ' XO-SERV-LINE-STAT-FL        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7422-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7424-GET-SVC-INSTALL-DESC.                                   *        
      *                                                                *        
      ******************************************************************        
       7424-GET-SVC-INSTALL-DESC.                                       
                                                                        
           MOVE '7424'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO UV-CODE-SHORT-DESC.       
           EXEC SQL                                                     
                SELECT CODE_SHORT_DESC                                  
                INTO   :UV-CODE-SHORT-DESC                              
                FROM   CSS_CODE_VALUE                                   
                WHERE  CODE_VALUE = :XO-INSTALL-TYPE-CD                 
                AND    COLUMN_NA = 'INSTALL_TYPE_CD'                    
                AND    TABLE_NA  = 'CSS_GAS_SERV_LINE'                  
                AND    COMPANY_NO = '26'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7424-GET-SVC-INSTALL-DESC'    
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  GAS SVC NO   = ' XO-SERVICE-NO               
              DISPLAY '**  CODE VALUE   = ' XO-INSTALL-TYPE-CD          
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7424-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7500-SELECT-SO-DTLS.                                         *        
      *                                                                *        
      ******************************************************************        
       7500-SELECT-SO-DTLS.                                             
                                                                        
           MOVE '7500'                         TO WS-ACTIVE-PARAGRAPH.  
           IF WS-SVC-NO >= 2000000000                                   
              PERFORM 7520-GET-INSTALL-SO-INFO   THRU 7520-EXIT         
              MOVE L4-WORK-TYPE-DESC             TO   D-INSTALL-WK-TYPE 
              MOVE VI-SERV-ORDER-NO              TO   WS-SO-NO          
              MOVE WS-SO-NUM                     TO   D-INSTALL-SO      
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 7525-GET-INSTALL-HSO-INFO THRU 7525-EXIT       
                 MOVE L4-WORK-TYPE-DESC            TO  D-INSTALL-WK-TYPE
                 MOVE ZG-SERV-ORDER-NO             TO  WS-SO-NO         
                 MOVE WS-SO-NUM                    TO  D-INSTALL-SO     
              END-IF                                                    
           END-IF.                                                      
           IF XO-SERV-LINE-STAT-FL = 'R' OR                             
              XO-SERV-LINE-STAT-FL = 'T'                                
              PERFORM 7540-GET-RETIRE-SO-INFO     THRU 7540-EXIT        
              MOVE L4-WORK-TYPE-DESC              TO   D-RETIRE-WK-TYPE 
              IF VI-SERV-ORDER-NO > 0                                   
                 MOVE VI-SERV-ORDER-NO            TO   WS-SO-NO         
                 MOVE WS-SO-NUM                   TO   D-RETIRE-SO      
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 7545-GET-RETIRE-HSO-INFO  THRU 7545-EXIT       
                 MOVE L4-WORK-TYPE-DESC            TO   D-RETIRE-WK-TYPE
                 IF VI-SERV-ORDER-NO > 0                                
                    MOVE ZG-SERV-ORDER-NO          TO   WS-SO-NO        
                    MOVE WS-SO-NUM                 TO   D-RETIRE-SO     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7520-GET-INSTALL-SO-INFO.                                    *        
      *                                                                *        
      ******************************************************************        
       7520-GET-INSTALL-SO-INFO.                                        
                                                                        
           MOVE '7520'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE XO-SERVICE-NO                TO  XX-SERVICE-NO.         
           INITIALIZE                        L4-WORK-TYPE-DESC          
                                             VI-SERV-ORDER-NO.          
           EXEC SQL                                                     
              SELECT L4.WORK_TYPE_DESC                                  
                    ,VI.SERV_ORDER_NO                                   
              INTO   :L4-WORK-TYPE-DESC                                 
                    ,:VI-SERV-ORDER-NO                                  
              FROM   CSS_GASLINE_SO_XRF   XX                            
                    ,CSS_SO_ORDER_INST    VI                            
                    ,CSS_WORK_TYPE        L4                            
                    ,CSS_SO_DATA          VO                            
              WHERE  VI.SERV_ORDER_NO = VO.SERV_ORDER_NO                
              AND    L4.WORK_TYPE_CD  = VI.WORK_TYPE_CD                 
              AND    XX.SERVICE_NO    = :XX-SERVICE-NO                  
              AND    VO.SERV_ORDER_NO = XX.SERV_ORDER_NO                
              AND    VO.COMPANY_NO    = '26'                            
              AND    VO.ORDER_TYPE_CD = 'FW024'                         
              AND    VI.WORK_TYPE_CD  IN ('G50', 'G51', 'G52', 'G53',   
                                          'G54', 'G55', 'G56', 'G57',   
                                          'G58', 'G59', 'G64', 'G65')   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7520-GET-INSTALL-SO-INFO.'    
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  GAS SVC NO   = ' XX-SERVICE-NO               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7525-GET-INSTALL-HSO-INFO.                                   *        
      *                                                                *        
      ******************************************************************        
       7525-GET-INSTALL-HSO-INFO.                                       
                                                                        
           MOVE '7525'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE XO-SERVICE-NO                TO  XX-SERVICE-NO.         
           INITIALIZE                        L4-WORK-TYPE-DESC          
                                             ZG-SERV-ORDER-NO.          
           EXEC SQL                                                     
              SELECT L4.WORK_TYPE_DESC                                  
                    ,ZG.SERV_ORDER_NO                                   
              INTO   :L4-WORK-TYPE-DESC                                 
                    ,:ZG-SERV-ORDER-NO                                  
              FROM   CSS_GASLINE_SO_XRF   XX                            
                    ,HST_SO_ORDER_INST    ZG                            
                    ,CSS_WORK_TYPE        L4                            
                    ,HST_SO_DATA          YV                            
              WHERE  ZG.SERV_ORDER_NO = YV.SERV_ORDER_NO                
              AND    L4.WORK_TYPE_CD  = ZG.WORK_TYPE_CD                 
              AND    XX.SERVICE_NO    = :XX-SERVICE-NO                  
              AND    YV.SERV_ORDER_NO = XX.SERV_ORDER_NO                
              AND    YV.COMPANY_NO    = '26'                            
              AND    YV.ORDER_TYPE_CD = 'FW024'                         
              AND    ZG.WORK_TYPE_CD  IN ('G50', 'G51', 'G52', 'G53',   
                                          'G54', 'G55', 'G56', 'G57',   
                                          'G58', 'G59', 'G64', 'G65')   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7525-GET-INSTALL-HSO-INFO.'   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  GAS SVC NO   = ' XX-SERVICE-NO               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7540-GET-RETIRE-SO-INFO.                                     *        
      *                                                                *        
      ******************************************************************        
       7540-GET-RETIRE-SO-INFO.                                         
                                                                        
           MOVE '7540'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE XO-SERVICE-NO                TO  XX-SERVICE-NO.         
           INITIALIZE                        L4-WORK-TYPE-DESC          
                                             VI-SERV-ORDER-NO.          
           EXEC SQL                                                     
              SELECT L4.WORK_TYPE_DESC                                  
                    ,VI.SERV_ORDER_NO                                   
              INTO   :L4-WORK-TYPE-DESC                                 
                    ,:VI-SERV-ORDER-NO                                  
              FROM   CSS_GASLINE_SO_XRF   XX                            
                    ,CSS_SO_ORDER_INST    VI                            
                    ,CSS_WORK_TYPE        L4                            
                    ,CSS_SO_DATA          VO                            
              WHERE  VI.SERV_ORDER_NO = VO.SERV_ORDER_NO                
              AND    L4.WORK_TYPE_CD  = VI.WORK_TYPE_CD                 
              AND    XX.SERVICE_NO    = :XX-SERVICE-NO                  
              AND    VO.SERV_ORDER_NO = XX.SERV_ORDER_NO                
              AND    VO.COMPANY_NO    = '26'                            
              AND    VO.ORDER_TYPE_CD = 'FW024'                         
              AND    VI.WORK_TYPE_CD  IN ('G60', 'G61', 'G62', 'G63')   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7540-GET-RETIRE-SO-INFO.'     
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  GAS SVC NO   = ' XX-SERVICE-NO               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7545-GET-RETIRE-HSO-INFO.                                    *        
      *                                                                *        
      ******************************************************************        
       7545-GET-RETIRE-HSO-INFO.                                        
                                                                        
           MOVE '7545'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE XO-SERVICE-NO                TO  XX-SERVICE-NO.         
           INITIALIZE                        L4-WORK-TYPE-DESC          
                                             ZG-SERV-ORDER-NO.          
           EXEC SQL                                                     
              SELECT L4.WORK_TYPE_DESC                                  
                    ,ZG.SERV_ORDER_NO                                   
              INTO   :L4-WORK-TYPE-DESC                                 
                    ,:ZG-SERV-ORDER-NO                                  
              FROM   CSS_GASLINE_SO_XRF   XX                            
                    ,HST_SO_ORDER_INST    ZG                            
                    ,CSS_WORK_TYPE        L4                            
                    ,HST_SO_DATA          YV                            
              WHERE  ZG.SERV_ORDER_NO = YV.SERV_ORDER_NO                
              AND    L4.WORK_TYPE_CD  = ZG.WORK_TYPE_CD                 
              AND    XX.SERVICE_NO    = :XX-SERVICE-NO                  
              AND    YV.SERV_ORDER_NO = XX.SERV_ORDER_NO                
              AND    YV.COMPANY_NO    = '26'                            
              AND    YV.ORDER_TYPE_CD = 'FW024'                         
              AND    ZG.WORK_TYPE_CD  IN ('G60', 'G61', 'G62', 'G63')   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7545-GET-RETIRE-HSO-INFO.'    
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  GAS SVC NO   = ' XX-SERVICE-NO               
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7545-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7600-SELECT-DATE-CHGS.                                       *        
      *                                                                *        
      ******************************************************************        
       7600-SELECT-DATE-CHGS.                                           
                                                                        
           MOVE '7600'                         TO WS-ACTIVE-PARAGRAPH.  
           PERFORM 7625-GET-INSTALL-DATE-CHGS  THRU 7625-EXIT.          
           PERFORM 7875-CHECK-PRV-CHG-VALUES   THRU 7875-EXIT.          
           MOVE MI-PRV-COLUMN-VALUE-TEXT       TO   D-INSTALL-DT-PREV.  
           MOVE MI-CHG-COLUMN-VALUE-TEXT       TO   D-INSTALL-DT-CHGD.  
                                                                        
           PERFORM 7650-GET-RETIRED-DATE-CHGS  THRU 7650-EXIT.          
           PERFORM 7875-CHECK-PRV-CHG-VALUES   THRU 7875-EXIT.          
           MOVE MI-PRV-COLUMN-VALUE-TEXT       TO   D-RETIRED-DT-PREV.  
           MOVE MI-CHG-COLUMN-VALUE-TEXT       TO   D-RETIRED-DT-CHGD.  
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7625-GET-INSTALL-DATE-CHGS.                                  *        
      *                                                                *        
      ******************************************************************        
       7625-GET-INSTALL-DATE-CHGS.                                      
                                                                        
           MOVE '7625'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
                                              MI-CHG-COLUMN-VALUE.      
                                                                        
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND COLUMN_DESC       = 'INSTALL DATE'               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND COLUMN_DESC       = 'INSTALL DATE'                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7625-GET-INSTALL-DATE-CHGS*'  
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7650-GET-RETIRED-DATE-CHGS.                                  *        
      *                                                                *        
      ******************************************************************        
       7650-GET-RETIRED-DATE-CHGS.                                      
                                                                        
           MOVE '7650'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
                                              MI-CHG-COLUMN-VALUE.      
                                                                        
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND COLUMN_DESC       = 'RETIRED DATE'               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND COLUMN_DESC       = 'RETIRED DATE'                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7650-GET-RETIRED-DATE-CHGS*'  
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7700-SELECT-TYPE-CHGS.                                       *        
      *                                                                *        
      ******************************************************************        
       7700-SELECT-TYPE-CHGS.                                           
                                                                        
           MOVE '7700'                         TO WS-ACTIVE-PARAGRAPH.  
           PERFORM 7725-GET-INSTALL-TYPE-CHGS  THRU 7725-EXIT.          
           PERFORM 7875-CHECK-PRV-CHG-VALUES   THRU 7875-EXIT.          
           MOVE MI-PRV-COLUMN-VALUE-TEXT       TO   D-PIPE-TYPE-PREV.   
           MOVE MI-CHG-COLUMN-VALUE-TEXT       TO   D-PIPE-TYPE-CHGD.   
                                                                        
           PERFORM 7750-GET-RETIRED-TYPE-CHGS  THRU 7750-EXIT.          
           PERFORM 7875-CHECK-PRV-CHG-VALUES   THRU 7875-EXIT.          
           MOVE MI-PRV-COLUMN-VALUE-TEXT       TO   D-PIPE-TYPE-RETD-P. 
           MOVE MI-CHG-COLUMN-VALUE-TEXT       TO   D-PIPE-TYPE-RETD-C. 
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7725-GET-INSTALL-TYPE-CHGS.                                  *        
      *                                                                *        
      ******************************************************************        
       7725-GET-INSTALL-TYPE-CHGS.                                      
                                                                        
           MOVE '7725'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
                                              MI-CHG-COLUMN-VALUE.      
                                                                        
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND COLUMN_DESC       = 'PIPE TYPE'                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND COLUMN_DESC       = 'PIPE TYPE'                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7725-GET-INSTALL-TYPE-CHGS*'  
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7750-GET-RETIRED-TYPE-CHGS.                                  *        
      *                                                                *        
      ******************************************************************        
       7750-GET-RETIRED-TYPE-CHGS.                                      
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
                                              MI-CHG-COLUMN-VALUE.      
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND COLUMN_DESC       = 'PIPE TYPE RETD'             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND COLUMN_DESC       = 'PIPE TYPE RETD'                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7750-GET-RETIRED-TYPE-CHGS*'  
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7800-SELECT-SIZE-CHGS.                                       *        
      *                                                                *        
      ******************************************************************        
       7800-SELECT-SIZE-CHGS.                                           
                                                                        
           MOVE '7800'                         TO WS-ACTIVE-PARAGRAPH.  
           PERFORM 7825-GET-INSTALL-SIZE-CHGS  THRU 7825-EXIT.          
           PERFORM 7875-CHECK-PRV-CHG-VALUES   THRU 7875-EXIT.          
           MOVE MI-PRV-COLUMN-VALUE-TEXT       TO   D-PIPE-SIZE-PREV.   
           MOVE MI-CHG-COLUMN-VALUE-TEXT       TO   D-PIPE-SIZE-CHGD.   
                                                                        
           PERFORM 7850-GET-RETIRED-SIZE-CHGS  THRU 7850-EXIT.          
           PERFORM 7875-CHECK-PRV-CHG-VALUES   THRU 7875-EXIT.          
           MOVE MI-PRV-COLUMN-VALUE-TEXT       TO   D-PIPE-SIZE-RETD-P. 
           MOVE MI-CHG-COLUMN-VALUE-TEXT       TO   D-PIPE-SIZE-RETD-C. 
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7825-GET-INSTALL-SIZE-CHGS.                                  *        
      *                                                                *        
      ******************************************************************        
       7825-GET-INSTALL-SIZE-CHGS.                                      
                                                                        
           MOVE '7825'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
                                              MI-CHG-COLUMN-VALUE.      
                                                                        
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND COLUMN_DESC       = 'PIPE SIZE'                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND COLUMN_DESC       = 'PIPE SIZE'                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7825-GET-INSTALL-SIZE-CHGS*'  
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7825-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7850-GET-RETIRED-SIZE-CHGS.                                  *        
      *                                                                *        
      ******************************************************************        
       7850-GET-RETIRED-SIZE-CHGS.                                      
                                                                        
           MOVE '7850'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
                                              MI-CHG-COLUMN-VALUE.      
                                                                        
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND COLUMN_DESC       = 'PIPE SIZE RETD'             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND COLUMN_DESC       = 'PIPE SIZE RETD'                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7850-GET-RETIRED-SIZE-CHGS*'  
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7875-CHECK-PRV-CHG-VALUES.                                   *        
      *                                                                *        
      ******************************************************************        
       7875-CHECK-PRV-CHG-VALUES.                                       
                                                                        
           IF MI-PRV-COLUMN-VALUE-TEXT  =  '*NEW*'                      
              MOVE SPACES TO MI-PRV-COLUMN-VALUE                        
           END-IF.                                                      
           IF MI-CHG-COLUMN-VALUE-TEXT  =  '*DELETED*'                  
              MOVE SPACES TO MI-CHG-COLUMN-VALUE                        
           END-IF.                                                      
                                                                        
       7875-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7900-SELECT-LEN-CHGS.                                       *         
      *                                                                *        
      ******************************************************************        
       7900-SELECT-LEN-CHGS.                                            
                                                                        
           MOVE '7900'                         TO WS-ACTIVE-PARAGRAPH.  
           PERFORM 7925-GET-INSTALL-LEN-CHGS  THRU 7925-EXIT.           
           PERFORM 7875-CHECK-PRV-CHG-VALUES   THRU 7875-EXIT.          
           MOVE MI-PRV-COLUMN-VALUE-TEXT       TO   D-PIPE-LEN-PREV.    
           MOVE MI-CHG-COLUMN-VALUE-TEXT       TO   D-PIPE-LEN-CHGD.    
                                                                        
           PERFORM 7950-GET-RETIRED-LEN-CHGS  THRU 7950-EXIT.           
           PERFORM 7875-CHECK-PRV-CHG-VALUES   THRU 7875-EXIT.          
           MOVE MI-PRV-COLUMN-VALUE-TEXT       TO   D-PIPE-LEN-RETD-P.  
           MOVE MI-CHG-COLUMN-VALUE-TEXT       TO   D-PIPE-LEN-RETD-C.  
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7925-GET-INSTALL-LEN-CHGS.                                  *         
      *                                                                *        
      ******************************************************************        
       7925-GET-INSTALL-LEN-CHGS.                                       
                                                                        
           MOVE '7925'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
                                              MI-CHG-COLUMN-VALUE.      
                                                                        
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND COLUMN_DESC       = 'PIPE LENGTH'                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND COLUMN_DESC       = 'PIPE LENGTH'                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7925-GET-INSTALL-LEN-CHGS*'   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7925-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7950-GET-RETIRED-LEN-CHGS.                                  *         
      *                                                                *        
      ******************************************************************        
       7950-GET-RETIRED-LEN-CHGS.                                       
                                                                        
           MOVE '7950'                     TO WS-ACTIVE-PARAGRAPH.      
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
                                              MI-CHG-COLUMN-VALUE.      
                                                                        
           EXEC SQL                                                     
                SELECT PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                  INTO :MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                  FROM CSS_MT_TRN_HST_DET                               
                 WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )        
                   AND COLUMN_DESC       = 'PIPE LEN RETD'              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*           INTO :MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*           FROM CSS_MT_TRN_HST_DET                                       
MFA-TR*          WHERE TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                
MFA-TR*            AND COLUMN_DESC       = 'PIPE LEN RETD'                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7950-GET-RETIRED-LEN-CHGS*'   
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  TRAN SEQ NO  = ' MH-TRANS-HIST-SEQ-NO        
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
A4645 ******************************************************************        
A4645 *   7960-GET-SVC-DELETE-DTLS.                                    *        
A4645 *                                                                *        
A4645 ******************************************************************        
A4645  7960-GET-SVC-DELETE-DTLS.                                        
A4645                                                                   
A4645      MOVE '7960'                     TO WS-ACTIVE-PARAGRAPH.      
A4645      MOVE SPACES                     TO MI-PRV-COLUMN-VALUE       
A4645                                         MI-CHG-COLUMN-VALUE.      
A4645                                                                   
A4645      EXEC SQL                                                     
A4645            SELECT TOP(1) MH.USER_ID,
              MH.TRAN_COMMENT                                 
A4645              INTO :MH-USER-ID                                     
A4645                  ,:MH-TRAN-COMMENT                                
A4645              FROM CSS_MNT_TRANS_HIST MH                           
A4645                  ,CSS_MT_TRN_HST_DET MI                           
A4645             WHERE MH.DATE_TRANS         >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )         
A4645               AND MH.DATE_TRANS         <  IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )           
A4645               AND MH.APPL_PROGRAM_ID    = 'PANEL531'              
A4645               AND MH.CODE_TRAN_TYPE     = 'F'                     
A4645               AND MH.ACCOUNT_NO         = 0                       
A4645               AND MH.CUSTOMER_NO        = 0                       
A4645               AND MH.PREMISE_NO         = :PR-PREMISE-NO          
A4645               AND MI.TRANS_HIST_SEQ_NO  = MH.TRANS_HIST_SEQ_NO    
A4645               AND MI.TRAN_APPL_NO       =  1                      
A4645               AND MI.TABLE_ID           =  ' '                    
A4645               AND MI.COLUMN_DESC        = 'GAS SVC NO'            
A4645               AND MI.PRV_COLUMN_VALUE   = :D-SERVICE-NO           
A4645               AND MI.CHG_COLUMN_VALUE   =  '*DELETED*'            
A4645                                            
A4645      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT MH.USER_ID                                              
MFA-TR*                ,MH.TRAN_COMMENT                                         
MFA-TR*            INTO :MH-USER-ID                                             
MFA-TR*                ,:MH-TRAN-COMMENT                                        
MFA-TR*            FROM CSS_MNT_TRANS_HIST MH                                   
MFA-TR*                ,CSS_MT_TRN_HST_DET MI                                   
MFA-TR*           WHERE MH.DATE_TRANS         >= :WS-START-DATE                 
MFA-TR*             AND MH.DATE_TRANS         <  :WS-END-DATE                   
MFA-TR*             AND MH.APPL_PROGRAM_ID    = 'PANEL531'                      
MFA-TR*             AND MH.CODE_TRAN_TYPE     = 'F'                             
MFA-TR*             AND MH.ACCOUNT_NO         = 0                               
MFA-TR*             AND MH.CUSTOMER_NO        = 0                               
MFA-TR*             AND MH.PREMISE_NO         = :PR-PREMISE-NO                  
MFA-TR*             AND MI.TRANS_HIST_SEQ_NO  = MH.TRANS_HIST_SEQ_NO            
MFA-TR*             AND MI.TRAN_APPL_NO       =  1                              
MFA-TR*             AND MI.TABLE_ID           =  ' '                            
MFA-TR*             AND MI.COLUMN_DESC        = 'GAS SVC NO'                    
MFA-TR*             AND MI.PRV_COLUMN_VALUE   = :D-SERVICE-NO                   
MFA-TR*             AND MI.CHG_COLUMN_VALUE   =  '*DELETED*'                    
MFA-TR*     FETCH FIRST 1 ROWS ONLY                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A4645                                                                   
A4645      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A4645                                                                   
A4645      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A4645         NEXT SENTENCE                                             
A4645      ELSE                                                         
A4645         DISPLAY '***********************************'             
A4645         DISPLAY '**  PROCESSING ERROR             **'             
A4645         DISPLAY '**  PARAGRAPH    = 7960-GET-SVC-DELETE-DTLS.'    
A4645         DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A4645         DISPLAY '**  SERVICE  NO  = ' D-SERVICE-NO                
A4645         DISPLAY '**  PROCESSING TERMINATED        **'             
A4645         DISPLAY '***********************************'             
A4645         PERFORM 9900-ABEND           THRU 9900-EXIT               
A4645      END-IF.                                                      
A4645                                                                   
A4645  7960-EXIT.                                                       
A4645      EXIT.                                                        
A4645                                                                   
A4645 ******************************************************************        
A4645 *   7962-GET-DELETE-USER-NAME.                                   *        
A4645 *                                                                *        
A4645 ******************************************************************        
A4645  7962-GET-DELETE-USER-NAME.                                       
A4645                                                                   
A4645      MOVE '7962'                     TO WS-ACTIVE-PARAGRAPH.      
A4645                                                                   
A4645      EXEC SQL                                                     
A4645            SELECT PF.FIRST_NAME                                   
A4645                  ,PF.LAST_NAME                                    
A4645                  ,PF.MIDDLE_NAME                                  
A4645              INTO :PF-FIRST-NAME                                  
A4645                  ,:PF-LAST-NAME                                   
A4645                  ,:PF-MIDDLE-NAME                                 
A4645              FROM CSS_USER_PROFILE PF                             
A4645             WHERE PF.USER_ID = :MH-USER-ID                        
A4645      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A4645                                                                   
A4645      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A4645                                                                   
A4645      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A4645         NEXT SENTENCE                                             
A4645      ELSE                                                         
A4645         DISPLAY '***********************************'             
A4645         DISPLAY '**  PROCESSING ERROR             **'             
A4645         DISPLAY '**  PARAGRAPH    = 7962-GET-DELETE-USER-NAME.'   
A4645         DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A4645         DISPLAY '**  SERVICE  NO  = ' D-SERVICE-NO                
A4645         DISPLAY '**  USER ID      = ' MH-USER-ID                  
A4645         DISPLAY '**  PROCESSING TERMINATED        **'             
A4645         DISPLAY '***********************************'             
A4645         PERFORM 9900-ABEND           THRU 9900-EXIT               
A4645      END-IF.                                                      
A4645                                                                   
A4645  7962-EXIT.                                                       
A4645      EXIT.                                                        
A4645                                                                   
      ******************************************************************        
      *   7990-UPDATE-ENDDATE                                          *        
      *        UPDATES WITH THE NEXT PROCESS DATE                      *        
      ******************************************************************        
       7990-UPDATE-ENDDATE.                                             
                                                                        
           MOVE '7990'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET PARM_DATA    =:G6-PARM-DATA                      
                 WHERE PROGRAM_NAME = :WS-PROGRAM-NAME                  
                   AND COMPANY_NO   = '26'                              
                   AND CMND_CODE    = 'DATE'                            
                   AND SEQ_NO       = 1                                 
                   AND STATUS       = 'A'                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7990-UPDATE-ENDDATE **'       
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  JOB PARM DATE= ' G6-PARM-DATA                
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08061003
      *   8050-WRITE-RPT-HEADER2                                       *08090000
      *   WRITES THE COLUMN HEADINGS                                   *08100000
      ******************************************************************08061003
                                                                        
       8050-WRITE-RPT-HEADER2.                                          
                                                                        
           WRITE FSO165 FROM WS-HEADER-LINE4.                           
           WRITE FSO165 FROM WS-HEADER-LINE5.                           
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8500-WRITE-DETAIL                                            *        
      *   WRITES THE REVISED DETAILS TO THE FILE                       *        
      ******************************************************************        
                                                                        
       8500-WRITE-DETAIL.                                               
                                                                        
           MOVE X'05' TO WS-FIL71 WS-FIL72 WS-FIL73 WS-FIL74 WS-FIL75   
                         WS-FIL76 WS-FIL77 WS-FIL78 WS-FIL79 WS-FIL80   
                         WS-FIL81 WS-FIL82 WS-FIL83 WS-FIL84 WS-FIL85   
                         WS-FIL86 WS-FIL87 WS-FIL88 WS-FIL89 WS-FIL90   
                         WS-FIL91 WS-FIL92 WS-FIL93 WS-FIL94 WS-FIL95   
                         WS-FIL96 WS-FIL97 WS-FIL98 WS-FIL99 WS-FIL100  
                         WS-FIL101  WS-FIL102  WS-FIL103  WS-FIL104     
                         WS-FIL105  WS-FIL106  WS-FIL107                
                                                                        
           WRITE FSO165 FROM WS-DETAIL-LINE1.                           
                                                                        
           MOVE SPACES TO WS-DETAIL-LINE1.                              
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8600-WRITE-PRNTFILE                                          *        
      *   WRITES THE MAIL HEADER AND DETAILS                           *        
      ******************************************************************        
                                                                        
       8600-WRITE-PRNTFILE.                                             
           MOVE WS-START-DATE        TO  WS-SUB-DATE1.                  
                                                                        
           MOVE WS-SUB-DATE2         TO  WS-PRNT-DATE.                  
           MOVE WS-PRNT-MM           TO  WS-FILE-MM.                    
           MOVE WS-PRNT-DD           TO  WS-FILE-DD.                    
           MOVE WS-PRNT-CCYY         TO  WS-FILE-CCYY.                  
                                                                        
           WRITE PRNTFILE-RECORD FROM MAILHEAD-1.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-2.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-3.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-4.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-5.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-6-1.                     
           WRITE PRNTFILE-RECORD FROM MAILHEAD-6-2.                     
           WRITE PRNTFILE-RECORD FROM MAILHEAD-6-3.                     
           WRITE PRNTFILE-RECORD FROM MAILHEAD-6-4.                     
           WRITE PRNTFILE-RECORD FROM MAILHEAD-7.                       
           WRITE PRNTFILE-RECORD FROM MAILHEAD-8.                       
           WRITE PRNTFILE-RECORD FROM MAILDTLS-1.                       
           WRITE PRNTFILE-RECORD FROM MAILDTLS-2.                       
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   9000-TERMINATE.                                              *        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           IF WS-FSO165-SUCCESSFUL                                      
              CLOSE FCSSO165-FILE                                       
                                                                        
              IF WS-FSO165-SUCCESSFUL                                   
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSSO165  PROCESSING ERROR **'            
                 DISPLAY '**  CLOSE ERROR OF FCSSO165 OUTPUT FILE'      
                 DISPLAY '**  FILE STATUS = ' WS-FSO165-STATUS          
                 DISPLAY '**  PROCESSING TERMINATED **'                 
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
              END-IF                                                    
           END-IF.                                                      
           CLOSE FCSSOXP1-FILE.                                         
           CLOSE FCSSOXP2-FILE.                                         
           CLOSE PRNTFILE.                                              
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * COPYBOOK FOR ABEND ROUTINE                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
