       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSSO163.                                            
       DATE-WRITTEN.                                                    
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      ******************************************************************        
      *               PROGRAM  MODIFICATION  LOG                       *        
      *                                                                *        
      *      DATE       INITIALS    REASON                             *        
      *      ----       --------    ------                             *        
A01114*    09/04/2009   VV90387     NEW CODE                           *        
A01114*    03/11/2010   VV90387     CONSIDER ALL ORDER STATE's OTHER   *        
A01114*                             THAN 'C'/'Z' FOR THE CC/NC ORDERS  *        
P00390*    05/25/2010   VV90387     NEW WQ TO REPORT FOLLY BEACH       *        
P00390*                             ADDRESS ISSUES                     *        
A02623*    07/19/2010   VV90387     NEW WQ FOR SAME DAY CC/OFF ORDERS  *        
A02623*    07/21/2010   VV90387     NEW WQ FOR CC/OC FRO ORDERS        *        
A02623*    07/28/2010   VV90387     CREATE WQ'S FOR FOLLY BEACH ONLY ON*        
A02623*                             ACTIVE ACCOUNTS AND DO NOT CREATE  *        
A02623*                             DUPLICATE WQ'S IF ALREADY EXISTING *        
A01360*    10/05/2010   VV90387     CREATE QA-ADDRESS-ISSUE WQ'S ONLY  *        
A01360*                             ON ACTIVE ACCOUNTS                 *        
A03352*    11/07/2011   MH94819     USE JOB PARM DATE FOR THE CURSORS  *        
A03352*                             INSTEAD OF CURRENT DATE AND CREATE *        
A03352*                             WQ FOR COURTESY ADJUSTMENTS        *        
A03352*    05/21/2012   MH94819     ACT-17 UPDATE CURSORS TO CHECK FOR *        
A03352*                             > PREV DATE AND <= CURRENT DATE    *        
A03352*                             UPDATE JOB PARM WITH NEXT BUSS DAY *        
A04807*    09/10/2013   VV90387     WQ FOR OFF's THAT ARE FRO ORDERS   *        
A04860*    06/18/2015   RS7M249     REPLACE CSS_WQ_ITEMS_MF WITH       *        
A04860*                 ACT078      CSS_WQ_ITEMS AND REMOVED UNUSED    *        
A04860*                             COPYBOOKS.                         *        
A00795*    03/09/2016   VV90387     RESET DUPLICATE WQ VARIABLE       *         
      ******************************************************************        
             REMARKS.                                                   
      ******************************************************************        
      *   THIS PROGRAM GENERATES WQ's FOR ORDERS QUALITY GROUP FOR     *        
      *        1)Orders without any Appliance                          *        
      *        2)Orders without any Heating Appliance                  *        
      *        3)Orders without Work selected for any Appliance        *        
      *        4)If Active DNP & CC/NC Orders exists                   *        
P00390*        4)For address issues in Folly Beach                     *        
      ******************************************************************        
                         ---- BASIC SEQUENCE STRUCTURE ----             
                    0000 - 0999     MAIN CONTROL PATH                   
                    1000 - 1999     INITIALIZATION                      
                    1000 - 1999     INPUT PROCESSING CONTROL PATH       
                    2000 - 2999     OUTPUT PROCESSING CONTROL PATH      
                    3000 - 4999     BATCH PROCESSING MODULES - NOT USED 
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO163'.
MSQ017     COPY MFASQLM.
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR PCSSO163 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05 WS-PGRMNAME               PIC X(10) VALUE 'PCSSO163'.     
           05 PROGRAM-NAME              PIC X(08) VALUE 'PCSSO163'.     
           05 WS-D                      PIC X(01) VALUE 'D'.            
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
           05 WS-N                      PIC X(01) VALUE 'N'.            
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
           05 WS-NO                     PIC X(01) VALUE 'N'.            
           05 WS-SCEG                   PIC X(02) VALUE '01'.           
           05 WS-PSNC                   PIC X(02) VALUE '26'.           
           05 WS-USER                   PIC X(06) VALUE 'SYSTEM'.       
ACT078     05 RS-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
A02623     05 WS-WQ-TYPE                PIC X(04) VALUE SPACES.         
A02623        88  APPL-DTLS                       VALUE 'APPL'.         
A02623        88  DNP-DTLS                        VALUE 'DNPS'.         
A02623        88  CC-OFF-DTLS                     VALUE 'CCOF'.         
A02623        88  CC-OC-DTLS                      VALUE 'CCOC'.         
A03352        88  CRTSY-ADJ                       VALUE 'CRTS'.         
A02623     05 WS-DUPLICATE-WQ           PIC X(01) VALUE 'N'.            
A02623        88  WS-DUPLICATE                    VALUE 'Y'.            
A02623        88  WS-NO-DUPLICATE                 VALUE 'N'.            
A03352     05 WS-CUSTOMER-NO            PIC 9(10) VALUE 0.              
A02623     05 WS-PREV-BUSS-DAY          PIC X(10) VALUE SPACES.         
A02623     05 WS-PREV-BUSINESS-DAY      PIC X(10) VALUE SPACES.         
A03352     05 WS-CURRENT-DATE           PIC X(10) VALUE SPACES.         
A03352     05 WS-PARM-DATE              PIC X(10) VALUE SPACES.         
A03352     05 WS-NEXT-DATE              PIC X(10) VALUE SPACES.         
A03352     05 WS-PREV-DATE              PIC X(10) VALUE SPACES.         
A03352     05 WS-PREV-DATE1             PIC X(26) VALUE SPACES.         
A03352     05 WS-PREV-DATE2             PIC X(26) VALUE SPACES.         
P00390     05 WS-NO-ADDR                PIC X(01) VALUE 'N'.            
P00390     05 WS-ADDR-CMNTS             PIC X(44) VALUE SPACES.         
A03352     05 WS-CRTSY-COMMENTS         PIC X(250) VALUE SPACES.        
           05 WS-APPL-CMNTS             PIC X(29) VALUE                 
                                        'Check Gas Appliance/Work Area'.
           05 WS-DNP-CMNTS              PIC X(44) VALUE                 
                         'Active DNP and CC/OC orders exist at premise'.
A02623     05 WS-CC-OFF-CMNTS           PIC X(47) VALUE                 
A02623                'CC and OFF orders exist for same day at premise'.
A02623     05 WS-CC-OC-CMNTS            PIC X(38) VALUE                 
A04807                'CC or OC or OFF orders entered for FRO'.         
P00390     05 WS-BILL-ADDR-CMNTS        PIC X(44) VALUE                 
P00390                   'Folly Beach premises with no billing address'.
P00390     05 WS-INCOR-ADDR-CMNTS       PIC X(44) VALUE                 
P00390                   'Folly Beach billing address incorrect format'.
           05 SCSCB077                  PIC X(08) VALUE 'SCSCB077'.     
                                                                        
       COPY CWS00038.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY FIOJC01.                                                            
                                                                        
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_SO_DATA          (PREFIX = VO)                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_ORDER_INST    (PREFIX = VI)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_LOCAL_OFFICE     (PREFIX = B1)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_APPLIANCE     (PREFIX = VQ)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOEQP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MKT_APPLIANCE    (PREFIX = JA)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
                                                                        
A03352******************************************************************        
A03352*    CSS_WQ_ITEMS         (PREFIX = WQ)                          *        
A03352******************************************************************        
A03352     EXEC SQL                                                             
A03352        INCLUDE TBWQITS                                                   
A03352     END-EXEC.                                                            
A03352                                                                  
P00390******************************************************************        
P00390*    CSS_ACCOUNT          (PREFIX = AT)                          *        
P00390******************************************************************        
P00390     EXEC SQL                                                             
P00390        INCLUDE TBACCT                                                    
P00390     END-EXEC.                                                            
P00390                                                                  
P00390******************************************************************        
P00390*    CSS_PREMISE          (PREFIX = PR)                          *        
P00390******************************************************************        
P00390     EXEC SQL                                                             
P00390        INCLUDE TBPREM                                                    
P00390     END-EXEC.                                                            
P00390                                                                  
P00390******************************************************************        
P00390*    CSS_ADDR_FORMATTED   (PREFIX = DY)                          *        
P00390******************************************************************        
P00390     EXEC SQL                                                             
P00390        INCLUDE TBADRFMT                                                  
P00390     END-EXEC.                                                            
P00390                                                                  
P00390******************************************************************        
P00390*    CSS_ADDR_FREEFORM    (PREFIX = DZ)                          *        
P00390******************************************************************        
P00390     EXEC SQL                                                             
P00390        INCLUDE TBADRFRE                                                  
P00390     END-EXEC.                                                            
P00390                                                                  
A03352******************************************************************        
A03352*    CSS_HOLIDAY          (PREFIX = J8)                          *        
A03352******************************************************************        
A03352     EXEC SQL                                                             
A03352        INCLUDE TBHLDAY                                                   
A03352     END-EXEC.                                                            
A03352                                                                  
A03352******************************************************************        
A03352*    CSS_JOB_PARM         (PREFIX = G6)                          *        
A03352******************************************************************        
A03352     EXEC SQL                                                             
A03352         INCLUDE TBJBPARM                                                 
A03352     END-EXEC.                                                            
A03352                                                                  
A03352******************************************************************        
A03352*    CSS_AR_TRANS_HIST    (PREFIX = AR)                          *        
A03352******************************************************************        
A03352     EXEC SQL                                                             
A03352         INCLUDE TBARHIST                                                 
A03352     END-EXEC.                                                            
A03352                                                                  
A02623******************************************************************        
A02623* COPYBOOK FOR WORKING STORAGE FOR BUSINESS DAY                  *        
A02623******************************************************************        
A02623     EXEC SQL                                                             
A02623        INCLUDE CWS00315                                                  
A02623     END-EXEC.                                                            
A02623                                                                  
ACT078*******FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077******        
ACT078     EXEC SQL                                                             
ACT078          INCLUDE CWS00077                                                
ACT078     END-EXEC.                                                            
ACT078                                                                  
ACT078 COPY CWS00010.                                                           
      *****************************************************************         
      * CURSOR FOR FETCHING THE ORDERS WITH INCORRECT APPLIANCE       *         
      *****************************************************************         
           EXEC SQL                                                     
                DECLARE APPL-DTLS CURSOR FOR                            
                 SELECT DISTINCT VO.ACCOUNT_NO_PRIOR,                   
                        VO.SERV_ORDER_NO,                               
                        VO.PREMISE_NO,                                  
                        VO.LOCAL_OFFICE                                 
                   FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                   
                        CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),             
                        CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED),              
                        CSS_WORK_AREA I2 WITH(READUNCOMMITTED)                  
                  WHERE ORDER_STATE_CD          IN ('A','B','D','H','R')
A03352             AND CAST(ASSIGNED_DATETIME AS DATE)  >  
              IIF(TRY_CONVERT(DATE, :WS-PREV-BUSS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSS-DAY) <> 10), CIS.CHAR2DATE(
                                                      :WS-PREV-BUSS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSS-DAY) )    
A03352             AND CAST(ASSIGNED_DATETIME AS DATE)  <= 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )     
                   AND VO.SERV_ORDER_NO         =  VI.SERV_ORDER_NO     
                   AND VO.COMPANY_NO            =  '01'                 
                   AND VO.BACK_DATED_IND        IN ('N',' ')            
                   AND VI.CODE_UTIL_TYPE        = 'G'                   
                   AND VI.WORK_TYPE_CD          IN ('UNB','UDP')        
                   AND VO.WORK_AREA_ID          = I2.WORK_AREA_ID       
                   AND VO.COMPANY_NO            = I2.COMPANY_NO         
                   AND I2.WORK_AREA_TX          NOT LIKE '%GAS%'        
                   AND VO.LOCAL_OFFICE          = B1.LOCAL_OFFICE       
                   AND VO.COMPANY_NO            = B1.COMPANY_NO         
                   AND B1.SERV_ORDER_WORK_CD IN                         
                       ('METRO','DISTR','DISTC')                        
                   AND                                                  
                   (NOT EXISTS (SELECT 'Y'                              
                          FROM CSS_SO_APPLIANCE VQ WITH(READUNCOMMITTED)        
                         WHERE VO.SERV_ORDER_NO  = VQ.SERV_ORDER_NO)    
                    OR (EXISTS (SELECT 'Y'                              
                          FROM CSS_SO_APPLIANCE  VQ
                           WITH(READUNCOMMITTED),                    
                               CSS_MKT_APPLIANCE JA
                           WITH(READUNCOMMITTED)                     
                         WHERE VO.SERV_ORDER_NO  = VQ.SERV_ORDER_NO     
                           AND VQ.APPLIANCE_CD   = JA.APPLIANCE_CD      
                           AND VO.COMPANY_NO     = JA.COMPANY_NO        
                           AND VQ.LIGHT_IND      = 'N'))                
                    OR ((EXISTS(SELECT 'Y'                              
                           FROM CSS_SO_DATA V2 WITH(READUNCOMMITTED)            
                          WHERE VO.SERV_ORDER_NO  = V2.SERV_ORDER_NO    
                          AND CIS.SUBSTR3(
           VO.CODES_DATA_PRESENT,12,1) = 'A') 
                    AND (NOT EXISTS(SELECT 'Y'                          
                               FROM CSS_SO_APPLIANCE  VQ
                           WITH(READUNCOMMITTED),               
                                    CSS_MKT_APPLIANCE JA
                           WITH(READUNCOMMITTED)                
                              WHERE VO.SERV_ORDER_NO  = VQ.SERV_ORDER_NO
                                AND VQ.APPLIANCE_CD   = JA.APPLIANCE_CD 
                                AND VO.COMPANY_NO     = JA.COMPANY_NO   
                                AND JA.SEASONAL_RT_FL = 'Y'             
                                AND JA.CIS_DISPLAY_FL = 'Y')))))        
                   FOR READ ONLY                                
A03352                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE APPL-DTLS CURSOR FOR                                    
MFA-TR*          SELECT DISTINCT VO.ACCOUNT_NO_PRIOR,                           
MFA-TR*                 VO.SERV_ORDER_NO,                                       
MFA-TR*                 VO.PREMISE_NO,                                          
MFA-TR*                 VO.LOCAL_OFFICE                                         
MFA-TR*            FROM CSS_SO_DATA VO,                                         
MFA-TR*                 CSS_SO_ORDER_INST VI,                                   
MFA-TR*                 CSS_LOCAL_OFFICE B1,                                    
MFA-TR*                 CSS_WORK_AREA I2                                        
MFA-TR*           WHERE ORDER_STATE_CD          IN ('A','B','D','H','R')        
MFA-TR*            AND DATE(ASSIGNED_DATETIME)  >  :WS-PREV-BUSS-DAY            
MFA-TR*            AND DATE(ASSIGNED_DATETIME)  <= :WS-CURRENT-DATE             
MFA-TR*            AND VO.SERV_ORDER_NO         =  VI.SERV_ORDER_NO             
MFA-TR*            AND VO.COMPANY_NO            =  '01'                         
MFA-TR*            AND VO.BACK_DATED_IND        IN ('N',' ')                    
MFA-TR*            AND VI.CODE_UTIL_TYPE        = 'G'                           
MFA-TR*            AND VI.WORK_TYPE_CD          IN ('UNB','UDP')                
MFA-TR*            AND VO.WORK_AREA_ID          = I2.WORK_AREA_ID               
MFA-TR*            AND VO.COMPANY_NO            = I2.COMPANY_NO                 
MFA-TR*            AND I2.WORK_AREA_TX          NOT LIKE '%GAS%'                
MFA-TR*            AND VO.LOCAL_OFFICE          = B1.LOCAL_OFFICE               
MFA-TR*            AND VO.COMPANY_NO            = B1.COMPANY_NO                 
MFA-TR*            AND B1.SERV_ORDER_WORK_CD IN                                 
MFA-TR*                ('METRO','DISTR','DISTC')                                
MFA-TR*            AND                                                          
MFA-TR*            (NOT EXISTS (SELECT 'Y'                                      
MFA-TR*                   FROM CSS_SO_APPLIANCE VQ                              
MFA-TR*                  WHERE VO.SERV_ORDER_NO  = VQ.SERV_ORDER_NO)            
MFA-TR*             OR (EXISTS (SELECT 'Y'                                      
MFA-TR*                   FROM CSS_SO_APPLIANCE  VQ,                            
MFA-TR*                        CSS_MKT_APPLIANCE JA                             
MFA-TR*                  WHERE VO.SERV_ORDER_NO  = VQ.SERV_ORDER_NO             
MFA-TR*                    AND VQ.APPLIANCE_CD   = JA.APPLIANCE_CD              
MFA-TR*                    AND VO.COMPANY_NO     = JA.COMPANY_NO                
MFA-TR*                    AND VQ.LIGHT_IND      = 'N'))                        
MFA-TR*             OR ((EXISTS(SELECT 'Y'                                      
MFA-TR*                    FROM CSS_SO_DATA V2                                  
MFA-TR*                   WHERE VO.SERV_ORDER_NO  = V2.SERV_ORDER_NO            
MFA-TR*                   AND SUBSTR(VO.CODES_DATA_PRESENT,12,1) = 'A')         
MFA-TR*             AND (NOT EXISTS(SELECT 'Y'                                  
MFA-TR*                        FROM CSS_SO_APPLIANCE  VQ,                       
MFA-TR*                             CSS_MKT_APPLIANCE JA                        
MFA-TR*                       WHERE VO.SERV_ORDER_NO  = VQ.SERV_ORDER_NO        
MFA-TR*                         AND VQ.APPLIANCE_CD   = JA.APPLIANCE_CD         
MFA-TR*                         AND VO.COMPANY_NO     = JA.COMPANY_NO           
MFA-TR*                         AND JA.SEASONAL_RT_FL = 'Y'                     
MFA-TR*                         AND JA.CIS_DISPLAY_FL = 'Y')))))                
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7601                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ACCOUNTS WITH DNP/RDO FOR SAME DAY        *         
      *****************************************************************         
           EXEC SQL                                                     
                DECLARE DNP-DTLS CURSOR FOR                             
                 SELECT DISTINCT VO.ACCOUNT_NO_PRIOR,                   
                        VO.PREMISE_NO,                                  
                        VO.LOCAL_OFFICE,                                
                        VO.COMPANY_NO                                   
                   FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                    
                  WHERE VO.ORDER_STATE_CD       = 'A'                   
                    AND VO.ORDER_TYPE_CD        ='DNP01'                
A03352              AND CAST(ASSIGNED_DATETIME AS DATE)  >  
              IIF(TRY_CONVERT(DATE, :WS-PREV-BUSS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSS-DAY) <> 10), CIS.CHAR2DATE(
                                                      :WS-PREV-BUSS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSS-DAY) )   
A03352              AND CAST(ASSIGNED_DATETIME AS DATE)  <= 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )    
                    AND EXISTS (SELECT V2.ACCOUNT_NO_PRIOR              
                          FROM CSS_SO_DATA V2 WITH(READUNCOMMITTED),            
                               CSS_SO_ORDER_INST VI
                           WITH(READUNCOMMITTED)                     
                         WHERE V2.ACCOUNT_NO_PRIOR = VO.ACCOUNT_NO_PRIOR
                          AND V2.SERV_ORDER_NO    = VI.SERV_ORDER_NO    
A01114                    AND V2.ORDER_STATE_CD IN ('A','B','D','H','R')
                          AND V2.BACK_DATED_IND IN ('N',' ')            
                          AND VI.WORK_TYPE_CD   IN ('RDO','VRB')        
                          AND (V2.ORDER_TYPE_CD LIKE 'CC%' OR           
                          V2.ORDER_TYPE_CD LIKE 'NC%'))                 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DNP-DTLS CURSOR FOR                                     
MFA-TR*          SELECT DISTINCT VO.ACCOUNT_NO_PRIOR,                           
MFA-TR*                 VO.PREMISE_NO,                                          
MFA-TR*                 VO.LOCAL_OFFICE,                                        
MFA-TR*                 VO.COMPANY_NO                                           
MFA-TR*            FROM CSS_SO_DATA VO                                          
MFA-TR*           WHERE VO.ORDER_STATE_CD       = 'A'                           
MFA-TR*             AND VO.ORDER_TYPE_CD        ='DNP01'                        
MFA-TR*             AND DATE(ASSIGNED_DATETIME)  >  :WS-PREV-BUSS-DAY           
MFA-TR*             AND DATE(ASSIGNED_DATETIME)  <= :WS-CURRENT-DATE            
MFA-TR*             AND EXISTS (SELECT V2.ACCOUNT_NO_PRIOR                      
MFA-TR*                   FROM CSS_SO_DATA V2,                                  
MFA-TR*                        CSS_SO_ORDER_INST VI                             
MFA-TR*                  WHERE V2.ACCOUNT_NO_PRIOR = VO.ACCOUNT_NO_PRIOR        
MFA-TR*                   AND V2.SERV_ORDER_NO    = VI.SERV_ORDER_NO            
MFA-TR*                   AND V2.ORDER_STATE_CD IN ('A','B','D','H','R')        
MFA-TR*                   AND V2.BACK_DATED_IND IN ('N',' ')                    
MFA-TR*                   AND VI.WORK_TYPE_CD   IN ('RDO','VRB')                
MFA-TR*                   AND (V2.ORDER_TYPE_CD LIKE 'CC%' OR                   
MFA-TR*                   V2.ORDER_TYPE_CD LIKE 'NC%'))                         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7700                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
P00390*****************************************************************         
P00390* CURSOR FOR FOLLY BEACH PREMISES WITH NO BILLING ADDRESS       *         
P00390*****************************************************************         
P00390     EXEC SQL                                                     
P00390          DECLARE BILL-ADDR CURSOR FOR                            
P00390           SELECT AT.ACCOUNT_NO,                                  
P00390                  AT.PREMISE_NO,                                  
P00390                  AT.CUSTOMER_NO,                                 
P00390                  AT.COMPANY_NO,                                  
P00390                  AT.LOCAL_OFFICE                                 
P00390             FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
P00390                  CSS_PREMISE PR WITH(READUNCOMMITTED),                   
P00390                  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)             
P00390            WHERE AT.PREMISE_NO     = PR.PREMISE_NO               
P00390              AND AT.COMPANY_NO     = PR.COMPANY_NO               
A02623              AND AT.CODE_ACCT_STAT = 'A'                         
P00390              AND PR.ADDRESS_ID     = DY.ADDRESS_ID               
P00390              AND DY.ZIP_CODE       = '29439'                     
P00390              AND NOT EXISTS                                      
P00390                  (SELECT AT1.ACCOUNT_NO                          
P00390                     FROM CSS_ACCOUNT AT1 WITH(READUNCOMMITTED),          
P00390                          CSS_ADDR_FORMATTED FO
                           WITH(READUNCOMMITTED)                   
P00390                    WHERE AT1.ACCOUNT_NO = AT.ACCOUNT_NO          
P00390                      AND AT1.ADDRESS_ID = FO.ADDRESS_ID)         
P00390              AND NOT EXISTS                                      
P00390                  (SELECT AT2.ACCOUNT_NO                          
P00390                     FROM CSS_ACCOUNT AT2 WITH(READUNCOMMITTED),          
P00390                          CSS_ADDR_FREEFORM DZ
                           WITH(READUNCOMMITTED)                    
P00390                    WHERE AT2.ACCOUNT_NO = AT.ACCOUNT_NO          
P00390                      AND AT2.ADDRESS_ID = DZ.ADDRESS_ID)         
P00390             FOR READ ONLY                                
P00390                                                      
P00390     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE BILL-ADDR CURSOR FOR                                    
MFA-TR*          SELECT AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.PREMISE_NO,                                          
MFA-TR*                 AT.CUSTOMER_NO,                                         
MFA-TR*                 AT.COMPANY_NO,                                          
MFA-TR*                 AT.LOCAL_OFFICE                                         
MFA-TR*            FROM CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_PREMISE PR,                                         
MFA-TR*                 CSS_ADDR_FORMATTED DY                                   
MFA-TR*           WHERE AT.PREMISE_NO     = PR.PREMISE_NO                       
MFA-TR*             AND AT.COMPANY_NO     = PR.COMPANY_NO                       
MFA-TR*             AND AT.CODE_ACCT_STAT = 'A'                                 
MFA-TR*             AND PR.ADDRESS_ID     = DY.ADDRESS_ID                       
MFA-TR*             AND DY.ZIP_CODE       = '29439'                             
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*                 (SELECT AT1.ACCOUNT_NO                                  
MFA-TR*                    FROM CSS_ACCOUNT AT1,                                
MFA-TR*                         CSS_ADDR_FORMATTED FO                           
MFA-TR*                   WHERE AT1.ACCOUNT_NO = AT.ACCOUNT_NO                  
MFA-TR*                     AND AT1.ADDRESS_ID = FO.ADDRESS_ID)                 
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*                 (SELECT AT2.ACCOUNT_NO                                  
MFA-TR*                    FROM CSS_ACCOUNT AT2,                                
MFA-TR*                         CSS_ADDR_FREEFORM DZ                            
MFA-TR*                   WHERE AT2.ACCOUNT_NO = AT.ACCOUNT_NO                  
MFA-TR*                     AND AT2.ADDRESS_ID = DZ.ADDRESS_ID)                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7800                                                 
MFA-TR*    END-EXEC.                                                            
P00390                                                                  
P00390*****************************************************************         
P00390* CURSOR FOR FOLLY BEACH BILL-ADDR WITH INCORRECT POBOX FORMAT  *         
P00390*****************************************************************         
P00390     EXEC SQL                                                     
P00390          DECLARE PO-FORMAT CURSOR FOR                            
P00390           SELECT AT.ACCOUNT_NO,                                  
P00390                  AT.CUSTOMER_NO,                                 
P00390                  AT.COMPANY_NO,                                  
P00390                  AT.LOCAL_OFFICE                                 
P00390             FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
P00390                  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)             
A02623            WHERE AT.CODE_ACCT_STAT  = 'A'                        
P00390              AND AT.ADDRESS_ID      = DY.ADDRESS_ID              
P00390              AND DY.ZIP_CODE        = '29439'                    
P00390              AND NOT DY.STREET_NAME LIKE 'PO BOX%'               
P00390              AND NOT DY.STREET_NAME LIKE 'P O BOX%'              
P00390              AND NOT DY.STREET_NAME LIKE 'P.O. BOX%'             
P00390              AND NOT DY.STREET_NAME LIKE 'P. O. BOX%'            
P00390              AND NOT DY.STREET_NAME LIKE 'P.O.BOX%'              
P00390              AND NOT DY.STREET_NAME LIKE 'POST OFFICE BOX%'      
P00390              AND NOT DY.STREET_NAME LIKE 'POBOX%'                
P00390          UNION                                                   
P00390           SELECT AT1.ACCOUNT_NO,                                 
P00390                  AT1.CUSTOMER_NO,                                
P00390                  AT1.COMPANY_NO,                                 
P00390                  AT1.LOCAL_OFFICE                                
P00390             FROM CSS_ACCOUNT AT1 WITH(READUNCOMMITTED),                  
P00390                  CSS_ADDR_FREEFORM  DZ WITH(READUNCOMMITTED)             
A01360            WHERE AT1.CODE_ACCT_STAT  = 'A'                       
P00390              AND AT1.ADDRESS_ID      = DZ.ADDRESS_ID             
P00390              AND DZ.ADDR_ZIP_CODE        = '29439'               
P00390              AND NOT DZ.ADDR_STREET LIKE 'PO BOX%'               
P00390              AND NOT DZ.ADDR_STREET LIKE 'P O BOX%'              
P00390              AND NOT DZ.ADDR_STREET LIKE 'P.O. BOX%'             
P00390              AND NOT DZ.ADDR_STREET LIKE 'P. O. BOX%'            
P00390              AND NOT DZ.ADDR_STREET LIKE 'P.O.BOX%'              
P00390              AND NOT DZ.ADDR_STREET LIKE 'POST OFFICE BOX%'      
P00390              AND NOT DZ.ADDR_STREET LIKE 'POBOX%'                
P00390             FOR READ ONLY                                
P00390                                                      
P00390     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE PO-FORMAT CURSOR FOR                                    
MFA-TR*          SELECT AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.CUSTOMER_NO,                                         
MFA-TR*                 AT.COMPANY_NO,                                          
MFA-TR*                 AT.LOCAL_OFFICE                                         
MFA-TR*            FROM CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_ADDR_FORMATTED DY                                   
MFA-TR*           WHERE AT.CODE_ACCT_STAT  = 'A'                                
MFA-TR*             AND AT.ADDRESS_ID      = DY.ADDRESS_ID                      
MFA-TR*             AND DY.ZIP_CODE        = '29439'                            
MFA-TR*             AND NOT DY.STREET_NAME LIKE 'PO BOX%'                       
MFA-TR*             AND NOT DY.STREET_NAME LIKE 'P O BOX%'                      
MFA-TR*             AND NOT DY.STREET_NAME LIKE 'P.O. BOX%'                     
MFA-TR*             AND NOT DY.STREET_NAME LIKE 'P. O. BOX%'                    
MFA-TR*             AND NOT DY.STREET_NAME LIKE 'P.O.BOX%'                      
MFA-TR*             AND NOT DY.STREET_NAME LIKE 'POST OFFICE BOX%'              
MFA-TR*             AND NOT DY.STREET_NAME LIKE 'POBOX%'                        
MFA-TR*         UNION                                                           
MFA-TR*          SELECT AT1.ACCOUNT_NO,                                         
MFA-TR*                 AT1.CUSTOMER_NO,                                        
MFA-TR*                 AT1.COMPANY_NO,                                         
MFA-TR*                 AT1.LOCAL_OFFICE                                        
MFA-TR*            FROM CSS_ACCOUNT AT1,                                        
MFA-TR*                 CSS_ADDR_FREEFORM  DZ                                   
MFA-TR*           WHERE AT1.CODE_ACCT_STAT  = 'A'                               
MFA-TR*             AND AT1.ADDRESS_ID      = DZ.ADDRESS_ID                     
MFA-TR*             AND DZ.ADDR_ZIP_CODE        = '29439'                       
MFA-TR*             AND NOT DZ.ADDR_STREET LIKE 'PO BOX%'                       
MFA-TR*             AND NOT DZ.ADDR_STREET LIKE 'P O BOX%'                      
MFA-TR*             AND NOT DZ.ADDR_STREET LIKE 'P.O. BOX%'                     
MFA-TR*             AND NOT DZ.ADDR_STREET LIKE 'P. O. BOX%'                    
MFA-TR*             AND NOT DZ.ADDR_STREET LIKE 'P.O.BOX%'                      
MFA-TR*             AND NOT DZ.ADDR_STREET LIKE 'POST OFFICE BOX%'              
MFA-TR*             AND NOT DZ.ADDR_STREET LIKE 'POBOX%'                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7900                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
A02623*****************************************************************         
A02623* CURSOR FOR CUSTOMER CHANGE/OFF ORDERS SCHEDULED FOR SAME DAY  *         
A02623*****************************************************************         
A02623     EXEC SQL                                                     
A02623          DECLARE CC-OFF CURSOR FOR                               
A02623           SELECT VO.PREMISE_NO,                                  
A02623                  VO.SERV_ORDER_NO,                               
A02623                  VO.ACCOUNT_NO_PRIOR,                            
A02623                  VO.COMPANY_NO,                                  
A02623                  VO.LOCAL_OFFICE                                 
A02623             FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                    
A02623            WHERE VO.ORDER_TYPE_CD   LIKE 'CC%'                   
A02623              AND VO.ORDER_STATE_CD  IN ('A','B','D','H','R')     
A03352              AND CAST(VO.ASSIGNED_DATETIME AS DATE) >  
              IIF(TRY_CONVERT(DATE, :WS-PREV-BUSS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSS-DAY) <> 10), CIS.CHAR2DATE(
                                                      :WS-PREV-BUSS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSS-DAY) ) 
A03352              AND CAST(VO.ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )  
A02623              AND EXISTS                                          
A02623                  (SELECT VO1.PREMISE_NO                          
A02623                     FROM CSS_SO_DATA VO1 WITH(READUNCOMMITTED)           
A02623                    WHERE VO.PREMISE_NO     = VO1.PREMISE_NO      
A02623                     AND VO1.ORDER_TYPE_CD  LIKE 'OFF%'           
A02623                     AND VO1.ORDER_STATE_CD IN                    
A02623                         ('A','B','D','H','R')                    
A02623                     AND CAST(VO.ASSIGNED_DATETIME AS DATE) =             
A02623                         CAST(VO1.ASSIGNED_DATETIME AS DATE))             
A02623             FOR READ ONLY                                
A02623                                                      
A02623     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CC-OFF CURSOR FOR                                       
MFA-TR*          SELECT VO.PREMISE_NO,                                          
MFA-TR*                 VO.SERV_ORDER_NO,                                       
MFA-TR*                 VO.ACCOUNT_NO_PRIOR,                                    
MFA-TR*                 VO.COMPANY_NO,                                          
MFA-TR*                 VO.LOCAL_OFFICE                                         
MFA-TR*            FROM CSS_SO_DATA VO                                          
MFA-TR*           WHERE VO.ORDER_TYPE_CD   LIKE 'CC%'                           
MFA-TR*             AND VO.ORDER_STATE_CD  IN ('A','B','D','H','R')             
MFA-TR*             AND DATE(VO.ASSIGNED_DATETIME) >  :WS-PREV-BUSS-DAY         
MFA-TR*             AND DATE(VO.ASSIGNED_DATETIME) <= :WS-CURRENT-DATE          
MFA-TR*             AND EXISTS                                                  
MFA-TR*                 (SELECT VO1.PREMISE_NO                                  
MFA-TR*                    FROM CSS_SO_DATA VO1                                 
MFA-TR*                   WHERE VO.PREMISE_NO     = VO1.PREMISE_NO              
MFA-TR*                    AND VO1.ORDER_TYPE_CD  LIKE 'OFF%'                   
MFA-TR*                    AND VO1.ORDER_STATE_CD IN                            
MFA-TR*                        ('A','B','D','H','R')                            
MFA-TR*                    AND DATE(VO.ASSIGNED_DATETIME) =                     
MFA-TR*                        DATE(VO1.ASSIGNED_DATETIME))                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7960                                                 
MFA-TR*    END-EXEC.                                                            
A02623                                                                  
A02623*****************************************************************         
A02623* CURSOR FOR CUSTOMER CHANGE/OCCUPANT CHANGE FRO ORDERS         *         
A02623*****************************************************************         
A02623     EXEC SQL                                                     
A02623          DECLARE CC-OC-FRO CURSOR FOR                            
A02623           SELECT VO.PREMISE_NO,                                  
A02623                  VO.SERV_ORDER_NO,                               
A02623                  VO.ACCOUNT_NO_PRIOR,                            
A02623                  VO.COMPANY_NO,                                  
A02623                  VO.LOCAL_OFFICE                                 
A02623             FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                    
A02623            WHERE VO.ORDER_TYPE_CD     IN ('CC001','CC002',       
A02623                                           'CC003','NC001',       
A04807                                           'OFF01','OFF02',       
A04807                                           'OFF03')               
A02623              AND VO.ORDER_STATE_CD    IN ('A','B','D','H','R')   
A02623              AND VO.BACK_DATED_IND    = 'Y'                      
A02623              AND CAST(VO.DATE_RECVED AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-PREV-BUSS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSS-DAY) <> 10), CIS.CHAR2DATE(
                                                      :WS-PREV-BUSS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSS-DAY) )       
A03352              AND CAST(VO.DATE_RECVED AS DATE) <  
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )        
A02623             FOR READ ONLY                                
A02623                                                      
A02623     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CC-OC-FRO CURSOR FOR                                    
MFA-TR*          SELECT VO.PREMISE_NO,                                          
MFA-TR*                 VO.SERV_ORDER_NO,                                       
MFA-TR*                 VO.ACCOUNT_NO_PRIOR,                                    
MFA-TR*                 VO.COMPANY_NO,                                          
MFA-TR*                 VO.LOCAL_OFFICE                                         
MFA-TR*            FROM CSS_SO_DATA VO                                          
MFA-TR*           WHERE VO.ORDER_TYPE_CD     IN ('CC001','CC002',               
MFA-TR*                                          'CC003','NC001',               
MFA-TR*                                          'OFF01','OFF02',               
MFA-TR*                                          'OFF03')                       
MFA-TR*             AND VO.ORDER_STATE_CD    IN ('A','B','D','H','R')           
MFA-TR*             AND VO.BACK_DATED_IND    = 'Y'                              
MFA-TR*             AND DATE(VO.DATE_RECVED) >= :WS-PREV-BUSS-DAY               
MFA-TR*             AND DATE(VO.DATE_RECVED) <  :WS-CURRENT-DATE                
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7975                                                 
MFA-TR*    END-EXEC.                                                            
A03352                                                                  
A03352*****************************************************************         
A03352* CURSOR FOR COURTESY ADJUSTMENTS                               *         
A03352*****************************************************************         
A03352     EXEC SQL                                                     
A03352          DECLARE CRTSY-ADJ CURSOR FOR                            
A03352           SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           WQ.DATE_CREATED, 121), ' ', '-'), ':', '.') DATE_CREATED,           
A03352                  WQ.ACCOUNT_NO,                                  
A03352                  WQ.PREMISE_NO,                                  
A03352                  WQ.CUSTOMER_NO,                                 
A03352                  WQ.COMPANY_NO,                                  
A03352                  WQ.SERV_ORDER_NO,                               
A03352                  WQ.STATUS,                                      
A03352                  WQ.USER_ID_ORIG,                                
A03352                  WQ.COMMENTS                                     
A03352             FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                   
A03352            WHERE WQ.CATEGORY_ID = 008                            
A03352              AND WQ.STATUS <> 'D'                                
A03352              AND WQ.DATE_CREATED >= CIS.CHAR2TIMESTAMP(
                                                         :WS-PREV-DATE1
              )               
A03352              AND WQ.DATE_CREATED <= CIS.CHAR2TIMESTAMP(
                                                         :WS-PREV-DATE2
              )               
A03352             FOR READ ONLY                                
A03352                                                      
A03352     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CRTSY-ADJ CURSOR FOR                                    
MFA-TR*          SELECT WQ.DATE_CREATED,                                        
MFA-TR*                 WQ.ACCOUNT_NO,                                          
MFA-TR*                 WQ.PREMISE_NO,                                          
MFA-TR*                 WQ.CUSTOMER_NO,                                         
MFA-TR*                 WQ.COMPANY_NO,                                          
MFA-TR*                 WQ.SERV_ORDER_NO,                                       
MFA-TR*                 WQ.STATUS,                                              
MFA-TR*                 WQ.USER_ID_ORIG,                                        
MFA-TR*                 WQ.COMMENTS                                             
MFA-TR*            FROM CSS_WQ_ITEMS WQ                                         
MFA-TR*           WHERE WQ.CATEGORY_ID = 008                                    
MFA-TR*             AND WQ.STATUS <> 'D'                                        
MFA-TR*             AND WQ.DATE_CREATED >= :WS-PREV-DATE1                       
MFA-TR*             AND WQ.DATE_CREATED <= :WS-PREV-DATE2                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7982                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                           PIC X(40) VALUE             
          'WORKING STORAGE FOR PCSSO163 ENDS HERE  '.                   
                                                                        
      ******************************************************************        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS MAIN PATH OF PROGRAM                           *        
      ******************************************************************        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZATION         THRU 1000-EXIT.          
                                                                        
           PERFORM 2000-MAIN-PROCESS           THRU 2000-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    1000-INITIALIZATION.                                        *        
      *                                                                *        
      ******************************************************************        
       1000-INITIALIZATION.                                             
                                                                        
           DISPLAY '**************************************************'.
           DISPLAY '** PROGRAM NAME: ' PROGRAM-NAME.                    
                                                                        
           MOVE '1000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
A02623     INITIALIZE                         WS-WQ-TYPE.               
                                                                        
A03352     PERFORM 7985-SELECT-JOB-PARM    THRU 7985-EXIT.              
A03352     MOVE WS-PARM-DATE               TO WS-CURRENT-DATE.          
A02623     MOVE WS-CURRENT-DATE            TO WS-NEW-BUSINESS-DAY.      
A02623     PERFORM 6525-PREV-BUSINESS-DAY  THRU                         
A02623     6525-PREV-BUSINESS-DAY-EXIT UNTIL NEXT-BUSINESS-DAY-FOUND.   
A02623     MOVE WS-NEW-BUSINESS-DAY        TO WS-PREV-BUSS-DAY.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2000-MAIN-PROCESS                                           *        
      *         DOES THE MAIN PROCESSING TO IDENTIFY SITUATIONS NEEDING*        
      *         WQ GENERATION.                                         *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
           PERFORM 7601-OPEN-APPLIANCE-CURSOR           THRU 7601-EXIT. 
           PERFORM 7625-FETCH-APPLIANCE-CURSOR          THRU 7625-EXIT. 
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A02623        SET APPL-DTLS                             TO TRUE         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                  PERFORM 2100-MOVE-DATA                THRU 2100-EXIT  
                  PERFORM 7625-FETCH-APPLIANCE-CURSOR   THRU 7625-EXIT  
              END-PERFORM                                               
           END-IF.                                                      
           PERFORM 7650-CLOSE-APPLIANCE-CURSOR          THRU 7750-EXIT. 
                                                                        
           PERFORM 7700-OPEN-DNP-CURSOR                 THRU 7700-EXIT. 
           PERFORM 7725-FETCH-DNP-CURSOR                THRU 7725-EXIT. 
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A02623        SET DNP-DTLS                              TO TRUE         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                  PERFORM 2100-MOVE-DATA                THRU 2100-EXIT  
                  PERFORM 7725-FETCH-DNP-CURSOR         THRU 7725-EXIT  
              END-PERFORM                                               
           END-IF.                                                      
           PERFORM 7750-CLOSE-DNP-CURSOR                THRU 7750-EXIT. 
                                                                        
P00390     PERFORM 7800-OPEN-BILL-ADDR-CURSOR           THRU 7800-EXIT. 
P00390     PERFORM 7825-FETCH-BILL-ADDR-CURSOR          THRU 7825-EXIT. 
P00390     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
P00390        PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
P00390            MOVE WS-Y                             TO WS-NO-ADDR   
A02623            PERFORM 7775-CHECK-DUPLICATE-WQ       THRU 7775-EXIT  
A02623            IF WS-NO-DUPLICATE                                    
P00390               PERFORM 2200-MOVE-ADDR-DATA        THRU 2200-EXIT  
A02623            END-IF                                                
P00390            PERFORM 7825-FETCH-BILL-ADDR-CURSOR   THRU 7825-EXIT  
P00390        END-PERFORM                                               
P00390     END-IF.                                                      
P00390     PERFORM 7850-CLOSE-BILL-ADDR-CURSOR          THRU 7850-EXIT. 
P00390                                                                  
P00390     PERFORM 7900-OPEN-PO-FORMAT-CURSOR           THRU 7900-EXIT. 
P00390     PERFORM 7925-FETCH-PO-FORMAT-CURSOR          THRU 7925-EXIT. 
P00390     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
P00390        PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
P00390            MOVE WS-N                             TO WS-NO-ADDR   
A02623            PERFORM 7775-CHECK-DUPLICATE-WQ       THRU 7775-EXIT  
A02623            IF WS-NO-DUPLICATE                                    
P00390               PERFORM 2200-MOVE-ADDR-DATA        THRU 2200-EXIT  
A02623            END-IF                                                
P00390            PERFORM 7925-FETCH-PO-FORMAT-CURSOR   THRU 7925-EXIT  
P00390        END-PERFORM                                               
P00390     END-IF.                                                      
P00390     PERFORM 7950-CLOSE-PO-FORMAT-CURSOR          THRU 7950-EXIT. 
P00390                                                                  
A02623     PERFORM 7955-OPEN-CC-OFF-CURSOR              THRU 7955-EXIT. 
A02623     PERFORM 7960-FETCH-CC-OFF-CURSOR             THRU 7960-EXIT. 
A02623     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A02623        PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
A02623            SET CC-OFF-DTLS                       TO TRUE         
A02623            PERFORM 2100-MOVE-DATA                THRU 2100-EXIT  
A02623            PERFORM 7960-FETCH-CC-OFF-CURSOR      THRU 7960-EXIT  
A02623        END-PERFORM                                               
A02623     END-IF.                                                      
A02623     PERFORM 7965-CLOSE-CC-OFF-CURSOR             THRU 7965-EXIT. 
A02623                                                                  
A02623     PERFORM 7970-OPEN-CC-OC-FRO-CURSOR           THRU 7970-EXIT. 
A02623     PERFORM 7975-FETCH-CC-OC-FRO-CURSOR          THRU 7975-EXIT. 
A02623     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A02623        PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
A02623            SET CC-OC-DTLS                        TO TRUE         
A02623            PERFORM 2100-MOVE-DATA                THRU 2100-EXIT  
A02623            PERFORM 7975-FETCH-CC-OC-FRO-CURSOR   THRU 7975-EXIT  
A02623        END-PERFORM                                               
A02623     END-IF.                                                      
A02623     PERFORM 7980-CLOSE-CC-OC-FRO-CURSOR          THRU 7980-EXIT. 
A03353                                                                  
A03353     PERFORM 7986-GET-PREV-DATE                   THRU 7986-EXIT. 
A03352     PERFORM 7982-OPEN-CRTSY-ADJ-CURSOR           THRU 7982-EXIT. 
A03352     PERFORM 7983-FETCH-CRTSY-ADJ-CURSOR          THRU 7983-EXIT. 
A03352     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
A03352        PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
A03352            SET CRTSY-ADJ                         TO TRUE         
A03352            PERFORM 2100-MOVE-DATA                THRU 2100-EXIT  
A03352            MOVE SPACES  TO WQ-COMMENTS-TEXT                      
A03352            PERFORM 7983-FETCH-CRTSY-ADJ-CURSOR   THRU 7983-EXIT  
A03352        END-PERFORM                                               
A03352     END-IF.                                                      
A03352     PERFORM 7984-CLOSE-CRTSY-ADJ-CURSOR          THRU 7984-EXIT. 
A03352     PERFORM 8600-UPDATE-JOB-PARM                 THRU 8600-EXIT. 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2100-MOVE-DATA                                              *        
      *    POPULATE THE WQ_ITEMS TABLE                                 *        
      ******************************************************************        
       2100-MOVE-DATA.                                                  
                                                                        
ACT078     INITIALIZE CWS00077-FIELDS.                                  
                                                                        
A02623     EVALUATE TRUE                                                
A02623        WHEN APPL-DTLS                                            
ACT078           MOVE VO-SERV-ORDER-NO        TO WS-77-SERV-ORDER-NO    
ACT078           MOVE 488                     TO WS-77-CATEGORY-ID      
ACT078           MOVE '4'                     TO WS-77-ROUTE-CATEGORY   
ACT078           MOVE WS-APPL-CMNTS           TO WS-77-COMMENTS-TEXT    
ACT078           MOVE LENGTH OF WS-APPL-CMNTS TO WS-77-COMMENTS-LEN     
A02623        WHEN DNP-DTLS                                             
ACT078           MOVE ZERO                    TO WS-77-SERV-ORDER-NO    
ACT078           MOVE WS-DNP-CMNTS            TO WS-77-COMMENTS-TEXT    
ACT078           MOVE LENGTH OF WS-DNP-CMNTS  TO WS-77-COMMENTS-LEN     
                 IF VO-COMPANY-NO = '01'                                
ACT078              MOVE 489                  TO WS-77-CATEGORY-ID      
ACT078              MOVE '4'                  TO WS-77-ROUTE-CATEGORY   
                 ELSE                                                   
ACT078              MOVE 491                  TO WS-77-CATEGORY-ID      
ACT078              MOVE '1'                  TO WS-77-ROUTE-CATEGORY   
                 END-IF                                                 
A02623        WHEN CC-OFF-DTLS                                          
ACT078           MOVE VO-SERV-ORDER-NO        TO WS-77-SERV-ORDER-NO    
ACT078           MOVE WS-CC-OFF-CMNTS         TO WS-77-COMMENTS-TEXT    
A02623           MOVE LENGTH OF WS-CC-OFF-CMNTS                         
ACT078                                        TO WS-77-COMMENTS-LEN     
A02623           IF VO-COMPANY-NO = '01'                                
ACT078              MOVE 506                  TO WS-77-CATEGORY-ID      
ACT078              MOVE '4'                  TO WS-77-ROUTE-CATEGORY   
A02623           ELSE                                                   
ACT078              MOVE 507                  TO WS-77-CATEGORY-ID      
ACT078              MOVE '1'                  TO WS-77-ROUTE-CATEGORY   
A02623           END-IF                                                 
A02623        WHEN CC-OC-DTLS                                           
ACT078           MOVE VO-SERV-ORDER-NO        TO WS-77-SERV-ORDER-NO    
ACT078           MOVE WS-CC-OC-CMNTS          TO WS-77-COMMENTS-TEXT    
A02623           MOVE LENGTH OF WS-CC-OC-CMNTS                          
ACT078                                        TO WS-77-COMMENTS-LEN     
A02623           IF VO-COMPANY-NO = '01'                                
ACT078              MOVE 508                  TO WS-77-CATEGORY-ID      
ACT078              MOVE '4'                  TO WS-77-ROUTE-CATEGORY   
A02623           ELSE                                                   
ACT078              MOVE 509                  TO WS-77-CATEGORY-ID      
ACT078              MOVE '1'                  TO WS-77-ROUTE-CATEGORY   
A02623           END-IF                                                 
A03352        WHEN CRTSY-ADJ                                            
A03352           MOVE SPACES                  TO WS-CRTSY-COMMENTS      
A03352           STRING                                                 
A03352         'Courtesy Adjustments Created By: ' DELIMITED BY SIZE    
A03352         WQ-USER-ID-ORIG,                                         
A03352         ' DATE: '                           DELIMITED BY SIZE    
A03352         WS-PREV-DATE                        DELIMITED BY SIZE    
A03352         ' COMMENTS: '                       DELIMITED BY SIZE    
A03352         WQ-COMMENTS-TEXT                    DELIMITED BY SIZE    
A03352           INTO WS-CRTSY-COMMENTS                                 
A03352           END-STRING                                             
ACT078           MOVE WQ-SERV-ORDER-NO        TO WS-77-SERV-ORDER-NO    
ACT078           MOVE 531                     TO WS-77-CATEGORY-ID      
ACT078           MOVE '4'                     TO WS-77-ROUTE-CATEGORY   
ACT078           MOVE WS-CRTSY-COMMENTS       TO WS-77-COMMENTS-TEXT    
A03352           MOVE LENGTH OF WS-CRTSY-COMMENTS                       
ACT078                                        TO WS-77-COMMENTS-LEN     
A03352           MOVE WQ-ACCOUNT-NO           TO VO-ACCOUNT-NO-PRIOR    
A03352           MOVE WQ-PREMISE-NO           TO VO-PREMISE-NO          
A03352           MOVE 0                       TO VO-LOCAL-OFFICE        
A03352           MOVE WQ-CUSTOMER-NO          TO WS-CUSTOMER-NO         
           END-EVALUATE.                                                
ACT078     MOVE VO-ACCOUNT-NO-PRIOR           TO WS-77-ACCOUNT-NO.      
ACT078     MOVE VO-PREMISE-NO                 TO WS-77-PREMISE-NO.      
ACT078     MOVE WS-CUSTOMER-NO                TO WS-77-CUSTOMER-NO.     
ACT078     MOVE WS-USER                       TO WS-77-USER-ID-ORIG.    
ACT078     MOVE SPACES                        TO WS-77-RESP-AREA-ID.    
ACT078     MOVE VO-LOCAL-OFFICE               TO WS-77-LOCAL-OFFICE.    
ACT078     MOVE WS-N                          TO WS-77-PRIORITY.        
ACT078     MOVE PROGRAM-NAME                  TO WS-77-CREATED-BY.      
                                                                        
ACT078     PERFORM 8500-INSERT-WORK-QUEUE     THRU 8500-EXIT.           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
ACT078                                                                  
P00390******************************************************************        
P00390*    2200-MOVE-ADDR-DATA                                         *        
P00390*    POPULATE THE WQ_ITEMS TABLE                                 *        
P00390******************************************************************        
P00390 2200-MOVE-ADDR-DATA.                                             
P00390                                                                  
ACT078     INITIALIZE CWS00077-FIELDS.                                  
                                                                        
ACT078     MOVE ZERO                       TO WS-77-SERV-ORDER-NO.      
ACT078     MOVE 505                        TO WS-77-CATEGORY-ID.        
ACT078     MOVE '4'                        TO WS-77-ROUTE-CATEGORY.     
P00390     IF WS-NO-ADDR = WS-Y                                         
P00390        MOVE WS-BILL-ADDR-CMNTS      TO WS-ADDR-CMNTS             
ACT078        MOVE AT-PREMISE-NO           TO WS-77-PREMISE-NO          
P00390     ELSE                                                         
P00390        MOVE WS-INCOR-ADDR-CMNTS     TO WS-ADDR-CMNTS             
ACT078        MOVE ZERO                    TO WS-77-PREMISE-NO          
P00390     END-IF.                                                      
ACT078     MOVE WS-ADDR-CMNTS              TO WS-77-COMMENTS-TEXT.      
ACT078     MOVE LENGTH OF WS-ADDR-CMNTS    TO WS-77-COMMENTS-LEN.       
ACT078     MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO.         
ACT078     MOVE AT-CUSTOMER-NO             TO WS-77-CUSTOMER-NO.        
ACT078     MOVE 'SYSTEM'                   TO WS-77-USER-ID-ORIG.       
ACT078     MOVE SPACES                     TO WS-77-RESP-AREA-ID.       
ACT078     MOVE AT-LOCAL-OFFICE            TO WS-77-LOCAL-OFFICE.       
ACT078     MOVE WS-N                       TO WS-77-PRIORITY.           
ACT078     MOVE PROGRAM-NAME               TO WS-77-CREATED-BY.         
P00390                                                                  
ACT078     PERFORM 8500-INSERT-WORK-QUEUE  THRU 8500-EXIT.              
P00390                                                                  
P00390 2200-EXIT.                                                       
P00390     EXIT.                                                        
P00390                                                                  
      ******************************************************************        
      *   7601-OPEN-APPLIANCE-CURSOR                                   *        
      *        OPENS THE APPLIANCE CURSOR TO FETCH ROWS                *        
      ******************************************************************        
       7601-OPEN-APPLIANCE-CURSOR.                                      
                                                                        
           MOVE '7601'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN APPL-DTLS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7601-OPEN-APPLIANCE-CURSOR'  
              DISPLAY '**  OPEN APPLIANCE CURSOR'                       
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7601-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7625-FETCH-APPLIANCE-CURSOR                                  *        
      *        GETS THE APPLIANCE INFO                                 *        
      ******************************************************************        
                                                                        
       7625-FETCH-APPLIANCE-CURSOR.                                     
                                                                        
           MOVE '7625'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH APPL-DTLS                                           
               INTO :VO-ACCOUNT-NO-PRIOR,                               
                    :VO-SERV-ORDER-NO,                                  
                    :VO-PREMISE-NO,                                     
                    :VO-LOCAL-OFFICE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7625-FETCH-APPLIANCE-CURSOR'  
              DISPLAY '**  FETCH APPLIANCE CURSOR'                      
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7650-CLOSE-APPLIANCE-CURSOR                                  *        
      *        CLOSING APPLIANCE CURSOR                                *        
      ******************************************************************        
                                                                        
       7650-CLOSE-APPLIANCE-CURSOR.                                     
                                                                        
           MOVE '7650'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE APPL-DTLS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7650-CLOSE-APPLIANCE-CURSOR'  
              DISPLAY '**  CLOSE APPLIANCE CURSOR '                     
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7700-OPEN-DNP-CURSOR                                         *        
      *        OPENS THE DNP CURSOR TO FETCH ROWS                      *        
      ******************************************************************        
       7700-OPEN-DNP-CURSOR.                                            
                                                                        
           MOVE '7700'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN DNP-DTLS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    =  7700-OPEN-DNP-CURSOR'        
              DISPLAY '**  OPEN DNP CURSOR'                             
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7725-FETCH-DNP-CURSOR                                        *        
      *        GETS THE DNP INFO                                       *        
      ******************************************************************        
                                                                        
       7725-FETCH-DNP-CURSOR.                                           
                                                                        
           MOVE '7725'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DNP-DTLS                                            
               INTO :VO-ACCOUNT-NO-PRIOR,                               
                    :VO-PREMISE-NO,                                     
                    :VO-LOCAL-OFFICE,                                   
                    :VO-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7725-FETCH-DNP-CURSOR'        
              DISPLAY '**  FETCH DNP CURSOR'                            
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7750-CLOSE-DNP-CURSOR                                        *        
      *        CLOSING DNP CURSOR                                      *        
      ******************************************************************        
                                                                        
       7750-CLOSE-DNP-CURSOR.                                           
                                                                        
           MOVE '7750'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE DNP-DTLS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7750-CLOSE-DNP-CURSOR'        
              DISPLAY '**  CLOSE DNP CURSOR '                           
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7775-CHECK-DUPLICATE-WQ                                      *        
      *        CHECK TO SEE IF THERE ARE ANY EXISTING WQ FOR FOLLY BEACH        
      ******************************************************************        
                                                                        
       7775-CHECK-DUPLICATE-WQ.                                         
                                                                        
           MOVE '7775'                     TO WS-ACTIVE-PARAGRAPH.      
           SET  WS-NO-DUPLICATE            TO TRUE.                     
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-DUPLICATE-WQ                                 
                  FROM CSS_WQ_ITEMS                                     
                 WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                     
                   AND CATEGORY_ID = 505                                
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-DUPLICATE-WQ                                         
MFA-TR*           FROM CSS_WQ_ITEMS                                             
MFA-TR*          WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                             
MFA-TR*            AND CATEGORY_ID = 505                                        
MFA-TR*            FETCH FIRST 1 ROW ONLY                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**  PROCESSING ERROR             **'             
              DISPLAY '**  PARAGRAPH    = 7775-CHECK-DUPLICATE-WQ'      
              DISPLAY '**  SELECT FROM CSS_WQ_ITEMS'                    
              DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**  PROCESSING TERMINATED        **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7775-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00390******************************************************************        
P00390*   7800-OPEN-BILL-ADDR-CURSOR                                   *        
P00390*        OPENS THE BILL-ADDR CURSOR                              *        
P00390******************************************************************        
P00390 7800-OPEN-BILL-ADDR-CURSOR.                                      
P00390                                                                  
P00390     MOVE '7800'                     TO WS-ACTIVE-PARAGRAPH.      
P00390                                                                  
P00390     EXEC SQL                                                     
P00390          OPEN BILL-ADDR                                          
P00390     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00390                                                                  
P00390     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00390                                                                  
P00390     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00390        NEXT SENTENCE                                             
P00390     ELSE                                                         
P00390        DISPLAY '***********************************'             
P00390        DISPLAY '**  PROCESSING ERROR             **'             
P00390        DISPLAY '**  PARAGRAPH    =  7800-OPEN-BILL-ADDR'         
P00390        DISPLAY '**  OPEN BILL-ADDR CURSOR'                       
P00390        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
P00390        DISPLAY '**  PROCESSING TERMINATED        **'             
P00390        DISPLAY '***********************************'             
P00390        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00390     END-IF.                                                      
P00390                                                                  
P00390 7800-EXIT.                                                       
P00390     EXIT.                                                        
P00390                                                                  
P00390******************************************************************        
P00390*   7825-FETCH-BILL-ADDR-CURSOR                                  *        
P00390*        GETS THE PREMISES WITH NO BILL ADDRESS                  *        
P00390******************************************************************        
P00390                                                                  
P00390 7825-FETCH-BILL-ADDR-CURSOR.                                     
P00390                                                                  
P00390     MOVE '7825'                     TO WS-ACTIVE-PARAGRAPH.      
P00390                                                                  
P00390     EXEC SQL                                                     
P00390        FETCH BILL-ADDR                                           
P00390         INTO :AT-ACCOUNT-NO,                                     
P00390              :AT-PREMISE-NO,                                     
P00390              :AT-CUSTOMER-NO,                                    
P00390              :AT-COMPANY-NO,                                     
P00390              :AT-LOCAL-OFFICE                                    
P00390     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00390                                                                  
P00390     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00390                                                                  
P00390     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00390        NEXT SENTENCE                                             
P00390     ELSE                                                         
P00390        DISPLAY '***********************************'             
P00390        DISPLAY '**  PROCESSING ERROR             **'             
P00390        DISPLAY '**  PARAGRAPH    = 7825-FETCH-BILL-ADDR-CURSOR'  
P00390        DISPLAY '**  FETCH BILL-ADDR CURSOR'                      
P00390        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
P00390        DISPLAY '**  PROCESSING TERMINATED        **'             
P00390        DISPLAY '***********************************'             
P00390        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00390     END-IF.                                                      
P00390                                                                  
P00390 7825-EXIT.                                                       
P00390     EXIT.                                                        
P00390                                                                  
P00390******************************************************************        
P00390*   7850-CLOSE-BILL-ADDR-CURSOR                                  *        
P00390*        CLOSING BILL-ADDR CURSOR                                *        
P00390******************************************************************        
P00390                                                                  
P00390 7850-CLOSE-BILL-ADDR-CURSOR.                                     
P00390                                                                  
P00390     MOVE '7850'                     TO WS-ACTIVE-PARAGRAPH.      
P00390                                                                  
P00390     EXEC SQL                                                     
P00390          CLOSE BILL-ADDR                                         
P00390     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00390                                                                  
P00390     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00390                                                                  
P00390     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00390        NEXT SENTENCE                                             
P00390     ELSE                                                         
P00390        DISPLAY '***********************************'             
P00390        DISPLAY '**  PROCESSING ERROR             **'             
P00390        DISPLAY '**  PARAGRAPH    = 7850-CLOSE-BILL-ADDR-CURSOR'  
P00390        DISPLAY '**  CLOSE BILL-ADDR CURSOR '                     
P00390        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
P00390        DISPLAY '**  PROCESSING TERMINATED        **'             
P00390        DISPLAY '***********************************'             
P00390        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00390     END-IF.                                                      
P00390                                                                  
P00390 7850-EXIT.                                                       
P00390     EXIT.                                                        
P00390                                                                  
P00390******************************************************************        
P00390*   7900-OPEN-PO-FORMAT-CURSOR                                   *        
P00390*        OPENS THE PO FORMAT CURSOR                              *        
P00390******************************************************************        
P00390 7900-OPEN-PO-FORMAT-CURSOR.                                      
P00390                                                                  
P00390     MOVE '7900'                     TO WS-ACTIVE-PARAGRAPH.      
P00390                                                                  
P00390     EXEC SQL                                                     
P00390          OPEN PO-FORMAT                                          
P00390     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00390                                                                  
P00390     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00390                                                                  
P00390     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00390        NEXT SENTENCE                                             
P00390     ELSE                                                         
P00390        DISPLAY '***********************************'             
P00390        DISPLAY '**  PROCESSING ERROR             **'             
P00390        DISPLAY '**  PARAGRAPH    =  7900-OPEN-PO-FORMAT-CURSOR'  
P00390        DISPLAY '**  OPEN PO-FORMAT CURSOR'                       
P00390        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
P00390        DISPLAY '**  PROCESSING TERMINATED        **'             
P00390        DISPLAY '***********************************'             
P00390        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00390     END-IF.                                                      
P00390                                                                  
P00390 7900-EXIT.                                                       
P00390     EXIT.                                                        
P00390                                                                  
P00390******************************************************************        
P00390*   7925-FETCH-PO-FORMAT-CURSOR                                  *        
P00390*        GETS THE PO FORMAT VARIATIONS                           *        
P00390******************************************************************        
P00390                                                                  
P00390 7925-FETCH-PO-FORMAT-CURSOR.                                     
P00390                                                                  
P00390     MOVE '7925'                     TO WS-ACTIVE-PARAGRAPH.      
P00390                                                                  
P00390     EXEC SQL                                                     
P00390        FETCH PO-FORMAT                                           
P00390         INTO :AT-ACCOUNT-NO,                                     
P00390              :AT-CUSTOMER-NO,                                    
P00390              :AT-COMPANY-NO,                                     
P00390              :AT-LOCAL-OFFICE                                    
P00390     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00390                                                                  
P00390     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00390                                                                  
P00390     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00390        NEXT SENTENCE                                             
P00390     ELSE                                                         
P00390        DISPLAY '***********************************'             
P00390        DISPLAY '**  PROCESSING ERROR             **'             
P00390        DISPLAY '**  PARAGRAPH    = 7925-FETCH-PO-FORMAT-CURSOR'  
P00390        DISPLAY '**  FETCH PO FORMAT CURSOR'                      
P00390        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
P00390        DISPLAY '**  PROCESSING TERMINATED        **'             
P00390        DISPLAY '***********************************'             
P00390        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00390     END-IF.                                                      
P00390                                                                  
P00390 7925-EXIT.                                                       
P00390     EXIT.                                                        
P00390                                                                  
P00390******************************************************************        
P00390*   7950-CLOSE-PO-FORMAT-CURSOR                                  *        
P00390*        CLOSING PO-FORMAT CURSOR                                *        
P00390******************************************************************        
P00390                                                                  
P00390 7950-CLOSE-PO-FORMAT-CURSOR.                                     
P00390                                                                  
P00390     MOVE '7950'                     TO WS-ACTIVE-PARAGRAPH.      
P00390                                                                  
P00390     EXEC SQL                                                     
P00390          CLOSE PO-FORMAT                                         
P00390     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00390                                                                  
P00390     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00390                                                                  
P00390     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00390        NEXT SENTENCE                                             
P00390     ELSE                                                         
P00390        DISPLAY '***********************************'             
P00390        DISPLAY '**  PROCESSING ERROR             **'             
P00390        DISPLAY '**  PARAGRAPH    = 7950-CLOSE-PO-FORMAT-CURSOR'  
P00390        DISPLAY '**  CLOSE PO-FORMAT CURSOR'                      
P00390        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
P00390        DISPLAY '**  PROCESSING TERMINATED        **'             
P00390        DISPLAY '***********************************'             
P00390        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00390     END-IF.                                                      
P00390                                                                  
P00390 7950-EXIT.                                                       
P00390     EXIT.                                                        
P00390                                                                  
A02623******************************************************************        
A02623*   7955-OPEN-CC-OFF-CURSOR                                      *        
A02623*        OPENS THE CURSOR FOR SAME DAY CC/OFF ORDERS             *        
A02623******************************************************************        
A02623 7955-OPEN-CC-OFF-CURSOR.                                         
A02623                                                                  
A02623     MOVE '7955'                     TO WS-ACTIVE-PARAGRAPH.      
A02623                                                                  
A02623     EXEC SQL                                                     
A02623          OPEN CC-OFF                                             
A02623     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02623                                                                  
A02623     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A02623                                                                  
A02623     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02623        NEXT SENTENCE                                             
A02623     ELSE                                                         
A02623        DISPLAY '***********************************'             
A02623        DISPLAY '**  PROCESSING ERROR             **'             
A02623        DISPLAY '**  PARAGRAPH    =  7955-OPEN-CC-OFF-CURSOR'     
A02623        DISPLAY '**  OPEN CC-OFF CURSOR'                          
A02623        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A02623        DISPLAY '**  PROCESSING TERMINATED        **'             
A02623        DISPLAY '***********************************'             
A02623        PERFORM 9900-ABEND           THRU 9900-EXIT               
A02623     END-IF.                                                      
A02623                                                                  
A02623 7955-EXIT.                                                       
A02623     EXIT.                                                        
A02623                                                                  
A02623******************************************************************        
A02623*   7960-FETCH-CC-OFF-CURSOR                                     *        
A02623*        GETS THE SAME DAY CC/OFF ORDER DETAILS                  *        
A02623******************************************************************        
A02623                                                                  
A02623 7960-FETCH-CC-OFF-CURSOR.                                        
A02623                                                                  
A02623     MOVE '7960'                     TO WS-ACTIVE-PARAGRAPH.      
A02623                                                                  
A02623     EXEC SQL                                                     
A02623        FETCH CC-OFF                                              
A02623         INTO :VO-PREMISE-NO,                                     
A02623              :VO-SERV-ORDER-NO,                                  
A02623              :VO-ACCOUNT-NO-PRIOR,                               
A02623              :VO-COMPANY-NO,                                     
A02623              :VO-LOCAL-OFFICE                                    
A02623     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02623                                                                  
A02623     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A02623                                                                  
A02623     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A02623        NEXT SENTENCE                                             
A02623     ELSE                                                         
A02623        DISPLAY '***********************************'             
A02623        DISPLAY '**  PROCESSING ERROR             **'             
A02623        DISPLAY '**  PARAGRAPH    = 7960-FETCH-CC-OFF-CURSOR'     
A02623        DISPLAY '**  FETCH CC-OFF CURSOR'                         
A02623        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A02623        DISPLAY '**  PROCESSING TERMINATED        **'             
A02623        DISPLAY '***********************************'             
A02623        PERFORM 9900-ABEND           THRU 9900-EXIT               
A02623     END-IF.                                                      
A02623                                                                  
A02623 7960-EXIT.                                                       
A02623     EXIT.                                                        
A02623                                                                  
A02623******************************************************************        
A02623*   7965-CLOSE-CC-OFF-CURSOR                                     *        
A02623*        CLOSING CC-OFF CURSOR                                   *        
A02623******************************************************************        
A02623                                                                  
A02623 7965-CLOSE-CC-OFF-CURSOR.                                        
A02623                                                                  
A02623     MOVE '7965'                     TO WS-ACTIVE-PARAGRAPH.      
A02623                                                                  
A02623     EXEC SQL                                                     
A02623          CLOSE CC-OFF                                            
A02623     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02623                                                                  
A02623     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A02623                                                                  
A02623     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02623        NEXT SENTENCE                                             
A02623     ELSE                                                         
A02623        DISPLAY '***********************************'             
A02623        DISPLAY '**  PROCESSING ERROR             **'             
A02623        DISPLAY '**  PARAGRAPH    = 7965-CLOSE-CC-OFF-CURSOR'     
A02623        DISPLAY '**  CLOSE CC-OFF CURSOR'                         
A02623        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A02623        DISPLAY '**  PROCESSING TERMINATED        **'             
A02623        DISPLAY '***********************************'             
A02623        PERFORM 9900-ABEND           THRU 9900-EXIT               
A02623     END-IF.                                                      
A02623                                                                  
A02623 7965-EXIT.                                                       
A02623     EXIT.                                                        
A02623                                                                  
A02623******************************************************************        
A02623*   7970-OPEN-CC-OC-FRO-CURSOR                                   *        
A02623*        OPENS THE CURSOR FOR CC/OC FRO ORDERS                   *        
A02623******************************************************************        
A02623 7970-OPEN-CC-OC-FRO-CURSOR.                                      
A02623                                                                  
A02623     MOVE '7970'                     TO WS-ACTIVE-PARAGRAPH.      
A02623                                                                  
A02623     EXEC SQL                                                     
A02623          OPEN CC-OC-FRO                                          
A02623     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02623                                                                  
A02623     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A02623                                                                  
A02623     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02623        NEXT SENTENCE                                             
A02623     ELSE                                                         
A02623        DISPLAY '***********************************'             
A02623        DISPLAY '**  PROCESSING ERROR             **'             
A02623        DISPLAY '**  PARAGRAPH    =  7970-OPEN-CC-OC-FRO-CURSOR'  
A02623        DISPLAY '**  OPEN CC-OC-FRO CURSOR'                       
A02623        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A02623        DISPLAY '**  PROCESSING TERMINATED        **'             
A02623        DISPLAY '***********************************'             
A02623        PERFORM 9900-ABEND           THRU 9900-EXIT               
A02623     END-IF.                                                      
A02623                                                                  
A02623 7970-EXIT.                                                       
A02623     EXIT.                                                        
A02623                                                                  
A02623******************************************************************        
A02623*   7975-FETCH-CC-OC-FRO-CURSOR                                  *        
A02623*        GETS THE CC/OC FRO ORDER DETAILS                        *        
A02623******************************************************************        
A02623                                                                  
A02623 7975-FETCH-CC-OC-FRO-CURSOR.                                     
A02623                                                                  
A02623     MOVE '7975'                     TO WS-ACTIVE-PARAGRAPH.      
A02623                                                                  
A02623     EXEC SQL                                                     
A02623        FETCH CC-OC-FRO                                           
A02623         INTO :VO-PREMISE-NO,                                     
A02623              :VO-SERV-ORDER-NO,                                  
A02623              :VO-ACCOUNT-NO-PRIOR,                               
A02623              :VO-COMPANY-NO,                                     
A02623              :VO-LOCAL-OFFICE                                    
A02623     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02623                                                                  
A02623     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A02623                                                                  
A02623     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A02623        NEXT SENTENCE                                             
A02623     ELSE                                                         
A02623        DISPLAY '***********************************'             
A02623        DISPLAY '**  PROCESSING ERROR             **'             
A02623        DISPLAY '**  PARAGRAPH    = 7975-FETCH-CC-OC-FRO-CURSOR'  
A02623        DISPLAY '**  FETCH CC-OC-FRO CURSOR'                      
A02623        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A02623        DISPLAY '**  PROCESSING TERMINATED        **'             
A02623        DISPLAY '***********************************'             
A02623        PERFORM 9900-ABEND           THRU 9900-EXIT               
A02623     END-IF.                                                      
A02623                                                                  
A02623 7975-EXIT.                                                       
A02623     EXIT.                                                        
A02623                                                                  
A02623******************************************************************        
A02623*   7980-CLOSE-CC-OC-FRO-CURSOR                                  *        
A02623*        CLOSING CC-OC-FRO CURSOR                                *        
A02623******************************************************************        
A02623                                                                  
A02623 7980-CLOSE-CC-OC-FRO-CURSOR.                                     
A02623                                                                  
A02623     MOVE '7980'                     TO WS-ACTIVE-PARAGRAPH.      
A02623                                                                  
A02623     EXEC SQL                                                     
A02623          CLOSE CC-OC-FRO                                         
A02623     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02623                                                                  
A02623     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A02623                                                                  
A02623     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02623        NEXT SENTENCE                                             
A02623     ELSE                                                         
A02623        DISPLAY '***********************************'             
A02623        DISPLAY '**  PROCESSING ERROR             **'             
A02623        DISPLAY '**  PARAGRAPH    = 7980-CLOSE-CC-OC-FRO-CURSOR'  
A02623        DISPLAY '**  CLOSE CC-OC-FRO CURSOR'                      
A02623        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A02623        DISPLAY '**  PROCESSING TERMINATED        **'             
A02623        DISPLAY '***********************************'             
A02623        PERFORM 9900-ABEND           THRU 9900-EXIT               
A02623     END-IF.                                                      
A02623                                                                  
A02623 7980-EXIT.                                                       
A02623     EXIT.                                                        
A02623                                                                  
A03352******************************************************************        
A03352*   7982-OPEN-CRTSY-ADJ-CURSOR                                   *        
A03352*        OPENS THE CURSOR FOR COURTESY ADJUSTMENTS               *        
A03352******************************************************************        
A03352 7982-OPEN-CRTSY-ADJ-CURSOR.                                      
A03352                                                                  
A03352     MOVE '7982'                     TO WS-ACTIVE-PARAGRAPH.      
A03352                                                                  
A03352     EXEC SQL                                                     
A03352          OPEN CRTSY-ADJ                                          
A03352     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03352                                                                  
A03352     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A03352                                                                  
A03352     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03352        NEXT SENTENCE                                             
A03352     ELSE                                                         
A03352        DISPLAY '***********************************'             
A03352        DISPLAY '**  PROCESSING ERROR             **'             
A03352        DISPLAY '**  PARAGRAPH    =  7982-OPEN-CRTSY-ADJ-CURSOR'  
A03352        DISPLAY '**  OPEN CRTSY-ADJ CURSOR'                       
A03352        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A03352        DISPLAY '**  PROCESSING TERMINATED        **'             
A03352        DISPLAY '***********************************'             
A03352        PERFORM 9900-ABEND           THRU 9900-EXIT               
A03352     END-IF.                                                      
A03352                                                                  
A03352 7982-EXIT.                                                       
A03352     EXIT.                                                        
A03352                                                                  
A03352******************************************************************        
A03352*   7983-FETCH-CRTSY-ADJ-CURSOR                                  *        
A03352*        GETS THE COURTESY ADJUSTMENTS DETAILS                   *        
A03352******************************************************************        
A03352                                                                  
A03352 7983-FETCH-CRTSY-ADJ-CURSOR.                                     
A03352                                                                  
A03352     MOVE '7983'                     TO WS-ACTIVE-PARAGRAPH.      
A03352     MOVE SPACES                     TO AR-TRAN-COMMENT.          
A03352                                                                  
A03352     EXEC SQL                                                     
A03352        FETCH CRTSY-ADJ                                           
A03352         INTO :WQ-DATE-CREATED,                                   
A03352              :WQ-ACCOUNT-NO,                                     
A03352              :WQ-PREMISE-NO,                                     
A03352              :WQ-CUSTOMER-NO,                                    
A03352              :WQ-COMPANY-NO,                                     
A03352              :WQ-SERV-ORDER-NO,                                  
A03352              :WQ-STATUS,                                         
A03352              :WQ-USER-ID-ORIG,                                   
A03352              :WQ-COMMENTS                                        
A03352     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03352                                                                  
A03352     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A03352                                                                  
A03352     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A03352        NEXT SENTENCE                                             
A03352     ELSE                                                         
A03352        DISPLAY '***********************************'             
A03352        DISPLAY '**  PROCESSING ERROR             **'             
A03352        DISPLAY '**  PARAGRAPH    = 7983-FETCH-CRTSY-ADJ-CURSOR'  
A03352        DISPLAY '**  FETCH CRTSY-ADJ CURSOR'                      
A03352        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A03352        DISPLAY '**  PROCESSING TERMINATED        **'             
A03352        DISPLAY '***********************************'             
A03352        PERFORM 9900-ABEND           THRU 9900-EXIT               
A03352     END-IF.                                                      
A03352                                                                  
A03352 7983-EXIT.                                                       
A03352     EXIT.                                                        
A03352                                                                  
A03352******************************************************************        
A03352*   7984-CLOSE-CRTSY-ADJ-CURSOR                                  *        
A03352*        CLOSING CRTSY-ADJ CURSOR                                *        
A03352******************************************************************        
A03352                                                                  
A03352 7984-CLOSE-CRTSY-ADJ-CURSOR.                                     
A03352                                                                  
A03352     MOVE '7984'                     TO WS-ACTIVE-PARAGRAPH.      
A03352                                                                  
A03352     EXEC SQL                                                     
A03352          CLOSE CRTSY-ADJ                                         
A03352     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03352                                                                  
A03352     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A03352                                                                  
A03352     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A03352        NEXT SENTENCE                                             
A03352     ELSE                                                         
A03352        DISPLAY '***********************************'             
A03352        DISPLAY '**  PROCESSING ERROR             **'             
A03352        DISPLAY '**  PARAGRAPH    = 7984-CLOSE-CRTSY-ADJ-CURSOR'  
A03352        DISPLAY '**  CLOSE CRTSY-ADJ CURSOR'                      
A03352        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A03352        DISPLAY '**  PROCESSING TERMINATED        **'             
A03352        DISPLAY '***********************************'             
A03352        PERFORM 9900-ABEND           THRU 9900-EXIT               
A03352     END-IF.                                                      
A03352                                                                  
A03352 7984-EXIT.                                                       
A03352     EXIT.                                                        
A03352                                                                  
A03352******************************************************************        
A03352*   7985-SELECT-JOB-PARM                                         *        
A03352*        SELECT CURRENT DATE FROM JOB PARM                       *        
A03352******************************************************************        
A03352 7985-SELECT-JOB-PARM.                                            
A03352                                                                  
A03352     EXEC SQL                                                     
A03352        SELECT PARM_DATA                                          
A03352          INTO :G6-PARM-DATA                                      
A03352          FROM CSS_JOB_PARM                                       
A03352         WHERE PROGRAM_NAME = 'PCSSO163'                          
A03352           AND COMPANY_NO   = '01'                                
A03352           AND CMND_CODE    = 'DATE'                              
A03352           AND SEQ_NO       = 10                                  
A03352           AND STATUS       = 'A'                                 
A03352     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03352                                                                  
A03352     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03352                                                                  
A03352     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03352        MOVE G6-PARM-DATA(10:10) TO WS-PARM-DATE                  
A03352     ELSE                                                         
A03352        DISPLAY '***********************************'             
A03352        DISPLAY '**  PROCESSING ERROR             **'             
A03352        DISPLAY '**  PARAGRAPH    = 7985-SELECT-JOB-PARM'         
A03352        DISPLAY '**  SELECT JOB PARM DATE'                        
A03352        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A03352        DISPLAY '**  PROCESSING TERMINATED        **'             
A03352        DISPLAY '***********************************'             
A03352        PERFORM 9900-ABEND           THRU 9900-EXIT               
A03352     END-IF.                                                      
A03352                                                                  
A03352 7985-EXIT.                                                       
A03352     EXIT.                                                        
A03352                                                                  
A03352******************************************************************        
A03352*   7986-GET-PREV-DATE                                           *        
A03352*        SELECT PREV DATE FOR PROCESSING                         *        
A03352******************************************************************        
A03352 7986-GET-PREV-DATE.                                              
A03352                                                                  
A03352     EXEC SQL                                                     
A03352       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-PREV-DATE                  
A03352     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-PREV-DATE                                                 
MFA-TR*              = DATE(:WS-CURRENT-DATE) - 1 DAYS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03352*                                                                         
A03352     IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
A03352         DISPLAY '***********************************'            
A03352         DISPLAY '**   ' WS-PGRMNAME ' PROCESSING ERROR   **'     
A03352         DISPLAY '**-------------------------------**'            
A03352         DISPLAY '**   7986-GET-PREV-DATE        :'               
A03352         DISPLAY '**   COULD NOT FIND PREV'                       
A03352         DISPLAY '**   DAY TO FETCH'                              
A03352         DISPLAY '***********************************'            
A03352         PERFORM 9900-ABEND         THRU 9900-EXIT                
A03352     ELSE                                                         
A03352         MOVE WS-PREV-DATE       TO WS-PREV-DATE1                 
A03352                                    WS-PREV-DATE2                 
A03352         MOVE '-00.00.00.000000' TO WS-PREV-DATE1(11:  )          
A03352         MOVE '-23.59.59.999999' TO WS-PREV-DATE2(11:  )          
A03352     END-IF.                                                      
A03352                                                                  
A03352 7986-EXIT.                                                       
A03352     EXIT.                                                        
A03352                                                                  
      ******************************************************************        
      *   8500-INSERT-WORK-QUEUE COPYBOOK                              *        
      ******************************************************************        
       8500-INSERT-WORK-QUEUE.                                          
                                                                        
ACT078     MOVE SPACES                      TO ABEND-FUNCTION.          
ACT078                                                                  
ACT078     CALL SCSCB077 USING CWS00077-FIELDS,                         
ACT078                         ABEND-FILE,                              
ACT078                         RS-RETURN-CODE.                          
ACT078     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE    
ACT078                                                                  
ACT078     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT078        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
ACT078        DISPLAY '8500-INSERT-WORK-QUEUE'                          
ACT078        DISPLAY 'CALL SCSCB077         '                          
ACT078        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT078        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT078        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT078        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT078        DISPLAY 'COMMENTS        ' WS-77-COMMENTS-TEXT            
ACT078        PERFORM 9900-ABEND             THRU 9900-EXIT             
ACT078     END-IF.                                                      
ACT078                                                                  
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03352******************************************************************        
A03352*   8600-UPDATE-JOB-PARM                                         *        
A03352*        UPDATE JOB PARM TABLE WITH NEXT DAYS DATE FOR RUN       *        
A03352******************************************************************        
A03352 8600-UPDATE-JOB-PARM.                                            
A03352*                                                                         
A03352     MOVE 'N'                        TO WS-NEXT-BUSINESS-DAY.     
A03352     MOVE WS-CURRENT-DATE            TO WS-NEW-BUSINESS-DAY.      
A03352     PERFORM 6500-GET-NEXT-BUSINESS-DAY  THRU                     
A03352             6500-NEXT-BUSINESS-DAY-EXIT UNTIL                    
A03352                  NEXT-BUSINESS-DAY-FOUND.                        
A03352     MOVE WS-NEW-BUSINESS-DAY        TO WS-NEXT-DATE.             
A03352*                                                                         
A03352     MOVE WS-NEXT-DATE TO G6-PARM-DATA(10:10).                    
A03352                                                                  
A03352     EXEC SQL                                                     
A03352        UPDATE CSS_JOB_PARM                                       
A03352           SET PARM_DATA    = :G6-PARM-DATA                       
A03352         WHERE PROGRAM_NAME = 'PCSSO163'                          
A03352           AND COMPANY_NO   = '01'                                
A03352           AND CMND_CODE    = 'DATE'                              
A03352           AND SEQ_NO       = 10                                  
A03352           AND STATUS       = 'A'                                 
A03352     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03352                                                                  
A03352     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03352                                                                  
A03352     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03352        NEXT SENTENCE                                             
A03352     ELSE                                                         
A03352        DISPLAY '***********************************'             
A03352        DISPLAY '**  PROCESSING ERROR             **'             
A03352        DISPLAY '**  PARAGRAPH    = 8600-UPDATE-JOB-PARM'         
A03352        DISPLAY '**  UPDATE JOB PARM DATE'                        
A03352        DISPLAY '**  RETURN CODE  = ' WS-ACTIVE-RETURN-CODE       
A03352        DISPLAY '**  PROCESSING TERMINATED        **'             
A03352        DISPLAY '***********************************'             
A03352        PERFORM 9900-ABEND           THRU 9900-EXIT               
A03352     END-IF.                                                      
A03352                                                                  
A03352 8600-EXIT.                                                       
A03352     EXIT.                                                        
A03352                                                                  
      *****************************************************************         
      *   9000-TERMINATE.                                             *         
      *****************************************************************         
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02623******************************************************************        
A02623* COPYBOOK DETERMINING THE PREVIOUS BUSINESS DAY                 *        
A02623******************************************************************        
A02623     EXEC SQL                                                             
A02623        INCLUDE CPD00315                                                  
A02623     END-EXEC.                                                            
A03352*                                                                         
      ******************************************************************        
      * COPYBOOK FOR ABEND ROUTINE                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
ACT078                                                                  
