       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSSO141.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM REFRESHES DNP DATA.                               **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    03/07    FB        ORIGINAL VERSION                       **         
      *    07/09    MSR       CHANGE COMMIT CNT TO 50                **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO141'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-ORDER       PIC 9(13).                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-ROW-COUNT           PIC S9(09) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-DATE-TRANS          PIC X(10).                        
                                                                        
      *01  LOC02324       USAGE SQL TYPE IS                             
      *                   RESULT-SET-LOCATOR VARYING.                   
                                                                        
       01  CSR02324-DATA.                                               
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE ZEROES.         
           05  WS-ACCOUNT-NO-CHAR REDEFINES WS-ACCOUNT-NO PIC X(13).    
           05  WS-FORECAST-DATE         PIC X(10) VALUE SPACES.         
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-TABLE-ID              PIC X(20) VALUE SPACES.         
           05  RS-MSG-TEXT              PIC X(30) VALUE SPACES.         
           05  RS-AMOUNT-DISC-BAL       PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  RS-AMOUNT-SECURITY       PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  RS-DATE-BILL-DAY-00      PIC X(10) VALUE SPACES.         
           05  RS-CREDIT-GROUP          PIC X(1)  VALUE SPACES.         
           05  RS-CODE-ARREARS          PIC X(1)  VALUE SPACES.         
           05  RS-CODE-DNP-TYPE         PIC X(1)  VALUE SPACES.         
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSODNP                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE SO_CURSOR CURSOR WITH HOLD FOR                     
               SELECT ACCOUNT_NO        ,                               
                      SERV_ORDER_NO     ,                               
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           DATE_FORECAST_DNP, 121), ' ', '-'), ':', '.') 
           DATE_FORECAST_DNP                                 
                 FROM CSS_SO_DATA                                       
                WHERE ORDER_TYPE_CD IN ('DNP01', 'DNPFB')               
                  AND ORDER_STATE_CD NOT IN ('Z', 'C')                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO_CURSOR CURSOR WITH HOLD FOR                             
MFA-TR*        SELECT ACCOUNT_NO        ,                                       
MFA-TR*               SERV_ORDER_NO     ,                                       
MFA-TR*               DATE_FORECAST_DNP                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ORDER_TYPE_CD IN ('DNP01', 'DNPFB')                       
MFA-TR*           AND ORDER_STATE_CD NOT IN ('Z', 'C')                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2324 CURSOR
MSQ001          FOR CALL CSR02324 ( :WS-ACCOUNT-NO-CHAR
                  , :WS-FORECAST-DATE
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-DATE-TRANS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                       
           DISPLAY 'TOTAL RECORDS = ' WS-DISPLAY-COUNT.                 
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           EXEC SQL                                                     
               OPEN SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING SO CURSOR          **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH SO_CURSOR                                           
               INTO :VO-ACCOUNT-NO,                                     
                    :VO-SERV-ORDER-NO,                                  
                    :VO-DATE-FORECAST-DNP                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-ORDER            
                   DISPLAY '****************************************'   
                   DISPLAY '**  1100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING SO CURSOR         **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER = ' WS-DISPLAY-ORDER              
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           INITIALIZE CSR02324-DATA.                                    
           MOVE VO-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
           MOVE VO-DATE-FORECAST-DNP(1:10) TO WS-FORECAST-DATE.         
      *    EXEC SQL                                                     
      *       CALL CSR02324 (:WS-ACCOUNT-NO-CHAR,                       
      *                      :WS-FORECAST-DATE)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2324
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2324
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2324 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN +466                                                
                   PERFORM 1120-PROCESS-SPDB-OUTPUT THRU 1120-EXIT      
               WHEN -471                                                
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  DBAS RESTART WLM OR CSR02324     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR CALLING CSR02324           **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000-UPDATE-SO-DATA THRU 2000-EXIT.                  
           PERFORM 2100-UPDATE-SO-DNP  THRU 2100-EXIT.                  
                                                                        
           ADD 1 TO WS-COMMIT-COUNT WS-ROW-COUNT.                       
           IF WS-COMMIT-COUNT > 50                                      
                 EXEC SQL                                               
                     COMMIT                                             
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                             
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1120-PROCESS-SPDB-OUTPUT.                                        
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC02324)                                               
      *       WITH PROCEDURE CSR02324                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2324 CURSOR FOR RESULT SET        
      *       :LOC02324                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_2324 INTO                           
                    :RS-RETURN-CODE                                     
                   ,:RS-TABLE-ID                                        
                   ,:RS-MSG-TEXT                                        
                   ,:RS-AMOUNT-DISC-BAL                                 
                   ,:RS-AMOUNT-SECURITY                                 
                   ,:RS-DATE-BILL-DAY-00                                
                   ,:RS-CREDIT-GROUP                                    
                   ,:RS-CODE-ARREARS                                    
                   ,:RS-CODE-DNP-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR FETCHING CSR02324 RESULTS  **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       1120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-UPDATE-SO-DATA.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET AMT_DNP_AT_BILLING = :RS-AMOUNT-DISC-BAL          
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-ORDER            
                   DISPLAY '****************************************'   
                   DISPLAY '**  2000-UPDATE-SO-DATA              **'    
                   DISPLAY '**  ERROR UPDATING CSS_SO_DATA       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER = ' WS-DISPLAY-ORDER              
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-UPDATE-SO-DNP.                                              
                                                                        
           MOVE RS-DATE-BILL-DAY-00 TO AI-DATE-BILL-DAY-00 (1:10).      
           MOVE '-00.00.00.000000' TO AI-DATE-BILL-DAY-00 (11:16).      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DNP                                        
                  SET AMOUNT_DISC_BAL    = :RS-AMOUNT-DISC-BAL,         
                      SECURITIES_TOT_AMT = :RS-AMOUNT-SECURITY,         
                      DATE_BILL_DAY_00   = CIS.CHAR2TIMESTAMP(
                                                   :AI-DATE-BILL-DAY-00
              ),        
                      CREDIT_GROUP       = :RS-CREDIT-GROUP,            
                      CUR_MTH_ARREARS_CD = :RS-CODE-ARREARS             
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DNP                                                
MFA-TR*           SET AMOUNT_DISC_BAL    = :RS-AMOUNT-DISC-BAL,                 
MFA-TR*               SECURITIES_TOT_AMT = :RS-AMOUNT-SECURITY,                 
MFA-TR*               DATE_BILL_DAY_00   = :AI-DATE-BILL-DAY-00,                
MFA-TR*               CREDIT_GROUP       = :RS-CREDIT-GROUP,                    
MFA-TR*               CUR_MTH_ARREARS_CD = :RS-CODE-ARREARS                     
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   MOVE VO-SERV-ORDER-NO TO WS-DISPLAY-ORDER            
                   DISPLAY '****************************************'   
                   DISPLAY '**  2100-UPDATE-SO-DNP               **'    
                   DISPLAY '**  ERROR UPDATING CSS_SO_DATA       **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER = ' WS-DISPLAY-ORDER              
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO141 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
