       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSSO131.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      ** THIS PROGRAM CHANGES THE SO102 DATE ON CSS_JOB_PARM.        ** 00200000
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    03/07    FB        ORIGINAL VERSION                       **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO131'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DATE-TRANS          PIC X(10).                        
           05  PROGRAM-NAME           PIC X(08) VALUE 'PCSSO131'.       
           05  WS-PARM-DATE           PIC X(10) VALUE SPACES.           
           05  WS-NEXT-DATE           PIC X(10) VALUE SPACES.           
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE TBJBPARM                                          00980000
           END-EXEC.                                                    00990000
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 7000-SELECT-JOB-PARM  THRU 7000-EXIT.                
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-PARM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PARM-DATE
              ) <> 0) OR (LEN(:WS-PARM-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-PARM-DATE
              ), CONVERT(DATE, :WS-PARM-DATE) ) )
            INTO
              :WS-NEXT-DATE                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES DATE(:WS-PARM-DATE) + 1 DAYS                              
MFA-TR*          INTO :WS-NEXT-DATE                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF WS-NEXT-DATE = G6-PARM-DATA(10:10)                        
               DISPLAY '****************************************'       
               DISPLAY '**  DATES DID NOT CHANGE             **'        
               DISPLAY '**  PREVIOUS DATE = ' G6-PARM-DATA(10:10)       
               DISPLAY '**  NEXT DATE     = ' WS-NEXT-DATE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
           MOVE WS-NEXT-DATE TO G6-PARM-DATA(10:10).                    
           PERFORM 7200-UPDATE-JOB-PARM  THRU 7200-EXIT.                
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'SO102'                             
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA(10:10) TO WS-PARM-DATE                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM     **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-UPDATE-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
                 SET PARM_DATA    = :G6-PARM-DATA                       
               WHERE PROGRAM_NAME = 'SO102'                             
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  ERROR UPDATING CSS_JOB_PARM      **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO131 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
