       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSSO122.                                         
COB303 DATE-WRITTEN.  APRIL 03, 2014.                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM REVERSES THE UPDATES FROM SEB CONSOLIDATION      *        
      *                                                                *        
      *  THIS PROGRAM UPDATES CSS_ACCOUNT                              *        
      *                       CSS_BILLING_DET                          *        
      *                       CSS_BILLING_HDR                          *        
      *                       CSS_COMM_DATA                            *        
      *                       CSS_CONTACT_PREMT                        *        
      ********                CSS_CUST_COMM_MF                         *        
      *                       CSS_CUST_PREM_HIST                       *        
      *                       CSS_MNT_TRANS_HIST                       *        
      *                       CSS_NAME_ACCT_XREF                       *        
      *                       CSS_PREMISE                              *        
      *                       CSS_REG_PROFILE                          *        
      *                       CSS_SO_DATA                              *        
      *                       CSS_UTIL_ENVRNMT                         *        
      *                       CSS_WQ_ITEMS                             *        
      *                       CSS_WQ_ITEMS_MF                          *        
      *                       HST_ACCOUNT                              *        
      *                       HST_SO_DATA                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *     DATE    INITIALS   COMMENTS                                *        
      *  ----------  ------   ---------------------------------------  *        
      *  04/03/2014  SC41135  PROGRAM CREATED.                         *        
ACT112*  04/15/2016  MS7M727  TO REMOVE CSS_WQ_ITEMS_MF TABLE          *        
      *              A04860                                            *        
A05460*  10 NOV 2016 RF10596  REMOVE CSS_CNSMPTN_MNTHLY TABLE          *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO122'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR PCSSO122 STARTS HERE'.                  
                                                                        
                                                                        
       01  PROGRAM-NAME                 PIC X(08) VALUE 'PCSSO118'.     
       01  WS-PGRMNAME                  PIC X(08).                      
       01  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.         
      *                                                                         
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
     ****** CSS_ACCOUNT - AT ******                                             
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
     ****** CSS_ADDR_FORMATTED - DY ******                                      
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_BILLING_HDR - BI ******                                         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_BILLING_DET - BG ******                                         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
     *                                                                  
     ****** CSS_COMM_DATA - KO ******                                           
     *                                                                  
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_COMM_DATA - KO ******                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_CONTACT_PREM - DX ******                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCPR                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_CUST_COMM_MF - CQ ******                                        
     ******                                                                     
     ******EXEC SQL                                                             
     ******   INCLUDE TBCSCMMF                                                  
     ******END-EXEC.                                                            
                                                                        
     ****** CSS_CUST_PREM_HIST - CH ******                                      
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_MISC_JRNL - MJ ******                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_MNT_TRANS_HIST - MH ******                                      
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_MT_TRN_HST_DET - MI ******                                      
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
     ****** CSS_NAME_ACCT_XREF - HT ******                                      
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_PREMISE - PR ******                                             
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
     ****** CSS_REG_PROFILE - LR ******                                         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_SO_DATA - VO ******                                             
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
     ****** CSS_UTIL_ENVRNMT - UT ******                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_WQ_ITEMS - WQ ******                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
     ****** HST_ACCOUNT - HA ******                                             
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
     ****** HST_SO_DATA - YV ******                                             
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
                                                                        
     ****** REV_BILLING_DET - RV ******                                         
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREVBLD                                                  
           END-EXEC.                                                            
     ****** CSS_JOB_PARM - G6  ******                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
                                                                        
    ********************* CURSORS *********************************             
           EXEC SQL                                                     
             DECLARE MAIN-CURSOR CURSOR WITH HOLD FOR                   
               SELECT MH.DATE_TRANS,                                    
                      MH.PREMISE_NO,                                    
                      LTRIM(RTRIM(MI.PRV_COLUMN_VALUE)),                
                      LTRIM(RTRIM(MI.CHG_COLUMN_VALUE)),                
                      LTRIM(RTRIM(MH.TRAN_COMMENT))                     
               FROM CSS_MNT_TRANS_HIST MH,                              
                    CSS_MT_TRN_HST_DET MI                               
              WHERE MH.DATE_TRANS = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                    
               AND MH.APPL_PROGRAM_ID = 'BATCH SP'                      
               AND MH.USER_ID = 'SYSTEM'                                
               AND MH.RESP_AREA_ID = '437'                              
               AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO          
               AND MH.TRAN_COMMENT LIKE                                 
                  'PREMISE NUMBER CHANGE FOR ACCT#%'                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MAIN-CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT MH.DATE_TRANS,                                            
MFA-TR*               MH.PREMISE_NO,                                            
MFA-TR*               LTRIM(RTRIM(MI.PRV_COLUMN_VALUE)),                        
MFA-TR*               LTRIM(RTRIM(MI.CHG_COLUMN_VALUE)),                        
MFA-TR*               LTRIM(RTRIM(MH.TRAN_COMMENT))                             
MFA-TR*        FROM CSS_MNT_TRANS_HIST MH,                                      
MFA-TR*             CSS_MT_TRN_HST_DET MI                                       
MFA-TR*       WHERE MH.DATE_TRANS = :WS-CURRENT-DATE                            
MFA-TR*        AND MH.APPL_PROGRAM_ID = 'BATCH SP'                              
MFA-TR*        AND MH.USER_ID = 'SYSTEM'                                        
MFA-TR*        AND MH.RESP_AREA_ID = '437'                                      
MFA-TR*        AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO                  
MFA-TR*        AND MH.TRAN_COMMENT LIKE                                         
MFA-TR*           'PREMISE NUMBER CHANGE FOR ACCT#%'                            
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
           COPY CWS00010.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-DISPLAY-COUNT        PIC S9(9) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-DISPLAY-SQLCODE      PIC -(8)9.                       
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT              PIC X(13) VALUE SPACES.          
           05  WS-ACCOUNT-NUM    REDEFINES WS-ACCOUNT PIC S9(13).       
           05  PROGRAM-NAME            PIC X(08) VALUE 'S122    '.      
           05  WS-NEW-PREM             PIC X(10) VALUE SPACES.          
           05  WS-OLD-PREM             PIC X(10) VALUE SPACES.          
           05  WS-PREV-PREM-NO         PIC X(10) VALUE SPACES.          
           05  WS-CURR-PREM-NO         PIC X(10) VALUE SPACES.          
           05  WS-USERID               PIC X(7).                        
COB305     05 WS-OLD-ADDR-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-NEW-ADDR-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-COUNT                PIC S9(04) COMP VALUE 1.         
           05  MULTIPLE-ROWS-SELECTED  PIC S9(09) VALUE -811 COMP.      
           05  WS-PREV-VALUE            PIC X(45) VALUE SPACES.         
           05  WS-NEW-VALUE             PIC X(45) VALUE SPACES.         
           05  WS-TRAN-COMMENT          PIC X(45) VALUE SPACES.         
           05  WS-FILLER-1              PIC X(13) VALUE SPACES.         
           05  WS-FILLER-2              PIC X(13) VALUE SPACES.         
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05   S-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE +1.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
          10  S-SP-NAME                 PIC X(18) VALUE SPACES.         
          10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.         
          10  S-SQLSTATE                PIC X(5)  VALUE ' '.            
          10  S-TABLE-NAME              PIC X(18) VALUE SPACES.         
          10  S-HOST-VARIABLES.                                         
              49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.           
              49  S-HOST-VARIABLES-V    PIC X(255).                     
          10  S-SQL-STATEMENT.                                          
              49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.           
              49  S-SQL-STATEMENT-V     PIC X(255).                     
          10  S-SQL-DESCRIPTION.                                        
              49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.           
              49  S-SQL-DESCRIPTION-V   PIC X(255).                     
          10  WS-ABEND-SQLERRMC.                                        
              49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.           
              49  WS-ABEND-SQLERRMC-V   PIC X(255).                     
          10  RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
          10  WS-SQLSTATE               PIC X(05) VALUE SPACES.         
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
            PERFORM 2005-GET-RUN-DATE          THRU 2005-EXIT.          
            PERFORM 2000-MAIN-PROCESS          THRU 2000-EXIT.          
            MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                      
            DISPLAY 'TOTAL RECORDS = ' WS-DISPLAY-COUNT.                
            STOP RUN.                                                   
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-MAIN-PROCESS                                              *        
      *                                                                *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
              PERFORM 2100-GET-PREMISE-NOS      THRU 2100-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2005-GET-RUN-DATE                                              *        
      *                                                                *        
      ******************************************************************        
       2005-GET-RUN-DATE.                                               
                                                                        
             MOVE '2005'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) G6.PARM_DATA                                     
                   INTO :G6-PARM-DATA                                   
                   FROM CSS_JOB_PARM G6                                 
                    WHERE G6.PROGRAM_NAME = 'PCSSO122'                  
                      AND G6.CMND_CODE    = 'DATE'                      
                      AND G6.STATUS= 'A'                                
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT G6.PARM_DATA                                             
MFA-TR*            INTO :G6-PARM-DATA                                           
MFA-TR*            FROM CSS_JOB_PARM G6                                         
MFA-TR*             WHERE G6.PROGRAM_NAME = 'PCSSO122'                          
MFA-TR*               AND G6.CMND_CODE    = 'DATE'                              
MFA-TR*               AND G6.STATUS= 'A'                                        
MFA-TR*               FETCH FIRST 1 ROW ONLY                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE G6-PARM-DATA(1:10)  TO WS-CURRENT-DATE                
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                  
           END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT_DATE                          
MFA-TR*    END-EXEC                                                             
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                     
           END-IF                                                       
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                CONTINUE                                                
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  2005-GET-RUN-DATE                **'    
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM      **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       2005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-GET-PREMISE-NOS                                           *        
      *                                                                *        
      ******************************************************************        
       2100-GET-PREMISE-NOS.                                            
                                                                        
           MOVE  '2100'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7000-OPEN-MNT-TRANS-CURSOR     THRU 7000-EXIT.       
           PERFORM 7005-FETCH-MNT-TRANS-CURSOR    THRU 7005-EXIT        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
                                                                        
               MOVE WS-TRAN-COMMENT(32:13) TO WS-ACCOUNT                
                                                                        
               PERFORM 7035-GET-ADDR-ID THRU 7035-EXIT                  
               PERFORM 2080-CONSOLIDATE-PREM THRU 2080-EXIT             
               ADD 1 TO WS-ROW-COUNT                                    
                                                                        
              IF WS-COMMIT-COUNT > 100 THEN                             
                 EXEC SQL                                               
                   COMMIT                                               
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT                                
              END-IF                                                    
                                                                        
               PERFORM 7005-FETCH-MNT-TRANS-CURSOR    THRU 7005-EXIT    
             END-PERFORM.                                               
              PERFORM 8190-DELETE-TRANS-HIST         THRU 8190-EXIT     
                                                                        
                PERFORM 7010-CLOSE-MNT-TRANS-CURSOR    THRU 7010-EXIT.  
                                                                        
              EXEC SQL                                                  
                COMMIT                                                  
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2080-CONSOLIDATE-PREM.                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2080-CONSOLIDATE-PREM.                                           
                                                                        
             MOVE '2080'                     TO WS-ACTIVE-PARAGRAPH.    
              MOVE  WS-ACCOUNT-NUM     TO BI-ACCOUNT-NO                 
                                          BG-ACCOUNT-NO                 
                                          HA-ACCOUNT-NO                 
                                          KO-ACCOUNT-NO                 
                                          HT-ACCOUNT-NO                 
                                          CH-ACCOUNT-NO                 
                                          MJ-ACCOUNT-NO                 
                                          AT-ACCOUNT-NO                 
                                          VO-ACCOUNT-NO                 
                                          LR-ACCOUNT-NO                 
                                          UT-ACCOUNT-NO                 
                                          WQ-ACCOUNT-NO                 
                                          YV-ACCOUNT-NO                 
                                          RV-ACCOUNT-NO                 
                                          MH-ACCOUNT-NO                 
              MOVE  PR-ADDRESS-ID      TO WS-NEW-ADDR-ID                
           PERFORM 8010-UPDATE-CSS-BILLING-HDR    THRU 8010-EXIT        
           PERFORM 8020-UPDATE-CSS-BILLING-DET    THRU 8020-EXIT        
           PERFORM 8040-UPDATE-CSS-COMM-DATA      THRU 8040-EXIT        
           PERFORM 8050-UPDATE-CSS-MNT-TRANS-HIST THRU 8050-EXIT        
           PERFORM 8060-UPDATE-CSS-NAME-ACCT-XREF THRU 8060-EXIT        
           PERFORM 8070-UPDATE-CSS-CONTACT-PREM   THRU 8070-EXIT        
           PERFORM 8090-UPDATE-CSS-CUST-PREM-HIST THRU 8090-EXIT        
           PERFORM 8100-UPDATE-CSS-MISC-JRNL      THRU 8100-EXIT        
           PERFORM 8110-UPDATE-CSS-REG-PROFILE    THRU 8110-EXIT        
           PERFORM 8120-UPDATE-CSS-SO-DATA        THRU 8120-EXIT        
           PERFORM 8125-UPDATE-HST-SO-DATA        THRU 8125-EXIT        
           PERFORM 8130-UPDATE-CSS-UTIL-ENVRNMT   THRU 8130-EXIT        
           PERFORM 8140-UPDATE-CSS-WQ-ITEMS       THRU 8140-EXIT        
           PERFORM 8150-SELECT-CSS-ACCOUNT        THRU 8150-EXIT        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             PERFORM 8160-UPDATE-CSS-ACCOUNT        THRU 8160-EXIT      
           ELSE                                                         
             PERFORM 8170-UPDATE-HST-ACCOUNT        THRU 8170-EXIT      
           END-IF                                                       
             PERFORM 8180-UPDATE-REV-BILLING-DET    THRU 8180-EXIT      
             ADD 1 TO WS-COMMIT-COUNT.                                  
                                                                        
       2080-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-MNT-TRANS-CURSOR                                     *        
      *                                                                *        
      ******************************************************************        
       7000-OPEN-MNT-TRANS-CURSOR.                                      
                                                                        
             MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
             EXEC SQL                                                   
                OPEN MAIN-CURSOR                                        
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                   CONTINUE                                             
             ELSE                                                       
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7000-OPEN-MNT-TRANS-CURSOR        **'   
                   DISPLAY '**  ERROR OPENING  MNT-TRANS   CURSOR **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
              END-IF.                                                   
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7005-FETCH-MNT-TRANS-CURSOR                                    *        
      *                                                                *        
      ******************************************************************        
       7005-FETCH-MNT-TRANS-CURSOR.                                     
                                                                        
             MOVE '7005'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              FETCH MAIN-CURSOR                                         
               INTO :MH-DATE-TRANS                                      
                   ,:MH-PREMISE-NO                                      
                   ,:WS-NEW-PREM                                        
                   ,:WS-OLD-PREM                                        
                   ,:WS-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             IF WS-ROW-COUNT > 0                                        
                MOVE MH-PREMISE-NO TO WS-CURR-PREM-NO                   
             IF WS-PREV-PREM-NO NOT EQUAL WS-CURR-PREM-NO               
                PERFORM 8190-DELETE-TRANS-HIST         THRU 8190-EXIT   
             END-IF                                                     
             END-IF                                                     
             MOVE MH-PREMISE-NO  TO WS-PREV-PREM-NO                     
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7005-FETCH-MNT-TRANS-CURSOR      **'    
                   DISPLAY '**  ERROR FETCHING MNT-TRANS   CURSOR**'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PREMISE = ' PR-PREMISE-NO               
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-CLOSE-MNT-TRANS-CURSOR                                    *        
      *                                                                *        
      ******************************************************************        
       7010-CLOSE-MNT-TRANS-CURSOR.                                     
                                                                        
             MOVE '7010'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                CLOSE MAIN-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7010-CLOSE-MNT-TRANS-CURSOR      **'    
                   DISPLAY '**  ERROR CLOSING MNT-TRANS   CURSOR  **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7035-GET-ADDR-ID                                               *        
      *                                                                *        
      ******************************************************************        
       7035-GET-ADDR-ID.                                                
                                                                        
             MOVE '7035'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_ID                                         
                 INTO                                                   
                     :PR-ADDRESS-ID                                     
               FROM CSS_PREMISE                                         
               WHERE PREMISE_NO = :WS-NEW-PREM                          
                                                            
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDRESS_ID                                                 
MFA-TR*          INTO                                                           
MFA-TR*              :PR-ADDRESS-ID                                             
MFA-TR*        FROM CSS_PREMISE                                                 
MFA-TR*        WHERE PREMISE_NO = :WS-NEW-PREM                                  
MFA-TR*        QUERYNO 7035                                                     
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                   CONTINUE                                             
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7035-GET-ADDR-ID                  **'   
                   DISPLAY '**  ERROR SEL FROM CSS_PREMISE        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
        7035-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-UPDATE-CSS-BILLING-HDR                                    *        
      *                                                                *        
      ******************************************************************        
       8010-UPDATE-CSS-BILLING-HDR.                                     
                                                                        
             MOVE '8010'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_HDR                                   
                  SET PREMISE_NO  = :WS-NEW-PREM                        
                WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                      
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_HDR                                           
MFA-TR*           SET PREMISE_NO  = :WS-NEW-PREM                                
MFA-TR*         WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
             CONTINUE                                                   
            ELSE                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  8010-UPDATING-CSS-BILLING-HDR     **'        
              DISPLAY '**  ERROR UPDATING PREMISE-NO         **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' BI-ACCOUNT-NO                    
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-UPDATE-CSS-BILLING-DET                                    *        
      *                                                                *        
      ******************************************************************        
       8020-UPDATE-CSS-BILLING-DET.                                     
                                                                        
             MOVE '8020'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_DET                                   
                  SET PREMISE_NO  = :WS-NEW-PREM                        
                WHERE ACCOUNT_NO  = :BG-ACCOUNT-NO                      
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_DET                                           
MFA-TR*           SET PREMISE_NO  = :WS-NEW-PREM                                
MFA-TR*         WHERE ACCOUNT_NO  = :BG-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  8020-UPDATE-CSS-BILLING-DET       **'        
              DISPLAY '**  ERROR UPDATING PREMISE-NO         **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' BG-ACCOUNT-NO                    
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8040-UPDATE-CSS-COMM-DATA                                      *        
      *                                                                *        
      ******************************************************************        
       8040-UPDATE-CSS-COMM-DATA.                                       
                                                                        
             MOVE '8040'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COMM_DATA                                     
                  SET PREMISE_NO = :WS-NEW-PREM                         
                WHERE ACCOUNT_NO  =  :KO-ACCOUNT-NO                     
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COMM_DATA                                             
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM                                 
MFA-TR*         WHERE ACCOUNT_NO  =  :KO-ACCOUNT-NO                             
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
             ELSE                                                       
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  8040-UPDATE-CSS-COMM-DATA         **'        
              DISPLAY '**  ERROR UPDATING PREMISE-NO         **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' KO-ACCOUNT-NO                    
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8050-UPDATE-CSS-MNT-TRANS-HIST                                 *        
      *                                                                *        
      ******************************************************************        
       8050-UPDATE-CSS-MNT-TRANS-HIST.                                  
                                                                        
             MOVE '8050'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MNT_TRANS_HIST                                
                  SET PREMISE_NO  = :WS-NEW-PREM                        
                WHERE ACCOUNT_NO  =  :MH-ACCOUNT-NO                     
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MNT_TRANS_HIST                                        
MFA-TR*           SET PREMISE_NO  = :WS-NEW-PREM                                
MFA-TR*         WHERE ACCOUNT_NO  =  :MH-ACCOUNT-NO                             
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                    CONTINUE                                            
            ELSE                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  8050-UPDATE-CSS-MNT-TRANS-HIST    **'        
              DISPLAY '**  ERROR UPDATING PREMISE-NO         **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' MH-ACCOUNT-NO                    
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
            END-IF.                                                     
                                                                        
        8050-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8060-UPDATE-CSS-NAME-ACCT-XREF                                 *        
      *                                                                *        
      ******************************************************************        
       8060-UPDATE-CSS-NAME-ACCT-XREF.                                  
                                                                        
             MOVE '8060'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_NAME_ACCT_XREF                                
                  SET PREMISE_NO = :WS-NEW-PREM,                        
                      ADDRESS_ID = :WS-NEW-ADDR-ID                      
                 WHERE ACCOUNT_NO  = :HT-ACCOUNT-NO                     
                   AND PREMISE_NO = :WS-OLD-PREM                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_NAME_ACCT_XREF                                        
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM,                                
MFA-TR*               ADDRESS_ID = :WS-NEW-ADDR-ID                              
MFA-TR*          WHERE ACCOUNT_NO  = :HT-ACCOUNT-NO                             
MFA-TR*            AND PREMISE_NO = :WS-OLD-PREM                                
MFA-TR*        QUERYNO 8060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '****************************************'      
                DISPLAY '**  8060-UPDATE-CSS-NAME-ACCT-XREF    **'      
                DISPLAY '**  ERROR UPDATING PREMISE-NO         **'      
                DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE             
                DISPLAY '**  ACCOUNT = ' HT-ACCOUNT-NO                  
                DISPLAY '**  PROCESSING TERMINATED             **'      
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                 
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
************************************************************************        
******* 8070-UPDATE-CSS-CONTACT-PREM                                   *        
*******                                                                *        
************************************************************************        
****** 8070-UPDATE-CSS-CONTACT-PREM.                                    
******                                                                  
******       MOVE '8070'                     TO WS-ACTIVE-PARAGRAPH.    
******                                                                  
******     EXEC SQL                                                     
******         UPDATE CSS_CONTACT_PREM                                  
******            SET PREMISE_NO  = :WS-NEW-PREM                        
******          WHERE PREMISE_NO = :WS-OLD-PREM                         
******                                                      
******     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CONTACT_PREM                                          
MFA-TR*           SET PREMISE_NO  = :WS-NEW-PREM                                
MFA-TR*         WHERE PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

******                                                                  
******      MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
******                                                                  
******      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
******              CONTINUE                                            
******      ELSE                                                        
******        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
******        DISPLAY '****************************************'        
******        DISPLAY '**  8070-UPDATE-CSS-CONTACT-PREM      **'        
******        DISPLAY '**  ERROR UPDATING PREMISE-NO         **'        
******        DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
******        DISPLAY '**  PROCESSING TERMINATED             **'        
******        DISPLAY '****************************************'        
******        PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
******      END-IF.                                                     
******                                                                  
******  8070-EXIT.                                                      
******      EXIT.                                                       
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8090-UPDATE-CSS-CUST-PREM-HIST                                 *        
      *                                                                *        
      ******************************************************************        
       8090-UPDATE-CSS-CUST-PREM-HIST.                                  
                                                                        
             MOVE '8090'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUST_PREM_HIST                                
                  SET PREMISE_NO  = :WS-NEW-PREM                        
                WHERE ACCOUNT_NO  = :CH-ACCOUNT-NO                      
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_PREM_HIST                                        
MFA-TR*           SET PREMISE_NO  = :WS-NEW-PREM                                
MFA-TR*         WHERE ACCOUNT_NO  = :CH-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  8090-UPDATE-CSS-CUST-PREM-HIST    **'        
              DISPLAY '**  ERROR UPDATING PREMISE-NO         **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' CH-ACCOUNT-NO                    
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8100-UPDATE-CSS-MISC-JRNL                                      *        
      *                                                                *        
      ******************************************************************        
       8100-UPDATE-CSS-MISC-JRNL.                                       
                                                                        
             MOVE '8100'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MISC_JRNL                                     
                  SET PREMISE_NO  = :WS-NEW-PREM                        
                WHERE ACCOUNT_NO  = :MJ-ACCOUNT-NO                      
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MISC_JRNL                                             
MFA-TR*           SET PREMISE_NO  = :WS-NEW-PREM                                
MFA-TR*         WHERE ACCOUNT_NO  = :MJ-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  8100-UPDATE-CSS-MISC-JRNL         **'        
              DISPLAY '**  ERROR UPDATING PREMISE-NO         **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' MJ-ACCOUNT-NO                    
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8110-UPDATE-CSS-REG-PROFILE                                    *        
      *                                                                *        
      ******************************************************************        
       8110-UPDATE-CSS-REG-PROFILE.                                     
                                                                        
             MOVE '8110'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_REG_PROFILE                                   
                  SET PREMISE_NO = :WS-NEW-PREM                         
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_REG_PROFILE                                           
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM                                 
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '****************************************'      
                DISPLAY '**  8110-UPDATE-CSS-REG-PROFILE       **'      
                DISPLAY '**  ERROR UPDATING PREMISE-NO         **'      
                DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE             
                DISPLAY '**  ACCOUNT = ' LR-ACCOUNT-NO                  
                DISPLAY '**  PROCESSING TERMINATED             **'      
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                 
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8120-UPDATE-CSS-SO-DATA                                        *        
      *                                                                *        
      ******************************************************************        
       8120-UPDATE-CSS-SO-DATA.                                         
                                                                        
             MOVE '8120'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET PREMISE_NO = :WS-NEW-PREM                         
                 WHERE ACCOUNT_NO_PRIOR  = :VO-ACCOUNT-NO               
                   AND PREMISE_NO = :WS-OLD-PREM                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM                                 
MFA-TR*          WHERE ACCOUNT_NO_PRIOR  = :VO-ACCOUNT-NO                       
MFA-TR*            AND PREMISE_NO = :WS-OLD-PREM                                
MFA-TR*        QUERYNO 8120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '****************************************'      
                DISPLAY '**  8120-UPDATE-CSS-SO-DATA           **'      
                DISPLAY '**  ERROR UPDATING PREMISE-NO         **'      
                DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE             
                DISPLAY '**  ACCOUNT = ' VO-ACCOUNT-NO                  
                DISPLAY '**  PROCESSING TERMINATED             **'      
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                 
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8125-UPDATE-HST-SO-DATA                                        *        
      *                                                                *        
      ******************************************************************        
       8125-UPDATE-HST-SO-DATA.                                         
                                                                        
             MOVE '8125'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE HST_SO_DATA                                       
                  SET PREMISE_NO = :WS-NEW-PREM                         
                 WHERE ACCOUNT_NO_PRIOR = :YV-ACCOUNT-NO                
                   AND PREMISE_NO = :WS-OLD-PREM                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE HST_SO_DATA                                               
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM                                 
MFA-TR*          WHERE ACCOUNT_NO_PRIOR = :YV-ACCOUNT-NO                        
MFA-TR*            AND PREMISE_NO = :WS-OLD-PREM                                
MFA-TR*        QUERYNO 8125                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '****************************************'      
                DISPLAY '**  8125-UPDATE-HST-SO-DATA           **'      
                DISPLAY '**  ERROR UPDATING PREMISE-NO         **'      
                DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE             
                DISPLAY '**  ACCOUNT = ' YV-ACCOUNT-NO                  
                DISPLAY '**  PROCESSING TERMINATED             **'      
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                 
           END-IF.                                                      
                                                                        
       8125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8130-UPDATE-CSS-UTIL-ENVRNMT                                   *        
      *                                                                *        
      ******************************************************************        
       8130-UPDATE-CSS-UTIL-ENVRNMT.                                    
                                                                        
             MOVE '8130'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_UTIL_ENVRNMT                                  
                  SET PREMISE_NO = :WS-NEW-PREM                         
                 WHERE ACCOUNT_NO  = :UT-ACCOUNT-NO                     
                   AND PREMISE_NO = :WS-OLD-PREM                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_UTIL_ENVRNMT                                          
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM                                 
MFA-TR*          WHERE ACCOUNT_NO  = :UT-ACCOUNT-NO                             
MFA-TR*            AND PREMISE_NO = :WS-OLD-PREM                                
MFA-TR*        QUERYNO 8130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                 MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE       
                 DISPLAY '****************************************'     
                 DISPLAY '**  8130-UPDATE-CSS-UTIL-ENVRNMT      **'     
                 DISPLAY '**  ERROR UPDATING PREMISE-NO         **'     
                 DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE            
                 DISPLAY '**  ACCOUNT = ' UT-ACCOUNT-NO                 
                 DISPLAY '**  PROCESSING TERMINATED             **'     
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8140-UPDATE-CSS-WQ-ITEMS                                       *        
      *                                                                *        
      ******************************************************************        
       8140-UPDATE-CSS-WQ-ITEMS.                                        
                                                                        
             MOVE '8140'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
            EXEC SQL                                                    
               UPDATE CSS_WQ_ITEMS                                      
                  SET PREMISE_NO  = :WS-NEW-PREM                        
                WHERE ACCOUNT_NO  = :WQ-ACCOUNT-NO                      
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*     EXEC SQL                                                            
MFA-TR*        UPDATE CSS_WQ_ITEMS                                              
MFA-TR*           SET PREMISE_NO  = :WS-NEW-PREM                                
MFA-TR*         WHERE ACCOUNT_NO  = :WQ-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8140                                                     
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
            ELSE                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  8140-UPDATE-CSS-WQ-ITEMS          **'        
              DISPLAY '**  ERROR UPDATING PREMISE-NO         **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  ACCOUNT = ' WQ-ACCOUNT-NO                    
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                   
           END-IF.                                                      
                                                                        
         8140-EXIT.                                                     
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 8150-SELECT-CSS-ACCOUNT                                        *        
      *                                                                *        
      ******************************************************************        
       8150-SELECT-CSS-ACCOUNT.                                         
                                                                        
             MOVE '8150'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
               INTO :AT-ACCOUNT-NO                                      
               FROM CSS_ACCOUNT                                         
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND PREMISE_NO =:WS-OLD-PREM                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO =:WS-OLD-PREM                                  
MFA-TR*        QUERYNO 8150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8150-SELECT-CSS-ACCOUNT           **'       
               DISPLAY '**  ERROR SELECTING PREMISE-NO        **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' AT-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
            END-IF.                                                     
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8160-UPDATE-CSS-ACCOUNT                                        *        
      *                                                                *        
      ******************************************************************        
       8160-UPDATE-CSS-ACCOUNT.                                         
                                                                        
             MOVE '8160'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET PREMISE_NO  = :WS-NEW-PREM                        
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND PREMISE_NO = :WS-OLD-PREM                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET PREMISE_NO  = :WS-NEW-PREM                                
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM                                 
MFA-TR*        QUERYNO 8150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8160-UPDATE-CSS-ACCOUNT           **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' AT-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
            END-IF.                                                     
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8180-UPDATE-REV-BILLING-DET                                    *        
      *                                                                *        
      ******************************************************************        
       8180-UPDATE-REV-BILLING-DET.                                     
                                                                        
             MOVE '8180'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               UPDATE REV_BILLING_DET                                   
                  SET PREMISE_NO =  :WS-NEW-PREM                        
                WHERE ACCOUNT_NO  = :RV-ACCOUNT-NO                      
                  AND PREMISE_NO  = :WS-OLD-PREM                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE REV_BILLING_DET                                           
MFA-TR*           SET PREMISE_NO =  :WS-NEW-PREM                                
MFA-TR*         WHERE ACCOUNT_NO  = :RV-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO  = :WS-OLD-PREM                                
MFA-TR*        QUERYNO 8180                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '****************************************'      
                DISPLAY '**  8180-UPDATE-REV-BILLING-DET       **'      
                DISPLAY '**  ERROR UPDATING PREMISE-NO         **'      
                DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE             
                DISPLAY '**  ACCOUNT = ' RV-ACCOUNT-NO                  
                DISPLAY '**  PROCESSING TERMINATED             **'      
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                 
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8170-UPDATE-HST-ACCOUNT                                                 
      *                                                                         
      *****************************************************************         
       8170-UPDATE-HST-ACCOUNT.                                         
                                                                        
              MOVE '8170'                     TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            EXEC SQL                                                    
                UPDATE HST_ACCOUNT                                      
                   SET PREMISE_NO =  :WS-NEW-PREM                       
                 WHERE ACCOUNT_NO  = :HA-ACCOUNT-NO                     
                   AND PREMISE_NO  = :WS-OLD-PREM                       
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE HST_ACCOUNT                                              
MFA-TR*            SET PREMISE_NO =  :WS-NEW-PREM                               
MFA-TR*          WHERE ACCOUNT_NO  = :HA-ACCOUNT-NO                             
MFA-TR*            AND PREMISE_NO  = :WS-OLD-PREM                               
MFA-TR*         QUERYNO 8170                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '****************************************'      
                DISPLAY '**  8170-UPDATE-HST-ACCOUNT           **'      
                DISPLAY '**  ERROR UPDATING PREMISE-NO         **'      
                DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE             
                DISPLAY '**  ACCOUNT = ' HA-ACCOUNT-NO                  
                DISPLAY '**  PROCESSING TERMINATED             **'      
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                 
           END-IF.                                                      
                                                                        
       8170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8190-DELETE-TRANS-HIST                                         *        
      *                                                                *        
      ******************************************************************        
       8190-DELETE-TRANS-HIST.                                          
                                                                        
             MOVE '8190'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_MNT_TRANS_HIST                           
                  WHERE PREMISE_NO = :WS-PREV-PREM-NO                   
                  AND APPL_PROGRAM_ID = 'BATCH SP'                      
                  AND TRAN_COMMENT LIKE 'PREMISE NUMBER CHANGE%'        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_MNT_TRANS_HIST                                   
MFA-TR*           WHERE PREMISE_NO = :WS-PREV-PREM-NO                           
MFA-TR*           AND APPL_PROGRAM_ID = 'BATCH SP'                              
MFA-TR*           AND TRAN_COMMENT LIKE 'PREMISE NUMBER CHANGE%'                
MFA-TR*        QUERYNO 8190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE        
                DISPLAY '****************************************'      
                DISPLAY '**  8190-DELETE-TRANS-HISTT           **'      
                DISPLAY '**  ERROR DELETING TRANS-HIST         **'      
                DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE             
                DISPLAY '**  PROCESSING TERMINATED             **'      
                DISPLAY '****************************************'      
                PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                 
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO118 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
