       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSSO119.                                         
COB303 DATE-WRITTEN.  AUGUST 20, 2013.                                  
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES THE PREMISE NUMBER FOR AN ACCOUNT -      *        
      *  CONSOLIDATES SEB PREMISE-NOS TO THE MOST RECENT PREMISE-NO    *        
      *  FOR A GIVEN AGL-PREMISE-NO.                                   *        
      *                                                                *        
      *  SCENARIO 1:  MAIN CURSOR - NEW ACCOUNTS                       *        
      *  ------------------------------------------                    *        
      *  1.RETRIEVE ALL THE LATEST UPDATED PREMISE DATA BASED ON THE   *        
      *    COMMON RUN DATE.                                            *        
      *  2.CHECK WHETHER THE ABOVE FETCHED AGL PREMISE HAS ANY OTHER   *        
      *    OLD PREMISE NUMBER WHICH IS NOT HAVING ANY ACTIVE ACCOUNTS  *        
      *    A) IF YES,CONTINUE THE UPDATE PROCESS ELSE IT WILL HAVE NEW *        
      *       PREMISE NUMBER WHICH CREATED AS PART OF PREMISE PROCESS. *        
      *  3.VALIDATE OLD AND NEW PREMISE ADDRESS, IF ADDRESS HAS ANY    *        
      *    CHANGE CREATE A WQ AND UPDATE ALL REQUIRED TABLE WITH OLD   *        
      *    PREMISE NUMBER.                                             *        
      *                                                                *        
      *  SCENARIO 2:  FINAL BILLED ACCOUNTS.                           *        
      *  -------------------------------------                         *        
      *   1.GET ALL THE FINAL BILLED ACCOUNTS PREMISE DATA WHICH HAS   *        
      *     OLD PREMISE NUMBER WITH A ACTIVE  ACCOUNTS BASED ON THE    *        
      *     COMMON RUN DATE.                                           *        
      *   2.RETRIEVE OLD ACTIVE PREMISE ACCOUNT DETAILS FOR THE SAME   *        
      *     AGL PREMISE NUMBER.                                        *        
      *   3.VALIDATE OLD AND NEW PREMISE ADDRESS, IF ADDRESS HAS ANY   *        
      *     CHANGE CREATE A WQ AND UPDATE ALL ACTIVE PREMISE ACCOUNTS  *        
      *     REQUIRED TABLE WITH FINAL BILLED ACCOUNT PREMISE NUMBER.   *        
      *                                                                *        
      *  SCENARIO 3:  NEW ACCTS WHICH HAS OLD PREMISE WITHOUT ANY ACCT.*        
      *  ------------------------------------------------------------  *        
      *  1.GET ALL THE NEW PREMISE ACCOUNTS WHICH HAS OLD PREMISE ALONE*        
      *    WITHOUT ANY ACCOUNT                                         *        
      *  2.GET EXISTING OLD  PREMISE DETAILS FOR THE SAME AGL WHICH    *        
      *    IS NOT HAVING ANY ACCOUNT                                   *        
      *  3.VALDIATE OLD AND NEW PREMISE ADDRESS, IF ADDRESS HAS ANY    *        
      *    CHANGE CREATE A WQ AND UPDATE ONLY COMMUNICATION DATA,      *        
      *    TRANSACTION HISTORY, WQ ITEMS AND DELETE NAME XREF TABLE    *        
      *    USING CURRENT ACCOUNT NEW PREMISE NUMBER.                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES CSS_ACCOUNT                              *        
      *                       CSS_BILLING_DET                          *        
      *                       CSS_BILLING_HDR                          *        
      *                       CSS_COMM_DATA                            *        
      *                       CSS_CONTACT_PREMT                        *        
      *                       CSS_CUST_PREM_HIST                       *        
      *                       CSS_MNT_TRANS_HIST                       *        
      *                       CSS_NAME_ACCT_XREF                       *        
      *                       CSS_PREMISE                              *        
      *                       CSS_REG_PROFILE                          *        
      *                       CSS_SO_DATA                              *        
      *                       CSS_UTIL_ENVRNMT                         *        
      *                       CSS_WQ_ITEMS                             *        
      *                       CSS_WQ_ITEMS_MF                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *     DATE    INITIALS   COMMENTS                                *        
      *  ----------  ------   ---------------------------------------  *        
      *  08/20/2013  SC41135  PROGRAM CREATED.                         *        
      *  05/15/2014  SC41135  ADDED CURSOR TO CONSOLIDATE PENDING PREM *        
      *                       TAGGED WITH P77801                                
A     *  01/28/2015  FMB      CHANGED WQ PROCESS TO DISPLAY OLD AND    *        
A     *                       NEW ADDRESSES. GENERAL FORMAT CLEANUP.   *        
ACT067*  02/16/2015  SS7F226  WORK QUEUE CHANGE TO REPLACE THE         *        
ACT067*              A04860   CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS AND    *        
ACT067*                       REMOVED THE UNUSED CODE.                 *        
A05460*  05/25/2016  SM93554  IF THE OLD PREMISE NUMBER (WHICH WE      *        
      *              ACT182   CONSIDER AS NEW IN THE PROGRAM) PRIOR TO *        
      *                       2012-01-01 WILL CONSIDER AS INVALID PREM *        
      *                       NUMBER AND WE WONT USE THE SAME PREMISE  *        
      *                       AS VALID FOR UPDATE. INSTEAD, WE WILL BE *        
      *                       UPDATING THE INVALID PREMISE ACCOUNTS    *        
      *                       WITH CURRENT PREMISE NUMBER.             *        
      *                                                                *        
A05460*  10 NOV 2016 RF10596  REMOVE CSS_CNSMPTN_MNTHLY FROM PROGRAM   *        
A05460*  17 NOV 2016 MR7E794  PROD FIX TO ADD NOT-FOUND CASE FOR AVOID *        
      *              ACT346   ABEND AND ADD DISPLY PREM NO IN PARA 7125*        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO119'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR PCSSO118 STARTS HERE'.                  
                                                                        
       01  PROGRAM-NAME                 PIC X(08) VALUE 'PCSSO118'.     
ACT067 01  WS-PGRMNAME                  PIC X(08) VALUE 'PCSSO119'.     
ACT067 01  SCSCB077                     PIC X(08) VALUE 'SCSCB077'.     
       01  WS-RUN-DATE                  PIC X(10) VALUE SPACES.         
COB305 01 WS-NEW-PREM-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.       
COB305 01 WS-OLD-PREM-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.       
COB305 01 WS-HOLD-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
                                                                        
       01  WS-MISC.                                                     
           05 WS-ACTIVE                 PIC X(01) VALUE 'A'.            
           05 WS-SEB                    PIC X(02) VALUE '01'.           
           05 WS-ZERO                   PIC 9(04) VALUE 0.              
           05 WS-PREM-MAX-END-DT        PIC X(10) VALUE SPACES.         
           05 WS-NULL-DATE-IND          PIC S9(4)  COMP.                
           05 WS-NEW-PREMISE-STATUS     PIC X(01) VALUE 'Y'.            
              88 NEW-PREM-VALID                   VALUE 'Y'.            
              88 NEW-PREM-INVALID                 VALUE 'N'.            
           05 WS-NO-MORE-ROWS           PIC X(01) VALUE 'N'.            
           05 WS-DONT-PRCESS-PEND-PREM  PIC X(01) VALUE 'N'.            
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
     ****** CSS_ACCOUNT - AT ****************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
     ****** CSS_ADDR_FORMATTED - DY *********************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_BILLING_HDR - BI ************************                       
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_BILLING_DET - BG ************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
     *                                                                  
     ****** CSS_COMM_DATA - KO **************************                       
     *                                                                  
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_MISC_JRNL - KO **************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_CONTACT_PREM - DX ***********************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCPR                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_CUST_PREM_HIST - CH *********************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_MISC_JRNL - MJ **************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_MNT_TRANS_HIST - MH *********************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_MT_TRN_HST_DET - MI *********************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
     ****** CSS_NAME_ACCT_XREF - HT *********************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_PREMISE - PR ****************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
     ****** CSS_REG_PROFILE - LR ************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_SO_DATA - VO ****************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
     ****** CSS_SO_UPDATE - VW***************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
     ****** CSS_UTIL_ENVRNMT - UT ***********************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_WQ_ITEMS - WQ ***************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
     ****** HST_ACCOUNT - HA ****************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
     ****** HST_SO_DATA - YV ****************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
                                                                        
     ****** REV_BILLING_DET - RV ************************                       
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREVBLD                                                  
           END-EXEC.                                                            
                                                                        
     ****** CSS_JOB_PARM - G6  ******                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
    *********************MAIN-CURSOR ******************************             
           EXEC SQL                                                     
             DECLARE MAIN-CURSOR CURSOR WITH HOLD FOR                   
               SELECT VO.ACCOUNT_NO_PRIOR,                              
                      VO.LOCAL_OFFICE,                                  
                      PR.PREMISE_NO,                                    
                      PR.AGL_PREM_NO,                                   
                      PR.ADDRESS_ID,                                    
                      PR.REV_DISTRICT_CD                                
               FROM CSS_SO_DATA VO,  CSS_SO_UPDATE VW,                  
                    CSS_PREMISE PR                                      
               WHERE VO.ORDER_TYPE_CD = 'FM002'                         
               AND VO.SERV_ORDER_STATUS = 60                            
               AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                  
               AND VO.SERV_ORDER_STATUS = VW.SERV_ORDER_STATUS          
               AND CAST(VW.UPDATE_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
               AND VO.PREMISE_NO = PR.PREMISE_NO                        
               AND PR.AGL_PREM_NO <> 0                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MAIN-CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT VO.ACCOUNT_NO_PRIOR,                                      
MFA-TR*               VO.LOCAL_OFFICE,                                          
MFA-TR*               PR.PREMISE_NO,                                            
MFA-TR*               PR.AGL_PREM_NO,                                           
MFA-TR*               PR.ADDRESS_ID,                                            
MFA-TR*               PR.REV_DISTRICT_CD                                        
MFA-TR*        FROM CSS_SO_DATA VO,  CSS_SO_UPDATE VW,                          
MFA-TR*             CSS_PREMISE PR                                              
MFA-TR*        WHERE VO.ORDER_TYPE_CD = 'FM002'                                 
MFA-TR*        AND VO.SERV_ORDER_STATUS = 60                                    
MFA-TR*        AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                          
MFA-TR*        AND VO.SERV_ORDER_STATUS = VW.SERV_ORDER_STATUS                  
MFA-TR*        AND DATE(VW.UPDATE_DATETIME) = :WS-RUN-DATE                      
MFA-TR*        AND VO.PREMISE_NO = PR.PREMISE_NO                                
MFA-TR*        AND PR.AGL_PREM_NO <> 0                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
    **********************FINALBILL-CURSOR******************************        
                                                                        
           EXEC SQL                                                     
               DECLARE FINALBILL-CURSOR CURSOR WITH HOLD FOR            
               SELECT AT.ACCOUNT_NO,                                    
                      PR.PREMISE_NO,                                    
                      PR.ADDRESS_ID,                                    
                      PR.AGL_PREM_NO,                                   
                      PR.LOCAL_OFFICE,                                  
                      PR.REV_DISTRICT_CD                                
               FROM CSS_ACCOUNT AT,                                     
                    CSS_PREMISE PR                                      
               WHERE AT.CODE_ACCT_STAT = 'B'                            
               AND CAST(AT.ACCT_FINALED_DT AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
               AND AT.PREMISE_NO = PR.PREMISE_NO                        
               AND PR.AGL_PREM_NO <> 0                                  
               AND EXISTS (SELECT 1 FROM                                
                    CSS_NAME_ACCT_XREF HT, CSS_PREMISE PR1              
                   WHERE PR1.AGL_PREM_NO = PR.AGL_PREM_NO               
                   AND PR1.PREMISE_NO <> PR.PREMISE_NO                  
                   AND PR1.PREMISE_NO = HT.PREMISE_NO                   
                   AND HT.CODE_ACCT_STAT = 'A')                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FINALBILL-CURSOR CURSOR WITH HOLD FOR                    
MFA-TR*        SELECT AT.ACCOUNT_NO,                                            
MFA-TR*               PR.PREMISE_NO,                                            
MFA-TR*               PR.ADDRESS_ID,                                            
MFA-TR*               PR.AGL_PREM_NO,                                           
MFA-TR*               PR.LOCAL_OFFICE,                                          
MFA-TR*               PR.REV_DISTRICT_CD                                        
MFA-TR*        FROM CSS_ACCOUNT AT,                                             
MFA-TR*             CSS_PREMISE PR                                              
MFA-TR*        WHERE AT.CODE_ACCT_STAT = 'B'                                    
MFA-TR*        AND DATE(AT.ACCT_FINALED_DT) = :WS-RUN-DATE                      
MFA-TR*        AND AT.PREMISE_NO = PR.PREMISE_NO                                
MFA-TR*        AND PR.AGL_PREM_NO <> 0                                          
MFA-TR*        AND EXISTS (SELECT 1 FROM                                        
MFA-TR*             CSS_NAME_ACCT_XREF HT, CSS_PREMISE PR1                      
MFA-TR*            WHERE PR1.AGL_PREM_NO = PR.AGL_PREM_NO                       
MFA-TR*            AND PR1.PREMISE_NO <> PR.PREMISE_NO                          
MFA-TR*            AND PR1.PREMISE_NO = HT.PREMISE_NO                           
MFA-TR*            AND HT.CODE_ACCT_STAT = 'A')                                 
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
P77801*******************NEW-ACCT *********************************             
           EXEC SQL                                                     
             DECLARE NEW-ACCT-CURSOR CURSOR WITH HOLD FOR               
               SELECT VO.ACCOUNT_NO_PRIOR,                              
                      VO.LOCAL_OFFICE,                                  
                      PR.PREMISE_NO,                                    
                      PR.AGL_PREM_NO,                                   
                      PR.ADDRESS_ID,                                    
                      PR.REV_DISTRICT_CD                                
               FROM CSS_SO_DATA VO,  CSS_SO_UPDATE VW,                  
                    CSS_PREMISE PR                                      
               WHERE VO.ORDER_TYPE_CD = 'FM002'                         
               AND VO.SERV_ORDER_STATUS = 60                            
               AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                  
               AND VO.SERV_ORDER_STATUS = VW.SERV_ORDER_STATUS          
               AND CAST(VW.UPDATE_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
               AND VO.PREMISE_NO = PR.PREMISE_NO                        
               AND PR.AGL_PREM_NO <> 0                                  
               AND EXISTS (                                             
               SELECT 1 FROM CSS_PREMISE PR1, CSS_NAME_ACCT_XREF HT     
               WHERE PR1.AGL_PREM_NO = PR.AGL_PREM_NO                   
               AND PR1.PREMISE_NO = HT.PREMISE_NO                       
               AND HT.CODE_ACCT_STAT = '')                              
                                                            
                END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE NEW-ACCT-CURSOR CURSOR WITH HOLD FOR                       
MFA-TR*        SELECT VO.ACCOUNT_NO_PRIOR,                                      
MFA-TR*               VO.LOCAL_OFFICE,                                          
MFA-TR*               PR.PREMISE_NO,                                            
MFA-TR*               PR.AGL_PREM_NO,                                           
MFA-TR*               PR.ADDRESS_ID,                                            
MFA-TR*               PR.REV_DISTRICT_CD                                        
MFA-TR*        FROM CSS_SO_DATA VO,  CSS_SO_UPDATE VW,                          
MFA-TR*             CSS_PREMISE PR                                              
MFA-TR*        WHERE VO.ORDER_TYPE_CD = 'FM002'                                 
MFA-TR*        AND VO.SERV_ORDER_STATUS = 60                                    
MFA-TR*        AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                          
MFA-TR*        AND VO.SERV_ORDER_STATUS = VW.SERV_ORDER_STATUS                  
MFA-TR*        AND DATE(VW.UPDATE_DATETIME) = :WS-RUN-DATE                      
MFA-TR*        AND VO.PREMISE_NO = PR.PREMISE_NO                                
MFA-TR*        AND PR.AGL_PREM_NO <> 0                                          
MFA-TR*        AND EXISTS (                                                     
MFA-TR*        SELECT 1 FROM CSS_PREMISE PR1, CSS_NAME_ACCT_XREF HT             
MFA-TR*        WHERE PR1.AGL_PREM_NO = PR.AGL_PREM_NO                           
MFA-TR*        AND PR1.PREMISE_NO = HT.PREMISE_NO                               
MFA-TR*        AND HT.CODE_ACCT_STAT = '')                                      
MFA-TR*             QUERYNO 7027                                                
MFA-TR*         END-EXEC.                                                       
                                                                        
P77801*******************PEND-PREM*********************************             
           EXEC SQL                                                     
             DECLARE PEND-PREM-CURSOR CURSOR WITH HOLD FOR              
                 SELECT PR.PREMISE_NO,                                  
                        PR.ADDRESS_ID,                                  
                        PR.AGL_PREM_NO,                                 
                        PR.LOCAL_OFFICE,                                
                        PR.REV_DISTRICT_CD                              
                  FROM CSS_PREMISE PR, CSS_NAME_ACCT_XREF HT            
                 WHERE PR.AGL_PREM_NO = :PR-AGL-PREM-NO                 
                   AND PR.PREMISE_NO = HT.PREMISE_NO                    
                   AND HT.CODE_ACCT_STAT = ''                           
**********       AND PR.PREMISE_NO <> :WS-NEW-PREM-NUM                          
                 AND NOT EXISTS (                                       
                 SELECT 1 FROM CSS_PREMISE PR1, CSS_NAME_ACCT_XREF HT1  
                   WHERE PR1.AGL_PREM_NO = PR.AGL_PREM_NO               
                    AND PR1.PREMISE_NO <> PR.PREMISE_NO                 
                    AND PR1.PREMISE_NO = HT1.PREMISE_NO                 
                    AND HT1.CODE_ACCT_STAT <> 'A' )                     
                                                            
                END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE PEND-PREM-CURSOR CURSOR WITH HOLD FOR                      
MFA-TR*          SELECT PR.PREMISE_NO,                                          
MFA-TR*                 PR.ADDRESS_ID,                                          
MFA-TR*                 PR.AGL_PREM_NO,                                         
MFA-TR*                 PR.LOCAL_OFFICE,                                        
MFA-TR*                 PR.REV_DISTRICT_CD                                      
MFA-TR*           FROM CSS_PREMISE PR, CSS_NAME_ACCT_XREF HT                    
MFA-TR*          WHERE PR.AGL_PREM_NO = :PR-AGL-PREM-NO                         
MFA-TR*            AND PR.PREMISE_NO = HT.PREMISE_NO                            
MFA-TR*            AND HT.CODE_ACCT_STAT = ''                                   
MFA-TR****       AND PR.PREMISE_NO <> :WS-NEW-PREM-NUM                          
MFA-TR*          AND NOT EXISTS (                                               
MFA-TR*          SELECT 1 FROM CSS_PREMISE PR1, CSS_NAME_ACCT_XREF HT1          
MFA-TR*            WHERE PR1.AGL_PREM_NO = PR.AGL_PREM_NO                       
MFA-TR*             AND PR1.PREMISE_NO <> PR.PREMISE_NO                         
MFA-TR*             AND PR1.PREMISE_NO = HT1.PREMISE_NO                         
MFA-TR*             AND HT1.CODE_ACCT_STAT <> 'A' )                             
MFA-TR*             QUERYNO 7055                                                
MFA-TR*         END-EXEC.                                                       
                                                                        
ACT182*GET THE ACCOUNT WHICH FALLS UNDER INVALID PREMISE NO********             
ACT182                                                                  
ACT182     EXEC SQL                                                     
ACT182       DECLARE INVLD-PREM-ACCT-CUR CURSOR WITH HOLD FOR           
ACT182          SELECT AT.ACCOUNT_NO                                    
ACT182                ,AT.CODE_ACCT_STAT                                
ACT182                ,AT.PREMISE_NO                                    
ACT182            FROM CSS_ACCOUNT AT                                   
ACT182           WHERE AT.PREMISE_NO = :WS-OLD-PREM-NUM                 
ACT182                                                      
ACT182     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE INVLD-PREM-ACCT-CUR CURSOR WITH HOLD FOR                   
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*               ,AT.CODE_ACCT_STAT                                        
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*          WHERE AT.PREMISE_NO = :WS-OLD-PREM-NUM                         
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            
ACT182                                                                  
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
           COPY CWS00010.                                                       
                                                                        
ACT067******************************************************************        
ACT067* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077          *        
ACT067******************************************************************        
ACT067     EXEC SQL                                                             
ACT067        INCLUDE CWS00077                                                  
ACT067     END-EXEC.                                                            
ACT067*                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-DISPLAY-COUNT        PIC S9(9) COMP VALUE 0.          
           05  WS-COMMIT-COUNT        PIC S9(9) COMP VALUE 0.           
           05  WS-DISPLAY-SQLCODE      PIC -(8)9.                       
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
COB305     05 WS-ACCOUNT-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-ACCOUNT              PIC X(13).                       
ACT067*    05  PROGRAM-NAME            PIC X(08) VALUE 'S119    '.              
           05  WS-PREV-AGL-PREM-NO     PIC S9(09)V USAGE COMP-3 VALUE 0.
           05  WS-PREV-PREM-CREATE-DT  PIC X(10).                       
           05  WS-NEW-PREM-CREATE-DT   PIC X(10).                       
           05  WS-USERID               PIC X(7).                        
           05  WS-OLD-LOCAL-OFFICE     PIC X(3).                        
           05  WS-NEW-LOCAL-OFFICE     PIC X(3).                        
COB305     05 WS-OLD-ADDR-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-NEW-ADDR-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-OLD-SP-ADDR-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-NEW-SP-ADDR-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-COUNT                PIC S9(04) COMP VALUE 1.         
           05  WS-COMPANY-NO           PIC X(01).                       
           05  WS-OLD-REV-DISTRICT-CD  PIC X(03) VALUE SPACES.          
           05  WS-NEW-REV-DISTRICT-CD  PIC X(03) VALUE SPACES.          
           05  WS-OLD-HOUSE-NO         PIC X(15).                       
           05  WS-NEW-HOUSE-NO         PIC X(15).                       
           05  WS-OLD-ADDR-PREFIX-1    PIC X(3).                        
           05  WS-NEW-ADDR-PREFIX-1    PIC X(3).                        
           05  WS-OLD-ADDR-PREFIX-2    PIC X(2).                        
           05  WS-NEW-ADDR-PREFIX-2    PIC X(2).                        
           05  WS-OLD-STREET-NAME      PIC X(30).                       
           05  WS-NEW-STREET-NAME      PIC X(30).                       
           05  WS-OLD-STREET-LOC-1     PIC X(04) VALUE SPACES.          
           05  WS-NEW-STREET-LOC-1     PIC X(04) VALUE SPACES.          
           05  WS-OLD-STREET-LOC-2     PIC X(11) VALUE SPACES.          
           05  WS-NEW-STREET-LOC-2     PIC X(11) VALUE SPACES.          
           05  WS-OLD-STREET-SUFFIX    PIC X(04) VALUE SPACES.          
           05  WS-NEW-STREET-SUFFIX    PIC X(04) VALUE SPACES.          
           05  WS-OLD-ADDR-OVERFLOW    PIC X(35) VALUE SPACES.          
           05  WS-NEW-ADDR-OVERFLOW    PIC X(35) VALUE SPACES.          
           05  WS-OLD-CARRIER-ROUTE    PIC X(05) VALUE SPACES.          
           05  WS-NEW-CARRIER-ROUTE    PIC X(05) VALUE SPACES.          
           05  WS-OLD-ZIP-CODE         PIC X(05) VALUE SPACES.          
           05  WS-NEW-ZIP-CODE         PIC X(05) VALUE SPACES.          
           05  WS-OLD-ZIP-CD-PLUS-FOUR PIC X(04) VALUE SPACES.          
           05  WS-NEW-ZIP-CD-PLUS-FOUR PIC X(04) VALUE SPACES.          
           05  WS-OLD-ZIP-CODE-TOKEN   PIC X(01) VALUE SPACES.          
           05  WS-NEW-ZIP-CODE-TOKEN   PIC X(01) VALUE SPACES.          
           05  WS-OLD-ADDR-USAGE-CD    PIC X(10) VALUE SPACES.          
           05  WS-NEW-ADDR-USAGE-CD    PIC X(10) VALUE SPACES.          
           05  WS-OLD-ADDR-SUFFIX      PIC X(02) VALUE SPACES.          
           05  WS-NEW-ADDR-SUFFIX      PIC X(02) VALUE SPACES.          
           05  WS-NRML-PRIORITY         PIC X(01) VALUE 'N'.            
           05  WS-UPDATE-DATE          PIC X(10).                       
           05  WS-LINE-1                PIC X(50) VALUE                 
               'PLEASE VERIFY THE ADDRESS FROM SEB CONSOLIDATION. '.    
           05  WS-PREV-VALUE            PIC X(45) VALUE SPACES.         
           05  WS-NEW-VALUE             PIC X(45) VALUE SPACES.         
           05  WS-DIFFER                PIC X(1) VALUE 'N'.             
           05  WS-FILLER-1              PIC X(11) VALUE SPACES.         
           05  WS-FILLER-2              PIC X(11) VALUE SPACES.         
A          05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
A          05  WS-NEW-ADDRESS-LINE      PIC X(80) VALUE SPACES.         
A          05  WS-OLD-ADDRESS-LINE      PIC X(80) VALUE SPACES.         
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05   S-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE +1.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
          10  S-SP-NAME                 PIC X(18) VALUE SPACES.         
          10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.         
          10  S-SQLSTATE                PIC X(5)  VALUE ' '.            
          10  S-TABLE-NAME              PIC X(18) VALUE SPACES.         
          10  S-HOST-VARIABLES.                                         
              49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.           
              49  S-HOST-VARIABLES-V    PIC X(255).                     
          10  S-SQL-STATEMENT.                                          
              49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.           
              49  S-SQL-STATEMENT-V     PIC X(255).                     
          10  S-SQL-DESCRIPTION.                                        
              49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.           
              49  S-SQL-DESCRIPTION-V   PIC X(255).                     
          10  WS-ABEND-SQLERRMC.                                        
              49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.           
              49  WS-ABEND-SQLERRMC-V   PIC X(255).                     
          10  RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
          10  WS-SQLSTATE               PIC X(05) VALUE SPACES.         
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 2000-MAIN-PROCESS          THRU 2000-EXIT.           
           MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                       
           DISPLAY 'TOTAL RECORDS = ' WS-DISPLAY-COUNT.                 
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-MAIN-PROCESS                                              *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
      *    GET COMOMN RUN DATE                                                  
           MOVE 'COMMONDATE'                 TO G6-PROGRAM-NAME         
           MOVE 'CA00'                       TO G6-CMND-CODE            
           MOVE WS-SEB                       TO G6-COMPANY-NO           
           MOVE WS-ACTIVE                    TO G6-STATUS               
           PERFORM 7100-GET-RUN-DATE            THRU 7100-EXIT          
           MOVE G6-PARM-DATA(1:10)           TO WS-RUN-DATE             
           DISPLAY 'RUN DATE: ' WS-RUN-DATE                             
                                                                        
      *    GET VALID PREMISE MAX END DATE                                       
ACT182     MOVE WS-PGRMNAME                  TO G6-PROGRAM-NAME         
ACT182     PERFORM 7100-GET-RUN-DATE         THRU 7100-EXIT             
ACT182     MOVE G6-PARM-DATA(1:10)           TO WS-PREM-MAX-END-DT      
ACT182     DISPLAY 'PREMISE MAX DATE: ' WS-PREM-MAX-END-DT              
                                                                        
ACT182*    MAIN UPDATE PROCESS                                                  
           PERFORM 2100-GET-PREMISE-NOS      THRU 2100-EXIT.            
           PERFORM 2200-GET-FINALBILL-ACCTS   THRU 2200-EXIT.           
P77801     PERFORM 2250-GET-NEW-ACCT         THRU 2250-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-GET-PREMISE-NOS                                           *        
      *                                                                *        
      ******************************************************************        
       2100-GET-PREMISE-NOS.                                            
                                                                        
           MOVE  '2100'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7000-OPEN-PREM-CONS-CURSOR     THRU 7000-EXIT.       
           PERFORM 7005-FETCH-PREM-CONS-CURSOR    THRU 7005-EXIT        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               MOVE  PR-PREMISE-NO TO WS-OLD-PREM-NUM                   
               MOVE  PR-ADDRESS-ID TO WS-OLD-ADDR-ID                    
               MOVE  VO-LOCAL-OFFICE TO WS-NEW-LOCAL-OFFICE             
               MOVE  PR-REV-DISTRICT-CD TO WS-OLD-REV-DISTRICT-CD       
               PERFORM 7115-SELECT-PREM-DTLS       THRU 7115-EXIT       
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE PR-PREMISE-NO    TO WS-NEW-PREM-NUM             
                   MOVE PR-REV-DISTRICT-CD TO WS-NEW-REV-DISTRICT-CD    
                   MOVE PR-LOCAL-OFFICE TO WS-OLD-LOCAL-OFFICE          
                   MOVE PR-ADDRESS-ID    TO WS-NEW-ADDR-ID              
                                       DY-ADDRESS-ID                    
                                                                        
                   PERFORM 2600-SAVE-NEW-PREM-ADDR   THRU 2600-EXIT     
                   PERFORM 2700-SAVE-OLD-PREM-ADDR     THRU 2700-EXIT   
                                                                        
                   IF WS-COMMIT-COUNT > 100 THEN                        
                       EXEC SQL                                         
                           COMMIT                                       
                       END-EXEC                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                       MOVE 0 TO WS-COMMIT-COUNT                        
                   END-IF                                               
               END-IF                                                   
               PERFORM 7005-FETCH-PREM-CONS-CURSOR    THRU 7005-EXIT    
           END-PERFORM.                                                 
           PERFORM 7010-CLOSE-PREM-CONS-CURSOR    THRU 7010-EXIT.       
           EXEC SQL                                                     
             COMMIT                                                     
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-GET-FINALBILL-ACCTS                                                
      *                                                                *        
      ******************************************************************        
       2200-GET-FINALBILL-ACCTS.                                        
                                                                        
           MOVE  '2200'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7020-OPEN-FINALBILL-CURSOR     THRU 7020-EXIT.       
           PERFORM 7025-FETCH-FINALBILL-CURSOR    THRU 7025-EXIT        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               MOVE PR-PREMISE-NO        TO WS-NEW-PREM-NUM             
               MOVE PR-LOCAL-OFFICE      TO WS-OLD-LOCAL-OFFICE         
               MOVE PR-REV-DISTRICT-CD   TO WS-NEW-REV-DISTRICT-CD      
               MOVE PR-ADDRESS-ID        TO WS-NEW-ADDR-ID              
                                            DY-ADDRESS-ID               
               PERFORM 7125-SELECT-ACTIVE-ACCT      THRU 7125-EXIT      
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   PERFORM 2600-SAVE-NEW-PREM-ADDR   THRU 2600-EXIT     
                   PERFORM 2700-SAVE-OLD-PREM-ADDR     THRU 2700-EXIT   
               END-IF                                                   
               IF WS-COMMIT-COUNT > 100 THEN                            
                   EXEC SQL                                             
                       COMMIT                                           
                   END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   MOVE 0 TO WS-COMMIT-COUNT                            
               END-IF                                                   
               PERFORM 7025-FETCH-FINALBILL-CURSOR    THRU 7025-EXIT    
           END-PERFORM.                                                 
           PERFORM 7030-CLOSE-FINALBILL-CURSOR    THRU 7030-EXIT.       
           EXEC SQL                                                     
             COMMIT                                                     
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P77801******************************************************************        
P77801* 2250-GET-NEW-ACCT                                                       
P77801*                                                                *        
P77801******************************************************************        
       2250-GET-NEW-ACCT.                                               
                                                                        
           MOVE  '2250'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7040-OPEN-NEW-ACCT-CURSOR  THRU 7040-EXIT.           
           PERFORM 7045-FETCH-NEW-ACCT-CURSOR THRU 7045-EXIT            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               MOVE PR-PREMISE-NO        TO WS-NEW-PREM-NUM             
               MOVE VO-LOCAL-OFFICE      TO WS-NEW-LOCAL-OFFICE         
               MOVE PR-REV-DISTRICT-CD   TO WS-NEW-REV-DISTRICT-CD      
               MOVE PR-ADDRESS-ID        TO WS-NEW-ADDR-ID              
                                            DY-ADDRESS-ID               
               PERFORM 2600-SAVE-NEW-PREM-ADDR   THRU 2600-EXIT         
               PERFORM 2500-GET-PEND-PREM     THRU 2500-EXIT            
               IF WS-COMMIT-COUNT > 100 THEN                            
                   EXEC SQL                                             
                       COMMIT                                           
                   END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   MOVE 0 TO WS-COMMIT-COUNT                            
               END-IF                                                   
               PERFORM 7045-FETCH-NEW-ACCT-CURSOR THRU 7045-EXIT        
           END-PERFORM.                                                 
           PERFORM 7050-CLOSE-NEW-ACCT-CURSOR THRU 7050-EXIT.           
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
P77801******************************************************************        
P77801* 2500-GET-PEND-PREM                                                      
P77801*                                                                *        
P77801******************************************************************        
       2500-GET-PEND-PREM.                                              
                                                                        
           MOVE  '2500'              TO   WS-ACTIVE-PARAGRAPH.          
           MOVE  WS-NO               TO   WS-DONT-PRCESS-PEND-PREM.     
                                                                        
           PERFORM 7055-OPEN-PEND-PREM-CURSOR  THRU 7055-EXIT.          
           PERFORM 7060-FETCH-PEND-PREM-CURSOR THRU 7060-EXIT           
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               MOVE  WS-OLD-ADDR-ID TO DY-ADDRESS-ID                    
                                                                        
ACT182         MOVE WS-YES          TO WS-DONT-PRCESS-PEND-PREM         
               PERFORM 2800-CONSOLIDATE-PREM THRU 2800-EXIT             
               ADD 1 TO WS-ROW-COUNT                                    
                                                                        
               PERFORM 7060-FETCH-PEND-PREM-CURSOR THRU 7060-EXIT       
           END-PERFORM.                                                 
           PERFORM 7065-CLOSE-PEND-PREM-CURSOR THRU 7065-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-SAVE-NEW-PREM-ADDR                                        *        
      *                                                                         
      ******************************************************************        
       2600-SAVE-NEW-PREM-ADDR.                                         
                                                                        
           MOVE '2600'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7035-GET-ADDRESS  THRU 7035-EXIT                     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE WS-ADDRESS-LINE TO WS-NEW-ADDRESS-LINE              
               MOVE DY-ADDRESS-ID   TO WS-NEW-ADDR-ID                   
               IF DY-ADDR-PREFIX-1 > SPACES                             
                   MOVE DY-ADDR-PREFIX-1  TO WS-NEW-ADDR-PREFIX-1       
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-ADDR-PREFIX-1                  
               END-IF                                                   
               IF DY-ADDR-SUFFIX   > SPACES                             
                   MOVE DY-ADDR-SUFFIX    TO WS-NEW-ADDR-SUFFIX         
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-ADDR-SUFFIX                    
               END-IF                                                   
               IF DY-ADDR-USAGE-CD > SPACES                             
                   MOVE DY-ADDR-USAGE-CD  TO WS-NEW-ADDR-USAGE-CD       
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-ADDR-USAGE-CD                  
               END-IF                                                   
               IF DY-ADDRESS-OVERFLOW > SPACES                          
                   MOVE DY-ADDRESS-OVERFLOW  TO WS-NEW-ADDR-OVERFLOW    
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-ADDR-OVERFLOW                  
               END-IF                                                   
               IF DY-CARRIER-ROUTE   > SPACES                           
                   MOVE DY-CARRIER-ROUTE  TO WS-NEW-CARRIER-ROUTE       
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-CARRIER-ROUTE                  
               END-IF                                                   
               IF DY-HOUSE-NO  >  SPACES                                
                   MOVE DY-HOUSE-NO       TO WS-NEW-HOUSE-NO            
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-HOUSE-NO                       
               END-IF                                                   
               IF DY-STREET-LOCATION-1 > SPACES                         
                   MOVE DY-STREET-LOCATION-1 TO WS-NEW-STREET-LOC-1     
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-STREET-LOC-1                   
               END-IF                                                   
               IF DY-STREET-LOCATION-2  > SPACES                        
                   MOVE DY-STREET-LOCATION-2 TO WS-NEW-STREET-LOC-2     
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-STREET-LOC-2                   
               END-IF                                                   
               IF DY-STREET-NAME   > SPACES                             
                   MOVE DY-STREET-NAME    TO WS-NEW-STREET-NAME         
               ELSE                                                     
                   MOVE SPACES TO      WS-NEW-STREET-NAME               
               END-IF                                                   
               IF DY-STREET-SUFFIX > SPACES                             
                   MOVE DY-STREET-SUFFIX  TO WS-NEW-STREET-SUFFIX       
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-STREET-SUFFIX                  
               END-IF                                                   
               IF DY-ZIP-CODE      > SPACES                             
                   MOVE DY-ZIP-CODE       TO WS-NEW-ZIP-CODE            
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-ZIP-CODE                       
               END-IF                                                   
               IF DY-ZIP-CODE-PLUS-FOUR > SPACES                        
                   MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-NEW-ZIP-CD-PLUS-FOUR
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-ZIP-CD-PLUS-FOUR               
               END-IF                                                   
               IF DY-ZIP-CODE-TOKEN > SPACES                            
                   MOVE DY-ZIP-CODE-TOKEN TO  WS-NEW-ZIP-CODE-TOKEN     
               ELSE                                                     
                   MOVE SPACES TO WS-NEW-ZIP-CODE-TOKEN                 
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2700-SAVE-OLD-PREM-ADDR.                                       *        
      *                                                                *        
      ******************************************************************        
       2700-SAVE-OLD-PREM-ADDR.                                         
                                                                        
           MOVE  WS-OLD-ADDR-ID TO DY-ADDRESS-ID                        
           PERFORM 2800-CONSOLIDATE-PREM THRU 2800-EXIT                 
           ADD 1 TO WS-ROW-COUNT.                                       
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2800-CONSOLIDATE-PREM.                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2800-CONSOLIDATE-PREM.                                           
                                                                        
           PERFORM 7035-GET-ADDRESS            THRU 7035-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A              MOVE WS-ADDRESS-LINE TO WS-OLD-ADDRESS-LINE              
               IF DY-ADDR-PREFIX-1 > SPACES                             
                   MOVE DY-ADDR-PREFIX-1  TO WS-OLD-ADDR-PREFIX-1       
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-ADDR-PREFIX-1                  
               END-IF                                                   
               IF DY-ADDR-SUFFIX   > SPACES                             
                   MOVE DY-ADDR-SUFFIX    TO WS-OLD-ADDR-SUFFIX         
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-ADDR-SUFFIX                    
               END-IF                                                   
               IF DY-ADDR-USAGE-CD > SPACES                             
                   MOVE DY-ADDR-USAGE-CD  TO WS-OLD-ADDR-USAGE-CD       
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-ADDR-USAGE-CD                  
               END-IF                                                   
               IF DY-ADDRESS-OVERFLOW > SPACES                          
                   MOVE DY-ADDRESS-OVERFLOW  TO WS-OLD-ADDR-OVERFLOW    
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-ADDR-OVERFLOW                  
               END-IF                                                   
               IF DY-CARRIER-ROUTE   > SPACES                           
                   MOVE DY-CARRIER-ROUTE  TO WS-OLD-CARRIER-ROUTE       
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-CARRIER-ROUTE                  
               END-IF                                                   
               IF DY-HOUSE-NO  >  SPACES                                
                   MOVE DY-HOUSE-NO       TO WS-OLD-HOUSE-NO            
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-HOUSE-NO                       
               END-IF                                                   
               IF DY-STREET-LOCATION-1 > SPACES                         
                   MOVE DY-STREET-LOCATION-1 TO WS-OLD-STREET-LOC-1     
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-STREET-LOC-1                   
               END-IF                                                   
               IF DY-STREET-LOCATION-2  > SPACES                        
                   MOVE DY-STREET-LOCATION-2 TO WS-OLD-STREET-LOC-2     
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-STREET-LOC-2                   
               END-IF                                                   
               IF DY-STREET-NAME   > SPACES                             
                   MOVE DY-STREET-NAME    TO WS-OLD-STREET-NAME         
               ELSE                                                     
                   MOVE SPACES TO      WS-OLD-STREET-NAME               
               END-IF                                                   
               IF DY-STREET-SUFFIX > SPACES                             
                   MOVE DY-STREET-SUFFIX  TO WS-OLD-STREET-SUFFIX       
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-STREET-SUFFIX                  
               END-IF                                                   
               IF DY-ZIP-CODE      > SPACES                             
                   MOVE DY-ZIP-CODE       TO WS-OLD-ZIP-CODE            
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-ZIP-CODE                       
               END-IF                                                   
               IF DY-ZIP-CODE-PLUS-FOUR > SPACES                        
                   MOVE DY-ZIP-CODE-PLUS-FOUR TO WS-OLD-ZIP-CD-PLUS-FOUR
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-ZIP-CD-PLUS-FOUR               
               END-IF                                                   
               IF DY-ZIP-CODE-TOKEN > SPACES                            
                   MOVE DY-ZIP-CODE-TOKEN TO  WS-OLD-ZIP-CODE-TOKEN     
               ELSE                                                     
                   MOVE SPACES TO WS-OLD-ZIP-CODE-TOKEN                 
               END-IF                                                   
           END-IF                                                       
                                                                        
      *    THE NEW PREMISE-NO SHOULD NOT BE LESS THAN PREMISE MAX DT.           
      *    IF PREMISE IS NOT VALID THAN FETCH ALL THE ACCOUNTS FALLS            
      *    UNDER THAT PREMISE AND UPDATE WITH LATEST PREMISE NO.                
                                                                        
ACT182     MOVE WS-YES                         TO WS-NEW-PREMISE-STATUS.
ACT182     MOVE SPACES                         TO CH-DATE-UTIL-SVC-END. 
                                                                        
ACT182     IF WS-DONT-PRCESS-PEND-PREM EQUAL WS-NO                      
ACT182        PERFORM 7200-GET-NEW-PREM-END-DT    THRU 7200-EXIT        
ACT182        IF CH-DATE-UTIL-SVC-END GREATER THAN SPACE AND            
ACT182           CH-DATE-UTIL-SVC-END <= WS-PREM-MAX-END-DT             
ACT182           MOVE WS-NO                    TO WS-NEW-PREMISE-STATUS 
ACT182        END-IF                                                    
ACT182                                                                  
ACT182        IF NEW-PREM-INVALID                                       
ACT182           PERFORM 2900-GET-INVLD-PREM-ACCT THRU 2900-EXIT        
ACT182        ELSE                                                      
ACT182           PERFORM 2950-UPDARE-NEW-PREMISE  THRU 2950-EXIT        
ACT182        END-IF                                                    
ACT182     ELSE                                                         
ACT182        PERFORM 2950-UPDARE-NEW-PREMISE     THRU 2950-EXIT        
ACT182     END-IF.                                                      
ACT182                                                                  
ACT182 2800-EXIT.                                                       
ACT182     EXIT.                                                        
ACT182                                                                  
ACT182******************************************************************        
ACT182*                                                                *        
ACT182* 2900-GET-INVLD-PREM-ACCT.                                      *        
ACT182******************************************************************        
ACT182 2900-GET-INVLD-PREM-ACCT.                                        
ACT182                                                                  
ACT182     MOVE WS-NO                           TO WS-NO-MORE-ROWS.     
ACT182*    HERE NEW PREMISE IS NOTHING BUT OLD INVALID PRMEISE                  
ACT182     MOVE WS-NEW-PREM-NUM                 TO WS-HOLD-PREMISE-NO.  
ACT182*    OLD PREMISE MEANS CURRENT PREMISE NUMBER FOR THE ACCT                
ACT182     MOVE WS-OLD-PREM-NUM                 TO WS-NEW-PREM-NUM      
ACT182*    MOVING OLD INVALID PREMISE TO UPDATE WITH RIGHT ONE                  
ACT182     MOVE WS-HOLD-PREMISE-NO              TO WS-OLD-PREM-NUM      
ACT182                                                                  
ACT182     PERFORM 7300-OPEN-INVLD-PREM-ACCT-CUR   THRU 7300-EXIT.      
ACT182     PERFORM 7310-FETCH-INVLD-PREM-ACCT-CUR  THRU 7310-EXIT.      
ACT182                                                                  
ACT182     PERFORM UNTIL WS-NO-MORE-ROWS EQUAL WS-YES                   
ACT182        PERFORM 2950-UPDARE-NEW-PREMISE      THRU 2950-EXIT       
ACT182                                                                  
ACT182        DISPLAY '** =======PRIOR 2012 PREM NO DTLS========'       
ACT182        DISPLAY '** INVLD PREM ACCT   = ' AT-ACCOUNT-NO           
ACT182        DISPLAY '** STATUS            = ' AT-CODE-ACCT-STAT       
ACT182        DISPLAY '** OLD INVLD PREM NO = ' AT-PREMISE-NO           
ACT182        DISPLAY '** NEW PREM NO       = ' WS-NEW-PREM-NUM         
ACT182        DISPLAY '** ======================================'       
ACT182                                                                  
ACT182        PERFORM 7310-FETCH-INVLD-PREM-ACCT-CUR                    
ACT182                                             THRU 7310-EXIT       
ACT182     END-PERFORM.                                                 
ACT182                                                                  
ACT182     PERFORM 7320-CLOSE-INVLD-PREM-ACCT-CUR  THRU 7320-EXIT.      
ACT182                                                                  
ACT182 2900-EXIT.                                                       
ACT182     EXIT.                                                        
ACT182                                                                  
ACT182******************************************************************        
ACT182* 2950-UPDARE-NEW-PREMISE.                                       *        
ACT182*                                                                *        
ACT182******************************************************************        
ACT182 2950-UPDARE-NEW-PREMISE.                                         
ACT182                                                                  
ACT182     MOVE AT-ACCOUNT-NO       TO BI-ACCOUNT-NO                    
ACT182                                 BG-ACCOUNT-NO                    
ACT182                                 HA-ACCOUNT-NO                    
ACT182                                 KO-ACCOUNT-NO                    
ACT182                                 CH-ACCOUNT-NO                    
ACT182                                 MJ-ACCOUNT-NO                    
ACT182                                 HT-ACCOUNT-NO                    
ACT182                                 VO-ACCOUNT-NO                    
ACT182                                 LR-ACCOUNT-NO                    
ACT182                                 UT-ACCOUNT-NO                    
ACT182                                 WQ-ACCOUNT-NO                    
ACT182                                 WS-77-ACCOUNT-NO                 
ACT182                                 YV-ACCOUNT-NO                    
ACT182                                 RV-ACCOUNT-NO                    
ACT182                                 MH-ACCOUNT-NO                    
ACT182                                 WS-ACCOUNT.                      
ACT182                                                                  
ACT182     IF AT-ACCOUNT-NO EQUAL WS-ZERO THEN                          
ACT182*       WHEN OLD PREMISE CREATED WITHOUT ANY ACCOUNT CREATION             
ACT182        MOVE 0 TO KO-ACCOUNT-NO                                   
ACT182                  MH-ACCOUNT-NO                                   
ACT182                  WQ-ACCOUNT-NO                                   
ACT182                                                                  
ACT182        IF NEW-PREM-VALID                                         
ACT182           PERFORM 5020-VALIDATE-ADDRESS      THRU 5020-EXIT      
ACT182        END-IF                                                    
ACT182                                                                  
ACT182        PERFORM 8040-UPDATE-CSS-COMM-DATA     THRU 8040-EXIT      
ACT182        PERFORM 8050-UPDATE-CSS-MNT-TRANS-HIST                    
ACT182                                              THRU 8050-EXIT      
ACT182        PERFORM 8140-UPDATE-CSS-WQ-ITEMS      THRU 8140-EXIT      
ACT182        PERFORM 8180-DELETE-NAME-ACCT-XREF    THRU 8180-EXIT      
ACT182        PERFORM 5000-MOVE-TRAN-HEAD           THRU 5000-EXIT      
ACT182        ADD 1 TO WS-COMMIT-COUNT                                  
ACT182                                                                  
ACT182     ELSE                                                         
ACT182       DISPLAY '** UPDATED ACCT NO   = ' AT-ACCOUNT-NO            
ACT182       DISPLAY '** OLD PREM NO       = ' WS-OLD-PREM-NUM          
ACT182       DISPLAY '** NEW PREM NO       = ' WS-NEW-PREM-NUM          
ACT182       DISPLAY '** ==================================='           
ACT182                                                                  
ACT182       IF NEW-PREM-VALID AND                                      
ACT182          WS-OLD-LOCAL-OFFICE NOT EQUAL WS-NEW-LOCAL-OFFICE       
ACT182          PERFORM 8220-UPDATE-LOCAL-OFFICE   THRU 8220-EXIT       
ACT182       END-IF                                                     
ACT182                                                                  
ACT182       IF NEW-PREM-VALID                                          
ACT182          PERFORM 5020-VALIDATE-ADDRESS       THRU 5020-EXIT      
ACT182       END-IF                                                     
ACT182                                                                  
ACT182       PERFORM 8010-UPDATE-CSS-BILLING-HDR    THRU 8010-EXIT      
ACT182       PERFORM 8020-UPDATE-CSS-BILLING-DET    THRU 8020-EXIT      
ACT182       PERFORM 8040-UPDATE-CSS-COMM-DATA      THRU 8040-EXIT      
ACT182       PERFORM 8050-UPDATE-CSS-MNT-TRANS-HIST THRU 8050-EXIT      
ACT182       PERFORM 8060-UPDATE-CSS-NAME-ACCT-XREF THRU 8060-EXIT      
ACT182       PERFORM 8070-UPDATE-CSS-CONTACT-PREM   THRU 8070-EXIT      
ACT182       PERFORM 8090-UPDATE-CSS-CUST-PREM-HIST THRU 8090-EXIT      
ACT182       PERFORM 8100-UPDATE-CSS-MISC-JRNL      THRU 8100-EXIT      
ACT182       PERFORM 8110-UPDATE-CSS-REG-PROFILE    THRU 8110-EXIT      
ACT182       PERFORM 8120-UPDATE-CSS-SO-DATA        THRU 8120-EXIT      
ACT182       PERFORM 8125-UPDATE-HST-SO-DATA        THRU 8125-EXIT      
ACT182       PERFORM 8130-UPDATE-CSS-UTIL-ENVRNMT   THRU 8130-EXIT      
ACT182       PERFORM 8140-UPDATE-CSS-WQ-ITEMS       THRU 8140-EXIT      
ACT182       PERFORM 8150-UPDATE-CSS-ACCOUNT        THRU 8150-EXIT      
ACT182       PERFORM 8160-UPDATE-REV-BILLING-DET    THRU 8160-EXIT      
ACT182       PERFORM 8170-UPDATE-HST-ACCOUNT        THRU 8170-EXIT      
ACT182       PERFORM 5000-MOVE-TRAN-HEAD            THRU 5000-EXIT      
ACT182       ADD 1 TO WS-COMMIT-COUNT                                   
ACT182     END-IF.                                                      
ACT182                                                                  
ACT182 2950-EXIT.                                                       
ACT182     EXIT.                                                        
ACT182                                                                  
      ******************************************************************        
      * 5020-VALIDATE-ADDRESS                                          *        
      *                                                                *        
      ******************************************************************        
       5020-VALIDATE-ADDRESS.                                           
                                                                        
           MOVE '5020'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           INSPECT WS-OLD-STREET-NAME REPLACING ALL '-' BY ' '.         
           INSPECT WS-NEW-STREET-NAME REPLACING ALL '-' BY ' '.         
                                                                        
           EVALUATE TRUE                                                
               WHEN (WS-OLD-ADDR-SUFFIX NOT EQUAL WS-NEW-ADDR-SUFFIX)   
                   STRING 'PREV ADDR SUFFIX - ' DELIMITED BY SIZE       
                           WS-OLD-ADDR-SUFFIX DELIMITED BY ' '          
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW ADDR SUFIX - ' DELIMITED BY SIZE         
                           WS-NEW-ADDR-SUFFIX DELIMITED BY ' '          
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN ((WS-OLD-ZIP-CODE-TOKEN NOT EQUAL                   
                      WS-NEW-ZIP-CODE-TOKEN) AND                        
                      WS-OLD-ZIP-CODE-TOKEN NOT EQUAL SPACES)           
                   STRING 'PREV ZIPCODE TOKEN - ' DELIMITED BY SIZE     
                           WS-OLD-ZIP-CODE-TOKEN DELIMITED BY ' '       
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW ZIPCODE TOKEN - ' DELIMITED BY SIZE      
                           WS-NEW-ZIP-CODE-TOKEN DELIMITED BY ' '       
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN ((WS-OLD-ZIP-CD-PLUS-FOUR NOT EQUAL                 
                      WS-NEW-ZIP-CD-PLUS-FOUR) AND                      
                      WS-OLD-ZIP-CD-PLUS-FOUR NOT EQUAL SPACES)         
                   STRING 'PREV ZIPCODE-PLUS-4 -' DELIMITED BY SIZE     
                           WS-OLD-ZIP-CD-PLUS-FOUR DELIMITED BY ' '     
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW ZIPCODE-PLUS-4 - ' DELIMITED BY SIZE     
                           WS-NEW-ZIP-CD-PLUS-FOUR DELIMITED BY ' '     
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN (WS-OLD-STREET-SUFFIX NOT EQUAL                     
                     WS-NEW-STREET-SUFFIX)                              
                   STRING 'PREV STREET SUFFIX - ' DELIMITED BY SIZE     
                           WS-OLD-STREET-SUFFIX DELIMITED BY ' '        
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW STREET SUFFIX - ' DELIMITED BY SIZE      
                           WS-NEW-STREET-SUFFIX DELIMITED BY ' '        
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN (WS-OLD-STREET-LOC-2 NOT EQUAL WS-NEW-STREET-LOC-2) 
                   STRING 'PREV STREET LOC-2 - ' DELIMITED BY SIZE      
                           WS-OLD-STREET-LOC-2 DELIMITED BY ' '         
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW STREET LOC-2 - ' DELIMITED BY SIZE       
                           WS-NEW-STREET-LOC-2 DELIMITED BY ' '         
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN (WS-OLD-STREET-LOC-1 NOT EQUAL WS-NEW-STREET-LOC-1) 
                   STRING 'PREV STREET LOC-1 - ' DELIMITED BY SIZE      
                           WS-OLD-STREET-LOC-1 DELIMITED BY ' '         
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW STREET LOC-1 - ' DELIMITED BY SIZE       
                           WS-NEW-STREET-LOC-1 DELIMITED BY ' '         
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN (WS-OLD-ADDR-PREFIX-1 NOT EQUAL                     
                     WS-NEW-ADDR-PREFIX-1)                              
                   STRING 'PREV ADDR PREFIX-1 - ' DELIMITED BY SIZE     
                           WS-OLD-ADDR-PREFIX-1 DELIMITED BY ' '        
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW ADDR PREFIX-1 -' DELIMITED BY SIZE       
                           WS-NEW-ADDR-PREFIX-1 DELIMITED BY ' '        
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN (WS-OLD-ADDR-PREFIX-2 NOT EQUAL                     
                     WS-NEW-ADDR-PREFIX-2)                              
                   STRING 'PREV ADDR PREFIX-2 - ' DELIMITED BY SIZE     
                           WS-OLD-ADDR-PREFIX-2 DELIMITED BY ' '        
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW ADDR PREFIX-2 - ' DELIMITED BY SIZE      
                           WS-NEW-ADDR-PREFIX-2 DELIMITED BY ' '        
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN (WS-OLD-STREET-NAME  NOT EQUAL WS-NEW-STREET-NAME)  
                   STRING  'PREV STREET NAME - ' DELIMITED BY SIZE      
                            WS-OLD-STREET-NAME DELIMITED BY '  '        
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW STREET NAME - ' DELIMITED BY SIZE        
                           WS-NEW-STREET-NAME DELIMITED BY '  '         
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN (WS-OLD-ZIP-CODE NOT EQUAL WS-NEW-ZIP-CODE)         
                   STRING 'PREV ZIPCODE - ' DELIMITED BY SIZE           
                           WS-OLD-ZIP-CODE DELIMITED BY ' '             
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW ZIPCODE - ' DELIMITED BY SIZE            
                           WS-NEW-ZIP-CODE DELIMITED BY ' '             
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN ((WS-OLD-REV-DISTRICT-CD NOT EQUAL                  
                      WS-NEW-REV-DISTRICT-CD) AND                       
                      AT-ACCOUNT-NO NOT EQUAL 0)                        
                   STRING 'PREV REV DIST - ' DELIMITED BY SIZE          
                           WS-OLD-REV-DISTRICT-CD DELIMITED BY SIZE     
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW REV DIST - ' DELIMITED BY SIZE           
                           WS-NEW-REV-DISTRICT-CD DELIMITED BY SIZE     
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN (WS-OLD-HOUSE-NO NOT EQUAL WS-NEW-HOUSE-NO)         
                   STRING 'PREV HOUSE NO - ' DELIMITED BY SIZE          
                           WS-OLD-HOUSE-NO DELIMITED BY ' '             
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW HOUSE NO - ' DELIMITED BY SIZE           
                           WS-NEW-HOUSE-NO DELIMITED BY ' '             
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
               WHEN ((WS-OLD-LOCAL-OFFICE(2:2) NOT EQUAL                
                      WS-NEW-LOCAL-OFFICE(2:2)) AND                     
                      AT-ACCOUNT-NO NOT EQUAL 0)                        
                   STRING 'PREV PREM LO - ' DELIMITED BY SIZE           
                           WS-OLD-LOCAL-OFFICE DELIMITED BY SIZE        
                     INTO WS-PREV-VALUE                                 
                   STRING 'NEW PREM LO -' DELIMITED BY SIZE             
                           WS-NEW-LOCAL-OFFICE DELIMITED BY SIZE        
                     INTO WS-NEW-VALUE                                  
                   MOVE 'Y' TO WS-DIFFER                                
           END-EVALUATE.                                                
                                                                        
           IF WS-DIFFER EQUAL WS-YES                                    
               PERFORM 5995-GENERATE-WQ   THRU 5995-EXIT                
               MOVE SPACES TO WS-NEW-VALUE                              
                              WS-PREV-VALUE                             
A                             WS-ADDRESS-LINE                           
A                             WS-OLD-ADDRESS-LINE                       
A                             WS-NEW-ADDRESS-LINE                       
               MOVE 'N'   TO WS-DIFFER                                  
           END-IF.                                                      
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5995-GENERATE-WQ                                               *        
      *                                                                *        
      ******************************************************************        
       5995-GENERATE-WQ.                                                
                                                                        
           MOVE '5995'                     TO WS-ACTIVE-PARAGRAPH.      
ACT067     MOVE ZEROES                     TO WS-77-SERV-ORDER-NO.      
ACT067     MOVE 551                        TO WS-77-CATEGORY-ID.        
ACT067     MOVE ZEROES                     TO WS-77-ACCOUNT-NO.         
ACT067     MOVE WS-NEW-PREM-NUM            TO WS-77-PREMISE-NO.         
ACT067     MOVE ZEROES                     TO WS-77-CUSTOMER-NO.        
ACT067     MOVE 'SYSTEM'                   TO WS-77-USER-ID-ORIG.       
ACT067     MOVE SPACES                     TO WS-77-RESP-AREA-ID.       
ACT067     MOVE SPACES                     TO WS-77-LOCAL-OFFICE.       
ACT067     MOVE '4'                        TO WS-77-ROUTE-CATEGORY.     
                                                                        
    ***  THE NEXT 8 LINES IS WHERE THE WORK QUEUE TEXT IS POPULATED             
ACT067     MOVE WS-NRML-PRIORITY         TO WS-77-PRIORITY.             
ACT067     MOVE WS-LINE-1                TO WS-77-COMMENTS-TEXT (1:50). 
ACT067     MOVE 'OLD = '                 TO WS-77-COMMENTS-TEXT (51:6). 
ACT067     MOVE WS-OLD-ADDRESS-LINE      TO WS-77-COMMENTS-TEXT (57:80).
ACT067     MOVE 'NEW = '                 TO WS-77-COMMENTS-TEXT (137:6).
ACT067     MOVE WS-NEW-ADDRESS-LINE      TO WS-77-COMMENTS-TEXT (143:80)
ACT067*    MOVE WS-PREV-VALUE            TO WS-77-COMMENTS-TEXT (51:45).        
ACT067*    MOVE WS-NEW-VALUE             TO WS-77-COMMENTS-TEXT (96:45).        
ACT067     MOVE 225                        TO WS-77-COMMENTS-LEN.       
                                                                        
ACT067     MOVE SPACES                     TO WS-77-FREE-FORM-TXT.      
ACT067     MOVE ZEROES                     TO WS-77-FREE-FORM-LEN.      
ACT067     MOVE WS-PGRMNAME                TO WS-77-CREATED-BY.         
                                                                        
           PERFORM 8565-INSERT-WORK-QUEUE  THRU 8565-EXIT.              
                                                                        
       5995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-PREM-CONS-CURSOR                                     *        
      *                                                                *        
      ******************************************************************        
       7000-OPEN-PREM-CONS-CURSOR.                                      
                                                                        
           MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN MAIN-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7000-OPEN-PREM-CONS-CURSOR        **'       
               DISPLAY '**  ERROR OPENING  PREM-CONS   CURSOR **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7005-FETCH-PREM-CONS-CURSOR                                    *        
      *                                                                *        
      ******************************************************************        
       7005-FETCH-PREM-CONS-CURSOR.                                     
                                                                        
           MOVE '7005'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH MAIN-CURSOR                                         
               INTO :VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-LOCAL-OFFICE                                    
                   ,:PR-PREMISE-NO                                      
                   ,:PR-AGL-PREM-NO                                     
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-REV-DISTRICT-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                MOVE VO-ACCOUNT-NO-PRIOR TO AT-ACCOUNT-NO               
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7005-FETCH-PREM-CONS-CURSOR      **'        
               DISPLAY '**  ERROR FETCHING PREM-CONS   CURSOR**'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PREMISE = ' PR-PREMISE-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-CLOSE-PREM-CONS-CURSOR                                    *        
      *                                                                *        
      ******************************************************************        
       7010-CLOSE-PREM-CONS-CURSOR.                                     
                                                                        
           MOVE '7010'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE MAIN-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7010-CLOSE-PREM-CONS-CURSOR      **'        
               DISPLAY '**  ERROR CLOSING PREM-CONS   CURSOR  **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7020-OPEN-FINALBILL-CURSOR                                      *        
      *                                                                *        
      ******************************************************************        
       7020-OPEN-FINALBILL-CURSOR.                                      
                                                                        
           MOVE '7020'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               OPEN FINALBILL-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7020-OPEN-FINALBILL-CURSOR        **'       
               DISPLAY '**  ERROR OPENING  FINALBILL  CURSOR  **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-FETCH-FINALBILL-CURSOR                                             
      *                                                                *        
      ******************************************************************        
       7025-FETCH-FINALBILL-CURSOR.                                     
                                                                        
           MOVE '7025'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH FINALBILL-CURSOR                                    
               INTO :AT-ACCOUNT-NO                                      
                   ,:PR-PREMISE-NO                                      
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-AGL-PREM-NO                                     
                   ,:PR-LOCAL-OFFICE                                    
                   ,:PR-REV-DISTRICT-CD                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7025-FETCH-FINALBILL-CURSOR      **'        
               DISPLAY '**  ERROR FETCHING FINALBILL CURSOR  **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PREMISE = ' PR-PREMISE-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-CLOSE-FINALBILL-CURSOR                                             
      *                                                                *        
      ******************************************************************        
       7030-CLOSE-FINALBILL-CURSOR.                                     
                                                                        
           MOVE '7030'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE FINALBILL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7030-CLOSE-FINALBILL-CURSOR       **'       
               DISPLAY '**  ERROR CLOSING FINALBILL CURSOR    **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
P77801******************************************************************        
P77801*7040-OPEN-NEW-ACCT-CURSOR                                      *         
P77801*                                                                *        
P77801******************************************************************        
       7040-OPEN-NEW-ACCT-CURSOR.                                       
                                                                        
           MOVE '7040'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               OPEN NEW-ACCT-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7040-OPEN-NEW-ACCT-CURSOR        **'        
               DISPLAY '**  ERROR OPENING  NEW-ACCT  CURSOR  **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
P77801******************************************************************        
P77801* 7045-FETCH-NEW-ACCT-CURSOR                                              
P77801*                                                                *        
P77801******************************************************************        
       7045-FETCH-NEW-ACCT-CURSOR.                                      
                                                                        
           MOVE '7045'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH NEW-ACCT-CURSOR                                     
               INTO :VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-LOCAL-OFFICE                                    
                   ,:PR-PREMISE-NO                                      
                   ,:PR-AGL-PREM-NO                                     
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-REV-DISTRICT-CD                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7045-FETCH-NEW-ACCT-CURSOR      **'         
               DISPLAY '**  ERROR FETCHING NEW-ACCT CURSOR  **'         
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PREMISE = ' PR-PREMISE-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
                                                                        
P77801******************************************************************        
P77801* 7050-CLOSE-NEW-ACCT-CURSOR                                              
P77801*                                                                *        
P77801******************************************************************        
       7050-CLOSE-NEW-ACCT-CURSOR.                                      
                                                                        
           MOVE '7050'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE NEW-ACCT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7050-CLOSE-NEW-ACCT-CURSOR       **'        
               DISPLAY '**  ERROR CLOSING NEW-ACCT CURSOR    **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
P77801******************************************************************        
P77801*7055-OPEN-PEND-PREM-CURSOR                                      *        
P77801*                                                                *        
P77801******************************************************************        
       7055-OPEN-PEND-PREM-CURSOR.                                      
                                                                        
           MOVE '7055'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               OPEN PEND-PREM-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7055-OPEN-PEND-PREM-CURSOR        **'       
               DISPLAY '**  ERROR OPENING  PEND-PREM  CURSOR  **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
              END-IF.                                                   
                                                                        
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
P77801******************************************************************        
P77801* 7060-FETCH-PEND-PREM-CURSOR                                             
P77801*                                                                *        
P77801******************************************************************        
       7060-FETCH-PEND-PREM-CURSOR.                                     
                                                                        
           MOVE '7060'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH PEND-PREM-CURSOR                                    
               INTO :PR-PREMISE-NO                                      
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-AGL-PREM-NO                                     
                   ,:PR-LOCAL-OFFICE                                    
                   ,:PR-REV-DISTRICT-CD                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE 0              TO AT-ACCOUNT-NO                     
               MOVE PR-PREMISE-NO  TO WS-OLD-PREM-NUM                   
               MOVE PR-ADDRESS-ID  TO WS-OLD-ADDR-ID                    
               MOVE PR-LOCAL-OFFICE TO WS-OLD-LOCAL-OFFICE              
               MOVE PR-REV-DISTRICT-CD TO WS-OLD-REV-DISTRICT-CD        
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7060-FETCH-PEND-PREM-CURSOR      **'        
               DISPLAY '**  ERROR FETCHING PEND-PREM CURSOR  **'        
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PREMISE = ' PR-PREMISE-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
P77801******************************************************************        
P77801* 7065-CLOSE-PEND-PREM-CURSOR                                             
P77801*                                                                *        
P77801******************************************************************        
       7065-CLOSE-PEND-PREM-CURSOR.                                     
                                                                        
           MOVE '7065'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               CLOSE PEND-PREM-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7065-CLOSE-PEND-PREM-CURSOR       **'       
               DISPLAY '**  ERROR CLOSING PEND-PREM CURSOR    **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7065-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7035-GET-ADDRESS                                               *        
      *                                                                *        
      ******************************************************************        
       7035-GET-ADDRESS.                                                
                                                                        
           MOVE '7035'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_ID,                                        
                     ADDR_PREFIX_1,                                     
                     ADDR_PREFIX_2,                                     
                     ADDR_SUFFIX,                                       
                     ADDR_USAGE_CD,                                     
                     ADDRESS_OVERFLOW,                                  
                     CARRIER_ROUTE,                                     
                     HOUSE_NO,                                          
                     STREET_LOCATION_1,                                 
                     STREET_LOCATION_2,                                 
                     STREET_NAME,                                       
                     STREET_SUFFIX,                                     
                     DY.ZIP_CODE,                                       
                     ZIP_CODE_PLUS_FOUR,                                
                     DY.ZIP_CODE_TOKEN,                                 
A                    RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE) + ' ' + 
           LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))               
                 INTO                                                   
                     :DY-ADDRESS-ID,                                    
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-ADDR-SUFFIX,                                   
                     :DY-ADDR-USAGE-CD,                                 
                     :DY-ADDRESS-OVERFLOW,                              
                     :DY-CARRIER-ROUTE,                                 
                     :DY-HOUSE-NO,                                      
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-STREET-NAME,                                   
                     :DY-STREET-SUFFIX,                                 
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN,                                
A                    :WS-ADDRESS-LINE                                   
               FROM CSS_ADDR_FORMATTED DY,                              
A                   CSS_ZIP_CODE A4                                     
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
A                AND DY.ZIP_CODE = A4.ZIP_CODE                          
A                AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                            
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDRESS_ID,                                                
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              ADDR_USAGE_CD,                                             
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              CARRIER_ROUTE,                                             
MFA-TR*              HOUSE_NO,                                                  
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                      
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                       
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                         
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                   
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||                    
MFA-TR*              LTRIM(RTRIM(TOWN) || ', ' ||                               
MFA-TR*              LTRIM(RTRIM(STATE) || ' ' ||                               
MFA-TR*              LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))                       
MFA-TR*          INTO                                                           
MFA-TR*              :DY-ADDRESS-ID,                                            
MFA-TR*              :DY-ADDR-PREFIX-1,                                         
MFA-TR*              :DY-ADDR-PREFIX-2,                                         
MFA-TR*              :DY-ADDR-SUFFIX,                                           
MFA-TR*              :DY-ADDR-USAGE-CD,                                         
MFA-TR*              :DY-ADDRESS-OVERFLOW,                                      
MFA-TR*              :DY-CARRIER-ROUTE,                                         
MFA-TR*              :DY-HOUSE-NO,                                              
MFA-TR*              :DY-STREET-LOCATION-1,                                     
MFA-TR*              :DY-STREET-LOCATION-2,                                     
MFA-TR*              :DY-STREET-NAME,                                           
MFA-TR*              :DY-STREET-SUFFIX,                                         
MFA-TR*              :DY-ZIP-CODE,                                              
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*              :DY-ZIP-CODE-TOKEN,                                        
MFA-TR*              :WS-ADDRESS-LINE                                           
MFA-TR*        FROM CSS_ADDR_FORMATTED DY,                                      
MFA-TR*             CSS_ZIP_CODE A4                                             
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                                
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        QUERYNO 7035                                                     
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7035-GET-ADDRESS                  **'       
               DISPLAY '**  ERROR SEL FROM CSS_ADDR_FORMATTED **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ADDRESS-ID = 'DY-ADDRESS-ID                 
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7035-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7100-GET-RUN-DATE                                              *        
      *                                                                *        
      ******************************************************************        
       7100-GET-RUN-DATE.                                               
                                                                        
           MOVE '7100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) G6.PARM_DATA                                     
                  INTO :G6-PARM-DATA                                    
                  FROM CSS_JOB_PARM G6                                  
                 WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME               
                   AND G6.CMND_CODE    = :G6-CMND-CODE                  
                   AND G6.COMPANY_NO   = :G6-COMPANY-NO                 
                   AND G6.STATUS       = :G6-STATUS                     
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT G6.PARM_DATA                                             
MFA-TR*           INTO :G6-PARM-DATA                                            
MFA-TR*           FROM CSS_JOB_PARM G6                                          
MFA-TR*          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                       
MFA-TR*            AND G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*            AND G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*            AND G6.STATUS       = :G6-STATUS                             
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7100-GET-RUN-DATE                **'        
               DISPLAY '**  ERROR SELECTING CSS_JOB_PARM      **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7115-SELECT-PREM-DTLS                                                   
      *                                                                *        
      ******************************************************************        
       7115-SELECT-PREM-DTLS.                                           
                                                                        
           MOVE '7115'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) PR.PREMISE_NO,
              PR.ADDRESS_ID,
              PR.REV_DISTRICT_CD,
              PR.LOCAL_OFFICE                                  
                  INTO :PR-PREMISE-NO                                   
                      ,:PR-ADDRESS-ID                                   
                      ,:PR-REV-DISTRICT-CD                              
                      ,:PR-LOCAL-OFFICE                                 
                 FROM CSS_PREMISE PR, CSS_NAME_ACCT_XREF HT             
                WHERE PR.AGL_PREM_NO = :PR-AGL-PREM-NO                  
                AND PR.PREMISE_NO <> :WS-OLD-PREM-NUM                   
                AND PR.PREMISE_NO = HT.PREMISE_NO                       
                AND HT.CODE_ACCT_STAT NOT IN ('P','A', '')              
                AND HT.CUSTOMER_ROLE_CD = ''                            
                AND NOT EXISTS( SELECT 1 FROM CSS_NAME_ACCT_XREF HT1    
                WHERE HT1.PREMISE_NO = PR.PREMISE_NO                    
                AND HT1.CODE_ACCT_STAT ='A')                            
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PR.PREMISE_NO,                                           
MFA-TR*                PR.ADDRESS_ID,                                           
MFA-TR*                PR.REV_DISTRICT_CD,                                      
MFA-TR*                PR.LOCAL_OFFICE                                          
MFA-TR*           INTO :PR-PREMISE-NO                                           
MFA-TR*               ,:PR-ADDRESS-ID                                           
MFA-TR*               ,:PR-REV-DISTRICT-CD                                      
MFA-TR*               ,:PR-LOCAL-OFFICE                                         
MFA-TR*          FROM CSS_PREMISE PR, CSS_NAME_ACCT_XREF HT                     
MFA-TR*         WHERE PR.AGL_PREM_NO = :PR-AGL-PREM-NO                          
MFA-TR*         AND PR.PREMISE_NO <> :WS-OLD-PREM-NUM                           
MFA-TR*         AND PR.PREMISE_NO = HT.PREMISE_NO                               
MFA-TR*         AND HT.CODE_ACCT_STAT NOT IN ('P','A', '')                      
MFA-TR*         AND HT.CUSTOMER_ROLE_CD = ''                                    
MFA-TR*         AND NOT EXISTS( SELECT 1 FROM CSS_NAME_ACCT_XREF HT1            
MFA-TR*         WHERE HT1.PREMISE_NO = PR.PREMISE_NO                            
MFA-TR*         AND HT1.CODE_ACCT_STAT ='A')                                    
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  7115-SELECT-PREM-DTLS             **'       
               DISPLAY '**  ERROR SELECTING PREM FTLS         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7125-SELECT-ACTIVE-ACCT                                                 
      *                                                                *        
      ******************************************************************        
       7125-SELECT-ACTIVE-ACCT.                                         
                                                                        
           MOVE '7125'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) AT.ACCOUNT_NO,
              PR.PREMISE_NO,
              PR.ADDRESS_ID,
              PR.LOCAL_OFFICE,
              PR.REV_DISTRICT_CD                               
                   INTO :AT-ACCOUNT-NO                                  
                       ,:PR-PREMISE-NO                                  
                       ,:PR-ADDRESS-ID                                  
                       ,:PR-LOCAL-OFFICE                                
                       ,:PR-REV-DISTRICT-CD                             
                 FROM CSS_PREMISE PR, CSS_ACCOUNT AT                    
                WHERE PR.AGL_PREM_NO = :PR-AGL-PREM-NO                  
                  AND PR.PREMISE_NO = AT.PREMISE_NO                     
                  AND AT.CODE_ACCT_STAT = 'A'                           
                AND PR.PREMISE_NO <> :WS-NEW-PREM-NUM                   
                ORDER BY AT.ACCT_CREATE_DT ASC                          
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AT.ACCOUNT_NO,                                           
MFA-TR*                PR.PREMISE_NO,                                           
MFA-TR*                PR.ADDRESS_ID,                                           
MFA-TR*                PR.LOCAL_OFFICE,                                         
MFA-TR*                PR.REV_DISTRICT_CD                                       
MFA-TR*            INTO :AT-ACCOUNT-NO                                          
MFA-TR*                ,:PR-PREMISE-NO                                          
MFA-TR*                ,:PR-ADDRESS-ID                                          
MFA-TR*                ,:PR-LOCAL-OFFICE                                        
MFA-TR*                ,:PR-REV-DISTRICT-CD                                     
MFA-TR*          FROM CSS_PREMISE PR, CSS_ACCOUNT AT                            
MFA-TR*         WHERE PR.AGL_PREM_NO = :PR-AGL-PREM-NO                          
MFA-TR*           AND PR.PREMISE_NO = AT.PREMISE_NO                             
MFA-TR*           AND AT.CODE_ACCT_STAT = 'A'                                   
MFA-TR*         AND PR.PREMISE_NO <> :WS-NEW-PREM-NUM                           
MFA-TR*         ORDER BY AT.ACCT_CREATE_DT ASC                                  
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
ACT346     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT346        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
ACT346           MOVE PR-PREMISE-NO         TO WS-OLD-PREM-NUM          
ACT346           MOVE PR-ADDRESS-ID         TO WS-OLD-ADDR-ID           
ACT346           MOVE PR-LOCAL-OFFICE       TO WS-NEW-LOCAL-OFFICE      
ACT346           MOVE PR-REV-DISTRICT-CD    TO WS-OLD-REV-DISTRICT-CD   
ACT346        ELSE                                                      
ACT346           DISPLAY '**  AGL PREMISE NO = ' PR-AGL-PREM-NO         
ACT346           DISPLAY '**  PREMISE NO     = ' WS-NEW-PREM-NUM        
ACT346        END-IF                                                    
           ELSE                                                         
ACT346         MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE       
               DISPLAY '****************************************'       
               DISPLAY '**  7125-SELECT-ACTIVE-ACCT           **'       
               DISPLAY '**  ERROR SELECTING ACTIVE ACCT       **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
ACT346         DISPLAY '**  AGL PREMISE NO = ' PR-AGL-PREM-NO           
ACT346         DISPLAY '**  PREMISE NO = ' WS-NEW-PREM-NUM              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT182******************************************************************        
ACT182*                                                                *        
ACT182* 7200-GET-NEW-PREM-END-DT.                                      *        
ACT182******************************************************************        
ACT182 7200-GET-NEW-PREM-END-DT.                                        
ACT182                                                                  
ACT182                                                                  
ACT182     EXEC SQL                                                     
ACT182        SELECT TOP(1) CH.DATE_UTIL_SVC_END                               
ACT182           INTO :CH-DATE-UTIL-SVC-END :WS-NULL-DATE-IND            
ACT182           FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)               
ACT182          WHERE CH.PREMISE_NO  = :WS-NEW-PREM-NUM                 
ACT182          ORDER BY CH.DATE_UTIL_SVC_END DESC                      
ACT182                                     
ACT182                                                      
ACT182     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CH.DATE_UTIL_SVC_END                                       
MFA-TR*          INTO :CH-DATE-UTIL-SVC-END:WS-NULL-DATE-IND                    
MFA-TR*          FROM CSS_CUST_PREM_HIST CH                                     
MFA-TR*         WHERE CH.PREMISE_NO  = :WS-NEW-PREM-NUM                         
MFA-TR*         ORDER BY CH.DATE_UTIL_SVC_END DESC                              
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT182                                                                  
ACT182     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
ACT182                                                                  
ACT182     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT182        IF WS-NULL-DATE-IND EQUAL  -1                             
ACT182           MOVE SPACES             TO CH-DATE-UTIL-SVC-END        
ACT182        END-IF                                                    
ACT182     ELSE                                                         
ACT182        MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
ACT182        MOVE '7200'                TO WS-ACTIVE-PARAGRAPH         
ACT182        DISPLAY '****************************************'        
ACT182        DISPLAY '**  7200-GET-NEW-PREM-END-DT          **'        
ACT182        DISPLAY '**  ERROR SELECTING ACTIVE ACCT       **'        
ACT182        DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
ACT182        DISPLAY '**  PROCESSING TERMINATED             **'        
ACT182        DISPLAY '**  NEW PREMISE = ' WS-NEW-PREM-NUM              
ACT182        DISPLAY '**  DELINQ VAL  = ' WS-PREM-MAX-END-DT           
ACT182        DISPLAY '****************************************'        
ACT182        PERFORM 9900-ABEND                  THRU 9900-ABEND-EXIT  
ACT182     END-IF.                                                      
ACT182                                                                  
ACT182 7200-EXIT.                                                       
ACT182     EXIT.                                                        
                                                                        
ACT182******************************************************************        
ACT182* 7300-OPEN-INVLD-PREM-ACCT-CUR.                                 *        
ACT182*                                                                *        
ACT182******************************************************************        
ACT182 7300-OPEN-INVLD-PREM-ACCT-CUR.                                   
ACT182                                                                  
ACT182                                                                  
ACT182     EXEC SQL                                                     
ACT182        OPEN INVLD-PREM-ACCT-CUR                                  
ACT182     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT182                                                                  
ACT182     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
ACT182                                                                  
ACT182     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT182         CONTINUE                                                 
ACT182     ELSE                                                         
ACT182        MOVE WS-ACTIVE-RETURN-CODE   TO WS-DISPLAY-SQLCODE        
ACT182        MOVE '7300'                  TO WS-ACTIVE-PARAGRAPH       
ACT182        DISPLAY '****************************************'        
ACT182        DISPLAY '**  7300-OPEN-INVLD-PREM-ACCT-CUR     **'        
ACT182        DISPLAY '**  ERROR OPENING  PREM-CONS   CURSOR **'        
ACT182        DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
ACT182        DISPLAY '**  PROCESSING TERMINATED             **'        
ACT182        DISPLAY '****************************************'        
ACT182        PERFORM 9900-ABEND              THRU 9900-ABEND-EXIT      
ACT182     END-IF.                                                      
ACT182                                                                  
ACT182 7300-EXIT.                                                       
ACT182     EXIT.                                                        
ACT182                                                                  
ACT182******************************************************************        
ACT182* 7310-FETCH-INVLD-PREM-ACCT-CUR.                                *        
ACT182*                                                                *        
ACT182******************************************************************        
ACT182 7310-FETCH-INVLD-PREM-ACCT-CUR.                                  
ACT182                                                                  
ACT182                                                                  
ACT182     EXEC SQL                                                     
ACT182        FETCH INVLD-PREM-ACCT-CUR                                 
ACT182         INTO :AT-ACCOUNT-NO                                      
ACT182             ,:AT-CODE-ACCT-STAT                                  
ACT182             ,:AT-PREMISE-NO                                      
ACT182     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT182                                                                  
ACT182     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
ACT182                                                                  
ACT182     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT182         CONTINUE                                                 
ACT182     ELSE                                                         
ACT182       IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
ACT182          MOVE WS-YES                    TO WS-NO-MORE-ROWS       
ACT182       ELSE                                                       
ACT182         MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-SQLCODE    
ACT182         MOVE '7310'                     TO WS-ACTIVE-PARAGRAPH   
ACT182         DISPLAY '****************************************'       
ACT182         DISPLAY '**  7310-FETCH-INVLD-PREM-ACCT-CUR   **'        
ACT182         DISPLAY '**  ERROR FETCHING PREM-CONS   CURSOR**'        
ACT182         DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
ACT182         DISPLAY '**  PREMISE = ' WS-NEW-PREM-NUM                 
ACT182         DISPLAY '**  PROCESSING TERMINATED             **'       
ACT182         DISPLAY '****************************************'       
ACT182         PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
ACT182       END-IF                                                     
ACT182     END-IF.                                                      
ACT182                                                                  
ACT182 7310-EXIT.                                                       
ACT182     EXIT.                                                        
ACT182                                                                  
ACT182******************************************************************        
ACT182*                                                                *        
ACT182*7320-CLOSE-INVLD-PREM-ACCT-CUR.                                 *        
ACT182******************************************************************        
ACT182 7320-CLOSE-INVLD-PREM-ACCT-CUR.                                  
ACT182                                                                  
ACT182     EXEC SQL                                                     
ACT182          CLOSE INVLD-PREM-ACCT-CUR                               
ACT182     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT182                                                                  
ACT182     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
ACT182                                                                  
ACT182     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT182         CONTINUE                                                 
ACT182     ELSE                                                         
ACT182         MOVE WS-ACTIVE-RETURN-CODE      TO WS-DISPLAY-SQLCODE    
ACT182         MOVE '7320'                     TO WS-ACTIVE-PARAGRAPH   
ACT182         DISPLAY '****************************************'       
ACT182         DISPLAY '**  7320-CLOSE-INVLD-PREM-ACCT-CUR   **'        
ACT182         DISPLAY '**  ERROR CLOSING PREM-CONS   CURSOR  **'       
ACT182         DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
ACT182         DISPLAY '**  PROCESSING TERMINATED             **'       
ACT182         DISPLAY '****************************************'       
ACT182         PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
ACT182     END-IF.                                                      
ACT182                                                                  
ACT182 7320-EXIT.                                                       
ACT182     EXIT.                                                        
ACT182                                                                  
                                                                        
      ******************************************************************        
      * 8010-UPDATE-CSS-BILLING-HDR                                    *        
      *                                                                *        
      ******************************************************************        
       8010-UPDATE-CSS-BILLING-HDR.                                     
                                                                        
           MOVE '8010'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_HDR                                   
                  SET PREMISE_NO  =:WS-NEW-PREM-NUM                     
                WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                      
                  AND PREMISE_NO =:WS-OLD-PREM-NUM                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_HDR                                           
MFA-TR*           SET PREMISE_NO  =:WS-NEW-PREM-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  = :BI-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO =:WS-OLD-PREM-NUM                              
MFA-TR*        QUERYNO 8010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8010-UPDATING-CSS-BILLING-HDR     **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' BI-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-UPDATE-CSS-BILLING-DET                                    *        
      *                                                                *        
      ******************************************************************        
       8020-UPDATE-CSS-BILLING-DET.                                     
                                                                        
           MOVE '8020'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_DET                                   
                  SET PREMISE_NO  =:WS-NEW-PREM-NUM                     
                WHERE ACCOUNT_NO  = :BG-ACCOUNT-NO                      
                  AND PREMISE_NO = :WS-OLD-PREM-NUM                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_DET                                           
MFA-TR*           SET PREMISE_NO  =:WS-NEW-PREM-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  = :BG-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM-NUM                             
MFA-TR*        QUERYNO 8020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8020-UPDATE-CSS-BILLING-DET       **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' BG-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8040-UPDATE-CSS-COMM-DATA                                      *        
      *                                                                *        
      ******************************************************************        
       8040-UPDATE-CSS-COMM-DATA.                                       
                                                                        
           MOVE '8040'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COMM_DATA                                     
                  SET PREMISE_NO = :WS-NEW-PREM-NUM                     
                WHERE ACCOUNT_NO  IN (:KO-ACCOUNT-NO,0)                 
                  AND PREMISE_NO =:WS-OLD-PREM-NUM                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COMM_DATA                                             
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  IN (:KO-ACCOUNT-NO,0)                         
MFA-TR*           AND PREMISE_NO =:WS-OLD-PREM-NUM                              
MFA-TR*        QUERYNO 8040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8040-UPDATE-CSS-COMM-DATA         **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' KO-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8050-UPDATE-CSS-MNT-TRANS-HIST                                 *        
      *                                                                *        
      ******************************************************************        
       8050-UPDATE-CSS-MNT-TRANS-HIST.                                  
                                                                        
           MOVE '8050'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MNT_TRANS_HIST                                
                  SET PREMISE_NO  =:WS-NEW-PREM-NUM                     
                WHERE ACCOUNT_NO  IN (:MH-ACCOUNT-NO, 0)                
                  AND PREMISE_NO = :WS-OLD-PREM-NUM                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MNT_TRANS_HIST                                        
MFA-TR*           SET PREMISE_NO  =:WS-NEW-PREM-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  IN (:MH-ACCOUNT-NO, 0)                        
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM-NUM                             
MFA-TR*        QUERYNO 8050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8050-UPDATE-CSS-MNT-TRANS-HIST    **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' MH-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
            END-IF.                                                     
                                                                        
        8050-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8060-UPDATE-CSS-NAME-ACCT-XREF                                 *        
      *                                                                *        
      ******************************************************************        
       8060-UPDATE-CSS-NAME-ACCT-XREF.                                  
                                                                        
           MOVE '8060'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_NAME_ACCT_XREF                                
                  SET PREMISE_NO = :WS-NEW-PREM-NUM,                    
                      ADDRESS_ID = :WS-NEW-ADDR-ID                      
                 WHERE ACCOUNT_NO  = :HT-ACCOUNT-NO                     
                   AND PREMISE_NO = :WS-OLD-PREM-NUM                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_NAME_ACCT_XREF                                        
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM-NUM,                            
MFA-TR*               ADDRESS_ID = :WS-NEW-ADDR-ID                              
MFA-TR*          WHERE ACCOUNT_NO  = :HT-ACCOUNT-NO                             
MFA-TR*            AND PREMISE_NO = :WS-OLD-PREM-NUM                            
MFA-TR*        QUERYNO 8060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8060-UPDATE-CSS-NAME-ACCT-XREF    **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' HT-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8070-UPDATE-CSS-CONTACT-PREM                                   *        
      *                                                                *        
      ******************************************************************        
       8070-UPDATE-CSS-CONTACT-PREM.                                    
                                                                        
           MOVE '8070'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CONTACT_PREM                                  
                  SET PREMISE_NO  =:WS-NEW-PREM-NUM                     
                WHERE PREMISE_NO =:WS-OLD-PREM-NUM                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CONTACT_PREM                                          
MFA-TR*           SET PREMISE_NO  =:WS-NEW-PREM-NUM                             
MFA-TR*         WHERE PREMISE_NO =:WS-OLD-PREM-NUM                              
MFA-TR*        QUERYNO 8070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8070-UPDATE-CSS-CONTACT-PREM      **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
        8070-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8090-UPDATE-CSS-CUST-PREM-HIST                                 *        
      *                                                                *        
      ******************************************************************        
       8090-UPDATE-CSS-CUST-PREM-HIST.                                  
                                                                        
           MOVE '8090'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUST_PREM_HIST                                
                  SET PREMISE_NO  =:WS-NEW-PREM-NUM                     
                WHERE ACCOUNT_NO  = :CH-ACCOUNT-NO                      
                  AND PREMISE_NO =:WS-OLD-PREM-NUM                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_PREM_HIST                                        
MFA-TR*           SET PREMISE_NO  =:WS-NEW-PREM-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  = :CH-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO =:WS-OLD-PREM-NUM                              
MFA-TR*        QUERYNO 8090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8090-UPDATE-CSS-CUST-PREM-HIST    **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' CH-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-UPDATE-CSS-MISC-JRNL                                      *        
      *                                                                *        
      ******************************************************************        
       8100-UPDATE-CSS-MISC-JRNL.                                       
                                                                        
           MOVE '8100'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MISC_JRNL                                     
                  SET PREMISE_NO  =:WS-NEW-PREM-NUM                     
                WHERE ACCOUNT_NO  = :MJ-ACCOUNT-NO                      
                  AND PREMISE_NO =:WS-OLD-PREM-NUM                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MISC_JRNL                                             
MFA-TR*           SET PREMISE_NO  =:WS-NEW-PREM-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  = :MJ-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO =:WS-OLD-PREM-NUM                              
MFA-TR*        QUERYNO 8100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8100-UPDATE-CSS-MISC-JRNL         **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' MJ-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8110-UPDATE-CSS-REG-PROFILE                                    *        
      *                                                                *        
      ******************************************************************        
       8110-UPDATE-CSS-REG-PROFILE.                                     
                                                                        
           MOVE '8110'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_REG_PROFILE                                   
                  SET PREMISE_NO = :WS-NEW-PREM-NUM                     
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
                  AND PREMISE_NO = :WS-OLD-PREM-NUM                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_REG_PROFILE                                           
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM-NUM                             
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*           AND PREMISE_NO = :WS-OLD-PREM-NUM                             
MFA-TR*        QUERYNO 8110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8110-UPDATE-CSS-REG-PROFILE       **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' LR-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8120-UPDATE-CSS-SO-DATA                                        *        
      *                                                                *        
      ******************************************************************        
       8120-UPDATE-CSS-SO-DATA.                                         
                                                                        
           MOVE '8120'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET PREMISE_NO = :WS-NEW-PREM-NUM                     
                 WHERE ACCOUNT_NO_PRIOR  = :VO-ACCOUNT-NO               
                   AND PREMISE_NO = :WS-OLD-PREM-NUM                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM-NUM                             
MFA-TR*          WHERE ACCOUNT_NO_PRIOR  = :VO-ACCOUNT-NO                       
MFA-TR*            AND PREMISE_NO = :WS-OLD-PREM-NUM                            
MFA-TR*        QUERYNO 8120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8120-UPDATE-CSS-SO-DATA           **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' VO-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8125-UPDATE-HST-SO-DATA                                        *        
      *                                                                *        
      ******************************************************************        
       8125-UPDATE-HST-SO-DATA.                                         
                                                                        
           MOVE '8125'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE HST_SO_DATA                                       
                  SET PREMISE_NO = :WS-NEW-PREM-NUM                     
                 WHERE ACCOUNT_NO_PRIOR = :YV-ACCOUNT-NO                
                   AND PREMISE_NO = :WS-OLD-PREM-NUM                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE HST_SO_DATA                                               
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM-NUM                             
MFA-TR*          WHERE ACCOUNT_NO_PRIOR = :YV-ACCOUNT-NO                        
MFA-TR*            AND PREMISE_NO = :WS-OLD-PREM-NUM                            
MFA-TR*        QUERYNO 8125                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8125-UPDATE-HST-SO-DATA           **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' YV-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8130-UPDATE-CSS-UTIL-ENVRNMT                                   *        
      *                                                                *        
      ******************************************************************        
       8130-UPDATE-CSS-UTIL-ENVRNMT.                                    
                                                                        
           MOVE '8130'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_UTIL_ENVRNMT                                  
                  SET PREMISE_NO = :WS-NEW-PREM-NUM                     
                 WHERE ACCOUNT_NO  = :UT-ACCOUNT-NO                     
                   AND PREMISE_NO = :WS-OLD-PREM-NUM                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_UTIL_ENVRNMT                                          
MFA-TR*           SET PREMISE_NO = :WS-NEW-PREM-NUM                             
MFA-TR*          WHERE ACCOUNT_NO  = :UT-ACCOUNT-NO                             
MFA-TR*            AND PREMISE_NO = :WS-OLD-PREM-NUM                            
MFA-TR*        QUERYNO 8130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8130-UPDATE-CSS-UTIL-ENVRNMT      **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' UT-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8140-UPDATE-CSS-WQ-ITEMS                                       *        
      *                                                                *        
      ******************************************************************        
       8140-UPDATE-CSS-WQ-ITEMS.                                        
                                                                        
           MOVE '8140'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_WQ_ITEMS                                       
                 SET PREMISE_NO  =:WS-NEW-PREM-NUM                      
               WHERE ACCOUNT_NO  = :WQ-ACCOUNT-NO                       
                 AND PREMISE_NO =:WS-OLD-PREM-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_WQ_ITEMS                                               
MFA-TR*          SET PREMISE_NO  =:WS-NEW-PREM-NUM                              
MFA-TR*        WHERE ACCOUNT_NO  = :WQ-ACCOUNT-NO                               
MFA-TR*          AND PREMISE_NO =:WS-OLD-PREM-NUM                               
MFA-TR*       QUERYNO 8140                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8140-UPDATE-CSS-WQ-ITEMS          **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' WQ-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
         8140-EXIT.                                                     
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 8150-UPDATE-CSS-ACCOUNT                                        *        
      *                                                                *        
      ******************************************************************        
       8150-UPDATE-CSS-ACCOUNT.                                         
                                                                        
           MOVE '8150'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET PREMISE_NO  =:WS-NEW-PREM-NUM                     
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
                  AND PREMISE_NO =:WS-OLD-PREM-NUM                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET PREMISE_NO  =:WS-NEW-PREM-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO =:WS-OLD-PREM-NUM                              
MFA-TR*        QUERYNO 8150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8150-UPDATE-CSS-ACCOUNT           **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' AT-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
            END-IF.                                                     
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8160-UPDATE-REV-BILLING-DET                                    *        
      *                                                                *        
      ******************************************************************        
       8160-UPDATE-REV-BILLING-DET.                                     
                                                                        
           MOVE '8160'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE REV_BILLING_DET                                   
                  SET PREMISE_NO =  :WS-NEW-PREM-NUM                    
                WHERE ACCOUNT_NO  = :RV-ACCOUNT-NO                      
                  AND PREMISE_NO  = :WS-OLD-PREM-NUM                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE REV_BILLING_DET                                           
MFA-TR*           SET PREMISE_NO =  :WS-NEW-PREM-NUM                            
MFA-TR*         WHERE ACCOUNT_NO  = :RV-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO  = :WS-OLD-PREM-NUM                            
MFA-TR*        QUERYNO 8160                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8160-UPDATE-REV-BILLING-DET       **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' RV-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8170-UPDATE-HST-ACCOUNT                                                 
      *                                                                         
      *****************************************************************         
       8170-UPDATE-HST-ACCOUNT.                                         
                                                                        
           MOVE '8170'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE HST_ACCOUNT                                       
                  SET PREMISE_NO =  :WS-NEW-PREM-NUM                    
                WHERE ACCOUNT_NO  = :HA-ACCOUNT-NO                      
                  AND PREMISE_NO  = :WS-OLD-PREM-NUM                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE HST_ACCOUNT                                               
MFA-TR*           SET PREMISE_NO =  :WS-NEW-PREM-NUM                            
MFA-TR*         WHERE ACCOUNT_NO  = :HA-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO  = :WS-OLD-PREM-NUM                            
MFA-TR*        QUERYNO 8170                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8170-UPDATE-HST-ACCOUNT           **'       
               DISPLAY '**  ERROR UPDATING PREMISE-NO         **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  ACCOUNT = ' HA-ACCOUNT-NO                   
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8180-DELETE-NAME-ACCT-XREF.                                             
      *                                                                         
      *****************************************************************         
       8180-DELETE-NAME-ACCT-XREF.                                      
                                                                        
           MOVE '8180'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_NAME_ACCT_XREF                           
                WHERE PREMISE_NO  = :WS-OLD-PREM-NUM                    
                  AND ACCOUNT_NO  = 0                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_NAME_ACCT_XREF                                   
MFA-TR*         WHERE PREMISE_NO  = :WS-OLD-PREM-NUM                            
MFA-TR*           AND ACCOUNT_NO  = 0                                           
MFA-TR*        QUERYNO 8180                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8180-DELETE-NAME-ACCT-XREF        **'       
               DISPLAY '**  ERROR DELETING FROM NAME-ACCT-XREF**'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PREMISE = ' WS-OLD-PREM-NUM                 
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8220-UPDATE-LOCAL-OFFICE                                       *        
      *                                                                *        
      ******************************************************************        
       8220-UPDATE-LOCAL-OFFICE.                                        
                                                                        
           MOVE '8220'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET LOCAL_OFFICE = :WS-NEW-LOCAL-OFFICE               
                WHERE PREMISE_NO   = :WS-NEW-PREM-NUM                   
                  AND LOCAL_OFFICE = :WS-OLD-LOCAL-OFFICE               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*           SET LOCAL_OFFICE = :WS-NEW-LOCAL-OFFICE                       
MFA-TR*         WHERE PREMISE_NO   = :WS-NEW-PREM-NUM                           
MFA-TR*           AND LOCAL_OFFICE = :WS-OLD-LOCAL-OFFICE                       
MFA-TR*       QUERYNO 8220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  8220-UPDATE-LOCAL-OFFICE          **'       
               DISPLAY '**  ERROR UPDATING PREM_CREATE_DT     **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PREMISE = ' WS-NEW-PREM-NUM                 
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      * 5000-MOVE-TRAN-HEAD                                         *           
      ***************************************************************           
       5000-MOVE-TRAN-HEAD.                                             
                                                                        
           MOVE '5000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03840095
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                    03860095

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  1100-GET-CURRENT-TIMESTAMP        **'       
               DISPLAY '**  ERROR GETTING CURRENT TIME        **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-DATE-TRANS = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  1100-GET-CURRENT-TIMESTAMP        **'       
               DISPLAY '**  ERROR GETTING CURRENT DATE        **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
           MOVE 'F'                TO MH-CODE-TRAN-TYPE.                
           MOVE 437                TO MH-RESP-AREA-ID.                  
           MOVE 0                  TO MH-CUSTOMER-NO.                   
           MOVE WS-NEW-PREM-NUM    TO MH-PREMISE-NO.                    
           MOVE 0                  TO MH-ACCOUNT-NO.                    
           MOVE 'SYSTEM'           TO MH-USER-ID.                       
           MOVE 'BATCH SP'         TO MH-APPL-PROGRAM-ID.               
           STRING 'PREMISE NUMBER CHANGE FOR ACCT#'                     
                   DELIMITED BY SIZE                                    
                   WS-ACCOUNT   DELIMITED BY SIZE                       
                   INTO MH-TRAN-COMMENT-TEXT                            
           END-STRING.                                                  
           MOVE +44                TO MH-TRAN-COMMENT-LEN.              
                                                                        
           PERFORM 5210-PREM-TRAN-DET THRU 5210-EXIT.                   
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5210-PREM-TRAN-DET                                             *        
      *                                                                *        
      ******************************************************************        
       5210-PREM-TRAN-DET.                                              
                                                                        
           MOVE '5210'               TO WS-ACTIVE-PARAGRAPH.            
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE 1                    TO WS-TRAN-APPL-NO.                
                                                                        
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE WS-NEW-PREM-NUM      TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE WS-OLD-PREM-NUM      TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE 'PREMISE NUMBER'     TO MI-COLUMN-DESC.                 
           MOVE ' '                  TO MI-TABLE-ID.                    
           PERFORM 6535-LOAD-MNT-TRANS-HIST THRU 6535-EXIT.             
           MOVE 0                    TO WS-TRAN-APPL-NO.                
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 04126399
      *6535-LOAD-MNT-TRANS-HIST                                       *         
      *                                                               *         
      *****************************************************************         
       6535-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           MOVE '6535'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           IF MI-TRAN-APPL-NO EQUAL 1 THEN                              
               PERFORM 6545-INSERT-MNT-TRANS-HIST THRU 6545-EXIT        
               PERFORM 6555-INSERT-MT-TRN-HST-DET THRU 6555-EXIT        
           ELSE                                                         
               PERFORM 6555-INSERT-MT-TRN-HST-DET THRU 6555-EXIT        
           END-IF.                                                      
                                                                        
       6535-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6545-INSERT-MNT-TRANS-HIST                                     *        
      *                                                                *        
      ******************************************************************        
       6545-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           MOVE '6545'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
                   CODE_TRAN_TYPE,    RESP_AREA_ID,                     
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,       PREMISE_NO,                       
                   USER_ID,           APPL_PROGRAM_ID,                  
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                               
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                             
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                               
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                          
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,                       
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,                     
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,                       
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,                  
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  6545-INSERT-MNT-TRANS-HIST        **'       
               DISPLAY '**  ERROR INSERTING MNT-TRANS-HIST    **'       
               DISPLAY '**' MH-TRANS-HIST-SEQ-NO                        
               DISPLAY '**  ACCOUNT-NO = ' MH-ACCOUNT-NO                
               DISPLAY '**  PREMISE-NO = ' MH-PREMISE-NO                
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       6545-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6555-INSERT-MT-TRN-HST-DET                                     *        
      *                                                                *        
      ******************************************************************        
       6555-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           MOVE '6555'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       
                 COLUMN_DESC,       PRV_COLUMN_VALUE,                   
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
                 :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*        ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                               
MFA-TR*          COLUMN_DESC,       PRV_COLUMN_VALUE,                           
MFA-TR*          CHG_COLUMN_VALUE,                                              
MFA-TR*          TABLE_ID)                                                      
MFA-TR*        VALUES                                                           
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,                       
MFA-TR*          :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,                   
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                          
MFA-TR*          :MI-TABLE-ID)                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '**  6555-INSERT-MT-TRN-HST-DET        **'       
               DISPLAY '**  ERROR INSERTING MT-TRN-HST-DET    **'       
               DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE              
               DISPLAY '**  PROCESSING TERMINATED             **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT                  
           END-IF.                                                      
                                                                        
       6555-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8565-INSERT-WORK-QUEUE                                         *        
      *                                                                *        
      ******************************************************************        
       8565-INSERT-WORK-QUEUE.                                          
                                                                        
ACT067     MOVE SPACES                       TO ABEND-FUNCTION.         
ACT067     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT067                            ABEND-FILE,                           
ACT067                            RS-RETURN-CODE.                       
ACT067                                                                  
ACT067      MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.  
ACT067                                                                  
ACT067      IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
ACT067         MOVE PROGRAM-NAME             TO   ABEND-PROGRAM         
ACT067         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT067         DISPLAY 'CALL SCSCB077         '                         
ACT067         DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO              
ACT067         DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO              
ACT067         DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO           
ACT067         DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE         
ACT067         PERFORM 9900-ABEND             THRU 9900-ABEND-EXIT      
ACT067      END-IF.                                                     
ACT067                                                                  
       8565-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO118 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
