       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSSO117                                          
COB303 DATE-WRITTEN.  FEB, 2010                                         
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  PROGRAM:  PCSSO117                                           *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      * THIS PROGRAM UPDATES THE CALL_STATUS IN CSS_SO_NDO_CALL_LIST  *         
      * TABLE AND RESET THE IVR-FL IN CSS_SO_DATA(CODES_DATA_PRESENT) *         
      *                                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
      *  02/08/10  SC41135    PROCEDURE ORIGINALLY CODED.             *         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO117'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSSO117 STARTS HERE'.            
                                                                        
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
       01  PROGRAM-NAME                 PIC X(08) VALUE 'PCSSO117'.     
       01  WS-PGRMNAME                  PIC X(08).                      
      *                                                                         
       01  MISC-FIELDS.                                                 
           05  WS-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.      
           05  WS-CURRENT-DATE         PIC X(10).                       
           05  WS-CURRENT-TS           PIC X(24).                       
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-X                    PIC X(01) VALUE 'X'.             
           05  WS-ROW-COUNT            PIC S9(09) COMP VALUE 0.         
           05  WS-DISPLAY-SQLCODE      PIC -(8)9.                       
           05  WS-DISPLAY-COUNT        PIC S9(09) COMP VALUE 0.         
           05  WS-COMMIT-COUNT         PIC S9(09) COMP VALUE 0.         
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSSO117 ENDS HERE  '.            
                                                                        
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_MODEL_SQL      (PREFIX = MS)                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_SO_DATA - VO ****                                                
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      **** CSS_SO_NDO_CALL_LIST - NL ****                                       
           EXEC SQL                                                             
                INCLUDE TBNDOLST                                                
           END-EXEC.                                                            
                                                                        
      **** CODES DATA PRESENT ****                                              
           EXEC SQL                                                             
              INCLUDE CWS00059                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   DB2 CURSOR DECLARATIONS                                    **        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *   RETRIEVE FROM CSS_SO_DATA                                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE CALL-LIST-ORDERS CURSOR WITH HOLD FOR              
               SELECT NL.SERV_ORDER_NO ,                                
                      NL.CALL_STATUS_CD                                 
                     ,VO.CODES_DATA_PRESENT                             
                FROM CSS_SO_NDO_CALL_LIST NL                            
                    ,CSS_SO_DATA VO                                     
                WHERE NL.CALL_STATUS_CD IN ('R', 'I')                   
                AND NL.SERV_ORDER_NO = VO.SERV_ORDER_NO                 
                                                            
          END-EXEC.                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CALL-LIST-ORDERS CURSOR WITH HOLD FOR                      
MFA-TR*        SELECT NL.SERV_ORDER_NO ,                                        
MFA-TR*               NL.CALL_STATUS_CD                                         
MFA-TR*              ,VO.CODES_DATA_PRESENT                                     
MFA-TR*         FROM CSS_SO_NDO_CALL_LIST NL                                    
MFA-TR*             ,CSS_SO_DATA VO                                             
MFA-TR*         WHERE NL.CALL_STATUS_CD IN ('R', 'I')                           
MFA-TR*         AND NL.SERV_ORDER_NO = VO.SERV_ORDER_NO                         
MFA-TR*          QUERYNO 7010                                                   
MFA-TR*   END-EXEC.                                                             
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *     0000-MAINLINE                                              *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 1100-GET-CURRENT-TIMESTAMP  THRU 1100-EXIT.         
            PERFORM 2000-MAIN-PROCESS          THRU 2000-EXIT.          
            MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                      
            DISPLAY 'TOTAL RECORDS = ' WS-DISPLAY-COUNT.                
            STOP RUN.                                                   
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-GET-CURRENT-TIMESTAMP                                     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       1100-GET-CURRENT-TIMESTAMP.                                      
                                                                        
            MOVE '1100'                     TO WS-ACTIVE-PARAGRAPH.     
                                                                        
            EXEC SQL                                                    
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-CURRENT-TS        = CURRENT TIMESTAMP                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
             CONTINUE                                                   
            ELSE                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  1100-GET-CURRENT-TIMESTAMP        **'        
              DISPLAY '**  ERROR GETTING NEXT DATE           **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-MAIN-PROCESS                                              *        
      *                                                                *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
           PERFORM 2100-GET-CALL-LIST-ORDERS THRU 2100-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-GET-CALL-LIST-ORDERS                                 *             
      *                                                                *        
      ******************************************************************        
       2100-GET-CALL-LIST-ORDERS.                                       
                                                                        
           MOVE  '2100'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7000-OPEN-CALL-LIST-ORD-CUR THRU 7000-EXIT.          
           PERFORM 7010-FETCH-CALL-LIST-ORD-CUR  THRU 7010-EXIT         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'SYSTEM'          TO NL-LAST-UPDATE-USERID           
              MOVE WS-CURRENT-TS     TO NL-LAST-UPDATE-TS               
              MOVE WS-X              TO NL-CALL-STATUS-CD               
                                                                        
              PERFORM 8200-UPDATE-CALL-LIST     THRU 8200-EXIT          
              MOVE VO-CODES-DATA-PRESENT   TO WS-CODES-SO-DATA-PRESENT  
              MOVE 'N' TO WS-CODE-NDO-IVR-FL                            
              MOVE WS-CODES-SO-DATA-PRESENT TO VO-CODES-DATA-PRESENT    
              MOVE NL-SERV-ORDER-NO         TO VO-SERV-ORDER-NO         
              PERFORM 8300-UPDATE-CDP-SODATA    THRU 8300-EXIT          
              IF WS-COMMIT-COUNT > 100 THEN                             
                 EXEC SQL                                               
                   COMMIT                                               
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT                                
              END-IF                                                    
           END-IF                                                       
               PERFORM 7010-FETCH-CALL-LIST-ORD-CUR  THRU 7010-EXIT     
             END-PERFORM.                                               
                                                                        
           PERFORM 7020-CLOSE-CALL-LIST-ORD-CUR  THRU 7020-EXIT.        
              EXEC SQL                                                  
                COMMIT                                                  
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-CALL-LIST-ORD-CUR                               *             
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7000-OPEN-CALL-LIST-ORD-CUR.                                     
                                                                        
           MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN CALL-LIST-ORDERS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7000-OPEN-CALL-LIST-ORD-CUR      **'    
                   DISPLAY '**  ERROR OPENING  CALL-LIST-ORDERS   **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-FETCH-CALL-LIST-ORD-CUR                                  *         
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7010-FETCH-CALL-LIST-ORD-CUR.                                    
                                                                        
           MOVE '7010'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH CALL-LIST-ORDERS                                    
               INTO :NL-SERV-ORDER-NO                                   
                   ,:NL-CALL-STATUS-CD                                  
                   ,:VO-CODES-DATA-PRESENT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7010-FETCH-CALL-LIST-ORD-CUR    **'     
                   DISPLAY '**  ERROR FETCHING CALL-LIST-ORDERS  **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' VO-SERV-ORDER-NO            
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CLOSE-CALL-LIST-ORD-CUR                                  *         
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7020-CLOSE-CALL-LIST-ORD-CUR.                                    
                                                                        
           MOVE '7020'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE CALL-LIST-ORDERS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7020-CLOSE-CALL-LIST-ORD-CUR    **'     
                   DISPLAY '**  ERROR CLOSING CALL-LIST-ORDERS    **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-UPDATE-CDP-SODATA                                         *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       8300-UPDATE-CDP-SODATA.                                          
                                                                        
           MOVE '8300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT       
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                            
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT               
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         QUERYNO 8300                                                    
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  8300-UPDATE-CDP-SODATA         **'      
                   DISPLAY '**  ERROR UPDATING CSS_SO_DATA        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-UPDATE-CALL-LIST                                          *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       8200-UPDATE-CALL-LIST.                                           
                                                                        
           MOVE '8200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_SO_NDO_CALL_LIST                             
                  SET CALL_STATUS_CD = :NL-CALL-STATUS-CD               
                     ,LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :NL-LAST-UPDATE-TS
              )               
                     ,LAST_UPDATE_USERID = :NL-LAST-UPDATE-USERID       
                 WHERE SERV_ORDER_NO = :NL-SERV-ORDER-NO                
                 AND CALL_STATUS_CD IN ('R','I')                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_SO_NDO_CALL_LIST                                     
MFA-TR*           SET CALL_STATUS_CD = :NL-CALL-STATUS-CD                       
MFA-TR*              ,LAST_UPDATE_TS = :NL-LAST-UPDATE-TS                       
MFA-TR*              ,LAST_UPDATE_USERID = :NL-LAST-UPDATE-USERID               
MFA-TR*          WHERE SERV_ORDER_NO = :NL-SERV-ORDER-NO                        
MFA-TR*          AND CALL_STATUS_CD IN ('R','I')                                
MFA-TR*          QUERYNO 8200                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           ADD   1    TO    WS-ROW-COUNT                                
           ADD   1    TO    WS-COMMIT-COUNT                             
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                   CONTINUE                                             
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  8200-UPDATE-CALL-LIST            **'    
                   DISPLAY '**  ERROR UPDATING CSS_SO_NDO_CALL_LIST'    
                   DISPLAY '**  ORDER   = ' NL-SERV-ORDER-NO            
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
        8200-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO117 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
                                                                        
