       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSSO116                                          
COB303 DATE-WRITTEN.  NOVEMBER, 2009                                    
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  PROGRAM:  PCSSO116                                           *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      * THIS PROGRAM POPULATES THE CSS_SO_NDO_CALL_LIST TABLE WITH    *         
      * NEXT DAY ORDERS.                                              *         
      *                                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
      *  09/28/09  SC41135    PROCEDURE ORIGINALLY CODED.             *         
P01176*  09/15/16  SC41135    ADDED WORK-TYPE RMT SIMILAR TO RMM      *         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSSO116'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSSO116 STARTS HERE'.            
                                                                        
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
       01  PROGRAM-NAME                 PIC X(08) VALUE 'PCSSO116'.     
       01  WS-PGRMNAME                  PIC X(08).                      
      *                                                                         
       01  MISC-FIELDS.                                                 
           05  WS-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.      
           05  WS-CODE-UTIL-TYPE       PIC X(01).                       
           05  WS-CURRENT-DATE         PIC X(10).                       
           05  WS-CURRENT-TS           PIC X(24).                       
           05  WS-NEXT-DATE            PIC X(10).                       
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-ROW-COUNT            PIC S9(09) COMP VALUE 0.         
           05  WS-DISPLAY-SQLCODE      PIC -(8)9.                       
           05  WS-DISPLAY-COUNT        PIC S9(09) COMP VALUE 0.         
           05  WS-COMMIT-COUNT         PIC S9(09) COMP VALUE 0.         
           05  WS-NULL-CALL-TS         PIC S9(04) COMP VALUE 0.         
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
      *01  LOC1            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
                                                                        
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSSO116 ENDS HERE  '.            
                                                                        
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_MODEL_SQL      (PREFIX = MS)                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_SO_DATA - VO ****                                                
           EXEC SQL                                                             
                INCLUDE TBSODAT                                                 
           END-EXEC.                                                            
                                                                        
      **** CSS_SO_ORDER_INST - VI ****                                          
           EXEC SQL                                                             
                INCLUDE TBSOODR                                                 
           END-EXEC.                                                            
                                                                        
      **** CSS_CUST_MISC_INFO - LQ ****                                         
           EXEC SQL                                                             
                INCLUDE TBCSTMSC                                                
           END-EXEC.                                                            
                                                                        
      **** CSS_ACCOUNT - AT ****                                                
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_NDO_IVR_CALL - NQ ****                                           
           EXEC SQL                                                             
                INCLUDE TBNDOIVR                                                
           END-EXEC.                                                            
                                                                        
      **** CSS_SO_NDO_CALL_LIST NL ****                                         
           EXEC SQL                                                             
                INCLUDE TBNDOLST                                                
           END-EXEC.                                                            
                                                                        
      **** CSS_LANDLORD - SI ****                                               
           EXEC SQL                                                             
                INCLUDE TBLNDLRD                                                
           END-EXEC.                                                            
                                                                        
      **** CODES DATA PRESENT ****                                              
           EXEC SQL                                                             
              INCLUDE CWS00059                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   DB2 CURSOR DECLARATIONS                                    **        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *   RETRIEVE FROM CSS_SO_DATA                                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE SO-DATA-IVR CURSOR WITH HOLD FOR                   
               SELECT DISTINCT VO.SERV_ORDER_NO ,                       
                      VO.PREMISE_NO             ,                       
                      VO.ACCOUNT_NO             ,                       
                      VO.ORDER_TYPE_CD          ,                       
                      VO.COMPANY_NO             ,                       
                      VO.PHONE_NO               ,                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME      ,                       
                      VO.CODES_DATA_PRESENT                             
                FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                      
                     CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),                
                     CSS_NDO_IVR_CALL NQ WITH(READUNCOMMITTED),                 
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_PREMISE PR WITH(READUNCOMMITTED)                       
                WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                   AND VO.ORDER_TYPE_CD = NQ.ORDER_TYPE_CD              
                   AND VO.COMPANY_NO = NQ.COMPANY_NO                    
                   AND VO.ORDER_STATE_CD = 'A'                          
                   AND VO.PHONE_NO <> ''                                
                   AND CAST(ASSIGNED_DATETIME AS DATE) =                        
                        DATEADD( DAY, 1, CAST(CIS.CURRENT$TIMESTAMP()
            AS DATE) )                 
                   AND  (VI.WORK_TYPE_CD = NQ.ELEC_WKTYPE_CD            
                    OR VI.WORK_TYPE_CD = NQ.GAS_WKTYPE_CD)              
                   AND VI.WORK_TYPE_CD NOT IN                           
                   ('','MTC','RDO','VRB','HOF','RMM','RMC','RS2','RMT') 
                   AND PR.PREMISE_NO = VO.PREMISE_NO                    
                   AND PR.CODE_RENTAL_PROP <> 'D'                       
                   AND AT.ACCOUNT_NO = VO.ACCOUNT_NO                    
                   AND AT.CUSTOMER_NO NOT IN                            
                    (SELECT LQ.CUSTOMER_NO FROM CSS_CUST_MISC_INFO LQ
                           WITH(READUNCOMMITTED)   
                   WHERE LQ.CUSTOMER_NO = AT.CUSTOMER_NO                
                   AND LQ.IVR_NDO_EXEMPT = 'Y')                         
                   AND VO.SERV_ORDER_NO NOT IN                          
                    (SELECT SI2.SERV_ORDER_NO FROM CSS_SO_ORDER_INST SI2
                           WITH(READUNCOMMITTED)
                       WHERE SI2.SERV_ORDER_NO = VO.SERV_ORDER_NO       
                         AND SI2.HOLD_RELEASE = 'Y')                    
                 FOR READ ONLY                                  
                                                            
          END-EXEC.                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SO-DATA-IVR CURSOR WITH HOLD FOR                           
MFA-TR*        SELECT DISTINCT VO.SERV_ORDER_NO ,                               
MFA-TR*               VO.PREMISE_NO             ,                               
MFA-TR*               VO.ACCOUNT_NO             ,                               
MFA-TR*               VO.ORDER_TYPE_CD          ,                               
MFA-TR*               VO.COMPANY_NO             ,                               
MFA-TR*               VO.PHONE_NO               ,                               
MFA-TR*               VO.ASSIGNED_DATETIME      ,                               
MFA-TR*               VO.CODES_DATA_PRESENT                                     
MFA-TR*         FROM CSS_SO_DATA VO,                                            
MFA-TR*              CSS_SO_ORDER_INST VI,                                      
MFA-TR*              CSS_NDO_IVR_CALL NQ,                                       
MFA-TR*              CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_PREMISE PR                                             
MFA-TR*         WHERE VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*            AND VO.ORDER_TYPE_CD = NQ.ORDER_TYPE_CD                      
MFA-TR*            AND VO.COMPANY_NO = NQ.COMPANY_NO                            
MFA-TR*            AND VO.ORDER_STATE_CD = 'A'                                  
MFA-TR*            AND VO.PHONE_NO <> ''                                        
MFA-TR*            AND DATE(ASSIGNED_DATETIME) =                                
MFA-TR*                 DATE(CURRENT TIMESTAMP) + 1 DAY                         
MFA-TR*            AND  (VI.WORK_TYPE_CD = NQ.ELEC_WKTYPE_CD                    
MFA-TR*             OR VI.WORK_TYPE_CD = NQ.GAS_WKTYPE_CD)                      
MFA-TR*            AND VI.WORK_TYPE_CD NOT IN                                   
MFA-TR*            ('','MTC','RDO','VRB','HOF','RMM','RMC','RS2','RMT')         
MFA-TR*            AND PR.PREMISE_NO = VO.PREMISE_NO                            
MFA-TR*            AND PR.CODE_RENTAL_PROP <> 'D'                               
MFA-TR*            AND AT.ACCOUNT_NO = VO.ACCOUNT_NO                            
MFA-TR*            AND AT.CUSTOMER_NO NOT IN                                    
MFA-TR*             (SELECT LQ.CUSTOMER_NO FROM CSS_CUST_MISC_INFO LQ           
MFA-TR*            WHERE LQ.CUSTOMER_NO = AT.CUSTOMER_NO                        
MFA-TR*            AND LQ.IVR_NDO_EXEMPT = 'Y')                                 
MFA-TR*            AND VO.SERV_ORDER_NO NOT IN                                  
MFA-TR*             (SELECT SI2.SERV_ORDER_NO FROM CSS_SO_ORDER_INST SI2        
MFA-TR*                WHERE SI2.SERV_ORDER_NO = VO.SERV_ORDER_NO               
MFA-TR*                  AND SI2.HOLD_RELEASE = 'Y')                            
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*   END-EXEC.                                                             
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *     0000-MAINLINE                                              *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 1100-GET-CURRENT-TIMESTAMP  THRU 1100-EXIT.         
            PERFORM 2000-MAIN-PROCESS          THRU 2000-EXIT.          
            MOVE WS-ROW-COUNT TO WS-DISPLAY-COUNT.                      
            DISPLAY 'TOTAL RECORDS = ' WS-DISPLAY-COUNT.                
            STOP RUN.                                                   
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-GET-CURRENT-TIMESTAMP                                     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       1100-GET-CURRENT-TIMESTAMP.                                      
                                                                        
             MOVE '1100'                     TO WS-ACTIVE-PARAGRAPH.    
                                                                        
             EXEC SQL                                                   
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SET :WS-CURRENT-TS        = CURRENT TIMESTAMP                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE          
              DISPLAY '****************************************'        
              DISPLAY '**  1100-GET-CURRENT-TIMESTAMP        **'        
              DISPLAY '**  ERROR GETTING NEXT DATE           **'        
              DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE               
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-MAIN-PROCESS                                              *        
      *                                                                *        
      ******************************************************************        
       2000-MAIN-PROCESS.                                               
                                                                        
           PERFORM 2100-POPULATE-IVR-ORDERS  THRU 2100-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-POPULATE-IVR-ORDERS.                                      *        
      *                                                                *        
      ******************************************************************        
       2100-POPULATE-IVR-ORDERS.                                        
                                                                        
           MOVE  '2100'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 7000-OPEN-SO-DATA-IVR-CURSOR   THRU 7000-EXIT.       
           PERFORM 7010-FETCH-SO-DATA-IVR-CURSOR  THRU 7010-EXIT        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
            MOVE VO-CODES-DATA-PRESENT   TO WS-CODES-SO-DATA-PRESENT    
            IF WS-CODE-NDO-IVR-FL EQUAL 'N' THEN                        
              PERFORM 2200-GET-ORDER-INST-DATA  THRU 2200-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
              MOVE VO-SERV-ORDER-NO  TO NL-SERV-ORDER-NO                
              MOVE VO-ACCOUNT-NO     TO NL-ACCOUNT-NO                   
              MOVE WS-N              TO NL-CALL-PRIORITY-CD             
              MOVE WS-R              TO NL-CALL-STATUS-CD               
              MOVE SPACES            TO NL-CALL-RESULT-CD               
              MOVE 'SYSTEM'          TO NL-LAST-UPDATE-USERID           
              MOVE WS-CURRENT-TS     TO NL-LAST-UPDATE-TS               
              MOVE  -1               TO WS-NULL-CALL-TS                 
              MOVE VO-PHONE-NO       TO NL-PHONE-NO                     
              MOVE VO-COMPANY-NO     TO NL-COMPANY-NO                   
              MOVE VO-ASSIGNED-DATETIME TO NL-ASSIGNED-DATETIME         
              MOVE 0                 TO NL-CALL-COUNT                   
                                                                        
              PERFORM 8200-INSERT-CALL-LIST     THRU 8200-EXIT          
              MOVE 'A' TO WS-CODE-NDO-IVR-FL                            
              MOVE WS-CODES-SO-DATA-PRESENT TO VO-CODES-DATA-PRESENT    
                                                                        
              PERFORM 8300-UPDATE-CDP-SODATA    THRU 8300-EXIT          
              IF WS-COMMIT-COUNT > 100 THEN                             
                 EXEC SQL                                               
                   COMMIT                                               
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE 0 TO WS-COMMIT-COUNT                                
              END-IF                                                    
             END-IF                                                     
            END-IF                                                      
            END-IF                                                      
               PERFORM 7010-FETCH-SO-DATA-IVR-CURSOR  THRU 7010-EXIT    
             END-PERFORM.                                               
                                                                        
           PERFORM 7020-CLOSE-SO-DATA-IVR-CURSOR  THRU 7020-EXIT.       
              EXEC SQL                                                  
                COMMIT                                                  
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-GET-ORDER-INST-DATA.                                      *        
      *                                                                *        
      ******************************************************************        
       2200-GET-ORDER-INST-DATA.                                        
                                                                        
           MOVE  '2200'              TO   WS-ACTIVE-PARAGRAPH.          
                                                                        
           MOVE   VO-SERV-ORDER-NO    TO WS-SERV-ORDER-NO               
           MOVE   'G'                 TO WS-CODE-UTIL-TYPE              
           PERFORM 7050-SELECT-SO-INST-DATA   THRU 7050-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN              
              MOVE   VI-WORK-TYPE-CD      TO NQ-GAS-WKTYPE-CD           
           ELSE                                                         
              MOVE   ' '                  TO NQ-GAS-WKTYPE-CD           
           END-IF                                                       
                                                                        
              MOVE   'E'                  TO WS-CODE-UTIL-TYPE          
              PERFORM 7050-SELECT-SO-INST-DATA THRU 7050-EXIT.          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN           
                  MOVE   VI-WORK-TYPE-CD      TO NQ-ELEC-WKTYPE-CD      
               ELSE                                                     
                  MOVE   ' '                  TO NQ-ELEC-WKTYPE-CD      
              END-IF                                                    
                                                                        
              MOVE  VO-ORDER-TYPE-CD        TO  NQ-ORDER-TYPE-CD        
              MOVE VO-COMPANY-NO            TO  NQ-COMPANY-NO           
              PERFORM 7500-GET-NDO-MSG-ID        THRU 7500-EXIT.        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-SO-DATA-IVR-CURSOR                                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7000-OPEN-SO-DATA-IVR-CURSOR.                                    
                                                                        
           MOVE '7000'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                OPEN SO-DATA-IVR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7000-OPEN-SO-DATA-IVR-CURSOR      **'   
                   DISPLAY '**  ERROR OPENING  SO-DATA-IVR CURSOR **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-FETCH-SO-DATA-IVR-CURSOR                                  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7010-FETCH-SO-DATA-IVR-CURSOR.                                   
                                                                        
           MOVE '7010'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH SO-DATA-IVR                                         
               INTO :VO-SERV-ORDER-NO                                   
                   ,:VO-PREMISE-NO                                      
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-PHONE-NO                                        
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-CODES-DATA-PRESENT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7010-FETCH-SO-DATA-IVR-CURSOR    **'    
                   DISPLAY '**  ERROR FETCHING SO-DATA-IVR CURSOR**'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  ORDER   = ' VO-SERV-ORDER-NO            
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CLOSE-SO-DATA-IVR-CURSOR                                  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7020-CLOSE-SO-DATA-IVR-CURSOR.                                   
                                                                        
           MOVE '7020'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                CLOSE SO-DATA-IVR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7020-CLOSE-SO-DATA-IVR-CURSOR    **'    
                   DISPLAY '**  ERROR CLOSING SO-DATA-IVR CURSOR  **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-NDO-MSG-ID                                            *        
      * GETS THE APPROPRIATE NDO_MSG_ID FROM CSS_NDO_IVR_CALL          *        
      *                                                                *        
      ******************************************************************        
       7500-GET-NDO-MSG-ID.                                             
                                                                        
             MOVE   '7500'       TO WS-ACTIVE-PARAGRAPH                 
                                                                        
             EXEC SQL                                                   
               SELECT NDO_MSG_ID                                        
                INTO :NQ-NDO-MSG-ID                                     
               FROM CSS_NDO_IVR_CALL NQ WITH(READUNCOMMITTED)                   
                WHERE ORDER_TYPE_CD = :NQ-ORDER-TYPE-CD                 
                   AND ELEC_WKTYPE_CD = :NQ-ELEC-WKTYPE-CD              
                   AND GAS_WKTYPE_CD  = :NQ-GAS-WKTYPE-CD               
                   AND COMPANY_NO     = :NQ-COMPANY-NO                  
                   AND NDO_IVR_FL     = 'Y'                             
                   AND CODE_STATUS_REAS = ''                            
                                                                 
                                                            
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*        SELECT NDO_MSG_ID                                                
MFA-TR*         INTO :NQ-NDO-MSG-ID                                             
MFA-TR*        FROM CSS_NDO_IVR_CALL NQ                                         
MFA-TR*         WHERE ORDER_TYPE_CD = :NQ-ORDER-TYPE-CD                         
MFA-TR*            AND ELEC_WKTYPE_CD = :NQ-ELEC-WKTYPE-CD                      
MFA-TR*            AND GAS_WKTYPE_CD  = :NQ-GAS-WKTYPE-CD                       
MFA-TR*            AND COMPANY_NO     = :NQ-COMPANY-NO                          
MFA-TR*            AND NDO_IVR_FL     = 'Y'                                     
MFA-TR*            AND CODE_STATUS_REAS = ''                                    
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             MOVE NQ-NDO-MSG-ID       TO  NL-NDO-MSG-ID                 
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7500-GET-NDO-MSG-ID            **'      
                   DISPLAY '**  ERROR SELECTING FROM CSS_NDO_IVR_CALL**'
                   DISPLAY '**  SERV ORDER  = ' WS-SERV-ORDER-NO        
                   DISPLAY '**  ELEC-WKTYPE = ' NQ-ELEC-WKTYPE-CD       
                   DISPLAY '**  GAS-WKTYPE  = ' NQ-GAS-WKTYPE-CD        
                   DISPLAY '**  TOTAL ORDERS= ' WS-ROW-COUNT            
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-UPDATE-CDP-SODATA                                         *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       8300-UPDATE-CDP-SODATA.                                          
                                                                        
           MOVE '8300'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT       
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                            
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT               
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         QUERYNO 8300                                                    
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  8300-UPDATE-CDP-SODATA         **'      
                   DISPLAY '**  ERROR UPDATING CSS_SO_DATA        **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-SELECT-SO-INST-DATA.                                 *             
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7050-SELECT-SO-INST-DATA.                                        
                                                                        
           MOVE '7050'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) WORK_TYPE_CD                                      
                  INTO :VI-WORK-TYPE-CD                                 
               FROM CSS_SO_ORDER_INST VI                                
                WHERE VI.SERV_ORDER_NO = :WS-SERV-ORDER-NO              
                  AND VI.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE            
                  AND VI.WORK_TYPE_CD <> ''                             
                                                  
                                                            
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_TYPE_CD                                              
MFA-TR*           INTO :VI-WORK-TYPE-CD                                         
MFA-TR*        FROM CSS_SO_ORDER_INST VI                                        
MFA-TR*         WHERE VI.SERV_ORDER_NO = :WS-SERV-ORDER-NO                      
MFA-TR*           AND VI.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND VI.WORK_TYPE_CD <> ''                                     
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*          QUERYNO 7050                                                   
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                   CONTINUE                                             
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  7050-SELECT-SO-INST-DATA-CURSOR    **'  
                   DISPLAY '**  ERROR SELECTING SO-INST-DATA CURSOR**'  
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-CALL-LIST                                          *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       8200-INSERT-CALL-LIST.                                           
                                                                        
           MOVE '8200'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_SO_NDO_CALL_LIST                        
                  (SERV_ORDER_NO                                        
                  ,ASSIGNED_DATETIME                                    
                  ,ACCOUNT_NO                                           
                  ,COMPANY_NO                                           
                  ,CALL_PRIORITY_CD                                     
                  ,PHONE_NO                                             
                  ,CALL_STATUS_CD                                       
                  ,CALL_RESULT_CD                                       
                  ,NDO_MSG_ID                                           
                  ,LAST_CALL_TS                                         
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                  ,CALL_COUNT)                                          
             VALUES                                                     
                 (:NL-SERV-ORDER-NO                                     
                 ,CIS.CHAR2TIMESTAMP(:NL-ASSIGNED-DATETIME)                     
                 ,:NL-ACCOUNT-NO                                        
                 ,:NL-COMPANY-NO                                        
                 ,:NL-CALL-PRIORITY-CD                                  
                 ,:NL-PHONE-NO                                          
                 ,:NL-CALL-STATUS-CD                                    
                 ,:NL-CALL-RESULT-CD                                    
                 ,:NL-NDO-MSG-ID                                        
                 ,CIS.CHAR2TIMESTAMP(:NL-LAST-CALL-TS :WS-NULL-CALL-TS)         
                 ,CIS.CHAR2TIMESTAMP(:NL-LAST-UPDATE-TS)                        
                 ,:NL-LAST-UPDATE-USERID                                
                 ,:NL-CALL-COUNT)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_SO_NDO_CALL_LIST                                
MFA-TR*           (SERV_ORDER_NO                                                
MFA-TR*           ,ASSIGNED_DATETIME                                            
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CALL_PRIORITY_CD                                             
MFA-TR*           ,PHONE_NO                                                     
MFA-TR*           ,CALL_STATUS_CD                                               
MFA-TR*           ,CALL_RESULT_CD                                               
MFA-TR*           ,NDO_MSG_ID                                                   
MFA-TR*           ,LAST_CALL_TS                                                 
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,CALL_COUNT)                                                  
MFA-TR*      VALUES                                                             
MFA-TR*          (:NL-SERV-ORDER-NO                                             
MFA-TR*          ,:NL-ASSIGNED-DATETIME                                         
MFA-TR*          ,:NL-ACCOUNT-NO                                                
MFA-TR*          ,:NL-COMPANY-NO                                                
MFA-TR*          ,:NL-CALL-PRIORITY-CD                                          
MFA-TR*          ,:NL-PHONE-NO                                                  
MFA-TR*          ,:NL-CALL-STATUS-CD                                            
MFA-TR*          ,:NL-CALL-RESULT-CD                                            
MFA-TR*          ,:NL-NDO-MSG-ID                                                
MFA-TR*          ,:NL-LAST-CALL-TS:WS-NULL-CALL-TS                              
MFA-TR*          ,:NL-LAST-UPDATE-TS                                            
MFA-TR*          ,:NL-LAST-UPDATE-USERID                                        
MFA-TR*          ,:NL-CALL-COUNT)                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                   ADD   1    TO    WS-ROW-COUNT                        
                   ADD   1    TO    WS-COMMIT-COUNT                     
           ELSE                                                         
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  8200-INSERT-CALL-LIST            **'    
                   DISPLAY '**  ERROR INSERTING INTO NDO_CALL_LIST*'    
                   DISPLAY '**  ACCT    = ' NL-ACCOUNT-NO               
                   DISPLAY '**  ORDER   = ' NL-SERV-ORDER-NO            
                   DISPLAY '**  ASSIG   = ' NL-ASSIGNED-DATETIME        
                   DISPLAY '**  COMPA   = ' NL-COMPANY-NO               
                   DISPLAY '**  PRIOR   = ' NL-CALL-PRIORITY-CD         
                   DISPLAY '**  PHONE   = ' NL-PHONE-NO                 
                   DISPLAY '**  STATS   = ' NL-CALL-STATUS-CD           
                   DISPLAY '**  RESUL   = ' NL-CALL-RESULT-CD           
                   DISPLAY '**  MSGID   = ' NL-NDO-MSG-ID               
                   DISPLAY '**  CALTS   = ' NL-LAST-CALL-TS             
                   DISPLAY '**  UPDTS   = ' NL-LAST-UPDATE-TS           
                   DISPLAY '**  USER    = ' NL-LAST-UPDATE-USERID       
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-IF.                                                      
                                                                        
        8200-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900-ABEND.                                                    *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSSO116 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
                                                                        
